/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.LosEffects;

public class Sensor
implements Serializable {
    private static final long serialVersionUID = 6838624193286089782L;
    private int type;
    public static final int TYPE_MEK_RADAR = 0;
    public static final int TYPE_VEE_RADAR = 1;
    public static final int TYPE_BAP = 2;
    public static final int TYPE_CLAN_BAP = 3;
    public static final int TYPE_BLOODHOUND = 4;
    public static final int TYPE_WATCHDOG = 5;
    public static final int TYPE_LIGHT_AP = 6;
    public static final int TYPE_MEK_IR = 7;
    public static final int TYPE_VEE_IR = 8;
    public static final int TYPE_MEK_MAGSCAN = 9;
    public static final int TYPE_VEE_MAGSCAN = 10;
    public static final int TYPE_BA_HEAT = 11;
    public static final int TYPE_BA_IMPROVED = 12;
    public static final int TYPE_MEK_SEISMIC = 13;
    public static final int TYPE_VEE_SEISMIC = 14;
    public static final String WATCHDOG = "WatchdogECMSuite";
    public static final String BAP = "BeagleActiveProbe";
    public static final String CLAN_AP = "CLActiveProbe";
    public static final String BLOODHOUND = "BloodhoundActiveProbe";
    public static final String LIGHT_AP = "CLLightActiveProbe";
    public static final String ISIMPROVED = "ISImprovedSensors";
    public static final String CLIMPROVED = "CLImprovedSensors";
    public static final String CLBALIGHT_AP = "CLBALightActiveProbe";
    public static final String ISBALIGHT_AP = "ISBALightActiveProbe";
    private static String[] sensorNames = new String[]{"Mech Radar", "Vehicle Radar", "Beagle Active Probe", "Clan BAP", "Bloodhound AP", "Watchdog", "Light AP", "Mech IR", "Vehicle IR", "Mech Magscan", "Vehicle Magscan", "Heat Sensors", "Improved Sensors", "Mech Seismic", "Vehicle Seismic"};
    public static final int SIZE = sensorNames.length;

    public static String getSensorName(int n) {
        if (n >= 0 && n < SIZE) {
            return sensorNames[n];
        }
        throw new IllegalArgumentException("Unknown sensor type");
    }

    public Sensor(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public boolean isBAP() {
        return this.type == 2 || this.type == 4 || this.type == 3 || this.type == 5 || this.type == 6;
    }

    public int getRangeByBracket() {
        switch (this.type) {
            case 2: {
                return 12;
            }
            case 4: {
                return 16;
            }
            case 3: {
                return 15;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                return 9;
            }
            case 7: 
            case 9: {
                return 10;
            }
            case 0: {
                return 8;
            }
            case 1: 
            case 12: {
                return 6;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 1;
            }
        }
        return 0;
    }

    public int adjustRange(int n, IGame iGame, LosEffects losEffects) {
        if ((this.type == 0 || this.type == 1 || this.type == 10 || this.type == 9) && losEffects.getHardBuildings() + losEffects.getSoftBuildings() > 0) {
            return 0;
        }
        if (this.type != 13 && this.type != 14 && this.type != 9 && this.type != 10 && !this.isBAP() && losEffects.isBlockedByHill()) {
            return 0;
        }
        if (this.type != 13 && this.type != 14 && iGame.getPlanetaryConditions().hasEMI()) {
            n -= 4;
        }
        if (this.type == 0 || this.type == 1 || this.type == 8 || this.type == 7 || this.type == 11) {
            n -= losEffects.getHeavyWoods() + losEffects.getSoftBuildings();
            n -= 2 * (losEffects.getUltraWoods() + losEffects.getHardBuildings());
        }
        if (this.type == 7 || this.type == 8) {
            n -= iGame.getPlanetaryConditions().getTemperatureDifference(50, -30);
        }
        return n;
    }

    public int getModsForStealth(Entity entity) {
        int n = 0;
        if (this.type == 13 || this.type == 14 || this.type == 8 || this.type == 7 || this.type == 11 || this.type == 9 || this.type == 10) {
            return n;
        }
        switch (this.type) {
            case 2: 
            case 5: {
                if (entity.isVoidSigActive()) {
                    n += 6;
                }
                if (entity.isNullSigActive()) {
                    n += 5;
                }
                if (!entity.isStealthActive() || entity.isNullSigActive()) break;
                n += 3;
                break;
            }
            case 3: {
                if (entity.isVoidSigActive()) {
                    n += 5;
                }
                if (entity.isNullSigActive()) {
                    n += 5;
                }
                if (!entity.isStealthActive() || entity.isNullSigActive()) break;
                n += 3;
                break;
            }
            case 4: {
                if (entity.isChameleonShieldActive()) {
                    ++n;
                }
                if (entity.isVoidSigActive()) {
                    n += 4;
                }
                if (entity.isNullSigActive()) {
                    n += 3;
                }
                if (entity.isStealthActive() && !entity.isNullSigActive()) {
                    ++n;
                }
                if (!entity.hasWorkingMisc(0x800000000000L, -1L)) break;
                ++n;
                break;
            }
            case 6: {
                if (entity.isVoidSigActive()) {
                    n += 6;
                }
                if (entity.isNullSigActive()) {
                    n += 6;
                }
                if (!entity.isStealthActive() || entity.isNullSigActive()) break;
                n += 4;
                break;
            }
            case 0: {
                if (entity.isChameleonShieldActive()) {
                    n += 2;
                }
                if (entity.isVoidSigActive()) {
                    n += 7;
                }
                if (entity.isNullSigActive()) {
                    n += 6;
                }
                if (entity.isStealthActive() && !entity.isNullSigActive()) {
                    n += 4;
                }
                if (!entity.hasWorkingMisc(0x800000000000L, -1L)) break;
                n += 2;
                break;
            }
            case 1: 
            case 12: {
                if (entity.isChameleonShieldActive()) {
                    n += 3;
                }
                if (entity.isVoidSigActive()) {
                    n += 7;
                }
                if (entity.isNullSigActive()) {
                    n += 7;
                }
                if (entity.isStealthActive() && !entity.isNullSigActive()) {
                    n += 5;
                }
                if (!entity.hasWorkingMisc(0x800000000000L, -1L)) break;
                n += 3;
            }
        }
        return n;
    }

    public int getModForECM(Entity entity) {
        double d = Math.max(0.0, Compute.getECMFieldSize(entity, entity.getPosition(), entity.getPosition()));
        double d2 = Math.max(0.0, Compute.getAngelECMFieldSize(entity, entity.getPosition(), entity.getPosition()));
        switch (this.type) {
            case 2: 
            case 3: 
            case 5: {
                return (int)Math.floor(d * 4.0 + d2 * 5.0);
            }
            case 4: {
                return (int)Math.floor(d * 2.0 + d2 * 3.0);
            }
            case 0: 
            case 6: {
                return (int)Math.floor(d * 5.0 + d2 * 6.0);
            }
            case 1: 
            case 12: {
                return (int)Math.floor(d * 6.0 + d2 * 7.0);
            }
        }
        return 0;
    }

    public int entityAdjustments(int n, Entity entity, IGame iGame) {
        if (!(this.type != 13 && this.type != 14 || entity.mpUsed != 0 && entity.getElevation() <= 0)) {
            return 0;
        }
        if (this.type == 7 || this.type == 8) {
            if (entity.heat < 1) {
                return 0;
            }
            n += entity.heat / 5;
            if (null != iGame.getBoard().getHex(entity.getPosition()) && iGame.getBoard().getHex(entity.getPosition()).containsTerrain(19)) {
                ++n;
            }
        }
        if (this.type == 9 || this.type == 10) {
            if (entity.getWeight() > 1000.0f) {
                n += 3;
            } else if (entity.getWeight() > 100.0f) {
                n += 2;
            } else if (entity.getWeight() >= 80.0f) {
                ++n;
            } else if (entity.getWeight() < 20.0f) {
                n = 0;
            }
            if (null != iGame.getBoard().getHex(entity.getPosition()) && iGame.getBoard().getHex(entity.getPosition()).containsTerrain(10)) {
                return 0;
            }
        }
        return n;
    }
}

