/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroBombHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -2995118961278208244L;

    public MicroBombHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        Coords coords = this.target.getPosition();
        if (!bl) {
            this.r = new Report(3190);
            this.r.subject = this.subjectId;
            this.r.add(coords.getBoardNum());
            vector.add(this.r);
        } else {
            coords = Compute.scatterDiveBombs(coords);
            if (this.game.getBoard().contains(coords)) {
                this.r = new Report(3195);
                this.r.subject = this.subjectId;
                this.r.add(coords.getBoardNum());
                vector.add(this.r);
            } else {
                this.r = new Report(3200);
                this.r.subject = this.subjectId;
                vector.add(this.r);
                return !bl;
            }
        }
        Infantry infantry = (Infantry)this.ae;
        int n = infantry.getShootingStrength();
        this.server.artilleryDamageArea(coords, this.ae.getPosition(), (AmmoType)this.ammo.getType(), this.subjectId, this.ae, n * 2, n, false, 0, vector);
        return true;
    }
}

