/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import java.util.List;

public class Quoting {
    public static final String DQ = "\"";
    public static final String Q = "'";
    public static final String DDQ = "\"\"";

    public static String joinStringQuoted(List<String> commandString) {
        if (null == commandString) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : commandString) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (Quoting.needsQuoting(s)) {
                Quoting.quoteString(sb, s);
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static boolean needsQuoting(String s) {
        return !(!s.contains(" ") && !s.contains(DQ) && !s.contains(Q) || s.startsWith(Q) && s.endsWith(Q) || s.startsWith(DQ) && s.endsWith(DQ));
    }

    public static StringBuilder quoteString(StringBuilder sb, String s) {
        return sb.append(DQ).append(s.replaceAll(DQ, DDQ)).append(DQ);
    }

    public static String quoteString(String s) {
        StringBuilder sb = new StringBuilder();
        return Quoting.quoteString(sb, s).toString();
    }
}

