/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import org.rundeck.client.api.model.ErrorDetail;
import org.rundeck.client.util.Client;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;

public interface ServiceClient<T>
extends Closeable {
    public static boolean hasAnyMediaType(MediaType mediaType1, MediaType ... types) {
        if (mediaType1 == null) {
            return false;
        }
        for (MediaType mediaType : types) {
            if (!mediaType1.type().equals(mediaType.type()) || !mediaType1.subtype().equals(mediaType.subtype())) continue;
            return true;
        }
        return false;
    }

    public <R> R checkError(Call<R> var1) throws IOException;

    public <R> WithErrorResponse<R> checkErrorResponse(Call<R> var1) throws IOException;

    public <R> R checkErrorDowngradable(Call<R> var1) throws IOException, Client.UnsupportedVersionDowngrade;

    public String getAppBaseUrl();

    public String getApiBaseUrl();

    public <R> R checkError(Response<R> var1) throws IOException;

    public <R> R checkError(WithErrorResponse<R> var1) throws IOException;

    public <R> WithErrorResponse<R> checkErrorResponse(Response<R> var1) throws IOException;

    public <R> R checkErrorDowngradable(Response<R> var1) throws IOException, Client.UnsupportedVersionDowngrade;

    public void reportApiError(ErrorDetail var1);

    public <X> X readError(Response<?> var1, Class<X> var2, MediaType ... var3) throws IOException;

    public <X> X readError(RepeatableResponse var1, Class<X> var2, MediaType ... var3) throws IOException;

    public <U> U apiCall(Function<T, Call<U>> var1) throws IOException;

    public <U> WithErrorResponse<U> apiWithErrorResponse(Function<T, Call<U>> var1) throws IOException;

    public <U> U apiCallDowngradable(Function<T, Call<U>> var1) throws IOException, Client.UnsupportedVersionDowngrade;

    public <U> WithErrorResponse<U> apiWithErrorResponseDowngradable(Function<T, Call<U>> var1) throws IOException, Client.UnsupportedVersionDowngrade;

    public T getService();

    public Retrofit getRetrofit();

    public int getApiVersion();

    default public boolean minApiVersion(int minimum) {
        return this.getApiVersion() >= minimum;
    }

    public static interface WithErrorResponse<T> {
        public Response<T> getResponse();

        default public boolean isError400() {
            return !this.getResponse().isSuccessful() && this.getResponse().code() == 400;
        }

        public RepeatableResponse getErrorBody() throws IOException;
    }

    public static interface RepeatableResponse {
        public ResponseBody repeatBody() throws IOException;

        public MediaType contentType();
    }
}

