/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.IStoppable;

public class AsyncRunListener
implements IRunListener,
IStoppable {
    private static final Runnable STOP = new Runnable(){

        @Override
        public void run() {
            throw new IllegalStateException("should never run");
        }
    };
    private final IRunListener delegate;
    private final Thread workerThread;
    private final BlockingQueue<Runnable> events = new LinkedBlockingQueue<Runnable>();
    private volatile boolean stopped = false;

    public AsyncRunListener(String threadName, IRunListener delegate) {
        this.delegate = delegate;
        this.workerThread = new Thread(threadName){

            @Override
            public void run() {
                try {
                    while (true) {
                        Runnable event;
                        if ((event = (Runnable)AsyncRunListener.this.events.take()) == STOP) {
                            return;
                        }
                        event.run();
                    }
                }
                catch (Throwable t) {
                    AsyncRunListener.this.stopped = true;
                    t.printStackTrace();
                    return;
                }
            }
        };
    }

    public void start() {
        this.workerThread.start();
    }

    @Override
    public void stop() throws InterruptedException {
        this.addEvent(STOP);
        this.workerThread.join();
    }

    @Override
    public void beforeSpec(final SpecInfo spec) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.beforeSpec(spec);
            }
        });
    }

    @Override
    public void beforeFeature(final FeatureInfo feature) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.beforeFeature(feature);
            }
        });
    }

    @Override
    public void beforeIteration(final IterationInfo iteration) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.beforeIteration(iteration);
            }
        });
    }

    @Override
    public void afterIteration(final IterationInfo iteration) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.afterIteration(iteration);
            }
        });
    }

    @Override
    public void afterFeature(final FeatureInfo feature) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.afterFeature(feature);
            }
        });
    }

    @Override
    public void afterSpec(final SpecInfo spec) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.afterSpec(spec);
            }
        });
    }

    @Override
    public void error(final ErrorInfo error) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.error(error);
            }
        });
    }

    @Override
    public void specSkipped(final SpecInfo spec) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.specSkipped(spec);
            }
        });
    }

    @Override
    public void featureSkipped(final FeatureInfo feature) {
        this.addEvent(new Runnable(){

            @Override
            public void run() {
                AsyncRunListener.this.delegate.featureSkipped(feature);
            }
        });
    }

    protected void addEvent(Runnable event) {
        if (this.stopped) {
            return;
        }
        this.events.add(event);
    }
}

