/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Iterator;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.spockframework.runtime.ExpressionInfoConverter;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.runtime.model.TextRegion;
import org.spockframework.util.Assert;
import org.spockframework.util.TextUtil;

public class ExpressionInfoBuilder {
    private final String text;
    private final String adjustedText;
    private final TextPosition startPos;
    private final Iterable<Object> values;
    private final String[] lines;

    public ExpressionInfoBuilder(String text, TextPosition startPos, Iterable<Object> values) {
        this.text = text;
        this.startPos = startPos;
        this.values = values;
        this.adjustedText = TextUtil.repeatChar(' ', startPos.getColumnIndex()) + text;
        this.lines = this.adjustedText.split("\n");
    }

    public ExpressionInfo build() {
        SourceUnit unit = SourceUnit.create((String)"Spec expression", (String)this.adjustedText);
        unit.parse();
        unit.completePhase();
        unit.convert();
        BlockStatement blockStat = unit.getAST().getStatementBlock();
        Assert.that(blockStat != null && blockStat.getStatements().size() == 1);
        Statement stat = (Statement)blockStat.getStatements().get(0);
        Assert.that(stat instanceof ExpressionStatement);
        Expression expr = ((ExpressionStatement)stat).getExpression();
        ExpressionInfo exprInfo = (ExpressionInfo)new ExpressionInfoConverter(this.lines).convert(expr);
        Iterator<Object> iter = this.values.iterator();
        for (ExpressionInfo info : exprInfo.inPostfixOrder(false)) {
            info.setText(this.findText(info.getRegion()));
            if (!iter.hasNext()) {
                Assert.fail("Missing value for expression '%s' in condition '%s'", info.getText(), this.text);
            }
            info.setValue(iter.next());
            if (this.startPos.getLineIndex() <= 0) continue;
            info.shiftVertically(this.startPos.getLineIndex());
        }
        return exprInfo;
    }

    private String findText(TextRegion region) {
        if (region == TextRegion.NOT_AVAILABLE) {
            return ExpressionInfo.TEXT_NOT_AVAILABLE;
        }
        try {
            String text = "";
            for (int i = 0; i <= region.getEnd().getLineIndex(); ++i) {
                String line = this.lines[i];
                if (i == region.getEnd().getLineIndex()) {
                    line = line.substring(0, region.getEnd().getColumnIndex());
                }
                if (i == region.getStart().getLineIndex()) {
                    line = line.substring(region.getStart().getColumnIndex());
                }
                text = text + line;
                if (i == region.getEnd().getLineIndex()) continue;
                text = text + '\n';
            }
            return text;
        }
        catch (IndexOutOfBoundsException e) {
            return ExpressionInfo.TEXT_NOT_AVAILABLE;
        }
    }
}

