/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.spockframework.util.Assert;
import org.spockframework.util.IFunction;
import org.spockframework.util.ObjectUtil;

public abstract class CollectionUtil {
    public static <E, F> ArrayList<F> filterMap(Collection<E> collection, IFunction<? super E, ? extends F> function) {
        ArrayList<F> result = new ArrayList<F>(collection.size());
        for (E elem : collection) {
            F resultElem = function.apply(elem);
            if (resultElem == null) continue;
            result.add(resultElem);
        }
        return result;
    }

    public static Object[] copyArray(Object[] array, int from, int to) {
        Object[] result = new Object[to - from];
        System.arraycopy(array, from, result, 0, to - from);
        return result;
    }

    public static List<Object> arrayToList(Object array) {
        ArrayList<Object> result = new ArrayList<Object>();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            result.add(Array.get(array, i));
        }
        return result;
    }

    public static <T> T getFirstElement(Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        Assert.that(iterator.hasNext());
        return iterator.next();
    }

    public static <T> T getLastElement(List<T> list) {
        Assert.that(list.size() > 0);
        return list.get(list.size() - 1);
    }

    public static <T> void setLastElement(List<T> list, T elem) {
        Assert.that(list.size() > 0);
        list.set(list.size() - 1, elem);
    }

    public static <T> void addLastElement(List<T> list, T element) {
        list.add(list.size(), element);
    }

    public static <T> Iterable<T> reverse(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final ListIterator listIterator = list.listIterator(list.size());
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return listIterator.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return listIterator.previous();
                    }

                    @Override
                    public void remove() {
                        listIterator.remove();
                    }
                };
            }
        };
    }

    public static <T> Set<T> asSet(T[] values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    public static <E> List<E> listOf(E ... elements) {
        ArrayList<E> result = new ArrayList<E>(elements.length);
        result.addAll(Arrays.asList(elements));
        return result;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, K key2, V value2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        map.put(key2, value2);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, K key2, V value2, K key3, V value3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        map.put(key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, K key2, V value2, K key3, V value3, K key4, V value4) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(key, value);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        return map;
    }

    public static Map filterNullValues(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if (next.getValue() != null) continue;
            iterator.remove();
        }
        return map;
    }

    public static Map putAll(Map original, Map ... others) {
        for (Map other : others) {
            original.putAll(other);
        }
        return original;
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> ... iterables) {
        return CollectionUtil.concat(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> concat(final List<Iterable<? extends T>> iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends T> iter;
                    int pos = 0;

                    @Override
                    public boolean hasNext() {
                        while (this.pos < iterables.size()) {
                            if (this.iter == null) {
                                this.iter = ((Iterable)iterables.get(this.pos)).iterator();
                            }
                            if (this.iter.hasNext()) {
                                return true;
                            }
                            this.iter = null;
                            ++this.pos;
                        }
                        return false;
                    }

                    @Override
                    public T next() {
                        while (this.pos < iterables.size()) {
                            if (this.iter == null) {
                                this.iter = ((Iterable)iterables.get(this.pos)).iterator();
                            }
                            if (this.iter.hasNext()) {
                                return this.iter.next();
                            }
                            this.iter = null;
                            ++this.pos;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    public static boolean containsAny(Iterable<?> iterable, Object ... elements) {
        for (Object curr : iterable) {
            for (Object elem : elements) {
                if (!ObjectUtil.equals(curr, elem)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> int findIndexOf(Iterable<T> iterable, IFunction<? super T, Boolean> predicate) {
        int index = 0;
        for (T elem : iterable) {
            if (predicate.apply(elem).booleanValue()) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

