/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.validation;

import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGHyperlink;
import com.jgoodies.dialogs.basics.AbstractPane;
import com.jgoodies.dialogs.basics.BasicDialogResources;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public class ValidationPane
extends AbstractPane {
    private final ValidationResult validationResult;
    private final ValidationMessageRenderer renderer;

    public ValidationPane(ValidationResult validationResult) {
        this(validationResult, null, null);
    }

    public ValidationPane(ValidationResult validationResult, ValidationMessageRenderer renderer) {
        this(validationResult, renderer, null);
    }

    public ValidationPane(ValidationResult validationResult, ValidationMessageRenderer renderer, ResourceMap resources) {
        super(resources);
        this.validationResult = Preconditions.checkNotNull(validationResult, "The %s must not be null.", "validation result");
        this.renderer = renderer != null ? renderer : IconAndTextRenderer.getInstance();
    }

    public boolean showSaveErrorOrConfirmation(EventObject event, String optionalTitle, String optionalObjectName) {
        return this.showErrorOrConfirmation(event, optionalTitle, optionalObjectName, "save", CommandValue.SAVE_ANYWAY);
    }

    public boolean showErrorOrConfirmation(EventObject event, String optionalTitle, String optionalObjectName, String context, Object proceedCommitValue) {
        if (this.validationResult.isEmpty()) {
            return true;
        }
        TaskPane pane = this.buildErrorOrConfirmation(context, optionalObjectName, proceedCommitValue);
        pane.showDialog(event, this.getTitle(optionalTitle, "ValidationPane." + context + ".defaultTitle"));
        return !pane.isCancelled();
    }

    protected TaskPane buildErrorOrConfirmation(String context, String optionalObjectName, Object proceedCommitValue) {
        return this.buildPane(this.messageType(this.validationResult), this.mainInstruction(this.validationResult, context, optionalObjectName), this.supplementalInstruction(this.validationResult, context), this.commitValues(this.validationResult, proceedCommitValue));
    }

    protected TaskPane buildPane(MessageType messageType, String mainInstruction, String supplementalInstruction, Object ... commitButtons) {
        return ((TaskPaneBuilder)new TaskPaneBuilder().messageType(messageType).mainInstructionText(mainInstruction, new Object[0]).content(this.buildContent(supplementalInstruction)).commitCommands(commitButtons).preferredWidth(PreferredWidth.MEDIUM)).marginContentBottom(7).build();
    }

    protected String mainInstruction(ValidationResult result, String context, String optionalObjectName) {
        String contextPart = context == null ? "" : context + ".";
        String key = "ValidationPane." + contextPart + ValidationPane.keyType(result) + ".mainInstruction";
        return optionalObjectName == null ? this.getResources().getString(key, new Object[0]) : this.getResources().getString(key + ".objectName", optionalObjectName);
    }

    protected String supplementalInstruction(ValidationResult result, String context) {
        if (!result.hasErrors()) {
            return null;
        }
        String contextPart = context == null ? "" : context + ".";
        String key = "ValidationPane." + contextPart + ValidationPane.keyType(result) + ".supplementalInstruction";
        return this.getResources().getString(key, new Object[0]);
    }

    protected JComponent buildContent(String supplementalInstruction) {
        return ((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:default:grow", new Object[0])).rows("f:100dlu:g", new Object[0])).add(this.buildContent0(supplementalInstruction)).xy(1, 1)).build();
    }

    protected JComponent buildContent0(String supplementalInstruction) {
        if (supplementalInstruction == null) {
            return this.buildMessagePanel(this.validationResult);
        }
        JComponent supplementalInstructionComponent = this.createSupplementalInstructionTextComponent(supplementalInstruction);
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:default:grow", new Object[0])).rows("p, 3dlu, f:d:g", new Object[0])).add(supplementalInstructionComponent).xy(1, 1)).add(this.buildMessagePanel(this.validationResult)).xy(1, 3)).build();
    }

    protected MessageType messageType(ValidationResult result) {
        return result.hasErrors() ? MessageType.ERROR : MessageType.QUESTION;
    }

    protected Object[] commitValues(ValidationResult result, Object proceedCommitValue) {
        Object[] objectArray;
        if (result.hasErrors()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = CommandValue.CLOSE;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = proceedCommitValue;
            objectArray = objectArray3;
            objectArray3[1] = CommandValue.CANCEL;
        }
        return objectArray;
    }

    protected JComponent createSupplementalInstructionTextComponent(String text) {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        JTextComponent c = factory.createStaticText(text, new Object[0]);
        c.setMinimumSize(new Dimension(0, 0));
        return c;
    }

    protected JComponent buildMessagePanel(ValidationResult result) {
        JComponent listView = this.buildMessageList(result);
        if (result.size() <= 5) {
            return listView;
        }
        JScrollPane scrollPane = new JScrollPane(listView);
        scrollPane.setBorder(null);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }

    protected JComponent buildMessageList(ValidationResult result) {
        ValidationResult sortedResult = this.sort(result);
        int resultCount = sortedResult.size();
        FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns("fill:200dlu:grow", new Object[0])).rows("d, %s*(d)", resultCount);
        int row = 1;
        for (ValidationMessage message : sortedResult.getMessages()) {
            JComponent messageComponent = this.renderer.createMessageComponent(message, this.getResources());
            builder.add(messageComponent).xy(1, row++);
        }
        return builder.build();
    }

    protected ValidationResult sort(ValidationResult unsorted) {
        ValidationResult sorted = new ValidationResult();
        sorted.addAll(unsorted.getErrors());
        sorted.addAll(unsorted.getWarnings());
        return sorted;
    }

    private static String keyType(ValidationResult result) {
        boolean hasErrors = result.hasErrors();
        boolean hasWarnings = result.hasWarnings();
        if (hasErrors && !hasWarnings) {
            return "errors";
        }
        if (hasErrors && hasWarnings) {
            return "messages";
        }
        return "warnings";
    }

    @Override
    protected Class<?> getResourceProviderClass() {
        return BasicDialogResources.class;
    }

    public static abstract class AbstractLinkRenderer
    extends AbstractValidationMessageRenderer {
        @Override
        protected String getLayoutColumnSpecification() {
            return "pref, 2epx, left:200:grow";
        }

        @Override
        protected JComponent createTextComponent(ValidationMessage message) {
            return new JGHyperlink(new LinkActivationAction(this, message), true);
        }

        protected abstract void activate(ActionEvent var1, ValidationMessage var2);
    }

    public static abstract class AbstractValidationMessageRenderer
    implements ValidationMessageRenderer {
        @Override
        public JComponent createMessageComponent(ValidationMessage message, ResourceMap resources) {
            Preconditions.checkNotNull(message, "The %s must not be null.", "message");
            JComponent labelComponent = this.createLabelComponent(message, resources);
            JComponent textComponent = this.createTextComponent(message);
            String accessibleName = this.getAccessibleNamePrefix(message, resources) + " " + message.formattedText();
            textComponent.getAccessibleContext().setAccessibleName(accessibleName);
            return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns(this.getLayoutColumnSpecification(), new Object[0])).rows("p", new Object[0])).add(labelComponent).xy(1, 1, "fill, top")).add(textComponent).xy(3, 1)).build();
        }

        protected abstract String getLayoutColumnSpecification();

        protected abstract JComponent createTextComponent(ValidationMessage var1);

        protected JComponent createLabelComponent(ValidationMessage message, ResourceMap resources) {
            Icon icon = this.getIcon(message, resources);
            return new JLabel(icon);
        }

        protected Icon getIcon(ValidationMessage message, ResourceMap resources) {
            return resources.getIcon(message.severity() == Severity.ERROR ? "ValidationPane.error.icon" : "ValidationPane.warning.icon");
        }

        protected String getAccessibleNamePrefix(ValidationMessage message, ResourceMap resources) {
            return resources.getString(message.severity() == Severity.ERROR ? "ValidationPane.error.accessibleNamePrefix" : "ValidationPane.warning.accessibleNamePrefix", new Object[0]);
        }
    }

    public static class IconAndTextRenderer
    extends AbstractValidationMessageRenderer {
        private static IconAndTextRenderer instance;

        protected IconAndTextRenderer() {
        }

        public static IconAndTextRenderer getInstance() {
            if (instance == null) {
                instance = new IconAndTextRenderer();
            }
            return instance;
        }

        @Override
        protected String getLayoutColumnSpecification() {
            return "pref, 0px, fill:pref:grow";
        }

        @Override
        protected JComponent createTextComponent(ValidationMessage message) {
            String text = message.formattedText();
            JTextComponent area = JGComponentFactory.getCurrent().createStaticText(text, new Object[0]);
            area.setMargin(new Insets(0, 0, 0, 0));
            area.setMinimumSize(new Dimension(0, 0));
            return area;
        }
    }

    private static final class LinkActivationAction
    extends AbstractAction {
        private final AbstractLinkRenderer renderer;
        private final ValidationMessage message;

        LinkActivationAction(AbstractLinkRenderer renderer, ValidationMessage message) {
            super(message.formattedText());
            this.renderer = renderer;
            this.message = message;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.renderer.activate(e, this.message);
        }
    }

    public static interface ValidationMessageRenderer {
        public JComponent createMessageComponent(ValidationMessage var1, ResourceMap var2);
    }
}

