/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import pcgen.base.formula.Formula;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Equipment;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

public class SpellBook
implements Cloneable {
    public static final int TYPE_KNOWN_SPELLS = 1;
    public static final int TYPE_PREPARED_LIST = 2;
    public static final int TYPE_SPELL_BOOK = 3;
    public static final int TYPE_INNATE_SPELLS = 4;
    private String name;
    private int type;
    private int numPages;
    private int numPagesUsed;
    private int numSpells;
    private Formula pageFormula;
    private String description;
    private Equipment equip;

    public SpellBook(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.name);
        if (this.type == 3) {
            result.append(" [");
            result.append(this.numPagesUsed);
            result.append('/');
            result.append(this.numPages);
            result.append(']');
        }
        return result.toString();
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final Equipment getEquip() {
        return this.equip;
    }

    public final void setEquip(Equipment equip) {
        this.equip = equip;
        this.setNumPages(equip.getSafe(IntegerKey.NUM_PAGES));
        this.setPageFormula(equip.getSafe(FormulaKey.PAGE_USAGE));
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final int getNumPages() {
        return this.numPages;
    }

    public final void setNumPages(int numPages) {
        this.numPages = numPages;
    }

    public final Formula getPageFormula() {
        return this.pageFormula;
    }

    public final void setPageFormula(Formula pageFormula) {
        this.pageFormula = pageFormula;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int type) {
        this.type = type;
    }

    public final String getTypeName() {
        String retValue = "";
        switch (this.getType()) {
            case 1: {
                retValue = "Known Spell List";
                break;
            }
            case 2: {
                retValue = "Prepared Spell List";
                break;
            }
            case 3: {
                retValue = "Spell Book";
                break;
            }
            case 4: {
                retValue = "Innate Spell List";
                break;
            }
            default: {
                retValue = "Unknown spell list type: " + this.getType();
            }
        }
        return retValue;
    }

    public final int getNumPagesUsed() {
        return this.numPagesUsed;
    }

    public final void setNumPagesUsed(int numPagesUsed) {
        this.numPagesUsed = numPagesUsed;
    }

    public final int getNumSpells() {
        return this.numSpells;
    }

    public final void setNumSpells(int numSpells) {
        this.numSpells = numSpells;
    }

    public Object clone() {
        SpellBook aClone = null;
        try {
            aClone = (SpellBook)super.clone();
            if (this.equip != null) {
                aClone.equip = this.equip.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            ShowMessageDelegate.showMessageDialog("Clone of SpellBook failed due to " + e.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aClone;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpellBook) {
            SpellBook other = (SpellBook)o;
            if (this.pageFormula == null ? other.pageFormula != null : !this.pageFormula.equals(other.pageFormula)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.equip == null ? other.equip != null : !this.equip.equals(other.equip)) {
                return false;
            }
            return this.name.equals(other.name) && this.type == other.type && this.numPages == other.numPages && this.numPagesUsed == other.numPagesUsed && this.numSpells == other.numSpells;
        }
        return false;
    }
}

