/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.ArrayList;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.character.Follower;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.term.BasePCDTermEvaluator;
import pcgen.core.term.TermEvaluator;

public class PCCountFollowerTypeTransitiveTermEvaluator
extends BasePCDTermEvaluator
implements TermEvaluator {
    private final String type;
    private final int index;
    private final String newCount;

    public PCCountFollowerTypeTransitiveTermEvaluator(String originalText, String type, int index, String newCount) {
        this.originalText = originalText;
        this.type = type;
        this.index = index;
        this.newCount = newCount;
    }

    @Override
    public Float resolve(CharacterDisplay display) {
        if (display.hasFollowers()) {
            ArrayList<Follower> aList = new ArrayList<Follower>();
            for (Follower follower : display.getFollowerList()) {
                if (!follower.getType().getKeyName().equalsIgnoreCase(this.type)) continue;
                aList.add(follower);
            }
            if (this.index < aList.size()) {
                Follower follower = (Follower)aList.get(this.index);
                for (PlayerCharacter pc : Globals.getPCList()) {
                    if (!follower.getFileName().equals(pc.getFileName()) || !follower.getName().equals(pc.getName())) continue;
                    return pc.getVariableValue(this.newCount, "");
                }
            }
        }
        return Float.valueOf(0.0f);
    }

    @Override
    public boolean isSourceDependant() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }
}

