/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.freemarker.CharacterExportAction;

public class PCStringDirective
extends CharacterExportAction
implements TemplateDirectiveModel,
TemplateMethodModelEx {
    private PlayerCharacter pc;
    private ExportHandler eh;

    public PCStringDirective(PlayerCharacter pc, ExportHandler eh) {
        this.pc = pc;
        this.eh = eh;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String value;
        if (params.size() != 1 || params.get("tag") == null) {
            throw new TemplateModelException("This directive requires a single tag parameter.");
        }
        if (loopVars.length != 0) {
            throw new TemplateModelException("This directive doesn't allow loop variables.");
        }
        if (body != null) {
            throw new TemplateModelException("This directive cannot take a body.");
        }
        String tag = params.get("tag").toString();
        if (tag.equals(value = this.getExportVariable(tag, this.pc, this.eh))) {
            throw new TemplateModelException("Invalid export tag '" + tag + "'.");
        }
        env.getOut().append(value);
    }

    public Object exec(List arg0) throws TemplateModelException {
        String value;
        if (arg0.size() != 1) {
            throw new TemplateModelException("Wrong arguments. tag required");
        }
        String tag = arg0.get(0).toString();
        if (tag.equals(value = this.getExportVariable(tag, this.pc, this.eh))) {
            throw new TemplateModelException("Invalid export tag '" + tag + "'.");
        }
        return value;
    }
}

