/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.List;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.character.CharacterSpell;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.SpellListToken;

public class SpellListBookToken
extends SpellListToken {
    public static final String TOKENNAME = "SPELLLISTBOOK";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        StringBuilder retValue = new StringBuilder();
        SpellListToken.SpellListTokenParams params = new SpellListToken.SpellListTokenParams(tokenSource, 2);
        PObject aObject = pc.getSpellClassAtIndex(params.getClassNum());
        if (aObject != null) {
            String bookName = Globals.getDefaultSpellBook();
            if (params.getBookNum() > 0) {
                bookName = pc.getDisplay().getSpellBookNames().get(params.getBookNum());
            }
            List<CharacterSpell> spells = pc.getCharacterSpells(aObject, null, bookName, params.getLevel());
            boolean needcomma = false;
            for (CharacterSpell cs : spells) {
                if (needcomma) {
                    retValue.append(", ");
                }
                needcomma = true;
                retValue.append(OutputNameFormatting.getOutputName(cs.getSpell()));
            }
            if (!needcomma && eh != null && eh.getExistsOnly()) {
                eh.setNoMoreItems(true);
            }
        }
        return retValue.toString();
    }
}

