/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl.lcdui;

import java.awt.Graphics;
import org.me4se.impl.lcdui.PhysicalFont;

public class TextBlock {
    PhysicalFont font;
    int width;
    String txt;
    StringBuffer positions = new StringBuffer();

    public TextBlock(PhysicalFont font, String txt, int width) {
        this.font = font;
        this.txt = txt == null ? "" : txt;
        this.width = width;
        int pos = 0;
        int len = this.txt.length();
        while (pos < len) {
            int start = pos;
            int i = pos;
            while (true) {
                if (i < len && txt.charAt(i) > ' ') {
                    ++i;
                    continue;
                }
                int w = font.stringWidth(txt.substring(start, i));
                if (pos == start && w > width) {
                    while (font.stringWidth(txt.substring(start, --i)) > width) {
                    }
                    pos = i;
                    break;
                }
                if (w <= width) {
                    pos = i;
                }
                if (w > width || i >= len || txt.charAt(i) == '\n' || txt.charAt(i) == '\r') break;
                ++i;
            }
            this.positions.append((char)(pos >= len ? len : ++pos));
        }
    }

    public int getHeight() {
        return this.positions.length() * this.font.height;
    }

    public void paint(Graphics g, int x, int y) {
        int count = this.positions.length();
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            int cut = this.positions.charAt(i);
            this.font.drawString(g, this.txt.substring(pos, cut > 0 && this.txt.charAt(cut - '\u0001') <= ' ' ? cut - '\u0001' : cut), x, y + this.font.ascent);
            pos = cut;
            y += this.font.height;
        }
    }
}

