/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.DoubleFromCharSequenceNotationConverter;
import org.gradle.internal.typeconversion.EnumFromCharSequenceNotationParser;
import org.gradle.internal.typeconversion.IntegerFromCharSequenceNotationConverter;
import org.gradle.internal.typeconversion.JavaVersionFromCharSequenceNotationConverter;
import org.gradle.internal.typeconversion.JvmVendorSpecFromCharSequenceNotationConverter;
import org.gradle.internal.typeconversion.LongFromCharSequenceNotationConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmVendorSpec;

public class OptionValueNotationParserFactory {
    public <T> NotationParser<CharSequence, T> toComposite(Class<T> targetType) throws OptionValidationException {
        if (targetType.isAssignableFrom(String.class) || targetType.isAssignableFrom(FileSystemLocation.class)) {
            return (NotationParser)Cast.uncheckedCast((Object)new NoDescriptionValuesJustReturningParser());
        }
        if (targetType.isAssignableFrom(JavaLanguageVersion.class)) {
            JavaVersionFromCharSequenceNotationConverter converter = new JavaVersionFromCharSequenceNotationConverter();
            return (NotationParser)Cast.uncheckedCast((Object)new NotationConverterToNotationParserAdapter((NotationConverter)converter));
        }
        if (targetType.isAssignableFrom(JvmVendorSpec.class)) {
            JvmVendorSpecFromCharSequenceNotationConverter converter = new JvmVendorSpecFromCharSequenceNotationConverter();
            return (NotationParser)Cast.uncheckedCast((Object)new NotationConverterToNotationParserAdapter((NotationConverter)converter));
        }
        if (targetType.isEnum()) {
            EnumFromCharSequenceNotationParser<Enum> converter = new EnumFromCharSequenceNotationParser<Enum>(targetType.asSubclass(Enum.class));
            return new NotationConverterToNotationParserAdapter(converter);
        }
        if (targetType.isAssignableFrom(Double.class)) {
            return new NotationConverterToNotationParserAdapter((NotationConverter)Cast.uncheckedCast((Object)new DoubleFromCharSequenceNotationConverter()));
        }
        if (targetType.isAssignableFrom(Integer.class)) {
            return new NotationConverterToNotationParserAdapter((NotationConverter)Cast.uncheckedCast((Object)new IntegerFromCharSequenceNotationConverter()));
        }
        if (targetType.isAssignableFrom(Long.class)) {
            return new NotationConverterToNotationParserAdapter((NotationConverter)Cast.uncheckedCast((Object)new LongFromCharSequenceNotationConverter()));
        }
        throw new OptionValidationException(String.format("Don't know how to convert strings to type '%s'.", targetType.getName()));
    }

    private static class NoDescriptionValuesJustReturningParser
    implements NotationParser<CharSequence, String> {
        private NoDescriptionValuesJustReturningParser() {
        }

        public String parseNotation(CharSequence notation) {
            return notation.toString();
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of String or CharSequence.");
        }
    }
}

