/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit.swingui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.antlr.gunit.swingui.model.ITestCaseInput;
import org.antlr.gunit.swingui.model.ITestCaseOutput;
import org.antlr.gunit.swingui.model.Rule;
import org.antlr.gunit.swingui.model.TestCase;
import org.antlr.gunit.swingui.model.TestCaseInputFile;
import org.antlr.gunit.swingui.model.TestCaseInputMultiString;
import org.antlr.gunit.swingui.model.TestCaseInputString;
import org.antlr.gunit.swingui.model.TestCaseOutputAST;
import org.antlr.gunit.swingui.model.TestCaseOutputResult;
import org.antlr.gunit.swingui.model.TestCaseOutputReturn;
import org.antlr.gunit.swingui.model.TestCaseOutputStdOut;
import org.antlr.gunit.swingui.model.TestSuite;
import org.antlr.gunit.swingui.parsers.ANTLRv3Lexer;
import org.antlr.gunit.swingui.parsers.ANTLRv3Parser;
import org.antlr.gunit.swingui.parsers.StGUnitLexer;
import org.antlr.gunit.swingui.parsers.StGUnitParser;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator {
    private static String TEMPLATE_FILE = "gunit.stg";
    private static StringTemplateGroup templates;

    public static String toScript(TestSuite testSuite) {
        if (testSuite == null) {
            return "";
        }
        StringTemplate gUnitScript = templates.getInstanceOf("gUnitFile");
        gUnitScript.setAttribute("testSuite", testSuite);
        return gUnitScript.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestSuite toTestSuite(File file, List ruleList) {
        TestSuite result = new TestSuite();
        try {
            block6: {
                TestSuiteAdapter adapter;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StGUnitLexer lexer = new StGUnitLexer(new ANTLRReaderStream(reader));
                CommonTokenStream tokens = new CommonTokenStream(lexer);
                StGUnitParser parser = new StGUnitParser(tokens);
                parser.adapter = adapter = new TestSuiteAdapter(result);
                parser.gUnitDef();
                result.setTokens(tokens);
                ((Reader)reader).close();
                String sGrammarFile = file.getParentFile().getAbsolutePath() + File.separator + result.getGrammarName() + ".g";
                File fileGrammar = new File(sGrammarFile);
                if (!fileGrammar.exists()) break block6;
                if (!fileGrammar.isFile()) break;
                List<Rule> completeRuleList = Translator.loadRulesFromGrammar(fileGrammar);
                for (Rule rule : completeRuleList) {
                    if (result.hasRule(rule)) continue;
                    result.addRule(rule);
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            return result;
        }
    }

    public static List<Rule> loadRulesFromGrammar(File grammarFile) {
        ArrayList<String> ruleNames = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(grammarFile));
            ANTLRv3Lexer lexer = new ANTLRv3Lexer(new ANTLRReaderStream(reader));
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            ANTLRv3Parser parser = new ANTLRv3Parser(tokens);
            parser.rules = ruleNames;
            parser.grammarDef();
            ((Reader)reader).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        for (String str : ruleNames) {
            ruleList.add(new Rule(str));
        }
        return ruleList;
    }

    static {
        InputStream in = Translator.class.getResourceAsStream(TEMPLATE_FILE);
        InputStreamReader rd = new InputStreamReader(in);
        templates = new StringTemplateGroup(rd);
    }

    public static class TestSuiteAdapter {
        private TestSuite model;
        private Rule currentRule;

        public TestSuiteAdapter(TestSuite testSuite) {
            this.model = testSuite;
        }

        public void setGrammarName(String name) {
            this.model.setGrammarName(name);
        }

        public void startRule(String name) {
            this.currentRule = new Rule(name);
        }

        public void endRule() {
            this.model.addRule(this.currentRule);
            this.currentRule = null;
        }

        public void addTestCase(ITestCaseInput in, ITestCaseOutput out) {
            TestCase testCase = new TestCase(in, out);
            this.currentRule.addTestCase(testCase);
        }

        private static String trimChars(String text, int numOfChars) {
            return text.substring(numOfChars, text.length() - numOfChars);
        }

        public static ITestCaseInput createFileInput(String fileName) {
            if (fileName == null) {
                throw new IllegalArgumentException("null");
            }
            return new TestCaseInputFile(fileName);
        }

        public static ITestCaseInput createStringInput(String line) {
            if (line == null) {
                throw new IllegalArgumentException("null");
            }
            return new TestCaseInputString(TestSuiteAdapter.trimChars(line, 1));
        }

        public static ITestCaseInput createMultiInput(String text) {
            if (text == null) {
                throw new IllegalArgumentException("null");
            }
            return new TestCaseInputMultiString(TestSuiteAdapter.trimChars(text, 2));
        }

        public static ITestCaseOutput createBoolOutput(boolean bool) {
            return new TestCaseOutputResult(bool);
        }

        public static ITestCaseOutput createAstOutput(String ast) {
            if (ast == null) {
                throw new IllegalArgumentException("null");
            }
            return new TestCaseOutputAST(ast);
        }

        public static ITestCaseOutput createStdOutput(String text) {
            if (text == null) {
                throw new IllegalArgumentException("null");
            }
            return new TestCaseOutputStdOut(TestSuiteAdapter.trimChars(text, 1));
        }

        public static ITestCaseOutput createReturnOutput(String text) {
            if (text == null) {
                throw new IllegalArgumentException("null");
            }
            return new TestCaseOutputReturn(TestSuiteAdapter.trimChars(text, 1));
        }
    }
}

