/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.util.ManifestLoader;
import java.util.List;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin {
    private final String pathToJar;
    private final String moduleName;
    private final String name;
    private final List<String> args;

    public Plugin(String name, String pathToJar, String moduleName, List<String> args) {
        this.name = name;
        this.pathToJar = pathToJar;
        this.moduleName = moduleName;
        this.args = args;
    }

    public String getName(ManifestLoader manifestLoader) {
        if (this.name == null) {
            try {
                Manifest manifest = manifestLoader.load(this.pathToJar);
                return manifest.getAttributes("jstd").getValue("plugin-name");
            }
            catch (ManifestLoader.ManifestNotFound e) {
                throw new RuntimeException(e);
            }
        }
        return this.name;
    }

    public String getPathToJar() {
        return this.pathToJar;
    }

    public String getModuleName(ManifestLoader manifestLoader) {
        if (this.moduleName == null) {
            try {
                Manifest manifest = manifestLoader.load(this.pathToJar);
                return manifest.getAttributes("jstd").getValue("plugin-module");
            }
            catch (ManifestLoader.ManifestNotFound e) {
                throw new RuntimeException(e);
            }
        }
        return this.moduleName;
    }

    public String getInitializerName(ManifestLoader manifestLoader) {
        try {
            Manifest manifest = manifestLoader.load(this.pathToJar);
            return manifest.getAttributes("jstd").getValue("plugin-initializer");
        }
        catch (ManifestLoader.ManifestNotFound e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pathToJar == null ? 0 : this.pathToJar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Plugin other = (Plugin)obj;
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.pathToJar == null ? other.pathToJar != null : !this.pathToJar.equals(other.pathToJar));
    }

    public String toString() {
        return "Plugin [moduleName=" + this.moduleName + ", name=" + this.name + ", pathToJar=" + this.pathToJar + ", args=" + this.args + "]";
    }

    public Plugin getPluginFromPath(String resolvedPath) {
        return new Plugin(this.name, resolvedPath, this.moduleName, this.args);
    }
}

