/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import net.coobird.thumbnailator.ThumbnailParameter;
import net.coobird.thumbnailator.tasks.io.ImageSink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImageSink<T>
implements ImageSink<T> {
    protected String outputFormat;
    protected ThumbnailParameter param;

    protected AbstractImageSink() {
    }

    @Override
    public void setOutputFormatName(String format) {
        this.outputFormat = format;
    }

    @Override
    public void setThumbnailParameter(ThumbnailParameter param) {
        this.param = param;
    }

    @Override
    public void write(BufferedImage img) throws IOException {
        if (img == null) {
            throw new NullPointerException("Cannot write a null image.");
        }
        if ("\u0000".equals(this.outputFormat)) {
            this.outputFormat = this.preferredOutputFormatName();
        }
    }

    @Override
    public String preferredOutputFormatName() {
        return ThumbnailParameter.ORIGINAL_FORMAT;
    }
}

