/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.PrefUtils;

public class AutoBackupIndicatorToolControl
implements IPropertyChangeListener,
Listener {
    private static final int DISABLED = 1;
    private static final int ENABLED = 2;
    private IPreferenceStore ps = CathyPlugin.getDefault().getPreferenceStore();
    private Control control;
    private Label label;
    private MenuManager menu;

    @Inject
    public AutoBackupIndicatorToolControl() {
    }

    @PostConstruct
    public void createGui(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 4;
        composite.setLayout((Layout)layout);
        this.label = new Label(composite, 0x1000000);
        this.label.setText(WorkbenchMessages.AutoBackupIndicator_AutoSaveDisabled_label);
        this.label.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)(Util.isMac() ? -2 : -1)));
        this.label.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.label.setCursor(this.label.getDisplay().getSystemCursor(21));
        this.label.addListener(3, (Listener)this);
        this.menu = new MenuManager();
        this.menu.add((IAction)new ChangeAutoSavePrefAction(this.ps, WorkbenchMessages.AutoBackupIndicator_DisableAutoSaveAction_text, 1));
        this.menu.add((IAction)new ChangeAutoSavePrefAction(this.ps, WorkbenchMessages.AutoBackupIndicator_EnableAutoSaveAction_text, 2));
        this.menu.add((IContributionItem)new Separator());
        this.menu.add((IAction)new OpenPreferencePageAction());
        this.menu.createContextMenu((Control)this.label);
        this.label.setMenu(this.menu.getMenu());
        this.updateEnablement();
        this.ps.removePropertyChangeListener((IPropertyChangeListener)this);
        this.ps.addPropertyChangeListener((IPropertyChangeListener)this);
        this.control = composite;
    }

    private void updateEnablement() {
        int value = this.getValue();
        if (value == 2) {
            this.label.setText(WorkbenchMessages.AutoBackupIndicator_AutoSaveEnabled_label);
            int intervals = this.ps.getInt("autoSaveIntervals");
            this.label.setToolTipText(NLS.bind((String)WorkbenchMessages.AutoSave_label2, (Object)intervals));
        } else {
            this.label.setText(WorkbenchMessages.AutoBackupIndicator_AutoSaveDisabled_label);
            this.label.setToolTipText(WorkbenchMessages.AutoBackupIndicator_AutoSaveDisabled_description);
        }
        if (this.menu != null) {
            IContributionItem[] iContributionItemArray = this.menu.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof ChangeAutoSavePrefAction) {
                    action.setChecked(((ChangeAutoSavePrefAction)action).getValue() == value);
                }
                ++n2;
            }
        }
    }

    private int getValue() {
        return this.ps.getBoolean("autoSaveEnabled") ? 2 : 1;
    }

    public void propertyChange(final PropertyChangeEvent event) {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        this.control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AutoBackupIndicatorToolControl.this.update(event.getProperty());
            }
        });
    }

    public void update(String id) {
        if (this.label == null || this.label.isDisposed() || this.ps == null) {
            return;
        }
        if (id == null || "autoSaveEnabled".equals(id)) {
            this.updateEnablement();
        }
    }

    public void handleEvent(final Event event) {
        if (event.widget == this.label && event.button == 1) {
            event.display.timerExec(10, new Runnable(){

                @Override
                public void run() {
                    Point loc = AutoBackupIndicatorToolControl.this.label.getParent().toDisplay(event.x, event.y);
                    AutoBackupIndicatorToolControl.this.updateEnablement();
                    AutoBackupIndicatorToolControl.this.menu.getMenu().setLocation(loc);
                    AutoBackupIndicatorToolControl.this.menu.getMenu().setVisible(true);
                }
            });
        }
    }

    private void changeStatus(int value) {
        this.ps.setValue("autoSaveEnabled", value == 2);
    }

    @PreDestroy
    private void dispose() {
        if (this.label != null) {
            this.label.dispose();
            this.label = null;
        }
        this.control = null;
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (this.ps != null) {
            this.ps.removePropertyChangeListener((IPropertyChangeListener)this);
            this.ps = null;
        }
    }

    private class ChangeAutoSavePrefAction
    extends Action {
        private IPreferenceStore ps;
        private int value;

        public ChangeAutoSavePrefAction(IPreferenceStore ps, String text, int value) {
            super(text);
            this.ps = ps;
            this.value = value;
        }

        public void run() {
            if (this.ps == null) {
                return;
            }
            AutoBackupIndicatorToolControl.this.changeStatus(this.value);
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class OpenPreferencePageAction
    extends Action {
        public OpenPreferencePageAction() {
            super(WorkbenchMessages.AutoBackupIndicator_OpenPreferenceAction_text);
        }

        public void run() {
            PrefUtils.openPrefDialog(null, (String)"org.xmind.ui.prefPage.General");
        }
    }
}

