/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ITopic;
import org.xmind.gef.GEF;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.draw2d.ChopBoxAnchor;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.gefext.AbstractDragTracker;
import org.xmind.ui.gantt2.gefext.HandleFigure;
import org.xmind.ui.gantt2.gefext.IEditPart;
import org.xmind.ui.gantt2.gefext.IPathShape;
import org.xmind.ui.gantt2.gefext.ITracker;
import org.xmind.ui.gantt2.gefext.PathDescriptor;
import org.xmind.ui.gantt2.gefext.SelectionFeedback;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.DependencyFigure;
import org.xmind.ui.gantt2.viewer.TaskBarPart;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.mindmap.IConnectionPart;

public class DependencyAnchorsFeedback
extends SelectionFeedback {
    private static final int SOURCE = 1;
    private static final int TARGET = 2;
    private static final int R = 5;
    private static final String LOCATION = "location";
    private static final String ANCHOR = "anchor";
    private static final String CHANGING_SOURCE = "changingSource";
    private static final String DUMMY_TARGET = "dummyTarget";
    private static final String DUMMY_ANCHOR = "dummyAnchor";
    private static final String TARGET_PART = "targetPart";
    private static final String ORIENTATION = "orientation";
    private static final String SEARCH_CONDITION = "searchCondition";
    private static final String LINE_COLOR = "lineColor";
    private static final String LINE_WIDTH = "lineWidth";
    private static final String LINE_ALPHA = "lineAlpha";
    private static final String REQUEST = "request";
    private AnchorFigure sourceHandle;
    private AnchorFigure targetHandle;
    private ITracker moveTracker;

    public void activate() {
        super.activate();
        this.sourceHandle = new AnchorFigure(this.getHost().getFigure(), 1);
        this.registerHandle((IFigure)this.sourceHandle, GEF.LAYER_HANDLE);
        this.targetHandle = new AnchorFigure(this.getHost().getFigure(), 2);
        this.registerHandle((IFigure)this.targetHandle, GEF.LAYER_HANDLE);
    }

    protected void onPreselected() {
        super.onPreselected();
        this.updateHandles();
    }

    protected void onDepreselected() {
        this.updateHandles();
        super.onDepreselected();
    }

    private boolean isMainFigureAvailable() {
        return this.getHost().getFigure().isVisible();
    }

    private void updateHandles() {
        if (this.getHost().getStatus().isPreSelected() && this.isMainFigureAvailable()) {
            this.activateHandles(new IFigure[]{this.sourceHandle, this.targetHandle});
        } else {
            this.deactivateHandles(new IFigure[]{this.sourceHandle, this.targetHandle});
        }
    }

    public boolean containsPoint(Point point) {
        return super.containsPoint(point) || this.isMainFigureAvailable() && this.isOverHandle(point, new IFigure[]{this.sourceHandle, this.targetHandle});
    }

    public void update(Object property) {
        super.update(property);
        this.updateHandles();
    }

    public Cursor findCursor(Point point) {
        if (this.isMainFigureAvailable() && this.isOverHandle(point, new IFigure[]{this.sourceHandle, this.targetHandle})) {
            return Cursors.HAND;
        }
        return super.findCursor(point);
    }

    public ITracker findTracker(Point point) {
        if (this.isMainFigureAvailable() && this.isOverHandle(point, new IFigure[]{this.sourceHandle, this.targetHandle})) {
            if (this.moveTracker == null) {
                this.moveTracker = new MoveDependencyTracker();
            }
            return this.moveTracker;
        }
        return super.findTracker(point);
    }

    private class AnchorFigure
    extends HandleFigure {
        private int type;
        private PrecisionPoint reference;

        public AnchorFigure(IFigure host, int type) {
            this.setHost(host);
            this.type = type;
            this.setBackgroundColor(Colors.moveHandleBackground());
            this.setForegroundColor(Colors.moveHandleBorder());
        }

        protected void calculateBounds(Rectangle source, Rectangle target) {
            PathDescriptor path = ((IPathShape)this.getHost()).getOutlinePath();
            this.reference = this.type == 1 ? path.getFirstPoint() : path.getLastPoint();
            target.x = (int)this.reference.x - 5;
            target.y = (int)this.reference.y - 5;
            target.width = 12;
            target.height = 12;
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            if (this.reference != null) {
                int x = (int)this.reference.x - 5 + 1;
                int y = (int)this.reference.y - 5 + 1;
                graphics.fillOval(x, y, 10, 10);
                graphics.drawOval(x, y, 9, 9);
            }
        }
    }

    private static class DependencyAnchorPartSearchCondition
    implements IViewer.IPartSearchCondition {
        private IPart exclude;

        public DependencyAnchorPartSearchCondition(IPart exclude) {
            this.exclude = exclude;
        }

        public boolean evaluate(IPart part) {
            return part != this.exclude && part instanceof TaskBarPart;
        }
    }

    private class MoveDependencyTracker
    extends AbstractDragTracker {
        private MoveDependencyTracker() {
        }

        protected void applyStatus(AbstractDragTracker.Status status) {
            ((IFigure)status.get(DependencyAnchorsFeedback.DUMMY_TARGET)).setLocation((Point)status.get(DependencyAnchorsFeedback.LOCATION));
            DependencyFigure connection = (DependencyFigure)DependencyAnchorsFeedback.this.getHost().getFigure();
            boolean changingSource = status.getBoolean(DependencyAnchorsFeedback.CHANGING_SOURCE, true);
            int orientation = status.getInteger(DependencyAnchorsFeedback.ORIENTATION, 0);
            if (orientation != 0) {
                if (changingSource) {
                    connection.setSourceOrientation(orientation);
                } else {
                    connection.setTargetOrientation(orientation);
                }
            }
            IAnchor anchor = (IAnchor)status.get(DependencyAnchorsFeedback.ANCHOR);
            if (changingSource) {
                connection.setSourceAnchor(anchor);
            } else {
                connection.setTargetAnchor(anchor);
            }
        }

        protected void restoreStatus(AbstractDragTracker.Status initStatus) {
            Request request2;
            super.restoreStatus(initStatus);
            DependencyAnchorsFeedback.this.getHost().getSite().getViewer().setPartSearchCondition((IViewer.IPartSearchCondition)initStatus.get(DependencyAnchorsFeedback.SEARCH_CONDITION));
            DependencyFigure connection = (DependencyFigure)DependencyAnchorsFeedback.this.getHost().getFigure();
            connection.setLineWidth(initStatus.getInteger(DependencyAnchorsFeedback.LINE_WIDTH, 1));
            connection.setForegroundColor((Color)initStatus.get(DependencyAnchorsFeedback.LINE_COLOR));
            connection.setAlpha((Integer)initStatus.get(DependencyAnchorsFeedback.LINE_ALPHA));
            boolean changingSource = initStatus.getBoolean(DependencyAnchorsFeedback.CHANGING_SOURCE, true);
            Request request = (Request)initStatus.get(DependencyAnchorsFeedback.REQUEST);
            AbstractDragTracker.Status status = this.getCurrentStatus();
            IPart targetPart = status == null ? null : (IPart)status.get(DependencyAnchorsFeedback.TARGET_PART);
            Request request3 = request2 = status == null ? null : (Request)status.get(DependencyAnchorsFeedback.REQUEST);
            if (changingSource) {
                ((IEditPart)((IConnectionPart)DependencyAnchorsFeedback.this.getHost()).getTargetNode()).hideTargetFeedback(request);
                if (targetPart != null && request2 != null) {
                    ((IEditPart)targetPart).hideSourceFeedback(request2);
                }
            } else {
                ((IEditPart)((IConnectionPart)DependencyAnchorsFeedback.this.getHost()).getSourceNode()).hideSourceFeedback(request);
                if (targetPart != null && request2 != null) {
                    ((IEditPart)targetPart).hideTargetFeedback(request2);
                }
            }
        }

        protected boolean captureInitialStatus(MouseEvent me, AbstractDragTracker.Status status) {
            Point cursorLocation = me.cursorLocation;
            status.set((Object)DependencyAnchorsFeedback.LOCATION, new Point(cursorLocation));
            boolean changingSource = DependencyAnchorsFeedback.this.isOverHandle(cursorLocation, new IFigure[]{DependencyAnchorsFeedback.this.sourceHandle});
            status.set((Object)DependencyAnchorsFeedback.CHANGING_SOURCE, changingSource);
            DependencyFigure connection = (DependencyFigure)DependencyAnchorsFeedback.this.getHost().getFigure();
            status.set((Object)DependencyAnchorsFeedback.LINE_COLOR, connection.getForegroundColor());
            status.set((Object)DependencyAnchorsFeedback.LINE_WIDTH, connection.getLineWidth());
            status.set((Object)DependencyAnchorsFeedback.LINE_ALPHA, connection.getAlpha());
            status.set((Object)DependencyAnchorsFeedback.ORIENTATION, changingSource ? connection.getSourceOrientation() : connection.getTargetOrientation());
            status.set((Object)DependencyAnchorsFeedback.ANCHOR, changingSource ? connection.getSourceAnchor() : connection.getTargetAnchor());
            connection.setForegroundColor(Colors.dummyDependency());
            connection.setLineWidth(2);
            connection.setAlpha(170);
            Figure dummyTarget = new Figure();
            dummyTarget.setPreferredSize(new Dimension());
            dummyTarget.setSize(dummyTarget.getPreferredSize());
            dummyTarget.setLocation(cursorLocation);
            status.set((Object)DependencyAnchorsFeedback.DUMMY_TARGET, dummyTarget);
            ChopBoxAnchor dummyAnchor = new ChopBoxAnchor((IFigure)dummyTarget);
            status.set((Object)DependencyAnchorsFeedback.DUMMY_ANCHOR, dummyAnchor);
            status.set((Object)DependencyAnchorsFeedback.TARGET_PART, null);
            Request request = new Request("connect");
            request.setDomain(this.getEditDomain());
            request.setViewer(DependencyAnchorsFeedback.this.getHost().getSite().getViewer());
            request.setParameter("position", (Object)new Point(cursorLocation));
            request.setParameter("source", (Object)DependencyAnchorsFeedback.this.getHost());
            request.setParameter("sourceOrientation", (Object)connection.getSourceOrientation());
            request.setParameter("targetOrientation", (Object)connection.getTargetOrientation());
            if (changingSource) {
                ((IEditPart)((IConnectionPart)DependencyAnchorsFeedback.this.getHost()).getTargetNode()).showTargetFeedback(request);
            } else {
                ((IEditPart)((IConnectionPart)DependencyAnchorsFeedback.this.getHost()).getSourceNode()).showSourceFeedback(request);
            }
            status.set((Object)DependencyAnchorsFeedback.REQUEST, request);
            IViewer viewer = DependencyAnchorsFeedback.this.getHost().getSite().getViewer();
            status.set((Object)DependencyAnchorsFeedback.SEARCH_CONDITION, viewer.getPartSearchCondition());
            IConnectionPart connectionPart = (IConnectionPart)DependencyAnchorsFeedback.this.getHost();
            viewer.setPartSearchCondition((IViewer.IPartSearchCondition)new DependencyAnchorPartSearchCondition((IPart)(changingSource ? connectionPart.getTargetNode() : connectionPart.getSourceNode())));
            return true;
        }

        protected Command getCommand(AbstractDragTracker.Status initStatus, AbstractDragTracker.Status status) {
            int targetOrientation;
            ITopic predecessor;
            TaskBarPart target = (TaskBarPart)status.get(DependencyAnchorsFeedback.TARGET_PART);
            if (target == null) {
                return null;
            }
            boolean changingSource = initStatus.getBoolean(DependencyAnchorsFeedback.CHANGING_SOURCE, true);
            int newOrientation = status.getInteger(DependencyAnchorsFeedback.ORIENTATION, 8);
            Dependency dependency = (Dependency)DependencyAnchorsFeedback.this.getHost().getModel();
            IConnectionPart connectionPart = (IConnectionPart)DependencyAnchorsFeedback.this.getHost();
            if ((target == connectionPart.getSourceNode() || target == connectionPart.getTargetNode()) && newOrientation == initStatus.getInteger(DependencyAnchorsFeedback.ORIENTATION, 8)) {
                return null;
            }
            ITopic successor = changingSource ? dependency.getSuccessor() : target.getTask();
            ITopic iTopic = predecessor = changingSource ? target.getTask() : dependency.getPredecessor();
            if (!this.passesDependencyConflictCheck(successor, predecessor)) {
                return null;
            }
            DependencyFigure figure = (DependencyFigure)DependencyAnchorsFeedback.this.getHost().getFigure();
            int sourceOrientation = changingSource ? newOrientation : figure.getSourceOrientation();
            int n = targetOrientation = changingSource ? figure.getTargetOrientation() : newOrientation;
            String type = sourceOrientation == 16 ? (targetOrientation == 8 ? "FS" : "FF") : (targetOrientation == 8 ? "SS" : "SF");
            if (changingSource) {
                return TaskInfoUtils.createChangeDependencyCommand((Dependency)dependency, (ITopic)predecessor, (String)type);
            }
            Command c1 = TaskInfoUtils.createRemoveDependencyCommand((Dependency)dependency);
            Command c2 = TaskInfoUtils.createAddDependencyCommand((ITopic)successor, (ITopic)predecessor, (String)type);
            return new CompoundCommand(TaskMessages.Command_ChangeDependency, new Command[]{c1, c2});
        }

        protected boolean updateStatus(MouseEvent me, AbstractDragTracker.Status initStatus, AbstractDragTracker.Status status) {
            int orientation;
            boolean changingSource = status.getBoolean(DependencyAnchorsFeedback.CHANGING_SOURCE, true);
            Request request = (Request)status.get(DependencyAnchorsFeedback.REQUEST);
            IPart oldTarget = (IPart)status.get(DependencyAnchorsFeedback.TARGET_PART);
            if (oldTarget != null && oldTarget instanceof IEditPart && request != null) {
                if (changingSource) {
                    ((IEditPart)oldTarget).hideSourceFeedback(request);
                } else {
                    ((IEditPart)oldTarget).hideTargetFeedback(request);
                }
            }
            IPart target = me.target;
            Point cursorLocation = me.cursorLocation;
            Object anchor = status.get(DependencyAnchorsFeedback.DUMMY_ANCHOR);
            int n = orientation = target instanceof TaskBarPart ? ((TaskBarPart)target).getConnectionOrientation(cursorLocation) : 0;
            if (orientation == 0) {
                target = null;
                request = null;
            } else {
                status.set((Object)DependencyAnchorsFeedback.ORIENTATION, orientation);
                TaskBarPart taskBarPart = (TaskBarPart)target;
                anchor = changingSource ? taskBarPart.getSourceAnchor((IGraphicalPart)DependencyAnchorsFeedback.this.getHost()) : taskBarPart.getTargetAnchor((IGraphicalPart)DependencyAnchorsFeedback.this.getHost());
                request = new Request("connect");
                request.setDomain(this.getEditDomain());
                request.setViewer(DependencyAnchorsFeedback.this.getHost().getSite().getViewer());
                request.setPrimaryTarget(target);
                request.setParameter("position", (Object)new Point(cursorLocation));
                request.setParameter("source", (Object)DependencyAnchorsFeedback.this.getHost());
                request.setParameter("sourceOrientation", (Object)(changingSource ? orientation : ((DependencyFigure)DependencyAnchorsFeedback.this.getHost().getFigure()).getSourceOrientation()));
                request.setParameter("targetOrientation", (Object)(changingSource ? ((DependencyFigure)DependencyAnchorsFeedback.this.getHost().getFigure()).getTargetOrientation() : orientation));
                if (changingSource) {
                    taskBarPart.showSourceFeedback(request);
                } else {
                    taskBarPart.showTargetFeedback(request);
                }
            }
            status.set((Object)DependencyAnchorsFeedback.LOCATION, new Point(cursorLocation));
            status.set((Object)DependencyAnchorsFeedback.TARGET_PART, target);
            status.set((Object)DependencyAnchorsFeedback.ANCHOR, anchor);
            status.set((Object)DependencyAnchorsFeedback.REQUEST, request);
            return true;
        }

        private boolean passesDependencyConflictCheck(ITopic task, ITopic predecessor) {
            if (task == predecessor) {
                return false;
            }
            if (TaskInfoUtils.isCircularDependencies((ITopic)task, (ITopic)predecessor)) {
                this.alertConflict(GanttMessages.TaskBarDependencyAnchorsFeedback_CircularDependencies_warning);
                return false;
            }
            return true;
        }

        private void alertConflict(String message) {
            MessageDialog.openWarning((Shell)DependencyAnchorsFeedback.this.getHost().getSite().getShell(), (String)GanttMessages.TaskBarDependencyAnchorsFeedback_InvalidDependencyDialog_windowTitle, (String)message);
        }

        public boolean handleMouseEntered(MouseEvent me, IViewer viewer) {
            if (viewer != DependencyAnchorsFeedback.this.getHost().getSite().getViewer()) {
                return true;
            }
            if (me.target != null && me.target instanceof TaskBarPart && me.target.hasRole("selectable role")) {
                viewer.setPreselected((Object)me.target);
            }
            return true;
        }

        public boolean handleMouseExited(MouseEvent me, IViewer viewer) {
            if (viewer != DependencyAnchorsFeedback.this.getHost().getSite().getViewer()) {
                return true;
            }
            if (me.target != null && me.target == viewer.getPreselectedPart()) {
                viewer.setPreselected(null);
            }
            return true;
        }

        public Cursor getCurrentCursor(Point pos, IPart host) {
            return Cursors.HAND;
        }
    }
}

