/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.notes;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.findreplace.AbstractFindReplaceOperationProvider;
import org.xmind.ui.mindmap.ITopicPart;

public class NotesFindReplaceOperationProvider
extends AbstractFindReplaceOperationProvider {
    private IAdaptable view;

    public NotesFindReplaceOperationProvider(IAdaptable view) {
        this.view = view;
    }

    @Override
    public String getContextName() {
        ITopicPart topicPart = (ITopicPart)this.view.getAdapter(ITopicPart.class);
        if (topicPart != null) {
            return NLS.bind((String)MindMapMessages.Notes_FindReplaceContextPattern, (Object)topicPart.getTopic().getTitleText());
        }
        return MindMapMessages.EmptyNotes_FindReplaceContextName;
    }

    @Override
    public String getContextName(int maxWidth, Font font) {
        return NotesFindReplaceOperationProvider.constrainText(this.getContextName(), maxWidth, font);
    }

    protected IFindReplaceTarget getFindReplaceTarget() {
        return (IFindReplaceTarget)this.view.getAdapter(IFindReplaceTarget.class);
    }

    @Override
    protected boolean findAll(String toFind) {
        return false;
    }

    @Override
    protected boolean findNext(String toFind) {
        return this.findInNotes(toFind);
    }

    private boolean findInNotes(String toFind) {
        return this.findInNotes(this.getFindReplaceTarget(), toFind);
    }

    private boolean findInNotes(IFindReplaceTarget target, String toFind) {
        if (target != null && target.canPerformFind()) {
            int offset = target.findAndSelect(this.isForward() ? target.getSelection().x + target.getSelection().y : target.getSelection().x - 1, toFind, this.isForward(), this.isCaseSensitive(), this.isWholeWord());
            return offset >= 0;
        }
        return false;
    }

    @Override
    protected boolean replaceAll(String toFind, String toReplaceWith) {
        boolean found;
        IFindReplaceTarget target = this.getFindReplaceTarget();
        boolean bl = found = target.findAndSelect(0, toFind, true, this.isCaseSensitive(), this.isWholeWord()) >= 0;
        if (found) {
            while (this.replaceInNotes(target, toFind, toReplaceWith)) {
            }
        }
        return found;
    }

    @Override
    protected boolean replaceNext(String toFind, String toReplaceWith) {
        return this.replaceInNotes(toFind, toReplaceWith);
    }

    private boolean replaceInNotes(String toFind, String toReplaceWith) {
        return this.replaceInNotes(this.getFindReplaceTarget(), toFind, toReplaceWith);
    }

    private boolean replaceInNotes(IFindReplaceTarget target, String toFind, String toReplaceWith) {
        if (target != null && target.canPerformFind() && target.isEditable()) {
            target.replaceSelection(toReplaceWith);
        }
        return this.findInNotes(target, toFind);
    }

    @Override
    public boolean canFind(String toFind) {
        return toFind != null;
    }

    @Override
    public boolean canFindAll(String toFind) {
        return false;
    }

    @Override
    public boolean canReplace(String toFind, String toReplaceWith) {
        return this.canFind(toFind);
    }

    @Override
    public boolean canReplaceAll(String toFind, String toReplaceWith) {
        return super.canReplaceAll(toFind, toReplaceWith);
    }

    @Override
    public boolean understandsPatameter(int parameter) {
        return super.understandsPatameter(parameter) && parameter != 32 && parameter != 16;
    }
}

