;;;;; -*-coding: x-ctext;-*-
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: header.el,v 44.7 2003/08/24 18:41:36 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: header.el
;;;;
;;;; Code that needs to go before everything else
;;;;


;;; Check the version of Emacs when compiling
;;;
;;; If the version of Emacs is too old, signal an error.
;;; We require Gnu Emacs 19.34 or 20.3 or XEmacs 21.1.

(eval-and-compile
  (if (or (not (boundp 'emacs-major-version))
          (not (boundp 'emacs-minor-version))
          (and (string-match "XEmacs" (emacs-version))
               (or (< emacs-major-version 20)
                   (and (= emacs-major-version 20)
                        (< emacs-minor-version 4))
                   (and (= emacs-major-version 21)
                        (< emacs-minor-version 1))))
          (and (not (string-match "XEmacs" (emacs-version)))
               (or (< emacs-major-version 19)
                   (and (= emacs-major-version 19)
                        (< emacs-minor-version 34))
                   (and (= emacs-major-version 20)
                        (< emacs-minor-version 2)))))
      (error "Emacs 19.34, XEmacs 21.1 or later, or Emacs 20.2 or later is required")))

(cond ((or (not (boundp 'emacs-major-version))
           (not (boundp 'emacs-minor-version))
           (< emacs-major-version (eval-when-compile emacs-major-version)))
       (error "LysKOM was compiled for a newer version of Emacs"))
      ((and (eq (eval-when-compile emacs-major-version) 19)
            (> emacs-major-version 19))
       (error "A LysKOM client compiled for Emacs 19 will not run in newer versions of Emacs.")))

;;; Check some basic misfeatures that are still all too common



(eval-and-compile
  (defmacro lyskom-detect-read-kbd-macro-bug ()
    `(and (stringp (read-kbd-macro "<SPC>"))
          (string-equal (read-kbd-macro "<SPC>") "<SPC>")))

  (let ((libraries-to-try '("edmacro")))
    (while libraries-to-try
      (if (lyskom-detect-read-kbd-macro-bug)
          (progn (condition-case nil
                     (load-library (car libraries-to-try))
                   (error nil))
                 (setq libraries-to-try (cdr libraries-to-try)))
        (setq libraries-to-try nil)))

    (if (lyskom-detect-read-kbd-macro-bug)
        (let ((elc-location (locate-library "macedit.elc"))
              (el-location (locate-library "macedit.el"))
              (elz-location (locate-library "macedit.el.gz")))
          (cond ((or el-location elc-location)
                 (message "\

You probably have a file named macedit.elc in Emacs' load path.

This file is included in some versions of the calc package and
is no longer required as the functions that it provides are
also provided by more modern packages.

You will need to remove macedit.el and all references to it
from Emacs. These are the files you need to remove:

%s
To fully remove macedit you will also have to remove any
autoloads that refer to it. These may be found in a file
named auto-autoloads.elc (or auto-autoloads.el), located 
in the same directory as macedit or in a file named
loaddefs.el, located elsewhere.

With Gnu Emacs you may be successful in removing references
by using the command update-autoloads-from-directories.
"
                          (mapconcat (lambda (x) (or x "")) 
                                     (list elc-location el-location elz-location) 
                                     "\n"))
                 (error "Unable to run or compile due to obsolete macedit package."))
                (t
                 (message "\

Your definition of read-kbd-macro appears to be obsolete. This
is usually caused by having a package called macedit in Emacs
load path, but I am unable to find this package. LysKOM cannot
run with your version of read-kbd-macro.
")
                 (error "Unable to run or compile due to obsolete definition of read-kbd-macro.")))))))


(eval-and-compile 
  (defvar lyskom-debug-compile (eval-when-compile (getenv "LYSKOM_DEBUG_COMPILE"))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: defvar.el,v 44.19 2004/07/12 18:11:16 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: defvar.el
;;;; Authos: David Byers
;;;;
;;;; This file contains definitions used to define variables
;;;;


(defvar lyskom-clientversion-long 
  "$Id: defvar.el,v 44.19 2004/07/12 18:11:16 byers Exp $\n"
  "Version for every file in the client.")


(provide 'lyskom)

;; Just to get rid of a compiler warning
(defvar kom-dont-read-saved-variables)

(defvar lyskom-local-variables nil
  "List of variables to make local in a LysKOM buffer")

(defvar lyskom-local-hooks nil
  "List of hooks to make local in a LysKOM buffer.")

(defvar lyskom-protected-variables nil
  "List of variables that are protected from kill-buffer")

(defvar lyskom-inherited-variables nil
  "List of variables inherited from the LysKOM buffer")

(defvar lyskom-elisp-variables nil
  "Tells the client what flags and hooks that are to be saved in the server.
These are the flags that are saved in the elisp-client part of the server.")

(defvar lyskom-transition-variables nil
  "Tells the client what variables are not to be saved in the server, but
are to be read from the server. This is for transitioning.")

(defvar lyskom-minibuffer-variables nil
  "These are variables that should be set in the minibuffer by 
lyskom-with-lyskom-minibuffer.")

(defvar lyskom-minibuffer-values nil
  "Dynamic binding of values that minibuffer variables are to take on")

(defvar lyskom-global-variables nil
  "List of flags that are to be saved as booleans in the common block.

Don't change these. They are defined by the protocol.")


(defmacro lyskom-save-variables (var-list &rest forms)
  "Save the values and property list of symbols in VAR-LIST and execute FORMS
The symbol value, property list and buffer-local property of all variables
is saved before executing FORMS and restored when FORMS have finished."
  (let ((sym1 (make-symbol "lyskom-saved-variables"))
        (sym2 (make-symbol "lyskom-saved-symbols"))
        (sym3 (make-symbol "lyskom-saved-local"))
        (sym4 (make-symbol "lyskom-saved-plist")))
    (` (let* (((, sym2) (quote (, var-list)))
              ((, sym1) (mapcar 'symbol-value (, sym2)))
              ((, sym4) (mapcar 'symbol-plist (, sym2)))
              ((, sym3) (mapcar (function
                                 (lambda (v)
                                   (local-variable-p v (current-buffer))))
                                 (, sym2))))
         (unwind-protect 
             (progn (,@ forms))
           (while (, sym1)
             (if (car (, sym3)) (make-local-variable (car (, sym2))))
             (set (car (, sym2)) (car (, sym1)))
             (setplist (car (, sym2)) (car (, sym4)))
             (setq (, sym1) (cdr (, sym1))
                   (, sym2) (cdr (, sym2))
                   (, sym3) (cdr (, sym3))
                   (, sym4) (cdr (, sym4)))))))))

(put 'lyskom-save-variables 'edebug-form-spec
     '(sexp body))

(defmacro lyskom-with-lyskom-minibuffer (&rest forms)
  "Run FORMS after ensuring that LysKOM minibuffer variables will be set."
  (` (let* ((lyskom-minibuffer-values
             (mapcar 'symbol-value lyskom-minibuffer-variables)))
       (unwind-protect
           (progn
             (add-hook 'minibuffer-setup-hook
                       'lyskom-setup-minibuffer-variables)
             (,@ forms))
         (remove-hook 'minibuffer-setup-hook
                      'lyskom-setup-minibuffer-variables)))))

(put 'lyskom-with-lyskom-minibuffer 'edebug-form-spec
     '(body))


(defun lyskom-setup-minibuffer-variables ()
  (let ((syms lyskom-minibuffer-variables)
        (vals lyskom-minibuffer-values))
    (while syms
      (make-local-variable (car syms))
      (set (car syms) (car vals))
      (setq syms (cdr syms)
            vals (cdr vals)))))

         

(defmacro def-kom-var (name value &rest args)
    "Define a variable with name NAME and initial value VALUE.
Remaining args, ARGS may be
A string        Used as the documentation string for the variable
A symbol        A predefined property of the variable
A list          A widget specification for the variable

Predefined (and tested) properties are the following
server          Save the variable in the elisp block. Implies local.
local           Make the variable buffer-local.
inherited       The variable is inherited from parent buffer. Implies protected
protected       The variable is marked as permanent local. Implies local.
minibuffer      Inherit the variable as a local variable in the minibuffer.
server-hook     A hook stored in the server.
local-hook      A hook variable that is made local in LysKOM buffers.
language-force  A language-variable whose value is to be forced."
          
    (let ((inherited nil)
          (protected nil)
          (elisp-block nil)
          (transition-block nil)
          (buffer-local nil)
          (widget-spec nil)
          (doc-string nil)
          (minibuffer nil)
          (local-hook-doc nil)
          (local-var-doc nil)
          (server-doc nil)
          (language-force nil)
          (arglist args))
;      (message "%S" name)
      (while arglist
        (cond ((stringp (car arglist)) (setq doc-string (car arglist)))
              ((consp (car arglist))
               (setq widget-spec 
                     (` ((setq lyskom-custom-variables
                               (cons  (quote (, (list name
                                                      (car arglist))))
                                      lyskom-custom-variables))))))
              ((symbolp (car arglist))
               (cond ((eq (car arglist) 'server)
                      (setq local-var-doc t server-doc t)
                      (setq elisp-block
                            `((add-to-list 'lyskom-elisp-variables ', name)
                              (add-to-list 'lyskom-local-variables ', name))))

                     ((eq (car arglist) 'common)
                      (setq local-var-doc t server-doc t)
                      (let ((common-name (car (cdr arglist)))
                            (type (car (cdr (cdr arglist)))))
                        (setq arglist (cdr (cdr arglist)))
                        (setq elisp-block
                              `((add-to-list 'lyskom-local-variables ',name)
                                (add-to-list 'lyskom-global-variables
                                             (vector ',common-name ',name ',type))))))

                     ((eq (car arglist) 'transition)
                      (let ((converter (car (cdr arglist))))
                        (setq arglist (cdr arglist))
                        (setq local-var-doc t server-doc t)
                        (setq transition-block
                              `((add-to-list 'lyskom-transition-variables 
                                             '(,name . ,converter))
                                (add-to-list 'lyskom-local-variables ',name)))))

                     ((eq (car arglist) 'server-hook)
                      (setq local-hook-doc t server-doc t)
                      (setq elisp-block
                            (` ((add-to-list 'lyskom-elisp-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-hooks
                                             (quote (, name)))))))

                     ((eq (car arglist) 'protected)
                      (setq local-var-doc t)
                      (setq protected
                            (` ((put (quote (, name)) 'permanent-local t)
                                (add-to-list 'lyskom-protected-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'inherited)
                      (setq local-var-doc t)
                      (setq inherited
                            (` ((add-to-list 'lyskom-inherited-variables
                                             (quote (, name)))
                                (put (quote (, name)) 'permanent-local t)
                                (add-to-list 'lyskom-protected-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'local)
                      (setq local-var-doc t)
                      (setq buffer-local
                            (` ((add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'local-hook)
                      (setq local-hook-doc t)
                      (setq buffer-local
                            (` ((add-to-list 'lyskom-local-hooks
                                             (quote (, name)))))))

                     ((eq (car arglist) 'minibuffer)
                      (setq minibuffer
                            (` ((add-to-list 'lyskom-minibuffer-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'language-force)
                      (setq language-force
                            `((put ',name 'lyskom-language-force t))))

                     (t (error "LysKOM: Unknown variable property: %S"
                               (car arglist)))))
              (t (error "LysKOM: Strange variable argument type: %S" 
                        (car arglist))))
        (setq arglist (cdr arglist)))

      (if (null doc-string) (setq doc-string "This variable is not documented."))

      (if doc-string
        (if
          (if (or local-var-doc local-hook-doc)
            (setq doc-string (concat doc-string "\n")))
          (if local-var-doc
            (setq doc-string (concat doc-string "\nThis variable is buffer-local.")))
          (if local-hook-doc
            (setq doc-string (concat doc-string "\nThis variable is a buffer-local hook.")))
          (setq doc-string (concat doc-string "\n\n\
Setting this variable in .emacs may not yield the results you expect
since that will affect all LysKOM sessions."))))

      (if (and doc-string server-doc)
        (setq doc-string (concat doc-string "

This variable is normally stored on a per-session basis in the
LysKOM server, but can be set in your .emacs simply by setting
it using setq or defvar.")))

      (` (progn (dont-compile (if (and (boundp (quote (, name)))
                                       (or (not (boundp lyskom-is-loaded))
                                           (not lyskom-is-loaded))
                                       (listp kom-dont-read-saved-variables))
                                  (add-to-list 'kom-dont-read-saved-variables
                                               (quote (, name)))))
                (defvar (, name) (, value) (, doc-string))
                (,@ (apply 'append
                           (list inherited
                                 protected
                                 elisp-block
                                 transition-block
                                 buffer-local
                                 minibuffer
                                 widget-spec
                                 language-force
                                 )))))))


(put 'def-kom-var 'edebug-form-spec
     '(&define name form &rest sexp))



(eval-and-compile (provide 'lyskom-defvar))



;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: feature.el,v 1.8 2003/08/16 16:58:45 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: feature.el
;;;;
;;;; Functions for determining if we have a particular feature or not
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: feature.el,v 1.8 2003/08/16 16:58:45 byers Exp $\n"))

(def-kom-var lyskom-feature-defaults nil
  "Alist with default values of all feature variables")

(eval-and-compile
  (defun lyskom-feature-variable (name)
    (intern (format "lyskom-%s-feature-flag" name))))

(defmacro lyskom-define-feature (name default)
  "Define a feature variable NAME with default value DEFAULT"
  `(progn (setq lyskom-feature-defaults 
                (cons (cons ',name ,default) lyskom-feature-defaults))
          (def-kom-var ,(lyskom-feature-variable name) ,default
            "LysKOM feature flag variable."
            inherited minibuffer local)))

(defmacro lyskom-set-feature (name value)
  "Set the value of feature NAME to VALUE"
  `(setq ,(lyskom-feature-variable name) ,value))

(defmacro lyskom-have-feature (name)
  "Return non-nil if feature NAME is non-nil"
  (lyskom-feature-variable name))

(defmacro lyskom-feature-value (name)
  "Return the value of feature NAME"
  (lyskom-feature-variable name))

(defun lyskom-clear-features ()
  "Set the feature variables to their defaults"
  (mapcar (lambda (feature)
            (set (lyskom-feature-variable (car feature)) (cdr feature)))
          lyskom-feature-defaults))

;;UNUSED: lyskom-list-features
(defun lyskom-list-features ()
  "List all feature values. mapcar ROCKS!"
  (mapcar 'lyskom-insert-before-prompt
          (mapcar (lambda (x) (apply 'format "%S: %S\n" x))
                  (lyskom-mapcar2 'list
                           (mapcar 'car lyskom-feature-defaults)
                           (mapcar 'symbol-value 
                                   (mapcar 'lyskom-feature-variable
                                           (mapcar 'car lyskom-feature-defaults)))))))

;;; ======================================================================
;;; ======================================================================

;;; Utility functions

(defmacro lyskom-have-call (call-no)
  "Non-nil if call CALL-NO is supported by the server"
  `(<= ,call-no (lyskom-feature-value highest-call)))


;;; ======================================================================
;;; ======================================================================

;;; The features

(lyskom-define-feature bcc-misc nil)
(lyskom-define-feature read-ranges nil)
(lyskom-define-feature aux-items nil)
(lyskom-define-feature highest-call 0)
(lyskom-define-feature local-to-global nil)
(lyskom-define-feature dynamic-session-info nil)
(lyskom-define-feature idle-time nil)
(lyskom-define-feature long-conf-types nil)


(provide 'lyskom-feature)
;;;;; -*-coding: raw-text;mode: emacs-lisp;-*-
;;;;; $Id: vars.el.in,v 44.313 2005/01/12 11:42:14 _cvs_pont_lyskomelisp Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: vars.el
;;;;
;;;; This file contains almost all the variables used in lyskom.
;;;;

;;;; Note: put "**" at the front of docstrings that are ready
;;;; for use in DocBook autogeneration.
;;;;
;;;; Rules for documentation that can be translated to DocBook
;;;; is in interndoc/vardoc


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: vars.el.in,v 44.313 2005/01/12 11:42:14 _cvs_pont_lyskomelisp Exp $\n"))

(defvar lyskom-dummy-variable-to-fool-the-byte-compiler)

(defvar lyskom-mule-compiled
  (eval-when-compile (and (fboundp 'multibyte-string-p)
                          (multibyte-string-p "")))
  "Non-nil if the client was compiled with multibyte characters enabled")

(provide 'lyskom)

(require 'lyskom-defvar "defvar")

(defconst lyskom-global-variable-types
  '((boolean (read . lyskom-flag-read-boolean)
             (write . lyskom-flag-write-boolean))
    (integer (read . lyskom-flag-read-integer)
             (write . lyskom-flag-write-integer))
    (symbol-list (read . lyskom-flag-read-symbol-list)
                 (write . lyskom-flag-write-symbol-list))
    (t (read . lyskom-flag-read-from-string)
       (write . prin1-to-string))))


(defun lyskom-protect-variable (sym) 
  "Protect SYM from being killed when deleting local variables."
  (put sym 'permanent-local t)
  (lyskom-local-variable sym)
  (add-to-list 'lyskom-protected-variables sym))

(defun lyskom-local-variable (sym)
  "Define SYM as a buffer-local variable"
  (add-to-list 'lyskom-local-variables sym))

(defun lyskom-inherited-variable (sym)
  "Define SYM as a variable that is inherited when creating new buffers.
Inheritance only works with the LysKOM buffer handling functions."
  (add-to-list 'lyskom-inherited-variable sym)
  (lyskom-protect-variable sym))

(defun lyskom-setup-local-variables ()
  "Set up all globally defined local variables in the current buffer."
  (mapcar 'make-local-variable lyskom-local-variables)
  (mapcar 'lyskom-make-local-hook lyskom-local-hooks))

(defvar lyskom-is-loaded nil
  "Non-nil when lyskom has been loaded.")

(defvar lyskom-have-one-login nil
  "Non-nil after the first login")


(def-kom-var kom-dont-read-saved-variables '(kom-dont-read-saved-variables
                                             lyskom-login-hook)
  "**Determines which LysKOM variables to not store in the server.

For the most part you do not have to modify this variable. Any variables
set before LysKOM is loaded will not be read from the server.
This variable should `nil', `t' or a list of symbols. 

The value `nil' means read all variables from the server. The value
`t' means read no variables from the server. When the value is a list
of symbols, those variables will not be read from the server.

Any other values are reserved for future use.")

(defmacro lyskom-maybe-setq (var value)
  "This is a wrapper around setq that does nothing
if the variable is in kom-dont-read-saved-variables."
  `(cond ((eq kom-dont-read-saved-variables t) nil)
         ((memq ,var kom-dont-read-saved-variables) nil)
         (t (set ,var ,value))))

(defmacro lyskom-maybe-setq-default (var value)
  "This is a wrapper around setq-default that does nothing
if the variable is in kom-dont-read-saved-variables."
  `(cond ((eq kom-dont-read-saved-variables t) nil)
         ((memq ,var kom-dont-read-saved-variables) nil)
         (t (set-default ',var ,value))))

;;;; ================================================================
;;;;                     Variables and constants.


;;; User flags

(def-kom-var kom-auto-confirm-new-conferences nil
  "**Determines behavior of `kom-list-new-conferences' and `kom-list-new-persons'.

When this variable is set to `t', `kom-list-new-conferences' and
`kom-list-new-persons' will automatically mark all listed conferences
and persons as known. When set to `nil', these commands will ask for
confirmation before marking the listed conferences and persons as known.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-dont-complain-about-missing-presentation nil
  "**Controls whether the client complains when you don't have
a presentation. When set to non-nil, the client will never
complain.

This variable should not be documented. Anybody asocial enough
to want this feature ought to have to work to find it."
  server)

(def-kom-var kom-show-sync-messages nil
  "**Controls display of database saving message.

When this variable is set to `t', the client will show a message in
the echo area when the LysKOM server signals that it is saving the
database. When set to `nil', no message is shown (the mode line is
changed regardless of the setting of this variable).

Values other than `t' and `nil' are reserved for future use."
  server)


(def-kom-var kom-text-links
  '((t ("\\<bug[ \t\n]+\\([0-9]+\\)\\>"
	"http://bugzilla.lysator.liu.se/show_bug.cgi?id=\\1"
	0 t)))
  "**Defines patterns for automatic links in the text.

This variable defines patterns to look for in text and convert to
links to URLs. The value of this variable must be an alist, where the
key (car) is a conference number and the value (cdr) is a list of link
specifications for that conference. The special value `t' for the key
indicates a list of patterns to apply in all conferences. Key values
other than positive integers and `t' are reserved for future use.

Each link specification is in turn a list \(`PATTERN' `REPLACEMENT'
`HIGHLIGHT' `IGNORE-CASE'), where `PATTERN' is a regular expression to
look for in the text, `REPLACEMENT' is used to generate a URL from the
text matching `PATTERN', `HIGHLIGHT' is the pattern group to highlight
as a URL and `IGNORE-CASE' specifies whether matching is
case-sensitive or not.

Each text is examined for each `PATTERN'. If a match is found, a URL
is created from `REPLACEMENT'. All characters except backslash are
copied verbatim. The backslash character starts one of the following
sequences:

    Sequence    Meaning
    -----------------------------------------------------------------
    `\\&'          Substitute the matched text

    `\\N'          Substitute match for text matching the Nth (...)
                group in `PATTERN'

    `\\\\'          Insert one backslash.
    -----------------------------------------------------------------

The `HIGHLIGHT' parameter specifies which (...) group in `PATTERN'
to highlight as an URL. Use 0 to highlight the entire match.

Finally, if `IGNORE-CASE' is `t', then ignore character case while
looking for `PATTERN'. Values other than `t' and `nil' are reserved
for future use.

When a text has more than one recipient, links will be generated for
all recipients. The order in which the recipients are examined and
the priority among links that match the same text is undefined."
  server)


(def-kom-var lyskom-default-conference-strategy
  '((kom-start-anew (what-is-your-name
                     (default . (lyskom-default-conference-empty))))

    (kom-delete-conf (what-conf-to-delete
                      (default . (lyskom-default-conference-empty))))

    (kom-sub-self (leave-what-conf
                   (filter . (lyskom-default-conference-not-self))))

    (kom-change-priority (what-to-change-pres-you
                          (default . (lyskom-default-conference-at-point
                                      lyskom-default-conference-self))))

    (kom-change-presentation (what-to-change-pres-you
                              (default . (lyskom-default-conference-at-point
                                          lyskom-default-conference-self))))

    (kom-change-conf-motd (who-to-put-motd-for
                           (default . (lyskom-default-conference-at-point
                                       lyskom-default-conference-self))))

    (kom-set-presentation (what-to-set-pres-you
                           (default . (lyskom-default-conference-at-point
                                       lyskom-default-conference-self))))

    (kom-set-motd-text (what-to-set-motd-you
                        (default . (lyskom-default-conference-at-point
                                    lyskom-default-conference-self))))

    (kom-remove-presentation (who-to-remove-pres-for
                              (default . (lyskom-default-conference-at-point
                                          lyskom-default-conference-self))))

    (kom-unset-conf-motd (who-to-remove-motd-for
                          (default . (lyskom-default-conference-at-point
                                      lyskom-default-conference-self))))

    (kom-go-to-conf (go-to-conf-p
                     (default . (lyskom-default-conference-at-point
                                 lyskom-default-conference-self))
                     (filter . (lyskom-default-conference-not-current))))

    (kom-list-created-conferences (list-confs-created-by
                                   (default . (lyskom-default-conference-at-point
                                               lyskom-default-conference-self))))

    (kom-change-name (name-to-be-changed
                      (default . (lyskom-default-conference-at-point
                                  lyskom-default-conference-self))))

    (kom-change-parenthesis (name-to-be-changed
                             (default . (lyskom-default-conference-at-point
                                         lyskom-default-conference-self))))

    (kom-change-password (whos-passwd
                          (default . (lyskom-default-conference-at-point
                                      lyskom-default-conference-self))))

    (kom-redirect-comments (redirect-for-whom
                            (default . (lyskom-default-conference-at-point
                                        lyskom-default-conference-self)))
                           (redirect-to-which-conf))

    (kom-filter-author (filter-author
                        (default . (lyskom-default-conference-at-point
                                    lyskom-default-conference-last-author))
                        (filter . (lyskom-default-conference-not-self)))
                       (filter-in-conf
                        (filter . (lyskom-default-conference-not-self))))


    (kom-review-by-to (review-by-whom
                       (default . (lyskom-default-conference-at-point
                                   lyskom-default-conference-empty)))
                      (review-to-conf))

    (kom-review-first (review-by-whom
                       (default . (lyskom-default-conference-at-point
                                   lyskom-default-conference-empty)))
                      (review-to-conf))

    (kom-review-all (review-by-whom
                     (default . (lyskom-default-conference-at-point
                                 lyskom-default-conference-empty)))
                    (review-to-conf))

    (kom-unread-by-to (unread-by-whom
                       (default . (lyskom-default-conference-at-point
                                   lyskom-default-conference-empty)))
                      (unread-to-conf))

    (kom-unread-first (unread-by-whom
                      (default . (lyskom-default-conference-at-point
                                  lyskom-default-conference-empty)))
                      (unread-to-conf))

    (kom-unread-all (unread-by-whom 
                     (default . (lyskom-default-conference-at-point
                                 lyskom-default-conference-empty)))
                    (unread-to-conf))

    (kom-set-permitted-submitters (conf-to-set-permitted-submitters-q)
                                  (new-permitted-submitters-q
                                   (default . (lyskom-default-conference-empty))))

    (lyskom (what-is-your-name 
             (default . (lyskom-default-conference-empty))))


    (kom-add-recipient (who-to-add-q 
                        (default . ((lyskom-default-conference-saved last-added-rcpt)))
                        (save last-added-rcpt)))

    (kom-add-copy (who-to-add-copy-q 
                   (default . ((lyskom-default-conference-saved last-added-cc)))
                   (save last-added-cc)))

    (kom-add-bcc (who-to-add-bcc-q 
                  (default . ((lyskom-default-conference-saved last-added-bcc)))
                  (save last-added-bcc)))

    (kom-sub-recipient (who-to-sub-q
                        (default . (lyskom-default-conference-at-point
                                    (lyskom-default-conference-saved last-sub-recipient)
                                    lyskom-default-conference-current
                                    lyskom-default-conference-restriction))
                        (save last-sub-recipient)))

    (kom-move-text (who-to-move-from-q
                    (default . (lyskom-default-conference-at-point
                                (lyskom-default-conference-saved last-sub-recipient)
                                lyskom-default-conference-current
                                lyskom-default-conference-restriction))
                    (save last-sub-recipient))
                   (who-to-move-to-q
                    (default . ((lyskom-default-conference-saved last-added-rcpt)
                                lyskom-default-conference-current))
                    (save last-added-rcpt)))

    (kom-move-text-tree (who-to-move-from-q
                         (default . (lyskom-default-conference-at-point
                                     (lyskom-default-conference-saved last-sub-recipient)
                                     lyskom-default-conference-current
                                     lyskom-default-conference-restriction))
                         (save last-sub-recipient))
                        (who-to-move-to-or-sub-q
                         (default . ((lyskom-default-conference-saved last-added-rcpt)
                                     lyskom-default-conference-current))
                         (save last-added-rcpt))
                        (who-to-move-to-q
                         (default . ((lyskom-default-conference-saved last-added-rcpt)
                                     lyskom-default-conference-current))
                         (save last-added-rcpt))
                        (who-to-add-q
                         (default . ((lyskom-default-conference-saved last-added-rcpt)
                                     lyskom-default-conference-current))
                         (save last-added-rcpt)))

    (kom-send-message (who-to-send-message-to
                       (default . (lyskom-default-conference-for-send-message))))

    (kom-send-alarm (who-to-send-message-to
                     (default . (lyskom-default-conference-for-send-message))))

    (kom-is-person-member-of-conference (pers-to-check-mship-for)
                                        (conf-to-check-mship-of))



    ;; Defaults and commands that use the defaults

    (kom-remote-autoreply (remote-control-who))
    (kom-remote-set-message (remote-control-who))
    (kom-remote-list-messages (remote-control-who))
    (kom-remote-erase-messages (remote-control-who))
    (kom-remote-quit (remote-control-who))
    (kom-review-presentation (presentation-for-whom))
    (kom-unread-presentation (unread-presentation-for-whom))
    (kom-add-member (who-to-add) (where-to-add))
    (kom-add-self (where-to-add-self))
    (kom-change-priority (change-priority-for-q))
    (kom-sub-member (who-to-exclude) (where-from-exclude))
    (kom-write-text (who-send-text-to))
    (kom-send-letter (who-letter-to))
    (kom-force-logoout (who-to-throw-out))
    (kom-change-supervisor (what-to-change-supervisor-for) (new-supervisor))
    (kom-who-is-on-in-conference (who-is-on-in-what-conference))
    (kom-who-is-present-in-conference (who-is-present-in-what-conference))
    (kom-add-cross-reference (which-conf-to-xref) (which-pers-to-xref))
    (kom-edit-add-cross-reference (which-conf-to-xref) (which-pers-to-xref))
    (kom-edit-insert-link (which-conf-to-link) (which-pers-to-link))
    (kom-status-conf (conf-for-status))
    (kom-status-session (session-for-status))
    (kom-force-logout (who-to-throw-out))
    (kom-status-person (pers-for-status))
    (kom-set-garb-nice (conf-to-set-garb-nice-q))
    (kom-set-super-conf (conf-to-set-super-conf-q) (new-super-conf-q))
    (kom-set-personal-label (label-what-pers) (label-what-conf))
    (kom-will-person-read-text (pers-to-check-will-read-for))
    (kom-create-aux-item (which-conf-to-add-aux-to))
    (kom-recommend-conference (recommend-which-conf))
    (kom-limit-import (limit-import-to-conf))
    (kom-edit-add-recipient (added-recipient))
    (kom-edit-add-bcc (added-blank-carbon-copy))
    (kom-edit-add-copy (added-carbon-copy))
    (kom-edit-move-text (who-to-move-to-q))
    (kom-add-faq (conf-to-add-faq))
    (kom-del-faq (conf-to-del-faq))
    (kom-review-faq (view-which-faq))
    (kom-unread-faq (unread-which-faq))
    (kom-change-conf-faq (what-to-change-faq-you))
    (kom-list-faqs (conf-to-list-faqs))
    (kom-filter-subject (filter-in-conf))
    (kom-filter-recipient (filter-recipient))
    (kom-filter-text (filter-in-conf))
    (kom-change-conf-type (what-conf-to-change))
    (kom-change-privileges (what-pers-privs-to-change))
    (kom-change-message-flag (set-message-flag-for-conf))

    (t (t (default . (lyskom-default-conference-at-point
                      lyskom-default-conference-current))))
    )

  "Strategy for the initial value for conference defaults.

Each element in this list identifies an Emacs och LysKOM command, and
defines the initial values for queries it makes for conference names.

Each element has the following format:

    \(COMMAND . \(\(PROMPT-1 . \(\(default . \(INITIAL-VALUES\\)\\)
                             \(filter  . \(EXCLUDED-CONFS\)\)
                             \(save    . \(SAVE-GROUPS\)\)\)\)
                \(PROMPT-2 . \(\(default . \(INITIAL-VALUES\)\)
                             \(filter  . \(EXCLUDED-CONFS\)\)
                             \(save    . \(SAVE-GROUPS\)\)\)\)
                ...\)\)

COMMAND is the name of a LysKOM or Emacs command. PROMPT-1 and
PROMPT-2 \(there can be any number of prompts liste in a single
command\) are symbols representing the prompt. These are defined
in lyskom-messages in swedish-strings.el and english-strings.el. 

INITIAL-VALUES are functions to call to generate a list of possible
initial values for the prompt. These functions must return lists of
conference numbers. EXCLUDED-CONFS are functions that are called to
eliminate possible initial values. These must take a single argument,
an uconf-stat, and should return the uconf-stat itself if it is a
valid candidate for the initial value, or nil if it is not. Finally,
SAVE-GROUPS are symbols under which the value the user inputs will be
saved.

As a special case, a list in INITIAL-VALUES is interpreted as a
function with arguments. The first element in the list is applied to
the remaining elements.

If `t' is used for COMMAND, it indicates the default to use when no
COMMAND listed matches the current command. If `t' is used for PROMPT,
it indicates defaults, filters and save groups to use when no other
PROMPT matches.


Some useful functions for INITIAL-VALUES are:

lyskom-default-conference-at-point returns the conference shown where
point is. If point is on a conference name, that name will be used as
the initial value.

lyskom-default-conference-current returns the current conference.

lyskom-default-conference-self returns the logged-in person.

lyskom-default-conference-last-author returns the author of the most
recently read text.

lyskom-default-conference-saved returns saved input. This must be
specified as a list in INITAL-VALUES, where the argument (second
element of the list) is the symbol under which the input was saved,
from \(SAVE-GROUPS\) in one or more commands.


Some useful functions for EXCLUDE-CONFS are:

lyskom-default-conference-not-self excludes the logged-in person.

lyskom-default-conference-not-current excludes the current conference.


The format of this variable may change in the future.
")


(defconst kom-old-farts-text-prompt-strategy
  '((kom-comment-previous (nil lyskom-get-previous-text))
    (kom-view-previous-commented-text (nil lyskom-get-previous-text))
    (kom-private-answer-previous (nil lyskom-get-previous-text))
    (t  (t   lyskom-get-last-read-text)
        (nil     lyskom-get-last-read-text)
        (0       lyskom-get-text-at-point)
        (lyskom-eq-dash   (lambda () (lyskom-get-text-above-point 1)))
        (listp   (lambda () (lyskom-tnpa-prompt (lyskom-get-last-read-text))))
        (plusp   current-prefix-arg)
        (minusp  (lambda () (lyskom-get-text-above-point (- current-prefix-arg))))))
"Put in your `kom-pick-text-no-strategy-alist' to get the 0.46 behaviour:
 * No prefix argument refers to the most recently read text.
 * The prefix argument zero refers to the text under point.
 * A positive prefix argument is interpreted as a text-no.
 * A negative prefix argument will try to find the text-no
   of the text `arg' messages above point from the current
   kom buffer.")

(defconst lyskom-old-farts-text-prompt-strategy
  kom-old-farts-text-prompt-strategy
  "Obsolete: Alias for kom-old-farts-text-prompt-strategy.")

(def-kom-var kom-pick-text-no-strategy-alist
  '(

    ;; Abstract specifications

    (read-or-written
     (t   (lambda () (lyskom-tnpa-prompt (lyskom-get-text-at-point))))
     (nil lyskom-get-text-at-point
          (lambda () (lyskom-tnpa-valid
                      (lyskom-tnpa-prompt (lyskom-get-last-written-or-read-by-me))))
          :constraint lyskom-text-written-by-me-p))
    (previous-text (nil lyskom-get-previous-text))
    (commented-text (nil lyskom-maybe-get-commented-text))
    (footnoted-text (nil lyskom-maybe-get-footnoted-text))

    ;; Specifications for actual commands

    (kom-comment-previous             :refer previous-text)
    (kom-view-previous-commented-text :refer previous-text)
    (kom-unread-previous-commented-text :refer previous-text)
    (kom-private-answer-previous      :refer previous-text)
    (kom-sub-comment                  :refer commented-text)
    (kom-sub-footnote                 :refer footnoted-text)
    (kom-write-footnote               :refer read-or-written)
    (kom-add-no-comments              :refer read-or-written)
    (kom-add-private-answer           :refer read-or-written)
    (kom-add-request-confirm          :refer read-or-written)

    ;; Default specification

    (t (nil     lyskom-get-text-at-point)
       (0       (lambda () (lyskom-tnpa-prompt (lyskom-get-text-at-point))))
       (lyskom-eq-dash (lambda () (lyskom-get-text-above-point 1)))
       (car     (lambda () (lyskom-get-text-at-point-ancestor (/ (logb (car current-prefix-arg)) 2))))
       (plusp   (lambda () (lyskom-get-text-below-point current-prefix-arg)))
       (minusp  (lambda () (lyskom-get-text-above-point (- current-prefix-arg))))
       (t       (lambda () (lyskom-tnpa-prompt (lyskom-get-text-at-point))))
       :constraint nil
       :filter  nil
       )
    )
  "**Defines how prefix arguments are used by commands to find a text to operate on.

The format of this list is as follows:

<
\((FN-KEY . ((PFX-KEY-1 . (FN1 FN2 ... PROP1 VAL1 PROP2 VAL2 ...)) 
            (PFX-KEY-2 . (FN1 FN2 ... PROP1 VAL1 PROP2 VAL2 ...))
            GPROP1 GVAL1
            GPROP2 GVAL2
            ...))
 ...)
>

`FN-KEY' is the name of a command, `t' or a symbol that does not
correspond to any function. Keys corresponding to commands indicate
configuration for that command. The `t' key indicates fallback
condiguration that applies to all commands, unless overridden by a
command-specific configuration. Other keys can be referenced from
command-specific configurations.

`PFX-KEY' is a key that indicates a prefix. If it is an atom not bound
to a function, it indicates configuration for prefix arguments eq to
the atom \(e.g. 0, - or `nil'). The special key `t' indicates fallback
configuration, used when all prefix-specific configurationas failed to
generate valid values.

`FN' is a function or variable used to generate lists of text numbers.
If a variable name, the value of the variable is used to generate a
list of text numbers. If a function, the function is called with no
arguments, and is expected to return a list of text numbers.

`PROP' is a property name \(see below) and VAL is the corresponding
value. Properties defined at the inner level apply only to results
generated for that prefix. Properties defined at the outer level apply
irrespective of prefix arguments. Properties defined in the default
element \(with `FN-KEY' set to `t'\) always apply, unless overridden by
non-nil properties in command-specific elements.

The following properties are available:

    Key             Value
    ------------------------------------------------------------------
    `:filter'       A function that is called on all text numbers. The
                    filter function is expected to return a new or 
                    modified text number. This can be used to indicate 
                    that the command should prompt or bypass the 
                    constraint.
    
    `:constraint'  A function that is called on all text numbers. It 
                   should return non-nil for text numbers that are 
                   valid for the command.
    
    `:refer'       A symbol indicating a configuration to use. Useful 
                   when several commands share the same (complex)
                   configuration. May not be used in the default 
                   element.
    ------------------------------------------------------------------


The following filter functions may be useful:

    Name                    What it does
    ------------------------------------------------------------------
    `lyskom-tnpa-prompt'    Prompt the user for the text number. The 
                            number used as the argument will be the 
                            default. 
    
    `lyskom-tnpa-valid'     Declare that the text number is valid, 
                            regardless of any constraint functions.
    ------------------------------------------------------------------

When `lyskom-read-text-no-prefix-arg' is called, this list is searched
both for a command-specific element and for the default element. Any
`:refer' links are resolved in the command-specific element. The
filter and constraint properties are extracted. These elements are
then searched for prefix-specific elements that match the current
prefix argument. The first text number that is generated that passes
the filter and constraint functions is used as the text number
argument for the command."
)

(def-kom-var kom-url-transformation-rules 
  '(
    ("^http://[^/]*aftonbladet\\.se/.*/story/.*html?$" . "\\&.")
    )
  "**An alist specifying transformations to be applied to URLs.

Elements in this list are of the form \(`PATTERN' . `REPLACEMENT').
Before an URL is opened, it is transformed by matching the URL against
each `PATTERN' in turn, and when a match is found, generating a new
URL according to `REPLACEMENT'.

All characters in `REPLACEMENT' except \\ are copied verbatim. The
backslash character starts one of the following sequences:

    Sequence    Meaning
    ---------------------------------------------------------------
    `\\&'        Substitute the matched text

    `\\N'        Substitute match for text matching the Nth (...)
                group in `PATTERN'

    `\\\\'        Insert one backslash.
    ---------------------------------------------------------------
"
  server
  )


(def-kom-var kom-check-configuration-on-startup t
  "**When non-nil, check Emacs configuration on client startup.

Valid values for this variable are `t' and `nil'. All other values are
reserved for future extensions. When non-nil, several checks will be
performed:

* Check that multibyte character support is enabled, if available.

* Check that the character coding Emacs uses matches the coding system
  used by the server.

Warnings will be shown in the LysKOM buffer on logon.
")


(def-kom-var kom-keyboard-menu-immediate-selection nil
  "**Controls how keyboard menus work.

When displaying text-based menus (typically by pressing the `=' key
when the cursor is on an active area), there are two modes of
selection. Setting this variable to `t' means pressing the letter
corresponding to an item selects that item. When this variable is
`nil', selection has to be confirmed by pressing enter.

Values other tha `t' and `nil' are reserved for future use."
  server)


(def-kom-var kom-edit-hide-add-button nil
  "**Controls the \"add\" button in the edit buffer.

When set to `t', hide the add button shown after the headers when
editing a text. When set to `nil' (the default), show the button.

Values other than `t' and `nil' are reserved for future use."
  server
)

(def-kom-var kom-max-overlays 120
  "**Maximum number of overlays to use to highlight texts.

When a text is displayed with its own background color (see
`kom-highlight-text-body', `kom-highlight-first-line',
`kom-highlight-dashed-lines', `kom-async-highlight-text-body' and
`kom-async-highlight-dashed-lines') one or more overlays are created.
Since a large number of overlays has a serious impact on performance,
the total number of overlays in the buffer can be limited using this
variable.

When set to a positive integer, limit the number of overlays to that
number. When set to `nil', do not limit the number of overlays. Values
other than a positive integer and `nil' are reserved for future use
and may cause unpredictible results."
  server
)

(def-kom-var kom-highlight-text-body t
  "**Controls highlighting of text bodies.

If `t', overlay `kom-text-body-face' on printed text bodies in LysKOM.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than `t' or `nil' are reserved for future use.

See `kom-max-overlays' for information on how to limit the number of
overlays."
  server
)

(def-kom-var kom-highlight-first-line t
  "**Controls highlighting of the first line of text headers.

If `t', overlay `kom-first-line-face' on the first header line of
texts. When this is enabled, an overlay or extent will be created that
may override certain aspects of the underlying text's formatting.
Values other than `t' or `nil' are reserved for future use.

See `kom-max-overlays' for information on how to limit the number of
overlays."
  server
)

(def-kom-var kom-highlight-dashed-lines t
  "**Controls highlighting of dashed lines around texts.

If `t', overlay `kom-dashed-lines-face' on the lines surrounding
texts. When this is enabled, an overlay or extent will be created that
may override certain aspects of the underlying text's formatting.
Values other than `t' or `nil' are reserved for future use.

See `kom-max-overlays' for information on how to limit the number of
overlays."
  server
)

(def-kom-var kom-async-highlight-text-body t
  "**Controls highlighting of asynchronous messages.

If `t', overlay `kom-async-text-body-face' on asynchronous messages in
LysKOM. When this is enabled, an overlay or extent will be created
that may override certain aspects of the underlying text's formatting.
Values other than `t' or `nil' are reserved for future use.

See `kom-max-overlays' for information on how to limit the number of
overlays."
  server
)

(def-kom-var kom-async-highlight-dashed-lines t
  "**Controls highlighting of dashed lines around asynchronous messages.

If `t', overlay `kom-dashed-lines-face' on the lines surrounding
messages. When this is enabled, an overlay or extent will be created
that may override certain aspects of the underlying text's formatting.
Values other than `t' or `nil' are reserved for future use.

See `kom-max-overlays' for information on how to limit the number of
overlays."
  server
)

(def-kom-var kom-extended-status-information nil
  "**Controls display of extra information when displaying LysKOM objects.

If `t', extended status information is listed for all objects in
LysKOM. If set to an association list, each element is a pair of tag
and value. The tag specifies a type of extended information. If the
corresponding value is `t', the information is shown. If the
corresponding value is `nil', the information is not shown.

Valid tags are:

    Tag                   Meaning
    ------------------------------------------------------------------
    `conf'                Show all extended information for conferences

    `pers'                Show all extended information for persons

    `server'              Show all extended information for the server

    `read-faq'            Show read FAQs

    `raw-server-stats'    Show raw server statistics

    `raw-boottime-info'   Show raw boot-time server information

    `t'                   Any information not explicitly listed
    ------------------------------------------------------------------

The information controlled by this variable is the kind of data that
most users are not interested in, and, if displayed, would make more
important information hard to find.

Currently this includes read FAQs (for letterboxes) and full
statistics and boot-time information (for the server).

Values other than those specified are reserved for future extensions."
server )

(def-kom-var kom-auto-list-faqs t
  "**Controls automatic display of FAQs.

When this variable is set to `t', list unread FAQs when entering a
conference or logging on to the server. When entering a conference,
list FAQs for that conference that have not been read. When logging
on, list FAQs for the server that have not been read.

Values other than `t' or `nil' are reserved for future extension."
  server
)

(def-kom-var kom-auto-review-faqs t
  "**Controls automatic review of FAQs.

When set to `t', automatically review unread FAQs when entering a
conference or logging on to the server. When entering a conference,
FAQs that are unread for that conference will be reviewed. When
logging on, FAQs that are unread for the server will be reviewed.

Values other than `t' or `nil' are reserved for future use."

  server
)

(def-kom-var kom-allow-incompleteness nil
  "**Allow or disallow operation on incomplete membership information.

If `nil', commands like `kom-list-news' will wait for all membership
information to be read. If this flag is set to `t', commands will not
wait for all membership information. Not waiting for complete
information allows certain commands to execute faster, particularly
during the login phase, but may result in incorrect or incomplete
answers.

Values other than `t' or `nil' are reserved for future use."
  server
)

(def-kom-var kom-bury-buffers t
  "**Controls the behaviour of `kom-next-kom' and its cousins.

If this variable is `t' the current buffer is sent to the back of the
buffer list when one of the commands `kom-next-kom',
`kom-previous-kom' or `kom-next-unread-kom' is invoked.

Values other than `t' or `nil' are reserved for future use."
  server)

(def-kom-var kom-write-texts-in-window nil
  "**Determines where to edit texts.

The value must be one of `nil', `other', `new-frame', `other-frame', a
string or a buffer.

When set to `nil', edit texts in the same window as the LysKOM buffer.
When set to `other', edit in another window, creating it if necessary.
When set to `other-frame', edit in another frame, if there is one
\(otherwise edit in the same window as the LysKOM buffer). When set to
`new-frame', create a new frame for editing. This frame will be
removed when editing is finished. A string means edit in the buffer
with that name. A buffer means edit in that buffer."
  server)

(def-kom-var kom-view-commented-in-window 'other
  "**Where to view commented texts. 

See the documentation for `kom-write-texts-in-window' for details."
  server)

(def-kom-var kom-edit-filters-in-window nil
  "**Where to edit filters with `kom-filter-edit'.

See the documentation for `kom-write-texts-in-window' for details."
  server)

(def-kom-var kom-list-membership-in-window 'other
  "**Where to list membership with `kom-list-membership'.

See the documentation for `kom-write-texts-in-window' for details."
  server)

(def-kom-var kom-personal-messages-in-window 'other
  "**Where to display personal messages. 

See the documentation for `kom-write-texts-in-window' for details."
  server)

(def-kom-var kom-customize-format 'long
  "**Determines the format of the customize buffer.

This variable currently only controls initial display of documentation
in the customize buffer (the buffer shown by `kom-customize'. When set
to the symbol `long', display documentation. When set to the symbol
`short', don't display documentation.

Values other than `long' or `short' are reserved for future use."
  server)

(def-kom-var kom-user-prompt-format "%[%c% %m%] - "
  "**Format of LysKOM prompt when waiting for input.

The value of this variable must be a string, which is displayed as the
LysKOM prompt, while waiting for a command. The string may contain the
following special sequences:

    Sequence      Meaning
    -----------------------------------------------------------------
    `%c'          Inserts the current default command.

    `%['          Inserts `[' if the ansaphone is on.

    `%]'          Inserts `]' is the ansaphone is on.

    `%m'          Inserts information about recorded messages.

    `%s'          Inserts the name of the LysKOM system

    `%S'          Inserts the server name.

    `%p'          Inserts the name of the user currently logged on.

    `%w'          Inserts the name of the current conference.

    `%a'          Inserts `anonymous' in the current language.

    `%A'          Inserts `Anonymous' in the current language.

    `%#'          Inserts the current session number.

    `% '          Inserts a space if it seems necessary (percent SPC).

    `%%'          Inserts a percent sign.
    -----------------------------------------------------------------

Here are a few examples:

    Format string                 What it does
    -----------------------------------------------------------------
    `\"%[%c% %m%] - \"'           The default prompt

    `\"%[%s: %c% %m%] - \"'       Could display \"LysKOM: Time - \"
    -----------------------------------------------------------------

Note that multiline prompts are not supported."
  server)


(def-kom-var kom-user-prompt-format-executing "%[%c% %m%]."
  "**Format of LysKOM prompt when executing a default command.

The value of this variable must be a string. See
`kom-user-prompt-format' for details."
  server)


(def-kom-var kom-enabled-prompt-format "%[%c% %m%] # "
  "**Format of LysKOM prompt when privileges are enabled..

The value of this variable must be a string. See
`kom-user-prompt-format' for details."
  server)


(def-kom-var kom-enabled-prompt-format-executing "%[%c% %m%]."
  "**Format of LysKOM prompt when executing a default command when
privileges are enabled. 

The value of this variable must be a string. See
`kom-user-prompt-format' for details."
  server)

(def-kom-var kom-anonymous-prompt-format "%[%c% %m%] (%a) - "
  "**Format of the LysKOM prompt when running anonymously.

The value of this variable must be a string. See
`kom-user-prompt-format' for details. See `kom-become-anonymous' for
information on anonymous mode.
"
  server)

(def-kom-var kom-anonymous-prompt-format-executing "%[%c% %m%] (%a)."
  "**Format of the LysKOM prompt when executing a command anonymously.

The value of this variable must be a string. See
`kom-user-prompt-format' for details. See `kom-become-anonymous' for
information on anonymous mode."
  server)

(def-kom-var kom-show-week-number t
  "**Controls display of week numbers in `kom-display-time'.

If set to `t' show the ISO week number when displaying the time. If
set to `nil', don't display the time. All other values are reserved
for future use.

For this feature to work, the calendar package must be installed."
  server)


(def-kom-var kom-cite-string ">"
  "**String to insert before each line of a commented text.

When citing a text in edit-mode, this string will be inserted before
each line. Although citing is not common and usually not useful in
LysKOM, there is occasionally reason to cite a commented text."
  server)

(def-kom-var kom-created-texts-are-saved nil
  "**If non-nil, save all created texts to a file. 

The value of this variable is the file name on which to save new
texts. Each time a text is created, it is appended to this file.
Values other than a string may produce unpredictible results, and are
reserved for future extensions."
  server
  inherited)

(def-kom-var kom-created-texts-are-read nil
  "**non-nil means automatically mark texts that you create as read.

When set to `t', all text you write are automatically marked as read,
except when running in anonymous mode. When set to `nil', your texts
will be shown as all others.

Values other than `t' and `nil' are reserved for future extensions."
  common created-texts-are-read boolean)

(def-kom-var kom-mark-read-texts-as-read-in-new-recipient t
  "**Controls whether to mark read texts as read in new recipients the acquire.

When this is set to `t', silently mark texts as read when they are
added to a new recipient, if they have been read in any conference.
When `nil', do not mark as read. This feature only works when you are
logged on. Texts added to new conferences while you are not logged on
will not be marked as read in the new recipient.

Values other than `t' or `nil' are reserved for future extensions."
  server)

(def-kom-var kom-customize-in-window nil
  "**Where to customize LysKOM with `kom-customize'.

See the documentation for `kom-write-texts-in-window' for details."
  server)

(def-kom-var kom-prioritize-in-window nil
  "**Where to prioritize conferences with `kom-prioritize'.

See the documentation for `kom-write-texts-in-window' for details."
  server)

(def-kom-var kom-default-mark nil
  "**The default mark used by `kom-mark-text'.

When set to an integer, `kom-mark-text' will not ask for a mark, but
simply mark with that number. When set to `nil', `kom-mark-text' will
ask for a mark.

Values other than integers and `nil' are reserved for future use."
  common default-mark integer
  server)

(def-kom-var kom-symbolic-marks-alist '(("Standard" . 100))
  "**Association list that maps symbolic marks to mark numbers.

Internally, texts can only be marked with numbers. The elisp client
implements symbolic marks through this mapping from mark names to
numbers. Each element of this list is a pair \(`NAME' . `MARK'), where
`NAME' is the name of the mark, and `MARK' is the corresponding
numeric mark."
  server)

(def-kom-var kom-reading-puts-comments-in-pointers-last t
  "**Controls the location where comment pointers are shown.

When set to `t', comment references are shwon at the end of texts.
When set to `nil', comment references are shwon in the headers.

`kom-reading-puts-comments-in-pointers-last' set to `nil'

<
    398331 1996-09-24  13:22  /2 lines/ George Berkeley
    Recipient: Philosophy <1226>
    Comment in text 398374 by John Locke
    Subject: 
    ------------------------------------------------------------
    An abstract idea is a contradiction in terms.
    (398331) -----------------------------------
>

`kom-reading-puts-comments-in-pointers-last' set to `t'

<
    398331 1996-09-24  13:22  /2 lines/ George Berkeley
    Recipient: Philosophy <1226>
    Subject: 
    ------------------------------------------------------------
    An abstract idea is a contradiction in terms.
    (398331) -----------------------------------
    Comment in text 398374 by John Locke
>
"
  common reading-puts-comments-in-pointers-last boolean
  inherited)

(def-kom-var kom-review-uses-cache t
  "**Controls whether review commands use the cache or not.

When set to `t', review commands (such as `kom-review-by-to') will get
texts from the client cache, if possible. This improves performance,
but texts may have changed since they were cached. When set to `nil',
review commands will always get texts from the server.

Values other than `t' and `nil' are reserved for future use."
  server
  inherited)

(def-kom-var kom-review-marks-texts-as-read nil
  "**Controls whether viewing texts with review commands marks then as read.

When set to `t', viewing texts with review commands (e.g.
`kom-review-by-to') will mark unread texts as read. When set to `nil',
texts are not marked as read. 

It is possible to change this setting for a single review command with
the key sequence for `kom-toggle-mark-as-read-prefix'. The value can
be changed for the entire session by using
`kom-make-review-mark-as-read' or `kom-make-review-not-mark-as-read'.

Values other than `t' and `nil' are reserved for future use."
  server
  inherited)

(def-kom-var kom-postpone-default 17
  "**The default number of texts to postpone with `kom-postpone'.

The value of this variable must be a positive integer or zero. All
other values are reserved for future use."
  server)


(def-kom-var kom-dashed-lines t
  "**Controls display of dashed lines before and after texts.

when set to `t' display dashed lines. When set to `nil', don't display
dashed lines.

`kom-dashed-lines' set to `t'

<
    892343 1996-09-24  19:21  /2 lines/ Tycho Brahe
    Recipien: Presentation (of new) Members
    Subject: Tycho Brahe
    ------------------------------------------------------------
    Astronomer and discoverer of stars resident on the island of Ven.
    (892343) -----------------------------------
>

`kom-dashed-lines' set to `nil'

<
    892343 1996-09-24  19:21  /2 lines/ Tycho Brahe
    Recipien: Presentation (of new) Members
    Subject: Tycho Brahe

    Astronomer and discoverer of stars resident on the island of Ven.
    (892343)
>

Values other than `t' and `nil' are reserved for future use. 

See `kom-highlight-dashed-lines' and
`kom-async-highlight-dashed-lines' for additional settings that affect
these lines."
  common dashed-lines boolean
  inherited)

(def-kom-var kom-long-lines nil
  "**If non-nil, some lines and borders will be made longer.

When set to `t', most dashed lines will be longer than the default.
When set to `nil',  use the standard length.

See `kom-text-footer-dash-length', `kom-text-header-dash-length' and
`kom-text-footer-format' for other related settings."
  server
  inherited)

(def-kom-var kom-text-footer-dash-length 52
  "**Control the length of the text footer.

When dashed lines (see `kom-dashed-lines') are in effect, and this is
set to a positive integer, make the text footer at least that many
characters long. Values other than a positive integer are reserved for
future use.

Note that the footer may end up longer than this if one or more elements
together are longer than this length.

This length is currently ignored when `kom-text-footer-format' is used."
  server
  inherited)

(def-kom-var kom-text-header-dash-length 60
  "**Control the length of the text footer.

When dashed lines (see `kom-dashed-lines') are in effect, and this is
set to a positive integer, make the dashed line before the text that
many characters long. 

Values other than a positive integer are reserved for future use."
  server
  inherited)



(def-kom-var kom-text-footer-format nil
  "**Defines the format of the text footer.

When set to a string, use that string as the text footer, overriding
all other settings that affect the text footer. The string may contain
the following special sequences:

    Directive     Meaning
    -------------------------------------------------------------
    `%n'          Insert the text number

    `%p'          Insert the number of the author

    `%P'          Insert the name of the author

    `%-'          Insert a bunch of dashes

    `%f'          Insert special formatting information
    -------------------------------------------------------------

Format directives can be prefixed with a number specifying the minimum
field width (e.g. `%20-'. The field width can be prefixed with an
equals sign (e.g. `%=20p' which means that the field is exactly as
wide as specified (contents may be truncated). A negative field width
means left justify the contents.

The field width of %- is special. It specifies the maximum number of
dashes printed. The actual number will be the maximum minus the length
of the author's name, if it is included anywhere in the format string.

When set, this variable overrides `kom-dashed-lines' and
`kom-show-author-at-end'.

The default format is equivalent to the following strings, depending on 
the settings of kom-dashed-lines and kom-show-author-at-end.

    `kom-dashed-lines'  `kom-show-author-at-end'   Format
    --------------------------------------------------------------------
    `t'                  `t'                       `\"(%n) /%P/%42-%f\"'

    `t'                  `nil'                     `\"(%n) %42-%f\"'

    `nil'                `t'                       `\"(%n) /%P/ %f\"'

    `nil'                `nil'                     `\"(%n) %f\"'
    --------------------------------------------------------------------
"
  server
  inherited)



(def-kom-var kom-show-creating-software nil
  "**Controls display of the software used to create each text.

When creating a text, it is possible to attach information about which
client was used to create the text. When this variable is set to `t',
this information, when available,  is displayed in all text headers.
When this variable is set to `nil', the information is not shown.

To display creating software for a text when this is off, review the
text using `kom-review-noconversion'.

Values other than `t' and `nil' are reserved for future use."
  server
  inherited)

(def-kom-var kom-show-author-at-end t
  "**Controls display of author information in the text footer.

When this is set to `t', display the author of each text immediately
after the text. When set to `nil', the author is not displayed.

`kom-show-author-at-end' set to `t' (with dashed lines on):

<
  892342 1996-09-24  19:21  /2 lines/ Claude Shannon
  Mottagare: Presentation (of new) Members
  rende: Claude Shannon
  ------------------------------------------------------------
  Information theoretician
  (892342) /Claude Shannon/------------------------------
>

`kom-show-author-at-end' set to `nil':

<
  892342 1996-09-24  19:21  /2 lines/ Claude Shannon
  Recipient: Presentation (of new) Members
  Subject: Claude Shannon
  ------------------------------------------------------------
  Information theoretician
  (892342) -----------------------------------
>

If `kom-text-footer-format' is set, the value of this variable is
ignored. Values other than `t' and `nil' are reserved for future use."
  server
  inherited)

(def-kom-var kom-truncate-threshold nil
  "**Controls truncation of text when reviewing.

When set to a positive integer, truncate long texts when reviewing. If
the text has more lines than the value of this variable, it will be
truncated to `kom-truncate-show-lines' lines. When a message is
truncated, a note to that effect will be shown in the message footer
unless `kom-text-footer-format' has been set to a string that does not
include the `%f' directive.

When set to `nil', no truncation will occur. Values other than
positive integers and `nil' are reserved for future use."
  server)

(def-kom-var kom-truncate-show-lines 10
  "**Number of lines to display when truncating texts.

The value must be a positive integer. When a text is truncated \(see
`kom-truncate-threshold', the minimum of `kom-truncate-threshold' and
`kom-truncate-show-lines' determines the number of lines to show.

Values other than positive integers are reserved for future use."
  server)


(def-kom-var kom-print-number-of-unread-on-entrance t
  "**Controls display of number of unread when entering a conference.

When set to `t', the number of unread texts in a conference is
displayed when entering that conference. When set to `nil', the number
of unread texts is not shown. Shortly after logging on, using
`kom-set-unread' or using `kom-recover', the number shown may be
incorrect.

Values other than `t' and `nil' are reserved for future use."
  common print-number-of-unread-on-entrance boolean)

(def-kom-var kom-show-unread-in-frame-title t
  "**Controls display of the unread indicator in the frame title.

When set to `t', an indicator will be shown in the title of each frame
containing a selected LysKOM session with unread texts. When set to
`nil' no indicator will be shown.

Values other than `t' and `nil' are reserved for future extensions."
  server)

;; In the common block of the user-area is a simple boolean variable
;; `presence-messages'.  The control of presence messages in the Emacs
;; Lisp client is more advanced, using two non-boolean variables instead
;; (`kom-presence-messages-in-echo' and `kom-presence-messages-in-buffer').
;;
;; Keep track of the common block variable too, although it isn't used here.
;; `lyskom-save-options' sets it before saving it in obvious cases,
;; but generally it's not possible to know what value it should have.
;; (It could also be used for default values for the presence options for
;; users converting from another client, but that isn't done.)

(def-kom-var kom-presence-messages t
  "Equivalent to the variable `presence-messages' in the user-area.
This is a boolean where other clients may store whether the user wants
messages about people logging in and out of LysKOM.  Here this is instead
controlled by `kom-presence-messages-in-echo-area' and
`kom-presence-messages-in-buffer', so only use this variable to
influence what this client stores in the common block of the user-area."
  common presence-messages boolean)

(def-kom-var kom-presence-messages-in-echo-area t
  "**Controls display of presence messages in the echo area.

If non-nil, LysKOM prints continuous info about what other people
are doing. Info is printed on the echo area and never in the buffer.
If minibuffer is used, no message is printed.

A list of integers means show messages for those users.

The value `friends' means show messages for the users in `kom-friends'.

The value `morons' means show messages for the users in `kom-morons'.

The value `friends-and-morons' means show messages for the users in 
`kom-friends' and `kom-morons'.

If you want the messages in the buffer, set the variable 
`kom-presence-messages-in-buffer'.

Values other than those listed are reserved for future use."
  server)

(def-kom-var kom-unread-mode-line-type nil
  "**Controls how information about unread sessions is shown in the mode line.

If this variable is `nil', there will be a single prompt indicating
whether you have unread texts or letters in any active session.

If this variable is `t', the mode line will indicate each session with
unread texts. Unread letters are indicated by upper-casing the session
name or (if the session name is in upper case already) surrounding it
with asterisks.

All other values are reserved for future use."
  )



(def-kom-var kom-presence-messages-in-buffer nil
  "**Controls display of presence messages in the LysKOM buffer.

If non-nil, LysKOM prints information about what other people are
doing in the LysKOM buffer. All printing is done just before the
prompt.

If `nil' no messages are printed. If `presence', messages about people
logging in, out and people changing name are printed.

All other values are reserved for future use."
  server)

(def-kom-var kom-show-where-and-what t
  "**Controls display of hostname and activity information in `kom-who-is-on'. 

When this is set to `t', `kom-who-is-on' and related commands will
display the machine the session is connected from and what the user is
doing. When set to `nil', this information will not be shwon.

Listing frmo `kom-who-is-on' with `kom-show-where-and-what' set to `t':

<
      User                                   Is in conference             
      At                                     Activity                        
  --------------------------------------------------------------------------
   6810 George Berkeley                      Philosophy                     
        berkeley@emp1.tcd.ie                 (Writing a comment.)           
   7571 John Locke                           Philosophy                     
        eridy@cc.ox.ac.uk                    (Waiting.)                     
  --------------------------------------------------------------------------
>

Listing frmo `kom-who-is-on' with `kom-show-where-and-what' set to `nil':

<
      User                                   Is in conference             
  --------------------------------------------------------------------------
   6810 George Berkeley                      Philosophy                     
   7571 John Locke                           Philosophy
  --------------------------------------------------------------------------
>

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-show-since-and-when nil
  "**Controls display of connection time in `kom-who-is-on'.

When set to `t', `kom-who-is-on' and related commands will display the
time when each session connected to the server and when each session
last indicated activity.

Listing frmo `kom-who-is-on' with `kom-show-since-and-when' set to `t':

<
        User                                 Is in conference             
        Connected                            Active last                  
  --------------------------------------------------------------------------
   6810 George Berkeley                      Philosophy                     
        Thursday 2003-01-09 09:24:56         Active                         
   7571 John Locke                           Philosophy                     
        Saturday 2003-01-11 14:02:47         12 minutes                     
  --------------------------------------------------------------------------
>

Listing frmo `kom-who-is-on' with `kom-show-since-and-when' set to `nil':

<
        User                                 Is in conference             
  --------------------------------------------------------------------------
   6810 George Berkeley                      Philosophy                     
   7571 John Locke                           Philosophy
  --------------------------------------------------------------------------
>

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-idle-hide 30
  "**Controls display of idle sessions in `kom-who-is-on'.

When set to a positive integer, the number of minutes of idletime
before a user is excluded from the list of users shown by
`kom-who-is-on' and related commands. This can be overridden by a
prefix argument to these commands. When set to `nil', do not hide idle
sessions.

Variables other than positive integers and `nil' are reserved for
future use."
  server)

(def-kom-var kom-show-footnotes-immediately t
  "**Controls display of footnotes.

When set to `t', footnotes will be displayed immediately following the
text. When set to `nil', footnotes will be displayed like regular
comments.

Values other than t and `nil' are reserved for future use."
  server)

(def-kom-var kom-follow-comments-outside-membership nil
  "**Controls display of comments in conferences you are not a member of.

If this variable is set to `nil', texts with no recipient you are a
member of will be ignored when selecting comments to display when
reading. When set to `t', the client will follow comment links
regardless of whether you are a member of any of the recipients of the
comment.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-follow-attachments t
  "**Controls how attachments to imported e-mail messages are handled.

When this is set to `t', attachments are followed like regular
comments. When set to `nil', attachments are not followed. To see them
you have to review them manually.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-read-depth-first t
  "**Determines the order in which to read texts.

When set to `t' \(the default), texts are read in comment order. When
set to `nil', texts are read in chronological order.

When reading in comment order, the next text to read is the first
comment of the most recently read text. If there are no comments, the
next text is a comment to another text. Reading in comment order lets
you view threads of discussion.

Values other than `t' or `nil' are reserved for future use."
  common read-depth-first boolean)

(def-kom-var kom-continuous-scrolling t
  "**Controls frequency of scrolling.

When set to `t', the LysKOM buffer is scrolled whenever text is
inserted. The last viewed position \(usually the most recent prompt)
will always be visible.

When set to `nil', scrolling takes place less frequently. This is
a suitable setting when running Emacs over a slow link, such as an old
modem.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-deferred-printing t
  "**Controls background display of non-cached information.

When set to `t', delay display of \(some) information that has to be
retreived from the server. A placeholder is shown where the
information will be printed, until it is available. This setting
results in a significant improvement in interactive performance.

When set to `nil', do not delay display of any information. This
lowers interactive performance, but may be suitable when running Emacs
over a slow connection.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var lyskom-overlay-pool nil  
  "Pool of overlays"
  local)

(def-kom-var lyskom-defer-indicator "[...]"
  "String to display while LysKOM is waiting for the real string.")

(def-kom-var kom-review-priority nil
  "**Priority to use when reviewing texts.

When set to a positive integer, use that as the priority to use when
reviewing texts. By setting `kom-review-priority' higher than 255 (the
maximum conference priority), new texts to conferences will not break
in while reviewing.

If set to `nil', use the current priority while reviewing. This allows
texts to conferences with priorities higher than that of the current
conference to break in while reviewing (depending on the setting of
`kom-higher-priority-breaks').

Values other than positive integers and `nil' are reserved for future
use."
  server)

(def-kom-var kom-higher-priority-breaks nil
  "**Controls how conference priorities are handled.

When set to `express', texts to conferences with a higher priority
than the current conferences will be shown as soon as the arrive. When
set to `t', texts to prioritized conferences will be shown after the
current comment tree. When set to `nil', prioritized conferences will
be visited when all texts in the current conference have been read.

Values other than `express', `t' and `nil' are reserved for future
use."
  server)

(def-kom-var kom-server-priority-breaks nil
  "**Controls how server priorities are handled.

A non-nil value allows servers with a higher priority than the
current server to break in when new texts arrive. This can be used to
give a work-related server a higher priority than a server used for
frivolous purposes (or, indeed, the other way around).

The following settings are available:

  Value                 Meaning
  --------------------------------------------------------------------
  `express'             Break in immediately when there are unread
                        texts.

  `express-letters'     Break in immediately when there are unread
                        letters.

  `t'                   Break in after the current comment chain when
                        there are unread texts.

  `letters'             Break in after the current comment-chain when
                        there are unread letters.

  `after-conf'          Break in after the current conference when
                        there are unread texts.

  `after-conf-letters'  Break in after the current conference when
                        there are unread letters.

  `when-done'           Prompt the user to go to the next session with
                        unreads after everything has been read. This
                        overrides `kom-do-when-done' as long as there
                        are sessions with unread texts. 
  --------------------------------------------------------------------

Values other than those listed above are reserved for future use and
may result in unpredictible behavior.

See `kom-server-priority' for information on setting the server
priority."
  server)


(def-kom-var kom-session-nickname nil
  "**Nickname for the current LysKOM session.

This variable contains the name of the current LysKOM session (a string)
or `nil'. If set, it will be used as the nickname for this LysKOM session.

See also `kom-server-aliases' and `kom-builtin-server-aliases'."
  server)

(def-kom-var kom-view-text-hook nil
  "**Hook that is called before a text is shown. 

When the hooks are called, `kom-view-text-text' is bound to the text
mass of the text and `kom-view-text-text-stat' to the text-stat of the
text to be shown."
  local-hook)

(def-kom-var lyskom-view-text-hook nil
  "Obsolete synonym for kom-view-text-hook."
  local-hook)


(def-kom-var lyskom-send-message-hook nil
  "Obsolete synonym for lyskom-send-message-hook."
  local-hook)

(def-kom-var kom-send-message-hook '(lyskom-send-message-trim-newlines)
  "**Hook that is called before a personal, group or common message is sent. 

When called, `lyskom-message-string' is bound to the message that will
be sent and `lyskom-message-recipient' to the conf-stat of the
recipient or nil if the recipient does not exist or if the message is
a common message.

If `lyskom-message-string' is set to nil by a hook, the message will not
be sent."
  local-hook)

(def-kom-var kom-send-message-setup-hook nil
  "**Hook that is called when the minibuffer is entered to read a message.

This hook can be used to set up the minibuffer in a way suitable for
writing messages. For example, the hook might enable `auto-fill-mode'
or set up automatic resizing of the minibuffer."
  local-hook)

(def-kom-var lyskom-send-message-setup-hook nil
  "Obsolete synonym for kom-send-message-setup-hook."
  local-hook)

(def-kom-var kom-send-message-exit-hook nil
  "**Hook that is called when the minibuffer is exited after reading a message.

Typically this hook will be used to undo the effects of
`kom-send-message-setup-hook'."
  local-hook)

(def-kom-var lyskom-send-message-exit-hook nil
  "Obsolete synonym for kom-send-message-exit-hook."
  local-hook)

(def-kom-var kom-send-text-hook nil
  "**Hook that is called before sending a text.

This hook is called before the headers are parsed, so it is possible
for the headers to be modified after this hook is called. It is also
possible that the text will not be sent at all."
  local-hook)

(def-kom-var lyskom-send-text-hook nil
  "Obsolete synonym for kom-send-text-hook."
  local-hook)

(def-kom-var kom-after-load-hook nil
  "**Hook to run once after LysKOM is loaded.

This is similar in effect to using `eval-after-load', but is
independent of the file name of the client.")

(def-kom-var lyskom-after-load-hook nil
  "Obsolete synonym for kom-after-load-hook.")

(def-kom-var kom-change-conf-hook nil
  "**Hook to run when changing conferences.

The functions in this list are run with two arguments. The first is the 
current conference number and the second is the number of the
conference being changed to.

This hook is run before `lyskom-current-conf' is changed, and before
any standard messages have been printed."
  local-hook)

(def-kom-var lyskom-change-conf-hook nil
  "Obsolete synonym for kom-change-conf-hook"
  local-hook)

(def-kom-var kom-after-change-conf-hook nil
  "**Hook to run when changing conferences.

The functions in this list are run with two arguments. The first is the 
current conference number and the second is the conference number
being changed to.

This hook is run after `lyskom-current-conf' is changed, and after any
standard messages have been printed."
  local-hook)

(def-kom-var lyskom-after-change-conf-hook nil
  "Obsolete synonym for kom-after-change-conf-hook."
  local-hook)

(def-kom-var lyskom-login-hook nil
  "**Hook called while logging in.

This hook is called after the session is logged in but before any
command is accepted from the keyboard. It is called immediately before
`kom-login-hook'."
  local-hook)

(def-kom-var kom-login-hook nil
  "**Hook called while logging in.

This hook is called after the session is logged in but before any
command is accepted from the keyboard. Unlike `lyskom-login-hook' it
can be stored in the server."
  server)

(def-kom-var kom-relogin-inhibit-commands '(kom-next-kom 
					    kom-previous-kom 
					    kom-where-is 
					    kom-next-unread-kom)
  "**Commands for which relogin is disabled.

This should be set to a list of commands for which relogin should not
be offered or used."
  server)

(def-kom-var kom-relogin-behaviour 'ask
  "**Controls how to behave when commands are issued in dead sessions.

When this is set to `t', the client will try to login automatically.
When set to `ask', the client will ask whatever the user wants to
reattach. When set to `nil', the client will not attempt to reattach."
  server)

(def-kom-var kom-remember-password nil
  "**Controls whatever to store the password in the session buffer.

When this is set to `t', the client will store the password for the 
current session as a buffert local variable. This can be used in
conjunction with `kom-relogin-behaviour' to reattach dead sessions
automatically."
  server)

(def-kom-var kom-confirm-add-recipients t
  "**Controls confirmation when adding recipients.

When this is set to `t', confirm the recipient type when adding
recipients. Commands like `kom-add-recipient' will pose a question to
determine the type of recipient to add. When set to `nil', assume that
the user always wants full recipients when using `kom-add-recipient'
and similar commands.

Values other than `t' and `nil' are reserved for future use."
  server)


(def-kom-var kom-do-when-done '(kom-review-all-marked-texts kom-display-time)
  "**What to do when all texts are read.

This is a list of commands and lists of commands that are prompted for
and executed when there are no more new texts. The last command in the
list will be prompted for over and over until new texts arrive.

The values in the list can be a LysKOM command (a symbol), an Emacs
command or a keyboard macro (a string).

Values other than those listed are reserved for future use."
  server)

(def-kom-var kom-page-before-command nil
  "**Controls clearing of the screen prior to certain commands.

When this variable is set to `t', all commands will execute at the top
of the LysKOM window. When a command is issued, the buffer will be
scroll so the last prompt is on the first line of the buffer.

When set to a list of LysKOM commands \(symbols), those commands will
execute at the top of the window. All others will execute without
scrolling the buffer.

When set to `nil', never scroll the buffer in the way described.

Values other than those listed are reserved for future use."
  server)

(def-kom-var kom-permissive-completion t
  "**Controls completion of logged-in sessions.

When the client reads names of logged-in users in the minibuffer \(e.g.
`kom-status-session'), it can permit completion of all users or just
those that are logged on.

If this variable is set to `t', completion will include all users,
including those that are not logged in. If this variable is set to
`nil', completion will be restricted to users who are logged in.

Setting this variable to `t' may improve performance significantly,
particularly on servers with many sessions.

Values other than `t' or `nil' are reserved for future use."
  server)

(def-kom-var kom-unsubscribe-makes-passive t
  "**Controls behavior of `kom-sub-self'.

If this variable is set to `t', leaving a conference with
`kom-sub-self' will make the membership passive. Leaving a second time
\(while the membership is still passive) will remove the membership
entirely. 

When set to `nil', `kom-sub-self' removes the membership immediately.

Values other than `t' and `nil' are reserved for future use."
  server)


(def-kom-var kom-membership-default-priority 'ask
  "**Default priority when joining a new conference.

If set to a valid priority (integer from 0 to 255) then new
conferences are read with this priority. When set to the symbol `ask',
the client will ask for a priority when joining new conferences.

Values other than those listed are reserved for future use."
  server)

(def-kom-var kom-membership-default-message-flag 'ask
  "**Default message flag when joining a new conference.

If set to `nil', messages will not be received for new conferences,
if set to `t', messages will be received. When set to the symbol `ask',
the client will ask if you want to receive messages when you join new 
conferences.

Values other than those listed are reserved for future use."
  server)

(def-kom-var kom-membership-default-placement 'last
  "**Default placement of new memberships.

This variable controls the placement of memberships within the
membership list when you join a conference. Note that the membership
priority has precedence over this position.

The value can be `first', `last' or a number. When set to `first', the
membership will be entered before all others. When set to `last', it
will be entered after all others. When set to an integer, the
membership is entered at that position in the list.

All other values are reserved for future use."
  server)

(def-kom-var lyskom-current-prompt nil
  "The current prompt or nil.
This is either nil, indicating that there is currently no prompt, or
a symbol indicating which command is prompted in the LysKOM buffer."
  local)

(def-kom-var lyskom-current-prompt-text nil
  "The current prompt text or nil.
This is either nil, indicating that there is currently no prompt, or
a string indicating the prompt shown in the LysKOM buffer."
  local)

(def-kom-var lyskom-current-prompt-args nil
  "The current prompt arguments.
These are arguments used to format the current prompt."
  local)

(def-kom-var lyskom-current-prompt-timestamp nil
  "The creationtime of the current prompt.
This is used when updating the prompt and on `lyskom-start-of-command'."
  local)

(def-kom-var lyskom-need-prompt-update nil
  "Non-nil if all prompts need to be updated."
  local)

(def-kom-var kom-show-personal-messages-in-buffer t
  "**Buffer to show personal, group and alarm messages in.

This variable controls which buffer personal, group and alarm messages
are shown in. When set to `nil', all messages are silently discarded.
When set to `t', messages are shown in the main LysKOM buffer. When
set to a string, messages will be inserted in a buffer by that name
\(one will be created if necessary). When set to a buffer, messages
are inserted in that buffer.

All values other than those listed are reserved for future use."
  server)

(def-kom-var kom-pop-personal-messages nil
  "**Non-nil means pop up a buffer with personal messages as they arrive.

When this variable is set to `nil', personal, group and alarm messages
are simply inserted in the appropriate buffer \(see
`kom-show-personal-messages-in-buffer'). The buffer is not displayed
automatically. When this variable is set to `t', the buffer in which a
new message is shown will be displayed automatically, possibly
splitting windows and uniconifying frames. When this variable is set
to `yes', the behavior is identical to when it is set to `t', but
frames will not be uniconified.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-ding-pause-amount 0.1
  "**Number of seconds to wait between successive beeps.

When multiple beeps are used as audible notification, this determines
the amount of time (in seconds) to wait between successive beeps. The
value must be a positive number (it may be a floating point number).")

(def-kom-var kom-ding-on-priority-break 1
  "**Non-nil means ding if a higher priority text or conference breaks in.

This variable must be set to a `t', `nil', a positive integer, a
string or a function. When set to `t' use the default beep. When set
to `nil', do not beep. When set to a number, beep that many times
\(see `kom-ding-pause-amount' for additional settings). When set to a
function, call that function. When set to a string, run the program
indicated by `kom-audio-player' with the string as its sole argument."
  server)

(def-kom-var kom-ding-on-new-letter nil
  "**Non-nil means ding if a message arrives in the letter box. 

See `kom-ding-on-priority-break' for valid values."
  server)


(def-kom-var kom-ding-on-wait-done 1
  "**Non-nil means ding when `kom-busy-wait' terminates.

See `kom-ding-on-priority-break' for valid values."
  server)

(def-kom-var kom-ding-on-common-messages 0
  "**Non-nil means ding when an alarm message arrives. 

See `kom-ding-no-priority-break' for valid values. In addition to
those listed there, the value of this variable may be a list of
elements like \(`KEY' . `VALUE'). If the sender (a conference number) is
found as the key of any element, the value of that element will be
used to generate the ding (valid values are those listed for
`kom-ding-on-priority-break'). The special key `t' is used when no other
key matches the sender."
  server)

(def-kom-var kom-ding-on-group-messages 1
  "**non-nil means ding when a group messages arrives.

See `kom-ding-on-common-messages' for valid values."
  server)

(def-kom-var kom-ding-on-personal-messages 2
  "**non-nil means ding when a personal message arrives.

See `kom-ding-on-common-messages' for valid values."
server)


(def-kom-var kom-ding-on-no-subject 2
  "**How to ding if the user has not entered a subject line.

When attempting to submit a text without a subject line, this variable
determines how to beep. See `kom-ding-on-priority-break' for valid
values."
  server)


(def-kom-var kom-audio-player "audioplay"
  "**Program used to play audio files.

If a of the variables that control audio signals (dings, beeps) is set
to a string, the command (shell command, not Emacs command) indicated
by this variable will be called with that string as an argument.
Therefore, this variable should be set to the name of an external
command that takes a single argument: a sound file to play.

Non-string values are reserved for future use."
  server)


(def-kom-var kom-ignore-message-senders nil
  "**List of senders whose personal, group and alarm messages are ignored.

The value of this variable must be a list of person numbers. Personal,
group and alarm messages sent by users in this list will be silently
ignored.

Values other than those listed are reserved for future use."
  server)

(def-kom-var kom-ignore-message-recipients nil
  "**List of recipients you do not want group messages to.

The value of this variable must be a list of conference numbers.
Messages sent to a recipient listed will be silently ignored.

Values other than those listed are reserved for future use."
  server)

(def-kom-var kom-show-personal-message-date t
  "**Controls display of date on personal messages.

When set to `t', display the date and time when personal, group and
alarm messages arrived. When set to `nil', only display the time.

`kom-show-personal-message-date' set to `t'>:

<
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Alarm message from Claude Chappe (1805-01-23 17:34):
  
  Je me donne la mort our viter l'ennui de la vie qui m'accable; je
  n'ai point de reproches  me faire.
  ----------------------------------------------------------------
>

`kom-show-personal-message-date' set to `nil':

<
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  Alarm message from Claude Chappe (17:34):
  
  Je me donne la mort our viter l'ennui de la vie qui m'accable; je
  n'ai point de reproches  me faire.
  ----------------------------------------------------------------
>

See Bulletin of Les Amis de Paris Central Tlgraphe, no. 20, July
1993 for information on the quote above.
"
  server)

(def-kom-var kom-default-message-recipient 'group
  "**Determines default recipient of personal messages.

When set to `everybody', the default recipient of all messages will be
all users (i.e. the default is to send alarm messages). This may not
work properly. 

If set to `group', the default recipient depends on the message most
recently received. If that message was a group message, then the
default recipient will be the recipient of that message. If that
message was a personal message or an alarm message, the default
recipient will be the sender of the most recent message.

If set to `sender', the default recipient is always the sender of the
most recently received message, regardless of its type.

Values other than those listed are reserved for future use."
  server)


(def-kom-var kom-filter-outgoing-messages t
  "**Determines whether automatic outgoing messages are shown.

When set to `t', outgoing remote control messages and automatic
replies are not displayed. When set to `nil', these messages are shown
the same way normal messages are shown when sent.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-highlight-conferences 
  '((kom-friends . kom-friends-face)
    (kom-morons  . kom-morons-face)
    (lyskom-highlight-has-no-presentation . kom-active-strikethrough-face)
    (lyskom-pers-no . kom-me-face)
    (lyskom-highlight-i-am-supervisor . kom-active-highlight-face))
  "**How to highlight conference an person names.

The value of this variable is an alist whose keys are matched against
conference numbers and whose values are the names of faces to use for
matching conferences.

The following values are legal for keys:

    Value       Meaning
    -----------------------------------------------------------------
    Symbol      If the value is a list, matches if the conference
                number is in the list. If the value is an integer,
                matches if the conference number matches the integer.

    List        Matches if the conference number is in the list.

    Function    Matches if the function returns non-nil (see below).
    -----------------------------------------------------------------

When using a function as the key, the function will be called with a
single argument, the object to be printed. The type of the argument
will vary depending on how it is printed. Functions should be written
so they work regardless of what is passed to them.

All other values are reserved for future use."
  server)

(def-kom-var kom-friends nil
  "**List of friends and other nice people.

The value of this variable is a list of person numbers. People listed
here will be displayed using the face in `kom-friends-face'. They can
also receive special treatment in other cases (see
`kom-presence-messages').

See `kom-morons' for a related variable.

Values other than a list of integers are reserved for future use."
  server)

(def-kom-var kom-morons nil
  "**List of people morons and other nasty people.

The value of this variable is a list of person numbers. People listed
here will be displayed using the face in `kom-morons-face'.

See `kom-friends' for a related variable.

Values other than a list of integers are reserved for future use."
  server)

(def-kom-var kom-dont-check-commented-authors nil
  "**A list of recipients that don't need to see comments to their texts.

When writing a comment, the client can check that the author of the
commented text is a member of at least one of the recipients. If that
is not the case, the user will be offered to add the author as a
recipient.

This variable lists authors who shold not be checked in this manner.
Typically it will contain a list of import agents.

Values other than a list of integers are reserved for future use."
  server
  inherited)

(def-kom-var kom-smileys t
  "**Controls display of graphical smileys.

When set to `t', display graphical smileys instead of `:-)' and
similar character sequences. When set to `nil', do not display
graphical smileys.

For this to work at all you must have the `smiley' or `smiley-ems'
installed (usually installed with Gnus) and support for graphics (part
of XEmacs and Gnu Emacs 21.x and later).

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-text-properties t
  "**Controls use of text properties in LysKOM (fonts and stuff).

When set to `t', the client will freely use text properties, like
fonts. When set to `nil', the client will not use text properties.
This will disable all font usage and clickable stuff.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-fontify-text t
  "**Controls whether plaintext messages are fontified.

When set to `t', the client will make words and phrases delimited by
asterisks bold, and words and phrases delimited by underscore italic.
Other similar features may be added in the future.

Values other than `t' or `nil' are reserved for future use."
  server)


(def-kom-var kom-use-button-hints t
  "**Controls use of context sensitive actions on clickable areas.

When set to `t', clickable areas of the same type may behave
differently depending on what command created them. For example, in
one case clicking a conference name may show the presentation of that
conference and in another it will go to the conference.

Values other than `t' and `nil' are reserved for future use.")

(def-kom-var kom-autowrap t
  "**Controls automatic text wrapping.

When set to `t', automatically break long lines in texts. A set of
rules attempts to limit line breaking to regular, unformatted text.
This works most of the time, but occasionally fails (in which case
`kom-review-noconversion' comes in handy).

When set to an integer, perform automatic line breaking in text no
longer than that many characters. 

When set to `nil', do not break lines automatically at all.

Values other than `t', `nil' and integers are reserved for future
use."
  server)

(def-kom-var kom-autowrap-timeout 5
  "**Limits how much time automatic text wrapping may take.

When set to an integer, limits the number of seconds automatic line
breaking may take. Without a limitation, breaking lines of a very long
text can take a very, very long time. Note that this setting is
approximate; the actual time spent breaking lines may be several
seconds longer than this value. Furthermore, using this setting slows
down all text display slightly.

When set to `nil', do not limit the amout of time automatic line
breaking may take.

Values other than `nil' and integers are reserved for future use."
  server)

(def-kom-var kom-keep-alive-interval 180
  "**Polling interval for `kom-keep-alive'.

The command `kom-keep-alive' polls the server periodically to keep the
connection active. This variable specifies how many seconds to wait
between these periodic requests to the server.

Values other than integers are reserved for future use."
  server)

(defvar lyskom-transforming-external-text nil
  "Dynamically bound to non-nil when transforming text in which text,
conference and person buttons are not expected.")

(def-kom-var lyskom-url-protocol-regexp
  "\\(file\\|ftp\\|gopher\\|http\\|https\\|news\\|wais\\|mailto\\|telnet\\):"
  "Regexp to match the protocol part of a URL.")

(def-kom-var lyskom-text-buttons
  '(
    ;; Text numbers
    ("\\(\\<[0-9][0-9][0-9][0-9]\\([0-9]\\)?\\([0-9]\\)?\\([0-9]\\)?\\([0-9]\\)?\\([0-9]\\)?\\>\\)" 
                                        ; Match
     text                               ; Button type
     0                                  ; Portion that's a button
     1                                  ; Portion that's the arg
     nil                                ; Face or nil (=default)
     )

    ;; Email

    ("\\(\\b\\|^\\)[^()<>@,;:\"\\\\\000- ]+@[^\000- <>;,.'\"!:?) \t\012\014]+\\(\\.[^\000- <>;,.'\"!:?)]+\\)+"
     email 0 0 kom-url-face)

    ;; URLs

    ("\\b\\(www\\|ftp\\|home\\)\\.[^\t \012\014\"<>|\\]*[^][\t \012\014\"<>|.,!(){}?'`:;]" 
     pseudo-url 0 nil kom-url-face)

    ("\\(file://\\|ftp://\\|gopher://\\|rtsp://\\|http://\\|https://\\|news:\\|wais://\\|mailto:\\|telnet:\\)[^\t \012\014\"<>|\\]*[^][\t \012\014\"<>|.,!(){}?'`:;]" 
     url 0 nil kom-url-face)

    ("<URL:\\([^<>]+\\)>"
     pseudo-url 1 1 kom-url-face lyskom-is-url)
    ("<\\([^<>]+\\)>"
     pseudo-url 1 1 kom-url-face lyskom-is-url)

    ;; JySKom enhancements

    ("<(?m[|]te[ \t\n\r]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     conf 0 1 nil)
    ("<(?text[ \t\n\r]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     text 0 1 nil)
    ("<(?person[ \t\n\r]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     pers 0 1 nil)

    ;; Info node reference

    ("\\*Note[ \n\t]+\\([^:\n]*\\(\n[^:\n]*\\)?\\):\\s-*\\(\\(([^\)]+)\\)?[^.,\t\n]*\\(\n[^.,\t\n]*\\)?\\)[.,\t]" 
     info-node 1 3 kom-url-face)

    )
  "List of buttons to install in the text mass of LysKOM objects. Each 
element is a list consisting of REGEXP TYPE BUTTON-MATCH BUTTON-ARG-MATCH
FACE &optional PRED.

REGEXP is the regexp to look for in the text.
TYPE is the button type. Valid button types are defined in lyskom-button-actions.
BUTTON-MATCH is the number of the parenthesized expression that is the actual button.
BUTTON-ARG-MATCH is the number of the expression to be used as the button argument.
FACE is the text face to apply to the button, or nil to use the default face.
If PRED is given, it is a function that will be passed the matched string; if 
it returns non-nil, the match is considered valid.")

(def-kom-var kom-url-viewer-preferences '("emacs"
                                          "windows"
                                          "w3")

  "**Specifies application preferences for opening URLs.

This is a list of URL handlers to try when opening a URL. Each handler
is associated with a set of protocols. An URL will be opened by the
first handler in the list that is associated with the URLs protocol.

Value values for elements in the list are:

    Handler          What it does                     Handles protocols
    ------------------------------------------------------------------------
    \"default\"      Use `browse-url' to open URLs    All

    \"windows\"      Microsoft Windows default        All

    \"netscape\"     Opens URLs in Netscape/Mozilla   All

    \"mosaic\"       Opens URLs in NCSA Mosaic        All common

    \"lynx\"         Opens URLs in Lynx               All common

    \"galeon\"       Opens URLs in Galeon             All common

    \"w3\"           Opens URLs in Emacs W3           http,gopher,ftp

    \"emacs\"        Opens URLs in Emacs              ftp,telnet,file,mailto

    \"dired\"        Opens URLs in Emacs              ftp,file

    \"telnet-mode\"  Opens URLs in Emacs              telnet

    \"mail-mode\"    Opens URLs in Emacs              mailto
    ------------------------------------------------------------------------

The variable `kom-url-managers' contains a list of all handlers. 

See `kom-mosaic-command', `kom-netscape-command',
`kom-galeon-command', `kom-lynx-terminal-command',
`kom-lynx-xterm-command', and `kom-windows-browser-command' for
additional settings that affect opening URLs."
  server)


(def-kom-var kom-url-managers '(("default"
                                 ".*"
                                 "Browse-URL"
                                 lyskom-view-url-browse-url)
                                ("w3" 
                                 "\\(http\\|gopher\\|ftp\\)"
                                 "Emacs W3" 
                                 lyskom-view-url-w3)
                                ("windows"
                                 ".*"
                                 "web browser"
                                 lyskom-view-url-windows)
                                ("netscape"
                                 ".*"
                                 "Netscape Navigator/Mozilla"
                                 lyskom-view-url-netscape)
                                ("\\(emacs\\|dired\\)"
                                 "\\(ftp\\|file\\)"
                                 "dired"
                                 lyskom-view-url-dired)
                                ("\\(emacs\\|telnet-mode\\)"
                                 "telnet"
                                 "emacs telnet"
                                 lyskom-view-url-telnet)
                                ("\\(emacs\\|mail-mode\\)"
                                 "mailto"
                                 "mail-mode"
                                 lyskom-view-url-mailmode)
                                ("mosaic"
                                 "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
                                 "NCSA Mosaic"
                                 lyskom-view-url-mosaic)
                                ("lynx"
                                 "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
                                 "Lynx"
                                 lyskom-view-url-lynx)
                                ("galeon"
                                 "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
                                 "Galeon"
                                 lyskom-view-url-galeon))

  "List of URL managers. Each element is a list consisting of
\(MANAGER-REGEXP PROTOCOLS NAME VIEW-FUNCTION). When LysKOM attempts to
view a URL, kom-url-viewer-preferences is scanned, and the URL
-manager whose MANAGER-REGEXP first matches an element in
kom-url-viewer-preferences and whose PROTOCOLS matches the protocol of
the selected URL is used to view the URL by calling its VIEW-FUNCTION
with the URL and the manager entry as arguments.")

(def-kom-var kom-windows-browser-command ""
  "**Program to open a URL in Windows. 

If it is the empty string, a couple of commands that are likely to
work on Windows will be tried."
  server)

(def-kom-var kom-mosaic-command "/usr/local/bin/mosaic"
  "**Command to run Mosaic.

Note that Mosaic uses its own special conventions to open URLs
remotely that are probably not suitable for other browsers."
  server)

(def-kom-var kom-netscape-command "netscape"
  "**Command to start Netscape or Mozilla.

If set to a string, it should be a command that starts Netscape or
Mozilla with no arguments. If a list, the first element must be a
command that starts Netscape. The remaining elements are used as
arguments to Netscape.

For instance, a value of \"netscape\" is valid, but \"netscape -d
host:0\" is not. Instead, the latter should be \(\"netscape\" \"-d\"
\"host:0\"\)"
  server)

(def-kom-var kom-netscape-variant nil
  "**Netscape-specific options.

When set to `nil', open URLs in whatever window Netscape or Mozilla
chooses. Usually an old window is recycled. When set to `new-window',
open URLs in a new window. When set to `new-tab', open URLs in a new
tab. These options may not work with all versions of Netscape or
Mozilla, or on all operating systems.

Values other than those listed above are reserved for future use."
  server)


(def-kom-var kom-galeon-command "galeon"
  "**Command used to run to start Galeon.

If a string, it should be a command that starts Galeon with no
arguments. If a list, the first element must be a command that starts
Galeon. The remaining elements are used as arguments to Galeon.

For instance, a value of \"galeon\" is valid, but \"galeon
--display host:0\" is not. Instead, the latter should be
\(\"galeon\" \"--display\" \"host:0\"\)"
  server)

(def-kom-var kom-lynx-terminal 'xterm
  "**Where to start Lynx when opening URLs.

Valid values are `xterm' \(start Lynx in an xterm) and `terminal'
\(start Lynx in Emacs terminal mode)."
  server)

(def-kom-var kom-lynx-xterm-command
  '("xterm" "-geometry" "90x50+100+100" "-e" "lynx")
  "**Command to run to start Lynx in an xterm.

Must be a list of strings, where the first element is the name of the
xterm program, and the remaining elements are arguments to the
xterm. The last elements should be \"-e\" \"lynx\", or something similar,
to start Lynx."
  server)

(def-kom-var kom-lynx-terminal-command "lynx"
  "**Command to run Lynx in Emacs terminal mode.

This can be either a string, to start Lynx with no arguments, or a
list of strings, where the first element is the command, and the rest
are arguments to Lynx."
  server)

(def-kom-var kom-confirm-multiple-recipients 'after
  "**Non-nil means ask the user for confirmation about recipients.

When the user writes a comment to a text with more than one recipient,
ask for confirmation that all recipients are relevant, or one question
for each recipient.

If this variable is set to `before', ask once for each recipient
before opening the edit buffer.

If this variable is set to `after', ask once for all recipients after
editing the text. This is the preferred value since it is difficult to
judge the relevance of a recipient until the text has been written.

Values other than those listed are reserved for future use."
  common confirm-multiple-recipients boolean)

(def-kom-var kom-check-for-new-comments t
  "**Controls check for new comments when writing comments.

When posting a comment, the client can check if the text being
commented has unread comments. This frequently happens when several
people attempt to answer the same question at the same time.

If this variable is set to `t' check for new comments before posting a
comment. If there are new comments, ask for confirmation before
posting.

If this variable is `nil', dont' check.

If this variable is set to a function name, call the function to see
if check should be performed. The function is called with the
commented text's text-stat as its sole argument. If it returns
non-nil, the check is performed.

A list of conference numbers means perform the check for all
conferences other than those listed.

All other values are reserved for future use."
  server)

(def-kom-var kom-check-commented-author-membership t
  "**Controls check that authors of commented texts will see a new comment.

When writing a comment, the client can check that the author of the
commented text is a member of at least one of the recipients. If that
is not the case, the user will be offered to add the author as a
recipient.

If this variable is set to `t', perform the check. If not, don't
perform the check.

See `kom-dont-check-commented-authors' for a way to exclude certain
authors from this check.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-inhibit-typeahead nil
  "**Controls how command typed while the client is busy are handled.

When this variable is set to `t', input that arrives while a command
is running will be discarded before the next prompt is shown. When set
to `nil', that input will be handled normally.

If you find yourself accidentally executing commands, it may make
sense to set this variable to `t'.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-max-buffer-size nil
  "**Controls the maximum size of the LysKOM buffer.

When this variable is set to an integer, limit the size of the LysKOM
buffer to that many characters. When set to `nil', don't limit the
buffer size.

Before anything is deleted, `lyskom-trim-buffer-hook' (note that this
hook variable will probably be renamed in the future). Also see
`kom-trim-buffer-minimum' for more information.

Values other than `nil' and positive integers are reserved for future
use."
  server)

(def-kom-var kom-trim-buffer-minimum 4096
  "**The amount of text to trim from the buffer when limiting its size.

To avoid cutting tiny bits from the top of the buffer all the time,
delete this many bytes (rounded to a whole line) from the buffer at a
time.

See `kom-max-buffer-size' for information on how to limit the buffer
size.

Values other than positive integers are reserved for future use."
  server)


(def-kom-var kom-print-relative-dates t
  "**Controls display of relative dates.

When set to `t', print today's date as \"today\" and yesterday's as
\"yesterday\" in most places. When set to `nil', print all dates using
the default numeric format.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-print-seconds-in-time-strings nil
  "**Controls display of seconds in timestamps.

When set to `t', display many timestamps with seconds. When set to
`nil', only show hours and minutes.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-show-namedays nil
  "**Controls display of namedays.

When this variable is set to a non-nil value,`kom-display-time' can
display names of the day.

If set to `t', show the namedays for the currently selected languag
\(if there are any). If set to a symbol, that symbol should indicate a
list of names (use `kom-list-nameday-lists' to see a list of all
possible lists). If set to a list, each element should be a symbol
indicating a list of names; display namedays from all indicated lists.

All values other than those listed are reserved for future use."
  server)

(def-kom-var kom-ssh-relay-host nil
  "**Controls relay of LysKOM sessions through ssh.

It is possible to automatically tunnel LysKOM sessions through ssh.
For this to work you need to have command-line ssh installed, and
connecting to the remote host indicated by this variable must succeed
without asking for a password or passphrase.

This variable, when set to a string, enables tunneling ssh to the host
indicated by the value of this variable.

Note that storing this variable in the LysKOM server makes no sense.

See `kom-ssh-command' for additional configuration options.

Values other than strings are reserved for future use.")

(def-kom-var kom-ssh-command "ssh"
  "**Command to start ssh.

This variable should be set to a command that runs ssh. Note that it
is not possible to specify command-line arguments using this variable.

See `kom-ssh-relay-host' for more information.

Non-string values are reserved for future use.")

(def-kom-var lyskom-ssh-proxy nil
  "When non-nil, the ssh proxy used for this buffer."
  local
  protected)

(def-kom-var kom-www-proxy nil
  "**Controls use of an HTTP proxy for the LysKOM session.

When this variable is set to a string, it should be the host name of
an HTTP proxy that supports the CONNECT method. All LysKOM sessions
will be transparently tunneled through this proxy.

When set to a list, each element must be a pair \(`SERVER' . `PROXY'),
where `SERVER' is a LysKOM server and `PROXY' is the proxy to use for
that server (or `nil' to not use a proxy). The special value `t' for
`SERVER' indicates the proxy to use for unlisted servers.

The proxy string has the form \"`HOST':`PORT'\", where `HOST' is the
proxy host and `POSRT' is the port on which the proxy is running. The
port part is optional. If it is not specified, port 80 is assumed.

Values other than those described are reserved for future use.")

(def-kom-var kom-www-proxy-headers
  "User-Agent: Mozilla/4.7C-CCK-MCD  [en] (X11; I; SunOS 5.6 sun4u)"
  "**Extra HTTP headers to use when connecting through a Proxy.

The value of this variable should either be a single string, which is
sent verbatim to the proxy, or a list of strings which will be sent to
the proxy separated by CRLF, or a list of elements like \(`NAME' `H1'
`H2' ... `Hn') where `NAME' is the name of a proxy and the remaining
elements are headers to send when connecting through that proxy.

Do not use this variable for proxy authentication.

Values other than those listed are reserved for future use.")


(def-kom-var kom-server-aliases nil
  "**An alist mapping server names to shorter identification strings.

Each value in this string should be of the form \(`SERVER' . `NICKNAME'),
where `NICKNAME' is the short name for the server `SERVER'. You can
set this in init files before loading LysKOM.

See `kom-builtin-server-aliases' for more information.

Values other than those described are reserved for future use.")

(def-kom-var kom-builtin-server-aliases
  '(("kom.lysator.liu.se" . "LysKOM")
    ("com.lysator.liu.se" . "LysCOM (LysKOM in English)")
    ("kom.ludd.luth.se" . "LuddKOM")
    ("kom.hem.liu.se" . "RydKOM")
    ("kom.update.uu.se" . "UppKOM")
    ("kom.mds.mdh.se" . "MdS-KOM")
    ("kom.stacken.kth.se" . "TokKOM")
    ("com.helsinki.fi" . "HesaKOM")
    ("kom.cd.chalmers.se" . "CD-KOM")
    ("community.roxen.com" . "Roxen Community KOM")
    ("kom.ds.hj.se" . "DSKOM")
    ("kom.sno.pp.se" . "SnoppKOM")
    ("myskom.kfib.org" . "MysKOM"))
  "**An alist mapping server names to shorter identification strings.

Each value in this string should be of the form (`SERVER' . `NICKNAME'),
where `NICKNAME' is the short name for the server `SERVER'. Avoid
setting this variable since that will override the list compiled into
the client. Use `kom-server-aliases' instead.

Values other than those described are reserved for future use.")

(def-kom-var kom-ansaphone-on nil
  "*'Controls automatic replies to personal messages.

When set to `t', send automatically send replies to personal messages.
See `kom-ansaphone-replies' and `kom-ansaphone-default-reply' for ways
to configure the replies to send.

When set to `nil', don't send automatic replies.

This can be set temporarily with `kom-toggle-auto-reply'. The reply
message can be changed temporarily with `kom-change-auto-reply'.

Values other than `t' and `nil' are reserved for future use."
  local)

(def-kom-var kom-silent-ansaphone nil
  "**Controls beeps when automatic replies are enabled.

When set to `t', don't beep or otherwise signal receipt of personal
messages while automatic replies are enabled (see `kom-ansaphone-on').
When set to `nil', signal receipt of personal messages as usual.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-ansaphone-record-messages t
  "**Controls recording of personal messages while automatic replies are on.

When set to `t', record personal messages that are received while
automatic replies are on. Recorded messages can be listed with
`kom-list-messages' and erased with `kom-erase-messages'.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-ansaphone-show-messages t
  "**Controls display or personal messages while automatic replies are on.

When set to `t', personal messages received while automatic replies
are enabled will be shown as usual. When set to `nil' the will not be
shown. Note that if this variable is set to `nil' and
`kom-ansaphone-record-messages' is also set to `nil', messages are
simply discarded.

Values other than `t' and `nil' are reserved for future use."
  server)


(def-kom-var lyskom-ansaphone-messages nil
  "Messages collected by the automatic reply facility.
The most recent message is the first message in the list."
  local)

(def-kom-var lyskom-ansaphone-when-set (current-time-string)
  "Time when the auto-reply facility was enabled."
  local)

(def-kom-var kom-remote-control t
  "**Enables and disable remote control.

When this is set to `t', it will be possible to control the client
from other sessions using `kom-remote-autoreply',
`kom-remote-list-messages', `kom-remote-set-message',
`kom-remote-erase-messages' and `kom-remote-quit' (and possibly others
in the future). When set to `nil', remote control is disabled.

See `kom-remote-controllers' and `kom-self-control' for ways to
control access through remote control.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-remote-controllers nil 
  "**List of people who may use remote control.

This should be `nil' or a list of person numbers. The persons listed
may control the session using remote control commands (see
`kom-remote-control' for more information).

See `kom-self-control' for another variable that affects remote
control.

Values other than `nil' and a list of persons are reserved for future
use."
  server)

(def-kom-var kom-self-control t
  "**Enable or disable remote control for the logged-in user.

When set to `t', the user who is currently logged in may control the
session remotely from sessions that where the same user is logged in.
When set to `nil', only permit users listed in
`kom-remote-controllers'.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-ansaphone-replies
  '((group nil nil nil nil)
    (common nil nil nil nil))
  "**List of automatic replies to various messages.

This variable determines non-default automatic replies to personal
messages. Automatic replies are only send when `kom-ansaphone-on' is
set to `t'.

The value of this variable is a list of rules. Each rule is a list
with five elements: `MESSAGE-TYPE', `SENDER', `RECIPIENT', `TEXT', and
`REPLY'. Incoming messages are compared against these rules in order.
A message matches a rule if it matches all non-nil elements of the
rule.

If `MESSAGE-TYPE' is non-nil, match against the message type. Valid
values are `personal', `group' and `common' (for alarm messages).

If `SENDER' is non-nil, match against the message sender. The value
is either an integer (a person number) or a list of person numbers. A
message matches if its sender is any of the listed persons.

If `RECIPIENT' is non-nil, match against the message recipient. The
value is either an integer (a conference number) or a list of
conference numbers. A message matches if its recipient is any of the
listed conferences.

If `TEXT' is non-nil, match against the message text. The value is
a regular expression. A message matches if it contains a match for the
regular expression.

If all non-nil components of a rule match, rule processing is
terminated. If `REPLY' is a string, send that string as the reply. If
`REPLY' is `nil', don't send a reply.

If all rules are processed without finding a match, the value of
`kom-ansaphone-default-reply' is sent.

The default value for this variable disables automatic replies to all
group and alarm messages."
  server)

(def-kom-var kom-agree-text nil
  "**Determines the text used in `kom-agree'.

When non-nil, this is the default text for `kom-agree'. The value
may be a string, which is used verbatim as the default text; a
function, which is called and should return a text to use; or a list
whose elements must be strings, functions or lists, and from which an
element will be chosen at random and used in the same manner as
`kom-agree-text' itself.

Values other than those described are reserved for future use."
  server)

(def-kom-var kom-default-language nil
  "**The default language for LysKOM.

When set to non-nil, this variable should be set to a list of
symbols or a symbol indicating the prefered language(s) for LysKOM.
Each symbol name must be the ISO 630 code for a desired language (e.g.
`sv' for Swedish and `en' for English). Available languages depend on
how LysKOM was built.

All valid choices are listed in `lyskom-languages'."
  common language symbol-list
  transition (lambda (x) (cond ((listp x) x) (t (list x))))
  inherited
  protected)

(def-kom-var lyskom-language kom-default-language
  local
  inherited
  minibuffer
  protected
  "The language currently in use for messages.")

(def-kom-var lyskom-global-language kom-default-language
  "The language for language-specific things that affect multiple sessions.")

(def-kom-var lyskom-edit-mode-map nil
  "Mode map for LysKOM edit."
  local)

(def-kom-var lyskom-edit-prefix nil
  "Mode map for LysKOM edit mode.")

(def-kom-var lyskom-customize-map nil
  "Keymap for the customize buffer"
  local)

(def-kom-var lyskom-command-alternatives nil
  "Possible command completions."
  local
  minibuffer)


;;; =================================================================
;;;
;;; Language-dependent variables
;;;

(def-kom-var lyskom-month-names nil
  "A list of month names.
Each element is a cons cell consisting of the name of the month
\(a symbol) and the number of the month (1-12). Each month may
appear more than once, but the first occurence should be the
preferred name of the month."
  local
  inherited
  language-force)

(def-kom-var lyskom-help-data nil
  "Help strings."
  local
  language-force)

(def-kom-var lyskom-onoff-table nil
  "A completion table for on and off selections."
  local
  language-force)

(def-kom-var lyskom-move-tree-actions nil
  "A completion table for actions in kom-move-text-tree"
  local
  language-force)

(def-kom-var lyskom-language-codes nil
  "A list of ISO 639 language codes"
  local
  language-force)

(def-kom-var lyskom-filter-predicate-list nil
      "A list of legal filter comparison predicates."
      local
      language-force)

(def-kom-var lyskom-filter-what nil
      "A list of legal filter conditions and their textual representation."
      local
      language-force)

(def-kom-var lyskom-filter-actions nil
      "A list of legal filter actions an their textual representation."
      local
      language-force)

(def-kom-var lyskom-filter-edit-map nil
  "Keymap for LysKOM filter edit."
  local)

(def-kom-var lyskom-prioritize-mode-map nil
  "Keymap used in lyskom-prioritize-mode."
  local)

(def-kom-var kom-ansaphone-default-reply nil
  "**Default message to send when automatic replies are on.

The value of this variable must be a string or `nil'. When set to
`nil', no automatic replies are generated. See `kom-ansaphone-replies'
for a more flexible way of specifying automatic replies.

Values other than strings ans `nil' are reserved for future use."
  server)

(def-kom-var kom-ispell-dictionary nil
  "**Dictionary to use for spell checking.

When spell checking is used when writing texts, this variable can be
used to specify an alternate dictionary. When set to `nil', use the
default dictionary. When set, it should be set to a string indicating
the alternate dictionary (see `ispell-dictionary').

Values other than `nil' and strings are reserved for future use."
  server
  inherited)

(def-kom-var lyskom-unread-mode-line nil
  "This variable will become part of mode-line-format"
  language-force)

(def-kom-var lyskom-unread-title-format nil
  "This variable will become part of frame-title-format"
  language-force)

(def-kom-var lyskom-button-actions
  '((text
     text-popup-title
     lyskom-button-view-text
     ((lyskom-button-view-text-action . lyskom-button-view-text)
      (lyskom-button-unread-text-action . lyskom-button-unread-text)
      (lyskom-button-copy-text-no-action . lyskom-button-copy-text-no)
      (lyskom-button-review-noconversion-action . lyskom-button-review-noconversion)
      (lyskom-button-review-converted-action . lyskom-button-review-converted)
      (lyskom-button-review-rot13-action . lyskom-button-review-rot13)
      (lyskom-button-find-root-review-action . lyskom-button-find-root-review)
      (lyskom-button-find-root-action . lyskom-button-find-root)
      (lyskom-button-review-comments-action . lyskom-button-review-comments)
      (lyskom-button-review-tree-action . lyskom-button-review-tree)
      (lyskom-button-comment-text-action . lyskom-button-comment-text)
      (lyskom-button-private-comment-text-action . lyskom-button-private-comment-text)
      (lyskom-button-write-footnote-action . lyskom-button-write-footnote)
      (lyskom-button-fast-reply-action . lyskom-button-fast-reply)
      (lyskom-button-mark-text-action . lyskom-button-mark-text)
      (lyskom-button-unmark-text-action . lyskom-button-unmark-text)
      (lyskom-button-save-text-action . lyskom-button-save-text)
      (lyskom-button-save-text-body-action . lyskom-button-save-text-body)
      )
     nil
     ;; ((nil lyskom-print-text footer lyskom-button-comment-text))
     )
    (conf 
     conf-popup-title
     lyskom-button-view-conf-presentation
     ((lyskom-button-view-conf-presentation-action . lyskom-button-view-conf-presentation)
      (lyskom-button-view-conf-status-action . lyskom-button-view-conf-status)
      (lyskom-button-goto-conf-action . lyskom-button-goto-conf)
      (lyskom-button-send-message-action . lyskom-button-send-message)
      (lyskom-button-add-self-action . lyskom-button-add-self)
      (lyskom-button-sub-self-action . lyskom-button-sub-self))
     ((kom-list-news . lyskom-button-goto-conf)
      (kom-membership . lyskom-button-goto-conf)))
    (pers 
     pers-popup-title
     lyskom-button-view-pers-presentation
     ((lyskom-button-view-pers-presentation-action . lyskom-button-view-pers-presentation)
      (lyskom-button-view-pers-status-action . lyskom-button-view-pers-status)
      (lyskom-button-view-session-status-action . lyskom-button-view-session-status)
      (lyskom-button-mail-action . lyskom-button-mail)
      (lyskom-button-send-message-action . lyskom-button-send-message))
     ((kom-list-news . lyskom-button-goto-conf)
      (kom-membership . lyskom-button-goto-conf)))
    (url 
     url-popup-title
     lyskom-button-open-url
     ((lyskom-button-open-url-action . lyskom-button-open-url)
      (lyskom-button-copy-url-action . lyskom-button-copy-url))
     nil)
    (info-node 
     generic-popup-title
     lyskom-button-goto-info-node
     ((lyskom-button-goto-info-node-action . lyskom-button-goto-info-node))
     nil)
    (email
     generic-popup-title
     lyskom-button-open-email
     ((lyskom-button-open-email-action . lyskom-button-open-email)
      (lyskom-button-copy-email-action . lyskom-button-copy-email))
     nil)
    (aux
     aux-popup-title
     lyskom-button-info-aux
     ((lyskom-button-info-aux-action . lyskom-button-info-aux)
      (lyskom-button-delete-aux-action . lyskom-button-delete-aux))
     nil)
    (aux-edit-menu
     nil
     nil
     ((lyskom-edit-toggle-secret-aux-action . lyskom-edit-toggle-secret-aux)
      (lyskom-edit-toggle-anonymous-aux-action . lyskom-edit-toggle-anonymous-aux)
      (lyskom-edit-toggle-inherit-aux-action . lyskom-edit-toggle-inherit-aux)
      (lyskom-edit-delete-aux-action . lyskom-edit-delete-aux))
     nil)
    (prioritize-flag-menu
     nil
     lyskom-prioritize-flag-toggle
     ((lyskom-prioritize-flag-toggle-action . lyskom-prioritize-flag-toggle)
      (lyskom-prioritize-flag-set-action . lyskom-prioritize-flag-set)
      (lyskom-prioritize-flag-clear-action . lyskom-prioritize-flag-clear))
     nil)
    (func
     nil
     lyskom-button-apply
     nil
     nil)
    (timestamp
     timestamp-popup-title
     (lambda (buffer argument text) nil)
     ((lyskom-button-copy-timestamp-action . lyskom-button-copy-timestamp))
     nil)
    (recpt-type
     recpt-type-popup-title
     (lambda (buffer argument text) nil)
     ((lyskom-button-recpt-type-recipient
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-copy
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'CC-RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-bcc
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'BCC-RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-sub
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-sub-recipient/copy
	    (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))))
    (add-recipient-or-xref
     add-recipient-or-xref
     nil
     ((lyskom-button-recpt-add-recipient
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-recipient)))
      (lyskom-button-recpt-add-copy
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-copy)))
      (lyskom-button-recpt-add-bcc
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-bcc)))
      (lyskom-button-aux-type-xref
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-cross-reference))))
      (lyskom-button-aux-type-no-comments
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-no-comments))))
      (lyskom-button-aux-type-personal-comments
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-personal-comments))))))
    )
  "This variable defines valid button types in LysKOM. Each element is a
list consisting of (TYPE LABEL DEFAULT ACTIONS HINTS).
TYPE is the button type the entry defines
LABEL is a textual representation for the button type, used in menu titles. If
      it is a symbol, that symbol will be looked up using lyskom-get-string.
DEFAULT is the default action to take on a click. It must be a function.
ACTIONS are other possible actions. The format of this entry is described 
        below.
HINTS is a list of hints to override the default action. This is described 
      below.

The ACTIONS entry is used to construct a pop-up menu. It is a list consisting 
of lists with the format (STRING . FUNCTION). STRING is the menu label and
FUNCTION is the function to call when the menu item is selected.

The HINTS entry is used to generate hints that the default action should be 
overridden. It is a list containing elements (COMMAND . HINT) where COMMAND is
as interactive LysKOM command and HINT is a function to call. When a button
is generated while the command COMMAND is being executed, HINT is used as a 
hint for a new default action. The user has the option to ignore or used the 
hint.

Also see the function \"lyskom-add-button-action\"."
  local
  inherited)

(def-kom-var kom-show-imported-envelope-sender t
  "**Controls display of envelope sender of imported e-mails.

When set to `t', dispaly the envelope sender of imported e-mails (if
the importer has recorded such information).

`kom-show-imported-envelope-sender' set to `t':

<
  2912231 today 10:07 +0100 /41 lines/  Super-User <root@spareribs.meat.com>
  Sent by: root@meat.spareribs.com
  Imported: today 00:07 by Mailman
  External recipient: BBQ <531@kom.meat.com>
>

`kom-show-imported-envelope-sender' set to `nil':

<
  2912231 today 10:07 +0100 /41 lines/  Super-User <root@spareribs.meat.com>
  Imported: today 00:07 by Mailman
  External recipient: BBQ <531@kom.meat.com>
>

Other variables that control display of imported e-mail include
`kom-show-imported-importer' and
`kom-show-imported-external-recipients'.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-show-imported-importer t
  "**Controls display of the importer name in imported mail.

When set to `t', display information about what imported the e-mail
\(if the importer has recorded such information). When set to `nil',
don't.

`kom-show-imported-importer' set to `t':

<
  2912231 today 10:07 +0100 /41 lines/  Super-User <root@spareribs.meat.com>
  Imported: today 00:07 by Mailman
  External recipient: BBQ <531@kom.meat.com>
>

`kom-show-imported-importer' set to `nil':

<
  2912231 today 10:07 +0100 /41 lines/  Super-User <root@spareribs.meat.com>
  External recipient: BBQ <531@kom.meat.com>
>

Other variables that control display of imported e-mail include
`kom-show-imported-importer' and
`kom-show-imported-external-recipients'.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-show-imported-message-id nil
  "**Controls display of the message id in imported mail.

When set to `t', display the message id of the imported e-mail. When
set to `nil', don't.

`kom-show-imported-message-id' set to `t':

<
  2912231 today 10:07 +0100 /41 lines/  Super-User <root@spareribs.meat.com>
  Message-ID: <D1696C471C6CD511A0BE00D0B7A932DE01BBB4FA@spareribs.meat.com>
  External recipient: BBQ <531@kom.meat.com>
>

`kom-show-imported-message-id' set to `nil':

<
  2912231 today 10:07 +0100 /41 lines/  Super-User <root@spareribs.meat.com>
  External recipient: BBQ <531@kom.meat.com>
>

Other variables that control display of imported e-mail include
`kom-show-imported-envelope-sender', `kom-show-imported-importer' and
`kom-show-imported-external-recipients'.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-show-imported-external-recipients t
  "**Controls display of external recipients of imported e-mail.

When set to `t', display all external recipients of each imported
e-mail (the to and cc headers). When set to `nil', don't display these
headers.

`kom-show-imported-external-recipients' set to `t':

<
  2912231 today 10:07 +0100 /41 lines/  Super-User <root@spareribs.meat.com>
  Imported: today 00:07 by Mailman
  External recipient: BBQ <531@kom.meat.com>
  External recipient: \"Mac the Hack\" <mac.hack@steak.meat.com>
>

`kom-show-imported-external-recipients' set to `nil':

<
  2912231 today 10:07 +0100 /41 lines/  Super-User <root@spareribs.meat.com>
  Imported: today 00:07 by Mailman
>

Other variables that control display of imported e-mail include
`kom-show-imported-envelope-sender', `kom-show-imported-importer' and
`kom-show-imported-message-id'.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-complete-numbers-before-names t
  "**Controls completion of numeric person and conference names.

When set to `t', reading conference and user names accepts the special
forms \"m 4711\" or \"p 42\" as numeric references to conference 4711 and
person 42 instead of trying to look for an object with a matching
name. If `nil', any name matching the input will be preferred to a
numeric reference.

Values other than `t' and `nil' are reserved for future use."
  server)


(def-kom-var kom-mercial nil
  "**What you are doing when you're done reading.

The value of this variable should be a string. This string is sent to
the server as the user's current activity when everything is read.

Users are encouraged to use their best sense of humor."
  server)


(defconst lyskom-commands-not-in-menu
  '(
    kom-unread-previous-commented-text
    kom-create-aux-item
    kom-become-nonanonymous
    kom-become-anonymous
    kom-send-alarm
    kom-get-abuse
    kom-get-appreciation
    kom-list-clients
    kom-view-previous-commented-text
    kom-membership
    kom-delete-text
    kom-quick-mode
    kom-slow-mode
    kom-busy-wait
    kom-comment-previous
    kom-private-answer-previous
    kom-change-language
    )
  "Commands that are not supposed to appear in menus.")

(defconst lyskom-commands
  '(
    kom-help
    kom-slow-mode
    kom-quick-mode
    kom-send-message
    kom-create-conf
    kom-delete-conf
    kom-delete-text
    kom-display-time
    kom-go-to-conf
    kom-go-to-next-conf
    kom-jump
    kom-list-created-conferences
    kom-list-conferences 
    kom-list-persons
    kom-list-news
    kom-list-re
    kom-list-sessions
    kom-membership
    kom-list-marks
    kom-postpone
    kom-set-session-priority
    kom-prioritize
    kom-status-person
    kom-status-conf
    kom-add-self
    kom-change-priority
    kom-list-summary
    kom-sub-self
    kom-quit
    kom-recover 
    kom-start-anew
    kom-view
    kom-find-root-review
    kom-review-comments
    kom-review-tree
    kom-review-cross-references
    kom-review-clear
    kom-review-last-normally-read
    kom-review-noconversion
    kom-review-converted
    kom-review-rot13
    kom-review-next
    kom-find-root
    kom-review-by-to
    kom-review-more
    kom-review-first
    kom-review-all
    kom-view-commented-text
    kom-view-previous-commented-text
    kom-review-stack
    kom-review-presentation
    kom-review-backward
    kom-view-next-text
    kom-who-is-on
    kom-who-is-on-in-conference
    kom-who-is-on-and-friend
    kom-who-am-i
    ;;   kom-display-who-buffer
    kom-list-clients
    kom-busy-wait
    kom-write-comment
    kom-comment-previous
    kom-write-footnote
    kom-private-answer
    kom-private-answer-previous
    kom-set-unread
    kom-write-text
    kom-send-letter
    kom-change-name
    kom-change-parenthesis
    kom-change-password
    kom-change-supervisor
    kom-change-presentation
    kom-get-appreciation
    kom-get-abuse
    kom-mark-text
    kom-unmark-text
    kom-review-marked-texts
    kom-review-all-marked-texts
    kom-add-recipient
    kom-add-copy
    kom-add-bcc
    kom-sub-recipient
    kom-move-text
    kom-move-text-tree
    kom-add-comment
    kom-sub-comment
    kom-add-cross-reference
    kom-add-member
    kom-sub-member
    kom-change-conf-motd
    kom-set-garb-nice
    kom-set-super-conf
    kom-set-permitted-submitters
    kom-unset-conf-motd
    kom-save-text
    kom-save-text-body
    kom-save-options
    kom-shutdown-server
    kom-sync-database
    kom-enable-adm-caps
    kom-disable-adm-caps
    kom-set-motd
    kom-remove-motd
    kom-force-logout
    kom-filter-author
    kom-filter-subject
    kom-filter-text
    kom-filter-recipient
    kom-super-jump
    kom-filter-edit
    kom-list-filters
    kom-show-user-area
    kom-change-conf-type

    kom-change-auto-reply
    kom-toggle-auto-reply
    kom-list-messages
    kom-erase-messages

    kom-remote-autoreply
    kom-remote-set-message
    kom-remote-list-messages
    kom-remote-erase-messages
    kom-remote-quit

    kom-status-session
    kom-customize
    kom-change-language
    kom-calculate

    kom-where-is

    kom-next-kom
    kom-previous-kom
    kom-next-unread-kom

    kom-send-alarm
    kom-agree
    kom-fast-reply
    kom-add-faq
    kom-del-faq
    kom-review-faq

    kom-add-footnote
    kom-sub-footnote

    kom-add-private-answer
    kom-add-no-comments
    kom-add-request-confirm

    kom-review-mail-headers

    kom-compare-texts
    kom-diff-texts

    kom-become-anonymous
    kom-become-nonanonymous

    kom-keep-alive
    kom-stop-keep-alive

    kom-who-is-present-in-conference
    kom-is-person-member-of-conference
    kom-change-conf-faq

    kom-make-review-mark-as-read
    kom-make-review-not-mark-as-read
    kom-set-presentation
    kom-set-motd-text
    kom-remove-presentation
    kom-create-aux-item
    kom-status-server
    kom-add-server-faq
    kom-del-server-faq
    kom-change-server-faq
    kom-review-server-faq
    kom-recommend-conference
    kom-redirect-comments
    kom-copy-options
    kom-mark-unread
    kom-unread-by-to
    kom-unread-last-normally-read
    kom-unread-root-review
    kom-unread-root
    kom-unread-tree
    kom-unread-comments
    kom-unread-previous-commented-text
    kom-unread-commented-text
    kom-unread-more
    kom-unread-all
    kom-unread-first
    kom-unread-all-marked-texts
    kom-unread-marked-texts
    kom-unread-faq
    kom-unread-server-faq
    kom-unread-presentation
    kom-join-all-conferences
    kom-leave-all-conferences
    kom-will-person-read-text
    kom-limit-import
    kom-change-message-flag
    kom-list-faqs
    kom-list-server-faqs
    kom-list-new-conferences
    kom-list-new-persons
    kom-change-privileges
    ))

;;; ================================================================
;;;                  Internal variables and constants


(defconst lyskom-clientversion "0.48"
  "Version of the LysKOM elisp client.")

(def-kom-var lyskom-settings-version lyskom-clientversion
  "Version of saved settings."
  server)

(defvar lyskom-max-int 8388607
  "The largest int Emacs, and thus this LysKOM client, can handle.")

(def-kom-var lyskom-server-uses-utc nil
  "When non-nil, assume that the server uses UTC timestamps."
  inherited
  local)

(defconst lyskom-server-features
  '((10 lyskom-bcc-flag
        lyskom-extended-types-flag)
    (9  lyskom-accept-async-flag
        lyskom-dynamic-session-info-flag
        lyskom-idle-time-flag)
    (8  lyskom-long-conf-types-flag 
        lyskom-set-last-read-flag 
        lyskom-uconf-stats-flag
        lyskom-set-last-read-flag)
    (7  lyskom-z-lookup-flag))
  "List describing which features a certain server has. Each
element is a list containing the protocol version and what
it supports. The format of each element is:

\(VERSION . SUPPORTS\)

Version is simply a protocol version. Protocol equal to or above the
version support the supports list.

SUPPORTS is a list of pairs and symbols. Cons pairs are treated as
arguments to setq, symbols are interpreted as variable names set
 to 't'.")

;;;(defconst lyskom-server-features
;;;  '(((>= 2 0 0) (lyskom-bcc-flag
;;;                 lyskom-aux-items-flag))
;;;    ((>= 1 9 0) (lyskom-accept-async-flag
;;;                 lyskom-dynamic-session-info-flag
;;;                 lyskom-idle-time-flag))
;;;    ((>= 1 8 0) (lyskom-long-conf-types-flag 
;;;                 lyskom-set-last-read-flag
;;;                 lyskom-uconf-stats-flag))
;;;    ((>= 1 7 0) (lyskom-z-lookup-flag))
;;;    ((= 2 0 0) ((protocol-version 10)))
;;;    ((= 1 9 0) ((protocol-version 9)))
;;;    ((= 1 8 0) ((protocol-version 8)))
;;;    ((= 1 7 0) ((protocol-version 7)))
;;;    ((= 1 7 1) ((protocol-version 7)))
;;;    ((< 1 7 0) ((protocol-version 6))))
;;;  "List describing which features a certain server version has.
;;;Each element is a list containing the server version and what it
;;;supports:
;;;")


(def-kom-var lyskom-server-version '(0 0 0)
  "The version of the server.  A list of three integers: major
version, minor version and revision."
  local)

(def-kom-var lyskom-server-coding-system 'iso-8859-1
  "The default coding system used by the server for all strings."
  inherited)

(def-kom-var lyskom-current-user-area 0
  "Text-no of the user area last saved or read for lyskom-pers-no."
  local)

(def-kom-var lyskom-max-packet-size lyskom-max-int
  "The largest possible packet size that can be transmitted to a
TCP/IP connection. This should be unlimited, but in practise there
are systems that limits this. This variable is automatically adjusted
if any problems are detected.")

(def-kom-var lyskom-pending-commands nil
  "Commands pending to be executed.
When a command finishes, it checks this variable to see if another command
should be run.

It should be a list where each element should be either a symbol or an
expression. If it is a symbol, it is invoked with `call-interactively', and
an expression is evaluated with `eval'."
  local)

(def-kom-var lyskom-do-when-done nil
  "Internal of kom-do-when-done."
  local)

(def-kom-var lyskom-do-when-starting nil
  "Internal of kom-do-when-starting. Obsolete.")

(def-kom-var lyskom-sessions-with-unread nil
  "List of LysKOM sessions with unread texts.
This is not buffer-local.")

(def-kom-var lyskom-sessions-with-unread-letters nil
  "List of LysKOM sessions with unread letters.
This is not buffer-local.")

(def-kom-var lyskom-session-has-unread-letters nil
  "Non-nil if this session has unread letters."
  local
  protected
  inherited)

(def-kom-var lyskom-session-has-unreads nil
  "Non-nil if this session has unread texts."
  local
  protected
  inherited)

(def-kom-var lyskom-buffer nil
  "The LysKOM buffer we are connected to."
  inherited
  minibuffer)

(def-kom-var lyskom-buffer-type nil
  "Type of the current buffer."
  local
  protected)

(def-kom-var output nil
  "Uaark. Just to omit a warning...")

(def-kom-var lyskom-errno nil
  "Errno of last lyskom error."
  local)

(def-kom-var lyskom-err-stat nil
  "Err-stat of last lyskom error."
  local)

(def-kom-var lyskom-parser-recovering nil
  "Non-nil if the parser is recovering from an error."
  local)

(def-kom-var lyskom-parse-pos nil
  "Position of parsing.")

(def-kom-var lyskom-unparsed-buffer nil
  "Buffer containing unparsed information from the server."
  local)

(def-kom-var lyskom-unparsed-marker nil
  "Where we now are inserting."
  local)

(def-kom-var lyskom-to-be-printed-before-prompt nil
  "Contains the strings to be printed before the next prompt."
  local)

(def-kom-var lyskom-other-clients-user-areas nil
  "Contains the parts of the user areas of unknown clients.
The area is a pair: name . info (both strings)."
  local)

(def-kom-var lyskom-saved-unknown-variables nil
  "Variables read from the user area that this client version
knows nothing about and that will be saved back unaltered."
  local)

(def-kom-var lyskom-pending-calls nil
  "Assoc list of calls to LysKOM server that have not yet completed.
Each element on the list has the format

	(REF-NO . KOM-QUEUE)
REF-NO	   unique number assigned by lyskom-send-packet.
KOM-QUEUE is a kom-queue. (See lyskom-call-data.)"
  local)

(def-kom-var lyskom-output-queues nil
  "Pending output to the server.
This is a vector of ten elements, each of which is a kom-queue. Calls from
queues with a higher index (priority) are always sent first.

At most lyskom-max-pending-calls calls are sent at once."
  local)

(def-kom-var lyskom-max-pending-calls 20
  "Max number of calls that are transmitted to the server at once.
Extra calls are queued in lyskom-output-queue and sent when the replies
returns.

This variable is not saved in the LysKOM server.")

(def-kom-var lyskom-number-of-pending-calls 0
  "Number of pending calls that are transmitted to the server."
  local)

;; This variable is used to prevent "starvation" of the blocking-do call.
;; When there is heavy prefetch going on in the background and a
;; blocking-do call is made there is a good chance that the
;; accept-process-output call will not return within a reasonable
;; time, because there will always be data to read from the server,
;; which means that Emacs will call lyskom-filter instead of returning
;; from accept-process-output.
(defvar lyskom-ok-to-send-new-calls t
  "This variable controls whether calls are passed to the server.
If it is nil, all outgoing calls are inhibited.")

(def-kom-var lyskom-ref-no 0
  "Next ref-no to use. These ref-nos are used to keep track of the
different packets.")

(def-kom-var lyskom-pers-no 0
  "The pers-no of the current user."
  inherited)

(def-kom-var lyskom-session-no 0
  "Session number in the server for this connection."
  local)

(def-kom-var kom-default-session-priority 0
  "**The default session priority.

Tha value of this variable must be an integer. Only texts in
conferences with a priority equal to or higher than this will be shown
by default.

To set the session priority in a running session, use
`kom-set-session-priority'. Setting this value directly will have no
effect on the actual session priority.

Non-integer values are reserved for future use."
  local
  server)

(def-kom-var kom-server-priority -1
  "**The default server priority.

The value of this variable must be an integer.

When `kom-server-priority-breaks' is set to a non-nil value, this
priority is used to decide when to go to a prioritized session. For a
session to be prioritized its priority must be higher than the current
session's `kom-server-priority' and higher than the priority of
whatever conference is currently being read.

Non-integer values are reserved for future use."
  server)


(def-kom-var lyskom-session-priority 0
  "This sessions priority.
Only texts in conferences with a priority equal to or higher than this
will be shown."
  local)

(def-kom-var lyskom-proc nil
  "The process (network connection) that is associated with this buffer."
  inherited
  minibuffer)

(def-kom-var lyskom-server-info nil
  "Info about the server."
  local)

(def-kom-var lyskom-server-version-info nil
  "Version information about the client."
  local)

(def-kom-var lyskom-server-name ""
  "The name of the server."
  inherited)

(def-kom-var lyskom-server-port nil
  "The port we are connected to."
  local)

(def-kom-var lyskom-buffer-list nil
  "List of all LysKOM buffers.")

(def-kom-var lyskom-static-session-info-cache nil
  "Cache of session."
  local)

(def-kom-var lyskom-conf-cache nil
  "Cache of conference statuses."
  local)

(def-kom-var lyskom-static-server-info nil
  "Cache of static-server-info"
  local)

(def-kom-var lyskom-stats-description nil
  "Cache of get-stats-description"
  local)

(def-kom-var lyskom-uconf-cache nil
  "Cache of small conference statuses."
  local)

(def-kom-var lyskom-pers-cache nil
  "Cache of person statuses."
  local)

(def-kom-var lyskom-text-cache nil
  "Cache of text statuses."
  local)

(def-kom-var lyskom-text-mass-cache nil
  "Cache of texts."
  local)

(def-kom-var lyskom-marked-text-cache nil
  "Cache of marks of all texts the current user has marked. "
  local)

(def-kom-var lyskom-is-parsing t
  "True when parsing a result.
This is used to prevent parallel parsing since the parser is not reentrant."
  local)

(def-kom-var lyskom-string-bytes-missing 0
  "Number of bytes missing in the unparsed buffer when parsing a string.
Set when parsing a string and there were not enough bytes in the buffer
with the unparsed bytes. This variable is used to prevent reparsing before 
the string is complete.
This variable is buffer-local in the unparsed-buffer."
  local
  inherited)

(def-kom-var lyskom-last-viewed 0       ;
  "Position of the first char of the last line that the user has had
time to view. This is normally the pos of the first char of the prompt."
  local)

(def-kom-var lyskom-mode-map nil
  "Keymap used in LysKOM mode."
  local)


(def-kom-var lyskom-reading-list nil
  "List of articles to read in the current conference.
Each element is a read-info. Only one of the elements is of the type CONF.
This one is located last in the list (except for the elements of the type 
REVIEW, REVIEW-TREE or REVIEW-MARK).
When reading an article with comments a list of the comments is built
recursively if the flag kom-read-depth-first is non-nil.
This is to keep track of the reading order.
Articles can exist in several of the read-info elements. All unread articles
in the conference are always present in the CONF type entry in this list even
if also in other entries. (COMM-IN, FOOTN-IN)

Some powerful reviewing commands requires to construct a list of articles that
should be read. These use the type REVIEW. When reviewing trees and when
every viewed article is supposed to be followed by all its comments then the
type REVIEW-TREE is used.

The first element is a dummy."
  local)

(def-kom-var lyskom-to-do-list nil
  "List of conferences with unread texts.
Each element is a read-info. All have the type 'CONF and there is one for
every conference with unread articles that have already been prefetched.
The list is sorted in falling priority. 
When going to a conference the first element (the one with the highest
priority) is copied from this list to lyskom-reading-list.

The first element is a dummy."
  local)

(def-kom-var lyskom-quit-flag nil
  "A flag indicating if the filter was interrupted by C-g.
 It is set to the same value as quit-flag on filter exit.")

(def-kom-var lyskom-ignoring-async-list nil
  "A list of async messages we are currently ignoring.
Each element is a list. The car of the list is the message and the
remaining elements are whatever is suitable for that type of message.
See the checks in lyskom-parse-async for details."
  local)

(def-kom-var lyskom-inhibit-minibuffer-messages nil
  "A flag indicating whether asynchronous minibuffer messages are allowed.
If this variable is non-nil, no asynchronous messages will appear.")

(def-kom-var lyskom-is-saving nil
  "A flag indicating whether the server is saving at the moment.")

;;; These variables control prefetch of conf-stats, text-stats and texts:

(def-kom-var lyskom-prefetch-conf-tresh 50
  "If fewer than lyskom-prefetch-conf-tresh texts are known, ask for more
conf-stats from server.

This is currently not used."
  local)

(def-kom-var lyskom-prefetch-confs 10
  "Number of confs to ask about at once when checking for unread texts.

This is currently not used."
  local)

(def-kom-var lyskom-fetch-map-nos 100
  "Number of text-nos lyskom will fetch when fetching maps."
  local)

(def-kom-var lyskom-fetch-membership-length 100
  "Number of entries in the membership-list that is fetched at a time.")

(def-kom-var lyskom-prefetch-limit 10
  "Number of prefetch requests the client will try to keep going
at a time.")


;;;

(def-kom-var lyskom-unread-confs nil
  "List containing all unread confs."
  local)

(def-kom-var lyskom-dont-change-prompt nil
  "Non-nil during the entry of a text."
  local)

(def-kom-var lyskom-command-to-do 'unknown
  "Atom describing what command to do. See the function lyskom-what-to-do."
  local)

(def-kom-var lyskom-is-waiting nil
  "If non-nil, this is the condition for the waiting to be stopped.
If t, however, it means that the user is waiting for a text with a prompt.
It is a form that will be evaluated (using eval) every time the asynchronous
message \"new text\" is received.

This is used by the command kom-busy-wait."
  local)

(def-kom-var lyskom-current-conf 0
  "Current conference. 0 means user is not reading any conf."
  local)

(def-kom-var lyskom-current-text nil
  "Text-no of current text. nil means no text is current."
  local)

(def-kom-var lyskom-last-written nil
  "Text-no of last text written. nil means no text written."
  local)

(def-kom-var lyskom-last-seen-written nil
  "Text-no of last text read or written by the current user.
When a new text is written, this is set to the text number of that text.
When a text is read that was written by the current user, this is
set to that text."
  local)

(def-kom-var lyskom-previous-text nil
  "Text-no of previous text. Nil means no text."
  local)

(def-kom-var lyskom-normally-read-texts nil
  "Stack of texts that are read normally. Used for kom-review-last-normally-read."
  local)

(def-kom-var lyskom-current-subject ""
  "Current subject."
  local)

(def-kom-var lyskom-current-user-area nil
  "Text-no of user area that current settings come from."
  local)

(def-kom-var kom-saved-file-name (concat default-directory "kom-text")
  "**The default filename when saving a LysKOM text.

This file name is used by `kom-save-text' as the default filename
until a new filename has been chosen."
  server)

(def-kom-var lyskom-saved-file-name nil
  "After saving once, the default file name when saving a LysKOM text."
  local)

(def-kom-var lyskom-mode-hook nil
  "*'Hook to run when `lyskom-mode' is entered.")

(def-kom-var kom-quit-hook nil
  "**Hook to run when the LysKOM session is ended.

This hook is only run when the session ends by using `kom-quit' or
`kom-remote-quit'. The hook is not run is the session is forecfully
terminated."
  server-hook)

(def-kom-var kom-quit-when-idle t
  "Controls automatic quitting when LysKOM is full.

When set to `t', automatically end the session when LysKOM is full and
the session has been idle for a predetermined amount of time.

This is currently not implemented.")

(def-kom-var kom-permanent-filter-list nil
  "List of patterns to filter permanently."
  server)

(def-kom-var kom-session-filter-list nil
  "List of patterns to filter during this session."
  local)

(def-kom-var lyskom-text-no-prompts-defaults
  '(kom-delete-text
    kom-view
    kom-write-footnote
    kom-mark-text
    kom-unmark-text
    kom-add-recipient
    kom-add-copy
    kom-add-bcc
    kom-sub-recipient
    kom-move-text
    kom-move-text-tree
    kom-add-comment
    kom-sub-comment
    kom-add-cross-reference
    kom-save-text-body
    kom-add-footnote
    kom-sub-footnote
    kom-add-faq
    kom-add-no-comments
    kom-add-private-answer
    kom-add-request-confirm
    kom-add-server-faq
    kom-mark-unread
    kom-set-presentation
    kom-set-motd-text
    kom-will-person-read-text
    kom-compare-texts
    kom-diff-texts
    )
  "Commands that prompt for a text number rather than assume a default."
  inherited)

(def-kom-var kom-text-no-prompts nil
  "**Determines which commands ask for text numbers.

The value of this variable must be a list containing pairs of 
(`COMMAND' . `VALUE'). If `VALUE' is `t', `COMMAND' will prompt for text
numbers. If `VALUE' is nil, `COMMAND' will use a suitable default value."
  server
  inherited)


(def-kom-var lyskom-filter-list nil
  "List of patterns that are filtered."
  local)

(def-kom-var kom-create-text-hook nil
  "**Hook to run before creating a new text.
This hook is run just before the server call to create the text is made.

The hook is currently called with the following arguments:

  Argument          Contents
  ----------------------------------------------------------------
  `MESSAGE'         The message text

  `MISC-LIST'       The misc-info list

  `AUX-LIST'        The aux-item list

  `BUFFER'          The edit buffer

  `IS-ANONYMOUS'    Non-nil if the user is currently anonymous.
  ----------------------------------------------------------------

Additional arguments may be added in the future, so include 
`&rest reserved' as the last element of the parameter list.

The hook can change the message by modifying the variable
`full-message', the misc-info list by modifying `misc-list' and the
aux-item list by modifying `aux-list'. This is not encouraged and may
break in the future."
  local-hook)

(def-kom-var lyskom-create-text-hook nil
  "Obsolete synonym for kom-create-text-hook"
  local-hook)


(def-kom-var kom-new-text-hook nil
  "**Hook to run when a new text is created.

This hook is run after the prompt is removed if it shall be changed
but before the text \"Text 4711 created\" is printed in the message
area and before the new prompt is printed."
  local-hook)

(def-kom-var lyskom-new-text-hook nil
  "Obsolete synonym for kom-new-text-hook"
  local-hook)

(def-kom-var kom-deleted-text-hook nil
  "**Hook to run when a text is deleted.

This hook is run after the prompt is removed if it shall be changed but 
before the new prompt is printed."
  local-hook)

(def-kom-var lyskom-deleted-text-hook nil
  "Obsolete synonym for kom-deleted-text-hook."
  local-hook)

(def-kom-var kom-new-recipient-hook nil
  "**Hook to run when a text receives a new recipient.

This hook is run after the prompt is removed if it shall be changed
but before the new prompt is printed. It may not run if the text has
been marked as read in any conference other than the person's
letterbox."
  local-hook)

(def-kom-var lyskom-new-recipient-hook nil
  "Obsolete synonym for kom-new-recipient-hook."
  local-hook)

(def-kom-var kom-personal-message-hook nil
  "**Hook to run when a personal message is received.

When the hook is run, `sender' is bound to the conf-stat of the sender
of the message (or possibly `nil'), `recipient' is 0 if the message is
an alarm message and otherwise the conf-stat of the recipient, and
`message' is a string that holds the message."
  local-hook)

(def-kom-var lyskom-personal-message-hook nil
  "Obsolete synonym for kom-personal-message-hook."
  local-hook)


(def-kom-var lyskom-executing-command t
  "Non-nil means the client is executing a command.
Most commands can't be interrupted by another command."
  local)

(def-kom-var lyskom-current-command nil
  "The command currently being executed."
  local)

(def-kom-var lyskom-command-point nil
  "The point where the most recent command was started."
  local)

(def-kom-var lyskom-current-function nil
  "Sometimes set to the current high-level function being executed."
  local)

(def-kom-var lyskom-current-function-phase nil
  "Sometimes set to the phase of the current high-level function being
executed."
  local)

(def-kom-var lyskom-membership-is-read nil
  "t when the membership has been read."
  local)

(def-kom-var lyskom-is-writing nil
  "t when the user is writing a text."
  local)

(def-kom-var lyskom-debug-communications-to-buffer nil
  "Non-nil means all communications with the server is stored in a buffer.
The name is stored in lyskom-debug-communications-to-buffer-buffer.")

(def-kom-var lyskom-debug-communications-limit 60000
  "When set to an integer limits the communications log to that many
bytes. When set to a non-integer, the communications log is unlimited.
If a protocol error is detected, this limit will be reset to nil.

See lyskom-debug-communications-to-buffer")

(def-kom-var lyskom-backtrace-list nil
  "List containing debugging information.")
  
(def-kom-var lyskom-debug-what-i-am-doing t
  "Non-nil means asynchronous message 5 will be logged to the debug
  buffer. ")

(def-kom-var lyskom-is-anonymous nil
  "Non-nil means be a bit secretive about things. Not totally
  secretive of course, since the server doesn't allow that yet."
  local)

(def-kom-var lyskom-debug-communications-to-buffer-buffer "*kom*-debugs"
  "Name of the buffer to insert the communications with the server into if
lyskom-debug-communications-to-buffer is non-nil.")

(def-kom-var lyskom-doing-default-command nil
  "Non-nil if LysKOM is executing the default command."
  local)

(def-kom-var lyskom-first-time-around nil
  "Non-nil if LysKOM is being entered for the first time."
  local)

(def-kom-var lyskom-experimental-features nil
  "If non-nil, LysKOM is likely to blow up in your face."
  local)

(def-kom-var lyskom-format-experimental nil
  "If non-nil, LysKOM is likely to make a fool out of you."
  local)

(def-kom-var lyskom-count-var 0
  "This variable is used for counting things in the client, such as
unread texts in list-unread."
  local)

(def-kom-var lyskom-default-conf-string nil
  "The default string to use for an unknown conference.
Set this locally when inserting a conference name using
lyskom-format-insert if you want to replace the usual description of
an unknown conference.")

(def-kom-var lyskom-default-pers-string nil
  "The default string to use for an unknown person.
Set this locally when inserting a conference name using
lyskom-format-insert if you want to replace the usual description of
an unknown person.")


(def-kom-var lyskom-is-administrator nil
  "This variable is t if the user is in administrator mode and nil otherwise."
  local
  minibuffer)

(def-kom-var lyskom-last-personal-message-sender nil
  "Name of sender of last personal message received."
  local)

(def-kom-var lyskom-last-group-message-recipient nil
  "Name of target for last group message received."
  local)

(def-kom-var lyskom-last-message-recipient nil
  "Number of last async message recipient sent to."
  local)

(def-kom-var lyskom-is-new-user nil
  "An internal variable used in kom-start-anew.")

(def-kom-var lyskom-apo-timeout-s 1
  "Seconds timeout for accept-process-output.")

(def-kom-var lyskom-apo-timeout-ms nil
  "Microseconds timeout for accept-process-output.")

(def-kom-var lyskom-collate-table nil
  "Table mapping characters to an equivalence class."
  inherited)

(def-kom-var lyskom-char-classes nil
  "An assoc list from character to a list of equivalent strings.
See lyskom-compute-char-classes."
  inherited)

(def-kom-var lyskom-dont-read-user-area nil
  "If non-nil the user area will not be read on login."
  local)

(def-kom-var lyskom-allow-missing-subject nil
  "If non-nil allow texts without subjects.")

(def-kom-var kom-w3-simplify-body t
  "**Control stripping of color information from HTML.

When this variable is set to `t', strip color information from body
tags in HTML passed to w3. This is generally a good idea. When `nil',
don't strip color information from body tags. This is generally a bad
idea.

Values other than `t' and `nil' are reserved for future use."
  server)

(def-kom-var kom-format-show-images t 
  "**Controls in-line display of images.

When set to `t', attempt to display images in-line. When set to `nil', 
images are handled as normal texts.

Values other than `t' and `nil' are reserved for future use."
  server)


(def-kom-var kom-format-html-authors '((t . t))
  "**Determines from which authors we accept HTML.

Each element of this list is a pair \(`PERS' . `VAL'), where `PERS' is a
person number and `VAL' is `t' or `nil'. If `VAL' is `t', then format
HTML written by `PERS'. If `VAL' is `nil', don't. The special value
`t' for `PERS' determines the default.

Values other than those listed are reserved for future use." 
  server)

(def-kom-var lyskom-format-special 
  '(("html"               . (lyskom-format-html-w3m lyskom-format-html-w3 lyskom-format-html-plaintext))
    ("enriched"           . lyskom-format-enriched)
    ("^image/"            . lyskom-format-image)
    ("^text/html"          . (lyskom-format-html-w3m lyskom-format-html-w3 lyskom-format-html-plaintext))
    ("^text/enriched"      . lyskom-format-enriched)
    ("^text/"             . lyskom-format-plaintext)
    ("^x-kom/text"         . lyskom-format-plaintext)  ;Archaic alias for text/x-kom-basic.
    ("^x-kom/basic"        . lyskom-format-plaintext)  ;Archaic alias for text/x-kom-basic.
    ("^x-kom/user-area"    . lyskom-format-x-kom/user-area)
    ("^x-kom/\\."         . lyskom-format-))
  
  "AList of (FORMAT . FUNCTION) specifying functions that format texts
of that type. FORMAT is a symbol and FUNCTION is a function taking one
argument and returning a formatted string.")

(def-kom-var lyskom-send-text-transform-function nil
  "Function to call to transform text before sending it to the server.
The function should accept a single argument and return the transformed
texts that is to be sent to the server.")

(def-kom-var lyskom-slow-mode nil
  "Non-nil when in slow mode."
  local)

(def-kom-var lyskom-saved-read-only nil
  "Saved value of buffer-read-only when in slow mode."
  local)

(def-kom-var lyskom-read-conf-saved-inputs nil
  "Saved inputs from lyskom-read-conf."
  local)


(defvar lyskom-line-start-chars-string
  "\"$&'()*+-./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]_`abcdefghijklmnopqrstuvwxyz"
  "Characters that may start a line in a paragraph to be broken.")

(def-kom-var lyskom-line-start-chars nil
  "Computer-friendly version of lyskom-line-start-string.")


(def-kom-var lyskom-last-text-format-flags nil
  "List of flags specifying how the last text was reformatted. This variable
should be dynamically bound whenever it needs to be used.")

(def-kom-var lyskom-read-faqs nil
  "List of FAQs that have been read."
  inherited)

(def-kom-var lyskom-rejected-recommendations nil
  "List of invitations that have been rejected."
  inherited)

(def-kom-var lyskom-last-known-conf-no nil
  "Last known conference number."
  server)

(def-kom-var lyskom-last-known-pers-no nil
  "Last known conference number."
  server)

(defvar lyskom-xface-cache (make-vector 29 0))


;;; ======================================================================
;;; Event hooks
;;;

(def-kom-var lyskom-add-membership-hook nil
  "Functions to call when a membership is added."
  local-hook)

(def-kom-var lyskom-replace-membership-hook nil
  "Functions to call when a membership is replaced."
  local-hook)

(def-kom-var lyskom-remove-membership-hook nil
  "Functions to call when a membership is removed."
  local-hook)

(def-kom-var lyskom-new-membership-list-hook nil
  "Functions to call when the entire membership list is replaced."
  local-hook)


;;; ======================================================================
;;;; lyskom-tell-phrases-validation-keyword-list
;;; This is a list of keywords for kom-tell-phrases.
;;; These are the only keywords that are allowed in kom-tell-phrases.

;;; To coders of the elisp-client:
;;; If you add/delete a reference to any of these keywords make sure
;;; you update these changes.

;;; To everyone:
;;; The kom-tell-phrases list is checked against this list when the
;;; client is loaded, i.e. by lyskom-tell-phrases-validate that causes
;;; an error if any keyword is not present or any non-keyword is
;;; present.

(defvar kom-tell-phrases nil
  "**A list of phrases describing what the client is doing. 

Each element in the list is a pair \(`KEY' . `PHRASE') where KEY is one
of the keywords in `lykom-tell-phrases-validation-keyword-list' and
`PHRASE' is the phrase to sent to the server then the client is doing
what `KEY' describes.

If the value of this variable is `nil', suitable defaults for the
currently selected language will be selected.")

(defconst lyskom-tell-phrases-validation-keyword-list
  '(
    (kom-tell-silence)
    (kom-tell-send)
    (kom-tell-login)
    (kom-tell-read)
    (kom-tell-1st-pres)
    (kom-tell-write-comment)
    (kom-tell-write-footnote)
    (kom-tell-write-letter)
    (kom-tell-write-reply)
    (kom-tell-write-text)
    (kom-tell-conf-pres)
    (kom-tell-recover)
    (kom-tell-wait)
    (kom-tell-regret)
    (kom-tell-review)
    (kom-tell-change-name)
    (kom-tell-change-supervisor)
    (kom-tell-next-lyskom)
    )
  "Users must not change this constant, but are encouraged to change
the value of  kom-tell-phrases for fun.")

;;; ================================================================
;;; Commands lists that are removed from extended command depending on
;;; administrator status.

(defconst lyskom-admin-removed-commands
  '(kom-enable-adm-caps))
(defconst lyskom-noadmin-removed-commands
  '(kom-disable-adm-caps
    kom-remove-motd
    kom-set-motd
    kom-shutdown-server
    kom-sync-database
    kom-add-server-faq 
    kom-del-server-faq
    kom-change-server-faq
    kom-recommend-conference
    kom-change-privileges))


;;; ================================================================
;;; Symbolic error codes

(defvar lyskom-error-codes
  '((no-error . 0)
    (not-implemented . 2)
    (obsolete-call . 3)
    (invalid-password . 4)
    (string-too-long . 5)
    (login-first . 6)
    (login-disallowed . 7)
    (conference-zero . 8)
    (undefined-conference . 9)
    (undefined-person . 10)
    (access-denied . 11)
    (permission-denied . 12)
    (not-member . 13)
    (no-such-text . 14)
    (text-zero . 15)
    (no-such-local-text . 16)
    (local-text-zero . 17)
    (bad-name . 18)
    (index-out-of-range . 19)
    (conference-exists . 20)
    (person-exists . 21)
    (secret-public . 22)
    (letterbox . 23)
    (ldb-error . 24)
    (illegal-misc . 25)
    (illegal-info-type . 26)
    (already-recipient . 27)
    (already-comment . 28)
    (already-footnote . 29)
    (not-recipient . 30)
    (not-comment . 31)
    (not-footnote . 32)
    (recipient-limit . 33)
    (comment-limit . 34)
    (footnote-limit . 35)
    (mark-limit . 36)
    (not-author . 37)
    (no-connect . 38)
    (out-of-memory . 39)
    (server-is-crazy . 40)
    (client-is-crazy . 41)
    (undefined-session . 42)
    (regexp-error . 43)
    (not-marked . 44)
    (temporary-failure . 45)
    (long-array . 46)
    (anonymous-rejected . 47)
    (illegal-aux-item . 48)
    (aux-item-permission . 49)
    (unknown-async . 50)
    (internal-error . 51)
    (feature-disabled . 52)
    (message-not-sent . 53)
    (invalid-membership-type . 54)
    (invalid-range . 55)
    (invalid-range-list . 56)
    (undefined-measurement . 57)
    (priority-denied . 59)
    (weight-zero . 60)
    (bad-bool . 61)
    )
  )

;;; ================================================================
;;;          Externally defined variables (environment)


(def-kom-var kom-default-server nil
  "**Default LysKOM server.

Use this server to log in to LysKOM. Can be overridden by the
`KOMSERVER' environment variable.

The value of this variable must be a string or `nil'."
  local)

(def-kom-var lyskom-default-server nil
  "**This variable is reserved for internal use. See 
`kom-default-server' instead." 
  local)

(def-kom-var kom-default-user-name nil
  "**Default LysKOM user name.

The value of this variable must be a string, indicating the
default user name, an integer indicating the conference number or 
`nil' to indicate no default. If set to an integer, log in as the
user with that conference number. If set to a string, log in as the 
user with that name.

Overrides the environment variable `KOMNAME'."
  local)

(def-kom-var lyskom-default-user-name nil
  "**This variable is reserved for internal use. See 
`kom-default-user-name' instead."
  local)

(def-kom-var kom-default-password nil
  "**Default LysKOM password.

The value of this variable must be a string or `nil'. Overrides the 
environment variable `KOMPASSWORD' \(which should never be used)."
  local)

(def-kom-var lyskom-default-password nil
  "**This variable is resvered for internal use. See 
`kom-default-password' instead."
  local)

(def-kom-var mode-line-conf-name nil
  "Conf name that is present on the mode-line."
  local)

(def-kom-var mode-line-server-name nil
  "Server name that is present on the mode-line."
  local)


;;; ============================================================
;;; History lists
;;;

(defvar lyskom-command-history nil)
(defvar lyskom-expression-history nil)
(defvar lyskom-message-history nil)
(defvar lyskom-language-history nil)
(defvar lyskom-fast-reply-history nil)
(defvar lyskom-help-history nil)


;;; ============================================================

(defconst lyskom-comment-types-list '(COMM-IN FOOTN-IN))
(defconst lyskom-recpt-types-list '(RECPT CC-RECPT BCC-RECPT)
  "Types of recipients in LysKOM.
This variable must be sorted in order of importance, with full recipients
first, followed by successively more and more minor recipients. The reason
for this is in kom-sub-recipient, which sorts the recipient list using
the order of this list.")
(defconst lyskom-review-types-list '(REVIEW REVIEW-TREE
                                            REVIEW-MARK REVIEW-FAQ
                                            REVIEW-FAQ-TREE))

;;; ============================================================


(eval-and-compile (provide 'lyskom-vars))

;;; vars.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: macros.el,v 44.40 2004/07/18 14:58:05 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: macros.el
;;;;
;;;; This file contains the macros which must be loaded before lyskom can
;;;; be compiled.
;;;;

(setq lyskom-clientversion-long
      (concat lyskom-clientversion-long
	      "$Id: macros.el,v 44.40 2004/07/18 14:58:05 byers Exp $\n"))

;;;
;;; Require parts of the widget package. We do this to avoid generating
;;; errors later on. This sucks. 
;;;

(require 'custom)
(require 'widget)

;;; ======================================================================
;;; lyskom-traverse - traverse a sequence.
;;;

(defmacro lyskom-traverse (atom sequence &rest body)
  "Bind ATOM to each element in SEQUENCE and execute BODY.
Value returned is always nil."
  (let ((seq-sym (make-symbol "sequence"))
        (len-sym (make-symbol "len"))
        (idx-sym (make-symbol "index")))
    `(catch 'lyskom-traverse
       (let* ((,seq-sym ,sequence)
              (,idx-sym 0)
              (,len-sym (or (listp ,seq-sym)
                            (length ,seq-sym)))
              (,atom nil))
         (if (listp ,seq-sym)
             (while ,seq-sym
               (setq ,atom (car ,seq-sym))
               ,@body
               (setq ,seq-sym (cdr ,seq-sym)))
           (while (< ,idx-sym ,len-sym)
             (setq ,atom (aref ,seq-sym ,idx-sym))
             ,@body
             (setq ,idx-sym (1+ ,idx-sym))))))))


(defmacro lyskom-traverse-membership (var &rest forms)
  "Traverse the membership list.
Variable VAR is bound to each membership, in turn, and FORMS are evaluated."
  (let ((el-sym (make-symbol "el")))
    `(catch 'lyskom-traverse
       (let ((,el-sym (membership-list->head
                       (lyskom-with-lyskom-buffer (lyskom-mship-cache-data))))
             (,var nil))
         (while ,el-sym
           (setq ,var (mship-list-node->data ,el-sym))
           ,@forms
           (setq ,el-sym (mship-list-node->next ,el-sym)))))))


(defmacro lyskom-traverse-aux (atom sequence &rest body)
  "Bind ATOM to each element in SEQUENCE and execute BODY.
Value returned is always nil."
  (let ((seq-sym (make-symbol "aux-items")))
    `(catch 'lyskom-traverse
       (let ((,seq-sym ,sequence)
             (,atom nil))
         (while ,seq-sym
           (setq ,atom (car ,seq-sym))
           (if (not (aux-item-flags->deleted
                     (aux-item->flags ,atom)))
               (progn ,@body))
           (setq ,seq-sym (cdr ,seq-sym)))))))


(defmacro lyskom-traverse-break (&optional result)
  "Break a current lyskom-traverse"
  `(throw 'lyskom-traverse ,result))



(put 'lyskom-traverse-aux 'edebug-form-spec '(sexp form body))
(put 'lyskom-traverse-aux 'lisp-indent-hook 2)
(put 'lyskom-traverse-membership 'edebug-form-spec '(sexp body))
(put 'lyskom-traverse-membership 'lisp-indent-hook 1)
(put 'lyskom-traverse 'lisp-indent-hook 2)
(put 'lyskom-traverse 'edebug-form-spec '(sexp form body))


;;; ======================================================================
;;; lyskom-save-excursion Does not save point and mark.
;;;

(defmacro lyskom-save-excursion (&rest forms)
  "Save-excursion without saving point and mark."
  (list 'let (list '(__buffer__ (current-buffer)))
	(list 'unwind-protect
	      (cons 'progn
		    forms)
	      '(set-buffer __buffer__))))

(put 'lyskom-save-excursion 'edebug-form-spec t)
(put 'lyskom-save-excursion 'lisp-indent-hook 0)


(defmacro lyskom-with-lyskom-buffer (&rest forms)
  "Evaluate FORMS in the current LysKOM buffer."
  `(save-excursion
     (set-buffer lyskom-buffer)
     ,@forms))

(put 'lyskom-with-lyskom-buffer 'edebug-form-spec t)
(put 'lyskom-with-lyskom-buffer 'lisp-indent-hook 0)

;;; ======================================================================
;;; Some useful macros to make the code more readable.
;;;

(defmacro char-in-string (char string)
  "Return t if the character CHAR is member of STRING. Otherwise return nil."
  (list 'null
	(list 'not
	      (list 'string-match
		    (list 'regexp-quote
			  (list 'char-to-string char))
		    string))))

(defmacro ++ (var)
  "Increment the variable VAR and return the value."
  (list 'setq var (list '1+ var)))

(defmacro -- (var)
  "Decrement the variable VAR and return the value."
  (list 'setq var (list '1- var)))

(eval-and-compile
  (if (fboundp 'when)
      nil
    (defmacro when (expr &rest body)
      "Execute BODY if EXPR evaluates to non-nil"
      (list 'if expr (cons 'progn body)))
    (put 'when lisp-indent-function 1)
    (put 'when 'edebug-form-spec t)))

(eval-and-compile
  (if (fboundp 'unless)
      nil
    (defmacro unless (expr &rest body)
      "Execute BODY if EXPR evaluates to non-nil"
      (append (list 'if expr nil) body))
    (put 'unless lisp-indent-function 1)
    (put 'unless 'edebug-form-spec t)))


;;; ======================================================================
;;; Multiple blocking read from server
;;;

(defmacro blocking-do-multiple (bind-list &rest body)
  "Bind variables according to BIND-LIST and then eval BODY.
The value of the last form in BODY is returned.
Each element in BIND-LIST is a list (SYMBOL FORM) which binds SYMBOL to
the result of the server call FORM, which is the same as used in blocking-do.
All the forms in BIND-LIST are evaluated before any symbols are bound."
  (let ((index 0))
    `(let ((lyskom-multiple-bind-sym
            (lyskom-blocking-do-multiple
             (list ,@(mapcar (lambda (x) 
                               `(list ',(car (car (cdr x)))
                                      ,@(cdr (car (cdr x)))))
                             bind-list)))))
       (let (,@(mapcar (lambda (bpat)
                         (prog1
                             `(,(car bpat) (elt lyskom-multiple-bind-sym
                                                ,index))
                           (setq index (1+ index))))
                       bind-list))
         ,@body))))


(put 'blocking-do-multiple 'edebug-form-spec '(sexp body))
(put 'blocking-do-multiple 'lisp-indent-function 1)


;;; ======================================================================
;;; Some commands generat async messages we don't really want
;;;

(defmacro lyskom-ignoring-async (async &rest body)
  `(let ((lyskom-ignoring-async-list 
          (cons (list ,@async) lyskom-ignoring-async-list)))
     ,@body))

(put 'lyskom-ignoring-async 'edebug-form-spec
     '(sexp body))

(put 'lyskom-ignoring-async 'lisp-indent-function 1)


;;; ======================================================================
;;; These macros do magic things to the compiler to avoid gratuitous
;;; compiler warnings.
;;;

(eval-and-compile (defvar lyskom-expected-unresolved-functions nil))
(eval-and-compile (defvar lyskom-expected-unresolved-functions-temp nil))

(defmacro lyskom-external-function (fn)
  `(eval-when-compile
       (setq lyskom-expected-unresolved-functions
             (cons ',fn lyskom-expected-unresolved-functions))))

(defmacro lyskom-with-external-functions (fns &rest body)
  "Ignore warnings about unresolved functions FNS when compiling BODY."
  `(progn (eval-when-compile
            (and (boundp 'byte-compile-unresolved-functions)
                 (setq lyskom-expected-unresolved-functions-temp
                       (cons (delq nil
                                   (mapcar (lambda (fn)
                                             (if (assq fn byte-compile-unresolved-functions)
                                                 nil
                                               fn))
                                           ',fns))
                             lyskom-expected-unresolved-functions-temp))))
          ,@body
          (eval-when-compile
            (and (boundp 'byte-compile-unresolved-functions)
                 (mapcar (lambda (fn) (and fn (setq byte-compile-unresolved-functions
                                                    (delq (assq fn byte-compile-unresolved-functions)
                                                          byte-compile-unresolved-functions))))
                         (car lyskom-expected-unresolved-functions-temp)))
            (setq lyskom-expected-unresolved-functions-temp
                  (cdr lyskom-expected-unresolved-functions-temp)))))


(defmacro lyskom-end-of-compilation ()
  `(progn 
     (eval-when-compile
       (progn
         (if (and (boundp 'byte-compile-unresolved-functions)
                  (consp (car-safe byte-compile-unresolved-functions))
                  (symbolp (car-safe (car-safe 
                                      byte-compile-unresolved-functions))))
             (progn
               (mapcar (function (lambda (x)
                                   (setq byte-compile-unresolved-functions
                                         (delq
                                          (assq x
                                                byte-compile-unresolved-functions)
                                          byte-compile-unresolved-functions))))
                       lyskom-expected-unresolved-functions)
               ))

         (if lyskom-compatibility-definitions
             (message "Compatibility definitions: %s"
                      (mapconcat '(lambda (sym)
                                    (symbol-name sym))
                                 lyskom-compatibility-definitions
                                 ", ")))))))

;;; ============================================================
;;; Keymap handling
;;;

(defmacro lyskom-use-local-map (keymap)
  "Use keymap KEYMAP as local map in this buffer. KEYMAP is made local in
the current buffer, and its value is copied from the LysKOM buffer."
  (` (progn (make-local-variable (quote (, keymap)))
            (setq (, keymap)
                  (lyskom-default-value (quote (, keymap))))
            (use-local-map (, keymap)))))

(defmacro lyskom-try-define-key (map seq fn)
  `(condition-case nil
       (define-key ,map ,seq ,fn)
     (error nil)))


;;; ============================================================
;;; Widget gunk
;;;

(defmacro lyskom-widget-wrapper (fn file)
  `(eval-and-compile
     (if (not (fboundp ',fn))
         (autoload ',fn ,file))))

(lyskom-widget-wrapper define-widget "widget")
(lyskom-widget-wrapper widget-at "wid-edit")
(lyskom-widget-wrapper widget-value "wid-edit")
(lyskom-widget-wrapper widget-button-click "wid-edit")
(lyskom-widget-wrapper widget-setup "wid-edit")
(lyskom-widget-wrapper widget-value-set "wid-edit")
(lyskom-widget-wrapper widget-insert "wid-edit")
(lyskom-widget-wrapper widget-create "wid-edit")
(lyskom-widget-wrapper widget-get "wid-edit")
(lyskom-widget-wrapper widget-put "wid-edit")

;;; ============================================================
;;; Signal gunk
;;;

(defmacro lyskom-ignore-errors (&rest forms)
  (` (condition-case nil
         (progn (,@ forms))
       (error nil))))

(put 'ignore-errors 'edebug-form-spec
     '(sexp form body))

(defun lyskom-assert-error (&rest args)
  (save-excursion
    (save-match-data
      (if (not (and (boundp 'lyskom-buffer)
                    (bufferp lyskom-buffer)))
          (let ((debug-on-error t))
            (apply 'error args))
        (set-buffer lyskom-buffer)
        (lyskom-save-backtrace)
        (apply 'message args)
        (lyskom-insert-before-prompt (concat (apply 'format args) "\n"))
        (lyskom-insert-before-prompt (format "%s\n" (car (car lyskom-backtrace-list))))
        (lyskom-insert-before-prompt (format "%s\n" (elt (car lyskom-backtrace-list) 1)))))))

(eval-and-compile
  (if lyskom-debug-compile
      (defsubst lyskom-assert (check &rest args)
        (or check (if args (apply 'lyskom-assert-error args)
                    (lyskom-assert-error "Assertion failed"))))
    (defsubst lyskom-assert (check &rest args) nil)))

(eval-and-compile
  (if lyskom-debug-compile
      (defmacro lyskom-debug-forms (&rest forms)
        `(progn ,@forms))
    (defmacro lyskom-debug-forms (&rest forms))))

;;; ============================================================
;;; Local variables
;;;

(defmacro lyskom-setq-default (name value)
  (` (lyskom-set-default (quote (, name))
                         (, value))))

(defmacro lyskom-ref-no ()
  `(prog1 lyskom-ref-no
     (setq lyskom-ref-no (1+ lyskom-ref-no))
     (when (< lyskom-ref-no 0) (setq lyskom-ref-no 1))))


(defsubst lyskom-mime-content-type (ct) (car ct))
(defsubst lyskom-mime-content-type-get (ct param) (cdr (assq param (cdr ct))))

(eval-and-compile (provide 'lyskom-macros))

;;; Local Variables: 
;;; eval: (put 'lyskom-traverse 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-save-excursion 'lisp-indent-hook 0)
;;; eval: (put 'lyskom-ignore-errors 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-with-external-functions 'lisp-indent-hook 1)
;;; end: 
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: compatibility.el,v 44.74 2004/10/29 10:41:09 _cvs_pont_lyskomelisp Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;; Copyright (C) 2001 Free Software Foundation, Inc.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: compatibility.el
;;;;
;;;; This file contains functions that may not exist in all supported
;;;; versions of Gnu Emacs. XEmacs-specific and Emacs 18-specific code
;;;; should go in some other file.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: compatibility.el,v 44.74 2004/10/29 10:41:09 _cvs_pont_lyskomelisp Exp $\n"))


;;; ============================================================
;;; Utility macros

(eval-and-compile
  (defvar lyskom-compatibility-definitions nil
    "Functions defined or redefined because they are incompatible with LysKOM")


(defmacro lyskom-provide-function (name &rest rest)
  "If NAME is not already defined, define it as a function."
  `(eval-and-compile
     (or (fboundp ',name)
         (progn (setq lyskom-compatibility-definitions
                      (cons ',name lyskom-compatibility-definitions))
                (defun ,name ,@rest)))))

(defmacro lyskom-provide-macro (name &rest rest)
  "If NAME is not already defined, define it as a macro."
  `(eval-and-compile
     (or (fboundp ',name)
         (progn (setq lyskom-compatibility-definitions
                      (cons ',name lyskom-compatibility-definitions))
                (defmacro ,name ,@rest)))))

(defmacro lyskom-macro-alias (name args &rest body)
  "Create a LysKOM name alias. If NAME is defined, then
lyskom-NAME will be an alias to it. Otherwise, lyskom-NAME
will be defined to be a macro with ARGS and BODY."
  (let ((alias-name (intern (concat "lyskom-" (symbol-name name)))))
    `(eval-and-compile
       (if (fboundp ',name)
           (defalias ',alias-name ',name)
         (setq lyskom-compatibility-definitions
               (cons ',name lyskom-compatibility-definitions))
         (defmacro ,alias-name ,args ,@body)))))

(defmacro lyskom-function-alias (name args &rest body)
  "Create a LysKOM name alias. If NAME is defined, then
lyskom-NAME will be an alias to it. Otherwise, lyskom-NAME
will be defined to be a function with ARGS and BODY."
  (let ((alias-name (intern (concat "lyskom-" (symbol-name name)))))
    `(eval-and-compile
       (if (fboundp ',name)
           (defalias ',alias-name ',name)
         (setq lyskom-compatibility-definitions
               (cons ',name lyskom-compatibility-definitions))
         (defun ,alias-name ,args ,@body)))))

(defmacro lyskom-xemacs-or-gnu (xemacs-form gnu-form)
  "Eval XEMACS-FORM in XEmacs and GNU-FORM in Gnu Emacs."
  (if (string-match "XEmacs" (emacs-version))
      xemacs-form
    gnu-form))
)



;;; ======================================================================
;;; Various definitions


;; Lots of Emacsen have buggy definitions of kbd (or no definition at
;; all) Although it's crufty to redefine a function from subr.el, I
;; will do so if it appears to be misbehaving. Don't like it? Tough!

(eval-and-compile
  (and (condition-case nil
           (or (equal (kbd (identity "<down-mouse-2>"))
                      [down-mouse-2])
               (error "Bad definition of kbd"))
         (error t))
       (progn (fmakunbound 'kbd)
              (lyskom-provide-macro kbd (keys)
                "Convert KEYS to the internal Emacs key representation.
KEYS should be a string in the format used for saving keyboard macros
\(see `insert-kbd-macro')."
                (if (or (stringp keys)
                        (vectorp keys))
                    (read-kbd-macro keys)
                  `(read-kbd-macro ,keys))))))


;; Functions mostly from XEmacs that we use

(lyskom-macro-alias compiled-function-p (arg) `(byte-code-function-p ,arg))
(lyskom-function-alias characterp (obj) (integerp obj))
(lyskom-function-alias int-to-char (obj) obj)
(lyskom-function-alias char-to-int (c) c)
(lyskom-function-alias signum (num) (cond ((< num 0) -1)
                                          ((> num 0) 1)
                                          (t 0)))

;; If we use lyskom-function-alias here we'll get an obsolecense
;; warning about screen-width. This way the compiler won't notice :-)

(if (fboundp 'frame-width)
    (defalias 'lyskom-frame-width 'frame-width)
  (fset 'lyskom-frame-width 'screen-width))

;; Some minibuffer compatibility stuff

(lyskom-with-external-functions (temp-minibuffer-message)
  (lyskom-function-alias minibuffer-contents () (buffer-string))
  (lyskom-function-alias minibuffer-message (message) 
    (temp-minibuffer-message message)))

;; Definition of map-keymap that hopefully works like the one in XEmacs
;; except that the sort-first argument is ignored.

(lyskom-function-alias map-keymap (fn keymap &optional sort-first)
  "Map FN over all bindings in KEYMAP."
  (let ((r 0))
    (when (keymapp keymap)
      (when (symbolp keymap) (setq keymap (symbol-value keymap)))
      (let ((keymap (cdr keymap))
            (el nil))
        (while (and keymap (not (keymapp keymap)))
          (setq el (car keymap) keymap (cdr keymap))
          (cond ((vectorp el)
                 (while (< r (length el))
                   (if (aref el r)
                       (funcall fn r (aref el r)))
                   (setq r (1+ r))))
                ((char-table-p el)
                 (map-char-table fn el))
                (t (funcall fn (car el) (cdr el)))))))))


;; set-keymap-parent also comes from XEmacs

(lyskom-function-alias set-keymap-parent (keymap new-parent)
  (let ((tail keymap))
    (while (and tail (cdr tail) (not (eq (car (cdr tail)) 'keymap)))
      (setq tail (cdr tail)))
    (if tail
        (setcdr tail new-parent))))


;; XEmacs and Gnu Emacs don't use the same names for mouse events
;; and such. This is to help us deal with that.

(defconst lyskom-gnu-keysym
  '((button1   . "<down-mouse-1>")
    (button2   . "<down-mouse-2>")
    (button3   . "<down-mouse-3>")
    (button1up . "<mouse-1>")
    (button2up . "<mouse-2>")
    (button3up . "<mouse-3>")))

(defconst lyskom-xemacs-keysym
  '((button1   . "<button1>")
    (button2   . "<button2>")
    (button3   . "<button3>")
    (button1up . "<button1up>")
    (button2up . "<button2up>")
    (button3up . "<button3up>")))


(defun lyskom-keys (sym)
  "Look up the key description for key SYM."
  (cdr (assq sym (lyskom-xemacs-or-gnu lyskom-xemacs-keysym
                                       lyskom-gnu-keysym))))



;;; ============================================================
;;; MULE stuff
;;;
;;; We used to define dummy versions of basic MULE functions so
;;; we could code using the standard names. We don't do that any
;;; more. Instead, we define aliases in our own namespace.

(defvar enable-multibyte-characters nil)
(lyskom-function-alias set-buffer-multibyte (arg)
  (put 'enable-multibyte-characters 'permanent-local t)
  (make-local-variable 'enable-multibyte-characters)
  (setq enable-multibyte-characters arg))

(lyskom-function-alias set-process-coding-system (proc &optional encoding decoding)) 
(lyskom-function-alias encode-coding-string (str coding-system) (copy-sequence str))
(lyskom-function-alias decode-coding-string (str coding-system) (copy-sequence str))
(lyskom-function-alias string-bytes (str) (length str))
(lyskom-function-alias check-coding-system (name) (error "No such coding system"))
(lyskom-function-alias find-coding-systems-for-charsets (cs) nil)
(lyskom-function-alias coding-system-get (cs prop) nil)
(lyskom-function-alias char-width (c) 1)
(lyskom-function-alias find-charset-string (str) '(ascii))
(lyskom-function-alias string-as-unibyte (str) str)
(lyskom-function-alias string-make-unibyte (str) str)
(lyskom-function-alias string-make-multibyte (str) str)
(lyskom-function-alias multibyte-string-p (str) nil)
(lyskom-function-alias charsetp (arg) nil)
(lyskom-function-alias coding-system-type (arg) nil)
(lyskom-function-alias coding-system-property (arg sym) (lyskom-coding-system-get arg sym))
(lyskom-function-alias split-string (string &optional separators)
  (string-split (or separators "[ \f\t\n\r\v]+") string))

;; Detect buggy versions of encode-coding-string and
;; decode-coding-string such as those provided by APEL (part of TM and
;; often included in XEmacs)

(defun lyskom-buggy-encode-coding-string (str coding-system) str)
(eval-and-compile
  (if (let ((test "TEM")) (eq (lyskom-encode-coding-string test 'raw-text) test))
      (progn (fset 'lyskom-buggy-encode-coding-string
                   (symbol-function 'lyskom-encode-coding-string))
             (defun lyskom-encode-coding-string (str coding-system)
               (copy-sequence (lyskom-buggy-encode-coding-string str coding-system))))))

(defun lyskom-buggy-decode-coding-string (str coding-system) str)
(eval-and-compile
  (if (let ((test "TEM")) (eq (lyskom-decode-coding-string test 'raw-text) test))
      (progn (fset 'lyskom-buggy-decode-coding-string
                   (symbol-function 'lyskom-decode-coding-string))
             (defun lyskom-decode-coding-string (str coding-system)
               (copy-sequence (lyskom-buggy-decode-coding-string str coding-system))))))


;; defmacro lyskom-encode-coding-char in XEmacs so the compiled code
;; is quicker. In Gnu Emacs define it as a function.
;;
;; The definition is made at compile-time to avoid getting warnings 
;; about encode-coding-char.

(eval-and-compile
  (cond ((eval-when-compile (string-match "XEmacs" (emacs-version)))
         (defmacro lyskom-encode-coding-char (c system) c))
        ((eval-when-compile (fboundp 'encode-coding-char))
         (defun lyskom-encode-coding-char (c system)
           (let ((s (encode-coding-char c system)))
             (if (and s (= (length s) 1))
                 (elt s 0)))))
        (t (defmacro lyskom-encode-coding-char (c system) c))))


;; It seems that string-width is buggy with respect to handling
;; unibyte strings in multibyte environments or vice versa. Or
;; something like that. There has got to be a good explanation
;; for the mess below.

(eval-and-compile
  (if (fboundp 'string-width)
      (defalias 'lyskom-original-string-width 'string-width)
    (defmacro lyskom-original-string-width (s) `(length ,s)))
  (lyskom-xemacs-or-gnu
   (defalias 'lyskom-string-width 'string-width)
   (defun lyskom-string-width (str)
     (cond ((and (lyskom-multibyte-string-p str)
                 (null enable-multibyte-characters))
            (lyskom-original-string-width (lyskom-string-make-unibyte str)))
           ((and (null (lyskom-multibyte-string-p str))
                 enable-multibyte-characters)
            (lyskom-original-string-width (lyskom-string-make-multibyte str)))
           (t (lyskom-original-string-width str))))))


;;; ================================================================
;;; Faces and windows and stuff

(lyskom-function-alias frame-property (frame property &optional default)
  (or (cdr (assq property (frame-parameters frame))) default))

(lyskom-function-alias face-background (face) nil)
(lyskom-function-alias face-foreground (face) nil)

(lyskom-function-alias find-face (face) (and (facep face) face))

(defun lyskom-make-face (name temporary)
  "Like make-face in XEmacs"
  (lyskom-xemacs-or-gnu (make-face name nil temporary)
                        (make-face name)))

(if (not (lyskom-find-face 'strikethrough))
    (progn (make-face 'strikethrough)
           (if (eval-when-compile (fboundp 'set-face-strikethrough-p))
               (set-face-strikethru-p 'strikethrough t)
             (set-face-underline-p 'strikethrough t))))


(defun lyskom-get-buffer-window-list (buffer &optional minibuf frame)
  "Return windows currently displaying BUFFER, or nil if none.
See `walk-windows' for the meaning of MINIBUF and FRAME."
  (let ((buffer (if (bufferp buffer) buffer (get-buffer buffer))) windows)
    (walk-windows (function (lambda (window)
			      (if (eq (window-buffer window) buffer)
				  (setq windows (cons window windows)))))
		  minibuf frame)
    windows))


; ==================================================================
; Image display

(lyskom-function-alias display-images-p () nil)
(lyskom-function-alias put-image (what where) nil)
(lyskom-function-alias create-image (file-or-data) nil)

;;; ================================================================
;;; Color stuff

(lyskom-function-alias color-specifier-p (obj) nil)
(lyskom-function-alias color-name (obj) nil)

(lyskom-with-external-functions (color-rgb-components
                                 make-specifier
                                 set-specifier)
  (eval-and-compile
    (cond ((and (fboundp 'color-rgb-components)
                (fboundp 'make-specifier)
                (fboundp 'set-specifier))
           (defun lyskom-color-values (color)
             (when (stringp color)
               (let ((spec nil))
                 (set-specifier (setq spec (make-specifier 'color)) color)
                 (setq color spec)))
             (color-rgb-components color)))
          ((fboundp 'color-values) (fset 'lyskom-color-values 'color-values))
          ((fboundp 'x-color-values) (fset 'lyskom-color-values 'x-color-values)))))



;;; ======================================================================
;;; Event stuff

(lyskom-with-external-functions (event-start)
  (lyskom-function-alias event-glyph (e))
  (lyskom-function-alias event-point (e)
    "Return the character position of the given mouse event.
If the event did not occur over a window, or did not occur over text,
then this returns nil.  Otherwise, it returns an index into the buffer
visible in the event's window."
    (car (cdr (event-start e))))

  (lyskom-function-alias event-closest-point (e)
    "Return the character position closest to the mouse event EVENT."
    (car (cdr (event-start e)))))


;;; ======================================================================
;;; Platform-specific stuff

(lyskom-provide-function w32-shell-execute (&rest args)
  "Dummy function that raises an error."
  (error "w32-shell-execute undefined"))



;;; ================================================================
;;; We provide these functions in the default namespace since there is
;;; no reason to beleive that (a) the definitions suck (they're taken
;;; from either XEmacs or Gnu Emacs) and (b) no package should be
;;; using them to figure out what environment it is running in
;;; (unlike, say, the MULE functions).
;;;
;;; There are also a few functions (regexpp and functionp) that may
;;; appear in some version of Emacs, and if they do we accept those
;;; definitions.
;;;

(lyskom-provide-function last (x &optional n)
  "Returns the last link in the list LIST.
With optional argument N, returns the Nth-to-last link (default 1)."
  "Returns the last link in the list LIST.
With optional argument N, returns Nth-to-last link (default 1)."
  (if n
      (let ((m 0) (p x))
	(while (consp p) (setq m (1+ m)) (setq p (cdr p)))
	(if (<= n 0) p
	  (if (< n m) (nthcdr (- m n) x) x)))
    (while (consp (cdr x)) (setq x (cdr x)))
    x))

(lyskom-provide-function plist-member (plist prop)
  "Return non-nil if PLIST has the property PROP.
PLIST is a property list, which is a list of the form
\(PROP1 VALUE1 PROP2 VALUE2 ...\). PROP is a symbol.
Unlike `plist-get', this allows you to distinguish between a missing
property and a property with the value nil."
      (while (and plist (not (eq (car plist) prop)))
        (setq plist (cdr (cdr plist))))
      (and plist t))

;; The make-temp-file function below is taken verbatim from Emacs 21.2.
(lyskom-provide-function make-temp-file (prefix &optional dir-flag)
  "Create a temporary file.  The returned file name (created by
appending some random characters at the end of PREFIX, and expanding
against `temporary-file-directory' if necessary, is guaranteed to
point to a newly created empty file.  You can then use `write-region'
to write new data into the file.

If DIR-FLAG is non-nil, create a new empty directory instead of a file."
  (let (file)
    (while (condition-case ()
	       (progn
		 (setq file
		       (make-temp-name
			(expand-file-name prefix 
                                          (lyskom-xemacs-or-gnu
                                           (temp-directory)
                                           temporary-file-directory))))
		 (if dir-flag
		     (make-directory file)
		   (write-region "" nil file nil 'silent nil))
		 nil)
             (file-already-exists t))
      ;; the file was somehow created by someone else between
      ;; `make-temp-name' and `write-region', let's try again.
      nil)
    file))

(lyskom-provide-function replace-in-string
    (str regexp newtext &optional literal)
  "Replaces all matches in STR for REGEXP with NEWTEXT string.
Optional LITERAL non-nil means do a literal replacement.
Otherwise treat \\ in NEWTEXT string as special:
  \\& means substitute original matched text,
  \\N means substitute match for \(...\) number N,
  \\\\ means insert one \\."
  (if (not (stringp str))
      (error "(replace-in-string): First argument must be a string: %s" str))
  (if (stringp newtext)
      nil
    (error "(replace-in-string): 3rd arg must be a string: %s"
	   newtext))
  (let ((rtn-str "")
	(start 0)
	(special)
	match prev-start)
    (while (setq match (string-match regexp str start))
      (setq prev-start start
	    start (match-end 0)
	    rtn-str
	    (concat
	      rtn-str
	      (substring str prev-start match)
	      (cond (literal newtext)
		    (t (mapconcat
			 (function
			   (lambda (c)
			     (if special
				 (progn
				   (setq special nil)
				   (cond ((eq c ?\\) "\\")
					 ((eq c ?&)
					  (substring str
						     (match-beginning 0)
						     (match-end 0)))
					 ((and (>= c ?0) (<= c ?9))
					  (if (> c (+ ?0 (length
							   (match-data))))
					      ;; Invalid match num
					      (error "(replace-in-string) Invalid match num: %c" c)
					    (setq c (- c ?0))
					    (substring str
						       (match-beginning c)
						       (match-end c))))
					 (t (char-to-string c))))
			       (if (eq c ?\\) (progn (setq special t) nil)
				 (char-to-string c)))))
			 newtext ""))))))
    (concat rtn-str (substring str start))))


(lyskom-provide-function buffer-live-p (object)
  "T of OBJECT is an editor buffer that has not been deleted."
  (and (bufferp object)
       (buffer-name object)))

(lyskom-provide-function string-to-vector (string)
  "Return a vector of characters in STRING."
  (let ((len (length string)) (i 0) val)
    (setq val (make-vector len 0))
    (while (< i len)
      (aset val i (aref string i))
      (setq i (1+ i)))
    val))

(lyskom-provide-function copy-tree (l)
  "Recursively copy the list L"
  (cond ((atom l) l)
        (t (cons (copy-tree (car l))
                 (copy-tree (cdr l))))))

(lyskom-provide-function functionp (obj)
  "Returns t if OBJ is a function, nil otherwise."
  (cond ((symbolp obj) (fboundp obj))
        ((subrp obj))
        ((lyskom-compiled-function-p obj))
        ((consp obj) (and (eq (car obj) 'lambda) (listp (car (cdr obj)))))
        (t nil)))

(lyskom-provide-function regexpp (re)
  "Return non-nil if RE looks like a valid regexp."
  (let ((result t))
    (save-match-data
      (condition-case nil
          (string-match re "")
        (error (setq result nil))))
    result))

(lyskom-macro-alias char-before (&optional pos buffer)
  `(save-excursion
     (save-restriction 
       (widen)
       ,@(if buffer `((set-buffer ,buffer)))
       ,(if pos 
	    `(if (or (> ,pos (point-max))
		     (<= ,pos (point-min)))
		 nil
	       (goto-char ,pos)
	       (preceding-char))
	   `(if (<= (point) (point-min))
		nil
	      (preceding-char))))))

(lyskom-function-alias make-hash-table (&rest args)
  "Create and return a new hash table.

This is a limited emulation of the make-hash-table function available
in some Emacsen. It ignores all arguments. The only test supported is
`eq'."
  (let ((test (car (cdr (memq ':test args)))))
    (or (eq test 'eq) (lyskom-error "internal error: invalid hash function"))
    (cons 'HASH nil)))

(lyskom-function-alias gethash (key table)
  "Look up KEY in TABLE and return its associated value.

This is a limited emulation of the gethash function available in some
Emacsen. It does not support the default argument."
  (cdr (assq key (cdr table))))

(lyskom-function-alias puthash (key value table)
  "Associate KEY with VALUE in hash table TABLE.
If KEY is already present in table, replace its current value with
VALUE.

This is a limited emulation of the puthash function available in some
Emacsen."
  (let ((tmp (assq key (cdr table))))
    (if tmp
        (setcdr tmp value)
      (setcdr table (cons (cons key value) (cdr table))))))

(lyskom-function-alias remhash (key table)
  "Remove KEY from TABLE.

This is a limited emulation of the remhash function available in some
Emacsen."
  (let ((tmp (assq key (cdr table))))
    (when tmp
      (setcdr table (delq tmp (cdr table))))))


;;; ================================================================
;;; Some symbols are self-evaluating. They're not in all versions
;;; of Emacs that we would like to support. So we make them
;;; self-evaluating here.

;; This code looks the way it does in order to avoid warnings in
;; Emacs 21.

(eval-when-compile
  (if (boundp ':lyskom-is-this-self-evaluating)
      (defmacro lyskom-make-self-evaluating (var))
    (defmacro lyskom-make-self-evaluating (var)
      `(eval-and-compile (set ',var ',var)))))

(lyskom-make-self-evaluating :default)
(lyskom-make-self-evaluating :mime-charset)
(lyskom-make-self-evaluating :default-help-echo)
(lyskom-make-self-evaluating :group)
(lyskom-make-self-evaluating :automatic)
(lyskom-make-self-evaluating :read-only)
(lyskom-make-self-evaluating :filter)
(lyskom-make-self-evaluating :filter-args)
(lyskom-make-self-evaluating :constraint)
(lyskom-make-self-evaluating :save)
(lyskom-make-self-evaluating :refer)
(lyskom-make-self-evaluating :width)
(lyskom-make-self-evaluating :prompt)
(lyskom-make-self-evaluating :align)
(lyskom-make-self-evaluating :format)
(lyskom-make-self-evaluating :output)
(lyskom-make-self-evaluating :subject-mode)
(lyskom-make-self-evaluating :subject-indent)
(lyskom-make-self-evaluating :text)
(lyskom-make-self-evaluating :text-stat)
(lyskom-make-self-evaluating :text-no)
(lyskom-make-self-evaluating :subjects)
(lyskom-make-self-evaluating :subject-last)
(lyskom-make-self-evaluating :comment-order)
(lyskom-make-self-evaluating :unique)
(lyskom-make-self-evaluating :weight)
(lyskom-make-self-evaluating :prompt-format)
(lyskom-make-self-evaluating :dead-ok)
(lyskom-make-self-evaluating :mark)
(lyskom-make-self-evaluating :test)
(lyskom-make-self-evaluating :size)
(lyskom-make-self-evaluating :may-interrupt)


;;; ================================================================
;;; Emacs 21.4 stuff

(lyskom-function-alias function-obsolete-p (function)
  "Return non-nil if FUNCTION is obsolete"
  (get function 'byte-obsolete-info))

(eval-and-compile
  (if (and (lyskom-function-obsolete-p 'process-kill-without-query)
           (fboundp 'set-process-query-on-exit-flag))
      (fset 'lyskom-set-process-query-on-exit-flag 'set-process-query-on-exit-flag)
    (fset 'lyskom-set-process-query-on-exit-flag 'process-kill-without-query)))

(eval-and-compile
  (if (lyskom-function-obsolete-p 'make-local-hook)
      (defun lyskom-make-local-hook (hook))
    (fset 'lyskom-make-local-hook 'make-local-hook)))



;;; ================================================================
;;; ================================================================
;;; ================================================================


;;; Set up edebug-form-spec and friends. We do this here because
;;; we have to have the eval block at the end, and this at least
;;; keeps everything together (it would have been nicer to put
;;; an eval block with each definition, but I don't think that
;;; would look good, and it might not always work).

(put 'lyskom-provide-function 'lisp-indent-hook 2)
(put 'lyskom-function-alias 'lisp-indent-hook 2)
(put 'lyskom-macro-alias 'lisp-indent-hook 2)
(put 'lyskom-xemacs-or-gnu 'edebug-form-spec '(form form))

;;; Local Variables:
;;; eval: (put 'lyskom-provide-function 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-function-alias 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-macro-alias 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-xemacs-or-gnu 'edebug-form-spec '(form form))
;;; end:
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: language.el,v 44.32 2004/01/01 22:01:39 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: language.el
;;;; Author: Niels Mller
;;;;
;;;;

(require 'lyskom-vars "vars")

;;; Variables

;;(defvar lyskom-language-symbols nil
;;  "Symbols with language data bound to them")

(defvar lyskom-languages nil
  "An alist of defined languages.
Each entry is a pair (SYMBOL . (NAME NAME ...)) where symbol is the symbol
used for identification, and the NAMEs are names of the language.")

(defvar lyskom-language-categories nil
  "Categories of language-specific variables.
Each element is a cons cell (NAME . SCOPE), where NAME is the name of
the category and SCOPE is its scope (global or local).")

(defvar lyskom-language-vars nil
  "A list of all language-dependent variables.
Each element is a cons cell (NAME . SCOPE), where NAME is the name of
the category and SCOPE is its scope (global or local).")


(defun lyskom-language-var-internal (scope var language val)
  "Defines a language-local variable value."
  (or (assq var lyskom-language-vars)
      (setq lyskom-language-vars
	    (cons (cons var scope) lyskom-language-vars)))
  (let* ((alist (get var 'lyskom-language-var))
	 (entry (assq language alist)))
    (if entry
	(setcdr entry val)
      (put var 'lyskom-language-var (cons (cons language val) alist)))))

(defmacro lyskom-language-var (scope var language val)
  `(lyskom-language-var-internal ',scope
                                 ',var
                                 ',language
                                 ',val))

(put 'lyskom-language-var 'lisp-indent-function 2)

(defun lyskom-set-language-vars (language scope)
  "Set language-specific variables to values for LANGUAGE.
SCOPE must be one of global or local, and specifies the scope of the change.
If SCOPE is global, change all variables, even those that affect multiple
sessions."
  (mapcar
   (lambda (spec)
     (let ((var (car spec))
           (var-scope (cdr spec)))
       (when (or (eq scope 'global)
                 (eq var-scope 'local))
         (when (eq scope 'global)
           (set-default var (eval (cdr (assq language
                                     (get var 'lyskom-language-var))))))
         (when (or (not (symbol-value var))
                   (get var 'lyskom-language-force))
           (set var (eval (cdr (assq language
                                     (get var 'lyskom-language-var)))))))))
   lyskom-language-vars))

;;; Keymaps

(defvar lyskom-language-keymaps nil
  "A list of all language-dependent keymaps.")

(defun lyskom-language-keymap-internal (keymap language langmap)
  "Defines a language-local keymap."
  ;; If the "real" keymap has no value, set it to an empty keymap
  (if (eval keymap)
      nil
    (set keymap (make-sparse-keymap)))
  ;; Add it to the list of keymaps
  (or (memq keymap lyskom-language-keymaps)
      (setq lyskom-language-keymaps
	    (cons keymap lyskom-language-keymaps)))
  ;; Modify the property list
  (let* ((alist (get keymap 'lyskom-language-keymap))
	 (entry (assq language alist)))
    (if entry
	(setcdr entry langmap)
      (put keymap 'lyskom-language-keymap
	   (cons (cons language langmap) alist)))))

(defmacro lyskom-language-keymap (keymap language langmap)
  `(lyskom-language-keymap-internal ',keymap
                                    ',language
                                    ',langmap))

(put 'lyskom-language-keymap 'lisp-indent-function 2)

(defun lyskom-set-language-keymaps (language)
  (mapcar
   (lambda (map)
     (lyskom-set-keymap-parent (symbol-value map)
                        (eval (cdr (assq language
                                         (get map
                                              'lyskom-language-keymap))))))
   lyskom-language-keymaps))



;;; String catalogs

(defun lyskom-language-strings-internal (scope category language alist)
  "Associates names to symbols.
See documentation of lyskom-language-strings for information on the 
parameters to this function."
  ;; Record category
  (or (assq category lyskom-language-categories)
      (setq lyskom-language-categories
	    (cons (cons category scope) lyskom-language-categories)))
  (let ((record (get category 'lyskom-language-symbols)))
    (mapcar (lambda (pair)
              (let* ((symbol (car pair))
                     (string (cdr pair))
                     (llist (get symbol category))
                     (entry (assq language llist)))
                ;; Record symbol
                (or (memq symbol record)
                    (setq record (cons symbol record)))
                (if entry
                    (setcdr entry string)
                  (put symbol category (cons (cons language string) llist)))))
	    alist)
    (put category 'lyskom-language-symbols record)))

(defmacro lyskom-language-strings (scope category language alist)
  "Define a category of strings.
SCOPE is the scope of language-specificity. If it is global, then these
strings apply globally and will not be altered by changing the session
language.

CATEGORY is the name of the category.

LANGUAGE is the language, a symbol denoting the ISO639 language code.

ALIST is the list of strings."
  `(lyskom-language-strings-internal ',scope
                                     ',category
                                     ',language
                                     ,alist))

(defun lyskom-language-missing-string-internal (category string languages)
  (let ((old-missing (assq 'lyskom-missing-languages (get string category))))
    (if old-missing
        (setcdr old-missing (append languages (cdr old-missing)))
      (put string category (cons (cons 'lyskom-missing-languages languages)
                                 (get string category))))))

(defun lyskom-language-ending-mismatch-internal (category string l1 l2)
  (let ((old-mismatch (assq 'lyskom-ending-mismatch (get string category))))
    (if old-mismatch
        (setcdr old-mismatch (append (list (cons l1 l2) (cons l2 l1))
                                     (cdr old-mismatch)))
      (put string category (cons (cons 'lyskom-ending-mismatch 
                                       (list (cons l1 l2) (cons l2 l1)))
                                 (get string category))))))

(defmacro lyskom-language-missing-string (category string &rest languages)
  `(lyskom-language-missing-string-internal ',category ',string ',languages))

(defmacro lyskom-language-ending-mismatch (category string l1 l2)
  `(lyskom-language-ending-mismatch-internal ',category ',string ',l1 ',l2))

(put 'lyskom-language-strings 'lisp-indent-function 2)

(defsubst lyskom-tell-string (key)
  "Retrieve the phrase indexed by the key from the kom-tell-phrases
assoc list."
  (condition-case nil
      (lyskom-get-string key 'kom-tell-phrases)
    (lyskom-internal-error (message "Bad kom-tell-phrases: missing %s" key)
                           "")))

(defsubst lyskom-try-get-string (symbol category &optional language)
    (cdr (assq (if (eq (cdr (assq category lyskom-language-categories)) 'local)
                   (or language lyskom-language)
                 (or language lyskom-global-language))
               (get symbol category))))

(defsubst lyskom-get-string-error (function symbol category)
  (signal 'lyskom-internal-error
	  (list function (list symbol category ": string not found"))))

(defun lyskom-get-string (symbol &optional category language)
  "Returns string associated with SYMBOL"
    (or (lyskom-try-get-string symbol (or category 'lyskom-message) language)
        (lyskom-get-string-error 'lyskom-get-string
                                 symbol
                                 (or category 'lyskom-message))))

(defun lyskom-get-string-sol (symbol &optional category)
  "Returns string associated with SYMBOL
If kom-long-lines is set, return the long form of the string, if it exists."
  (or  (and kom-long-lines
            (lyskom-try-get-string (intern (concat (symbol-name symbol)
                                                        "-long"))
                                        (or category 'lyskom-message)))
       (lyskom-try-get-string symbol
                                   (or category 'lyskom-message))
       (lyskom-get-string-error 'lyskom-get-string
                                symbol
                                (or category 'lyskom-message))))


(defun lyskom-get-strings (symbols &optional category)
  "Returns an alist of (symbol . string) pairs

according to CATEGORY and lyskom-language. Kind of inverse to
lyskom-define-language."
  (mapcar (lambda (symbol)
            (cons symbol (lyskom-get-string symbol category)))
	  symbols))

(defun lyskom-get-menu-string (symbol)
  "Returns the name of a menu(item)

Looks for the 'lyskom-menu category, or 'lyskom-command
if 'lyskom-menu is not found."
  (lyskom-encode-coding-string 
    (or (lyskom-try-get-string symbol 'lyskom-menu)
        (lyskom-try-get-string symbol 'lyskom-command)
        (lyskom-get-string-error 'lyskom-get-menu-string symbol 'lyskom-menu))
    'iso-8859-1))

(defun lyskom-define-language (language coding &rest names)
  (let ((match (assq language lyskom-languages)))
    (if match
	(setcdr match names)
      (setq lyskom-languages (cons (cons language names) lyskom-languages))))
  (put language 'lyskom-language-coding coding))

(defun lyskom-language-coding (language)
  (or (get language 'lyskom-language-coding)
      'raw-text))

(defun lyskom-language-name (language)
  "Return the name of language code LANGUAGE in the current language."
  (save-excursion
    (when lyskom-buffer (set-buffer lyskom-buffer))
    (or (cdr (assq language lyskom-language-codes))
        (lyskom-format (cdr (assq '-- lyskom-language-codes))
                       (symbol-name language)))))

(defun lyskom-set-language (language scope)
  "Set the current language to LANGUAGE.
Returns non-nil on success and nil on failure."
  (when (listp language) 
    (setq language (lyskom-first-available-language language)))
  (cond ((not (assq language lyskom-languages))
         (lyskom-format-insert-before-prompt 'language-not-loaded
                                             (lyskom-language-name language))
         nil)
        (t 
         (cond ((eq scope 'local) 
                (setq lyskom-language language))
               ((eq scope 'global) 
                (setq lyskom-global-language language)
                (lyskom-set-language-keymaps language)))
         (lyskom-set-language-vars language scope)
         (when (eq scope 'global) (lyskom-update-menus))
         (lyskom-update-prompt t)
         (lyskom-update-command-completion)
         t)))

(defun lyskom-first-available-language (langs)
  "Return the first language in LANGS that is supported."
  (or (lyskom-traverse el (if (listp langs) langs (list langs))
        (when (assq el lyskom-languages)
          (lyskom-traverse-break el)))
      (car (car lyskom-languages))))

(defun lyskom-language-from-environment (var)
  "Return language name from value of environment variable VAR."
  (let ((tmp (getenv var)))
    (and tmp 
         (string-match "^\\([a-z]+\\)" tmp)
         (intern (match-string 1 tmp)))))

(defun lyskom-default-language ()
  "Return the default language for LysKOM"
  (let ((languages (append
                    (if (listp kom-default-language)
                        kom-default-language
                      (list kom-default-language))
                    (list
                     (lyskom-language-from-environment "KOMLANGUAGE")
                     (lyskom-language-from-environment "LC_ALL")
                     (lyskom-language-from-environment "LC_MESSAGES")
                     (lyskom-language-from-environment "LANG")))))
    (or (lyskom-traverse lang languages
          (when (assq lang lyskom-languages)
            (lyskom-traverse-break lang)))
        (car (car (last lyskom-languages))))))




(eval-and-compile (provide 'lyskom-language))

;;; language.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: help.el,v 44.7 2003/01/05 21:37:06 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: help.el
;;;;
;;;; Functions for formatting help strings in the client
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: help.el,v 44.7 2003/01/05 21:37:06 byers Exp $\n"))



(defgroup lyskom-faces nil
  "Faces for use in the LysKOM elisp client."
  :group 'lyskom)

(defgroup lyskom nil
  "Faces for use in the LysKOM elisp client."
  :group 'default)

(defface lyskom-help-h1-face '((t (:weight bold :underline t :height 2.0 :family "helvetica")))
  "First level header in LysKOM help."
  :group 'lyskom-faces)

(defface lyskom-help-h2-face '((t (:weight bold :underline t :height 1.5 :family "helvetica")))
  "Second level header in LysKOM help."
  :group 'lyskom-faces)

(defface lyskom-help-h3-face '((t (:weight bold :family "helvetica")))
  "Third level header in LysKOM help."
  :group 'lyskom-faces)

;;; Note that these are duplicated in help-compile.el. Change one and change both!

;;UNUSED: lyskom-help-create-data
(defsubst lyskom-help-create-data (tag attr data)
  (list tag attr data))

(defsubst lyskom-help-data-get-tag (data)
  (elt data 0))

(defsubst lyskom-help-data-get-attr (attr data)
  (cdr (assq attr (elt data 1))))

;;UNUSED: lyskom-help-data-get-attrs
(defsubst lyskom-help-data-get-attrs (data)
  (elt data 1))

(defsubst lyskom-help-data-get-data (data)
  (elt data 2))


(defvar lyskom-help-format-handlers
  '((h1 . lyskom-help-format-h1)
    (h2 . lyskom-help-format-h2)
    (h3 . lyskom-help-format-h3)
    (p  . lyskom-help-format-p)
    (b  . lyskom-help-format-b)
    (i  . lyskom-help-format-i)
    (list . lyskom-help-format-list)
    (item . lyskom-help-format-item)
    (inline . lyskom-help-format-inline)
    (refer . lyskom-help-format-refer)
    (cref . lyskom-help-format-cref)
    (section . lyskom-help-format-section)
    (TEXT . lyskom-help-format-TEXT))
  )

(defun lyskom-help-get-section (section)
  (elt (assq section lyskom-help-data) 2))

(defun lyskom-help-show-section (section)
  "Format and insert section SECTION."
  (lyskom-do-help-format (lyskom-help-get-section section)))

(defun lyskom-do-help-format (data)
  "Format ant insert help data DATA."
  (let ((inhibit-read-only t))
    (cond ((symbolp (car data))
           (funcall (cdr (assq (car data) lyskom-help-format-handlers)) data))
          (t (lyskom-traverse el 
                 data
               (let ((tag (lyskom-help-data-get-tag el)))
                 (funcall (cdr (assq tag lyskom-help-format-handlers))
                          el)))))))

(defun lyskom-help-format-text-properties (data props)
  (let ((start (point-max-marker)))
    (set-marker-insertion-type start nil)
    (lyskom-traverse el (lyskom-help-data-get-data data)
      (lyskom-do-help-format el))
    (add-text-properties start (point-max) props)
    (set-marker start nil)))

(defun lyskom-help-format-section (section)
  "Format and insert section SECTION."
  (lyskom-do-help-format (lyskom-help-data-get-data section)))

(defun lyskom-help-format-h1 (data)
  (lyskom-insert "\n\n")
  (lyskom-help-format-text-properties data '(face lyskom-help-h1-face))
  (lyskom-insert "\n\n"))

(defun lyskom-help-format-h2 (data)
  (lyskom-insert "\n")
  (lyskom-help-format-text-properties data '(face lyskom-help-h2-face))
  (lyskom-insert "\n\n"))

(defun lyskom-help-format-h3 (data)
  (lyskom-help-format-text-properties data '(face lyskom-help-h3-face))
  (lyskom-insert "\n"))

(defun lyskom-help-format-i (data)
  (lyskom-help-format-text-properties data '(face italic)))

(defun lyskom-help-format-b (data)
  (lyskom-help-format-text-properties data '(face bold)))

(defun lyskom-help-format-TEXT (data)
  (lyskom-insert (cdr data)))

(defun lyskom-help-format-list (data)
  (lyskom-insert "\n")
  (when (lyskom-help-data-get-attr 'header data)
    (lyskom-insert (lyskom-help-data-get-attr 'header data))
    (lyskom-insert "\n"))
  (lyskom-do-help-format (lyskom-help-data-get-data data))
  (lyskom-insert "\n"))

(defun lyskom-help-format-item (data)
  (lyskom-insert "  * ")
  (lyskom-do-help-format (lyskom-help-data-get-data data))
  (lyskom-insert "\n"))

(defun lyskom-help-format-refer (data)
  (let* ((id (intern (lyskom-help-data-get-attr 'id data)))
         (section (lyskom-help-get-section id))
         (string (or (lyskom-help-data-get-attr 'prompt section)
                     (format "%s" id))))
    (lyskom-format-insert 
     "%#2@%#1s"
     string
     `(face underline
            mouse-face highlight
            lyskom-button t
            lyskom-button-text ""
            lyskom-button-type func
            lyskom-buffer ,(current-buffer)
            lyskom-button-arg (kom-help (,string . ,id)))))

)


(defun lyskom-help-format-cref (data)
  (let* ((command (intern (lyskom-help-data-get-attr 'id data)))
         (command-name (lyskom-get-string command 'lyskom-command))
         (keys (delq nil
                     (mapcar (lambda (x)
                               (if (and (arrayp x)
                                        (eq (elt x 0) 'menu-bar))
                                   nil
                                 x))
                             (where-is-internal command))))
         (heading (lyskom-format "%#1@%[%#2s%]%#3?b%[ (%#3s)%]%[%]"
                                 '(face italic)
                                 command-name
                                 (and keys 
                                      (mapconcat 'key-description
                                                 keys
                                                 "; ")))))
    (lyskom-insert heading)))

(defun lyskom-help-format-inline (data)
  (let* ((id (intern (lyskom-help-data-get-attr 'id data)))
         (section (lyskom-help-get-section id)))
    (cond (section (lyskom-do-help-format section))
          (t (lyskom-insert (format "[%S]" id))))))

(defun lyskom-help-format-p (data)
  (let ((start (point-max-marker)))
    (set-marker-insertion-type start nil)
    (lyskom-traverse el (lyskom-help-data-get-data data)
      (lyskom-do-help-format el))
      (save-excursion
        (save-restriction
          (narrow-to-region start (point-max))
          (goto-char (point-min))
          (while (re-search-forward "^\\s-+" nil t)
            (replace-match "" nil nil))
          (lyskom-fill-region (point-min) (point-max))))
      (lyskom-insert "\n\n")))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: english-strings.el,v 44.352 2005/01/12 19:32:05 qha Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: english-strings.el
;;;;
;;;; This file contains all strings in the LysKOM elisp client.
;;;; Language:     English.
;;;; ================================================================
;;;;
;;;; Translation from swedish-strings.el: David Byers
;;;;

(require 'lyskom-vars "vars")
(require 'lyskom-language "language")

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
              "$Id: english-strings.el,v 44.352 2005/01/12 19:32:05 qha Exp $"))


;;; ================================================================
;;; The language definition

(lyskom-define-language 'en
                        'iso-8859-1
                        "English"
                        "Engelska")


;;; ================================================================
;;; lyskom-edit-mode-map                             English version

(defvar lyskom-en-edit-mode-map nil)
(lyskom-language-keymap lyskom-edit-mode-map en lyskom-en-edit-mode-map)

;;; Set the keymap for lyskom-edit-mode

(defvar lyskom-en-edit-prefix)
(defvar lyskom-en-edit-review-prefix)
(defvar lyskom-en-edit-insert-prefix)
(defvar lyskom-en-edit-aux-prefix)
(defvar lyskom-en-edit-add-prefix)

(if lyskom-en-edit-mode-map
    nil
  (setq lyskom-en-edit-mode-map (make-sparse-keymap))
  (define-prefix-command 'lyskom-en-edit-prefix)
  (define-prefix-command 'lyskom-en-edit-review-prefix)
  (define-prefix-command 'lyskom-en-edit-insert-prefix)
  (define-prefix-command 'lyskom-en-edit-aux-prefix)
  (define-prefix-command 'lyskom-en-edit-add-prefix)

  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2 'button2up))) 'kom-button-click-or-yank)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2up 'button2))) 'kom-mouse-null)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-edit-mode-map (kbd "*")     'kom-button-press-or-self-insert-command)
  (define-key lyskom-en-edit-mode-map (kbd "=")     'kom-menu-button-press-or-self-insert-command)
  (define-key lyskom-en-edit-mode-map (kbd "TAB")   'kom-edit-next-button-or-self-insert)
  (define-key lyskom-en-edit-mode-map (kbd "M-TAB") 'kom-edit-prev-button)
  (define-key lyskom-en-edit-mode-map (kbd "<S-tab>") 'kom-edit-prev-button)

  (define-key lyskom-en-edit-mode-map (kbd "C-c") 'lyskom-en-edit-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-x") 'lyskom-en-edit-aux-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-r") 'lyskom-en-edit-review-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-i") 'lyskom-en-edit-insert-prefix)
  (define-key lyskom-en-edit-prefix (kbd "TAB") 'lyskom-en-edit-insert-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-a") 'lyskom-en-edit-add-prefix)

  (define-key lyskom-en-edit-prefix (kbd "?")	'lyskom-help)
  (define-key lyskom-en-edit-prefix (kbd "*") 'kom-button-press)
  (define-key lyskom-en-edit-prefix (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-en-edit-prefix (kbd "C-y") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-b")     'kom-edit-insert-buglist)
  (define-key lyskom-en-edit-prefix (kbd "C-c")	'kom-edit-send)
  (define-key lyskom-en-edit-prefix (kbd "C-s") 'kom-edit-ispell-message)
  (define-key lyskom-en-edit-prefix (kbd "C-k")	'kom-edit-quit)

  (define-key lyskom-en-edit-review-prefix (kbd "?") 'lyskom-help)
  (define-key lyskom-en-edit-review-prefix (kbd "C-c") 'kom-edit-show-commented)

  (define-key lyskom-en-edit-insert-prefix (kbd "?") 'lyskom-help)
  (define-key lyskom-en-edit-insert-prefix (kbd "C-c") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-insert-prefix (kbd "C-y") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-insert-prefix (kbd "1") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "2") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "3") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "4") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "5") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "6") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "7") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "8") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "9") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "SPC") 'kom-edit-insert-text)
  (define-key lyskom-en-edit-insert-prefix (kbd "C-l") 'kom-edit-insert-link)
  (define-key lyskom-en-edit-insert-prefix (kbd "C-i") 'kom-edit-insert-last-info-nodename)

  (define-key lyskom-en-edit-add-prefix (kbd "C-r") 'kom-edit-add-recipient)
  (define-key lyskom-en-edit-add-prefix (kbd "C-c") 'kom-edit-add-copy)
  (define-key lyskom-en-edit-add-prefix (kbd "<RET>") 'kom-edit-move-text)
  (define-key lyskom-en-edit-add-prefix (kbd "C-x") 'kom-edit-add-cross-reference)
  (define-key lyskom-en-edit-add-prefix (kbd "C-p") 'kom-edit-add-personal-comments)
  (define-key lyskom-en-edit-add-prefix (kbd "C-n") 'kom-edit-add-no-comments)
  (define-key lyskom-en-edit-add-prefix (kbd "C-r") 'kom-edit-add-read-confirm-request)
  (define-key lyskom-en-edit-add-prefix (kbd "?") 'lyskom-help))



(lyskom-language-missing-string lyskom-message cgdag en)
(lyskom-language-missing-string lyskom-message sixjune en)
(lyskom-language-missing-string lyskom-message holdnose en)
(lyskom-language-missing-string lyskom-message 13dayxmas en)
(lyskom-language-missing-string lyskom-message 20dayxmas en)
(lyskom-language-missing-string lyskom-message kyndeldag en)
(lyskom-language-missing-string lyskom-message skottdag en)
(lyskom-language-missing-string lyskom-message intwomday en)
(lyskom-language-missing-string lyskom-message mariebdag en)
(lyskom-language-missing-string lyskom-message johannesddag en)
(lyskom-language-missing-string lyskom-message fnday en)
(lyskom-language-missing-string lyskom-message allhelgonadag en)
(lyskom-language-missing-string lyskom-message varnlosdag en)
(lyskom-language-missing-string lyskom-message luciaday en)

(lyskom-language-ending-mismatch lyskom-message carbon-copy-prefix en sv)
(lyskom-language-ending-mismatch lyskom-message blank-carbon-copy-prefix en sv)
(lyskom-language-ending-mismatch lyskom-message newyeareve en sv)

;;; Formely known as lyskom-strings
(lyskom-language-strings local lyskom-message en 
  '(
    ; From vars.el: 
    ; From komtypes.el: nil
    ; From clienttypes.el: nil
    ; From startup.el:
    (server-q . "LysKOM server? (%#1s) ")
    (try-connect . "LysKOM elisp client version %#1s.\nAttempting to connect to %#2s.\n")
    (too-old-server . "The server is too old for this version of the client.")
    (connection-done . "Connection established. Server version is %#1s.\n\n")
    (what-is-your-name . "What is your name? ")
    (password . "Your password? ")
    (wrong-password . "Incorrect password.\n")
    (wrong-password-help . "
If you have forgotten your password you may be able to get a new one
by e-mailing the site administrators at one of the addresses listed
below:\n")
    (wrong-password-email . "* %#1t\n")
    (are-logged-in . "You have entered LysKOM. Please wait...\n")
    (you-have-motd . "\nYou have a notice on your mailbox:\n\n")
    (server-has-motd . "There is a notice on the server:\n")
    (lyskom-motd-was-garbed . "\nThe login message does not exist!
The message that was supposed to be shown after login has disappeared.
Please contact the LysKOM administrator.\n")

    (first-greeting . "%#1s
This appears to be the first time you use LysKOM. Welcome!
Please make sure you have spelled your name correctly. You should use your
full name and organisation, eg. \"Joe Hacker, MIT\". If your name is spelled
incorrectly, or you wish to change it, answer 'no' to the question below.

At present the LysKOM server stores most of the information so that
anybody can read it. Only passwords are encrypted.

If you are uncertain about how to use LysKOM, you can retrieve a manual by
anonymous ftp to ftp.lysator.liu.se. Ask your system administrator for help
on how to do this. You can also type \"?\" for the command \"Help\".
")

    (is-name-correct . "Is the name %#1s correct? ")
    (personal-password . "Enter a personal password: ")
    (repeat-password . "Repeat for confirmation: ")
    (repeat-failure . "The passwords were not the same.\n")

    (could-not-create-you .  "LysKOM couldn't create that user.\n")
    (presentation-subject . "%#1s")
    (presentation-form . "\
Name:      
Address:   
           
Telephone: 
E-mail:    
WWW:       

Other:     ")
    (presentation-help . "You are writing your presentation.\n")
    (not-present-anywhere . "Not in any conference.")
    (unknown-person . "Unknown user")
    (in-secret-conference . "Secret conference (%#1d).")
    (start-new-session-same-server
     . "You are already connected to that server. Do you want a new session? ")
    (new-session-in-buffer . "\n\n---- New session at %s ----\n\n")
    (warning-about-uncompiled-client . "
NOTE: The LysKOM client is not compiled. It is recommended to run a compiled
client for performance reasons. Read the accompanying README to learn how to
do that.
")

    ; From internal.el:
    (shaky-tcp . "At the moment I can't reach the server. The TCP/IP connection is shaky%#1s")
    (retrying-tcp . "Retrying.")

    ; From parse.el:
    (protocol-error . "protocol error: %s")

    ; From services.el:
    (interrupted . "Interrupted\n")

    ; From cache.el:
    ; No entries.

    ; From commands1.el:
    (appreciation . 
"You are a very special person, beautiful and wise, respected by
everybody around you. You are doing a splendid job. Many people love
you, body and soul. You make life easier for others. You are a very
warm and sensitive person.

Be proud of being You! You have a very good reason.\n\n")
    (abuse . 
"You are a nuisance, ugly and stupid, disrespected by everybody around
you. You are doing a worthless job. Many people hate you, body and
soul. You make life harder for others. You are a very cold and
unfeeling person.

Be ashamed of being You! You have a very good reason.\n\n")


    (what-conf-to-delete . "Conference/user to delete: ")
    (what-conf-to-change . "Conference to modify: ")
    (confirm-delete-pers-or-conf . "Really delete %#1s %#2s? ")
    (the-pers . "the user")
    (the-conf . "the conference")
    (deletion-not-confirmed . "Deletion aborted\n")
    (somebody-else-deleted-that-conf . "Somebody else just deleted the conference.\n")
    (conf-is-deleted . "OK, %#1s is now deleted.\n")
    (you-could-not-delete . "%#1M can't be deleted by you.\n")
    (you-have-deleted-yourself . "You have deleted yourself.\n")

    (what-text-to-delete . "Remove which text? ")
    (delete-marked-text . "The text is %#1s. Delete anyway? ")
    (delete-marked-by-you . "marked by you")
    (delete-marked-by-you-and-others . "marked by you and %#1?d%[someone else%]%[%#1d others%]")
    (delete-marked-by-several . "marked by %#1d user%#1?d%[%]%[s%]")
    (delete-commented-text-help . "\
The text you are about to remove has comments. If you remove it the 
comments will lose their context, and this annoys and even angers
many readers. You should consider moving it to another conference
instead of removing it.")
    (delete-commented-text . "The text has comments. Remove anyway? ")
    (really-delete-commented-text . "Removing a commented text may annoy many readers. Remove anyway?")
    (deleting-text . "Removing text %#1:n...")

    (presentation-for-whom . "View presentation for which conference/user? ")
    (text-to-see-author-of . "Review presentation of author of which text? ")
    (unread-presentation-for-whom . "Unread presentation for which conference/user? ")
    (text-to-unread-author-of . "Mark presentation of author of which text as unread? ")
    (somebody-deleted-that-conf . "Somebody just deleted that conference.\n")
    (review-presentation-of . "Review presentation of %#1M.\n")
    (has-no-presentation . "%#1:M has no presentation.\n")

    (have-to-read . "You must read a text first.\n")

    (no-comment-to . "There is no commented text.\n")
    (no-text-at-point . "There is no text at point.\n")
    (what-ancestor . "Which of the commented texts do you want? ")

    (who-letter-to . "Send a letter to whom? ")
    (who-send-text-to . "Send text to which conference? ")
    (has-motd . "%#1P has a notice on his/her mailbox:\n\n")
    (motd-persist-q . "Do you still want to write the text? ")

    (who-to-add . "Whom do you want to add? ")
    (where-to-add . "To which conference? ")
    (where-to-add-self . "Join which conference? ")
    (priority-q . "Priority of your membership? (0 (low) - 255 (high)) ")
    (other-priority-q . "Priority of the membership? (0 (low) - 255 (high)) ")
    (done . "done.\n")
    (cancelled . "cancelled.\n")
    (nope . "didn't work.\n")
    (add-already-member . "%#1P is already a member of %#2M.\n")
    (you-already-member . "You are already a member of %#1M.\n")

    (cant-find-supervisor . "Can't find supervisor of %#1M.\n")
    (is-read-protected-contact-supervisor . "%#1M is closed.
Send a letter to  %#2P to apply for membership.\n")

    (conf-does-not-exist . "\nThe conference doesn't exist.\n")

    (who-to-exclude . "Who do you want to remove? ")
    (where-from-exclude . "From which conference? ")

    (leave-what-conf . "Leave which conference? ")

    (error-fetching-person . "Error retrieving user.\n")
    (error-fetching-conf . "Error retrieving conference.\n")

    (name-of-conf . "Conference name? ")
    (anyone-member . "May anyone join? ")
    (secret-conf . "Secret conference? ")
    (comments-allowed . "Are comments allowed? ")
    (anonymous-allowed . "Are anonymous texts allowed? ")
    (secret-members-allowed . "Are secret members permitted? ")
    (what-comment-no . "Comment text number: ")
    (what-footnote-no . "Footnote text number: ")
    (what-private-no . "Private reply to text number: ")

    (quit-in-spite-of-unsent . "You have an unsent text. Do you really want to quit? ")
    (really-quit . "Do you really want to quit LysKOM? ")
    (session-ended . "
--------------------------------------------
  LysKOM session finished
  You are now disconnected from the server
--------------------------------------------
")
    (session-ended-long . "
-------------------------------------------------------------------------------
  LysKOM session finished
  You are now disconnected from the server
-------------------------------------------------------------------------------
")
    (session-auto-ended . "
============================================================
Disconnecting from LysKOM since all connections are in use
and you have finished reading. Please come back later.
============================================================\n\n")
    (session-auto-ended-long . "
===============================================================================
Disconnecting from LysKOM since all connections are in use
and you have finished reading. Please come back later.
===============================================================================
\n")
    (what-to-change-pres-you . "Change presentation of whom/what: ")
    (what-to-change-faq-you . "Change FAQ for which conference: ")
    (who-to-put-motd-for . "Post notice on whom/what: ")

    (what-to-set-pres-you . "Set presentation for whom/what: ")
    (what-text-to-set-as-pres-no . "Which text do you want as the new presentation: ")
    (what-to-set-motd-you . "Set notice on whom/what: ")
    (what-text-to-set-as-motd-no . "Which text do you want as the new notice: ")
    (conf-already-has-pres . "The conference/person already has a presentation. Continue anyway? ")
    (conf-already-has-motd . "The conference/person already has a notice. Continue anyway? ")
    (setting-conf-pres . "Setting presentation of %#1M to text %#2n...")
    (setting-conf-motd . "Setting notice for %#1M to text %#2n...")

    (who-to-remove-pres-for . "Remove presentation from whom: ")
    (removing-pres-for-conf . "Removing presentation (text %#2n) from %#1M...")

    (cant-get-conf-stat . "Cannot get the status of that conference.\n")
    (go-to-conf-p . "Go to conference: ")
    (want-become-member . "Do you want to join? ")
    (no-ok . "Okiedokie, whatever you say.\n")

    (who-to-remove-motd-for . "Remove notice from whom/what: ")

    (conf-all-read . "no unread texts")
    (no-in-conf . "You are not present in any conference.\n")

    (search-for-pers . "Enter search key (RETURN for all users): ")
    (search-for-conf . "Enter search key (RETURN for all conferences): ")
    (search-re . "Enter search regexp: ")
    (search-re-for-what . "What do you want to search for? ")
    (search-re-persons . "ppersons")
    (search-re-confs . "cconferences")
    (search-re-all . "bboth")

    (no-matching-confs . "No conferences match \"%#1s\".\n")
    (no-matching-perss . "No persons match \"%#1s\".\n")
    (no-matching-anys . "No persons or conferences match \"%#1s\".\n")
    (no-confs-exist . "There are no conferences in the database.\n")
    (no-pers-confs-exist . "There are no persons or conferences in the database.\n")
    (list-confs-created-by . "List owned conferences for: ")
    (listing-confs-created-by . "Listing owned conferences for %#1P\
    C=Created, O=Supervisor, S=Letterbox is super conf; S=Secret, P=Protected\n")
    (list-pers-confs-created-by . "List owned conferences and persons for: ")
    (getting-all-confs . "Retrieving a list of all conferences from the server...")
    (getting-all-pers-confs . "Retrieving a list of all persons and conferences from the server...")
    (getting-all-confs-done . "Retrieving a list of all conferences from the server...done")
    (getting-all-pers-confs-done . "Retrieving a list of all persons and conferences from the server...done")
    (finding-created-confs . "Finding owned conferences (%#1d of %#2d done)")
    (finding-created-pers-confs . "Finding owned persons and conferences (%#1d of %#2d done)")
    (no-created-confs . "%#1P is not creator, supervisor or super conference for any conference.\n")

    (name-to-be-changed . "Name to change: ")
    (no-such-conf-or-pers . "The conference or user doesn't exist.\n")
    (new-name . "New name: ")
    (new-paren . "New parenthesis: ")
    (too-many-parens-in-name . "Multiple parentheses in name. Use \"Change name\" instead.\n")
    (no-paren-in-name . "The name doesn't contain a parenthesis.\n")
    (who-to-change-supervisor-for . "Change supervisor of whom/what? ")
    (new-supervisor . "New supervisor: ")
    (text-to-mark . "Mark which text? ")
    (text-to-unmark . "Unmark which text? ")
    (what-mark . "Set which mark type (name or 0-255)? ")
    (erroneous-mark . "Erroneous mark type.\n")
    (want-to-create-symbolic-mark . "The mark type \"%#1s\" does not exist. Do you want to create it? ")
    (creating-symbolic-mark-type . "Creating mark type \"%#1s\" (%#2d).\n")
    (no-mark-types-left . "Sorry, there are no free mark types. Remove an old one first.")
    (unmarking-textno . "Unmarking text %#1n...")
    (marking-textno . "Marking text %#1n with mark %#2?b%[\"%#2s\" (%#3d)%]%[%#3d%]...")
    (list-which-mark . "List texts with which mark type (name or 0-255, RET for all)? ")

    (new-passwd-again . "Repeat the new password for confirmation: ")
    (what-mark-to-unread . "Mark which mark type as unread (name or 0-255, RET for all)? ")
    (what-mark-to-view . "Review which mark type (name or 0-255, RET for all)? ")
    (whos-passwd . "Change password for whom? ")
    (old-passwd . "Your current password: ")
    (new-passwd . "The new password: ")
    (changing-passwd . "Changing password...")
    (retype-dont-match . "You didn't reenter the same passwrod. Try again.\n")
    (palindrome . " (a palindrome!)")
    (lyskom-name . "User")
    (is-in-conf . "In conference")
    (from-machine . "At")
    (is-doing . "Activity")
    (connection-time . "Connected")
    (active-last . "Active last")
    (active . "Active")
    (lyskom-client . "Client")
    (text-to-add-recipient . "Add recipient to which text:")
    (text-to-add-copy . "Add recipient of carbon copy to which text:")
    (text-to-add-bcc . "Add recipient of blind carbon copy to which text:")
    (text-to-delete-recipient . "Remove recipient from which text:")
    (text-to-move . "Which text do you want to move:")
    (text-tree-to-move . "Which text is the root of the tree you want to move:")

    (text-to-add-comment-to . "Add comment to which text:")
    (text-to-delete-comment-from . "Remove comment from which text:")
    (text-to-add-footnote-to . "Add footnote to which text:")
    (text-to-delete-footnote-from . "Remove footnote from which text:")
    (text-to-add-cross-reference-to . "Add cross reference to which text:")
    (text-has-no-recipients-r . "Text %#1n has no recipients\n")
    (cant-move-from-to-same . "Source and target conferences must be different.\n")

    (where-on-list-q . "Placement in your list? (0-%#1d) ")
    (accepting-invitation . "Accepting invitation to %#2M%#3?b%[ %#3s%]%[%]...")
    (member-in-conf . "Joining %#2M%#3?b%[ %#3s%]%[%]...")
    (member-in-conf-with-low-priority . "%#1M has lower priority than your session priority, and will not be shown.\n")
    (member-in-conf-with-unread-date . "with unread from %#2s %#3d, %#1d")
    (member-in-conf-with-unread . "unread %#1d unread")
    (add-member-in . "Adding %#1P as a member of %#2M...")
    (change-priority-for-q . "Change priority of conference: ")
    (cant-change-priority-of-passive . "Can't change priority of passive memberships.\n")
    (change-priority-for . "Changing priority of %#2M...")
    (unsubscribe-to . "Leaving %#1M...")
    (unsubscribe-to-2 . "Leaving %#1M%#2s...")
    (confirm-each-join . "Confirm joining individual conferences? ")
    (confirm-each-msg . "Confirm reception of group messages in individual mten? ")
    (receive-each-msg . "Do you want to receive group messages in all conferences? ")
    (no-confirm-each-sure . "Are you sure you want to join %#1d conferences automatically? ")
    (confirm-join . "Join %#1M? ")
    (getting-all-confs . "Getting a list of all conferences...")
    (getting-all-confs-progress . "Getting a list of all conferences (%#1d/%#2d)...")
    (getting-all-confs-done . "Getting a list of all conferences...done")
    (unsub-all-skipping-letterbox . "nix\nThis is your letterbox.\n")
    (unsub-all-skipping-supervised . "nix\nYou are the supervisor of the conference.\n")
    (unsub-secret-conf-q . "%#1M is secret. Leave anyway? ")
    (unsub-all-secret . "aLeave all secret conferences")
    (unsub-closed-conf-q . "%#1M r close. Leave anyway? ")
    (unsub-all-closed . "aLeave all closed conferences")
    (unsub-open-conf-q . "Leave %#1M? ")
    (unsub-all-open . "aLeave all open conferences")
    (abc-yes . "yYes")
    (abc-no . "nNo")
    (abc-yes-all . "aJa to all")
    (abc-no-all . "xNej to all")

    (move-tree-move . "mMove")
    (move-tree-sub  . "rRemove")
    (move-tree-add  . "aAdd")
    (move-tree-ign  . "nNothing")
    (move-tree-jump . "jJump")
    (move-tree-quit . "qCancel")

    (move-tree-add-rcpt-type . "Add as: ")
    (move-tree-rcpt . "rRecipient")
    (move-tree-cc . "cCarbon copy")
    (move-tree-bcc . "dBlind carbon copy")

    (move-tree-leave-cc-q . "Leave original recipient as carbon copy recipient? ")

    (exclude-from . "Removing %#1P from %#2M...")

    (unsubscribe-failed . "\nDidn't work. Perhaps %#1P isn't a member of %#2M?\n")
    (activate-mship . "Become active member of %#1M...")
    (activate-mship-done . "Activated passive membership of %#1M.\n")
    (passivate-done . "You are now a passive member of %#1M.
Leave the conference again to unsubscribe completely.\n")

    (You . "You")
    (could-not-create-conf . "Couldn't create the conference \"%#1s\".\n")
    (created-conf-no-name . "Conference number %[%#3@%#1:m %#2:M%] has been created.\n")
    (cant-read-textno . "You are not allowed to read text %#1:n.\n")

    (not-supervisor-for . "You are not the supervisor of %#1M.\n")
    (not-supervisor-for-server . "You do not have administrative rights on this LysKOM-server.\n")
    (go-to-conf . "Go to conference %#1M.\n")
    (cant-go-to-his-mailbox . "You are not allowed to go to %#1M's mailbox.\n")
    (not-member-of-conf . "You are not a member of %#1M.\n")
    (about-to-change-name-from . "%#1M\n")
    (change-name-done . "Done. New name: %[%#2@%#1:M%].\n")
    (change-name-nope . "Couldn't change name to %#1s. Error code %#3d. %#2s.\n")
    (change-supervisor-from-to . "Change supervisor of %#1M to %#2P...")
    (change-supervisor-nope . 
     "\nDidn't work. Perhaps you are not allowed to change the supervisor of %#1M?\n")
    
    (no-marked-texts . "You have not marked any texts.\n")
    (no-marked-texts-mark . 
     "You have not marked any texts with mark type \"%#1s\".\n")

    (weekdays . ["Sunday" "Monday" "Tuesday" "Wednesday" "Thursday"
		 "Friday" "Saturday" "Sunday"])
    (weekdays-short . ["Sun" "Mon" "Tue" "Wed" "Thu" "Fri" "Sat" "Sun"])
    (time-is . "The time is %#1s%#2s (according to the server).")
    (time-is-week . "The time is %#1s%#2s, week %#3d (according to the server).")

    (xmaseve . "Christmas eve!\nYou didn't open any gifts early, did you?")
    (xmasday . "Christmas day.\nDid you get any nice gifts this year?")
    (newyearday . "\nMay %#1d be a prosperous and good year for you!")
    (newyeareve . "Happy New Year!")
    (newyearevelate . "Less than an hour left of %#1d...")
    (lysbday . "
On this day, in 1973, the Lysator Academic Computer Society was
formed, and it was a great day in the history of computing in Sweden.
Read all about it at http://www.lysator.liu.se/history/")

    (total-users . "    A total of %#1d users (%#2s).\n")
    (total-users-sans-date . "    A total of %#1d users\n")
    (total-visible-users . "    A total of %#1d visible user%#1?d%[%]%[s%] (%#2s).\n")
    (total-active-users . "    A total of %#1d active user%#1?d%[%]%[s%] (%#2s).\n")
    (total-visible-active-users
     . "    A total of %#1d visible%#1?d%[%]%[%] active user%#1?d%[%]%[s%] (%#2s).\n")
    (client-statistics . "    Distribution of clients:\n")
    (client-statistics-line . "    %4#2d %#1s%#3?d%[%]%[ [%#3d variants]%]")
    (who-to-add-q . "Add whom/what as a recipient? ")
    (who-to-add-copy-q . "Add which conference/user as carbon copy recipient? ")
    (who-to-add-bcc-q . "Add which conference/user as blind carbon copy recipient? ")
    (add-footnotes-too-q . "Try to add recipient to footnotes? ")
    (add-attachments-too-q . "Try to add recipient to attachments? ")

    (really-add-as-recpt-q . "Send future comments to the text to %#1M too? ") 
    (who-to-sub-q . "Remove whom/what as a recipient? ")
    (sub-footnotes-too-q . "Try to remove recipient from footnotes? ")
    (sub-attachments-too-q . "Try to remove recipient from attachments? ")

    (who-to-move-from-q . "Move from where? ")
    (who-to-move-to-q . "Move to where? ")
    (who-to-move-to-or-sub-q . "Move to where (empty to just remove recipient)? ")
    (move-footnotes-too-q . "Try to move footnotes? ")
    (move-attachments-too-q . "Try to move attachments? ")
    (move-text-not-recipient . "incorrect recipient.\n")

    (adding-name-as-recipient . "Adding %#1M as recipient of text %#2n...")
    (adding-name-as-copy . "%#1M will receive a carbon copy of text %#2n...")
    (adding-name-as-bcc . "%#1M will receive a blind carbon copy of text %#2n...")
    (remove-name-as-recipient .
     "Removing %#1M as recipient of text %#2n...")
    (adding-cross-reference . "Adding cross reference...")

    (error-recipient-limit . "Text %#1n has too many recipients.\n")
    (error-already-recipient . "%#2M is already a recipient of text %#1n.\n")
    (error-permission-denied-add-recpt . "Only the author of %#1n or supervisor for %#2M can change recipient types.\n")
    (error-permission-denied-sub-recpt . "Only the author of %#1n or supervisor for %#2M can remove the recipient.\n")
    (error-access-denied-add-recpt . "You are not allowed to add texts to %#2M.\n")
    (error-not-recipient . "%#2M is not a recipient of text %#1n.\n")

    (moving-tree-what-action-q . "What do you want to do? ")
    (moving-cant-read . "Can't move text %#1n (unable to read text).\n")
    (moving-name . "Moving text %#3n from %#1M to %#2M...")
    (moving-already-moved . "Text %#1n does not have %#2M as a recipient.\nSkipping this text and its comments.\n")
    (text-to-add-q . "Add which text as a comment to %#1n? ")
    (text-to-remove-q . "Remove which text as a comment from %#1n? ")
    (text-to-add-footn-q . "Add which text as a footnote to %#1n? ")
    (text-to-remove-footn-q . "Remove which text as a footnote from %#1n? ")
    (add-comment-to . "Adding text %#1n as a comment to text %#2n...")
    (sub-comment-to . "Removing text %#1n as a comment to text %#2n...")
    (add-footnote-to . "Adding text %#1n as a footnote to text %#2n...")
    (sub-footnote-to . "Removing text %#1n as a footnote to text %#2n...")
    (comment-keep-recpt-p ."Should %#1s remain a recipient? ")
    (comment-all-relevant-p . "There are multiple recipients. Are they all relevant? ")
    (please-edit-recipients . "Modify the recipient list and send the text again.")
    (add-recipient-p . "Add recipient%#2?b%[ %#2M to reach%]%[%] %#1P? ")
    (checking-rcpt . "Checking recipients...")
    (checking-rcpt-done . "Checking recipients...done")
    (checking-comments . "Checking commented texts...")
    (checking-comments-done . "Checking commented texts...done")
    (please-check-commented-texts . "Review the commented text and its comments.")
    (have-unread-comment . "Send despite unread comments to text %#1n? ")
    (duplicate-recipients . "Unable to post. A recipient is duplicated (%#1M)")
    (no-recipients . "Unable to post text. No recipients were specified.")

    (matching-regexp . "Conferences/users matching `%#1s'\n")
    (matching-regexp-perss . "Users matching `%#1s'\n")
    (matching-regexp-confs . "Conferences matching `%#1s'\n")

    (who-is-active-all . "Showing all sessions.\n")
    (who-is-active-last-minutes . "Showing all sessions active the last %#1d minutes.\n")
    (showing-invisibles . "Showing invisible sessions.\n")
    (null-who-info . "No one (active) is logged on.\n")

    (no-other-lyskom-r . "There are no other active LysKOM sessions.\n")
    (no-lyskom-session . "There are no active LysKOM sessions.")
    (no-other-unread-lyskom-r . "There is no another LysKOM session with unread texts.\n")
    (no-unread-lyskom-r . "There is no active LysKOM session with unread texts.\n")
    (no-unread-lyskom . "There is no active LysKOM session with unread texts.")

    (who-is-on-in-what-conference . "Who in which conference: ")
    (who-is-present-in-what-conference . "Who present in which conference: ")
    (who-is-friend . "Only friends are shown.\n")
    (who-is-active-and-member . "Only members in %#1M are shown.\n")
    (who-is-active-and-present . "Only members present in %#1M are shown.\n")

    (personal-comment-to-anonymous . "It is not possible to write a personal comment to an anonymous text.\n")

    ;; Used for kom-is-person-member-of-conference:
    (pers-to-check-mship-for . "Whose membership do you want to check? ") ;-)
    (conf-to-check-mship-of . "...for which conference? ")
    (conf-is-empty . "The conference %#1M is empty.\n")
    (pers-is-member-of-conf . "Yes, %#1P is a member of the conference %#2M.\n")
    (pers-is-passive-member-of-conf . "Well, %#1P is only a passive member of the conference %#2M.\n")
    (pers-is-not-member-of-conf . "No, %#1P is not a member of the conference %#2M.\n")
    (pers-is-member-of-conf-2 . "Number of unread: %#2D (last access %#1s)\n")
    (pers-will-receive-async . "Reception of group messages %#1?b%[enabled%]%[disabled%]\n")
    (pers-mship-priority . "Membership priority: %#1d\n")
    (Unknown-number . "Unknown number")
    (text-to-check-will-read-for . "...for membership in recipients of text: ")
    (pers-to-check-will-read-for . "Person to check: ")
    (pers-is-member-of-rcpt . "Yes, %#1P is a member of at least one recipient to text %#2n.\n")
    (pers-is-passive-member-of-rcpt . "Well, %#1P is only a passive member of at least one recipient of %#2n.\n")
    (pers-is-not-member-of-rcpt . "No, %#1P is not a member of any recipient of %#2n.\n")

    ; From commands2.el:

    (your-memberships . "Your LysKOM conference memberships:\n")
    (memberships-header . "Last access	   Prio Unread	Conference\n")
    (memberships-line . "%16#1s  %#2d\t%#3d\t%#4M\n")
    
    (conf-for-status . "Get status of which conference? ")
    (no-such-conf . "The conference doesn't exist.\n")
    (status-record . "Status of conference %#1M (%#1m)%#2s\n\n")
    (change-type-prompt . "Change conference type for %#1M (%#1m) (%#2s)...")
    (Mailbox . "Mailbox")
    (Protected . "Protected")
    (no-comments . "No comments")
    (closed . "Closed")
    (allow-anon . "anonymomus ok")
    (allow-secret . "secret members")
                   
    (created-by . "Created by person %24#1p %#3s(%#2P)\n")
    (created-at . "Created:%34#1s\n")
    (members .    "Number of members: %19#1d\n")
    (conf-allows-secret-members . "Secret members:                          %#1s\n")
    (conf-allows-anon-texts .     "Anonymous texts:                         %#1s\n")
    (anon-texts-permitted . "Anonymous texts are permitted")
    (anon-texts-not-permitted . "Anonymous texts are not permitted")
    (secret-members-permitted . "Secret members are permitted")
    (secret-members-not-permitted . "Secret members are not permitted")
    (garb-nice .      "Expiration time:          %16#1d day%#1?d%[%]%[s%]\n")
    (keep-commented . "Min. expiration time for commented texts: %#1d day%#1?d%[%]%[s%]\n")
    (lowest-local-no . "Lowest local number: %21#1d\n")
    (highest-local-no . "Highest local number: %20#1d\n")
    (last-text-time . "Time of last text:    %20#1s (according to your cache)\n")
    (no-of-motd . "Notice in text:    %13#1n\n")
    (pers-has-privileges .  "Privileges:  %#1s\n")
    (pers-has-privileges-2 .  "%28#1s")
    (superconf-is-no-name . "Superconference: %25#1m %#3s(%#2M)\n")
    (permitted-submitters-no-name . "Allowed authors: %25#1m %#3s(%#2M)\n")
    (supervisor-is-no-name . "Supervisor: %30#1p %#3s(%#2P)\n")
    (presentation-no . "Presentation:    %25#1n\n")
    (conf-has-motd . "\n%#1M has a notice on his/her mailbox:\n")
    (conf-mship-priority . "Prioritet:       %25#1n%#2?b%[ %#2s%]%[%]\n")
    (status-conf-generic . "%-40#1s %#2s\n")
    (status-aux-item . "Unknown property:              %11#1s%#3s (created by %#2M)\n")
    (conf-mx-list-name . "Imported mailing list:                   %#1s %#2s\n")
    (conf-mx-refuse-import . "Refuse import of:                        %#1s %#2s\n")
    (recommended-conf-aux . "Recommended conference:                  %#1M <%#1m> %#2s\n")
    (bad-recommended-conf-aux . "Recommended conference:                  \"%<20...#1s\" %[%#2@[invalid]%] %#3s\n")
    (status-read-faq-aux-item . "Read FAQ:                  %15#2n for %#1?z%[%#1M <%#1m>%]%[the server%] %#3s\n")
    (bad-status-read-faq-aux-item . "Read FAQ:                                \"%<20...#1s\" %[%#2@[invalid]%] %#3s\n")
    (status-rejected-recommendation-aux-item . "Rejected recommendation for:             %#1M %#2s\n")
    (bad-status-rejected-recommendation-aux-item . "Rejected recommendation for:             \"%<20...#1s\" %[%#2@[invalid]%] %#3s\n")
    (status-send-comments-to . "Redirect comments to:                    %#1M <%#1m> %#2s\n")
    (bad-status-send-comments-to . "Redirect comments to:                    \"%<20...#1s\" %[%#2@[invalid]%] %#3s\n")

    (Everybody . "Everyone")
    (show-members-list-also-q . "List members? ")
    (show-membership-info-q . "Show membership info number of unreads? ")
    (conf-has-these-members . "\n%#1M has the following members:\n")
    (conf-has-no-members . "\n%#1M has no members.\n")
    (member-list-header . "\nLast entered        Unread  Name\n")
    (secret-membership . "--- Secret line ---\n")
    (conf-membership-line . "%#4@%#1s%#2M %#3s\n")
    (conf-membership-line-2 . "                            Added %#1s by %#2P\n")
    (pers-for-status . "Get status of which user? ")
    (text-to-see-author-status-of . "Get status of the author of which text? ")
    (no-such-pers . "The user doesn't exist.\n")
    (pers-status-record . "Status of user %#1P (%#1p)\n")
    (created-time .  "Created:%34#1s\n\n")
    (created-confs . "Conferences created:%22#1d\n")
    (created-persons . "Users created:%28#1d\n")
    (created-texts . "Texts created:%28#1d\n")
    (created-lines . "Lines created:%28#1d\n")
    (created-chars . "Characters created:%23#1d\n")
    (no-of-sessions . "Session count:%28#1d\n")
    (present-time-d-h-m-s . "Total presence:%16#1d d %02#2d:%02#3d:%02#4d\n")
    (last-log-in . "Last login or logout:%21#1s\n")
    (user-name . "User: %36#1s\n")

    (read-texts . "Texts read:%31#1d\n")
    (marked-texts . "Texts marked:%29#1d\n")
    (time-for-last-letter . "Time of last letter:%22#1s (according to your cache)\n")
    (superconf . "Superconference: %25#1m %#3s(%#2M)\n")
    (supervisor . "Supervisor: %30#1p %#3s(%#2P)\n")
    (member-of-confs . "Member of (conferences):%18#1d\n")
    (presentation . "Presentation:    %25#1n\n")
    (show-membership-list-also-q . "List memberships? ")
    (not-allowed-see-confs . "%#1P is not a member of any conferences.\n")
    (is-member-of . "\n%#1P is a member of the following conferences:\n")
    (membership-list-header . "\nLast access         Unread   Conference\n")
    (pers-membership-line . "%#5@%#1s%#2s%#3M %#4s\n")
    (pers-membership-line-2 . "                             Added %#1s by %#2P\n")
    (is-supervisor-mark . "O ")
    (who-to-send-message-to . "Send message to whom? (%#1s) ")
    (send-empty-message-p . "The message is empty. Send it anyway? ")
    (his-total-unread . "\n%#1M has %#2d unread texts (plus %#3d in passive memberships).\n")
    (message-prompt . "Message%#1?z%[%]%[ (till alla inloggade)%]: ")
    (message-sent-to-user . "\
%[%#3$================================================================
%]%[%#4$Your message for %#2M:

%#1t
%]%[%#3$----------------------------------------------------------------
%]")
    (message-sent-to-all . "\
%[%#3$================================================================
%]%[%#4$Your public message

%#1t
%]%[%#3$----------------------------------------------------------------
%]")
    (message-sent-to-user-long . "\
%[%#3$\
===============================================================================
%]%[%#4$Your message for %#2M:

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-sent-to-all-long . "\
%[%#3$\
===============================================================================
%]%[%#4$Your public message

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-use-alarm-instead . "Use %#1s to send alarm messages.\n")
    (message-all-info . "\
%#1@Send alarm message to all users.

%[%#3FConsider using \"%#2C\" to send your message to a specific
conference or user.%]
")
    (message-recipient-info . "Send message to %#1M\n")
    (message-nope .
     "Unable to send message. %#3s\
The message you were sending to %#1M was:
%#2t\n")
    (only-last . "Last texts in %#1s: ")
    (initial-unread . "Initial number of unread (empty for all texts): ")
    (only-error . "Something went wrong. Sorry.\n")
    
    (lp--only-last . "Number of text to read: ")

    (session-list-unreads-in-confs . 
			      "You have %#2?z%[%#2d unread letter%#2?d%[%]%[s%], in total %]%[%]%#3d unread text%#3?d%[%]%[s%] in %#4d conference%#4?d%[%]%[s%] in %#1s.\n")
    (session-list-no-unread-in . "You have no unread texts in %#1s.\n")

    (you-have-unreads . "You have %#1d unread text%#1?d%[%]%[s%] in %#2M\n")
    (you-have-unreads-special . "You have %#1d uncommented text%#1?d%[%]%[s%] in %#2M\n")
    (you-have-no-unreads . "You have read everything in %#1M\n")
    (you-have-read-everything . "No news (is bad news).\n")
    (no-unreads-shown . "Found no conferences meeting that criterion.\n")
    (total-unreads .
     "You have %#1d unread text%#1?d%[%]%[s%] texts in %#2d conference%#2?d%[%]%[s%].\n")
    (shown-unreads . "Showed %#1d unread text%#1?d%[%]%[s%] in %#2d conference%#2?d%[%]%[s%].\n")
    (list-unread-with-n-unread . "Listing conferences with at least %#1d unread.\n")
    (list-unread-with-at-most-n-unread . "Listing conferences with at most %#1d unread.\n")
    (waiting-for-anything .
     "You are waiting for a text in any conference.\n")
    (waiting-higher-than . 
     "You are waiting for a text in any conference with a priority higher than %#1d.\n")
    
    (have-to-be-in-conf-with-unread . "You must go to a non-empty conference first.\n")
    (Texts . "Text")
    (Written . "Written")
    (Lines . "Lines")
    (Author . "Author")
    (Subject . "Subject")
    (Comments . "Co")
    (Num-marks . "Mk")
    (mark-type . "Type")
    (mark-no . "Mrk")

    (could-not-read . "You couldn't read the text (%#1n).\n")
    (multiple-choice . "There are several alternatives.")

    (does-not-exist . "Unknown command.") ; Only people fixing bugs or receiving bug reports should change these:
    (summary-line . "%=-8#1n%#2s%4#3d  %[%#4@%#5:P%]  %[%#6@%#7r%]\n")
    (diff-what-text-old . "Old text to compare: ")
    (diff-what-text-new . "New text to compare: ")

    ; Only people fixing bugs or receiving bug reports should change these:
    (buggreport-compilestart . "Creating bug report...")
    (buggreport-compileend . "Creating bug report...done")
    (buggreport-description . "This is what I was doing:
\(Fill in your comments below\)\n================\n\n
================
In the information below are the 100 most recently pressed keys from
your emacs. If you recently logged on, you password may be contained in
this list. If that is the case, change the characters corresponding to
your password to asterisks.

When you have finished writing this, send your bug report to the LysKOM
developers. You can do this either by email to bug-lyskom@lysator.liu.se or
by mailing a hardcopy of your bug report to:
Lysator, c/0 ISY, Linkoping Univerity, S-581 83 Linkoping, SWEDEN.
Mark the envelope with \"LysKOM bug report\"\n\n")
    (buggreport-internals . "LysKOM's internal information:\n\n")
    (buggreport-version . "lyskom-version:")
    (buggreport-emacs-version . "emacs-version:")
    (buggreport-system-id . "system-id:")
    (buggreport-ctl-arrow-doc . "ctrl-doc:")
    (buggreport-unparsed . "\nlyskom-unparsed-buffer:")
    (buggreport-command-keys . "Recently pressed keys:")
    (buggreport-backtrace . "\n*Backtrace*:\n%#1s\n")
    (buggreport-communications . "\nlyskom-debug-communications-to-buffer-buffer:")
    (buggreport-all-kom-variables . "\n\nOther variables:\n***** *********")
    (buggreport-instead-of-byte-comp . "byte-code(\"byte-string\"")
    (buggreport-subject . "Bugreport elisp-client version %#1s")


    (not-logged-in . "You are not logged on. ")
    (name-is-not-in-conf . "%#1s is not in any conference.\n")
    (name-is-in-conf . "%#1s is in\n%#2s\n")
    (connected-during . "Connect time: %#1d seconds.\n")

    (conf-to-set-permitted-submitters-q . "For which conference do you want to set the allowed authors? ")
    (conf-to-set-super-conf-q . "Set superconference of which conference? ")
    (new-super-conf-q . "Which conference do you want as superconference? ")
    (new-permitted-submitters-q . "Allow members of which conference as authors in %#1s? (all) ")
    (super-conf-for-is . "Changing superconference of %#1M to %#2M...")
    (permitted-submitters-removed-for-conf . "Allowing all authors to conference %#1M...")
    (submitters-conf-for-is . "Changing authors admitted to conference %#1M to the members of %#2M...") 
   
    (conf-to-set-garb-nice-q . "Set expiration time for which conference? ")
    (new-keep-commented-q . "How many days shall new comments protect texts from removal? ")
    (new-garb-nice-q . "After how many days shall texts be removed? ")
    (garb-nice-for-is . "Changing expiration for %#1M to %#2d day%#2?d%[%]%[s%]...")
    (keep-commented-for-is . "Changing minimum expiration for commented texts in %#1M to %#2d day%#2?d%[%]%[s%]...")

    (really-shutdown . "Are you sure you want to shut down the server? ")
    (closing-server . "Shutting down the server...")
    (really-sync . "Are you sure you want to save the database? ")
    (syncing-server . "Saving the database...")
    (administrator . "administrator")
    (no-longer-administrator . "a regular user again")
    (you-are-now . "Ok, you are now running as %#1s.\n")
    (setting-motd . "Changing login message to text %#1n.\n")
    (set-motd-success . "You have set a new login message.\n")
    (set-motd-failed . "Didn't work. Perhaps you were not an administrator.\n")
    (removing-motd . "Removing the login message.\n")
    (removed-motd . "You have removed the login message.\n")
    (who-to-throw-out . "Whose session do you want to kill? ")
    (throwing-out . "Killing session %#1d... ")
    (postpone-prompt . "How much do you want to read now? ")
    (set-session-priority . "Set reading level: ")

    ; From review.el:
    (no-unread-done . "You need to unread something before you can unread more.\n")
    (no-review-done . "You need to review something before you can review more.\n")
    (not-reviewing . "You are currently not reviewing anything.\n")
    (unread-how-many . "Unread how many?")
    (unread-how-many-more . "Unread how many more?")
    (review-how-many . "Review how many?")
    (review-how-many-more . "Review how many more?")
    (latest-n . "last %#1d")
    (first-n . "first %#1d")

    (review-by-whom . "Review %#1s by whom: ")
    (review-to-conf . "Review %#1s to conference: ")
    (unread-by-whom . "Unread %#1s by whom: ")
    (unread-to-conf . "Unread %#1s to conference: ")
    (all-confs . "all conferences")

    (unread-info-by-to . "Unread %#1s by %#2P to %#3M.\n")
    (unread-more-info-by-to . "Unread %#1s by %#2P to %#3M.\n")
    (unread-rest . "the rest")
    (unread-more . "%#1d more")

    (review-info-by-to . "Review %#1s by %#2P to %#3M forwards.\n")
    (review-more-info-by-to . "Review %#1s by %#2P to %#3M forwards.\n")
    (review-rest . "the rest")
    (review-more . "%#1d more")
    (you-review . "You are now reviewing %#1s.\n")
    (read-text-first . "You must read a text first.\n")
    (cannot-read-last-text . "You cannot review the last read text.\n")
    (review-n-texts . "Review %#1d texts.\n")
    (review-marked . "Review %#1d marked texts.\n")
    (review-text-no . "Review text %#1n\n")
    (review-many-comments . "Review %#2?d%[one%]%[%#2d%] comment%#2?d%[%]%[s%] to text %#1n.\n")
    (view-many-comments . "Read %#2?d%[one%]%[%#2d%] comment%#2?d%[%]%[s%] to %#1n.\n")
    (view-texts-in-conf . "Grand total of %#1d texts to read in %#2M.\n")

    (not-reading-anywhere . "You are not reading in any conference.\n")
    (read-normally-read . "How many texts to you want to read again? ")

    (review-conf-gone . "The conference does not exist.\n")
    (review-pers-gone . "The user does not exist.\n")
    (review-cant-read-conf . "You can't review texts to a closed conference you are not a member of.\n")
    (review-cant-read-letterbox . "You can't review texts to somebody else's mailbox.\n")
    (review-cant-read-empty . "The conference is empty.\n")
    (cant-review-everything . "You cannot review every text in LysKOM.\n")
    (cant-unread-everything . "You cannot unread every text in LysKOM.\n")

    (more-than-one-root . "Text %#1n has more than one root.\n")
    (more-than-one-root-review . "\
Text %#1n has more than one root but only one of the trees will be shown.\n")

    ; From edit-text.el:
    (press-C-c-C-c . "Enter C-c C-c to post the text.")
    (recipient . "Recipient")
    (carbon-copy . "Carbon copy")
    (blank-carbon-copy . "Blind Carbon copy")
    (recipient-prefix . "\\([Rr]\\)")
    (carbon-copy-prefix . "[Cc]\\([Aa]\\|[Cc]\\)")
    (blank-carbon-copy-prefix . "[Bb]\\([Ll]\\|[Cc][Cc]\\)")
    (add-recipient . "Add a recipient")
    (add-recipient-or-xref . "Add...")

    (secret-aux-flag . "secret")
    (anonymous-aux-flag . "anonymous")
    (inherit-aux-flag  . "inherited")
    (aux-item-prefix . "[*]")
    (aux-item-prefix-regexp . "\\[\\*\\]\\s-*")
    (comment-item-prefix . "#\\s-*")
    (text-no-comment . "%#1d %#2s /%#3d line%#3?d%[%]%[s%]/ %#4P %#5?b%[ [anonymous]%]%[%]\n")
    (cant-fcc-text-file-error . "Unable to save text %#1n to \"%#2s\" (%#3s: %#4s).\n")
    (cant-fcc-text . "Unable to save text %#1n to \"%#2s\" (%#3s).\n")

    (header-subject . "Subject: ")
    (header-separator . "\\<lyskom-edit-mode-map>\
--- Write below. \
Post: \\[kom-edit-send], \
Kill: \\[kom-edit-quit], \
Help: \\[describe-mode] ---")
    (text-mass . "%#4s%#1s%[%#6@\n%]%[%#5@%#2s%]%[%#7@\n%]%#3s")
    (comment-to-by . "%#1s to text %#2n%#3s.\n")
    (already-sent . "You have already posted this text. Post it anyway? ")
    (subject . "Subject: ")
    (subject-prefix . "[Ss]")
    (enter-subject-idi . "Enter a subject.")
    (which-text-include . "Include which text? ")
    (added-recipient . "Recipient: ")
    (added-carbon-copy . "Carbon copy to conference: ")
    (added-blank-carbon-copy . "Blind carbon copy to conference: ")
    (text-to-comment-q . "Which text do you want to comment? ")
    (conf-has-motd-no . "The conference has a notice. (%#1d)\n\n%#2s")
    (still-want-to-add . "Do you still want to add the conference as a recipient? ")
    (could-not-create-text . "\nCouldn't create the text. Error: %#2s.\n")
    (no-get-text . "You were not allowed to retrieve the text.")
    (unknown-header . "Unknown header")
    (transform-error . "Send unformatted (%#1s)? ")
    (cant-find-info-node . "Can't find the info buffer")

    (link-type . "What to you want to link to? ")
    (which-text-to-link . "Add link to text: ")
    (which-text-to-link-err . "Text not found. Add link to text: ")
    (which-pers-to-link . "Add link to user: ")
    (which-conf-to-link . "Add link to conference: ")

    ; From view-text.el:
    (view-text-first-line . "%#7$%#2@%#1n %#3s /%#4d line%#4?d%[%]%[s%]/ %#5P%#6?b%[%#6s%]%[%]\n")

    (marked-by-you . "Marked by you (type: %#1s).\n")
    (marked-by-you-and-others . "Marked by you (type: %#2s) and %#1?d%[someone else%]%[%#1d others%].\n")
    (marked-by-several . "Marked by %#1d user%#1?d%[%]%[s%].\n")

    (timeformat-day-yyyy-mm-dd-hh-mm-ss . "%#7s %4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm-ss . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d")
    (timeformat-yyyy-mm-dd . "%4#1d-%02#2d-%02#3d")
    (timeformat-hh-mm-ss . "%02#4d:%02#5d:%02#6d")
    (timeformat-hh-mm . "%02#4d:%02#5d")

    (format-time-date-and-time . "%#1s %#2s")
    (format-time-just-date . "%#1s")
    (format-time-just-time . "%#2s")
    (today . "today")
    (yesterday . "yesterday")

    (no-such-text-no . "The text doesn't exist. (%#1:n)\n")
    (text-created-at . "Created: %#1s\n")
    (text-imported-at . "Imported: %#1s\n")
    (text-imported-at-by . "Imported: %#1s by %#2P\n")

    (head-Subject . "Subject: ")
    (Recipient . "Recipient")
    (Extra-recipient . "CC")
    (Hidden-recipient . "BCC")
    (mx-Recipient . "External recipient")
    (mx-Extra-recipient . "External CC")
    (mx-Extern-reply-to . "External replies to")
    (Strange-recipient . "Also to")
    (send-at . "   Posted:     %#1s\n")
    (sent-by . "   Posted by %#1P\n")
    (received-at . "    Received: %#1s\n")

    (comment-to-text . "Comment to text %#1n")
    (footnote-to-text . "Footnote to text %#1n")
    (comment-in-text . "Comment in text %#1n")
    (footnote-in-text . "Footnote in text %#1n")

    (attachment-to-text . "Attachment %#3sto text %#1n")
    (attachment-in-text . "Attachment %#3sin text %#1n")
    
    (envelope-sender . "Sent by: %#1s\n")
    (attachment-filename . "Attachment file name: \"%#1s\"\n")
    (message-id . "Message-ID: %#1s\n")

    (comment-to-text-by . "Comment to text %#1n by %#2P")
    (footnote-to-text-by . "Footnote to text %#1n by %#2P")
    (comment-in-text-by . "Footnote in text %#1n by %#2P")
    (footnote-in-text-by . "Footnote in text %#1n by %#2P")

    (written-by . " by %#1P\n")

    ; From async.el:

    (name-has-changed-to-name . "%#1:P has changed name to %#2:P")
    (name-has-changed-to-name-r . "%[%#3@%#1:P%] has changed name to %[%#3@%#2:P%]\n")
    (you-changed-name-to . "You have now changed your name to %[%#2@%#1:P%].\n")
    (database-sync . "Synching database.")

    (lyskom-is-full . "\
===========================================================
Message from the LysKOM system: Somebody tried to connect,
but failed since all connections available to LysKOM are in
use. Please leave and return later if you are just waiting
for a text.
===========================================================\n")
    (lyskom-is-full-long . "\
===============================================================================
Message from the LysKOM system: Somebody tried to connect,
but failed since all connections available to LysKOM are in
use. Please leave and return later if you are just waiting
for a text.
===============================================================================
")
    (has-entered . "%#1:P has entered %#2s.")
    (has-entered-r . "%#2@%#1P has entered %#3s.\n")
    (has-left . "%#1:P has left %#2s.")
    (has-left-r . "%#2@%#1P has left %#3s.\n")
    (Unknown . "Unknown")
    (unknown . "unknown")
    (Unknown2 . "Unknown")

    (no-longer-member . "You are no longer a member of %#1M.\n")
    (no-longer-member-n . "You are no longer a member of %#1m (conference is gone).\n")
    (have-become-member . "You have become a member of %#1M.\n")
    (have-become-invited-member . "You have been invited to %#1M.
Go to the conference to accept or decline the invitation. You can also use
the command 'Join conference' to accept the invitation.\n")
    (have-become-passive-member . "You have become a passive member of %#1M.\n")


    (message-broadcast . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Alarm from %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-broadcast-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Alarm from %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Personal message from %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-from-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Personal message from %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from-to ."\
%[%#5$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$Group message to %#3M\nfrom %#2P (%#4s):

%#1t
%]%[%#5$\
----------------------------------------------------------------
%]")
    (message-from-to-long ."\
%[%#5$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$Group message to %#3M\nfrom %#2P (%#4s):

%#1t
%]%[%#5$\
-------------------------------------------------------------------------------
%]")


    (text-is-created . "Text %#1n has been created!")

    ; Used in mode-line-process
    (mode-line-waiting . ": waiting")
    (mode-line-working . ": working")
    (mode-line-saving . ": saving")
    (mode-line-down . ": down")

    ; From completing-read.el:

    (person-or-conf-no-regexp . "\\`[ \t]*[mpMP]\\w*[ \t]+\\([0-9]+\\)\\'")
    (session-no-regexp . "\\`[ \t]*[sS]\\w*[ \t]+\\([0-9]+\\)\\'")
    (conf-prompt . "Which conference/person? ")

    ; From flags.el:
    (saving-settings . "Saving options...")
    (saving-settings-done . "Saving options...done")
    (save-options-failed-internal . "\
Failed to save options because of an internal error.

Global options:       %#1?b%[Encoding failed%]%[OK%]
Elisp client options: %#2?b%[Encoding failed%]%[OK%]
Other client options: %#3?b%[Encoding failed%]%[OK%]

Rapportera grna detta fel till elispklientens utvecklare.
")
    (hang-on . "Wait a moment...\n")
    (no-changes . "Nothing was saved since no options had been changed.\n")
    (could-not-save-options . "Couldn't save options.\n")
    (could-not-create-area . "Couldn't create the text.\n")
    (could-not-set-user-area . "Couldn't alter the user area. The server says error: %#1d\n")
    (you-dont-exist . "You don't exist. Go away.\n")
    (error-in-options . "There was an error in one of your variables (%#1s)
It was set to \"%#2s\" in the user area. It is set to nil instead.
Send a bug report.\n")
    (error-in-options-short . "There was an error in your saved settings. Some settings have not been read.")
    (reading-settings-from-server . "Saved settings have changed on the server. Re-reading saved settings.\n")

    ; From elib-string.el:
    ; No entries.

    ; From lyskom-rest.el:

    (mode-line-unread . " Unread ")
    (mode-line-letters . "letters ")
    (frame-title-unread . "Unread")
    (frame-title-letters . " letters")
    (sessions-with-unreads . "Sessions with unread texts")
    (unread-letters . "unread letters")

    (bad-text-no-prefix . "Unable to translate prefix `%s' to a text number")
    (prefix-arg-try-again . "Specify another text or press control-g to abort.\n")
    (error-code . "%#2?+%[Error code %#2d/%#3S: %]%[%]%#1s.\n")
    (error-in-kom-do-when-done . "The variable kom-do-when-done has an erroneous value.
You should set it to a better value.\n")
    (extended-command . "LysKOM: ")
    (wait-for-server . "LysKOM is waiting for a response from the server. Wait for the prompt.\n")
    (review-text-q . "Review text: ")

    (completely-read-conf . "You have seen all the texts in this conference.\n")
    (not-in-any-conf . "You are not in a conference now.\n")

    (all-conf-unread-r . "You have nothing unread.\n")
    (all-conf-unread-s . "You have nothing unread. ")
    (enter-conf-unread . "%#1d unread text%#1?d%[%]%[s%]")
    (enter-conf-unread-faq . "%#1d unread FAQ%#1?d%[%]%[s%]")

    (save-one-on-file-q . "Save copy of text %#1n in file: ")
    (save-many-on-file-q . "Save copies of %#1d texts in file: ")
    (saving-one-on-file . "Saving copy of text %#1n in %#2s.\n")
    (saving-many-on-file . "Saving %#1d texts in %#2s.\n")
    (save-text-to-file-q . "Save body of text %#1n in which file: ")
    (save-text-confirm . "File %#1s exists. Overwrite? ")
    (saving-text . "Saving text %#1n as %#2s...")
    (what-save-no . "Which text do you want to save? ")
    (wait-for-prompt . "Wait for the prompt.")

    (conference-no . "<conference %#1d>")
    (person-no . "<person %#1d>")
    (prompt-several-messages . "(%d messages)")
    (prompt-single-message . "(%d message)")

    (text-buffer-missing . "The text buffer no longer exists.\n")
    (re-edit-text-prompt . "Edit the text that couldn't be created")
    (go-to-pri-conf-prompt . "Go to next prioritized conference")
    (go-to-pri-mailbox-prompt . "G to your mailbox (prioritized)")
    (read-pri-text-conf . "Read next prioritized text")
    (read-pri-letter-prompt . "Read next letter (prioritized)")
    (review-next-text-prompt . "Review next text")
    (review-next-comment-prompt . "Review next comment")
    (review-next-marked-prompt . "Review next marked text")
    (review-next-faq-prompt . "Review next FAQ")
    (read-next-letter-prompt . "Read next letter")
    (read-next-footnote-prompt . "Read next footnote")
    (read-next-comment-prompt . "Read next comment")
    (read-next-text-prompt . "Read next text")
    (read-next-attachment-prompt . "Read next attachment")
    (go-to-conf-of-marked-prompt . "Resume reviewing marked")
    (go-to-conf-of-review-tree-prompt . "Resume reviewing comments")
    (go-to-conf-of-review-prompt . "Resume reviewing texts")
    (go-to-conf-of-review-faq-prompt . "Resume reviewing FAQs")
    (go-to-next-conf-prompt . "Go to next conference")
    (go-to-your-mailbox-prompt . "Go to your mailbox")
    (next-pri-session-prompt . "Go to prioritized LysKOM \"%#1s\"")
    (next-unread-session-prompt . "Go to LysKOM \"%#1s\"")
    (no-such-kom-session . "No such session with unread texts.\n")
    (the-command . "Command: %#1C")
    (error-in-login-hook . "There was an error in your kom-login-hook: %#1s\n")

    (give-a-number . "Enter a number: ")

    (yes-regexp . "\\`[yY][eE][sS]\\'")
    (no-regexp . "\\`[nN][oO]\\'")
    (yes-string . "Yes")
    (no-string . "No")
    (yes-or-no-nag . "Answer yes or no.")
    (yes-or-no . "(yes or no) ")

    (y-or-n-instring . "yYnN ")
    (j-or-n-nag . "Answer y or n. ")
    (j-or-n . "(y or n) ")
    (y-instring . "yY ")

    (a-or-b-or-c-nag . "Pleas press a valid key. ")

    (person-does-not-exist . "User %#1d (does not exist).")
    (conference-does-not-exist . "Conference %#1d (does not exist).")
    (conf-no-does-not-exist-r . "Conference %#1d does not exist.")
    (person-is-anonymous . "Anonymous user")

    (process-signal . "Signal from the process.")
    (dead-session . "No active LysKOM session.")
    (resurrect-session . "The LysKOM session is not active. Do you want to reconnect? ")
    (not-lyskom-buffer . "This is not an active LysKOM session.")
    (closed-connection . "
**************************************************
%#2s
LysKOM session killed abnormally
Error message: %#1s**************************************************")
    (error-not-found . "Error code %#1d. No explanation available.")

    ; Useful in more places than one:
    (illegal-command . "Illegal command.\n")
    (no-such-text . "The text doesn't exist.\n")
    (no-such-text-m . "The text doesn't exist.")
    (nobody . "nobody")
    (everybody . "everyone")
    (everything . "everything")
    (anybody . "anyone")
    (forward . "forward")
    (backward . "backward")
    (wait . "Wait a moment...\n")
    (comment . "Comment")
    (comment-prefix . "\\([Cc][Oo]\\)")
    (footnote . "Footnote")
    (footnote-prefix . "\\([Ff]\\)")
    (by . " by %#1P")
    (text-created .  "Text %#1n has been created.\n")
    (text-created-anonymous .  "\
Text %#1n has been created (anonymously). To make it more difficult
for others to figure out that you wrote the text, you should wait a while
before reading it.\n")

    (resolve-session . "Which session: ")

    (starting-program . "Starting %#1s...")
    (super-jump . "Filtering subject \"%#1r\" in conference \"%#2M\"\n")
    (no-recipient . "There are no recipients for this text.\n")
    (filtered . "[Filtered]")
    (filter-error-specification . "Error in the filter specification")
    (filter-error-bad-not . "Error in the filter specification after 'not'")
    (filter-error-unknown-key . "The filter key '%S' is unknown.")
    (filter-error-key-arg . "Bad filter data (%S %S)")
    (filter-tree . "Skipping text %#1n \"%#2r\" by %#3P and all its comments.\n")
    (filter-text . "Skipping text %#1n \"%#2r\" by %#3P.\n")
    (filter-permanent . "Permanent? ")
    (filter-action . "Filter how? ")
    (filter-in-conf . "In which conference? (all) ")
    (filter-subject . "Filter which subject? ")
    (filter-recipient . "Filter which recipient? ")
    (filter-which-text . "Filter texts containing: ")
    (filter-author . "Filter which author? ")
    (permanent . "(permanent)")
    (temporary . "(temporary)")
    (filter-edit-buffer-name . "*LysKOM Filter Edit*")
    (filter-edit-empty-list . "Empty list")
    (filter-edit-start-of-list . "Beginning of list")
    (filter-edit-end-of-list . "End of list")
    (filter-edit-filter-how . "Filter how? ")
    (filter-edit-filter-what . "What do you want to filter? ")
    (filter-edit-bad-argument . "Bad input: %s")
    (filter-edit-outside-entry . "Can't do that outside a filter")
    (filter-edit-outside-list . "Can't do that outside the list")
    (filter-edit-end-of-pattern . "End of filter")
    (filter-edit-save-p . "Save changes? ")
    (filter-edit-remove-empty . "Empty filters cause all texts to be filtered. Do you want to remove these? ")
    (filter-edit-restart-p . "You have made changes. Really revert? ")
    (filter-edit-help . "p Up, n Down, i New line, M-i New filter, d Delete line, M-d Delete filter")
    (filter-edit-header . "Edit filters on \"%s\"\n")
    (filter-edit-saving . "Saving changes...")
    (filter-edit-saving-done . "Saving changes...done")
    (filter-edit-saving-error . "Couldn't save changes!")
    (filter-edit-insert-pred . "%#1s (=,!=): ")
    (filter-edit-insert-arg . "%#1s %#2s (what): ")
    (no-filters . "No filters are defined.\n")
    (view-filters-header . "\nActive filters:\n\n")
    (view-filters-footer . "")

    (ansaphone-new-message . "New Ansaphone message: ")
    (ansaphone-message . "Ansaphone message:
----------------------------------------------------------------------
%#1t
----------------------------------------------------------------------
")
    (ansaphone-message-long . "Ansaphone message:
-------------------------------------------------------------------------------
%#1t
-------------------------------------------------------------------------------
")
    (ansaphone-state . "The Ansaphone is %#1s.")
    (ansaphone-state-r . "The Ansaphone is now %#1s.\n")
    (ansaphone-messages-gone . "Recorded messages have been erased.")
    (ansaphone-no-messages . "No recorded messages.\n")
    (ansaphone-message-list-start . "Recorded messages:\n\n")
    (ansaphone-message-list-end . "\n\n")
    (ansaphone-message-header . "Automatic reply (set %#1s):\n")

    (remote-erase-messages . "Remote control (%#1P %#2s): Erased recorded messages\n")
    (remote-set-message . "Remote control (%#1P %#2s): Ansaphone message:
----------------------------------------------------------------------
%#3t
----------------------------------------------------------------------
")
    (remote-set-message-long . "Remote control (%#1P %#2s): Ansaphone message:
-------------------------------------------------------------------------------
%#3t
-------------------------------------------------------------------------------
")    (remote-set-ansaphone . "Remote control (%#1P %#2s): The ansaphone is %#3s\n")
    (remote-list-messages . "Remote control (%#1P %#2s): Listed recorded messages\n")
    (remote-quit . "Remote control (%#1P %#2s): Quit\n")

    (illegal-remote . 
"Illegal remote control attempt:
Time: %#1s
From: %#2P <%#2p>
To  : %#3P <%#3p>
Text: 
%#4t")
    (illegal-remote-reply . "Remote control rejected: %#1s") 
    (remote-not-in-list . "Unauthorised person")
    (remote-bad-command . "Unknown or malformed command")
    (remote-unknown-error . "Unknown error")

    (remote-control-who . "Remotely control which session? ")
    (remote-control-autoreply . "Ansaphone on or off? ")

    (state-on . "on")
    (state-off . "off")
    

    (text-popup-title . "Text %#1s")
    (conf-popup-title . "Conference %#1s")
    (pers-popup-title . "User %#1s")
    (url-popup-title  . "URL %#1s")
    (aux-popup-title  . "Property")
    (timestamp-popup-title . "Timestamp %#1s")
    (recpt-type-popup-title . "Recipient type: %#1s")
    (add-recpt-button-text . "[Add...]")
    (add-recpt-button-text-regex . "\\[Add\\.\\.\\.\\]")
    (generic-popup-title . "%#1s")

    (who-i-am-not-present . "%#1P (not in any conference) \n")
    (who-i-am-present . "%#1P is present in %#2M\n")
    (who-i-am-client . "The program is lyskom.el, version %#1s%#2?b%[ (MULE)%]%[%].\n")
    (who-i-am-server . "This is %#1s, version %#2s.\n")
    (who-i-am-emacs . "Running under %#1s%#2?b%[ (MULE)%]%[%].\n")

    (no-such-session-r . "That session does not exist. Perhaps the user is not logged on.\n")
    (person-not-logged-in-r . "%#1P %#2?b%[has not been logged on since %#2s%]%[is not logged on%].\n")

    (session-status . "Session %#1d is %#2P <%#2p>
%#5s %#7s %#4M
Using %#6D from %#3s\n")
    (session-status-9 . "Session %#1d is %#2P <%#2p>
%#5s %#7s %#4M
Using %#6D from %#3s
On since %#8s%#9s")
    (session-status-inactive . "\nHas been inactive for %#1s\n")
    (one-day . "one day")
    (one-hour . "one hour")
    (one-minute . "one minute")
    (years . "years")
    (year . "r")
    (month . "month")
    (months . "months")
    (days . "days")
    (day . "day")
    (hours . "hours")
    (minutes . "minutes")
    (and . "and")
    (session-is-active . " and is currently active.\n")
    (session-is-invisible . "This session is invisible.\n")
    (status-for-session . "Session status for whom? ")
    (unknown-doing-what . "Exists")
    (doing-where-conn . "in")
    (doing-nowhere-conn . "but is")
    (waiting-for-membership . "Waiting for the membership list to be fetched...%d/%d")

    ;; From slow.el
    (no-such-command . "There is no such command.\n")
    (command-completions . "You may mean one of the following:\n %#1s\n")

    (which-language . "Change language to: ")
    (send-formatted . "Send as formatted text? ")
    (changing-language-to . "Changing to %#1s.\n")
    (language-set-to . "Language set to %#1s%#2?b%[ %#3@[%#2s]%]%[%].\n")
    (language-not-loaded . "%#1s is unavailable.\n")

    (reformat-html . "HTML")
    (reformat-enriched . "enriched")
    (reformat-filled . "filled")
    (reformat-image . "image")
    (image-no-show . "< The image cannot be shown. >")

    (reformat-truncated . "truncated")

    (reformat-signature . "designed")

    (reformat-deswascii . "was swascii")

    (reformat-rot13 . "rot13")

    (need-library . "The \"%#1s\" package is required for this command.\n")
    (calc-expression . "Expression: ")

    (do-send-anonymous . "Send the text anonymously? ")
    (remove-self-sending-anonymous . "Remove yourself as a recipient of the text? ")
    (anonymous . "anonymous")
    (Anonymous . "Anonymous")

    (secret-conf-letter . "S")
    (protected-conf-letter . "P")
    (created-conf-letter . "C")
    (superconf-conf-letter . "S")
    (supervisor-conf-letter . "O")

    ;; Some Help

    (where-is-doesnt-exist . "The command %#1s does not exist")
    (where-is-on-no-key . "%#1s is not on any key")
    (where-is-on-key . "%#1s is on %#2s")

    ;; From aux-items.el

    (content-type-aux . "Content type: %#1s")
    (content-type-regexp . "Content type: \\(\\S-+\\)")

    (agreeing . "Agreeing with text %#1n...")
    (fast-replying . "Remark to text %#1n...")
    (author-fast-replies . "Remarks by the author:")
    (author-fast-reply-aux . "  \"%#1t\"")
    (other-fast-replies . "Remarks:")
    (other-fast-reply-aux . "  \"%#1t\" /%#2P/")
    (fast-reply-too-long . "Can't create remarks that consist of more than one line.\n")

    (conf-to-list-faqs . "List FAQ for which conference: ")
    (faq-for-conf-aux . "FAQ for %#1M <%#1m>")
    (bad-faq-for-conf-aux . "FAQ: \"%<20...#1s\" %[%#2@[invalid]%] %#3s")
    (faq-for-server-aux . "FAQ for the LysKOM-server") 
    (faq-in-text-aux . "FAQ in text:                 %10#1n %#2D")
    (bad-faq-in-text-aux . "FAQ in text:                             \"%<20...#1s %[%#2@[invalid]%] %#3s")
    (conf-to-add-faq . "Which conference do you want to add an FAQ for? ")
    (text-to-add-as-faq . "Which text is the new FAQ? ")
    (text-to-change-as-faq . "Which FAQ do you want to change? ")
    (adding-faq . "Adding text %#1n as an FAQ for %#2?b%[%#2M%]%[the server%]...")
    (conf-to-del-faq . "Which conference do you want to remove an FAQ from? ")
    (text-to-del-as-faq . "Which text do you want to remove as FAQ? ")
    (deleting-faq . "Removing text %#1n as FAQ for %#2?b%[%#2M%]%[the server%]...")
    (conf-has-no-faq . "%#1?b%[%#1M%]%[The server%] has no FAQ\n")
    (unread-which-faq . "Mark FAQ for which conference as unread? ")
    (view-which-faq . "View FAQ for which conference? ")
    (review-faq-for-r . "View FAQ for %#1?b%[%#1M%]%[the server%].\n")
    (set-faq-for-conf-done . "FAQ for %#1?b%[%#1M%]%[the server%] set to text %#3n.\n")
    (set-faq-for-conf-failed . "Unable to set the FAQ for %#1?b%[%#1M%]%[the server%] to text %#3n.\n")
    (changed-faq-for-conf-done . "FAQ in text %#2n for %#1?b%[%#1M%]%[the server%] changed to text %#3n.\n")
    (changed-faq-for-conf-failed . "Unable to change FAQ for %#1?b%[%#1M%]%[the server%] to text %#3n.
%#2?b%[Text %#2n is still the FAQ.
%]%[%]%#4s")
    (faq-in-text . "FAQ in text %#1n %#3s%#4s")
    (faq-in-text-by . "FAQ in text %#1n %#5s %#3sby %#2P %#4s")
    (server-has-new-faq . "\nThere %#1?d%[is a new FAQ%]%[are %#1d new FAQs%] for the server.\n")
    (unread-faqs-header . "\nUnread FAQ%#1?d%[%]%[s%] for %#2?b%[%#2M%]%[the server%]::\n")
    (all-faqs-header . "All FAQs for %#1?b%[%#1M%]%[the server%]:\n")

    (too-many-languages . "Cannot code that many character sets. Send uncoded? ")
    (too-many-content-types . "Cannot figure out what content type you want. Simplify the text.")

    (cross-reference-text-status-aux . "See text:              %10#1n /%#2P/")
    (cross-reference-conf-status-aux . "See conference:                         <%#1m> %#1M /%#2P/")
    (cross-reference-pers-status-aux . "See person:                             <%#1p> %#1P /%#2P/")
    (strange-cross-reference-status .  "See also:                                %#1s (whatever that means)")
    (cross-reference-text-aux . "See text %#1n /%#2P/")
    (cross-reference-conf-aux . "See conference <%#1m> %#1M /%#2P/")
    (cross-reference-pers-aux . "See person <%#1p> %#1P /%#2P/")
    (cross-reference-text-regexp . "See text \\([0-9]+\\)")
    (cross-reference-conf-regexp . "See conference <\\([0-9]+\\)>")
    (cross-reference-pers-regexp . "See person <\\([0-9]+\\)>")
    (strange-cross-reference . "See %#1s, whatever that might mean")

    (no-comments-aux . "The author has requested others not to comment this text")
    (no-comments-edit-aux . "Request that others do not comment")
    (no-comments-regexp . "Request that others do not comment")
    
    (personal-comment-aux . "The author has requested private replies only")
    (personal-comment-edit-aux . "Request private replies only")
    (personal-comment-regexp . "Request private replies only")
    
    (request-confirmation-aux . "%#1P has requested confirmation of reading")
    (request-confirmation-edit-aux . "Request confirmation of reading")
    (request-confirmation-regexp . "Request confirmation of reading")
    (confirm-read-q . "Confirm reading text %#1n? ")
    
    (read-confirm-aux . "Confirmed reading: %#1P %#2s")

    (redirect-email-aux . "Send e-mail to %#1s")
    (redirect-lyskom-aux . "Send texts to conference %#1M")

    (label-what-kind . "Set personal label on what (text, conference, user)? ")
    (label-what-text . "Set personal label on text: ")
    (label-what-conf . "Set personal label on which conference? ")
    (label-what-pers . "Set personal label on which person? ")
    (label-what-label . "Personal label: ")
    (label-secret    . "Should others to be able to see the label? ")

    (creating-software-aux . "Created with %#1s")
    (world-readable-text-aux . "The text can be read without logging on")
    (world-readable-text-edit-aux . "Make the text readable without logging on")

    (cant-get-aux-item . "Can't find property\n")
    (aux-item-no-info . "No information available\n")
    (aux-item-info . "\
Number:        %#1d %#6s
Type:          %#2d (%#3s)
Created by:    %#4P <%#4p>
Created:       %#5s
Flags:         %#7s
Inherit limit: %#8s
Contents:     \"%#9s\"
")
    (secret . "Secret")
    (deleted . "Deleted")
    (hide-creator . "Secret creator")
    (inherit . "Inherited")
    (unlimited-inherit . "Unlimited inheritance")
    (no-inheritance . "Inheritance is off")
    (no-more-inheritance . "Inherit limit reached; will not be further inherited")
    (inherit-steps . "%#1d steps")

    (aux-item-for . "Properties for ")
    (aux-item-for-conference-no . "conference <%#1m> %#1M")
    (aux-item-for-text-no . "text %#1n")
    (aux-item-for-server . "the server")

    (what-fast-reply-no . "Remark to which text? ")
    (fast-reply-prompt . "Remark: ")
    (agree-prompt . "Text: ")
    (default-agree-string . "I agree")
    (what-agree-no . "Agree with which text? ")

    (what-kind-to-add-aux-to . "Attach information to what? ")
    (which-conf-to-add-aux-to . "Which conference to you want to attach information to? ")
    (which-text-to-add-aux-to . "Which text to you want to attach information to? ")
    (which-aux-item-tag . "Information tag: ")
    (which-aux-item-inherit . "Set the  inherit-flag? ")
    (which-aux-item-secret . "Set the secret-flag? ")
    (which-aux-item-anonymous . "Set the anonymous-flag? ")
    (which-aux-item-rsv1 . "Set the dont-garb-flag? ")
    (which-aux-item-rsv2 . "Set the reserved2-flag? ")
    (which-aux-item-rsv3 . "Set the reserved3-flag? ")
    (which-aux-item-rsv4 . "Set the reserved4-flag? ")
    (which-aux-item-inherit-limit . "Inherit limit: ")
    (which-aux-item-data . "Data: ")

    ;; Cross-reference stuff

    (Person . "User")
    (person . "user")
    (persons . "users")
    (Conference . "Conference")
    (conference . "conference")
    (conferences . "conferences")
    (Text . "Text")
    (text . "text")
    (texts . "texts")
    (Server . "Server")
    (server . "server")
    (servers . "servers")
    (abc-person . "pPerson")
    (abc-conference . "cConference")
    (abc-text . "tText")

    (xref-type . "What to you want to refer to? ")
    (which-text-to-xref . "Add reference to text: ")
    (which-text-to-xref-err . "Text not found. Add reference to text: ")
    (which-pers-to-xref . "Add reference to user: ")
    (which-conf-to-xref . "Add reference to conference: ")

    ;; Aux-item stuff from edit-text

    (no-comments-q . "The author doesn't want comments. Comment anyway? ")
    (private-answer-q . "The author wants private replies. Write private reply? ")

    (your-invited . "You have been invited to %#1M by %#2P.
By accepting the invitation you will continue to be a member of %#1M.
If you decline the invitation you will not be a member of the conference.
")
    (accept-invitation . "Do you want to accept the invitation now? ")
    (enter-passive . "You are a passive member of %#1M.
You must become an active member of the conference to enter it.\n")
    (convert-passive . "Do you want to become an active member of %#1M? ")
    (bug-secret-mship . "You are a secret member of %#1M\n")

    (invitation-mt-type . "invited")
    (passive-mt-type . "passive")
    (secret-mt-type . "secret")
    (message-flag-off-mt-type . "no group messages")
    (message-flag-on-mt-type . "group messages")

    (Invitation-mt-type . "Invited")
    (Passive-mt-type . "Passive")
    (Secret-mt-type . "Secret")
    (Message-flag-mt-type . "Group messages")

    (not-author . "You are not the author of text %#1n.")
    (not-author-try-anyway-p . "You are not the author of the text. Try anyway? ")
    (what-no-comments-no . "Which text do you want to prevent comments to: ")
    (adding-no-comments . "Preventing comments to text %#1n...")
    (already-no-comments . "Text %#1n already prevents comments.\n")

    (what-private-answer-no . "Which text do you want private replies to: ")
    (adding-private-answer . "Requesting only private replies to text %#1n...")
    (already-private-answer . "Text %#1n already has a request for private replies only.\n")

    (what-request-confirm-no . "Which text do you want read confirmations for: ")
    (adding-request-confirm . "Requesting read confirmations for text %#1n...")
    (already-request-confirm . "Text %#1n already has a request for read confirmations.\n")

    (review-mail-headers-to-what . "Which text's mail headers do you want to see? ")
    (no-mail-headers . "Text %#1n has no mail headers\n")
    (mail-headers-for . "Mail headers for text %#1n:\n")
    (email-name-prefix . "")
    (email-name-suffix . "")

    (you-are-anonymous . "You are now somewhat anonymous.\n")
    (you-are-nonanonymous . "You are no longer anonymous.\n")
    (you-are-already-anonymous . "You are already somewhat anonymous.\n")
    (you-are-already-nonanonymous . "You are already non-anonymous.\n")

    (start-keep-alive . "Sending data at %#1d second intervals to keep the connection active.")
    (stop-keep-alive . "No longer keeping connection active by sending extra data.")

    (review-converted-q . "Review which text converted?")
    (review-noconversion-q . "Review which text unconverted?")
    (review-rot13-q . "Review which text in rot13?")
    (unread-commented-q . "Mark the commented for which text as unread?")
    (review-commented-q . "Review the commented for which text?")

    (review-tree-q . "Review all comments recursively for which text?")
    (find-root-q . "Review original text for text?")
    (find-root-review-q . "Review tree of which text?")
    (review-comments-q . "Review all comments to which text?")
    (review-xrefs-q . "Review all cross references from which text?")
    (unread-tree-q . "Unread all comments recursively for which text?")
    (unread-root-q . "Unread original text for text?")
    (unread-root-review-q . "Unread tree of which text?")
    (unread-comments-q . "Unread all comments to which text?")

    (confusion-who-to-reply-to . "I can't figure out which text you want to write a private reply to.\n")
    (confusion-what-to-answer-to . "I can't figure out which text you want to write a reply to.\n")
    (confusion-what-to-view . "I can't figure out which text you want to view.\n")

    (confusion-what-to-reply-to . "I can't figure out which text you want to write a remark to.\n")
    (confusion-what-to-agree-to . "I can't figure out which text you want to agree with.\n")
    (confusion-what-to-request-confirmation . "I can't figure out which text you want read confirmations for.\n")
    (confusion-what-to-comment . "I can't figure out which text you want to comment.\n")
    (confusion-what-to-footnote . "I can't figure out to which text you want to write a footnote to.\n")

    (confusion-what-to-delete . "I can't figure out which text you want to delete.\n")
    (confusion-what-to-add-sub-recipient . "I can't figure out which text you want to %#1s.\n")
    (add-rcpt-action-name . "add a recipient to")
    (add-copy-action-name . "add a carbon copy recipient to")
    (add-bcc-action-name . "add a blind carbon copy recipient to")
    (sub-action-name . "remove a recipient from")
    (move-action-name . "move")

    (confusion-what-to-add-comment-to . "I can't figure out which text you want to add a comment to.\n")
    (confusion-what-to-sub-comment-from . "I can't figure out which text you want to remove a comment from.\n")
    (confusion-what-to-add-footnote-to . "I can't figure out which text you want to add a footnote to.\n")
    (confusion-what-to-sub-footnote-from . "I can't figure out which text you want to remove a footnote from.\n")
    
    (confusion-what-to-mark . "I can't figure out which text you want to mark.\n")
    (confusion-what-to-unmark . "I can't figure out which text you want to unmark.\n")
    (confusion-what-to-save . "I can't figure out which text you want to save.\n")

    (confusion-what-to-review-mail-headers . "I can't figure out which text's mail headers you want to see.\n")
    (confusion-what-to-unread-root . "I can't figure out which text's root you want to mark as unread.\n")
    (confusion-what-to-unread-root-review . "I can't figure out which tree you want to mark as unread.\n")
    (confusion-what-to-find-root . "I can't figure out which text's root you want to see.\n")
    (could-not-find-root . "Unable to identify the root text. The comment structure may be cyclic.\n")
    (confusion-what-to-find-root-review . "I can't figure out which tree you want to review.\n")

    ;; Help stuff

    (help-with-what . "What do you want help with? ")
    (help-for . "Help for \"%#1s\"\n")

    ;; Button actions

    (lyskom-button-view-text-action . "View text")
    (lyskom-button-unread-text-action . "Unread text")
    (lyskom-button-copy-text-no-action . "Copy text number")
    (lyskom-button-review-converted-action . "Review converted")
    (lyskom-button-review-noconversion-action . "Review unconverted")
    (lyskom-button-review-rot13-action . "Review rot13")
    (lyskom-button-find-root-review-action . "Review tree")
    (lyskom-button-find-root-action . "Review root text")
    (lyskom-button-comment-text-action . "Write comment")
    (lyskom-button-private-comment-text-action . "Write personal reply")
    (lyskom-button-mark-text-action . "Mark text")
    (lyskom-button-unmark-text-action . "Unmark text")
    (lyskom-button-save-text-action . "Save archive copy")
    (lyskom-button-save-text-body-action . "Save text body")
    (lyskom-button-review-comments-action . "Review all comments")
    (lyskom-button-review-tree-action . "Review all comments recursively")
    (lyskom-button-write-footnote-action . "Write footnote")
    (lyskom-button-fast-reply-action . "Remark")
    (lyskom-button-view-conf-presentation-action . "View presentation")
    (lyskom-button-view-conf-status-action . "View conference status")
    (lyskom-button-goto-conf-action . "Go to conference")
    (lyskom-button-send-message-action . "Send group message")
    (lyskom-button-add-self-action . "Join conference")
    (lyskom-button-sub-self-action . "Leave conference")
    (lyskom-button-view-pers-presentation-action . "View presentation")
    (lyskom-button-view-pers-status-action . "View user status")
    (lyskom-button-view-session-status-action . "View session status")
    (lyskom-button-mail-action . "Send letter")
    (lyskom-button-send-message-action . "Send personal message")
    (lyskom-button-open-url-action . "Open")
    (lyskom-button-copy-url-action . "Copy")
    (lyskom-button-goto-info-node-action . "Open")
    (lyskom-button-open-email-action . "Send mail")
    (lyskom-button-copy-email-action . "Copy")
    (lyskom-button-info-aux-action . "Information")
    (lyskom-button-delete-aux-action . "Delete")
    (lyskom-button-copy-timestamp-action . "Copy")
    (lyskom-button-recpt-type-recipient . "Recipient")
    (lyskom-button-recpt-type-copy . "Carbon copy")
    (lyskom-button-recpt-type-bcc . "Blind Carbon copy")
    (lyskom-button-recpt-type-sub . "Remove")
    (lyskom-button-recpt-add-recipient . "Recipient")
    (lyskom-button-recpt-add-copy . "Carbon copy recipient")
    (lyskom-button-recpt-add-bcc . "Blind carbon copy recipient")
    (lyskom-button-aux-type-xref . "Reference to conference/person/text")
    (lyskom-button-aux-type-no-comments . "Request no comments")
    (lyskom-button-aux-type-personal-comments . "Request personal reply")

    (lyskom-edit-toggle-secret-aux-action . "Toggle \"secret\"")
    (lyskom-edit-toggle-anonymous-aux-action . "Toggle \"anonymous\"")
    (lyskom-edit-toggle-inherit-aux-action . "Toggle \"inherited\"")
    (lyskom-edit-delete-aux-action . "Delete")
    (lyskom-prioritize-flag-toggle-action . "Toggle")
    (lyskom-prioritize-flag-set-action . "Set")
    (lyskom-prioritize-flag-clear-action . "Clear")

    (server-status-header   . "Status for LysKOM-server %#1s%#2?b%[ (%#2s:%#3d)%]%[%]\n\n")
    (server-status-server   . "Canonical server name:                   %#1s%#2?b%[:%#2s%]%[%]\n")
    (server-status-version  . "Software version:                        %#1s %#2s\n")
    (server-status-protocol . "Protocol version:          %15#1d\n")
    (server-status-sessions . "\
Number of sessions:  %21#1d (total)
                     %21#2d active in the last %#7d minutes
                     %21#3d inactive sessions
                     %21#4d unknown activity
                     %21#5d invisible sessions
                     %21#6d not logged on/secret/zombies\n")
    (server-status-first-text . "Oldest existing text:       %14#1n\n")
    (server-status-last-text  . "Youngest existing text:     %14#1n%#2?b%[ (%#2n at start)%]%[%]\n")
    (server-status-texts .      "Number of texts:            %14#1d (%#2s now, %#3d at start)\n")
    (server-status-confs .      "Number of conferences:      %14#1d (%#2s now, %#3d at start)\n")
    (server-status-pers .       "Number of persons:          %14#1d (%#2s now, %#3d at start)\n")
    (server-status-has-motd . "\nThe server has a notice:\n")
    (server-status-time .      "Current server time:            %#1s\n")
    (server-status-boot-time . "Server start time:              %#1s\n")
    (server-status-save-time . "Initial database save time:     %#1s%#2?b%[ (%#2s)%]%[%]\n")

    (mship-type-invitation-q . "Membership invitation? ")
    (mship-type-passive-q . "Passive membership? ")
    (mship-type-secret-q . "Secret membership? ")
    (recommend-which-conf . "Which conference do you want to recommend? ")
    (recommend-set-priority-q . "Recommend a priority? ")
    (recommend-set-mship-type-q . "Recommend a membership type? ")
    (recommending-conf . "Recommending %#1M%#2?b%[ (priority %#2d)%]%[%]%#3?b%[ %#3s%]%[%]...")
    (has-recommended-conf . "%#1P has recommended conference %#2M. Do you want to become a member?\n")
    (accept-recommendation . "Join conference %#1M? ")
    (accepting-recommendation . "Joining recommended conference %#2M...")

    (redirect-for-whom . "Redirect comments for whom: ")
    (redirect-to-which-conf . "Redirect comments to: ")
    (redirecting-comments-to . "Redirecting comments for %#1P to %#2M%#3?b%[ (old %#1M)%]%[%]...")

    (kom-redirect-comments-e49 . "You do not have permission to perform this redirection")
    (kom-redirect-comments-e48 . "Comment redirection is not supported by the server")

    (external-program-missing . "Can't find the external program \"%#1s\" that is required for this command.")
    (ignored-user-area-var . "\

Ignoring the following variables in your settings:

    %#1s

These variables are not registered as LysKOM variables and cannot be
read from the server. You can remove the variables from the server by
giving the command \"Save options\".

%#2?b%[%#5F\
Unknown variables may be the result of saving your settings in version
 %#3s of the client; this is version %#4s.

%]%[%]")


    (unknown-aux-item . "Unknown property")
    (text-header-aux-item . "%#1s: <%#2d> \"%#3s\" %#4s")

    (aux-content-type-name . "Content type")
    (aux-fast-reply-name . "Remark")
    (aux-cross-reference-name . "Reference")
    (aux-no-comments-name . "Request for no comments")
    (aux-personal-comment-name . "Request for personal replies")
    (aux-request-confirmation-name . "Request for read confirmation")
    (aux-read-confirm-name . "Read confirmation")
    (aux-redirect-name . "Redirect")
    (aux-x-face-name . "Picture")
    (aux-alternate-name-name . "Alternate name")
    (aux-pgp-signature-name . "PGP signature")
    (aux-pgp-public-key-name . "PGP public key")
    (aux-e-mail-address-name . "E-mail address")
    (aux-faq-text-name . "FAQ in text")
    (aux-creating-software-name . "Creating software")
    (aux-mx-author-name . "E-mail author")
    (aux-mx-from-name . "E-mail from")
    (aux-mx-reply-to-name . "E-mail reply to")
    (aux-mx-to-name . "E-mail to")
    (aux-mx-cc-name . "E-mail CC")
    (aux-mx-date-name . "E-mail date")
    (aux-mx-message-id-name . "E-mail message ID")
    (aux-mx-in-reply-to-name . "E-mail in reply to")
    (aux-mx-misc-name . "E-mail headers")
    (aux-mx-allow-filter-name . "E-mail allow-filter")
    (aux-mx-reject-forward-name . "E-mail reject-forward")
    (aux-notify-comments-name . "Notify me about comments")
    (aux-faq-for-conf-name . "FAQ for conference")
    (aux-recommended-conf-name . "Conference recommendation")
    (aux-allowed-content-type-name . "Allowed content type")
    (aux-canonical-name-name . "Canonical name")
    (aux-mx-list-name-name . "Mailing list name")
    (aux-send-comments-to-name . "Send comments to")
    (aux-world-readable-name . "World-readable")
    (aux-mx-refuse-import . "Refuse text import")
    (aux-elisp-client-read-faq-name . "Read FAQ")
    (aux-elisp-client-rejected-invitation-name . "Rejected invitation")

    (review-marking-as-read . "Review marks as read")
    (review-not-marking-as-read . "Review does not mark as read")

    (review-using-cache . "Review uses cache")
    (review-not-using-cache . "Review doesn't use cache")

    (using-ssh-connection . "Using ssh connection to %#1s...")
    (opening-ssh-connection . "Opening ssh connection to %#1s...")
    (ssh-cant-connect . "Unable to open ssh connection: %s")
    (ssh-closing . "Closing ssh connection to %#1s")
    (ssh-unknown-host . "unknown host")

    (keyboard-cancel . "Cancel")
    (keyboard-menu-help . "(choose: C-n, C-p; confirm: RET)")
    (customize-help . "See the beginning of the buffer for more information")

    (no-mule-warning . "\

%#1@You have disabled support for multibyte characters (MULE) in emacs.
This may be due to a call to standard-display-european in your .emacs
or in one of the shared emacs startup files.

This software is designed to run with support for multibyte characters
enabled. Without this support texts may be displayed incorrectly, and
you may encounter problems writing texts. Consider enabling sypport
for multibyte characters in emacs.

")
    (coding-system-mismatch-warning . "\

%#3@Your emacs is configured to encode characters using \"%#1s\",
but the LysKOM server you are using recommends \"%#2s\".

You may encounter problems when writing comments, and comments to your
texts may contain a mix of characters that cannot be encoded or
displayed correctly. Please consider changing your language
environment to one that uses \"%#2s\" to encode text.

")


    (has-nameday-1 . "Today's name is %#1s%#2?b%[ (%#2s)%]%[%].")
    (has-nameday-2 . "Today's names are %#1s and %#2s%#3?b%[ (%#3s)%]%[%].")
    (no-nameday . "No nameday today%#2?b%[ (%#2s)%]%[%]")

    (invalid-date-entry . "Invalid date")
    (number-out-of-range . "Invalid number")
    (or-date . "or date")

    (set-unread-n . "Only read the most recent %#1?d%[text%]%[%#1d texts%].\n")
    (set-unread-date . "Only read texts since %#2s %#3d, %#1d.\n")

    (jump-from-text . "Skip comments to which text? ")
    (jumping-from-text . "Skipping comments to text %#1n.\n")
    (jumping-from-text-review . "Skipping reviewed comments.\n")

    (session-to-copy-options-from . "Session to copy options from: ")
    (reading-settings-from . "Reeading options from %s...")
    (reading-settings-from-done . "Reading options from %s...done")

    (super-jump-q . "Super jump which text? ")
    (conf-list-legend . "* Not member; - Passive member\n")

    (unread-text-q . "Make which text unread? ")
    (marking-text-unread . "Marking text %#1n as unread...")
    (cant-mark-text-unread . "Couldn't mark %#1n as unread (%#2s)\n")
    (confusion-what-to-mark-unread . "I can't figure out what text you want to mark as unread.\n")
    (no-comment-to-to-unread . "There is no commented text to mark as unread.\n")

    (mx-refuse-import-html . "HTML")
    (mx-refuse-import-spam . "Spam")
    (mx-refuse-import-all . "All texts")
    (abc-html . "hHTML")
    (abc-spam . "sSpam")
    (abc-everything . "aAll texts")
    (limit-import-to-conf . "Limit import to which conference? ")
    (limit-import-of-what . "Limit import of what? ")
    (limit-import-not-super . "You do not seem to be the supervisor of the conference. Try anyway? ")
    (limiting-import . "Limiting import of  %#1s to %#2M...")

    (set-message-flag-for-conf . "Sett message flag for which conference? ")
    (set-message-flag-to-what . "Receive grupp messages to %#1M? ")
    (setting-message-flag . "%#1?b%[Enabling%]%[Disabling%] reception of group messages to %#2M...")

    (text-has-no-comments . "Text %#1n has no comments\n")
    (text-has-no-footnotes . "Text %#1n has no footnotes\n")
    (set-message-flag-q . "Accept group messages to %#1M? ")

    (why-you-got-no-presentation . "\

%#1@\
========================================================================
You do not have a presentation%#2?z%[ but you've written %#2d texts%]%[%]

Use the command \"Change presentation\" to write or change your 
presentation.


%[%#4F\
Your presentations serves to give other users of %#3s some information
about who you are, and this contributes to the sense of community in
%#3s. This message will be repeated at random intervals until you have
written a presentation.%]
========================================================================

")

    (status-server-stats . "Server statistics:\n\n")
    (current-average . "current")

    (unit-second . "second")
    (unit-minute . "minute")
    (unit-hour . "hour")
    (unit-day . "day")
    (unit-mongth . "month")
    (unit-year . "year")

    (db-status-backup . "information loss may have occurred")
    (no-support-in-server . "No support in server for this command.\n")
    (mark-confs-as-known . "Mark these %#2d %#1s as known? ")
    (no-new-conferences . "No new %#2s%#1?b%[ since %#1s%]%[%].\n")
    (new-conferences-since . "New %#2s%#1?b%[ since %#1s%]%[%]:\n")
    (list-confs-from-date . "List %#1s created since what date (empty for everything)? ")

    (privs-wheel . "wheel")
    (privs-admin . "administrator")
    (privs-statistic . "statistics")
    (privs-create-conf . "create conferences")
    (privs-create-pers . "create persons")
    (privs-change-name . "change names")
    (privs-flg7 . "unknown (7)")
    (privs-flg8 . "unknown (8)")
    (privs-flg9 . "unknown (9)")
    (privs-flg10 . "unknown (10)")
    (privs-flg11 . "unknown (11)")
    (privs-flg12 . "unknown (12)")
    (privs-flg13 . "unknown (13)")
    (privs-flg14 . "unknown (14)")
    (privs-flg15 . "unknown (15)")
    (privs-flg16 . "unknown (16)")
    (lyskom-no-privileges . "no permissions")

    (what-pers-privs-to-change . "Whose privileges do you want to change? ")
    (change-pers-privs-prompt . "\
Current privileges for %#1P (%#1p):
    %#2s
Change privileges for %#1P (%#1p)...")

    (set-wheel-priv-q . "Activate wheel privileges? ")
    (set-admin-priv-q . "Activate administrator privileges? ")
    (set-statistic-priv-q . "Activate statistics privileges? ")
    (set-create-conf-priv-q . "Activate right to create conferences? ")
    (set-create-pers-priv-q . "Activate right to create persons? ")
    (set-change-name-priv-q . "Activate right to change names? ")
    (set-flg7-priv-q . "Activate unknown privilege 7? ")
    (set-flg8-priv-q . "Activate unknown privilege 8? ")
    (set-flg9-priv-q . "Activate unknown privilege 9? ")
    (set-flg10-priv-q . "Activate unknown privilege 10? ")
    (set-flg11-priv-q . "Activate unknown privilege 11? ")
    (set-flg12-priv-q . "Activate unknown privilege 12? ")
    (set-flg13-priv-q . "Activate unknown privilege 13? ")
    (set-flg14-priv-q . "Activate unknown privilege 14? ")
    (set-flg15-priv-q . "Activate unknown privilege 15? ")
    (set-flg16-priv-q . "Activate unknown privilege 16? ")

    (canceling-command . "Canceling command...")

    ;; From mship-edit.el

    (no-selection . "No selection")
    (selection . "%#1d selected")
    (lp-no-hidden . "")
    (lp-hidden . "(%#1d hidden)")
    (priority-prompt . "New priority for %#1M: ")
    (priority-prompt-marked . "New priority for selected conferences: ")
    (lp-no-creation-info . "No information on when the membership was created")
    (lp-invited . "Invited")
    (lp-added . "Added")
    (lp-nope . "Operation failed: %#1s")
    (lp-no-entry . "No membership on this line")
    (lp-no-active-filter . "(no filters active)")
    (lp-active-filters . "Active filters: %#1s")
    (lp-mark-mship-with-prio . "Select memberships with priority: ")
    (lp-unmark-mship-with-prio . "Deselect memberships with priority: ")
    (lp-no-selection . "No memberships selected")
    (lp-at-min-prio . "Already at minimum priority")
    (lp-at-max-prio . "Already at maximum priority")
    (lp-beginning-of-list . "Beginning of list")
    (lp-end-of-list . "End of list")
    (lp-goto-priority . "Go to priority: ")
    (lp-mode-name . "Membership")
    (lp-header-main . "Membership for %#1M on %#2s")
    (lp-list-header . " Prio   %#1s  Last entered Unread IHPM\n")
    (lp-help-footer . "
 Select membership:  SPC      Select region:  C-w      Flytta markerade:   C-y
 Set priority:       p        Increase prio:  +        Decrease prio:      -
 Move up:            M-p      Move down:      M-n      Toggle flags:   I,H,P,M
 Postpone reading:   P        Only last:      o   
 Quit:               C-c C-c                           More help:        C-h m
")
    (lp-hide-read-after . "Hide memberships read after: ")
    (lp-hide-read-since . "Hide memberships not read since: ")
    (lp-skipping-missing-meeting . "Conference %#1M no longer exists, skipping.")
    ))


(lyskom-language-var local lyskom-month-names en
  '(("january" . 1)   ("jan" . 1)
    ("february" . 2)  ("feb" . 2)
    ("march" . 3)     ("mar" . 3)
    ("april" . 4)     ("apr" . 4)
    ("may" . 5)       ("may" . 5)
    ("june" . 6)      ("jun" . 6)
    ("july" . 7)      ("jul" . 7)
    ("august" . 8)    ("aug" . 8)
    ("september" . 9) ("sep" . 9)
    ("october" . 10)  ("oct" . 10)
    ("november" . 11) ("nov" . 11)
    ("december" . 12) ("dec" . 12)))


;;; ================================================================
;;;              The commands and their associated functions


;;; Formely known as lyskom-commands
(lyskom-language-strings local lyskom-command en
  '(
    (kom-help                 . "Help")
    (kom-slow-mode            . "Long commands")
    (kom-quick-mode           . "Short commands")
    (kom-send-message         . "Send message")
    (kom-send-alarm           . "Send alarm")
    (kom-create-conf          . "Create conference")
    (kom-delete-conf          . "Delete conference/user")
    (kom-delete-text          . "Remove text")
    (kom-display-time         . "Time")
    (kom-go-to-conf           . "Go (to) conference")
    (kom-go-to-next-conf      . "(Go to) next conference")
    (kom-jump                 . "Skip (all) comments")
    (kom-list-created-conferences     . "List owned conferences") 
    (kom-list-conferences     . "List conferences") 
    (kom-list-persons         . "List users")
    (kom-list-news            . "List news")
    (kom-list-sessions        . "List sessions")
    (kom-list-re              . "List (using) regexps")
    (kom-membership           . "List memberships")
    ;; (kom-list-marks	      . "List marks")
    (kom-postpone             . "Postpone reading")
    (kom-set-session-priority . "Set reading level")
    (kom-prioritize           . "Prioritize conferences")
    (kom-status-person        . "Status (of) person")
    (kom-status-conf          . "Status (of) conference")
    (kom-add-self             . "Join conference")
    (kom-change-priority      . "Change priority")
    (kom-list-summary         . "List text (subjects)")
    (kom-sub-self             . "Leave (a) conference")
    (kom-quit                 . "Quit")
    (kom-recover              . "Recover") 
    (kom-start-anew           . "New User")
    (kom-view                 . "Review text")
    (kom-find-root-review     . "Review tree")
    (kom-review-comments      . "Review all comments")
    (kom-review-tree          . "Review all comments recursively")
    (kom-review-clear         . "Review and skip")
    (kom-review-last-normally-read
     			      . "Review again")
    (kom-review-cross-references
     			      . "Review all cross references")
    (kom-review-converted     . "Review converted")
    (kom-review-noconversion  . "Review unconverted")
    (kom-review-rot13         . "Review rot13")
    (kom-review-next          . "Review next")
    (kom-find-root            . "Review original (text)")
    (kom-review-by-to         . "Review last")
    (kom-review-first         . "Review first")
    (kom-review-all           . "Review all")
    (kom-review-more          . "Review more")
    (kom-view-commented-text  . "Review (the) commented (text)")
    (kom-view-previous-commented-text
     			      . "Review (the) previously commented (text)")
    (kom-review-stack         . "Review stack")
    (kom-review-presentation  . "Review presentation")
    (kom-review-backward      . "(Review) Backwards")
    (kom-view-next-text       . "(Read) next text")
    (kom-who-is-on            . "Who (is on)")
    (kom-who-is-on-in-conference
                              . "Who (is on in) conference")
    (kom-who-is-present-in-conference
                              . "Who (is) present (in) conference")
    (kom-who-is-on-and-friend . "Which friends (are on)")
    (kom-who-am-i             . "Where (am) i")
    (kom-list-clients	      . "List clients")
    (kom-busy-wait            . "Wait (for news)")
    (kom-write-comment        . "(Write) comment")
    (kom-comment-previous     . "(Write) comment (to) previous text")
    (kom-write-footnote       . "(Write) footnote")
    (kom-private-answer       . "(Write) personal reply (by letter)")
    (kom-private-answer-previous
   . "(Write) personal (reply to) previous text (by letter)")
    (kom-set-unread     	      . "Only (the) last")
    (kom-write-text           . "Write (a) text")
    (kom-send-letter          . "Write (a) letter")
    (kom-change-name          . "Change name")
    (kom-change-parenthesis   . "Change parenthesis")
    (kom-change-password      . "Change password")
    (kom-change-supervisor    . "Change supervisor")
    (kom-change-presentation  . "Change presentation")
    (kom-get-appreciation     . "(Please) pat my head")
    (kom-get-abuse            . "(Please) kick my butt")
    (kom-mark-text            . "Mark (text)")
    (kom-unmark-text          . "Unmark (text)")
    (kom-review-marked-texts  . "Review marked (texts)")
    (kom-review-all-marked-texts . "Review all marked (texts)")
    (kom-add-recipient        . "Add recipient")
    (kom-add-copy             . "Add (recipient of) carbon copy")
    (kom-add-bcc	      . "Add (recipient of) blind carbon copy")
    (kom-sub-recipient        . "Remove recipient")
    (kom-move-text            . "Move text")
    (kom-move-text-tree       . "Move tree")
    (kom-add-comment          . "Add comment")
    (kom-sub-comment          . "Remove comment")
    (kom-add-cross-reference  . "Add cross reference")
    (kom-add-member           . "Add (a) member")
    (kom-sub-member           . "Remove (a) member")
    (kom-change-conf-motd     . "(Post) notice (on the) conference")
    (kom-set-garb-nice        . "Change expiration")
    (kom-set-super-conf       . "Change superconference")
    (kom-set-permitted-submitters . "Change allowed authors")
    (kom-unset-conf-motd      . "Remove notice")
    (kom-save-text            . "Archive (copy of) text (in file)")
    (kom-save-text-body       . "Save text body (in file)")
    (kom-save-options         . "Save options")
    (kom-shutdown-server      . "Shut down (server)")
    (kom-sync-database        . "Save (the) database")
    (kom-enable-adm-caps      . "Become administrator")
    (kom-disable-adm-caps     . "Become (normal) user")
    (kom-set-motd             . "Change login message")
    (kom-remove-motd          . "Remove login message")
    (kom-force-logout         . "Kill session")
    (kom-filter-author        . "Filter author")
    (kom-filter-subject       . "Filter subject")
    (kom-filter-recipient     . "Filter recipient")
    (kom-super-jump           . "Super jump")
    (kom-filter-edit          . "Edit filters")
    (kom-filter-text          . "Filter contents")
    (kom-list-filters         . "List filters")
    (kom-show-user-area       . "Show user area")
    (kom-change-conf-type     . "Change conference type")

    (kom-change-auto-reply    . "Change ansaphone message")
    (kom-toggle-auto-reply    . "Ansaphone")
    (kom-list-messages        . "List messages")
    (kom-erase-messages       . "Erase messages")

    (kom-remote-autoreply     . "Remote control ansaphone")
    (kom-remote-set-message   . "Remote control change ansaphone message")
    (kom-remote-list-messages . "Remote control list messages")
    (kom-remote-erase-messages . "Remote control erase messages")
    (kom-remote-quit          . "Remote control quit")

    (kom-status-session       . "Status (of) session")
    (kom-customize            . "Customize LysKOM")
    (kom-next-kom             . "Next LysKOM")
    (kom-previous-kom         . "Previous LysKOM")
    (kom-next-unread-kom      . "Next unread LysKOM")
    (kom-change-language      . "Change language")
    (kom-calculate            . "Calculate")
    (kom-list-marks           . "List marked texts")
    (kom-where-is             . "Where (is the) command")
    (kom-fast-reply           . "Remark (to text)")
    (kom-agree                . "Agree")
    (kom-add-faq              . "Add FAQ")
    (kom-del-faq              . "Remove FAQ")
    (kom-review-faq           . "View FAQ")

    (kom-sub-footnote         . "Remove footnote")
    (kom-add-footnote         . "Add footnote")

    (kom-add-no-comments      . "Prevent comments")
    (kom-add-private-answer   . "Request private reply")
    (kom-add-request-confirm  . "Request confirmation of reading")

    (kom-review-mail-headers  . "Review mail headers")

    (kom-compare-texts        . "Compare two texts")
    (kom-diff-texts           . "View diff")

    (kom-become-anonymous     . "Become anonymous")
    (kom-become-nonanonymous  . "Become non-anonymous (come forth into the light)")

    (kom-keep-alive           . "Keep connection alive")
    (kom-stop-keep-alive      . "Stop keeping connection alive")

    (kom-is-person-member-of-conference . "Check (if person is a) member (of conference)")
    (kom-will-person-read-text . "Check (if person will) read (text)")

    (kom-change-conf-faq      . "Change FAQ")

    (kom-make-review-mark-as-read . "Review marks as read")
    (kom-make-review-not-mark-as-read . "Review does not mark as read")

    (kom-set-presentation     . "Add presentation")
    (kom-remove-presentation  . "Remove presentation")
    (kom-set-motd-text        . "Add notice")
    (kom-create-aux-item      . "Create propoerty")
    (kom-status-server        . "Status (of) server")
    (kom-add-server-faq       . "Add server FAQ")
    (kom-del-server-faq       . "Remove server FAQ")
    (kom-review-server-faq    . "Review server FAQ")
    (kom-change-server-faq    . "Change server FAQ")
    (kom-recommend-conference . "Recommend conference")
    (kom-redirect-comments    . "Redirect comments")
    (kom-copy-options         . "Copy options")
    (kom-mark-unread          . "Unread text")
    (kom-unread-by-to         . "Unread last")
    (kom-unread-more          . "Unread more")
    (kom-unread-commented-text . "Unread (the) commented (text)")
    (kom-unread-previous-commented-text . "Unread (the) previously commented (text)")
    (kom-unread-comments      . "Unread all comments")
    (kom-unread-tree          . "Unread all comments recursively")
    (kom-unread-root          . "Unread original (text)")
    (kom-unread-root-review   . "Unread tree")
    (kom-unread-last-normally-read
     			      . "Unread again")
    (kom-unread-first         . "Unread first")
    (kom-unread-all           . "Unread all")

    (kom-unread-presentation  . "Unread presentation")
    (kom-unread-server-faq    . "Unread server FAQ")
    (kom-unread-faq           . "Unread FAQ")
    (kom-unread-marked-texts  . "Unread marked (texts)")
    (kom-unread-all-marked-texts . "Unread all markeed (texts)")

    (kom-join-all-conferences . "Join all conferences")
    (kom-leave-all-conferences . "Leave (almost) all conferences")
    (kom-limit-import         . "Limit imported texts")
    (kom-change-message-flag  . "Change reception (of) group messages")
    (kom-list-faqs            . "List FAQs")
    (kom-list-server-faqs     . "List server-FAQs")
    (kom-list-new-conferences . "List new conferences")
    (kom-list-new-persons     . "List new users")
    (kom-change-privileges    . "Change privileges")
    ))

(lyskom-language-var global lyskom-language-codes en
  '((aa . "Afar")
    (ab . "Abkhazian")
    (af . "Afrikaans")
    (am . "Amharic")
    (ar . "Arabic")
    (as . "Assamese")
    (ay . "Aymara")
    (az . "Azerbaijani")
    (ba . "Bashkir")
    (be . "Byelorussian")
    (bg . "Bulgarian")
    (bh . "Bihari")
    (bi . "Bislama")
    (bn . "Bengali")
    (bo . "Tibetan")
    (br . "Breton")
    (ca . "Catalan")
    (co . "Corsican")
    (cs . "Czech")
    (cy . "Welsh")
    (da . "Danish")
    (de . "German")
    (dz . "Bhutani")
    (el . "Greek")
    (en . "English")
    (eo . "Esperanto")
    (es . "Spanish")
    (et . "Estonian")
    (eu . "Basque")
    (fa . "Persian")
    (fi . "Finnish")
    (fj . "Fiji")
    (fo . "Faroese")
    (fr . "French")
    (fy . "Frisian")
    (ga . "Irish")
    (gd . "Scots Gaelic")
    (gl . "Galician")
    (gn . "Guarani")
    (gu . "Gujarati")
    (ha . "Hausa")
    (he . "Hebrew")
    (hi . "Hindi")
    (hr . "Croatian")
    (hu . "Hungarian")
    (hy . "Armenian")
    (ia . "Interlingua")
    (id . "Indonesian")
    (ie . "Interlingue")
    (ik . "Inupiak")
    (is . "Icelandic")
    (it . "Italian")
    (iu . "Inuktitut")
    (ja . "Japanese")
    (jw . "Javanese")
    (ka . "Georgian")
    (kk . "Kazakh")
    (kl . "Greenlandic")
    (km . "Cambodian")
    (kn . "Kannada")
    (ko . "Korean")
    (ks . "Kashmiri")
    (ku . "Kurdish")
    (ky . "Kirghiz")
    (la . "Latin")
    (ln . "Lingala")
    (lo . "Laotian")
    (lt . "Lithuanian")
    (lv . "Latvian Lettish")
    (mg . "Malagasy")
    (mi . "Maori")
    (mk . "Macedonian")
    (ml . "Malayalam")
    (mn . "Mongolian")
    (mo . "Moldavian")
    (mr . "Marathi")
    (ms . "Malay")
    (mt . "Maltese")
    (my . "Burmese")
    (na . "Nauru")
    (ne . "Nepali")
    (nl . "Dutch")
    (no . "Norwegian")
    (oc . "Occitan")
    (om . "Oromo")
    (or . "Oriya")
    (pa . "Pundjabi")
    (pl . "Polish")
    (ps . "Pashto")
    (pt . "Portuguese")
    (qu . "Quechua")
    (rm . "Rhaeto-Romance")
    (rn . "Kirundi")
    (ro . "Romanian")
    (ru . "Russian")
    (rw . "Kiyarwanda")
    (sa . "Sanskrit")
    (sd . "Sindhi")
    (sg . "Sangho")
    (sh . "Serbo-Croatian")
    (si . "Singhalese")
    (sk . "Slovak")
    (sl . "Slovenian")
    (sm . "Samoan")
    (sn . "Shona")
    (so . "Somali")
    (sq . "Albanian")
    (sr . "Serbian")
    (ss . "Siswati")
    (st . "Sesotho")
    (su . "Sudanese")
    (sv . "Swedish")
    (sw . "Swahili")
    (ta . "Tamil")
    (te . "Telugu")
    (tg . "Tajik")
    (th . "Thai")
    (ti . "Tigrinya")
    (tk . "Turkmen")
    (tl . "Tagalog")
    (tn . "Setswana")
    (to . "Tonga")
    (tr . "Turkish")
    (ts . "Tsonga")
    (tt . "Tatar")
    (tw . "Twi")
    (ug . "Uigur")
    (uk . "Ukrainian")
    (ur . "Urdu")
    (uz . "Uzbek")
    (vi . "Vietnamese")
    (vo . "Volapk")
    (wo . "Wolof")
    (xh . "Xhosa")
    (yi . "Yiddish")
    (yo . "Yorouba")
    (za . "Zhuang")
    (zh . "Chinese")
    (zu . "Zulu")
    (-- . "Unknown language (%#1s)")))

(lyskom-language-missing-string lyskom-menu kom-help en)
(lyskom-language-missing-string lyskom-menu kom-change-language en)

(lyskom-language-strings global lyskom-menu en
  '((lyskom    . "LysKOM")
    (read      . "Read")
    (dont-read . "Jump")
    (write     . "Write")
    (conference . "Conference")
    (other     . "Other")
    (person    . "User")
    (server    . "Server")
    (marks     . "Marks")
    (filters   . "Filters")
    (move      . "Go")
    (info      . "About")
    (send      . "Send message")
    (review    . "Review")
    (unread    . "Unread")
    (receivers . "Receivers")
    (commented . "Commented")
    (aux-items . "Properties")
    (conf-admin . "Conference admin")
    (server-admin . "Server admin")
    (membership . "Membership")
    (pers-admin . "User admin")
    (autoreply . "Auto-reply")
    (remote-control . "Remote control")
    (language . "Change language")
    (kom-change-global-language . "Display and commands")
    (kom-change-local-language . "Display language only")
    (kom-edit-send . "Send")
    (kom-edit-send-anonymous . "Send anonymously")
    (kom-edit-quit . "Throw away") 
    (kom-ispell-message . "Check spelling")
    (kom-edit-add-recipient . "Add recipient")
    (kom-edit-add-copy . "Add carbon copy")
    (kom-edit-show-commented . "Review commented")
    (kom-edit-insert-commented . "Cite commented")
    (kom-edit-insert-buglist . "Paste commented bug list")
    (kom-edit-add-bcc . "Add blind carbon copy")
    (kom-edit-add-cross-reference . "Add cross reference")
    (kom-edit-add-no-comments . "Request no comments")
    (kom-edit-add-personal-comments . "Request personal replies")
    (kom-edit-add-read-confirm-request . "Request read confirmation")
    (kom-edit-move-text . "Move to new recipient")

    (lp--toggle-membership-selection . "Toggle membership selection")
    (lp--select-region . "Select region")
    (lp--select-priority . "Select priority")
    (lp--deselect-priority . "Deselect priority")
    (lp--deselect-all . "Deselect all")
    (lp--membership-expansion . "Membership expansion")
    (lp--toggle-entry-expansion . "Toggle expansion")
    (lp--expand-entry . "Expand membership")
    (lp--contract-entry . "Contract membership")
    (lp--membership-priority . "Priority")
    (lp--set-priority . "Change priority")
    (lp--move-up . "Move up")
    (lp--move-down . "Move down")
    (lp--increase-priority . "Increase priority")
    (lp--decrease-priority . "Lower priority")
    (lp--yank . "Move selected")
    (lp--filter . "Filter")
    (lp--show-hide-memberships-read-before . "Toggle display of memberships read before...")
    (lp--show-hide-memberships-read-after . "Toggle display of memberships read after...")
    (lp--show-hide-read-memberships . "Toggle display of memberships without unreads")
    (lp--show-hide-passive-memberships . "Toggle display of passive memberships")
    (lp--show-all . "Show all memberships")
    (lp--membership-type . "Membership type")
    (lp--toggle-invitation . "Toggle invitation")
    (lp--toggle-passive . "Toggle passive")
    (lp--toggle-message-flag . "Toggle messages")
    (lp--toggle-secret . "Toggle secret")
    (lp--set-unread . "Only last") 
    (lp--quit . "Quit")
))

(lyskom-language-var local lyskom-onoff-table en
  '(("on" . on) ("off" . off)))

(lyskom-language-var local lyskom-filter-predicate-list en
      '(("=" . nil) ("!=" . t)))

(lyskom-language-var local lyskom-filter-what en
      '((author . "Author")
        (author-no . "Author (number)")
        (author-re . "Author (regexp)")
        (subject . "Subject")
        (subject-re . "Subject (regexp)")
        (recipient . "Recipient")
        (recipient-no . "Recipient (number)")
        (recipient-re . "Recipient (regexp)")
        (text . "Contents")
        (text-re . "Contents (regexp)")))

(lyskom-language-var local lyskom-filter-actions en
      '((skip-text . "Skip")
        (dontshow . "Don't show")
        (read . "Exclude from filter")
        (skip-tree . "Skip comments")
	(obliterate . "Obliterate")))

(defconst lyskom-keybindings-missing nil)

(defvar lyskom-en-mode-map nil)
(lyskom-language-keymap lyskom-mode-map en lyskom-en-mode-map)

(defvar lyskom-en-review-prefix)
(defvar lyskom-en-change-prefix)
(defvar lyskom-en-next-prefix)
(defvar lyskom-en-list-prefix)
(defvar lyskom-en-filter-get-prefix)
(defvar lyskom-en-S-prefix)
(defvar lyskom-en-who-prefix)
(defvar lyskom-en-A-prefix)
(defvar lyskom-en-B-prefix)
(defvar lyskom-en-unread-prefix)

(if lyskom-en-mode-map
    nil
  (setq lyskom-en-mode-map (make-keymap))
  (suppress-keymap lyskom-en-mode-map)
  (define-prefix-command 'lyskom-en-review-prefix)
  (define-prefix-command 'lyskom-en-change-prefix)
  (define-prefix-command 'lyskom-en-next-prefix)
  (define-prefix-command 'lyskom-en-list-prefix)
  (define-prefix-command 'lyskom-en-filter-get-prefix)
  (define-prefix-command 'lyskom-en-S-prefix)
  (define-prefix-command 'lyskom-en-who-prefix)
  (define-prefix-command 'lyskom-en-A-prefix)
  (define-prefix-command 'lyskom-en-B-prefix)
  (define-prefix-command 'lyskom-en-unread-prefix)

  (define-key lyskom-en-mode-map (kbd "h") 'lyskom-en-change-prefix)
  (define-key lyskom-en-mode-map (kbd "r") 'lyskom-en-review-prefix)
  (define-key lyskom-en-mode-map (kbd "f") 'lyskom-en-filter-get-prefix)
  (define-key lyskom-en-mode-map (kbd "n") 'lyskom-en-next-prefix)
  (define-key lyskom-en-mode-map (kbd "l") 'lyskom-en-list-prefix)
  (define-key lyskom-en-mode-map (kbd "s") 'lyskom-en-S-prefix)
  (define-key lyskom-en-mode-map (kbd "w") 'lyskom-en-who-prefix)
  (define-key lyskom-en-mode-map (kbd "a") 'lyskom-en-A-prefix)
  (define-key lyskom-en-mode-map (kbd "b") 'lyskom-en-B-prefix)
  (define-key lyskom-en-mode-map (kbd "u") 'lyskom-en-unread-prefix)

  (define-key lyskom-en-mode-map (kbd "M-m") 'kom-toggle-mark-as-read-prefix)
  (define-key lyskom-en-mode-map (kbd "M-c") 'kom-toggle-cache-prefix)

  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button2)) 'kom-button-click)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-mode-map (kbd "*") 'kom-button-press)
  (define-key lyskom-en-mode-map (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-en-mode-map (kbd "TAB") 'kom-next-link)
  (define-key lyskom-en-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-en-mode-map (kbd "<S-tab>") 'kom-previous-link)

  ;; These should be first in order to be last in the menu of alternatives.
  (define-key lyskom-en-review-prefix     (kbd "?") 'lyskom-help)
  (define-key lyskom-en-unread-prefix     (kbd "?") 'lyskom-help)
  (define-key lyskom-en-change-prefix     (kbd "?") 'lyskom-help)
  (define-key lyskom-en-next-prefix       (kbd "?") 'lyskom-help)
  (define-key lyskom-en-list-prefix       (kbd "?") 'lyskom-help)
  (define-key lyskom-en-filter-get-prefix (kbd "?") 'lyskom-help)
  (define-key lyskom-en-S-prefix          (kbd "?") 'lyskom-help)
  (define-key lyskom-en-who-prefix        (kbd "?") 'lyskom-help)
  (define-key lyskom-en-A-prefix          (kbd "?") 'lyskom-help)
  
  (define-key lyskom-en-mode-map (kbd "o")     'kom-set-unread)
  (define-key lyskom-en-mode-map (kbd "x")     'kom-extended-command)
  (define-key lyskom-en-mode-map (kbd "<SPC>") 'kom-next-command)
  (define-key lyskom-en-mode-map (kbd "<LFD>")  'kom-page-next-command)
  (define-key lyskom-en-mode-map (kbd "<RET>")  'kom-line-next-command)

  (define-key lyskom-en-mode-map (kbd "?")  'kom-help)
  (define-key lyskom-en-mode-map (kbd "e")  'kom-send-letter)
  (define-key lyskom-en-mode-map (kbd "g")  'kom-go-to-conf)
  (define-key lyskom-en-mode-map (kbd "t")  'kom-write-text)
  (define-key lyskom-en-mode-map (kbd "c")  'kom-write-comment)
  (define-key lyskom-en-mode-map (kbd "C")  'kom-comment-previous)
  (define-key lyskom-en-mode-map (kbd "F")  'kom-write-footnote)
  (define-key lyskom-en-mode-map (kbd "p")  'kom-private-answer)
  (define-key lyskom-en-mode-map (kbd "P")  'kom-private-answer-previous)
  (define-key lyskom-en-mode-map (kbd "j")  'kom-jump)
  (define-key lyskom-en-mode-map (kbd "J")  'kom-super-jump)
  (define-key lyskom-en-mode-map (kbd "I")  'kom-who-am-i)
  (define-key lyskom-en-mode-map (kbd "W")  'kom-busy-wait)
  (define-key lyskom-en-mode-map (kbd "m")  'kom-add-self)
  (define-key lyskom-en-mode-map (kbd "M")  'kom-mark-text)
  (define-key lyskom-en-mode-map (kbd "U")  'kom-unmark-text)
  (define-key lyskom-en-mode-map (kbd "q")  'kom-quit)
  (define-key lyskom-en-mode-map (kbd "z")  'kom-bury)
  (define-key lyskom-en-mode-map (kbd "R")  'kom-recover)
  (define-key lyskom-en-mode-map (kbd "T")  'kom-display-time)

  (define-key lyskom-en-list-prefix (kbd "k") 'kom-list-sessions)
  (define-key lyskom-en-list-prefix (kbd "m") 'kom-list-marks)
  (define-key lyskom-en-list-prefix (kbd "c") 'kom-list-conferences)
  (define-key lyskom-en-list-prefix (kbd "n") 'kom-list-news)
  (define-key lyskom-en-list-prefix (kbd "u") 'kom-list-persons)
  (define-key lyskom-en-list-prefix (kbd "r") 'kom-list-re)
  (define-key lyskom-en-list-prefix (kbd "M") 'kom-membership)
  (define-key lyskom-en-list-prefix (kbd "s") 'kom-list-summary)
  (define-key lyskom-en-list-prefix (kbd "f") 'kom-list-filters)
  (define-key lyskom-en-list-prefix (kbd "q") 'kom-list-faqs)
  (define-key lyskom-en-list-prefix (kbd "Q") 'kom-list-server-faqs)

  (define-key lyskom-en-next-prefix (kbd "t") 'kom-view-next-new-text)
  (define-key lyskom-en-next-prefix (kbd "c") 'kom-go-to-next-conf)
  (define-key lyskom-en-next-prefix (kbd "l") 'kom-next-kom)
  (define-key lyskom-en-next-prefix (kbd "u") 'kom-next-unread-kom)

  (define-key lyskom-en-filter-get-prefix (kbd "p") 'kom-get-appreciation)
  (define-key lyskom-en-filter-get-prefix (kbd "k") 'kom-get-abuse)
  (define-key lyskom-en-filter-get-prefix (kbd "s") 'kom-filter-subject)
  (define-key lyskom-en-filter-get-prefix (kbd "a") 'kom-filter-author)
  (define-key lyskom-en-filter-get-prefix (kbd "c") 'kom-filter-text)
  (define-key lyskom-en-filter-get-prefix (kbd "r") 'kom-filter-recipient)

  (define-key lyskom-en-who-prefix (kbd "w") 'kom-who-is-on)
  (define-key lyskom-en-who-prefix (kbd "c") 'kom-who-is-on-in-conference)
  (define-key lyskom-en-who-prefix (kbd "p") 'kom-who-is-present-in-conference)
  (define-key lyskom-en-who-prefix (kbd "f") 'kom-who-is-on-and-friend)

  (define-key lyskom-en-change-prefix (kbd "p") 'kom-change-presentation)
  (define-key lyskom-en-change-prefix (kbd "q") 'kom-change-conf-faq)
  (define-key lyskom-en-change-prefix (kbd "f") 'kom-filter-edit)
  (define-key lyskom-en-change-prefix (kbd "m") 'kom-change-auto-reply)
  (define-key lyskom-en-change-prefix (kbd "t") 'kom-move-text)
  (define-key lyskom-en-change-prefix (kbd "T") 'kom-move-text-tree)

  (define-key lyskom-en-unread-prefix (kbd "SPC") 'kom-mark-unread)
  (define-key lyskom-en-unread-prefix (kbd "0") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "1") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "2") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "3") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "4") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "5") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "6") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "7") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "8") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "9") 'kom-initial-digit-unread)
  (define-key lyskom-en-unread-prefix (kbd "c") 'kom-unread-commented-text)
  (define-key lyskom-en-unread-prefix (kbd "C") 'kom-unread-previous-commented-text)
  (define-key lyskom-en-unread-prefix (kbd "a ?") 'lyskom-help)
  (define-key lyskom-en-unread-prefix (kbd "a c") 'kom-unread-comments)
  (define-key lyskom-en-unread-prefix (kbd "a r") 'kom-unread-tree)
  (define-key lyskom-en-unread-prefix (kbd "g") 'kom-unread-last-normally-read)
  (define-key lyskom-en-unread-prefix (kbd "o") 'kom-unread-root)
  (define-key lyskom-en-unread-prefix (kbd "l") 'kom-unread-by-to)
  (define-key lyskom-en-unread-prefix (kbd "M") 'kom-unread-more)
  (define-key lyskom-en-unread-prefix (kbd "r") 'kom-unread-root-review)
  (define-key lyskom-en-unread-prefix (kbd "f") 'kom-unread-first)
  (define-key lyskom-en-unread-prefix (kbd "A") 'kom-unread-all)
  (define-key lyskom-en-unread-prefix (kbd "f") 'kom-unread-first)
  (define-key lyskom-en-unread-prefix (kbd "p") 'kom-unread-presentation)
  (define-key lyskom-en-unread-prefix (kbd "q") 'kom-unread-faq)
  (define-key lyskom-en-unread-prefix (kbd "Q") 'kom-unread-server-faq)
  (define-key lyskom-en-unread-prefix (kbd "m") 'kom-unread-marked-texts)
  (define-key lyskom-en-unread-prefix (kbd "a m") 'kom-unread-all-marked-texts)
  (define-key lyskom-en-unread-prefix (kbd "a SPC") 'kom-unread-all)

  (define-key lyskom-en-review-prefix (kbd "SPC") 'kom-view)
  (define-key lyskom-en-review-prefix (kbd "0") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "1") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "2") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "3") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "4") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "5") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "6") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "7") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "8") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "9") 'kom-initial-digit-view)
  (define-key lyskom-en-review-prefix (kbd "b") 'kom-review-backward)
  (define-key lyskom-en-review-prefix (kbd "c") 'kom-view-commented-text)
  (define-key lyskom-en-review-prefix (kbd "C") 'kom-view-previous-commented-text)
  (define-key lyskom-en-review-prefix (kbd "a ?") 'lyskom-help)
  (define-key lyskom-en-review-prefix (kbd "a c") 'kom-review-comments)
  (define-key lyskom-en-review-prefix (kbd "a r") 'kom-review-tree)
  (define-key lyskom-en-review-prefix (kbd "a x") 'kom-review-cross-references)
  (define-key lyskom-en-review-prefix (kbd "j") 'kom-review-clear)
  (define-key lyskom-en-review-prefix (kbd "n") 'kom-review-next)
  (define-key lyskom-en-review-prefix (kbd "u") 'kom-review-noconversion)
  (define-key lyskom-en-review-prefix (kbd "v") 'kom-review-converted)
  (define-key lyskom-en-review-prefix (kbd "3") 'kom-review-rot13)
  (define-key lyskom-en-review-prefix (kbd "o") 'kom-find-root)
  (define-key lyskom-en-review-prefix (kbd "l") 'kom-review-by-to)
  (define-key lyskom-en-review-prefix (kbd "f") 'kom-review-first)
  (define-key lyskom-en-review-prefix (kbd "A") 'kom-review-all)
  (define-key lyskom-en-review-prefix (kbd "M") 'kom-review-more)
  (define-key lyskom-en-review-prefix (kbd "g") 'kom-review-last-normally-read)
  (define-key lyskom-en-review-prefix (kbd "q") 'kom-review-faq)
  (define-key lyskom-en-review-prefix (kbd "Q") 'kom-review-server-faq)
  (define-key lyskom-en-review-prefix (kbd "s") 'kom-review-stack)
  (define-key lyskom-en-review-prefix (kbd "p") 'kom-review-presentation)
  (define-key lyskom-en-review-prefix (kbd "r") 'kom-find-root-review)
  (define-key lyskom-en-review-prefix (kbd "m") 'kom-review-marked-texts)
  (define-key lyskom-en-review-prefix (kbd "a m") 'kom-review-all-marked-texts)
  (define-key lyskom-en-review-prefix (kbd "a SPC") 'kom-review-all)
  (define-key lyskom-en-review-prefix (kbd "x a") 'kom-agree)
  (define-key lyskom-en-review-prefix (kbd "x q") 'kom-fast-reply)
  (define-key lyskom-en-review-prefix (kbd "h") 'kom-review-mail-headers)

  (define-key lyskom-en-S-prefix (kbd "c") 'kom-status-conf)
  (define-key lyskom-en-S-prefix (kbd "p") 'kom-status-person)
  (define-key lyskom-en-S-prefix (kbd "s") 'kom-status-session)
  (define-key lyskom-en-S-prefix (kbd "k") 'kom-status-server)
  (define-key lyskom-en-S-prefix (kbd "m") 'kom-send-message)
  (define-key lyskom-en-S-prefix (kbd "u m") 'kom-sub-recipient)
  (define-key lyskom-en-S-prefix (kbd "u k") 'kom-sub-comment)
  (define-key lyskom-en-S-prefix (kbd "u q") 'kom-del-faq)
  (define-key lyskom-en-S-prefix (kbd "u f") 'kom-sub-footnote)
  (define-key lyskom-en-S-prefix (kbd "u ?") 'lyskom-help)

  (define-key lyskom-en-A-prefix (kbd "?") 'lyskom-help)
  (define-key lyskom-en-A-prefix (kbd "m") 'kom-add-recipient)
  (define-key lyskom-en-A-prefix (kbd "e") 'kom-add-copy)
  (define-key lyskom-en-A-prefix (kbd "d") 'kom-add-bcc)
  (define-key lyskom-en-A-prefix (kbd "k") 'kom-add-comment)
  (define-key lyskom-en-A-prefix (kbd "r") 'kom-add-cross-reference)
  (define-key lyskom-en-A-prefix (kbd "q") 'kom-add-faq)
  (define-key lyskom-en-A-prefix (kbd "f") 'kom-add-footnote)
  (define-key lyskom-en-A-prefix (kbd "Q") 'kom-add-server-faq)

  (define-key lyskom-en-B-prefix (kbd "l") 'kom-previous-kom)


  ;; Running in) buffer

  (define-key lyskom-en-mode-map (kbd "M-p") 'backward-text)
  (define-key lyskom-en-mode-map (kbd "M-n") 'forward-text)
  (define-key lyskom-en-mode-map (kbd "C-M-p") 'kom-prev-prompt)
  (define-key lyskom-en-mode-map (kbd "C-M-n") 'kom-next-prompt)
  (define-key lyskom-en-mode-map (kbd "s a") 'kom-save-text)

  (define-key lyskom-en-mode-map (kbd "C-?") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<DEL>") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<delete>") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<BS>") 'scroll-down)

  (define-key lyskom-en-mode-map (kbd "<") 'beginning-of-buffer)
  (define-key lyskom-en-mode-map (kbd ">") 'end-of-buffer)
  )


;;; ================================================================
;;; Prioritization

(defvar lyskom-en-prioritize-mode-map nil "Keymap used in lyskom-prioritize-mode")
(lyskom-language-keymap lyskom-prioritize-mode-map en lyskom-en-prioritize-mode-map)

(if lyskom-en-prioritize-mode-map
    nil
  (setq lyskom-en-prioritize-mode-map (make-keymap))
  (suppress-keymap lyskom-en-prioritize-mode-map)
  (define-key lyskom-en-prioritize-mode-map (kbd "SPC") 'lp--toggle-membership-selection)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-k") 'lp--toggle-membership-selection)
  (define-key lyskom-en-prioritize-mode-map (kbd "p")   'lp--set-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-w") 'lp--select-region)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-w") 'lp--select-region)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-y") 'lp--yank)
  (define-key lyskom-en-prioritize-mode-map (kbd "#")   'lp--select-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-#")   'lp--deselect-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-DEL") 'lp--deselect-all)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-p") 'lp--previous-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd "<up>") 'lp--previous-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-n") 'lp--next-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd "<down>") 'lp--next-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd "<home>") 'lp--first-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd "<end>") 'lp--last-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<") 'lp--first-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd "M->") 'lp--last-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd "g") 'lp--goto-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "RET") 'lp--toggle-entry-expansion)
  (define-key lyskom-en-prioritize-mode-map (kbd "+") 'lp--increase-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "-") 'lp--decrease-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-p") 'lp--move-up)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-n") 'lp--move-down)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<up>") 'lp--move-up)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<down>") 'lp--move-down)
  (define-key lyskom-en-prioritize-mode-map (kbd "I") 'lp--toggle-invitation)
  (define-key lyskom-en-prioritize-mode-map (kbd "H") 'lp--toggle-secret)
  (define-key lyskom-en-prioritize-mode-map (kbd "P") 'lp--toggle-passive)
  (define-key lyskom-en-prioritize-mode-map (kbd "M") 'lp--toggle-message-flag)
  (define-key lyskom-en-prioritize-mode-map (kbd "o") 'lp--set-unread)
  (define-key lyskom-en-prioritize-mode-map (kbd "P") 'lp--postpone)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-c C-c") 'lp--quit)
  (define-key lyskom-en-prioritize-mode-map (kbd "q") 'lp--quit)
  (define-key lyskom-en-prioritize-mode-map (kbd "(") 'lp--expand-entry)
  (define-key lyskom-en-prioritize-mode-map (kbd ")") 'lp--contract-entry)

  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button2up)) 'kom-button-click)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button2)) 'kom-mouse-null)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-prioritize-mode-map (kbd "*") 'kom-button-press)
  (define-key lyskom-en-prioritize-mode-map (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-en-prioritize-mode-map (kbd "TAB") 'kom-next-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-i") 'kom-next-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-C-i") 'kom-previous-link)
  )



;;;==============================================================
;;; Keymap for filter editing
;;;

(defvar lyskom-en-filter-edit-map nil)
(lyskom-language-keymap lyskom-filter-edit-map en lyskom-en-filter-edit-map)

(if lyskom-en-filter-edit-map ()
  (setq lyskom-en-filter-edit-map (make-keymap))
  (suppress-keymap lyskom-en-filter-edit-map)
  (define-prefix-command 'lyskom-en-filter-edit-prefix)
  (define-key lyskom-en-filter-edit-map (kbd "C-c")  'lyskom-en-filter-edit-prefix)
  (define-key lyskom-en-filter-edit-map (kbd "p") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "P") 'lyskom-filter-edit-prev-entry)
  (define-key lyskom-en-filter-edit-map (kbd "n") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "N") 'lyskom-filter-edit-next-entry)
  (define-key lyskom-en-filter-edit-map (kbd "C-p") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-n") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-b") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-f") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-p") 'lyskom-filter-edit-prev-entry)
  (define-key lyskom-en-filter-edit-map (kbd "M-n") 'lyskom-filter-edit-next-entry)
  (define-key lyskom-en-filter-edit-map (kbd "d") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-d") 'lyskom-filter-edit-delete-entry)
  (define-key lyskom-en-filter-edit-map (kbd "D") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-d") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "i") 'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "I") 'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-i") 'lyskom-filter-edit-insert-entry)
  (define-key lyskom-en-filter-edit-map (kbd "<") 'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-en-filter-edit-map (kbd ">") 'lyskom-filter-edit-end-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "M-<") 'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "M->") 'lyskom-filter-edit-end-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "q") 'lyskom-filter-edit-quit)
  (define-key lyskom-en-filter-edit-map (kbd "C-c C-c")   'lyskom-filter-edit-quit)
  (define-key lyskom-en-filter-edit-map (kbd "x") 'lyskom-filter-edit-expunge)
  (define-key lyskom-en-filter-edit-map (kbd "s") 'lyskom-filter-edit-save)
  (define-key lyskom-en-filter-edit-map (kbd "g") 'lyskom-filter-edit-revert)
  (define-key lyskom-en-filter-edit-map (kbd "t") 'lyskom-filter-edit-toggle-permanent)
  (define-key lyskom-en-filter-edit-map (kbd "a") 'lyskom-filter-edit-toggle-action)
  (define-key lyskom-en-filter-edit-map (kbd "?") 'lyskom-filter-edit-brief-help)
  (define-key lyskom-en-filter-edit-map (kbd "h") 'lyskom-filter-edit-brief-help)
  )



;;;; ============================================================
;;;; Strings and things for the customize mode
;;;;

(defvar lyskom-en-customize-map nil)
(lyskom-language-keymap lyskom-customize-map en lyskom-en-customize-map)


(if lyskom-en-customize-map
    nil
  (setq lyskom-en-customize-map (make-sparse-keymap))
  (define-key lyskom-en-customize-map (kbd "TAB") 'widget-forward)
  (define-key lyskom-en-customize-map (kbd "M-TAB") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "<S-tab>") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "C-i") 'widget-forward)
  (define-key lyskom-en-customize-map (kbd "M-C-i") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "C-m") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "C-j") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "<RET>") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "<LFD>") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button2)) 'widget-button-click)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button3)) 'lyskom-widget-click)
  (define-key lyskom-en-customize-map (kbd "C-c C-c") 'lyskom-customize-save-and-quit)
  (define-key lyskom-en-customize-map (kbd "C-c C-k") 'lyskom-customize-quit)
  (define-key lyskom-en-customize-map (kbd "C-c C-s") 'lyskom-customize-save)
  (define-key lyskom-en-customize-map (kbd "C-c C-a") 'lyskom-customize-apply)
  (define-key lyskom-en-customize-map (kbd "?") 'lyskom-customize-help)
)

(lyskom-language-strings local lyskom-custom-strings en
  '(
    ;;
    ;; Widget strings
    ;;

    (which-person . "Specify person: ")
    (which-conf . "Specify a conference: ")
    (which-conf-or-person . "Specify a person or conference: ")
    (which-name . "Specify a name: ")
    (some-person . "Person %#1d")
    (invalid-value . "Invalid value (%#1S)")
    (unknown-command . "Unknown command (%#1s)")
    (ding . "Audio cue")

    ;;
    ;; Help messages
    ;;

    (variable-type-help . "Select to save the setting in the server.")
    (default-help-echo . "Change the value of  %#1s.")
    (change-this-name . "Change the name in this entry.")
    (show-doc . "Show documentation.")
    (hide-doc . "Hide documentation.")
    (select-command . "Select a command.")
    (select-what-to-execute . "\
Select whether to execute command or keyboard macro.")
    (select-url-viewer . "Select a web browser.")
    (select-number . "Select number of times.")
    (select-audio-file . "Select an audio file.")
    (select-priority . "Select a priority.")
    (select-buffer . "Select a buffer name.")
    (select-buffer-size . "Select maximum buffer size.")

    ;;
    ;; Strings that are used in types and so forth
    ;;

    (buffer-name . "%#1s-configure")

    (other-window .     "Some other window             ")
    (other-frame .      "Some other frame              ")
    (new-frame .        "In a new frame                ")
    (lyskom-window .    "The LysKOM buffer's window    ")
    (window-on-buffer . "A window displaying the buffer")

    (on . "On ")
    (off . "Off")
    (yes . "Yes")
    (no . "No ")
    (to-file . "To file:")
    (max-text-length . "For texts shorter than: ")
    (autowrap-timeout . "Timeout in seconds: ")
    (no-timeout . "No timeout")

    (friends . "Friends and other special people")

    (turned-off .      "Turned off           ")
    (number-of-times . "A few times")
    (specific-spec . "Per recipient/sender")
    (sound-file . "Audio file")
    (other-persons . "All others")

    (selected-mark . "Mark          ")
    (conf-or-person . "Person or conference")
    (ask .           "Ask every time         ")
    (limited-number . "A limited number")
    (unlimited-number . "Unlimited")

    (before . "Before the text")
    (after . "After the text")
    (depth-first . "In comment order")
    (time-order . "In time order")

    (ar-message-type . "Message type")
    (ar-personal     . "Personal")
    (ar-group        . "Group")
    (ar-alarm        . "Alarm")
    (ar-any-type     . "Any message type")
    (ar-sender       . "Sender")
    (ar-any-sender   . "Any sender")
    (ar-specified-sender . "Specified senders")
    (ar-pers-or-conf . "Person or conference")
    (ar-recipient    . "Recipient")
    (ar-any-recipient . "Any recipient")
    (ar-specified-recipient . "Specified recipients")
    (ar-person       . "Person")
    (ar-message-text . "Message text")
    (ar-any-message  . "Any message")
    (ar-matching-regexp . "Matching regexp")
    (ar-reply        . "Reply")
    (ar-no-reply     . "No reply")
    (ar-reply-text   . "Reply text")

    (express-break . "Immediately upon creation  ")
    (break .         "After current comment chain")
    (no-break .      "After current conference   ")

    (express-server-break . "Immediately")
    (express-server-letters-break . "Immediately if letters arrive")
    (server-break . "After current comment chain")
    (letters-server-break . "After current comment chain if letters arrive")
    (after-conf-server-break . "After current conference")
    (after-conf-letters-server-break . "After current conference if letters arrive")
    (when-done-server-break . "After everything has been read")
    (no-server-break . "Never")

    (command . "Command")
    (command-list . "Command list")
    (some-persons . "For some persons")
    (name . "Name")

    (page-none . "Never                        ")
    (page-all .  "Before every command         ")
    (page-some . "Before the following commands")

    (ask-every-time . "Ask every time         ")
    (fixed-priority . "Fixed priority")

    (messages-in-lyskom-buffer . "In the LysKOM buffer")
    (discard-messages .          "Nowhere - discard them")
    (in-named-buffer .           "In a named buffer:")

    (automatic-session-name . "Automatic")
    (given-session-name . "Use specified:")

    (simple-unread-mode-line . "Simple")
    (explicit-unread-mode-line . "Show all sessions with unread")

    (everybody-rcpt . "Everybody                                ")
    (group-rcpt .     "The recipient of the last group message  ")
    (sender-rcpt .    "The sender of the most recent message    ")
    (last-recipient-recpt . "The last person I sent a message to")

    (viewer-program . "Web browser")
    (no-viewer            . "(none selected)")
    (default-viewer       . "Browse-URL (all)")
    (netscape-viewer . "Netscape/Mozilla (all)")
    (windows-viewer       . "Windows default or Netscape/Mozilla (all)")
    (emacs-w3-viewer . "Emacs W3 mode (HTTP, Goper, FTP)")
    (emacs-general-viewer . "Emacs (FTP, Telnet, Mail)")
    (emacs-dired-viewer . "Emacs Dired (FTP)")
    (emacs-mail-viewer . "Emacs Mail mode (Mail)")
    (emacs-telnet-viewer . "Emacs Telnet mode (telnet)")
    (mosaic-viewer . "NCSA Mosaic (all)")
    (lynx-viewer          . "Lynx (all)")
    (galeon-viewer        . "Galeon (all)")

    (dont-check . "Don't ask for confirmation")
    (check-before-open . "Confirm before writing the text")
    (check-before-send . "Confirm before sending the text")
    (no-size-limit . "No limit")
    (max-size-in-bytes . "Fixed limit (in bytes)")
    (execute . "Execute")
    (kbd-macro . "Keyboard macro")
    (command . "Command")
    (enter-kbd-macro . "Enter a keybard macro. Finish with %#1s")
    (long-format .  "Show help texts")
    (short-format . "Hide help texts")

    (truncate-threshold-lines . "Max lines")

    (first . "First")
    (last . "Last")
    (specific-placement . "Specific location")
    (priority . "Priority")
    (same-as-conf . "Same as current conference")
    (custom-format . "Custom format:")
    (default-format . "Standard format")
    (a-string . "A string:")
    (some-string . "A random string")
    (unspecified . "Unspecified")

    (symbolic-mark-association . "Association")
    (symbolic-mark-name . "Symbolic name: ")
    (mark-type-to-assoc . "Mark type to associate with: ")

    (prompt-for-text-no . "Prompt for text number")

    (all-others . "All others")
    (some-person . "Person")
    (format-html . "Format HTML:")

    (url-transform-regexp . "From (regexp):")
    (url-transform-newtext . " To:")

    (default-namedays . "Namedays for current language")
    (specific-namedays . "Specific name list")
    (several-name-lists . "Several name lists")

    (link-pattern-for . "Link patterns for")
    (all-conferences . "All recipients")
    (link-specific-rcpt . "Specific recipient")
    (link-pattern . "Link pattern")
    (link-replace . "Link substitution")
    (link-highlight-match . "Highlight group")
    (link-fold-case . "Case insensitive")

    (generated-face . "Automatic")
    (predefined-fonts . "Fonts intended for specific uses\n")
    (other-fonts . "Fonts with no specific uses\n")
    (other-face . "Other")

    (ext-simple-command . "Simple command")
    (ext-complex-command . "Command with arguments")
    (ext-complex-component . "Command/argument")

    (lynx-xterm . "Lynx in xterm")
    (lynx-emacs . "Lynx in emacs terminal-mode")

    (morons . "Morons and other \"special\" people")
    (friends . "Friends and other special people")
    (me . "Mig, myself and I")
    (i-am-supervisor . "Conferences i supervise")
    (has-no-presentation . "Conferences without presentations")
    (highlight-conferences . "Conferences:")
    (highlight-face . "Face:")
    (highlight-conflist . "Conference list")

    (yes-dont-pop . "Yes, but don't uniconify frames")
    (language . "Language")

    (specific-extended-info . "Only selected information")
    (extended-info-show . "Show:")
    (extended-info-type . "Information type:")

    (extended-server-info . "All extended server information")
    (extended-conf-info . "All extended conference information")
    (extended-pers-info . "All extended person information")
    (extended-read-faq-info . "Read FAQs")
    (extended-statistics-info . "Full server statistics")
    (extended-all-other-info . "Other information")

    ;;
    ;; Misc doc strings
    ;;

    (lyskom . "Configuration of LysKOM")
    (lyskom-doc . "\
These commands work outside editable text fields.
\\[lyskom-customize-save-and-quit] to save and quit,
\\[lyskom-customize-save-and-quit] to save and quit,
\\[lyskom-customize-save] to save without quitting,
\\[lyskom-customize-quit] to quit without saving.
\\[widget-forward] moves to the next setting
\\[widget-button-press] changes the value
Press C-h m for a complete list of commands.

Documentation:  [?] Show documentation    [!] Hide documentation
Lists etc.   :  [INS] Add a line   [DEL] Remove a line   [*] Modify

If the box before the name of the setting is selected, the setting will
be saved in the server. Otherwise it will be saved in your .emacs.

Click prompts with the middle mouse button to change values and bring 
up menus.")




    (section . "------------------------------------------------------------------------------\n")
    (look-and-feel-misc . "Look and feel\n")
    (window-locations   . "Windows\n")
    (windows-where      . "How are windows created:\n")
    (reading .            "Reading\n")
    (writing .            "Writing\n")
    (urls .               "URL management\n")
    (personal-messages .  "Personal messages\n")
    (remote-control .     "Remote control of LysKOM\n")
    (hooks .              "Hook functions\n")

    (audio-cues .         "Audio cues\n")
    (audio-cues-when    . "Issue audio cues when:\n")
    (automatic-replies .  "Automatic replies\n")

    (new-window-netscape . "Open URLs in a new window")
    (new-tab-netscape . "Open URLs in a new tab")
    (default-netscape . "Open URLs wherever")

    (audio-cues-doc . "\
  The following group of settings controls how LysKOM issues audio cues in
  various situations. The following options are available for each setting:

    Off
        No audio cue is issued

    A Few Times
        Emacs will beep one or more times. You have to specify how many
        times Emacs is to beep.

    Audio File
        Emacs will attempt to play the specified audio file. The program
        used to play the file is specified by another setting.")
    

    (sending-doc . "\
  The following settings turn on or off certain checks that can be performed
  before sending a text to the server. The checks are designed to keep
  you from doing something stupid.

    Confirm multiple recipients
        If a text or comment has more than one recipient, LysKOM 
        can ask which of the recipients are relevant. This can either
        be done before you start writing the text, in which case 
        LysKOM will post a question for each recipient, or before sending
        the text to the server, in which case you may confirm all the
        recipients at once. It is also possible to turn this check off
        entirely.

    Check membership of commented author
        When on, LysKOM will check that the author of the comment you are
        writing is a member of at least one of the recipients of your comment.
        If not, LysKOM will offer to add the commented author as a recipient
        to the comment you are writing.

    Authors not to check
        A list of authors not to check even if check membership of
        commented author is on.

    Check for unread comments
        When this is on, LysKOM will check that you have read all the other
        comments to the text you are commenting before sending your
        comment to the server. This is supposed to help you avoid duplicating
        someone else's comment.")

    (windows-doc . "\
  The following settings control how windows are created in LysKOM. The
  available options are:


    Some other window
        In another window, but in the same frame as LysKOM. If there only
        is one window in the frame, a new window will be created (and will
        be removed when you are finished).

    Some other frame
        In a different frame than the one LysKOM is in. If there only is one
        frame, a new one will be created (and will be removed when you are
        finished).

    In a new frame
        A new frame is created (and will be removed when you are finished).

    The LysKOM buffer's window
        The LysKOM buffer's window will be used. LysKOM will be restored to
        the window when you're finished.

    A window displaying the buffer
        If there is a window anywhere displaying the named buffer, that 
        window will be used. This might be useful if you always have a
        particular buffer showing, but don't need it when executing some
        command.")


    ;;
    ;; Doc strings for variables
    ;;

    (kom-ansaphone-replies-doc . "\
  This setting controls automatic replies in detail. You can set replies
  for specific senders, recipients and even message contents. If the message
  being replied to does not match any element in this list, the default
  auto reply message above is sent instead.

  For each pattern in the list you can set the required message type, 
  sender the message must have, recipient the message must have, a regular
  expression the message must match and the reply to send.

  It is advisable to configure the client not to send a message to any
  group or alarm message.")

    (kom-bury-buffers-doc . "\
  Controls how the LysKOM buffer is handled when moving to another KOM buffer
  with the Next and Previous LysKOM commands. When turned on the current
  buffer is buried.")

    (kom-personal-messages-in-window-doc . "\
  Controls which window is used to display the buffer with personal messages.
  For this setting to have any effect, personal messages must be displayed
  in a separate buffer, and that buffer must be displayed automatically
  every time a message is received.")

    (kom-write-texts-in-window-doc . "\
  Controls which window is used to write new texts.")

    (kom-prioritize-in-window-doc . "\
  Controls which window is used to prioritize conferences.")

    (kom-edit-filters-in-window-doc . "\
  Controls which window is used for editing filters.")

    (kom-customize-in-window-doc . "\
  Controls which window is used to configure LysKOM.")

    (kom-view-commented-in-window-doc . "\
  Controls which window is used to show the commented text when commenting.")

    (kom-list-membership-in-window-doc . "\
  Controls in which window your membership list is shown.")


    (kom-user-prompt-format-doc . "\
  The format of the LysKOM prompt. Certain control sequences cause special
  text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-user-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing.
  Certain control sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-anonymous-prompt-format-doc . "\
  The format of the LysKOM prompt used when anonymous. Certain control
  sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-anonymous-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing
  and the session is anonymous. Certain control sequences cause special 
  text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-enabled-prompt-format-doc . "\
  The format of the LysKOM prompt when in administrator mode. Certain
  control sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-enabled-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing
  and the session is in administrator mode. Certain control sequences 
  cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")
    
    (kom-cite-string-doc . "\
  A string that is inserted before each line in a cited text. Normally this
  is set to something like \"> \". Note that it is not customary to cite
  commented texts the way it is done in e-mail or Usenet News since the
  commented text is always available in LysKOM.")


    (kom-created-texts-are-read-doc . "\
  When this is on, self-created texts are automatically marked as read. Turned
  off, those texts are presented as any other texts.")

    (kom-default-mark-doc . "\
  The default mark type used for marking texts. A mark type is an integer
  between 0 and 255 (inclusive). If no default mark type is selected, LysKOM
  asks for a mark type every time a text is to be marked. This can be used
  to separate different types of marks. You can, for example, mark texts
  which contain valuable information with a certain integer and texts which
  you should remember to comment some time with another integer.")

    (kom-symbolic-marks-alist-doc . "\
  To avoid having to memorize what the integer mark types are supposed to
  mean, you can define a list of symbolic mark types. A symbolic mark type
  is a descriptive string that is associated with an integer mark type.")

    (kom-reading-puts-comments-in-pointers-last-doc . "\
  Controls if comment links are listed before or after the body of a text.
  Normally comment links are listed after the text.

  Before:

    398331 1996-09-24  13:22  /2 lines/ George Berkeley
    Recipient: Philosophy <1226>
    Comment in text 398374 by John Locke
    Subject: 
    ------------------------------------------------------------
    An abstract idea is a contradiction in terms.
    (398331) -----------------------------------

  After:

    398331 1996-09-24  13:22  /2 lines/ George Berkeley
    Recipient: Philosophy <1226>
    Subject: 
    ------------------------------------------------------------
    An abstract idea is a contradiction in terms.
    (398331) -----------------------------------
    Comment in text 398374 by John Locke
")

    (kom-dashed-lines-doc . "\
  When this setting is turned on, dashed lines are displayed before and after
  the text body. When turned off, blank lines are used instead.

  On:

    892343 1996-09-24  19:21  /2 lines/ Tycho Brahe
    Recipien: Presentation (of new) Members
    Subject: Tycho Brahe
    ------------------------------------------------------------
    Astronomer and discoverer of stars resident on the island of Ven.
    (892343) -----------------------------------

  Off:

    892343 1996-09-24  19:21  /2 lines/ Tycho Brahe
    Recipien: Presentation (of new) Members
    Subject: Tycho Brahe

    Astronomer and discoverer of stars resident on the island of Ven.
    (892343)

  Most people have this turned on.")

    (kom-autowrap-doc . "\
  With this setting turned on, LysKOM will attempt to fill any paragraphs
  containing lines that are wider than the screen. Paragraphs that appear
  to have been preformatted by the author are exempted from this treatment.
  If set to a number, only texts shorter than this number (in characters)
  will be filled. This may be useful to avoid filling very long texts.")

    (kom-autowrap-timeout-doc . "\
  This setting controls the maximum number of seconds the client may
  spend attempting to fill paragraphs of a text. This is useful to
  avoid long waits while the client is breaking lines in a very long
  text. The actual time spent filling paragraphs may be several
  seconds longer than this value. Unfortunately there is no way to
  avoid this. Furthermore, setting a limit slows down all text display
  slightly. When this is off, it is still possible to cancel paragraph
  filling by typing C-g.")

    (kom-show-author-at-end-doc . "\
  When this is turned on, the name of the author will be shown at the end
  of the text. The name is also shown before the text as usual.

  On (with dashed lines on):

    892342 1996-09-24  19:21  /2 lines/ Claude Shannon
    Mottagare: Presentation (of new) Members
    rende: Claude Shannon
    ------------------------------------------------------------
    Information theoretician
    (892342) /Claude Shannon/------------------------------

  Off:

    892342 1996-09-24  19:21  /2 lines/ Claude Shannon
    Recipient: Presentation (of new) Members
    Subject: Claude Shannon
    ------------------------------------------------------------
    Information theoretician
    (892342) -----------------------------------

  If dashed lines are off, the author's name will be shown as in this
  example, but the dashed lines are naturally not displayed.")

    (kom-truncate-threshold-doc . "\
  If this is activated, texts longer than the maximum number of lines will
  be truncated when you review comments, review marked texts or review the
  first or last texts in a conference.  Texts will not be truncated when
  you review a text, review a tree or read the next text.")

    (kom-truncate-show-lines-doc . "\
  The number of lines to show of truncated texts.")

    (kom-print-number-of-unread-on-entrance-doc . "\
  Determines whether the number of unread texts is shown when entering
  a conference:

  On:

    Go to next conference...
    Presentation (of new) Members - 3 unread
    Read next text - 

  Off:

    Go to next conference...
    Presentation (of new) Members
    Read next text - ")



    (kom-presence-messages-in-echo-area-doc . "\
  If you want messages in the echo area when somebody logs in, logs out or
  changes name, turn this setting on. Messages are shown in the minibuffer.
  If you want messages about a limited number of users, specify which ones.
  To not get any messages at all, just specify an empty list.")

    (kom-presence-messages-in-buffer-doc . "\
  If you want messages in the LysKOM buffer when somebody logs in, logs out
  or changes name, turn this setting on. Messages are shown in the LysKOM
  buffer. If you want messages about a limited number of users, specify which 
  ones. To not get any messages at all, just specify an empty list.")

    (kom-show-where-and-what-doc . "\
  If this is on, the list of active users will include the machine and user
  they are logged in from (if known) and what they are currently doing.

  On:

        User                                   Is in conference             
        At                                     Activity                        
    --------------------------------------------------------------------------
     6810 George Berkeley                      Philosophy                     
          berkeley@emp1.tcd.ie                 (Writing a comment.)           
     7571 John Locke                           Philosophy                     
          eridy@cc.ox.ac.uk                    (Waiting.)                     

  Off:

        User                                   Is in conference             
    --------------------------------------------------------------------------
     6810 George Berkeley                      Philosophy                     
     7571 John Locke                           Philosophy")

    (kom-show-since-and-when-doc . "\
  If this is on, the list of active users will include the connection time
  and the inactivity period for each user.")

    (kom-remember-password-doc . "\
  When this setting is active the password used to login to LysKOM will
  be saved in a local variable in the session buffer. This makes it 
  possible to relogin automatically if the session is lost. Note that the
  password is saved in clear text so it can be read by anyone who gains 
  access to your LysKOM session buffer (even disconnected).")

    (kom-idle-hide-doc . "\
  The listing of active users normally only shows those users who have been
  active recently. This setting determines how many minutes a user may be
  inactive without being excluded from the list of active users.")


    (kom-show-footnotes-immediately-doc . "\
  Footnotes can be shown either as comments or immediately when the text
  they are footnotes to is displayed. This setting controls which behavior
  is used.")


    (kom-follow-comments-outside-membership-doc . "\
  LysKOM will normally not follow chains of comments into conferences you are
  not a member of. If you do want to follow comment chains into other
  conferences, turn this setting on.")


    (kom-read-depth-first-doc . "\
  LysKOM can display texts either in the order they were written or in
  the order defined by the comment tree. For example, if texts 1003 and
  1004 are comments to text 1002, text 1006 is a comment to 1003 and 
  texts 1005 and 1007 are comments to 1004, the comment tree looks 
  something like this:
        
  1002 +-- 1003 --- 1006
       |
       +-- 1004 +-- 1005
                |
                +-- 1007

  Reading in order of creation will cause the texts to be displayed
  in numerical order: 1002, 1003, 1004, 1005, 1006 and finally 1007.
  Reading in comment order will give the order 1002, 1003, 1006, 1004,
  1005 and finally 1007.")


    (kom-continuous-scrolling-doc . "\
  Turned on means that LysKOM will scroll the buffer while new text is 
  being inserted, not just at the end of a command. This works well with
  faster terminals, but may be worth turning off if the terminal is so slow
  that scrolling Emacs buffers takes a long time.")


    (kom-deferred-printing-doc . "\
  In order to improve speed, LysKOM will not print certain things, such as
  the names of users and conferences immediately, but will delay printing
  to make time for other tasks. This improves response time in the client
  considerably, and should only be turned off if it causes problems.")


    (kom-higher-priority-breaks-doc . "\
  When texts are created in conferences that have a higher priority than
  the one currently being read, LysKOM will attempt to break the normal
  reading order to show these. This setting controls whether the reading
  order is broken immediately, after the current comment chain is read or
  when everything in the current conference has been read.")


    (kom-login-hook-doc . "\
  This hook lists commands to be run when logging in, before any input is
  accepted from the keyboard.")


    (kom-do-when-done-doc . "\
  This hook lists commands and keyboard macros that are to be executed when
  all texts have been read.")


    (kom-page-before-command-doc . "\
  The LysKOM buffer can be cleared before all commands, so text that is 
  inserted always appears at the top of the buffer's window. This variable
  controls before which commands the buffer is to be scrolled.")


    (kom-permissive-completion-doc . "\
  When this is on, TAB will only complete to the names of users that are 
  logged on when the command being invoked is only applicable to people
  that are logged on. When off, TAB will complete to names of everyone.")


    (kom-membership-default-priority-doc . "\
  This specifies how the initial priority of a conference is set when
  you first become a member. If it is a number between 1 and 255, that is
  the priority assigned. If it is something else, LysKOM will ask for a 
  priority every time you become a member of a conference.")

    (kom-membership-default-message-flag-doc . "\
  This specifies if group messages are received for conferences you join.
  `Yes' means group messages are received, `No' that they aren't and 
  `Ask every time' that the client will ask every time you become a member
  of a conference.")

    (kom-show-personal-messages-in-buffer-doc . "\
  This setting specifies how personal, group and public messages are shown.
  The messages can be displayed in the LysKOM buffer, simply thrown away or
  be shown in a named buffer.")

    (kom-pop-personal-messages-doc . "\
  If messages are shown in a named buffer and this setting is also on, then
  LysKOM will display that buffer whenever a message arrives.")

    (kom-audio-player-doc . "\
  If you want LysKOM to play audio files instead of simply beeping, this
  setting must specify the name of a program that can play the audio files.
  The program must take a single argument, the name of the file to play.")

    (kom-default-message-recipient-doc . "\
  This setting controls who will be the default recipient of messages. The
  default recipient may either be everyone, i.e. a public message; the
  sender of the most recently received message; the recipient of the most
  recently received group message; or the sender of the most recently
  received personal message.")

    (kom-filter-outgoing-messages-doc . "\
  If this is on, messages that are sent automatically, such as automatic
  replies and replies to remote control commands, will be shown as if you
  had sent them manually.")

    (kom-friends-doc . "\
  The users named in this list will be displayed using a special face in
  the LysKOM buffer. These users are also listed with the command Which 
  friends (and may be used in other similar commands).")

    (kom-morons-doc . "\
  The users named in this list will be displayed using a warning face in
  the LysKOM buffer.")

    (kom-url-viewer-preferences-doc . "\
  This setting controls which WWW browser that will be used to open URLs
  found in LysKOM. If the first browser in the list cannot handle the type
  of URL being opened, then the next browser is tried, and so on.")

    (kom-windows-browser-command-doc . "\
  This setting specifies the command to use to start a web browser
  under Windows. If empty, a couple of commands that are likely to
  work on Windows will be tried.")

    (kom-mosaic-command-doc . "\
  This setting specifies the command to use to start NCSA Mosaic.")

    (kom-netscape-command-doc . "\
  This setting specifies the command to use to start Netscape or Mozilla.")

    (kom-galeon-command-doc . "\
  This setting specifies the command to use to start Galeon.")

    (kom-inhibit-typeahead-doc . "\
  Key presses are usually buffered while LysKOM is busy, and are executed
  as soon as possible. With this setting off, LysKOM discards any key presses
  received while the client was busy.")

    (kom-max-buffer-size-doc . "\
  It is possible to limit the size of the LysKOM buffer by specifying a
  maximum number of characters in this setting. When the buffer grows
  beyond this limit, text from the beginning of the buffer is removed.")

    (kom-ansaphone-record-messages-doc . "\
  LysKOM can record messages that arrive when the autoreply feature is on.
  This setting controls whether messages are recorded or not.")

    (kom-ansaphone-show-messages-doc . "\
  When this setting is on, LysKOM will display incoming messages even if
  the autoreply feature is turned on.")

    (kom-ansaphone-default-reply-doc . "\
  This is the message sent by the autoreply feature unless a different
  message has been specified using some other means (and other means are
  only for careful experts).")

    (kom-remote-control-doc . "\
  When turned on, it is possible to control the session using remote control
  commands. Only those users listed below may issue the commands.")

    (kom-remote-controllers-doc . "\
  The users listed here are permitted to issue remove control commands
  to your LysKOM session.")

    (kom-self-control-doc . "\
  When this is on, the user who is logged on may issue remote control
  commands. This is an alternative to adding yourself to the list of 
  permitted controllers.")

    (kom-customize-format-doc . "\
  The documentation for the various settings can be visible or hidden when
  you open the settings buffer. No matter if it starts hidden or visible, the
  documentation for individual settings can be shown and hidden by using the
  question mark/exclamation mark to the right of the setting.")

    (kom-default-language-doc . "\
  Default language to use in LysKOM. If you change this setting the new
  language will not be applied to the current setting. Use the Change
  language command to do that. The first langauge in the list will be used
  in all clients that support this function.")

    (kom-ispell-dictionary-doc . "\
  This specifies the dictionary ispell is to use for spell checking. If set
  to ispell-dictionary, then the variable ispell-dictionary will be used
  instead.")

    (kom-show-namedays-doc . "\
  When this is on, display the name of the day. You can choose to display
  names from a list appropriate to the currently selected language. You
  can also choose a specific list of names.")

    (kom-show-week-number-doc . "\
  The Time command shows week numbers if this is on.")

    (kom-relogin-behaviour-doc . "\
  This controls if the client will try to reattach when a command is given 
  in a disconnected session. On means the client tries to reattach
  automatically, Off that it doesn't even ask.")

    (kom-relogin-inhibit-commands-doc . "\
  Commands for which reattachment is disabled. These commands will never
  cause the client to reattach.")

    (kom-membership-default-placement-doc . "\
  This controls where new memberships are placed. First means before
  all existing memberships of the same priority. Last means after all
  existing memberships of the same priority. A number indicates a
  fixed placement (although the client will eventually sort the membership
  list in order of priority).")

    (kom-show-imported-importer-doc . "\
  The importer of an imported e-mail message is shown if this is on.
  This only works with compliant e-mail importers.")

    (kom-show-imported-envelope-sender-doc . "\
  The actual sender (the envelope sender) of imported e-mails is shown 
  if this is on. This only works with compliant e-mail importers.")

    (kom-show-imported-external-recipients-doc . "\
  Show external recipients and CC recipients of imported e-mails if this
  is on. This only works with compilant e-mail importers.")

    (kom-show-imported-message-id-doc . "\
  Show Message-Id of imported e-mails if this is on. This only works with 
  compilant e-mail importers.")

    (kom-agree-text-doc . "\
  Default text for the Agree command. It can either be a text or a list
  of texts. If it is a list, one of the texts will be chosen at random.")

    (kom-silent-ansaphone-doc . "\
  If this is off, the client will not beep when a personal, group or
  public message is received when the auto reply feature is on.")

    (kom-default-session-priority-doc . "\
  The session priority of new sessions. Conferences with a lower priority
  will not be read.")

    (kom-unsubscribe-makes-passive-doc . "\
  When this is on, the first time you leave a conference you become a
  passive member. Leaving the conference again unsubscribes you completely.
  When this is off, leaving a conference unsubscribes you immediately.")

    (kom-review-priority-doc . "\
  Priority for review commands. This setting can be used to give review
  commands a higher priority than normal. The default priority is the
  same as the conference currently being read. Set this to 256 or higher
  if you want review commands to take precedence over all conferences.")

    (kom-show-creating-software-doc . "\
  Show the name of the client used to create a text if the information
  is present and this setting is on.")

    (kom-text-footer-format-doc . "\
  Format for the text footer. In the format string, %n is replaced by the
  text number, %P with the author's name, %p with the author's number, %f
  with information about the text (HTML, filled, etc), and %- with a
  suitable dashed line. A number after the percent sign is the minimum
  number of characters to use. A minus sign before the number causes text
  to be left justified within the field. An equals sign causes text
  longer than the indicated width to be truncated.")
 
    (kom-long-lines-doc . "\
  When this is on, most of the dashed lines are made longer than normal.")

    (kom-postpone-default-doc . "\
  Number of texts to postpone with the Postpone reading command.")

    (kom-allow-incompleteness-doc . "\
  When this is on, the client will not wait for information about all
  unread texts, even if it is needed. The result is that List news and
  some other commands do not yield accurate results shortly after logging
  in. When this is off, the client will wait for information on all
  unread texts when it is needed.")

    (kom-smileys-doc . "\
  When this is on, Emacs supports it, and the appropriate package 
  (smiley.el, which is part of Gnus) is installed, smileys will be
  shown graphically.")
  
    (kom-ignore-message-senders-doc . "\
  Don't show personal, group or alarm messages from these senders.")

    (kom-ignore-message-recipients-doc . "\
  Don't show group messages to these recipients.")

    (kom-text-footer-dash-length-doc . "\
  The total length of the text footer when long dashed lines are not
  in effect and no custom format is being used.")

    (kom-text-header-dash-length-doc . "\
  The total length of the text header when long dashed lines are not
  in effect.")

    (kom-show-personal-message-date-doc . "\
  When this is on, the date and time is shown on all personal, group and
  alarm messages.")

    (kom-w3-simplify-body-doc . "\
  When this is on, the client will ignore colors set in the HTML body when
  displaying formatted HTML.")

    (kom-mercial-doc . "\
  This text is shown in the list of users when you have finished reading
  everything.")

    (kom-session-nickname-doc . "\
  How the session name is determined. This is the name displayed in the 
  mode line and by List sessions.")

    (kom-server-priority-doc . "\
  Priority of this LysKOM session. The client can prompt you to go to
  a session with unread texts when a text arrives in a session with a
  higher priority than the one currently being read.")

    (kom-server-priority-breaks-doc . "\
   This setting controls when a prompt to go to the next LysKOM session
   with unread texts is presented.

   Immediately                  Present a prompt if any text arrives in
                                a session with a higher priority.

   Immediately if letters arrive    Present a prompt is a letter arrives
                                in a session with a higher priority.

   After current comment chain  Present a prompt after the current chain
                                of comments has been read if a text
                                arrives in a session with a higher 
                                priority.

   After current comment chain if letters arrive    Present a prompt
                                after the current chain of comments has
                                been read if a letter arrives in a session
                                with a higher priority.

   After current conference     Present a prompt after all texts in the
                                current conference have been read if a
                                text arrives in a session with a higher
                                priority.

   After current conference if letters arrive       Present a prompt 
                                after all texts in the current conference
                                have been read if a letter arrives in a 
                                session with a higher priority.

   After everything has been read   Present a prompt to go to the next
                                session with unreads after everything
                                has been read. The prompt is presented
                                regardless of session priorities.

   Never                        Never prompt to go to another LysKOM
                                session.")

    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-personal-messages-doc . "")
    (kom-ding-on-group-messages-doc . "")
    (kom-ding-on-common-messages-doc . "")
    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-wait-done-doc . "")
    (kom-ding-on-priority-break-doc . "")
    (kom-ding-on-new-letter-doc . "")
    (kom-check-for-new-comments-doc . "")
    (kom-check-commented-author-membership . "")
    (kom-confirm-multiple-recipients-doc . "")
    (kom-check-commented-author-membership-doc . "")
    (kom-complete-numbers-before-names-doc . "\
   When this is on and you enter a text that can be either a conference
   number or a conference name, the client will accept it as a conference 
   number, if possible. When this is off, the text will be accepted as
   a conference name first and number second.")
    (kom-keep-alive-interval-doc . "\
  The number of seconds between calls to the server used to keep the
  network connection to the LysKOM server active. If your network connection
  shuts down after a period of inactivity, set this to approximately half
  that period and use the command `Keep connection alive'.")
    (kom-text-no-prompts-doc . "\
  Specifies which commands will always prompt for text numbers and which
  will not. Commands that are not listed here will use default behavior.")
    (kom-saved-file-name-doc . "\
  Specifies the default file to archive texts in. The client will always
  prompt for the file name, using this as the default.")
    (kom-follow-attachments-doc . "\
  Specifies whether to read imported e-mail attachments as regular
  comments. When off, imported attachments are marked as read when the
  e-mail they are attached to is read.")
    (kom-show-unread-in-frame-title-doc . "\
  When this is on, the indicator \"(Unread)\" is shown in the title
  bar of all windows whose active buffer belongs to a LysKOM session
  with unread texts. The title bar may not be updated unless the
  window is open.")
    (kom-unread-mode-line-type-doc . "\
  This settings controls how unread texts are indicated in the mode line.
  `Simple' meand there is a single indication for all active sessions that
  shows if there are any unread texts or letters.

  `Show all sessions with unread' means all sessions with unread texts 
  will be listed in the mode line. If there are unread letters in a 
  session it will be indicated by uppercasing the session name (e.g. 
  LysLys becomes LYSLYS). If the session name is upper cased already
  (e.g. LYSLYS) it will be marked with asterisks (e.g. *LYSLYS*).

  Note that this setting should be the same for all active LysKom
  sessions. That means it's probably wise to save it in your .emacs.")
    (kom-created-texts-are-saved-doc . "\
  If this variable is set to a file name, all texts you write will be 
  saved to that file. Texts that could not be created are not saved.")
    (kom-confirm-add-recipients-doc . "\
  When this is on and you add a recipient to a text, the client will
  ask if comments to the text should also be sent to the new
  recipient. When this is off, comments will always be sent to the new
  recipient. For most people it is a good idea to leave this on.")

    (kom-trim-buffer-minimum-doc . "\
  If you have limited the LysKOM buffer size, this variable determines
  how much larger than the limit the buffer has to be before it is
  trimmed back to the maximum size. The variable must be an integer;
  the default is 4096.")

    (kom-dont-check-commented-authors-doc . "")
    (kom-print-relative-dates-doc . "\
  The time fields of texts (and a couple of other things) will be
  \"today\" or \"yesterday\" if this setting is on and the text was
  written today or yesterday, respectively. If it is off, absolute
  dates will always be shown.")
    (kom-print-seconds-in-time-strings-doc . "\
  If this setting is on, some time strings (for example the creation
  time of texts and sent messages) will include seconds.")
    (kom-review-uses-cache-doc . "\
  If this is turned on, commands that review texts will use saved copies
  of the text rather than get new copies from the server. This makes the
  commands run significantly faster, but in some cases the texts may 
  have changed since they were copied, and you will not see those 
  changes.")
    (kom-review-marks-texts-as-read-doc . "\
  If this is turned on, commands that review texts will also mark them
  as read. Otherwise, the review commands will leave your reading history
  untouched, as usual.")
    (kom-auto-review-faqs-doc . "\
  If this is turned on, FAQs that are not marked as read will be reviewed
  automatically when you log on or go to a conference with a new FAQ.")
    (kom-auto-list-faqs-doc . "\
  If this is turned on, new FAQs will be listed automatically when you
  log on or go to a conference with a new FAQ.")
    (kom-extended-status-information-doc . "\
  When this is on, additional information may be shown by commands that
  display person, conference and server status.")
    (kom-highlight-first-line-doc . "\
  When this is on, the first line (with text number, date and author) is
  shown with a different format than normal text.")
    (kom-highlight-dashed-lines-doc . "\
  When this is on, the lines before and after the text body is shown with
  a different format than normal text.")
    (kom-highlight-text-body-doc . "\
  When this is on, the text body is shown with a different format than
  normal text.")
    (kom-async-highlight-dashed-lines-doc . "\
  When this is on, the lines before and after personal, group and alarm
  messages are shown with a different format than normal text.")
    (kom-async-highlight-text-body-doc . "\
  When this is on, the body of personal, group and alarm messages are
  shown with a different format than normal text.")
    (kom-edit-hide-add-button-doc . "\
  When this is on, an [Add...] button will be shown after the list of
  recipients and properties when writing a new text.")
    (kom-format-html-authors-doc . "\
  This setting controls which authors' HTML messages that the client will
  attempt to format.")
    (kom-format-show-images-doc . "\
  This setting controls if texts marked as images are treated
  specially or handled as normal texts.") 
    (kom-keyboard-menu-immediate-selection-doc . "\
  This setting controls whether keyboard shortcuts in text-based context
  menus require confirmation with return or not. With this on you have
  to confirm all selections with return.")
    (kom-max-overlays-doc . "\
  Use this setting to limit the number of overlays in the LysKOM buffer
  \(overlays are used to create the colored backgrounds for texts\). By
  limiting the number of overlays it is possible to speed up operations
  such as scrolling significantly. Each text requires 1-4 overlays for
  highlighting, depending on other settings.")
    (kom-mark-read-texts-as-read-in-new-recipient-doc . "\
  When this is on, texts that have been read will automatically be
  marked as read in any conferences they are added to. This only works
  as long as the LysKOM session is logged in. Texts are never 
  automatically marked as read in your mailbox.")
    (kom-url-transformation-rules-doc . "\
  Rules for transformation of URLs before they are sent to a web browser.
  \"From\" is a regexp that is replaced by \"To\". Regexps are documented
  in the Emacs manual. The string in \"To\" can contain the following
  special sequences:

      \\& means substitute original matched text,
      \\N means substitute match for (...) number N,
      \\\\ means insert one \\.")

    (kom-text-links-doc . "\
  Text link definitions. Each line defines one link for texts with a
  particular recipient. All occurrences of the link pattern will be shown
  as URL links. The URL pointed to by the link is generated from the text
  matching the link pattern, by substituting according to the link
  substitution. The text that is highlighted is determined by the 
  \"Highlight group\" setting: zero means highlight the entire match. A
  number 1-9 indicated the parenthesized group to highlight (and if that
  makes no sense to you, stick with zero). If \"Case insensitive\" is
  on, text will be matched without recard for character case.

  The link substitution can contain the following special sequences:

      \\& means substitute original matched text,
      \\N means substitute match for (...) number N,
      \\\\ means insert one \\.")

    (kom-active-face-doc . "\
  Face used for clickable areas other than URLs, conference and person
  names, friends, morons and text numbers.")
    (kom-active-highlight-face-doc . "\
  Face intended for clickable areas that are to be highlighted.")
    (kom-active-strikethrough-face-doc . "\
  Face intended for clickable areas that are to be indicated with
  strikethrough.")
    (kom-url-face-doc . "\
  Face used for clickable URLs.")
    (kom-me-face-doc . "\
  Face used for my own name.")
    (kom-highlight-face-doc . "\
  Face used for highlighting clickable areas as the mouse is moved
  over them.")
    (kom-subject-face-doc . "\
  Face used for subject lines.")
    (kom-text-no-face-doc . "\
  Face used for text numbers.")
    (kom-friends-face-doc . "\
  Face used for names of people listed in \"Friends and other 
  special people\".")
    (kom-morons-face-doc . "\
  Face used for names of people listed in \"Morons and other
  \"special\" people.")
    (kom-presence-face-doc . "\
  Face used for presence messages.")
    (kom-first-line-face-doc . "\
  Face used for first header line. This face is overlayed on other
  text. Properties not defined by this face will be retained. For
  example, if you only set the weight property, the colors normally
  used will not be changed.")
    (kom-warning-face-doc . "\
  Face used for important warnings.")
    (kom-mark-face-doc . "\
  Face used for various marks, including the indicator shown when the
  client scrolls less than a full page. This face is overlayed on other
  text. Properties not defined by this face will be retained. For
  example, if you only set the weight property, the colors normally
  used will not be changed.")
    (kom-dim-face-doc . "\
  Face used for various discreet texts.")
    (kom-text-body-face-doc . "\
  Face used for text bodies. This face is overlayed on other
  text. Properties not defined by this face will be retained. For
  example, if you only set the weight property, the colors normally
  used will not be changed.")
    (kom-dashed-lines-face-doc . "\
  Face used for dashed lines around texts.  This face is overlayed
  on other text. Properties not defined by this face will be retained. 
  For example, if you only set the weight property, the colors 
  normally used will not be changed.")
    (kom-async-text-body-face-doc . "\
  Face used for messages.  This face is overlayed on other
  text. Properties not defined by this face will be retained. For
  example, if you only set the weight property, the colors normally
  used will not be changed.")
    (kom-async-dashed-lines-face-doc . "\
  Face used for dashed lines around messages.  This face is overlayed
  on other text. Properties not defined by this face will be retained. 
  For example, if you only set the weight property, the colors normally
  used will not be changed.")
    (kom-lynx-terminal-doc . "\
  Lynx can run inside emacs or in an xterm (or similar). This setting
  decides which.")
    (kom-lynx-terminal-command-doc . "\
  This is the command to use to start Lynx in emacs terminal-mode.
  It should be something simple, like \"lynx\".")
    (kom-lynx-xterm-command-doc . "\
  This is the command to use to start Lynx in an xterm. The command
  neets to start both the terminal emulator and lynx.")
    (kom-show-sync-messages-doc . "\
  When this is on, the client will display a message when the LysKOM
  server signals that it is saving the database.")
    (kom-highlight-conferences-doc . "\
  This setting controls display of conference names. For each choice
  it is possible to select a face. The value must be either a face or
  the name of a variable that contains a face.")
    (kom-netscape-variant-doc . "\
  This setting controls where the client opens URLs. How well the
  settings work depends on which variant of Netscape or Mozilla you
  are using, and even on which operating system you are on.")
    (kom-auto-confirm-new-conferences-doc . "\
  If this setting is on, the commands \"List new conferences\" and
  \"List new users\" will automatically mark new conferences and
  users as known.")
    (kom-text-properties-doc . "\
  If this setting is on, the client will display different types of
  things using different fonts and colors. For example, text numbers
  and other clickable things will be displayed using a special color.")
    (kom-fontify-text-doc . "\
  If this setting is on, words and phrases that are delimited by
  special characters will be shown in bold or italics. For example,
  words delimited by asterisks will be shown bold.")

    ;;
    ;; Tags for variables
    ;;

    (kom-ansaphone-replies-tag . "Automatic replies")
    (kom-bury-buffers-tag . "Bury buffers when changing LysKOM:")

  (kom-personal-messages-in-window-tag . "Personal messages:      ")
    (kom-customize-in-window-tag       . "LysKOM customization:   ")
    (kom-write-texts-in-window-tag     . "Author new texts:       ")
    (kom-prioritize-in-window-tag      . "Prioritize conferences: ")
    (kom-edit-filters-in-window-tag    . "Modify filters:         ")
    (kom-view-commented-in-window-tag  . "Review comments:        ")
    (kom-list-membership-in-window-tag . "List membership:        ")

    (kom-user-prompt-format-tag . "Prompt format:")
    (kom-user-prompt-format-executing-tag . "Prompt format when executing:")
    (kom-anonymous-prompt-format-tag . "Prompt format (anonymous):")
    (kom-anonymous-prompt-format-executing-tag . "Prompt format when executing (anonymous):")
    (kom-enabled-prompt-format-tag . "Prompt format (admin):")
    (kom-enabled-prompt-format-executing-tag . "Prompt format when executing (admin):")

    (kom-higher-priority-breaks-tag . 
"Read prioritized texts:                           ")
    (kom-created-texts-are-read-tag . 
"Automatically read created texts:                 ")
    (kom-default-mark-tag           . 
"Default mark:                                     ")
    (kom-print-number-of-unread-on-entrance-tag . 
"Show number of unread when entering a conference: ")
    (kom-follow-comments-outside-membership-tag .
"Follow comment chains outside membership:         ")
    (kom-show-footnotes-immediately-tag .
"Show footnotes immediately:                       ")
    (kom-membership-default-priority-tag . 
"Default priority for new memberships:             ")
   (kom-membership-default-message-flag-tag . 
"Receive group messages for new memberships:       ")
    (kom-dashed-lines-tag . 
"Dashed lines around the text body:                ")
    (kom-autowrap-tag . 
"Fill wide paragraphs before displaying:           ")
    (kom-autowrap-timeout-tag . 
"Maximum time spend filling paragraphs:            ")
    (kom-show-author-at-end-tag .
"Show the name of the author after the body:       ")

    (kom-truncate-threshold-tag .
"Truncate long texts:                              ")
    (kom-truncate-show-lines-tag .
"Lines to show of truncated texts:                 ")

    (kom-reading-puts-comments-in-pointers-last-tag . "Comment links are shown:")
    (kom-read-depth-first-tag . "Read order:")
    (kom-deferred-printing-tag . "Delayed display:")
    (kom-continuous-scrolling-tag . "Continuous scrolling:")

    (kom-presence-messages-in-echo-area-tag . 
"Presence messages in echo area:        ")
    (kom-presence-messages-in-buffer-tag .
"Presence messages in the LysKOM buffer:")
    (kom-page-before-command-tag . "Clear the screen:")

    (kom-remember-password-tag . "Remember LysKOM session password:")
    (kom-idle-hide-tag . 
"Number of minutes of inactivity before session is hidden:      ")
    (kom-show-where-and-what-tag . 
"Show where sessions are logged on from and what they are doing:    ")
    (kom-show-since-and-when-tag . 
"Show when sessions connected and how long they have been inactive: ")



    (kom-login-hook-tag . "Commands executed after logging on:")
    (kom-do-when-done-tag . "Commands to execute after reading everything:")
    (kom-permissive-completion-tag . "Fussy name completion:")
    (kom-show-personal-messages-in-buffer-tag . 
"Where are messages shown: ")
    (kom-pop-personal-messages-tag . 
"Pop up message buffer:    ")
    (kom-default-message-recipient-tag . 
"Default message recipient:")

    (kom-audio-player-tag . "Audio player program:")
    (kom-ding-on-new-letter-tag        . "When a letter arrives:            ")
    (kom-ding-on-priority-break-tag    . "When a prioritized text arrives:  ")
    (kom-ding-on-wait-done-tag         . "When done waiting:                ")
    (kom-ding-on-common-messages-tag   . "When a public message arrives:    ")
    (kom-ding-on-group-messages-tag    . "When a group message arrives:     ")
    (kom-ding-on-personal-messages-tag . "When a personal message arrives:  ")
    (kom-ding-on-no-subject-tag     .    "When you forget the subject line: ")

    (kom-filter-outgoing-messages-tag . "Show automatic messages:")
    (kom-friends-tag . "Friends and other special people:")
    (kom-morons-tag . "Morons and other \"special\" people:")
    (kom-url-viewer-preferences-tag . "Open URLs using the following program:")
    (kom-windows-browser-command-tag . "Command to start a web browser on Windows:")
    (kom-mosaic-command-tag . "Command to start NCSA Mosaic:")
    (kom-netscape-command-tag . "Command to start Netscape/Mozilla:")
    (kom-galeon-command-tag . "Command to start Galeon:")

    (kom-symbolic-marks-alist-tag . "Symbolic mark types:")

    (kom-cite-string-tag . "Quotation indicator:")
    (kom-confirm-multiple-recipients-tag . 
"Confirm multiple recipients:         ")
    (kom-check-commented-author-membership-tag . 
"Check membership of commented author:")
    (kom-check-for-new-comments-tag . 
"Check for unread comments:           ")

    (kom-ansaphone-record-messages-tag . 
"Save messages when auto reply is on:    ")
    (kom-ansaphone-show-messages-tag . 
"Display messages when auto reply is on: ")
    (kom-ansaphone-default-reply-tag . "Auto reply message:")


    (kom-inhibit-typeahead-tag . "Buffer keypresses:")
    (kom-max-buffer-size-tag . "Maximum buffer size:")

    (kom-remote-control-tag .     "Remote commands on or off:             ")
    (kom-self-control-tag .       "Allow me to use remote commands:       ")
    (kom-remote-controllers-tag . "People allowed to use remove commands:")

    (kom-customize-format-tag . "Show documentation for all settings:")
    (kom-default-language-tag . "Language list:")
    (kom-show-namedays-tag    . "Show today's names:")
    (kom-ispell-dictionary-tag . "Spelling dictionary:")

    (kom-show-week-number-tag . "Show week number:")
    (kom-relogin-behaviour-tag . "Reattach automatically:")
    (kom-relogin-inhibit-commands-tag . "Commands for which reattachment is inhibited:")
    (kom-membership-default-placement-tag . "Placement of new memberships:")
    (kom-show-imported-importer-tag . "Show importer of imported messages:")
    (kom-show-imported-envelope-sender-tag . "Show sender of imported messages:")
    (kom-show-imported-external-recipients-tag . "Show external recipients of imported messages:")
    (kom-show-imported-message-id-tag . "Show message-id of imported messages:")
    (kom-agree-text-tag . "Default text for Agree:")
    (kom-silent-ansaphone-tag . "Beep when auto reply is on:")
    (kom-default-session-priority-tag . "Default session priority:")
    (kom-unsubscribe-makes-passive-tag . "Leaving a conference converts membership to passive:")
    (kom-review-priority-tag . "Priority for review commands:")
    (kom-show-creating-software-tag . "Show creating software:")
    (kom-text-footer-format-tag . "Text footer format:")
    (kom-long-lines-tag . "Long dashed lines:")
    (kom-postpone-default-tag . "Default number of texts to postpone:")
    (kom-allow-incompleteness-tag . "Allow incomplete information about unread texts:")
    (kom-smileys-tag . "Show smileys graphically:")
    (kom-ignore-message-senders-tag . "Don't show messages from:")
    (kom-ignore-message-recipients-tag . "Don't show messages to:")
    (kom-text-footer-dash-length-tag . "Text footer length:")
    (kom-text-header-dash-length-tag . "Length of dashed line before text:")
    (kom-show-personal-message-date-tag . "Show date and time of messages:")
    (kom-w3-simplify-body-tag . "Display HTML without document colors:")
    (kom-mercial-tag . "Text to display when all is read:")
    (kom-session-nickname-tag . "How session name is determined:")
    (kom-server-priority-tag . "Session priority:")
    (kom-server-priority-breaks-tag . "Prompt to go to next LysKOM:")
    (kom-complete-numbers-before-names-tag . "Read conference numbers before names:")
    (kom-keep-alive-interval-tag . "Keep connection alive interval:")
    (kom-text-no-prompts-tag . "How commands prompt for text numbers:")
    (kom-saved-file-name-tag . "File to archive texts in:")
    (kom-follow-attachments-tag . "Read imported attachments as texts:")
    (kom-show-unread-in-frame-title-tag . "Show unread indicator in title bar:")
    (kom-unread-mode-line-type-tag . "How unread texts are indicated in the mode line:")
    (kom-created-texts-are-saved-tag . "Save created texts:")
    (kom-confirm-add-recipients-tag . "Ask if comments should be sent to new recipients:")
    (kom-trim-buffer-minimum-tag . "How small parts of the LysKOM buffer are trimmed:")
    (kom-dont-check-commented-authors-tag . "Authors not to check:")
    (kom-print-relative-dates-tag . "Show relative dates:")
    (kom-print-seconds-in-time-strings-tag . "Include seconds in time strings:")
    (kom-review-uses-cache-tag . "Review commands use cached texts:")
    (kom-review-marks-texts-as-read-tag . "Review commands mark texts as read:")
    (kom-auto-review-faqs-tag . "Review new FAQs automatically:")
    (kom-auto-list-faqs-tag . "List new FAQs automatically:")
    (kom-extended-status-information-tag . "Extended status information:")
    (kom-highlight-first-line-tag . "Color first line:")
    (kom-highlight-dashed-lines-tag . "Color dashed lines:")
    (kom-highlight-text-body-tag . "Color text backgrounds:")
    (kom-async-highlight-dashed-lines-tag . "Color dashed lines around messages:")
    (kom-async-highlight-text-body-tag . "Color message backgrounds:")
    (kom-edit-hide-add-button-tag . "Show add button when writing texts:")
    (kom-format-html-authors-tag . "Format HTML-messages per author:")
    (kom-format-show-images-tag . "Show texts with images as images:")
    (kom-keyboard-menu-immediate-selection-tag . "Shortcuts in text menus require confirmation:")
    (kom-max-overlays-tag . "Maximum number of overlays:")
    (kom-mark-read-texts-as-read-in-new-recipient-tag . "Mark read texts read when added to new recipients:")
    (kom-url-transformation-rules-tag . "Transformation of URLs:")
    (kom-text-links-tag . "Text links:")

    (kom-active-face-tag . "Other clickable areas:")
    (kom-active-highlight-face-tag . "Highlighted clickable areas:")
    (kom-active-strikethrough-face-tag . "Struck-through clickable areas:")
    (kom-url-face-tag . "Clickable URLs:")
    (kom-me-face-tag . "My own name:")
    (kom-highlight-face-tag . "Mouseover highlight:")
    (kom-subject-face-tag . "Subject lines:")
    (kom-text-no-face-tag . "Text numbers:")
    (kom-friends-face-tag . "Friends and other special people:")
    (kom-morons-face-tag . "Morons and other \"special\" people:")
    (kom-presence-face-tag . "Presence messages:")
    (kom-first-line-face-tag . "First header line:")
    (kom-warning-face-tag . "Important warnings:")
    (kom-mark-face-tag . "Various marks:")
    (kom-dim-face-tag . "Various discreet texts:")
    (kom-text-body-face-tag . "Text bodies:")
    (kom-dashed-lines-face-tag . "Dashed lines around texts:")
    (kom-async-text-body-face-tag . "Messages:")
    (kom-async-dashed-lines-face-tag . "Dashed lines around messages:")
    (kom-lynx-terminal-command-tag . "Command to run lynx in emacs:")
    (kom-lynx-terminal-tag . "Where to run lynx:")
    (kom-lynx-xterm-command-tag . "Command to run lynx in xterm:")
    (kom-show-sync-messages-tag . "Show database-saving message:")
    (kom-highlight-conferences-tag . "Display of names::")
    (kom-netscape-variant-tag . "Where Netscape/Mozilla opens URLs:")
    (kom-auto-confirm-new-conferences-tag . "Always mark new conferences as known:")
    (kom-text-properties-tag . "Use fonts and colors:")
    (kom-fontify-text-tag . "Bold and italic fonts in texts:")
    )
)






;;;; ============================================================
;;;; The default Ansaphone message goes here. The more complex 
;;;; message specification probably should too, but it's not here
;;;; yet. People who know how to use it are smart enough to do it
;;;; right.

(lyskom-language-var local kom-ansaphone-default-reply en 
  "I am not reading LysKOM right now. Please write a letter instead.")
        
;;;; ============================================================
;;;; Other language-dependent variables
;;;;

(lyskom-language-var local kom-ispell-dictionary en
  "english")



;;;; ================================================================
;;;; Tell phrases should be configured with the default language used
;;;; at the server and not for person reading if they happens to
;;;; differ. This is of course because they are sent to the server for
;;;; everybody else to see.

;;;; Aronsson was here 4 DEC 1990, thus creating version 0.18
					; Created *-tell-*


;;; To coders of the elisp-client:
;;; You not only have to change the text here, you also have to modify
;;; kom-tell-phrases-validation-list in vars.el if you add or remove
;;; one of these.

(eval-when-compile (defvar kom-tell-phrases))

(lyskom-language-strings local kom-tell-phrases en
  '((kom-tell-silence		. "") ; Why ?
    (kom-tell-send		. "Is trying to post a text.")
    (kom-tell-login		. "Is entering LysKOM.")
    (kom-tell-read		. "Is reading.")
    (kom-tell-1st-pres		. "Is writing the first presentation.")
    (kom-tell-write-comment	. "Is writing a comment.")
    (kom-tell-write-footnote	. "Is writing a footnote.")
    (kom-tell-write-letter	. "Is writing a letter.")
    (kom-tell-write-reply	. "Is writing a personal reply.")
    (kom-tell-write-text	. "Is writing a text.")
    (kom-tell-conf-pres		. "Is writing the presentation for a new conference.")
    (kom-tell-recover		. "Is restarting KOM. Sigh.")
    (kom-tell-wait		. "Is waiting.")
    (kom-tell-regret		. "Decides to throw away the text.")
    (kom-tell-review		. "Is reviewing.")
    (kom-tell-change-name       . "Takes on a new name.")
    (kom-tell-change-supervisor . "Changes the supervisor of something.")
    (kom-tell-next-lyskom	. "Moves to a different LysKOM.")))

(if (and (boundp 'kom-tell-phrases)
         kom-tell-phrases)
    (lyskom-language-strings local kom-tell-phrases en
      (mapcar (function 
               (lambda (x)
                 (cond ((and (consp x)
                             (symbolp (car x))
                             (stringp (cdr x))) x)
                       ((and (consp x)
                             (symbolp (car x))
                             (consp (cdr x))
                             (stringp (car (cdr x))))
                        (cons (car x) (car (cdr x))))
                       (t nil))))
              kom-tell-phrases)))


;; Placed here because this must NOT be evaluated before 
;; kom-tell-phrases is defined:

(lyskom-language-var local kom-mercial en (lyskom-get-string 'kom-tell-wait 
                                                       'kom-tell-phrases))


(lyskom-language-strings local lyskom-error-texts en
  '((error-0 . "No error")
    (error-2 . "Not yet implemented by the server")
    (error-3 . "No longer implemented by the server")
    (error-4 . "Wrong password")
    (error-5 . "String too long")
    (error-6 . "You have not logged on")
    (error-7 . "Nobody may enter LysKOM at this time")
    (error-8 . "You attempted to use conference number 0")
    (error-9 . "Undefined or secret conference")
    (error-10 . "Undefined or secret user")
    (error-11 . "No read or write permission")
    (error-12 . "Illegal operation")
    (error-13 . "You are not a member of that conference")
    (error-14 . "There is no text with that number")
    (error-15 . "You cannot use global text number 0")
    (error-16 . "There is no text with that local number")
    (error-17 . "You cannot use local text number 0")
    (error-18 . "Name too short, too long or containing illegal characters")
    (error-19 . "Index out of bounds")
    (error-20 . "The conference already exists")
    (error-21 . "The user already exists")
    (error-22 . "Secret but not read-protected")
    (error-23 . "You are not allowed to change the person/conference flag")
    (error-24 . "Error in the database. Tough luck.")
    (error-25 . "Invalid recipient or comment type")
    (error-26 . "Illegal info type. (Bug in the client)")
    (error-27 . "Already recipient of this text")
    (error-28 . "Already comment to this text")
    (error-29 . "Already footnote to this text")
    (error-30 . "Not a recipient of this text")
    (error-31 . "Not a comment to this text")
    (error-32 . "Not a footnote to this text")
    (error-33 . "Too many recipients")
    (error-34 . "Too many commentsp")
    (error-35 . "Too many footnotes")
    (error-36 . "Too many marks")
    (error-37 . "You are not the author of that text")
    (error-38 . "You cannot connect to the server")
    (error-39 . "Out of memory")
    (error-40 . "The server is gone crazy")
    (error-41 . "The client thinks that the server says that it does not understand the client")
    (error-42 . "No such session")
    (error-43 . "Invalid regular expression")
    (error-44 . "Can't unmark a text that was not marked")
    (error-45 . "Temorary lossage. Please try again later")
    (error-46 . "Sending huge messages to the server is not a nice thing to do")
    (error-47 . "Anonymous texts are not accepted by all recipients")
    (error-48 . "Invalid property")
    (error-49 . "Change of property not permitted")
    (error-50 . "Unknown asynchronous message")
    (error-51 . "Internal server error")
    (error-52 . "Feature disabled in the server")
    (error-53 . "Unable to send message")
    (error-54 . "Invalid membership type")
    (error-55 . "Invalid range")
    (error-56 . "Invalidrange list")
    (error-57 . "Undefined measurement")
    (error-58 . "Priority denied")
    (error-59 . "Weight denied")
    (error-60 . "Zero weight")
    (error-61 . "Invalid boolean value")

    (error--1 . "You are not a member of any recipient")
))

(lyskom-language-var global lyskom-unread-mode-line en
  (lyskom-make-lyskom-unread-mode-line))

(lyskom-language-var global lyskom-unread-title-format en
  (lyskom-make-lyskom-unread-title-format))

(lyskom-language-var local lyskom-help-data en lyskom-en-help-data)


(provide 'lyskom-strings)

;;; english-strings ends here

(defvar lyskom-en-help-data (quote ((language-help "" (section ((id . "language-help") (prompt . "")) ((h2 nil ((TEXT . "Language Settings"))) (p nil ((TEXT . " You can switch the language in this session by using the command ") (cref ((id . "kom-change-language")) nil) (TEXT . " or the Emacs command ") (i nil ((TEXT . "M-x kom-change-language"))) (TEXT . ". To also change the key bindings (this will affect all sessions), type C-u before the command (e.g. C-u x") (cref ((id . "kom-change-language")) nil) (TEXT . "). "))) (p nil ((TEXT . " For full information, including how to change the default language, see ") (refer ((id . "language")) nil) (TEXT . " (this information will be presented using the current language selection). ")))))) (language "Language" (section ((id . "language") (prompt . "Language")) ((h1 nil ((TEXT . "Multiple language support"))) (p nil ((TEXT . " The elisp client can be built to support multiple languages. The default is to build with support for english and swedish, with english as the default language selection. "))) (h2 nil ((TEXT . "Temporary Language Change"))) (p nil ((TEXT . " Use ") (cref ((id . "kom-change-language")) nil) (TEXT . " to temporarily switch languages. Please note that you must give a prefix argument to ") (cref ((id . "kom-change-language")) nil) (TEXT . " to change the key binding. Key bindings are changed in ") (i nil ((TEXT . "all"))) (TEXT . " sessions, not just the one where the command is given. "))) (h2 nil ((TEXT . "Permanent Language Change"))) (p nil ((TEXT . " Use ") (cref ((id . "kom-customize")) nil) (TEXT . " to change languages permanently. By saving the language selection in .emacs, that language will be the default the next time you start Emacs and load the elisp client. "))) (h2 nil ((TEXT . "Changing the default language"))) (p nil ((TEXT . " There are a number of ways to change the default language in the elisp client. The client looks at the following, in order, until it finds a useful setting: "))) (list nil ((item nil ((TEXT . "The variable kom-default-language (change it with ") (cref ((id . "kom-customize")) nil) (TEXT . ")"))) (item nil ((TEXT . "The environment variable KOMLANGUAGE"))) (item nil ((TEXT . "The environment variable LC_ALL"))) (item nil ((TEXT . "The environment variable LC_MESSAGES"))) (item nil ((TEXT . "The environment variable LANG"))))) (p nil ((TEXT . " The variable kom-default-language can be set to a list of symbols, where each symbol corresponds to a language. Se the list below for available languages. The first language on the list that is supported by the client will be used. "))) (p nil ((TEXT . " The environment variables should be set to a language code. For example, the value \"sv\" will cause the client to use Swedish. "))) (h2 nil ((TEXT . "Known languages"))) (list nil ((item nil ((TEXT . "sv - Swedish"))) (item nil ((TEXT . "en - English")))))))) (conferences "Conferences" (section ((id . "conferences") (prompt . "Conferences")) ((h1 nil ((TEXT . "Conferences"))) (p nil ((TEXT . " Every LysKOM system is organized as a set of conferences, each covering a separate topic. Anybody can create a conference, but you should think twice before doing so. In a mature LysKOM system the conference you want to create probably already exists. "))) (p nil ((TEXT . " Conferences can be open, closed and secret. Anyone can join and read texts in all open conferences. To join a closed conference, the conference administractor has to grant membership. Secret conferences are secret: you can't even see them unless you're a member. Most conferences are open. Closed and secret conferences are much less common. "))) (p nil ((TEXT . " The following commands might be useful to get started: "))) (inline ((id . "kom-list-conferences")) nil) (inline ((id . "kom-review-presentation")) nil) (inline ((id . "kom-add-self")) nil) (inline ((id . "kom-go-to-conf")) nil) (h2 nil ((TEXT . "Priorities"))) (p nil ((TEXT . " Your memberships have priorities. When you log on, conferences with higher priority will be presented before conferences with lower priority. Use ") (cref ((id . "kom-prioritize")) nil) (TEXT . " to change your priorities. ")))))) (persons "Persons" (section ((id . "persons") (prompt . "Persons")) ((h1 nil ((TEXT . "Persons"))) (p nil ((TEXT . " Every LysKOM user has a person. A person contains some statistics about what the user has done (texts created, texts read, logon time, and some other stuff). Every person is also associated with a letterbox with the same name of the person. The letterbox is essentially a regular closed conference. ")))))) (texts "Texts" (section ((id . "texts") (prompt . "Texts")) ((h1 nil ((TEXT . "Texts"))) (p nil ((TEXT . " The purpose of LysKOM is to communicate, and communication is done through texts. Texts are simply texts written by a LysKOM member. "))) (h2 nil ((TEXT . "Recipients"))) (p nil ((TEXT . " Every text has one or more recipients: conferences to which the text has been sent. There are three kinds of recipients: regular recipients, cc-recipients and bcc-recipients. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "Regular recipients"))) (TEXT . " are the most common. A regular recipient means that the text belongs in the specified conference (or conferences). Comments to the text will automatically be sent to the same set of recipients. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "CC recipients"))) (TEXT . " are used when you want to send a copy of a text to a conference, but don't want followups sent to that conference. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "BCC recipients"))) (TEXT . " are fairly unusual. To even ") (i nil ((TEXT . "see"))) (TEXT . " a BCC recipient you have to have permission to be a member in the recipient conference. This kind of recipient can be used when you want to send a copy of a text to somebody's letterbox, but don't want other readers to know. "))) (h2 nil ((TEXT . "Comments"))) (p nil ((TEXT . " A text can have comments. A thread of comments to comments to comments is often called comment thread, comment chain or comment tree (strictly speaking a comment thread is a path down the comment tree). Anyone can write comments to any text. There is not requirement that comments be sent to the same conferences as the commented texts. "))) (h2 nil ((TEXT . "Special texts"))) (p nil ((TEXT . " There are three kinds of special texts: presentations, FAQs and notices. A presentation is a text associated with a conference or letterbox, that contains a presentation of that conference or person. These are normally sent to special conferences. A FAQ is a text with frequently asked questions (and answers) in a particular conference. Normally, new FAQs will be displayed when entering the associated conference. Notices are texts that contain urgent information about a person or conference. You can use a notice when you will be away from LysKOM for a while, and similar occasions. ")))))) (settings "Settings" (section ((id . "settings") (prompt . "Settings")) ((h1 nil ((TEXT . "Settings"))) (p nil ((TEXT . " The elisp client has a large number of user-configurable settings. With a few exceptions you can change these by using the command ") (cref ((id . "kom-customize")) nil) (TEXT . ". "))) (p nil ((TEXT . " Settings can be saved in the server or in your .emacs. Settings that are saved in the server will apply only for a particular user on a particular server. Settings saved in .emacs take precedence over settings stored in the server. ")))))) (reading "Reading texts" (section ((id . "reading") (prompt . "Reading texts")) ((h1 nil ((TEXT . "Reading texts"))) (p nil ((TEXT . " To just read texts in the default order, simply press SPC until all texts have been displayed. The elisp client will display one text at a time until you have read all texts in all conferences you are a member of. Use the command ") (cref ((id . "kom-list-summary")) nil) (TEXT . " to see which texts will be shown. There are a large number of more advanced commands, some of which are listed in the sections mentioned below. "))) (list ((header . "See also:")) ((item nil ((refer ((id . "filter")) nil))) (item nil ((refer ((id . "review")) nil))) (item nil ((refer ((id . "mark")) nil)))))))) (filter "Avoiding certain texts" (section ((id . "filter") (prompt . "Avoiding certain texts")) ((h1 nil ((TEXT . "Avoiding certain texts"))) (p nil ((TEXT . " Sometimes you don't want to read certain texts. In those cases the following commands may be useful. Besides these, there are a number of commands for filtering texts, if there is a certain type of text you never want to see. "))) (inline ((id . "kom-set-unread")) nil) (inline ((id . "kom-jump")) nil) (inline ((id . "kom-super-jump")) nil)))) (mark "Remembering texts" (section ((id . "mark") (prompt . "Remembering texts")) ((h1 nil ((TEXT . "Remembering texts"))) (p nil ((TEXT . " Sometimes you might find a text that you want to remember. In these cases, mark the text. A mark is really just a number from 0 to 255, but the elisp client supports assigning easy-to-remember names to marks. "))) (inline ((id . "kom-mark-text")) nil) (inline ((id . "kom-unmark-text")) nil) (inline ((id . "kom-review-all-marked-texts")) nil) (inline ((id . "kom-review-marked-texts")) nil) (inline ((id . "kom-list-marks")) nil)))) (review "Finding old texts" (section ((id . "review") (prompt . "Finding old texts")) ((h1 nil ((TEXT . "Finding old texts"))) (p nil ((TEXT . " There are a large number of commands for finding old texts. All of these start with the word \"Review\". This is just a small sampling: "))) (inline ((id . "kom-review-by-to")) nil) (inline ((id . "kom-review-first")) nil) (inline ((id . "kom-review-more")) nil) (inline ((id . "kom-review-clear")) nil) (inline ((id . "kom-view-commented-text")) nil) (inline ((id . "kom-review-comments")) nil) (inline ((id . "kom-find-root-review")) nil) (inline ((id . "kom-find-root")) nil) (inline ((id . "kom-review-tree")) nil)))) (writing "Writing or changing texts" (section ((id . "writing") (prompt . "Writing or changing texts")) ((h1 nil ((TEXT . "Writing or changing texts"))) (p nil ((TEXT . " There are three basic types of texts: texts, comments and footnotes. All of them are texts, but they are associated to ") (i nil ((TEXT . "other"))) (TEXT . " texts in different ways. "))) (h2 nil ((TEXT . "Texts"))) (p nil ((TEXT . " These are texts that aren't comments to other texts. They start a new thread of discussion. Remember to choose a good subject line when you create new texts. "))) (inline ((id . "kom-write-text")) nil) (inline ((id . "kom-send-letter")) nil) (h2 nil ((TEXT . "Comments"))) (p nil ((TEXT . " Comments are texts that are comments to other texts. When you write a comment, check that the subject line and recipients are still suitable. Personal replies are simply comments sent to somebody's letterbox. "))) (inline ((id . "kom-write-comment")) nil) (inline ((id . "kom-private-answer")) nil) (h2 nil ((TEXT . "Footnotes"))) (p nil ((TEXT . " Footnotes are special comments that only the author of a text can create. Since they are presented before regular comments, they are useful when you want to clarify something you've written before people start writing comments to the text. "))) (inline ((id . "kom-write-footnote")) nil) (h2 nil ((TEXT . "Prefix argument"))) (p nil ((TEXT . " There are several ways to specify which text you want to comment or write a footnote to. When you give any of the comments listed above without an argument, they will apply to the most recenty read text. "))) (p nil ((TEXT . " Sometimes you want a different text. There are a few commands that apply to the next-to-most-recently read (") (cref ((id . "kom-comment-previous")) nil) (TEXT . ", ") (cref ((id . "kom-private-answer-previous")) nil) (TEXT . "), and by using prefix arguments you can specify any text to any command. Supply a prefix argument as usual in Emacs by C-u followed by the argument, or simply type the argument directly. "))) (p nil ((TEXT . " Specify text ") (i nil ((TEXT . "N"))) (TEXT . " by giving the text number as the prefix argument. Specify the text where the cursor is by giving prefix argument 0. Specify the text ") (i nil ((TEXT . "N"))) (TEXT . " texts back in the buffer from the point where the cursor is by giving the prefix argument -") (i nil ((TEXT . "N"))) (TEXT . ". To get a prompt at which you can type the text number, simply hit C-u before giving the command. "))) (h2 nil ((TEXT . "Manage recipients"))) (p nil ((TEXT . " To change the recipients on a text you have to be the author of the text or administrator of the recipient you want to change. Use the commands ") (cref ((id . "kom-add-recipient")) nil) (TEXT . " to add and ") (cref ((id . "kom-sub-recipient")) nil) (TEXT . " to remove recipients. "))) (h2 nil ((TEXT . "Messages and remarks"))) (p nil ((TEXT . " Never use messages (personal, group or alarm messages) or remarks in place of regular texts. It won't work and people will get upset. ")))))) (kom-list-conferences "" (section ((id . "kom-list-conferences") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-conferences")) nil))) (p nil ((TEXT . " List conferences in LysKOM. Use this command with creative arguments to find conferences that you're interested in. ")))))) (kom-list-re "" (section ((id . "kom-list-re") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-re")) nil))) (p nil ((TEXT . " List conferences in LysKOM. Use this command with creative arguments to find conferences that you're interested in. ")))))) (kom-review-presentation "" (section ((id . "kom-review-presentation") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-presentation")) nil))) (p nil ((TEXT . " Show the presentation for a conference or person. Use this command to get more information about a conference. ")))))) (kom-add-self "" (section ((id . "kom-add-self") (prompt . "")) ((h3 nil ((cref ((id . "kom-add-self")) nil))) (p nil ((TEXT . " Join a conference so you can read the texts in the conference and so you'll find out when new texts are created. ")))))) (kom-go-to-conf "" (section ((id . "kom-go-to-conf") (prompt . "")) ((h3 nil ((cref ((id . "kom-go-to-conf")) nil))) (p nil ((TEXT . " Go to a conference you want to read texts in. If you aren't already a member of the conference, you will be asked if you want to join the conference. ")))))) (kom-write-footnote "" (section ((id . "kom-write-footnote") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-footnote")) nil))) (p nil ((TEXT . " Creates a new footnote to an existing text. ")))))) (kom-private-answer "" (section ((id . "kom-private-answer") (prompt . "")) ((h3 nil ((cref ((id . "kom-private-answer")) nil))) (p nil ((TEXT . " Creates a private reply to the author of an existing text. ")))))) (kom-write-comment "" (section ((id . "kom-write-comment") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-comment")) nil))) (p nil ((TEXT . " Creates a new comment to an existing text. ")))))) (kom-send-letter "" (section ((id . "kom-send-letter") (prompt . "")) ((h3 nil ((cref ((id . "kom-send-letter")) nil))) (p nil ((TEXT . " Creates a new letter. ")))))) (kom-write-text "" (section ((id . "kom-write-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-text")) nil))) (p nil ((TEXT . " Creates a new text that is not a comment to any other text. ")))))) (kom-review-tree "" (section ((id . "kom-review-tree") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-tree")) nil))) (p nil ((TEXT . " Reviews the entire tree of comments under the specified text. ")))))) (kom-find-root "" (section ((id . "kom-find-root") (prompt . "")) ((h3 nil ((cref ((id . "kom-find-root")) nil))) (p nil ((TEXT . " Finds the text that started the discussion that the specified text is part of. ")))))) (kom-find-root-review "" (section ((id . "kom-find-root-review") (prompt . "")) ((h3 nil ((cref ((id . "kom-find-root-review")) nil))) (p nil ((TEXT . " Reviews the entire tree of comments that the specified text is part of. Essentially the same as doing ") (cref ((id . "kom-find-root")) nil) (TEXT . " followed by ") (cref ((id . "kom-review-tree")) nil) (TEXT . ". ")))))) (kom-review-comments "" (section ((id . "kom-review-comments") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-comments")) nil))) (p nil ((TEXT . " Reviews all comments to the specified text, but not the comments to the comments. ")))))) (kom-view-commented-text "" (section ((id . "kom-view-commented-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-view-commented-text")) nil))) (p nil ((TEXT . " Reviews the text to which the specified text is a comment. ")))))) (kom-review-clear "" (section ((id . "kom-review-clear") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-clear")) nil))) (p nil ((TEXT . " Aborts all review commands that are active. ")))))) (kom-review-more "" (section ((id . "kom-review-more") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-more")) nil))) (p nil ((TEXT . " Reviews more texts using the same criteria as the most recent ") (cref ((id . "kom-review-by-to")) nil) (TEXT . ", or ") (cref ((id . "kom-review-first")) nil) (TEXT . " command. ")))))) (kom-review-first "" (section ((id . "kom-review-first") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-first")) nil))) (p nil ((TEXT . " Reviews the first text(s) created by a particular person sent to a particular conference. Any parameter can be ignored by simply not supplying a value (use zero for the number of texts) in order to do things like review all texts to a particular conference, the first five texts written by a particular person and so forth. ")))))) (kom-review-by-to "" (section ((id . "kom-review-by-to") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-by-to")) nil))) (p nil ((TEXT . " Reviews the text(s) most recently created by a particular person sent to a particular conference. Any parameter can be ignored by simply not supplying a value (use zero for the number of texts) in order to do things like review all texts to a particular conference, the last five texts written by a particular person and so forth. ")))))) (kom-list-marks "" (section ((id . "kom-list-marks") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-marks")) nil))) (p nil ((TEXT . " Lists all texts marked with a particular mark. ")))))) (kom-review-marked-texts "" (section ((id . "kom-review-marked-texts") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-marked-texts")) nil))) (p nil ((TEXT . " Reviews all texts marked with a particular mark. ")))))) (kom-review-all-marked-texts "" (section ((id . "kom-review-all-marked-texts") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-all-marked-texts")) nil))) (p nil ((TEXT . " Reviews all marked texts. ")))))) (kom-unmark-text "" (section ((id . "kom-unmark-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-unmark-text")) nil))) (p nil ((TEXT . " Removes your marks from a texts. ")))))) (kom-mark-text "" (section ((id . "kom-mark-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-mark-text")) nil))) (p nil ((TEXT . " Marks a texts. Normally this command will ask for the mark to use. ")))))) (kom-super-jump "" (section ((id . "kom-super-jump") (prompt . "")) ((h3 nil ((cref ((id . "kom-super-jump")) nil))) (p nil ((TEXT . " Creates a filter that will skip texts that have the same subject line as the specified text and are sent to the current conference. ")))))) (kom-jump "" (section ((id . "kom-jump") (prompt . "")) ((h3 nil ((cref ((id . "kom-jump")) nil))) (p nil ((TEXT . " Skips all texts in the comment tree below the most recently read text. This is useful when you see a text that starts a discussion that you aren't interested in. ")))))) (kom-set-unread "" (section ((id . "kom-set-unread") (prompt . "")) ((h3 nil ((cref ((id . "kom-set-unread")) nil))) (p nil ((TEXT . " Set the number of unread texts in a particular conference. Can be useful when you have lots of old texts to catch up with. ")))))) (kom-prioritize "" (section ((id . "kom-prioritize") (prompt . "")) ((h3 nil ((cref ((id . "kom-prioritize")) nil))) (p nil ((TEXT . " Interactively change priorities and placements of your memberships. For more information, press C-h m or ? when you have given the command. ")))))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: komtypes.el,v 44.42 2004/07/20 19:28:10 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; This file contains primitives for the different data types
;;;; in the lyskom system. All types here have their origin in
;;;; the server. Compare the file clienttypes.el.
;;;;
;;;; Author: ceder
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: komtypes.el,v 44.42 2004/07/20 19:28:10 byers Exp $\n"))


;;; ============================================================
;;; Black magic...

(defmacro def-komtype (type args &rest flags)
  "Define a new type named TYPE with fields ARGS and documentation DOC.
TYPE is the name of the new type; a symbol.
ARGS is a list of arguments. Each element can be a symbol or a cons whose
car is the name of the field and the cdr is a property list for the field.

The special symbol &optional indicates start of fields that will be
optional in the constructor argument list.

Legal fiels properties are:

:default val        In the constructor, if the value supplied for the 
                    field is nil, use VAL instead.
:read-only t        Do not create a mutator. Note that t must be specified.
:automatic val      Do not include field in constructor. Use VAL for
                    the initial field value.
:filter code        Use CODE as a filter for the field value supplied to
                    the constructor.

Only one of :automatic, :filter or :default may be supplied.


Optional FLAGS are additional modifiers.

If :nil-safe is included, then calling accessors on nil object will
return nil and not signal an error.

If :create-hook HOOK is included, HOOK will be inserted into the
constructor function. When HOOK is evaluated, OBJECT (uppercase) is
bound to the newly created object. It may be modified.
"
  (let ((accessors nil)
        (mutators nil)
        (predicate nil)
        (constructor nil)
        (access-method 'aref)
        (type-sym (intern (upcase (symbol-name type))))
        (constructor-body nil)
        (create-hook nil))

    (while flags
      (cond ((eq (car flags) ':nil-safe) (setq access-method 'elt))
            ((eq (car flags) ':create-hook)
             (setq flags (cdr flags))
             (setq create-hook (car flags))))
      (setq flags (cdr flags)))

    ;; Create constructor

    (setq constructor-body
          `(cons ',type-sym
                 (vector
                  ,@(delq '&optional
                          (mapcar 
                           (lambda (arg)
                             (cond ((plist-member (cdr-safe arg) ':automatic)
                                    (plist-get (cdr-safe arg) ':automatic))
                                   ((plist-member (cdr-safe arg) ':filter)
                                    (plist-get (cdr-safe arg) ':filter))
                                   ((plist-get (cdr-safe arg) ':default)
                                    `(or ,(car arg) ,(plist-get (cdr arg) :default)))
                                   (t (or (car-safe arg) arg))
                                   ))
                           args)))))

    (when create-hook
      (setq constructor-body
            `(let ((OBJECT ,constructor-body))
               ,create-hook
               OBJECT)))

    (setq constructor
          `(defsubst ,(intern (format "lyskom-create-%S" type))
             ,(delq nil (mapcar (lambda (arg)
                                  (unless (plist-member (cdr-safe arg) ':automatic)
                                    (or (car-safe arg) arg)))
                                args))
             ,(format "Create a `%S' from arguments.
Automatically created with def-komtype." type)
             ,constructor-body))

    ;; Create predicate

    (setq predicate
        `(defsubst ,(intern (format "lyskom-%S-p" type)) (obj)
           ,(format "Return non-nil if OBJ is a %S
Automatically created with def-komtype" type)
           (and (consp obj) (eq (car obj) ',type-sym))))

    ;; Create accessors and mutators

    (let ((field-index 0))
      (mapcar
       (lambda (arg)
         (unless (eq arg '&optional)
           (let ((field (or (car-safe arg) arg)))
             (setq accessors
                   (cons `(defsubst ,(intern (format "%S->%S" type field)) (obj)
                            (lyskom-assert (or (null obj) (,(intern (format "lyskom-%S-p" type)) obj))
                                           "Assertion failed in %s: got %S" ,(format "%S->%S" type field) obj)
                            ,(format "Return field `%s' from OBJ." field)
                            (,access-method (cdr obj) ,field-index))
                         accessors))
             (unless (plist-get (cdr-safe arg) ':read-only)
               (setq mutators
                     (cons `(defsubst ,(intern (format "set-%S->%S" type field)) (obj val)
                              (lyskom-assert (or (null obj) (,(intern (format "lyskom-%S-p" type)) obj))
                                             "Assertion failed in %s: got %S" ,(format "%S->%S" type field) obj)
                              ,(format "Set field `%s' of OBJ to VAL." field)
                              (aset (cdr obj) ,field-index val))
                           mutators))))
           (setq field-index (1+ field-index))))
       args))

    ;; Return the forms

    `(progn ,constructor
            ,predicate
            ,@accessors
            ,@mutators)))




;;; ================================================================
;;;                            conf-no-list


;;; Constructor:

(def-komtype conf-no-list 
  ((conf-nos :filter (cond ((vectorp conf-nos) (append conf-nos nil))
                           (t conf-nos))
             :read-only t))
  :nil-safe)


;;; ================================================================
;;;                            uconf-stat

(def-komtype uconf-stat 
  ((conf-no          :read-only t)
   name
   (conf-type        :read-only t)
   (highest-local-no :read-only t)
   (nice             :read-only t))
  :nil-safe)

;;; ================================================================
;;;                            conf-stat

;;; Constructor:

(def-komtype conf-stat 
  ((conf-no              :read-only t)
   name
   (conf-type            :read-only t)
   (creation-time        :read-only t)
   (last-written         :read-only t)
   (creator              :read-only t)
   (presentation)
   (supervisor           :read-only t)
   (permitted-submitters :read-only t)
   (super-conf           :read-only t)
   (msg-of-day)
   (garb-nice            :read-only t)
   (keep-commented       :read-only t)
   (no-of-members        :read-only t)
   (first-local-no       :read-only t)
   no-of-texts
   &optional
   (expire               :read-only t :default 0)
   (aux-items            :read-only t))
  :nil-safe)


;;; ================================================================
;;;                          conf-type.

(def-komtype conf-type
  ((rd_prot         :read-only t)
   (original        :read-only t)
   (secret          :read-only t)
   (letterbox       :read-only t)
   &optional 
   (anarchy         :read-only t)
   (forbid-secret   :read-only t)
   (rsv2            :read-only t)
   (rsv3            :read-only t))
  :nil-safe)



;;;; This field is just simulation of a field in the conf-stat
;;;; that not yet exist.

(defsubst conf-stat->comm-conf (conf-stat)
  (if (and (conf-type->original (conf-stat->conf-type conf-stat))
	   (not (zerop (conf-stat->super-conf conf-stat))))
      (conf-stat->super-conf conf-stat)
    (conf-stat->conf-no conf-stat)))




;;; ================================================================
;;;                         Conf-list


(def-komtype conf-list
  ((conf-nos    :read-only t) 
   (conf-types  :read-only t))
  :nil-safe)


;;; ================================================================
;;;                             pers-stat


;;; Constructor:

(def-komtype pers-stat 
  ((pers-no                 :read-only t) 
   (username                :read-only t)
   privileges
   (flags                   :read-only t)
   (last-login              :read-only t)
   user-area
   (total-time-present      :read-only t)
   (sessions                :read-only t)
   (created-lines           :read-only t)
   (created-bytes           :read-only t)
   (read-texts              :read-only t)
   (no-of-text-fetches      :read-only t)
   (created-persons         :read-only t)
   (created-confs           :read-only t)
   (first-created-text      :read-only t)
   (no-of-created-texts     :read-only t)
   (no-of-marks             :read-only t)
   (no-of-confs             :read-only t))
  :nil-safe)


;;; ================================================================
;;;                           text-stat


;;; Constructor:

(def-komtype text-stat 
  ((text-no             :read-only t)
   (creation-time       :read-only t)
   (author              :read-only t)
   (no-of-lines         :read-only t)
   (no-of-chars         :read-only t)
   (no-of-marks         :read-only t)
   (misc-info-list      :read-only t)
   &optional 
   (aux-items))
  :nil-safe)

;;; ================================================================
;;;                              aux-item

(def-komtype aux-item-flags
  ((deleted     :read-only t)
   inherit
   secret
   anonymous
   dont-garb
   (reserved2   :read-only t)
   (reserved3   :read-only t)
   (reserved4   :read-only t))
  :nil-safe)

(def-komtype aux-item 
  ((aux-no          :read-only t)
   (tag             :read-only t)
   (creator         :read-only t)
   (sent-at         :read-only t)
   (flags           :read-only t)
   (inherit-limit   :read-only t)
   data)
  :nil-safe)



;;; ================================================================
;;;                            text

(def-komtype text
  ((text-no         :read-only t)
   text-mass)
  :nil-safe)

;;; Utilities

(defun text->decoded-text-mass (text text-stat)
  "Get the text mass of a text after decoding according to its content type"
  (save-match-data 
    (let* ((str (text->text-mass text))
           (item (lyskom-get-aux-item
                  (text-stat->aux-items text-stat) 1))
           (content-type (and (car item)
                              (lyskom-mime-decode-content-type
                               (aux-item->data (car item))))))
      (if (lyskom-mime-content-type-get content-type 'charset)
          (lyskom-mime-decode-string str (lyskom-mime-content-type-get content-type 'charset))
        str))))



;;; ================================================================
;;;                          misc-info


(def-komtype misc-info 
  (type
   recipient-no
   local-no
   rec-time
   comm-to
   comm-in
   footn-to
   footn-in
   sender
   sent-at)
  :nil-safe)

(defsubst lyskom-create-empty-misc-info ()
  "Create an empty misc-info."
  (lyskom-create-misc-info nil nil nil nil nil nil nil nil nil nil))



;;; ================================================================
;;;                                time

(def-komtype time 
  ((sec         :read-only t)
   (min         :read-only t)
   (hour        :read-only t)
   (mday        :read-only t)
   (mon         :read-only t)
   (year        :read-only t)
   (wday        :read-only t)
   (yday        :read-only t)
   (isdst       :read-only t)
   &optional
   (tzhr        :read-only t)
   (tzmin       :read-only t))
  :nil-safe)

(defun lyskom-create-time-from-utc (sec min hour mday mon year 
                                        wday yday isdst &optional tzhr tzmin)
  (if lyskom-server-uses-utc
      (let* ((date (decode-time (encode-time sec min hour mday mon year 0))))
        (unless (eq mday (elt date 3))
          (setq yday (if (< (or (car (current-time-zone)) 0) 0)
                         (- yday 1) (+ yday 1)))
          (cond ((< yday 1) (setq yday (lyskom-days-in-year (elt date 5))))
                ((> yday (lyskom-days-in-year year)) (setq yday 1))))

        (lyskom-create-time (elt date 0) ; sec
                            (elt date 1) ; min
                            (elt date 2) ; hour
                            (elt date 3) ; mday
                            (elt date 4) ; mon
                            (elt date 5) ; year
                            (elt date 6) ; dow
                            yday        ; yday
                            (elt date 7) ; dst
                            nil nil)
        )
    (lyskom-create-time sec min hour mday mon year
                        wday yday isdst tzhr tzmin)))


;;; ================================================================
;;;                               privs

(def-komtype privs 
  ((wheel       :read-only t)
   (admin       :read-only t)
   (statistic   :read-only t)
   (create_pers :read-only t)
   (create_conf :read-only t)
   (change_name :read-only t)
   (flg7        :read-only t)
   (flg8        :read-only t)
   (flg9        :read-only t)
   (flg10       :read-only t)
   (flg11       :read-only t)
   (flg12       :read-only t)
   (flg13       :read-only t)
   (flg14       :read-only t)
   (flg15       :read-only t)
   (flg16       :read-only t))
  :nil-safe)


;;; ================================================================
;;;                            flags

(def-komtype session-flags
  ((invisible           :read-only t)
   (user_active_used    :read-only t)
   (user_absent         :read-only t)
   (reserved3           :read-only t)
   (reserved4           :read-only t)
   (reserved5           :read-only t)
   (reserved6           :read-only t)
   (reserved7           :read-only t))
  :nil-safe)

(def-komtype dynamic-session-info
  ((session             :read-only t)
   (person              :read-only t)
   (working-conference  :read-only t)
   (idle-time           :read-only t)
   (flags               :read-only t)
   (what-am-i-doing     :read-only t))
  :nil-safe)

(def-komtype static-session-info
  ((username            :read-only t)
   (hostname            :read-only t)
   (ident-user          :read-only t)
   (connection-time     :read-only t))
  :nil-safe)

;;; ================================================================
;;;                            flags

(def-komtype flags
  ((unread_is_secret    :read-only t)
   (flg2                :read-only t)
   (flg3                :read-only t)
   (flg4                :read-only t)
   (flg5                :read-only t)
   (flg6                :read-only t)
   (flg7                :read-only t)
   (flg8                :read-only t))
  :nil-safe)


;;; ================================================================
;;;                             membership


;;; Constructor:

(def-komtype member-list 
  ((members     :read-only t))
  :nil-safe)

(def-komtype member
  ((pers-no             :read-only t)
   (created-by          :read-only t)
   (created-at          :read-only t)
   (membership-type     :read-only t))
  :nil-safe)

;;;
;;; Note that message-flag here is *not* the same as in the
;;; protocol. The value of message-flag is computed from
;;; message-invert in the protocol when received and when
;;; sent.
;;;

(def-komtype membership-type
  (invitation
   passive
   secret
   message-flag
   (rsv2                :read-only t)
   (rsv3                :read-only t)
   (rsv4                :read-only t)
   (rsv5                :read-only t))
  :nil-safe)

(def-komtype membership 
  (position 
   (last-time-read)
   (conf-no             :read-only t)
   priority 
   (last-text-read      :read-only t)
   read-texts
   (created-by          :read-only t)
   (created-at          :read-only t)
   (type                :read-only t))
  :nil-safe)

;;; Special stuff

(defun lyskom-member-list-find-member (person members)
  (when members
    (lyskom-traverse member (member-list->members members)
      (when (eq person (member->pers-no member))
        (lyskom-traverse-break member)))))



;;; ================================================================
;;;                               map


(def-komtype map 
  ((first-local         :read-only t)
   (text-nos            :read-only t))
  :nil-safe)

;;; Concat:

(defsubst lyskom-map-concat (&rest maps)
  "Take any number of MAPS and return a new map which is the sum of the maps.
Args: &rest MAPS.
The MAPS must be consecutive. No gaps or overlaps are currently allowed."
  (if (null maps)
      (lyskom-create-map 1 [])
    (let* ((first (map->first-local (car maps)))
	   (high (+ first (length (map->text-nos (car maps)))))
	   (maplist (list (map->text-nos (car maps))))
	   (maps (cdr maps)))
      (while maps
	(if (/= (map->first-local (car maps))
		high)
	    (signal 'lyskom-internal-error '("lyskom-map-concat")))
	(setq maplist (nconc maplist (list (map->text-nos (car maps)))))
	(setq high (+ high (length (map->text-nos (car maps)))))
	(setq maps (cdr maps)))
      (lyskom-create-map first (apply 'vconcat maplist)))))


;;; ================================================================
;;; Text-Mapping support

(def-komtype text-mapping
  ((range-begin         :read-only t)
   (range-end           :read-only t)
   (size                :read-only t)
   (later-texts-exist   :read-only t)
   (type                :read-only t)
   (block               :read-only nil)))

(defsubst lyskom-create-text-pair (local global) (cons local global))
;;UNUSED: text-pair->local-number
(defsubst text-pair->local-number (pair) (car pair))
;;UNUSED: text-pair->global-number
(defsubst text-pair->global-number (pair) (cdr pair))

(defsubst text-mapping->block-size (map)
  (if (eq (text-mapping->type map) 'dense)
      (length (map->text-nos (text-mapping->block map)))
    (length (text-mapping->block map))))

;;UNUSED: text-mapping->local-to-global
(defun text-mapping->local-to-global (map local)
  (cond ((or (< local (text-mapping->range-begin map))
             (> local (text-mapping->range-end map))) nil)
        ((eq (text-mapping->type map) 'sparse)
         (cdr (assq local (text-mapping->block map))))

        ((eq (text-mapping->type map) 'dense)
         (let ((result (aref (text-mapping->block map)
                             (- local (text-mapping->range-begin map)))))
           (and (not (zerop result)) result)))))

(defun text-mapping->global-numbers (map)
  (cond ((eq (text-mapping->type map) 'sparse)
         (mapcar 'cdr (text-mapping->block map)))
        ((eq (text-mapping->type map) 'dense)
         (let ((result nil))
           (lyskom-traverse el (map->text-nos (text-mapping->block map))
             (unless (zerop el) (setq result (cons el result))))
           (nreverse result)))))

(defun text-mapping->global-to-local (map global)
  (cond ((eq (text-mapping->type map) 'sparse)
         (cdr (rassq global (text-mapping->block map))))
        ((eq (text-mapping->type map) 'dense)
         (let ((i (text-mapping->range-begin map))
               (result nil))
           (while (< i (text-mapping->range-end map))
             (if (eq (aref (map->text-nos (text-mapping->block map)) 
                           (- i (text-mapping->range-begin map)))
                     global)
                 (setq result i i (text-mapping->range-end map))
               (setq i (1+ i))))
           result))))

(defun text-mapping->remove-local (map local)
  (cond ((eq (text-mapping->type map) 'dense)
         (setq local (- local (text-mapping->range-begin map)))
         (when (and (>= local 0)
                    (< local (text-mapping->block-size map)))
           (aset (map->text-nos (text-mapping->block map)) local 0)))

        ((eq (text-mapping->type map) 'sparse)
         (let ((el (assq local (text-mapping->block map))))
           (when el
             (set-text-mapping->block map 
                                      (delq el (text-mapping->block map))))))))

(def-komtype    text-mapping-iterator
  ((map         :read-only t)
   (next-value  :automatic nil)
   (state       :automatic nil))
  :create-hook (text-mapping-iterator->init OBJECT))

(defun text-mapping->iterator (map)
  (lyskom-create-text-mapping-iterator map))

(defun text-mapping-iterator->init (iter)
  (if (eq (text-mapping->type (text-mapping-iterator->map iter)) 'dense)
      (set-text-mapping-iterator->state iter 0)
    (set-text-mapping-iterator->state 
     iter (text-mapping->block (text-mapping-iterator->map iter)))))

(defun text-mapping-iterator->next (iter)
  (when (text-mapping-iterator->state iter)
    (let ((map (text-mapping-iterator->map iter)))
      (prog1
          (if (eq (text-mapping->type map) 'dense)
              (lyskom-create-text-pair (+ (text-mapping-iterator->state iter)
                                          (text-mapping->range-begin map))
                                       (aref (map->text-nos (text-mapping->block map))
                                             (text-mapping-iterator->state iter)))
            (car (text-mapping-iterator->state iter)))
        (text-mapping-iterator->step iter)))))

(defun text-mapping-iterator->step (iter)
  (let ((map (text-mapping-iterator->map iter))
        (state (text-mapping-iterator->state iter)))
    (cond 
     ((eq (text-mapping->type map) 'dense)
      (setq state (1+ state))
      (while (and (< state (text-mapping->block-size map))
                  (eq 0 (aref (map->text-nos (text-mapping->block map)) state)))
        (setq state (1+ state)))
      (set-text-mapping-iterator->state 
       iter (and (< state (text-mapping->block-size map)) state)))

     ((eq (text-mapping->type map) 'sparse)
      (set-text-mapping-iterator->state iter (cdr state))))))



;;; ================================================================
;;;                            mark

(def-komtype mark 
  ((text-no     :read-only t)
   (mark-type   :read-only t))
  :nil-safe)

;;; Utilities

(defun mark->symbolic-mark-type (mark)
  (lyskom-symbolic-mark-type-string (mark->mark-type mark)))

;;; ================================================================
;;;                           who-info

(def-komtype who-info 
  ((pers-no         :read-only t)
   (working-conf    :read-only t)
   (connection      :read-only t)
   (doing-what      :read-only t)
   (username        :read-only t)
   &optional
   (hostname        :read-only t)
   (ident-user      :read-only t))
  :nil-safe)


;;; ================================================================
;;;                         session-info

(def-komtype session-info 
  ((pers-no         :read-only t)
   (working-conf    :read-only t)
   (connection      :read-only t)
   (doing           :read-only t)
   (username        :read-only t)
   (hostname        :read-only t)
   (ident-user      :read-only t)
   (idletime        :read-only t)
   (connect-time    :read-only t))
  :nil-safe)



;;; ================================================================
;;;                            text-list

;;; Constructor:

(def-komtype text-list 
  (texts-internal 
   (tail :automatic (last texts-internal))
   (length-internal :automatic (length texts-internal)))
  :nil-safe)

(defsubst text-list->texts (text-list)
  (text-list->texts-internal text-list))

(defsubst set-text-list->texts (text-list texts)
  (set-text-list->texts-internal text-list texts)
  (set-text-list->tail text-list (last texts))
  (set-text-list->length-internal text-list (length texts)))

(defsubst text-list->empty (text-list)
  "Return t if TEXT-LIST is empty."
  (null (text-list->texts text-list)))

(defsubst text-list->length (text-list)
  "Return the length of TEXT-LIST."
  (unless (text-list->length-internal text-list)
    (set-text-list->length-internal text-list
                                    (length (text-list->texts text-list))))
  (text-list->length-internal text-list))

(defsubst text-list->memq (text-list no)
  "Return non-nil if TEXT-LIST contains TEXT-NO."
  (memq no (text-list->texts text-list)))

(defsubst text-list->delq (text-list no)
  "Remove text NO from TEXT-LIST."
  (set-text-list->texts-internal text-list (delq no (text-list->texts text-list)))
  (when (eq no (car (text-list->tail text-list)))
    (set-text-list->tail text-list (last (text-list->texts text-list))))
  (set-text-list->length-internal text-list nil))

;;; FIXME: It would be useful if text-list->append would only append
;;; FIXME: unique numbers and not blindnly concatenate the two lists.
;;; FIXME: That would probably take care of any remaining problems
;;; FIXME: where some texts are listed twice in the to do list.

(defsubst text-list->append (text-list texts)
  "Destructively append TEXTS to the end of TEXT-LIST."
  (if (text-list->texts text-list)
      (progn
        (nconc (or (text-list->tail text-list)
                   (text-list->texts-internal text-list))
               texts)
        (when (text-list->length-internal text-list)
          (set-text-list->length-internal 
           text-list
           (+ (text-list->length-internal text-list)
              (length texts)))))
    (set-text-list->texts-internal text-list texts)
    (set-text-list->length-internal text-list nil))
  (set-text-list->tail text-list (last texts)))

(defun text-list->trim-head (tlist n)
  "Destructively remove all but the N last elements from TLIST.
Do nothing if the TLIST is less than N elements long."
  (set-text-list->texts-internal tlist (nthcdr (max (- (text-list->length tlist) n) 0)
                                               (text-list->texts tlist)))
  (when (text-list->length-internal tlist)
    (set-text-list->length-internal tlist n))
  (unless (text-list->texts tlist)
    (set-text-list->length-internal tlist 0)
    (set-text-list->tail tlist nil)))


;;; ================================================================
;;;                         version-info


;;; Constructor:

(def-komtype version-info 
  ((protocol-version    :read-only t)
   (server-software     :read-only t)
   (software-version    :read-only t))
  :nil-safe)


;;; ================================================================
;;;                          server-info

(def-komtype server-info 
  ((version         :read-only t)
   (conf-pres-conf  :read-only t)
   (pers-pres-conf  :read-only t)
   (motd-conf       :read-only t)
   (kom-news-conf   :read-only t)
   motd-of-lyskom
   &optional
   (aux-item-list   :read-only t))
  :nil-safe)


;;; ================================================================
;;;                            conf-z-info-list

(def-komtype conf-z-info-list
  ((conf-z-infos :read-only t))
  :nil-safe)


;;; ================================================================
;;;                            conf-z-info

;;; Constructor:

(def-komtype conf-z-info 
  ((name            :read-only t)
   (conf-type       :read-only t)
   (conf-no         :read-only t))
  :nil-safe)


(def-komtype stats-description
  ((what            :read-only t)
   (when            :read-only t))
  :nil-safe)

(def-komtype stats
  ((average         :read-only t)
   (ascent-rate     :read-only t)
   (descent-rate    :read-only t))
  :nil-safe)

(def-komtype server-stats
  (&optional
   (what            :default nil)
   (when            :default nil)
   (values          :default nil))
  :nil-safe)

(def-komtype static-server-info
  ((boot-time       :read-only t)
   (save-time       :read-only t)
   (db-status       :read-only t)
   (existing-texts  :read-only t)
   (highest-text-no :read-only t)
   (existing-confs  :read-only t)
   (existing-persons :read-only t)
   (highest-conf-no :read-only t))
  :nil-safe)

(def-komtype scheduling-info
  ((priority        :read-only t)
   (weight          :read-only t))
  :nil-safe)


;;; ================================================================



;;; Utilities

(defun text-stat-find-aux (text-stat tag &optional person)
  "Return a list containing the aux items in TEXT-STAT with tag TAG.
If PERSON is non-nil return only those items created by person.
Args: TEXT-STAT TAG PERSON"
  (let ((result nil)
        (items (text-stat->aux-items text-stat)))
    (while items
      (when (and (eq tag (aux-item->tag (car items)))
                 (not (aux-item-flags->deleted
                       (aux-item->flags (car items))))
                 (or (null person)
                     (eq person (aux-item->creator (car items)))))
        (setq result (cons (car items) result)))
      (setq items (cdr items)))
    (nreverse result)))

(defun conf-stat-find-aux (conf-stat tag &optional person)
  "Return a list containing the aux items in CONF-STAT with tag TAG.
If PERSON is non-nil return only those items created by person.
Args: CONF-STAT TAG PERSON"
  (let ((result nil)
        (items (conf-stat->aux-items conf-stat)))
    (while items
      (when (and (eq tag (aux-item->tag (car items)))
                 (not (aux-item-flags->deleted
                       (aux-item->flags (car items))))
                 (or (null person)
                     (eq person (aux-item->creator (car items)))))
        (setq result (cons (car items) result)))
      (setq items (cdr items)))
    (nreverse result)))

(defun lyskom-is-recipient (text-stat conf-no)
  "Return non-nil if TEXT-STAT has CONF-NO as a recipient."
  (let ((result nil))
    (lyskom-traverse misc
        (text-stat->misc-info-list text-stat)
      (when (and (memq (misc-info->type misc) lyskom-recpt-types-list)
                 (eq (misc-info->recipient-no misc) conf-no))
        (setq result t)))
    result))



(provide 'lyskom-types)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: clienttypes.el,v 44.27 2004/07/21 11:14:38 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: clienttypes.el
;;;;
;;;; This file contains primitives for the different data types
;;;; in the lyskom elisp client. The types in here are only used
;;;; within this lyskom client.
;;;;
;;;; Authors: Linus Tolke and Inge Wallin
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: clienttypes.el,v 44.27 2004/07/21 11:14:38 byers Exp $\n"))


;;; ================================================================
;;;                            read-info

;;; A read-info is used by to tell the client which text to 
;;; show next and in which order to step through the conferences 
;;; with unread texts. New read-infos are created and deleted
;;; all the time within a session.
;;;
;;; The type is one of the following:
;;;   REVIEW      - Default review type, created by the kom-review-by-to
;;;		    and the kom-review-comments
;;;   REVIEW-TREE - List of texts created by one of the tree-reading 
;;;		    commands: kom-find-root-review, kom-review-tree
;;;   REVIEW-MARK - List of texts created by the review-mark command
;;;   REVIEW-FAQ  - List of texts created by kom-review-faq or similar
;;;   REVIEW-FAQ-TREE  - Like REVIEW-TREE but for FAQs
;;;   COMM-IN     - Type containing the list of comments to a text
;;;   FOOTN-IN    - Type containing the list of footnotes to a text
;;;   CONF        - Basic type of unread in a conf.
;;;   RE-EDIT-TEXT - Re-edit a failed submission. Buffer is in misc.
;;;   PRI-SESSION - Go to prioritized session.
;;;
;;;   The types REVIEW-TREE, COMM-IN and FOOTN-IN are created for new for
;;;   every text read (recursively) when appropriate.
;;;
;;;   The difference between REVIEW, REVIEW-MARK and REVIEW-FAQ is just
;;;   that there generate different prompts and different text from
;;;   kom-review-stack.
;;;


;;; read-info

(def-komtype read-info 
  ((type                :read-only t)
   (conf-stat           :read-only t)
   priority 
   (text-list           :read-only t)
   &optional 
   (comm-to             :read-only t)
   forward 
   (unfetched-texts     :read-only t :automatic nil)
   (misc                :read-only t))
  :nil-safe)


(defsubst read-info-append-text-list (read-info texts)
  (text-list->append (read-info->text-list read-info) texts))

(defsubst read-info-enter-text-last (read-info text-no)
  (read-info-append-text-list read-info (list text-no)))


;;; ================================================================
;;;                          read-list
;;;
;;; We don't use def-komtype here because the code below relies on 
;;; read-lists being a cons of READ-LIST and the data.
;;;

;;; Constructor:

(defsubst lyskom-create-read-list ()
  "Create an empty read-list."
  (cons 'READ-LIST nil))


;;; Predicates:

(defsubst read-list-isempty (read-list)
  "Return t if READ-LIST is empty, otherwise return nil."
  (null (cdr read-list)))


;;; Selectors:

(defsubst read-list->first (read-list)
  "Return the first entry in READ-LIST, or nil if empty."
  (car-safe (cdr read-list)))


(defsubst read-list->nth (read-list n)
  "Args: READ-LIST N
Return element N in READ-LIST or nil if outside the range.
The range of valid values for N is [0, num-entries - 1]."
  (elt (cdr read-list) n))


(defsubst read-list->all-entries (read-list)
  "Return a list of all entries in READ-LIST."
  (cdr read-list))


;;; Other functions:

(defsubst read-list-length (read-list)
  "Return the number of entries in READ-LIST."
  (length (read-list->all-entries read-list)))


;;; Modifiers:

(defsubst set-read-list-empty (read-list)
  "Empty READ-LIST destructively."
  (let ((tmp (cdr read-list)))
    (setcdr read-list nil)
    (lyskom-traverse read-info tmp
      (when (eq 'CONF (read-info->type read-info))
        (lp--maybe-update-unreads (conf-stat->conf-no
                                   (read-info->conf-stat read-info)))))))

(defsubst set-read-list-del-first (read-list)
  "Delete the first entry of READ-LIST if there is one."
  (let ((el (car (cdr read-list))))
    (if (cdr read-list)
        (setcdr read-list (cdr (cdr read-list))))
    (when (and el (eq (read-info->type el) 'CONF))
      (lp--maybe-update-unreads (conf-stat->conf-no
                                 (read-info->conf-stat el))))))


(defsubst read-list-enter-first (read-info read-list)
  "Enter READ-INFO first into READ-LIST."
  (setcdr read-list (cons read-info (cdr read-list)))
  (when (eq 'CONF (read-info->type read-info))
    (lp--maybe-update-unreads (conf-stat->conf-no
                               (read-info->conf-stat read-info))))
  )


(defun read-list-enter-text (text-no recipient rlist)
  "Args: TEXT-NO RECIPIENT RLIST.
Add the new text TEXT-NO to any RECIPIENT found in RLIST.
RECIPIENT is a conf-stat.
Returns t if there was a conference to insert this text into."
  (let ((inserted nil))
    (lyskom-traverse
     read-info (cdr rlist)
     (cond
      ((and (eq 'CONF (read-info->type read-info))
	    (= (conf-stat->conf-no recipient)
	       (conf-stat->conf-no (read-info->conf-stat read-info))))
       (read-info-enter-text-last read-info text-no)
       (setq inserted t))))
    (when inserted (lp--maybe-update-unreads (conf-stat->conf-no recipient)))
    inserted))


(defun read-list-delete-text (text-no rlist)
  "Destructively delete all occurances of TEXT-NO from RLIST.
RLIST is a list of read-info.
Entries of the type REVIEW, REVIEW-FAQ, REVIEW-TREE or REVIEW-MARK are
not changed except if they were empty in which case they are removed.
Returns the modified RLIST.
TEXT-NO may be nil, in which case only empty read-infos on RLIST are removed."
  (let* ((prev rlist)			;"Previous" cons-celll
	 (curr (cdr rlist)))		;Current cons-cell
    (while curr
      (when text-no
        (cond
         ((let ((type (read-info->type (car curr)))) 
					; Don't change REVIEW et c.
            (memq type lyskom-review-types-list)))
         (t				; Do change all other entries.
          (let ((tl  (read-info->text-list (car curr))))
            (when (text-list->memq tl text-no)
              (text-list->delq tl text-no)
              (lp--maybe-update-unreads
               (conf-stat->conf-no (read-info->conf-stat (car curr)))))))))
      
      ;; Delete this element from RLIST if the text-list became or was empty.
      
      (if (text-list->empty (read-info->text-list (car curr)))
	  (setcdr prev (cdr curr))
	(setq prev curr))
      (setq curr (cdr curr))))
  rlist)


(defun read-list-enter-read-info (read-info rlist &optional before)
  "Destructively insert READ-INFO in RLIST, sorted by priority.
RLIST is a list of read-info.
Args: READ-INFO RLIST &optional BEFORE.
A new item with the same priority as an item that is alreay on the list
will nomally be inserted after the old one, but if BEFORE is non-nil it
will be inserted before it."
  (let ((pri (+ (if before 0 -1)
		(read-info->priority read-info)))
	(continue t)
	(conf-stat (read-info->conf-stat read-info))
	(type (read-info->type read-info)))
    (while continue
      (cond
       ((and (eq type 'CONF)
	     (eq (read-info->type (car (cdr rlist))) 'CONF)
	     (eq (conf-stat->conf-no conf-stat)
                 (conf-stat->conf-no (read-info->conf-stat
                                      (car (cdr rlist))))))
	(read-info-append-text-list
	 (car (cdr rlist))
	 (text-list->texts (read-info->text-list read-info)))
        (lp--maybe-update-unreads (conf-stat->conf-no conf-stat))
	(setq continue nil)) 

       ((null (cdr rlist)) 
	(setcdr rlist (list read-info))
	(setq continue nil))
       ((>= pri (read-info->priority (car (cdr rlist))))
	(setcdr rlist (cons read-info (cdr rlist)))
	(setq continue nil))
       (t 
	(setq rlist (cdr rlist)))))

    (when (eq type 'CONF)
      (lp--maybe-update-unreads (conf-stat->conf-no conf-stat)) )))


(defun read-list-delete-read-info (conf-no rlist)
  "Destructively removes all the entries for the conf CONF-NO in RLIST.
RLIST is a list of read-info."
  (while (cdr rlist)
    (if (eq (conf-stat->conf-no (read-info->conf-stat
				      (car (cdr rlist))))
	    conf-no)
	(setcdr rlist (cdr (cdr rlist)))
      (setq rlist (cdr rlist))))
  (lp--maybe-update-unreads conf-no))
 
(defun read-list-rotate (read-list)
  "Put the first element of READ-LIST last in the same list. The second
element will be the new first element."
  (if (> (length read-list) 2)
      (let ((first (cdr read-list))
	    (last  (cdr read-list)))
	(while (cdr last)
	  (setq last (cdr last)))
	(setcdr last first)
	(setcdr read-list (cdr first))
	(setcdr first nil)))
  read-list)    
	  

;;; ================================================================
;;;                      A simple queue

;;;
;;; This is a simple implementation of a queue.  The only thing you
;;; can do with it is stuff things at the back of it and remove
;;; things from the front of it.  (...and of course do a few tests)
;;;

;;; Author: Inge Wallin


(defun lyskom-queue-create ()
  "Create an empty queue."
  (cons 'QUEUE (cons nil nil)))


(defsubst lyskom-queue-enter (queue element)
  "Enter last into the queue QUEUE the ELEMENT."
  (let ((elementcell (cons element nil)))
    (if (null (car (cdr queue)))
	; QUEUE is empty
	(setcar (cdr queue)
		(setcdr (cdr queue) 
			elementcell))
      (setcdr (cdr (cdr queue))
	      elementcell)
      (setcdr (cdr queue)
	      elementcell))))


(defsubst lyskom-queue-p (queue)
  "Return t if QUEUE is a queue, otherwise return nil."
  (eq (car-safe queue) 'QUEUE))


(defsubst lyskom-queue-isempty (queue)
  "Return t if QUEUE is empty, otherwise return nil."
  (null (car (cdr queue))))


(defsubst lyskom-queue->first (queue)
  "Return the first element of QUEUE or nil if it is empty."
  (car-safe (car (cdr queue))))


(defsubst lyskom-queue->all-entries (queue)
  "Return all elements of QUEUE (nil if it is empty)."
  (car-safe (cdr queue)))


;;UNUSED: lyskom-queue->last
(defsubst lyskom-queue->last (queue)
  "Return the lastelement of QUEUE or nil if it is empty."
  (car-safe (cdr (cdr queue))))


(defun lyskom-queue-remove-matching (queue pred)
  "Remove all elements from QUEUE that satisfy PRED."
  (let ((prev nil)
        (ptr (car (cdr queue))))
    (while ptr
      (if (funcall pred (car ptr))
        (progn (if prev
                   (setcdr prev (cdr ptr))
                 (setcar (cdr queue) (cdr ptr)))
               (unless (cdr ptr)
                 (setcdr (cdr queue) prev)))
        (setq prev ptr))
      (setq ptr (cdr ptr)))))


(defsubst lyskom-queue-make-empty (queue)
  "Make the queue QUEUE empty."
  (setcdr queue (cons nil nil)))

;;UNUSED: lyskom-queue-set-data
(defsubst lyskom-queue-set-data (queue data)
  (lyskom-queue-make-empty queue)
  (setcdr queue (cons data (last data))))


(defsubst lyskom-queue-delete-first (queue)
  "Delete the first element of QUEUE and return it. If QUEUE is empty
return nil and do nothing."
  (if (lyskom-queue-isempty queue)
      nil
    (prog1
	(lyskom-queue->first queue)
      (setcar (cdr queue)
	      (cdr (car (cdr queue))))
      (if (null (car (cdr queue)))
	  (setcdr (cdr queue) nil)))))


;;; ================================================================
;;;                           A simple stack

;;; 
;;; This is an implementation of a simple stack.
;;;

;;; Author: Inge Wallin


(defun lyskom-stack-create ()
  "Create an empty stack"
  (cons 'STACK nil))


(defun lyskom-stack-p (stack)
  "Return t if STACK is a lyskom-stack, otherwise return nil."
  (eq (car-safe stack) 'STACK))


(defun lyskom-stack-push (stack element)
  "Push the second arg ELEMENT onto the first arg STACK"
  (setcdr stack (cons element (cdr stack))))


(defun lyskom-stack-pop (stack)
  "Remove the topmost element from STACK and return it. If the stack
is empty, return nil"
  (prog1
      (car-safe (cdr stack))
    (setcdr stack (cdr-safe (cdr stack)))))


(defun lyskom-stack->top (stack)
  "Return the topmost element of STACK or nil if it is empty."
  (car-safe (cdr stack)))


;;UNUSED: lyskom-stack->length
(defun lyskom-stack->length (stack)
  "Return the number of elements on STACK."
  (length (cdr stack)))

;;UNUSED: lyskom-stack->nth
(defun lyskom-stack->nth (stack n)
  "Return element no (second arg) N of the stack (first arg) STACK.
N counts from zero. If the length of STACK is less than N, nil is returned."
  (nth n (cdr stack)))


(defun lyskom-stack->all-entries (stack)
  "Return a list of all entries in STACK.
The element last pushed is first in the list."
  (cdr stack))


(defsubst lyskom-stack-isempty (stack)
  "Returns non-nil if the STACK is empty."
  (not (cdr stack)))



;;; ================================================================
;;;			format-state

(def-komtype format-state
  (format-string
   start
   argl
   length
   result
   delayed-propl
   delayed-overlays
   delayed-content
   depth)
  :nil-safe)

;;; ================================================================


;;; ======================================================================
;;;
;;; collector
;;;

;;; A collector is used when a handler needs to pass information
;;; back to a function using asynchronous calls. You could use
;;; dynamically scoped variables, but that causes problems when
;;; the user quits before all handlers have been called since the
;;; result variable will be out of scope for the remaining handlers.
;;; The best-case scenario will be a crash. The worst-case scenario
;;; is when the handler clobbers another variable with the same name
;;; that has come into scope.
;;;
;;; So, so collect a number of results, do the following:
;;;
;;;    (setq <result> (make-collector))
;;;    (<loop-function>
;;;        (initiate-<ngonting> '<queue> <function> <argl> <result>))
;;;    (lyskom-wait-queue '<queue>)
;;;    (<use> (collector->value <result>))
;;;
;;; where function is something like this:
;;;
;;;    (defun <funktion> (data-frn-servern collector)
;;;        (set-collector->value collector
;;;                              (cons (<behandla> data-frn-servern)
;;;                                    (collector->value collector))))
;;;
;;; or shorter,
;;;
;;;    (defun <funktion> (data-frn-servern collector)
;;;        (collector-push (<behandla> data-frn-servern)))
;;;
;;; This sidestepping protects the handler from scope changes.
;;;


(defun make-collector ()
  "Create a data type for collecting asynchronous results safely"
  (cons 'COLLECTOR nil))

(defsubst collector->value (collector)
  "Get the current value of a collector"
  (cdr collector))

(defsubst set-collector->value (collector value)
  "Set the calue of a collector"
  (setcdr collector value))

(defun collector-push (value collector)
  "Push VALUE onto the front of COLLECTOR's value"
  (setcdr collector (cons value (cdr collector))))


;;; ================================================================
;;; Specification for text links (cached)
;;;
;;; We don't use def-komtype since the accessors should be able to
;;; work on user settings too.

(defun lyskom-create-lyskom-text-link (pattern replacement 
                                               highlight ignore-case)
  (cons 'LYSKOM-TEXT-LINK (vector pattern replacement highlight ignore-case)))

(defsubst lyskom-text-link->pattern (link)
  (if (symbolp (car link)) (elt (cdr link) 0) (elt link 0)))

(defsubst lyskom-text-link->replacement (link)
  (if (symbolp (car link)) (elt (cdr link) 1) (elt link 1)))

(defsubst lyskom-text-link->highlight (link)
  (if (symbolp (car link)) (elt (cdr link) 2) (elt link 2)))

(defsubst lyskom-text-link->ignore-case (link)
  (if (symbolp (car link)) (elt (cdr link) 3) (elt link 3)))





(eval-and-compile (provide 'lyskom-clienttypes))

;;; clienttypes.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: faces.el,v 44.8 2004/10/28 18:51:55 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: faces.el
;;;;
;;;; Code to handle faces in LysKOM
;;;;
;;;; ================================================================
;;;; Faces in LysKOM
;;;;
;;;; There are a bunch of face variables that define witch face to use
;;;; in various roles. By using variables as a secnod level of
;;;; indirection it is possible to have divveret faces in different
;;;; buffers.
;;;;
;;;; The concept of face schemes that was used in versions up to
;;;; and including 0.47.1 is completely out the door.
;;;; ================================================================

;;;; TODO:
;;;;
;;;; Setup faces from resources? Do we need that any more? Or will
;;;; defface take care of it for us?
;;;;
;;;; Remove old code.
;;;;
;;;; In the customization buffer we need a new widget type that
;;;; can open customization of a face.
;;;;
;;;; The customization buffer should provide a choice for the
;;;; user of nil, the "factory default" and a specific face.
;;;;
;;;; Other than that, it's more or less done.



(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: faces.el,v 44.8 2004/10/28 18:51:55 byers Exp $\n"))



;;; ================================================================
;;; Face variables
;;;
;;; Here's a list of all face variables. Seems to be useful on occasion.
;;;
;;; kom-active-face
;;; kom-url-face
;;; kom-me-face
;;; kom-highlight-face
;;; kom-text-face
;;; kom-subject-face
;;; kom-text-no-face
;;; kom-friends-face
;;; kom-morons-face
;;; kom-presence-face
;;; kom-first-line-face
;;; kom-warning-face
;;; kom-mark-face
;;; kom-dim-face
;;; kom-text-body-face
;;; kom-dashed-lines-face
;;; kom-async-text-body-face
;;; kom-async-dashed-lines-face

(def-kom-var kom-active-face 'kom-face--default--active-face
  "*Face used for most \"clickable\" areas.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--active-face.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-active-strikethrough-face 'kom-face--default--active-strikethrough-face
  "*Face used for some \"clickable\" areas.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--active-strikethrough-face.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-active-highlight-face 'kom-face--default--active-highlight-face
  "*Face used for some \"clickable\" areas.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--active-highlight-face.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-url-face 'kom-face--default--url-face
  "*Face used for URLs.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--url-face.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-me-face 'kom-face--default--me-face
  "*Face used to show your own name.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--me-face.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-highlight-face 'kom-face--default--highlight-face
  "*Face used for various highlights.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--highlight.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-subject-face 'kom-face--default--subject-face
  "*Face used for subject lines.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--subject-fac.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-text-no-face 'kom-face--default--text-no-face
  "*Face used for text numbers.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--text-no-fac.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-friends-face 'kom-face--default--friends-face
  "*Face used for people in kom-friends.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--friends-fac.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-morons-face 'kom-face--default--morons-face
  "*Face used for people in kom-morons.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--morons-face.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-presence-face 'kom-face--default--presence-face
  "*Face used for presence messages.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--presence-f.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-first-line-face 'kom-face--default--first-line-face
  "*Face used for the first line header of each text.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--first-li.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-warning-face 'kom-face--default--warning-face
  "*Face used to display important warnings.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--warning-fac.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-mark-face 'kom-face--default--mark-face
  "*Face used for temporary marks.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--mark-face.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-dim-face 'kom-face--default--dim-face
  "*Face used to display dimmed items, such as passive memberships.
The value should be either a symbol naming a face or nil.
The default value is kom-face--default--dim-face.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-text-body-face nil
  "*Face to use to modify text bodies.
The value should be either a symbol naming a face or nil.

If this is set to nil, a face with a background that differs ever
so slightly from the default background will be created.

The default value is nil.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-dashed-lines-face nil
  "*Face to use to modify the dashed lines before and after texts.
The value should be either a symbol naming a face or nil.

If this is set to nil, a face with a background that differs slightly
from the default background will be created.

The default value is nil.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-async-text-body-face nil
  "*Face to use to modify asynchronos message bodies.
The value should be either a symbol naming a face or nil.

If this is set to nil, a face with a background that differs ever
so slightly from the default background will be created.

The default value is nil.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var kom-async-dashed-lines-face nil
  "*Face to use to modify dashed lines around asynchronous messsages.
The value should be either a symbol naming a face or nil.

If this is set to nil, a face with a background that differs slightly
from the default background will be created.

The default value is nil.

This is a LysKOM face variable."
  server
  inherited)

(def-kom-var lyskom-default-text-body-face nil
  "Default text body face."
  inherited)

(def-kom-var lyskom-default-async-text-body-face nil
  "Default text body face."
  inherited)

(def-kom-var lyskom-default-dashed-lines-face nil
  "Default text body face."
  inherited)

(def-kom-var lyskom-default-async-dashed-lines-face nil
  "Default text body face."
  inherited)


;;; ================================================================
;;; Main entry points

(defun lyskom-setup-faces-for-buffer ()
  "Set up faces for the current buffer."
    (setq lyskom-default-text-body-face nil)
    (setq lyskom-default-dashed-lines-face nil)
    (setq lyskom-default-async-text-body-face nil)
    (setq lyskom-default-async-dashed-lines-face nil)
    (condition-case nil
	(let ((faces (lyskom-generate-faces-for-background
		      (or (face-background 'default)
			  (lyskom-frame-property (selected-frame) 'background-color)
			  "#ffffff"))))
	  (setq lyskom-default-text-body-face
		(cdr (assq 'text-body faces))
		lyskom-default-dashed-lines-face
		(cdr (assq 'dashed-lines faces))
		lyskom-default-async-text-body-face
		(cdr (assq 'async-text-body faces))
		lyskom-default-async-dashed-lines-face
		(cdr (assq 'async-dashed-lines faces))))
      (error nil)))


;;; ================================================================
;;; Background faces
;;;
;;; The faces for text backgrounds cannot be hard-coded. It's OK
;;; to hard-code some known alternatives, but in the general case
;;; we're better off calculating the colors.
;;;
;;; The user can specify faces for these properties, but can also
;;; specify "default", which means calculate the face.
;;;

(defvar lyskom-background-faces nil
  "Pool of background faces.
This is an alist of `(COLOR . FACES)' elements, where COLOR is a
canonical representation of a background color and FACES is an
alist of automatically generated faces to use in that background.
Each element of FACES is of the form `(KEY . FACE-NAME)', where
KEY is one of `text-body', `dashed-lines', `async-text-body' or
`async-dashed-lines', and FACE-NAME is the name of the face to
use for the feature specified by KEY.

When the faces for a buffer are set, the client will look in this 
pool for the appropriate faces. If none are found, new faces will
be generated and stored in the pool.

This list is not consulted at any other time.

See `lyskom-background-colors' for additional information.")


(defvar lyskom-background-colors
  '(("#ffffff" 
     (text-body . "#f8f8ff")
     (dashed-lines . "#e8e8ff")
     (async-text-body . "#f8fff8")
     (async-dashed-lines . "#e8ffe8"))
    ("#000000"
     (text-body . "#080808")
     (dashed-lines . "#101010")
     (async-text-body . "#000020")
     (async-dashed-lines . "#101030")))
  "Specification for special background faces.

This is an alist of `(COLOR . SPEC)' elements, where COLOR is a color
name and SPEC is an alist specifying background colors to use when the
main background is COLOR. Elements in SPEC are `(KEY . COLOR)' where
KEY is one of `text-body', `dashed-lines', `async-text-body' or
`async-dashed-lines' and COLOR is the name of the background color to
use for the feature indicated by KEY.

This list is consulted only when generating new faces for a particular
background color. Changes to it after starting the client may have no
effect.

See `lyskom-background-faces' for additional information."
)

(defun lyskom-canonicalize-color (color)
  "Create a canonical string name for color COLOR.
COLOR must be a string (a color name)"
  (apply 'format 
         "#%02x%02x%02x"
         (mapcar (lambda (x) (lsh x -8))
                 (lyskom-color-values color))))

(defun lyskom-generate-faces-for-background (background)
  "Generate highlight faces for background BACKGROUND.
BACKGROUND must be a color name. This function updates
`lyskom-background-colors' and returns a list that has the same
structure as the value of an element in that list. See the documentation
for `lyskom-background-colors' for more information."
  (let* ((color (lyskom-canonicalize-color background))
         (cached (cdr (assoc color lyskom-background-faces))))
    (unless cached
      (let* ((text-body-face-name
              (intern (format "lyskom-generated-text-body-face-%s" color)))
             (dashed-lines-face-name
              (intern (format "lyskom-generated-dashed-lines-face-%s" color)))
             (async-text-body-face-name
              (intern (format "lyskom-generated-async-text-body-face-%s" color)))
             (async-dashed-lines-face-name
              (intern (format "lyskom-generated-async-dashed-lines-face-%s" color)))
             (predefined (cdr (assoc color lyskom-background-colors)))
             (weak (lyskom-get-color-highlight (lyskom-color-values background) 0.025))
             (strong (lyskom-get-color-highlight (lyskom-color-values background) 0.05))
             (text-body-color (or (cdr (assq 'text-body predefined)) weak))
             (dashed-lines-color (or (cdr (assq 'dashed-lines predefined)) strong))
             (async-text-body-color (or (cdr (assq 'async-text-body predefined)) weak))
             (async-dashed-lines-color (or (cdr (assq 'async-dashed-lines predefined)) strong))
             )
        (make-face text-body-face-name)
        (set-face-background text-body-face-name text-body-color)
        (make-face dashed-lines-face-name)
        (set-face-background dashed-lines-face-name dashed-lines-color)
        (make-face async-text-body-face-name)
        (set-face-background async-text-body-face-name async-text-body-color)
        (make-face async-dashed-lines-face-name)
        (set-face-background async-dashed-lines-face-name async-dashed-lines-color)
        (setq cached
              `((text-body ,text-body-face-name)
                (dashed-lines ,dashed-lines-face-name)
                (async-text-body ,async-text-body-face-name)
                (async-dashed-lines ,async-dashed-lines-face-name)))
        (setq lyskom-background-faces
              (cons (cons color cached) lyskom-background-faces))))
    cached))




;;; ================================================================
;;; Predefined faces
;;;
;;; There are two sets of predefined faces: the defaults and the
;;; user-defined faces. Users should not muck with the defaults.

(defface kom-face--default--active-face
  '((((background light))
     (:foreground "blue4")
     )
    (((background dark))
     (:foreground "lightblue")
     )
    )
  "Face suitable for most \"clickable\" areas.
Do not alter this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--active-strikethrough-face
  '((((background light))
     (:foreground "blue4"
      :strike-through t)
     )
    (((background dark))
     (:foreground "lightblue"
      :strike-through t)
     )
    )
  "Face suitable for some \"clickable\" areas.
Do not alter this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--active-highlight-face
  '((((background light))
     (:foreground "blue4"
      :weight bold)
     )
    (((background dark))
     (:foreground "lightblue"
      :weight bold)
     )
    )
  "Face suitable for some \"clickable\" areas.
Do not alter this face unless you know what you're doing."
  :group 'lyskom-faces
  )


(defface kom-face--default--url-face
  '((((background light))
     (:foreground "blueviolet")
     )
    (((background dark))
     (:foreground "moccasin")
     )
    )
  "Face suitable for URLs.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )


(defface kom-face--default--me-face
  '((((background light))
     (:foreground "blue3"
     :background "lavender"
     :weight bold)
     )
    (((background dark))
     (:foreground "gold"
     :background "black"
     :weight bold)
     )
    )
  "Face suitable for showing your own name.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )


(defface kom-face--default--highlight-face
  '((((background light))
     (:background "darkseagreen2")
     )
    (((background dark))
     (:background "darkblue")
     )
    )
  "Face suitable for various highlights.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--subject-face
  '((t nil))
  "Face suitable for subject lines.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--text-no-face
  '((((background light))
     (:foreground "blue4")
     )
    (((background dark))
     (:foreground "lightblue")
     )
    )
  "Face suitable for text numbers.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--friends-face
  '((((background light))
     (:foreground "blue3"
     :background "lavender")
     )
    (((background dark))
     (:foreground "red")
     )
    )
  "Face suitable for people in kom-friends.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--morons-face
  '((((background light))
     (:foreground "blue3"
     :background "#ffff60")
     )
    (((background dark))
     (:foreground "yellow")
     )
    )
  "Face suitable for people in kom-morons.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--presence-face
  '((((background light))
     (:foreground "dim gray"
     :slant italic)
     )
    (((background dark))
     (:foreground "gray"
     :slant italic)
     )
    )
  "Face suitable for presence messages.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )


(defface kom-face--default--mark-face
  '((((background light))
     (:foreground "blue3"
     :background "lavender")
     )
    (((background dark))
     (:foreground "gold"
     :background "black")
     )
    )
  "Face suitable for temporary marks.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )


(defface kom-face--default--first-line-face
  '((t (:weight bold)))
  "Face suitable for the first line header of each text.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--warning-face
  '((t (:weight bold :foreground "red")))
  "Face suitable for displaying important warnings.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )

(defface kom-face--default--dim-face
  '((t (:foreground "gray")))
  "Face suitable for dimmed items, such as passive memberships.
Do not change this face unless you know what you're doing."
  :group 'lyskom-faces
  )


;;; ----------------------------------------------------------------
;;; Dummy faces (copies of the default faces for uses to muck with.
;;;

(defface kom-face--user-defined--active-face
  '((((background light))
     (:foreground "blue4")
     )
    (((background dark))
     (:foreground "lightblue")
     )
    )
  "Face suitable for most \"clickable\" areas."
  :group 'lyskom-faces
  )


(defface kom-face--user-defined--active-strikethrough-face
  '((((background light))
     (:foreground "blue4"
      :strike-through t)
     )
    (((background dark))
     (:foreground "lightblue"
      :strike-through t)
     )
    )
  "Face suitable for some \"clickable\" areas."
  :group 'lyskom-faces
  )

(defface kom-face--user-defined--active-highlight-face
  '((((background light))
     (:foreground "blue4"
      :weight bold)
     )
    (((background dark))
     (:foreground "lightblue"
      :weight bold)
     )
    )
  "Face suitable for some \"clickable\" areas."
  :group 'lyskom-faces
  )


(defface kom-face--user-defined--url-face
  '((((background light))
     (:foreground "blueviolet")
     )
    (((background dark))
     (:foreground "moccasin")
     )
    )
  "Face suitable for URLs."
  :group 'lyskom-faces
  )


(defface kom-face--user-defined--me-face
  '((((background light))
     (:foreground "blue3"
     :background "lavender"
     :weight bold)
     )
    (((background dark))
     (:foreground "gold"
     :background "black"
     :weight bold)
     )
    )
  "Face suitable for showing your own name."
  :group 'lyskom-faces
  )


(defface kom-face--user-defined--highlight-face
  '((((background light))
     (:background "darkseagreen2")
     )
    (((background dark))
     (:background "darkblue")
     )
    )
  "Face suitable for various highlights."
  :group 'lyskom-faces
  )

(defface kom-face--user-defined--subject-face
  '((t nil))
  "Face suitable for subject lines."
  :group 'lyskom-faces
  )

(defface kom-face--user-defined--text-no-face
  '((((background light))
     (:foreground "blue4")
     )
    (((background dark))
     (:foreground "lightblue")
     )
    )
  "Face suitable for text numbers."
  :group 'lyskom-faces
  )

(defface kom-face--user-defined--friends-face
  '((((background light))
     (:foreground "blue3"
     :background "lavender")
     )
    (((background dark))
     (:foreground "red")
     )
    )
  "Face suitable for people in kom-friends."
  :group 'lyskom-faces
  )

(defface kom-face--user-defined--morons-face
  '((((background light))
     (:foreground "blue3"
     :background "yellow")
     )
    (((background dark))
     (:foreground "yellow")
     )
    )
  "Face suitable for people in kom-morons."
  :group 'lyskom-faces
  )

(defface kom-face--user-defined--presence-face
  '((((background light))
     (:foreground "dim gray"
     :slant italic)
     )
    (((background dark))
     (:foreground "gray"
     :slant italic)
     )
    )
  "Face suitable for presence messages."
  :group 'lyskom-faces
  )


(defface kom-face--user-defined--mark-face
  '((((background light))
     (:foreground "blue3"
     :background "lavender")
     )
    (((background dark))
     (:foreground "gold"
     :background "black")
     )
    )
  "Face suitable for temporary marks."
  :group 'lyskom-faces
  )


(defface kom-face--user-defined--first-line-face
  '((t (:weight bold)))
  "Face suitable for the first line header of each text."
  :group 'lyskom-faces
  )

(defface kom-face--user-defined--warning-face
  '((t (:weight bold :foreground "red")))
  "Face suitable for displaying important warnings."
  :group 'lyskom-faces
  )

(defface kom-face--user-defined--dim-face
  '((t (:foreground "gray")))
  "Face suitable for dimmed items, such as passive memberships."
  :group 'lyskom-faces
  )





(defvar lyskom-predefined-faces
  '((kom-active-face . (kom-face--default--active-face
                        kom-face--user-defined--active-face))
    (kom-url-face . (kom-face--default--url-face
                     kom-face--user-defined--url-face))
    (kom-me-face . (kom-face--default--me-face
                    kom-face--user-defined--me-face))
    (kom-highlight-face . (kom-face--default--highlight-face
                           kom-face--user-defined--highlight-face))
    (kom-text-face . (kom-face--default--text-face
                      kom-face--user-defined--text-face))
    (kom-subject-face . (kom-face--default--subject-face
                         kom-face--user-defined--subject-face))
    (kom-text-no-face . (kom-face--default--text-no-face
                         kom-face--user-defined--text-no-face))
    (kom-friends-face . (kom-face--default--friends-face
                         kom-face--user-defined--friends-face))
    (kom-morons-face . (kom-face--default--morons-face
                        kom-face--user-defined--morons-face))
    (kom-presence-face . (kom-face--default--presence-face
                          kom-face--user-defined--presence-face))
    (kom-first-line-face . (kom-face--default--first-line-face
                            kom-face--user-defined--first-line-face))
    (kom-warning-face . (kom-face--default--warning-face
                         kom-face--user-defined--warning-face))
    (kom-mark-face . (kom-face--default--mark-face
                      kom-face--user-defined--mark-face))
    (kom-dim-face . (kom-face--default--dim-face
                     kom-face--user-defined--dim-face))
    (kom-text-body-face . (kom-face--default--text-body-face
                           kom-face--user-defined--text-body-face))
    (kom-dashed-lines-face . (kom-face--default--dashed-lines-face
                              kom-face--user-defined--dashed-lines-face))
    (kom-async-text-body-face . (kom-face--default--async-text-body-face
                                 kom-face--user-defined--async-text-body-face))
    (kom-async-dashed-lines-face . (kom-face--default--async-dashed-lines-face
                                    kom-face--user-defined--async-dashed-lines-face))
    (kom-active-highlight-face . (kom-face--default--active-highlight-face
                                  kom-face--user-defined--active-highlight-face))
    (kom-active-strikethrough-face . (kom-face--default--active-strikethrough-face
                                      kom-face--user-defined--active-strikethrough-face))

    )
  "Alist of predefined faces suitable for each face variable.
Used for customization and nothing else."
)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: deferred-insert.el,v 44.6 2003/04/05 18:14:25 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: deferred-insert.el
;;;;
;;;; This file includes functions for deffering insertion of
;;;; information into the LysKOM buffer.
;;;;

;;;
;;; How to defer a peice of text:
;;; =============================
;;;
;;;  1. Insert some temporary text. Use the variable
;;;     `lyskom-defer-indicator' as a placeholder.
;;; 
;;;  2. Create a defer-info-structure by calling
;;;     `lyskom-create-defer-info' with the following parameters
;;;
;;;        SERVER-CALL - the call to get the data (initate-get-*)
;;;        CALL-ARG    - the argument for the server call. This is
;;;                      limited to a single argument, which is enough
;;;                      for get-conf-stat and friends.
;;;        HANDLER     - the function to be called to insert the
;;;                      "real" data.
;;;        POS         - a marker indicating where the insertion
;;;                      should be placed.
;;;        DEL-CHARS   - an integer indicating how many characters
;;;                      from POS on should be replaced by the "real"
;;;                      text.
;;;        FORMAT      - a format string for inserting the real
;;;                      data. This should normally only contain a
;;;                      single format atom using argument 1
;;;                      (i.e. "%#1P").
;;;        DATA        - any data that you might want to use in
;;;                      HANDLER.
;;;
;;;  3. Call `lyskom-defer-insertion' with the defer-info as argument.
;;;
;;;  4. Write a handler function that takes two arguments, the server
;;;     reply and the defer-info. This function should replace the
;;;     temporary text. A convenient way to do this is to use
;;;     `lyskom-replace-deferred'.
;;;
;;;  5. Sit back and watch it work.
;;;  
;;;  Notes:
;;;  
;;;  POS must be located before the temporary text. DEL-CHARS should
;;;  usually be set to (length lyskom-defer-indicator). Don't count on
;;;  it to be 5.
;;;
;;;  Steps 1 and 2 are often implemented the other way around, or at
;;;  least the POS parameter is determined before any text is
;;;  inserted.
;;;
;;;  You should only defer text if kom-deferred-printing is non-nil.
;;;



;;; Type: defer-info

(def-komtype defer-info 
  (server-call
   call-par
   handler
   pos
   del-chars
   format
   &optional
   data
   (last-viewed :automatic lyskom-last-viewed)))


(defun lyskom-defer-insertion (defer-info)
  "Defer insertion of something.
The insertion will be at (point)."
  (set-defer-info->last-viewed defer-info lyskom-last-viewed)
  ;; (goto-char (defer-info->pos defer-info))
  (if (and (defer-info->call-par defer-info)
           (listp (defer-info->call-par defer-info)))
      (apply (intern-soft (concat "initiate-"
				(symbol-name (defer-info->server-call
					       defer-info))))
	   'deferred
	   (defer-info->handler defer-info)
           (append (defer-info->call-par defer-info) (list defer-info)))
    (funcall (intern-soft (concat "initiate-"
                                  (symbol-name (defer-info->server-call
                                                 defer-info))))
             'deferred
             (defer-info->handler defer-info)
             (defer-info->call-par defer-info)
             defer-info)))

(defun lyskom-replace-deferred (defer-info &rest replacement-data)
  "Replace some defered text."
  (save-excursion
    (when (marker-buffer (defer-info->pos defer-info))
      (set-buffer (marker-buffer (defer-info->pos defer-info))))
    (goto-char (defer-info->pos defer-info))
    (apply 'lyskom-format-insert-at-point
	   (defer-info->format defer-info)
	   replacement-data)
    (let ((inhibit-read-only t))
      (delete-char (defer-info->del-chars defer-info)))
    (set-marker (defer-info->pos defer-info) nil))
  (if lyskom-executing-command
      nil
    (let ((window (get-buffer-window lyskom-buffer)))
      (if window
	  (if (pos-visible-in-window-p (point-max) window)
	      nil
	    ;; This means that this insertion moved point out of the
	    ;; window. The scrolling becomes tricky. One big problem is
	    ;; that we can't use lyskom-last-viewed, because it has been
	    ;; updated to the new prompt. Until that is solved we make
	    ;; sure that we never scroll.
	    ;;
	    ;; The solution is to save lyskom-last-viewed in the defer-info
	    (save-selected-window
	      (select-window window)
	      (lyskom-scroll))
	    )))))


(defun lyskom-deferred-insert-conf (conf-stat defer-info)
  "Insert the name of a conference at a previously reserved place."
  (lyskom-replace-deferred
   defer-info
   (if (null conf-stat)
       (lyskom-format 
	(or (defer-info->data defer-info)
	    (if (= (aref (defer-info->format defer-info)
			 (1- (length (defer-info->format defer-info))))
		   ?P)
		(if (= (defer-info->call-par defer-info) 0)
		    'person-is-anonymous
		  'person-does-not-exist)
	      'conference-does-not-exist))
	(defer-info->call-par defer-info))
     conf-stat)
   (text-properties-at (defer-info->pos defer-info))))


;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: utilities.el,v 44.160 2005/01/23 16:25:31 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: utilities.el
;;;;
;;;; This file contains general lisp utility functions and
;;;; lyskom-specific utility functions (such as date formatting and
;;;; minibuffer reading)
;;;;


(setq lyskom-clientversion-long
      (concat lyskom-clientversion-long
	      "$Id: utilities.el,v 44.160 2005/01/23 16:25:31 byers Exp $\n"))


(defvar coding-category-list)
(defun lyskom-check-configuration ()
  ;; Excuse my paranoia. This code is hardly tested at all, so I
  ;; really want it wrapped to prevent errors from breaking the
  ;; client. Plus it lets me check how to do stuff in Gnu Emacs 21
  ;; without worrying about compatibility with other versions.
  (when kom-check-configuration-on-startup
    (condition-case nil
        (progn
          ;; Check that we have MULE
          (when (and (>= emacs-major-version 20)
                     (boundp 'enable-multibyte-characters)
                     (not enable-multibyte-characters))
            (lyskom-format-insert 'no-mule-warning
                                  `(face ,kom-warning-face)
                                  ))

          ;; Check coding system
          (when (and enable-multibyte-characters
                     (not (memq 'utf-8
                                (lyskom-coding-system-get
                                 (symbol-value (car coding-category-list))
                                 'alias-coding-systems)))
                     (not (memq lyskom-server-coding-system
                                (lyskom-coding-system-get
                                 (symbol-value (car coding-category-list))
                                 'alias-coding-systems))))
            (lyskom-format-insert 'coding-system-mismatch-warning
                                  (symbol-value (car coding-category-list))
                                  lyskom-server-coding-system
                                  `(face ,kom-warning-face)
                                  ))
          )
      (error nil)
      )))

;;;
;;; Lisp utility functions
;;;

(defsubst listify-vector (vector)
  "Turn VECTOR into a list"
  (append vector nil))

(defun nfirst (n list)
  "Return a list of the N first elements of LIST."
  (let ((result nil))
    (while (and (> n 0) list)
      (setq result (cons (car list) result)
            list (cdr list)
            n (1- n)))
    (nreverse result)))

(defun lyskom-rotate-list (list el)
  "Destructively rotate LIST so EL becomes the first element.
If EL occurs more than one, the first occurrence is used."
  (let ((tail (memq el list)))
    (if (or (null tail) (eq el (car list)))
        list
      (setcdr (nthcdr (- (length list) (length tail) 1) list) nil)
      (setcdr (nthcdr (1- (length tail)) tail) list)
      tail)))

(defun lyskom-preceding-cons (list el)
  "Return the cons cell of LIST preceding the first cons cell whose car is EL.
Return nil if TAIL is the same as LIST or not a member of LIST."
  (unless (or (eq (car list) el)
              (not (memq el list)))
    (nthcdr (- (length list) (length (memq el list)) 1) list)))

(defun lyskom-insert-in-list (el list before)
  "Destructively insert EL in LIST before element BEFORE.
If BEFORE is not in the list, then insert EL at the end of the list."
  (cond ((eq before (car list))
         (cons el list))
        (t (setcdr (nthcdr (- (length list)
                              (length (memq before list)) 1) list)
                   (cons el (memq before list)))
           list)))

(defun lyskom-move-in-list (el list pos)
  "Destructively move EL within LIST so it appears at position POS."
  (when (memq el list)
    (setq list (delq el list))
    (cond ((eq 0 pos) (setq list (cons el list)))
          (t (setcdr (nthcdr (1- pos) list)
                     (cons el (nthcdr pos list))))))
  list)

;;;
;;; +++ FIXME: If cl.el can be guaranteed, this is pointless.
;;;

(defun lyskom-butlast (x &optional n)
  "Returns a copy of LIST with the last N elements removed."
  (if (and n (<= n 0)) x
    (lyskom-nbutlast (copy-sequence x) n)))

(defun lyskom-nbutlast (x &optional n)
  "Modifies LIST to remove the last N elements."
  (let ((m (length x)))
    (or n (setq n 1))
    (and (< n m)
	 (progn
	   (if (> n 0) (setcdr (nthcdr (- (1- m) n) x) nil))
	   x))))

(defun filter-list (test list)
  (let ((result nil))
    (lyskom-traverse el list
      (when (funcall test el)
        (setq result (cons el result))))
    (nreverse result)))

;;;============================================================
;;;
;;; Utility functions.
;;;
;;; These should be shared in LysKOM
;;;

(defun lyskom-ignore (&rest args)
  "Ignore all arguments"
  )

(defun lyskom-mapcar2 (fn seq1 seq2)
  (let (result)
    (while (and seq1 seq2)
      (setq result (cons (funcall fn (car seq1) (car seq2)) result))
      (setq seq1 (cdr seq1)
            seq2 (cdr seq2)))
    (nreverse result)))

(defun lyskom-maxint ()
  (let ((n 1) 
        (l nil)
        (i 31))
    (while (and (> n 0) (> i 0))
      (setq l (cons n l))
      (setq n (* 2 n))
      (setq i (1- i)))
    (apply '+ l)))

;; Set lyskom-maxint correctly

(setq lyskom-max-int (lyskom-maxint))


(defun lyskom-try-require (feature &optional message &rest args)
  "Load the feature FEATURE using require. 
If optional MESSAGE is non-nil, use it as a LysKOM format string 
taking one string argument to print an error message. Remaining
arguments are used as arguments for the format string.

Returns t if the feature is loaded or can be loaded, and nil otherwise."
  (or (featurep 'feature)
      (condition-case nil
          (progn (require feature)
                 t)
        (error 
         (when message
           (apply 'lyskom-format-insert-before-prompt message (symbol-name feature) args))
         nil))))


(defvar lyskom-apo-timeout 0
  "Current millisecond timeout value for accept-process-output")

(defvar lyskom-apo-timeout-index 0
  "Index in lyskom-apo-timeout-vector-max where last timeout is")

(defconst lyskom-apo-timeout-vector
  [0 1000 1000 2000 3000 5000 8000 13000 21000 34000 55000 89000 144000 233000 377000 610000]
  "Vector of timeout values (usecs) for accept-process-output")

(defconst lyskom-apo-timeout-vector-max (1- (length lyskom-apo-timeout-vector))
  "Maximum index in lyskom-apo-timeout-vector")

(defun lyskom-next-apo-timeout ()
  (if (< lyskom-apo-timeout-index lyskom-apo-timeout-vector-max)
      (setq lyskom-apo-timeout
            (aref lyskom-apo-timeout-vector
                  (setq lyskom-apo-timeout-index
                        (1+ lyskom-apo-timeout-index))))))

(defun lyskom-reset-apo-timeout ()
  (setq lyskom-apo-timeout-index -1)
  (setq lyskom-apo-timeout 0))

(defun lyskom-accept-process-output ()
  "Call accept-process-output with the correct timeout values."
  (lyskom-next-apo-timeout)
  (accept-process-output nil 0 lyskom-apo-timeout))

(defun lyskom-set-alist (alist item value)
  "Modifies (non-destructively) an alist ALIST to set item
ITEM to the value VALUE."
  (let ((pair (assq item alist)))
     (if pair
         (progn (setcdr pair value) alist)
       (cons (cons item value) alist))))


;;;
;;; WARNING!
;;;
;;; The following variable is *important* if you fuck it up in any
;;; way, the functions used to read conference names won't work. So if
;;; you change it, try to work one character at a time, and when
;;; you're done, run through the mappings of all 256 characters to
;;; make sure they look OK.
;;;
;;; Make sure your MULE Emacs doesnt fuck it up for you. It did for me.
;;;

(defvar lyskom-default-collate-table
  "\000\001\002\003\004\005\006\007\010 \012\013\014\015\016\017\020\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]~\200\201\202\203\204\205\206\207\210\211\212\213\214\215\216\217\220\221\222\223\224\225\226\227\230\231\232\233\234\235\236\237!AAAA[]ACEEEEIIIINOOOO\\OUUUYYAAAA[]ACEEEEIIIINOOOO\\OUUUYY"
  "String mapping characters to their collate class.

Lowercase, uppercase and other equivalents are mapped to the same class.
The class number defines a proper sorting order.")


(defsubst lyskom-maybe-recode-string (s &optional coding force)
  "Change the encoding of S for when multibyte characters are not supported.
Optional second argument CODING is the coding system to use. If optional
third argument FORCE is non-nil, always encode multibyte strings, otherwise
only encode when multibyte strings are not supported."
  (if (and (lyskom-multibyte-string-p s)
           (or force (not enable-multibyte-characters)))
      (lyskom-encode-coding-string s (or coding
                                         (and lyskom-language
                                              (lyskom-language-coding lyskom-language))
                                         'raw-text))
    s))

(defun lyskom-recode-string-for-title (s coding)
  "Encode S with CODING for use in frame titles.
Attempts to encode the string only in Emacs versions that do not require
MULE coding for frame titles"
  (cond
   ((memq window-system '(win32 mswindows w32))
    (lyskom-maybe-recode-string s coding t))
   ((> emacs-major-version 20) s)
   (t (lyskom-maybe-recode-string s coding t))))

(defun lyskom-maybe-frob-completion-table (table &optional copy)
  "Recode the cars of alist TABLE to default coding system unless multibyte
characters are enabled. This function is destructive unless optional copy
is non-nil."
  (cond (enable-multibyte-characters table)
	(copy (mapcar (lambda (el)
			(cons (lyskom-maybe-recode-string (car el) nil t)
			      (cdr el)))
                      table))
	(t (lyskom-traverse el table
		(setcar el (lyskom-maybe-recode-string (car el) nil t)))
	   table)))


(defsubst lyskom-unicase-char (c)
  "Smash case and diacritical marks on c." 
  (if (< (lyskom-char-to-int c) (length lyskom-collate-table))
      (aref lyskom-collate-table (lyskom-char-to-int c))
    (setq c (lyskom-encode-coding-char c lyskom-server-coding-system))
    (if (and c (< (lyskom-char-to-int c) (length lyskom-collate-table)))
	(aref lyskom-collate-table (lyskom-char-to-int c))
      c)))

(defun lyskom-unicase (s)
  "Smash case and diacritical marks of all chars in s." 
  (lyskom-save-excursion
   (and lyskom-buffer (set-buffer lyskom-buffer))
   (let* ((s2 (string-to-vector 
               (lyskom-encode-coding-string s lyskom-server-coding-system)))
          (l (length s2)))
     (while (> l 0)
       (setq l (1- l))
       (aset s2 l (lyskom-unicase-char (aref s2 l))))
     (concat s2))))

(defun lyskom-looking-at (s)
  "Version of looking-at that will work in Gnu Emacs 20.3"
  (save-excursion
    (let ((start (point)))
      (and (re-search-forward s nil t)
	   (eq (match-beginning 0) start)))))

;; Don't slow things down with our own looking-at unless we have to

(eval-and-compile
 (condition-case nil
     (if (and (eq emacs-major-version 20)
	      (eq emacs-minor-version 3))
	 nil
       (fset 'lyskom-looking-at (symbol-function 'looking-at)))
   (error nil)))


(defun lyskom-compute-char-classes (map)
  "Find out which characters that are equivalent according to MAP.

MAP should be a collate table.

The return value is an assoc list, which characters as keys, and a
list of single-character strings as values.  Only characters that are
equivalent to at least one more character is returned in the assoc
list.

Example: if this function returns

	((97 \"A\" \"a\")
         (65 \"A\" \"a\")
	 (48 \"O\" \"o\" \"0\")
	 (111 \"O\" \"o\" \"0\")
	 (79 \"O\" \"o\" \"0\"))

it means that a and A are equivalent, and o, O and 0 are equivalent.
All other characters are unique."

  (lyskom-save-excursion
    (and lyskom-buffer (set-buffer lyskom-buffer))
    (let ((ix (length map))
	  (cls-to-strings nil)) ;assoc-list from equivalence class to
				;list of chars
      (while (> ix 0)
	(setq ix (1- ix))
	(let* ((cls (aref map ix))
	       (str (lyskom-decode-coding-string (concat (vector ix))
                                                 lyskom-server-coding-system))
	       (elem (assoc cls cls-to-strings)))
	  (if elem
	      (rplacd elem (cons str (cdr elem)))
	    (setq cls-to-strings (cons (list cls str) cls-to-strings)))))
      (let ((res nil))
	(while cls-to-strings
	  (let ((lst (cdr (car cls-to-strings))))
	    (if (> (length lst) 1)
		(while lst
		  (setq res (cons (cons (string-to-char (car lst))
					(cdr (car cls-to-strings)))
				  res))
		  (setq lst (cdr lst)))))
	  (setq cls-to-strings (cdr cls-to-strings)))
	res))))
    
;; Stolen from thingatpt.el
;; FIXME: We may not really need this function. Check the callers.

(defun lyskom-thing-at-point-looking-at (regexp)
  "Return non-nil if point is in or just after a match for REGEXP.
Set the match data from the earliest such match ending at or after
point."
  (save-excursion
    (let ((old-point (point)) match)
      (and (looking-at regexp)
	   (>= (match-end 0) old-point)
	   (setq match (point)))
      ;; Search back repeatedly from end of next match.
      ;; This may fail if next match ends before this match does.
      (re-search-forward regexp nil 'limit)
      (while (and (re-search-backward regexp nil t)
		  (or (> (match-beginning 0) old-point)
		      (and (looking-at regexp) ; Extend match-end past search start
			   (>= (match-end 0) old-point)
			   (setq match (point))))))
      (if (not match) nil
	(goto-char match)
	;; Back up a char at a time in case search skipped
	;; intermediate match straddling search start pos.
	(while (and (not (bobp))
		    (progn (backward-char 1) (looking-at regexp))
		    (>= (match-end 0) old-point)
		    (setq match (point))))
	(goto-char match)
	(looking-at regexp)))))


;; Stolen from Gnu Emacs

(defun lyskom-truncate-string-to-width (str end-column &optional trailer)
  "Truncate string STR to end at column END-COLUMN.

If optional TRAILER is non-nil, it is a string to append if STR is
truncated. The total width will still be at most END-COLUMN."
  (when (and trailer (>= (lyskom-string-width trailer) end-column))
    (setq trailer nil))

  (cond ((< (lyskom-string-width str) end-column) str)
        (t (when trailer 
             (setq end-column (- end-column (lyskom-string-width trailer))))
           (let ((idx 0)
                 (column 0)
                 (len (length str))
                 ch last-column last-idx)

             (condition-case nil
                 (while (< column end-column)
                   (setq last-column column
                         last-idx idx
                         ch (aref str idx)
                         column (+ column (lyskom-char-width ch))
                         idx (1+ idx)))
               (args-out-of-range (setq idx len)))
             (if (> column end-column)
                 (setq column last-column idx last-idx))
             (setq str (substring str 0 idx))
             (when trailer
               (setq str (concat str trailer)))
             str))))



(defun lyskom-buffer-display-message (string &optional buffer)
  (let* ((inhibit-read-only t)
         (buffer (or buffer (current-buffer)))
         (window (cdr 
                  (assoc (selected-frame)
                         (mapcar (lambda (x) (cons (window-frame x) x))
                                 (get-buffer-window-list buffer))))))
    (erase-buffer)
    (unless window (setq window (display-buffer buffer)))
    (select-window window)
    (delete-other-windows window)
    (insert (make-string (/ (window-height window) 3) ?\n))
    (insert string)
    (center-region (point-min) (point-max))
    (goto-char (point-min))
    (fundamental-mode)
    (toggle-read-only t)))


(eval-and-compile
  (lyskom-xemacs-or-gnu
   (fset 'lyskom-string= (symbol-function 'string=))
   (if (< emacs-major-version 20)
       (fset 'lyskom-string= (symbol-function 'string=))
     (defun lyskom-string= (s1 s2)
       (string= (and s1 (if (lyskom-multibyte-string-p s1)
		    s1
		  (lyskom-decode-coding-string s1 (lyskom-language-coding
					    lyskom-language))))
		(and s2 (if (lyskom-multibyte-string-p s2)
		    s2
		  (lyskom-decode-coding-string s2 (lyskom-language-coding
					    lyskom-language)))))))))

(defun lyskom-string-assoc (key list)
  "Return non-nil if KEY is the same string as the car of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (car (car list))))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-string-member (key list)
  "Return non-nil if KEY is the same string as the car of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (car list)))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-string-rassoc (key list)
  "Return non-nil if KEY is the same string as the cdr of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (cdr (car list))))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-set-default (sym val)
  "Set the value of SYM in the LysKOM buffer to VAL."
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (set sym val)))

(defun lyskom-default-value (sym)
  "Get the value of SYM in the LysKOM buffer"
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (symbol-value sym)))

(defun lyskom-default-value-safe (sym)
  "Get the value of SYM in the LysKOM buffer"
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (and (boundp sym) (symbol-value sym))))


;;; ============================================================
;;; Prefix arguments

(defun lyskom-get-ancestors-of-text (text-no level)
  "Returns a list of all ancestors of TEXT-NO that are LEVEL
comment/foot-note levels up the comment tree. LEVEL is a
non-negative integer and 0 means the given text-no."
  (if (< level 1)
      (list text-no)
    (let* ((text-stat (blocking-do 'get-text-stat text-no))
	   (ancestors (and text-stat
			   (lyskom-text-stat-commented-texts text-stat)))
	   (level (1- level))
	   (result '()))
	(while ancestors
	  (setq result
		(lyskom-union
		 (lyskom-get-ancestors-of-text (car ancestors) level)
		 result
                 ))
	  (setq ancestors (cdr ancestors)))
	result)))

(defun lyskom-maybe-get-commented-text ()
  (let* ((text-no (lyskom-text-at-point))
         (text-stat (and text-no (blocking-do 'get-text-stat text-no))))
    (when text-no
      (if (lyskom-misc-infos-from-list 
           'COMM-IN (text-stat->misc-info-list text-stat))
          text-no
        (lyskom-get-text-at-point-ancestor 1)))))

(defun lyskom-maybe-get-footnoted-text ()
  (let* ((text-no (lyskom-text-at-point))
         (text-stat (and text-no (blocking-do 'get-text-stat text-no))))
    (when text-no
      (if (lyskom-misc-infos-from-list 
           'FOOTN-IN (text-stat->misc-info-list text-stat))
          text-no
        (lyskom-get-text-at-point-ancestor 1)))))

(defun lyskom-get-last-read-text ()
  (lyskom-default-value 'lyskom-current-text))

(defun lyskom-get-previous-text ()
  (lyskom-default-value 'lyskom-previous-text))

(defun lyskom-get-text-at-point ()
  (lyskom-text-at-point))

(defun lyskom-get-text-at-point-ancestor (arg)
  (let* ((text (lyskom-text-at-point))
	 (cnos (and text (lyskom-get-ancestors-of-text text arg)))
	 (txts (length cnos)))
    (cond
     ((not text)
      (lyskom-error (lyskom-get-string 'no-text-at-point)))
     ((eq txts 0)
      (lyskom-error (lyskom-get-string 'no-comment-to)))
     ((eq txts 1)
      (car cnos))
     (t
      (lyskom-read-number (lyskom-get-string 'what-ancestor) 
                          (car cnos)
                          nil
                          nil
                          cnos)))))

(defun lyskom-get-last-text-written-by-me ()
  (lyskom-default-value 'lyskom-last-written))

(defun lyskom-get-last-written-or-read-by-me ()
  (lyskom-default-value 'lyskom-last-seen-written))

(defun lyskom-get-text-above-point (arg)
  (save-excursion
    (let ((former-point (point)))
      (backward-text (+ 1 arg))
      (if (looking-at "\\([0-9]+\\)\\s-")
	  (string-to-int (match-string 1))
	(progn ;; we probably ended up above the first message in the buffer
	  (forward-text)
	  (if (and (< (point) former-point)
		   (looking-at "\\([0-9]+\\)\\s-"))
	      (string-to-int (match-string 1))
	    (lyskom-error (lyskom-get-string 'bad-text-no-prefix) arg)))))))

(defun lyskom-get-text-below-point (arg)
  (if (and (numberp arg) (> arg 20))
      arg
    (save-excursion
      (let ((former-point (point)))
        (forward-text arg)
        (if (looking-at "\\([0-9]+\\)\\s-")
            (string-to-int (match-string 1))
          (progn ;; we probably ended up below the final message in the buffer
            (backward-text)
            (if (and (> (point) former-point)
                     (looking-at "\\([0-9]+\\)\\s-"))
                (string-to-int (match-string 1))
              (lyskom-error (lyskom-get-string 'bad-text-no-prefix) arg))))))))

(defun lyskom-read-text-no-prompt-p (command)
  "Return non-nil if the COMMAND should prompt for a text number."
  (let ((check (assq command kom-text-no-prompts)))
    (if check (cdr check) (memq command lyskom-text-no-prompts-defaults))))

;;; ------------------------------------------------------------
;;; Constraints

(defun lyskom-text-written-by-me-p (text-no)
  (let ((text-stat (blocking-do 'get-text-stat text-no)))
    (and text-stat
         (lyskom-is-supervisor (text-stat->author text-stat)
                               lyskom-pers-no))))



;;; ------------------------------------------------------------
;;; Functions used in predicates and strategies

(defun lyskom-eq-dash (e) (eq e '-))

(defun lyskom-tnpa-prompt (text-nos)
  (lyskom-tnpa-add-property text-nos 'prompt))

(defun lyskom-tnpa-valid (text-nos)
  (lyskom-tnpa-add-property text-nos 'valid))

(defun lyskom-tnpa-add-property (text-nos what)
  (cond ((numberp text-nos) (vector text-nos (list what)))
        ((vectorp text-nos)
         (aset text-nos 1 (cons what (aref text-nos 1)))
         text-nos)
        ((and text-nos (listp text-nos))
         (mapcar (lambda (el)
                   (cond ((vectorp el) (aset el 1 (cons what (aref el 1))))
                         (t (vector el (list what)))))
                 text-nos))))

(defsubst lyskom-tnpa-text-no (el)
  (if (vectorp el) (aref el 0) el))

(defsubst lyskom-tnpa-text-property (el prop)
  (and (vectorp el) (memq prop (aref el 1))))



;;; ------------------------------------------------------------
;;; The main function

(defun lyskom-tnpa-apply-strategy (strategies filter-spec constraint-spec)
  (let ((filter-locl (car (cdr (memq :filter strategies))))
        (constraint-locl (car (cdr (memq :constraint strategies)))))
    (lyskom-traverse strategy strategies
      (if (memq strategy '(:filter :constraint :save))
          (lyskom-traverse-break)
        (let ((tmp (cond ((functionp strategy) (funcall strategy))
                         ((and (symbolp strategy) (boundp strategy)) (symbol-value strategy))
                         (t nil))))
          (unless (listp tmp) (setq tmp (list tmp)))
          (when filter-locl (setq tmp (mapcar filter-locl tmp)))
          (when filter-spec (setq tmp (mapcar filter-spec tmp)))
          (when (or constraint-spec constraint-locl)
            (setq tmp 
                  (delq nil (mapcar (lambda (el)
                                      (when (or (lyskom-tnpa-text-property el 'valid)
                                                (and (or (null constraint-locl)
                                                         (funcall constraint-locl (lyskom-tnpa-text-no el)))
                                                     (or (null constraint-spec)
                                                         (funcall constraint-spec (lyskom-tnpa-text-no el)))))
                                        el))
                                    tmp))))
          (when tmp (lyskom-traverse-break (car tmp))))))))



(defun lyskom-read-text-no-prefix-arg (prompt &optional command)
  (when (listp prompt) (setq prompt (car prompt)))
  (let* ((command (or command lyskom-current-command this-command))
         (command-spec (cdr (assq command kom-pick-text-no-strategy-alist)))
         (refer-spec (car (cdr (memq :refer command-spec))))
         (default-spec (cdr (assq t kom-pick-text-no-strategy-alist)))
         (filter-spec (car (cdr (or (memq :filter command-spec)
                                    (memq :filter default-spec)))))
         (constraint-spec (car (cdr (or (memq :constraint command-spec)
                                        (memq :constraint default-spec)))))
         (text nil))

    (if refer-spec
        (lyskom-read-text-no-prefix-arg prompt refer-spec)

      ;; Traverse all strategy lists, in the appropriate order.
      ;; Identical predicates are only called once. We traverse
      ;; command-spec and default-spec until we find an applicable
      ;; element (one that matches the prefix argument). When we find
      ;; that element, we call its strategies until we find one that
      ;; generates a result that passes the filter and the constraint.
      ;;
      ;; If we never find an element, we use the t predicates in the
      ;; specification. These are fallbacks and only applied if no
      ;; strategy provides a text number.
      ;;
      ;; The exit from this block should give us a text (perhaps with
      ;; properties) that we can either use or prompt for.
      ;;
      ;; Using catch and throw significantly simplifies this code.

      (setq text
            (catch 'lyskom-tnpa-text
              (let ((handled nil))
                (lyskom-traverse spec-list (list command-spec default-spec)
                  (lyskom-traverse el spec-list
                    (if (not (listp el))
                        (lyskom-traverse-break) ; We hit :filter or something like that
                      (cond
                       ((memq (car el) handled)) ; Already handled once
                       ((eq (car el) t)) ; Defaults are handled after this loop
                       ((or (eq (car el) current-prefix-arg)
                            (condition-case nil (funcall (car el) current-prefix-arg) (error nil)))

                        ;; The predicate matches the perfix argument, so now we can
                        ;; evaluate the strategies.

                        (let ((tmp (lyskom-tnpa-apply-strategy (cdr el) filter-spec constraint-spec)))
                          (when tmp (throw 'lyskom-tnpa-text tmp)))))
                      (setq handled (cons (car el) handled))))))

              ;; The strategies failed to yield anything useful Apply
              ;; the default strategies, both from the command and from
              ;; the default strategy list..

              (throw 'lyskom-tnpa-text
                     (or (lyskom-tnpa-apply-strategy (cdr (assq t command-spec)) filter-spec constraint-spec)
                         (lyskom-tnpa-apply-strategy (cdr (assq t default-spec)) filter-spec constraint-spec)))
              ))

      ;; We now have a text that fits the constraint. Really, the only
      ;; thing to do at this point is prompt for the text, if that is
      ;; requested.

      (if (or (not (lyskom-tnpa-text-no text))
              (lyskom-tnpa-text-property text 'prompt)
              (lyskom-read-text-no-prompt-p lyskom-current-command))
          (lyskom-read-number prompt (or (lyskom-tnpa-text-no text)
                                         (lyskom-default-value 'lyskom-current-text)))
        (lyskom-tnpa-text-no text)))))

;;; ============================================================
;;; Set functions

(defun lyskom-subset-p (a b)
  "Return non-nil if A is a subset of B"
  (let ((result t))
    (while a
      (if (memq (car a) b)
          (setq a (cdr a))
        (setq result nil a nil)))
    result))

(defun lyskom-intersection (a b)
  "Returns as a list the intersection of list A and list B.
The order of the list a is kept."
  (if (or a b)
      (let ((list nil))
        (while a
          (if (memq (car a) b)
              (setq list (cons (car a) list)))
          (setq a (cdr a)))
        (nreverse list))))

(defun lyskom-union (a b)
  "Returns a list containing the union of list A and list B.
Specifically, concatenate all elements of B that are not in A
to the end of A. This operation is destructive and modifies the
list pointed to by A."
  (let ((result nil))
    (lyskom-traverse x b
      (unless (memq x a) (setq result (cons x result))))
    (nconc a (nreverse result))))

(defun lyskom-delete-duplicates (list &optional key)
  "Removes all but one instance of each element in LIST.
If optional argument KEY is non-nil, apply KEY to each element before
comparison. Comparison is done with eq."
  (let ((clist (mapcar (lambda (el)
                         (if key
                             (cons (funcall key el) el)
                           (cons el el)))
                       list))
        (result nil))
    (lyskom-traverse el clist
      (unless (assq (car el) result)
        (setq result (cons el result))))
    (nreverse (mapcar 'cdr result))))

(defun lyskom-plusp (int)
  "Returns t for integers greater than 0, nil otherwise."
  (and (integerp int) (> int 0)))

(defun lyskom-minusp (int)
  "Returns t for integers smaller than 0, nil otherwise."
  (and (integerp int) (< int 0)))



;;; ======================================================================
;;; LysKOM Hooks
;;;

(defun lyskom-run-hook-with-args (hook &rest args)
  "Run HOOK with the specified arguments ARGS in the LysKOM buffer.
See run-hook-with-args for detailed information."
  (lyskom-save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                              lyskom-buffer)
                                         (current-buffer)))
                  (apply 'run-hook-with-args hook args)))



(defun lyskom-add-hook (hook function &optional append)
  "Add to the value of HOOK the function FUNCTION in the LysKOM buffer.
If optional APPEND is non-nil, add at the end of HOOK."
  (save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                       lyskom-buffer)
                                  (current-buffer)))
                  (add-hook hook function append t)))

(defun lyskom-remove-hook (hook function)
  "From the value of HOOK remove the function FUNCTION in the LysKOM buffer."
  (save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                       lyskom-buffer)
                                  (current-buffer)))
                  (remove-hook hook function t)))




;;; ======================================================================
;;; Printing
;;;
;;; XEmacs princ does not insert text properties. This function is based
;;; on the C code for princ. 
;;;

(defun lyskom-princ (object &optional stream)
  "Output the printed representation of OBJECT, any Lisp OBJECT.
No quoting characters are used; no delimiters are printed around
the contents of strings. Text properties are retained.

Output stream is STREAM, or value of standard-output, and must be a
buffer or a marker. Function or minibuffer streams are not supported
for strings."
  (if (not (stringp object))
      (princ object stream)
    (let ((old-point nil)
          (start-point nil)
          (old-buffer (current-buffer)))
      (unwind-protect
          (progn
            (cond ((bufferp stream) (set-buffer stream))
                  ((markerp stream) 
                   (setq old-point (point))
                   (set-buffer (marker-buffer stream))
                   (goto-char stream)
                   (setq start-point (point)))
                  ((null stream)
                   (cond ((bufferp standard-output) (set-buffer standard-output))
                         ((markerp standard-output) 
                          (setq old-point (point))
                          (set-buffer (marker-buffer standard-output))
                          (goto-char standard-output)
                          (setq start-point (point))))))

            (insert object))
        (cond ((markerp stream) 
               (set-marker stream (point))
               (if (>= old-point start-point)
                   (goto-char (+ old-point (- (point) start-point)))
                 (goto-char old-point))))
        (set-buffer old-buffer)))))


;;; ======================================================================
;;; Faces
;;;

(make-face 'lyskom-weak-highlight-face)
(make-face 'lyskom-strong-highlight-face)

(defun lyskom-copy-face (old new)
  (lyskom-xemacs-or-gnu (copy-face old new nil nil nil 'remove-all)
                        (copy-face old new)))



;;; ============================================================
;;; Date and time utilities

(defun lyskom-current-client-time ()
  "Return time representing current client time."
  (let ((now (decode-time)))
    (lyskom-create-time (elt now 0)     ;sec
                        (elt now 1)     ;min
                        (elt now 2)     ;hour
                        (elt now 3)     ;mday
                        (elt now 4)     ;mon
                        (elt now 5)     ;year
                        (elt now 6)     ;wday
                        0               ;yday
                        (if (elt now 7) ;isdst
                            1
                          0)
                        )))

(defun lyskom-current-server-time ()
  "Return time representing current server time."
  (blocking-do 'get-time))

(defun lyskom-format-time (format &optional time)
  "Return TIME as a string formatted as FORMAT.

FORMAT may be a string or a symbol.  If it is a symbol, it is
interpreted as follows:

    'date-and-time  Include date and time. [1][2]
    'date           Include just date. [1]
    'time           Include just time. [2]

    [1] If kom-print-seconds-in-time-strings is nil, only hours and
    minutes will be included in the time; if it is non-nil, seconds
    will also be included.
    [2] If kom-print-relative-dates is non-nil and the date is today's
    or yesterday's, the string \"today\" or \"yesterday\" (respectively)
    is used instead of the standard date format.

If FORMAT is a symbol but not one of the symbols listed above, the
format string will be looked up with lyskom-get-string.  The
timeformat-* strings are tailored to be used as formats for this
function.

The arguments to the format string are (in order): year, month number
\(starting with one for January), day-of-month number, hour, minute,
second, full name of the day of the week, abbreviated name of the day
of the week.

TIME defaults to the current client time."
  (let* ((time (or time (lyskom-current-client-time)))
         (fmt (cond
               ((stringp format)
                format)
               ((memq format '(date-and-time date time))
                (lyskom-format (cond ((eq format 'date-and-time)
                                      'format-time-date-and-time)
                                     ((eq format 'date)
                                      'format-time-just-date)
                                     ((eq format 'time)
                                      'format-time-just-time))
                               (lyskom-get-string
                                (or (and kom-print-relative-dates
                                         (lyskom-calculate-day-diff time))
                                    'timeformat-yyyy-mm-dd))
                               (lyskom-get-string
                                (if kom-print-seconds-in-time-strings
                                    'timeformat-hh-mm-ss
                                  'timeformat-hh-mm))))
               ((symbolp format)
                (lyskom-get-string format))
               (t (error "Invalid argument")))))
    (lyskom-format fmt
                   (time->year time)
                   (time->mon  time)
                   (time->mday time)
                   (time->hour time)
                   (time->min  time)
                   (time->sec  time)
                   (elt (lyskom-get-string 'weekdays)
                        (time->wday time))
                   (elt (lyskom-get-string 'weekdays-short)
                        (time->wday time)))))


;;; ============================================================
;;; Keymap utilities

(defun lyskom-lookup-key (keymap event &optional accept-default)
  (if (not (arrayp event))
      (setq event (vector event)))
  (if (null keymap)
      (and accept-default 
           (lookup-key global-map event))
    (or (lookup-key keymap event)
        (lyskom-lookup-key (keymap-parent keymap) event accept-default))))

(defun lyskom-keymap-body (keymap)
  (setq keymap (cdr keymap))
  (cond ((arrayp (car keymap)) (car keymap))
        (t keymap)))

(defun lyskom-keymap-realbinding (binding)
  (while (stringp (car-safe binding))
    (setq binding (cdr binding)))
  binding)

(defun lyskom-overlay-keymap (basemap overlay keymap &optional prefix)
  (let ((keys (make-vector (1+ (length prefix)) nil))
        (index (length prefix))
        (body nil)
        (r 0))

    (while (< r (length prefix))
      (aset keys r (aref prefix r))
      (setq r (1+ r)))

    (cond ((not (keymapp keymap)))
          ((not (keymapp overlay)))
          ((not (keymapp basemap)))

          ((setq body (lyskom-keymap-body overlay))
           (mapcar
            (function
             (lambda (element)
               (cond ((arrayp element)
                      (let ((len (length element)))
                        (setq r 0)
                        (while (< r len)
                          (aset keys index r)
                          (lyskom-overlay-keys keys (aref element r)
                                               basemap overlay keymap)
                          (setq r (1+ r)))))

                     ((consp element)
                      (when (not (eq t (car element)))
                        (aset keys index (car element))
                        (lyskom-overlay-keys keys
                                             (lyskom-keymap-realbinding
                                              (cdr element))
                                             basemap overlay keymap)))

                     (t nil))))
            body)))))


(defun lyskom-overlay-keys (keys binding basemap overlay keymap)
  (let ((base-binding (lyskom-lookup-key basemap keys nil)))

   ;; If the binding is a keymap or prefix and
   ;; the binding in the base is a keymap or prefix 
   ;; then recurse

   (cond ((and (keymapp binding)
               (keymapp base-binding))
          (lyskom-overlay-keymap basemap binding keymap keys))

   ;; If the binding is a keymap or prefix and
   ;; we are bound in the base
   ;; then don't recurse

         ((and (keymapp binding)
               base-binding) nil)

   ;; If we are not bound in the base
   ;; copy the binding

         ((and binding
               (null base-binding)) (define-key keymap keys binding)))))

(defun lyskom-traverse-keymap (fn keymap)
  "Like lyskom-map-keymap, but traverses parent links too."
  (let ((parent (keymap-parent keymap)))
    (lyskom-map-keymap fn keymap)
    (when (keymapp parent) (lyskom-traverse-keymap fn parent))))


;;;
;;; Stuff
;;;

(defun lyskom-return-membership-type (mt)
  "Return a text description of membership type mt"
  (let ((tmp
         (mapconcat 
          'identity
          (delete nil
                  (list (if (membership-type->invitation mt) (lyskom-get-string 'invitation-mt-type) nil)
                        (if (membership-type->passive mt) (lyskom-get-string 'passive-mt-type) nil)
                        (if (membership-type->secret mt) (lyskom-get-string 'secret-mt-type) nil)
                        (if (eq (membership-type->message-flag mt)
                                (membership-type->passive mt))
                            (lyskom-get-string (if (membership-type->message-flag mt)
                                                   'message-flag-on-mt-type
                                                 'message-flag-off-mt-type)))))
          ", ")))
    (if (string= tmp "") 
        tmp
      (concat "[" tmp "]"))))

(defun lyskom-find-unread (conf-no)
  "Return the number of unread texts in CONF-NO.
If this function is unable to calculate the number of unread texts it will
return nil."
  (save-excursion
   (set-buffer lyskom-buffer)
   (let ((rlist (read-list->all-entries lyskom-to-do-list))
         (found nil))
     (while (and (not found) rlist)
       (when (eq conf-no (conf-stat->conf-no
                          (read-info->conf-stat (car rlist))))
         (setq found (text-list->length (read-info->text-list (car rlist)))))
       (setq rlist (cdr rlist)))
     found)))

(defun lyskom-prev-area (num prop &optional goto-point-min)
  (while (> num 0)
    (let ((where (previous-single-property-change (point) prop)))
      (cond (where
             (if (not (get-text-property where prop))
                 (setq where (previous-single-property-change 
                              where prop)))
             (if where
                 (goto-char where)
               (goto-char (point-min))
               (setq num 1)))
            (goto-point-min (goto-char (point-min))
                            (setq num 1))))
    (setq num (1- num))))

(defun lyskom-next-area (num prop &optional goto-point-max)
  "Move the cursor to the next prompt in the LysKOM buffer"
  (interactive "p")
  (while (> num 0)
    (let ((where (next-single-property-change (point) prop)))
      (cond (where
             (if (not (get-text-property where prop))
                 (setq where (next-single-property-change where prop)))
             (if where
                 (goto-char where)
               (goto-char (point-max))
               (setq num 1)))
            (goto-point-max (goto-char (point-max))
                            (setq num 1))))
      (setq num (1- num))))

;;; ============================================================
;;; Database stuff

(defun lyskom-get-send-comments-to (conf-no &optional want-type)
  "Get the send-comments-to value for conference CONF-NO.
Returns nil if there is no send-comments-to set.

f WANT-TYPE is set, return as a conf (RECPT . TYPE), wher RECPT
is the conference to use and TYPE is the type of recipient (numeric)."
  (let* ((conf-stat (if (numberp conf-no)
                        (blocking-do 'get-conf-stat conf-no)
                      conf-no))
         (send-comments-to
          (and conf-stat 
               (car (lyskom-get-aux-item (conf-stat->aux-items conf-stat) 33))))
         (result (when send-comments-to
                   (cond ((string-match "^\\([0-9]+\\)\\s-+\\([0-9]+\\)" (aux-item->data send-comments-to))
                          (cons (string-to-number
                                 (match-string 1 (aux-item->data send-comments-to)))
                                (string-to-number
                                 (match-string 2 (aux-item->data send-comments-to)))))
                         ((string-match "^\\([0-9]+\\)"
                                        (aux-item->data send-comments-to))
                          (cons (string-to-number
                                 (match-string 1 (aux-item->data send-comments-to)))
                                0))
                         (t nil)))))
    (if want-type result (car result))))
    
(defun lyskom-get-all-conferences (&optional feep)
  "Return a list of all conferences.
If FEEP is non-nil, show progress messages"
  (and feep (lyskom-message (lyskom-get-string 'getting-all-confs)))
  (prog1 (mapcar 'conf-z-info->conf-no
                 (conf-z-info-list->conf-z-infos
                  (blocking-do 'lookup-z-name "" nil t)))
    (and feep (lyskom-message (lyskom-get-string 'getting-all-confs-done)))))

(defun lyskom-is-supervisor (conf-no viewer-no)
  "Return non-nil if the supervisor of CONF-NO is VIEWER-NO."
  (or (eq viewer-no conf-no)
      (lyskom-is-strictly-supervisor conf-no viewer-no)))

(defun lyskom-is-strictly-supervisor (conf-no viewer-no)
  "Return non-nil if VIEWER-NO is strictly a supervisor of CONF-NO

Cannot be called from a callback."
  (let ((collector (make-collector))
        (conf-stat nil))
    (initiate-get-conf-stat 'background 'collector-push conf-no collector)
    (lyskom-wait-queue 'background)
    (setq conf-stat (car (collector->value collector)))

    (cond ((null viewer-no) nil)
          ((eq viewer-no 0) nil)
          ((null conf-stat) nil)
          ((eq viewer-no (conf-stat->supervisor conf-stat)) t)
          ((lyskom-is-member (conf-stat->supervisor conf-stat) viewer-no) t)
          (t nil))))

(defun lyskom-i-am-supervisor (conf-stat &optional may-block)
  "Returns non-nil if lyskom-pers-no is the supervisor of CONF-STAT.

If MAY-BLOCK is non-nil, this function never makes server calls, so if
the information required to answer accurately is not cached, this
function will return an incorrect result (nil instead of t)."
  (let ((marshal nil))
    (when conf-stat
      (let ((conf (conf-stat->supervisor conf-stat))
            (result nil))
        (while (and (not (memq conf marshal)) conf (not result))
          (setq marshal (cons conf marshal))
          (if (lyskom-try-get-membership conf t)
              (setq result t)
            (if may-block
                (setq conf (conf-stat->supervisor 
                            (blocking-do 'get-conf-stat conf)))
              (setq conf (conf-stat->supervisor (cache-get-conf-stat conf))))))
        result))))


(defun lyskom-is-member (conf-no pers-no &optional queue)
  "Return the membership in CONF-NO of PERS-NO
Optional argument QUEUE is the queue to send the queries on.

Cannot be called from a callback."
  (or (and (eq pers-no lyskom-pers-no)
           (lyskom-try-get-membership conf-no t))
      (let ((collector (make-collector)))
        (initiate-query-read-texts (or queue 'background)
                                   'collector-push
                                   pers-no
                                   conf-no
                                   nil 0
                                   collector)
        (lyskom-wait-queue (or queue 'background))
        (car (collector->value collector)))))

(defun lyskom-text-recipients (text-stat &optional want-types)
  "Return the list of recipients for TEXT-STAT.
If WANT-TYPES is non-nil then the result is an assoc list where the 
car of each element is the recipient number and the cdr is the type."
  (let ((result nil))
    (lyskom-traverse misc (text-stat->misc-info-list text-stat)
      (when (memq (misc-info->type misc) lyskom-recpt-types-list)
        (if want-types
            (setq result (cons (cons (misc-info->recipient-no misc)
                                     (misc-info->type misc))
                               result))
          (setq result (cons (misc-info->recipient-no misc)
                             result)))))
    (nreverse result)))

(defun lyskom-text-comments (text-stat)
  "Return the list of comments to TEXT-STAT"
  (let ((result nil))
    (lyskom-traverse misc (text-stat->misc-info-list text-stat)
      (cond ((eq (misc-info->type misc) 'FOOTN-IN)
             (setq result (cons (misc-info->footn-in misc) result)))
            ((eq (misc-info->type misc) 'COMM-IN)
             (setq result (cons (misc-info->comm-in misc) result)))))
    (nreverse result)))


(defun lyskom-find-conf-by-date (target-date)
  "Search all conferences for a conference created on or about TARGET-DATE.
Returns the conf-stat of the conference."
  (blocking-do-multiple ((lowest (find-next-conf-no 0))
                         (highest (first-unused-conf-no)))

    (let* ((index (+ lowest (/ (- highest lowest) 2)))
           (last-index (1- index))
           (result nil))
      (while (/= last-index index)

        ;; Get the first conf-stat after index

        (let ((conf-stat nil)
              (conf-no index))
          (while (and (null conf-stat)
                      (<= conf-no highest))
            (setq conf-stat (blocking-do 'get-conf-stat conf-no))
            (unless conf-stat
              (setq conf-no (blocking-do 'find-next-conf-no conf-no))))

          ;; If we were unable to find a conf-stat, then set highest
          ;; equal to index -- there are no conf-stats in that area,
          ;; so we might as well start looking below index

          (cond ((null conf-stat) (setq highest index))
                ((lyskom-time-greater (conf-stat->creation-time conf-stat)
                                      target-date)
                 (setq highest (1+ conf-no)))
                (t (setq lowest conf-no)))
          (setq last-index index result conf-stat)
          (setq index (+ lowest (/ (- highest lowest) 2)))))
      result)))


(defun lyskom-find-text-by-date (conf-stat target-date)
  "Search texts in CONF-STAT for a text added on or about TARGET-DATE.
Returns a cons of (LOCAL . GLOBAL)"
  (let* ((lowest (conf-stat->first-local-no conf-stat))
         (highest (+ lowest (conf-stat->no-of-texts conf-stat)))
         (conf-no (conf-stat->conf-no conf-stat))
         (result nil)
         (index (+ lowest (/ (- highest lowest) 2)))
         (last-index (1- index)))
    (while (/= last-index index)
      (let* ((map (blocking-do 'local-to-global 
                               conf-no
                               index
                               1)))
        (cond ((null map) (setq lowest highest))
              ((null (text-mapping->global-numbers map))
               (setq highest index))
              (t 
               (let* ((text-no (car (text-mapping->global-numbers map)))
                      (text-stat (blocking-do 'get-text-stat text-no))
                      (local-no (text-mapping->global-to-local map text-no))
                      (date (and text-stat
                                 (lyskom-traverse misc
                                     (text-stat->misc-info-list text-stat)
                                   (when (and (memq (misc-info->type misc) lyskom-recpt-types-list)
					      (eq (misc-info->recipient-no misc) conf-no))
                                     (lyskom-traverse-break 
                                      (if (misc-info->sent-at misc)
                                          (misc-info->sent-at misc)
                                        (text-stat->creation-time text-stat))))))))
                 (when text-stat
                   (setq index local-no)
                   (if (lyskom-time-greater
			date
                        target-date)
                       (setq highest index)
                     (setq lowest index))
                   (setq result text-stat))))))
      (setq last-index index)
      (setq index (+ lowest (/ (- highest lowest) 2))))
    (cons last-index (text-stat->text-no result))))

(put 'lyskom-parse-date-invalid 'error-conditions
     '(error lyskom-error))
(put 'lyskom-parse-date-invalid 'error-message
     "Error parsing date")

(defvar lyskom-year-window-start 80
  "Windowing threshold for YY year specifications.
Years below this are considered in the 21st century. Years above this
in the 20th century")

(defun lyskom-all-prefixes (s)
  "Return part of a regular expression matching all prefixes of S.
The value returned does not include the parens before at either ends of the expression."
  (let ((result nil)
        (i 1))
    (while (<= i (length s))
      (setq result (cons (substring s 0 i) result) i (1+ i)))
    (mapconcat 'regexp-quote result "\\|")))

(defun lyskom-read-date (prompt &optional empty)
  "Read a date from the minibuffer. 
Returns a list (YEAR MONTH DATE) corresponding to the user's input."
  (let ((result nil)
        (date nil))
    (while (null result)
      (setq date (lyskom-verified-read-from-minibuffer 
                  prompt 
                  date
                  (lambda (data)
                    (condition-case nil
                        (cond ((and empty (string-equal data "")) nil)
                              (t (lyskom-parse-date data) nil))
                      (lyskom-error (lyskom-get-string 'invalid-date-entry))))))
      (condition-case nil
          (cond ((and empty (string-equal date "")) (setq result t))
                (t (setq result (lyskom-parse-date date))))
        (lyskom-error nil)))
    (and (listp result) result)))

(defun lyskom-parse-date (arg)
  "Parse ARG (a string) as a date.
Returns a list (YEAR MONTH DAY) corresponding to the date in ARG."
  (let* ((month-regexp (concat "\\("
                               (mapconcat (lambda (el)
                                            (regexp-quote (car el)))
                                          lyskom-month-names
                                          "\\|")
                               "\\)"))
         (y-regexp (concat "\\("
                             (mapconcat (lambda (el)
                                          (lyskom-all-prefixes (lyskom-get-string el)))
                                        '(years year)
                                        "\\|")
                             "\\)"))
         (m-regexp (concat "\\("
                             (mapconcat (lambda (el)
                                          (lyskom-all-prefixes (lyskom-get-string el)))
                                        '(months month)
                                        "\\|")
                             "\\)"))
         (d-regexp (concat "\\("
                             (mapconcat (lambda (el)
                                          (lyskom-all-prefixes (lyskom-get-string el)))
                                        '(days day)
                                        "\\|")
                             "\\)"))
         (test-date (format-time-string "%x" '(20 0)))
         (now (decode-time))
         (current-day (elt now 3))
         (current-month (elt now 4))
         (current-year (elt now 5))
         (case-fold-search t)
         year month day di mi yi)

    ;; Look at test-date to see where dates in ambiguous cases should go
    (cond ((string-match "01.*16.*70" test-date) (setq di 2 mi 1 yi 3))
          ((string-match "01.*70.*16" test-date) (setq di 3 mi 1 yi 2))
          ((string-match "16.*01.*70" test-date) (setq di 1 mi 2 yi 3))
          ((string-match "16.*70.*01" test-date) (setq di 1 mi 3 yi 2))
          ((string-match "70.*01.*16" test-date) (setq di 3 mi 2 yi 1))
          ((string-match "70.*16.*01" test-date) (setq di 2 mi 3 yi 1)))

    ;; Match various variants
    (cond ((string-match "^\\s-*\\([0-9][0-9][0-9][0-9]?\\)\\s-*[ -./]\\s-*\\([0-9][0-9]?\\)\\s-*[ -./]\\s-*\\([0-9][0-9]?\\)\\s-*$" arg)
           ;; YYYY-MM-DD
           (setq year (string-to-int (match-string 1 arg))
                 month (string-to-int (match-string (if (> mi di) 3 2) arg))
                 day (string-to-int (match-string (if (> mi di) 2 3) arg)))
           (when (> month 12) (setq month day day month))
           )

          ((string-match "^\\s-*\\([0-9][0-9]?\\)\\s-*[ -./]\\s-*\\([0-9][0-9]?\\)\\s-*[ -./]\\s-*\\([0-9][0-9][0-9][0-9]?\\)\\s-*$" arg)
           ;; MM-DD-YYYY
           (setq year (string-to-int (match-string 3 arg))
                 month (string-to-int (match-string (if (> mi di) 2 1) arg))
                 day (string-to-int (match-string (if (> mi di) 1 2) arg)))
           (when (> month 12) (setq month day day month))
           )

          ((string-match "^\\s-*\\([0-9][0-9]\\)\\s-*[ -./]\\s-*\\([0-9][0-9]?\\)\\s-*[ -./]\\s-*\\([0-9][0-9]?\\)\\s-*$" arg)
           ;; Ambiguous:
           ;; YY/MM/DD, YY/DD/MM, MM/DD/YY, DD/MM/YY
           (setq year (string-to-int (match-string yi arg))
                 month (string-to-int (match-string mi arg))
                 day (string-to-int (match-string di arg)))
           (when (> month 12) (setq month day day month))
           )

          ((string-match "^\\s-*\\([0-9][0-9]\\)\\s-*/\\s-*\\([0-9][0-9]\\)\\s-*$" arg)
           ;; Ambiguous:
           ;; MM/DD       Euro
           ;; DD/MM       US
           (let ((a (string-to-int (match-string 1 arg)))
                 (b (string-to-int (match-string 2 arg))))
             (cond ((> a 12) (setq month b day a))
                   ((> b 12) (setq month a day b))
                   ((> di mi) (setq month b day a))
                   (t (setq month a day b))))
           )

          ((string-match (format "^\\s-*\\([0-9][0-9]?\\)\\s-*%s\\s-*\\([0-9][0-9][0-9][0-9]\\)\\s-*$" month-regexp) arg)
           ;; DD Month YYYY
           (setq day (string-to-int (match-string 1 arg))
                 month (cdr (lyskom-string-assoc (match-string 2 arg) lyskom-month-names))
                 year (string-to-int (match-string 3 arg)))
           )

          ((string-match (format "^\\s-*%s \\([0-9][0-9]?\\),\\s-*\\([0-9][0-9][0-9]?[0-9]?\\)\\s-*$" month-regexp) arg)
           ;; Month DD, YYYY
           (setq day (string-to-int (match-string 2 arg))
                 month (cdr (lyskom-string-assoc (match-string 1 arg) lyskom-month-names))
                 year (string-to-int (match-string 3 arg)))
           )

          ((string-match (format "^\\s-*\\([0-9][0-9]?\\) %s,\\s-*\\([0-9][0-9][0-9]?[0-9]?\\)\\s-*$" month-regexp) arg)
           ;; DD Month, YYYY
           (setq day (string-to-int (match-string 1 arg))
                 month (cdr (lyskom-string-assoc (match-string 2 arg) lyskom-month-names))
                 year (string-to-int (match-string 3 arg)))
           )

          ((string-match (format "^\\s-*%s,?\\s-*\\([0-9][0-9][0-9][0-9]\\)\\s-*$" month-regexp) arg)
           ;; Ambiguous:
           ;; Month YYYY
           (setq day 1
                 month (cdr (lyskom-string-assoc (match-string 1 arg) lyskom-month-names))
                 year (string-to-int (match-string 2 arg)))
           )

          ((string-match (format "^\\s-*%s \\([0-9][0-9]?\\)\\s-*$" month-regexp) arg)
           ;; Ambiguous:
           ;; Month DD, Month YY
           (setq month (cdr (lyskom-string-assoc (match-string 1 arg) lyskom-month-names))
                 day (string-to-int (match-string 2 arg))
                 year current-year)
           (when (> day 31) (setq day 1 year day))
           )

          ((string-match (format "^\\s-*\\([0-9][0-9]?\\) %s\\s-*$" month-regexp) arg)
           ;; DD Month
           (setq day (string-to-int (match-string 1 arg))
                 month (cdr (lyskom-string-assoc (match-string 2 arg) lyskom-month-names))
                 year current-year)
           )

          ((string-match (format "^\\s-*-?\\([0-9]+\\)\\s-*%s\\s-*$" y-regexp) arg)
           ;; -NN years
           (setq year (- current-year (string-to-int (match-string 1 arg)))
                 day current-day
                 month current-month)
           )

          ((string-match (format "^\\s-*-?\\([0-9]+\\)\\s-*%s\\s-*$" m-regexp) arg)
           ;; -NN months
           (setq year current-year month current-month day current-day)
           (let ((count (string-to-int (match-string 1 arg))))
             (while (> count 0)
               (if (>= count month)
                   (setq count (- count month)
                         year (1- year)
                         month 12)
                 (setq month (- month count) count 0))))
           (setq day (lyskom-adjust-day-for-date year month day))
           )

          ((string-match (format "^\\s-*-?\\([0-9]+\\)\\s-*%s\\s-*$" d-regexp) arg)
           ;; -NN days
           ;; Theres probably an off-by-one error in this code on year transitions
           ;; but I really don't care.
           (setq year current-year month current-month day current-day)
           (let ((count (string-to-int (match-string 1 arg))))
             (while (> count 0)
               (if (>= count day)
                   (progn (setq count (- count day) month (1- month))
                          (when (< month 1) (setq month 12 year (1- year)))
                          (setq day (lyskom-adjust-day-for-date year month 31)))
                 (setq day (- day count) count 0))))
           (setq day (lyskom-adjust-day-for-date year month day))
           )
          ((string-match "^\\s-*\\([0-9][0-9][0-9][0-9]?\\)\\s-*$" arg)
           ;; YYYY goes last because the pattern is the most general
           (setq year (string-to-int (match-string 0 arg)) month 1 day 1)
           )
          (t (signal 'lyskom-parse-date-invalid (list (format "Unrecognized date: %s" arg))))
          )

     ;; Do the window thing for two-digit dates
     (cond ((< year lyskom-year-window-start) (setq year (+ 2000 year)))
           ((< year 100) (setq year (+ 1900 year))))

     ;; Check date validity. Check month before checking days-in-month or stuff breaks
     (when (or (< month 1) (< day 1) (> month 12)
               (> day (lyskom-days-in-month year month)))
       (signal 'lyskom-parse-date-invalid (list (format "Invalid date: %s" arg))))


     (list year month day)
     ))

(defvar lyskom-month-limits '[31        ; Jan
                              28        ; Feb (non-leap)
                              31        ; Mar
                              30        ; Apr
                              31        ; May
                              30        ; Jun
                              31        ; Jul
                              31        ; Aug
                              30        ; Sep
                              31        ; Oct
                              30        ; Nov
                              31        ; Dec
                              ]
  "Number of days in various months. The value for february is not used.")

(defun lyskom-is-leap-year (year)
  "Return non-nil if YEAR is a leap year."
  (or (and (zerop (% year 4))
           (not (zerop (% year 100))))
      (zerop (% year 400))))

(defun lyskom-days-in-year (year)
  "Return number of days in YEAR."
  (if (lyskom-is-leap-year year) 366 365))

(defun lyskom-days-in-month (year month)
  "Return the number of days mONTH of YEAR.
Args: YEAR MONTH"
  (cond ((eq month 2) (if (lyskom-is-leap-year year) 29 28))
        (t (elt lyskom-month-limits (1- month)))))


(defun lyskom-adjust-day-for-date (year month day)
  "Return an appropriate day of month for a combination of YEAR, MONTH and DAY.
If DAY is too high for YEAR and MONTH, return the maximum permissible DAY for
that combination. Otherwise return DAY."
  (let ((mdays (lyskom-days-in-month year month)))
    (if (> day mdays) mdays day)))


;;; ================================================================
;;; Check noconversion

(defun lyskom-viewing-noconversion ()
  "Return non-nil if we are reviewing in noconversion mode."
  (eq 'kom-review-noconversion lyskom-current-command))


;;; ================================================================
;;; Read membership types

(defun lyskom-read-membership-type ()
  "Interactively read a membership type"
  (let ((invitation (lyskom-j-or-n-p 'mship-type-invitation-q))
        (passive (lyskom-j-or-n-p 'mship-type-passive-q))
        (secret (lyskom-j-or-n-p 'mship-type-secret-q)))
    (lyskom-create-membership-type invitation
                                   passive
                                   secret
                                   nil
                                   nil
                                   nil
                                   nil
                                   nil)))


;;; ================================================================
;;; String truncation
;;;

(defun lyskom-truncate-to-lines (string threshold show-lines &optional width)
  "If STRING is more than THRESHOLD lines on screen, truncate it to  SHOW-LINES.
Optional argument WIDTH is thw window width to use instead of window-width.

This function takes the setting of truncate-lines into account, so
the resulting string may not have SHOW-LINES newline characters.

Result is eq to STRING when no truncation is required.

The result is approximate when truncate-lines is non-nil since different
Emacsen use a different number of characters for the continuation marks
at the end of broken lines. We assume one character continuation marks."
  (let ((line-length (if truncate-lines lyskom-max-int (- (or width (window-width)) 1)))
        (count 0)
        (end nil)
        (pos 0))
    (while (and (< pos (length string)) (< count threshold))
      (setq count (1+ count))
      (let ((next (string-match "\\(\n\\|\\'\\)" string pos)))
        (if (> (- next pos) line-length)
            (setq pos (+ pos line-length))
          (setq pos (match-end 0))))
        (when (= count show-lines)
          (setq end pos)))

    (if (>= count threshold)
        (substring string 0 end)
      string)))


;;; ================================================================
;;; Color model manipulations
;;;
;;; (Of COURSE you need this in a KOM client!)
;;;

(defun lyskom-get-color-highlight (color distance)
  "Create a highlight color for COLOR that is DISTANCE away.
COLOR is a list of R G and B components from 0 to 65535.
DISTANCE is a non-negative integer no larger than 1.0, that in some
way specifies how far away from the original color the new color
should be."
  (when color
    (let* ((hls (lyskom-rgb-to-hls (mapcar (lambda (x) (/ x 65535.0)) color)))
           (l (elt hls 1)))
      (if (> l 0.6)
          (setq l (- l distance))
        (setq l (+ l distance)))
      (cond ((> l 1.0) (setq l 1.0))
            ((< l 0.0) (setq l 0.0)))
      (aset hls 1 l)

      (apply 'format "#%02x%02x%02x"
             (mapcar (lambda (c) (round (* 255 c)))
                     (lyskom-hls-to-rgb hls))))))


(defun lyskom-rgb-to-hls (rgb)
  "Convert a point in RGB color space to a point in HLS color space.

Input value is a vector [R G B], where R, G and B represent red, green
and blue components, respectively. Each value is a non-negative
floating-point value no larger than 1.0.

Output is a vector [H L S], where H, L and S represend hue, lightness
and saturation, respectively. H is in the range 0..360, L and S are
non-negative floating-point numbers no higher than 1.0. If the input
color is a shade of gray (all components are equal), then H in the
output is nil.

Algorithm adapted from Foley, \"Computer Graphics\"."
  (let* ((r (elt rgb 0))
         (g (elt rgb 1))
         (b (elt rgb 2))
         (rgbmin (min r g b))
         (rgbmax (max r g b))
         (h nil)
         (l (/ (+ rgbmax rgbmin) 2.0))
         (s nil)
         (delta (- rgbmax rgbmin)))
    (if (zerop delta)
        (setq s 0.0)
      (if (<= l 0.5)
          (setq s (/ delta (+ rgbmax rgbmin)))
        (setq s (/ delta (- 2.0 rgbmax rgbmin))))
      (cond ((= r rgbmax)
             (setq h (/ (- g b) delta)))
            ((= g rgbmax)
             (setq h (+ 2.0 (/ (- b r) delta))))
            ((= b rgbmax)
             (setq h (+ 4.0 (/ (- r g) delta)))))
      (setq h (* h 60.0))
      (if (< h 0)
          (setq h (+ 360.0 h))))
    (vector h l s)))

(defun lyskom-hls-to-rgb-value (n1 n2 h)
  "Helper function for lyskom-hls-to-rgb"
  (cond ((> h 360) (setq h (- h 360.0)))
        ((< h 0) (setq h (+ h 360.0))))

  (cond ((< h 60)  (+ n1 (* (- n2 n1) (/ h 60.0))))
        ((< h 180) n2)
        ((< h 240) (+ n1 (* (- n2 n1) (/ (- 240.0 h) 60.0))))
        (t n1)))

(defun lyskom-hls-to-rgb (hls)
  "Convert a point in HLS color space to a point in RGB color space.

Input HLS is a vector [H L S], where H, L and S represend hue,
lightness and saturation, respectively. H is in the range 0..360, L
and S are non-negative floating-point numbers no higher than 1.0. If
the input color is a shade of gray (all components are equal), then S
in the input is ignored and may be anything.

Output value is a vector [R G B], where R, G and B represent red,
green and blue components, respectively. Each value is in the range
1..1.0.

This algorithm is adapted from Foley, \"Computer Graphics\" (and
has the bug in that algorithm fixed)."
  (let* ((h (elt hls 0))
         (l (elt hls 1))
         (s (elt hls 2))
         (m2 (if (<= l 0.5)
                 (* l (+ 1.0 s))
               (+ l (* s (- 1 l)))))
         (m1 (- (* 2 l) m2)))
    (if (zerop s)
        (vector l l l)
      (vector (lyskom-hls-to-rgb-value m1 m2 (+ h 120))
              (lyskom-hls-to-rgb-value m1 m2 h)
              (lyskom-hls-to-rgb-value m1 m2 (- h 120))))))


;;; ================================================================
;;; Automatically test that RGB->X and X->RGB color model conversions
;;; really are the inverse of each other.
;;; 
;;; (defun lyskom-test-color-model ()
;;;   (let ((r 0.0)
;;;         (g 0.0)
;;;         (b 0.0)
;;;         (step 0.05))
;;;     (while (<= r 1.0)
;;;       (setq g 0.0)
;;;       (while (<= g 1.0)
;;;         (setq b 0.0)
;;;         (while (<= b 1.0)
;;;           (let ((tmp (lyskom-hls-to-rgb
;;;                       (lyskom-rgb-to-hls (vector r g b)))))
;;;             (unless (and (< (- r (elt tmp 0)) 0.000000001)
;;;                          (< (- g (elt tmp 1)) 0.000000001)
;;;                          (< (- b (elt tmp 2)) 0.000000001))
;;;               (message "Mismatch %1.2f,%1.2f,%1.2f gave %S/%S" r g b (lyskom-rgb-to-hls (vector r g b)) tmp)))
;;;           (setq b (+ b step)))
;;;         (setq g (+ g step)))
;;;       (setq r (+ r step)))))

;;;(defun lyskom-test-auto-colors ()
;;;  (make-face 'test-1)
;;;  (make-face 'test-2)
;;;  (make-face 'test-default)
;;;  (while t
;;;    (let ((foreground (read-from-minibuffer "Foreground: "))
;;;          (background (read-from-minibuffer "Background: ")))
;;;      (pop-to-buffer (get-buffer-create "*kom*-test"))
;;;      (erase-buffer)
;;;      (set-face-foreground 'test-default foreground)
;;;      (set-face-background 'test-default background)
;;;      (set-face-background 'test-1 (lyskom-get-color-highlight (x-color-values background) 0.05))
;;;      (set-face-background 'test-2 (lyskom-get-color-highlight (x-color-values background) 0.025))
;;;      (let ((lyskom-buffer (current-buffer)))
;;;        (lyskom-format-insert "\
;;;%#3@Lsa nsta fotnot...
;;;8408827 idag 00:40 /1 rad/ Lunkwill/CH ( Auf das Universum! )
;;;Fotnot till text 8408825 av Lunkwill/CH ( Auf das Universum! )
;;;Mottagare: Ntverk, Internet, LysNET, Sunet... <30873>
;;;Mottagare: SUBnet (Stngstadens och LiU:s) studentbostadsnt <12152>
;;;Mottagare: Lunkwill/CH ( Auf das Universum! ) <2092>
;;;rende: Vrmtet
;;;%[%#1$------------------------------------------------------------
;;;%]%[%#2$Och tack s mycket fr frklaringarna! =)
;;;%]%[%#1$(8408827) /Lunkwill/CH ( Auf das Universum! )/------
;;;%]G till nsta mte...
;;;SUN erfarenhetsutbyte - 1 olst
;;;Lsa nsta text...
;;;8408823 idag 00:39 /4 rader/ Erik Persson, Lysato(r)
;;;Kommentar till text 8407161 av Dejan (ngot desperat)
;;;Mottagare: SUN erfarenhetsutbyte <23622>
;;;rende: Skapa partitionstabell
;;;%[%#1$------------------------------------------------------------
;;;%]%[%#2$Om du nu vill spela Fibre Channel med IDE-RAID s gr du ver n efter
;;;vatten. Det finns redan IDE-RAID med FC-interface.  Dock har jag inte
;;;sett ngon som stdjer ngot annat n FC-AL vilket r lite
;;;begrnsande.
;;;%]%[%#1$(8408823) ------------------------------------------
;;;%]G till nsta mte...
;;;
;;;
;;;
;;;"
;;;                              '(face test-1)
;;;                              '(face test-2)
;;;                              '(face test-default))))))
;;;

(defun lyskom-safe-color-name (c)
  "Return a color name as a string or nil." 
  (cond ((stringp c) c)
	((lyskom-color-specifier-p c) (lyskom-color-name c))))


(defun lyskom-is-url (text)
  "Return non-nil if TEXT can be interpreted as an URL.
Any whitespace and newlines in TEXT will be ignored."
  (save-match-data
    (let ((text (replace-in-string text "\\s-+" "")))
      (or (string-match "^\\(file://\\|ftp://\\|gopher://\\|http://\\|https://\\|news:\\|wais://\\|mailto:\\|telnet:\\|rtsp:\\)[^\t \012\014\"<>|\\]*[^][\t \012\014\"<>|.,!(){}?'`:;]$" text)
          (string-match "^\\(www\\|ftp\\|home\\)\\.[^\t \012\014\"<>|\\]*[^][\t \012\014\"<>|.,!(){}?'`:;]$"  text)))))

(defun lyskom-nag-about-presentation (&optional harder)
  (unless kom-dont-complain-about-missing-presentation
    (blocking-do-multiple
        ((pers-stat (get-pers-stat (or lyskom-pers-no 0)))
         (conf-stat (get-conf-stat (or lyskom-pers-no 0))))
      (when (and pers-stat conf-stat
                 (or harder
                     (eq (random 
                          (max 3 (- 20
                                    (pers-stat->no-of-created-texts pers-stat)
                                    (* 5 (pers-stat->created-confs pers-stat))
                                    (* 2 (pers-stat->created-persons pers-stat)))))
                         1))
                 (null (blocking-do 'get-text-stat 
                                    (conf-stat->presentation conf-stat))))
        (lyskom-beep 2)
        (lyskom-format-insert 'why-you-got-no-presentation
                              `(face ,kom-warning-face)
                              (pers-stat->no-of-created-texts pers-stat)
                              (lyskom-session-nickname)
                              72)
        (sit-for (if harder 0 1))))))

(defun lyskom-get-server-stats ()
  (let ((descr (blocking-do 'get-stats-description)))
    (when descr
      (let ((result (lyskom-create-server-stats))
            (collector (make-collector)))
      (set-server-stats->when result
       (listify-vector (stats-description->when descr)))
      (set-server-stats->what result
       (listify-vector (stats-description->what descr)))
      (lyskom-traverse name (stats-description->what descr)
        (initiate-get-stats 'main
                            (lambda (res name c)
                              (when res
                                (collector-push (cons name (listify-vector res)) c)))
                            name
                            name
                            collector))
      (lyskom-wait-queue 'main)

      (set-server-stats->values result
                                (nreverse (collector->value collector)))
      result))))

(defun lyskom-format-units (val units base-unit)
  "Format VAL using units. UNITS is an alist (COUNT . NAME), where
NAME is the name of a unit and COUNT is the number of base units for
that name. For example, if the base unit is seconds, then minutes
could be defined with \(60 . \"min\"). BASE-UNIT is the name of the
base unit \(which implicitly has a count of 1)."
  (mapconcat
   (lambda (el)
     (format "%d%s"
             (car el)
             (cond ((stringp (cdr el)) (cdr el))
                   ((symbolp (cdr el)) (lyskom-get-string (cdr el))))))
   (nreverse
    (let ((result nil))
      (lyskom-traverse unit units
        (when (>= val (car unit))
          (let ((a (/ val (car unit))))
            (when (> a 0) (setq result (cons (cons a (cdr unit)) result)))
            (setq val (% val (car unit))))))
      (if (> val 0)
          (cons (cons val base-unit) result)
        result)))
   ""))

(defun lyskom-format-time-units (val &optional what)
  "Format VAL as values per time unit in such a way that the
result is readable (i.e. whole numbers, if possible). WHAT is
the unit measured."
  (let ((last-unit nil))
    (if (eq val 0) 
        (lyskom-format "0%#1?b%[ %#1s%]%[%]/%#2s" 
                       what
                       (lyskom-get-string 'unit-hour))
      (lyskom-traverse unit '((unit-second . 1)
                              (unit-minute . 60)
                              (unit-hour . 60)
                              (unit-day . 24)
                              (unit-month . 30)
                              (unit-year . 12))
        (setq val (* val (cdr unit)))
        (setq last-unit unit)
        (when (> val 1)
          (lyskom-traverse-break)))
      (lyskom-format "%0.0.4#1f%#2?b%[ %#2s%]%[%]/%#3s" val
                     what (lyskom-get-string (car last-unit))))))




(defun lyskom-extended-status-information (tag)
  "Return non-nil is extended status information indicated by TAG
should be shown."
  (cond ((eq kom-extended-status-information t) t)
        ((assq tag kom-extended-status-information) 
         (cdr (assq tag kom-extended-status-information)))
        ((cdr (assq t kom-extended-status-information)))))

(defun lyskom-extended-status-override (tag)
  "Return a new value for kom-extended-status-information that
reflects an override of the value by the value of TAG."
  (cond ((eq kom-extended-status-information t) t)
        ((assq tag kom-extended-status-information)
         (cdr (assq tag kom-extended-status-information)))
        (t kom-extended-status-information)))




;;; ============================================================
;;; Magic that allows us to clear the initial value in the
;;; minibuffer when the user types a character.
;;;
;;; We can't alter the buffer contents in before-change-functions
;;; since this can crash Gnu Emacs 20.7 (it computes positions
;;; internally before calling before-change-functions, and if
;;; those positions are invalid afterwards all sorts of things
;;; can happen).
;;;
;;; Theory of operation:
;;;
;;; In the pre-command-hook, record the position of point and
;;; the contents of the minibuffer.
;;;
;;; In before-change-functions, check if there is initial
;;; input in the buffer yet -- if not we're not yet ready
;;; to erase anything.
;;;
;;; In the post-command-hook, if the buffer contents have changed
;;; since there was inital input in the buffer, erase the initial
;;; input. If the position of point has moved, disable all the
;;; magic (both can happen at the same time).
;;;
;;; We set up advice on read-from-minibuffer and completing-read
;;; that mangles the initial input appropriately.
;;;

(defvar lyskom-minibuffer-point)
(defvar lyskom-minibuffer-string)
(defvar lyskom-minibuffer-do-change)

(defun lyskom-magic-minibuffer-pre-command (&rest args)
  "Save current status of the minibuffer for later magic."
  (setq lyskom-minibuffer-point (point)
        lyskom-minibuffer-string (buffer-string)))

(defun lyskom-magic-minibuffer-before-change (&rest args)
  "Check if the initial input has been placed in the minibuffer.

This function is called at least once before the initial input
has been placed in the minibuffer by Emacs. Most magic needs to
be disabled until the input has been deposited."
  (setq lyskom-minibuffer-do-change
        (lyskom-next-property-bounds (point-min)
                                     (point-max) 'lyskom-initial-mbc)))

(defun lyskom-magic-minibuffer-post-command (&rest args)
  "Function for use as post-command-hook in magic minibuffer.

If the contents of the minibuffer have changed since initial input
has been placed in the minibuffer, erase the initial input. This
happens when the user enters something in the minibuffer.

If point has moved, disable magic. This happens either after we
delete the initial contents (which is OK) or after the user moves
point without altering the buffer contents."
  (when (and lyskom-minibuffer-do-change
             (not (equal (buffer-string) lyskom-minibuffer-string)))
    (let ((ranges nil)
          (tmp nil)
          (start (point-min)))
      (while (setq tmp (lyskom-next-property-bounds
                        start (point-max) 'lyskom-initial-mbc))
        (setq ranges (cons tmp ranges)
              start (cdr tmp)))
      (lyskom-traverse range ranges
        (delete-region (car range) (cdr range)))
      (when ranges
        (lyskom-magic-minibuffer-cancel))))

    (unless (or (null lyskom-minibuffer-point)
              (eq lyskom-minibuffer-point (point)))
    (lyskom-magic-minibuffer-cancel)))

(defun lyskom-magic-minibuffer-cancel ()
  "Remove hooks used to make the minibuffer magic."
  (remove-hook 'pre-command-hook 'lyskom-magic-minibuffer-pre-command)
  (remove-hook 'post-command-hook 'lyskom-magic-minibuffer-post-command)
  (remove-hook 'before-change-functions 'lyskom-magic-minibuffer-before-change))

(defun lyskom-magic-minibuffer-mangle-initial (initial)
  "Add text properties to INITIAL (a string or cons) so it is
suitable for use as initial input in a magic minibuffer."
  (cond ((null initial) nil)
        ((stringp initial)
         (let ((tmp (copy-sequence initial)))
           (add-text-properties 0 (length tmp) '(lyskom-initial-mbc t rear-nonsticky t end-open t start-open t front-sticky nil) tmp)
           tmp))
        ((consp initial)
         (let ((tmp (copy-sequence (car initial))))
           (add-text-properties 0 (length tmp) '(lyskom-initial-mbc t rear-nonsticky t end-open t start-open t front-sticky nil) tmp)
           (cons tmp (cdr initial))))

        (t initial)))



;;; ------------------------------------------------------------
;;; Gnu Emacs and XEmacs have different names for parameters.
;;; This is stupid and makes the code below a lot uglier.

(defadvice read-from-minibuffer (around lyskom-magic-minibuffer-read-from-minibuffer nil disable)
  (let* ((initial-input (and (boundp 'initial-input) (lyskom-magic-minibuffer-mangle-initial (symbol-value 'initial-input))))
	 (initial-contents (and (boundp 'initial-contents) (lyskom-magic-minibuffer-mangle-initial (symbol-value 'initial-contents))))
	 (initial (and (boundp 'initial) (lyskom-magic-minibuffer-mangle-initial (symbol-value 'initial))))
	 (init (and (boundp 'init) (lyskom-magic-minibuffer-mangle-initial (symbol-value 'init))))
	 (result ad-do-it))
    (lyskom-ignore initial-input)
    (lyskom-ignore initial-contents)
    (lyskom-ignore initial)
    (lyskom-ignore init)
    (when (stringp result)
      (remove-text-properties 0 (length result) '(end-open nil rear-nonsticky nil lyskom-initial-mbc nil) result)
      (unless (or (text-properties-at 0 result)
		  (next-property-change 0 result))
	(set-text-properties 0 (length result) nil result)))
    result))

(defadvice completing-read (around lyskom-magic-minibuffer-completing-read nil disable)
  (let* ((initial-input (and (boundp 'initial-input) (lyskom-magic-minibuffer-mangle-initial (symbol-value 'initial-input))))
	 (initial-contents (and (boundp 'initial-contents) (lyskom-magic-minibuffer-mangle-initial (symbol-value 'initial-contents))))
	 (initial (and (boundp 'initial) (lyskom-magic-minibuffer-mangle-initial (symbol-value 'initial))))
	 (init (and (boundp 'init) (lyskom-magic-minibuffer-mangle-initial (symbol-value 'init))))
	 (result ad-do-it))
    (lyskom-ignore initial-input)
    (lyskom-ignore initial-contents)
    (lyskom-ignore initial)
    (lyskom-ignore init)
    (when (stringp result)
      (remove-text-properties 0 (length result) '(end-open nil rear-nonsticky nil lyskom-initial-mbc nil) result)
      (unless (or (text-properties-at 0 result)
		  (next-property-change 0 result))
	(set-text-properties 0 (length result) nil result)))
    result))

(defun lyskom-magic-minibuffer-add-advice ()
  (ad-enable-advice 'read-from-minibuffer 'around 'lyskom-magic-minibuffer-read-from-minibuffer)
  (ad-enable-advice 'completing-read 'around 'lyskom-magic-minibuffer-completing-read)
  (ad-activate 'read-from-minibuffer)
  (ad-activate 'completing-read)
  )

(defun lyskom-magic-minibuffer-cancel-advice ()
  (ad-disable-advice 'read-from-minibuffer 'around 'lyskom-magic-minibuffer-read-from-minibuffer)
  (ad-disable-advice 'completing-read 'around 'lyskom-magic-minibuffer-completing-read)
  )

(defmacro lyskom-with-magic-minibuffer (&rest forms)
  `(let ((lyskom-minibuffer-point nil)
         (lyskom-minibuffer-string nil)
         (lyskom-minibuffer-do-change nil)
         (pre-command-hook pre-command-hook)
         (post-command-hook post-command-hook)
         (before-change-functions before-change-functions))
     (add-hook 'pre-command-hook 'lyskom-magic-minibuffer-pre-command)
     (add-hook 'post-command-hook 'lyskom-magic-minibuffer-post-command)
     (add-hook 'before-change-functions 'lyskom-magic-minibuffer-before-change)
     (unwind-protect
         (progn (lyskom-magic-minibuffer-add-advice)
                ,@forms)
       (lyskom-magic-minibuffer-cancel-advice))))




(defun lyskom-completing-read (prompt table &optional predicate
                                      require-match init hist def)
  (let ((this-command this-command))
    (lyskom-ignore def)
    (lyskom-with-lyskom-minibuffer
     (lyskom-with-magic-minibuffer
      (let ((res (completing-read prompt table predicate require-match init hist)))
        (if (or (null res) (equal res "")) def res))))))

(defun lyskom-read-from-minibuffer (prompt 
                                    &optional initial-contents
                                    keymap read hist def)
  (let ((this-command this-command))
    (lyskom-ignore def)
    (lyskom-with-lyskom-minibuffer
     (lyskom-with-magic-minibuffer
      (or (read-from-minibuffer prompt initial-contents keymap read hist) def)))))

(defun lyskom-set-connection-time-format (val)
  "Change protocol time format to UTC if VAL is non-nil."
  ;; Check for broken encode-time
  (setq val (and val 
                 (condition-case nil
                     (not (equal (encode-time 0 0 0 1 1 1970 0)
                                 (encode-time 0 0 0 1 1 1970 -4)))
                   (error nil))))
  (when (or (blocking-do 'set-connection-time-format val)
            (null val))
    (lyskom-traverse-buffer-hierarchy
     (lambda (buf)
       (save-excursion
         (set-buffer buf)
         (make-variable-buffer-local 'lyskom-server-uses-utc)
         (setq lyskom-server-uses-utc val)))
     lyskom-buffer)))

(put 'lyskom-integer-conversion-error 'error-conditions '(lyskom-integer-conversion-error lyskom-error error))
(put 'lyskom-integer-conversion-error 'error-message "Invalid integer conversion")

(defun lyskom-string-to-int (string &optional signal-error)
  "Convert STRING to an integer by parsing it as a decimal number.
This does not parse floating point numbers.
It ignores leading spaces and tabs."
  (or (let ((tmp (string-to-int string)))
        (cond ((eq tmp 0) 
               (and (string-match "^\\s-*0+\\s-*" string) 0))
              ((integerp tmp) tmp)
              (t nil)))
      (and signal-error
           (signal 'lyskom-integer-conversion-error string))))

(defun lyskom-privilege-string (privs &optional format sep)
  (setq format (or format "%#1s")
        sep (or sep ", "))
  (mapconcat (lambda (x) (lyskom-format format (lyskom-get-string x)))
             (or (delq nil (list
                            (and (privs->wheel privs) 'privs-wheel)
                            (and (privs->admin privs) 'privs-admin)
                            (and (privs->statistic privs) 'privs-statistic)
                            (and (privs->create_pers privs) 'privs-create-pers)
                            (and (privs->create_conf privs) 'privs-create-conf)
                            (and (privs->change_name privs) 'privs-change-name)
                            (and (privs->flg7 privs) 'privs-flg7)
                            (and (privs->flg8 privs) 'privs-flg8)
                            (and (privs->flg9 privs) 'privs-flg9)
                            (and (privs->flg10 privs) 'privs-flg10)
                            (and (privs->flg11 privs) 'privs-flg11)
                            (and (privs->flg12 privs) 'privs-flg12)
                            (and (privs->flg13 privs) 'privs-flg13)
                            (and (privs->flg14 privs) 'privs-flg14)
                            (and (privs->flg15 privs) 'privs-flg15)
                            (and (privs->flg16 privs) 'privs-flg16)
                            ))
                 '(lyskom-no-privileges))
             sep))

(defvar lyskom-gensym-index 0
  "Index to use in lyskom-gensym")

(defun lyskom-gensym ()
  "Generate a unique symbol"
  (let ((name "t"))
    (while (intern-soft name)
      (setq lyskom-gensym-index (1+ lyskom-gensym-index))
      (setq name (format "lyskom-gensym: %d" lyskom-gensym-index)))
    (intern name)))

(put 'lyskom-with-magic-minibuffer 'edebug-form-spec '(body))



;;; ================================================================
;;; List text summaries

(defvar lyskom-list-text-summary-params)
(defvar lyskom-list-text-summary-params-persistent)
(defvar lyskom-list-text-summary-format)

(defsubst lyskom-list-text-summary-get (sym)
  (or (plist-get lyskom-list-text-summary-params sym)
      (plist-get lyskom-list-text-summary-params-persistent sym)))

(defsubst lyskom-list-text-summary-put (sym val &optional persistent)
  (if persistent
      (setq lyskom-list-text-summary-params-persistent
            (plist-put lyskom-list-text-summary-params-persistent sym val))
    (setq lyskom-list-text-summary-params
          (plist-put lyskom-list-text-summary-params sym val))))

(defun lyskom-max-mark-width ()
  "Return the maximum width of the user's symbolic mark strings."
  (apply 'max 3 (mapcar (function (lambda (x) (length (car x))))
                        kom-symbolic-marks-alist)))

(defun lyskom-max-text-no-width ()
  "Ask the server about the maximum text number width."
  (length (int-to-string (blocking-do 'find-previous-text-no
                                      lyskom-max-int))))

(defun lyskom-symbolic-mark-type-string (mark-no &optional strict)
  "Return a symbolic name string for the mark-type of MARK.
If optional argument STRICT is non-nil, return nil if there is no symbolic
 name for the mark type."
  (or (car-safe (rassoc mark-no kom-symbolic-marks-alist))
      (and (not strict) (int-to-string mark-no))))





(defvar lyskom-text-summary-fields
  '((mark-type :width lyskom-max-mark-width
               :prompt mark-type
               :align left
               :format "s"
               :output (lambda (text-stat)
                         (let ((mark (or (lyskom-list-text-summary-get :mark)
                                         (cache-text-is-marked 
                                          (text-stat->text-no text-stat)))))
                           (if mark
                               (lyskom-symbolic-mark-type-string (mark->mark-type mark))
                             "")))
               )

    (mark-no :width 3
             :prompt mark-no
             :align left
             :format "s"
             :output (lambda (text-stat)
                       (let ((mark (cache-text-is-marked 
                                    (text-stat->text-no text-stat))))
                         (if mark (int-to-string (mark->mark-type mark)) "")))
               )

    (comments  :width 2
               :prompt Comments
               :align right
               :format "s"
               :output (lambda (text-stat)
                         (if (zerop (length (lyskom-text-comments text-stat)))
                             ""
                           (int-to-string
                            (length (lyskom-text-comments text-stat)))))
               )

    (mark-count :width 2
                :prompt Num-marks
                :align right
                :format "s"
                :output (lambda (text-stat)
                          (if (zerop (text-stat->no-of-marks text-stat))
                              ""
                            (int-to-string (text-stat->no-of-marks text-stat))))
                )

    (text-no   :width lyskom-max-text-no-width
               :prompt Texts
               :align left
               :format "n"
               :output (lambda (text-stat) (text-stat->text-no text-stat)))

    (written   :width (lambda ()
                        (max (length (lyskom-format-time 'time))
                             (length (lyskom-format-time
                                      'timeformat-yyyy-mm-dd))))
               :prompt Written
               :align left
               :format "s"
               :output (lambda (text-stat)
                         (let ((now (lyskom-current-server-time))
                               (time (or (lyskom-mx-date-to-time
                                          (car (lyskom-get-aux-item 
                                                (text-stat->aux-items text-stat) 21)))
                                         (text-stat->creation-time text-stat))))
                           (if (and (= (time->year now) (time->year time))
                                    (= (time->mon now) (time->mon time))
                                    (= (time->mday now) (time->mday time)))
                               (lyskom-format-time 'time time)
                             (lyskom-format-time 'timeformat-yyyy-mm-dd 
                                                 time))))
               )

    (lines     :width 5
               :prompt Lines
               :align right
               :align left
               :format "d"
               :output (lambda (text-stat)
                         (text-stat->no-of-lines text-stat))
               )

    (author    :width nil
               :weight 50.0
               :prompt Author
               :align left
               :format "P"
               :output (lambda (text-stat)
                         (let ((mx-from (car (lyskom-get-aux-item (text-stat->aux-items text-stat) 17)))
                               (mx-author (car (lyskom-get-aux-item (text-stat->aux-items text-stat) 16))))
                           (if (or mx-from mx-author)
                               (lyskom-format-mx-author mx-from mx-author)
                             (text-stat->author text-stat))))
               )

    (subject   :width nil
               :weight 100.0
               :prompt Subject
               :align left
               :format "s"
               :output (lambda (text-stat)
                         (lyskom-list-text-summary-subject text-stat))
               )
    )
  "Specification of fields that can be included in text summary lists.

Each element is a cons (KEY . PLIST), where KEY is the name of the 
field type (arbitrary symbol). and PLIST is a property list, which 
may include the following properties:

    :width      Witdh of the field. Function, number or nil.
    :weight     Weight for dynamically sized field. Floating point.
    :prompt     Heading for the column. Symbol.
    :align      Alignment of the column. Either left or right.
    :format     Format code for the column. For lyskom-format.
    :output     Function that outputs the column.

If width is nil, the field is dynamically sized. All dynamically sized
fields share the available width, according to their respective weights.
Columns will always be at least as wide as the column heading.

Note that weight must be a floating-point number, or the arithmetic
used to comput dynamic columns will not work. The weight is only used
for dynamic columns."
  )


(defun lyskom-list-text-summary-subject (text-stat)
  "Handle subject field for a text summary listing."
  (let* ((mode (lyskom-list-text-summary-get :subject-mode))
         (indent (lyskom-list-text-summary-get :subject-indent))
         (text (lyskom-list-text-summary-get :text))
         (txt (text->decoded-text-mass text text-stat))
         (eos (and txt (string-match (regexp-quote "\n") txt)))
         (subject (if eos (substring txt 0 eos) "")))

    (cond ((eq mode 'unique)
           (if (lyskom-string-member 
                subject (lyskom-list-text-summary-get :subjects))
               (throw 'lyskom-list-text-summary-abort t)
             (lyskom-list-text-summary-put
              :subjects (cons subject (lyskom-list-text-summary-get :subjects))
              t)))

          ((eq mode 'thread)
           (when (and (not (eq indent 0))
                      (string-equal (lyskom-list-text-summary-get :subject-last)
                                    subject))
             (setq subject ""))))

    (unless (string-equal "" subject)
      (lyskom-list-text-summary-put :subject-last subject t))

    (lyskom-format "%#1@%#2r"
                   (lyskom-default-button 'text (text-stat->text-no text-stat))
                   (concat (cond ((not indent) "")
                                 ((>= indent 10)
                                  (format ">>>[%d]>>>" indent))
                                 (t (make-string indent ?\>)))
                           subject))

    ))


;; Sub-optimal (i.e. too much code) implementation for the sake of
;; clarity. It is possible to implement this with far less computation
;; and fewer variables, but the code tends to be harder to understand.

(defun lyskom-summary-line-format-string (spec)
  "Return header and format string for text summary lines.
SPEC is the specification for the line. It is a list of symbols
that must exist as keys in lyskom-text-summary-fields and strings,
which must be valid for lyskom-format (i.e. with percent signs
doubled.

Returns a cons of the header string and a format string for the
"
  (let ((total-field-width 0)
        (field-width-list nil)
        (dynamic-width nil)
        (dynamic-weight 0))

    ;; Compute dynamic widths

    (lyskom-traverse el spec
      (if (stringp el)
          (setq total-field-width (+ total-field-width 
                                     (lyskom-string-width el)))
        (let* ((field-spec (cdr (assq el lyskom-text-summary-fields)))
               (prompt (plist-get field-spec :prompt))
               (dw (plist-get field-spec :weight))
               (w1 (plist-get field-spec :width))
               (w2 (cond ((functionp w1) (funcall w1))
                         ((numberp w1) w1)
                         ((null w1) nil))))
          (if (null w2)
              (setq dynamic-weight (+ dynamic-weight dw))
            (setq w2 (max w2 (if prompt (lyskom-string-width (lyskom-get-string prompt)) 0)))
            (setq total-field-width (+ total-field-width w2)))
          (setq field-width-list (cons w2 field-width-list)))))

    (setq dynamic-width (- (1- (window-width)) total-field-width)
          field-width-list (nreverse field-width-list))

    ;; Now dynamic-width contains the total width allocated to dynamically
    ;; sized fields. We will calculate the individual field widths like 
    ;; this:
    ;;
    ;; field-width := floor(dynamic-width / num-dynamic-fields)
    ;; dynamic-width := dynamic-width - field-width
    ;; num-dynamic-fields := num-dynamic-fields - 1
    ;;
    ;; This spreads the available space as equally as possible and 
    ;; eliminates any possibility of round-off errors since everything
    ;; can be implemented using integer arithmetic.

    (let ((field-no 0)
          (format-string "")
          (header-string ""))
      (lyskom-traverse el spec
        (if (stringp el)
            (setq format-string (concat format-string el)
                  header-string (concat header-string (lyskom-format el)))
          (let* ((field-spec (cdr (assq el lyskom-text-summary-fields)))
                 (prompt (plist-get field-spec :prompt))
                 (width (car field-width-list)))

            (unless width
              (let* ((dw (plist-get field-spec :weight))
                     (frac (floor (* dynamic-width (/ dw dynamic-weight)))))
                (setq width (max (if prompt
                                     (lyskom-string-width
                                      (lyskom-get-string prompt))
                                   0)
                                 frac))
                (setq dynamic-width (- dynamic-width width))
                (setq dynamic-weight (- dynamic-weight dw))))

            (setq field-no (1+ field-no)
                  format-string
                  (concat format-string
                          (format "%%%s%s%d#%d%s"
                                  (if (null (car field-width-list)) "=" "")
                                  (if (eq (plist-get field-spec :align) 'left)
                                      "-" "")
                                  width 
                                  field-no
                                  (plist-get field-spec :format)))
                  header-string 
                  (concat header-string
                          (lyskom-format
                           (format "%%%s%d#1s"
                                   (if (eq (plist-get field-spec :align) 'left)
                                       "-" "")
                                   width)
                           (if prompt (lyskom-get-string prompt) "")))
                  field-width-list (cdr field-width-list)
                  ))))
      (cons header-string format-string))))



(defun lyskom-list-text-summary-print (spec &rest args)
  (setq lyskom-list-text-summary-params args)

  (if (or (null (lyskom-list-text-summary-get :text-stat))
          (null (lyskom-list-text-summary-get :text)))
      (lyskom-format-insert 'could-not-read 
                            (lyskom-list-text-summary-get :text-no))

    (catch 'lyskom-list-text-summary-abort
      (apply 'lyskom-format-insert
             lyskom-list-text-summary-format
             (delq 'CONSTANT-STRING
                   (mapcar (lambda (el)
                             (if (stringp el) 'CONSTANT-STRING
                               (let* ((field-spec (cdr (assq el lyskom-text-summary-fields)))
                                      (output (plist-get field-spec :output)))
                                 (funcall output (lyskom-list-text-summary-get :text-stat)))))
                           spec)))
      (lyskom-insert "\n"))
    ))


(defun lyskom-list-text-summary (text-list spec &rest args)
  "List a summary of texts in TEXT-LIST according to SPEC.
TEXT-LIST is a list of text numbers or marks. SPEC is a list
of symbols and constant strings. The symbols must be keys in
lyskom-text-summary-fields.

Args is a list of keywords, some of which may have arguments

    :unique           Only print the first text with a specific subject
    :comment-order    Print texts in comment order, with indented subjects
    :filter FN        Filter function (see below)
    :filter-args ARGS Filter arguments (see below).

The filter function is applied to each element of text-list. It is passed
the text-list element as its first argument, and elements of :filter-args
as its remaining arguments. The text will be listed only if the filter
function returns non-nil."

  (setq spec (or spec 
                 '(text-no " " written " " lines " " 
                           comments " " author " " subject)))

  (let* ((text-no nil)
         (indent 0)
         (comment-order nil)
         (filter-function nil)
         (filter-args nil)
         (lyskom-list-text-summary-tmp (lyskom-summary-line-format-string spec))
         (lyskom-list-text-summary-params nil)
         (lyskom-list-text-summary-params-persistent nil)
         (lyskom-list-text-summary-format (cdr lyskom-list-text-summary-tmp)))

    (lyskom-list-text-summary-put :subject-mode nil t)

    (while args
      (cond ((eq (car args) :unique)
             (lyskom-list-text-summary-put :subject-mode 'unique t))
            ((eq (car args) :comment-order)  
             (setq comment-order t)
             (lyskom-list-text-summary-put :subject-mode 'thread t))
            ((eq (car args) :filter)
             (setq filter-function (car (cdr args))
                   args (cdr args)))
            ((eq (car args) :filter-args)
             (setq filter-args (car (cdr args))
                   args (cdr args))))
      (setq args (cdr args)))

    (lyskom-insert (car lyskom-list-text-summary-tmp))
    (lyskom-insert "\n")

    (lyskom-list-text-summary-put :subject-indent 0)

    (while text-list
      (setq text-no (car text-list) text-list (cdr text-list))

      (when (or (null filter-function)
                (apply filter-function text-no filter-args))

        (cond 
         ((eq text-no 'in) (setq indent (1+ indent)))
         ((eq text-no 'out) (setq indent (1- indent)))
         (t (let (mark)
              (cond ((lyskom-mark-p text-no) 
                     (setq mark text-no text-no (mark->text-no text-no)))
                    ((numberp text-no)))

              (blocking-do-multiple ((text-stat (get-text-stat text-no))
                                     (text (get-text text-no)))
              (lyskom-list-text-summary-print spec
                                              :text-no text-no
                                              :text-stat text-stat
                                              :text text
                                              :mark mark
                                              :subject-indent indent)
              (sit-for 0)

              (when comment-order
                (let ((comments (lyskom-text-comments text-stat)))
                  (setq text-list (cons 'out text-list))
                  (lyskom-traverse comment-no (nreverse comments)
                    (when (memq comment-no text-list)
                      (setq text-list (cons comment-no 
                                            (delq comment-no text-list)))))
                  (setq text-list (cons 'in text-list))))))
            ))))))

;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: completing-read.el,v 44.52 2003/08/25 17:36:39 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: completing-read.el
;;;; Author: David Byers
;;;;
;;;; This file implements functions for reading a conference name
;;;; or a person name with completion and other help.
;;;;

(setq lyskom-clientversion-long 
      (concat
       lyskom-clientversion-long
       "$Id: completing-read.el,v 44.52 2003/08/25 17:36:39 byers Exp $\n"))

(defvar lyskom-name-hist nil)


;;; ============================================================
;;;
;;; Name lookup caches
;;;

(defvar lyskom-completing-who-info-cache nil
  "Temporary cache of who-info data")

(defvar lyskom-completing-lookup-name-cache nil
  "Temporary cache of server queries")

(defvar lyskom-completing-use-dynamic-info nil)

(defun lyskom-completing-clear-cache ()
  (setq lyskom-completing-who-info-cache nil)
  (setq lyskom-completing-lookup-name-cache nil))

(defun lyskom-completing-who-is-on ()
  "Get information about who is on, first checking the cache. Returns what 
\(blocking-do 'who-is-on\) would, but as a list, not a vector"
  (if lyskom-completing-who-info-cache
      lyskom-completing-who-info-cache
    (setq lyskom-completing-who-info-cache
          (listify-vector
	   (if (lyskom-have-feature dynamic-session-info)
	       (blocking-do 'who-is-on-dynamic t t 0)
	     (blocking-do 'who-is-on))))))

(defun lyskom-completing-cache-completion (string data)
  (let* ((downs (lyskom-unicase string))
         (tmp (assoc downs lyskom-completing-lookup-name-cache)))
    (if (null tmp)
        (setq lyskom-completing-lookup-name-cache
              (cons (cons downs data) lyskom-completing-lookup-name-cache)))
    string))

(defun lyskom-completing-lookup-z-name (string want-conf want-pers)
  "Look up STRING as a name. Same as \(blocking-do 'lookup-z-name ...\)
but first checks a cache."
  (if (and (eq 0 want-conf)
           (eq 0 want-pers))
      nil
    (let* ((downs (lyskom-unicase string))
           (tmp (assoc downs lyskom-completing-lookup-name-cache)))
      (if tmp
          (cdr tmp)
        (progn
          (setq tmp (blocking-do 'lookup-z-name string want-pers want-conf))
          (setq lyskom-completing-lookup-name-cache
                (cons (cons downs tmp)
                      lyskom-completing-lookup-name-cache))
          tmp)))))

;;; ============================================================
;;;
;;; Keymaps
;;;


(defvar lyskom-minibuffer-local-completion-map
  (let ((map (copy-keymap minibuffer-local-completion-map)))
    (define-key map " " nil)
    map)
  "Keymap used for reading LysKOM names.")

(defvar lyskom-minibuffer-local-must-match-map
  (let ((map (copy-keymap minibuffer-local-must-match-map)))
    (lyskom-xemacs-or-gnu 
     (lyskom-set-keymap-parent map lyskom-minibuffer-local-completion-map)
     (define-key map " " nil))
    map)
  "Keymap used for reading LysKOM names.")



(defsubst lyskom-completing-match-string-regexp (string)
  (concat "^"
          (replace-in-string (regexp-quote (lyskom-unicase (lyskom-completing-strip-name string)))
                             "\\s-+" "\\\\S-*\\\\s-+")
          "\\s-*"))

(defsubst lyskom-completing-match-string (string name)
  "Return non-nil if STRING matches NAME using LysKOM completion rules."
  (string-match (lyskom-completing-match-string-regexp string)
                (lyskom-completing-strip-name (lyskom-unicase name))))


(defun lyskom-read-conf-no (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its number or zero if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) 0)
          ((stringp conf-z-info) 0)
	  ((lyskom-conf-stat-p conf-z-info) (conf-stat->conf-no conf-z-info))
	  ((lyskom-uconf-stat-p conf-z-info) (uconf-stat->conf-no conf-z-info))
          (t (conf-z-info->conf-no conf-z-info)))))

(defun lyskom-read-conf-stat (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its conf-stat or nil if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) nil)
          ((stringp conf-z-info) nil)
	  ((lyskom-conf-stat-p conf-z-info) conf-z-info)
          ((lyskom-uconf-stat-p conf-z-info) 
           (blocking-do 'get-conf-stat (uconf-stat->conf-no conf-z-info)))
          (t (blocking-do 'get-conf-stat 
                          (conf-z-info->conf-no conf-z-info))))))

(defun lyskom-read-uconf-stat (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its conf-stat or nil if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) nil)
          ((stringp conf-z-info) nil)
	  ((lyskom-uconf-stat-p conf-z-info) conf-z-info)
	  ((lyskom-conf-stat-p conf-z-info)
           (blocking-do 'get-uconf-stat 
                        (conf-stat->conf-no conf-z-info)))
          (t (blocking-do 'get-uconf-stat 
                          (conf-z-info->conf-no conf-z-info))))))

(defun lyskom-read-conf-name (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its name.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) "")
          ((stringp conf-z-info) conf-z-info)
	  ((lyskom-conf-stat-p conf-z-info) (conf-stat->name conf-z-info))
	  ((lyskom-uconf-stat-p conf-z-info) (uconf-stat->name conf-z-info))
	  (t (conf-z-info->name conf-z-info)))))


;;; ================================================================
;;; Code to guess defaults for initial input
;;;

(defun lyskom-default-conference-at-point (&rest args)
  (let* ((pos (or lyskom-command-point (point)))
         (type (and pos (get-text-property pos 'lyskom-button-type))))
    (and (memq type '(conf pers))
         (list (get-text-property pos 'lyskom-button-arg)))))

(defun lyskom-default-conference-current (&rest args)
  (list lyskom-current-conf))

(defun lyskom-default-conference-self (&rest args)
  (list lyskom-pers-no))

(defun lyskom-default-conference-last-author (&rest args)
  (and (lyskom-get-last-read-text)
       (list (text-stat->author
              (blocking-do 'get-text-stat (lyskom-get-last-read-text))))))

(defun lyskom-default-conference-restriction (predicate &rest args)
  (and (assq 'restrict predicate)
       (cdr (assq 'restrict predicate))))

(defun lyskom-default-conference-empty (&rest args)
  nil)


(defun lyskom-default-conference-saved (sym &rest args)
  (save-excursion
    (when lyskom-buffer (set-buffer lyskom-buffer))
    (and (cdr (assq (car sym) lyskom-read-conf-saved-inputs))
         (list (conf-z-info->conf-no 
                (cdr (assq (car sym) lyskom-read-conf-saved-inputs)))))))

(defun lyskom-default-conference-not-self (uc &rest args)
  (not (eq (uconf-stat->conf-no uc) lyskom-pers-no)))

(defun lyskom-default-conference-not-current (uc &rest args)
  (not (eq (uconf-stat->conf-no uc) lyskom-current-conf)))



(defun lyskom-get-initial-conf-strategy (prompt)
  (when (listp prompt) (setq prompt (car prompt)))
  (let* ((spec-1 (cdr (assq (or lyskom-current-command this-command)
                            lyskom-default-conference-strategy)))
         (default-spec 
           (cdr (assq t (assq t lyskom-default-conference-strategy))))
         (prompt-spec (cdr (assq prompt spec-1)))
         (cmd-spec (cdr (assq t spec-1))))
    (lyskom-debug-forms
     (unless spec-1 
       (save-excursion
         (when lyskom-buffer (set-buffer lyskom-buffer))
         (lyskom-format-insert-before-prompt 
          "%[%#2@%#1s%]\n"
          (format "Warning: no strategy for %S/%S"
                  (or lyskom-current-command this-command)
                  prompt)
          `(face ,kom-warning-face)))))
    (list (or (assq 'default prompt-spec)
              (assq 'default cmd-spec)
              (assq 'default default-spec))
          (or (assq 'filter prompt-spec)
              (assq 'filter cmd-spec)
              (assq 'filter default-spec))
          (or (assq 'save prompt-spec)
              (assq 'save cmd-spec)
              (assq 'save default-spec)))))

(defun lyskom-read-conf-guess-initial (prompt predicate)
  "Return a guess for the initial value for lyskom-read-conf."
  (let* ((strategy (lyskom-get-initial-conf-strategy prompt))
         (default (cdr (assq 'default strategy)))
         (filter (cdr (assq 'filter strategy))))

    (uconf-stat->name
     (car
      (filter-list 
       (lambda (uconf-stat)
         (and uconf-stat
              (not (memq nil
                         (mapcar (lambda (fn)
                                   (funcall fn uconf-stat))
                                 filter)))
              (lyskom-read-conf-internal-verify-type
               (uconf-stat->conf-no uconf-stat)
               (uconf-stat->conf-type uconf-stat)
               predicate nil nil)))
       (mapcar (lambda (conf-no)
                 (blocking-do 'get-uconf-stat conf-no)) 
               (apply 'append 
                      (delq nil (mapcar (lambda (fn)
                                          (if (listp fn)
                                              (funcall (car fn) (cdr fn) predicate)
                                            (funcall fn predicate)))
                                        default)))))))))



(defun lyskom-read-conf-save-input (prompt input)
  "Save INPUT as input for the current completing read command."
  (save-excursion
    (when lyskom-buffer (set-buffer lyskom-buffer))
    (lyskom-traverse sym (cdr (assq 'save (lyskom-get-initial-conf-strategy prompt)))
      (if (assq sym lyskom-read-conf-saved-inputs)
          (setcdr (assq sym lyskom-read-conf-saved-inputs) input)
        (setq lyskom-read-conf-saved-inputs 
              (cons (cons sym input) lyskom-read-conf-saved-inputs))
        ))))

(defun lyskom-read-conf (prompt type &optional empty initial mustmatch)
  "Completing read a conference or person from the minibuffer. 

PROMPT is the prompt. It can be a string, symbol or list. If it is a symbol,
       lyskom-get-string will be used to get the string. If it is a list,
       it is used as the argument list to lyskom-format to create the
       prompt. You should use symbols and lists only.
TYPE   is the type of conferences to return. It is a list of one or
       more of the following:

       all     Return any conference.
       conf    Return conferences (not letterboxes).
       pers    Return persons (letterboxes).
       login   Return persons who are also logged-in.
       membership Return only conferences and letterboxes lyskom-pers-no
               is a member of.
       none    Return names that do not match anything in the database.
       (restrict c1 c2 ...) Restrict matching to conference numbers c1, 
               c2 etc. The implementation is inefficient for long lists.

Optional arguments

EMPTY     allow nothing to be entered.

INITIAL   initial contents of the minibuffer. If an integer, use the
          name of that conference. This is normally computed automatically,
          so pass nil whenever possible.

MUSTMATCH if non-nil, the user must enter a valid name.

The return value may be one of
A conf-z-info: The conf-z-info associated with the name entered,
nil:         Nothing was entered, or
A string:    A name that matched nothing in the database."

  ;; We bind lyskom-current-command here so that changes to
  ;; this-command will not confuse our guesses for the initial value
  ;; (particularly at the end of this function, where we sometimes
  ;; save the value the user entered).

  (let ((lyskom-current-command (or lyskom-current-command this-command)))
    (lyskom-completing-clear-cache)
    (setq initial
          (cond ((integerp initial)
                 (uconf-stat->name (blocking-do 'get-uconf-stat initial)))
                ((stringp initial) initial)
                ((lyskom-conf-stat-p initial)
                 (conf-stat->name initial))
                ((lyskom-uconf-stat-p initial)
                 (uconf-stat->name initial))
                ((lyskom-conf-z-info-p initial)
                 (conf-z-info->name initial))
                ((consp initial) initial)
                ((lyskom-read-conf-guess-initial prompt type))
                (t nil)))

    (let* ((completion-ignore-case t)
           (minibuffer-local-completion-map 
            lyskom-minibuffer-local-completion-map)
           (minibuffer-local-must-match-map 
            lyskom-minibuffer-local-must-match-map)
           (read-string nil)
           (old-prompt prompt)
           (result nil)
           (keep-going t))

      (setq prompt (cond ((stringp prompt) prompt)
                         ((symbolp prompt) (lyskom-get-string prompt))
                         ((listp prompt) (apply 'lyskom-format prompt))
                         (t (lyskom-get-string 'conf-prompt))))

      (while keep-going
        (setq read-string (lyskom-completing-read prompt
                                                  'lyskom-read-conf-internal
                                                  type
                                                  mustmatch
                                                  (if (listp initial)
                                                      initial
                                                    (cons initial 0))
                                                  'lyskom-name-hist))
        (setq result
              (cond ((null read-string) nil)
                    ((string= "" read-string) nil)
                    (t (lyskom-lookup-conf-by-name read-string type))))
        (setq keep-going (and (not empty)
                              (null result))))
      (lyskom-read-conf-save-input old-prompt result)
      result)))


(defun lyskom-read-conf-get-logins ()
  "Used internally by lyskom-read-conf-internal to get a list of
persons who are logged on."
  (mapcar (if (lyskom-have-feature dynamic-session-info)
              (function (lambda (el) (dynamic-session-info->person el)))
            (function (lambda (el) (who-info->pers-no el))))
          (lyskom-completing-who-is-on)))


(defun lyskom-read-conf-expand-specials (string
                                         predicate
                                         login-list
                                         x-list
                                         &optional return-cs)
  "Used internally by lyskom-read-conf-internal to expand person and
conference number specifications to something useful."
  (cond ((string-match (lyskom-get-string 'person-or-conf-no-regexp) string)
         (let* ((no (string-to-int (match-string 1 string)))
                (cs (blocking-do 'get-uconf-stat no)))
           (if (and cs
                    (lyskom-read-conf-internal-verify-type
                     (uconf-stat->conf-no cs)
                     (uconf-stat->conf-type cs)
                     predicate 
                     login-list
                     x-list))
               (if return-cs
                   cs
                 (list string)))))
        ((string-match (lyskom-get-string 'session-no-regexp) string)
         (let* ((no (string-to-int (match-string 1 string)))
                (si (blocking-do 'get-session-info no))
                (cs (and si
                         (blocking-do 'get-uconf-stat
                                      (session-info->pers-no si)))))
           (if (and cs
                    (lyskom-read-conf-internal-verify-type
                     (uconf-stat->conf-no cs)
                     (uconf-stat->conf-type cs)
                     predicate 
                     login-list
                     x-list))
               (if return-cs
                   cs
                 (list string)))))))

(defun lyskom-read-conf-lookup-specials (string predicate login-list x-list)
  "Used internally by lyskom-read-conf-internal to look up conf-stats
from person and conference number specifications."
  (let ((cs (lyskom-read-conf-expand-specials string
                                              predicate
                                              login-list
                                              x-list
                                              t)))
    (lyskom-create-conf-z-info (uconf-stat->name cs)
                               (uconf-stat->conf-type cs)
                               (uconf-stat->conf-no cs))))

(defun lyskom-lookup-conf-by-name (string predicate)
  "Return the conf-z-info associated with STRING that also satisfies
PREDICATE or nil if no name matches. See lyskom-read-conf-internal for
a documentation of PREDICATE."
  (if (string= string "")
      nil
    (lyskom-read-conf-internal string predicate 'lyskom-lookup)))


(defun lyskom-read-conf-internal (string predicate all)
  "Complete the name STRING according to PREDICATE and ALL.

STRING is a string to complete.
PREDICATE is a list of name types to return. See lyskom-read-conf for
details.
ALL is set by try-completion and all-completions. See the Emacs lisp
manual for a description. Special value 'lyskom-lookup makes the
function work as a name-to-conf-stat translator."

  ;;
  ;;  Catch some degenerate cases that can cause...problems. This
  ;;  won't solve all the...problems, but should speed things up a
  ;;  little bit.
  ;;

  (cond 
   ((and (null all)
         (string-match "^\\s-*$" string)) "")
   ((and (eq all 'lyskom-lookup)
         (string-match "^\\s-*$" string)) nil)
   ((and (eq all 'lambda)
         (string-match "^\\s-*$" string)) nil)
   (t

    (let* ((login-list (and (memq 'login predicate)
                            (lyskom-read-conf-get-logins)))
           (x-list (lyskom-completing-lookup-z-name string 
                                                    (if (or (memq 'all predicate)
                                                            (memq 'membership predicate)
                                                            (memq 'conf predicate)
                                                            (memq 'none predicate)) 1 0)
                                                    (if (or (memq 'all predicate)
                                                            (memq 'membership predicate)
                                                            (memq 'pers predicate)
                                                            (memq 'none predicate)
                                                            (memq 'login predicate)) 1 0)))
           (r-list (when (assq 'restrict predicate)
                     (let ((result (make-collector)))
                       (lyskom-traverse conf-no (cdr (assq 'restrict predicate))
                         (initiate-get-uconf-stat 'main 'collector-push 
                                                  conf-no result))
                       (lyskom-wait-queue 'main)
                       (delq nil
                             (mapcar (lambda (conf-stat)
                                       (when (lyskom-completing-match-string string (uconf-stat->name conf-stat))
                                         (lyskom-create-conf-z-info
                                          (uconf-stat->name conf-stat)
                                          (uconf-stat->conf-type conf-stat)
                                          (uconf-stat->conf-no conf-stat))))
                               (collector->value result))))))
           (candidate-list 
            (append r-list
                   (if x-list
                       (conf-z-info-list->conf-z-infos x-list))))
           (result-list nil))

      ;;
      ;;  login-list now contains a list of logins, IF the predicate
      ;;  includes 'login
      ;;
      ;;  candidate-list contains a list of conf-z-infos
      ;;
      ;;  Now set result-list to the conf-z-infos that fulfill the
      ;;  predicate, fetching the conf-stats asynchronously.
      ;;

      (lyskom-traverse el candidate-list
        (if (lyskom-read-conf-internal-verify-type (conf-z-info->conf-no el)
                                                   (conf-z-info->conf-type el)
                                                   predicate
                                                   login-list
                                                   candidate-list)
            (setq result-list (cons el result-list))))
      

      ;;
      ;;  Now the matching conf-z-infos are in result-list
      ;;

      (cond 
       ((eq all 'lyskom-lookup)
        (let ((names (mapcar 'conf-z-info->name 
                             result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))

          (cond ((and kom-complete-numbers-before-names specials)
                 (lyskom-read-conf-lookup-specials string
                                                   predicate
                                                   login-list
                                                   candidate-list))
                ((= (length result-list) 1)
                 (car result-list))

                ((and (> (length result-list) 1)
                      (lyskom-completing-member string names))
                 (elt result-list
                      (- (length result-list)
                         (length (lyskom-completing-member string names)))))

                (specials (lyskom-read-conf-lookup-specials string
                                                            predicate
                                                            login-list
                                                            candidate-list))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 string))))
     
       ;;
       ;;  Check for exact match. We have an exact match in the server
       ;;  when there was a single match OR when there was no match, and
       ;;  no match is valid according to predicate
       ;;

       ((eq all 'lambda)
        (let ((specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond ((= (length result-list) 1) t)
                ((and (> (length result-list) 1)
                      (let ((names (mapcar 'conf-z-info->name
                                           result-list)))
                        (and (lyskom-completing-member string names)
                             t))))
                (result-list nil)
                ((= (length specials) 1) t)
                (specials nil)
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)

                (t (lyskom-read-conf-internal-verify-type nil
                                                          nil
                                                          predicate
                                                          login-list
                                                          candidate-list)))))


       ;;
       ;;  Called from all-completions. Return a list of all possible
       ;;  completions, in this case all names in the result list plus,
       ;;  if the input string is a person or conf number specification,
       ;;  the input string, PROVIDED, the requested conference matches
       ;;  the predicate. If there were no matches, return the input
       ;;  string if no matches satisfies the predicate.
       ;;
          
       (all
        (let ((names (mapcar 'conf-z-info->name result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond (specials (append specials names))
                (names names)
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 (list string))
                (t nil))))

       ;;
       ;;  Called from try-completion, and there were no matches. Try to
       ;;  expand the input string as a person or conf number
       ;;  specification or return something sensible if the predicate
       ;;  is satisfied by no matches.
       ;;

       ((null result-list)
        (let ((specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond (specials (car specials))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 t)
                (t nil))))

       ;;
       ;;  Called from try-completion, and there were matches in the
       ;;  server. Return t if the string is an exact match to any
       ;;  string returned from the server. Otherwise, expand the string
       ;;  as far as possible and return that
       ;;

       (t
        (let ((name-list (mapcar 'conf-z-info->name result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (if specials (setq name-list (nconc specials name-list)))

          (cond ((lyskom-completing-member string name-list) 
                 (or (and (= (length name-list) 1) t) string)) ; Exact match
                ((= (length name-list) 1) (car name-list))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                (t (or (lyskom-completing-cache-completion
                        (lyskom-complete-string name-list)
                        (if r-list
                            (lyskom-create-conf-z-info-list
                             (apply 'vector candidate-list))
                          x-list))
                       (and (lyskom-read-conf-internal-verify-type 
                             nil
                             nil
                             predicate
                             login-list
                             candidate-list)
                            (list string))))))))))))
        

(defun lyskom-completing-member (string list)
  (let ((string (lyskom-unicase (lyskom-completing-strip-name string)))
        (result nil))
    (while (and list (not result))
      (if (lyskom-string= string (lyskom-unicase 
                           (lyskom-completing-strip-name (car list))))
          (setq result list)
        (setq list (cdr list))))
    result))


(defun lyskom-completing-strip-name (string)
  "Strip parens and crap from a name."
  (while (string-match "([^()]*)" string)
    (setq string (replace-match " " t t string)))
  (while (string-match "\\s-\\s-+" string)
    (setq string (replace-match " " t t string)))
  (while (string-match "([^()]*$" string)
    (setq string (substring string 0 (match-beginning 0))))
  (if (string-match "^\\s-*\\(.*\\S-\\)\\s-*$" string)
      (match-string 1 string)
    string))


(defun lyskom-read-conf-internal-verify-type (conf-no
                                              conf-type
                                              predicate
                                              logins
                                              x-list)
  (or (memq conf-no (cdr (assq 'restrict predicate)))
      (and (memq 'all predicate)
           conf-no)
      (and (memq 'conf predicate)
           conf-type
           (not (conf-type->letterbox conf-type)))
      (and (memq 'pers predicate) 
           conf-type
           (conf-type->letterbox conf-type))
      (and (memq 'login predicate)
           conf-no
           (memq conf-no logins))
      (and (memq 'membership predicate)
           conf-no
           (lyskom-get-membership conf-no t))
      (and (memq 'none predicate) 
           (and (null conf-no)
                (null x-list)))))

;;; FOR DEBUGGING (DON'T DELETE)     /byers
;;;
;;; (defun lyskom-complete-show-data-list (state data)
;;;   (save-excursion
;;;     (pop-to-buffer (get-buffer-create "*kom*-complete"))
;;;     (erase-buffer)
;;;     (lyskom-set-buffer-multibyte nil)
;;;    (while data
;;;       (insert
;;;        (format "%s\n" (substring (aref (car data) 2)
;;;                                  (aref (car data) 0)
;;;                                  (aref (car data) 1))))
;;;       (setq data (cdr data)))
;;;     (insert (format "%S %S: %S" (symbol-value current-state)
;;;                     (elt state 0)
;;;                     (elt state 1)))
;;;     (sit-for 5)))


(defun lyskom-complete-string (string-list)
  "Find the longest common prefix of all strings in STRING-LIST according to
the LysKOM rules of string matching."
  (let ((main-state 'start-of-string)
        (tmp-state nil)
        (current-state 'main-state)
        (main-accumulator nil)
        (tmp-accumulator nil)
        (current-accumulator 'main-accumulator)
        (done nil)
        (paren-depth 0)
        (have-here nil)
        (last-event-worth-noting nil)
        (data-list (lyskom-complete-string-munge-input string-list))
        (next-char-state (vector nil nil)))

    (while (not done)
      (lyskom-complete-string-next-char next-char-state data-list)
;      (lyskom-complete-show-data-list next-char-state data-list)
      (cond

       ;;
       ;; Case one, a match of two non-special characters.
       ;; Accumulate one character and advance the lists
       ;;

       ((eq (aref next-char-state 0) 'match)
        (if (eq (aref next-char-state 1) ?\ )
            (progn
              (cond ((memq (symbol-value current-state)
			     '(start-of-word start-of-string))
                     nil)
                    ((eq last-event-worth-noting 'mismatch)
                     (lyskom-complete-string-accumulate current-accumulator
                                                        'SPC))
                    (t
                     (lyskom-complete-string-accumulate current-accumulator
                                                        ?\ )))
              (set current-state 'start-of-word)
              (lyskom-complete-string-advance data-list))
          (progn
            (set current-state 'in-a-word)
            (lyskom-complete-string-accumulate current-accumulator
                                               (aref next-char-state 1))
            (lyskom-complete-string-advance data-list)))
        (setq last-event-worth-noting 'match))
       
       ;;
       ;; Case two, a match of two open-paren expressions Increase
       ;; paren depth and accumulate a character. First set
       ;; current-accumulator to the temporary if paren-depth is zero
       ;; to start with.
       ;;

       ((eq (aref next-char-state 0) 'open-paren-match)
        (setq last-event-worth-noting 'match)
        (if (zerop paren-depth)
            (progn
              (setq current-accumulator 'tmp-accumulator)
              (setq current-state 'tmp-state)
              (setq tmp-state main-state)
              (setq tmp-accumulator nil)))
        (setq paren-depth (1+ paren-depth))
        (lyskom-complete-string-accumulate current-accumulator
                                    (aref next-char-state 1))
        (lyskom-complete-string-advance data-list))

       ;;
       ;; Case three, a match of two close-paren expressions
       ;; Accumulate a character. If paren-depth is postitive,
       ;; decrease it. If it ends up zero, add the temporary
       ;; accumulator to the main accumulator and set the current
       ;; accumulator to the main accumulator.
       ;;

       ((eq (aref next-char-state 0) 'close-paren-match)
        (setq last-event-worth-noting 'match)
        (lyskom-complete-string-accumulate current-accumulator
                                    (aref next-char-state 1))
        (if (> paren-depth 0)
            (progn
              (setq paren-depth (1- paren-depth))
              (if (zerop paren-depth)
                  (progn
                    (setq main-accumulator
                          (nconc tmp-accumulator main-accumulator))
                    (setq main-state tmp-state)
                    (setq current-state 'main-state)
                    (setq current-accumulator 'main-accumulator)))))
        (lyskom-complete-string-advance data-list))

       ;;
       ;; Case two, a mismatch of any kind in a paren expression
       ;;

       ((and (> paren-depth 0)
             (memq (aref next-char-state 0)
		     '(mismatch space-mismatch open-paren-mismatch)))
        (setq last-event-worth-noting 'mismatch)
        (setq tmp-accumulator nil)
        (setq tmp-state nil)
        (setq current-state 'main-state)
        (setq current-accumulator 'main-accumulator)
        (lyskom-complete-string-close-parens data-list paren-depth)
        (setq paren-depth 0))

       ;;
       ;; Case two and a half or so, a space mismatch. This is ignored
       ;; if we're still at the start of the string
       ;;
       
       ((and (eq (aref next-char-state 0) 'space-mismatch)
             (memq (symbol-value current-state)
		     '(start-of-string start-of-word)))
        (setq last-event-worth-noting nil)
        (lyskom-complete-string-skip-whitespace data-list))

       ;;
       ;; Case three, a mismatch of regular characters outside a paren
       ;; Advance to the end of the current word
       ;;

       ((and (memq (aref next-char-state 0) '(mismatch space-mismatch))
             (zerop paren-depth))
        (setq last-event-worth-noting 'mismatch)
        (if (memq (symbol-value current-state)
		    '(start-of-word start-of-string))
            (setq done t)
          (progn
            (if (not have-here)
                (progn
                  (lyskom-complete-string-accumulate current-accumulator 
                                                     'HERE)
                  (setq have-here t)))
            (lyskom-complete-string-advance-to-end-of-word data-list)
            (set current-state 'in-a-word))))

       ;;
       ;; Case four, a mistmatch where one character is an open-paren
       ;;

       ((eq (aref next-char-state 0) 'open-paren-mismatch)
        (setq last-event-worth-noting 'mismatch)
        (lyskom-complete-string-skip-parens data-list))


       ;;
       ;; Case five, eof
       ;;

       ((eq (aref next-char-state 0) 'eof)
        (setq done t))

       ;;
       ;; Case six, can't happen
       ;;

       (t (error "This can't happen: %S" next-char-state))))

    ;;
    ;; Build the result by reversing the result list and making a
    ;; string out of it.
    ;;

    (if (eq (car main-accumulator) 'SPC)
        (setq main-accumulator (cdr main-accumulator)))

    (setq main-accumulator (nreverse main-accumulator))

    (if (memq 'HERE main-accumulator)
        (let ((backup (length (memq 'HERE main-accumulator))))
          (if lyskom-experimental-features
              (setq unread-command-events
                    (append (cons ? (make-list (1- backup) 2))
                            unread-command-events)))
          (setq main-accumulator (delq 'HERE main-accumulator))))
    
    (concat (mapcar (lambda (el) (if (eq el 'SPC) ?\  el))
		    main-accumulator))))


(defun lyskom-complete-string-accumulate (accumulator char)
  (set accumulator (cons char (symbol-value accumulator))))

(defun lyskom-complete-string-munge-input (string-list)
  (mapcar (function
           (lambda (x)
             (vector 0 (length x) x)))
          string-list))

;;;
;;; Advance one regular character or multiple whitespaces
;;;

(defun lyskom-complete-string-advance (data-list)
  (lyskom-traverse 
   el data-list
   (string-match "\\([ \t]+\\|[^ \t]\\|$\\)"
                 (aref el 2)
                 (aref el 0))
   (aset el 0 (match-end 0))))

(defun lyskom-complete-string-skip-whitespace (data-list)
  (lyskom-traverse
   el data-list
   (string-match "[ \t]*" (aref el 2) (aref el 0))
   (aset el 0 (match-end 0))))

;;;
;;; Advance to the end of the current word
;;;

(defun lyskom-complete-string-advance-to-end-of-word (data-list)
  (lyskom-traverse
   el data-list
   (aset el 0 (string-match "\\([ \t]\\|$\\)" 
                            (aref el 2)
                            (aref el 0)))))

;;;
;;; Unwind a number of parens
;;;

(defun lyskom-complete-string-skip-parens (data-list)
  (lyskom-traverse
   el data-list
   (if (eq ?\( (aref (aref el 2) (aref el 0)))
       (progn
         (aset el 0 (1+ (aref el 0)))
         (lyskom-complete-string-close-parens-2 el 1)))))

(defun lyskom-complete-string-close-parens (data-list depth)
  (lyskom-traverse
   el data-list
   (lyskom-complete-string-close-parens-2 el depth)))

(defun lyskom-complete-string-close-parens-2 (el depth)
  (let ((string (aref el 2))
        (pos (aref el 0)))
    (while (> depth 0)
      (cond ((>= pos (length string)) 
             (setq depth 0))
            ((eq (aref string pos) ?\))
             (setq depth (1- depth)))
            ((eq (aref string pos) ?\))
             (setq depth (1+ depth))))
      (setq pos (1+ pos)))
    (aset el 0 pos)))


;;;
;;; Check what's happenin' next
;;;

(defun lyskom-complete-string-next-char (state data-list)
  (let ((eofp nil)
        (open-paren-p nil)
        (close-paren-p nil)
        (matchp t)
        (spacep nil)
        (char nil)
        (xchar nil))

    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (mapcar
      (function 
       (lambda (x)
         (cond ((>= (aref x 0) (aref x 1))
                (setq eofp t)
                (setq matchp nil))
               ((eq (aref (aref x 2) (aref x 0)) ?\()
                (setq open-paren-p t))
               ((eq (aref (aref x 2) (aref x 0)) ?\))
                (setq close-paren-p t))
               ((eq (aref (aref x 2) (aref x 0)) ?\ )
                (setq spacep t)))

         (setq matchp (and matchp
                           (if (null char)
                               (progn
                                 (setq xchar (aref (aref x 2)
                                                   (aref x 0)))
                                 (setq char (lyskom-unicase-char xchar)))
                             (eq char (lyskom-unicase-char
                                       (aref (aref x 2)
                                             (aref x 0)))))))))
      data-list))

    (aset state 1 xchar)
    (cond (eofp (aset state 0 'eof))
          ((and matchp open-paren-p)
           (aset state 0 'open-paren-match))
          ((and matchp close-paren-p)
           (aset state 0 'close-paren-match))
          (matchp
           (aset state 0 'match))
          (spacep
           (aset state 0 'space-mismatch))
          (open-paren-p
           (aset state 0 'open-paren-mismatch))
          (t
           (aset state 0 'mismatch))))
  state)








;;; ============================================================
;;;
;;; Session reading
;;;
;;;



(defun lyskom-read-session-no (prompt &optional empty initial only-one)
  (let ((possible-matches
         (lyskom-session-from-conf
          (lyskom-read-conf-no prompt
                               (if kom-permissive-completion
                                   '(pers)
                                 '(login))
                               empty
                               initial
                               t))))
    (if (and (> (length possible-matches) 1)
             only-one)
        (lyskom-read-session-resolve-ambiguity possible-matches)
      possible-matches)))


(defun lyskom-session-from-conf (conf-no)
  (let ((who-list (lyskom-completing-who-is-on))
        (sessions nil))
    (if (lyskom-have-feature dynamic-session-info)
	(while who-list
	  (if (eq (dynamic-session-info->person (car who-list)) conf-no)
	      (setq sessions (cons (dynamic-session-info->session
				    (car who-list))
				   sessions)))
	  (setq who-list (cdr who-list)))
      (while who-list
	(if (eq (who-info->pers-no (car who-list))
		conf-no)
	    (setq sessions (cons (who-info->connection (car who-list))
				 sessions)))
	(setq who-list (cdr who-list))))
    (cond ((and (null sessions) kom-permissive-completion) (list (- conf-no)))
          (t sessions))))


(defun lyskom-read-session-resolve-ambiguity (sessions)
  (lyskom-insert "\n")
  (let* ((s-width (1+ (apply 'max (mapcar (function
					   (lambda (x)
					     (lyskom-string-width (int-to-string x))))
					  sessions))))
	 (format-string-s (lyskom-info-line-format-string s-width "s" "s"))
	 (format-string-p (lyskom-info-line-format-string s-width "P" "M")))
    (lyskom-format-insert format-string-s
			  ""
			  (lyskom-get-string 'lyskom-name)
			  (lyskom-get-string 'is-in-conf))
    (lyskom-format-insert format-string-s
			  ""
			  (lyskom-get-string 'from-machine)
			  (lyskom-get-string 'is-doing))
    (lyskom-insert
     (concat (make-string (- (lyskom-window-width) 2) ?-)
	     "\n"))
    (let ((result nil)
	  (who-info
	   (mapcar (function
		    (lambda (el)
		      (let* ((info (blocking-do 'get-session-info el))
			     (confconfstat
			      (blocking-do 'get-uconf-stat
					   (session-info->working-conf info))))
			(lyskom-format-insert
			 format-string-p
			 (format "%d%s"
				 (session-info->connection info)
				 (if (eq (session-info->connection info)
					 lyskom-session-no)
				     "*" " "))
			 (session-info->pers-no info)
			 (or confconfstat
                             (lyskom-get-string 'not-present-anywhere)))
			(lyskom-format-insert
			 format-string-p
			 ""
			 (lyskom-return-username info)
			 (concat "("
				 (session-info->doing info)
				 ")"))
			(cons (number-to-string
			       (session-info->connection info))
			      info))))
		   (sort sessions '<))))
      (lyskom-insert (concat (make-string (- (lyskom-window-width) 2) ?-)
			     "\n"))
      (lyskom-insert (lyskom-format 'total-users-sans-date (length who-info)))
      (lyskom-scroll)
      (while (string= ""
                      (setq result (lyskom-completing-read
				    (lyskom-get-string 'resolve-session)
				    (lyskom-maybe-frob-completion-table 
				     who-info)
				    nil
				    t
				    (car (car who-info))
				    nil))))
      (list (session-info->connection (cdr (assoc result who-info)))))))



;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: keyboard-menu.el,v 44.6 2003/08/16 16:58:45 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: keyboard-menu.el
;;;;
;;;; Implements completing-read almost-compatible lyskom-read-from-menu
;;;; used to implement keyboard navigation of LysKOM menus ('cos tmm
;;;; was *so* ugly).
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: keyboard-menu.el,v 44.6 2003/08/16 16:58:45 byers Exp $\n"))

(defvar lyskom-keyboard-menu-menu)
(defvar lyskom-keyboard-menu-buffer)
(defvar lyskom-keyboard-menu-prompt)
(defvar lyskom-keyboard-menu-selection)
(defvar lyskom-keyboard-menu-overlay)

(defvar lyskom-keyboard-menu-keymap nil)

(defun lyskom-keyboard-menu-read-char (prompt)
  "Read a single keyboard event from the keyboard.
Like read-event in Gnu Emacs or next-command-event in XEmacs."
  (message prompt)
  (sit-for 0)
  (lyskom-xemacs-or-gnu
   (let ((ev (next-command-event nil prompt)))
	    (when (eq 'key-press (event-type ev))
	      (cond ((eq (event-key ev) 'return) 'return)
		    ((event-to-character ev))
		    ((event-key ev))
		    (t nil))))
   (read-event)))

(defun lyskom-keyboard-menu-keys-for-string (string)
  "Return a list of suitable mnemonics for menu item STRING."
  (let ((a-uc nil)
        (a-lc nil)
        (b-uc nil)
        (b-lc nil)
        (c-uc nil)
        (c-lc nil))
    (lyskom-traverse word (string-split " " string)
      (unless (eq (elt word 0) ?\()
        (setq a-lc (cons (downcase (substring word 0 1)) a-lc)
              a-uc (cons (upcase (substring word 0 1)) a-uc))
        (when (> (length word) 1)
          (setq b-lc (cons (downcase (substring word 1 2)) b-lc)
                b-uc (cons (upcase (substring word 1 2)) b-uc)))
        (when (> (length word) 2)
          (setq c-lc (cons (downcase (substring word 2 3)) c-lc)
                c-uc (cons (upcase (substring word 2 3)) c-uc)))
        ))
    (mapcar (lambda (s)
              (lyskom-xemacs-or-gnu
               s
               (lyskom-encode-coding-string 
                s 
                (and (boundp 'default-keyboard-coding-system)
                     default-keyboard-coding-system))))
            (nconc (nreverse a-lc)
                   (nreverse b-lc)
                   (nreverse c-lc)
                   (nreverse a-uc)
                   (nreverse b-uc)
                   (nreverse c-uc)
                   ))))


(defun lyskom-keyboard-menu-frob-table (table)
  "Convert TABLE to a form suitable for keyboard menus.
TABLE is an alist whose elements' cars are strings. The result will
be an alist whose elements' cars are mnemonics for the string in the
same element's cdr."
  (let ((used-keys nil)
        (default-keys "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
        (default-keys-index 0))
    (nconc
     (mapcar 
      (lambda (element)
        (let* ((string (car element))
               (keys (lyskom-keyboard-menu-keys-for-string string))
               (mnemonic (lyskom-traverse key keys
                           (unless (member key used-keys)
                             (lyskom-traverse-break key)))))

          (while (and (not mnemonic)
                      (< default-keys-index (length default-keys)))
            (let ((key (substring default-keys 
                                  default-keys-index
                                  (1+ default-keys-index))))
              (unless (member key used-keys)
                (setq mnemonic key))))

          (setq used-keys (cons mnemonic used-keys))
          (list mnemonic string element)))
      table)
     (list (list "C-g" (lyskom-get-string 'keyboard-cancel) nil)))))



(defun lyskom-keyboard-menu-highlight-selected ()
  "Highlight the selected menu item"
  (set-buffer lyskom-keyboard-menu-buffer)
  (let ((pos (text-property-any (point-min) 
                                (point-max)
                                'lyskom-keyboard-menu-item
                                lyskom-keyboard-menu-selection)))
    (cond ((or (null pos)
               (null lyskom-keyboard-menu-selection))
           (lyskom-xemacs-or-gnu
            (set-extent-face lyskom-keyboard-menu-overlay nil)
            (overlay-put lyskom-keyboard-menu-overlay 'face nil))
           (goto-char (point-min)))
          (t (let ((start pos)
                   (end (or (next-single-property-change 
                             pos
                             'lyskom-keyboard-menu-item)
                            (point-max))))
               (lyskom-xemacs-or-gnu
                (set-extent-endpoints lyskom-keyboard-menu-overlay
                                      start end)
                (move-overlay lyskom-keyboard-menu-overlay
                              start end)))
             (goto-char pos)
             (lyskom-xemacs-or-gnu
              (set-extent-face lyskom-keyboard-menu-overlay kom-mark-face)
              (overlay-put lyskom-keyboard-menu-overlay
                           'face kom-mark-face))))
    (save-excursion
      (unless (pos-visible-in-window-p pos)
        (recenter)))))


(defun lyskom-keyboard-menu-format-item (item &optional pad-len)
  "Format a single menu item as a string"
  (let ((string (format "%s (%s)" (elt item 1) (elt item 0))))
    (when (and pad-len (> pad-len (length string)))
      (setq string (concat string (make-string (- pad-len (length string))
                                               ?\ ))))
    (add-text-properties 0 
                         (length string)
                         (list 'lyskom-keyboard-menu-item item)
                         string)
    string))

(defun lyskom-keyboard-menu-insert (prompt menu)
  "Insert the text-based representation of the menu.
PROMPT is the menu title and MENU is the menu data."
  (let* ((line-length (apply 'max
                             (mapcar (lambda (x)
                                       (+ (length (elt x 0))
                                          (length (elt x 1))
                                          3))
                                     menu)))
         (columns (/ (+ (window-width) 1)
                     (+ line-length 2)))
         (dashes (make-string (+ (* line-length columns)
                                 (* 2 (1- columns))) ?-))
         (quit-item nil))

    (insert (format "%s\n%s\n" prompt dashes))
    (lyskom-traverse el menu
      (if (null (elt el 2))
          (setq quit-item el)
        (let ((string (lyskom-keyboard-menu-format-item el line-length)))
          (when (> (+ (current-column) (length string) 2) (window-width))
            (insert "\n"))
          (unless (bolp) (insert "  "))
          (insert string))))
    (unless (bolp)
      (insert "\n"))
    (insert dashes)
    (insert "\n")
    (when quit-item
      (insert (lyskom-keyboard-menu-format-item quit-item)))))




;;; ================================================================
;;; Interactive commands
;;; 


(defun lyskom-read-from-menu (prompt table)
  "Let the user select one of the values in TABLE.
TABLE is an alist whose elements' cars are strings.
Returns the selected string."
  (let* ((menu (lyskom-keyboard-menu-frob-table table))
         (buffer (get-buffer-create "*Keyboard menu*"))
         (menu-window-height 0))
    (save-excursion

      ;; Format the buffer

      (set-buffer buffer)
      (erase-buffer)
      (lyskom-keyboard-menu-insert prompt menu)

      (goto-char (point-min))
      (setq menu-window-height (+ 2 (count-lines (point-min) (point-max))))

      ;; Display the window and do the thing

      (save-window-excursion
        (if (< (- (window-height (selected-window))
                  menu-window-height) 5)
            (select-window
             (display-buffer buffer t))
          (split-window (selected-window) menu-window-height)
          (switch-to-buffer buffer))
        (let* ((lyskom-keyboard-menu-buffer buffer)
               (lyskom-keyboard-menu-menu menu)
               (lyskom-keyboard-menu-selection nil)
               (lyskom-keyboard-menu-overlay 
                (lyskom-xemacs-or-gnu
                 (make-extent 1 1 lyskom-keyboard-menu-buffer)
                 (make-overlay 0 0 lyskom-keyboard-menu-buffer)))
               (result nil))

          (lyskom-xemacs-or-gnu
           (set-extent-face lyskom-keyboard-menu-overlay nil)
           (overlay-put lyskom-keyboard-menu-overlay 'face nil))

          (condition-case nil
              (while (null result)
                (lyskom-keyboard-menu-highlight-selected)
                (let ((c (lyskom-keyboard-menu-read-char 
                          (lyskom-format "%#1s %#2s: %#3s"
                                         prompt
                                         (lyskom-get-string 'keyboard-menu-help)
                                         (or (elt lyskom-keyboard-menu-selection 1)
                                             "")))))
                  (cond ((eq (lookup-key global-map (vector c)) 'keyboard-quit)
                         (keyboard-quit))
                        ((eq c ?\C-a) (lyskom-keyboard-menu-beginning-of-line))
                        ((eq c ?\C-e) (lyskom-keyboard-menu-end-of-line))
                        ((or (eq c 'up)
                             (eq c ?\C-p))
                         (lyskom-keyboard-menu-up))
                        ((or (eq c ?\C-b)
                             (eq c 'left))
                         (lyskom-keyboard-menu-backward))
                        ((or (eq c 'down)
                             (eq c ?\C-n))
                         (lyskom-keyboard-menu-down))
                        ((or (eq c ?\C-f)
                             (eq c 'right))
                         (lyskom-keyboard-menu-forward))
                        ((or (eq c 'return)
                             (eq c ?\r)
                             (eq c ?\n))
                         (setq result lyskom-keyboard-menu-selection))
                        ((and (lyskom-characterp c)
                              (assoc (make-string 1 c) 
                                     lyskom-keyboard-menu-menu))
                         (if kom-keyboard-menu-immediate-selection
                             (setq result (assoc (make-string 1 c) 
                                                 lyskom-keyboard-menu-menu))
                           (setq lyskom-keyboard-menu-selection
                                 (assoc (make-string 1 c)
                                        lyskom-keyboard-menu-menu))))))
                (when lyskom-keyboard-menu-selection
                  (setq lyskom-keyboard-menu-menu
                        (lyskom-rotate-list lyskom-keyboard-menu-menu
                                            lyskom-keyboard-menu-selection))))
            (quit (setq result nil)))
          (elt result 2)
          )))))

(defun lyskom-keyboard-menu-up ()
  "Move up one menu item"
  (interactive)
  (let ((done nil))
    (while (not done)

      ;; Move up one line
      (condition-case nil
          (previous-line 1)
        (beginning-of-buffer (setq done t)))

      ;; Scan the items on this line until we find the one
      ;; just before point or just after point or around
      ;; point.

      (let ((selection nil)
            (start (save-excursion (beginning-of-line) (point)))
            (end (save-excursion (end-of-line) (point)))
            (pos (point)))
        (while (and (>= pos start) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1- pos)))

        (setq pos (point))
        (while (and (<= pos end) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1+ pos)))
        (when selection (setq done t
                              lyskom-keyboard-menu-selection selection))))))

(defun lyskom-keyboard-menu-down ()
  "Move down one menu item."
  (interactive)
  (let ((done nil))
    (while (not done)

      ;; Move up one line
      (condition-case nil
          (next-line 1)
        (end-of-buffer (setq done t)))

      ;; Scan the items on this line until we find the one
      ;; just before point or just after point or around
      ;; point.

      (let ((selection nil)
            (start (save-excursion (beginning-of-line) (point)))
            (end (save-excursion (end-of-line) (point)))
            (pos (point)))
        (while (and (>= pos start) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1- pos)))

        (setq pos (point))
        (while (and (<= pos end) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1+ pos)))
        (when selection (setq done t
                              lyskom-keyboard-menu-selection selection))))))




(defun lyskom-keyboard-menu-forward ()
  "Move right one menu item."
  (interactive)
  (let ((pos (point))
        (item nil))
    (while (and pos (or (null item) (eq item lyskom-keyboard-menu-selection)))
      (setq pos (next-single-property-change pos 'lyskom-keyboard-menu-item))
      (when pos
        (setq item (get-text-property pos 'lyskom-keyboard-menu-item))))
    (when item (setq lyskom-keyboard-menu-selection item))))


(defun lyskom-keyboard-menu-backward ()
  "Move left one menu item."
  (interactive)
  (let ((pos (point))
        (item nil))
    (while (and pos (or (null item) (eq item lyskom-keyboard-menu-selection)))
      (setq pos (previous-single-property-change pos 'lyskom-keyboard-menu-item))
      (when pos
        (setq item (get-text-property pos 'lyskom-keyboard-menu-item))))
    (when item (setq lyskom-keyboard-menu-selection item))))

(defun lyskom-keyboard-menu-beginning-of-line ()
  "Move to the first menu item of this line."
  (interactive)
  (beginning-of-line)
  (setq lyskom-keyboard-menu-selection
        (or (get-text-property (point) 'lyskom-keyboard-menu-item)
            (get-text-property (or (next-single-property-change 
                                    (point) 'lyskom-keyboard-menu-item
                                    nil (save-excursion (end-of-line) (point)))
                                   (point))
                               'lyskom-keyboard-menu-item))))

(defun lyskom-keyboard-menu-end-of-line ()
  "Move to the last menu item of this line."
  (interactive)
  (end-of-line)
  (setq lyskom-keyboard-menu-selection
        (if (get-text-property (point) 'lyskom-keyboard-menu-item)
            (get-text-property (point) 'lyskom-keyboard-menu-item)
          (let ((pos (previous-single-property-change 
                      (point) 'lyskom-keyboard-menu-item
                      nil (1- (save-excursion (beginning-of-line) (point))))))
            (when (and pos (not (zerop pos)))
              (or (get-text-property pos 'lyskom-keyboard-menu-item)
                  (get-text-property (1- pos)  'lyskom-keyboard-menu-item)))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: command.el,v 44.55 2005/01/11 07:35:52 _cvs_pont_lyskomelisp Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: command.el
;;;;
;;;; This file contains stuff regarding commands.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: command.el,v 44.55 2005/01/11 07:35:52 _cvs_pont_lyskomelisp Exp $\n"))


;;; ======================================================================
;;; LysKOM user commands
;;; The new, blocking commands have a very similar structure
;;;
;;;  (defun kom-cmd (args)
;;;    "Documentation"
;;;    (interactive "...")
;;;    (lyskom-start-of-command 'kom-cmd)
;;;    (unwind-protect
;;;        (progn ...)
;;;      (lyskom-end-of-command)))
;;;
;;; This can now be written as
;;;
;;; (def-kom-command kom-cmd (args)
;;;   "Documentation"
;;;   (interactive "...")
;;;   ...)

(eval-and-compile
  (defun lyskom-fix-interactive-decl (decl command)
    (cond ((stringp (car (cdr decl))) decl)
          (t `(interactive (let ((lyskom-current-command ',command))
                             ,@(cdr decl)))))))




(defmacro def-kom-command (cmd args doc &rest forms)
  "Define a LysKOM command CMD with args ARGS and docstring DOC.

This is like a defun for LysKOM commands. After the docstring you may
have a series of keywords that alter the behavior of the command,
followed by an interactive declaration (required) and the body of the
command.

The following keywords are recognized:

:dead-ok        See the DEAD-OK paramter to lyskom-start-of-command
:may-interrupt  See the MAY-INTERRUPT parameter to lyskom-start-of-command
:prompt-format  See the PROMPT-FORMAT parameter to lyskom-start-of-command

Note that :prompt-format requires an argument."
  (let (interactive-decl may-interrupt dead-ok prompt-format)
    (while (memq (car forms) '(:prompt-format :dead-ok :may-interrupt))
      (cond ((eq (car forms) :prompt-format)
             (setq prompt-format (car (cdr forms)))
             (setq forms (cdr forms)))
            ((eq (car forms) :dead-ok)
             (setq dead-ok t))
            ((eq (car forms) :may-interrupt)
             (setq may-interrupt t)))
      (setq forms (cdr forms)))

    (when (and (listp (car forms))
               (eq 'interactive (car (car forms))))
      (setq interactive-decl (car forms) forms (cdr forms)))

    (if (not (stringp doc))
        (progn (message "!! No docstring for command %S" cmd)
               (setq forms (cons interactive-decl forms))
               (setq interactive-decl doc)
               (setq doc "")))
    (if (not (eq (car interactive-decl) 'interactive))
        (progn (message "!! Missing interactive declaration for %S; assuming \(interactive\)" cmd)
               (setq forms (cons interactive-decl forms))
               (setq interactive-decl '(interactive))))
    (let ((bufsym (make-symbol (format "%S-start-buffer" cmd)))
          (winsym (make-symbol (format "%S-start-window" cmd))))
      `(defun ,cmd ,args
         ,doc
         ,(lyskom-fix-interactive-decl interactive-decl cmd)
         (let ((lyskom-command-point (point)))
           (lyskom-start-of-command ',cmd ,may-interrupt ,dead-ok ,prompt-format)
           (let ((,bufsym (current-buffer))
                 (,winsym (selected-window)))
             (unwind-protect
                 (condition-case nil
                     (progn ,@forms)
                   (quit (ding)
                         (lyskom-insert-before-prompt
                          (lyskom-get-string 'interrupted))))
               (lyskom-save-excursion
                 (cond ((and (buffer-live-p ,bufsym)
                             (window-live-p ,winsym)
                             (eq (window-buffer ,winsym) ,bufsym))
                        (save-selected-window
                          (set-buffer ,bufsym)
                          (select-window ,winsym)
                          (lyskom-end-of-command)))

                       ((buffer-live-p ,bufsym)
                        (set-buffer ,bufsym)
                        (lyskom-end-of-command))

                       (t (lyskom-end-of-command)))))))))))


;;
;; def-kom-emacs-command works like def-kom-command, but the template 
;; is different. Commands defined this way will run as regular Emacs
;; commands when invoked outside of a LysKOM buffer. 
;;
;; The variable <cmd>-running-as-kom-command is non-nil when running
;; as a LysKOM command and nil otherwise.
;;
;; Note: this function catches *all* errors in lyskom-start-of-command
;;       which may not be what you want, so be careful.
;;
;; 
;; (defun kom-cmd (args)
;;   "Documentation"
;;   (interactive "...")
;;   (let ((kom-cmd-running-as-kom-command nil))
;;     (condition-case nil
;;         (progn (lyskom-start-of-command 'kom-cmd)
;;                (setq kom-cmd-running-as-kom-command t))
;;       (error nil))
;;     (unwind-protect
;;         (condition-case nil
;;             (progn ...)
;;           (quit (ding)
;;                 (lyskom-insert-before-prompt
;;                  (lyskom-get-string 'interrupted))))
;;       (and kom-cmd-running-as-kom-command (lyskom-end-of-command)))))
;; 

(defmacro def-kom-emacs-command (cmd args doc &rest forms)
  (let (interactive-decl may-interrupt dead-ok prompt-format)
    (while (memq (car forms) '(:prompt-format :dead-ok :may-interrupt))
      (cond ((eq (car forms) :prompt-format)
             (setq prompt-format (car (cdr forms)))
             (setq forms (cdr forms)))
            ((eq (car forms) :dead-ok)
             (setq dead-ok t))
            ((eq (car forms) :may-interrupt)
             (setq may-interrupt t)))
      (setq forms (cdr forms)))

    (when (and (listp (car forms))
               (eq 'interactive (car (car forms))))
      (setq interactive-decl (car forms) forms (cdr forms)))

    (if (not (stringp doc))
        (progn (message "!! No docstring for command %S" cmd)
               (setq forms (cons interactive-decl forms))
               (setq interactive-decl doc)
               (setq doc "")))
    (if (not (eq (car interactive-decl) 'interactive))
        (progn (message "!! Missing interactive declaration for %S; assuming \(interactive\)" cmd)
               (setq forms (cons interactive-decl forms))
               (setq interactive-decl '(interactive))))

    (let ((rsym (intern (format "%S-running-as-kom-command" cmd)))
          (bufsym (make-symbol (format "%S-start-buffer" cmd)))
          (winsym (make-symbol (format "%S-start-window" cmd))))
      `(defun ,cmd ,args
         ,doc
         ,(lyskom-fix-interactive-decl interactive-decl cmd)
         (let ((,rsym nil))
           (condition-case nil
               (progn (lyskom-start-of-command ',cmd ,may-interrupt ,dead-ok ,prompt-format)
                      (setq ,rsym t))
             (error nil))
           (let ((,bufsym (current-buffer))
                 (,winsym (selected-window)))
             (unwind-protect
                 (condition-case nil
                     (progn ,@forms)
                   (quit (ding)
                         (lyskom-insert-before-prompt
                          (lyskom-get-string 'interrupted))))
               (and ,rsym
                    (lyskom-save-excursion
                      (cond ((and (buffer-live-p ,bufsym)
                                  (window-live-p ,winsym)
                                  (eq (window-buffer ,winsym) ,bufsym))
                             (save-selected-window
                               (set-buffer ,bufsym)
                               (select-window ,winsym)
                               (lyskom-end-of-command)))

                            ((buffer-live-p ,bufsym)
                             (set-buffer ,bufsym)
                             (lyskom-end-of-command))

                            (t (lyskom-end-of-command))))))))))))


(put 'def-kom-command 'edebug-form-spec
     '(&define name lambda-list
	       [&optional stringp]	; Match the doc string, if present.
	       ("interactive" interactive)
	       def-body))

(put 'def-kom-emacs-command 'edebug-form-spec
     '(&define name lambda-list
	       [&optional stringp]	; Match the doc string, if present.
	       ("interactive" interactive)
	       def-body))



;;;; ================================================================
;;;;                User-level commands and functions.


(defsubst lyskom-command-name (command &optional language)
  "Get the command name for the command COMMAND"
  (condition-case nil
      (lyskom-get-string command 'lyskom-command language)
    (error nil)))

(defun lyskom-ok-command (alternative administrator)
  "Returns non-nil if it is ok to do such a command right now."
  (when (vectorp alternative) 
    (setq alternative (cons (elt alternative 0) (elt alternative 1))))
  (if administrator
      (not (memq (cdr alternative) lyskom-admin-removed-commands))
    (not (memq (cdr alternative) lyskom-noadmin-removed-commands))))

(defun kom-extended-command ()
  "Read a LysKOM function name and call the function."
  (interactive)
  (let ((fnc (lyskom-read-extended-command current-prefix-arg)))
    (cond
     (fnc (call-interactively fnc))
     (t (kom-next-command)))) )

(defvar lyskom-command-minibuffer-local-completion-map
  (let ((map (copy-keymap minibuffer-local-completion-map)))
    (define-key map " " 'lyskom-command-complete-word)
    map)
  "Keymap used for reading LysKOM names.")

(defvar lyskom-command-minibuffer-local-must-match-map
  (let ((map (copy-keymap minibuffer-local-must-match-map)))
    (lyskom-xemacs-or-gnu 
     (progn (lyskom-set-keymap-parent map lyskom-minibuffer-local-completion-map)
            (define-key map " " 'lyskom-command-complete-word))
     (define-key map " " 'lyskom-command-complete-word))
    map)
  "Keymap used for reading LysKOM names.")

(defun lyskom-read-extended-command (&optional prefix-arg prompt)
  "Reads and returns a command"
  (let* ((completion-ignore-case t)
	 (minibuffer-setup-hook minibuffer-setup-hook)
         (base-prompt (cond ((null prompt) (lyskom-get-string 'extended-command))
                            ((symbolp prompt) (lyskom-get-string prompt))
                            (t prompt)))
	 (alternatives (mapcar 
			(lambda (pair)
			  (cons 
			   (cdr pair)
			   (car pair)))
			(lyskom-get-strings lyskom-commands
					    'lyskom-command)))
	 (name nil)
         (prefix-text
          (cond ((eq prefix-arg '-) "- ")
                ((equal prefix-arg '(4)) "C-u ")
                ((integerp prefix-arg) 
                 (format "%d " prefix-arg))
                ((and (consp prefix-arg) 
                      (integerp (car prefix-arg)))
                 (format "%d " (car prefix-arg)))
                (t nil)))
         (prompt (if prefix-text
                     (concat prefix-text base-prompt)
                   base-prompt)))

    (let ((minibuffer-local-completion-map 
           lyskom-command-minibuffer-local-completion-map)
          (minibuffer-local-must-match-map 
           lyskom-command-minibuffer-local-must-match-map))
      (while (or (null name)
                 (string= "" name))
        (setq name (lyskom-completing-read prompt
                                           'lyskom-complete-command
                                           ;; lyskom-is-administrator is buffer-local and
                                           ;; must be evalled before the call to 
                                           ;; completing-read
                                           ;; Yes, this is not beautiful
                                           (list 'lambda '(alternative) ;
                                                 (list 'lyskom-ok-command 'alternative
                                                       lyskom-is-administrator))
                                           t
                                           nil
                                           'lyskom-command-history))))
    (cdr (lyskom-string-assoc name alternatives))))


(defun lyskom-update-command-completion ()
  "Build a list of alternatives for completion of LysKOM commands.
Each list element is a vector [NAME COMMAND CANONICAL]. NAME is the
command name, COMMAND is the command and CANONICAL is the name 
transformed for matching."
  (setq lyskom-command-alternatives
        (mapcar (lambda (el) 
                  (vector (cdr el)
                          (car el)
                          (lyskom-completing-strip-command
                           (lyskom-unicase (cdr el)))
			  (lyskom-unicase (cdr el))))
                (lyskom-get-strings lyskom-commands 'lyskom-command))))

(defun lyskom-lookup-command-by-name (string &optional predicate)
  "Look up the command that corresponds to a certain string."
  (lyskom-complete-command string predicate 'lyskom-lookup))

(defsubst lyskom-command-match-string-regexp (string)
  (concat 
   "^\\s-*"
   (replace-in-string (regexp-quote
                       (lyskom-unicase
                        (lyskom-completing-strip-command string)))
                      "\\s-+" "\\\\S-*\\\\s-+")
          "\\s-*"))

(defun lyskom-completing-strip-command (string)
  "Strip parens and crap from a name.
If optional DONT-STRIP-SPACES is non-nil, don't strip spaces at front
and back of the string."
  (while (string-match "([^()]*)" string) ; Strip nested parens
    (setq string (replace-match "" t t string)))
  (while (string-match "\\s-\\s-+" string) ; Collapse spaces
    (setq string (replace-match " " t t string)))
  (while (string-match "([^()]*$" string) ; Strip incomplete parens at end
    (setq string (substring string 0 (match-beginning 0))))
  string)

;;; FIXME: Below is an idea on how to do command completion more right.
;;;
;;; Precompute lists of words in all commands. Include the optional words 
;;; and mark them as optional. Possibly allow sublists in the list, and
;;; make lists of words into sublists and mark the entire sublist as
;;; optional.
;;;
;;; When matching, divide the input into a list of words. Start matchin
;;; prefixes against the list of words for a command. It goes something 
;;; like this:
;;;
;;; C = 0, I = 0
;;; while there are more words in the input and command
;;;    A = word I of the input
;;;    B = word C of the command
;;;    if B is an optional word then
;;;       N = index of word following optional group that B is part of
;;;       push N,I onto backtracking stack
;;;    if A is a prefix of B then
;;;       I = I + 1
;;;	  C = C + 1
;;;       next iteration of the loop
;;;    if the backtracking stack is empty then
;;;       return mismatch
;;;    pop X,Y from the backtracking stack
;;;    C = X
;;;    I = Y
;;;    next iteration of the loop
;;; end while
;;; if there are left-over words in C then
;;;    return a mismatch
;;; else
;;;    return a match (I,C)
;;;
;;; When doing a word completion we can let the completion function do the
;;; actual work. It computes the longest possible completion we can have
;;; (i.e. one full word more than what we've got) and hands that over to
;;; lyskom-complete-string. Computing the longest possible completion
;;; goes something like this:
;;;
;;; W = nil
;;; Store I,C for all matches
;;; for all matches M = 1 .. N do
;;;    do something useful
;;;
;;; The idea is to get the last word that matches the input by storing
;;; the results of the match computation and then looking at the
;;; following word in all possible completions. If the following word
;;; is a word in an optional group that is the same in all possible
;;; completions, then that plus the first C words of any of the
;;; possible completions is the maximum possible. If the next word is
;;; a word of an optional group that does *not* match in all
;;; possibles, then ignore the optional group and look at the next
;;; word instead.

(defun lyskom-complete-command (string predicate all)
  "Completion function for LysKOM commands."
  (when (string-match "^\\s-+" string)
    (setq string (substring string (match-end 0))))
  (let ((alternatives nil)
        (m-string (lyskom-command-match-string-regexp string))
        (u-string (lyskom-unicase string))
        (exact nil))
    (lyskom-traverse el lyskom-command-alternatives
      (when (and (string-match m-string (elt el 2))
                 (or (null predicate) (funcall predicate el)))
        (setq alternatives (cons (if (eq all 'lyskom-lookup) el (elt el 0)) alternatives))
	(if (string-equal u-string (elt el 3)) (setq exact el))))
    (cond 
     ((eq all 'lyskom-lookup) (and exact (elt exact 1)))
     ((eq all 'lambda) exact)
     (all alternatives)
     ((null alternatives) nil)
     ((and (= (length alternatives) 1) exact) t)
     (t (let ((tmp (lyskom-complete-string alternatives)))
	  (lyskom-maybe-recode-string
	   (if (string-match (concat (regexp-quote (lyskom-unicase tmp)) "\\s-") u-string)
	       (concat tmp " ")
	     tmp)))))))

(defun lyskom-command-complete-word ()
  (interactive)
  (let ((string (buffer-string)))
    (when (next-single-property-change 0 'read-only string)
      (setq string 
            (substring string 
                       (next-single-property-change 0 'read-only string))))

    (let ((completion (try-completion string
                                      minibuffer-completion-table
                                      minibuffer-completion-predicate)))
      (cond ((null completion) (lyskom-minibuffer-message " [No match]") nil)
            ((eq completion t) nil)
            (t (let* ((tmp string))
                 (when (and (string-equal (lyskom-unicase completion)
                                          (lyskom-unicase tmp))
                            (not (string-match "\\s-$" completion)))
                   (if (stringp (setq tmp (try-completion 
                                           (concat tmp " ")
                                           minibuffer-completion-table
                                           minibuffer-completion-predicate)))
                       (setq completion tmp)))
                 (if (string-equal (lyskom-unicase completion)
                                   (lyskom-unicase string))
                     (progn (minibuffer-completion-help) nil)
                   (delete-region (- (point-max) (length string))
                                  (point-max))

                   ;; Now we have the suggested completion
                   ;; Expand what's in the buffer by one real word.

                   (let* ((count (lyskom-command-complete-count-words string))
                          (result (lyskom-command-complete-word-truncate 
                                   completion count)))
                     (when (string= result string)
                       (setq result (lyskom-command-complete-word-truncate 
                                     completion (1+ count))))
                     (insert result))
                   t)))))))

(defvar lyskom-command-complete-regexp
  "\\(([^\)]*)\\s-+\\)*\\S-+\\(\\s-*([^\)]*)\\)*\\(\\s-+\\|\\'\\)")

(defun lyskom-command-complete-word-truncate (completion count)
  "Truncate completion COMPLETION to COUNT words."
  (let ((start 0))
    (while (and (> count 0)
                (string-match lyskom-command-complete-regexp completion start))
      (setq start (match-end 0)
            count (1- count)))
    (substring completion 0 start)))

(defun lyskom-command-complete-count-words (string)
  "Count number of real words in command name or completion STRING."
  (let ((start 0)
        (count 0))
    (while (string-match lyskom-command-complete-regexp string start)
      (setq start (match-end 0)
            count (1+ count)))
    count))



;;; The code below is an alternative implementation of 
;;; lyskom-command-complete-word that mucks with the
;;; contents of the minibuffer and then calls the regular
;;; minibuffer functions.
;;;
;;;
;;;(defun lyskom-command-complete-word-count-words (string)
;;;  (let ((count 0)
;;;        (start 0))
;;;    (while (string-match lyskom-command-complete-regexp string start)
;;;      (setq start (match-end 0)
;;;            count (1+ count)))
;;;    count))  
;;;
;;;(defun lyskom-command-complete-word ()
;;;  (interactive)
;;;  (let* ((string (buffer-string))
;;;         completions)
;;;    ;; Strip the prompt in Emacs 21
;;;    (when (next-single-property-change 0 'read-only string)
;;;      (setq string 
;;;            (substring string 
;;;                       (next-single-property-change 0 'read-only string))))
;;;
;;;    (setq completions (save-excursion
;;;                        (set-buffer lyskom-buffer)
;;;                        (lyskom-complete-command string 
;;;                                                 nil
;;;                                                 nil)))
;;;    (when (stringp completions)
;;;      (let ((original-count (lyskom-command-complete-word-count-words string))
;;;            (start 0))
;;;        (while (and (> original-count 0)
;;;                    (string-match lyskom-command-complete-regexp completions start))
;;;          (setq start (match-end 0)
;;;                original-count (1- original-count)))
;;;
;;;        (delete-region (- (point-max) (length string)) (point-max))
;;;        (let ((result (substring completions 0 start)))
;;;          (string-match "\\s-*\\'" result)
;;;          (insert (substring result 0 (match-beginning 0)))))))
;;;  (minibuffer-complete-word))


(defun lyskom-start-of-command (function &optional may-interrupt dead-ok prompt-format)
  "This function is run at the beginning of every LysKOM command.
It moves the cursor one line down, and +++ later it will tell the server
that the previous text has been read.

Argument FUNCTION is a string the string will be written in the buffer
on start of the command. If it is a symbol it searches for the corresponding
command name in lyskom-commands and writes this in the message buffer.

If optional argument MAY-INTERRUPT is present and non-nil,
don't signal an error if this call is interrupting another command.

If optional DEAD-OK is non-nil, don't signal an error if the session 
has been closed.

If optional PROMPT-FORMAT is non-nil, this will be used to format the prompt.
It should be a format string suitable for lyskom-format. Argument one is the
command name (a symbol or string).

Special: if lyskom-is-waiting then we are allowed to break if we set 
lyskom-is-waiting nil.

This function checks if lyskom-doing-default-command and
lyskom-first-time-around are bound. The text entered in the buffer is
chosen according to this"

  (cond ((or (not (boundp 'lyskom-proc))
             (not (boundp 'lyskom-buffer))
             (and (null lyskom-proc) (null lyskom-buffer)))
         (lyskom-error "%s" (lyskom-get-string 'not-lyskom-buffer)))

        ((and (not (or dead-ok
		       (memq function kom-relogin-inhibit-commands)))
              (or (not lyskom-proc)
                  (memq (process-status lyskom-proc) '(closed signal exited nil))))
	 (if (or (eq t kom-relogin-behaviour)
		 (and (eq 'ask kom-relogin-behaviour) 
		      (lyskom-j-or-n-p (lyskom-get-string 'resurrect-session))))
	     (lyskom lyskom-server-name lyskom-pers-no)
      (lyskom-error "%s" (lyskom-get-string 'dead-session)))))

  (if (and lyskom-is-waiting
           (listp lyskom-is-waiting))
      (progn
        (setq lyskom-is-waiting nil)
        (lyskom-end-of-command)))

  (setq lyskom-is-waiting nil)
  (if (and lyskom-executing-command (not may-interrupt))
      (lyskom-error "%s" (lyskom-get-string 'wait-for-prompt)))
  (if (not (and (boundp 'lyskom-doing-default-command)
                lyskom-doing-default-command))
      (cond
       (lyskom-first-time-around)
       ((stringp function) (lyskom-insert function))
       ((lyskom-command-name function)
        (if prompt-format 
            (lyskom-format-insert prompt-format function)
          (lyskom-insert (lyskom-command-name function)))))
    (save-excursion
      (if lyskom-current-prompt
          (let ((inhibit-read-only t))
            (goto-char (point-max))
            (beginning-of-line)
            (delete-region (point) (point-max)))))
    (lyskom-insert (lyskom-modify-prompt 
                    (cond ((stringp lyskom-current-prompt) 
                           (apply 'lyskom-format 
                                  lyskom-current-prompt
                                  lyskom-current-prompt-args))
                          ((symbolp lyskom-current-prompt)
                           (apply 'lyskom-format 
                                  (lyskom-get-string lyskom-current-prompt)
                                  lyskom-current-prompt-args))
                          (t (format "%S" lyskom-current-prompt)))
                    t)))
  (setq mode-line-process (lyskom-get-string 'mode-line-working))
  (if (pos-visible-in-window-p (point-max))
      (save-excursion
        (goto-char (point-max))
        (lyskom-set-last-viewed)))
  (setq lyskom-executing-command t)
  (setq lyskom-current-command function)
  (setq lyskom-current-prompt nil)
  (lyskom-insert "\n")
  (if (and (eq (window-buffer (selected-window))
               (current-buffer))) 
      (progn
	(if (pos-visible-in-window-p (1- (point-max)))
	    (goto-char (point-max)))
	(sit-for 0)))
  (run-hooks 'lyskom-before-command-hook)
  (if kom-page-before-command           ;Nice with dumb terminals.
      (if (or (not (listp kom-page-before-command))
              (memq function kom-page-before-command))
          (recenter 1))))


(defun lyskom-end-of-command ()
  "Print prompt, maybe scroll, prefetch info."
  (lyskom-save-excursion
    (message "")
    (lyskom-clean-all-buffer-lists)
    (while (and lyskom-to-be-printed-before-prompt
                (lyskom-queue->first lyskom-to-be-printed-before-prompt))
      (if (not (bolp)) (lyskom-insert "\n"))
      (lyskom-insert (car (lyskom-queue->first 
                           lyskom-to-be-printed-before-prompt)))
      (lyskom-queue-delete-first lyskom-to-be-printed-before-prompt))
    (setq lyskom-executing-command nil)
    (setq lyskom-current-command nil)
    (setq lyskom-current-prompt nil)	; Already set in s-o-c really
    (lyskom-scroll)
    (setq mode-line-process (lyskom-get-string 'mode-line-waiting))
    (if (pos-visible-in-window-p (point-max) (selected-window))
        (lyskom-set-last-viewed))
    (lyskom-prefetch-and-print-prompt)
    (run-hooks 'lyskom-after-command-hook)
    (when (and (lyskom-have-feature idle-time)
               (not lyskom-is-anonymous))
      (save-excursion (set-buffer lyskom-buffer)
                      (initiate-user-active 'background nil)))
    (if kom-inhibit-typeahead
        (discard-input))
    ;; lyskom-pending-commands should probably be a queue or a stack.
    (when lyskom-pending-commands
      (let ((command (car lyskom-pending-commands)))
        (setq lyskom-pending-commands (cdr lyskom-pending-commands))
        (if (symbolp command)
            (call-interactively command)
          (eval command))))
    (when lyskom-slow-mode
      (buffer-enable-undo))))

(eval-and-compile (provide 'lyskom-command))

;;; command.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: buffers.el,v 44.28 2004/11/15 17:27:17 _cvs_pont_lyskomelisp Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: buffers.el
;;;; Author: David Byers
;;;;
;;;; This file implements special buffer handling used in LysKOM
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: buffers.el,v 44.28 2004/11/15 17:27:17 _cvs_pont_lyskomelisp Exp $\n"))


;;;;
;;;; LYSKOM BUFFER MANAGEMENT
;;;;
;;;; Buffers are arranged in a tree rooted in a LysKOM buffer. There
;;;; is one tree for each session.
;;;;
;;;; Use lyskom-get-buffer-create to create new buffers
;;;; Use lyskom-display-buffer to display most buffers
;;;; Use lyskom-undisplay-buffer to undisplay those buffers
;;;;





;;;; ============================================================
;;;; Buffer hierarchy management
;;;;
;;;; This code should not be too dependent on LysKOM
;;;;

(defvar lyskom-buffer-children nil
  "List of buffers that are children to this buffer")

(defvar lyskom-buffer-inherited-variables nil
  "List of variables automatically inherited to sub-buffers when
they are created.")

(defvar lyskom-buffer-parent nil
  "Parent of buffer")

(defvar lyskom-killing-hierarchy nil
  "Non-nil while killing a buffer hierarchy.")

(make-variable-buffer-local 'lyskom-buffer-parent)
(lyskom-protect-variable 'lyskom-buffer-parent)

(make-variable-buffer-local 'lyskom-buffer-children)
(lyskom-protect-variable 'lyskom-buffer-children)

(make-variable-buffer-local 'lyskom-buffer-inherited-variables)
(lyskom-protect-variable 'lyskom-buffer-inherited-variables)




(defun lyskom-set-buffer-parent (buffer parent)
  "Set the parent buffer of BUFFER to PARENT. If buffer is already
a child of some buffer, reparent it."
  (save-excursion (set-buffer buffer)
		  (if (and lyskom-buffer-parent
                           (buffer-live-p lyskom-buffer-parent))
                      (lyskom-remove-buffer-child lyskom-buffer-parent buffer))
		  (setq lyskom-buffer-parent parent)
		  (if parent (lyskom-add-buffer-child parent buffer))))

(defun lyskom-remove-buffer-child (buffer child)
  "Remove CHILD from BUFFER's list of children. Args: BUFFER CHILD"
  (save-excursion (set-buffer buffer)
		  (if (boundp 'lyskom-buffer-children)
		      (setq lyskom-buffer-children 
                            (delq child lyskom-buffer-children)))))

(defun lyskom-add-buffer-child (buffer child)
  "Add CHILD as a child of BUFFER. Args: BUFFER CHILD"
  (save-excursion (set-buffer buffer)
		  (setq lyskom-buffer-children
                        (cons child lyskom-buffer-children))))

(defun lyskom-get-buffer-parent (buffer)
  "Return the parent of BUFFER or nil if it has no parent"
  (save-excursion (set-buffer buffer)
		  (and (boundp 'lyskom-buffer-parent)
		       lyskom-buffer-parent)))

(defun lyskom-get-buffer-children (buffer)
  "Return the list of children of buffer BUFFER or nil if there are none."
  (save-excursion (set-buffer buffer)
		  (and (boundp 'lyskom-buffer-children)
		       lyskom-buffer-children)))

(defun lyskom-buffer-root-ancestor (buffer)
  "Return the ultimate ancestor of buffer BUFFER."
  (let ((buffer-parent buffer))
    (while (setq buffer-parent
		 (lyskom-get-buffer-parent buffer))
      (setq buffer buffer-parent))
    buffer))

(defun lyskom-traverse-buffer-hierarchy (function buffer)
  "Apply FUNCTION to each descendent of BUFFER. Results are discarded."
  (let ((queue (list buffer))
        (done nil)
        (current nil))
    (while queue
      (setq current (car queue))
      (setq queue (cdr queue))
      (unless (or (memq current done)
                  (not (buffer-live-p current)))
        (setq done (cons current done))
        (setq queue (append queue (lyskom-get-buffer-children current)))
        (funcall function current)))))


(defun lyskom-map-buffer-children (function buffer)
  "Apply FUNCTION to each child of BUFFER and make a list of the results."
  (cond ((null buffer) nil)
	(t (cons (funcall function buffer)
		 (apply 'nconc 
			(mapcar (function
				 (lambda (x)
                                   (lyskom-map-buffer-children function x)))
				(lyskom-get-buffer-children buffer)))))))


(defun lyskom-buffer-hierarchy-query-kill-function ()
  "When querying if a buffer is to be killed, ensure that none of
the children object"
  (save-excursion
    (not (memq nil
               (mapcar (function
                        (lambda (buffer)
                          (if (buffer-live-p buffer)
                              (progn (set-buffer buffer)
                                     (run-hook-with-args-until-failure
                                      'kill-buffer-query-functions))
                            t)))
                       (lyskom-get-buffer-children (current-buffer)))))))
  

(defun lyskom-buffer-hierarchy-kill-hook ()
  "When killing a buffer, enure that its children also die"
  (let ((kill-buffer-query-functions nil)
        (lyskom-killing-hierarchy (or lyskom-killing-hierarchy
                                      (current-buffer))))
    (lyskom-set-buffer-parent (current-buffer) nil)
    (let ((buflist (lyskom-get-buffer-children (current-buffer))))
      (while buflist
        (kill-buffer (car buflist))
        (setq buflist (cdr buflist))))))


(defun lyskom-buffer-kill-trim-hook ()
  "When killing a buffer, run trimming hooks."
  (when (eq major-mode 'lyskom-mode)
    (let ((lyskom-trim-buffer-delete-to (point-max)))
      (lyskom-ignore lyskom-trim-buffer-delete-to)
      (run-hooks 'lyskom-trim-buffer-hook))))

(add-hook 'kill-buffer-hook 'lyskom-buffer-hierarchy-kill-hook)
(add-hook 'kill-buffer-hook 'lyskom-buffer-kill-trim-hook)
(add-hook 'kill-buffer-query-functions
          'lyskom-buffer-hierarchy-query-kill-function)

;;;; ======================================================================

(defun lyskom-update-unread-mode-line ()
  (setq lyskom-unread-mode-line 
	(lyskom-make-lyskom-unread-mode-line)))

;;;; ======================================================================
;;;; ======================================================================

(defun lyskom-clean-all-buffer-lists ()
  "Remove dead buffers from all relevant buffer lists"
  (setq lyskom-sessions-with-unread
        (lyskom-clean-buffer-list lyskom-sessions-with-unread)
        lyskom-sessions-with-unread-letters
        (lyskom-clean-buffer-list lyskom-sessions-with-unread-letters)
        lyskom-buffer-list
        (lyskom-clean-buffer-list lyskom-buffer-list))
  (lyskom-update-unread-mode-line)
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defun lyskom-clean-buffer-list (buffers)
  "Remove all dead buffers from BUFFERS"
  (let ((result nil))
    (while buffers
      (if (lyskom-buffer-p (car buffers))
        (setq result (cons (car buffers) result))
        (save-excursion (set-buffer (car buffers))
                        (setq lyskom-session-has-unread-letters nil)
                        (setq lyskom-session-has-unreads nil)))
      (setq buffers (cdr buffers)))
    (nreverse result)))

(defun lyskom-remove-buffer-from-lists (&optional buffer)
    "Remove BUFFER from all internal lists.
If BUFFER is not specified, assume the current buffer"
  (unless buffer (setq buffer (current-buffer)))
  (lyskom-remove-unread-buffer buffer)  
  (setq lyskom-buffer-list
        (delq buffer lyskom-buffer-list))
  (lyskom-update-unread-mode-line)
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defun lyskom-remove-unread-buffer (buffer &optional letters-only)
  (unless letters-only
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unreads nil)))
     buffer)
    (setq lyskom-sessions-with-unread 
          (delq buffer lyskom-sessions-with-unread)))
  (lyskom-traverse-buffer-hierarchy 
   (lambda (x)
     (save-excursion (set-buffer x)
                     (setq lyskom-session-has-unread-letters nil)))
   buffer)
  (setq lyskom-sessions-with-unread-letters
        (delq buffer lyskom-sessions-with-unread-letters))
  (lyskom-update-unread-mode-line)
  (lyskom-set-default 'lyskom-need-prompt-update t))
  

(defun lyskom-add-unread-buffer (buffer &optional letters)
  (unless (memq buffer lyskom-sessions-with-unread)
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unreads t)))
     buffer)
    (setq lyskom-sessions-with-unread
          (cons buffer lyskom-sessions-with-unread)))
  (unless (or (null letters)
              (memq buffer lyskom-sessions-with-unread-letters))
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unread-letters t)))
     buffer)
    (setq lyskom-sessions-with-unread-letters
          (cons buffer lyskom-sessions-with-unread-letters)))
  (lyskom-update-unread-mode-line) 
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defvar lyskom-associated-buffer-list nil
  "List of (CATEGORY . BUFFER-LIST) listing all buffers of various
categories")

(make-variable-buffer-local 'lyskom-associated-buffer-list)
(lyskom-protect-variable 'lyskom-associated-buffer-list)

(defvar lyskom-buffer-category nil
  "Category of this buffer")

(make-variable-buffer-local 'lyskom-buffer-category)
(lyskom-protect-variable 'lyskom-buffer-category)

(def-kom-var lyskom-saved-window-configuration nil
  "The window configuration to return to when closing the window"
  protected
  local)

(def-kom-var lyskom-dedicated-frame nil
  "The frame dedicated to the current buffer"
  protected
  local)

(def-kom-var lyskom-dedicated-window nil
  "The window dedicated to the current buffer"
  protected
  local)

(defvar lyskom-undisplaying-hierarchy nil
  "The top of the buffer hierarchy being undisplayed.")



(defun lyskom-clean-up-buffer-category (cat)
  (let ((buffers (cdr (assq cat (lyskom-default-value 'lyskom-associated-buffer-list))))
        (result nil))
    (while buffers
      (when (buffer-live-p (car buffers))
        (setq result (cons (car buffers) result)))
      (setq buffers (cdr buffers)))
    (lyskom-set-buffers-of-category cat (nreverse result))))


(defun lyskom-set-buffers-of-category (category buflist)
  (let ((tmp (assq category (lyskom-default-value 'lyskom-associated-buffer-list))))
    (cond (tmp (setcdr tmp buflist))
          (t (lyskom-setq-default 
              lyskom-associated-buffer-list
              (cons (cons category buflist)
                    (lyskom-default-value 'lyskom-associated-buffer-list)))))))


(defun lyskom-buffers-of-category (cat)
  "Return all live buffers of catgory CAT"
  (lyskom-clean-up-buffer-category cat)
  (cdr (assq cat (lyskom-default-value 'lyskom-associated-buffer-list))))


(defun lyskom-add-buffer-of-category (buffer category)
  "Add BUFFER as a buffer of category CATEGORY"
  (let ((tmp (assq category (lyskom-default-value 'lyskom-associated-buffer-list))))
    (cond (tmp (setcdr tmp (cons buffer (cdr tmp))))
          (t (lyskom-setq-default 'lyskom-associated-buffer-list
                                  (cons (cons category (list buffer))
                                        (lyskom-default-value
                                         'lyskom-associated-buffer-list)))))))


(defun lyskom-quit-query ()
  (if (and (boundp 'lyskom-buffer)
           (local-variable-p 'lyskom-buffer (current-buffer))
             (eq lyskom-buffer (current-buffer))
             (lyskom-buffers-of-category 'write-texts))
    (unwind-protect
        (progn
          (display-buffer (car (lyskom-buffers-of-category 'write-texts)))
          (lyskom-ja-or-nej-p (lyskom-get-string 'quit-in-spite-of-unsent)))
      nil)
    t))

(add-hook 'kill-buffer-query-functions 'lyskom-quit-query)
(add-hook 'kill-emacs-query-functions 'lyskom-quit-query)

(defun lyskom-recode-buffer-name (name)
  (cond ((and (lyskom-multibyte-string-p name)
              (not enable-multibyte-characters))
	 (lyskom-encode-coding-string name 
			       (or (and lyskom-language
					(lyskom-language-coding
					 lyskom-language))
				   'raw-text)))
	((and (not (lyskom-multibyte-string-p name)) 
              enable-multibyte-characters)
	 (lyskom-decode-coding-string name 
                                      (or (and lyskom-language
                                               (lyskom-language-coding
                                                lyskom-language))
                                          'raw-text)))
	(t name)))

(defun lyskom-generate-new-buffer (name)
  (setq name (lyskom-recode-buffer-name name))
  (let ((buf (generate-new-buffer name)))
    (save-excursion
      (set-buffer buf))
    buf))

(defun lyskom-get-buffer-create (category name &optional unique)
  "Create a new buffer of category CATEGORY with name generated from NAME. 
If UNIQUE is non-nil, re-use the first existing buffer of category
CATEGORY, renaming it and killing its local variables.

The created buffer is made a child of the current buffer."
  (setq name (lyskom-recode-buffer-name name))
  (let ((buffers (lyskom-buffers-of-category category))
        (buffer nil))
    (if (and unique buffers)
        (progn (setq buffer (car buffers))
               (save-excursion (set-buffer buffer)
                               (let ((inhibit-read-only t))
;;; +++ FIXME: This is that erase-buffer works if there are widgets
                                 (setq before-change-functions
                                       (delq 'widget-before-change
                                             before-change-functions))
                                 (erase-buffer))
                               (kill-all-local-variables)
                               (if (equal (buffer-name (current-buffer))
                                          name)
                                   nil
                                 (rename-buffer name t))))
      (progn (setq buffer (generate-new-buffer name))
             (lyskom-add-buffer-of-category buffer category)))
    (lyskom-set-buffer-parent buffer (current-buffer))
    (lyskom-update-inherited-variables buffer)
    (save-excursion (set-buffer buffer)
                    (setq lyskom-buffer-category category))
    buffer))



(defun lyskom-update-inherited-variables (buffer)
  "Update all inherited variables in this buffer and propagate them
to all children"
  (save-excursion 
    (let ((variables nil)
          (tmp lyskom-inherited-variables))
      (set-buffer buffer)
      (when lyskom-buffer-parent
        (set-buffer lyskom-buffer-parent)
        (setq variables (mapcar 'symbol-value lyskom-inherited-variables))
        (set-buffer buffer)
        (while tmp
          (make-local-variable (car tmp))
          (set (car tmp) (car variables))
          (setq tmp (cdr tmp)
                variables (cdr variables))))
      (mapcar 'lyskom-update-inherited-variables
              lyskom-buffer-children))))



(defun lyskom-display-buffer (buffer &optional keep-frame-iconified)
  "Display the buffer BUFFER and select the window displaying it.

If BUFFER is already visible in some window in any frame, iconified or
otherwise, make that window visible. Otherwise display buffer as per 
which category it is in. Selects the window.

If optional argument KEEP-FRAME-ICONIFIED is non-nil, then don't
deiconify any frames.

Returns the window displaying BUFFER."


  (set-buffer buffer)
  (let ((windows (lyskom-get-buffer-window-list buffer nil 0))
        (iconified-frame nil)
        (visible-frame))

    ;;
    ;; Find out if the buffer is visible somewhere
    ;;

    (while windows
      (cond ((not (frame-live-p (window-frame (car windows)))))
            ((eq (frame-visible-p (window-frame (car windows))) 'icon)
             (setq iconified-frame (car windows)))
            ((frame-visible-p (window-frame (car windows)))
             (setq visible-frame (car windows))
             (setq windows nil)))
      (setq windows (cdr windows)))

    ;;
    ;; Display it
    ;;

    (cond
     (visible-frame (select-window visible-frame)
                    visible-frame)
     (iconified-frame (unless keep-frame-iconified 
                        (make-frame-visible (window-frame iconified-frame)))
                      (select-window iconified-frame)
                      iconified-frame)

     (t
      (let ((category lyskom-buffer-category)
            (window nil))
        (if (null category) 
            (progn (select-window (display-buffer buffer))
                   (selected-window))

          (let* ((sym (intern-soft (concat "kom-"
                                           (symbol-name category)
                                           "-in-window")))
                 (open (lyskom-default-value-safe sym))
                 (saved-window-configuration
                  (save-excursion
                    (set-buffer (or (and (boundp 'lyskom-buffer)
                                         lyskom-buffer)
                                    (current-buffer)))
                    (current-window-configuration)))
                 (dedicated-frame nil)
                 (dedicated-window nil))
            
            (cond 

             ;;
             ;; NULL -- Just switch to the buffer
             ;;

             ((null open)
              (switch-to-buffer buffer)
              (setq window (selected-window)))

             ;;
             ;; OTHER, OTHER-WINDOW -- Switch to in another window
             ;;

             ((memq open '(other other-window))
              (switch-to-buffer-other-window buffer)
              (setq dedicated-window (selected-window))
              (setq window (selected-window)))
                  
             ;;
             ;; OTHER-FRAME -- Switch to in another frame
             ;; Create frame if none exist
             ;;

             ((eq open 'other-frame)
              (if (eq (selected-frame) (next-frame))
                  (switch-to-buffer-other-frame buffer)
                (other-frame 1)
                (switch-to-buffer buffer))
              (setq window (selected-window)))
                  
             ;;
             ;; NEW-FRAME
             ;; Create a new frame and display buffer in that frame
             ;;

             ((eq open 'new-frame)
              (switch-to-buffer-other-frame buffer)
              (setq dedicated-frame (selected-frame))
              (setq dedicated-window (selected-window))
              (setq window (selected-window))
              (setq saved-window-configuration nil))

             ;;
             ;; String or buffer
             ;; Switch to buffer in window displaying named buffer
             ;; Prefer windows in selected frame
             ;;

             ((and (or (stringp open)
                       (bufferp open))
                   (lyskom-get-buffer-window-list open nil 'visible))
              (let ((tmp (lyskom-get-buffer-window-list open nil 'visible)))
                (setq window (car tmp))
                (while tmp
                  (if (eq (window-frame (car tmp))
                          (selected-frame))
                      (progn
                        (setq window (car tmp))
                        (setq tmp nil))
                    (setq tmp (cdr tmp))))
                (select-window window)
                (switch-to-buffer buffer)))

             ;;
             ;; Otherwise just switch
             ;;
             
             (t (switch-to-buffer buffer)
                (setq window (selected-window))))


            ;;
            ;; Set up kill-buffer-hooks and similar things
            ;;

            (select-window window)
            (set-buffer buffer)
            (make-local-variable 'lyskom-dedicated-frame)
            (setq lyskom-dedicated-frame dedicated-frame)
            (make-local-variable 'lyskom-dedicated-window)
            (setq lyskom-dedicated-window dedicated-window)
            (make-local-variable 'lyskom-saved-window-configuration)
            (setq lyskom-saved-window-configuration
                  saved-window-configuration)
            (lyskom-make-local-hook 'kill-buffer-hook)
            (add-hook 'kill-buffer-hook
                      'lyskom-undisplay-buffer-hook nil t)
            (put 'kill-buffer-hook 'permanent-local t)
            window)))))))


(defun lyskom-undisplay-buffer-hook ()
  (save-excursion (lyskom-undisplay-buffer (current-buffer))))

(defun lyskom-undisplay-buffer (&optional buffer)
  "Undisplay BUFFER. If buffer is not specified, undisplay the current
buffer"

  (setq buffer (or buffer (current-buffer)))
  (let ((dedicated-frame (and (boundp 'lyskom-dedicated-frame)
                              lyskom-dedicated-frame))
        (dedicated-window (and (boundp 'lyskom-dedicated-window)
                                       lyskom-dedicated-window))
        (lyskom-undisplaying-hierarchy (or buffer
                                           lyskom-undisplaying-hierarchy))
        (saved-window-configuration
         (and (boundp 'lyskom-saved-window-configuration)
              lyskom-saved-window-configuration)))
         
    (cond 

     ;;
     ;; If buffer has a dedicated frame AND
     ;; buffer is visible in that frame THEN
     ;; delete the frame
     ;;

     (dedicated-frame
      (when (memq dedicated-frame
                  (mapcar 'window-frame
                          (lyskom-get-buffer-window-list buffer nil t)))
        (delete-frame dedicated-frame)
        (setq dedicated-frame nil)))

     ((and lyskom-killing-hierarchy
           (not (eq lyskom-killing-hierarchy buffer))) nil)
     ((and lyskom-undisplaying-hierarchy
           (not (eq lyskom-undisplaying-hierarchy buffer))) nil)

     (dedicated-window
      (when (and (window-live-p dedicated-window)
                 (eq (get-buffer buffer)
                     (window-buffer dedicated-window)))
	(if (eq dedicated-window (next-window dedicated-window))
	    (bury-buffer buffer)
	    (delete-window dedicated-window))
	(setq dedicated-window nil))
      (when saved-window-configuration
        (lyskom-set-partial-window-configuration
         saved-window-configuration)))

     (saved-window-configuration
      (lyskom-set-partial-window-configuration
       lyskom-saved-window-configuration)))))

(defun lyskom-set-partial-window-configuration (configuration)
  "Set CONFIGURATION as the current window configuration with the exception
of point mark and window-start in all windows."
  (let* ((info nil)
         (binfo nil))
    (save-excursion
      (setq binfo
            (mapcar (function
                     (lambda (b)
                       (set-buffer b)
                       (list b (point) (mark t))))
                    (buffer-list)))
      (walk-windows (function
                     (lambda (w)
                       (set-buffer (window-buffer w))
                       (setq info
                             (cons
                              (list w
                                    (window-start w)
                                    (window-point w)
                                    (window-buffer w))
                              info))))
                    t t))
    (unwind-protect
        (set-window-configuration configuration)
      (save-selected-window
        (let (buffer window saved-point saved-mark saved-start)

          (while binfo
            (setq buffer (elt (car info) 0)
                  saved-point (elt (car info) 1)
                  saved-mark (elt (car info) 2))
            (when (buffer-live-p buffer)
              (set-buffer buffer)
              (goto-char saved-point)
              (set-mark saved-mark))
            (setq binfo (cdr binfo)))

          (while info
            (setq window (elt (car info) 0)
                  saved-start (elt (car info) 1)
                  saved-point (elt (car info) 2)
                  buffer (elt (car info) 3))

            (when (and (window-live-p window)
                       (eq (window-buffer window)
                           buffer))
              (set-window-start window saved-start)
              (set-window-point window saved-point))
            (setq info (cdr info))))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: aux-items.el,v 44.42 2004/02/24 12:23:16 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: aux-items.el
;;;;
;;;; Implementation of aux-item specific stuff.
;;;; Hopefulle more of this will be made more general in the future.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: aux-items.el,v 44.42 2004/02/24 12:23:16 byers Exp $\n"))

(def-kom-var lyskom-aux-item-definitions nil
  "List of aux item definitions.")

(defmacro def-aux-item (name number &rest data)
  (` (setq lyskom-aux-item-definitions 
           (add-to-list 'lyskom-aux-item-definitions
                        (cons (, number)
                              (cons (cons 'name (quote (, name)))
                                    (quote (, data))))))))

(defun lyskom-aux-item-definition->name (def)
  (cdr (assq 'name def)))

(defun lyskom-aux-item-definition->number (def)
  (car def))


(defun lyskom-aux-item-try-call (item method default &rest args)
  (when (lyskom-aux-item-p item)
    (setq item (lyskom-find-aux-item-definition item)))
  (cond ((listp method)
         (let ((result nil)
               (found nil))
           (while method
             (when (lyskom-aux-item-definition-field item (car method))
               (setq result
                     (apply (lyskom-aux-item-definition-field item
                                                              (car method))
                            args)
                     found t
                     method nil))
             (setq method (cdr method)))
           (if found result default)))
        (t (if (lyskom-aux-item-definition-field item method)
             (apply (lyskom-aux-item-definition-field item method) args)
             default))))

(defun lyskom-aux-item-has-call (item method)
  "Return non-nil if aux-item ITEM has a defined method METHOD"
  (when (lyskom-aux-item-p item)
    (setq item (lyskom-find-aux-item-definition item)))
  (lyskom-aux-item-definition-field item method))

(defun lyskom-aux-item-call (def method &rest args)
  (apply 'lyskom-aux-item-try-call def method nil args))


(defun lyskom-aux-item-definition-field (def method)
  (when (lyskom-aux-item-p def)
    (setq def (lyskom-find-aux-item-definition def)))
  (cdr (assq method def)))


(defun lyskom-find-aux-item-definition (aux)
  (assq (aux-item->tag aux) lyskom-aux-item-definitions))

(defun lyskom-match-aux-items (item-list predicate)
  "Return a list of all aux-items in ITEM-LIST that match PREDICATE.
PREDICATE should receives a single aux-item as its argument and should
return non-nil if the item is to be included in the list."
  (let ((result nil))
    (while item-list
      (when (funcall predicate (car item-list))
        (setq result (cons (car item-list) result)))
      (setq item-list (cdr item-list)))
    (nreverse result)))

(defun lyskom-get-aux-item (item-list tag)
  "Return all aux-items in ITEM-LIST with tag TAG."
  (lyskom-match-aux-items item-list
                          (lambda (el) (eq (aux-item->tag el) tag))))


(defun lyskom-aux-item-terminating-button (item obj)
  (if obj
       (lyskom-format 
        " %#1@%[[*]%]" 
        (lyskom-default-button 
         'aux 
         (cond ((lyskom-text-stat-p obj) (list 'text
                                               (text-stat->text-no obj)
                                               (aux-item->aux-no item)))
               ((lyskom-conf-stat-p obj) (list 'conf
                                               (conf-stat->conf-no obj)
                                               (aux-item->aux-no item)))
               ((eq obj 'server) (list 'server nil (aux-item->aux-no item)))
               (t item))))
     ""))

(defun lyskom-aux-item-after-parse (item)
  (lyskom-aux-item-try-call item 'decode-data nil)
  item)

(defun lyskom-aux-item-output-data (item)
  (lyskom-aux-item-try-call item 
                            'encode-data
                            (aux-item->data item)
			    item))

(defun lyskom-aux-item-modify-list (item-list deleted added)
  "Return a copy of ITEM-LIST with items in DELETED removed and items
in ADDED added."
  (let ((new-nos (nconc (mapcar 'aux-item->aux-no deleted)
                        (mapcar 'aux-item->aux-no added))))
    (nconc (filter-list (lambda (el) (not (memq (aux-item->aux-no el) new-nos)))
                        item-list)
           added)))

(defun lyskom-aux-item-validate (data &rest tests)
  "Validata aux-item data.
DATA is data to validate. TESTS are the tests to use.
A test can be a function or a regular expression to match.
Invalid tests are silently ignored."
  (not (lyskom-traverse test tests
         (condition-case nil
             (unless
                 (cond ((stringp test) (string-match test data))
                       ((functionp test) (funcall test data)))
               (lyskom-traverse-break t))
           (error (lyskom-traverse-break t))))))


;;; ======================================================================

(def-aux-item content-type 1
  (text-name aux-content-type-name)
  (parse . lyskom-parse-content-type)
  (text-print . lyskom-print-content-type)
  (info  . lyskom-aux-item-info))

(def-aux-item fast-reply 2
  (text-name aux-fast-reply-name)
  (parse . nil)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (info . lyskom-aux-item-info))

(def-aux-item cross-reference 3
  (text-name aux-cross-reference-name)
  (status-print . lyskom-status-print-cross-reference)
  (text-print-when . comment)
  (parse . lyskom-parse-cross-reference)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (text-print . lyskom-print-cross-reference)
  (edit-insert . lyskom-edit-insert-cross-reference)
  (info  . lyskom-aux-item-info))

(def-aux-item no-comments 4
  (text-name aux-no-comments-name)
  (text-print-when . footer)
  (parse . lyskom-parse-no-comments)
  (text-print . lyskom-print-no-comments)
  (edit-insert . lyskom-edit-insert-no-comments)
  (info  . lyskom-aux-item-info))

(def-aux-item personal-comment 5
  (text-name aux-personal-comment-name)
  (text-print-when . footer)
  (parse . lyskom-parse-personal-comments)
  (text-print . lyskom-print-personal-comments)
  (edit-insert . lyskom-edit-insert-personal-comments)
  (info  . lyskom-aux-item-info))

(def-aux-item request-confirmation 6
  (text-name aux-request-confirmation-name)
  (text-print-when . header)
  (parse . lyskom-parse-request-confirmation)
  (text-print . lyskom-print-request-confirmation)
  (edit-insert . lyskom-edit-insert-request-confirmation)
  (info  . lyskom-aux-item-info)
  (read-action . lyskom-request-confirmation-action))

(def-aux-item read-confirm 7
  (text-name aux-read-confirm-name)
  (text-print-when . header)
  (text-print . lyskom-print-read-confirm)
  (info  . lyskom-aux-item-info))

(def-aux-item redirect 8
  (text-name aux-redirect-name)
  (print . lyskom-print-redirect)
  (info  . lyskom-aux-item-info))

(def-aux-item x-face 9
  (text-name aux-x-face-name)
  (print . lyskom-print-xface)
  (info  . lyskom-aux-item-info))

(def-aux-item alternate-name 10
  (text-name aux-alternate-name-name)
  (text-print-when . header)
  (text-print . lyskom-print-alternate-name)
  (encode-data . lyskom-aux-item-encode-data)
  (parse-data . lyskom-aux-item-decode-data)
  (info  . lyskom-aux-item-info))

(def-aux-item pgp-signature 11
  (text-name aux-pgp-signature-name)
  (info  . lyskom-aux-item-info))

(def-aux-item pgp-public-key 12
  (text-name aux-pgp-public-key-name)
  (info  . lyskom-aux-item-info))

(def-aux-item e-mail-address 13
  (text-name aux-e-mail-address-name)
  (info  . lyskom-aux-item-info))

(def-aux-item faq-text 14
  (text-name aux-faq-text-name)
  (info . lyskom-aux-item-info)
  (text-header-line . (faq-in-text faq-in-text-by))
  (status-print . lyskom-status-print-faq-text))

(def-aux-item creating-software 15
  (text-name aux-creating-software-name)
  (info . lyskom-aux-item-info)
  (text-print-when . header)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (text-print . lyskom-print-creating-software))

(def-aux-item mx-author 16
  (text-name aux-mx-author-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-from 17
  (text-name aux-mx-from-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-reply-to 18
  (text-name aux-mx-reply-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-to 19
  (text-name aux-mx-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-cc 20
  (text-name aux-mx-cc-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-date 21
  (text-name aux-mx-date-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-message-id 22
  (text-name aux-mx-message-id-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-in-reply-to 23
  (text-name aux-mx-in-reply-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-misc 24
  (text-name aux-mx-misc-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-allow-filter 25
  (text-name aux-mx-allow-filter-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-reject-forward 26
  (text-name aux-mx-reject-forward-name)
  (info . lyskom-aux-item-info))

(def-aux-item notify-comments 27
  (text-name aux-notify-comments-name)
  (info . lyskom-aux-item-info))

(def-aux-item faq-for-conf 28
  (text-name aux-faq-for-conf-name)
  (text-print . lyskom-print-faq-for-conf)
  (text-print-when . header)
  (info . lyskom-aux-item-info)
  (read-action . lyskom-faq-for-conf-action))


(def-aux-item recommended-conf 29
  (text-name aux-recommended-conf-name)
  (status-print . lyskom-print-recommended-conf)
  (info . lyskom-aux-item-info))

(def-aux-item allowed-content-type 30
  (text-name aux-allowed-content-type-name)
  (info . lyskom-aux-item-info))

(def-aux-item canonical-name 31
  (text-name aux-canonical-name-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-list-name 32
  (text-name aux-mx-list-name-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-mx-list-name))

(def-aux-item send-comments-to 33
  (text-name aux-send-comments-to-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-send-comments-to))

(def-aux-item world-readable 34
  (text-name aux-world-readable-name)
  (info . lyskom-aux-item-info)
  (text-print . lyskom-print-world-readable)
  (parse . lyskom-parse-world-readable)
  (edit-insert . lyskom-edit-insert-world-readable)
  (text-print-when . header))

(def-aux-item mx-refuse-import 35
  (text-name aux-mx-refuse-import)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-mx-refuse-import))

(def-aux-item elisp-client-read-faq 10000
  (text-name aux-elisp-client-read-faq-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-elisp-client-read-faq))

(def-aux-item elisp-client-rejected-invitation 10001
  (text-name aux-elisp-client-rejected-invitation-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-elisp-client-rejected-invitation))


;;; ================================================================



(defun lyskom-aux-item-decode-data (item)
  (set-aux-item->data 
   item
   (lyskom-decode-coding-string (aux-item->data item) lyskom-server-coding-system)))

(defun lyskom-aux-item-encode-data (item)
  (lyskom-encode-coding-string (aux-item->data item) lyskom-server-coding-system)
  )


(defun lyskom-aux-item-info (item header)
  (let ((def (lyskom-find-aux-item-definition item)))
    
    (concat 
     (lyskom-get-string 'aux-item-for)
     header
     "\n"
     (lyskom-format
      'aux-item-info
      (aux-item->aux-no item)
      (aux-item->tag item)
      (if def
          (lyskom-aux-item-definition->name def)
        "unknown")
      (aux-item->creator item)
      (lyskom-format-time 'date-and-time (aux-item->sent-at item))
      (if (aux-item-flags->deleted (aux-item->flags item))
          (format "(%s)" (lyskom-get-string 'deleted))
        "")
      (mapconcat 'identity
                 (delq nil
                       (list
                        (and (aux-item-flags->secret (aux-item->flags item))
                             (lyskom-get-string 'secret))
                        (and (aux-item-flags->anonymous (aux-item->flags item))
                             (lyskom-get-string 'hide-creator))
                        (and (aux-item-flags->inherit (aux-item->flags item))
                             (lyskom-get-string 'inherit))))
                 ", ")
      (cond ((not (aux-item-flags->inherit (aux-item->flags item)))
             (lyskom-get-string 'no-inheritance))
            ((zerop (aux-item->inherit-limit item))
             (lyskom-get-string 'unlimited-inherit))
            ((eq 1  (aux-item->inherit-limit item))
             (lyskom-get-string 'no-more-inherit))
            (t (lyskom-format 'inherit-steps
                              (1- (aux-item->inherit-limit item)))))
      (aux-item->data item)))))

                 

(defun lyskom-print-content-type (item &optional obj)
  (concat (lyskom-format 'content-type-aux (aux-item->data item))
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-parse-content-type ()
  (and (looking-at (lyskom-get-string 'content-type-regexp))
       (match-string 1)))

(defun lyskom-parse-cross-reference ()
  (or (and (looking-at (lyskom-get-string 'cross-reference-text-regexp))
           (concat "T" (match-string 1)))
      (and (looking-at (lyskom-get-string 'cross-reference-conf-regexp))
           (concat "C" (match-string 1)))
      (and (looking-at (lyskom-get-string 'cross-reference-pers-regexp))
           (concat "P" (match-string 1)))))

(defun lyskom-edit-insert-cross-reference (item pers)
  (concat
   (lyskom-print-cross-reference item nil pers)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-print-cross-reference (item &optional obj pers)
  (let ((pers (if (and (zerop (aux-item->creator item))
                       pers)
                  pers
                (aux-item->creator item))))

    ;; We use string-to-int here since we handle floats in 
    ;; lyskom-format.

    (concat
     (cond ((string-match "^P\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-pers-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           ((string-match "^C\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-conf-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           ((string-match "^T\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-text-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           (t (lyskom-format 'strange-cross-reference 
                             (aux-item->data item)
                             pers
                             )))
     (lyskom-aux-item-terminating-button item obj)
     )))

(defun lyskom-status-print-cross-reference (item &optional obj pers)
  ;; We use string-to-int here since we handle floats in 
  ;; lyskom-format.
  (lyskom-insert 
   (concat
    (cond ((string-match "^P\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-pers-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          (aux-item->creator pers)
                          ))
          ((string-match "^C\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-conf-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          pers
                          ))
          ((string-match "^T\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-text-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          (aux-item->creator pers)
                          ))
          (t (lyskom-format 'strange-cross-reference-status 
                            (aux-item->data item)
                            (aux-item->creator pers)
                            )))
    (lyskom-aux-item-terminating-button item obj)
    "\n")))  

(defun lyskom-parse-no-comments ()
  (and (looking-at (lyskom-get-string 'no-comments-regexp))
       ""))

(defun lyskom-print-no-comments (item &optional obj)
  (concat (lyskom-format 'no-comments-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-no-comments (item &optional obj)
  (concat
   (lyskom-format 'no-comments-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-parse-personal-comments ()
  (and (looking-at (lyskom-get-string 'personal-comment-regexp))
       ""))

(defun lyskom-print-personal-comments (item &optional obj)
  (concat (lyskom-format 'personal-comment-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-personal-comments (item &optional obj)
  (concat
   (lyskom-format 'personal-comment-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-parse-request-confirmation ()
  (and (looking-at (lyskom-get-string 'request-confirmation-regexp))
       ""))

(defun lyskom-print-request-confirmation (item &optional obj)
  (concat (lyskom-format 'request-confirmation-aux
                         (aux-item->creator item))
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-request-confirmation (item &optional obj)
  (concat
   (lyskom-format 'request-confirmation-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-faq-for-conf-action (text-stat)
  (let ((faqs (text-stat-find-aux text-stat 28)))
    (lyskom-traverse aux faqs
      (condition-case nil
          (lyskom-register-read-faq (lyskom-string-to-int
                                     (aux-item->data aux) t)
                                    (text-stat->text-no text-stat))
       (lyskom-integer-conversion-error nil)))))

(defun lyskom-request-confirmation-action (text-stat)
  (let ((confirmations (text-stat-find-aux text-stat 7))
        (have-confirmation nil))
    (while confirmations
      (when (eq lyskom-pers-no (aux-item->creator (car confirmations)))
        (setq have-confirmation t)
        (setq confirmations nil))
      (setq confirmations (cdr confirmations)))
    (when  (not have-confirmation)
      (lyskom-scroll)
      (when (lyskom-j-or-n-p
             (lyskom-format (lyskom-get-string 'confirm-read-q)
                            text-stat))
        (let ((item (lyskom-create-aux-item 0 7 lyskom-pers-no
                                            nil 
                                            (lyskom-create-aux-item-flags
                                             nil nil nil nil nil nil nil nil)
                                            0 "")))
          (initiate-modify-text-info 'background
                                     nil
                                     (text-stat->text-no text-stat)
                                     nil
                                     (list item))
          (cache-del-text-stat (text-stat->text-no text-stat)))))))

(defun lyskom-print-read-confirm (item &optional obj)
  (concat 
   (lyskom-format 'read-confirm-aux
                  (aux-item->creator item)
                  (lyskom-format-time 'date-and-time (aux-item->sent-at item)))
   (lyskom-aux-item-terminating-button item obj)))



(defun lyskom-print-redirect (item &optional obj)
  ;; We use string-to-int here since we handle floats in 
  ;; lyskom-format.
  (concat
   (cond ((string-match "^E-mail:\\(.*\\)$" (aux-item->data item))
          (lyskom-format 'redirect-email-aux 
                         (match-string 1 (aux-item->data item))))
         ((string-match "^LysKOM:\\(.*\\)$" (aux-item->data item))
          (lyskom-format 'redirect-lyskom-aux 
                         (string-to-int 
                          (match-string 1 (aux-item->data item))))))
   (lyskom-aux-item-terminating-button item obj)))   


(defun lyskom-print-xface (item &optional obj)
  (lyskom-xemacs-or-gnu
   (lyskom-maybe-add-face-to-string item
                                    (make-string 0 ?X))
   nil))

(defun lyskom-maybe-add-face-to-string (item string)
  (lyskom-xemacs-or-gnu
   (if (null item)
       string
     (setq item (car item))
     (unless (lyskom-find-face 'kom-xface)
       (make-face 'kom-xface))
     (let* ((h (concat "X-Face: " (aux-item->data item)))
            (g (intern h lyskom-xface-cache))
            (e (make-extent 0 (length string) string)))
       (if (boundp g)
           (setq g (symbol-value g))
         (set g (make-glyph
                 (list
                  (list 'global (cons '(tty) [nothing]))
                  (list 'global (cons '(win) 
                                      (vector 'xface ':data h))))))
         (setq g (symbol-value g))
         (set-glyph-face g 'kom-xface))
       (set-extent-begin-glyph e g)
       (set-extent-property e 'end-open nil)
       (set-extent-property e 'start-open nil)
       (set-extent-property e 'duplicable t)
       string))
   string))


(defun lyskom-print-alternate-name (item &optional obj)
  (concat "[" (aux-item->data item) "] "
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-faq-format-subject (text text-stat text-no)
  (if (and text text-stat)
      (concat "\""
	      (cond ((string-match "\n" (text->decoded-text-mass text text-stat))
		     (substring (text->decoded-text-mass text text-stat) 0 (match-beginning 0)))
		    (t ""))
	      "\"")
    (lyskom-format 'no-such-text-m text-no)))

(defun lyskom-deferred-print-faq (text-stat defer-info)
  (if text-stat
      (initiate-get-text 
       'deferred 
       (lambda (text text-stat defer-info)
         (lyskom-replace-deferred defer-info 
                                  (lyskom-format "%#1r" 
                                                 (lyskom-print-faq-format-subject text
                                                                                  text-stat
                                                                                  (defer-info->data defer-info)))))
       (text-stat->text-no text-stat)
       text-stat
       defer-info)
    (lyskom-replace-deferred defer-info
                             (lyskom-print-faq-format-subject nil nil (defer-info->data defer-info)))))

(defun lyskom-status-print-faq-text (item &optional obj)
  (if (lyskom-aux-item-validate (aux-item->data item) 'lyskom-string-to-int)
      (let* ((text-no (string-to-int (aux-item->data item)))
             (subject (if kom-deferred-printing
                          (lyskom-create-defer-info 'get-text-stat
                                                    text-no
                                                    'lyskom-deferred-print-faq
                                                    nil nil nil
                                                    text-no)
                        (blocking-do-multiple ((text (get-text text-no))
                                               (text-stat (get-text-stat text-no)))
                          (lyskom-print-faq-format-subject text text-stat text-no)))))
        (lyskom-format-insert 'faq-in-text-aux 
                              text-no
                              subject)
        (lyskom-insert (lyskom-aux-item-terminating-button item obj)))
    (lyskom-format-insert 'bad-faq-in-text-aux
                          (aux-item->data item)
                          `(face ,kom-warning-face)
                          (lyskom-aux-item-terminating-button item obj)))
  (lyskom-insert "\n"))

(defun lyskom-print-faq-for-conf (item &optional obj)
  (if (lyskom-aux-item-validate (aux-item->data item) 'lyskom-string-to-int)
      (let ((conf-no (string-to-int (aux-item->data item))))
        (concat 
         (cond ((zerop conf-no) (lyskom-get-string 'faq-for-server-aux))
               (t (lyskom-format 'faq-for-conf-aux conf-no)))
         (lyskom-aux-item-terminating-button item obj)))
    (lyskom-format 'bad-faq-for-conf-aux 
                   (aux-item->data item)
                   `(face ,kom-warning-face)
                   (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-creating-software (item &optional obj)
  (when (or kom-show-creating-software
            (lyskom-viewing-noconversion))
    (concat
     (lyskom-format 'creating-software-aux (aux-item->data item))
     (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-send-comments-to (item &optional obj)
  (if (lyskom-aux-item-validate (aux-item->data item) 'lyskom-string-to-int)
      (let ((conf-no (string-to-int (aux-item->data item))))
        (lyskom-format-insert 'status-send-comments-to
                              conf-no 
                              (lyskom-aux-item-terminating-button item obj)))
    (lyskom-format-insert 'bad-status-send-comments-to
                          (aux-item->data item)
                          `(face ,kom-warning-face)
                          (lyskom-aux-item-terminating-button item obj))))



(defun lyskom-parse-world-readable ()
  (and (looking-at (regexp-quote 
                    (lyskom-get-string 'world-readable-text-edit-aux)))
       ""))

(defun lyskom-edit-insert-world-readable (item &optional obj)
  (concat
   (lyskom-format 'world-readable-text-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-print-world-readable (item &optional obj)
  (concat (lyskom-format 'world-readable-text-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-mx-list-name (item &optional obj)
  (lyskom-format-insert 'conf-mx-list-name 
                        (aux-item->data item)
                        (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-mx-refuse-import (item &optional obj)
  (let* ((sym (intern (format "mx-refuse-import-%s" (aux-item->data item))))
         (s (or (lyskom-try-get-string sym 'lyskom-message)
                (format "'%s'" (aux-item->data item)))))
    (lyskom-format-insert 'conf-mx-refuse-import s
                          (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-recommended-conf (item &optional obj)
  (if (lyskom-aux-item-validate (aux-item->data item) 'lyskom-string-to-int)
      (let ((conf-no (string-to-int (aux-item->data item))))
        (lyskom-format-insert 'recommended-conf-aux
                              conf-no
                              (lyskom-aux-item-terminating-button item obj)))
    (lyskom-format-insert 'bad-recommended-conf-aux
                          (aux-item->data item)
                          `(face ,kom-warning-face)
                          (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-elisp-client-read-faq (item &optional obj)
  (when (lyskom-extended-status-information 'read-faq)
    (when (string-match "^\\([0-9]+\\) \\([0-9]+\\)" (aux-item->data item))
      (condition-case nil
          (let ((conf-no (lyskom-string-to-int (match-string 1 (aux-item->data item)) t))
                (text-no (lyskom-string-to-int (match-string 2 (aux-item->data item)) t)))
            (lyskom-format-insert 'status-read-faq-aux-item 
                                  conf-no 
                                  text-no
                                  (lyskom-aux-item-terminating-button item obj)))
        (lyskom-integer-conversion-error
         (lyskom-format-insert 'bad-status-read-faq-aux-item
                               (aux-item->data item)
                               `(face ,kom-warning-face)
                               (lyskom-aux-item-terminating-button item obj)))))))

(defun lyskom-print-elisp-client-rejected-invitation (item &optional obj)
  (if (lyskom-aux-item-validate (aux-item->data item) 'lyskom-string-to-int)
      (let ((conf-no (string-to-int (aux-item->data item))))
        (lyskom-format-insert 'status-rejected-recommendation-aux-item
                              conf-no 
                              (lyskom-aux-item-terminating-button item obj)))
    (lyskom-format-insert 'bad-status-rejected-recommendation-aux-item
                          (aux-item->data item)
                          `(face ,kom-warning-face)
                          (lyskom-aux-item-terminating-button item obj))))

(provide 'lyskom-aux-items)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: mime.el,v 44.11 2004/11/11 07:14:59 _cvs_pont_lyskomelisp Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: mime.el
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: mime.el,v 44.11 2004/11/11 07:14:59 _cvs_pont_lyskomelisp Exp $\n"))

(defvar lyskom-charset-alist
  '(((ascii)						. us-ascii)
    ((ascii latin-iso8859-1)				. iso-8859-1)
    ((ascii latin-iso8859-2)				. iso-8859-2)
    ((ascii latin-iso8859-3)				. iso-8859-3)
    ((ascii latin-iso8859-4)				. iso-8859-4)
    ((ascii cyrillic-iso8859-5)				. iso-8859-5)
;;; ((ascii cyrillic-iso8859-5)				. koi8-r)
    ((ascii arabic-iso8859-6)				. iso-8859-6)
    ((ascii greek-iso8859-7)				. iso-8859-7)
    ((ascii hebrew-iso8859-8)				. iso-8859-8)
    ((ascii latin-iso8859-9)				. iso-8859-9)
    ((ascii latin-iso8859-15)				. iso-8859-15)
    ((ascii latin-jisx0201
	    japanese-jisx0208-1978 japanese-jisx0208)	. iso-2022-jp)
    ((ascii latin-jisx0201
	    katakana-jisx0201 japanese-jisx0208)	. shift_jis)
    ((ascii korean-ksc5601)				. euc-kr)
    ((ascii chinese-gb2312)				. gb2312)
    ((ascii chinese-big5-1 chinese-big5-2)		. big5)
    ((ascii latin-iso8859-1 greek-iso8859-7
	    latin-jisx0201 japanese-jisx0208-1978
	    chinese-gb2312 japanese-jisx0208
	    korean-ksc5601 japanese-jisx0212)		. iso-2022-jp-2)
    ;; ((ascii latin-iso8859-1 greek-iso8859-7
    ;;         latin-jisx0201 japanese-jisx0208-1978
    ;;         chinese-gb2312 japanese-jisx0208
    ;;         korean-ksc5601 japanese-jisx0212
    ;;         chinese-cns11643-1 chinese-cns11643-2)      . iso-2022-int-1)


;;    ,(if (or (not (fboundp 'charsetp)) ;; non-Mule case
;;	     (charsetp 'unicode-a)
;;	     (not (mm-coding-system-p 'mule-utf-8)))
;;	 '(utf-8 unicode-a unicode-b unicode-c unicode-d unicode-e)
;;       ;; If we have utf-8 we're in Mule 5+.
;;       (append '(utf-8)
;;	       (delete 'ascii
;;		       (lyskom-coding-system-get 'mule-utf-8 'safe-charsets))))

    ))


(defun lyskom-mime-string-charset (data)
  (let* ((cs (lyskom-find-charset-string data))
         (tmp lyskom-charset-alist)
         (best-guess (let ((system nil))
                       (while (and tmp cs)
                         (if (lyskom-subset-p cs (car (car tmp)))
                             (setq system (cdr (car tmp)) tmp nil)
                           (setq tmp (cdr tmp))))
                       system)))
    (or
     best-guess
     (lyskom-xemacs-or-gnu
      lyskom-server-coding-system
      (let ((coding (lyskom-find-coding-systems-for-charsets cs)))
        (while (and (car coding)
                    (null (or (lyskom-coding-system-get (car coding) 'mime-charset)
                              (lyskom-coding-system-get (car coding) :mime-charset))))
          (setq coding (cdr coding)))
        (and (car coding)
             (or (lyskom-coding-system-get (car coding) 'mime-charset)
                 (lyskom-coding-system-get (car coding) :mime-charset)))))
    lyskom-server-coding-system)))

(defun lyskom-mime-charset-coding-system (charset)
  (condition-case nil
      (and (lyskom-check-coding-system charset)
           charset)
    (error 'raw-text)))

(defun lyskom-mime-encode-string (data)
  (let* ((mime-charset (lyskom-mime-string-charset data))
         (coding-system (lyskom-mime-charset-coding-system mime-charset)))
    (when (and mime-charset coding-system)
      (cons mime-charset (lyskom-encode-coding-string data coding-system)))))

(defun lyskom-mime-decode-string (data charset)
  (let* ((coding-system (lyskom-mime-charset-coding-system charset)))
    (if coding-system
        (lyskom-decode-coding-string data coding-system)
      data)))

(defun lyskom-mime-decode-content-type (data)
  (let ((content-type nil)
        (params nil)
        (start 0))

  (when (string-match "^[^;]*" data)
    (setq content-type (match-string 0 data))
    (setq start (match-end 0)))

  (while (string-match ";\\s *\\([^=;]*\\)\\(=\\([^;]*\\)\\)" data start)
    (let ((param-name (intern (match-string 1 data)))
          (param-value (match-string 3 data)))
      (when (and (memq param-name '(charset format))
                 param-value)
        (setq param-value (intern param-value)))

      (setq params (cons (cons param-name (or param-value t)) params)))
    (setq start (match-end 0)))

  (cons content-type params)))


(provide 'lyskom-mime)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: prefetch.el,v 44.32 2004/07/15 17:13:03 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: prefetch.el
;;;;
;;;; The (new) prefetch system.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: prefetch.el,v 44.32 2004/07/15 17:13:03 byers Exp $\n"))

(def-kom-var lyskom-prefetch-queue nil
  "A queue where all prefetch requests are entered."
  local)

(defvar lyskom-inhibit-prefetch nil
  "When non-nil, disables the prefetch.")

(def-kom-var lyskom-pending-prefetch 0
  "Variable counting the number of unfinished prefetch requests."
  local)

(defun lyskom-setup-prefetch ()
  "Set up the prefetch system"
  (setq lyskom-prefetch-queue (lyskom-queue-create))
  (setq lyskom-pending-prefetch 0)
  (setq lyskom-membership-is-read 0))

(defun lyskom-reset-prefetch ()
  "Reset the prefetch system"
  (lyskom-setup-prefetch))

(defsubst lyskom-membership-is-read ()
  "Return t if the while membership list has been fetched, and nil otherwise."
  (eq lyskom-membership-is-read 't))


(defun lyskom-fetch-start-of-map (conf-stat membership)
  "Block fetching map for MEMBERSHIP until we see a text.
Start the prefetch for the remainder of the map."
  (let* ((first-local (1+ (membership->last-text-read membership)))
         (map (blocking-do 'local-to-global
                           (membership->conf-no membership)
                           first-local
                           lyskom-fetch-map-nos)))
    (when map
      (lyskom-enter-map-in-to-do-list map conf-stat membership)
      (when (text-mapping->later-texts-exist map)
        (lyskom-prefetch-map-using-conf-stat conf-stat
                                             (text-mapping->range-end map)
                                             membership)))))

(defun lyskom-prefetch-conf (conf-no)
  "Prefetch the conf-stat for the conference with number CONF-NO."
  (lyskom-queue-enter lyskom-prefetch-queue 
                      `(initiate-get-conf-stat prefetch
                                               lyskom-prefetch-handler 
                                               ,conf-no))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-pers (pers-no)
  "Prefetch the pers-stat for person with number PERS-NO."
  (lyskom-queue-enter lyskom-prefetch-queue
                      `(initiate-get-pers-stat prefetch
                                               lyskom-prefetch-handler
                                               ,pers-no))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-text (text-no)
  "Prefetch the text-stat for the text with number TEXT-NO."
  (lyskom-queue-enter lyskom-prefetch-queue
                      `(initiate-get-text-stat prefetch
                                               lyskom-prefetch-handler
                                               ,text-no))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-textmass (text-no)
  "Prefetch the text mass for the text with number TEXT-NO."
  (lyskom-queue-enter lyskom-prefetch-queue
                      `(initiate-get-text prefetch
                                          lyskom-prefetch-handler
                                          ,text-no))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-textauth (text-no)
  "Prefetch the text stat and the author of text number TEXT-NO."
  (lyskom-queue-enter lyskom-prefetch-queue
                      `(initiate-get-text-stat prefetch
                                               lyskom-prefetch-textauth-handler
                                               ,text-no))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-text-all (text-no)
  "Prefetch all info about the text with number TEXT-NO."
  (lyskom-queue-enter lyskom-prefetch-queue
                      `(initiate-get-text-stat prefetch
                                               lyskom-prefetch-text-all-handler
                                               ,text-no))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-text-stat-all (text-stat)
  "Prefetch all info about the text with text stat TEXT-STAT."
  (lyskom-prefetch-text-all-handler text-stat))

(defun lyskom-prefetch-texttree (text-no &optional only-new)
  "Prefetch all info about the text with number TEXT-NO and descends recursively.

If ONLY-NEW is non-nil and the text-stat in question is already
prefetched the prefetch is not done."
  (unless (and only-new (cache-get-text-stat text-no))
    (lyskom-queue-enter lyskom-prefetch-queue
                        `(initiate-get-text-stat prefetch
                                                 lyskom-prefetch-texttree-handler
                                                 ,text-no)))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-membership (pers-no)
  "Prefetch memberships for PERS-NO."
  (lyskom-queue-enter lyskom-prefetch-queue 
                      (list (lambda (pers-no)
                              (if (numberp lyskom-membership-is-read)
                                  (initiate-get-part-of-membership
                                   'prefetch 'lyskom-prefetch-membership-handler
                                   pers-no lyskom-membership-is-read
                                   lyskom-fetch-membership-length
                                   pers-no)
                                (lyskom-prefetch-handler)))
                            pers-no))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-one-membership (conf-no pers-no)
  "Prefetch the membership in CONF-NO for PERS-NO."
  (lyskom-queue-enter lyskom-prefetch-queue 
                      `(initiate-query-read-texts prefetch
                                                  lyskom-prefetch-read-texts-handler
                                                  ,pers-no
                                                  ,conf-no
                                                  t
                                                  ,lyskom-max-int
                                                  ,conf-no))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-map (conf-no membership)
  "Prefetches a map for conf CONF-NO."
  (lyskom-prefetch-map-from conf-no
                            (1+ (membership->last-text-read membership))
                            membership))

(defun lyskom-prefetch-map-from (conf-no first-local membership)
  "Prefetches a map for conf CONFNO starting att FIRST-LOCAL."
  (lyskom-queue-enter lyskom-prefetch-queue
                      `(initiate-get-conf-stat prefetch
                                               lyskom-prefetch-confstatformap-handler
                                               ,conf-no
                                               ,first-local
                                               ,membership))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-map-using-conf-stat (conf-stat first-local membership)
  "Prefetches a map for conf CONFSTAT starting att FIRST-LOCAL."
  (lyskom-queue-enter lyskom-prefetch-queue
                      `(initiate-local-to-global prefetch
                                                 lyskom-prefetch-map-handler
                                                 ,(conf-stat->conf-no conf-stat)
                                                 ,first-local
                                                 ,lyskom-fetch-map-nos
                                                 ,conf-stat
                                                 ,first-local
                                                 ,membership))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-texts (texts)
  "Prefetches a list of texts."
  (when texts
    (lyskom-queue-enter lyskom-prefetch-queue
                        `(initiate-get-text-stat prefetch
                                                 lyskom-prefetch-texts-handler
                                                 ,(car texts)
                                                 ,(cdr texts))))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-cancel-prefetch-map (conf-no &optional queue))


;;; ================================================================
;;; Internal prefetch functions

(defun lyskom-stop-prefetch ()
  "Stop the prefetch process temporarily."
  )

(defun lyskom-start-prefetch ()
  "Start the whole prefetch process"
  (lyskom-continue-prefetch))

(defun lyskom-continue-prefetch ()
  "Called after each prefetch is finished and also when the whole prefetch
process is started. Used to keep prefetch going."
  (unless lyskom-inhibit-prefetch
    (let ((lyskom-inhibit-prefetch t))
      (while (and (< lyskom-pending-prefetch lyskom-prefetch-limit)
                  (lyskom-prefetch-one-item)
                  (++ lyskom-pending-prefetch))))))

(defun lyskom-prefetch-one-item ()
  "Get the first element of the prefetch data structure and fetch it.
Return t if an element was prefetched, otherwise return nil."
  (let ((item (lyskom-queue-delete-first lyskom-prefetch-queue)))
    (cond ((null item) nil)
          ((functionp (car item)) (apply (car item) (cdr item)) t)
          (t (signal 'lyskom-internal-error
                     (list "unknown prefetch key" (car item)))))))



;;; ================================================================
;;; Handlers
;;;

(defun lyskom-prefetch-textauth-handler (text-stat)
  "Prefetch the conf-stat of the author of the text TEXT-STAT."
  (-- lyskom-pending-prefetch)
  (lyskom-stop-prefetch)
  (when text-stat
    (lyskom-prefetch-conf (text-stat->author text-stat)))
  (lyskom-start-prefetch))

(defun lyskom-prefetch-text-all-handler (text-stat)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT."
  (-- lyskom-pending-prefetch)
  (lyskom-stop-prefetch)
  (lyskom-prefetch-conf (text-stat->author text-stat))
  (lyskom-prefetch-textmass (text-stat->text-no text-stat))
  (lyskom-traverse misc (text-stat->misc-info-list text-stat)
   (let ((type (misc-info->type misc)))
     (cond
      ((memq type lyskom-recpt-types-list)
       (lyskom-prefetch-conf (misc-info->recipient-no misc)))
      ((eq type 'COMM-IN)
       (lyskom-prefetch-textauth (misc-info->comm-in misc)))
      ((eq type 'FOOTN-IN)
       (lyskom-prefetch-textauth (misc-info->footn-in misc)))
      ((eq type 'COMM-TO)
       (lyskom-prefetch-textauth (misc-info->comm-to misc)))
      ((eq type 'FOOTN-TO)
       (lyskom-prefetch-textauth (misc-info->footn-to misc)))
      (t nil))))
  (lyskom-start-prefetch))



(defun lyskom-prefetch-texttree-handler (text-stat)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT.
Then prefetch all info (texttree) of comments."
  (-- lyskom-pending-prefetch)
  (when text-stat
    (lyskom-stop-prefetch)
    (lyskom-prefetch-conf (text-stat->author text-stat))
    (lyskom-prefetch-textmass (text-stat->text-no text-stat))
    (lyskom-traverse misc (text-stat->misc-info-list text-stat)
     (let ((type (misc-info->type misc)))
       (cond
	((memq type lyskom-recpt-types-list)
	 (lyskom-prefetch-conf (misc-info->recipient-no misc)))
	((eq type 'COMM-IN)
	 (lyskom-prefetch-texttree (misc-info->comm-in misc) t))
	((eq type 'FOOTN-IN)
	 (lyskom-prefetch-texttree (misc-info->footn-in misc) t))
	((eq type 'COMM-TO)
	 (lyskom-prefetch-textauth (misc-info->comm-to misc)))
	((eq type 'FOOTN-TO)
	 (lyskom-prefetch-textauth (misc-info->footn-to misc)))
	(t nil)))))
  (lyskom-start-prefetch))


(defun lyskom-prefetch-read-texts-handler (membership pers-no)
  (-- lyskom-pending-prefetch)
  (lyskom-stop-prefetch)
  (when membership
    (let ((old-mship (lyskom-try-get-membership
                      (membership->conf-no membership) t)))
      (if old-mship
          (set-membership->read-texts old-mship
                                      (membership->read-texts membership))
        (lyskom-add-memberships-to-membership (list membership)))
      (when (and (lyskom-visible-membership membership)
                 (lyskom-prefetch-map (membership->conf-no membership)
                                      membership))))
    (lyskom-start-prefetch)))


(defun lyskom-prefetch-membership-handler (memberships pers-no)
  "Handle the return of the membership prefetch call."
  (-- lyskom-pending-prefetch)
  (lyskom-stop-prefetch)
  (lyskom-add-memberships-to-membership memberships)
  (if (and (numberp lyskom-membership-is-read)
           (< (length memberships) lyskom-fetch-membership-length))
        (setq lyskom-membership-is-read t)
    (setq lyskom-membership-is-read (+ lyskom-membership-is-read
                                       lyskom-fetch-membership-length))
    (lyskom-prefetch-membership pers-no))
  (lyskom-start-prefetch))


(defun lyskom-prefetch-confstatformap-handler (conf-stat first-local membership)
  "Now that we have the conf-stat we can fetch the map."
  (-- lyskom-pending-prefetch)
  (lyskom-stop-prefetch)
  (lyskom-prefetch-map-using-conf-stat conf-stat first-local membership)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-map-handler (map conf-stat first-local membership)
  "Handle the return of the membership prefetch call.
Maps are `cached' in lyskom-to-do-list."
  (-- lyskom-pending-prefetch)
  (lyskom-stop-prefetch)
  (let ((next-start (and map (text-mapping->range-end map))))
    (when map
      (when (text-mapping->later-texts-exist map)
	(lyskom-prefetch-map-using-conf-stat conf-stat
                                             next-start
                                             membership))
      (lyskom-enter-map-in-to-do-list map conf-stat membership)))
  (lyskom-start-prefetch)
  (lyskom-update-prompt)
  (lyskom-set-mode-line))


(defun lyskom-prefetch-texts-handler (text-stat texts queue)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT."
  (-- lyskom-pending-prefetch)
  (lyskom-stop-prefetch)
  (lyskom-prefetch-conf (text-stat->author text-stat))
  (lyskom-prefetch-textmass (text-stat->text-no text-stat))
  (lyskom-traverse misc (text-stat->misc-info-list text-stat)
    (let ((type (misc-info->type misc)))
      (cond ((memq type lyskom-recpt-types-list)
             (lyskom-prefetch-conf (misc-info->recipient-no misc)))
            ((eq type 'COMM-IN)
             (lyskom-prefetch-textauth (misc-info->comm-in misc)))
            ((eq type 'FOOTN-IN)
             (lyskom-prefetch-textauth (misc-info->footn-in misc)))
            ((eq type 'COMM-TO)
             (lyskom-prefetch-textauth (misc-info->comm-to misc)))
            ((eq type 'FOOTN-TO)
             (lyskom-prefetch-textauth (misc-info->footn-to misc)))
            (t nil))))
  (lyskom-prefetch-texts texts)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-handler (&rest data)
  "Handler called after each simple prefetch request is done."
  (-- lyskom-pending-prefetch)
  (lyskom-continue-prefetch))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: startup.el,v 44.111 2005/01/09 01:16:02 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: startup.el
;;;;
;;;; This file contains functions that are called only when lyskom
;;;; is loaded, started or when a new user is logged in during a 
;;;; session.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: startup.el,v 44.111 2005/01/09 01:16:02 byers Exp $\n"))


;;; ================================================================
;;;                         Start kom.


(defvar lyskom-www-proxy-connect-phase 1
  "Phase when reading connection response from www-proxy:
1: (initial phase) waiting for the
   string \"HTTP/1.0 2000 Connection established\"
2: we have seen the connection string. After this, it may come lines stating
   proxy-agents and other things. They all seem to end with an empty line,
   so in this phase we wait for an empty line.")


(eval-and-compile
  (defun lyskom-compilation-in-progress ()
    "Returns non-nil if the client currently is being compiled, else nil."

    ;; This horrid code is inspired from how cl-compiling-file in the
    ;; cl package works.
    (let ((outbuffersym (lyskom-xemacs-or-gnu 'byte-compile-outbuffer
                                              'outbuffer)))
      (and (boundp outbuffersym)
           (bufferp (symbol-value outbuffersym))
           (equal (buffer-name (symbol-value outbuffersym))
                  " *Compiler Output*")))))


(defconst lyskom-is-running-compiled
  (eval-when-compile (lyskom-compilation-in-progress))
  "Non-nil if the client is running compiled, else nil.")


;;;###autoload
(defun lyskom (&optional host username password session-priority invisiblep)
  "Start a LysKOM session.
Optional arguments: HOST, USERNAME, PASSWORD and INVISIBLEP.

A numeric prefix argument sets the session priority. A prefix argument
of `C-u', on the other hand, logs in the session without notifying other
clients of the event. See lyskom-mode for details on lyskom."
  (interactive (list (lyskom-read-server-name
		      (lyskom-format 'server-q
				     (or (getenv "KOMSERVER")
					 lyskom-default-server
					 kom-default-server)))
		     nil
		     nil
		     (if current-prefix-arg
			 (prefix-numeric-value current-prefix-arg)
		       nil)
		     (and current-prefix-arg (listp current-prefix-arg))))

  (run-hooks 'lyskom-init-hook)
  (setq username
	(or username 
	    lyskom-default-user-name
	    kom-default-user-name
	    (getenv "KOMNAME")))
  (setq password
	(or password
	    (when (and lyskom-default-password ; Got default password?
		       (or (not lyskom-server-name) ; For this host?
			   (string= lyskom-server-name
				    host)))
	      lyskom-default-password)
	    kom-default-password
	    (getenv "KOMPASSWORD")))
  (if (zerop (length host))
      (let* ((env-kom (getenv "KOMSERVER"))
	     (canon (or (lyskom-string-rassoc env-kom kom-server-aliases)
                        (lyskom-string-rassoc env-kom kom-builtin-server-aliases))))
	(setq host (or (car canon)
		       env-kom
		       lyskom-default-server
		       kom-default-server))))
  (let ((port 4894)
	(init-done nil))
    (cond				;Allow "nanny:4892" to use port 4892.
     ((string-match ":" host)
      (setq port (string-to-int (substring host (match-end 0))))
      (cond
       ((zerop (match-beginning 0))
	(setq host (or lyskom-default-server kom-default-server)))
       (t
	(setq host (substring host 0 (match-beginning 0)))))))

    (let* ((duplicate-buffers
            (delq nil
                  (mapcar (lambda (buffer)
                            (and (lyskom-buffer-p buffer t)
                                 (buffer-name buffer)
                                 (string-match (regexp-quote host)
                                               (buffer-name buffer))
                                 (save-excursion (set-buffer buffer)
                                                 (and 
                                                  (boundp 'lyskom-server-port)
                                                  (eq port lyskom-server-port)))
                                 buffer))
                          (buffer-list))))
	   (name nil)
	   (proc nil)
           (buffer (car duplicate-buffers))
	   ;; (alive (lyskom-buffer-p buffer))
           (reused-buffer nil))
      

      ;;<<<<<<< startup.el
      ;;      (if (and buffer
      ;;	       alive
      ;;=======
      (if (and (lyskom-buffer-p buffer nil)
	       (not (prog1
			(j-or-n-p (lyskom-get-string
				   'start-new-session-same-server))
		      (message ""))))
	  (progn 
            (switch-to-buffer buffer)
            (setq reused-buffer t))
	(unwind-protect
	    (progn
	      (cond ((and buffer (not (lyskom-buffer-p buffer)))
		     (set-buffer buffer)
                     (setq reused-buffer t)
		     (goto-char (point-max))
                     (lyskom-insert
                      (format (lyskom-get-string 'new-session-in-buffer)
                              (lyskom-format-time
                               'timeformat-day-yyyy-mm-dd-hh-mm-ss)))
                     (setq name (buffer-name buffer)))
		    (t
		     (setq buffer (lyskom-generate-new-buffer host))
		     (setq name (buffer-name buffer))))
              (let* ((www-proxy-host-string
                      (cond ((stringp kom-www-proxy) kom-www-proxy)
                            ((listp kom-www-proxy)
                             (or (cdr (lyskom-string-assoc host kom-www-proxy))
                                 (cdr (assq t kom-www-proxy))
                                 nil))
                            (t nil)))
                     (www-proxy-host nil)
                     (www-proxy-port nil)
                     (match (string-match "\\(.*\\):\\([0-9]+\\)"
                                          (or www-proxy-host-string "")))
                     (headers nil))
                (setq www-proxy-host (or (and match
                                          (match-string 1 www-proxy-host-string))
                                     www-proxy-host-string)
                      www-proxy-port (or (and match
                                          (string-to-int
                                           (match-string 2
                                                         www-proxy-host-string)))
                                     80))
                (cond (www-proxy-host
                       (setq headers 
                             (cond ((stringp kom-www-proxy-headers)
                                    (list kom-www-proxy-headers))
                                   ((and (listp kom-www-proxy-headers)
                                         (stringp (car kom-www-proxy-headers)))
                                    kom-www-proxy-headers)
                                   ((and (listp kom-www-proxy-headers)
                                         (consp (car kom-www-proxy-headers)))
                                    (cdr (or (lyskom-string-assoc www-proxy-host
                                                                  kom-www-proxy-headers)
                                             (assq t kom-www-proxy-headers))))))
                       (setq proc (lyskom-open-network-stream name buffer
                                                              www-proxy-host
                                                              www-proxy-port))
                       ;; We do explicit coding
                       (lyskom-set-process-coding-system proc 'no-conversion 'no-conversion)

		       ;; Install our filter.
		       ;; Do this before we send the CONNECT command to
		       ;; the proxy, in case the proxy answers fast.
		       (setq lyskom-www-proxy-connect-phase 1)
		       (set-process-filter proc
					   'lyskom-www-proxy-connect-filter)
		       (lyskom-set-process-query-on-exit-flag proc nil)

                       (lyskom-process-send-string 
                        proc
                        (format "CONNECT %s:%d HTTP/1.0\r\n"
                                host port))

                       (mapcar (lambda (header)
                                 (lyskom-process-send-string proc header)
                                 (lyskom-process-send-string proc "\r\n"))
                               headers)
                       (lyskom-process-send-string proc "\r\n")


		       ;; Now wait for the answer from the proxy
		       ;;
		       ;; This is because anything we send before the
		       ;; connection ack will be thrown away by the proxy
		       ;; so it is bad to try to start talking with the
		       ;; server before the connection is up.
		       (while (eq 'lyskom-www-proxy-connect-filter
				  (process-filter proc))
			 (accept-process-output proc))
		       ;; Now the proxy has connected to the kom server
		       )
                      (t (setq proc (lyskom-open-network-stream name buffer
                                                                host port))
                         ;; We do explicit coding
                         (lyskom-set-process-coding-system proc 'no-conversion 'no-conversion))))
	      (switch-to-buffer buffer)
	      (lyskom-mode)		;Clearing lyskom-default...
	      (setq lyskom-buffer buffer)
	      (setq lyskom-default-user-name username)
	      (setq lyskom-default-password password)
	      (setq lyskom-server-name host)
	      (setq lyskom-server-port port)
	      (setq lyskom-proc proc)
	      (lyskom-setup-faces-for-buffer)
              (lyskom-check-configuration)
	      (lyskom-insert
	       (lyskom-format 'try-connect lyskom-clientversion host))
	      (set-process-filter proc 'lyskom-connect-filter)
              (lyskom-set-process-query-on-exit-flag proc nil)
	      (lyskom-process-send-string
	       proc
	       (concat "A"
		       (lyskom-format-objects
			(concat (user-login-name)
				"%" (system-name)))
                       "\n"))
	      (while (eq 'lyskom-connect-filter (process-filter proc))
		(accept-process-output proc))
	      ;; Now we have got the correct response.
	      (set-process-sentinel proc 'lyskom-sentinel)

	      (save-excursion
		(lyskom-init-parse buffer))

              ;; Set up timestamps and stuff
              (lyskom-set-connection-time-format t)

              ;; Async messages
              (lyskom-accept-async)

	      ;; +++PREFETCH+++
	      (lyskom-setup-prefetch)

	      ;; Tell the server who we are
	      (initiate-set-client-version 'background nil
					   "lyskom.el" lyskom-clientversion)

              (setq lyskom-server-version-info (blocking-do 'get-version-info))
              (when (or (null lyskom-server-version-info)
                        (<= (version-info->protocol-version 
                             lyskom-server-version-info) 7))
                (lyskom-error 'too-old-server))
	      (lyskom-setup-client-for-server-version)

	      (setq lyskom-server-info (blocking-do 'get-server-info))
	      (lyskom-format-insert 
	       'connection-done
	       (version-info->software-version lyskom-server-version-info))

              (when (lyskom-have-call 85)
                (setq lyskom-collate-table (blocking-do 'get-collate-table))
                (setq lyskom-char-classes nil)
                (lyskom-update-command-completion))
              (if (not (zerop (server-info->motd-of-lyskom
			       lyskom-server-info)))
		  (blocking-do-multiple ((text (get-text 
                                                (server-info->motd-of-lyskom
                                                 lyskom-server-info)))
                                         (text-stat (get-text-stat
                                                     (server-info->motd-of-lyskom
                                                      lyskom-server-info))))
                    (let* ((conf-stat (and text-stat (blocking-do 'get-conf-stat (text-stat->author text-stat))))
                           (str (and text text-stat (text->decoded-text-mass text text-stat))))
                      (if (null text-stat)
                          (lyskom-get-string 'lyskom-motd-was-garbed)
                        (lyskom-insert (lyskom-get-string 'server-has-motd))
                        (when (string-match "\n" str)
                          (setq str (substring str (match-end 0))))
                        (lyskom-format-insert 
                         "%#2$%#1s\n"
                         (if kom-dashed-lines
                             (make-string kom-text-header-dash-length ?-)
                           "")
                         (when kom-highlight-dashed-lines
                           `(face ,(or kom-dashed-lines-face
                                       lyskom-default-dashed-lines-face))))

                        (lyskom-format-insert "%#2$%#1t\n"
                                              str
                                              (when kom-highlight-text-body
                                                `(face ,(or kom-text-body-face
                                                            lyskom-default-text-body-face))))

                        (lyskom-format-insert
                         "%#2$%#1s\n"
                         (lyskom-format-text-footer 
                          text-stat
                          conf-stat
                          (cond ((eq (text-stat->author text-stat) 0)
                                 (lyskom-get-string 'person-is-anonymous))
                                (conf-stat (conf-stat->name conf-stat))
                                (t (lyskom-format 'person-does-not-exist 
                                                  (text-stat->author text-stat))))
                          kom-text-footer-format
                          lyskom-last-text-format-flags)
                         (when kom-highlight-dashed-lines
                           `(face ,(or kom-dashed-lines-face
                                       lyskom-default-dashed-lines-face))))
                        ))))

	      ;; Can't use lyskom-end-of-command here.
	      (setq lyskom-executing-command nil)
	      ;; Log in
	      (kom-start-anew t session-priority invisiblep)
	      (if (memq lyskom-buffer lyskom-buffer-list)
		  (while (not (eq lyskom-buffer (car lyskom-buffer-list)))
		    (setq lyskom-buffer-list
			  (nconc (cdr lyskom-buffer-list)
				 (list (car lyskom-buffer-list)))))
		(setq lyskom-buffer-list
		      (cons lyskom-buffer lyskom-buffer-list)))
              ;; We're done
	      (setq init-done t)
              )
	  ;; Something went wrong. Lets cleanup everything. :->
	  (if init-done
	      nil
	    (if proc (delete-process proc))
	    (unless reused-buffer (kill-buffer buffer))))))))


(defun lyskom-accept-async ()
  (blocking-do 'accept-async '(5 7 8 9 11 12 13 14 15 16 17 18 19 20 21 22))
  (let* ((ans (blocking-do 'query-async)))
    (unless (memq 15 (listify-vector ans))
      ;; async-new-text is not implemented, so use async-new-text-old
      (blocking-do 'accept-async '(0 5 7 8 9 11 12 13 14 16 17 18 19 20 21 22)))))


(defun lyskom-www-proxy-connect-filter (proc output)
  "Receive connection acknowledgement from proxy."
  (if lyskom-debug-communications-to-buffer
      (lyskom-debug-insert proc "-----> " output))
  (cond
   ((and (= lyskom-www-proxy-connect-phase 1)
	 (string-match "^HTTP/1\\.. 200.*\r\n" output))
    (setq lyskom-www-proxy-connect-phase 2)
    ;; safety check: see if the empty line is already in this output
    (lyskom-www-proxy-connect-filter proc output))

   ((and (= lyskom-www-proxy-connect-phase 2)
	 (string-match "^\r\n" output))
    (set-process-filter proc 'lyskom-connect-filter))))

(defun lyskom-open-network-stream (name buffer host service)
  (let ((relay (lyskom-setup-ssh-relay host service buffer)))
    (if relay
        (open-network-stream name
                             buffer
                             "127.0.0.1"
                             (get relay 'relay-port))
    (open-network-stream name
                         buffer
                         host
                         service))))


(defun lyskom-setup-ssh-relay (server port kom-buffer)
  (when kom-ssh-relay-host
    (let* ((procname (format "ssh<%s:%s:%d>" kom-ssh-relay-host server port))
           (bufname (concat " *" procname "*"))
           (proc (get-process procname))
           (procsym (intern procname))
           (relay-port (and proc
                            (eq (process-status proc) 'run)
                            (get procsym 'relay-port)))
           (msg nil))
      (unwind-protect
          (save-excursion
            (set-buffer (get-buffer-create bufname))
            (if relay-port
                (lyskom-message 
                 "%s" 
                 (lyskom-format (setq msg 'using-ssh-connection)
                                kom-ssh-relay-host))
              (when proc (delete-process proc))
              (setq relay-port (+ 10000 (random 20000)))
              (put procsym 'relay-host 
                   (if (string-match "@" kom-ssh-relay-host)
                       (substring kom-ssh-relay-host (1+ (match-beginning 0)))
                     kom-ssh-relay-host))
              (put procsym 'relay-port relay-port)
              (put procsym 'num-connected 0)
              (lyskom-message
               "%s"
               (lyskom-format (setq msg 'opening-ssh-connection)
                              kom-ssh-relay-host))
              (goto-char (point-max))
              (insert "\n--- new connection ---\n")
              (let ((old-lc-all (getenv "LC_ALL")))
                (unwind-protect
                    (progn
                      (setenv "LC_ALL" "C")
                      (setq proc (start-process
                                  procname
                                  bufname
                                  kom-ssh-command "-n" "-x"
                                  "-L" (format "%d:%s:%d" relay-port server port)
                                  kom-ssh-relay-host
                                  "sh -c \"while :; do echo ok; sleep 600; done\"")))
                  (setenv "LC_ALL" old-lc-all)))
              (lyskom-set-process-query-on-exit-flag proc nil))
            (while (progn
                     (goto-char (point-max))
                     (re-search-backward "^--- .* ---$" nil t)
                     (not (re-search-forward "^ok$" nil t)))
              (when (re-search-forward "\\<\\(Enter passphrase.*$\\|^.*password.*$\\)\\|refused\\|disconnect\\|denied\\|error\\|key not found\\>" nil t)
                (cond ((match-string 1)
                       (process-send-string 
                        proc
                        (concat (silent-read (match-string 1)) "\n"))
                       (delete-region (match-beginning 0) 
                                      (match-end 0)))
                      (t (error (lyskom-get-string 'ssh-cant-connect)
                                (buffer-substring-no-properties
                                 (progn (beginning-of-line) (point))
                                 (progn (skip-chars-forward "^\n\r")
                                        (point)))))))
              (sleep-for 0.5))
            (setq proc nil)
            (lyskom-message 
             "%s"
             (lyskom-format (concat 
                             (lyskom-format msg kom-ssh-relay-host)
                             (lyskom-get-string 'done)))))
        (if proc (delete-process proc)))

      (save-excursion 
        (set-buffer kom-buffer)
        (put procsym 'num-connected (1+ (or (get procsym 'num-connected) 0)))
        (make-local-variable 'lyskom-ssh-proxy)
        (setq lyskom-ssh-proxy procsym))
      )))


(defun lyskom-setup-client-for-server-version ()
  "Setup flags according to protocol versions."
  (lyskom-clear-features)
  (let ((protocol-version 
         (version-info->protocol-version lyskom-server-version-info)))

  (when (>= protocol-version 8)
    (lyskom-set-feature long-conf-types t))

  (when (>= protocol-version 9)
    (lyskom-set-feature dynamic-session-info t)
    (lyskom-set-feature idle-time t))

  (when (>= protocol-version 10)
    (lyskom-set-feature bcc-misc t)
    (lyskom-set-feature aux-items t)
    (lyskom-set-feature highest-call 105)
    (lyskom-set-feature local-to-global t))

  (when (>= protocol-version 11)
    (lyskom-set-feature read-ranges t)
    (lyskom-set-feature highest-call 110))
  ))


(defun lyskom-connect-filter (proc output)
  "Receive connection acknowledgement from server."
  (if lyskom-debug-communications-to-buffer
      (lyskom-debug-insert proc "-----> " output))
  (cond
   ((string-match "^LysKOM\n" output)
    (set-process-filter proc 'lyskom-filter))))





;;; ================================================================
;;;                        Start anew


(defun kom-start-anew (&optional lyskom-first-time-around session-priority invisiblep)
  "Start/login as a new person. If INVISIBLEP is not nil, the login will not be
shown to other users."
  (interactive)
  (lyskom-start-of-command 'kom-start-anew)
  (lyskom-completing-clear-cache)
  (let ((new-me nil)
	(login-successful nil)
        (ignored-user-area-vars nil))
    (unwind-protect
        (progn
          (if lyskom-first-time-around
              nil
            (lyskom-tell-internat 'kom-tell-login))
          ;; We can't allow the prefetch to go on after the new user
          ;; is logged in, but to shut down the prefetch would be too
          ;; brutal, since the new login might be cancelled. To
          ;; prevent the blocking-do calls below from allowing
          ;; prefetch we set lyskom-inhibit-prefetch locally.
          (let ((lyskom-inhibit-prefetch t))
            (while (not new-me)

              (if (and lyskom-first-time-around
                       lyskom-default-user-name)
                  ;; This is nil if we can't find a unique match.
                  (setq new-me
			(if (integerp lyskom-default-user-name)
			    lyskom-default-user-name
			(conf-z-info->conf-no
                         (lyskom-lookup-conf-by-name lyskom-default-user-name
                                                     '(pers))))))
              (if new-me
                  nil
                (let ((name nil))
                  (while (or (null name) (string= name ""))
                    (setq name (lyskom-read-conf-name 'what-is-your-name
                                                      '(pers none) nil nil t)))
                  (setq new-me
                        (or (conf-z-info->conf-no 
                             (lyskom-lookup-conf-by-name name '(pers)))
                            (lyskom-create-new-person name)))))
              ;; Now new-me contains a number of a person.
              ;; Lets log him in.
              (if new-me
                  (let ((conf-stat (blocking-do 'get-conf-stat new-me))
                        (lyskom-inhibit-minibuffer-messages t))

                    ;; Previously this code used lyskom-pers-no
                    ;; directly instead of new-me, but that caused
                    ;; problem with asynchrounous code trying to
                    ;; access it.
                    ;;
                    ;; Setting lyskom-pers-no fscks up other things
                    ;; if we do keyboard-quit in the middle, so don't.
                    ;;
                    ;; (setq lyskom-pers-no new-me)

                    ;; DEBUG
                    (if (null conf-stat)
                        (lyskom-insert "You don't exist. Go away.\n"))

                    (lyskom-insert (concat (conf-stat->name conf-stat) "\n"))
                    (setq lyskom-first-time-around nil)
                    (if (blocking-do 'login new-me
                                     (setq lyskom-default-password
					   (if lyskom-default-password
					       lyskom-default-password
					     ;; Use password read when creating
					     ;; the person when loggin in new
					     ;; users
					     (or lyskom-is-new-user
						 (silent-read
						  (lyskom-get-string 'password)))))
					   (if invisiblep 1 0))
                        (progn
                          (if lyskom-is-new-user
                              (blocking-do 'add-member
                                           (server-info->conf-pres-conf lyskom-server-info)
                                           new-me
                                           100 
                                           1
                                           (lyskom-create-membership-type
                                            nil nil nil nil nil nil nil nil)))
			  (setq login-successful t))
                      (lyskom-insert-string 'wrong-password)
		      (setq lyskom-default-password nil)
                      (when (lyskom-get-aux-item 
                             (server-info->aux-item-list lyskom-server-info)
                             13)        ; e-mail
                        (lyskom-insert 'wrong-password-help)
                        (mapcar (lambda (el)
                                  (lyskom-format-insert 'wrong-password-email
                                                        (aux-item->data el)))
                                (lyskom-get-aux-item 
                                 (server-info->aux-item-list lyskom-server-info)
                                 13)    ; e-mail
                                ))
                      (setq new-me nil))
                    (setq lyskom-is-new-user nil))))

            ;; Now we are logged in.
            (setq lyskom-pers-no new-me)
            (setq lyskom-is-administrator nil)
            (lyskom-insert-string 'are-logged-in)

            (unless lyskom-is-running-compiled
              (lyskom-insert-string 'warning-about-uncompiled-client))

            (unless lyskom-dont-read-user-area
              (setq ignored-user-area-vars (lyskom-read-options)))

	    (unless kom-remember-password
		(setq lyskom-default-password nil))

	    ;Update mode-line string if needed (as early as possible).

	    (lyskom-mode-name-from-host) 
	    
            (when (or session-priority kom-default-session-priority)
              (setq lyskom-session-priority
                    (or session-priority kom-default-session-priority)))
            (lyskom-run-hook-with-args 'lyskom-change-conf-hook
                                       lyskom-current-conf
                                       0)
            (lyskom-run-hook-with-args 'kom-change-conf-hook
                                       lyskom-current-conf
                                       0)
            (setq lyskom-current-conf 0)
            (cache-set-marked-texts (blocking-do 'get-marks))
            ;; What is this variable? It is never used. It is ust to
            ;; fill the cache?
            (let ((lyskom-who-am-i (blocking-do 'who-am-i)))
              (if lyskom-who-am-i (setq lyskom-session-no lyskom-who-am-i))))

          ;; If login succeeded, clear the caches and set the language

          (when login-successful
            (clear-all-caches)
            (lyskom-init-membership)
            (when (lyskom-set-language (lyskom-default-language) 'local)
              (unless lyskom-have-one-login
                (lyskom-set-language (lyskom-default-language) 'global)
                (setq-default lyskom-language lyskom-language)
                (setq-default kom-default-language (list lyskom-language)))
              (lyskom-format-insert-before-prompt
               'language-set-to
               (lyskom-language-name (lyskom-default-language))
               "Help on changing languages" 
                `(face underline
                       mouse-face highlight
                       lyskom-button t
                       lyskom-button-text ""
                       lyskom-button-type func
                       lyskom-buffer ,(current-buffer)
                       lyskom-button-arg 
                       (kom-help ("Changing Languages" . language-help))))

              )
            (setq lyskom-have-one-login t))

          (when ignored-user-area-vars
            (lyskom-format-insert-before-prompt
             'ignored-user-area-var
             (mapconcat (lambda (x) (symbol-name (car x)))
                        ignored-user-area-vars
                        "\n    ")
             (lyskom-string= lyskom-clientversion lyskom-settings-version)
             lyskom-settings-version
             lyskom-clientversion
             72)
            (setq lyskom-saved-unknown-variables ignored-user-area-vars))

          ;; Show motd and encourage writing a presentation

          (let ((conf-stat (blocking-do 'get-conf-stat lyskom-pers-no)))
            (if (and conf-stat
                     (/= (conf-stat->msg-of-day conf-stat) 0))
                (progn
                  (lyskom-insert-string 'you-have-motd)
                  (lyskom-view-text (conf-stat->msg-of-day conf-stat))))
            (lyskom-nag-about-presentation t))

          (setq lyskom-is-new-user nil)

          ;; Start the prefetch and update some basic caches
          (lyskom-refetch))
      (lyskom-end-of-command)))

  ;; Run the hook kom-login-hook. We don't want to hang the
  ;; login, just because something crashed here.

  (condition-case err
      (progn
        (run-hooks 'lyskom-login-hook)
        (run-hooks 'kom-login-hook))
    (error (lyskom-format-insert-before-prompt
            'error-in-login-hook (format "%s" err)))))


(defun lyskom-refetch ()
  "Resets and fetches all reading info.
This is called at login and after prioritize and set-unread."

  ;; The whole membership!

  (lyskom-init-membership)
  (setq lyskom-to-do-list (lyskom-create-read-list))
  (setq lyskom-reading-list (lyskom-create-read-list))


  (lyskom-reset-prefetch)
  (let ((lyskom-inhibit-prefetch t))
    (let ((unreads (blocking-do 'get-unread-confs lyskom-pers-no)))
      (lyskom-traverse conf-no (conf-no-list->conf-nos unreads)
        (lyskom-prefetch-one-membership conf-no lyskom-pers-no)))
    (lyskom-prefetch-membership lyskom-pers-no))
  (lyskom-start-prefetch)

  (condition-case nil
      (progn (lyskom-update-read-faqs)
             (lyskom-clean-read-faqs lyskom-pers-no)
             (lyskom-update-rejected-recommendations)
             (lyskom-startup-check-faqs)
             (lyskom-startup-check-recommended-memberships))
    (error nil)
    (quit nil)))

(defun lyskom-create-new-person (name)
  "A new user named NAME (or an old that mis-spelled his name)."
  (lyskom-insert
   (lyskom-format 'first-greeting name))
  (lyskom-scroll)
  (cond
   ((ja-or-nej-p (lyskom-format 'is-name-correct name))
    (let ((password (silent-read (lyskom-get-string 'personal-password))))
      (cond
       ((not (equal password 
		    (silent-read (lyskom-get-string 'repeat-password))))
	;; Failed to enter the same password twice
	(lyskom-insert-string 'repeat-failure)
	nil)
       (t
	;; Entered the same password twice
	(let ((new-person (blocking-do 'create-person name
                                       password
                                       (lyskom-create-flags nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil)
                                       nil)))
	  (if (null new-person)
	      (lyskom-insert-string 'could-not-create-you)
	    ;; Raise a flag so the user will be added to the
	    ;; presentation conference after login
	    (setq lyskom-is-new-user password))
	  new-person)))))
   (t
    ;; Do not create a new person
    nil)))


(defun lyskom-read-server-name (prompt)
  "Read the name of a LysKOM server.
Copmpletion is done on the servers i kom-server-aliases and
kom-builtin-server-aliases. If an alias name is entered, the
corresponding address is returned."
  ;; Create a completion table like
  ;; (("kom.lysator.liu.se" . "kom.lysator.liu.se")
  ;;  ("LysKOM" . "kom.lysator.liu.se"))
  (let ((known-servers
	 (append (mapcar (function (lambda (pair)
				     (cons (car pair) (car pair))))
			 (append kom-server-aliases kom-builtin-server-aliases))
		 (mapcar (function (lambda (pair)
				     (cons (cdr pair) (car pair))))
			 (append kom-server-aliases kom-builtin-server-aliases))))
	(completion-ignore-case t)
	server)
    (setq server (lyskom-completing-read prompt
                                         (lyskom-maybe-frob-completion-table
                                          known-servers)
                                         nil nil))
    (or (cdr (lyskom-string-assoc server known-servers))
	server)))
      

;;; ================================================================
;;;                        The LysKOM mode.

;; The LysKOM mode should not be inherited if we create a new buffer
;; and default-major-mode is nil.
(put 'lyskom-mode 'mode-class 'special)

(defun lyskom-mode ()
  "\\<lyskom-mode-map>Mode for LysKOM client.
Commands:
\\[kom-next-command]	Do the default action. This can be to read the next text,select
	next conference with unread texts or whatever the prompt says.
\\[kom-go-to-conf]	Go to a conference. LysKOM will ask you for a conference
	and make you a member of it if you are not already.
\\[kom-list-conferences]	List conferences matching a given string.
\\[kom-list-persons]	List persons matching a given string.

\\[kom-list-news]	List the conferences you have unread texts in.
\\[kom-go-to-next-conf]	Go to the next conference with unread texts.

\\[kom-membership]	Display a buffer with the list of conferences you are member in.

\\[kom-quit]	Leave this LysKOM session.
\\[kom-who-is-on]	Show a list of all the users of lyskom right now.

\\[kom-extended-command]	Read a command using the minibuffer and execute it.
	This is another way to give commands.

\\[kom-write-text]	Start writing a new text.
\\[kom-write-comment]	Start writing a comment to the last read article.
\\[kom-private-answer]	Start writing a personal answer to the author of the last
	read article.
\\[kom-send-letter]	Start writing a letter to a person or conference.

\\[kom-page-next-command]	Clear the page and do what \\[kom-next-command] does.
\\[kom-line-next-command]	Do what \\[kom-next-command] does, but scroll at most 1 line.

0 .. 9	Give a numeric argument to the next command.
\\[describe-mode]	Display this help text.

\\[kom-busy-wait]	Put the lyskom-session in wait mode. The next created text with 
	a priority higher than that of the next conference you are going
	to will be read directly when it is created.
\\[kom-set-unread]	Mark a number of texts as unread.
\\[kom-jump]	Skip (mark as read) all the comments to this article recursively.
\\[kom-display-time]	Show the current date and time.

\\[kom-change-presentation]	Change your presentation.
\\[kom-view]	View the specified text.
\\[kom-view-commented-text]	View the text that the current text comments or is a footnote to.
\\[kom-review-presentation]	Show the presentation for a person or a conferencce.

\\[kom-review-comments]	View all comments to the current text.
\\[kom-review-tree]	View all comments to the current text and step through the tree
	in depth-first order.

\\[kom-find-root-review]	View the complete comment tree.
\\[kom-find-root]	Show the root text of this comment tree.
\\[kom-review-by-to]	View the last (first or all) article written by named author
	in a named conference.

\\[kom-mark-text]	Create a mark on a text.
\\[kom-unmark-text]	Remove the mark on a text.
\\[kom-review-marked-texts]	View all text marked with a certain mark.
\\[kom-review-all-marked-texts]	View all marked text.

\\[kom-view-next-new-text]	Read the next text from the list of unread.
\\[kom-review-next]	Continue the viewing.
\\[kom-review-stack]	Show the stack of things we are viewing.
\\[kom-review-clear]	Clear the stack of things we are viewing.
\\[kom-review-backward]	Toggles the read order of reviewed texts. This can only be done
	when viewing texts with \\[kom-review-by-to], \\[kom-review-marked-texts] and \\[kom-review-all-marked-texts].

\\[kom-status-conf]	Show the status of a conference.
\\[kom-status-person]	Show the status of a person
\\[kom-save-text]	Save the text you are looking at to a file.

\\[kom-get-abuse]	Get an insulting text.
\\[kom-get-appreciation]	Get an encouraging text.

\\[kom-add-self]	Become a member of a conference.
\\[kom-sub-self]	Removes you as a member of a conference.

All bindings (this is here due to the fact that inconsistensies while 
developping this package are frequent):
\\{lyskom-mode-map}
Entry to this mode runs lyskom-mode-hook.

Functions and variables beginning with kom- are intended for the user to see,
set or call.
Functions and variables beginning with lyskom- are not intended for the user
to see, set of call."
  (interactive)
  (lyskom-clear-vars)
  (lyskom-mode-name-from-host)
  (setq mode-line-buffer-identification
	; Must start with a string to be handled properly, it seems.
	(list "" 'mode-line-server-name  ": " 'mode-line-conf-name))

  (setq major-mode 'lyskom-mode)
  (setq mode-name "LysKOM")
  (setq mode-line-process (lyskom-get-string 'mode-line-working))
  (use-local-map lyskom-mode-map)
  (lyskom-set-menus 'lyskom-mode lyskom-mode-map)
  (run-hooks 'lyskom-mode-hook)

  (buffer-disable-undo (current-buffer))
  (setq buffer-read-only t))

(defun lyskom-clear-vars ()
  "Set up buffer-local vars."
  (lyskom-save-variables (lyskom-proc
                          lyskom-pers-no
                          lyskom-last-viewed
                          lyskom-unparsed-buffer
                          lyskom-unparsed-marker
                          lyskom-server-info
                          lyskom-server-name)
      (kill-all-local-variables))
    (lyskom-setup-local-variables)
    (setq lyskom-do-when-done (cons kom-do-when-done kom-do-when-done))
    (setq lyskom-output-queues (make-vector 10 nil))
    (setq lyskom-collate-table lyskom-default-collate-table)
    (setq lyskom-char-classes nil)
    (let ((i 0))
      (while (< i 10)
        (aset lyskom-output-queues i (lyskom-queue-create))
        (setq i (1+ i))))
    (setq lyskom-pending-calls nil)
    (lyskom-set-mode-line
     (lyskom-get-string 'not-present-anywhere)))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: reading.el,v 44.22 2004/07/21 11:14:39 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: reading.el
;;;;
;;;; This file contains functions that manage membership and reading
;;;; lists, namely lyskom-membersip lyskom-reading-list and
;;;; lyskom-to-do-list. These are called both from prefetch and from
;;;; startup procedures.
;;;; 

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: reading.el,v 44.22 2004/07/21 11:14:39 byers Exp $\n"))


(defun lyskom-enter-map-in-to-do-list (map conf-stat membership)
  "Takes a MAP and enters all its listed text-nos in the conference CONF-STAT.
This works by modifying the lyskom-to-do-list which in some cases
also means modifying the lyskom-reading-list. The zero text-nos are skipped."
  (let ((list (lyskom-list-unread map membership))
        (mship (lyskom-try-get-membership (conf-stat->conf-no conf-stat))))
    (when (and list mship)
      (read-list-enter-read-info
       (lyskom-create-read-info 
	'CONF conf-stat
	(membership->priority 
	 (lyskom-try-get-membership (conf-stat->conf-no conf-stat)))
	(lyskom-create-text-list
	 list))
       lyskom-to-do-list))))


(defun lyskom-sort-to-do-list ()
  "Sort lyskom-to-do-list in order of membership priorities. 
The priorities for CONF elements are updated to match the membership
priorities. Elements that are not of type CONF appear first on the list
within their priority. This may not be totally accurate, but it's a
reasonable guess."
  (let ((todo (read-list->all-entries lyskom-to-do-list))
        (info nil))

    ;; Update the priorities in the read list

    (while todo
      (setq info (car todo))
      (setq todo (cdr todo))
      (when (eq (read-info->type info) 'CONF)
        (let ((mship 
               (lyskom-get-membership 
                (conf-stat->conf-no (read-info->conf-stat info)) t)))
          (when mship
            (set-read-info->priority info
                                     (membership->priority mship))))))

    ;; Sort the todo list

    (setq lyskom-to-do-list (cons 'READ-LIST
                                  (sort (read-list->all-entries lyskom-to-do-list)
                                        'lyskom-read-info-<)))
    (lyskom-update-prompt)))

(defun lyskom-read-info-< (a b)
  (cond ((< (read-info->priority a) (read-info->priority b)) nil)
        ((> (read-info->priority a) (read-info->priority b)) t)

        ;; Both are confs of equal priority; check position in mship
        ((and (eq (read-info->type a) 'CONF) 
              (eq (read-info->type b) 'CONF))
         (< (lyskom-membership-position 
             (conf-stat->conf-no (read-info->conf-stat a)))
            (lyskom-membership-position 
             (conf-stat->conf-no (read-info->conf-stat b)))))

        ;; A is a CONF and B is not; B is greater.
        ((eq (read-info->type a) 'CONF) nil)

        ;; Both are not CONF, so A is not less than B
        (t t)))



;;; ================================================================
;;; Fundamental membership cache functions

(def-komtype mship-list-node (prev next data))
(def-komtype membership-list ((head :automatic nil)
                              (tail :automatic nil)
                              (size :automatic 0)))
;;; (def-komtype smship (id priority position))


;;; ----------------------------------------------------------------
;;; INSERTION FUNCTIONS
;;;
;;; There are three functions for inserting memberships into a list.
;;;
;;; Use lyskom-membership-list-insert when inserting memberships in
;;; random order. It uses a heuristic based on the priority of the
;;; membership to determine whether to search from the front of back
;;; of the list.
;;;
;;; Use lyskom-membership-list-append when you know that the position
;;; of the membership is towards the end of the list.
;;;
;;; Use lyskom-membership-list-prepend when you know that the position
;;; of the membership is towards the front of the list.
;;;
;;;
;;; The heuristic is optimized for randomly inserting memberships. If
;;; the list is near-full and a single membership is to be inserted,
;;; other heuristics might perform better. If the approximate position
;;; of the membership is already known, this heuristic is not the best.
;;;

(defun lyskom-membership-list-compare-next (mship next &optional after)
  (and next
       (or (> (membership->priority (mship-list-node->data next))
              (membership->priority mship))
           (and (= (membership->priority (mship-list-node->data next))
                   (membership->priority mship))
                (membership->position mship)
                (if after
                    (>= (membership->position mship)
                        (membership->position (mship-list-node->data next)))
                  (> (membership->position mship)
                     (membership->position (mship-list-node->data next))))))))

(defun lyskom-membership-list-compare-prev (mship prev)
  (and prev
       (or (< (membership->priority (mship-list-node->data prev))
              (membership->priority mship))
           (and (= (membership->priority (mship-list-node->data prev))
                   (membership->priority mship))
                (membership->position mship)
                (<= (membership->position mship)
                    (membership->position (mship-list-node->data prev)))))))  


(defun lyskom-membership-list-insert (mship-list mship &optional simulate)
  "Insert a new membership MSHP into MSHIP-LIST."
  (if (and (membership-list->head mship-list)
           (membership-list->tail mship-list)
           (< (- (membership->priority mship)
                 (membership->priority (mship-list-node->data (membership-list->head mship-list))))
              (- (membership->priority (mship-list-node->data (membership-list->tail mship-list)))
                 (membership->priority mship))))
      (lyskom-membership-list-append mship-list mship simulate)
    (lyskom-membership-list-prepend mship-list mship simulate)))


(defun lyskom-membership-list-insert-position (mship prev next)
  "Return position MSHIP should have if inserted between PREV and NEXT.
Internal function for lyskom-membership-list-insert."

  ;; If it already has a position that is between the positions of cur and prev
  ;; then we do not alter that position. If it has some other position or no
  ;; position, set its position to the position of cur (which is appropriate
  ;; when adding a new membership). We do this even if there is room between
  ;; prev and cur since such a hole probably indicates that we haven't gotten
  ;; the entire membership from the server -- once we have all memberships there
  ;; shouldn't be any holes left.
  
  (if (or (null (membership->position mship))
          (<= (membership->position mship)
              (if prev (membership->position (mship-list-node->data prev)) -1))
          (>= (membership->position mship)
              (if next (membership->position (mship-list-node->data next)) 
                lyskom-max-int)))
      (cond (next (membership->position (mship-list-node->data next)))
            (prev (1+ (membership->position (mship-list-node->data prev))))
            (t 0))
    (membership->position mship)))

(defun lyskom-membership-list-prepend (mship-list mship &optional simulate)
  "Insert new membership MSHIP into MSHIP-LIST."
  (let ((cur (membership-list->head mship-list))
        (prev nil))

    ;; Search for the element in the list at which we want to insert
    ;; the new membership.

    (while (lyskom-membership-list-compare-next mship cur)
      (setq prev cur cur (mship-list-node->next cur)))


    (if simulate
        (lyskom-membership-list-insert-position mship prev cur)

      (let ((new (lyskom-create-mship-list-node prev cur mship)))
        (set-membership->position 
         mship (lyskom-membership-list-insert-position mship prev cur))

        ;; If cur is nil, then we want to insert at the end of the list
        ;; If prev is nil, then we want to insert at the beginning of the list
        ;; If both are nil, the list is empty and we are inserting the first element

        (if prev
            (set-mship-list-node->next prev new)
          (set-membership-list->head mship-list new))
        (if cur
            (set-mship-list-node->prev cur new)
          (set-membership-list->tail mship-list new))

        (setq prev new)

        ;; If the position we chose for the new element collides with the position of
        ;; the element following it, we adjust the positions of following elements
        ;; until all elements again have unique positions.

        (while (and cur (eq (membership->position (mship-list-node->data prev))
                            (membership->position (mship-list-node->data cur))))
          (set-membership->position (mship-list-node->data cur)
                                    (1+ (membership->position (mship-list-node->data cur))))
          (setq prev cur cur (mship-list-node->next cur)))

        (set-membership-list->size mship-list (1+ (membership-list->size mship-list)))
        new))))


(defun lyskom-membership-list-append (mship-list mship &optional simulate)
  "Like lyskom-insert-membership, but searches from the end of the list"
  (let ((cur (membership-list->tail mship-list))
        (prev nil))

    (while (lyskom-membership-list-compare-prev mship cur)
      (setq prev cur cur (mship-list-node->prev cur)))

    (if simulate


      (if (or (null (membership->position mship))
              (<= (membership->position mship)
                  (if cur (membership->position (mship-list-node->data cur)) -1))
              (>= (membership->position mship)
                  (if prev (membership->position (mship-list-node->data prev)) lyskom-max-int)))
          (set-membership->position mship
                                (cond (prev (membership->position (mship-list-node->data prev)))
                                      (cur (1+ (membership->position (mship-list-node->data cur))))
                                      (t 0))))

    (if simulate
        (lyskom-membership-list-insert-position mship prev cur)

      (let ((new (lyskom-create-mship-list-node cur prev mship)))
        (set-membership->position 
         mship (lyskom-membership-list-insert-position mship cur prev))

        ;; If cur is nil, then we want to insert at the end of the list
        ;; If prev is nil, then we want to insert at the beginning of the list
        ;; If both are nil, the list is empty and we are inserting the first element

        (if cur
            (set-mship-list-node->next cur new)
          (set-membership-list->head mship-list new))
        (if prev
            (set-mship-list-node->prev prev new)
          (set-membership-list->tail mship-list new))

        ;; Set up for scanning back to the end of the list to adjust positions
        ;; of elements that are after the newly inserted element.

        (setq prev new cur (mship-list-node->next new))

        ;; If the position we chose for the new element collides with the position of
        ;; the element following it, we adjust the positions of following elements
        ;; until all elements again have unique positions.

        (while (and cur (eq (membership->position (mship-list-node->data prev))
                            (membership->position (mship-list-node->data cur))))
          (set-membership->position (mship-list-node->data cur)
                                    (1+ (membership->position (mship-list-node->data cur))))
          (setq prev cur cur (mship-list-node->next cur)))

        (set-membership-list->size mship-list (1+ (membership-list->size mship-list)))
        new)))))


(defun lyskom-membership-list-delete (mship-list node)
  "Remove NODE from MSHIP-LIST"
  (if (mship-list-node->next node)
      (set-mship-list-node->prev (mship-list-node->next node)
                                 (mship-list-node->prev node))
    (set-membership-list->tail mship-list
                               (mship-list-node->prev node)))

  (if (mship-list-node->prev node)
      (set-mship-list-node->next (mship-list-node->prev node)
                                 (mship-list-node->next node))
    (set-membership-list->head mship-list (mship-list-node->next node)))

  (setq node (mship-list-node->next node))
  (while node
    (set-membership->position (mship-list-node->data node)
                              (1- (membership->position (mship-list-node->data node))))
    (setq node (mship-list-node->next node)))

  (set-membership-list->size mship-list (1- (membership-list->size mship-list))))

(defun lyskom-membership-list-move (mship-list node)
  "Move the node NODE in MSHIP-LIST to its new position.
Returns non-nil value if the membership actually moved."
  (let* ((prev (mship-list-node->prev node))
         (next (mship-list-node->next node))
         (mship (mship-list-node->data node))
         (moved nil)
         (new-pos nil))

    (cond
     ((lyskom-membership-list-compare-next mship next t) ; Move right
      (setq prev nil)
      (while (lyskom-membership-list-compare-next mship next t)
        (setq moved t)
        (setq new-pos (membership->position (mship-list-node->data next)))
        (set-membership->position (mship-list-node->data next) (1- new-pos))
        (setq prev next next (mship-list-node->next next)))
      (set-membership->position mship new-pos))

     ((lyskom-membership-list-compare-prev mship prev) ; Move left
      (setq next nil)
      (while (lyskom-membership-list-compare-prev mship prev)
        (setq moved t)
        (setq new-pos (membership->position (mship-list-node->data prev)))
        (set-membership->position (mship-list-node->data prev) (1+ new-pos))
        (setq next prev prev (mship-list-node->prev prev)))
      (set-membership->position mship new-pos))

     (t                                 ; Stay in the same place
      (setq prev (mship-list-node->prev node))
      (setq next (mship-list-node->next node))
      (setq new-pos (membership->position mship))))


    ;; Remove the node from its current position

    (if (mship-list-node->prev node)
        (set-mship-list-node->next (mship-list-node->prev node)
                                   (mship-list-node->next node))
      (set-membership-list->head mship-list (mship-list-node->next node)))
    (if (mship-list-node->next node)
        (set-mship-list-node->prev (mship-list-node->next node)
                                   (mship-list-node->prev node))
      (set-membership-list->tail mship-list (mship-list-node->prev node)))

    ;; Splice it into the list at the new position

    (set-mship-list-node->prev node prev)
    (set-mship-list-node->next node next)

    (if prev 
        (set-mship-list-node->next prev node)
      (set-membership-list->head mship-list node))

    (if next
        (set-mship-list-node->prev next node)
      (set-membership-list->tail mship-list node))
    moved
  ))



;;; ================================================================
;;; The following functions are concerned with managing the cache

(def-kom-var lyskom-mship-cache nil
  "Membership cache. Do not alter directly."
  local)

(defsubst lyskom-mship-cache-index () (aref lyskom-mship-cache 0))
(defsubst lyskom-mship-cache-data  () (aref lyskom-mship-cache 1))

(defun lyskom-mship-cache-create ()
  "Initialize the membership cache to empty."
  (vector (lyskom-make-hash-table :size 300 :test 'eq) 
          (lyskom-create-membership-list)))

(defun lyskom-mship-cache-get (conf-no)
  "Get the membership for CONF-NO from the membership cache."
  (lyskom-gethash conf-no (lyskom-mship-cache-index)))

(defun lyskom-mship-cache-put (mship)
  "Add MSHIP to the membership cache."
  (lyskom-puthash (membership->conf-no mship)
                  (lyskom-membership-list-insert (lyskom-mship-cache-data) mship)
                  (lyskom-mship-cache-index)))

(defun lyskom-mship-cache-append (mship)
  "Add MSHIP to the membership cache."
  (lyskom-puthash (membership->conf-no mship)
                  (lyskom-membership-list-append (lyskom-mship-cache-data) mship)
                  (lyskom-mship-cache-index)))

(defun lyskom-mship-cache-del (conf-no)
  "Delete CONF-NO from the membership cache."
  (let ((node (lyskom-mship-cache-get conf-no)))
    (when node
      (lyskom-membership-list-delete (lyskom-mship-cache-data) node)
      (lyskom-remhash conf-no (lyskom-mship-cache-index)))))

(defun lyskom-add-memberships-to-membership (memberships)
  "Adds newly fetched MEMBERSHIPS to the membership list."
  (lyskom-with-lyskom-buffer
    (lyskom-traverse mship memberships
      (unless (lyskom-mship-cache-get (membership->conf-no mship))
        (lyskom-mship-cache-append mship)))))

(defun lyskom-insert-membership (mship)
  "Add MSHIP into lyskom-membership, sorted by priority."
  (lyskom-with-lyskom-buffer
    (lyskom-mship-cache-put mship)
    (lp--update-buffer (membership->conf-no mship))
    ))


(defun lyskom-replace-membership (mship)
  "Replace the membership MSHIP."
  (lyskom-with-lyskom-buffer
    (let ((node (lyskom-mship-cache-get (membership->conf-no mship))))
      (set-mship-list-node->data node mship)
      (if node
          (when (lyskom-membership-list-move (lyskom-mship-cache-data) node)
            (lyskom-sort-to-do-list))
        (lyskom-mship-cache-put mship)))
    (lp--update-buffer (membership->conf-no mship))))

(defun lyskom-remove-membership (conf-no)
  "Remove the membership for CONF-NO from lyskom-membership."
  (lyskom-with-lyskom-buffer
    (lyskom-mship-cache-del conf-no)
    (lp--update-buffer conf-no)))

(defun lyskom-membership-position (conf-no)
  "Return the position of the membership for CONF-NO."
  (lyskom-with-lyskom-buffer
    (membership->position (lyskom-get-membership conf-no t))))


(defun lyskom-init-membership ()
  "Initialize membership cache and information."
  (setq lyskom-mship-cache
        (lyskom-mship-cache-create)))

(defun lyskom-membership-length ()
  "Return the size of the membership list."
  (membership-list->size (lyskom-mship-cache-data)))

(defun lyskom-get-membership (conf-no &optional want-passive)
  "Return membership for conference CONF-NO.
If optional WANT-PASSIVE is non-nil, also return passive memberships.

If the membership has not been cached, a blocking call is made to the
server to attempt to get it, so this function should not be used from
a callback function."
  (lyskom-with-lyskom-buffer
    (or (lyskom-try-get-membership conf-no want-passive)
        (and (not (lyskom-membership-is-read))
             (let ((mship (blocking-do 'query-read-texts lyskom-pers-no conf-no t 0)))
               (when (and mship (lyskom-visible-membership mship))
                 (lyskom-add-membership mship conf-no))
               (when (or want-passive
                         (not (membership-type->passive (membership->type mship))))
                 mship))))))


(defun lyskom-try-get-membership (conf-no &optional want-passive)
  "Return membership for conference CONF-NO.
If optional WANT-PASSIVE is non-nil, also return passive memberships.

This call does not block. If the membership has not been cached, this
call will return nil." 
  (lyskom-with-lyskom-buffer
    (let ((mship (lyskom-mship-cache-get conf-no)))
      (when (and mship
                 (or want-passive
                     (not (membership-type->passive 
                           (membership->type
                            (mship-list-node->data mship))))))
        (mship-list-node->data mship)))))


(defun lyskom-query-membership-position (priority position)
  "Return the real position of a membership with PRIORITY and POSITION.
The position returned is the position at which the membership would be
placed in the membership cache."
  (let ((mship (lyskom-create-membership position nil nil priority 
                                         nil nil nil nil nil)))
    (lyskom-membership-list-insert (lyskom-mship-cache-data) mship t)))





;;; ================================================================
;;; Testing


;;;(defun lps (l)
;;;  (let ((cur (membership-list->head l))
;;;        res)
;;;    (while cur
;;;      (setq res (cons (cons (smship->id (mship-list-node->data cur))
;;;                            (smship->position (mship-list-node->data cur)))
;;;                      res)
;;;            cur (mship-list-node->next cur)))
;;;    (nreverse res)))
;;;
;;;
;;;
;;;(progn (setq l (lyskom-create-membership-list))
;;;(setq a (lyskom-create-smship 'a 255 0))
;;;(setq b (lyskom-create-smship 'b 100 1))
;;;(setq c (lyskom-create-smship 'c 100 2))
;;;(setq d (lyskom-create-smship 'd 100 3))
;;;(setq e (lyskom-create-smship 'e  50 4))
;;;(setq f (lyskom-create-smship 'f  50 5))
;;;(setq g (lyskom-create-smship 'g  20 6))
;;;(setq h (lyskom-create-smship 'h   1 7)))
;;;
;;;(setq x (lyskom-create-smship 'x 100 nil))
;;;
;;;(mapcar (lambda (el) (lyskom-membership-list-insert l el)) (list c g f b d a x))

;; (let ((mx 0)
;;       (times nil))
;;   (while (<= mx 500)
;; ;    (garbage-collect)
;;     (message "%d" mx)
;;     (let ((enter-time nil)
;;           (exit-time nil)
;;           (l (lyskom-create-membership-list))
;;           (i 0)
;;           (x 0)
;;           (y 0))
;;       (garbage-collect)
;;       (setq mx (+ mx 10))
;;       (setq enter-time (current-time))
;;       (while (< i mx)
;;         (let* ((val (random mx))
;;                (el (lyskom-create-smship i val (- mx val))))
;;           (lyskom-membership-list-insert l el))
;;         (setq i (1+ i)))
;;       (setq exit-time (current-time))
;;       (princ (format "%05d %.8f %.8f %4d %4d\n"
;;                      mx 
;;                      (elp-elapsed-time enter-time exit-time)
;;                      (/ (elp-elapsed-time enter-time exit-time) mx)
;;                      x
;;                      y))
;;       (sit-for 0)
;;       (setq times (cons (cons mx
;;                               (elp-elapsed-time enter-time exit-time)) times))
;; ))
;;   times)


;; (defun lyskom-map-membership-list (fn list)
;;   (let ((cur (membership-list->tail list))
;;         (res nil))
;;     (while cur
;;       (setq res (cons (funcall fn (mship-list-node->data cur)) res)
;;             cur (mship-list-node->prev cur)))
;;     res))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: internal.el,v 44.11 2004/02/12 21:07:52 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: internal.el
;;;;
;;;; Here are internal functions that handles the different kom-queue
;;;; calls. Add a call, apply the handler when a call is done.
;;;;
;;;; Originally written:    ceder
;;;; Completely rewritten:  Inge Wallin
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: internal.el,v 44.11 2004/02/12 21:07:52 byers Exp $\n"))


;;;; ================================================================
;;;;                          Variables.


(defvar lyskom-call-data nil
  "This is an assoc-list of data for the kom-queues.
Each element on the list has the following format:

(NAME . KOM-QUEUE)

NAME    is an atom, the name of the kom-queue.	A kom-queue is a way
        to send questions to the LysKOM server and deal with the replies 
        in a controlled way.

KOM-QUEUE is a kom-queue.")

(make-variable-buffer-local 'lyskom-call-data)


;;; ================================================================
;;;                   Data type kom-queue

;;;
;;; Each kom-queue consists of the following 4 fields:
;;;     PENDING -
;;;         a list where each element represents a call to a service on 
;;;         the server, or a call to lyskom-collect, lyskom-use or 
;;;         lyskom-run. The elements are lists. The first element on each 
;;;         list is a key to what it represents, as described below.
;;;     COLLECT-FLAG - 
;;;          t means this queue is collecting results for a future 
;;;          lyskom-use of lyskom-list-use. The results are collected
;;;          on collect-queue
;;;     COLLECT-QUEUE -
;;;          This is where the results described above are collected.
;;;     HALTED -
;;;          An integer counting the number of times this queue is halted.
;;;          A call to lyskom-halt increments this counter, a call to
;;;          lyskom-resume decrements it.
;;;
;;;
;;; The items on PENDING is one of the following:
;;;
;;; 	('CALL REF-NO PARSER PARSER-DATA HANDLER HANDLER-DATA)
;;; 		A call that has not yet returned.
;;; 
;;; 	('PARSED REF-NO RESULT HANDLER HANDLER-DATA)
;;; 		A call that has returned, but the result can not be
;;; 		handled until all previous calls has returned.
;;; 
;;; 	('COLLECT)
;;; 		Marks the start of a sequence of results that will be
;;; 		handled by a multi-handler or multi-list-handler.
;;; 
;;; 	('COLLECT-IGNORE)
;;; 		Marks the start of a sequence of results that will be 
;;; 		handled by a multi-handler of multi-list-handler with
;;; 		errors stripped away.
;;; 
;;; 	('USE MULTI-HANDLER MULTI-HANDLER-DATA)
;;; 		Marks the end of a sequence. MULTI-HANDLER is called
;;; 		when all calls before this element have been handled.
;;; 		MULTI-HANDLER is a function whose first arguments are
;;; 		the results from calls between previous COLLECT and
;;; 		this USE.  MULTI-HANDLER-DATA is optional.  If it
;;; 		exists it is a list of more arguments to send to
;;; 		MULTI-HANDLER.
;;; 
;;; 	('LIST-USE MULTI-HANDLER MULTI-HANDLER-DATA)
;;; 		Marks the end of a sequence. MULTI-HANDLER is called
;;; 		when all calls before this element have been handled.
;;; 		MULTI-HANDLER is a function whose first argument is a
;;; 		list of all results from calls between previous
;;; 		COLLECT and this LIST-USE. MULTI-HANDLER-DATA is
;;; 		optional. If it exists it is a list of more arguments
;;; 		to send to MULTI-HANDLER.
;;; 
;;; 	('RUN FUNCTION FUNCTION-ARGS)
;;; 		Run FUNCTION when all calls before this have been handled.
;;;
;;;


(defun kom-queue-create ()
  "Creates a new instance of an empty kom-queue."
  (vector (lyskom-queue-create)
	  nil
	  (lyskom-queue-create)
	  0))


(defun kom-queue->pending (queue)
  "Returns the pending field of the kom-queue QUEUE."
  (elt queue 0))


(defun kom-queue->collect-flag (queue)
  "Returns the collect-flag field of the kom-queue QUEUE."
  (elt queue 1))


(defun kom-queue->collect-queue (queue)
  "Returns the collect-queue field of the kom-queue QUEUE."
  (elt queue 2))


(defun set-kom-queue-collect-flag (queue new-val)
  "Set the collect-flag field of the kom-queue QUEUE to NEW-VAL."
  (aset queue 1 new-val))


(defun kom-queue-halt (queue)
  "Halts the kom-queue QUEUE."
  (aset queue 3 (1+ (elt queue 3))))


(defun kom-queue-resume (queue)
  "Resume execution on the kom-queue QUEUE."
  (if (eq (elt queue 3) 0)
      (signal 'lyskom-internal-error
	      (list "kom-queue-resume called on an unhalted queue: "
		    queue))
    (aset queue 3 (1- (elt queue 3)))))


(defun kom-queue-is-halted (queue)
  "Return t if the kom-queue QUEUE is halted at least once."
  (> (elt queue 3) 0))



;;; ================================================================
;;;               Entry points to this communication packet.


(defun lyskom-collect (kom-queue)
  "Collect the results of future calls via KOM-QUEUE.
The results of the calls will be available to the multi-handler.
See lyskom-use and lyskom-list-use."
  (lyskom-call-add kom-queue 'COLLECT))


(defun lyskom-collect-ignore-err (kom-queue)
  "Collect the result of future calls via KOM-QUEUE.
The result of the calls will be available to the multi-handler with the calls
producing errors stripped."
  (lyskom-call-add kom-queue 'COLLECT-IGNORE))


(defun lyskom-use (kom-queue multi-handler &rest multi-handler-data)
  "Use the previously collected results from calls to the server.
Args: KOM-QUEUE MULTI-HANDLER &rest MULTI-HANDLER-DATA

MULTI-HANDLER is a function that is called when all previous results
have been handled. MULTI-HANDLER-DATA is a list of additional
arguments the multi-handler wants.

See also lyskom-list-use."
  (lyskom-call-add kom-queue 'USE multi-handler multi-handler-data)
  (lyskom-check-call kom-queue))


(defun lyskom-list-use (kom-queue multi-handler &rest multi-handler-data)
  "Use the previously collected results from calls to the server.
Args: KOM-QUEUE MULTI-HANDLER &rest MULTI-HANDLER-DATA

MULTI-HANDLER is a function that is called when all previous
results have been handled. The first argument is a list of
the results. MULTI-HANDLER-DATA is a list of additional
arguments the multi-handler wants.

The difference between lyskom-use and lyskom-list-use is the way
the MULTI-HANDLER receives the data. lyskom-list-use sends them as
a list, lyskom-use as different parameters."
  (lyskom-call-add kom-queue 'LIST-USE multi-handler multi-handler-data)
  (lyskom-check-call kom-queue))


(defun lyskom-run (kom-queue function &rest function-args)
  "Call a function when all calls have been handled.
Args: KOM-QUEUE FUNCTION &rest FUNCTION-ARGS
Register a FUNCTION that shall be called with FUNCTION-ARGS when
all previous calls to the server via KOM-QUEUE have been handled."
  (lyskom-call-add kom-queue 'RUN function function-args)
  (lyskom-check-call kom-queue))


(defun lyskom-halt (queue-name)
  "Prohibit execution of handlers on QUEUE-NAME.
The execution will resume when (lyskom-resume KOM-QUEUE) is called."
  (let ((queue-pair (assq queue-name lyskom-call-data)))
    (if (null queue-pair)
	(setq queue-pair (lyskom-add-new-queue queue-name)))
    (kom-queue-halt (cdr queue-pair))))
    

(defun lyskom-resume (kom-queue)
  "Resume execution of waiting handlers on KOM-QUEUE.
See documentation for lyskom-halt."
  (let ((queue (assq kom-queue lyskom-call-data)))
    (cond
     ((null queue)			;A new kom-queue?
      (signal 'lyskom-internal-error
	      (list "lyskom-resume called on an unused queue:"
		    kom-queue)))
     ((kom-queue-is-halted (cdr queue)) ;A halted queue?
      (kom-queue-resume (cdr queue))    ;Resume execution on the queue.
      (lyskom-check-call kom-queue))	;Run any pending handlers.
     (t					;The queue was not halted. This
      (signal 'lyskom-internal-error	;is an error.
	      (list "lyskom-resume:"
		    kom-queue "(not halted)"))))))


(defun lyskom-call (kom-queue ref-no handler handler-data
			       parser &rest parser-data)
  "Add information about a call that has not yet returned to kom-queue.
Arguments: KOM-QUEUE REF-NO HANDLER HANDLER-DATA
	   PARSER &rest PARSER-DATA."
  (lyskom-call-add kom-queue 'CALL ref-no 
		   parser parser-data handler handler-data))

(defun lyskom-fake-call (kom-queue ref-no handler handler-data)
  "Add information about a call that will not return from the server,
but will be filled in by some other function."
  (lyskom-call-add kom-queue 'CALL ref-no
                   nil nil handler handler-data))

(defun lyskom-complete-call (kom-queue ref-no result)
  "Force a call placed on KOM-QUEUE with reference number REF-NO to return 
RESULT. This should only be used to complete calls placed on the queue using
lyskom-fake-call, or the parser might get confused."
  (let ((call-info (lyskom-locate-ref-no kom-queue ref-no)))
    (if call-info
        (progn
          (lyskom-tr-call-to-parsed call-info result)
          (lyskom-check-call kom-queue)))))


(defun lyskom-cancel-calls (ref-nos)
  "Cancel the calls in the list REF-NOS.
Calls that have been sent to the server will have their callbacks
canceled, but as they have been sent, the client must wait for them
to complete in some way."
  (let ((unsent nil))
    (lyskom-traverse queue lyskom-output-queues
      (lyskom-traverse ref-no ref-nos
        (when (assq ref-no (car (cdr queue)))
          (setq unsent (cons ref-no unsent)))))

    ;;    (lyskom-format-insert "REF-NOS\n")
    ;;    (lyskom-format-insert "    %#1s\n" (format "%S" ref-nos))
    ;;    (lyskom-format-insert "UNSENT\n")
    ;;    (lyskom-format-insert "    %#1s\n" (format "%S" unsent))

    (lyskom-traverse queue lyskom-output-queues
      (lyskom-queue-remove-matching queue
                                    (lambda (el) (memq (car el) unsent))))

    (lyskom-traverse queue lyskom-call-data
      (lyskom-queue-remove-matching (kom-queue->pending (cdr queue))
                                    (lambda (el) 
                                      (or (and (eq (car el) 'CALL)
                                               (memq (car (cdr el)) unsent))
                                          (and (eq (car el) 'PARSED)
                                               (memq (car (cdr el)) ref-nos)))))
      (lyskom-traverse call-data (car (cdr (kom-queue->pending (cdr queue))))
        (when (and (eq (car call-data) 'CALL)
                   (memq (car (cdr call-data)) ref-nos))
          ;;          (lyskom-format-insert "Canceling callback %#1d\n" (car (cdr call-data)))
          (setcdr call-data
                  (list (elt (cdr call-data) 0) ; ref-no
                        (elt (cdr call-data) 1) ; parser
                        (elt (cdr call-data) 2) ; parser-data
                        nil             ; handler, then handler-data
                        nil)))))
    (lyskom-check-output-queues)))


;;;; ================================================================
;;;;                     Internal functions.



(defun lyskom-add-new-queue (queue-name)
  "Add QUEUE-NAME to lyskom-call-data as an empty queue.
Return a dotted pair consisting of the QUEUE-NAME and the new queue."
  (let ((new-queue-list (list (cons queue-name (kom-queue-create)))))
    (if (null lyskom-call-data)
	(setq lyskom-call-data new-queue-list)
      (nconc lyskom-call-data new-queue-list))
    (car new-queue-list)))

(defun lyskom-set-queue-priority (queue-name priority)
  (put queue-name 'lyskom-queue-priority priority))

(defun lyskom-queue-priority (queue-name)
  (or (get queue-name 'lyskom-queue-priority)
      0))

(defun lyskom-call-add (queue-name type &rest data)
  "Add an entry to the kom-queue QUEUE-NAME. The entry is of type TYPE
and third argument DATA contains the rest of the necessary data."
  (let ((queue (assoc queue-name lyskom-call-data)))
    (if (null queue)
	(setq queue (lyskom-add-new-queue queue-name)))
    (lyskom-queue-enter (kom-queue->pending (cdr queue))
			(cons type data))))


(defun lyskom-send-packet (kom-queue string)
  "Send a packet to the server.
Add info on lyskom-pending-calls. Update lyskom-ref-no.
Args: KOM-QUEUE STRING."

  ;; Queue it
  (lyskom-queue-enter (aref lyskom-output-queues
			    (lyskom-queue-priority kom-queue))
		      (cons lyskom-ref-no string))
  (setq lyskom-pending-calls
	(cons (cons lyskom-ref-no kom-queue)
	      lyskom-pending-calls))
  (setq lyskom-ref-no (1+ lyskom-ref-no))
  (when (< lyskom-ref-no 0) (setq lyskom-ref-no 1))

  ;; Send something from the output queues
  (lyskom-check-output-queues))

(defun lyskom-check-output-queues ()
  "Check for pending calls to the server.
Send calls from queues with higher priority first, and make sure that at
most lyskom-max-pending-calls are sent to the server at the same time."
  (catch 'done
    (let ((i 9))
      (while (and lyskom-ok-to-send-new-calls
		  (< lyskom-number-of-pending-calls
		     lyskom-max-pending-calls))
	(while (lyskom-queue-isempty (aref lyskom-output-queues i))
	  (-- i)
	  (if (< i 0) (throw 'done nil)))
	(let ((entry (lyskom-queue-delete-first
		      (aref lyskom-output-queues i))))
	  (++ lyskom-number-of-pending-calls)
	  (lyskom-process-send-string
	   lyskom-proc
	   (concat (number-to-string (car entry)) (cdr entry) "\n")))))))

(defun lyskom-decrease-pending-calls ()
  "A reply has come.
Send a pending call or decrease lyskom-number-of-pending-calls."
  (-- lyskom-number-of-pending-calls)
  (if (< lyskom-number-of-pending-calls 0)
      (setq lyskom-number-of-pending-calls 0))
  (lyskom-check-output-queues))
	

(defun lyskom-process-send-string (process string)
  "Send PROCESS the contents of STRING.
STRING is split in several parts if the operating system can't deal
with big strings."
  (let ((tries 0))
  (while
      (condition-case err
	  (progn (lyskom-process-send-string-2 process string)
		 nil)
	(file-error
	 (if lyskom-debug-communications-to-buffer
	     (lyskom-debug-insert process "Error: " (format "%s" err))
;;;	     (save-excursion
;;;	       (set-buffer (get-buffer-create
;;;			    lyskom-debug-communications-to-buffer-buffer))
;;;	       (save-excursion
;;;		 (goto-char (point-max))
;;;		 (insert "\n" 
;;;			 (format "%s" process)
;;;			 (concat "Error: " (format "%s" err))))
;;;	       (set-buffer (process-buffer process)))
	   )
	 (cond
	  ((and (string= "writing to process" (car (cdr err)))
		(or (string= "message too long" (car (cdr (cdr err))))
		    (string= "no more processes" (car (cdr (cdr err)))))
		(> lyskom-max-packet-size 1))
	   ;; Seems to be impossible to write too long strings to TCP/IP.
	   ;; This happens on a Sequence Balance with packets longer than
	   ;; 2048 bytes. Decrease lyskom-max-packet-size and retry.
	   (setq lyskom-max-packet-size (/ lyskom-max-packet-size 2))
	   t)

	  ((and (string= "writing to process" (car (cdr err)))
		(string= "host is unreachable" (car (cdr (cdr err)))))
	   ;; The net is currently shaky. We try again in a while.
	   (lyskom-message "%s" (lyskom-format 'shaky-tcp
					       (make-string (++ tries) ?.)))
	   (sit-for 4)
	   (lyskom-message "%s" (lyskom-get-string 'retrying-tcp))
	   t)
	  
	  (t
	   ;; It was some unknown file-error. Pass it down.
	   (signal (car err) (cdr err)))))))))


(defun lyskom-process-send-string-2 (process string)
  "Send PROCESS the contents of STRING as input.
PROCESS may be a process name. At most lyskom-max-packet-size bytes
is sent with each packet. If STRING is longer it is splitted."
  (cond
   ((<= (length string) lyskom-max-packet-size)
    (process-send-string
     process
     (progn
       (if lyskom-debug-communications-to-buffer
	   (lyskom-debug-insert process "To " string))
       string)))
   (t
    (let ((i 0))
      (while (< i (length string))
	(process-send-string
	 process
	 (let ((string (substring string
				  i
				  (min (length string)
				       (+ i lyskom-max-packet-size)))))
	   (if lyskom-debug-communications-to-buffer
	       (save-excursion
		 (set-buffer (get-buffer-create 
			      lyskom-debug-communications-to-buffer-buffer))
		 (save-excursion
		   (goto-char (point-max))
		   (insert "\n"
                           "To " process ": "))
		 (set-buffer (process-buffer process))))
	   string))
	(setq i (+ i lyskom-max-packet-size)))))))


(defun lyskom-check-call (queue-name)
  "Check lyskom-call-data and call handlers, multi-handlers and functions.
Args: QUEUE-NAME.
HALTED -> stop
CALL -> stop
PARSED -> handle ->
       -> collect-flag? 'COLLECT -> add on temporary resultlist.
	 	        'COLLECT-IGNORE -> add on temporary resultlist if not 
			 		   error.
		        no  -> delete from lyskom-call-data.
COLLECT -> collect-flag? yes -> error!
			 no  -> set collect-flag.
COLLECT-IGNORE -> collect-flag? yes -> error!
				no -> set collect-flag.
USE ->      call handler. Delete previous parts.
LIST-USE -> call handler. Delete previous parts.
RUN ->      call function. Delete. Not allowed inside COLLECT/USE."
  (let* ((queue (cdr-safe (assoc queue-name lyskom-call-data)))
         (type nil)
         (first-pending (lyskom-queue->first (kom-queue->pending queue))))
    (while (and queue
                (not (or (kom-queue-is-halted queue)
                         (lyskom-queue-isempty (kom-queue->pending queue))
                         (eq (car first-pending) 'CALL))))
      (setq type (car first-pending))

      (cond

       ((eq type 'PARSED)
	(kom-queue-halt queue)
	(unwind-protect
	    (lyskom-apply-handler first-pending)
	  (kom-queue-resume queue))
        (if (or (eq (kom-queue->collect-flag queue) 'COLLECT)
                (and (eq (kom-queue->collect-flag queue) 'COLLECT-IGNORE)
                     (car (cdr (cdr first-pending)))))
            (lyskom-queue-enter (kom-queue->collect-queue queue)
                                (car (cdr (cdr first-pending))))))

       ((eq type 'COLLECT)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call COLLECT."))
          (set-kom-queue-collect-flag queue 'COLLECT)
          (lyskom-queue-make-empty (kom-queue->collect-queue queue))))

       ((eq type 'COLLECT-IGNORE)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call COLLECT-IGNORE."))
          (set-kom-queue-collect-flag queue 'COLLECT-IGNORE)
          (lyskom-queue-make-empty (kom-queue->collect-queue queue))))

       ((eq type 'USE)
        (if (not (kom-queue->collect-flag queue))
            (signal 'lyskom-internal-error
                    '("lyskom-check-call USE.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-multi-handler
             first-pending (lyskom-queue->all-entries
                            (kom-queue->collect-queue queue)))
          (kom-queue-resume queue))
        (set-kom-queue-collect-flag queue nil))

       ((eq type 'LIST-USE)
        (if (not (kom-queue->collect-flag queue))
            (signal 'lyskom-internal-error
                    '("lyskom-check-call LIST-USE.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-multi-list-handler
             first-pending (lyskom-queue->all-entries
                            (kom-queue->collect-queue queue)))
          (kom-queue-resume queue))
        (set-kom-queue-collect-flag queue nil))

       ((eq type 'RUN)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call RUN.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-function first-pending)
          (kom-queue-resume queue)))
       
       (t (signal 'lyskom-internal-error
                  (list 'lyskom-check-call
                        "unknown key:"
                        (car first-pending)))))

      (lyskom-queue-delete-first (kom-queue->pending queue))
      (setq first-pending (lyskom-queue->first (kom-queue->pending queue))))))

;;; Quit is NOT ok to press while the handler is running. inhibit-quit
;;; should be t when these are called.
(defun lyskom-apply-handler (pending)
  "Apply a handler. Args: PENDING.
PENDING is an entry of the list as described in documentation for the variable
lyskom-call-data. The car on the list must be a PARSED:
	('PARSED RESULT HANDLER HANDLER-DATA)"
  (if (car (cdr (cdr (cdr pending))))
      (apply (car (cdr (cdr (cdr pending))))	;Handler
	     (car (cdr (cdr pending)))	;Result
	     (car (cdr (cdr (cdr (cdr pending)))))))) ;Handler-data

(defun lyskom-apply-multi-handler (pending result-list)
  "Apply a handler for a lyskom-collect - lyskom-use construct."
  (apply (car (cdr pending))		;Multi-handler
	 (nconc result-list
		(car (cdr (cdr pending)))))) ;Multi-handler-data


(defun lyskom-apply-multi-list-handler (pending result-list)
  "Apply a handler for a lyskom-collect - lyskom-list-use construct."
  (apply (car (cdr pending))		;Multi-handler
	 (cons result-list
	       (car (cdr (cdr pending)))))) ;Multi-handler-data
    
(defun lyskom-apply-function (pending)
  (setcar pending 'HALTED)
  (apply (car (cdr pending))	    ;Function.
	 (car (cdr (cdr pending)))))  ;Function-args.
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: services.el,v 44.49 2004/10/28 18:51:55 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; This file contains functions for sending requests to the server
;;;; and parsing the result.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: services.el,v 44.49 2004/10/28 18:51:55 byers Exp $\n"))


;;; ================================================================
;;; Macro for defining services

;;; (defmacro def-kom-service (name args &rest body)
;;;   "Create an initiate call. NAME and ARGS are the name and arguments for the call.
;;; If BODY starts with a string, that is the documentation string.
;;; If BODY consists of (call N PARSER), generate a simple call
;;; for RPC number N, and parse the result with PARSER."
;;;   (let ((function-name (intern (concat "initiate-" (symbol-name name))))
;;;         (doc-string nil)
;;;         (auto-call nil)
;;;         (buffer-save (intern (format "initiate-%s-saved-buffer" name))))
;;;     (when (stringp (car body))
;;;       (setq doc-string (car body))
;;;       (setq body (cdr body)))
;;; 
;;;     (when (and (listp (car body))
;;;                (eq 'call (car (car body))))
;;;       (setq auto-call (car body))
;;;       (setq body (cdr body)))
;;; 
;;;     (` (defun (, function-name) (kom-queue handler (,@ args) &rest data)
;;;          (, 
;;;           (or doc-string 
;;;               (format "Initiate %S on server\nArgs: KOM-QUEUE HANDLER %s &rest DATA"  
;;;                       name (mapconcat 
;;;                             (function
;;;                              (lambda (x)
;;;                                (format "%s" (upcase (symbol-name x)))))
;;;                             args
;;;                             " "))))
;;;          (let (((, buffer-save) (current-buffer)))
;;;            (unwind-protect
;;;                (progn
;;;                  (and (not lyskom-output-queues) (set-buffer lyskom-buffer))
;;;                  (,@ (if auto-call
;;;                          (` ((lyskom-call kom-queue lyskom-ref-no handler data (quote (, (elt auto-call 2))))
;;;                              (lyskom-send-packet kom-queue (lyskom-format-objects (, (elt auto-call 1)) (,@ args)))))
;;;                        body)))
;;;              (set-buffer (, buffer-save))))))))

(defmacro lyskom-server-call (&rest body)
  "Macro to protect initiate-somethings 
from being called in the wrong buffer."
  (` (let ((initiate-something-saved-buffer (current-buffer)))
       (unwind-protect
           (prog2 (or lyskom-output-queues (set-buffer lyskom-buffer))
               lyskom-ref-no
             (,@ body))
         (set-buffer initiate-something-saved-buffer)))))

(put 'lyskom-server-call 'lisp-indent-function 0)
(put 'lyskom-server-call 'edebug-form-spec t)
     

;;; ================================================================
;;;                     Requests for services


(defun initiate-login-old (kom-queue handler pers-no password &rest data)
  "Log in on server.
Args: KOM-QUEUE HANDLER PERS-NO PASSWORD &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 0 pers-no password))))


(defun initiate-login (kom-queue handler pers-no password status 
                                 &rest data)
  "Log in on server.
Args: KOM-QUEUE HANDLER PERS-NO PASSWORD STATUS &rest DATA.
Status is 0 for visible login and 1 for invisible login."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 62 pers-no
                                                         password status))))


(defun initiate-logout (kom-queue handler &rest data)
  "Log out from server.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 1))))


(defun initiate-pepsi (kom-queue handler conf-no &rest data)
  "Change working conference.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
    (let ((mship (lyskom-try-get-membership conf-no t)))
      (when mship
        (set-membership->last-time-read mship (lyskom-current-client-time))))
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 2 conf-no))))

(defun initiate-change-name (kom-queue handler
				       conf-no new-name
				       &rest data)
  "Change the name of a conference.
Args: KOM-QUEUE HANDLER CONF-NO NEW-NAME &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 3 conf-no new-name))))


(defun initiate-change-what-i-am-doing (kom-queue handler what &rest data)
  "Tell server what you are doing.
Args: KOM-QUEUE HANDLER WHAT &rest DATA.
WHAT is a string."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 4 what))))
  

(defun initiate-create-person (kom-queue handler name 
                                         password pers-flags
                                         aux-items 
                                             &rest data)
  "Create a new person.
Args: KOM-QUEUE HANDLER NAME PASSWORD &rest DATA."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 89)
       (lyskom-send-packet kom-queue (lyskom-format-objects 89
                                                            name
                                                            password
                                                            pers-flags
                                                            (cons 'LIST 
                                                                  aux-items)))
     (lyskom-send-packet kom-queue (lyskom-format-objects 5 name password)))))


;;; Call 6 is get-person-stat-old, and is obsoleted by call 49.

(defun initiate-set-priv-bits (kom-queue handler pers-no priv-bits &rest data)
  "Set priv-bits of a person.
Args: KOM-QUEUE HANDLER PERS-NO PRIV-BITS &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 7 pers-no priv-bits))))


(defun initiate-set-passwd (kom-queue handler
				      pers-no old-pw new-pw
				      &rest data)
  "Set the password of a person.
Args: KOM-QUEUE HANDLER PERS-NO OLD-PW NEW-PW &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 8 pers-no old-pw new-pw))))


;;; 
;;; This function has a ridiculous name!  It ought to be called
;;; get-membership.  Unfortunately this name is already taken
;;; by another call.
;;;
(defun initiate-query-read-texts (kom-queue handler
					    pers-no 
                                            conf-no
                                            want-read-ranges
                                            max-ranges
                                            &rest data)
  "Get a membership struct describing the membership of PERS-NO in CONF-NO.
Args: KOM-QUEUE HANDLER PERS-NO CONF-NO &rest DATA"
  (lyskom-server-call
    (cond ((lyskom-have-call 107)
           (lyskom-call kom-queue lyskom-ref-no handler data 
                        'lyskom-parse-membership-11)
           (lyskom-send-packet kom-queue
                               (lyskom-format-objects 107 pers-no conf-no
                                                      want-read-ranges
                                                      max-ranges)))
          ((lyskom-have-call 98)
           (lyskom-call kom-queue lyskom-ref-no handler data 
                        'lyskom-parse-membership-10)
           (lyskom-send-packet kom-queue
                               (lyskom-format-objects 98 pers-no conf-no)))
          (t
           (lyskom-call kom-queue lyskom-ref-no handler data 
                        'lyskom-parse-membership-old)
           (lyskom-send-packet kom-queue
                               (lyskom-format-objects 9 pers-no conf-no))))))


(defun initiate-create-conf (kom-queue handler
				       conf-name conf-type
                                       aux-items &rest data)
  "Add a member to a conference.
Args: KOM-QUEUE HANDLER CONF-NAME CONF-TYPE &rest DATA."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 88)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 88 conf-name conf-type
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 10 conf-name conf-type)))))


(defun initiate-delete-conf (kom-queue handler conf-no &rest data)
  "Delete a conference.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 11 conf-no))))



(defun initiate-lookup-name (kom-queue handler name &rest data)
  "See what conferences match NAME.
Args: KOM-QUEUE HANDLER NAME &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-conf-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 12 name))))
					    

;;; Call 13 is get-conf-stat-old, which is obsoleted by 50.


(defun initiate-add-member (kom-queue handler
				      conf-no 
                                      pers-no
                                      priority
                                      where
                                      type
				      &rest data)
  "Add a member to a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERS-NO PRIORITY WHERE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (if (lyskom-have-call 100)
        (lyskom-send-packet kom-queue
                            (lyskom-format-objects 100 conf-no pers-no 
                                                   priority where type))
      (lyskom-send-packet kom-queue
                          (lyskom-format-objects 14 conf-no pers-no 
                                                 priority where)))))


(defun initiate-sub-member (kom-queue handler
				      conf-no pers-no
				      &rest data)
  "Subtract a member from a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERS-NO  &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 15 conf-no pers-no))))


(defun initiate-set-presentation (kom-queue handler
					    conf-no text-no
					    &rest data)
  "Set presentation of a conference.
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 16 conf-no text-no))))


(defun initiate-set-conf-motd (kom-queue handler conf-no text-no &rest data)
  "Set motd of a conference.
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 17 conf-no text-no))))


(defun initiate-set-supervisor (kom-queue handler conf-no admin
					  &rest data)
  "Set supervisor of a conference.
Args: KOM-QUEUE HANDLER CONF-NO ADMIN &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 18 conf-no admin))))


(defun initiate-set-permitted-submitters (kom-queue handler conf-no perm-sub
						    &rest data)
  "Set permitted submitters of a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERM-SUB &rest DATA.
PERM-SUB is a conference number. All members in that conference might
write texts in CONF-NO. If PERM-SUB is zero everyone is allowed to
write texts in CONF-NO."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 19 conf-no perm-sub))))


(defun initiate-set-super-conf (kom-queue handler conf-no super-conf
					  &rest data)
  "Set superconference of a conference.
Args: KOM-QUEUE HANDLER CONF-NO SUPER-CONF &rest DATA.
Unauthorized attempts to write texts to CONF-NO will bounce to SUPER-CONF."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects 20 conf-no super-conf))))


(defun initiate-set-conf-type (kom-queue handler conf-no conf-type &rest data)
  "Set type of a conference.
Args: KOM-QUEUE HANDLER CONF-NO CONF-TYPE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 21 conf-no conf-type))))


(defun initiate-set-garb-nice (kom-queue handler conf-no garb-nice &rest data)
  "Set garb-nice of a conference.
Args: KOM-QUEUE HANDLER CONF-NO GARB-NICE &rest DATA.
Texts in CONF-NO will live approximately GARB-NICE days."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 22 conf-no garb-nice))))


(defun initiate-get-marks (kom-queue handler &rest data)
  "Get all marked texts.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-mark-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 23))))


(defun initiate-mark-text (kom-queue handler
                                     text-no mark-type
                                     &rest data)
  "Mark a text.
Args: KOM-QUEUE HANDLER TEXT-NO MARK-TYPE &rest DATA.
MARK-TYPE is currently a number, but this should maybe be
changed (internally in the elisp-klient) to something similar to
a conf-type (with several bits that are 't' or 'nil' that is)."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 
                         (if (lyskom-have-call 72) 72 24) 
                         text-no mark-type))))

(defun initiate-unmark-text (kom-queue handler
                                     text-no
                                     &rest data)
  "Unmark a text.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (if (lyskom-have-call 73)
        (lyskom-send-packet kom-queue (lyskom-format-objects 73 text-no)))
      (lyskom-send-packet kom-queue (lyskom-format-objects 24 text-no 0))))


(defun initiate-get-text (kom-queue handler text-no &rest data)
  "Get text from LysKOM server.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (let ((text (cache-get-text text-no)))
      (cond
       ((null text)			;Cached info?
        (lyskom-call kom-queue		;No, ask the server.
                     lyskom-ref-no
                     handler data
                     'lyskom-parse-text text-no)
                                        ;(princ text-no (get-buffer-create "text"))+++
                                        ;(terpri (get-buffer-create "text"))
        (lyskom-send-packet kom-queue (lyskom-format-objects 25 text-no
                                                             0 lyskom-max-int)))
       (t
                                        ;Cached info. 
        (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) text handler data)
        (lyskom-check-call kom-queue))))))


(defun initiate-get-text-stat (kom-queue handler text-no &rest data)
  "Get text-stat from LysKOM server.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
   (let ((text-stat (cache-get-text-stat text-no)))
     (cond
      ((null text-stat)			;Cached info?
       (lyskom-call kom-queue		;No, ask the server.
                    lyskom-ref-no
                    handler data
                    (if (lyskom-have-call 90)
                        'lyskom-parse-text-stat
                      'lyskom-parse-text-stat-old)
                    text-no)
       ;;(princ text-no (get-buffer-create "text-stat"))+++
       ;;(terpri (get-buffer-create "text-stat"))
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects
                            (if (lyskom-have-call 90) 90 26)
                            text-no)))
      (t
                                        ;Cached info. 
       (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) text-stat handler data)
       (lyskom-check-call kom-queue))))))


(defun initiate-mark-as-read (kom-queue handler conf-no text-list &rest data)
  "Mark all texts in TEXT-LIST as read in CONF-NO. Args: CONF-NO TEXT-LIST."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 27 conf-no 
                                               (cons 'LIST text-list)))))


(defun initiate-create-text (kom-queue 
                             handler
                             message
                             misc-list
                             aux-items
                             &rest data)
  "Create a new text.
Args: KOM-QUEUE HANDLER MESSAGE MISC-LIST AUX-ITEMS &rest DATA.
MESSAGE is a string. MISC-LIST should be created by lyskom-create-misc-list."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 86)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 86
                                                  (cons 'STRING message)
                                                  misc-list
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 28 
						(cons 'STRING message) 
						misc-list)))))

				     
(defun initiate-delete-text (kom-queue handler text-no &rest data)
  "Delete a text.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 29 text-no))))


(defun initiate-add-recipient (kom-queue handler
					 text-no conf-no type
					 &rest data)
  "Add a recipient to a text.
Args: KOM-QUEUE HANDLER TEXT-NO CONF-NO TYPE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet 
     kom-queue
     (lyskom-format-objects 30 text-no conf-no
                            (cond ((eq type 'RECPT) 0)
                                  ((eq type 'CC-RECPT) 1)
                                  ((eq type 'BCC-RECPT) 
                                   (if (lyskom-have-feature bcc-misc)
                                       15 1)))))))

(defun initiate-sub-recipient (kom-queue handler
					 text-no conf-no 
					 &rest data)
  "Subtract a recipient from a text.
Args: KOM-QUEUE HANDLER TEXT-NO CONF-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 31 text-no conf-no))))


(defun initiate-add-comment (kom-queue handler
                                       comment-text-no text-no
                                       &rest data)
  "Add a comment to a text.
Args: KOM-QUEUE HANDLER COMMENT-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 32 comment-text-no text-no))))

				       

(defun initiate-sub-comment (kom-queue handler
                                       comment-text-no text-no
                                       &rest data)
  "Subtract a comment from a text.
Args: KOM-QUEUE HANDLER COMMENT-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 33 comment-text-no text-no))))


(defun initiate-get-map (kom-queue handler conf-no first-local
				   no-of-texts &rest data-list)
  "Get mapping from local to global text-nos for CONF-NO from server.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-TEXTS DATA-LIST.
Use z-initiate-get-map instead. This function has severe performance losses
with big maps."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data-list 'lyskom-parse-map)
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects 34 conf-no
                                               first-local no-of-texts))))

(defun z-initiate-get-map  (kom-queue handler conf-no first-local
                                      no-of-texts &rest data)
  "Get mapping from local to global text-nos for CONF-NO from server.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-TEXTS &rest DATA.
This function will automatically split fetching of big maps to small
chunks of lyskom-fetch-map-nos texts/chunk if KOM-QUEUE is not already
used to collect a result. This currently gives a big performance gain.
Unfortunately it is impossible (or at least very hard) to do the same
thing when a collect is in progress. This will of course be fixed in
protocol B."
  (lyskom-server-call
    (cond
     ((kom-queue->collect-flag (cdr-safe (assq kom-queue lyskom-call-data)))
      ;; Use oldstyle single big map. Sorry.
      (apply 'initiate-get-map
             kom-queue handler conf-no first-local no-of-texts data))
     (t
      ;; You win.
      (initiate-get-map kom-queue 'lyskom-receive-partial-map conf-no
                        first-local lyskom-fetch-map-nos
                        (+ lyskom-fetch-map-nos first-local)
                        (- no-of-texts lyskom-fetch-map-nos)
                        conf-no nil kom-queue data handler)))))

(defun lyskom-receive-partial-map (map first-local no-of-texts
				       conf-no map-so-far kom-queue
				       data-list handler)
  "Receive a partial map and start fetching a new chunk."
  (lyskom-server-call
    (let ((map-list (nconc map-so-far (list map))))
      (if (<= no-of-texts 0)
          (apply handler (apply 'lyskom-map-concat map-list) data-list)
        (initiate-get-map kom-queue 'lyskom-receive-partial-map conf-no
                          first-local lyskom-fetch-map-nos
                          (+ lyskom-fetch-map-nos first-local)
                          (- no-of-texts lyskom-fetch-map-nos)
                          conf-no map-list kom-queue data-list handler)))))


(defun initiate-get-time (kom-queue handler &rest data)
  "Get time from server.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-time)
    (lyskom-send-packet kom-queue (lyskom-format-objects 35))))


(defun initiate-get-server-info (kom-queue handler &rest data)
  "Get info about the server"
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no
                handler
                data
                (if (lyskom-have-call 94)
                    'lyskom-parse-server-info
                  'lyskom-parse-server-info-old))
   (lyskom-send-packet kom-queue
                       (lyskom-format-objects
                        (if (lyskom-have-call 94) 94 36)))))


(defun initiate-add-footnote (kom-queue handler
					footnote-text-no text-no
					&rest data)
  "Add a footnote to a text.
Args: KOM-QUEUE HANDLER FOOTNOTE-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 37 footnote-text-no text-no))))


(defun initiate-sub-footnote (kom-queue handler
					footnote-text-no text-no
					&rest data)
  "Subtract a footnote from a text.
Args: KOM-QUEUE HANDLER FOOTNOTE-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 38 footnote-text-no text-no))))


;;; Call 39, who-is-on-old, is obsoleted by call 63.


(defun initiate-set-unread (kom-queue handler conf-no no-of-unread &rest data)
  "Set number of unread texts in a certain conference.
Args: KOM-QUEUE HANDLER CONF-NO NO-OF-UNREAD &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 40 conf-no no-of-unread))))


(defun initiate-set-motd-of-lyskom (kom-queue handler text-no &rest data)
  "Set message of the day of LysKOM.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 41 text-no))))


(defun initiate-enable (kom-queue handler level &rest data)
  "Set security level.
Args: KOM-QUEUE HANDLER LEVEL &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 42 level))))

;;; Call 43 is sync. Starting with version 1.9 of lyskomd it is a
;;; privileged operation, so there is no harm in having the function
;;; easily available any more.

(defun initiate-sync (kom-queue handler &rest data)
  "Sync the LysKOM datbase. This is a prioritized call."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 43))))

;;; Call 44 is shutdown. Use 'kill -HUP' instead.

(defun initiate-shutdown (kom-queue handler parameter &rest data)
  "Shutdown the server.
Args: KOM-QUEUE HANDLER PARAMETER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 44 parameter))))


(defun initiate-broadcast (kom-queue handler message &rest data)
  "Send a broadcast message to all logged in users.
Args: KOM-QUEUE HANDLER MESSAGE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 45 message))))



(defun initiate-get-membership (kom-queue handler pers-no &rest data)
  "Get membership-list for PERS-NO from server.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA."
  (lyskom-server-call
    (cond ((lyskom-have-call 108)
           (lyskom-call kom-queue lyskom-ref-no handler data
                        'lyskom-parse-membership-list-11)
           (lyskom-send-packet 
            kom-queue 
            (lyskom-format-objects 108 pers-no 0 lyskom-max-int
                                   1 lyskom-max-int)))
          ((lyskom-have-call 99)
           (lyskom-call kom-queue lyskom-ref-no handler data
                        'lyskom-parse-membership-list-10)
           (lyskom-send-packet 
            kom-queue 
            (lyskom-format-objects 99 pers-no 0 lyskom-max-int 1)))
          (t (lyskom-call kom-queue lyskom-ref-no handler data
                          'lyskom-parse-membership-list-old)
             (lyskom-send-packet 
              kom-queue 
              (lyskom-format-objects 46 pers-no 0 lyskom-max-int 1))))))


(defun initiate-get-part-of-membership (kom-queue handler pers-no first length
						  &rest data)
  "Get membership-list for PERS-NO from server.
Args: KOM-QUEUE HANDLER PERS-NO FIRST-IN-LIST LENGHT &rest DATA."
  (lyskom-server-call
    (cond ((lyskom-have-call 108)
           (lyskom-call kom-queue lyskom-ref-no handler data
                        'lyskom-parse-membership-list-11)
           (lyskom-send-packet 
            kom-queue 
            (lyskom-format-objects 108 pers-no first length
                                   1 1)))
          ((lyskom-have-call 99)
           (lyskom-call kom-queue lyskom-ref-no handler data
                        'lyskom-parse-membership-list-10)
           (lyskom-send-packet 
            kom-queue 
            (lyskom-format-objects 99 pers-no first length 0)))
          (t (lyskom-call kom-queue lyskom-ref-no handler data
                          'lyskom-parse-membership-list-old)
             (lyskom-send-packet 
              kom-queue 
              (lyskom-format-objects 46 pers-no first length 0))))))


(defun initiate-get-created-texts (kom-queue handler pers-no first-local
					     no-of-texts &rest data)
  "Get a part of the list of created texts for a person.
Args: KOM-QUEUE HANDLER PERS-NO FIRST-LOCAL NO-OF-TEXTS &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-map)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 47 pers-no
                                               first-local no-of-texts))))


(defun initiate-get-members (kom-queue handler conf-no first-local
				       no-of-members &rest data)
  "Get a part of the list of members in a conference.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-MEMBERS &rest DATA.
Returns a conf-no-list."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 (if (lyskom-have-call 101)
                     'lyskom-parse-member-list
                   'lyskom-parse-member-list-old))
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 
                         (if (lyskom-have-call 101) 101 48)
                         conf-no
                         first-local no-of-members))))


(defun initiate-get-pers-stat (kom-queue handler pers-no &rest data)
  "Get status for person PERS-NO.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA."
  (lyskom-server-call
    (let ((pers-stat (cache-get-pers-stat pers-no)))
      (cond
       ((null pers-stat)                ;Cached info?
        (lyskom-call kom-queue		;No, ask the server.
                     lyskom-ref-no
                     handler data
                     'lyskom-parse-pers-stat pers-no)
                                        ;(princ pers-no (get-buffer-create "pers-stat")) +++
                                        ;(terpri (get-buffer-create "pers-stat"))
        (lyskom-send-packet kom-queue (lyskom-format-objects 49 pers-no)))
       (t
                                        ;Cached info. 
        (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) pers-stat handler data)
        (lyskom-check-call kom-queue))))))

(defun initiate-get-conf-stat (kom-queue handler conf-no &rest data)
  "Get conf-stat from LysKOM server.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
   (let ((conf-stat (cache-get-conf-stat conf-no)))
     (cond
      ((zerop conf-no)			;No real user.
       (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) nil handler data)
       (lyskom-check-call kom-queue))
      ((null conf-stat)			;Cached info?
       (lyskom-call kom-queue		;No, ask the server.
                    lyskom-ref-no
                    handler data
                    (if (lyskom-have-call 91)
                        'lyskom-parse-conf-stat
                      'lyskom-parse-conf-stat-old)
                    conf-no)
       ;;(princ conf-no (get-buffer-create "conf-stat")) +++
       ;;(terpri (get-buffer-create "conf-stat"))
       (lyskom-send-packet kom-queue 
                           (lyskom-format-objects
                            (if (lyskom-have-call 91) 91 50)
                            conf-no)))
      (t
                                        ;Cached info. 
       (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) conf-stat handler data)
       (lyskom-check-call kom-queue))))))


;; who-is-on is obsoleted by who-is-on-dynamic (83) i protocol version 9
(defun initiate-who-is-on (kom-queue handler &rest data)
  "Ask server who is on.
Args: KOM-QUEUE HANDLER &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-who-info-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 51))))


(defun initiate-get-unread-confs (kom-queue handler pers-no &rest data)
  "Return a list of confs that may have unread texts.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA.
PERS-NO is the number of the person whos confs we are checking."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-conf-no-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 52 pers-no))))


(defun initiate-send-message (kom-queue handler recipient message &rest data)
  "Send a message to one or all logged in users.
Args: KOM-QUEUE HANDLER RECIPIENT MESSAGE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 53 recipient message))))


(defun initiate-get-session-info (kom-queue handler session-no &rest data)
  "Ask server for info about a session.
Args: KOM-QUEUE HANDLER SESSION-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-session-info)
    (lyskom-send-packet kom-queue (lyskom-format-objects 54 session-no))))


(defun initiate-disconnect (kom-queue handler session-no &rest data)
  "Disconnect a session.
Args: KOM-QUEUE HANDLER SESSION &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 55 session-no))))


(defun initiate-who-am-i (kom-queue handler &rest data)
  "Ask the server which connection we are using.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 56))))

(defun initiate-set-user-area (kom-queue handler pers-no text-no &rest data)
  "Set user-area of a person.
Args: KOM-QUEUE HANDLER PERS-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 57 pers-no text-no))))


;; WARNING: If you start using this you have to figure out a way to
;; convert local time (before) to UTC. Since this doesn't work at the
;; moment, I have commented this functoun into oblivion.
;;
;; (defun initiate-get-last-text (kom-queue handler before &rest data)
;;   "Get text created before BEFORE.
;; Args: KOM-QUEUE HANDLER BEFORE &rest DATA"
;;   (lyskom-server-call
;;     (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
;;     (lyskom-send-packet kom-queue (lyskom-format-objects 58 before))))


(defun initiate-create-anonymous-text (kom-queue 
                                       handler
                                       message 
                                       misc-list
                                       aux-items
                                       &rest data)
  "Create a new anonymous text.
Args: KOM-QUEUE HANDLER MESSAGE MISC-LIST AUX-ITEMS &rest DATA.
MESSAGE is a string. MISC-LIST should be created by lyskom-create-misc-list."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 87)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 87
                                                  (cons 'STRING message)
                                                  misc-list
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 59 
                                                (cons 'STRING message)
                                                misc-list)))))


(defun initiate-find-next-text-no (kom-queue handler text-no &rest data)
  "Find the text following the text TEXT-NO"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 60 text-no))))

(defun initiate-find-previous-text-no (kom-queue handler text-no &rest data)
  "Find the text preceding the text TEXT-NO"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 61 text-no))))

;; Call 62 is above

(defun initiate-who-is-on-ident (kom-queue handler &rest data)
  "Who is logged on. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-who-info-ident-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 63))))

(defun initiate-get-session-info-ident (kom-queue handler 
                                                  session-no &rest data)
  "Get session info. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-session-info-ident)
    (lyskom-send-packet kom-queue (lyskom-format-objects 64 session-no))))

(defun initiate-re-lookup-person (kom-queue handler regexp &rest data)
  "Look up person based on regexp. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 65 regexp))))

(defun initiate-re-lookup-conf (kom-queue handler regexp &rest data)
  "Look up conference based on regexp. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 66 regexp))))

(defun initiate-lookup-person (kom-queue handler regexp &rest data)
  "Look up person based on abbreviated name. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 67 regexp))))

(defun initiate-lookup-conf (kom-queue handler regexp &rest data)
  "Look up conference based on abbreviated name. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 68 regexp))))

(defun initiate-set-client-version (kom-queue handler name version &rest data)
  "Tell the server to set the client name and version of this session."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 69 name version))))


(defun initiate-get-client-name (kom-queue handler session &rest data)
  "Tell the server to set the highest unread article in conference CONF-NO
to TEXT-NO
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-string)
    (lyskom-send-packet kom-queue (lyskom-format-objects 70 session))))


(defun initiate-get-client-version (kom-queue handler session &rest data)
  "Tell the server to set the highest unread article in conference CONF-NO
to TEXT-NO
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-string)
    (lyskom-send-packet kom-queue (lyskom-format-objects 71 session))))

(defun initiate-re-z-lookup (kom-queue handler regexp want-persons want-confs
				       &rest data)
  "Perform a regexp lookup.
Args: KOM-QUEUE HANDLER REGEXP WANT-PERSONS WANT-CONFS &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-conf-z-info-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 74 regexp want-persons
                                                         want-confs))))

(defun initiate-get-version-info (kom-queue handler &rest data)
  "Perform a get-version-info vall.
Args: KOM-QUEUE HANDLER &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-version-info)
    (lyskom-send-packet kom-queue (lyskom-format-objects 75))))


(defun initiate-lookup-z-name (kom-queue handler name want-persons want-confs
                                         &rest data)
  "Perform a z-lookup.
Args: KOM-QUEUE HANDLER NAME WANT-PERSONS WANT-CONFS &rest DATA"
  (lyskom-server-call
    (if (lyskom-have-call 76)
        (progn
          (lyskom-call kom-queue lyskom-ref-no handler data 
                       'lyskom-parse-conf-z-info-list)
          (lyskom-send-packet kom-queue (lyskom-format-objects 76 name
                                                               want-persons
                                                               want-confs)))
      (let ((ref-no lyskom-ref-no))
        (lyskom-fake-call kom-queue ref-no handler data)
        (++ lyskom-ref-no)
        (initiate-lookup-name 'compat
                              'initiate-compat-lookup-z-name-2
                              name
                              kom-queue
                              ref-no
                              want-persons
                              want-confs)))))

(defun initiate-compat-lookup-z-name-2 (result kom-queue
                                               ref-no
                                               want-persons
                                               want-confs)
  (lyskom-server-call
    (if (null result)
        (lyskom-complete-call kom-queue ref-no nil))

    (let ((conf-nos (listify-vector (conf-list->conf-nos result)))
          (conf-types (listify-vector (conf-list->conf-types result))))
      (lyskom-collect 'follow)
      (while conf-nos
        (if (or (and want-persons
                     (conf-type->letterbox (car conf-types)))
                (and want-confs
                     (not (conf-type->letterbox (car conf-types)))))
            (initiate-get-conf-stat 'follow nil (car conf-nos)))
        (setq conf-nos (cdr conf-nos))
        (setq conf-types (cdr conf-types)))
      (lyskom-list-use 'follow
                       'initiate-compat-lookup-z-name-3
                       kom-queue
                       ref-no))))



(defun initiate-compat-lookup-z-name-3 (conf-list kom-queue 
                                                  ref-no)
  (lyskom-server-call
    (lyskom-complete-call kom-queue ref-no
                          (lyskom-create-conf-z-info-list
                           (mapcar (function
                                    (lambda (conf-stat)
                                      (lyskom-create-conf-z-info
                                       (conf-stat->name conf-stat)
                                       (conf-stat->conf-type conf-stat)
                                       (conf-stat->conf-no conf-stat))))
                                   conf-list)))))
    

(defun initiate-set-last-read (kom-queue handler conf-no text-no &rest data)
  "Tell the server to set the highest unread article in conference CONF-NO
to TEXT-NO
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA"
  (lyskom-server-call
    (if (lyskom-have-call 77)
        (progn
          (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
          (lyskom-send-packet kom-queue (lyskom-format-objects 77
                                                               conf-no text-no)))
      (initiate-get-conf-stat kom-queue 
                              'initiate-set-last-read-2 
                              conf-no
                              kom-queue
                              handler 
                              conf-no
                              text-no
                              data))))

(defun initiate-set-last-read-2 (conf-stat 
                                 kom-queue
                                 handler
                                 conf-no
                                 text-no
                                 data)
  (lyskom-server-call
    (let ((no-of-unread (- (1- (+ (conf-stat->first-local-no conf-stat)
                                  (conf-stat->no-of-texts conf-stat)))
                           text-no)))
      (if (< no-of-unread 0)
          (setq no-of-unread 0))

      (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
      (lyskom-send-packet kom-queue
                          (lyskom-format-objects 40 conf-no no-of-unread)))))

(defun initiate-get-uconf-stat (kom-queue handler conf-no &rest data)
  "Get an uconf-stat from LysKOM server.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
    (let ((conf-stat (cache-get-uconf-stat conf-no)))
      (cond ((zerop conf-no)
             (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) nil handler data)
             (lyskom-check-call kom-queue))
            ((null conf-stat)
             (lyskom-call kom-queue
                          lyskom-ref-no
                          handler data
                          'lyskom-parse-uconf-stat conf-no)
             (lyskom-send-packet kom-queue (lyskom-format-objects 78 conf-no)))
            (t
             (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) conf-stat handler data)
             (lyskom-check-call kom-queue))))))

(defun initiate-set-info (kom-queue handler 
                                    conf-pres-conf
                                    pers-pres-conf
                                    motd-conf
                                    kom-news-conf
                                    motd-of-lyskom &rest data)
  "Set server info."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 79
                                                         0
                                                         conf-pres-conf
                                                         pers-pres-conf
                                                         motd-conf
                                                         kom-news-conf
                                                         motd-of-lyskom))))
                                                         

(defun initiate-accept-async (kom-queue handler list &rest data)
  "Request asynchronous messages in LIST
Args: KOM-QUEUE HANDLER LIST &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 80
                                                         (cons 'LIST
                                                               list)))))

(defun initiate-query-async (kom-queue handler &rest data)
  "Request information on which async messages are being sent.
Args: KOM-QUEUE HANDLER &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 81))))
                                 


(defun initiate-user-active (kom-queue handler &rest data)
  "Notify the server that the user is active
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 82))))


(defun initiate-who-is-on-dynamic (kom-queue handler want-visible
					     want-invisible active-last
					     &rest data)
  "Ask server who is on.
Args: KOM-QUEUE HANDLER WANT-VISIBLE WANT-INVISIBLE ACTIVE_LAST &rest DATA"
  (lyskom-server-call
  (lyskom-call kom-queue lyskom-ref-no handler data
	       'lyskom-parse-dynamic-session-info-list)
  (lyskom-send-packet kom-queue (lyskom-format-objects
				 83 want-visible want-invisible active-last))))


(defun initiate-get-static-session-info (kom-queue handler session-no
						   &rest data)
  "Ask server for info about a session.
Args: KOM-QUEUE HANDLER SESSION-NO &rest DATA"
  (lyskom-server-call
   (let ((info (cache-get-static-session-info session-no)))
     (cond
      ((null info)			; Not cached
       (lyskom-call kom-queue lyskom-ref-no handler data
                    'lyskom-parse-static-session-info session-no)
       (lyskom-send-packet kom-queue (lyskom-format-objects
                                      84 session-no)))
      (t                                ; Cached
       (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) info handler data)
       (lyskom-check-call kom-queue)))))) ;This might call the handler.


(defun initiate-get-collate-table (kom-queue handler &rest data)
  "Get the collate table from the server."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-string)
    (lyskom-send-packet kom-queue (lyskom-format-objects 85))))

(defun initiate-modify-text-info (kom-queue handler 
                                            text-no
                                            delete-items
                                            add-items
                                            &rest data)
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue
                       (lyskom-format-objects 92
                                              text-no
                                              (cons 'LIST delete-items)
                                              (cons 'LIST add-items)))))

(defun initiate-modify-conf-info (kom-queue handler
                                            conf-no
                                            delete-items
                                            add-items
                                            &rest data)
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue 
                       (lyskom-format-objects 93
                                              conf-no
                                              (cons 'LIST delete-items)
                                              (cons 'LIST add-items)))))

(defun initiate-modify-server-info (kom-queue handler 
                                              delete-items
                                              add-items
                                              &rest data)
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue
                       (lyskom-format-objects 95
                                              (cons 'LIST delete-items)
                                              (cons 'LIST add-items)))))

(defun initiate-query-predefined-aux-items (kom-queue handler &rest data)
  "Send query-predefined-aux-items to the server"
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data
                'lyskom-parse-number-array)
   (lyskom-send-packet kom-queue (lyskom-format-objects 96))))

(defun initiate-set-expire (kom-queue handler conf-no expire &rest data)
  "Send set-expire to server."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue (lyskom-format-objects 97 conf-no expire))
   (cache-del-conf-stat conf-no)))

(defun initiate-set-membership-type (kom-queue handler pers-no conf-no type &rest data)
  "Send set-membership-type to the server."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects 102 pers-no conf-no type))))

(defun initiate-local-to-global (kom-queue handler 
                                           conf-no
                                           first-local-no
                                           no-of-texts &rest data)
  "Send local-to-global to server."
  (lyskom-server-call
    (cond ((lyskom-have-call 103)
           (lyskom-call kom-queue lyskom-ref-no handler data
                        'lyskom-parse-text-mapping no-of-texts)
           (lyskom-send-packet kom-queue
                               (lyskom-format-objects 103 
                                                      conf-no
                                                      first-local-no
                                                      no-of-texts)))
          (t (lyskom-call kom-queue lyskom-ref-no 
                          'lyskom-l2g-fake-callback
                          (cons handler data)
                          'lyskom-parse-map)
                 (lyskom-send-packet kom-queue 
                                     (lyskom-format-objects 34 conf-no
                                                            first-local-no
                                                            no-of-texts))))))

(defun lyskom-l2g-fake-callback (map handler &rest data)
  (let ((mapping 
         (and map (lyskom-create-text-mapping (map->first-local map)
                                              (+ (map->first-local map)
                                                 (length (map->text-nos map)))
                                              (length (map->text-nos map))
                                              t
                                              'dense
                                              map))))
    (apply handler mapping data)))

(defun initiate-map-created-texts (kom-queue handler
                                             author
                                             first-local-no
                                             no-of-texts
                                             &rest data)
  "Send map-created-texts to the server."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-text-mappinng no-of-texts)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 104
                                               author
                                               first-local-no
                                               no-of-texts))))



(defun initiate-set-keep-commented (kom-queue handler conf-no keep &rest data)
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue (lyskom-format-objects 105 conf-no keep))
   (cache-del-conf-stat conf-no)))

(defun initiate-set-pers-flags (kom-queue handler pers-no flags &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 106 pers-no flags))
    (cache-del-pers-stat pers-no)))

(defun initiate-mark-as-unread (kom-queue handler conf-no text &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 109 conf-no text))))

(defun initiate-get-stats-description (kom-queue handler &rest data)
  (lyskom-server-call
    (if lyskom-stats-description
        (progn (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) lyskom-stats-description
                                handler data)
          (lyskom-check-call kom-queue))
      (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-stats-description)
      (lyskom-send-packet kom-queue (lyskom-format-objects 111)))))

(defun initiate-get-stats (kom-queue handler what &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-stats-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 112 what))))

(defun initiate-get-boottime-info (kom-queue handler &rest data)
  (lyskom-server-call
    (if lyskom-static-server-info
        (progn (lyskom-call-add kom-queue 'PARSED (lyskom-ref-no) lyskom-static-server-info
                                handler data)
          (lyskom-check-call kom-queue))
      (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-static-server-info)
      (lyskom-send-packet kom-queue (lyskom-format-objects 113)))))

(defun initiate-first-unused-conf-no (kom-queue handler &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 114))))

(defun initiate-first-unused-text-no (kom-queue handler &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 115))))

(defun initiate-find-next-conf-no (kom-queue handler conf-no &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 116 conf-no))))

(defun initiate-find-previous-conf-no (kom-queue handler conf-no &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 117 conf-no))))

(defun initiate-get-scheduling (kom-queue handler session-no &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-scheduling-info)
    (lyskom-send-packet kom-queue (lyskom-format-objects 118 (or session-no 0)))))

(defun initiate-set-scheduling (kom-queue handler session-no priority weight &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 119 (or session-no 0) priority weight))))

(defun initiate-set-connection-time-format (kom-queue handler use-utc &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 120 use-utc))))


;;; ================================================================


;; Blocking reading from server:

(defvar lyskom-blocking-return nil
  "Return from blocking-do.")

(defun blocking-return (retval)
  "Sets blocking variable."
  (setq lyskom-blocking-return retval
	lyskom-ok-to-send-new-calls nil))

(defun blocking-do (command &rest data)
  "Does the COMMAND agains the lyskom-server and returns the result.
COMMAND is one lyskom-command \(like the initiate-* but the initiate- is
stripped. DATA is the args to command.
The cache is consulted when command is get-conf-stat, get-pers-stat
or get-text-stat."
  ;; Here we could check if lyskom-blocking-return is non-nil, in
  ;; which case there is a bug in the code

  (save-excursion
    (set-buffer (or lyskom-buffer
                    (process-buffer lyskom-proc)))
    ;; If this happens, we're in trouble
    (if lyskom-is-parsing
	(lyskom-really-serious-bug))

    (let ((lyskom-blocking-return 'not-yet-gotten))
      ;; This should not be necessary, but for robustness sake...
      ;; There are occasions when it is needed.
      (setq lyskom-ok-to-send-new-calls t)

      (apply (intern-soft (concat "initiate-"
				  (symbol-name command)))
	     'blocking 'blocking-return
	     data)
      (unwind-protect
	  (while (and (eq lyskom-blocking-return 'not-yet-gotten)
		      (memq (process-status lyskom-proc) '(open run))
		      ;; The following test should probably be removed
		      (not lyskom-quit-flag))
	    (lyskom-accept-process-output))
	
	;; OK to continue with prefetch and stuff again
	(setq lyskom-ok-to-send-new-calls t)
	(lyskom-check-output-queues))
      
      (if (or lyskom-quit-flag quit-flag)
          (signal 'quit nil))
      (setq lyskom-quit-flag nil)
      lyskom-blocking-return)))



(defun lyskom-wait-queue (queue)
  "Waits until all data on QUEUE has been processed"
  (save-excursion
    (set-buffer (or lyskom-buffer
                    (process-buffer lyskom-proc)))
    (let ((collector (make-collector)))
      (lyskom-run queue (lambda (c) (set-collector->value c t)) collector)
      (unwind-protect
	  (while (and (null (collector->value collector))
		      (not lyskom-quit-flag))
	    (lyskom-accept-process-output))
	(setq lyskom-ok-to-send-new-calls t)
	(lyskom-check-output-queues))
      (if (or lyskom-quit-flag quit-flag)
	  (progn
	    (lyskom-insert-before-prompt (lyskom-get-string 'interrupted))
	    (signal 'quit nil)))
      (setq lyskom-quit-flag nil)
      (collector->value collector))))


(defvar lyskom-multiple-blocking-return nil
  "Return from blocking-do-multiple")

(defun lyskom-blocking-do-multiple (call-list)
  (save-excursion
    (set-buffer (or lyskom-buffer
                    (process-buffer lyskom-proc)))
    ;; If this happens, we're in trouble
    (if lyskom-is-parsing
	(lyskom-really-serious-bug))
    
    (let ((lyskom-multiple-blocking-return 'not-yet-gotten))
      (setq lyskom-ok-to-send-new-calls t)
      (lyskom-collect 'blocking)
      (while call-list
	(apply (intern-soft (concat "initiate-"
				    (symbol-name (car (car call-list)))))
	       'blocking nil
	       (cdr (car call-list)))
	(setq call-list (cdr call-list)))
      (lyskom-use 'blocking 'lyskom-blocking-do-multiple-1)
      (unwind-protect
	  (while (and (eq lyskom-multiple-blocking-return 'not-yet-gotten)
		      (memq (process-status lyskom-proc) '(open run))
		      (not lyskom-quit-flag))
	    (lyskom-accept-process-output))
	;; OK to continue with prefetch and stuff again
	(setq lyskom-ok-to-send-new-calls t)
	(lyskom-check-output-queues))
      (if lyskom-quit-flag
	  (progn
	    (setq lyskom-quit-flag nil)
	    (lyskom-insert-before-prompt (lyskom-get-string 'interrupted))
	    (signal 'quit nil)))
      lyskom-multiple-blocking-return)))

(defun lyskom-blocking-do-multiple-1 (&rest data)
  (setq lyskom-multiple-blocking-return data
	lyskom-ok-to-send-new-calls nil))

(defun lyskom-cancel-call (queue-name ref-nos)
  "Attempt to cancel calls in queue QUEUE-NAME with ref-no in REF-NOS. 
There is no guarantee that the call will be canceled. In particular, if
the call is not on QUEUE-NAME or has been sent to the server, it will
probably not be canceled."
  (let ((found nil))

    ;; Delete the call from the pending queue

    (let* ((queue (cdr (assq queue-name lyskom-call-data)))
           (calls (and queue (lyskom-queue->all-entries (kom-queue->pending queue)))))
      (when queue
        (lyskom-queue-make-empty (kom-queue->pending queue))
        (lyskom-traverse el calls
          (if (memq (elt el 1) ref-nos)
              (setq found t)
            (lyskom-queue-enter (kom-queue->pending queue) el)))))
    
    ;; Delete the call from the output queue

    (let* ((queue (aref lyskom-output-queues (lyskom-queue-priority queue-name))))
      (when (and queue found)
        (let ((calls (lyskom-queue->all-entries queue)))
          (lyskom-queue-make-empty queue)
          (lyskom-traverse el calls
            (unless (memq (car el) ref-nos)
              (lyskom-queue-enter queue el))))))))

(put 'blocking-do-multiple 'edebug-form-spec '(sexp body))



(eval-and-compile (provide 'lyskom-services))

;;; services.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: parse.el,v 44.59 2004/06/26 13:32:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: parse.el
;;;;
;;;; This file contains functions which parse replies from the
;;;; server. 
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: parse.el,v 44.59 2004/06/26 13:32:32 byers Exp $\n"))


;;; ================================================================
;;;        Errors that are handled of use while parsing


(put 'lyskom-parse-incomplete 'error-conditions
     '(error lyskom-error lyskom-parse-incomplete))
(put 'lyskom-parse-incomplete 'error-message
     "LysKOM internal error: Parse incomplete.")


;;; ================================================================
;;;                  Low-level parsing.


(defun lyskom-string-skip-whitespace (string)
  "Return STRING omitting any leading whitespace."
  (let ((start (string-match "[^ \t\n\r]" string)))
    (cond ((null start) "")
	  (t (substring string start)))))

(defun lyskom-parse-skip-rest-of-token ()
  "Skip to the next whitespace"
  (let ((c (lyskom-parse-char)))
    (while (not (or (= c ?\ ) (= c ?\n)))
      (setq c (lyskom-parse-char)))))

(defun lyskom-parse-nonwhite-char ()
  "Get next character, skipping whitespace, from lyskom-unparsed-buffer and
increase lyskom-parse-pos. Signal lyskom-parse-incomplete if
the buffer lyskom-unparsed-buffer is exhausted."
  (let ((char (lyskom-parse-char)))
    (while (or (= char ?\ )
               (= char ?\n))
      (setq char (lyskom-parse-char)))
    char))

  
(defun lyskom-parse-char ()
  "Get next character from lyskom-unparsed-buffer and increase 
lyskom-parse-pos. Signal lyskom-parse-incomplete if the buffer 
lyskom-unparsed-buffer is exhausted."
  (cond
   ((< lyskom-parse-pos (point-max))
    (prog1 (char-after lyskom-parse-pos)
      (++ lyskom-parse-pos)))
   (t (signal 'lyskom-parse-incomplete nil))))


(defun lyskom-expect-char (char)
  "Read past next non-white character, which must be equal to CHAR.
Return nil, or signal lyskom-protocol-error if the
first non-white character was not equal to CHAR."
  (if (/= char (lyskom-parse-nonwhite-char))
      (lyskom-protocol-error 'lyskom-expect-char
                             "Expecting %S but got %S"
                             char (char-after (1- lyskom-parse-pos)))
    nil))


(defun lyskom-char-p (char)
  "Check if next token is CHAR (a character)."
  (let* ((lyskom-parse-pos lyskom-parse-pos)
         (c (