;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: header.el,v 44.5 2002/04/28 11:50:35 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: header.el
;;;;
;;;; Code that needs to go before everything else
;;;;


;;; Check the version of Emacs when compiling
;;;
;;; If the version of Emacs is too old, signal an error.
;;; We require Gnu Emacs 19.34 or 20.3 or XEmacs 21.1.

(eval-and-compile
  (if (or (not (boundp 'emacs-major-version))
          (not (boundp 'emacs-minor-version))
          (and (string-match "XEmacs" (emacs-version))
               (or (< emacs-major-version 20)
                   (and (= emacs-major-version 20)
                        (< emacs-minor-version 4))
                   (and (= emacs-major-version 21)
                        (< emacs-minor-version 1))))
          (and (not (string-match "XEmacs" (emacs-version)))
               (or (< emacs-major-version 19)
                   (and (= emacs-major-version 19)
                        (< emacs-minor-version 34))
                   (and (= emacs-major-version 20)
                        (< emacs-minor-version 2)))))
      (error "Emacs 19.34, XEmacs 21.1 or later, or Emacs 20.2 or later is required")))

(cond ((or (not (boundp 'emacs-major-version))
           (not (boundp 'emacs-minor-version))
           (< emacs-major-version (eval-when-compile emacs-major-version)))
       (error "LysKOM was compiled for a newer version of Emacs"))
      ((and (eq (eval-when-compile emacs-major-version) 19)
            (> emacs-major-version 19))
       (error "A LysKOM client compiled for Emacs 19 will not run in newer versions of Emacs.")))

;;; Check some basic misfeatures that are still all too common



(eval-and-compile
  (defmacro lyskom-detect-read-kbd-macro-bug ()
    `(and (stringp (read-kbd-macro "<SPC>"))
          (string-equal (read-kbd-macro "<SPC>") "<SPC>")))

  (let ((libraries-to-try '("edmacro")))
    (while libraries-to-try
      (if (lyskom-detect-read-kbd-macro-bug)
          (progn (condition-case nil
                     (load-library (car libraries-to-try))
                   (error nil))
                 (setq libraries-to-try (cdr libraries-to-try)))
        (setq libraries-to-try nil)))

    (if (lyskom-detect-read-kbd-macro-bug)
        (let ((elc-location (locate-library "macedit.elc"))
              (el-location (locate-library "macedit.el"))
              (elz-location (locate-library "macedit.el.gz")))
          (cond ((or el-location elc-location)
                 (message "\

You probably have a file named macedit.elc in Emacs' load path.

This file is included in some versions of the calc package and
is no longer required as the functions that it provides are
also provided by more modern packages.

You will need to remove macedit.el and all references to it
from Emacs. These are the files you need to remove:

%s
To fully remove macedit you will also have to remove any
autoloads that refer to it. These may be found in a file
named auto-autoloads.elc (or auto-autoloads.el), located 
in the same directory as macedit or in a file named
loaddefs.el, located elsewhere.

With Gnu Emacs you may be successful in removing references
by using the command update-autoloads-from-directories.
"
                          (mapconcat (lambda (x) (or x "")) 
                                     (list elc-location el-location elz-location) 
                                     "\n"))
                 (error "Unable to run or compile due to obsolete macedit package."))
                (t
                 (message "\

Your definition of read-kbd-macro appears to be obsolete. This
is usually caused by having a package called macedit in Emacs
load path, but I am unable to find this package. LysKOM cannot
run with your version of read-kbd-macro.
")
                 (error "Unable to run or compile due to obsolete definition of read-kbd-macro.")))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: defvar.el,v 44.15 2002/04/13 15:01:28 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: defvar.el
;;;; Authos: David Byers
;;;;
;;;; This file contains definitions used to define variables
;;;;


(defconst lyskom-clientversion-long 
  "$Id: defvar.el,v 44.15 2002/04/13 15:01:28 byers Exp $\n"
  "Version for every file in the client.")


(provide 'lyskom)

;; Just to get rid of a compiler warning
(defvar kom-dont-read-saved-variables)

(defvar lyskom-local-variables nil
  "List of variables to make local in a LysKOM buffer")

(defvar lyskom-local-hooks nil
  "List of hooks to make local in a LysKOM buffer.")

(defvar lyskom-protected-variables nil
  "List of variables that are protected from kill-buffer")

(defvar lyskom-inherited-variables nil
  "List of variables inherited from the LysKOM buffer")

(defvar lyskom-elisp-variables nil
  "Tells the client what flags and hooks that are to be saved in the server.
These are the flags that are saved in the elisp-client part of the server.")

(defvar lyskom-minibuffer-variables nil
  "These are variables that should be set in the minibuffer by 
lyskom-with-lyskom-minibuffer.")

(defvar lyskom-minibuffer-values nil
  "Dynamic binding of values that minibuffer variables are to take on")


(defmacro lyskom-save-variables (var-list &rest forms)
  "Save the values and property list of symbols in VAR-LIST and execute FORMS
The symbol value, property list and buffer-local property of all variables
is saved before executing FORMS and restored when FORMS have finished."
  (let ((sym1 (make-symbol "lyskom-saved-variables"))
        (sym2 (make-symbol "lyskom-saved-symbols"))
        (sym3 (make-symbol "lyskom-saved-local"))
        (sym4 (make-symbol "lyskom-saved-plist")))
    (` (let* (((, sym2) (quote (, var-list)))
              ((, sym1) (mapcar 'symbol-value (, sym2)))
              ((, sym4) (mapcar 'symbol-plist (, sym2)))
              ((, sym3) (mapcar (function
                                 (lambda (v)
                                   (local-variable-p v (current-buffer))))
                                 (, sym2))))
         (unwind-protect 
             (progn (,@ forms))
           (while (, sym1)
             (if (car (, sym3)) (make-local-variable (car (, sym2))))
             (set (car (, sym2)) (car (, sym1)))
             (setplist (car (, sym2)) (car (, sym4)))
             (setq (, sym1) (cdr (, sym1))
                   (, sym2) (cdr (, sym2))
                   (, sym3) (cdr (, sym3))
                   (, sym4) (cdr (, sym4)))))))))

(put 'lyskom-save-variables 'edebug-form-spec
     '(sexp body))

(defmacro lyskom-with-lyskom-minibuffer (&rest forms)
  "Run FORMS after ensuring that LysKOM minibuffer variables will be set."
  (` (let* ((lyskom-minibuffer-values
             (mapcar 'symbol-value lyskom-minibuffer-variables)))
       (unwind-protect
           (progn
             (add-hook 'minibuffer-setup-hook
                       'lyskom-setup-minibuffer-variables)
             (,@ forms))
         (remove-hook 'minibuffer-setup-hook
                      'lyskom-setup-minibuffer-variables)))))

(put 'lyskom-with-lyskom-minibuffer 'edebug-form-spec
     '(body))


(defun lyskom-setup-minibuffer-variables ()
  (let ((syms lyskom-minibuffer-variables)
        (vals lyskom-minibuffer-values))
    (while syms
      (make-local-variable (car syms))
      (set (car syms) (car vals))
      (setq syms (cdr syms)
            vals (cdr vals)))))

         

(defmacro def-kom-var (name value &rest args)
    "Define a variable with name NAME and initial value VALUE.
Remaining args, ARGS may be
A string        Used as the documentation string for the variable
A symbol        A predefined property of the variable
A list          A widget specification for the variable

Predefined (and tested) properties are the following
server          Save the variable in the elisp block. Implies local.
local           Make the variable buffer-local.
inherited       The variable is inherited from parent buffer. Implies protected
protected       The variable is marked as permanent local. Implies local.
minibuffer      Inherit the variable as a local variable in the minibuffer.
server-hook     A hook stored in the server.
local-hook      A hook variable that is made local in LysKOM buffers.
language-force  A language-variable whose value is to be forced."
          
    (let ((inherited nil)
          (protected nil)
          (elisp-block nil)
          (buffer-local nil)
          (widget-spec nil)
          (doc-string nil)
          (minibuffer nil)
          (local-hook-doc nil)
          (local-var-doc nil)
          (server-doc nil)
          (language-force nil)
          (arglist args))
      (while arglist
        (cond ((stringp (car arglist)) (setq doc-string (car arglist)))
              ((consp (car arglist))
               (setq widget-spec 
                     (` ((setq lyskom-custom-variables
                               (cons  (quote (, (list name
                                                      (car arglist))))
                                      lyskom-custom-variables))))))
              ((symbolp (car arglist))
               (cond ((eq (car arglist) 'server)
                      (setq local-var-doc t server-doc t)
                      (setq elisp-block
                            (` ((if (and (not (memq (quote (, name))
                                                      lyskom-global-boolean-variables))
                                           (not (memq (quote (, name))
                                                      lyskom-global-non-boolean-variables)))
                                           (add-to-list 'lyskom-elisp-variables
                                                        (quote (, name))))
                                      (add-to-list 'lyskom-local-variables
                                                   (quote (, name)))))))

                     ((eq (car arglist) 'server-hook)
                      (setq local-hook-doc t server-doc t)
                      (setq elisp-block
                            (` ((add-to-list 'lyskom-elisp-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-hooks
                                             (quote (, name)))))))

                     ((eq (car arglist) 'protected)
                      (setq local-var-doc t)
                      (setq protected
                            (` ((put (quote (, name)) 'permanent-local t)
                                (add-to-list 'lyskom-protected-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'inherited)
                      (setq local-var-doc t)
                      (setq inherited
                            (` ((add-to-list 'lyskom-inherited-variables
                                             (quote (, name)))
                                (put (quote (, name)) 'permanent-local t)
                                (add-to-list 'lyskom-protected-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'local)
                      (setq local-var-doc t)
                      (setq buffer-local
                            (` ((add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'local-hook)
                      (setq local-hook-doc t)
                      (setq buffer-local
                            (` ((add-to-list 'lyskom-local-hooks
                                             (quote (, name)))))))

                     ((eq (car arglist) 'minibuffer)
                      (setq minibuffer
                            (` ((add-to-list 'lyskom-minibuffer-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'language-force)
                      (setq language-force
                            `((put ',name 'lyskom-language-force t))))

                     (t (error "LysKOM: Unknown variable property: %S"
                               (car arglist)))))
              (t (error "LysKOM: Strange variable argument type: %S" 
                        (car arglist))))
        (setq arglist (cdr arglist)))

      (if doc-string
        (if
          (if (or local-var-doc local-hook-doc)
            (setq doc-string (concat doc-string "\n")))
          (if local-var-doc
            (setq doc-string (concat doc-string "\nThis variable is buffer-local.")))
          (if local-hook-doc
            (setq doc-string (concat doc-string "\nThis variable is a buffer-local hook.")))
          (setq doc-string (concat doc-string "\n\n\
Setting this variable in .emacs may not yield the results you expect
since that will affect all LysKOM sessions."))))

      (if (and doc-string server-doc)
        (setq doc-string (concat doc-string "

This variable is normally stored on a per-session basis in the
LysKOM server, but can be set in your .emacs simply by setting
it using setq or defvar.")))


      (` (progn (dont-compile (if (and (boundp (quote (, name)))
                                       (or (not (boundp lyskom-is-loaded))
                                           (not lyskom-is-loaded))
                                       (listp kom-dont-read-saved-variables))
                                  (add-to-list 'kom-dont-read-saved-variables
                                               (quote (, name)))))
                (defvar (, name) (, value) (, doc-string))
                (,@ (apply 'append
                           (list inherited
                                 protected
                                 elisp-block
                                 buffer-local
                                 minibuffer
                                 widget-spec
                                 language-force
                                 )))))))


(put 'def-kom-var 'edebug-form-spec
     '(&define name form &rest sexp))



(eval-and-compile (provide 'lyskom-defvar))



;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: feature.el,v 1.5 2002/02/28 18:43:13 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: feature.el
;;;;
;;;; Functions for determining if we have a particular feature or not
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: feature.el,v 1.5 2002/02/28 18:43:13 joel Exp $\n"))

(def-kom-var lyskom-feature-defaults nil
  "Alist with default values of all feature variables")

(eval-and-compile
  (defun lyskom-feature-variable (name)
    (intern (format "lyskom-%s-feature-flag" name))))

(defmacro lyskom-define-feature (name default)
  "Define a feature variable NAME with default value DEFAULT"
  `(progn (setq lyskom-feature-defaults 
                (cons (cons ',name ,default) lyskom-feature-defaults))
          (def-kom-var ,(lyskom-feature-variable name) ,default
            "LysKOM feature flag variable."
            inherited minibuffer local)))

(defmacro lyskom-set-feature (name value)
  "Set the value of feature NAME to VALUE"
  `(setq ,(lyskom-feature-variable name) ,value))

(defmacro lyskom-have-feature (name)
  "Return non-nil if feature NAME is non-nil"
  (lyskom-feature-variable name))

(defmacro lyskom-feature-value (name)
  "Return the value of feature NAME"
  (lyskom-feature-variable name))

(defun lyskom-clear-features ()
  "Set the feature variables to their defaults"
  (mapcar (lambda (feature)
            (set (lyskom-feature-variable (car feature)) (cdr feature)))
          lyskom-feature-defaults))

(defun lyskom-list-features ()
  "List all feature values. mapcar ROCKS!"
  (mapcar 'lyskom-insert-before-prompt
          (mapcar (lambda (x) (apply 'format "%S: %S\n" x))
                  (mapcar2 'list
                           (mapcar 'car lyskom-feature-defaults)
                           (mapcar 'symbol-value 
                                   (mapcar 'lyskom-feature-variable
                                           (mapcar 'car lyskom-feature-defaults)))))))

;;; ======================================================================
;;; ======================================================================

;;; Utility functions

(defmacro lyskom-have-call (call-no)
  "Non-nil if call CALL-NO is supported by the server"
  `(<= ,call-no (lyskom-feature-value highest-call)))


;;; ======================================================================
;;; ======================================================================

;;; The features

(lyskom-define-feature bcc-misc nil)
(lyskom-define-feature aux-items nil)
(lyskom-define-feature highest-call 0)
(lyskom-define-feature local-to-global nil)
(lyskom-define-feature dynamic-session-info nil)
(lyskom-define-feature idle-time nil)
(lyskom-define-feature long-conf-types nil)


(provide 'lyskom-feature)
;;;;; -*-coding: raw-text;mode: emacs-lisp;-*-
;;;;; $Id: vars.el.in,v 44.207 2002/09/08 11:13:14 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: vars.el
;;;;
;;;; This file contains almost all the variables used in lyskom.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: vars.el.in,v 44.207 2002/09/08 11:13:14 byers Exp $\n"))

(defvar lyskom-mule-compiled
  (eval-when-compile (and (fboundp 'multibyte-string-p)
                          (multibyte-string-p "")))
  "Non-nil if the client was compiled with multibyte characters enabled")

(provide 'lyskom)

(require 'lyskom-defvar "defvar")

(defconst lyskom-global-boolean-variables '(
  kom-created-texts-are-read
  kom-dashed-lines
  kom-presence-messages
  kom-print-number-of-unread-on-entrance
  kom-read-depth-first
  kom-reading-puts-comments-in-pointers-last
  kom-confirm-multiple-recipients
)
  "List of flags that are to be saved as booleans in the common block.

Don't change these. They are defined by the protocol.")

(defconst lyskom-global-non-boolean-variables '(
  kom-default-mark
)
  "List of flags that are to be saved in the common block.
These are the non-boolean ones. See: lyskom-global-boolean-variables.

Don't change these. They are defined by the protocol.")



(defun lyskom-protect-variable (sym) 
  "Protect SYM from being killed when deleting local variables."
  (put sym 'permanent-local t)
  (lyskom-local-variable sym)
  (add-to-list 'lyskom-protected-variables sym))

(defun lyskom-local-variable (sym)
  "Define SYM as a buffer-local variable"
  (add-to-list 'lyskom-local-variables sym))

(defun lyskom-inherited-variable (sym)
  "Define SYM as a variable that is inherited when creating new buffers.
Inheritance only works with the LysKOM buffer handling functions."
  (add-to-list 'lyskom-inherited-variable sym)
  (lyskom-protect-variable sym))

(defun lyskom-setup-local-variables ()
  "Set up all globally defined local variables in the current buffer."
  (mapcar 'make-local-variable lyskom-local-variables)
  (mapcar 'make-local-hook lyskom-local-hooks))

(defvar lyskom-is-loaded nil
  "Non-nil when lyskom has been loaded.")

(defvar lyskom-have-one-login nil
  "Non-nil after the first login")


(def-kom-var kom-dont-read-saved-variables '(kom-dont-read-saved-variables
                                             lyskom-login-hook)
  "*Non-nil means don't read some variables from the server.
t means don't read any variables. A list means don't read variables that
are in the list.")

(defmacro lyskom-maybe-setq (var value)
  "This is a wrapper around setq that does nothing
if the variable is in kom-dont-read-saved-variables."
  `(cond ((eq kom-dont-read-saved-variables t) nil)
         ((memq ,var kom-dont-read-saved-variables) nil)
         (t (set ,var ,value))))

(defmacro lyskom-maybe-setq-default (var value)
  "This is a wrapper around setq-default that does nothing
if the variable is in kom-dont-read-saved-variables."
  `(cond ((eq kom-dont-read-saved-variables t) nil)
         ((memq ,var kom-dont-read-saved-variables) nil)
         (t (set-default ,var ,value))))


;;;; ================================================================
;;;;                     Variables and constants.


;;; User flags

(defconst lyskom-old-farts-text-prompt-strategy
  '((kom-comment-previous . ((t   . lyskom-get-previous-text)
			     (nil . lyskom-get-previous-text)))
    (t . ((t   . lyskom-get-last-read-text)
	  (nil . lyskom-get-last-read-text)
	  (0   . lyskom-get-text-at-point)
	  (-     lyskom-get-text-above-point (lambda (&optional args) 1))
	  (listp . lyskom-prompt-for-text-no)
	  (lyskom-plusp . lyskom-get-explicit-text)
	  (lyskom-minusp  lyskom-get-text-above-point abs))))
"Put in your `kom-pick-text-no-strategy-alist' to get the 0.46 behaviour:
 * No prefix argument refers to the most recently read text.
 * The prefix argument zero refers to the text under point.
 * A positive prefix argument is interpreted as a text-no.
 * A negative prefix argument will try to find the text-no
   of the text `arg' messages above point from the current
   kom buffer.")

(def-kom-var kom-pick-text-no-strategy-alist
      '((kom-comment-previous . ((t   . lyskom-get-previous-text)
				 (nil . lyskom-get-previous-text)))
        (kom-private-answer-previous . ((t   . lyskom-get-previous-text)
                                        (nil . lyskom-get-previous-text)))
	(t . ((t   . lyskom-get-text-at-point) ; default for prompts
	      (nil . lyskom-get-text-at-point) ; no prefix arg
	      (0   . lyskom-prompt-for-text-no)
	      (-     lyskom-get-text-above-point (lambda (&optional arg) 1))
	      (listp lyskom-get-text-at-point-ancestor
		     (lambda (arg) (/ (logb (car arg)) 2)))
	      (lyskom-plusp . lyskom-get-text-below-point)
	      (lyskom-minusp  lyskom-get-text-above-point abs))))
      "Defines how prefix arguments are used to find a text-no to operate on.
The cars on the list are either one of the functions which invokes
`lyskom-read-text-no-prefix-arg' (typically the one of the kom-* functions),
or the value t for the strategy common to all such functions. For functions in
the list, the strategy is chosen from the cdr of that entry and, if and when
no matching rule was found that way, from the common strategy.

Each cdr on the list is an alist specifying when to do how when mapping a
prefix argument to a text-no.

The cars on this alist are the predicates for which the cdrs map functions that
retrieve the text-no to operate on. Each predicate is tested in turn on the
prefix argument, and when one returns non-nil, the cdr gets invoked, until the
list is empty or one cdr returned some non-nil value, whichever comes first. If
you like, the cars can also be the actual prefix-arg values (-, 0 or nil, for
example) that you want to invoke some special rule for. The value t means that
the behaviour given by the cdr stipulates the DEFAULT value for the prompt,
when one is shown.

The cdrs on the list may be either of:

* a function, in which case it gets called with four parameters: the prefix
  argument, the PROMPT that would be used to ask the user for a text-no, a
  (possibly nil) DEFAULT choice for that prompt, and a CONSTRAINT value, all
  as provided in the call to `lyskom-read-text-no-prefix-arg' (see its docs)
  Returning a positive integer means return that text-no. Returning a common
  lyskom format string aborts, showing your helpful error description. A nil
  return value means try successive rules instead to get a text-no.

* a list of two functions, optionally followed by additional list items,
  in which case the second function is called to change the prefix argument
  parameter for the first function, which is then called as above. Any extra
  items on the argument list will be appended to its argument list. Hence, a
  '(my-get-text-no abs 17 4711) entry would result in a my-get-text-no call
  (funcall my-get-text-no (abs prefix-arg) prompt default nil 17 4711)."
  )


(def-kom-var kom-keyboard-menu-immediate-selection nil
  "*When non-nil, typing a keyboard shortcut in a keyboard menu selects
the item immediately, without requiring the user to press RET to confirm."
  server)


(def-kom-var kom-edit-hide-add-button nil
  "*If non-nil, hide the add button shown after the headers when editing
a text."
  server
)

(def-kom-var kom-max-overlays 120
  "*Maximum number of overlays to use to highlight texts.
Each text uses one, two, three or four overlays, depending on settings.
Must be a positive integer or nil. If nil, the number of overlays will
be unlimited. Behavior of non-positive and non-nil values is undefined."
  server
)

(def-kom-var kom-highlight-text-body t
  "*If t, overlay kom-text-body-face on printed text bodies in LysKOM.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-highlight-first-line t
  "*If t, overlay kom-first-line-face on the first header line of texts.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-highlight-dashed-lines t
  "*If t, overlay kom-dashed-lines-face on the lines surrounding texts.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-async-highlight-text-body t
  "*If t, overlay kom-text-body-face on asynchronous messages in LysKOM.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-async-highlight-dashed-lines t
  "*If t, overlay kom-dashed-lines-face on the lines surrounding messages.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-extended-status-information nil
  "*If t, list extended status information for all objects in LysKOM.
Extended status information include such information as read FAQs.
Values other than t or nil are reserved for future extensions."
  server
)

(def-kom-var kom-auto-list-faqs t
  "*If non-nil, list unread FAQs when entering a conference or logging
on to the server."
  server
)

(def-kom-var kom-auto-review-faqs t
  "*If non-nil, automatically review unread FAQs when entering a
conference or logging on to the server."
  server
)

(def-kom-var kom-allow-incompleteness nil
  "*If nil, commands like kom-list-news will wait for the prefetch.
If this flag is set to t, some commands may give incomplete answers,
but it might make them faster, especially during the login phase."
  server
)

(def-kom-var kom-bury-buffers t
  "*Controls the behaviour of kom-next-kom and its cousins.
If this variable is non-nil the current buffer is sent to the back
of the buffer list when one of the commands `kom-next-kom',
`kom-previous-kom' or `kom-next-unread-kom' is invoked."
  server)

(def-kom-var kom-write-texts-in-window nil
  "*Where to edit texts. One of nil, 'other, 'new-frame, 'other-frame, a string
or a buffer.

nil means edit texts in the same window as the LysKOM buffer.
'other means edit in another window, creating it if necessary.
'other-frame means edit in another frame, if there is one.
'new-frame means create a new frame for editing. The frame will be removed 
          when editing is finished.
A string or buffer means edit in the indicated buffer."
  server)

(def-kom-var kom-view-commented-in-window 'other
  "*Where to view commented texts. See kom-write-texts-in-window for details."
  server)

(def-kom-var kom-edit-filters-in-window nil
  "*Where to edit filters. See kom-write-texts-in-window for
more information."
  server)

(def-kom-var kom-list-membership-in-window 'other
  "*Where to list membership. See kom-write-texts-in-window for
more information."
  server)

(def-kom-var kom-personal-messages-in-window 'other
  "*Where to display personal messages. See kom-write-texts-in-window 
for more information."
  server)

(def-kom-var kom-customize-format 'long
  "*Format of the customize buffer. Must be long or short."
  server)

(def-kom-var kom-user-prompt-format "%[%c% %m%] - "
  "*Format of LysKOM prompt when waiting for input."
  server)


(def-kom-var kom-user-prompt-format-executing "%[%c% %m%]."
  "*Format of LysKOM prompt when executing a default command"
  server)


(def-kom-var kom-enabled-prompt-format "%[%c% %m%] # "
  "*Format of LysKOM prompt when in enabled mode."
  server)


(def-kom-var kom-enabled-prompt-format-executing "%[%c% %m%]."
  "*Format of LysKOM prompt when executing a default command in 
enabled mode."
  server)

(def-kom-var kom-anonymous-prompt-format "%[%c% %m%] (%a) - "
  "*Format of the LysKOM prompt when running anonymously."
  server)

(def-kom-var kom-anonymous-prompt-format-executing "%[%c% %m%] (%a)."
  "*Format of the LysKOM prompt when executing a command anonymously."
  server)

(def-kom-var kom-show-week-number t
  "*If non-nil show the ISO week number when displaying the time."
  server)


(def-kom-var kom-cite-string ">"
  "*String to insert before each line of a commented text."
  server)

(def-kom-var kom-created-texts-are-saved nil
  "*If non-nil, save all created texts to a file. 
The value of this variable is the file name on which to save new texts."
  server
  inherited)

(def-kom-var kom-created-texts-are-read t
  "*Non-nil means automatically mark texts that you create as read."
  server)

(def-kom-var kom-customize-in-window nil
  "*Where to customize LysKOM. See kom-write-texts-in-window."
  server)

(def-kom-var kom-prioritize-in-window nil
  "*Where to prioritize conferences. See kom-write-texts-in-window."
  server)

(def-kom-var kom-default-mark nil
  "*If non-nil (must be an integer), the user is not asked for type of mark."
  server)

(def-kom-var kom-symbolic-marks-alist '(("Standard" . 100))
  "*Assoc list which maps symbolic mark strings to mark numbers."
  server)

(def-kom-var kom-reading-puts-comments-in-pointers-last t
  "*If non-nil, the texts are shown with comment references at the end."
  server
  inherited)

(def-kom-var kom-review-uses-cache t
  "*If non-nil, review commands don't use the cache."
  server
  inherited)

(def-kom-var kom-review-marks-texts-as-read nil
  "*If non-nil, review commands mark the reviewed texts as read."
  server
  inherited)

(def-kom-var kom-postpone-default 17
  "*The number of articles to postpone by default."
  server)


(def-kom-var kom-dashed-lines t
  "*If non-nil, all texts will be surrounded by lines of dashes."
  server
  inherited)

(def-kom-var kom-long-lines nil
  "*If non-nil, some lines and borders will be made longer."
  server
  inherited)

(def-kom-var kom-text-footer-dash-length 52
  "*If non-nil, the total length of the text footer, when dashes are in use.
Note that the footer may end up longer than this if one or more elements
together are longer than this length.

This length is currently ignored when kom-text-footer-format is used."
  server
  inherited)

(def-kom-var kom-text-header-dash-length 60
  "*If non-nil, the total length of the dashes before a text body.
If kom-dashed-lines is non-nil, this is ignored."
  server
  inherited)



(def-kom-var kom-text-footer-format nil
  "*If non-nil, this specifies the format of a text footer.

The following format directives are legal:

    %n      The text number.
    %p      The number of the author.
    %P      The name of the author
    %-      A bunch of dashes
    %f      Information about the text in parentheses.

Format letters can be prefixed with a number specifying the minimum
field width. The field width can be prefixed with an equals sign which
means that the field is exactly as wide as specified (contents may be
truncated). A negative field width means left justify the contents.

The field width of %- is special. It specifies the maximum number of
dashes printed. The actual number will be the maximum minus the
length of the author's name, if it is included anywhere in the format
string.

When set, this variable overrides kom-dashed-lines and
kom-show-author-at-end.

The default format is equivalent to the following strings, depending on 
the settings of kom-dashed-lines and kom-show-author-at-end.

kom-dashed-lines    kom-show-author-at-end      Format
t                   t                           \"(%n) /%P/%42-%f\"
t                   nil                         \"(%n) %42-%f\"
nil                 t                           \"(%n) /%P/ %f\"
nil                 nil                         \"(%n) %f\"
"
  server
  inherited)



(def-kom-var kom-show-creating-software nil
  "*If non-nil, show the creating software of each text, if specified."
  server
  inherited)

(def-kom-var kom-show-author-at-end t
  "*If non-nil, the author will be shown at the end of each text."
  server
  inherited)

(def-kom-var kom-truncate-threshold nil
  "*If non-nil, truncate long texts when reviewing.
If the text is longer (in lines), the threshold it will be
truncated to `kom-truncate-show-lines' length."
  server)

(def-kom-var kom-truncate-show-lines 10
  "*How many lines to show after truncating.
If the text is truncated by `kom-truncate-threshold', show this many
lines.  If this is greater than the threshold, the threshold will be
used."
  server)


(def-kom-var kom-print-number-of-unread-on-entrance t
  "*If non-nil, print automatically the number of unread articles when
entering a conference."
  server)

(def-kom-var kom-show-unread-in-frame-title t
  "*If non-nil, show an unread indicator in the frame title of each
LysKOM session."
  server)

;; In the common block of the user-area is a simple boolean variable
;; `presence-messages'.  The control of presence messages in the Emacs
;; Lisp client is more advanced, using two non-boolean variables instead
;; (`kom-presence-messages-in-echo' and `kom-presence-messages-in-buffer').
;;
;; Keep track of the common block variable too, although it isn't used here.
;; `lyskom-save-options' sets it before saving it in obvious cases,
;; but generally it's not possible to know what value it should have.
;; (It could also be used for default values for the presence options for
;; users converting from another client, but that isn't done.)

(def-kom-var kom-presence-messages t
  "Equivalent of the variable `presence-messages' in the user-area.
This is a boolean where other clients may store whether the user wants
messages about people logging in and out of LysKOM.  Here this is instead
controlled by `kom-presence-messages-in-echo-area' and
`kom-presence-messages-in-buffer', so only use this variable to
influence what this client stores in the common block of the user-area."
  server)

(def-kom-var kom-presence-messages-in-echo-area t
  "*If non-nil, LysKOM prints continuous info about what other people are doing.
Info is printed on the echo area and never in the buffer. If minibuffer is
used, no message is printed.

A list of integers means show messages for those users.

The value 'friends means show messages for the users in kom-friends.

The value 'morons means show messages for the users in kom-morons.

The value 'friends-and-morons means show messages for the users in 
kom-friends and kom-morons.

If you want the messages in the buffer, you could set the variable 
kom-presence-messages-in-buffer."
  server)



(def-kom-var kom-presence-messages-in-buffer nil
  "*If non-nil, LysKOM prints information about what other people are doing in the buffer.
All printing is done just before the prompt.

If nil no messages are printed.
If 'presence, messages about people logging in, out and people 
changing name are printed."
  server)

(def-kom-var kom-show-where-and-what t
  "*Non-nil means kom-who-is-on shows from which machine the user is running
and what he is doing."
  server)

(def-kom-var kom-show-since-and-when nil
  "*Non-nil means kom-who-is-on shows when the user connected and when
he last was active."
  server)

(def-kom-var kom-idle-hide 30
  "*The number of minutes of idle-time before a user is excluded from the list
of users. This can be overridden by a prefix argument to `kom-who-is-on'."
  server)

(def-kom-var kom-show-footnotes-immediately t
  "*Non-nil means show footnotes immediately following the text."
  server)

(def-kom-var kom-follow-comments-outside-membership nil
  "*Show comments in conferences you are not a member of.

If this variable is nil, texts with no recipient you are a member of
will not be shown."
  server)

(def-kom-var kom-follow-attachments t
  "*Follow attachments as if they are regular comments."
  server)

;;(def-kom-var kom-who-buffer-size-when-displaying 10
;;  "Size of window to display the who-buffer.
;;This is used when executing the kom-display-who-buffer command."
;;  server)

(def-kom-var kom-read-depth-first t
  "*Non-nil means read comments and footnotes to a text before other texts."
  server)

(def-kom-var kom-continuous-scrolling t
  "*Non-nil means scroll LysKOM window as text is inserted. The last viewed
position (generally the most recent prompt) will always be visible."
  server)


;; Should this be set to nil if baud-rate is low?
(def-kom-var kom-deferred-printing t
  "*Non-nil means delay printing of some information not in the cache.
You might want to turn this off to have the old, linear behaviour."
  server)

(def-kom-var lyskom-overlay-pool nil  
  "Pool of overlays"
  local)

(def-kom-var lyskom-defer-indicator "[...]"
  "String to display while LysKOM is waiting for the real string.")

(def-kom-var kom-review-priority nil
  "*If non-nil, the priority to use when reviewing texts. Set this to
255 or higher to avoid texts and conferences with higher priority to
break in while reviewing."
  server)

(def-kom-var kom-higher-priority-breaks nil
  "*Non-nil means allow texts from conferences with higher priority to break in.
If the value is 'express, texts are allowed to break in the middle of a
comment chain. Otherwise we don't let them in until the end of the comment
tree."
  server)

(def-kom-var kom-server-priority-breaks nil
  "*Non-nil means allow servers with a higher priority to break in.
Valid values are 'express, 'express-letters, 'letters, 'after-conf, 
'after-conf-letters, t and 'when-done.

'express means break immediately when a text arrives in a prioritized
session.

'express-letters means break immediately when a letter arrives in a 
prioritized session.

t means break after the current comment chain when a text arrives in 
a prioritized session.

'letters means break after the current comment chain when a letter
arrives in a prioritized session.

'after-conf means break after the current conference when a text
arrives in a prioritized session.

'after-conf-letters means break after the current conference when a
letter arrives in a prioritized session.

'when-done means prompt user to go to the next session with unreads
after everything has been read. This overrides kom-do-when-done as
long as there are sessions with unread texts.
"
  server)

(def-kom-var kom-view-text-hook nil
  "*Hook that is called before a text is shown. When the hooks are
called, kom-view-text-text is bound to the text mass of the 
text and kom-view-text-text-stat to the text-stat of the text
to be shown."
  local-hook)

(def-kom-var lyskom-view-text-hook nil
  "Obsolete synonym for kom-view-text-hook."
  local-hook)


(def-kom-var lyskom-send-message-hook nil
  "*Obsolete synonym for lyskom-send-message-hook."
  local-hook)

(def-kom-var kom-send-message-hook '(lyskom-send-message-trim-newlines)
  "*Hook that is called before a personal, group or common message is sent. 

When called, lyskom-message-string is bound to the message that will be sent
and lyskom-message-recipient to the conf-stat of the recipient or nil if
the recipient does not exist or if the message is a common message.

If lyskom-message-string is set to nil by a hook, the message will not
be sent."
  local-hook)

(def-kom-var kom-send-message-setup-hook nil
  "*Hook that is called when the minibuffer is entered to read a message."
  local-hook)

(def-kom-var lyskom-send-message-setup-hook nil
  "*Obsolete synonym for kom-send-message-setup-hook."
  local-hook)

(def-kom-var kom-send-message-exit-hook nil
  "*Hook that is called when the minibuffer is exited after reading a message."
  local-hook)

(def-kom-var lyskom-send-message-exit-hook nil
  "*Obsolete synonym for kom-send-message-exit-hook."
  local-hook)

(def-kom-var kom-send-text-hook nil
  "*Hook that is called before sending a text. Hook functions return t to
signal success and nil to prevent the text from being sent."
  local-hook)

(def-kom-var lyskom-send-text-hook nil
  "*Obsolete synonym for kom-send-text-hook."
  local-hook)

(def-kom-var kom-after-load-hook nil
  "*Hook to run once after LysKOM is loaded.")

(def-kom-var lyskom-after-load-hook nil
  "*Obsolete synonym for kom-after-load-hook.")

(def-kom-var kom-change-conf-hook nil
  "*Hook to run when changing conferences.
The functions in this list are run with two arguments. The first is the 
current conf-no and the second is the conf-no being changed to.

This hook is run before lyskom-current-conf is changed, and before any
standard messages have been printed."
  local-hook)

(def-kom-var lyskom-change-conf-hook nil
  "*Obsolete synonym for kom-change-conf-hook"
  local-hook)

(def-kom-var kom-after-change-conf-hook nil
  "*Hook to run when changing conferences.
The functions in this list are run with two arguments. The first is the 
current conf-no and the second is the conf-no being changed to.

This hook is run after lyskom-current-conf is changed, and after any
standard messages have been printed."
  local-hook)

(def-kom-var lyskom-after-change-conf-hook nil
  "*Obsolete synonym for kom-after-change-conf-hook."
  local-hook)

(def-kom-var lyskom-login-hook nil
  "*What to do when logged in.
This hook is called after we have logged in but before any command is
accepted from the keyboard. It is called immediately before
kom-login-hook."
  local-hook)

(def-kom-var kom-login-hook nil
  "*What to do when logged in.
This is a list of commands that are executed after we have logged in but before
any command is accepted from the keyboard. See also lyskom-login-hook."
  server)

(def-kom-var kom-confirm-add-recipients t
  "*When non-nil, offer to add cc-recipient instead of full recipient."
  server)


(def-kom-var kom-do-when-done '(kom-review-all-marked-texts kom-display-time)
  "*What to do when all texts are read.
This is a list of commands and lists of commands that are prompted for
and executed when there are no more new texts.  The last element in
the list is the one that will never be removed from the list.
A command can be one of:

type			prompt
------------------------------
lyskom-function		from the lyskom-command-name function
command			\"Command:\" (name of function or definition of
			lambda expression)
keyboard macro		\"Command:\" (keyboard macro definition)"
  server)

(def-kom-var kom-page-before-command nil
  "*This is a list of all commands before which the screen is cleared.
If it isn't a list and isn't nil the screen is cleared before all commands."
  server)

(def-kom-var kom-permissive-completion t
  "*If t, completion on logged-in persons will usually also include
persons who are not logged in. Values other than t or nil are reserved
for future use."
  server)

(def-kom-var kom-unsubscribe-makes-passive t
  "*If non-nil subtracting oneself from a conference makes the membership
passive. A second leave will actually remove the membership."
  server)

(def-kom-var kom-membership-default-priority 'ask
  "*Default priority when joining a new conference.
If a valid priority then new conferences are read with this priority. 
Otherwise ask the user for a priority.

Valid priorities are only the range 0-255."
  server)

(def-kom-var kom-membership-default-placement 'last
  "*Tells the system where to put new conferences.
The value can be one of the following:
'first => before all other conferences.
'last => after all other conferences.
a number => at that position
otherwise => the new conference is entered after all conferences."
  server)

(def-kom-var lyskom-current-prompt nil
  "The current prompt or nil.
This is either nil, indicating that there is currently no prompt, or
a symbol indicating which command is prompted in the LysKOM buffer."
  local)

(def-kom-var lyskom-current-prompt-text nil
  "The current prompt text or nil.
This is either nil, indicating that there is currently no prompt, or
a string indicating the prompt shown in the LysKOM buffer."
  local)

(def-kom-var lyskom-current-prompt-args nil
  "The current prompt arguments.
These are arguments used to format the current prompt."
  local)

(def-kom-var lyskom-current-prompt-timestamp nil
  "The creationtime of the current prompt.
This is used when updating the prompt and on lyskom-start-of-command."
  local)

(def-kom-var lyskom-need-prompt-update nil
  "Non-nil if all prompts need to be updated."
  local)

(def-kom-var kom-show-personal-messages-in-buffer t
  "*Buffer to show personal messages in.
If nil, discard them.
If t, insert them in the *kom* buffert.
If non-nil and non-t this should be a buffer or a name of a (possibly
nonexistent) buffer in which the message is inserted."
  server)

(def-kom-var kom-pop-personal-messages nil
  "*Non-nil means pop up a buffer with personal messages as they arrive.
kom-show-personal-messages-in-buffer decides which buffer to pop."
  server)

(def-kom-var kom-ding-pause-amount 0.1
  "*Amount of time to wait between successive beeps.")

(def-kom-var kom-ding-on-new-letter nil
  "*Non-nil means ding if a message arrives in the letter box. See 
kom-ding-on-priority-break for valid values."
  server)


(def-kom-var kom-ding-on-priority-break 1
  "*Non-nil means ding if a higher priority text or conference breaks in.
A number means the number of times to ding. A string is an argument for the
program named by kom-audio-player."
  server)

(def-kom-var kom-ding-on-wait-done 1
  "*Non-nil means ding when busy-waiting finishes.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as a 
function to call."
  server)

(def-kom-var kom-ding-on-common-messages 0
  "*Non-nil means ding as alarm messages arrive. 
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the sender identity. The corresponding VALUE is used as the
specification on how to beep."
  server)

(def-kom-var kom-ding-on-group-messages 1
  "*Non-nil means ding as group messages arrive.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the recipient identity. The corresponding VALUE is used as the
specification on how to beep."
  server)

(def-kom-var kom-ding-on-personal-messages 2
  "*Non-nil means ding as personal messages arrive.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the sender identity. The corresponding VALUE is used as the
specification on how to beep."
  server)


(def-kom-var kom-ding-on-no-subject 2
  "*How to ding if the user has not entered a subject line.
A number means the number of times to ding. A string is an argument for the
program named by kom-audio-player. A symbol is interpreted as a function 
to call."
  server)


(def-kom-var kom-audio-player "audioplay"
  "*Program to play audio files."
  server)


(def-kom-var kom-ignore-message-senders nil
  "*List of senders whose personal, group and alarm messages are ignored."
  server)

(def-kom-var kom-ignore-message-recipients nil
  "*List of recipients you do not want group messages to."
  server)

(def-kom-var kom-show-personal-message-date t
  "*Show date on personal messages is non-nil."
  server)

(def-kom-var kom-default-message-recipient 'group
  "*Determines default recipient of personal messages.

'everybody means the default recipient is everybody.
'group     means the default recipient is the group to which the last
           message was sent, if it was a group message. If the last message
           was a personal message or a common message, it means the same as 
           'sender. 
'sender    means the sender of the last message received."
  server)


(def-kom-var kom-filter-outgoing-messages t
  "*t if outgoing remote-control messages and automatic replies are not
to be displayed in the buffer."
  server)


(def-kom-var kom-friends nil
  "*List of people whose names should be formatted using kom-friends-face.
Also used in kom-who-is-on-and-friend. This is a list of integers (person
numbers)."
  server)

(def-kom-var kom-morons nil
  "*List of people whose names should be formatted using kom-morons-face."
  server)

(def-kom-var kom-dont-check-commented-authors nil
  "*List of recipients who do not need to be added to comments that they
might not see. Typically this list consists of import agents."
  server
  inherited)

(def-kom-var kom-default-face-scheme nil  
  "*Face scheme to use per default for new logins.")

(def-kom-var kom-smileys t
  "*Non-nil means to reformat smileys in text."
  server)

(def-kom-var kom-text-properties t
  "*Non-nil means to insert text properties in the Emacs buffer for
various LysKOM elements.")

(def-kom-var kom-use-button-hints t
  "*Non-nil means use button hints for overriding default actions.")

(def-kom-var kom-autowrap t
  "*Non-nil means auto wrap articles with discretion.
A number means wrap articles shorter than the number (in bytes)."
  server)

(def-kom-var kom-keep-alive-interval 180
  "*The number of seconds between periodic requests used to keep the session alive"
  server)

(defvar lyskom-transforming-external-text nil
  "Dynamically bound to non-nil when transforming text in which text,
conference and person buttons are not expected.")

(def-kom-var lyskom-url-protocol-regexp
  "\\(file\\|ftp\\|gopher\\|http\\|https\\|news\\|wais\\|mailto\\|telnet\\):"
  "Regexp to match the protocol part of a URL.")

(def-kom-var lyskom-text-buttons
  '(
    ;; Text numbers
    ("\\(\\<[0-9][0-9][0-9][0-9]\\([0-9]\\)?\\([0-9]\\)?\\([0-9]\\)?\\>\\)" 
                                        ; Match
     text                               ; Button type
     0                                  ; Portion that's a button
     1                                  ; Portion that's the arg
     nil                                ; Face or nil (=default)
     )

    ;; Email

    ("\\(\\b\\|^\\)[^()<>@,;:\"\\\\\000- ]+@[^\000- <>;,.'\"!:?) \t\012\014]+\\(\\.[^\000- <>;,.'\"!:?)]+\\)+"
     email 0 0 kom-url-face)

    ;; URLs

    ("\\b\\(www\\|ftp\\|home\\)\\.[^\t \012\014\"<>|\\]*[^][\t \012\014\"<>|.,!(){}?'`:;]" 
     pseudo-url 0 nil kom-url-face)

    ("\\(file://\\|ftp://\\|gopher://\\|http://\\|https://\\|news:\\|wais://\\|mailto:\\|telnet:\\)[^\t \012\014\"<>|\\]*[^][\t \012\014\"<>|.,!(){}?'`:;]" 
     url 0 nil kom-url-face)
    ("<URL:\\s-*\\([^>]*\\)\\s-*>"
     url 1 1 kom-url-face)

    ;; JySKom enhancements

    ("<(?m[|]te[ \t\n]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     conf 0 1 nil)
    ("<(?text[ \t\n]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     text 0 1 nil)
    ("<(?person[ \t\n]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     pers 0 1 nil)

    ;; Info node reference

    ("\\*Note[ \n\t]+\\([^:\n]*\\(\n[^:\n]*\\)?\\):\\s-*\\(\\(([^\)]+)\\)?[^.,\t\n]*\\(\n[^.,\t\n]*\\)?\\)[.,\t]" 
     info-node 1 3 kom-url-face)

    )
  "List of buttons to install in the text mass of LysKOM objects. Each element is
a list consisting of REGEXP TYPE BUTTON-MATCH BUTTON-ARG-MATCH FACE.
REGEXP is the regexp to look for in the text.
TYPE is the button type. Valid button types are defined in lyskom-button-actions.
BUTTON-MATCH is the number of the parenthesized expression that is the actual button.
BUTTON-ARG-MATCH is the number of the expression to be used as the button argument.
FACE is the text face to apply to the button, or nil to use the default face.")

(def-kom-var kom-url-viewer-preferences '("emacs"
                                          "windows"
                                          "w3")

  "*LysKOM will attempt to use URL viewers in the order specified here.
kom-url-managers is a list of all available viewers. Note that the elements
are all strings.

When you select a URL, this list is used to determine which URL
viewer to use in the following manner: Each element is in turn matched
against the manager regexp for each manager in kom-url-managers, and the
first manager found that matches is used to display the URL.

See kom-url-managers for a list of all available URL viewers. See
kom-netscape-command and kom-mosaic-command for information specific 
to some URL viewers."
  server)


(def-kom-var kom-url-managers '(("default"
                            ".*"
                            "Browse-URL"
                            lyskom-view-url-browse-url)
                           ("w3" 
			    "\\(http\\|gopher\\|ftp\\)"
			    "Emacs W3" 
			    lyskom-view-url-w3)
                           ("windows"
                            ".*"
                            "web browser"
                            lyskom-view-url-windows)
			   ("netscape"
			    ".*"
			    "Netscape Navigator/Mozilla"
			    lyskom-view-url-netscape)
			   ("\\(emacs\\|dired\\)"
			    "\\(ftp\\|file\\)"
			    "dired"
			    lyskom-view-url-dired)
			   ("\\(emacs\\|telnet-mode\\)"
			    "telnet"
			    "emacs telnet"
			    lyskom-view-url-telnet)
			   ("\\(emacs\\|mail-mode\\)"
			    "mailto"
			    "mail-mode"
			    lyskom-view-url-mailmode)
			   ("mosaic"
			    "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
			    "NCSA Mosaic"
			    lyskom-view-url-mosaic)
			   ("lynx"
			    "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
			    "Lynx"
			    lyskom-view-url-lynx)
			   ("galeon"
			    "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
			    "Galeon"
			    lyskom-view-url-galeon))

  "List of URL managers. Each element is a list consisting of
(MANAGER-REGEXP PROTOCOLS NAME VIEW-FUNCTION). When LysKOM attempts to
view a URL, kom-url-viewer-preferences is scanned, and the URL
-manager whose MANAGER-REGEXP first matches an element in
kom-url-viewer-preferences and whose PROTOCOLS matches the protocol of
the selected URL is used to view the URL by calling its VIEW-FUNCTION
with the URL and the manager entry as arguments.")

(def-kom-var kom-windows-browser-command ""
  "*Program to run to open a URL in Windows. If it is the empty
string, a couple of commands that are likely the work on Windows will
be tried."
  server)

(def-kom-var kom-mosaic-command "/usr/local/bin/mosaic"
  "*Command to run to start Mosaic."
  server)

(def-kom-var kom-netscape-command "netscape"
  "*Command to run to start Netscape or Mozilla.

If a string, it should be a command that starts Netscape or Mozilla 
with no arguments. If a list, the first element must be a command 
that starts Netscape. The remaining elements are used as arguments 
to Netscape.

For instance, a value of \"netscape\" is valid, but \"netscape -d host:0\"
is not. Instead, the latter should be \(\"netscape\" \"-d\" \"host:0\"\)"
  server)

(def-kom-var kom-galeon-command "galeon"
  "*Command to run to start Galeon.

If a string, it should be a command that starts Galeon with no
arguments. If a list, the first element must be a command that starts
Galeon. The remaining elements are used as arguments to Galeon.

For instance, a value of \"galeon\" is valid, but \"galeon --display host:0\"
is not. Instead, the latter should be \(\"galeon\" \"--display\" \"host:0\"\)"
  server)

(def-kom-var kom-lynx-terminal 'xterm
  "*Where to start Lynx.
Valid values are 'xterm (start Lynx in an xterm) and 'terminal (start
Lynx in Emacs terminal mode).")

(def-kom-var kom-lynx-xterm-command
  '("xterm" "-geometry" "90x50+100+100" "-e" "lynx")
  "*Command to run to start Lynx in an xterm.
Must be a list of strings, where the first element is the name of the
xterm program, and the remaining elements are arguments to the
xterm. The last elements should be \"-e\" \"lynx\", or something similar,
to start Lynx.")

(def-kom-var kom-lynx-terminal-command "lynx"
  "*Command to run Lynx in Emacs terminal mode.

This can be either a string, to start Lynx with no arguments, or a
list of strings, where the first element is the command, and the rest
are arguments to Lynx.")

(def-kom-var kom-confirm-multiple-recipients 'after
  "*Non-nil means ask the user for confirmation about recipients.
When the user writes a comment to a text with more than one recipient
he gets a y-or-n-p question for all recipients. 'before means check
before opening the edit buffer. Anything else means check before
sending the article."
  server)

(def-kom-var kom-check-for-new-comments t
  "*Non-nil means check that no new comments have been written to a commented
texts since the last check. A list means check in all conferences except
those listed. A function means call the function and check if non-nil is
returned. The function is called with the commented text's text-stat as
an argument."
  server)

(def-kom-var kom-check-commented-author-membership t
  "*Non-nil means check that the authors of the commented texts are
members of at least one of the recipient conferences. If not, offer to
add them as recipients."
  server)

(def-kom-var kom-inhibit-typeahead nil
  "*If non-nil, discard keyboard input that arrives while a LysKOM command is
executing. "
  server)

(def-kom-var kom-max-buffer-size nil
  "*If non-nil, ensure that buffers won't grow any larger than this."
  server)

(def-kom-var kom-print-relative-dates t
  "*If non-nil, print today's and yesterday's date as \"today\" and
\"yesterday\" (respectively) in some places instead of the default,
numeric format."
  server)

(def-kom-var kom-print-seconds-in-time-strings nil
  "*If non-nil, include seconds, minutes and hours when printing
time in some places. If nil, only include minutes and hours."
  server)

(def-kom-var kom-show-namedays nil
  "*Non-nil means display namedays when running in Swedish.
This variable will eventually be replaced with something else."
  server)

(def-kom-var kom-ssh-relay-host nil
  "*Host to which the session is to be tunneled through ssh through.
For this to work, ssh to the host must succeed without asking for a
password or passphrase.

Note: Storing this variable in the LysKOM server makes no sense.")

(def-kom-var lyskom-ssh-proxy nil
  "When non-nil, the ssh proxy used for this buffer."
  local
  protected)

(def-kom-var kom-www-proxy nil
  "*Non-nil indicates a WWW proxy to use for the connection.
This is useful behind a firewall if the proxy supports the CONNECT
method. 

If this variable is a string, it is assumed to be a proxy
specification for all LysKOM servers. If it is a list, it is assumed
to be a list of pairs, (SERVER . PROXY), where SERVER is the server for
which PROXY specification is to be used. The special value t
can be used for SERVER to indicate a default proxy.

A proxy specification has the form \"HOST:PORT\" where HOST is the
host name of the proxy and PORT is the port to connect to. The :PORT
part is optional. If it is not specified, port 80 is assumed.")

(def-kom-var kom-www-proxy-headers
  "User-Agent: Mozilla/4.7C-CCK-MCD  [en] (X11; I; SunOS 5.6 sun4u)"
  "*Headers to send to the proxy when connecting to LysKOM through a WWW
proxy. The value of this variable should either be a single string, which
is sent verbatim to the proxy, or a list of strings which will be sent to
the proxy separated by CRLF, or a list of elements like (NAME H1 H2 ... Hn)
where NAME is the name of a proxy and the remaining elements are headers
to send when connecting through that proxy.

Do not use this variable for proxy authentication.")



(def-kom-var kom-server-aliases
  '(("kom.lysator.liu.se" . "LysKOM")
    ("com.lysator.liu.se" . "LysCOM (LysKOM in English)")
    ("kom.ludd.luth.se" . "LuddKOM")
    ("kom.hem.liu.se" . "RydKOM")
    ("kom.update.uu.se" . "UppKOM")
    ("kom.mds.mdh.se" . "MdS-KOM")
    ("kom.stacken.kth.se" . "TokKOM")
    ("com.helsinki.fi" . "HesaKOM")
    ("kom.cd.chalmers.se" . "CD-KOM")
    ("community.roxen.com" . "Roxen Community KOM")
    ("kom.ds.hj.se" . "DSKOM")
    ("kom.sno.pp.se" . "SnoppKOM"))
  "*An alist mapping server names to shorter identification strings")

(def-kom-var kom-ansaphone-on nil
  "t if automatic replies to personal messages are in effect."
  local)

(def-kom-var kom-silent-ansaphone nil
  "*Non-nil if messages should not cause beeps when the ansaphone is on."
  server)

(def-kom-var kom-ansaphone-record-messages t
  "*t if messages are recorded while the ansaphone is on."
  server)

(def-kom-var kom-ansaphone-show-messages t
  "*t if messages are to be shown when they are recorded."
  server)


(def-kom-var lyskom-ansaphone-messages nil
  "Messages collected by the automatic reply facility.
The most recent message is the first message in the list."
  local)

(def-kom-var lyskom-ansaphone-when-set (current-time-string)
  "Time when the auto-reply facility was enabled."
  local)

(def-kom-var kom-remote-control t
  "*t if LysKOM may be remotely controlled."
  server)

(def-kom-var kom-remote-controllers nil 
  "*Persons who may control LysKOM using messages. By default you can
always control your own sessions. See kom-self-control for more
information."
  server)

(def-kom-var kom-self-control t
  "*If non-nil, remote control commands are accepted from sessions logged
in as the same user as the current session."
  server)

(def-kom-var kom-ansaphone-replies
  '((group nil nil nil nil)
    (common nil nil nil nil))
  "*List of automatic replies to various messages.

A list of (MESSAGE-TYPE SENDER RECIPIENT TEXT REPLY)
    MESSAGE-TYPE is one of 'personal, 'group or 'common or nil
    SENDER is a list of integers or a single integer or nil
    RECIPIENT is a list of integers or a single integer or nil
    TEXT is a regular expression or nil
    REPLY is a string or nil

When an incoming message arrives and the auto-reply facility is on,
this list is checked for automatic replies. The message type, sender,
recipient and text of the incoming messages is matched against the 
elements of this list. If a match is found, the corresponding reply is
send. A nil in one of the message-type, sender, recipient or text
components in the list is taken to mean a wildcard. A null reply means
don't send a reply.

If none of the elements match, kom-ansaphone-default-reply is sent."
  server)

(def-kom-var kom-agree-text nil
  "*If non-nil, the default text to use when agreeing with a text.
This variable can be a string, function or list. If a string, the
string is used as the message. If a function, the function is called
and the return value is used. If a list, one of the elements is selected
at random and used. This element may be a string, function or list."
  server)

(def-kom-var kom-default-language nil
  "*Which language to use for messages in new sessions.
The value is a symbol whose name is the ISO 630 code for the desired
language (e.g. sv for Swedish and en for English). Not that the languages
available depend on how you have built the client.

All choices are listed in `lyskom-languages'"
  server 
  inherited
  protected)

(def-kom-var lyskom-language kom-default-language
  local
  inherited
  protected
  "The language currently in use for messages.")

(def-kom-var lyskom-global-language kom-default-language
  "The language for language-specific things that affect multiple sessions.")

(def-kom-var lyskom-edit-mode-map nil
  "Mode map for LysKOM edit."
  local)

(def-kom-var lyskom-edit-prefix nil
  "Mode map for LysKOM edit mode.")

(def-kom-var lyskom-customize-map nil
  "Keymap for the customize buffer"
  local)

(def-kom-var lyskom-command-alternatives nil
  "Possible command completions."
  local
  minibuffer)

(def-kom-var kom-trim-buffer-minimum 4096
  "*This number of bytes rounded to a whole line is the amount of text trimmed
each time ." 
  server)


;;; =================================================================
;;;
;;; Language-dependent variables
;;;

(def-kom-var lyskom-month-names nil
  "A list of month names.
Each element is a cons cell consisting of the name of the month
\(a symbol) and the number of the month (1-12). Each month may
appear more than once"
  local
  inherited
  language-force)

(def-kom-var lyskom-help-data nil
  "Help strings."
  local
  language-force)

(def-kom-var lyskom-onoff-table nil
  "A completion table for on and off selections."
  local
  language-force)

(def-kom-var lyskom-move-tree-actions nil
  "A completion table for actions in kom-move-text-tree"
  local
  language-force)

(def-kom-var lyskom-language-codes nil
  "A list of ISO 639 language codes"
  local
  language-force)

(def-kom-var lyskom-filter-predicate-list nil
      "A list of legal filter comparison predicates."
      local
      language-force)

(def-kom-var lyskom-filter-what nil
      "A list of legal filter conditions and their textual representation."
      local
      language-force)

(def-kom-var lyskom-filter-actions nil
      "A list of legal filter actions an their textual representation."
      local
      language-force)

(def-kom-var lyskom-filter-edit-map nil
  "Keymap for LysKOM filter edit."
  local)

(def-kom-var lyskom-prioritize-mode-map nil
  "Keymap used in lyskom-prioritize-mode."
  local)

(def-kom-var lyskom-prioritize-header-lines nil
  "Number of lines in the header of the prioritization buffer."
  local
  language-force)

(def-kom-var lyskom-prioritize-header nil
  "Header for the reprioritization buffer."
  inherited
  language-force)

(def-kom-var kom-ansaphone-default-reply nil
  "*Default message to send when the ansaphone is on."
  server)

(def-kom-var kom-ispell-dictionary nil
  "*Dictionary to use for spell checking."
  server
  inherited)

(def-kom-var lyskom-unread-mode-line nil
  "This variable will become part of mode-line-format"
  language-force)

(def-kom-var lyskom-unread-title-format nil
  "This variable will become part of frame-title-format"
  language-force)

(def-kom-var lyskom-button-actions
  '((text
     text-popup-title
     lyskom-button-view-text
     ((lyskom-button-view-text-action . lyskom-button-view-text)
      (lyskom-button-copy-text-no-action . lyskom-button-copy-text-no)
      (lyskom-button-review-noconversion-action . lyskom-button-review-noconversion)
      (lyskom-button-find-root-review-action . lyskom-button-find-root-review)
      (lyskom-button-find-root-action . lyskom-button-find-root)
      (lyskom-button-review-comments-action . lyskom-button-review-comments)
      (lyskom-button-review-tree-action . lyskom-button-review-tree)
      (lyskom-button-comment-text-action . lyskom-button-comment-text)
      (lyskom-button-private-comment-text-action . lyskom-button-private-comment-text)
      (lyskom-button-write-footnote-action . lyskom-button-write-footnote)
      (lyskom-button-fast-reply-action . lyskom-button-fast-reply)
      (lyskom-button-mark-text-action . lyskom-button-mark-text)
      (lyskom-button-unmark-text-action . lyskom-button-unmark-text)
      (lyskom-button-save-text-action . lyskom-button-save-text)
      (lyskom-button-save-text-body-action . lyskom-button-save-text-body)
      )
     nil
     ;; ((nil lyskom-print-text footer lyskom-button-comment-text))
     )
    (conf 
     conf-popup-title
     lyskom-button-view-conf-presentation
     ((lyskom-button-view-conf-presentation-action . lyskom-button-view-conf-presentation)
      (lyskom-button-view-conf-status-action . lyskom-button-view-conf-status)
      (lyskom-button-goto-conf-action . lyskom-button-goto-conf)
      (lyskom-button-send-message-action . lyskom-button-send-message)
      (lyskom-button-add-self-action . lyskom-button-add-self)
      (lyskom-button-sub-self-action . lyskom-button-sub-self))
     ((kom-list-news . lyskom-button-goto-conf)
      (kom-membership . lyskom-button-goto-conf)))
    (pers 
     pers-popup-title
     lyskom-button-view-pers-presentation
     ((lyskom-button-view-pers-presentation-action . lyskom-button-view-pers-presentation)
      (lyskom-button-view-pers-status-action . lyskom-button-view-pers-status)
      (lyskom-button-view-session-status-action . lyskom-button-view-session-status)
      (lyskom-button-mail-action . lyskom-button-mail)
      (lyskom-button-send-message-action . lyskom-button-send-message))
     ((kom-list-news . lyskom-button-goto-conf)
      (kom-membership . lyskom-button-goto-conf)))
    (url 
     url-popup-title
     lyskom-button-open-url
     ((lyskom-button-open-url-action . lyskom-button-open-url)
      (lyskom-button-copy-url-action . lyskom-button-copy-url))
     nil)
    (info-node 
     generic-popup-title
     lyskom-button-goto-info-node
     ((lyskom-button-goto-info-node-action . lyskom-button-goto-info-node))
     nil)
    (email
     generic-popup-title
     lyskom-button-open-email
     ((lyskom-button-open-email-action . lyskom-button-open-email)
      (lyskom-button-copy-email-action . lyskom-button-copy-email))
     nil)
    (aux
     aux-popup-title
     lyskom-button-info-aux
     ((lyskom-button-info-aux-action . lyskom-button-info-aux)
      (lyskom-button-delete-aux-action . lyskom-button-delete-aux))
     nil)
    (aux-edit-menu
     nil
     aux-edit-menu-text
     ((lyskom-edit-toggle-secret-aux-action . lyskom-edit-toggle-secret-aux)
      (lyskom-edit-toggle-anonymous-aux-action . lyskom-edit-toggle-anonymous-aux)
      (lyskom-edit-toggle-inherit-aux-action . lyskom-edit-toggle-inherit-aux)
      (lyskom-edit-delete-aux-action . lyskom-edit-delete-aux))
     nil)
    (prioritize-flag-menu
     nil
     lyskom-prioritize-flag-toggle
     ((lyskom-prioritize-flag-toggle-action . lyskom-prioritize-flag-toggle)
      (lyskom-prioritize-flag-set-action . lyskom-prioritize-flag-set)
      (lyskom-prioritize-flag-clear-action . lyskom-prioritize-flag-clear))
     nil)
    (func
     nil
     lyskom-button-apply
     nil
     nil)
    (timestamp
     timestamp-popup-title
     (lambda (buffer argument text) nil)
     ((lyskom-button-copy-timestamp-action . lyskom-button-copy-timestamp))
     nil)
    (recpt-type
     recpt-type-popup-title
     (lambda (buffer argument text) nil)
     ((lyskom-button-recpt-type-recipient
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-copy
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'CC-RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-bcc
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'BCC-RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-sub
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-sub-recipient/copy
	    (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))))
    (add-recipient-or-xref
     add-recipient-or-xref
     (lambda (buffer argument text) nil)
     ((lyskom-button-recpt-add-recipient
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-recipient)))
      (lyskom-button-recpt-add-copy
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-copy)))
      (lyskom-button-recpt-add-bcc
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-bcc)))
      (lyskom-button-aux-type-xref
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-cross-reference))))
      (lyskom-button-aux-type-no-comments
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-no-comments))))
      (lyskom-button-aux-type-personal-comments
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-personal-comments))))))
    )
  "This variable defines valid button types in LysKOM. Each element is a
list consisting of (TYPE LABEL DEFAULT ACTIONS HINTS).
TYPE is the button type the entry defines
LABEL is a textual representation for the button type, used in menu titles. If
      it is a symbol, that symbol will be looked up using lyskom-get-string.
DEFAULT is the default action to take on a click. It must be a function.
ACTIONS are other possible actions. The format of this entry is described 
        below.
HINTS is a list of hints to override the default action. This is described 
      below.

The ACTIONS entry is used to construct a pop-up menu. It is a list consisting 
of lists with the format (STRING . FUNCTION). STRING is the menu label and
FUNCTION is the function to call when the menu item is selected.

The HINTS entry is used to generate hints that the default action should be 
overridden. It is a list containing elements (COMMAND . HINT) where COMMAND is
as interactive LysKOM command and HINT is a function to call. When a button
is generated while the command COMMAND is being executed, HINT is used as a 
hint for a new default action. The user has the option to ignore or used the 
hint.

Also see the function \"lyskom-add-button-action\"."
  local
  inherited)

(def-kom-var kom-show-imported-envelope-sender t
  "*If non-nil, show the envelope sender of texts imported by komimportmail."
  server)

(def-kom-var kom-show-imported-importer t
  "*If non-nil, show the name of the importer of an imported text."
  server)

(def-kom-var kom-show-imported-external-recipients t
  "*If non-nil, show the external recipients to an imported text."
  server)

(def-kom-var kom-complete-numbers-before-names t
  "*If non-nil, reading conference and user names accepts the special 
forms ``m 4711'' or ``p 42'' as numeric references to conference 4711
and person 42 instead of trying to look for an object with a matching
name. If nil, any name matching the input will be preferred to a
numeric reference."
  server)


(def-kom-var kom-mercial nil
  "*When the user has seen all texts and has reached the view-time prompt,
this string is used as the argument to lyskom-tell-server.
Users are encouraged to use their best sense of humor."
  server)


(defconst lyskom-commands
  '(
    kom-help
    kom-slow-mode
    kom-quick-mode
    kom-send-message
    kom-create-conf
    kom-delete-conf
    kom-delete-text
    kom-display-time
    kom-go-to-conf
    kom-go-to-next-conf
    kom-jump
    kom-list-created-conferences
    kom-list-conferences 
    kom-list-persons
    kom-list-news
    kom-list-re
    kom-membership
    kom-list-marks
    kom-postpone
    kom-set-session-priority
    kom-prioritize
    kom-status-person
    kom-status-conf
    kom-add-self
    kom-change-priority
    kom-list-summary
    kom-sub-self
    kom-quit
    kom-recover 
    kom-start-anew
    kom-view
    kom-find-root-review
    kom-review-comments
    kom-review-tree
    kom-review-clear
    kom-review-last-normally-read
    kom-review-noconversion
    kom-review-next
    kom-find-root
    kom-review-by-to
    kom-review-more
    kom-review-first
    kom-review-all
    kom-view-commented-text
    kom-view-previous-commented-text
    kom-review-stack
    kom-review-presentation
    kom-review-backward
    kom-view-next-text
    kom-who-is-on
    kom-who-is-on-in-conference
    kom-who-is-on-and-friend
    kom-who-am-i
    ;;   kom-display-who-buffer
    kom-list-clients
    kom-busy-wait
    kom-write-comment
    kom-comment-previous
    kom-write-footnote
    kom-private-answer
    kom-private-answer-previous
    kom-set-unread
    kom-write-text
    kom-send-letter
    kom-change-name
    kom-change-parenthesis
    kom-change-password
    kom-change-supervisor
    kom-change-presentation
    kom-get-appreciation
    kom-get-abuse
    kom-mark-text
    kom-unmark-text
    kom-review-marked-texts
    kom-review-all-marked-texts
    kom-add-recipient
    kom-add-copy
    kom-add-bcc
    kom-sub-recipient
    kom-move-text
    kom-move-text-tree
    kom-add-comment
    kom-sub-comment
    kom-add-cross-reference
    kom-add-member
    kom-sub-member
    kom-change-conf-motd
    kom-set-garb-nice
    kom-set-super-conf
    kom-set-permitted-submitters
    kom-unset-conf-motd
    kom-save-text
    kom-save-text-body
    kom-save-options
    kom-shutdown-server
    kom-sync-database
    kom-enable-adm-caps
    kom-disable-adm-caps
    kom-set-motd
    kom-remove-motd
    kom-force-logout
    kom-filter-author
    kom-filter-subject
    kom-filter-text
    kom-filter-recipient
    kom-super-jump
    kom-filter-edit
    kom-list-filters
    kom-show-user-area
    kom-change-conf-type

    kom-change-auto-reply
    kom-toggle-auto-reply
    kom-list-messages
    kom-erase-messages

    kom-remote-autoreply
    kom-remote-set-message
    kom-remote-list-messages
    kom-remote-erase-messages
    kom-remote-quit

    kom-status-session
    kom-customize
    kom-change-language
    kom-calculate

    kom-where-is

    kom-next-kom
    kom-previous-kom
    kom-next-unread-kom

    kom-send-alarm
    kom-agree
    kom-fast-reply
    kom-add-faq
    kom-del-faq
    kom-review-faq

    kom-add-footnote
    kom-sub-footnote

    kom-add-private-answer
    kom-add-no-comments
    kom-add-request-confirm

    kom-review-mail-headers

    kom-compare-texts
    kom-diff-texts

    kom-become-anonymous
    kom-become-nonanonymous

    kom-keep-alive
    kom-stop-keep-alive

    kom-who-is-present-in-conference
    kom-is-person-member-of-conference
    kom-change-conf-faq

    kom-make-review-mark-as-read
    kom-make-review-not-mark-as-read
    kom-set-presentation
    kom-set-motd-text
    kom-remove-presentation
    kom-create-aux-item
    kom-status-server
    kom-add-server-faq
    kom-del-server-faq
    kom-change-server-faq
    kom-review-server-faq
    kom-recommend-conference
    kom-redirect-comments
    ))

;;; ================================================================
;;;                  Internal variables and constants


(defconst lyskom-clientversion "0.47"
  "Version of the LysKOM elisp client.")

(defvar lyskom-max-int 8388607
  "The largest int Emacs, and thus this LysKOM client, can handle.")

(defconst lyskom-server-features
  '((10 lyskom-bcc-flag
        lyskom-extended-types-flag)
    (9  lyskom-accept-async-flag
        lyskom-dynamic-session-info-flag
        lyskom-idle-time-flag)
    (8  lyskom-long-conf-types-flag 
        lyskom-set-last-read-flag 
        lyskom-uconf-stats-flag
        lyskom-set-last-read-flag)
    (7  lyskom-z-lookup-flag))
  "List describing which features a certain server has. Each
element is a list containing the protocol version and what
it supports. The format of each element is:

\(VERSION . SUPPORTS\)

Version is simply a protocol version. Protocol equal to or above the
version support the supports list.

SUPPORTS is a list of pairs and symbols. Cons pairs are treated as
arguments to setq, symbols are interpreted as variable names set
 to 't'.")

;;;(defconst lyskom-server-features
;;;  '(((>= 2 0 0) (lyskom-bcc-flag
;;;                 lyskom-aux-items-flag))
;;;    ((>= 1 9 0) (lyskom-accept-async-flag
;;;                 lyskom-dynamic-session-info-flag
;;;                 lyskom-idle-time-flag))
;;;    ((>= 1 8 0) (lyskom-long-conf-types-flag 
;;;                 lyskom-set-last-read-flag
;;;                 lyskom-uconf-stats-flag))
;;;    ((>= 1 7 0) (lyskom-z-lookup-flag))
;;;    ((= 2 0 0) ((protocol-version 10)))
;;;    ((= 1 9 0) ((protocol-version 9)))
;;;    ((= 1 8 0) ((protocol-version 8)))
;;;    ((= 1 7 0) ((protocol-version 7)))
;;;    ((= 1 7 1) ((protocol-version 7)))
;;;    ((< 1 7 0) ((protocol-version 6))))
;;;  "List describing which features a certain server version has.
;;;Each element is a list containing the server version and what it
;;;supports:
;;;")


(def-kom-var lyskom-server-version '(0 0 0)
  "The version of the server.  A list of three integers: major
version, minor version and revision."
  local)

(def-kom-var lyskom-server-coding-system 'iso-8859-1
  "The default coding system used by the server for all strings."
  inherited)

(def-kom-var lyskom-max-packet-size lyskom-max-int
  "The largest possible packet size that can be transmitted to a
TCP/IP connection. This should be unlimited, but in practise there
are systems that limits this. This variable is automatically adjusted
if any problems are detected.")

(def-kom-var lyskom-pending-commands nil
  "Commands pending to be executed.
When a command finishes, it checks this variable to see if another command
should be run.

It should be a list where each element should be either a symbol or an
expression. If it is a symbol, it is invoked with `call-interactively', and
an expression is evaluated with `eval'."
  local)

(def-kom-var lyskom-do-when-done nil
  "Internal of kom-do-when-done."
  local)

(def-kom-var lyskom-do-when-starting nil
  "Internal of kom-do-when-starting. Obsolete.")

(def-kom-var lyskom-sessions-with-unread nil
  "List of LysKOM sessions with unread texts.
This is not buffer-local.")

(def-kom-var lyskom-sessions-with-unread-letters nil
  "List of LysKOM sessions with unread letters.
This is not buffer-local.")

(def-kom-var lyskom-session-has-unread-letters nil
  "Non-nil if this session has unread letters."
  local
  protected
  inherited)

(def-kom-var lyskom-session-has-unreads nil
  "Non-nil if this session has unread texts."
  local
  protected
  inherited)

(def-kom-var lyskom-buffer nil
  "The LysKOM buffer we are connected to."
  inherited
  minibuffer)

(def-kom-var lyskom-buffer-type nil
  "Type of the current buffer."
  local
  protected)

(def-kom-var output nil
  "Uaark. Just to omit a warning...")

(def-kom-var lyskom-errno nil
  "Errno of last lyskom error."
  local)

(def-kom-var lyskom-err-stat nil
  "Err-stat of last lyskom error."
  local)

(def-kom-var lyskom-parser-recovering nil
  "Non-nil if the parser is recovering from an error."
  local)

(def-kom-var lyskom-parse-pos nil
  "Position of parsing.")

(def-kom-var lyskom-unparsed-buffer nil
  "Buffer containing unparsed information from the server."
  local)

(def-kom-var lyskom-unparsed-marker nil
  "Where we now are inserting."
  local)

(def-kom-var lyskom-to-be-printed-before-prompt nil
  "Contains the strings to be printed before the next prompt."
  local)

(def-kom-var lyskom-other-clients-user-areas nil
  "Contains the parts of the user areas of unknown clients.
The area is a pair: name . info (both strings)."
  local)

(def-kom-var lyskom-pending-calls nil
  "Assoc list of calls to LysKOM server that have not yet completed.
Each element on the list has the format

	(REF-NO . KOM-QUEUE)
REF-NO	   unique number assigned by lyskom-send-packet.
KOM-QUEUE is a kom-queue. (See lyskom-call-data.)"
  local)

(def-kom-var lyskom-output-queues nil
  "Pending output to the server.
This is a vector of ten elements, each of which is a kom-queue. Calls from
queues with a higher index (priority) are always sent first.

At most lyskom-max-pending-calls calls are sent at once."
  local)

(def-kom-var lyskom-max-pending-calls 20
  "*Max number of calls that are transmitted to the server at once.
Extra calls are queued in lyskom-output-queue and sent when the replies
returns.

This variable is not saved in the LysKOM server.")

(def-kom-var lyskom-number-of-pending-calls 0
  "Number of pending calls that are transmitted to the server."
  local)

;; This variable is used to prevent "starvation" of the blocking-do call.
;; When there is heavy prefetch going on in the background and a
;; blocking-do call is made there is a good chance that the
;; accept-process-output call will not return within a reasonable
;; time, because there will always be data to read from the server,
;; which means that Emacs will call lyskom-filter instead of returning
;; from accept-process-output.
(defvar lyskom-ok-to-send-new-calls t
  "This variable controls whether calls are passed to the server.
If it is nil, all outgoing calls are inhibited.")

(def-kom-var lyskom-ref-no 0
  "Next ref-no to use. These ref-nos are used to keep track of the
different packets.")

(def-kom-var lyskom-pers-no 0
  "The pers-no of the current user."
  inherited)

(def-kom-var lyskom-session-no 0
  "Session number in the server for this connection."
  local)

(def-kom-var kom-default-session-priority 1
  "*The default session priority.
Only texts in conferences with a priority equal to or higher than this
will be shown by default.

To set the session priority in a running session, set the variable
lyskom-session-priority instead. The value of this variable is used
to initialize lyskom-session-priority when a new session is started."
  local
  server)

(def-kom-var kom-server-priority -1
  "*The default server priority.
When kom-server-priority-breaks is set, this priority is used to decide
when to go to a prioritized session. For a session to be prioritized its
priority must be higher than the current session's kom-server-priority 
and higher than the priority of whatever is currently being read."
  server)


(def-kom-var lyskom-session-priority 0
  "*This sessions priority.
Only texts in conferences with a priority equal to or higher than this
will be shown."
  local)

(def-kom-var lyskom-proc nil
  "The process (network connection) that is associated with this buffer."
  inherited
  minibuffer)

(def-kom-var lyskom-server-info nil
  "Info about the server."
  local)

(def-kom-var lyskom-server-version-info nil
  "Version information about the client."
  local)

(def-kom-var lyskom-server-name ""
  "The name of the server."
  inherited)

(def-kom-var lyskom-server-port nil
  "The port we are connected to."
  local)

(def-kom-var lyskom-buffer-list nil
  "List of all LysKOM buffers.")

(def-kom-var lyskom-static-session-info-cache nil
  "Cache of session."
  local)

(def-kom-var lyskom-conf-cache nil
  "Cache of conference statuses."
  local)

(def-kom-var lyskom-uconf-cache nil
  "Cache of small conference statuses."
  local)

(def-kom-var lyskom-pers-cache nil
  "Cache of person statuses."
  local)

(def-kom-var lyskom-text-cache nil
  "Cache of text statuses."
  local)

(def-kom-var lyskom-text-mass-cache nil
  "Cache of texts."
  local)

(def-kom-var lyskom-marked-text-cache nil
  "Cache of marks of all texts the current user has marked. "
  local)

(def-kom-var lyskom-who-info-cache nil
  "Cache of people presently logged in in LysKOM."
  local)

(def-kom-var lyskom-who-info-buffer nil
  "Buffer for the who info presentation."
  local)

(def-kom-var lyskom-who-info-buffer-is-on nil
  "Says whether we are collecting who-information or not."
  local)


(def-kom-var lyskom-is-parsing t
  "True when parsing a result.
This is used to prevent parallel parsing since the parser is not reentrant."
  local)

(def-kom-var lyskom-string-bytes-missing 0
  "Number of bytes missing in the unparsed buffer when parsing a string.
Set when parsing a string and there were not enough bytes in the buffer
with the unparsed bytes. This variable is used to prevent reparsing before 
the string is complete.
This variable is buffer-local in the unparsed-buffer."
  local
  inherited)

(def-kom-var lyskom-last-viewed 0       ;
  "Position of the first char of the last line that the user has had
time to view. This is normally the pos of the first char of the prompt."
  local)

(def-kom-var lyskom-mode-map nil
  "Keymap used in LysKOM mode."
  local)


(def-kom-var lyskom-reading-list nil
  "List of articles to read in the current conference.
Each element is a read-info. Only one of the elements is of the type CONF.
This one is located last in the list (except for the elements of the type 
REVIEW, REVIEW-TREE or REVIEW-MARK).
When reading an article with comments a list of the comments is built
recursively if the flag kom-read-depth-first is non-nil.
This is to keep track of the reading order.
Articles can exist in several of the read-info elements. All unread articles
in the conference are always present in the CONF type entry in this list even
if also in other entries. (COMM-IN, FOOTN-IN)

Some powerful reviewing commands requires to construct a list of articles that
should be read. These use the type REVIEW. When reviewing trees and when
every viewed article is supposed to be followed by all its comments then the
type REVIEW-TREE is used.

The first element is a dummy."
  local)

(def-kom-var lyskom-to-do-list nil
  "List of conferences with unread texts.
Each element is a read-info. All have the type 'CONF and there is one for
every conference with unread articles that have already been prefetched.
The list is sorted in falling priority. 
When going to a conference the first element (the one with the highest
priority) is copied from this list to lyskom-reading-list.

The first element is a dummy."
  local)

(def-kom-var lyskom-quit-flag nil
  "A flag indicating if the filter was interrupted by C-g.
 It is set to the same value as quit-flag on filter exit.")

(def-kom-var lyskom-ignoring-async-list nil
  "A list of async messages we are currently ignoring.
Each element is a list. The car of the list is the message and the
remaining elements are whatever is suitable for that type of message.
See the checks in lyskom-parse-async for details."
  local)

(def-kom-var lyskom-inhibit-minibuffer-messages nil
  "A flag indicating whether asynchronous minibuffer messages are allowed.
If this variable is non-nil, no asynchronous messages will appear.")

(def-kom-var lyskom-is-saving nil
  "A flag indicating whether the server is saving at the moment.")

;;; These variables control prefetch of conf-stats, text-stats and texts:

(def-kom-var lyskom-prefetch-conf-tresh 50
  "If fewer than lyskom-prefetch-conf-tresh texts are known, ask for more
conf-stats from server.

This is currently not used."
  local)

(def-kom-var lyskom-prefetch-confs 10
  "Number of confs to ask about at once when checking for unread texts.

This is currently not used."
  local)

(def-kom-var lyskom-fetch-map-nos 50
  "Number of text-nos lyskom will fetch when fetching maps."
  local)

(def-kom-var lyskom-fetch-membership-length 6
  "*Number of entries in the membership-list that is fetched at a time.
This should be optimized depending on how often you read LysKOM and
the activity in the first groups in you membership list.

Best performance is achieved if you, when logging in, always have an unread
article in one of the first lyskom-fetch-membership-length conferences.")

(def-kom-var lyskom-prefetch-limit 10
  "Number of prefetch requests the client will try to keep going
at a time.")


;;;

(def-kom-var lyskom-membership nil
  "Sorted membership list of the logged in person."
  local)

(def-kom-var lyskom-unread-confs nil
  "List containing all unread confs."
  local)

(def-kom-var lyskom-dont-change-prompt nil
  "Non-nil during the entry of a text."
  local)

(def-kom-var lyskom-command-to-do 'unknown
  "Atom describing what command to do. See the function lyskom-what-to-do."
  local)

(def-kom-var lyskom-is-waiting nil
  "If non-nil, this is the condition for the waiting to be stopped.
If t, however, it means that the user is waiting for a text with a prompt.
It is a form that will be evaluated (using eval) every time the asynchronous
message \"new text\" is received.

This is used by the command kom-busy-wait."
  local)

(def-kom-var lyskom-current-conf 0
  "Current conference. 0 means user is not reading any conf."
  local)

(def-kom-var lyskom-current-text nil
  "Text-no of current text. nil means no text is current."
  local)

(def-kom-var lyskom-last-written nil
  "Text-no of last text written. nil means no text written."
  local)

(def-kom-var lyskom-last-seen-written nil
  "Text-no of last text read or written by the current user.
When a new text is written, this is set to the text number of that text.
When a text is read that was written by the current user, this is
set to that text."
  local)

(def-kom-var lyskom-previous-text nil
  "Text-no of previous text. Nil means no text."
  local)

(def-kom-var lyskom-normally-read-texts nil
  "Stack of texts that are read normally. Used for kom-review-last-normally-read."
  local)

(def-kom-var lyskom-current-subject ""
  "Current subject."
  local)

(def-kom-var lyskom-last-added-rcpt 0
  "The default conference when adding a recipient or moving a text."
  local)

(def-kom-var lyskom-last-added-ccrcpt 0
  "The default conference when adding a ccrecipient."
  local)

(def-kom-var lyskom-last-added-bccrcpt 0
  "The default conference when adding a bccrecipient."
  local)

(def-kom-var lyskom-last-sub-rcpt 0
  "The default conference when removing a recipient."
  local)

(def-kom-var kom-saved-file-name (concat default-directory "kom-text")
  "*The default file name when saving a LysKOM text."
  server)

(def-kom-var lyskom-saved-file-name nil
  "After saving once, the default file name when saving a LysKOM text."
  local)

(def-kom-var lyskom-mode-hook nil
  "*Hook to run when lyskom-mode is entered.")

(def-kom-var kom-quit-hook nil
  "*Hook to run when the LysKOM session is correctly ended."
  server-hook)

(def-kom-var kom-quit-when-idle t
  "Non-nil to automatically quit when LysKOM is full and the session is idle")

(def-kom-var kom-permanent-filter-list nil
  "List of patterns to filter permanently."
  server)

(def-kom-var kom-session-filter-list nil
  "List of patterns to filter during this session."
  local)

(def-kom-var lyskom-text-no-prompts-defaults
  '(kom-delete-text
    kom-view
    kom-write-footnote
    kom-mark-text
    kom-unmark-text
    kom-add-recipient
    kom-add-copy
    kom-add-bcc
    kom-sub-recipient
    kom-move-text
    kom-move-text-tree
    kom-add-comment
    kom-sub-comment
    kom-add-cross-reference
    kom-save-text-body
    kom-add-footnote
    kom-sub-footnote
    kom-add-faq
    kom-add-no-comments
    kom-add-private-answer
    kom-add-request-confirm
    kom-add-server-faq
    )
  "Commands that prompt for a text number rather than assume a default."
  inherited)

(def-kom-var kom-text-no-prompts nil
  "*Configure which commands ask for text numbers.
A list containing pairs of (COMMAND . VALUE). If VALUE is non-nil, COMMAND
will prompt for text numbers. If VALUE is nil, COMMAND will use a suitable
default value."
  server
  inherited)


(def-kom-var lyskom-filter-list nil
  "List of patterns that are filtered."
  local)

(def-kom-var kom-create-text-hook nil
  "*Hook to run before creating a new text.
This hook is run just before the server call to create the text is made.

The hook is currently called with the following arguments:
MESSAGE         The message text
MISC-LIST       The misc-info list
AUX-LIST        The aux-item list
BUFFER          The edit buffer
IS-ANONYMOUS    Non-nil if the user is currently anonymous.
&rest RESERVED  Additional arguments may be added in the future.

The hook can change the message by modifying the variable
full-message, the misc-info list by modifying misc-list and the
aux-item list by modifying aux-list. This is not encouraged."
  local-hook)

(def-kom-var lyskom-create-text-hook nil
  "*Obsolete synonym for kom-create-text-hook"
  local-hook)


(def-kom-var kom-new-text-hook nil
  "*Hook to run when a new text is created.
This hook is run after the prompt is removed if it shall be changed but before
the text \"Text 4711 r skapad!\" is printed in the message area. And before the
new prompt is printed."
  local-hook)

(def-kom-var lyskom-new-text-hook nil
  "*Obsolete synonym for kom-new-text-hook"
  local-hook)

(def-kom-var kom-deleted-text-hook nil
  "*Hook to run when a text is deleted.
This hook is run after the prompt is removed if it shall be changed but 
before the new prompt is printed."
  local-hook)

(def-kom-var lyskom-deleted-text-hook nil
  "*Obsolete synonym for kom-deleted-text-hook."
  local-hook)

(def-kom-var kom-new-recipient-hook nil
  "*Hook to run when a text receives a new recipient.
This hook is run after the prompt is removed if it shall be changed but before
the new prompt is printed. It is not run if the text has been marked as read
in any conference other than the person's letterbox."
  local-hook)

(def-kom-var lyskom-new-recipient-hook nil
  "*Obsolete synonym for kom-new-recipient-hook."
  local-hook)

;;(def-kom-var lyskom-who-info-has-changed-hook nil
;;  "Hook to run every time the who-info-buffer has changed.
;;The hook is run with current-buffer the lyskom buffer, not the 
;;who-info-buffer."
;;  server)

(def-kom-var kom-personal-message-hook nil
  "*Hook to run when a personal message is received.
When the hook is run, 'sender' is bound to the conf-stat of the sender
of the message (or possibly nil), 'recipient' is 0 if the message is a
public message and otherwise the conf-stat of the recipient, and
'message' is a string that holds the message."
  local-hook)

(def-kom-var lyskom-personal-message-hook nil
  "*Obsolete synonym for kom-personal-message-hook."
  local-hook)


(def-kom-var lyskom-executing-command t
  "Non-nil means the client is executing a command.
Most commands can't be interrupted by another command."
  local)

(def-kom-var lyskom-current-command nil
  "The command currently being executed."
  local)

(def-kom-var lyskom-current-function nil
  "Sometimes set to the current high-level function being executed."
  local)

(def-kom-var lyskom-current-function-phase nil
  "Sometimes set to the phase of the current high-level function being
executed."
  local)

(def-kom-var kom-low-priority -1
  "*Priority that the current conference is set to when
aborted. nil means don't alter priority. (This means that
kom-go-to-next-conf might go to the same conference again.)")

(def-kom-var lyskom-membership-is-read nil
  "t when the membership has been read."
  local)

(def-kom-var lyskom-is-writing nil
  "t when the user is writing a text."
  local)

(def-kom-var lyskom-debug-communications-to-buffer nil
  "Non-nil means all communications with the server is stored in a buffer.
The name is stored in lyskom-debug-communications-to-buffer-buffer.")

(def-kom-var lyskom-debug-communications-limit 60000
  "When set to an integer limits the communications log to that many
bytes. When set to a non-integer, the communications log is unlimited.
If a protocol error is detected, this limit will be reset to nil.

See lyskom-debug-communications-to-buffer")

(def-kom-var lyskom-backtrace-list nil
  "List containing debugging information.")
  
(def-kom-var lyskom-debug-what-i-am-doing t
  "Non-nil means asynchronous message 5 will be logged to the debug
  buffer. ")

(def-kom-var lyskom-is-anonymous nil
  "Non-nil means be a bit secretive about things. Not totally
  secretive of course, since the server doesn't allow that yet."
  local)

(def-kom-var lyskom-debug-communications-to-buffer-buffer "*kom*-debugs"
  "Name of the buffer to insert the communications with the server into if
lyskom-debug-communications-to-buffer is non-nil.")

(def-kom-var lyskom-doing-default-command nil
  "Non-nil if LysKOM is executing the default command."
  local)

(def-kom-var lyskom-first-time-around nil
  "Non-nil if LysKOM is being entered for the first time."
  local)

(def-kom-var lyskom-experimental-features nil
  "If non-nil, LysKOM is likely to blow up in your face."
  local)

(def-kom-var lyskom-format-experimental nil
  "If non-nil, LysKOM is likely to make a fool out of you."
  local)

(def-kom-var lyskom-count-var 0
  "This variable is used for counting things in the client, such as
unread texts in list-unread."
  local)

(def-kom-var lyskom-default-conf-string nil
  "The default string to use for an unknown conference.
Set this locally when inserting a conference name using
lyskom-format-insert if you want to replace the usual description of
an unknown conference.")

(def-kom-var lyskom-default-pers-string nil
  "The default string to use for an unknown person.
Set this locally when inserting a conference name using
lyskom-format-insert if you want to replace the usual description of
an unknown person.")


(def-kom-var lyskom-is-administrator nil
  "This variable is t if the user is in administrator mode and nil otherwise."
  local
  minibuffer)

(def-kom-var lyskom-last-personal-message-sender ""
  "Name of sender of last personal message received."
  local)

(def-kom-var lyskom-last-group-message-recipient ""
  "Name of target for last group message received."
  local)

(def-kom-var lyskom-last-message-recipient nil
  "Number of last async message recipient sent to."
  local)

(def-kom-var lyskom-is-new-user nil
  "An internal variable used in kom-start-anew.")

(def-kom-var lyskom-apo-timeout-s 1
  "Seconds timeout for accept-process-output.")

(def-kom-var lyskom-apo-timeout-ms nil
  "Microseconds timeout for accept-process-output.")

(def-kom-var lyskom-collate-table nil
  "Table mapping characters to an equivalence class."
  inherited)

(def-kom-var lyskom-char-classes nil
  "An assoc list from character to a list of equivalent strings.
See lyskom-compute-char-classes."
  inherited)

(def-kom-var lyskom-dont-read-user-area nil
  "If non-nil the user area will not be read on login."
  local)

(def-kom-var lyskom-allow-missing-subject nil
  "If non-nil allow texts without subjects.")

(def-kom-var kom-w3-simplify-body t
  "*Strip color information from body tag."
  server)

(def-kom-var kom-format-html-authors '((t . t))
  "*Controls from which authors we accept HTML.
Each element of this list is a cons cell (PERS . VAL), where PERS is
a person number and VAL is t or nil. If VAL is t, then we format HTML
written by PERS. Otherwise not."
  server)

(def-kom-var lyskom-format-special 
  '(("html"               . lyskom-format-html)
    ("enriched"           . lyskom-format-enriched)
    ("text/html"          . lyskom-format-html)
    ("text/enriched"      . lyskom-format-enriched)
    ("text/plain"         . nil)
    ("text/x-kom-basic"   . nil)
    ("x-kom/text"         . nil)  ;Archaic alias for text/x-kom-basic.
    ("x-kom/basic"        . nil)  ;Archaic alias for text/x-kom-basic.
    ("x-kom/\\."         . lyskom-format-))
  "AList of (FORMAT . FUNCTION) specifying functions that format texts
of that type. FORMAT is a symbol and FUNCTION is a function taking one
argument and returning a formatted string.")

(def-kom-var lyskom-send-text-transform-function nil
  "Function to call to transform text before sending it to the server.
The function should accept a single argument and return the transformed
texts that is to be sent to the server.")

(def-kom-var lyskom-slow-mode nil
  "Non-nil when in slow mode."
  local)

(def-kom-var lyskom-saved-read-only nil
  "Saved value of buffer-read-only when in slow mode."
  local)

(defvar lyskom-line-start-chars-string
  "\"$&'()*+-./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]_`abcdefghijklmnopqrstuvwxyz"
  "Characters that may start a line in a paragraph to be broken.")

(def-kom-var lyskom-line-start-chars nil
  "Computer-friendly version of lyskom-line-start-string.")


(def-kom-var lyskom-last-text-format-flags nil
  "List of flags specifying how the last text was reformatted. This variable
should be dynamically bound whenever it needs to be used.")

(def-kom-var lyskom-read-faqs nil
  "List of FAQs that have been read."
  inherited)

(def-kom-var lyskom-rejected-recommendations nil
  "List of invitations that have been rejected."
  inherited)

(defvar lyskom-xface-cache (make-vector 29 0))


;;; ======================================================================
;;; Event hooks
;;;

(def-kom-var lyskom-add-membership-hook nil
  "Functions to call when a membership is added."
  local-hook)

(def-kom-var lyskom-replace-membership-hook nil
  "Functions to call when a membership is replaced."
  local-hook)

(def-kom-var lyskom-remove-membership-hook nil
  "Functions to call when a membership is removed."
  local-hook)

(def-kom-var lyskom-new-membership-list-hook nil
  "Functions to call when the entire membership list is replaced."
  local-hook)


;;; ======================================================================
;;;; lyskom-tell-phrases-validation-keyword-list
;;; This is a list of keywords for kom-tell-phrases.
;;; These are the only keywords that are allowed in kom-tell-phrases.

;;; To coders of the elisp-client:
;;; If you add/delete a reference to any of these keywords make sure
;;; you update these changes.

;;; To everyone:
;;; The kom-tell-phrases list is checked against this list when the
;;; client is loaded, i.e. by lyskom-tell-phrases-validate that causes
;;; an error if any keyword is not present or any non-keyword is
;;; present.

(defvar kom-tell-phrases nil
  "*A list of phrases describing what the client is doing. Each element in
the list is a pair \(KEY . PHRASE\) where KEY is one of the keywords in
lykom-tell-phrases-validation-keyword-list and PHRASE is the phrase to
sent to the server then the client is doing what KEY describes.

If the value of this variable is nil, suitable defaults for the currently
selected language will be selected.")

(defconst lyskom-tell-phrases-validation-keyword-list
  '(
    (kom-tell-silence)
    (kom-tell-send)
    (kom-tell-login)
    (kom-tell-read)
    (kom-tell-1st-pres)
    (kom-tell-write-comment)
    (kom-tell-write-footnote)
    (kom-tell-write-letter)
    (kom-tell-write-reply)
    (kom-tell-write-text)
    (kom-tell-conf-pres)
    (kom-tell-recover)
    (kom-tell-wait)
    (kom-tell-regret)
    (kom-tell-review)
    (kom-tell-change-name)
    (kom-tell-change-supervisor)
    (kom-tell-next-lyskom)
    )
  "Users must not change this constant, but are encouraged to change
the value of  kom-tell-phrases for fun.")

;;; ================================================================
;;; Commands lists that are removed from extended command depending on
;;; administrator status.

(defconst lyskom-admin-removed-commands
  '(kom-enable-adm-caps))
(defconst lyskom-noadmin-removed-commands
  '(kom-disable-adm-caps
    kom-remove-motd
    kom-set-motd
    kom-shutdown-server
    kom-sync-database
    kom-add-server-faq 
    kom-del-server-faq
    kom-change-server-faq
    kom-recommend-conference))


;;; ================================================================
;;; Symbolic error codes

(defvar lyskom-error-codes
  '((no-error . 0)
    (not-implemented . 2)
    (obsolete-call . 3)
    (invalid-password . 4)
    (string-too-long . 5)
    (login-first . 6)
    (login-disallowed . 7)
    (conference-zero . 8)
    (undefined-conference . 9)
    (undefined-person . 10)
    (access-denied . 11)
    (permission-denied . 12)
    (not-member . 13)
    (no-such-text . 14)
    (text-zero . 15)
    (no-such-local-text . 16)
    (local-text-zero . 17)
    (bad-name . 18)
    (index-out-of-range . 19)
    (conference-exists . 20)
    (person-exists . 21)
    (secret-public . 22)
    (letterbox . 23)
    (ldb-error . 24)
    (illegal-misc . 25)
    (illegal-info-type . 26)
    (already-recipient . 27)
    (already-comment . 28)
    (already-footnote . 29)
    (not-recipient . 30)
    (not-comment . 31)
    (not-footnote . 32)
    (recipient-limit . 33)
    (comment-limit . 34)
    (footnote-limit . 35)
    (mark-limit . 36)
    (not-author . 37)
    (no-connect . 38)
    (out-of-memory . 39)
    (server-is-crazy . 40)
    (client-is-crazy . 41)
    (undefined-session . 42)
    (regexp-error . 43)
    (not-marked . 44)
    (temporary-failure . 45)
    (long-array . 46)
    (anonymous-rejected . 47)
    (illegal-aux-item . 48)
    (aux-item-permission . 49)
    (unknown-async . 50)
    (internal-error . 51)
    (feature-disabled . 52)
    (message-not-sent . 53)
    (invalid-membership-type . 54))
  )

;;; ================================================================
;;;          Externally defined variables (environment)


(defvar kom-default-server nil
  "*Setting this variable does nothing. See lyskom-default-server instead.")

(def-kom-var lyskom-default-server "kom.lysator.liu.se"
  "*Default LysKOM server.")

(defvar kom-default-user-name nil
  "*Setting this variable does nothing. See lyskom-default-user-name instead.")

(def-kom-var lyskom-default-user-name nil
  "*Default LysKOM user name."
  local)

(defvar kom-default-password nil
  "*Setting this variable does nothing. See lyskom-default-password instead.")

(def-kom-var lyskom-default-password nil
  "Default LysKOM password."
  local)

(def-kom-var mode-line-conf-name nil
  "Conf name that is present on the mode-line."
  local)

;;
;; Set up default faces in case no face scheme is selected
;;

(def-kom-var lyskom-faces
  '(kom-active-face kom-url-face kom-me-face kom-highlight-face
		    kom-text-face kom-subject-face kom-text-no-face
		    kom-friends-face kom-morons-face kom-presence-face
		    kom-first-line-face kom-warning-face kom-mark-face
                    kom-text-body-face kom-dashed-lines-face 
                    kom-async-text-body-face kom-async-dashed-lines-face
                    kom-dim-face)
  "This is a list of the faces that LysKOM uses.")

(defvar kom-face-schemes nil
  "*Setting this variable does nothing. See lyskom-face-schemes instead.")

(def-kom-var lyskom-face-schemes
  '((default
     (kom-active-face default "blue4" nil)
     (kom-url-face default "BlueViolet" nil)
     (kom-me-face bold "blue3" "lavender")
     (kom-highlight-face highlight nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face default "blue3" "lavender")
     (kom-morons-face default "blue3" "yellow")
     (kom-presence-face italic "dim gray" nil)
     (kom-mark-face bold "blue3" "lavender")
     (kom-warning-face bold "red" nil)
     (kom-first-line-face bold nil nil)
     (kom-dim-face default "gray" nil)
     (kom-dashed-lines-face nil nil "#e8e8ff")
     (kom-text-body-face nil nil "#f8f8ff")
     (kom-async-dashed-lines-face nil nil "#ffe8e8")
     (kom-async-text-body-face nil nil "#fff8f8")
     (property expected-background "white")
     )
    (bark
     (kom-active-face default "Gold" "Black")
     (kom-mark-face default "White" nil)
     (kom-url-face default "Gold" "Black")
     (kom-me-face default "Gold" "Black")
     (kom-highlight-face default "PaleGreen" nil)
     (kom-text-face default nil nil)
     (kom-subject-face default "Gold" nil)
     (kom-text-no-face default nil nil)
     (kom-presence-face default "Gold" nil)
     (kom-first-line-face bold nil nil)
     (kom-dashed-lines-face nil nil "#0a0a0a")
     (kom-async-text-body-face nil nil "#181818")
     (kom-async-dashed-lines-face nil nil "#0a0a0a")
     (kom-text-body-face nil nil "#181818")
     (kom-dim-face nil "DarkSlateGray")
     (kom-friends-face nil "Gold" "Black")
     (kom-morons-face nil "Gold" "Black")
     (kom-warning-face bold "Red" nil)
     (property expected-background "black")
     )
    (black-and-tan
      (kom-active-face default "#602000" nil)
      (kom-url-face default "#800040" nil)
      (kom-me-face bold "#602000" "#f0f0e0")
      (kom-highlight-face highlight nil nil)
      (kom-text-face default nil nil)
      (kom-subject-face default nil nil)
      (kom-text-no-face kom-active-face nil nil)
      (kom-friends-face default "#602000" "#f0f0e0")
      (kom-morons-face default "#602000" "#ffffc0")
      (kom-presence-face italic "grey" nil)
      (kom-mark-face bold "#602000" "#f0f0e0")
      (kom-warning-face bold "red" nil)
      (kom-first-line-face bold nil nil)
      (kom-dim-face default "gray" nil)
      (kom-text-body-face nil nil "#f8f8f0")
      (kom-dashed-lines-face nil nil "#f0f0e0")
      (kom-async-text-body-face nil nil "#f8f8f0")
      (kom-async-dashed-lines-face nil nil "#f0f0e0")
      (property expected-background "white")
      )
    (inverse
     (kom-active-face default "lightblue" nil)
     (kom-url-face default "Moccasin" nil)
     (kom-me-face bold "gold" "black")
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default "Khaki" nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face default "red" nil)
     (kom-morons-face default "yellow" nil)
     (kom-presence-face italic "grey" nil)
     (kom-mark-face default "gold" "black")
     (kom-warning-face bold "red" nil)
     (kom-first-line-face bold nil nil)
     (kom-dim-face default "gray" nil)
     (kom-dashed-lines-face nil nil "#101010")
     (kom-text-body-face nil nil "#080808")
     (kom-async-dashed-lines-face nil nil "#101030")
     (kom-async-text-body-face nil nil "#000020")
     (property expected-background "black")
     )
    (monochrome
     (kom-text-body-face nil nil nil)
     (kom-async-dashed-lines-face nil nil nil)
     (kom-async-text-body-face nil nil nil)
     (kom-dashed-lines-face nil nil nil)
     (kom-active-face default nil nil)
     (kom-url-face default nil nil)
     (kom-me-face bold nil nil)
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face underline nil nil)
     (kom-morons-face strikethrough nil nil)
     (kom-presence-face italic nil nil)
     (kom-mark-face bold nil "black")
     (kom-warning-face bold nil nil)
     (kom-first-line-face bold nil nil)
     (kom-dim-face default nil nil)
     (property expected-background "white")
     )
    (minimal
     (kom-active-face default nil nil)
     (kom-url-face default nil nil)
     (kom-me-face default nil "lavender")
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face default nil nil)
     (kom-friends-face default nil "alice blue")
     (kom-morons-face default nil "red")
     (kom-presence-face italic "dim gray" nil)
     (kom-mark-face default nil "black")
     (kom-warning-face bold nil nil)
     (kom-first-line-face nil nil nil)
     (kom-dashed-lines-face nil nil nil)
     (kom-text-body-face nil nil nil)
     (kom-async-dashed-lines-face nil nil nil)
     (kom-async-text-body-face nil nil nil)
     (kom-dim-face default nil nil)
     (property expected-background "white")
     )
    (highlight
     (kom-active-face    default   nil          "aliceblue")
     (kom-url-face       default   nil          "yellow")
     (kom-me-face        bold      "darkblue"   "thistle")
     (kom-highlight-face highlight nil          nil)
     (kom-text-face      default   nil          nil)
     (kom-text-no-face   default   nil          nil)
     (kom-friends-face   default   "darkblue"   "thistle")
     (kom-morons-face    strikethrough   "red"        "seagreen")
     (kom-subject-face   default   nil          nil)
     (kom-presence-face  italic    "dim gray"   nil)
     (kom-mark-face      bold      "darkblue"   "thistle")
     (kom-warning-face   bold      "yellow"     "red")
     (kom-first-line-face nil  nil          "lavender")
     (kom-dashed-lines-face nil  nil          "lavender")
     (kom-text-body-face nil nil "#f8f8ff")
     (kom-async-dashed-lines-face nil  nil          "lavender")
     (kom-async-text-body-face nil nil "#f8f8ff")
     (kom-dim-face       default   "gray"       nil)
     (property expected-background "white")
     ))
  "*Face schemes for LysKOM.

This variable is an association list that defines the face and color
schemes in LysKOM. The car of each element is the scheme key, a
symbol, and the cdr is a list of face definitions. Each face
definition in turn is a list of four elements: the face name, the base
face, foreground color and background color. When LysKOM defines a
face from such a specification, the base face is first copied (unless
it is nil) and then the foreground and background colors are set. If
it permissible to substitute nil for any element except the face name.

For instance, (kom-me-face bold \"yellow\" \"red\") will cause kom-me-face
to be bold with yellow text on a red background."
)


;;; ============================================================
;;; History lists
;;;

(defvar lyskom-command-history nil)
(defvar lyskom-expression-history nil)
(defvar lyskom-message-history nil)
(defvar lyskom-language-history nil)
(defvar lyskom-fast-reply-history nil)
(defvar lyskom-help-history nil)


;;; ============================================================

(defconst lyskom-comment-types-list '(COMM-IN FOOTN-IN))
(defconst lyskom-recpt-types-list '(RECPT CC-RECPT BCC-RECPT))
(defconst lyskom-review-types-list '(REVIEW REVIEW-TREE
                                            REVIEW-MARK REVIEW-FAQ))

(eval-and-compile (provide 'lyskom-vars))

;;; vars.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: macros.el,v 44.29 2002/06/12 18:29:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: macros.el
;;;;
;;;; This file contains the macros which must be loaded before lyskom can
;;;; be compiled.
;;;;

(setq lyskom-clientversion-long
      (concat lyskom-clientversion-long
	      "$Id: macros.el,v 44.29 2002/06/12 18:29:32 byers Exp $\n"))

;;;
;;; Require parts of the widget package. We do this to avoid generating
;;; errors later on. This sucks. 
;;;

(require 'custom)
(require 'widget)

;;; ======================================================================
;;; lyskom-traverse - traverse a sequence.
;;;

(defmacro lyskom-traverse (atom sequence &rest body)
  "Bind ATOM to each element in SEQUENCE and execute BODY.
Value returned is always nil."
  `(let* ((__i__ 0)
          (__sequence__ ,sequence)
          (__len__ (or (listp __sequence__ )
                       (length __sequence__)))
          (,atom nil)
          (__result__ nil))
     (setq __result__ __result__)       ; Get rid of compiler warnings
     (if (listp __sequence__)
         (while __sequence__
           (setq ,atom (car __sequence__))
           ,@body
           (setq __sequence__ (cdr __sequence__)))
       (while (< __i__ __len__)
         (setq ,atom (aref __sequence__ __i__))
         ,@body
         (setq __i__ (1+ __i__))))
     __result__))
  

(defmacro lyskom-traverse-break (&optional result)
  "Break a current lyskom-traverse"
  `(progn (setq __len__ 0)
          (setq __sequence__ nil)
          (setq __result__ (or ,result __result__))))

(defmacro lyskom-traverse-aux (atom sequence &rest body)
  "Bind ATOM to each element in SEQUENCE and execute BODY.
Value returned is always nil."
  (let ((seq (make-symbol "aux-items")))
    (` (let (((, seq) (, sequence))
             ((, atom) nil))
         (while (, seq)
           (setq (, atom) (car (, seq)))
           (if (not (aux-item-flags->deleted
                     (aux-item->flags (, atom))))
               (progn (,@ body)))
           (setq (, seq) (cdr (, seq))))))))


(put 'lyskom-traverse-aux 'edebug-form-spec
     '(sexp form body))

(put 'lyskom-traverse-aux 'lisp-indent-hook 2)

(put 'lyskom-traverse 'edebug-form-spec
     '(sexp form body))


;;; ======================================================================
;;; lyskom-save-excursion Does not save point and mark.
;;;

(defmacro lyskom-save-excursion (&rest forms)
  "Save-excursion without saving point and mark."
  (list 'let (list '(__buffer__ (current-buffer)))
	(list 'unwind-protect
	      (cons 'progn
		    forms)
	      '(set-buffer __buffer__))))

(put 'lyskom-save-excursion 'edebug-form-spec t)
(put 'lyskom-save-excursion 'lisp-indent-hook 0)

;;; ======================================================================
;;; Some useful macros to make the code more readable.
;;;

(defmacro char-in-string (char string)
  "Return t if the character CHAR is member of STRING. Otherwise return nil."
  (list 'null
	(list 'not
	      (list 'string-match
		    (list 'regexp-quote
			  (list 'char-to-string char))
		    string))))

(defmacro ++ (var)
  "Increment the variable VAR and return the value."
  (list 'setq var (list '1+ var)))

(defmacro -- (var)
  "Decrement the variable VAR and return the value."
  (list 'setq var (list '1- var)))

(eval-and-compile
  (if (fboundp 'when)
      nil
    (defmacro when (expr &rest body)
      "Execute BODY if EXPR evaluates to non-nil"
      (list 'if expr (cons 'progn body)))
    (put 'when lisp-indent-function 1)
    (put 'when 'edebug-form-spec t)))

(eval-and-compile
  (if (fboundp 'unless)
      nil
    (defmacro unless (expr &rest body)
      "Execute BODY if EXPR evaluates to non-nil"
      (append (list 'if expr nil) body))
    (put 'unless lisp-indent-function 1)
    (put 'unless 'edebug-form-spec t)))


;;; ======================================================================
;;; Multiple blocking read from server
;;;

(defmacro blocking-do-multiple (bind-list &rest body)
  "Bind variables according to BIND-LIST and then eval BODY.
The value of the last form in BODY is returned.
Each element in BIND-LIST is a list (SYMBOL FORM) which binds SYMBOL to
the result of the server call FORM, which is the same as used in blocking-do.
All the forms in BIND-LIST are evaluated before any symbols are bound."
  (let ((bindsym 'multiple-bind-sym)
	(index 0))
    (` (let (((, bindsym)
	      (lyskom-blocking-do-multiple
	       (list (,@ (mapcar (function (lambda (x) 
					     (` (list '(, (car (car (cdr x))))
						      (,@ (cdr (car (cdr x))))))))
			   bind-list))))))
	 (let ((,@ (mapcar (function 
			    (lambda (bpat)
			      (prog1
				  (` ((, (car bpat))
				      (elt (, bindsym) (, index))))
				(setq index (1+ index)))))
			   bind-list)))
	   (,@ body))))))

(put 'blocking-do-multiple 'edebug-form-spec
     '(sexp body))

(put 'blocking-do-multiple 'lisp-indent-function 1)


;;; ======================================================================
;;; Some commands generat async messages we don't really want
;;;

(defmacro lyskom-ignoring-async (async &rest body)
  `(let ((lyskom-ignoring-async-list 
          (cons (list ,@async) lyskom-ignoring-async-list)))
     ,@body))

(put 'lyskom-ignoring-async 'edebug-form-spec
     '(sexp body))

(put 'lyskom-ignoring-async 'lisp-indent-function 1)


;;; ======================================================================
;;; These macros do magic things to the compiler to avoid gratuitous
;;; compiler warnings.
;;;

(eval-and-compile (defvar lyskom-expected-unresolved-functions nil))

(defmacro lyskom-external-function (fn)
  (` (eval-when-compile
       (setq lyskom-expected-unresolved-functions
             (cons (quote (, fn))
                   lyskom-expected-unresolved-functions)))))

(defmacro lyskom-end-of-compilation ()
  (` 
   (eval-when-compile
     (progn
       (if (and (boundp 'byte-compile-unresolved-functions)
                (consp (car-safe byte-compile-unresolved-functions))
                (symbolp (car-safe (car-safe 
                                    byte-compile-unresolved-functions))))
           (progn
             (mapcar (function (lambda (x)
                                 (setq byte-compile-unresolved-functions
                                       (delq
                                        (assq x
                                              byte-compile-unresolved-functions)
                                        byte-compile-unresolved-functions))))
                     lyskom-expected-unresolved-functions)
             (mapcar (function (lambda (x)
                                 (setq byte-compile-unresolved-functions
                                       (delq
                                        (assq x
                                              byte-compile-unresolved-functions)
                                        byte-compile-unresolved-functions))))
                     lyskom-compatibility-definitions)))
       (if lyskom-compatibility-definitions
           (message "Compatibility definitions: %s"
                    (mapconcat '(lambda (sym)
                                  (symbol-name sym))
                               lyskom-compatibility-definitions
                               ", ")))))))

;;; ============================================================
;;; Keymap handling
;;;

(defmacro lyskom-use-local-map (keymap)
  "Use keymap KEYMAP as local map in this buffer. KEYMAP is made local in
the current buffer, and its value is copied from the LysKOM buffer."
  (` (progn (make-local-variable (quote (, keymap)))
            (setq (, keymap)
                  (lyskom-default-value (quote (, keymap))))
            (use-local-map (, keymap)))))


;;; ============================================================
;;; Widget gunk
;;;

(defmacro lyskom-widget-wrapper (fn file)
  `(eval-and-compile
     (if (not (fboundp ',fn))
         (autoload ',fn ,file))))

(lyskom-widget-wrapper define-widget "widget")
(lyskom-widget-wrapper widget-at "wid-edit")
(lyskom-widget-wrapper widget-value "wid-edit")
(lyskom-widget-wrapper widget-button-click "wid-edit")
(lyskom-widget-wrapper widget-setup "wid-edit")
(lyskom-widget-wrapper widget-value-set "wid-edit")
(lyskom-widget-wrapper widget-insert "wid-edit")
(lyskom-widget-wrapper widget-create "wid-edit")
(lyskom-widget-wrapper widget-get "wid-edit")
(lyskom-widget-wrapper widget-put "wid-edit")

;;; ============================================================
;;; Signal gunk
;;;

(defmacro lyskom-ignore-errors (&rest forms)
  (` (condition-case nil
         (progn (,@ forms))
       (error nil))))

(put 'ignore-errors 'edebug-form-spec
     '(sexp form body))


;;; ============================================================
;;; Local variables
;;;

(defmacro lyskom-setq-default (name value)
  (` (lyskom-set-default (quote (, name))
                         (, value))))


(eval-and-compile (provide 'lyskom-macros))

;;; Local Variables: 
;;; eval: (put 'lyskom-traverse 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-save-excursion 'lisp-indent-hook 0)
;;; eval: (put 'lyskom-ignore-errors 'lisp-indent-hook 2)
;;; end: 
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: compatibility.el,v 44.60 2002/08/06 19:43:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;; Copyright (C) 2001 Free Software Foundation, Inc.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: compatibility.el
;;;;
;;;; This file contains functions that may not exist in all supported
;;;; versions of Gnu Emacs. XEmacs-specific and Emacs 18-specific code
;;;; should go in some other file.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: compatibility.el,v 44.60 2002/08/06 19:43:32 byers Exp $\n"))


;;; ======================================================================
;;; Use lyskom-provide to supply a definition that is only to be used
;;; if no definition already exists. The definition will be evaluated at
;;; both compile and run time.
;;;
;;; lyskom-provide-macros behaves like defmacro
;;; lyskom-provide-function behaves like defun
;;; lyskom-provide-subst behaves like defsubst
;;;

(eval-and-compile
  (defvar lyskom-compatibility-definitions nil
    "Functions defined or redefined because they are incompatible with
LysKOM"))

;;; ============================================================
;;; lyskom-compatibility-forms
;;; lyskom-compatibility-definition
;;;


(defmacro lyskom-compatibility-forms (predicate &rest forms)
  "If PREDICATE is nil, evaluate FORMS at compile and run time"
  (` (eval-and-compile
       (if (not (, predicate))
           (progn (,@ forms))))))

(defmacro lyskom-compatibility-definition (predicate definition)
  "If PREDICATE is nil, evaluate DEFINITION at compile and run time.
Definition should be a function definition of some kind, with syntax 
similar to defun or defmacro.

To simply define a function if it is not already defined, used one
of the lyskom-provide-* functions instead."
  (` (progn ;(eval-when-compile
            ;  (if (not (, predicate))
            ;      (message "Compatibility %S for %S"
            ;               (quote (, (car definition)))
            ;               (quote (, (car (cdr definition)))))))
              (eval-and-compile
                (if (not (, predicate))
                    (progn
                      (, definition)
                      (setq lyskom-compatibility-definitions
                            (cons (quote (, (car (cdr definition))))
                                  lyskom-compatibility-definitions))))))))


;;; ============================================================
;;; lyskom-provide
;;; lyskom-provide-macro
;;; lyskom-provide-function
;;; lyskom-provide-subst
;;;
;;; Define functions if they are not already defined
;;;

(defmacro lyskom-provide (definer name rest)
  `(eval-and-compile
     (if (not (fboundp ',name))
         (progn (setq lyskom-compatibility-definitions
                      (cons ',name lyskom-compatibility-definitions))
                (,definer ,name ,@rest)))))


(defmacro lyskom-provide-macro (name &rest rest)
  "If NAME is not already defined, define it as a macro."
  (` (lyskom-provide defmacro (, name) (, rest))))

(defmacro lyskom-provide-function (name &rest rest)
  "If NAME is not already defined, define it as a function."
  (` (lyskom-provide defun (, name) (, rest))))

(defmacro lyskom-provide-subst (name &rest rest)
  "If NAME is not already defined, define it as a defsubst."
  (` (lyskom-provide defsubst (, name) (, rest))))


;;; ============================================================
;;; lyskom-xemacs-or-gnu
;;;

(eval-and-compile
  (defmacro lyskom-xemacs-or-gnu (xemacs-form gnu-form)
    "Eval XEMACS-FORM in XEmacs and GNU-FORM in Gnu Emacs."
    (if (string-match "XEmacs" (emacs-version))
        xemacs-form
      gnu-form)))

(put 'lyskom-xemacs-or-gnu 'edebug-form-spec '(form form))



;;; ======================================================================
;;; Defining keys
;;;
;;; Lots of Emacsen have buggy definitions of kbd (or no definition at all)
;;; Although it's crufty to redefine a function from subr.el, I will do so
;;; if it appears to be misbehaving. Don't like it? Tough!
;;;

(lyskom-compatibility-definition
    (condition-case nil
        (or (equal (kbd (identity "<down-mouse-2>"))
                   [down-mouse-2])
            (error "Bad definition of kbd"))
      (error nil))

    (defmacro kbd (keys)
      "Convert KEYS to the internal Emacs key representation.
KEYS should be a string in the format used for saving keyboard macros
\(see `insert-kbd-macro')."
      (if (or (stringp keys)
              (vectorp keys))
          (read-kbd-macro keys)
        `(read-kbd-macro ,keys))))


;;; ======================================================================
;;; ======================================================================
;;; ======================================================================

;;;


(lyskom-provide-macro char-before (&optional pos buffer)
  `(save-excursion
     (save-restriction 
       (widen)
       ,@(if buffer `((set-buffer ,buffer)))
       ,(if pos 
	    `(if (or (> ,pos (point-max))
		     (<= ,pos (point-min)))
		 nil
	       (goto-char ,pos)
	       (preceding-char))
	   `(if (<= (point) (point-min))
		nil
	      (preceding-char))))))
		       

(lyskom-provide-function characterp (obj)
  (integerp obj))

(lyskom-provide-function int-to-char (obj)
  obj)

(lyskom-compatibility-forms (fboundp 'frame-width)
    (fset 'frame-width 'screen-width))

(lyskom-provide-function signum (num)
  (cond ((< num 0) -1)
        ((> num 0) 1)
        (t 0)))


;;; ======================================================================
;;; Definition of map-keymap that hopefully works like the one in XEmacs
;;; except that the sort-first argument is ignored.
;;;

(lyskom-provide-function map-keymap (fn keymap &optional sort-first)
  (let ((r 0))
    (cond ((vectorp keymap)
           (while (< r (length keymap))
             (if (aref keymap r)
                 (funcall fn r (aref keymap r)))
             (setq r (1+ r))))
          (t (mapcar (function 
                      (lambda (x)
                        (funcall fn (car x) (cdr x))))
                     (cdr keymap))))))


(lyskom-provide-function set-keymap-parent (keymap new-parent)
   (let ((tail keymap))
     (while (and tail (cdr tail) (not (eq (car (cdr tail)) 'keymap)))
       (setq tail (cdr tail)))
     (if tail
         (setcdr tail new-parent))))

(defconst lyskom-gnu-keysym
  '((button1   . "<down-mouse-1>")
    (button2   . "<down-mouse-2>")
    (button3   . "<down-mouse-3>")
    (button1up . "<mouse-1>")
    (button2up . "<mouse-2>")
    (button3up . "<mouse-3>")
    (	       . [229])
    (	       . [197])
    (C-       . [(control 229)])
    (C-       . [(control 197)])
    (	       . [228])
    (	       . [196])
    (	       . [246])
    (	       . [214])
))

(defconst lyskom-xemacs-keysym
  '((button1   . "<button1>")
    (button2   . "<button2>")
    (button3   . "<button3>")
    (button1up . "<button1up>")
    (button2up . "<button2up>")
    (button3up . "<button3up>")
    (C-       . [(control aring)])
    (C-       . [(control Aring)])
    (	       . [aring])
    (	       . [Aring])
    (	       . [adiaeresis])
    (	       . [Adiaeresis])
    (	       . [odiaeresis])
    (	       . [Odiaeresis])
))


(defun lyskom-keys (sym)
  "Look up the key description for key SYM."
  (cdr (assq sym (lyskom-xemacs-or-gnu lyskom-xemacs-keysym
                                       lyskom-gnu-keysym))))


;;; ============================================================
;;; Text property and extents stuff
;;;

(lyskom-provide-function map-extents (&rest args))

(lyskom-provide-function next-text-property-bounds 
    (count pos prop &optional object)
  "Return the COUNTth bounded property region of property PROP after POS.
If COUNT is less than zero, search backwards.  This returns a cons
\(START . END) of the COUNTth maximal region of text that begins after POS
\(starts before POS) and has a non-nil value for PROP.  If there aren't
that many regions, nil is returned.  OBJECT specifies the buffer or
string to search in."
  (or object (setq object (current-buffer)))
  (let ((begin (if (stringp object) 0 (point-min)))
	(end (if (stringp object) (length object) (point-max))))
    (catch 'hit-end
      (if (> count 0)
	  (progn
	    (while (> count 0)
	      (if (>= pos end)
		  (throw 'hit-end nil)
		(and (get-char-property pos prop object)
		     (setq pos (next-single-property-change pos prop
							    object end)))
		(setq pos (next-single-property-change pos prop object end)))
	      (setq count (1- count)))
	    (and (< pos end)
		 (cons pos (next-single-property-change pos prop object end))))
	(while (< count 0)
	  (if (<= pos begin)
	      (throw 'hit-end nil)
	    (and (get-char-property (1- pos) prop object)
		 (setq pos (previous-single-property-change pos prop
							    object begin)))
	    (setq pos (previous-single-property-change pos prop object
						       begin)))
	  (setq count (1+ count)))
	(and (> pos begin)
	     (cons (previous-single-property-change pos prop object begin)
		   pos))))))


;;; ============================================================
;;; Basic stuff

(lyskom-provide-function char-to-int (c) c)

(defvar enable-multibyte-characters nil)
(lyskom-provide-function set-buffer-multibyte (arg)
  (put 'enable-multibyte-characters 'permanent-local t)
  (make-local-variable 'enable-multibyte-characters)
  (setq enable-multibyte-characters arg))

(lyskom-provide-function set-process-coding-system (proc &optional encoding decoding)
  ) 

(lyskom-provide-function encode-coding-string (str coding-system) (copy-sequence str))
(lyskom-provide-function decode-coding-string (str coding-system) (copy-sequence str))
(lyskom-provide-function string-bytes (str) (length str))
(lyskom-provide-function check-coding-system (name) (error "No such coding system"))
(lyskom-provide-function find-coding-systems-for-charsets (cs) nil)
(lyskom-provide-function coding-system-get (cs prop) nil)
(lyskom-provide-function string-width (str) (length str))
(lyskom-provide-function char-width (c) 1)
(lyskom-provide-function find-charset-string (str) '(ascii))
(lyskom-provide-function string-as-unibyte (str) str)
(lyskom-provide-function string-make-unibyte (str) str)
(lyskom-provide-function string-make-multibyte (str) str)
(lyskom-provide-function multibyte-string-p (str) nil)


;;; Detect buggy versions of encode-coding-string and decode-coding-string
;;; such as those provided by APEL (part of TM and often included in XEmacs)

(defun lyskom-buggy-encode-coding-string (str coding-system) str)
(eval-and-compile
  (if (let ((test "TEM")) (eq (encode-coding-string test 'raw-text) test))
      (progn (fset 'lyskom-buggy-encode-coding-string
                   (symbol-function 'encode-coding-string))
             (defun encode-coding-string (str coding-system)
               (copy-sequence (lyskom-buggy-encode-coding-string str coding-system))))))

(defun lyskom-buggy-decode-coding-string (str coding-system) str)
(eval-and-compile
  (if (let ((test "TEM")) (eq (decode-coding-string test 'raw-text) test))
      (progn (fset 'lyskom-buggy-decode-coding-string
                   (symbol-function 'decode-coding-string))
             (defun decode-coding-string (str coding-system)
               (copy-sequence (lyskom-buggy-decode-coding-string str coding-system))))))


;; defmacro lyskom-encode-coding-char in XEmacs so the compiled code
;; is quicker. In Gnu Emacs define it as a function.
;;
;; The definition is made at compile-time to avoid getting warnings 
;; about encode-coding-char.

(eval-and-compile
  (cond ((eval-when-compile (string-match "XEmacs" (emacs-version)))
         (defmacro lyskom-encode-coding-char (c system) c))
        ((eval-when-compile (fboundp 'encode-coding-char))
         (defun lyskom-encode-coding-char (c system)
           (let ((s (encode-coding-char c system)))
             (if (and s (= (length s) 1))
                 (elt s 0)))))
        (t (defmacro lyskom-encode-coding-char (c system) c))))


(eval-and-compile
  (lyskom-xemacs-or-gnu
   (fset 'lyskom-string-width (symbol-function 'string-width))
   (defun lyskom-string-width (str)
     (cond ((and (multibyte-string-p str)
                 (null enable-multibyte-characters))
            (string-width (string-make-unibyte str)))
           ((and (null (multibyte-string-p str))
                 enable-multibyte-characters)
            (string-width (string-make-multibyte str)))
           (t (string-width str))))))


(eval-and-compile
  (cond ((eval-when-compile (string-match "XEmacs" (emacs-version)))
         (defun lyskom-completing-read (prompt
                                        table 
                                        &optional predicate require-match
                                        init hist def inherit-input-method)
           (completing-read prompt table predicate require-match init hist)))
        ((eval-when-compile (> emacs-major-version 19))
         (fset 'lyskom-completing-read (symbol-function 'completing-read)))
        (t 
         (defun lyskom-completing-read (prompt
                                        table 
                                        &optional predicate require-match
                                        init hist def inherit-input-method)
           (completing-read prompt table predicate require-match init hist)))))

(eval-and-compile
  (cond ((eval-when-compile (string-match "XEmacs" (emacs-version)))
	 (defun lyskom-read-from-minibuffer (prompt 
					     &optional initial-contents
					     keymap read hist default-value
					     inherit-input-method)
	   (read-from-minibuffer prompt
				 initial-contents
				 keymap
				 read
				 hist)))
	((eval-when-compile (> emacs-major-version 19))
	 (fset 'lyskom-read-from-minibuffer 
	       (symbol-function 'read-from-minibuffer)))
	(t (defun lyskom-read-from-minibuffer (prompt 
					       &optional initial-contents
					       keymap read hist default-value
					       inherit-input-method)
	     (read-from-minibuffer prompt
				   initial-contents
				   keymap
				   read
				   hist)))))

(lyskom-external-function temp-minibuffer-message)
(lyskom-provide-function minibuffer-message (message)
  (temp-minibuffer-message message))


(lyskom-provide-function last (x &optional n)
  "Returns the last link in the list LIST.
With optional argument N, returns the Nth-to-last link (default 1)."
  "Returns the last link in the list LIST.
With optional argument N, returns Nth-to-last link (default 1)."
  (if n
      (let ((m 0) (p x))
	(while (consp p) (setq m (1+ m)) (setq p (cdr p)))
	(if (<= n 0) p
	  (if (< n m) (nthcdr (- m n) x) x)))
    (while (consp (cdr x)) (setq x (cdr x)))
    x))

(lyskom-provide-function plist-member (plist prop)
  "Return non-nil if PLIST has the property PROP.
PLIST is a property list, which is a list of the form
\(PROP1 VALUE1 PROP2 VALUE2 ...\). PROP is a symbol.
Unlike `plist-get', this allows you to distinguish between a missing
property and a property with the value nil."
      (while (and plist (not (eq (car plist) prop)))
        (setq plist (cdr (cdr plist))))
      (and plist t))

;; The make-temp-file function below is taken verbatim from Emacs 21.2.
(lyskom-provide-function make-temp-file (prefix &optional dir-flag)
  "Create a temporary file.  The returned file name (created by
appending some random characters at the end of PREFIX, and expanding
against `temporary-file-directory' if necessary, is guaranteed to
point to a newly created empty file.  You can then use `write-region'
to write new data into the file.

If DIR-FLAG is non-nil, create a new empty directory instead of a file."
  (let (file)
    (while (condition-case ()
	       (progn
		 (setq file
		       (make-temp-name
			(expand-file-name prefix 
                                          (lyskom-xemacs-or-gnu
                                           (temp-directory)
                                           temporary-file-directory))))
		 (if dir-flag
		     (make-directory file)
		   (write-region "" nil file nil 'silent nil 'excl))
		 nil)
             (file-already-exists t))
      ;; the file was somehow created by someone else between
      ;; `make-temp-name' and `write-region', let's try again.
      nil)
    file))


;;; ================================================================
;;; Faces

(lyskom-provide-function reset-face (face &optional locale tag-set exact-p)
  )

(lyskom-provide-function lyskom-face-background-name (face)
  (face-background face))

(lyskom-provide-function lyskom-face-foreground-name (face)
  (face-foreground face))


(lyskom-provide-function find-face (face)
  (and (facep face) face))

(defun lyskom-make-face (name temporary)
  "Like make-face in XEmacs"
  (lyskom-xemacs-or-gnu (make-face name nil temporary)
                        (make-face name)))

(if (not (find-face 'strikethrough))
    (progn (make-face 'strikethrough)
           (if (eval-when-compile (fboundp 'set-face-strikethrough-p))
               (set-face-strikethru-p 'strikethrough t)
             (set-face-underline-p 'strikethrough t))))


;;; ======================================================================
;;; Event stuff

(lyskom-external-function event-start)
(lyskom-provide-function event-point (e)
  "Return the character position of the given mouse event.
If the event did not occur over a window, or did not occur over text,
then this returns nil.  Otherwise, it returns an index into the buffer
visible in the event's window."
  (car (cdr (event-start e))))

(lyskom-provide-function event-closest-point (e)
  "Return the character position closest to the mouse event EVENT."
  (car (cdr (event-start e))))

(lyskom-provide-function event-glyph (e))


(defun lyskom-get-buffer-window-list (buffer &optional minibuf frame)
  "Return windows currently displaying BUFFER, or nil if none.
See `walk-windows' for the meaning of MINIBUF and FRAME."
  (let ((buffer (if (bufferp buffer) buffer (get-buffer buffer))) windows)
    (walk-windows (function (lambda (window)
			      (if (eq (window-buffer window) buffer)
				  (setq windows (cons window windows)))))
		  minibuf frame)
    windows))

(lyskom-provide-function 
 replace-in-string (str regexp newtext &optional literal)
  "Replaces all matches in STR for REGEXP with NEWTEXT string.
Optional LITERAL non-nil means do a literal replacement.
Otherwise treat \\ in NEWTEXT string as special:
  \\& means substitute original matched text,
  \\N means substitute match for \(...\) number N,
  \\\\ means insert one \\."
  (if (not (stringp str))
      (error "(replace-in-string): First argument must be a string: %s" str))
  (if (stringp newtext)
      nil
    (error "(replace-in-string): 3rd arg must be a string: %s"
	   newtext))
  (let ((rtn-str "")
	(start 0)
	(special)
	match prev-start)
    (while (setq match (string-match regexp str start))
      (setq prev-start start
	    start (match-end 0)
	    rtn-str
	    (concat
	      rtn-str
	      (substring str prev-start match)
	      (cond (literal newtext)
		    (t (mapconcat
			 (function
			   (lambda (c)
			     (if special
				 (progn
				   (setq special nil)
				   (cond ((eq c ?\\) "\\")
					 ((eq c ?&)
					  (substring str
						     (match-beginning 0)
						     (match-end 0)))
					 ((and (>= c ?0) (<= c ?9))
					  (if (> c (+ ?0 (length
							   (match-data))))
					      ;; Invalid match num
					      (error "(replace-in-string) Invalid match num: %c" c)
					    (setq c (- c ?0))
					    (substring str
						       (match-beginning c)
						       (match-end c))))
					 (t (char-to-string c))))
			       (if (eq c ?\\) (progn (setq special t) nil)
				 (char-to-string c)))))
			 newtext ""))))))
    (concat rtn-str (substring str start))))


(lyskom-provide-function buffer-live-p (object)
  "T of OBJECT is an editor buffer that has not been deleted."
  (and (bufferp object)
       (buffer-name object)))

;;; ================================================================
;;; Color stuff

(lyskom-external-function set-specifier)
(lyskom-external-function make-specifier)
(lyskom-external-function color-rgb-components)

(lyskom-compatibility-definition (not (and (fboundp 'color-rgb-components) 
                                           (fboundp 'make-specifier)))
    (defun lyskom-color-values (color)
      (when (stringp color)
        (let ((spec nil))
          (set-specifier (setq spec (make-specifier 'color)) color)
          (setq color spec)))
      (color-rgb-components color)))

(eval-and-compile
  (cond ((fboundp 'lyskom-color-values) nil)
        ((fboundp 'color-values) (fset 'lyskom-color-values 'color-values))
        ((fboundp 'x-color-values) (fset 'lyskom-color-values 'x-color-values))))


;;; ======================================================================
;;; Platform-specific stuff

(lyskom-provide-function w32-shell-execute (&rest args)
  "Dummy function that raises an error."
  (error "w32-shell-execute undefined"))

;; This code looks the way it does in order to avoid warnings in
;; Emacs 21.

(eval-and-compile
  (condition-case nil
      (symbol-value ':default-help-echo)
    (error (set ':default-help-echo ':default-help-echo)))
  (condition-case nil
      (symbol-value ':group)
    (error (set ':group ':group))))




;;; Local Variables:
;;; eval: (put 'lyskom-provide-macro 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-provide-function 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-provide-subst 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-compatibility-forms 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-compatibility-definition 'lisp-indent-hook 2)
;;; end:
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: language.el,v 44.26 2002/05/24 12:42:44 davidk Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: language.el
;;;; Author: Niels Mller
;;;;
;;;;

(require 'lyskom-vars "vars")

;;; Variables

;;(defvar lyskom-language-symbols nil
;;  "Symbols with language data bound to them")

(defvar lyskom-languages nil
  "An alist of defined languages.
Each entry is a pair (SYMBOL . (NAME NAME ...)) where symbol is the symbol
used for identification, and the NAMEs are names of the language.")

(defvar lyskom-language-categories nil
  "Categories of language-specific variables.
Each element is a cons cell (NAME . SCOPE), where NAME is the name of
the category and SCOPE is its scope (global or local).")

(defvar lyskom-language-vars nil
  "A list of all language-dependent variables.
Each element is a cons cell (NAME . SCOPE), where NAME is the name of
the category and SCOPE is its scope (global or local).")


(defun lyskom-language-var-internal (scope var language val)
  "Defines a language-local variable value."
  (or (assq var lyskom-language-vars)
      (setq lyskom-language-vars
	    (cons (cons var scope) lyskom-language-vars)))
  (let* ((alist (get var 'lyskom-language-var))
	 (entry (assq language alist)))
    (if entry
	(setcdr entry val)
      (put var 'lyskom-language-var (cons (cons language val) alist)))))

(defmacro lyskom-language-var (scope var language val)
  `(lyskom-language-var-internal ',scope
                                 ',var
                                 ',language
                                 ',val))

(put 'lyskom-language-var 'lisp-indent-function 2)

(defun lyskom-set-language-vars (language scope)
  "Set language-specific variables to values for LANGUAGE.
SCOPE must be one of global or local, and specifies the scope of the change.
If SCOPE is global, change all variables, even those that affect multiple
sessions."
  (mapcar
   (lambda (spec)
     (let ((var (car spec))
           (var-scope (cdr spec)))
       (when (or (eq scope 'global) (eq var-scope 'local))
         (when (or (not (symbol-value var))
                   (get var 'lyskom-language-force))
           (set var (eval (cdr (assq language
                                     (get var 'lyskom-language-var)))))))))
   lyskom-language-vars))

;;; Keymaps

(defvar lyskom-language-keymaps nil
  "A list of all language-dependent keymaps.")

(defun lyskom-language-keymap-internal (keymap language langmap)
  "Defines a language-local keymap."
  ;; If the "real" keymap has no value, set it to an empty keymap
  (if (eval keymap)
      nil
    (set keymap (make-sparse-keymap)))
  ;; Add it to the list of keymaps
  (or (memq keymap lyskom-language-keymaps)
      (setq lyskom-language-keymaps
	    (cons keymap lyskom-language-keymaps)))
  ;; Modify the property list
  (let* ((alist (get keymap 'lyskom-language-keymap))
	 (entry (assq language alist)))
    (if entry
	(setcdr entry langmap)
      (put keymap 'lyskom-language-keymap
	   (cons (cons language langmap) alist)))))

(defmacro lyskom-language-keymap (keymap language langmap)
  `(lyskom-language-keymap-internal ',keymap
                                    ',language
                                    ',langmap))

(put 'lyskom-language-keymap 'lisp-indent-function 2)

(defun lyskom-set-language-keymaps (language)
  (mapcar
   (lambda (map)
     (set-keymap-parent (symbol-value map)
                        (eval (cdr (assq language
                                         (get map
                                              'lyskom-language-keymap))))))
   lyskom-language-keymaps))

;(defun lyskom-set-language-keymaps (language)
;  (mapcar
;   (function
;    (lambda (map)
;      (setcdr (symbol-value map)
;	      (eval (cdr (assq language
;			       (get map 'lyskom-language-keymap)))))))
;   lyskom-language-keymaps))

;;; String catalogs

(defun lyskom-language-strings-internal (scope category language alist)
  "Associates names to symbols.
See documentation of lyskom-language-strings for information on the 
parameters to this function."
  ;; Record category
  (or (assq category lyskom-language-categories)
      (setq lyskom-language-categories
	    (cons (cons category scope) lyskom-language-categories)))
  (let ((record (get category 'lyskom-language-symbols)))
    (mapcar (lambda (pair)
              (let* ((symbol (car pair))
                     (string (cdr pair))
                     (llist (get symbol category))
                     (entry (assq language llist)))
                ;; Record symbol
                (or (memq symbol record)
                    (setq record (cons symbol record)))
                (if entry
                    (setcdr entry string)
                  (put symbol category (cons (cons language string) llist)))))
	    alist)
    (put category 'lyskom-language-symbols record)))

(defmacro lyskom-language-strings (scope category language alist)
  "Define a category of strings.
SCOPE is the scope of language-specificity. If it is global, then these
strings apply globally and will not be altered by changing the session
language.

CATEGORY is the name of the category.

LANGUAGE is the language, a symbol denoting the ISO639 language code.

ALIST is the list of strings."
  `(lyskom-language-strings-internal ',scope
                                     ',category
                                     ',language
                                     ,alist))

(defun lyskom-language-missing-string-internal (category string languages)
  (let ((old-missing (assq 'lyskom-missing-languages (get string category))))
    (if old-missing
        (setcdr old-missing (append languages (cdr old-missing)))
      (put string category (cons (cons 'lyskom-missing-languages languages)
                                 (get string category))))))

(defun lyskom-language-ending-mismatch-internal (category string l1 l2)
  (let ((old-mismatch (assq 'lyskom-ending-mismatch (get string category))))
    (if old-mismatch
        (setcdr old-mismatch (append (list (cons l1 l2) (cons l2 l1))
                                     (cdr old-mismatch)))
      (put string category (cons (cons 'lyskom-ending-mismatch 
                                       (list (cons l1 l2) (cons l2 l1)))
                                 (get string category))))))

(defmacro lyskom-language-missing-string (category string &rest languages)
  `(lyskom-language-missing-string-internal ',category ',string ',languages))

(defmacro lyskom-language-ending-mismatch (category string l1 l2)
  `(lyskom-language-ending-mismatch-internal ',category ',string ',l1 ',l2))

(put 'lyskom-language-strings 'lisp-indent-function 2)

(defsubst lyskom-tell-string (key)
  "Retrieve the phrase indexed by the key from the kom-tell-phrases
assoc list."
  (condition-case nil
      (lyskom-get-string key 'kom-tell-phrases)
    (lyskom-internal-error (message "Bad kom-tell-phrases: missing %s" key)
                           "")))

(defsubst lyskom-try-get-string (symbol category)
    (cdr (assq (if (eq (cdr (assq category lyskom-language-categories)) 'local)
                   lyskom-language
                 lyskom-global-language)
               (get symbol category))))

(defsubst lyskom-get-string-error (function symbol category)
  (signal 'lyskom-internal-error
	  (list function (list symbol category ": string not found"))))

(defun lyskom-get-string (symbol &optional category)
  "Returns string associated with SYMBOL"
    (or (lyskom-try-get-string symbol (or category 'lyskom-message))
        (lyskom-get-string-error 'lyskom-get-string
                                 symbol
                                 (or category 'lyskom-message))))

(defun lyskom-get-string-sol (symbol &optional category)
  "Returns string associated with SYMBOL
If kom-long-lines is set, return the long form of the string, if it exists."
  (or  (and kom-long-lines
            (lyskom-try-get-string (intern (concat (symbol-name symbol)
                                                        "-long"))
                                        (or category 'lyskom-message)))
       (lyskom-try-get-string symbol
                                   (or category 'lyskom-message))
       (lyskom-get-string-error 'lyskom-get-string
                                symbol
                                (or category 'lyskom-message))))


(defun lyskom-get-strings (symbols &optional category)
  "Returns an alist of (symbol . string) pairs

according to CATEGORY and lyskom-language. Kind of inverse to
lyskom-define-language."
  (mapcar (lambda (symbol)
            (cons symbol (lyskom-get-string symbol category)))
	  symbols))

(defun lyskom-get-menu-string (symbol)
  "Returns the name of a menu(item)

Looks for the 'lyskom-menu category, or 'lyskom-command
if 'lyskom-menu is not found."
  (encode-coding-string 
    (or (lyskom-try-get-string symbol 'lyskom-menu)
        (lyskom-try-get-string symbol 'lyskom-command)
        (lyskom-get-string-error 'lyskom-get-menu-string symbol 'lyskom-menu))
    'iso-8859-1))

(defun lyskom-string-check-category (category)
  "Returns list of names for the category, and their supported languages"
  (mapcar (lambda (symbol)
            (let ((info (get symbol category)))
              (if info (cons symbol (mapcar 'car info)))))
	  (get category 'lyskom-language-symbols)))


(defun lyskom-define-language (language coding &rest names)
  (let ((match (assq language lyskom-languages)))
    (if match
	(setcdr match names)
      (setq lyskom-languages (cons (cons language names) lyskom-languages))))
  (put language 'lyskom-language-coding coding))

(defun lyskom-language-coding (language)
  (or (get language 'lyskom-language-coding)
      'raw-text))

(defun lyskom-language-name (language)
  "Return the name of language code LANGUAGE in the current language."
  (save-excursion
    (when lyskom-buffer (set-buffer lyskom-buffer))
    (or (cdr (assq language lyskom-language-codes))
        (lyskom-format (cdr (assq '-- lyskom-language-codes))
                       (symbol-name language)))))

(defun lyskom-set-language (language scope)
  "Set the current language to LANGUAGE.
Returns non-nil on success and nil on failure."
  (cond ((not (assq language lyskom-languages))
         (lyskom-format-insert-before-prompt 'language-not-loaded
                                             (lyskom-language-name language))
         nil)
        (t 
         (cond ((eq scope 'local) 
                (setq lyskom-language language))
               ((eq scope 'global) 
                (setq lyskom-global-language language)
                (lyskom-set-language-keymaps language)))
         (lyskom-set-language-vars language scope)
         (when (eq scope 'global) (lyskom-update-menus))
         (lyskom-update-prompt t)
         (lyskom-update-command-completion)
         t)))

(eval-and-compile (provide 'lyskom-language))

;;; language.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: help.el,v 44.6 2002/06/12 18:29:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: help.el
;;;;
;;;; Functions for formatting help strings in the client
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: help.el,v 44.6 2002/06/12 18:29:32 byers Exp $\n"))



(defgroup lyskom-faces nil
  "Faces for use in the LysKOM elisp client."
  :group 'lyskom)

(defgroup lyskom nil
  "Faces for use in the LysKOM elisp client."
  :group 'default)

(defface lyskom-help-h1-face '((t (:weight bold :underline t :height 2.0 :family "helvetica")))
  "First level header in LysKOM help."
  :group 'lyskom-faces)

(defface lyskom-help-h2-face '((t (:weight bold :underline t :height 1.5 :family "helvetica")))
  "Second level header in LysKOM help."
  :group 'lyskom-faces)

(defface lyskom-help-h3-face '((t (:weight bold :family "helvetica")))
  "Third level header in LysKOM help."
  :group 'lyskom-faces)

;;; Note that these are duplicated in help-compile.el. Change one and change both!

(defsubst lyskom-help-create-data (tag attr data)
  (list tag attr data))

(defsubst lyskom-help-data-get-tag (data)
  (elt data 0))

(defsubst lyskom-help-data-get-attr (attr data)
  (cdr (assq attr (elt data 1))))

(defsubst lyskom-help-data-get-attrs (data)
  (elt data 1))

(defsubst lyskom-help-data-get-data (data)
  (elt data 2))


(defvar lyskom-help-format-handlers
  '((h1 . lyskom-help-format-h1)
    (h2 . lyskom-help-format-h2)
    (h3 . lyskom-help-format-h3)
    (p  . lyskom-help-format-p)
    (b  . lyskom-help-format-b)
    (i  . lyskom-help-format-i)
    (list . lyskom-help-format-list)
    (item . lyskom-help-format-item)
    (inline . lyskom-help-format-inline)
    (refer . lyskom-help-format-refer)
    (cref . lyskom-help-format-cref)
    (section . lyskom-help-format-section)
    (TEXT . lyskom-help-format-TEXT))
  )

(defun lyskom-help-get-section (section)
  (elt (assq section lyskom-help-data) 2))

(defun lyskom-help-show-section (section)
  "Format and insert section SECTION."
  (lyskom-do-help-format (lyskom-help-get-section section)))

(defun lyskom-do-help-format (data)
  "Format ant insert help data DATA."
  (let ((inhibit-read-only t))
    (cond ((symbolp (car data))
           (funcall (cdr (assq (car data) lyskom-help-format-handlers)) data))
          (t (lyskom-traverse el 
                 data
               (let ((tag (lyskom-help-data-get-tag el)))
                 (funcall (cdr (assq tag lyskom-help-format-handlers))
                          el)))))))

(defun lyskom-help-format-text-properties (data props)
  (let ((start (point-max-marker)))
    (set-marker-insertion-type start nil)
    (lyskom-traverse el (lyskom-help-data-get-data data)
      (lyskom-do-help-format el))
    (add-text-properties start (point-max) props)
    (set-marker start nil)))

(defun lyskom-help-format-section (section)
  "Format and insert section SECTION."
  (lyskom-do-help-format (lyskom-help-data-get-data section)))

(defun lyskom-help-format-h1 (data)
  (lyskom-insert "\n\n")
  (lyskom-help-format-text-properties data '(face lyskom-help-h1-face))
  (lyskom-insert "\n\n"))

(defun lyskom-help-format-h2 (data)
  (lyskom-insert "\n")
  (lyskom-help-format-text-properties data '(face lyskom-help-h2-face))
  (lyskom-insert "\n\n"))

(defun lyskom-help-format-h3 (data)
  (lyskom-help-format-text-properties data '(face lyskom-help-h3-face))
  (lyskom-insert "\n"))

(defun lyskom-help-format-i (data)
  (lyskom-help-format-text-properties data '(face italic)))

(defun lyskom-help-format-b (data)
  (lyskom-help-format-text-properties data '(face bold)))

(defun lyskom-help-format-TEXT (data)
  (lyskom-insert (cdr data)))

(defun lyskom-help-format-list (data)
  (lyskom-insert "\n")
  (when (lyskom-help-data-get-attr 'header data)
    (lyskom-insert (lyskom-help-data-get-attr 'header data))
    (lyskom-insert "\n"))
  (lyskom-do-help-format (lyskom-help-data-get-data data))
  (lyskom-insert "\n"))

(defun lyskom-help-format-item (data)
  (lyskom-insert "  * ")
  (lyskom-do-help-format (lyskom-help-data-get-data data))
  (lyskom-insert "\n"))

(defun lyskom-help-format-refer (data)
  (let* ((id (intern (lyskom-help-data-get-attr 'id data)))
         (section (lyskom-help-get-section id))
         (string (or (lyskom-help-data-get-attr 'prompt section)
                     (format "%s" id))))
    (lyskom-format-insert 
     "%#2@%#1s"
     string
     `(face underline
            mouse-face highlight
            lyskom-button t
            lyskom-button-text ""
            lyskom-button-type func
            lyskom-buffer ,(current-buffer)
            lyskom-button-arg (kom-help (,string . ,id)))))

)


(defun lyskom-help-format-cref (data)
  (let* ((command (intern (lyskom-help-data-get-attr 'id data)))
         (command-name (lyskom-get-string command 'lyskom-command))
         (keys (delq nil
                     (mapcar (lambda (x)
                               (if (and (arrayp x)
                                        (eq (elt x 0) 'menu-bar))
                                   nil
                                 x))
                             (where-is-internal command))))
         (heading (lyskom-format "%#1@%[%#2s%]%#3?b%[ (%#3s)%]%[%]"
                                 '(face italic)
                                 command-name
                                 (and keys 
                                      (mapconcat 'key-description
                                                 keys
                                                 "; ")))))
    (lyskom-insert heading)))

(defun lyskom-help-format-inline (data)
  (let* ((id (intern (lyskom-help-data-get-attr 'id data)))
         (section (lyskom-help-get-section id)))
    (cond (section (lyskom-do-help-format section))
          (t (lyskom-insert (format "[%S]" id))))))

(defun lyskom-help-format-p (data)
  (let ((start (point-max-marker)))
    (set-marker-insertion-type start nil)
    (lyskom-traverse el (lyskom-help-data-get-data data)
      (lyskom-do-help-format el))
      (save-excursion
        (save-restriction
          (narrow-to-region start (point-max))
          (goto-char (point-min))
          (while (re-search-forward "^\\s-+" nil t)
            (replace-match "" nil nil))
          (lyskom-fill-region (point-min) (point-max))))
      (lyskom-insert "\n\n")))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: english-strings.el,v 44.230 2002/09/07 21:35:22 ceder Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: english-strings.el
;;;;
;;;; This file contains all strings in the LysKOM elisp client.
;;;; Language:     English.
;;;; ================================================================
;;;;
;;;; Translation from swedish-strings.el: David Byers
;;;;

(require 'lyskom-vars "vars")
(require 'lyskom-language "language")

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
              "$Id: english-strings.el,v 44.230 2002/09/07 21:35:22 ceder Exp $"))


;;; ================================================================
;;; The language definition

(lyskom-define-language 'en
                        'iso-8859-1
                        "English"
                        "Engelska")


;;; ================================================================
;;; lyskom-edit-mode-map                             English version

(defvar lyskom-en-edit-mode-map nil)
(lyskom-language-keymap lyskom-edit-mode-map en lyskom-en-edit-mode-map)

;;; Set the keymap for lyskom-edit-mode

(defvar lyskom-en-edit-prefix nil)

(if lyskom-en-edit-mode-map
    nil
  (setq lyskom-en-edit-mode-map (make-sparse-keymap))
  (define-prefix-command 'lyskom-en-edit-prefix)
  (define-prefix-command 'lyskom-en-edit-review-prefix)
  (define-prefix-command 'lyskom-en-edit-insert-prefix)
  (define-prefix-command 'lyskom-en-edit-aux-prefix)
  (define-prefix-command 'lyskom-en-edit-add-prefix)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2 'button2up))) 'kom-button-click-or-yank)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2up 'button2))) 'kom-mouse-null)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-edit-mode-map (kbd "*")     'kom-button-press-or-self-insert-command)
  (define-key lyskom-en-edit-mode-map (kbd "=")     'kom-menu-button-press-or-self-insert-command)
  (define-key lyskom-en-edit-mode-map (kbd "TAB")   'kom-edit-next-button-or-self-insert)
  (define-key lyskom-en-edit-mode-map (kbd "M-TAB") 'kom-edit-prev-button)
  (define-key lyskom-en-edit-mode-map (kbd "<S-tab>") 'kom-edit-prev-button)
  (define-key lyskom-en-edit-mode-map (kbd "C-c")	'lyskom-en-edit-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-x") 'lyskom-en-edit-aux-prefix)
  (define-key lyskom-en-edit-prefix (kbd "?")	'lyskom-help)
  (define-key lyskom-en-edit-prefix (kbd "C-r") 'lyskom-en-edit-review-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-i") 'lyskom-en-edit-insert-prefix)
  (define-key lyskom-en-edit-prefix (kbd "TAB") 'lyskom-en-edit-insert-prefix)
  (define-key lyskom-en-edit-prefix (kbd "*") 'kom-button-press)
  (define-key lyskom-en-edit-prefix (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-en-edit-prefix (kbd "C-c")	'kom-edit-send)
  (define-key lyskom-en-edit-prefix (kbd "C-s") 'kom-ispell-message)
  (define-key lyskom-en-edit-prefix (kbd "C-k")	'kom-edit-quit)
  (define-key lyskom-en-edit-prefix (kbd "r ?")	'lyskom-help)
  (define-key lyskom-en-edit-prefix (kbd "C-r C-c") 'kom-edit-show-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-i ?") 'lyskom-help)
  (define-key lyskom-en-edit-prefix (kbd "C-i C-c") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-y") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-i C-y") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-b")     'kom-edit-insert-buglist)
  (define-key lyskom-en-edit-prefix (kbd "C-i 1") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 2") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 3") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 4") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 5") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 6") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 7") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 8") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 9") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i SPC") 'kom-edit-insert-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i C-l") 'kom-edit-insert-link)
  (define-key lyskom-en-edit-prefix (kbd "C-a") 'lyskom-en-edit-add-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-a C-r") 'kom-edit-add-recipient)
  (define-key lyskom-en-edit-prefix (kbd "C-a C-c") 'kom-edit-add-copy)
  (define-key lyskom-en-edit-prefix (kbd "C-a <RET>") 'kom-edit-move-text)
  (define-key lyskom-en-edit-prefix (kbd "C-a C-x") 'kom-edit-add-cross-reference)
  (define-key lyskom-en-edit-prefix (kbd "C-x C-p") 'kom-edit-add-personal-comments)
  (define-key lyskom-en-edit-prefix (kbd "C-x C-n") 'kom-edit-add-no-comments)
  (define-key lyskom-en-edit-prefix (kbd "C-x C-r") 'kom-edit-add-read-confirm-request)
  (define-key lyskom-en-edit-prefix (kbd "C-a ?") 'lyskom-help))


;;(defvar lyskom-header-separator
;;  (substitute-command-keys
;;   "\\<lyskom-edit-mode-map>\
;;--- Write below. \
;;Post: \\[kom-edit-send], \
;;Kill: \\[kom-edit-quit], \
;;Help: \\[describe-mode] ---")
;;  "*String to separate headers from text body.")
;;
;;(defvar lyskom-swascii-header-separator nil
;;  "The swascii version of lyskom-header-separator.")
;;
;;(defvar lyskom-header-subject "Subject: "
;;  "*String to prompt for subject in the edit buffer.")
;;
;;
;;(defvar lyskom-swascii-header-subject nil
;;  "The swascii version of lyskom-header-subject.")

(lyskom-language-missing-string lyskom-message cgdag en)
(lyskom-language-missing-string lyskom-message sixjune en)
(lyskom-language-missing-string lyskom-message holdnose en)
(lyskom-language-missing-string lyskom-message 13dayxmas en)
(lyskom-language-missing-string lyskom-message 20dayxmas en)
(lyskom-language-missing-string lyskom-message kyndeldag en)
(lyskom-language-missing-string lyskom-message skottdag en)
(lyskom-language-missing-string lyskom-message intwomday en)
(lyskom-language-missing-string lyskom-message mariebdag en)
(lyskom-language-missing-string lyskom-message johannesddag en)
(lyskom-language-missing-string lyskom-message fnday en)
(lyskom-language-missing-string lyskom-message allhelgonadag en)
(lyskom-language-missing-string lyskom-message varnlosdag en)

(lyskom-language-ending-mismatch lyskom-message carbon-copy-prefix en sv)
(lyskom-language-ending-mismatch lyskom-message blank-carbon-copy-prefix en sv)
(lyskom-language-ending-mismatch lyskom-message newyeareve en sv)

;;; Formely known as lyskom-strings
(lyskom-language-strings local lyskom-message en 
  '(
    ; From vars.el: 
    ; From komtypes.el: nil
    ; From clienttypes.el: nil
    ; From startup.el:
    (server-q . "LysKOM server? (%#1s) ")
    (try-connect . "LysKOM elisp client version %#1s.\nAttempting to connect to %#2s.\n")
    (too-old-server . "The server is too old for this version of the client.")
    (connection-done . "Connection established. Server version is %#1s.\n\n")
    (what-is-your-name . "What is your name? ")
    (password . "Your password? ")
    (wrong-password . "Incorrect password.\n")
    (wrong-password-help . "
If you have forgotten your password you may be able to get a new one
by e-mailing the site administrators at one of the addresses listed
below:\n")
    (wrong-password-email . "* %#1t\n")
    (are-logged-in . "You have entered LysKOM. Please wait...\n")
    (you-have-motd . "\nYou have a notice on your mailbox:\n\n")
    (lyskom-motd-was-garbed . "\nThe login message does not exist!
The message that was supposed to be shown after login has disappeared.
Please contact the LysKOM administrator.\n")
    (presentation-encouragement .
"You have not written a presentation. Please write a presentation by using
the command Ap. If you do not want to write a presentations, please type fk.\n")

    (first-greeting . "%#1s
This appears to be the first time you use LysKOM. Welcome!
Please make sure you have spelled your name correctly. You should use your
full name and organisation, eg. \"Joe Hacker, MIT\". If your name is spelled
incorrectly, or you wish to change it, answer 'no' to the question below.

At present the LysKOM server stores most of the information so that
anybody can read it. Only passwords are encrypted.

If you are uncertain about how to use LysKOM, you can retrieve a manual by
anonymous ftp to ftp.lysator.liu.se. Ask your system administrator for help
on how to do this. You can also type \"?\" for the command \"Help\".
")

    (is-name-correct . "Is the name %#1s correct? ")
    (personal-password . "Enter a personal password: ")
    (repeat-password . "Repeat for confirmation: ")
    (repeat-failure . "The passwords were not the same.\n")

    (could-not-create-you .  "LysKOM couldn't create that user.\n")
    (presentation-subject . "%#1s")
    (presentation-form . "\
Name:      
Address:   
           
Telephone: 
E-mail:    
WWW:       

Other:     ")
    (presentation-help . "You are writing your presentation.\n")
    (not-present-anywhere . "Not in any conference.")
    (unknown-person . "Unknown user")
    (in-secret-conference . "Secret conference (%#1d).")
    (start-new-session-same-server
     . "You are already connected to that server. Do you want a new session? ")
    (new-session-in-buffer . "\n\n---- New session at %s ----\n\n")
    (warning-about-uncompiled-client . "
NOTE: The LysKOM client is not compiled. It is recommended to run a compiled
client for performance reasons. Read the accompanying README to learn how to
do that.
")

    ; From internal.el:
    (shaky-tcp . "At the moment I can't reach the server. The TCP/IP connection is shaky%#1s")
    (retrying-tcp . "Retrying.")

    ; From parse.el:
    (protocol-error . "protocol error: %s")

    ; From services.el:
    (interrupted . "Interrupted\n")

    ; From cache.el:
    ; No entries.

    ; From commands1.el:
    (appreciation . 
"You are a very special person, beautiful and wise, respected by
everybody around you. You are doing a splendid job. Many people love
you, body and soul. You make life easier for others. You are a very
warm and sensitive person.

Be proud of being You! You have a very good reason.\n\n")
    (abuse . 
"You are a nuisance, ugly and stupid, disrespected by everybody around
you. You are doing a worthless job. Many people hate you, body and
soul. You make life harder for others. You are a very cold and
unfeeling person.

Be ashamed of being You! You have a very good reason.\n\n")


    (what-conf-to-delete . "Conference/user to delete: ")
    (what-conf-to-change . "Conference to modify: ")
    (confirm-delete-pers-or-conf . "Really delete %#1s %#2s? ")
    (the-pers . "the user")
    (the-conf . "the conference")
    (deletion-not-confirmed . "Deletion aborted\n")
    (somebody-else-deleted-that-conf . "Somebody else just deleted the conference.\n")
    (conf-is-deleted . "OK, %#1s is now deleted.\n")
    (you-could-not-delete . "%#1M can't be deleted by you.\n")
    (you-have-deleted-yourself . "You have deleted yourself.\n")

    (what-text-to-delete . "Remove which text? ")
    (delete-marked-text . "The text is %#1s. Delete anyway? ")
    (delete-marked-by-you . "marked by you")
    (delete-marked-by-you-and-others . "marked by you and %#1?d%[someone else%]%[%#1d others%]")
    (delete-marked-by-several . "marked by %#1d user%#1?d%[%]%[s%]")
    (deleting-text . "Removing text %#1:n...")

    (presentation-for-whom . "Which conference/user? ")
    (text-to-see-author-of . "Review presentation of author of which text? ")
    (somebody-deleted-that-conf . "Somebody just deleted that conference.\n")
    (review-presentation-of . "Review presentation of %#1M.\n")
    (has-no-presentation . "%#1:M has no presentation.\n")

    (have-to-read . "You must read a text first.\n")

    (no-comment-to . "There is no commented text.\n")
    (no-text-at-point . "There is no text at point.\n")
    (what-ancestor . "Which of the commented texts do you want? ")

    (who-letter-to . "Send a letter to whom? ")
    (who-send-text-to . "Send text to which conference? ")
    (has-motd . "%#1P has a notice on his/her mailbox:\n\n")
    (motd-persist-q . "Send the letter? ")

    (who-to-add . "Whom do you want to add? ")
    (where-to-add . "To which conference? ")
    (where-to-add-self . "Join which conference? ")
    (priority-q . "Priority of your membership? (0 (low) - 255 (high)) ")
    (done . "done.\n")
    (cancelled . "cancelled.\n")
    (nope . "didn't work.\n")
    (add-already-member . "%#1P is already a member of %#2M.\n")

    (cant-find-supervisor . "Can't find supervisor of %#1M.\n")
    (is-read-protected-contact-supervisor . "%#1M is closed.
Send a letter to  %#2P to apply for membership.\n")

    (conf-does-not-exist . "\nThe conference doesn't exist.\n")

    (who-to-exclude . "Who do you want to remove? ")
    (where-from-exclude . "From which conference? ")

    (leave-what-conf . "Leave which conference? ")

    (error-fetching-person . "Error retrieving user.\n")
    (error-fetching-conf . "Error retrieving conference.\n")

    (name-of-conf . "Conference name? ")
    (anyone-member . "May anyone join? ")
    (secret-conf . "Secret conference? ")
    (comments-allowed . "Are comments allowed? ")
    (anonymous-allowed . "Are anonymous texts allowed? ")
    (secret-members-allowed . "Are secret members permitted? ")
    (what-comment-no . "Comment text number: ")
    (what-footnote-no . "Footnote text number: ")
    (what-private-no . "Private reply to text number: ")

    (quit-in-spite-of-unsent . "You have an unsent text. Do you really want to quit? ")
    (really-quit . "Do you really want to quit LysKOM? ")
    (session-ended . "
--------------------------------------------
  LysKOM session finished
  You are now disconnected from the server
--------------------------------------------
")
    (session-ended-long . "
-------------------------------------------------------------------------------
  LysKOM session finished
  You are now disconnected from the server
-------------------------------------------------------------------------------
")
    (session-auto-ended . "
============================================================
Disconnecting from LysKOM since all connections are in use
and you have finished reading. Please come back later.
============================================================\n\n")
    (session-auto-ended-long . "
===============================================================================
Disconnecting from LysKOM since all connections are in use
and you have finished reading. Please come back later.
===============================================================================
\n")
    (what-to-change-pres-you . "Change presentation of whom/what (yourself): ")
    (what-to-change-faq-you . "Change FAQ for which conference: ")
    (who-to-put-motd-for . "Post notice on whom/what (yourself): ")

    (what-to-set-pres-you . "Set presentation for whom/what (yourself): ")
    (what-text-to-set-as-pres-no . "Which text do you want as the new presentation: ")
    (what-to-set-motd-you . "Set notice on whom/what (yourself): ")
    (what-text-to-set-as-motd-no . "Which text do you want as the new notice: ")
    (conf-already-has-pres . "The conference/person already has a presentation. Continue anyway? ")
    (conf-already-has-motd . "The conference/person already has a notice. Continue anyway? ")
    (setting-conf-pres . "Setting presentation of %#1M to text %#2n...")
    (setting-conf-motd . "Setting notice for %#1M to text %#2n...")

    (who-to-remove-pres-for . "Vilket mte/person vill du ta bort presentationen frn (dig sjlv): ")
    (removing-pres-for-conf . "Tar bort presentation (text %#2n) frn %#1M...")

    (cant-get-conf-stat . "Cannot get the status of that conference.\n")
    (go-to-conf-p . "Go to conference: ")
    (want-become-member . "Do you want to join? ")
    (no-ok . "Okiedokie, whatever you say.\n")

    (who-to-remove-motd-for . "Remove notice from whom/what: ")

    (conf-all-read . "no unread texts")
    (no-in-conf . "You are not present in any conference.\n")

    (search-for-pers . "Enter search key (RETURN for all users): ")
    (search-for-conf . "Enter search key (RETURN for all conferences): ")
    (search-re . "Enter search regexp: ")
    (include-persons . "Search among persons? ")
    (include-conferences . "Search among conferences? ")

    (no-matching-confs . "No conferences match \"%#1s\".\n")
    (no-matching-perss . "No persons match \"%#1s\".\n")
    (no-matching-anys . "No persons or conferences match \"%#1s\".\n")
    (no-confs-exist . "There are no conferences in the database.\n")
    (no-pers-confs-exist . "There are no persons or conferences in the database.\n")
    (list-confs-created-by . "List owned conferences for: ")
    (listing-confs-created-by . "Listing owned conferences for %#1P\
    C=Created, O=Supervisor, S=Letterbox is super conf; S=Secret, P=Protected\n")
    (list-pers-confs-created-by . "List owned conferences and persons for: ")
    (getting-all-confs . "Retrieving a list of all conferences from the server...")
    (getting-all-pers-confs . "Retrieving a list of all persons and conferences from the server...")
    (getting-all-confs-done . "Retrieving a list of all conferences from the server...done")
    (getting-all-pers-confs-done . "Retrieving a list of all persons and conferences from the server...done")
    (finding-created-confs . "Finding owned conferences (%#1d of %#2d done)")
    (finding-created-pers-confs . "Finding owned persons and conferences (%#1d of %#2d done)")
    (no-created-confs . "%#1P is not creator, supervisor or super conference for any conference.\n")

    (name-to-be-changed . "Name to change: ")
    (no-such-conf-or-pers . "The conference or user doesn't exist.\n")
    (new-name . "New name: ")
    (new-paren . "New parenthesis: ")
    (no-paren-in-name . "The name doesn't contain a parenthesis.\n")
    (who-to-change-supervisor-for . "Change supervisor of whom/what? ")
    (new-supervisor . "New supervisor: ")
    (text-to-mark . "Mark which text? ")
    (text-to-unmark . "Unmark which text? ")
    (what-mark . "Set which mark type (name or 0-255)? ")
    (erroneous-mark . "Erroneous mark type.\n")
    (want-to-create-symbolic-mark . "The mark type \"%#1s\" does not exist. Do you want to create it? ")
    (creating-symbolic-mark-type . "Creating mark type \"%#1s\" (%#2d).\n")
    (no-mark-types-left . "Sorry, there are no free mark types. Remove an old one first.")
    (unmarking-textno . "Unmarking text %#1n...")
    (marking-textno . "Marking text %#1n...")
    (list-which-mark . "List texts with which mark type (name or 0-255, RET for all)? ")

    (new-passwd-again . "Repeat the new password for confirmation: ")
    (what-mark-to-view . "Review which mark type (name or 0-255, RET for all)? ")
    (whos-passwd . "Change password for whom? (yourself) ")
    (old-passwd . "Your current password: ")
    (new-passwd . "The new password: ")
    (changing-passwd . "Changing password...")
    (retype-dont-match . "You didn't reenter the same passwrod. Try again.\n")
    (palindrome . " (a palindrome!)")
    (lyskom-name . "User")
    (is-in-conf . "In conference")
    (from-machine . "At")
    (is-doing . "Activity")
    (connection-time . "Connected")
    (active-last . "Active last")
    (active . "Active")
    (lyskom-client . "Client")
    (text-to-add-recipient . "Add recipient to which text:")
    (text-to-add-copy . "Add recipient of carbon copy to which text:")
    (text-to-add-bcc . "Add recipient of blind carbon copy to which text:")
    (text-to-delete-recipient . "Remove recipient from which text:")
    (text-to-move . "Which text do you want to move:")
    (text-tree-to-move . "Which text is the root of the tree you want to move:")

    (text-to-add-comment-to . "Add comment to which text:")
    (text-to-delete-comment-from . "Remove comment from which text:")
    (text-to-add-footnote-to . "Add footnote to which text:")
    (text-to-delete-footnote-from . "Remove footnote from which text:")
    (text-to-add-cross-reference-to . "Add cross reference to which text:")
    (text-has-no-recipients-r . "Text %#1n has no recipients\n")

    (where-on-list-q . "Placement in your list? (0-%#1d) ")
    (member-in-conf . "Joining to %#1M...")
    (add-member-in . "Adding %#1P as a member of %#2M...")
    (change-priority-for-q . "Change priority of conference: ")
    (change-priority-for . "Changing priority of %#2M...")
    (unsubscribe-to . "Leaving %#1M...")
    (passivate-done . "You are now a passive member of %#1M.
Leave the conference again to unsubscribe completely.\n")

    (exclude-from . "Removing %#1P from %#2M...")

    (unsubscribe-failed . "\nDidn't work. Perhaps %#1P isn't a member of %#2M?\n")

    (You . "You")
    (could-not-create-conf . "Couldn't create the conference \"%#1s\".\n")
    (created-conf-no-name . "Conference number %[%#3@%#1:m %#2:M%] has been created.\n")
    (cant-read-textno . "You are not allowed to read text %#1:n.\n")

    (not-supervisor-for . "You are not the supervisor of %#1M.\n")
    (not-supervisor-for-server . "You do not have administrative rights on this LysKOM-server.\n")
    (go-to-conf . "Go to conference %#1M.\n")
    (cant-go-to-his-mailbox . "You are not allowed to go to %#1M's mailbox.\n")
    (not-member-of-conf . "You are not a member of %#1M.\n")
    (about-to-change-name-from . "%#1M\n")
    (change-name-done . "Done. New name: %[%#2@%#1:M%].\n")
    (change-name-nope . "Couldn't change name to %#1s. Error code %#3d. %#2s.\n")
    (change-supervisor-from-to . "Change supervisor of %#1M to %#2P...")
    (change-supervisor-nope . 
     "\nDidn't work. Perhaps you are not allowed to change the supervisor of %#1M?\n")
    
    (no-marked-texts . "You have not marked any texts.\n")
    (no-marked-texts-mark . 
     "You have not marked any texts with mark type \"%#1s\".\n")

    (weekdays . ["Sunday" "Monday" "Tuesday" "Wednesday" "Thursday"
		 "Friday" "Saturday" "Sunday"])
    (weekdays-short . ["Sun" "Mon" "Tue" "Wed" "Thu" "Fri" "Sat" "Sun"])
    (time-is . "The time is %#1s%#2s (according to the server).")
    (time-is-week . "The time is %#1s%#2s, week %#3d (according to the server).")

    (xmaseve . "Christmas eve!\nYou didn't open any gifts early, did you?")
    (xmasday . "Christmas day.\nDid you get any nice gifts this year?")
    (newyearday . "\nMay %#1d be a prosperous and good year for you!")
    (newyeareve . "Happy New Year!")
    (newyearevelate . "Less than an hour left of %#1d...")
    (lysbday . "
On this day, in 1973, the Lysator Academic Computer Society was
formed, and it was a great day in the history of computing in Sweden.
Read all about it at http://www.lysator.liu.se/history/")

    (total-users . "    A total of %#1d users (%#2s).\n")
    (total-users-sans-date . "    A total of %#1d users\n")
    (total-visible-users . "    A total of %#1d visible user%#1?d%[%]%[s%] (%#2s).\n")
    (total-active-users . "    A total of %#1d active user%#1?d%[%]%[s%] (%#2s).\n")
    (total-visible-active-users
     . "    A total of %#1d visible%#1?d%[%]%[%] active user%#1?d%[%]%[s%] (%#2s).\n")
    (client-statistics . "    Distribution of clients:\n")
    (client-statistics-line . "    %4#2d %#1s")
    (who-to-add-q . "Add whom/what as a recipient? ")
    (who-to-add-copy-q . "Add which conference/user as carbon copy recipient? ")
    (who-to-add-bcc-q . "Add which conference/user as blind carbon copy recipient? ")
    (really-add-as-recpt-q . "Send future comments to the text to %#1M too? ") 
    (who-to-sub-q . "Remove whom/what as a recipient? ")
    (who-to-move-from-q . "Move from where? ")
    (who-to-move-to-q . "Move to where? ")
    (who-to-move-to-or-sub-q . "Move to where (empty to just remove recipient)? ")

    (adding-name-as-recipient . "Adding %#1M as recipient of text %#2n...")
    (adding-name-as-copy . "%#1M will receive a carbon copy of text %#2n...")
    (remove-name-as-recipient .
     "Removing %#1M as recipient of text %#2n...")
    (adding-cross-reference . "Adding cross reference...")

    (error-recipient-limit . "Text %#1n has too many recipients.\n")
    (error-already-recipient . "%#2M is already a recipient of text %#1n.\n")
    (error-permission-denied-add-recpt . "Only the author of %#1n or supervisor for %#2M can change recipient types.\n")
    (error-permission-denied-sub-recpt . "Only the author of %#1n or supervisor for %#2M can remove the recipient.\n")
    (error-access-denied-add-recpt . "You are not allowed to add texts to %#2M.\n")
    (error-not-recipient . "%#2M is not a recipient of text %#1n.\n")

    (moving-tree-what-action-q . "What do you want to do? (flytta) ")
    (moving-name . "Moving text %#3n from %#1M to %#2M...")
    (moving-already-moved . "Text %#1n does not have %#2M as a mottagare.\nSkipping this text and its comments.\n")
    (text-to-add-q . "Add which text as a comment to %#1n? ")
    (text-to-remove-q . "Remove which text as a comment from %#1n? ")
    (text-to-add-footn-q . "Add which text as a footnote to %#1n? ")
    (text-to-remove-footn-q . "Remove which text as a footnote from %#1n? ")
    (add-comment-to . "Adding text %#1n as a comment to text %#2n...")
    (sub-comment-to . "Removing text %#1n as a comment to text %#2n...")
    (add-footnote-to . "Adding text %#1n as a footnote to text %#2n...")
    (sub-footnote-to . "Removing text %#1n as a footnote to text %#2n...")
    (comment-keep-recpt-p ."Should %#1s remain a recipient? ")
    (comment-all-relevant-p . "There are multiple recipients. Are they all relevant? ")
    (please-edit-recipients . "Modify the recipient list and send the text again.")
    (add-recipient-p . "Add recipient%#2?b%[ %#2M to reach%]%[%] %#1P? ")
    (checking-rcpt . "Checking recipients...")
    (checking-rcpt-done . "Checking recipients...done")
    (checking-comments . "Checking commented texts...")
    (checking-comments-done . "Checking commented texts...done")
    (please-check-commented-texts . "Review the commented text and its comments.")
    (have-unread-comment . "Send despite unread comments to text %#1n? ")
    (duplicate-recipients . "Unable to post. A recipient is duplicated (%#1M)")
    (no-recipients . "Unable to post text. No recipients were specified.")

    (matching-regexp . "Conferences/users matching `%#1s'\n")
    (matching-regexp-perss . "Users matching `%#1s'\n")
    (matching-regexp-confs . "Conferences matching `%#1s'\n")

    (who-is-active-all . "Showing all sessions.\n")
    (who-is-active-last-minutes . "Showing all sessions active the last %#1d minutes.\n")
    (showing-invisibles . "Showing invisible sessions.\n")
    (null-who-info . "No one (active) is logged on.\n")

    (no-other-lyskom-r . "There are no other active LysKOM sessions.\n")
    (no-lyskom-session . "There are no active LysKOM sessions.")
    (no-other-unread-lyskom-r . "There is no another LysKOM session with unread texts.\n")
    (no-unread-lyskom-r . "There is no active LysKOM session with unread texts.\n")
    (no-unread-lyskom . "There is no active LysKOM session with unread texts.")

    (who-is-on-in-what-conference . "Who in which conference: ")
    (who-is-present-in-what-conference . "Who present in which conference: ")
    (who-is-friend . "Only friends are shown.\n")
    (who-is-active-and-member . "Only members in %#1M are shown.\n")
    (who-is-active-and-present . "Only members present in %#1M are shown.\n")

    (personal-comment-to-anonymous . "It is not possible to write a personal comment to an anonymous text.\n")

    ;; Used for kom-is-person-member-of-conference:
    (pers-to-check-mship-for . "Whose membership do you want to check? ") ;-)
    (conf-to-check-mship-of . "...for what conference? ")
    (conf-is-empty . "The conference %#1M is empty.\n")
    (pers-is-member-of-conf . "Yes, %#1P is a member of the conference %#2M.\n")
    (pers-is-passive-member-of-conf . "Well, %#1P is only a passive member of the conference %#2M.\n")
    (pers-is-not-member-of-conf . "No, %#1P is not a member of the conference %#2M.\n")

    ; From commands2.el:

    (your-memberships . "Your LysKOM conference memberships:\n")
    (memberships-header . "Last access	   Prio	Unread	Conference\n")
    (memberships-line . "%16#1s  %#2d\t%#3d\t%#4M\n")
    
    (conf-for-status . "Get status of which conference? ")
    (no-such-conf . "The conference doesn't exist.\n")
    (status-record . "Status of conference %#1M (%#1m) %#2s\n\n")
    (change-type-prompt . "Change conference type for %#1M (%#1m) (%#2s)...")
    (Mailbox . "Mailbox")
    (Protected . "Protected")
    (no-comments . "No comments")
    (closed . "Closed")
    (allow-anon . "anonymomus ok")
    (allow-secret . "secret members")
                   
    (created-by . "Created by person %24#1p %#3s(%#2P)\n")
    (created-at . "Created:%34#1s\n")
    (members .    "Number of members: %19#1d\n")
    (conf-allows-secret-members . "Secret members:                          %#1s\n")
    (conf-allows-anon-texts .     "Anonymous texts:                         %#1s\n")
    (anon-texts-permitted . "Anonymous texts are permitted")
    (anon-texts-not-permitted . "Anonymous texts are not permitted")
    (secret-members-permitted . "Secret members are permitted")
    (secret-members-not-permitted . "Secret members are not permitted")
    (garb-nice . "Expiration time (in days):%16#1d\n")
    (lowest-local-no . "Lowest local number: %21#1d\n")
    (highest-local-no . "Highest local number: %20#1d\n")
    (last-text-time . 
     "Time of last text:    %20#1s (according to your cache)\n")
    (no-of-motd . "Notice in text:    %13#1n\n")
    (superconf-is-no-name . "Superconference: %25#1m %#3s(%#2M)\n")
    (permitted-submitters-no-name . "Allowed authors: %25#1m %#3s(%#2M)\n")
    (supervisor-is-no-name . "Supervisor: %30#1p %#3s(%#2P)\n")
    (presentation-no . "Presentation:    %25#1n\n")
    (conf-has-motd . "\n%#1M has a notice on his/her mailbox:\n")
    (conf-mship-priority . "Prioritet:       %25#1n%#2?b%[ %#2s%]%[%]\n")
    (status-conf-generic . "%-40#1s %#2s\n")
    (status-aux-item . "Unknown auxiliary information: %11#1s%#3s (skapad av %#2M)\n")
    (conf-mx-list-name . "Imported mailing list:                   %#1s %#2s\n")
    (recommended-conf-aux . "Recommended conference:                  %#1M <%#1m> %#2s\n")
    (status-read-faq-aux-item . "Read FAQ:                  %15#2n for %#1?z%[%#1M <%#1m>%]%[the server%] %#3s\n")
    (status-rejected-recommendation-aux-item . "Rejected recommendation for:             %#1M %#2s\n")
    (status-send-comments-to . "Redirect comments to:                    %#1M <%#1m> %#2s\n")

    (Everybody . "Everyone")
    (show-members-list-also-q . "List members? ")
    (show-membership-info-q . "Show number of unreads? ")
    (conf-has-these-members . "\n%#1M has the following members:\n")
    (conf-has-no-members . "\n%#1M has no members.\n")
    (member-list-header . "Last entered        Unread  Name\n\n")
    (secret-membership . "--- Secret line ---\n")
    (conf-membership-line . "%#1s%#2M %#3s\n")
    (conf-membership-line-2 . "                            Added %#1s by %#2P\n")
    (pers-for-status . "Get status of which user? ")
    (text-to-see-author-status-of . "Get status of the author of which text? ")
    (no-such-pers . "The user doesn't exist.\n")
    (pers-status-record . "Status of user %#1P (%#1p)\n")
    (created-time .  "Created:%34#1s\n\n")
    (created-confs . "Conferences created:%22#1d\n")
    (created-persons . "Users created:%28#1d\n")
    (created-texts . "Texts created:%28#1d\n")
    (created-lines . "Lines created:%28#1d\n")
    (created-chars . "Characters created:%23#1d\n")
    (no-of-sessions . "Session count:%28#1d\n")
    (present-time-d-h-m-s . "Total presence:%16#1d d %02#2d:%02#3d:%02#4d\n")
    (last-log-in . "Last login or logout:%21#1s\n")
    (user-name . "User: %36#1s\n")

    (read-texts . "Texts read:%31#1d\n")
    (marked-texts . "Texts marked:%29#1d\n")
    (time-for-last-letter . "Time of last letter:%22#1s (according to your cache)\n")
    (superconf . "Superconference: %25#1m %#3s(%#2M)\n")
    (supervisor . "Supervisor: %30#1p %#3s(%#2P)\n")
    (member-of-confs . "Member of (conferences):%18#1d\n")
    (presentation . "Presentation:    %25#1n\n")
    (show-membership-list-also-q . "List memberships? ")
    (not-allowed-see-confs . "%#1P is not a member of any conferences.\n")
    (is-member-of . "\n%#1P is a member of the following conferences:\n")
    (membership-list-header . "Last access          Unread  Conference\n\n")
    (pers-membership-line . "%#1s%#2s%#3M %#4s\n")
    (pers-membership-line-2 . "                             Added %#1s by %#2P\n")
    (is-supervisor-mark . "O ")
    (who-to-send-message-to . "Send message to whom? (%s) ")
    (send-empty-message-p . "The message is empty. Send it anyway? ")
    (his-total-unread . "\n%#1M has a total of %#2d unread texts.\n")
    (message-prompt . "Message: ")
    (message-sent-to-user . "\
%[%#3$================================================================
%]%[%#4$Your message for %#2M:

%#1t
%]%[%#3$----------------------------------------------------------------
%]")
    (message-sent-to-all . "\
%[%#3$================================================================
%]%[%#4$Your public message

%#1t
%]%[%#3$----------------------------------------------------------------
%]")
    (message-sent-to-user-long . "\
%[%#3$\
===============================================================================
%]%[%#4$Your message for %#2M:

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-sent-to-all-long . "\
%[%#3$\
===============================================================================
%]%[%#4$Your public message

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-use-alarm-instead . "Use %#1s to send alarm messages.\n")
    (message-all-info . "Send alarm\n")
    (message-recipient-info . "Send message to %#1M\n")
    (message-nope .
     "Unable to send the message. Perhaps the recipient isn't logged on.
The message you were sending to %#1M was:
%#2t\n")
    (only-last . "Last (0 - %#1d) texts in %#2s: ")
    (only-error . "Something went wrong. Sorry.\n")
    
    (you-have-unreads . "You have %#1d unread text%#1?d%[%]%[s%] in %#2M\n")
    (you-have-unreads-special . "You have %#1d uncommented text%#1?d%[%]%[s%] in %#2M\n")
    (you-have-no-unreads . "You have read everything in %#1M\n")
    (you-have-read-everything . "No news (is bad news).\n")
    (no-unreads-shown . "Found no conferences meeting that criterion.\n")
    (total-unreads .
     "You have %#1d unread text%#1?d%[%]%[s%] texts in %#2d conference%#2?d%[%]%[s%].\n")
    (shown-unreads . "Showed %#1d unread text%#1?d%[%]%[s%] in %#2d conference%#2?d%[%]%[s%].\n")
    (list-unread-with-n-unread . "Listing conferences with at least %#1d unread.\n")
    (list-unread-with-at-most-n-unread . "Listing conferences with at most %#1d unread.\n")
    (waiting-for-anything .
     "You are waiting for a text in any conference.\n")
    (waiting-higher-than . 
     "You are waiting for a text in any conference with a priority higher than %#1d.\n")
    
    (have-to-be-in-conf-with-unread . "You must go to a non-empty conference first.\n")
    (Texts . "Text")
    (Written . "Written")
    (Lines . "Lines")
    (Author . "Author")
    (Subject . "Subject")
    (mark-type . "Type")

    (could-not-read . "You couldn't read the text (%#1n).\n")
    (multiple-choice . "There are several alternatives.")

    (does-not-exist . "Unknown command.") ; Only people fixing bugs or receiving bug reports should change these:
    (summary-line . "%=-8#1n%#2s%4#3d  %[%#4@%#5:P%]  %[%#6@%#7r%]\n")
    (diff-what-text-old . "Old text to compare: ")
    (diff-what-text-new . "New text to compare: ")

    ; Only people fixing bugs or receiving bug reports should change these:
    (buggreport-compilestart . "Creating bug report...")
    (buggreport-compileend . "Creating bug report...done")
    (buggreport-description . "This is what I was doing:
\(Fill in your comments below\)\n================\n\n
================
In the information below are the 100 most recently pressed keys from
your emacs. If you recently logged on, you password may be contained in
this list. If that is the case, change the characters corresponding to
your password to asterisks.

When you have finished writing this, send your bug report to the LysKOM
developers. You can do this either by email to bug-lyskom@lysator.liu.se or
by mailing a hardcopy of your bug report to:
Lysator, c/0 ISY, Linkoping Univerity, S-581 83 Linkoping, SWEDEN.
Mark the envelope with \"LysKOM bug report\"\n\n")
    (buggreport-internals . "LysKOM's internal information:\n\n")
    (buggreport-version . "lyskom-version:")
    (buggreport-emacs-version . "emacs-version:")
    (buggreport-system-id . "system-id:")
    (buggreport-ctl-arrow-doc . "ctrl-doc:")
    (buggreport-unparsed . "\nlyskom-unparsed-buffer:")
    (buggreport-command-keys . "Recently pressed keys:")
    (buggreport-backtrace . "\n*Backtrace*:\n%#1s\n")
    (buggreport-communications . "\nlyskom-debug-communications-to-buffer-buffer:")
    (buggreport-all-kom-variables . "\n\nOther variables:\n***** *********")
    (buggreport-instead-of-byte-comp . "byte-code(\"byte-string\"")
    (buggreport-subject . "Bugreport elisp-client version %#1s")


    (not-logged-in . "You are not logged on. ")
    (name-is-not-in-conf . "%#1s is not in any conference.\n")
    (name-is-in-conf . "%#1s is in\n%#2s\n")
    (connected-during . "Connect time: %#1d seconds.\n")

    (conf-to-set-permitted-submitters-q . "For which conference do you want to set the allowed authors? ")
    (conf-to-set-super-conf-q . "Set superconference of which conference? ")
    (new-super-conf-q . "Which conference do you want as superconference? ")
    (new-permitted-submitters-q . "Allow members of which conference as authors in %#1s? (all) ")
    (super-conf-for-is . "Changing superconference of %#1M to %#2M...")
    (permitted-submitters-removed-for-conf . "Allowing all authors to conference %#1M...")
    (submitters-conf-for-is . "Changing authors admitted to conference %#1M to the members of %#2M...") 
   
    (conf-to-set-garb-nice-q . "Set expiration time for which conference? ")
    (new-garb-nice-q . "After how many days shall texts be removed? ")
    (garb-nice-for-is . "Changing expiration for %#1M to %#2d...")

    (really-shutdown . "Are you sure you want to shut down the server? ")
    (closing-server . "Shutting down the server...")
    (really-sync . "Are you sure you want to save the database? ")
    (syncing-server . "Saving the database...")
    (administrator . "administrator")
    (no-longer-administrator . "a regular user again")
    (you-are-now . "Ok, you are now running as %#1s.\n")
    (setting-motd . "Changing login message to text %#1n.\n")
    (set-motd-success . "You have set a new login message.\n")
    (set-motd-failed . "Didn't work. Perhaps you were not an administrator.\n")
    (removing-motd . "Removing the login message.\n")
    (removed-motd . "You have removed the login message.\n")
    (who-to-throw-out . "Who's session do you want to kill? ")
    (throwing-out . "Killing session %#1d... ")
    (postpone-prompt . "How much do you want to read now? ")
    (set-session-priority . "Set reading level: ")

    ; From review.el:
    (no-review-done . "You need to review something before you can review more.\n")
    (not-reviewing . "You are currently not reviewing anything.\n")
    (review-how-many . "Review how many?")
    (review-how-many-more . "Review how many more?")
    (latest-n . "last %#1d")
    (first-n . "first %#1d")
    (info-by-whom . "%#1s by whom: ")
    (info-to-conf . "%#1s to conference: ")
    (info-by-to . "%#1s by %#2P to %#3M forward.")
    (all-confs . "all conferences")
    (no-get-conf . "You are not allowed to access that conference.\n")
    (no-get-pers . "You are not allowed to access that user.\n")
    (no-review-info . "You are not allowed to review %#1s\n")
    (review-info . "Review %#1s")
    (review-info-by-to . "Review %#1s by %#2P to %#3M forwards.\n")
    (review-more-info-by-to . "Review %#1s by %#2P to %#3M forwards.\n")
    (review-rest . "the rest")
    (review-more . "%#1d more")
    (you-review . "You are now reviewing %#1s.\n")
    (read-text-first . "You must read a text first.\n")
    (cannot-read-last-text . "You cannot review the last read text.\n")
    (review-n-texts . "Review %#1d texts.\n")
    (review-marked . "Review %#1d marked texts.\n")
    (review-text-no . "Review text %#1n\n")
    (review-many-comments . "Review %#2?d%[one%]%[%#2d%] comment%#2?d%[%]%[s%] to text %#1n.\n")
    (view-many-comments . "Read %#2?d%[one%]%[%#2d%] comment%#2?d%[%]%[s%] to %#1n.\n")
    (view-texts-in-conf . "Grand total of %#1d texts to read in %#2M.\n")

    (not-reading-anywhere . "You are not reading in any conference.\n")
    (read-normally-read . "How many texts to you want to read again? ")

    (review-conf-gone . "The conference does not exist.\n")
    (review-pers-gone . "The user does not exist.\n")
    (review-cant-read-conf . "You can't review texts to a closed conference you are not a member of.\n")
    (review-cant-read-letterbox . "You can't review texts to somebody else's mailbox.\n")
    (review-cant-read-empty . "The conference is empty.\n")
    (cant-review-everything . "You cannot review every text in LysKOM.\n")

    (more-than-one-root . "Text %#1n has more than one root.\n")
    (more-than-one-root-review . "\
Text %#1n has more than one root but only one of the trees will be shown.\n")

    ; From edit-text.el:
    (press-C-c-C-c . "Enter C-c C-c to post the text.")
    (recipient . "Recipient")
    (recipient-prefix . "[Rr]")
    (carbon-copy . "Carbon copy")
    (blank-carbon-copy . "Blind Carbon copy")
    (carbon-copy-prefix . "[Cc]\\([Aa]\\|[Cc]\\)")
    (blank-carbon-copy-prefix . "[Bb]\\([Ll]\\|[Cc][Cc]\\)")
    (add-recipient . "Add a recipient")
    (add-recipient-or-xref . "Add...")

    (secret-aux-flag . "secret")
    (anonymous-aux-flag . "anonymous")
    (inherit-aux-flag  . "inherited")
    (aux-item-prefix . "[*]")
    (aux-item-prefix-regexp . "\\[\\*\\]\\s-*")
    (comment-item-prefix . "#\\s-*")
    (text-no-comment . "%#1d %#2s /%#3d line%#3?d%[%]%[s%]/ %#4P %#5?b%[ [anonymous]%]%[%]\n")
    (cant-fcc-text-file-error . "Unable to save text %#1n to \"%#2s\" (%#3s: %#4s).\n")
    (cant-fcc-text . "Unable to save text %#1n to \"%#2s\" (%#3s).\n")

    (header-subject . "Subject: ")
    (header-separator . "\\<lyskom-edit-mode-map>\
--- Write below. \
Post: \\[kom-edit-send], \
Kill: \\[kom-edit-quit], \
Help: \\[describe-mode] ---")
    (text-mass . "%#4s%#1s\n%#2s\n%#3s")
    (comment-to-by . "%#1s to text %#2n%#3s.\n")
    (already-sent . "You have already posted this text. Post it anyway? ")
    (subject . "Subject: ")
    (subject-prefix . "[Ss]")
    (enter-subject-idi . "Enter a subject.")
    (which-text-include . "Include which text? ")
    (added-recipient . "Recipient: ")
    (added-carbon-copy . "Carbon copy to conference: ")
    (added-blank-carbon-copy . "Blind carbon copy to conference: ")
    (text-to-comment-q . "Which text do you want to comment? ")
    (conf-has-motd-no . "The conference has a notice. (%#1d)\n\n%#2s")
    (still-want-to-add . "Do you still want to add the conference as a recipient? ")
    (could-not-create-text . "\nCouldn't create the text. Error: %#2s.\n")
    (no-get-text . "You were not allowed to retrieve the text.")
    (unknown-header . "Unknown header")
    (transform-error . "Send unformatted (%#1s)? ")
    (cant-find-info-node . "Can't find the info buffer")

    (link-type . "What to you want to link to (text, conference or person)? ")
    (which-text-to-link . "Add link to text: ")
    (which-text-to-link-err . "Text not found. Add link to text: ")
    (which-pers-to-link . "Add link to user: ")
    (which-conf-to-link . "Add link to conference: ")

    ; From view-text.el:
    (view-text-first-line . "%#7$%#2@%#1n %#3s /%#4d line%#4?d%[%]%[s%]/ %#5P%#6?b%[%#6s%]%[%]\n")

    (marked-by-you . "Marked by you (type: %#1s).\n")
    (marked-by-you-and-others . "Marked by you (type: %#2s) and %#1?d%[someone else%]%[%#1d others%].\n")
    (marked-by-several . "Marked by %#1d user%#1?d%[%]%[s%].\n")

    (timeformat-day-yyyy-mm-dd-hh-mm-ss . "%#7s %4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm-ss . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d")
    (timeformat-yyyy-mm-dd . "%4#1d-%02#2d-%02#3d")
    (timeformat-hh-mm-ss . "%02#4d:%02#5d:%02#6d")
    (timeformat-hh-mm . "%02#4d:%02#5d")

    (format-time-date-and-time . "%#1s %#2s")
    (format-time-just-date . "%#1s")
    (format-time-just-time . "%#2s")
    (today . "today")
    (yesterday . "yesterday")

    (no-such-text-no . "The text doesn't exist. (%#1:n)\n")
    (text-created-at . "Created: %#1s\n")
    (text-imported-at . "Imported: %#1s\n")
    (text-imported-at-by . "Imported: %#1s by %#2P\n")

    (head-Subject . "Subject: ")
    (Recipient . "Recipient")
    (Extra-recipient . "CC")
    (Hidden-recipient . "BCC")
    (mx-Recipient . "External recipient")
    (mx-Extra-recipient . "External CC")
    (mx-Extern-reply-to . "External replies to")
    (Strange-recipient . "Also to")
    (send-at . "   Posted:     %#1s\n")
    (sent-by . "   Posted by %#1P\n")
    (received-at . "    Received: %#1s\n")

    (comment-to-text . "Comment to text %#1n")
    (footnote-to-text . "Footnote to text %#1n")
    (comment-in-text . "Comment in text %#1n")
    (footnote-in-text . "Footnote in text %#1n")

    (attachment-to-text . "Attachment %#3sto text %#1n")
    (attachment-in-text . "Attachment %#3sin text %#1n")
    
    (envelope-sender . "Sent by: %#1s\n")
    (attachment-filename . "Attachment file name: \"%#1s\"\n")

    (comment-to-text-by . "Comment to text %#1n by %#2P")
    (footnote-to-text-by . "Footnote to text %#1n by %#2P")
    (comment-in-text-by . "Footnote in text %#1n by %#2P")
    (footnote-in-text-by . "Footnote in text %#1n by %#2P")

    (written-by . " by %#1P\n")

    ; From async.el:

    (name-has-changed-to-name . "%#1:P has changed name to %#2:P")
    (name-has-changed-to-name-r . "%[%#3@%#1:P%] has changed name to %[%#3@%#2:P%]\n")
    (you-changed-name-to . "You have now changed your name to %[%#2@%#1:P%].\n")
    (database-sync . "Synching database.")

    (lyskom-is-full . "\
===========================================================
Message from the LysKOM system: Somebody tried to connect,
but failed since all connections available to LysKOM are in
use. Please leave and return later if you are just waiting
for a text.
===========================================================\n")
    (lyskom-is-full-long . "\
===============================================================================
Message from the LysKOM system: Somebody tried to connect,
but failed since all connections available to LysKOM are in
use. Please leave and return later if you are just waiting
for a text.
===============================================================================
")
    (has-entered . "%#1:P has entered %#2s.")
    (has-entered-r . "%#2@%#1P has entered %#3s.\n")
    (has-left . "%#1:P has left %#2s.")
    (has-left-r . "%#2@%#1P has left %#3s.\n")
    (Unknown . "Unknown")
    (unknown . "unknown")
    (Unknown2 . "Unknown")

    (no-longer-member . "You are no longer a member of %#1M.\n")
    (no-longer-member-n . "You are no longer a member of %#1m (conference is gone).\n")
    (have-become-member . "You have become a member of %#1M.\n")
    (have-become-invited-member . "You have been invited to %#1M.
Go to the conference to accept or decline the invitation. You can also use
the command 'Join conference' to accept the invitation.\n")
    (have-become-passive-member . "You have become a passive member of %#1M.\n")


    (message-broadcast . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Alarm from %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-broadcast-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Alarm from %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Personal message from %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-from-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Personal message from %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from-to ."\
%[%#5$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$Group message to %#3M\nfrom %#2P (%#4s):

%#1t
%]%[%#5$\
----------------------------------------------------------------
%]")
    (message-from-to-long ."\
%[%#5$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$Group message to %#3M\nfrom %#2P (%#4s):

%#1t
%]%[%#5$\
-------------------------------------------------------------------------------
%]")


    (text-is-created . "Text %#1n has been created!")

    ; Used in mode-line-process
    (mode-line-waiting . ": waiting")
    (mode-line-working . ": working")
    (mode-line-saving . ": saving")
    (mode-line-down . ": down")

    ; From completing-read.el:

    (person-or-conf-no-regexp . "\\`[ \t]*[mpMP]\\w*[ \t]+\\([0-9]+\\)\\'")
    (session-no-regexp . "\\`[ \t]*[sS]\\w*[ \t]+\\([0-9]+\\)\\'")
    (conf-prompt . "Which conference/person? ")

    ; From prioritize.el:

    (cant-move-nothing-nowhere . "Can't move nothing anywhere.")
    (goto-priority-prompt . "Go to priority: ")
    (priority-prompt . "New priority for %#1M: ")
    (priority-prompt-marked . "New priority for selected conferences: ")
    (beginning-of-list . "Beginning of list")
    (end-of-list . "End of list")
    (reprioritize-from . "Reprioritize from: ")
    (reprioritize-to . "Reprioritize to: ")
    (no-selection . "No selection")
    (selection . "%d selected")

    (cannot-get-membership . "Cannot retrieve your membership list.")
    (cannot-get-pers-stat . "Cannot retrieve your personal status.")
    (prioritize-help .
"u,n Move conference, SPC select, p prioritize selection, q quit, C-h m help")
    (your-priorities . " Priority   Conference
-------------------------------------------------------------------------------
")
    (your-membship . "Your memberships:
  Prio Conf# Conference\n")
    (prio-row . " %5#1d%5#2m  %#3M\n")
    (too-high-goto-2 . "You are too high up. Move down to line two.")
    (too-low-go-up . "You can't push the last line. Move up one line.")
    (all-confs-popped .  "All conferences have been popped.")
    (prio-died . "Couldn't complete the move. Sorry. Kill the buffer.")
    (new-priority . "New priority? (0 (low) - 255 (high)) ")
    (new-prio . "%6#1d")

    ; From flags.el:
    (saving-settings . "Saving options...")
    (saving-settings-done . "Saving options...done")
    (hang-on . "Wait a moment...\n")
    (no-changes . "Nothing was saved since no options had been changed.\n")
    (could-not-save-options . "Couldn't save options.\n")
    (could-not-create-area . "Couldn't create the text.\n")
    (could-not-set-user-area . "Couldn't alter the user area. The server says error: %#1d\n")
    (you-dont-exist . "You don't exist. Go away.\n")
    (error-in-options . "There was an error in one of your variables (%#1s)
It was set to \"%#2s\" in the user area. It is set to nil instead.
Send a bug report.\n")
    (error-in-options-short . "There was an error in your saved settings. Some settings have not been read.")

    ; From elib-string.el:
    ; No entries.

    ; From lyskom-rest.el:

    (mode-line-unread . " Unread ")
    (mode-line-letters . "letters ")
    (frame-title-unread . "Unread")
    (frame-title-letters . " letters")
    (sessions-with-unreads . "Sessions with unread texts")
    (unread-letters . "unread letters")

    (bad-text-no-prefix . "Unable to translate prefix `%s' to a text number")
    (prefix-arg-try-again . "Specify another text or press control-g to abort.\n")
    (error-code . "Error code %#2d/%#3S: %#1s.\n")
    (error-in-kom-do-when-done . "The variable kom-do-when-done has an erroneous value.
You should set it to a better value.\n")
    (extended-command . "LysKOM: ")
    (wait-for-server . "LysKOM is waiting for a response from the server. Wait for the prompt.\n")
    (review-text-q . "Review text: ")

    (completely-read-conf . "You have seen all the texts in this conference.\n")
    (not-in-any-conf . "You are not in a conference now.\n")

    (all-conf-unread-r . "You have nothing unread.\n")
    (all-conf-unread-s . "You have nothing unread. ")
    (enter-conf-unread . "%#1d unread text%#1?d%[%]%[s%]")
    (enter-conf-unread-faq . "%#1d unread FAQ%#1?d%[%]%[s%]")

    (save-one-on-file-q . "Save copy of text %#1n in file: ")
    (save-many-on-file-q . "Save copies of %#1d texts in file: ")
    (saving-one-on-file . "Saving copy of text %#1n in %#2s.\n")
    (saving-many-on-file . "Saving %#1d texts in %#2s.\n")
    (save-text-to-file-q . "Save body of text %#1n in which file: ")
    (save-text-confirm . "File %#1s exists. Overwrite? ")
    (saving-text . "Saving text %#1n as %#2s...")
    (what-save-no . "Which text do you want to save? ")
    (wait-for-prompt . "Wait for the prompt.")

    (conference-no . "<conference %#1d>")
    (person-no . "<person %#1d>")
    (prompt-several-messages . "(%d messages)")
    (prompt-single-message . "(%d message)")

    (text-buffer-missing . "The text buffer no longer exists.\n")
    (re-edit-text-prompt . "Edit the text that couldn't be created")
    (go-to-pri-conf-prompt . "Go to next prioritized conference")
    (read-pri-text-conf . "Read next prioritized text")
    (review-next-text-prompt . "Review next text")
    (review-next-comment-prompt . "Review next comment")
    (review-next-marked-prompt . "Review next marked text")
    (review-next-faq-prompt . "Review next FAQ")
    (read-next-letter-prompt . "Read next letter")
    (read-next-footnote-prompt . "Read next footnote")
    (read-next-comment-prompt . "Read next comment")
    (read-next-text-prompt . "Read next text")
    (read-next-attachment-prompt . "Read next attachment")
    (go-to-conf-of-marked-prompt . "Resume reviewing marked")
    (go-to-conf-of-review-tree-prompt . "Resume reviewing comments")
    (go-to-conf-of-review-prompt . "Resume reviewing texts")
    (go-to-conf-of-review-faq-prompt . "Resume reviewing FAQs")
    (go-to-next-conf-prompt . "Go to next conference")
    (go-to-your-mailbox-prompt . "Go to your mailbox")
    (next-pri-session-prompt . "Go to prioritized LysKOM \"%#1s\"")
    (next-unread-session-prompt . "Go to LysKOM \"%#1s\"")
    (no-such-kom-session . "No such session with unread texts.\n")
    (the-command . "Command: %#1C")
    (error-in-login-hook . "There was an error in your kom-login-hook: %#1s\n")

    (give-a-number . "Enter a number: ")

    (yes-regexp . "\\`[yY][eE][sS]\\'")
    (no-regexp . "\\`[nN][oO]\\'")
    (yes-string . "Yes")
    (no-string . "No")
    (yes-or-no-nag . "Answer yes or no.")
    (yes-or-no . "(yes or no) ")

    (y-or-n-instring . "yYnN ")
    (j-or-n-nag . "Answer y or n. ")
    (j-or-n . "(y or n) ")
    (y-instring . "yY ")

    (person-does-not-exist . "User %#1d (does not exist).")
    (conference-does-not-exist . "Conference %#1d (does not exist).")
    (conf-no-does-not-exist-r . "Conference %#1d does not exist.")
    (person-is-anonymous . "Anonymous user")

    (process-signal . "Signal from the process.")
    (dead-session . "No active LysKOM session.")
    (not-lyskom-buffer . "This is not an active LysKOM session.")
    (closed-connection . "
**************************************************
%#2s
LysKOM session killed abnormally
Error message: %#1s**************************************************")
    (error-not-found . "Error code %#1d. No explanation available.")

    ; Useful in more places than one:
    (illegal-command . "Illegal command.\n")
    (no-such-text . "The text doesn't exist.\n")
    (no-such-text-m . "The text doesn't exist.")
    (nobody . "nobody")
    (everybody . "everyone")
    (everything . "everything")
    (anybody . "anyone")
    (forward . "forward")
    (backward . "backward")
    (wait . "Wait a moment...\n")
    (comment . "Comment")
    (comment-prefix . "[Cc][Oo]")
    (footnote . "Footnote")
    (footnote-prefix . "[Ff]")
    (by . " by %#1P")
    (text-created .  "Text %#1n has been created.\n")
    (text-created-anonymous .  "\
Text %#1n has been created (anonymously). To make it more difficult
for others to figure out that you wrote the text, you should wait a while
before reading it.\n")

    (resolve-session . "Which session: ")

    (starting-program . "Starting %#1s...")
    (super-jump . "Filtering subject \"%#1r\" in conference \"%#2M\"\n")
    (no-recipient . "There are no recipients for this text.\n")
    (filtered . "[Filtered]")
    (filter-error-specification . "Error in the filter specification")
    (filter-error-bad-not . "Error in the filter specification after 'not'")
    (filter-error-unknown-key . "The filter key '%S' is unknown.")
    (filter-error-key-arg . "Bad filter data (%S %S)")
    (filter-tree . "Skipping text %#1n \"%#2r\" by %#3P and all its comments.\n")
    (filter-text . "Skipping text %#1n \"%#2r\" by %#3P.\n")
    (filter-permanent . "Permanent? ")
    (filter-action . "Filter how? ")
    (filter-in-conf . "In which conference? (all) ")
    (filter-subject . "Filter which subject? ")
    (filter-recipient . "Filter which recipient? ")
    (filter-which-text . "Filter texts containing: ")
    (filter-author . "Filter which author? ")
    (permanent . "(permanent)")
    (temporary . "(temporary)")
    (filter-edit-buffer-name . "*LysKOM Filter Edit*")
    (filter-edit-empty-list . "Empty list")
    (filter-edit-start-of-list . "Beginning of list")
    (filter-edit-end-of-list . "End of list")
    (filter-edit-filter-how . "Filter how? ")
    (filter-edit-filter-what . "What do you want to filter? ")
    (filter-edit-bad-argument . "Bad input: %s")
    (filter-edit-outside-entry . "Can't do that outside a filter")
    (filter-edit-outside-list . "Can't do that outside the list")
    (filter-edit-end-of-pattern . "End of filter")
    (filter-edit-save-p . "Save changes? ")
    (filter-edit-remove-empty . "Empty filters cause all texts to be filtered. Do you want to remove these? ")
    (filter-edit-restart-p . "You have made changes. Really revert? ")
    (filter-edit-help . "p Up, n Down, i New line, M-i New filter, d Delete line, M-d Delete filter")
    (filter-edit-header . "Edit filters on \"%s\"\n")
    (filter-edit-saving . "Saving changes...")
    (filter-edit-saving-done . "Saving changes...done")
    (filter-edit-saving-error . "Couldn't save changes!")
    (filter-edit-insert-pred . "%#1s (=,!=): ")
    (filter-edit-insert-arg . "%#1s %#2s (what): ")
    (no-filters . "No filters are defined.\n")
    (view-filters-header . "\nActive filters:\n\n")
    (view-filters-footer . "")

    (ansaphone-new-message . "New Ansaphone message: ")
    (ansaphone-message . "Ansaphone message:
----------------------------------------------------------------------
%#1t
----------------------------------------------------------------------
")
    (ansaphone-message-long . "Ansaphone message:
-------------------------------------------------------------------------------
%#1t
-------------------------------------------------------------------------------
")
    (ansaphone-state . "The Ansaphone is %#1s.")
    (ansaphone-state-r . "The Ansaphone is now %#1s.\n")
    (ansaphone-messages-gone . "Recorded messages have been erased.")
    (ansaphone-no-messages . "No recorded messages.\n")
    (ansaphone-message-list-start . "Recorded messages:\n\n")
    (ansaphone-message-list-end . "\n\n")
    (ansaphone-message-header . "Automatic reply (set %#1s):\n")

    (remote-erase-messages . "Remote control (%#1P %#2s): Erased recorded messages\n")
    (remote-set-message . "Remote control (%#1P %#2s): Ansaphone message:
----------------------------------------------------------------------
%#3t
----------------------------------------------------------------------
")
    (remote-set-message-long . "Remote control (%#1P %#2s): Ansaphone message:
-------------------------------------------------------------------------------
%#3t
-------------------------------------------------------------------------------
")    (remote-set-ansaphone . "Remote control (%#1P %#2s): The ansaphone is %#3s\n")
    (remote-list-messages . "Remote control (%#1P %#2s): Listed recorded messages\n")
    (remote-quit . "Remote control (%#1P %#2s): Quit\n")

    (illegal-remote . 
"Illegal remote control attempt:
Time: %#1s
From: %#2P <%#2p>
To  : %#3P <%#3p>
Text: 
%#4t")
    (illegal-remote-reply . "Remote control rejected: %#1s") 
    (remote-not-in-list . "Unauthorised person")
    (remote-bad-command . "Unknown or malformed command")
    (remote-unknown-error . "Unknown error")

    (remote-control-who . "Remotely control which session? ")
    (remote-control-autoreply . "Ansaphone on or off? ")

    (state-on . "on")
    (state-off . "off")
    

    (text-popup-title . "Text %#1s")
    (conf-popup-title . "Conference %#1s")
    (pers-popup-title . "User %#1s")
    (url-popup-title  . "URL %#1s")
    (aux-popup-title  . "Auxiliary information")
    (timestamp-popup-title . "Timestamp %#1s")
    (recpt-type-popup-title . "Recipient type: %#1s")
    (add-recpt-button-text . "[Add...]")
    (add-recpt-button-text-regex . "\\[Add\\.\\.\\.\\]")
    (generic-popup-title . "%#1s")

    (who-i-am-not-present . "%#1P (not in any conference) \n")
    (who-i-am-present . "%#1P is present in %#2M\n")
    (who-i-am-client . "The program is lyskom.el, version %#1s%#2?b%[ (MULE)%]%[%].\n")
    (who-i-am-server . "This is %#1s, version %#2s.\n")
    (who-i-am-emacs . "Running under %#1s%#2?b%[ (MULE)%]%[%].\n")

    (no-such-session-r . "That session does not exist. Perhaps the user is not logged on.\n")
    (person-not-logged-in-r . "%#1P %#2?b%[has not been logged on since %#2s%]%[is not logged on%].\n")

    (session-status . "Session %#1d is %#2P <%#2p>
%#5s %#7s %#4M
Using %#6D from %#3s\n")
    (session-status-9 . "Session %#1d is %#2P <%#2p>
%#5s %#7s %#4M
Using %#6D from %#3s
On since %#8s%#9s")
    (session-status-inactive . "\nHas been inactive for %#1s\n")
    (one-day . "one day")
    (one-hour . "one hour")
    (one-minute . "one minute")
    (years . "years")
    (year . "r")
    (month . "month")
    (months . "months")
    (days . "days")
    (day . "day")
    (hours . "hours")
    (minutes . "minutes")
    (and . "and")
    (session-is-active . " and is currently active.\n")
    (session-is-invisible . "This session is invisible.\n")
    (status-for-session . "Session status for whom? ")
    (unknown-doing-what . "Exists")
    (doing-where-conn . "in")
    (doing-nowhere-conn . "but is")
    (waiting-for-membership . "Waiting for the membership list to be fetched...%d/%d")

    ;; From slow.el
    (no-such-command . "There is no such command.\n")
    (command-completions . "You may mean one of the following:\n %#1s\n")

    (which-language . "Change language to: ")
    (send-formatted . "Send as formatted text? ")
    (changing-language-to . "Changing to %#1s.\n")
    (language-set-to . "Language set to %#1s.\n")
    (language-not-loaded . "%#1s is unavailable.\n")

    (reformat-html . "HTML")
    (reformat-enriched . "enriched")
    (reformat-filled . "filled")

    (reformat-truncated . "truncated")

    (reformat-signature . "designed")

    (reformat-deswascii . "was swascii")

    (need-library . "The \"%#1s\" package is required for this command.\n")
    (calc-expression . "Expression: ")

    (do-send-anonymous . "Send the text anonymously? ")
    (anonymous . "anonymous")
    (Anonymous . "Anonymous")

    (secret-conf-letter . "S")
    (protected-conf-letter . "P")
    (created-conf-letter . "C")
    (superconf-conf-letter . "S")
    (supervisor-conf-letter . "O")

    ;; Some Help

    (where-is-doesnt-exist . "The command %#1s does not exist")
    (where-is-on-no-key . "%#1s is not on any key")
    (where-is-on-key . "%#1s is on %#2s")

    ;; From aux-items.el

    (content-type-aux . "Content type: %#1s")
    (content-type-regexp . "Content type: \\(\\S-+\\)")

    (agreeing . "Agreeing with text %#1n...")
    (fast-replying . "Remark to text %#1n...")
    (author-fast-replies . "Remarks by the author:")
    (author-fast-reply-aux . "  \"%#1t\"")
    (other-fast-replies . "Remarks:")
    (other-fast-reply-aux . "  \"%#1t\" /%#2P/")
    (fast-reply-too-long . "Can't create remarks that consist of more than one line.\n")

    (faq-for-conf-aux . "FAQ for %#1M <%#1m>") 
    (faq-for-server-aux . "FAQ for the LysKOM-server") 
    (faq-in-text-aux . "FAQ in text:                 %10#1n %#2D")
    (conf-to-add-faq . "Which conference do you want to add an FAQ for? ")
    (text-to-add-as-faq . "Which text is the new FAQ? ")
    (text-to-change-as-faq . "Which FAQ do you want to change? ")
    (adding-faq . "Adding text %#1n as an FAQ for %#2?b%[%#2M%]%[the server%]...")
    (conf-to-del-faq . "Which conference do you want to remove an FAQ from? ")
    (text-to-del-as-faq . "Which text do you want to remove as FAQ? ")
    (deleting-faq . "Removing text %#1n as FAQ for %#2?b%[%#2M%]%[the server%]...")
    (conf-has-no-faq . "%#1?b%[%#1M%]%[The server%] has no FAQ\n")
    (view-which-faq . "View FAQ for which conference? ")
    (review-faq-for-r . "View FAQ for %#1?b%[%#1M%]%[the server%].\n")
    (changed-faq-for-conf-done . "FAQ in text %#2n for %#1?b%[%#1M%]%[the server%] changed to text %#3n.\n")
    (changed-faq-for-conf-failed . "Unable to change FAQ for %#1?b%[%#1M%]%[the server%] to text %#3n.
%#2?b%[Text %#2n is still the FAQ.
%]%[%]%#4s")
    (faq-in-text . "FAQ in text %#1n %#3s%#4s")
    (faq-in-text-by . "FAQ in text %#1n %#5s %#3sby %#2P %#4s")
    (server-has-new-faq . "\nThere %#1?d%[is a new FAQ%]%[are %#1d new FAQs%] for the server.\n")
    (unread-faqs-header . "\nUnread FAQ%#1?d%[%]%[s%] for %#2?b%[%#2M%]%[the server%]::\n")

    (too-many-languages . "Cannot code that many character sets. Send uncoded? ")
    (too-many-content-types . "Cannot figure out what content type you want. Simplify the text.")

    (cross-reference-text-status-aux . "See text:              %10#1n /%#2P/")
    (cross-reference-conf-status-aux . "See conference:                         <%#1m> %#1M /%#2P/")
    (cross-reference-pers-status-aux . "See person:                             <%#1p> %#1P /%#2P/")
    (strange-cross-reference-status .  "See also:                                %#1s (whatever that means)")
    (cross-reference-text-aux . "See text %#1n /%#2P/")
    (cross-reference-conf-aux . "See conference <%#1m> %#1M /%#2P/")
    (cross-reference-pers-aux . "See person <%#1p> %#1P /%#2P/")
    (cross-reference-text-regexp . "See text \\([0-9]+\\)")
    (cross-reference-conf-regexp . "See conference <\\([0-9]+\\)>")
    (cross-reference-pers-regexp . "See person <\\([0-9]+\\)>")
    (strange-cross-reference . "See %#1s, whatever that might mean")

    (no-comments-aux . "The author has requested others not to comment this text")
    (no-comments-edit-aux . "Request that others do not comment")
    (no-comments-regexp . "Request that others do not comment")
    
    (personal-comment-aux . "The author has requested private replies only")
    (personal-comment-edit-aux . "Request private replies only")
    (personal-comment-regexp . "Request private replies only")
    
    (request-confirmation-aux . "%#1P has requested confirmation of reading")
    (request-confirmation-edit-aux . "Request confirmation of reading")
    (request-confirmation-regexp . "Request confirmation of reading")
    (confirm-read-q . "Confirm reading text %#1n? ")
    
    (read-confirm-aux . "Confirmed reading: %#1P %#2s")

    (redirect-email-aux . "Send e-mail to %#1s")
    (redirect-lyskom-aux . "Send texts to conference %#1M")

    (label-what-kind . "Set personal label on what (text, conference, user)? ")
    (label-what-text . "Set personal label on text: ")
    (label-what-conf . "Set personal label on which conference? ")
    (label-what-pers . "Set personal label on which person? ")
    (label-what-label . "Personal label: ")
    (label-secret    . "Should others to be able to see the label? ")

    (creating-software-aux . "Created with %#1s")
    (world-readable-text-aux . "The text can be read without logging on")
    (world-readable-text-edit-aux . "Make the text readable without logging on")

    (cant-get-aux-item . "Can't find auxiliary information\n")
    (aux-item-no-info . "No information available\n")
    (aux-item-info . "\
Number:        %#1d %#6s
Type:          %#2d (%#3s)
Created by:    %#4P <%#4p>
Created:       %#5s
Flags:         %#7s
Inherit limit: %#8s
Contents:     \"%#9s\"
")
    (secret . "Secret")
    (deleted . "Deleted")
    (hide-creator . "Secret creator")
    (inherit . "Inherited")
    (unlimited-inherit . "Unlimited inheritance")
    (no-inheritance . "Inheritance is off")
    (no-more-inheritance . "Inherit limit reached; will not be further inherited")
    (inherit-steps . "%#1d steps")

    (aux-item-for . "Auxiliary information for ")
    (aux-item-for-conference-no . "conference <%#1m> %#1M")
    (aux-item-for-text-no . "text %#1n")
    (aux-item-for-server . "the server")

    (what-fast-reply-no . "Remark to which text? ")
    (fast-reply-prompt . "Remark: ")
    (agree-prompt . "Text: ")
    (default-agree-string . "I agree")
    (what-agree-no . "Agree with which text? ")

    (what-kind-to-add-aux-to . "Attach information to what? ")
    (which-conf-to-add-aux-to . "Which conference to you want to attach information to? ")
    (which-text-to-add-aux-to . "Which text to you want to attach information to? ")
    (which-aux-item-tag . "Information tag: ")
    (which-aux-item-inherit . "Set the  inherit-flag? ")
    (which-aux-item-secret . "Set the secret-flag? ")
    (which-aux-item-anonymous . "Set the anonymous-flag? ")
    (which-aux-item-rsv1 . "Set the dont-garb-flag? ")
    (which-aux-item-rsv2 . "Set the reserved2-flag? ")
    (which-aux-item-rsv3 . "Set the reserved3-flag? ")
    (which-aux-item-rsv4 . "Set the reserved4-flag? ")
    (which-aux-item-inherit-limit . "Inherit limit: ")
    (which-aux-item-data . "Data: ")

    ;; Cross-reference stuff

    (person . "User")
    (conference . "Conference")
    (text . "Text")
    (server . "Server")

    (xref-type . "What to you want to refer to (text, conference or person)? ")
    (which-text-to-xref . "Add reference to text: ")
    (which-text-to-xref-err . "Text not found. Add reference to text: ")
    (which-pers-to-xref . "Add reference to user: ")
    (which-conf-to-xref . "Add reference to conference: ")

    ;; Aux-item stuff from edit-text

    (no-comments-q . "The author doesn't want comments. Comment anyway? ")
    (private-answer-q . "The author wants private replies. Write private reply? ")

    (your-invited . "You have been invited to %#1M by %#2P.
By accepting the invitation you will continue to be a member of %#1M.
If you decline the invitation you will not be a member of the conference.
")
    (accept-invitation . "Do you want to accept the invitation now? ")
    (enter-passive . "You are a passive member of %#1M.
You must become an active member of the conference to enter it.\n")
    (convert-passive . "Vill du bli aktiv medlem i %#1M? ")
    (bug-secret-mship . "You are a secret member of %#1M\n")

    (invitation-mt-type . "invited")
    (passive-mt-type . "passive")
    (secret-mt-type . "secret")

    (Invitation-mt-type . "Invited")
    (Passive-mt-type . "Passive")
    (Secret-mt-type . "Secret")

    (not-author-try-anyway-p . "You are not the author of the text. Try anyway? ")
    (what-no-comments-no . "Which text do you want to prevent comments to: ")
    (adding-no-comments . "Preventing comments to text %#1n...")
    (already-no-comments . "Text %#1n already prevents comments.\n")

    (what-private-answer-no . "Which text do you want private replies to: ")
    (adding-private-answer . "Requesting only private replies to text %#1n...")
    (already-private-answer . "Text %#1n already has a request for private replies only.\n")

    (what-request-confirm-no . "Which text do you want read confirmations for: ")
    (adding-request-confirm . "Requesting read confirmations for text %#1n...")
    (already-request-confirm . "Text %#1n already has a request for read confirmations.\n")

    (review-mail-headers-to-what . "Which text's mail headers do you want to see? ")
    (no-mail-headers . "Text %#1n has no mail headers\n")
    (mail-headers-for . "Mail headers for text %#1n:\n")
    (email-name-prefix . "")
    (email-name-suffix . "")

    (you-are-anonymous . "You are now somewhat anonymous.\n")
    (you-are-nonanonymous . "You are no longer anonymous.\n")
    (you-are-already-anonymous . "You are already somewhat anonymous.\n")
    (you-are-already-nonanonymous . "You are already non-anonymous.\n")

    (start-keep-alive . "Sending data at %#1d second intervals to keep the connection active.")
    (stop-keep-alive . "No longer keeping connection active by sending extra data.")

    (review-noconversion-q . "Review which text unconverted?")
    (review-commented-q . "Review the commented for which text?")

    (review-tree-q . "Review all comments recursively for which text?")
    (find-root-q . "Review original text for text?")
    (find-root-review-q . "Review tree of which text?")
    (review-comments-q . "Review all comments to which text?")

    (confusion-who-to-reply-to . "I can't figure out which text you want to write a private reply to.\n")
    (confusion-what-to-answer-to . "I can't figure out which text you want to write a reply to.\n")
    (confusion-what-to-view . "I can't figure out which text you want to view.\n")

    (confusion-what-to-reply-to . "I can't figure out which text you want to write a remark to.\n")
    (confusion-what-to-agree-to . "I can't figure out which text you want to agree with.\n")
    (confusion-what-to-request-confirmation . "I can't figure out which text you want read confirmations for.\n")
    (confusion-what-to-comment . "I can't figure out which text you want to comment.\n")
    (confusion-what-to-footnote . "I can't figure out to which text you want to write a footnote to.\n")

    (confusion-what-to-delete . "I can't figure out which text you want to delete.\n")
    (confusion-what-to-add-sub-recipient . "I can't figure out which text you want to %#1s.\n")
    (add-rcpt-action-name . "add a recipient to")
    (add-copy-action-name . "add a carbon copy recipient to")
    (add-bcc-action-name . "add a blind carbon copy recipient to")
    (sub-action-name . "remove a recipient from")
    (move-action-name . "move")

    (confusion-what-to-add-comment-to . "I can't figure out which text you want to add a comment to.\n")
    (confusion-what-to-sub-comment-from . "I can't figure out which text you want to remove a comment from.\n")
    (confusion-what-to-add-footnote-to . "I can't figure out which text you want to add a footnote to.\n")
    (confusion-what-to-sub-footnote-from . "I can't figure out which text you want to remove a footnote from.\n")
    
    (confusion-what-to-mark . "I can't figure out which text you want to mark.\n")
    (confusion-what-to-unmark . "I can't figure out which text you want to unmark.\n")
    (confusion-what-to-save . "I can't figure out which text you want to save.\n")

    (confusion-what-to-review-mail-headers . "I can't figure out which text's mail headers you want to see.\n")
    (confusion-what-to-find-root . "I can't figure out which text's root you want to see.\n")
    (confusion-what-to-find-root-review . "I can't figure out which tree you want to review.\n")

    ;; Help stuff

    (help-with-what . "What do you want help with? ")
    (help-for . "Help for \"%#1s\"\n")

    ;; Button actions

    (lyskom-button-view-text-action . "View text")
    (lyskom-button-copy-text-no-action . "Copy text number")
    (lyskom-button-review-noconversion-action . "Review unconverted")
    (lyskom-button-find-root-review-action . "Review tree")
    (lyskom-button-find-root-action . "Review root text")
    (lyskom-button-comment-text-action . "Write comment")
    (lyskom-button-private-comment-text-action . "Write personal reply")
    (lyskom-button-mark-text-action . "Mark text")
    (lyskom-button-unmark-text-action . "Unmark text")
    (lyskom-button-save-text-action . "Save archive copy")
    (lyskom-button-save-text-body-action . "Save text body")
    (lyskom-button-review-comments-action . "Review all comments")
    (lyskom-button-review-tree-action . "Review all comments recursively")
    (lyskom-button-write-footnote-action . "Write footnote")
    (lyskom-button-fast-reply-action . "Remark")
    (lyskom-button-view-conf-presentation-action . "View presentation")
    (lyskom-button-view-conf-status-action . "View conference status")
    (lyskom-button-goto-conf-action . "Go to conference")
    (lyskom-button-send-message-action . "Send group message")
    (lyskom-button-add-self-action . "Join conference")
    (lyskom-button-sub-self-action . "Leave conference")
    (lyskom-button-view-pers-presentation-action . "View presentation")
    (lyskom-button-view-pers-status-action . "View user status")
    (lyskom-button-view-session-status-action . "View session status")
    (lyskom-button-mail-action . "Send letter")
    (lyskom-button-send-message-action . "Send personal message")
    (lyskom-button-open-url-action . "Open")
    (lyskom-button-copy-url-action . "Copy")
    (lyskom-button-goto-info-node-action . "Open")
    (lyskom-button-open-email-action . "Send mail")
    (lyskom-button-copy-email-action . "Copy")
    (lyskom-button-info-aux-action . "Information")
    (lyskom-button-delete-aux-action . "Delete")
    (lyskom-button-copy-timestamp-action . "Copy")
    (lyskom-button-recpt-type-recipient . "Recipient")
    (lyskom-button-recpt-type-copy . "Carbon copy")
    (lyskom-button-recpt-type-bcc . "Blind Carbon copy")
    (lyskom-button-recpt-type-sub . "Remove")
    (lyskom-button-recpt-add-recipient . "Recipient")
    (lyskom-button-recpt-add-copy . "Carbon copy recipient")
    (lyskom-button-recpt-add-bcc . "Blind carbon copy recipient")
    (lyskom-button-aux-type-xref . "Referenc till conference/person/text")
    (lyskom-button-aux-type-no-comments . "Request no comments")
    (lyskom-button-aux-type-personal-comments . "Request personal reply")

    (lyskom-edit-toggle-secret-aux-action . "Toggle \"secret\"")
    (lyskom-edit-toggle-anonymous-aux-action . "Toggle \"anonymous\"")
    (lyskom-edit-toggle-inherit-aux-action . "Toggle \"inherited\"")
    (lyskom-edit-delete-aux-action . "Delete")
    (lyskom-prioritize-flag-toggle-action . "Toggle")
    (lyskom-prioritize-flag-set-action . "Set")
    (lyskom-prioritize-flag-clear-action . "Clear")

    (server-status-header   . "Status for LysKOM-server %#1s%#2?b%[ (%#2s:%#3d)%]%[%]\n\n")
    (server-status-server   . "Canonical server name:                   %#1s%#2?b%[:%#2s%]%[%]\n")
    (server-status-version  . "Software version:                        %#1s %#2s\n")
    (server-status-protocol . "Protocol version:          %15#1d\n")
    (server-status-sessions . "\
Number of sessions:  %21#1d (total)
                     %21#2d active in the last %#7d minutes
                     %21#3d inactive sessions
                     %21#4d unknown activity
                     %21#5d invisible sessions
                     %21#6d not logged on/secret/zombies\n")
    (server-status-first-text . "Oldest existing text:      %15#1n\n")
    (server-status-last-text  . "Youngest existing text:    %15#1n\n")
    (server-status-has-motd . "\nThe server has a notice:\n")
    (server-status-time . "Serverns tid:                   %#1s\n")

    (mship-type-invitation-q . "Membership invitation? ")
    (mship-type-passive-q . "Passive membership? ")
    (mship-type-secret-q . "Secret membership? ")
    (recommend-which-conf . "Which conference do you want to recommend? ")
    (recommend-set-priority-q . "Recommend a priority? ")
    (recommend-set-mship-type-q . "Recommend a membership type? ")
    (recommending-conf . "Recommending %#1M%#2?b%[ (priority %#2d)%]%[%]%#3?b%[ %#3s%]%[%]...")
    (has-recommended-conf . "%#1P has recommended conference %#2M. Do you want to become a member?\n")
    (accept-recommendation . "Join conference %#1M? ")
    (accepting-recommendataion . "Joining recommended conference %#1M...")

    (redirect-for-whom . "Redirect comments for whom: ")
    (redirect-to-which-conf . "Redirect comments to: ")
    (redirecting-comments-to . "Redirecting comments for %#1P to %#2M%#3?b%[ (old %#1M)%]%[%]...")

    (kom-redirect-comments-e49 . "You do not have permission to perform this redirection")
    (kom-redirect-comments-e48 . "Comment redirection is not supported by the server")

    (external-program-missing . "Can't find the external program \"%#1s\", that was required for this command.")
    (ignored-user-area-var . "\

Ignoring the following variables in your settings:

    %#1s

These variables are not registered as LysKOM variables and cannot be
read from the server. You can remove the variables from the server by
giving the command \"Save options\".\n\n")


    (unknown-aux-item . "Oknd tillggsinformation")
    (text-header-aux-item . "%#1s: <%#2d> \"%#3s\" %#4s")

    (aux-content-type-name . "Content type")
    (aux-fast-reply-name . "Remark")
    (aux-cross-reference-name . "Reference")
    (aux-no-comments-name . "Request for no comments")
    (aux-personal-comment-name . "Request for personal replies")
    (aux-request-confirmation-name . "Request for read confirmation")
    (aux-read-confirm-name . "Read confirmation")
    (aux-redirect-name . "Redirect")
    (aux-x-face-name . "Picture")
    (aux-alternate-name-name . "Alternate name")
    (aux-pgp-signature-name . "PGP signature")
    (aux-pgp-public-key-name . "PGP public key")
    (aux-e-mail-address-name . "E-mail address")
    (aux-faq-text-name . "FAQ in text")
    (aux-creating-software-name . "Creating software")
    (aux-mx-author-name . "E-mail author")
    (aux-mx-from-name . "E-mail from")
    (aux-mx-reply-to-name . "E-mail reply to")
    (aux-mx-to-name . "E-mail to")
    (aux-mx-cc-name . "E-mail CC")
    (aux-mx-date-name . "E-mail date")
    (aux-mx-message-id-name . "E-mail message ID")
    (aux-mx-in-reply-to-name . "E-mail in reply to")
    (aux-mx-misc-name . "E-mail headers")
    (aux-mx-allow-filter-name . "E-mail allow-filter")
    (aux-mx-reject-forward-name . "E-mail reject-forward")
    (aux-notify-comments-name . "Notify me about comments")
    (aux-faq-for-conf-name . "FAQ for conference")
    (aux-recommended-conf-name . "Conference recommendation")
    (aux-allowed-content-type-name . "Allowed content type")
    (aux-canonical-name-name . "Canonical name")
    (aux-mx-list-name-name . "Mailing list name")
    (aux-send-comments-to-name . "Send comments to")
    (aux-world-readable-name . "World-readable")
    (aux-elisp-client-read-faq-name . "Read FAQ")
    (aux-elisp-client-rejected-invitation-name . "Rejected invitation")

    (review-marking-as-read . "Review marks as read")
    (review-not-marking-as-read . "Review does not mark as read")

    (using-ssh-connection . "Using ssh connection to %#1s...")
    (opening-ssh-connection . "Opening ssh connection to %#1s...")
    (ssh-cant-connect . "Unable to open ssh connection: %s")
    (ssh-closnig . "Closing ssh connection to %#1s")
    (ssh-unknown-host . "unknown host")

    (keyboard-cancel . "Cancel")
    (keyboard-menu-help . "(choose: C-n, C-p; confirm: RET)")
    (customize-help . "See the beginning of the buffer for more information")
    (missing-faces . "\
Your text face scheme \"%#1s\" is missing the following faces:

    %#2s

Using the default face in place of these faces.
")
    ))


(lyskom-language-var local lyskom-month-names en
  '(("jan" . 1)  ("january" . 1)
    ("feb" . 2)  ("february" . 2)
    ("mar" . 3)  ("march" . 3)
    ("apr" . 4)  ("april" . 4)
    ("may" . 5)  ("may" . 5)
    ("jun" . 6)  ("june" . 6)
    ("jul" . 7)  ("july" . 7)
    ("aug" . 8)  ("august" . 8)
    ("sep" . 9)  ("september" . 9)
    ("oct" . 10) ("october" . 10)
    ("nov" . 11) ("november" . 11)
    ("dec" . 12) ("december" . 12)))


;;; ================================================================
;;;              The commands and their associated functions


;;; Formely known as lyskom-commands
(lyskom-language-strings local lyskom-command en
  '(
    (kom-help                 . "Help")
    (kom-slow-mode            . "Long commands")
    (kom-quick-mode           . "Short commands")
    (kom-send-message         . "Send message")
    (kom-send-alarm           . "Send alarm")
    (kom-create-conf          . "Create conference")
    (kom-delete-conf          . "Delete conference/user")
    (kom-delete-text          . "Remove text")
    (kom-display-time         . "Time")
    (kom-go-to-conf           . "Go (to) conference")
    (kom-go-to-next-conf      . "(Go to) next conference")
    (kom-jump                 . "Skip (all) comments")
    (kom-list-created-conferences     . "List owned conferences") 
    (kom-list-conferences     . "List conferences") 
    (kom-list-persons         . "List users")
    (kom-list-news            . "List news")
    (kom-list-re              . "List (using) regexps")
    (kom-membership           . "List memberships")
    ;; (kom-list-marks	      . "List marks")
    (kom-postpone             . "Postpone reading")
    (kom-set-session-priority . "Set reading level")
    (kom-prioritize           . "Prioritize conferences")
    (kom-status-person        . "Status (of) user")
    (kom-status-conf          . "Status (of) conference")
    (kom-add-self             . "Join conference")
    (kom-change-priority      . "Change priority")
    (kom-list-summary         . "List text (subjects)")
    (kom-sub-self             . "Leave (a) conference")
    (kom-quit                 . "Quit")
    (kom-recover              . "Recover") 
    (kom-start-anew           . "New User")
    (kom-view                 . "Review text")
    (kom-find-root-review     . "Review tree")
    (kom-review-comments      . "Review all comments")
    (kom-review-tree          . "Review all comments recursively")
    (kom-review-clear         . "Review and skip")
    (kom-review-last-normally-read
     			      . "Review again")
    (kom-review-noconversion  . "Review unconverted")
    (kom-review-next          . "Review next")
    (kom-find-root            . "Review original (text)")
    (kom-review-by-to         . "Review last")
    (kom-review-first         . "Review first")
    (kom-review-all           . "Review all")
    (kom-review-more          . "Review more")
    (kom-view-commented-text  . "Review (the) commented (text)")
    (kom-view-previous-commented-text
     			      . "Review (the) previously commented (text)")
    (kom-review-stack         . "Review stack")
    (kom-review-presentation  . "Review presentation")
    (kom-review-backward      . "(Review) Backwards")
    (kom-view-next-text       . "(Read) next text")
    (kom-who-is-on            . "Who (is on)")
    (kom-who-is-on-in-conference
                              . "Who (is on in) conference")
    (kom-who-is-present-in-conference
                              . "Who (is) present (in) conference")
    (kom-who-is-on-and-friend . "Which friends (are on)")
    (kom-who-am-i             . "Where (am) i")
    (kom-list-clients	      . "List clients")
    (kom-busy-wait            . "Wait (for news)")
    (kom-write-comment        . "(Write) comment")
    (kom-comment-previous     . "(Write) comment (to) previous text")
    (kom-write-footnote       . "(Write) footnote")
    (kom-private-answer       . "(Write) personal reply (by letter)")
    (kom-private-answer-previous
   . "(Write) personal (reply to) previous text (by letter)")
    (kom-set-unread     	      . "Only (the) last")
    (kom-write-text           . "Write (a) text")
    (kom-send-letter          . "Write (a) letter")
    (kom-change-name          . "Change name")
    (kom-change-parenthesis   . "Change parenthesis")
    (kom-change-password      . "Change password")
    (kom-change-supervisor    . "Change supervisor")
    (kom-change-presentation  . "Change presentation")
    (kom-get-appreciation     . "(Please) pat my head")
    (kom-get-abuse            . "(Please) kick my butt")
    (kom-mark-text            . "Mark (text)")
    (kom-unmark-text          . "Unmark (text)")
    (kom-review-marked-texts  . "Review marked (texts)")
    (kom-review-all-marked-texts . "Review all marked (texts)")
    (kom-add-recipient        . "Add recipient")
    (kom-add-copy             . "Add (recipient of) carbon copy")
    (kom-add-bcc	      . "Add (recipient of) blind carbon copy")
    (kom-sub-recipient        . "Remove recipient")
    (kom-move-text            . "Move text")
    (kom-move-text-tree       . "Move tree")
    (kom-add-comment          . "Add comment")
    (kom-sub-comment          . "Remove comment")
    (kom-add-cross-reference  . "Add cross reference")
    (kom-add-member           . "Add (a) member")
    (kom-sub-member           . "Remove (a) member")
    (kom-change-conf-motd     . "(Post) notice (on the) conference")
    (kom-set-garb-nice        . "Change expiration")
    (kom-set-super-conf       . "Change superconference")
    (kom-set-permitted-submitters . "Change allowed authors")
    (kom-unset-conf-motd      . "Remove notice")
    (kom-save-text            . "Archive (copy of) text (in file)")
    (kom-save-text-body       . "Save text body (in file)")
    (kom-save-options         . "Save options")
    (kom-shutdown-server      . "Shut down (server)")
    (kom-sync-database        . "Save (the) database")
    (kom-enable-adm-caps      . "Become administrator")
    (kom-disable-adm-caps     . "Become (normal) user")
    (kom-set-motd             . "Change login message")
    (kom-remove-motd          . "Remove login message")
    (kom-force-logout         . "Kill session")
    (kom-filter-author        . "Filter author")
    (kom-filter-subject       . "Filter subject")
    (kom-filter-recipient     . "Filter recipient")
    (kom-super-jump           . "Super jump")
    (kom-filter-edit          . "Edit filters")
    (kom-filter-text          . "Filter contents")
    (kom-list-filters         . "List filters")
    (kom-show-user-area       . "Show user area")
    (kom-change-conf-type     . "Change conference type")

    (kom-change-auto-reply    . "Change ansaphone message")
    (kom-toggle-auto-reply    . "Ansaphone")
    (kom-list-messages        . "List messages")
    (kom-erase-messages       . "Erase messages")

    (kom-remote-autoreply     . "Remote control ansaphone")
    (kom-remote-set-message   . "Remote control change ansaphone message")
    (kom-remote-list-messages . "Remote control list messages")
    (kom-remote-erase-messages . "Remote control erase messages")
    (kom-remote-quit          . "Remote control quit")

    (kom-status-session       . "Status (of) session")
    (kom-customize            . "Customize LysKOM")
    (kom-next-kom             . "Next LysKOM")
    (kom-previous-kom         . "Previous LysKOM")
    (kom-next-unread-kom      . "Next unread LysKOM")
    (kom-change-language      . "Change language")
    (kom-calculate            . "Calculate")
    (kom-list-marks           . "List marked texts")
    (kom-where-is             . "Where (is the) command")
    (kom-fast-reply           . "Remark (to text)")
    (kom-agree                . "Agree")
    (kom-add-faq              . "Add FAQ")
    (kom-del-faq              . "Remove FAQ")
    (kom-review-faq           . "View FAQ")

    (kom-sub-footnote         . "Remove footnote")
    (kom-add-footnote         . "Add footnote")

    (kom-add-no-comments      . "Prevent comments")
    (kom-add-private-answer   . "Request private reply")
    (kom-add-request-confirm  . "Request confirmation of reading")

    (kom-review-mail-headers  . "Review mail headers")

    (kom-compare-texts        . "Compare two texts")
    (kom-diff-texts           . "View diff")

    (kom-become-anonymous     . "Become anonymous")
    (kom-become-nonanonymous  . "Become non-anonymous (come forth into the light)")

    (kom-keep-alive           . "Keep connection alive")
    (kom-stop-keep-alive      . "Stop keeping connection alive")

    (kom-is-person-member-of-conference . "Check (if person is a) member (of conference)")
    (kom-change-conf-faq      . "Change FAQ")

    (kom-make-review-mark-as-read . "Review marks as read")
    (kom-make-review-not-mark-as-read . "Review does not mark as read")

    (kom-set-presentation     . "Add presentation")
    (kom-remove-presentation  . "Remove presentation")
    (kom-set-motd-text        . "Add notice")
    (kom-create-aux-item      . "Create auxiliary information")
    (kom-status-server        . "Status (of) server")
    (kom-add-server-faq       . "Add server FAQ")
    (kom-del-server-faq       . "Remove server FAQ")
    (kom-review-server-faq    . "Review server FAQ")
    (kom-change-server-faq    . "Change server FAQ")
    (kom-recommend-conference . "Recommend cnoference")
    (kom-redirect-comments    . "Redirect comments")
    ))

(lyskom-language-var global lyskom-language-codes en
  '((aa . "Afar")
    (ab . "Abkhazian")
    (af . "Afrikaans")
    (am . "Amharic")
    (ar . "Arabic")
    (as . "Assamese")
    (ay . "Aymara")
    (az . "Azerbaijani")
    (ba . "Bashkir")
    (be . "Byelorussian")
    (bg . "Bulgarian")
    (bh . "Bihari")
    (bi . "Bislama")
    (bn . "Bengali")
    (bo . "Tibetan")
    (br . "Breton")
    (ca . "Catalan")
    (co . "Corsican")
    (cs . "Czech")
    (cy . "Welsh")
    (da . "Danish")
    (de . "German")
    (dz . "Bhutani")
    (el . "Greek")
    (en . "English")
    (eo . "Esperanto")
    (es . "Spanish")
    (et . "Estonian")
    (eu . "Basque")
    (fa . "Persian")
    (fi . "Finnish")
    (fj . "Fiji")
    (fo . "Faroese")
    (fr . "French")
    (fy . "Frisian")
    (ga . "Irish")
    (gd . "Scots Gaelic")
    (gl . "Galician")
    (gn . "Guarani")
    (gu . "Gujarati")
    (ha . "Hausa")
    (he . "Hebrew")
    (hi . "Hindi")
    (hr . "Croatian")
    (hu . "Hungarian")
    (hy . "Armenian")
    (ia . "Interlingua")
    (id . "Indonesian")
    (ie . "Interlingue")
    (ik . "Inupiak")
    (is . "Icelandic")
    (it . "Italian")
    (iu . "Inuktitut")
    (ja . "Japanese")
    (jw . "Javanese")
    (ka . "Georgian")
    (kk . "Kazakh")
    (kl . "Greenlandic")
    (km . "Cambodian")
    (kn . "Kannada")
    (ko . "Korean")
    (ks . "Kashmiri")
    (ku . "Kurdish")
    (ky . "Kirghiz")
    (la . "Latin")
    (ln . "Lingala")
    (lo . "Laotian")
    (lt . "Lithuanian")
    (lv . "Latvian Lettish")
    (mg . "Malagasy")
    (mi . "Maori")
    (mk . "Macedonian")
    (ml . "Malayalam")
    (mn . "Mongolian")
    (mo . "Moldavian")
    (mr . "Marathi")
    (ms . "Malay")
    (mt . "Maltese")
    (my . "Burmese")
    (na . "Nauru")
    (ne . "Nepali")
    (nl . "Dutch")
    (no . "Norwegian")
    (oc . "Occitan")
    (om . "Oromo")
    (or . "Oriya")
    (pa . "Pundjabi")
    (pl . "Polish")
    (ps . "Pashto")
    (pt . "Portuguese")
    (qu . "Quechua")
    (rm . "Rhaeto-Romance")
    (rn . "Kirundi")
    (ro . "Romanian")
    (ru . "Russian")
    (rw . "Kiyarwanda")
    (sa . "Sanskrit")
    (sd . "Sindhi")
    (sg . "Sangho")
    (sh . "Serbo-Croatian")
    (si . "Singhalese")
    (sk . "Slovak")
    (sl . "Slovenian")
    (sm . "Samoan")
    (sn . "Shona")
    (so . "Somali")
    (sq . "Albanian")
    (sr . "Serbian")
    (ss . "Siswati")
    (st . "Sesotho")
    (su . "Sudanese")
    (sv . "Swedish")
    (sw . "Swahili")
    (ta . "Tamil")
    (te . "Telugu")
    (tg . "Tajik")
    (th . "Thai")
    (ti . "Tigrinya")
    (tk . "Turkmen")
    (tl . "Tagalog")
    (tn . "Setswana")
    (to . "Tonga")
    (tr . "Turkish")
    (ts . "Tsonga")
    (tt . "Tatar")
    (tw . "Twi")
    (ug . "Uigur")
    (uk . "Ukrainian")
    (ur . "Urdu")
    (uz . "Uzbek")
    (vi . "Vietnamese")
    (vo . "Volapk")
    (wo . "Wolof")
    (xh . "Xhosa")
    (yi . "Yiddish")
    (yo . "Yorouba")
    (za . "Zhuang")
    (zh . "Chinese")
    (zu . "Zulu")
    (-- . "Unknown language (%#1s)")))

(lyskom-language-strings global lyskom-menu en
  '((lyskom    . "LysKOM")
    (read      . "Read")
    (dont-read . "Jump")
    (write     . "Write")
    (conference . "Conference")
    (other     . "Other")
    (person    . "User")
    (marks     . "Marks")
    (move      . "Go")
    (info      . "About")
    (send      . "Send message")
    (receivers . "Receivers")
    (commented . "Commented")
    (kom-edit-send . "Send")
    (kom-edit-send-anonymous . "Send anonymously")
    (kom-edit-quit . "Throw away") 
    (kom-ispell-message . "Check spelling")
    (kom-edit-add-recipient . "Add recipient")
    (kom-edit-add-copy . "Add carbon copy")
    (kom-edit-show-commented . "Review commented")
    (kom-edit-insert-commented . "Cite commented")
    (kom-edit-insert-buglist . "Paste commented bug list")
    (kom-edit-add-bcc . "Add blind carbon copy")
    (kom-edit-add-cross-reference . "Add cross reference")
    (kom-edit-add-no-comments . "Request no comments")
    (kom-edit-add-personal-comments . "Request personal replies")
    (kom-edit-add-read-confirm-request . "Request read confirmation")
    (kom-edit-move-text . "Move to new recipient")
))

(lyskom-language-var local lyskom-move-tree-actions en
                     '(("Move text or subtract recipient" . move)
                       ("Leave text and continue with comments" . skip)
                       ("Abort this command" . quit)
                       ("Skip this command and its comment tree" . jump)))

(lyskom-language-var local lyskom-onoff-table en
  '(("on" . on) ("off" . off)))

(lyskom-language-var local lyskom-filter-predicate-list en
      '(("=" . nil) ("!=" . t)))

(lyskom-language-var local lyskom-filter-what en
      '((author . "Author")
        (author-no . "Author (number)")
        (author-re . "Author (regexp)")
        (subject . "Subject")
        (subject-re . "Subject (regexp)")
        (recipient . "Recipient")
        (recipient-no . "Recipient (number)")
        (recipient-re . "Recipient (regexp)")
        (text . "Contents")
        (text . "Contents (regexp)")))

(lyskom-language-var local lyskom-filter-actions en
      '((skip-text . "Skip")
        (dontshow . "Don't show")
        (read . "Exclude from filter")
        (skip-tree . "Skip comments")))
                               
(defconst lyskom-keybindings-missing nil)

(defvar lyskom-en-mode-map nil)
(lyskom-language-keymap lyskom-mode-map en lyskom-en-mode-map)

(if lyskom-en-mode-map
    nil
  (setq lyskom-en-mode-map (make-keymap))
  (suppress-keymap lyskom-en-mode-map)
  (define-prefix-command 'lyskom-en-review-prefix)
  (define-prefix-command 'lyskom-en-change-prefix)
  (define-prefix-command 'lyskom-en-next-prefix)
  (define-prefix-command 'lyskom-en-list-prefix)
  (define-prefix-command 'lyskom-en-filter-get-prefix)
  (define-prefix-command 'lyskom-en-S-prefix)
  (define-prefix-command 'lyskom-en-previous-prefix)
  (define-prefix-command 'lyskom-en-who-prefix)
  (define-key lyskom-en-mode-map (kbd "A") 'lyskom-en-change-prefix)
  (define-key lyskom-en-mode-map (kbd "r") 'lyskom-en-review-prefix)
  (define-key lyskom-en-mode-map (kbd "f") 'lyskom-en-filter-get-prefix)
  (define-key lyskom-en-mode-map (kbd "n") 'lyskom-en-next-prefix)
  (define-key lyskom-en-mode-map (kbd "l") 'lyskom-en-list-prefix)
  (define-key lyskom-en-mode-map (kbd "s") 'lyskom-en-S-prefix)
  (define-key lyskom-en-mode-map (kbd "b") 'lyskom-en-previous-prefix)
  (define-key lyskom-en-mode-map (kbd "w") 'lyskom-en-who-prefix)

  (define-key lyskom-en-mode-map (kbd "M-m") 'kom-toggle-mark-as-read-prefix)

  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button2)) 'kom-button-click)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-mode-map (kbd "*") 'kom-button-press)
  (define-key lyskom-en-mode-map (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-en-mode-map (kbd "TAB") 'kom-next-link)
  (define-key lyskom-en-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-en-mode-map (kbd "<S-tab>") 'kom-previous-link)

  ;; These should be first in order to be last in the menu of alternatives.
  (define-key lyskom-en-mode-map (kbd "A ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "r ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "f ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "n ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "l ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "s ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "b ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "w ?") 'lyskom-help)
  

  (define-key lyskom-en-mode-map (kbd "o")     'kom-set-unread)
  (define-key lyskom-en-mode-map (kbd "x")     'kom-extended-command)
  (define-key lyskom-en-mode-map (kbd "<SPC>") 'kom-next-command)
  (define-key lyskom-en-mode-map (kbd "<LFD>")  'kom-page-next-command)
  (define-key lyskom-en-mode-map (kbd "<RET>")  'kom-line-next-command)

  (define-key lyskom-en-mode-map (kbd "?")  'kom-help)
  (define-key lyskom-en-mode-map (kbd "m")  'kom-send-letter)
  (define-key lyskom-en-mode-map (kbd "g")  'kom-go-to-conf)
  (define-key lyskom-en-mode-map (kbd "a")  'kom-write-text)
  (define-key lyskom-en-mode-map (kbd "c")  'kom-write-comment)
  (define-key lyskom-en-mode-map (kbd "C")  'kom-comment-previous)
  (define-key lyskom-en-mode-map (kbd "F")  'kom-write-footnote)
  (define-key lyskom-en-mode-map (kbd "p")  'kom-private-answer)
  (define-key lyskom-en-mode-map (kbd "P")  'kom-private-answer-previous)
  (define-key lyskom-en-mode-map (kbd "j")  'kom-jump)
  (define-key lyskom-en-mode-map (kbd "J")  'kom-super-jump)
  (define-key lyskom-en-mode-map (kbd "l M") 'kom-list-marks)
  (define-key lyskom-en-mode-map (kbd "l c") 'kom-list-conferences)
  (define-key lyskom-en-mode-map (kbd "l n") 'kom-list-news)
  (define-key lyskom-en-mode-map (kbd "l u") 'kom-list-persons)
  (define-key lyskom-en-mode-map (kbd "l r") 'kom-list-re)
  (define-key lyskom-en-mode-map (kbd "l s") 'kom-membership)
  (define-key lyskom-en-mode-map (kbd "l a") 'kom-list-summary)
  (define-key lyskom-en-mode-map (kbd "l f") 'kom-list-filters)
  (define-key lyskom-en-mode-map (kbd "S")  'kom-add-self)
  (define-key lyskom-en-mode-map (kbd "M")  'kom-mark-text)
  (define-key lyskom-en-mode-map (kbd "U")  'kom-unmark-text)
  (define-key lyskom-en-mode-map (kbd "n a") 'kom-view-next-new-text)
  (define-key lyskom-en-mode-map (kbd "n c") 'kom-go-to-next-conf)
  (define-key lyskom-en-mode-map (kbd "n l") 'kom-next-kom)
  (define-key lyskom-en-mode-map (kbd "n u") 'kom-next-unread-kom)
  (define-key lyskom-en-mode-map (kbd "b l") 'kom-previous-kom)
  (define-key lyskom-en-mode-map (kbd "q")  'kom-quit)
  (define-key lyskom-en-mode-map (kbd "z")  'kom-bury)
  (define-key lyskom-en-mode-map (kbd "R")  'kom-recover)
  (define-key lyskom-en-mode-map (kbd "t")  'kom-display-time)
  (define-key lyskom-en-mode-map (kbd "f p") 'kom-get-appreciation)
  (define-key lyskom-en-mode-map (kbd "f k") 'kom-get-abuse)
  (define-key lyskom-en-mode-map (kbd "f s") 'kom-filter-subject)
  (define-key lyskom-en-mode-map (kbd "f a") 'kom-filter-author)
  (define-key lyskom-en-mode-map (kbd "f c") 'kom-filter-text)
  (define-key lyskom-en-mode-map (kbd "f r") 'kom-filter-recipient)
  (define-key lyskom-en-mode-map (kbd "w w") 'kom-who-is-on)
  (define-key lyskom-en-mode-map (kbd "w c") 'kom-who-is-on-in-conference)
  (define-key lyskom-en-mode-map (kbd "w p") 'kom-who-is-present-in-conference)
  (define-key lyskom-en-mode-map (kbd "w f") 'kom-who-is-on-and-friend)
  (define-key lyskom-en-mode-map (kbd "I")  'kom-who-am-i)
  (define-key lyskom-en-mode-map (kbd "W")  'kom-busy-wait)
  (define-key lyskom-en-mode-map (kbd "A p") 'kom-change-presentation)
  (define-key lyskom-en-mode-map (kbd "A q") 'kom-change-conf-faq)
  (define-key lyskom-en-mode-map (kbd "A f") 'kom-filter-edit)
  (define-key lyskom-en-mode-map (kbd "A m") 'kom-change-auto-reply)
  (define-key lyskom-en-mode-map (kbd "A t") 'kom-move-text)
  (define-key lyskom-en-mode-map (kbd "A T") 'kom-move-text-tree)
  (define-key lyskom-en-mode-map (kbd "r SPC") 'kom-view)
  (define-key lyskom-en-mode-map (kbd "r 0") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 1") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 2") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 3") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 4") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 5") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 6") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 7") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 8") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 9") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r c") 'kom-view-commented-text)
  (define-key lyskom-en-mode-map (kbd "r C") 'kom-view-previous-commented-text)
  (define-key lyskom-en-mode-map (kbd "r a ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "r a c") 'kom-review-comments)
  (define-key lyskom-en-mode-map (kbd "r a r") 'kom-review-tree)
  (define-key lyskom-en-mode-map (kbd "r j") 'kom-review-clear)
  (define-key lyskom-en-mode-map (kbd "r n") 'kom-review-next)
  (define-key lyskom-en-mode-map (kbd "r u") 'kom-review-noconversion)
  (define-key lyskom-en-mode-map (kbd "r o") 'kom-find-root)
  (define-key lyskom-en-mode-map (kbd "r l") 'kom-review-by-to)
  (define-key lyskom-en-mode-map (kbd "r f") 'kom-review-first)
  (define-key lyskom-en-mode-map (kbd "r A") 'kom-review-all)
  (define-key lyskom-en-mode-map (kbd "r M") 'kom-review-more)
  (define-key lyskom-en-mode-map (kbd "r g") 'kom-review-last-normally-read)
  (define-key lyskom-en-mode-map (kbd "r q") 'kom-review-faq)
  (define-key lyskom-en-mode-map (kbd "r Q") 'kom-review-server-faq)
  (define-key lyskom-en-mode-map (kbd "B")  'kom-review-backward)
  (define-key lyskom-en-mode-map (kbd "r s") 'kom-review-stack)
  (define-key lyskom-en-mode-map (kbd "r p") 'kom-review-presentation)
  (define-key lyskom-en-mode-map (kbd "r r") 'kom-find-root-review)
  (define-key lyskom-en-mode-map (kbd "r m") 'kom-review-marked-texts)
  (define-key lyskom-en-mode-map (kbd "r a m") 'kom-review-all-marked-texts)
  (define-key lyskom-en-mode-map (kbd "r a SPC") 'kom-review-all)
  (define-key lyskom-en-mode-map (kbd "r x a") 'kom-agree)
  (define-key lyskom-en-mode-map (kbd "r x q") 'kom-fast-reply)
  (define-key lyskom-en-mode-map (kbd "r h") 'kom-review-mail-headers)
  (define-key lyskom-en-mode-map (kbd "s c") 'kom-status-conf)
  (define-key lyskom-en-mode-map (kbd "s u") 'kom-status-person)
  (define-key lyskom-en-mode-map (kbd "s s") 'kom-status-session)
  (define-key lyskom-en-mode-map (kbd "s k") 'kom-status-server)
  (define-key lyskom-en-mode-map (kbd "s m") 'kom-send-message)

  ;; Running in) buffer

  (define-key lyskom-en-mode-map (kbd "M-p") 'backward-text)
  (define-key lyskom-en-mode-map (kbd "M-n") 'forward-text)
  (define-key lyskom-en-mode-map (kbd "C-M-p") 'kom-prev-prompt)
  (define-key lyskom-en-mode-map (kbd "C-M-n") 'kom-next-prompt)
  (define-key lyskom-en-mode-map (kbd "s a") 'kom-save-text)

  (define-key lyskom-en-mode-map (kbd "C-?") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<DEL>") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<delete>") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<BS>") 'scroll-down)
  )


;;;==============================================================
;;; Keymap for filter editing
;;;

(defvar lyskom-en-filter-edit-map nil)
(lyskom-language-keymap lyskom-filter-edit-map en lyskom-en-filter-edit-map)

(if lyskom-en-filter-edit-map ()
  (setq lyskom-en-filter-edit-map (make-keymap))
  (suppress-keymap lyskom-en-filter-edit-map)
  (define-prefix-command 'lyskom-en-filter-edit-prefix)
  (define-key lyskom-en-filter-edit-map (kbd "C-c")  'lyskom-en-filter-edit-prefix)
  (define-key lyskom-en-filter-edit-map (kbd "p") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "P") 'lyskom-filter-edit-prev-entry)
  (define-key lyskom-en-filter-edit-map (kbd "n") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "N") 'lyskom-filter-edit-next-entry)
  (define-key lyskom-en-filter-edit-map (kbd "C-p") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-n") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-b") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-f") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-p") 'lyskom-filter-edit-prev-entry)
  (define-key lyskom-en-filter-edit-map (kbd "M-n") 'lyskom-filter-edit-next-entry)
  (define-key lyskom-en-filter-edit-map (kbd "d") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-d") 'lyskom-filter-edit-delete-entry)
  (define-key lyskom-en-filter-edit-map (kbd "D") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-d") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "i") 'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "I") 'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-i") 'lyskom-filter-edit-insert-entry)
  (define-key lyskom-en-filter-edit-map (kbd "<") 'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-en-filter-edit-map (kbd ">") 'lyskom-filter-edit-end-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "M-<") 'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "M->") 'lyskom-filter-edit-end-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "q") 'lyskom-filter-edit-quit)
  (define-key lyskom-en-filter-edit-map (kbd "C-c C-c")   'lyskom-filter-edit-quit)
  (define-key lyskom-en-filter-edit-map (kbd "x") 'lyskom-filter-edit-expunge)
  (define-key lyskom-en-filter-edit-map (kbd "s") 'lyskom-filter-edit-save)
  (define-key lyskom-en-filter-edit-map (kbd "g") 'lyskom-filter-edit-revert)
  (define-key lyskom-en-filter-edit-map (kbd "t") 'lyskom-filter-edit-toggle-permanent)
  (define-key lyskom-en-filter-edit-map (kbd "a") 'lyskom-filter-edit-toggle-action)
  (define-key lyskom-en-filter-edit-map (kbd "?") 'lyskom-filter-edit-brief-help)
  (define-key lyskom-en-filter-edit-map (kbd "h") 'lyskom-filter-edit-brief-help)
  )


;;;(if lyskom-prioritize-mode-map
;;;    nil
;;;  (setq lyskom-prioritize-mode-map (make-keymap))
;;;  (suppress-keymap lyskom-prioritize-mode-map)
;;;  (define-key lyskom-prioritize-mode-map "\C-?" 'previous-line)
;;;  (define-key lyskom-prioritize-mode-map " "    'next-line)
;;;  (define-key lyskom-prioritize-mode-map "\C-k" 'kom-prioritize-kill)
;;;  (define-key lyskom-prioritize-mode-map "\C-y" 'kom-prioritize-yank)
;;;  (define-key lyskom-prioritize-mode-map "p"     'kom-prioritize-set-priority)
;;;  (define-key lyskom-prioritize-mode-map "\C-c\C-c" 'kom-prioritize-quit)
;;;  (define-key lyskom-prioritize-mode-map "q"     'kom-prioritize-quit)
;;;  (define-key lyskom-prioritize-mode-map "Q"     'kom-prioritize-quit)
;;;  (define-key lyskom-prioritize-mode-map "u"     'kom-prioritize-move-up)
;;;  (define-key lyskom-prioritize-mode-map "d"     'kom-prioritize-move-down)
;;;)

(defvar lyskom-en-prioritize-mode-map nil)
(lyskom-language-keymap lyskom-prioritize-mode-map en lyskom-en-prioritize-mode-map)

(if lyskom-en-prioritize-mode-map 
    nil
  (setq lyskom-en-prioritize-mode-map (make-keymap))
  (suppress-keymap lyskom-en-prioritize-mode-map)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button2)) 'kom-button-click)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-prioritize-mode-map (kbd "*") 'kom-button-press)
  (define-key lyskom-en-prioritize-mode-map (kbd "+") 'kom-menu-button-press)
  (define-key lyskom-en-prioritize-mode-map (kbd "?") 'kom-prioritize-help)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-k") 'kom-prioritize-select)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-y") 'kom-prioritize-yank)
  (define-key lyskom-en-prioritize-mode-map (kbd "SPC") 'kom-prioritize-select)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-m") 'kom-prioritize-next-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-j") 'kom-prioritize-next-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "DEL") 'kom-prioritize-previous-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-DEL") 'kom-prioritize-deselect-all)
  (define-key lyskom-en-prioritize-mode-map (kbd "<down>") 'kom-prioritize-next-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-n") 'kom-prioritize-next-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "<up>") 'kom-prioritize-previous-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-p") 'kom-prioritize-previous-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "p") 'kom-prioritize-previous-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<up>") 'kom-prioritize-move-up)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-p") 'kom-prioritize-move-up)
  (define-key lyskom-en-prioritize-mode-map (kbd "u") 'kom-prioritize-move-up)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<down>") 'kom-prioritize-move-down)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-n") 'kom-prioritize-move-down)
  (define-key lyskom-en-prioritize-mode-map (kbd "d") 'kom-prioritize-move-down)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<") 'kom-prioritize-beginning)
  (define-key lyskom-en-prioritize-mode-map (kbd "M->") 'kom-prioritize-end)
  (define-key lyskom-en-prioritize-mode-map (kbd "r") 'kom-prioritize-reprioritize)
  (define-key lyskom-en-prioritize-mode-map (kbd "g") 'kom-prioritize-goto-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "p") 'kom-prioritize-set-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "s") 'kom-prioritize-save)
  (define-key lyskom-en-prioritize-mode-map (kbd "q") 'kom-prioritize-quit)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-c C-c") 'kom-prioritize-quit)
  (define-key lyskom-en-prioritize-mode-map (kbd "TAB") 'kom-next-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-C-i") 'kom-previous-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "<S-tab>") 'kom-previous-link)
)

(lyskom-language-var local lyskom-prioritize-header-lines en 2)

(lyskom-language-var local lyskom-prioritize-header en 
" Prio   Conference
-----------------------------------------------------------------------------
")



;;;; ============================================================
;;;; Strings and things for the customize mode
;;;;

(defvar lyskom-en-customize-map nil)
(lyskom-language-keymap lyskom-customize-map en lyskom-en-customize-map)


(if lyskom-en-customize-map
    nil
  (setq lyskom-en-customize-map (make-sparse-keymap))
  (define-key lyskom-en-customize-map (kbd "TAB") 'widget-forward)
  (define-key lyskom-en-customize-map (kbd "M-TAB") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "<S-tab>") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "C-i") 'widget-forward)
  (define-key lyskom-en-customize-map (kbd "M-C-i") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "C-m") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "C-j") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "<RET>") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "<LFD>") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button2)) 'widget-button-click)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button3)) 'lyskom-widget-click)
  (define-key lyskom-en-customize-map (kbd "C-c C-c") 'lyskom-customize-save-and-quit)
  (define-key lyskom-en-customize-map (kbd "C-c C-k") 'lyskom-customize-quit)
  (define-key lyskom-en-customize-map (kbd "C-c C-s") 'lyskom-customize-save)
  (define-key lyskom-en-customize-map (kbd "C-c C-a") 'lyskom-customize-apply)
  (define-key lyskom-en-customize-map (kbd "?") 'lyskom-customize-help)
)

(lyskom-language-strings local lyskom-custom-strings en
  '(
    ;;
    ;; Widget strings
    ;;

    (which-person . "Specify person: ")
    (which-conf . "Specify a conference: ")
    (which-conf-or-person . "Specify a person or conference: ")
    (which-name . "Specify a name: ")
    (some-person . "Person %#1d")
    (invalid-value . "Invalid value (%#1S)")
    (unknown-command . "Unknown command (%#1s)")
    (ding . "Audio cue")

    ;;
    ;; Help messages
    ;;

    (variable-type-help . "Select to save the setting in the server.")
    (default-help-echo . "Change the value of  %#1s.")
    (change-this-name . "Change the name in this entry.")
    (show-doc . "Show documentation.")
    (hide-doc . "Hide documentation.")
    (select-command . "Select a command.")
    (select-what-to-execute . "\
Select whether to execute command or keyboard macro.")
    (select-url-viewer . "Select a web browser.")
    (select-number . "Select number of times.")
    (select-audio-file . "Select an audio file.")
    (select-priority . "Select a priority.")
    (select-buffer . "Select a buffer name.")
    (select-buffer-size . "Select maximum buffer size.")

    ;;
    ;; Strings that are used in types and so forth
    ;;

    (buffer-name . "%#1s-configure")

    (other-window .     "Some other window             ")
    (other-frame .      "Some other frame              ")
    (new-frame .        "In a new frame                ")
    (lyskom-window .    "The LysKOM buffer's window    ")
    (window-on-buffer . "A window displaying the buffer")

    (on . "On ")
    (off . "Off")
    (yes . "Yes")
    (no . "No ")
    (to-file . "To file:")
    (max-text-length . "For texts shorter than: ")

    (friends . "Friends and other special people")

    (turned-off .      "Turned off           ")
    (number-of-times . "A few times")
    (specific-spec . "Per recipient/sender")
    (sound-file . "Audio file")
    (other-persons . "All others")

    (selected-mark . "Mark          ")
    (conf-or-person . "Person or conference")
    (ask .           "Ask every time         ")
    (limited-number . "A limited number")
    (unlimited-number . "Unlimited")

    (before . "Before the text")
    (after . "After the text")
    (depth-first . "In comment order")
    (time-order . "In time order")

    (ar-message-type . "Message type")
    (ar-personal     . "Personal")
    (ar-group        . "Group")
    (ar-alarm        . "Alarm")
    (ar-any-type     . "Any message type")
    (ar-sender       . "Sender")
    (ar-any-sender   . "Any sender")
    (ar-specified-sender . "Specified senders")
    (ar-pers-or-conf . "Person or conference")
    (ar-recipient    . "Recipient")
    (ar-any-recipient . "Any recipient")
    (ar-specified-recipient . "Specified recipients")
    (ar-person       . "Person")
    (ar-message-text . "Message text")
    (ar-any-message  . "Any message")
    (ar-matching-regexp . "Matching regexp")
    (ar-reply        . "Reply")
    (ar-no-reply     . "No reply")
    (ar-reply-text   . "Reply text")

    (express-break . "Immediately upon creation  ")
    (break .         "After current comment chain")
    (no-break .      "After current conference   ")

    (express-server-break . "Immediately")
    (express-server-letters-break . "Immediately if letters arrive")
    (server-break . "After current comment chain")
    (letters-server-break . "After current comment chain if letters arrive")
    (after-conf-server-break . "After current conference")
    (after-conf-letters-server-break . "After current conference if letters arrive")
    (when-done-server-break . "After everything has been read")
    (no-server-break . "Never")

    (command . "Command")
    (command-list . "Command list")
    (some-persons . "For some persons")
    (name . "Name")

    (page-none . "Never                        ")
    (page-all .  "Before every command         ")
    (page-some . "Before the following commands")

    (ask-every-time . "Ask every time         ")
    (fixed-priority . "Fixed priority")

    (messages-in-lyskom-buffer . "In the LysKOM buffer")
    (discard-messages .          "Nowhere - discard them")
    (in-named-buffer .           "In a named buffer:")

    (everybody-rcpt . "Everybody                                ")
    (group-rcpt .     "The recipient of the last group message  ")
    (sender-rcpt .    "The sender of the most recent message    ")
    (last-recipient-recpt . "The last person I sent a message to")

    (viewer-program . "Web browser")
    (no-viewer            . "(ingenting valt)")
    (default-viewer       . "Browse-URL (all)")
    (netscape-viewer . "Netscape/Mozilla (all)")
    (windows-viewer       . "Windows default or Netscape/Mozilla (all)")
    (emacs-w3-viewer . "Emacs W3 mode (HTTP, Goper, FTP)")
    (emacs-general-viewer . "Emacs (FTP, Telnet, Mail)")
    (emacs-dired-viewer . "Emacs Dired (FTP)")
    (emacs-mail-viewer . "Emacs Mail mode (Mail)")
    (emacs-telnet-viewer . "Emacs Telnet mode (telnet)")
    (mosaic-viewer . "NCSA Mosaic (all)")
    (lynx-viewer          . "Lynx (all)")
    (galeon-viewer        . "Galeon (all)")

    (dont-check . "Don't ask for confirmation")
    (check-before-open . "Confirm before writing the text")
    (check-before-send . "Confirm before sending the text")
    (no-size-limit . "No limit")
    (max-size-in-bytes . "Fixed limit (in bytes)")
    (execute . "Execute")
    (kbd-macro . "Keyboard macro")
    (command . "Command")
    (enter-kbd-macro . "Enter a keybard macro. Finish with %#1s")
    (long-format .  "Show help texts")
    (short-format . "Hide help texts")

    (truncate-threshold-lines . "Max lines")

    (first . "First")
    (last . "Last")
    (specific-placement . "Specific location")
    (priority . "Priority")
    (same-as-conf . "Same as current conference")
    (custom-format . "Custom format:")
    (default-format . "Standard format")
    (a-string . "A string:")
    (some-string . "A random string")
    (unspecified . "Unspecified")

    (symbolic-mark-association . "Association")
    (symbolic-mark-name . "Symbolic name: ")
    (mark-type-to-assoc . "Mark type to associate with: ")

    (prompt-for-text-no . "Prompt for text number")

    (all-others . "All others")
    (some-person . "Person")
    (format-html . "Format HTML:")

    ;;
    ;; Misc doc strings
    ;;

    (lyskom . "Configuration of LysKOM")
    (lyskom-doc . "\\[lyskom-customize-save-and-quit] to save and quit,
\\[lyskom-customize-save-and-quit] to save and quit,
\\[lyskom-customize-save] to save without quitting,
\\[lyskom-customize-quit] to quit without saving.
\\[widget-forward] moves to the next setting
\\[widget-button-press] changes the value

Documentation:  [?] Show documentation    [!] Hide documentation
Lists etc.   :  [INS] Add a line   [DEL] Remove a line   [*] Modify

If the box before the name of the setting is selected, the setting will
be saved in the server. Otherwise it will be saved in your .emacs.")




    (section . "------------------------------------------------------------------------------\n")
    (look-and-feel-misc . "Look and feel\n")
    (window-locations   . "Windows\n")
    (windows-where      . "How are windows created:\n")
    (reading .            "Reading\n")
    (writing .            "Writing\n")
    (urls .               "URL management\n")
    (personal-messages .  "Personal messages\n")
    (remote-control .     "Remote control of LysKOM\n")
    (hooks .              "Hook functions\n")

    (audio-cues .         "Audio cues\n")
    (audio-cues-when    . "Issue audio cues when:\n")
    (automatic-replies .  "Automatic replies\n")


    (audio-cues-doc . "\
  The following group of settings controls how LysKOM issues audio cues in
  various situations. The following options are available for each setting:

    Off
        No audio cue is issued

    A Few Times
        Emacs will beep one or more times. You have to specify how many
        times Emacs is to beep.

    Audio File
        Emacs will attempt to play the specified audio file. The program
        used to play the file is specified by another setting.")
    

    (sending-doc . "\
  The following settings turn on or off certain checks that can be performed
  before sending a text to the server. The checks are designed to keep
  you from doing something stupid.

    Confirm multiple recipients
        If a text or comment has more than one recipient, LysKOM 
        can ask which of the recipients are relevant. This can either
        be done before you start writing the text, in which case 
        LysKOM will post a question for each recipient, or before sending
        the text to the server, in which case you may confirm all the
        recipients at once. It is also possible to turn this check off
        entirely.

    Check membership of commented author
        When on, LysKOM will check that the author of the comment you are
        writing is a member of at least one of the recipients of your comment.
        If not, LysKOM will offer to add the commented author as a recipient
        to the comment you are writing.

    Authors not to check
        A list of authors not to check even if check membership of
        commented author is on.

    Check for unread comments
        When this is on, LysKOM will check that you have read all the other
        comments to the text you are commenting before sending your
        comment to the server. This is supposed to help you avoid duplicating
        someone else's comment.")

    (windows-doc . "\
  The following settings control how windows are created in LysKOM. The
  available options are:


    Some other window
        In another window, but in the same frame as LysKOM. If there only
        is one window in the frame, a new window will be created (and will
        be removed when you are finished).

    Some other frame
        In a different frame than the one LysKOM is in. If there only is one
        frame, a new one will be created (and will be removed when you are
        finished).

    In a new frame
        A new frame is created (and will be removed when you are finished).

    The LysKOM buffer's window
        The LysKOM buffer's window will be used. LysKOM will be restored to
        the window when you're finished.

    A window displaying the buffer
        If there is a window anywhere displaying the named buffer, that 
        window will be used. This might be useful if you always have a
        particular buffer showing, but don't need it when executing some
        command.")


    ;;
    ;; Doc strings for variables
    ;;

    (kom-ansaphone-replies-doc . "\
  This setting controls automatic replies in detail. You can set replies
  for specific senders, recipients and even message contents. If the message
  being replied to does not match any element in this list, the default
  auto reply message above is sent instead.

  For each pattern in the list you can set the required message type, 
  sender the message must have, recipient the message must have, a regular
  expression the message must match and the reply to send.

  It is advisable to configure the client not to send a message to any
  group or alarm message.")

    (kom-bury-buffers-doc . "\
  Controls how the LysKOM buffer is handled when moving to another KOM buffer
  with the Next and Previous LysKOM commands. When turned on the current
  buffer is buried.")

    (kom-personal-messages-in-window-doc . "\
  Controls which window is used to display the buffer with personal messages.
  For this setting to have any effect, personal messages must be displayed
  in a separate buffer, and that buffer must be displayed automatically
  every time a message is received.")

    (kom-write-texts-in-window-doc . "\
  Controls which window is used to write new texts.")

    (kom-prioritize-in-window-doc . "\
  Controls which window is used to prioritize conferences.")

    (kom-edit-filters-in-window-doc . "\
  Controls which window is used for editing filters.")

    (kom-customize-in-window-doc . "\
  Controls which window is used to configure LysKOM.")

    (kom-view-commented-in-window-doc . "\
  Controls which window is used to show the commented text when commenting.")

    (kom-list-membership-in-window-doc . "\
  Controls in which window your membership list is shown.")


    (kom-user-prompt-format-doc . "\
  The format of the LysKOM prompt. Certain control sequences cause special
  text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-user-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing.
  Certain control sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-anonymous-prompt-format-doc . "\
  The format of the LysKOM prompt used when anonymous. Certain control
  sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-anonymous-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing
  and the session is anonymous. Certain control sequences cause special 
  text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-enabled-prompt-format-doc . "\
  The format of the LysKOM prompt when in administrator mode. Certain
  control sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-enabled-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing
  and the session is in administrator mode. Certain control sequences 
  cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")
    
    (kom-cite-string-doc . "\
  A string that is inserted before each line in a cited text. Normally this
  is set to something like \"> \". Note that it is not customary to cite
  commented texts the way it is done in e-mail or Usenet News since the
  commented text is always available in LysKOM.")


    (kom-created-texts-are-read-doc . "\
  When this is on, self-created texts are automatically marked as read. Turned
  off, those texts are presented as any other texts.")

    (kom-default-mark-doc . "\
  The default mark type used for marking texts. A mark type is an integer
  between 0 and 255 (inclusive). If no default mark type is selected, LysKOM
  asks for a mark type every time a text is to be marked. This can be used
  to separate different types of marks. You can, for example, mark texts
  which contain valuable information with a certain integer and texts which
  you should remember to comment some time with another integer.")

    (kom-symbolic-marks-alist-doc . "\
  To avoid having to memorize what the integer mark types are supposed to
  mean, you can define a list of symbolic mark types. A symbolic mark type
  is a descriptive string that is associated with an integer mark type.")

    (kom-reading-puts-comments-in-pointers-last-doc . "\
  Controls if comment links are listed before or after the body of a text.
  Normally comment links are listed after the text.

  Before:

    398331 1996-09-24  13:22  /2 lines/ George Berkeley
    Recipient: Philosophy <1226>
    Comment in text 398374 by John Locke
    Subject: 
    ------------------------------------------------------------
    An abstract idea is a contradiction in terms.
    (398331) -----------------------------------

  After:

    398331 1996-09-24  13:22  /2 lines/ George Berkeley
    Recipient: Philosophy <1226>
    Subject: 
    ------------------------------------------------------------
    An abstract idea is a contradiction in terms.
    (398331) -----------------------------------
    Comment in text 398374 by John Locke
")

    (kom-dashed-lines-doc . "\
  When this setting is turned on, dashed lines are displayed before and after
  the text body. When turned off, blank lines are used instead.

  On:

    892343 1996-09-24  19:21  /2 lines/ Tycho Brahe
    Recipien: Presentation (of new) Members
    Subject: Tycho Brahe
    ------------------------------------------------------------
    Astronomer and discoverer of stars resident on the island of Ven.
    (892343) -----------------------------------

  Off:

    892343 1996-09-24  19:21  /2 lines/ Tycho Brahe
    Recipien: Presentation (of new) Members
    Subject: Tycho Brahe

    Astronomer and discoverer of stars resident on the island of Ven.
    (892343)

  Most people have this turned on.")

    (kom-autowrap-doc . "\
  With this setting turned on, LysKOM will attempt to fill any paragraphs
  containing lines that are wider than the screen. Paragraphs that appear
  to have been preformatted by the author are exempted from this treatment.")

    (kom-show-author-at-end-doc . "\
  When this is turned on, the name of the author will be shown at the end
  of the text. The name is also shown before the text as usual.

  On (with dashed lines on):

    892342 1996-09-24  19:21  /2 lines/ Claude Shannon
    Mottagare: Presentation (of new) Members
    rende: Claude Shannon
    ------------------------------------------------------------
    Information theoretician
    (892342) /Claude Shannon/------------------------------

  Off:

    892342 1996-09-24  19:21  /2 lines/ Claude Shannon
    Recipient: Presentation (of new) Members
    Subject: Claude Shannon
    ------------------------------------------------------------
    Information theoretician
    (892342) -----------------------------------

  If dashed lines are off, the author's name will be shown as in this
  example, but the dashed lines are naturally not displayed.")

    (kom-truncate-threshold-doc . "\
  If this is activated, texts longer than the maximum number of lines will
  be truncated when you review comments, review marked texts or review the
  first or last texts in a conference.  Texts will not be truncated when
  you review a text, review a tree or read the next text.")

    (kom-truncate-show-lines-doc . "\
  The number of lines to show of truncated texts.")

    (kom-print-number-of-unread-on-entrance-doc . "\
  Determines whether the number of unread texts is shown when entering
  a conference:

  On:

    Go to next conference...
    Presentation (of new) Members - 3 unread
    Read next text - 

  Off:

    Go to next conference...
    Presentation (of new) Members
    Read next text - ")



    (kom-presence-messages-in-echo-area-doc . "\
  If you want messages in the echo area when somebody logs in, logs out or
  changes name, turn this setting on. Messages are shown in the minibuffer.
  If you want messages about a limited number of users, specify which ones.
  To not get any messages at all, just specify an empty list.")

    (kom-presence-messages-in-buffer-doc . "\
  If you want messages in the LysKOM buffer when somebody logs in, logs out
  or changes name, turn this setting on. Messages are shown in the LysKOM
  buffer. If you want messages about a limited number of users, specify which 
  ones. To not get any messages at all, just specify an empty list.")

    (kom-show-where-and-what-doc . "\
  If this is on, the list of active users will include the machine and user
  they are logged in from (if known) and what they are currently doing.

  On:

        User                                   Is in conference             
        At                                     Activity                        
    --------------------------------------------------------------------------
     6810 George Berkeley                      Philosophy                     
          berkeley@emp1.tcd.ie                 (Writing a comment.)           
     7571 John Locke                           Philosophy                     
          eridy@cc.ox.ac.uk                    (Waiting.)                     

  Off:

        User                                   Is in conference             
    --------------------------------------------------------------------------
     6810 George Berkeley                      Philosophy                     
     7571 John Locke                           Philosophy")

    (kom-show-since-and-when-doc . "\
  If this is on, the list of active users will include the connection time
  and the inactivity period for each user.")

    (kom-idle-hide-doc . "\
  The listing of active users normally only shows those users who have been
  active recently. This setting determines how many minutes a user may be
  inactive without being excluded from the list of active users.")


    (kom-show-footnotes-immediately-doc . "\
  Footnotes can be shown either as comments or immediately when the text
  they are footnotes to is displayed. This setting controls which behavior
  is used.")


    (kom-follow-comments-outside-membership-doc . "\
  LysKOM will normally not follow chains of comments into conferences you are
  not a member of. If you do want to follow comment chains into other
  conferences, turn this setting on.")


    (kom-read-depth-first-doc . "\
  LysKOM can display texts either in the order they were written or in
  the order defined by the comment tree. For example, if texts 1003 and
  1004 are comments to text 1002, text 1006 is a comment to 1003 and 
  texts 1005 and 1007 are comments to 1004, the comment tree looks 
  something like this:
        
  1002 +-- 1003 --- 1006
       |
       +-- 1004 +-- 1005
                |
                +-- 1007

  Reading in order of creation will cause the texts to be displayed
  in numerical order: 1002, 1003, 1004, 1005, 1006 and finally 1007.
  Reading in comment order will give the order 1002, 1003, 1006, 1004,
  1005 and finally 1007.")


    (kom-continuous-scrolling-doc . "\
  Turned on means that LysKOM will scroll the buffer while new text is 
  being inserted, not just at the end of a command. This works well with
  faster terminals, but may be worth turning off if the terminal is so slow
  that scrolling Emacs buffers takes a long time.")


    (kom-deferred-printing-doc . "\
  In order to improve speed, LysKOM will not print certain things, such as
  the names of users and conferences immediately, but will delay printing
  to make time for other tasks. This improves response time in the client
  considerably, and should only be turned off if it causes problems.")


    (kom-higher-priority-breaks-doc . "\
  When texts are created in conferences that have a higher priority than
  the one currently being read, LysKOM will attempt to break the normal
  reading order to show these. This setting controls whether the reading
  order is broken immediately, after the current comment chain is read or
  when everything in the current conference has been read.")


    (kom-login-hook-doc . "\
  This hook lists commands to be run when logging in, before any input is
  accepted from the keyboard.")


    (kom-do-when-done-doc . "\
  This hook lists commands and keyboard macros that are to be executed when
  all texts have been read.")


    (kom-page-before-command-doc . "\
  The LysKOM buffer can be cleared before all commands, so text that is 
  inserted always appears at the top of the buffer's window. This variable
  controls before which commands the buffer is to be scrolled.")


    (kom-permissive-completion-doc . "\
  When this is on, TAB will only complete to the names of users that are 
  logged on when the command being invoked is only applicable to people
  that are logged on. When off, TAB will complete to names of everyone.")


    (kom-membership-default-priority-doc . "\
  This specifies the how the initial priority of a conference is set when
  you first become a member. If it is a number between 1 and 255, that is
  the priority assigned. If it is something else, LysKOM will ask for a 
  priority every time you become a member of a conference.")

    (kom-show-personal-messages-in-buffer-doc . "\
  This setting specifies how personal, group and public messages are shown.
  The messages can be displayed in the LysKOM buffer, simply thrown away or
  be shown in a named buffer.")

    (kom-pop-personal-messages-doc . "\
  If messages are shown in a named buffer and this setting is also on, then
  LysKOM will display that buffer whenever a message arrives.")

    (kom-audio-player-doc . "\
  If you want LysKOM to play audio files instead of simply beeping, this
  setting must specify the name of a program that can play the audio files.
  The program must take a single argument, the name of the file to play.")

    (kom-default-message-recipient-doc . "\
  This setting controls who will be the default recipient of messages. The
  default recipient may either be everyone, i.e. a public message; the
  sender of the most recently received message; the recipient of the most
  recently received group message; or the sender of the most recently
  received personal message.")

    (kom-filter-outgoing-messages-doc . "\
  If this is on, messages that are sent automatically, such as automatic
  replies and replies to remote control commands, will be shown as if you
  had sent them manually.")

    (kom-friends-doc . "\
  The users named in this list will be displayed using a special face in
  the LysKOM buffer. These users are also listed with the command Which 
  friends (and may be used in other similar commands).")

    (kom-morons-doc . "\
  The users named in this list will be displayed using a warning face in
  the LysKOM buffer.")

    (kom-url-viewer-preferences-doc . "\
  This setting controls which WWW browser that will be used to open URLs
  found in LysKOM. If the first browser in the list cannot handle the type
  of URL being opened, then the next browser is tried, and so on.")

    (kom-windows-browser-command-doc . "\
  This setting specifies the command to use to start a web browser
  under Windows. If empty, a couple of commands that are likely the
  work on Windows will be tried.")

    (kom-mosaic-command-doc . "\
  This setting specifies the command to use to start NCSA Mosaic.")

    (kom-netscape-command-doc . "\
  This setting specifies the command to use to start Netscape or Mozilla.")

    (kom-galeon-command-doc . "\
  This setting specifies the command to use to start Galeon.")

    (kom-inhibit-typeahead-doc . "\
  Key presses are usually buffered while LysKOM is busy, and are executed
  as soon as possible. With this setting off, LysKOM discards any key presses
  received while the client was busy.")

    (kom-max-buffer-size-doc . "\
  It is possible to limit the size of the LysKOM buffer by specifying a
  maximum number of characters in this setting. When the buffer grows
  beyond this limit, text from the beginning of the buffer is removed.")

    (kom-ansaphone-record-messages-doc . "\
  LysKOM can record messages that arrive when the autoreply feature is on.
  This setting controls whether messages are recorded or not.")

    (kom-ansaphone-show-messages-doc . "\
  When this setting is on, LysKOM will display incoming messages even if
  the autoreply feature is turned on.")

    (kom-ansaphone-default-reply-doc . "\
  This is the message sent by the autoreply feature unless a different
  message has been specified using some other means (and other means are
  only for careful experts).")

    (kom-remote-control-doc . "\
  When turned on, it is possible to control the session using remote control
  commands. Only those users listed below may issue the commands.")

    (kom-remote-controllers-doc . "\
  The users listed here are permitted to issue remove control commands
  to your LysKOM session.")

    (kom-self-control-doc . "\
  When this is on, the user who is logged on may issue remote control
  commands. This is an alternative to adding yourself to the list of 
  permitted controllers.")

    (kom-customize-format-doc . "\
  The documentation for the various settings can be visible or hidden when
  you open the settings buffer. No matter if it starts hidden or visible, the
  documentation for individual settings can be shown and hidden by using the
  question mark/exclamation mark to the right of the setting.")

    (kom-default-language-doc . "\
  Default language to use in LysKOM. If you change this setting the new
  language will not be applied to the current setting. Use the Change
  language command to do that.")

    (kom-ispell-dictionary-doc . "\
  This specifies the dictionary ispell is to use for spell checking. If set
  to ispell-dictionary, then the variable ispell-dictionary will be used
  instead.")

    (kom-show-namedays-doc . "\
  This only works in Swedish. If you're running LysKOM in Swedish, turning
  this on causes today's names to be shown when you ask for the time.")

    (kom-show-week-number-doc . "\
  The Time command shows week numbers if this is on.")

    (kom-membership-default-placement-doc . "\
  This controls where new memberships are placed. First means before
  all existing memberships of the same priority. Last means after all
  existing memberships of the same priority. A number indicates a
  fixed placement (although the client will eventually sort the membership
  list in order of priority).")

    (kom-show-imported-importer-doc . "\
  The importer of an imported e-mail message is shown if this is on.
  This only works with compliant e-mail importers.")

    (kom-show-imported-envelope-sender-doc . "\
  The actual sender (the envelope sender) of imported e-mails is shown 
  if this is on. This only works with compliant e-mail importers.")

    (kom-show-imported-external-recipients-doc . "\
  Show external recipients and CC recipients of imported e-mails if this
  is on. This only works with compilant e-mail importers.")

    (kom-agree-text-doc . "\
  Default text for the Agree command. It can either be a text or a list
  of texts. If it is a list, one of the texts will be chosen at random.")

    (kom-silent-ansaphone-doc . "\
  If this is off, the client will not beep when a personal, group or
  public message is received when the auto reply feature is on.")

    (kom-default-session-priority-doc . "\
  The session priority of new sessions. Conferences with a lower priority
  will not be read.")

    (kom-unsubscribe-makes-passive-doc . "\
  When this is on, the first time you leave a conference you become a
  passive member. Leaving the conference again unsubscribes you completely.
  When this is off, leaving a conference unsubscribes you immediately.")

    (kom-review-priority-doc . "\
  Priority for review commands. This setting can be used to give review
  commands a higher priority than normal. The default priority is the
  same as the conference currently being read. Set this to 256 or higher
  if you want review commands to take precedence over all conferences.")

    (kom-show-creating-software-doc . "\
  Show the name of the client used to create a text if the information
  is present and this setting is on.")

    (kom-text-footer-format-doc . "\
  Format for the text footer. In the format string, %n is replaced by the
  text number, %P with the author's name, %p with the author's number, %f
  with information about the text (HTML, filled, etc), and %- with a
  suitable dashed line. A number after the percent sign is the minimum
  number of characters to use. A minus sign before the number causes text
  to be left justified within the field. An equals sign causes text
  longer than the indicated width to be truncated.")
 
    (kom-long-lines-doc . "\
  When this is on, most of the dashed lines are made longer than normal.")

    (kom-postpone-default-doc . "\
  Number of texts to postpone with the Postpone reading command.")

    (kom-allow-incompleteness-doc . "\
  When this is on, the client will not wait for information about all
  unread texts, even if it is needed. The result is that List news and
  some other commands do not yield accurate results shortly after logging
  in. When this is off, the client will wait for information on all
  unread texts when it is needed.")

    (kom-smileys-doc . "\
  When this is on, Emacs supports it, and the appropriate package 
  (smiley.el, which is part of Gnus) is installed, smileys will be
  shown graphically.")
  
    (kom-ignore-message-senders-doc . "\
  Don't show personal, group or alarm messages from these senders.")

    (kom-ignore-message-recipients-doc . "\
  Don't show group messages to these recipients.")

    (kom-text-footer-dash-length-doc . "\
  The total length of the text footer when long dashed lines are not
  in effect and no custom format is being used.")

    (kom-text-header-dash-length-doc . "\
  The total length of the text header when long dashed lines are not
  in effect.")

    (kom-show-personal-message-date-doc . "\
  When this is on, the date and time is shown on all personal, group and
  alarm messages.")

    (kom-w3-simplify-body-doc . "\
  When this is on, the client will ignore colors set in the HTML body when
  displaying formatted HTML.")

    (kom-mercial-doc . "\
  This text is shown in the list of users when you have finished reading
  everything.")

    (kom-server-priority-doc . "\
  Priority of this LysKOM session. The client can prompt you to go to
  a session with unread texts when a text arrives in a session with a
  higher priority than the one currently being read.")

    (kom-server-priority-breaks-doc . "\
   This setting controls when a prompt to go to the next LysKOM session
   with unread texts is presented.

   Immediately                  Present a prompt if any text arrives in
                                a session with a higher priority.

   Immediately if letters arrive    Present a prompt is a letter arrives
                                in a session with a higher priority.

   After current comment chain  Present a prompt after the current chain
                                of comments has been read if a text
                                arrives in a session with a higher 
                                priority.

   After current comment chain if letters arrive    Present a prompt
                                after the current chain of comments has
                                been read if a letter arrives in a session
                                with a higher priority.

   After current conference     Present a prompt after all texts in the
                                current conference have been read if a
                                text arrives in a session with a higher
                                priority.

   After current conference if letters arrive       Present a prompt 
                                after all texts in the current conference
                                have been read if a letter arrives in a 
                                session with a higher priority.

   After everything has been read   Present a prompt to go to the next
                                session with unreads after everything
                                has been read. The prompt is presented
                                regardless of session priorities.

   Never                        Never prompt to go to another LysKOM
                                session.")

    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-personal-messages-doc . "")
    (kom-ding-on-group-messages-doc . "")
    (kom-ding-on-common-messages-doc . "")
    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-wait-done-doc . "")
    (kom-ding-on-priority-break-doc . "")
    (kom-ding-on-new-letter-doc . "")
    (kom-check-for-new-comments-doc . "")
    (kom-check-commented-author-membership . "")
    (kom-confirm-multiple-recipients-doc . "")
    (kom-check-commented-author-membership-doc . "")
    (kom-complete-numbers-before-names-doc . "\
   When this is on and you enter a text that can be either a conference
   number or a conference name, the client will accept it as a conference 
   number, if possible. When this is off, the text will be accepted as
   a conference name first and number second.")
    (kom-keep-alive-interval-doc . "\
  The number of seconds between calls to the server used to keep the
  network connection to the LysKOM server active. If your network connection
  shuts down after a period of inactivity, set this to approximately half
  that period and use the command `Keep connection alive'.")
    (kom-text-no-prompts-doc . "\
  Specifies which commands will always prompt for text numbers and which
  will not. Commands that are not listed here will use default behavior.")
    (kom-saved-file-name-doc . "\
  Specifies the default file to archive texts in. The client will always
  prompt for the file name, using this as the default.")
    (kom-follow-attachments-doc . "\
  Specifies whether to read imported e-mail attachments as regular
  comments. When off, imported attachments are marked as read when the
  e-mail they are attached to is read.")
    (kom-show-unread-in-frame-title-doc . "\
  When this is on, the indicator \"(Unread)\" is shown in the title
  bar of all windows whose active buffer belongs to a LysKOM session
  with unread texts. The title bar may not be updated unless the
  window is open.")
    (kom-created-texts-are-saved-doc . "\
  If this variable is set to a file name, all texts you write will be 
  saved to that file. Texts that could not be created are not saved.")
    (kom-confirm-add-recipients-doc . "\
  When this is on and you add a recipient to a text, the client will
  ask if comments to the text should also be sent to the new
  recipient. When this is off, comments will always be sent to the new
  recipient. For most people it is a good idea to leave this on.")

    (kom-trim-buffer-minimum-doc . "\
  If you have limited the LysKOM buffer size, this variable determines
  how much larger than the limit the buffer has to be before it is
  trimmed back to the maximum size. The variable must be an integer;
  the default is 4096.")

    (kom-dont-check-commented-authors-doc . "")
    (kom-print-relative-dates-doc . "\
  The time fields of texts (and a couple of other things) will be
  \"today\" or \"yesterday\" if this setting is on and the text was
  written today or yesterday, respectively. If it is off, absolute
  dates will always be shown.")
    (kom-print-seconds-in-time-strings-doc . "\
  If this setting is on, some time strings (for example the creation
  time of texts and sent messages) will include seconds.")
    (kom-review-uses-cache-doc . "\
  If this is turned on, commands that review texts will use saved copies
  of the text rather then get new copies from the server. This makes the
  commands run significantly faster, but in some cases the texts may 
  have changed since they were copied, and you will not see those 
  changes.")
    (kom-review-marks-texts-as-read-doc . "\
  If this is turned on, commands that review texts will also mark them
  as read. Otherwise, the review commands will leave your reading history
  untouched, as usual.")
    (kom-auto-review-faqs-doc . "\
  If this is turned on, FAQs that are not marked as read will be reviewed
  automatically when you log on or go to a conference with a new FAQ.")
    (kom-auto-list-faqs-doc . "\
  If this is turned on, new FAQs will be listed automatically when you
  log on or go to a conference with a new FAQ.")
    (kom-extended-status-information-doc . "\
  When this is on, additional information may be shown by commands that
  display person, conference and server status.")
    (kom-highlight-first-line-doc . "\
  When this is on, the first line (with text number, date and author) is
  shown with a different format than normal text.")
    (kom-highlight-dashed-lines-doc . "\
  When this is on, the lines before and after the text body is shown with
  a different format than normal text.")
    (kom-highlight-text-body-doc . "\
  When this is on, the text body is shown with a different format than
  normal text.")
    (kom-async-highlight-dashed-lines-doc . "\
  When this is on, the lines before and after personal, group- and alarm
  messages are shown with  a different format than normal text.")
    (kom-async-highlight-text-body-doc . "\
  When this is on, the body of personal, group- and alarm messages are
  shown with a different format than normal text.")
    (kom-edit-hide-add-button-doc . "\
  When this is on, an [Add...] button will be shown after the list of
  recipients and auxiliary information when writing a new text.")
    (kom-format-html-authors-doc . "\
  This setting controls which author's HTML messages that the client will
  attempt to format.")
    (kom-keyboard-menu-immediate-selection-doc . "\
  This setting controls whether keyboard shortcuts in text-based context
  menus require confirmation with return or not. With this on you have
  to confirm all selections with return.")
    (kom-max-overlays-doc . "\
  Use this setting to limit the number of overlays in the LysKOM buffer
  \(overlays are used to create the colored backgrounds for texts\). By
  limiting the number of overlays it is possible to speed up operations
  such as scrolling significantly. Each text requires 1-4 overlays for
  highlighting, depending on other settings.")


    ;;
    ;; Tags for variables
    ;;
    
    (kom-ansaphone-replies-tag . "Automatic replies")
    (kom-bury-buffers-tag . "Bury buffers when changing LysKOM:")

  (kom-personal-messages-in-window-tag . "Personal messages:      ")
    (kom-customize-in-window-tag       . "LysKOM customization:   ")
    (kom-write-texts-in-window-tag     . "Author new texts:       ")
    (kom-prioritize-in-window-tag      . "Prioritize conferences: ")
    (kom-edit-filters-in-window-tag    . "Modify filters:         ")
    (kom-view-commented-in-window-tag  . "Review comments:        ")
    (kom-list-membership-in-window-tag . "List membership:        ")

    (kom-user-prompt-format-tag . "Prompt format:")
    (kom-user-prompt-format-executing-tag . "Prompt format when executing:")
    (kom-anonymous-prompt-format-tag . "Prompt format (anonymous):")
    (kom-anonymous-prompt-format-executing-tag . "Prompt format when executing (anonymous):")
    (kom-enabled-prompt-format-tag . "Prompt format (admin):")
    (kom-enabled-prompt-format-executing-tag . "Prompt format when executing (admin):")

    (kom-higher-priority-breaks-tag . 
"Read prioritized texts:                           ")
    (kom-created-texts-are-read-tag . 
"Automatically read created texts:                 ")
    (kom-default-mark-tag           . 
"Default mark:                                     ")
    (kom-print-number-of-unread-on-entrance-tag . 
"Show number of unread when entering a conference: ")
    (kom-follow-comments-outside-membership-tag .
"Follow comment chains outside membership:         ")
    (kom-show-footnotes-immediately-tag .
"Show footnotes immediately:                       ")
    (kom-membership-default-priority-tag . 
"Default priority for new memberships:             ")
    (kom-dashed-lines-tag . 
"Dashed lines around the text body:                ")
    (kom-autowrap-tag . 
"Fill wide paragraphs before displaying:           ")
    (kom-show-author-at-end-tag .
"Show the name of the author after the body:       ")

    (kom-truncate-threshold-tag .
"Truncate long texts:                              ")
    (kom-truncate-show-lines-tag .
"Lines to show of truncated texts:                 ")

    (kom-reading-puts-comments-in-pointers-last-tag . "Comment links are shown:")
    (kom-read-depth-first-tag . "Read order:")
    (kom-deferred-printing-tag . "Delayed display:")
    (kom-continuous-scrolling-tag . "Continuous scrolling:")

    (kom-presence-messages-in-echo-area-tag . 
"Presence messages in echo area:        ")
    (kom-presence-messages-in-buffer-tag .
"Presence messages in the LysKOM buffer:")
    (kom-page-before-command-tag . "Clear the screen:")

    (kom-idle-hide-tag . 
"Number of minutes of inactivity before session is hidden:      ")
    (kom-show-where-and-what-tag . 
"Show where sessions are logged on from and what they are doing:    ")
    (kom-show-since-and-when-tag . 
"Show when sessions connected and how long they have been inactive: ")



    (kom-login-hook-tag . "Commands executed after logging on:")
    (kom-do-when-done-tag . "Commands to execute after reading everything:")
    (kom-permissive-completion-tag . "Fussy name completion:")
    (kom-show-personal-messages-in-buffer-tag . 
"Where are messages shown: ")
    (kom-pop-personal-messages-tag . 
"Pop up message buffer:    ")
    (kom-default-message-recipient-tag . 
"Default message recipient:")

    (kom-audio-player-tag . "Audio player program:")
    (kom-ding-on-new-letter-tag        . "When a letter arrives:            ")
    (kom-ding-on-priority-break-tag    . "When a prioritized text arrives:  ")
    (kom-ding-on-wait-done-tag         . "When done waiting:                ")
    (kom-ding-on-common-messages-tag   . "When a public message arrives:    ")
    (kom-ding-on-group-messages-tag    . "When a group message arrives:     ")
    (kom-ding-on-personal-messages-tag . "When a personal message arrives:  ")
    (kom-ding-on-no-subject-tag     .    "When you forget the subject line: ")

    (kom-filter-outgoing-messages-tag . "Show automatic messages:")
    (kom-friends-tag . "Friends and other special people:")
    (kom-morons-tag . "Morons and other \"special\" people:")
    (kom-url-viewer-preferences-tag . "Open URLs using the following program:")
    (kom-windows-browser-command-tag . "Command to start a web browser on Windows:")
    (kom-mosaic-command-tag . "Command to start NCSA Mosaic:")
    (kom-netscape-command-tag . "Command to start Netscape/Mozilla:")
    (kom-galeon-command-tag . "Command to start Galeon:")

    (kom-symbolic-marks-alist-tag . "Symbolic mark types:")

    (kom-cite-string-tag . "Quotation indicator:")
    (kom-confirm-multiple-recipients-tag . 
"Confirm multiple recipients:         ")
    (kom-check-commented-author-membership-tag . 
"Check membership of commented author:")
    (kom-check-for-new-comments-tag . 
"Check for unread comments:           ")

    (kom-ansaphone-record-messages-tag . 
"Save messages when auto reply is on:    ")
    (kom-ansaphone-show-messages-tag . 
"Display messages when auto reply is on: ")
    (kom-ansaphone-default-reply-tag . "Auto reply message:")


    (kom-inhibit-typeahead-tag . "Buffer keypresses:")
    (kom-max-buffer-size-tag . "Maximum buffer size:")

    (kom-remote-control-tag .     "Remote commands on or off:             ")
    (kom-self-control-tag .       "Allow me to use remote commands:       ")
    (kom-remote-controllers-tag . "People allowed to use remove commands:")

    (kom-customize-format-tag . "Show documentation for all settings:")
    (kom-default-language-tag . "Default language:  ")
    (kom-show-namedays-tag    . "Show today's names:")
    (kom-ispell-dictionary-tag . "Spelling dictionary:")

    (kom-show-week-number-tag . "Show week number:")
    (kom-membership-default-placement-tag . "Placement of new memberships:")
    (kom-show-imported-importer-tag . "Show importer of imported messages:")
    (kom-show-imported-envelope-sender-tag . "Show sender of imported messages:")
    (kom-show-imported-external-recipients-tag . "Show external recipients of imported messages:")
    (kom-agree-text-tag . "Default text for Agree:")
    (kom-silent-ansaphone-tag . "Beep when auto reply is on:")
    (kom-default-session-priority-tag . "Default session priority:")
    (kom-unsubscribe-makes-passive-tag . "Leaving a conference converts membership to passive:")
    (kom-review-priority-tag . "Priority for review commands:")
    (kom-show-creating-software-tag . "Show creating software:")
    (kom-text-footer-format-tag . "Text footer format:")
    (kom-long-lines-tag . "Long dashed lines:")
    (kom-postpone-default-tag . "Default number of texts to postpone:")
    (kom-allow-incompleteness-tag . "Allow incomplete information about unread texts:")
    (kom-smileys-tag . "Show smileys graphically:")
    (kom-ignore-message-senders-tag . "Don't show messages from:")
    (kom-ignore-message-recipients-tag . "Don't show messages to:")
    (kom-text-footer-dash-length-tag . "Text footer length:")
    (kom-text-header-dash-length-tag . "Length of dashed line before text:")
    (kom-show-personal-message-date-tag . "Show date and time of messages:")
    (kom-w3-simplify-body-tag . "Display HTML without document colors:")
    (kom-mercial-tag . "Text to display when all is read:")
    (kom-server-priority-tag . "Session priority:")
    (kom-server-priority-breaks-tag . "Prompt to go to next LysKOM:")
    (kom-complete-numbers-before-names-tag . "Read conference numbers before names:")
    (kom-keep-alive-interval-tag . "Keep connection alive interval:")
    (kom-text-no-prompts-tag . "How commands prompt for text numbers:")
    (kom-saved-file-name-tag . "File to archive texts in:")
    (kom-follow-attachments-tag . "Read imported attachments as texts:")
    (kom-show-unread-in-frame-title-tag . "Show unread indicator in title bar:")
    (kom-created-texts-are-saved-tag . "Save created texts:")
    (kom-confirm-add-recipients-tag . "Ask if comments should be sent to new recipients:")
    (kom-trim-buffer-minimum-tag . "How small parts of the LysKOM buffer are trimmed:")
    (kom-dont-check-commented-authors-tag . "Authors not to check:")
    (kom-print-relative-dates-tag . "Show relative dates:")
    (kom-print-seconds-in-time-strings-tag . "Include seconds in time strings:")
    (kom-review-uses-cache-tag . "Review commands use cached texts:")
    (kom-review-marks-texts-as-read-tag . "Review commands mark texts as read:")
    (kom-auto-review-faqs-tag . "Review new FAQs automatically:")
    (kom-auto-list-faqs-tag . "List new FAQs automatically:")
    (kom-extended-status-information-tag . "Extended status information:")
    (kom-highlight-first-line-tag . "Color fist line:")
    (kom-highlight-dashed-lines-tag . "Color dashed lines:")
    (kom-highlight-text-body-tag . "Color text backgrounds:")
    (kom-async-highlight-dashed-lines-tag . "Color dashed lines around messages:")
    (kom-async-highlight-text-body-tag . "Color message backgrounds:")
    (kom-edit-hide-add-button-tag . "Show add button when writing texts:")
    (kom-format-html-authors-tag . "Format HTML-messages per author:")
    (kom-keyboard-menu-immediate-selection-tag . "Shortcuts in text menus require confirmation:")
    (kom-max-overlays-tag . "Maximum number of overlays:")
    )
)






;;;; ============================================================
;;;; The default Ansaphone message goes here. The more complex 
;;;; message specification probably should too, but it's not here
;;;; yet. People who know how to use it are smart enough to do it
;;;; right.

(lyskom-language-var local kom-ansaphone-default-reply en 
  "I am not reading LysKOM right now. Please write a letter instead.")
        
;;;; ============================================================
;;;; Other language-dependent variables
;;;;

(lyskom-language-var local kom-ispell-dictionary en
  "english")



;;;; ================================================================
;;;; Tell phrases should be configured with the default language used
;;;; at the server and not for person reading if they happens to
;;;; differ. This is of course because they are sent to the server for
;;;; everybody else to see.

;;;; Aronsson was here 4 DEC 1990, thus creating version 0.18
					; Created *-tell-*


;;; To coders of the elisp-client:
;;; You not only have to change the text here, you also have to modify
;;; kom-tell-phrases-validation-list in vars.el if you add or remove
;;; one of these.

(eval-when-compile (defvar kom-tell-phrases))

(lyskom-language-strings local kom-tell-phrases en
  '((kom-tell-silence		. "") ; Why ?
    (kom-tell-send		. "Is trying to post a text.")
    (kom-tell-login		. "Is entering LysKOM.")
    (kom-tell-read		. "Is reading.")
    (kom-tell-1st-pres		. "Is writing the first presentation.")
    (kom-tell-write-comment	. "Is writing a comment.")
    (kom-tell-write-footnote	. "Is writing a footnote.")
    (kom-tell-write-letter	. "Is writing a letter.")
    (kom-tell-write-reply	. "Is writing a personal reply.")
    (kom-tell-write-text	. "Is writing a text.")
    (kom-tell-conf-pres		. "Is writing the presentation for a new conference.")
    (kom-tell-recover		. "Is restarting KOM. Sigh.")
    (kom-tell-wait		. "Is waiting.")
    (kom-tell-regret		. "Decides to throw away the text.")
    (kom-tell-review		. "Is reviewing.")
    (kom-tell-change-name       . "Takes on a new name.")
    (kom-tell-change-supervisor . "Changes the supervisor of something.")
    (kom-tell-next-lyskom	. "Moves to a different LysKOM.")))

(if (and (boundp 'kom-tell-phrases)
         kom-tell-phrases)
    (lyskom-language-strings local kom-tell-phrases en
      (mapcar (function 
               (lambda (x)
                 (cond ((and (consp x)
                             (symbolp (car x))
                             (stringp (cdr x))) x)
                       ((and (consp x)
                             (symbolp (car x))
                             (consp (cdr x))
                             (stringp (car (cdr x))))
                        (cons (car x) (car (cdr x))))
                       (t nil))))
              kom-tell-phrases)))


;; Placed here because this must NOT be evaluated before 
;; kom-tell-phrases is defined:

(lyskom-language-var local kom-mercial en (lyskom-get-string 'kom-tell-wait 
                                                       'kom-tell-phrases))


(lyskom-language-strings local lyskom-error-texts en
  '((error-0 . "No error")
    (error-2 . "Not yet implemented")
    (error-3 . "No longer implemented")
    (error-4 . "Wrong password")
    (error-5 . "String too long")
    (error-6 . "You have not logged on")
    (error-7 . "Nobody may enter LysKOM at this time")
    (error-8 . "You attempted to use conference number 0")
    (error-9 . "Undefined or secret conference")
    (error-10 . "Undefined or secret user")
    (error-11 . "No read or write permission")
    (error-12 . "Illegal operation")
    (error-13 . "You are not a member of that conference")
    (error-14 . "There is no text with that number")
    (error-15 . "You cannot use global text number 0")
    (error-16 . "There is no text with that local number")
    (error-17 . "You cannot use local text number 0")
    (error-18 . "Name too short, too long or containing illegal characters")
    (error-19 . "Index out of bounds")
    (error-20 . "The conference already exists")
    (error-21 . "The user already exists")
    (error-22 . "Secret but not read-protected")
    (error-23 . "You are not allowed to change the person/conference flag")
    (error-24 . "Error in the database. Tough luck.")
    (error-25 . "Invalid recipient or comment type")
    (error-26 . "Illegal info type. (Bug in the client)")
    (error-27 . "Already recipient of this text")
    (error-28 . "Already comment to this text")
    (error-29 . "Already footnote to this text")
    (error-30 . "Not a recipient of this text")
    (error-31 . "Not a comment to this text")
    (error-32 . "Not a footnote to this text")
    (error-33 . "Too many recipients")
    (error-34 . "Too many commentsp")
    (error-35 . "Too many footnotes")
    (error-36 . "Too many marks")
    (error-37 . "You are not the author of that text")
    (error-38 . "You cannot connect to the server")
    (error-39 . "Out of memory")
    (error-40 . "The server is gone crazy")
    (error-41 . "The client thinks that the server says that it does not understand the client")
    (error-42 . "No such session")
    (error-43 . "Invalid regular expression")
    (error-44 . "Can't unmark a text that was not marked")
    (error-45 . "Temorary lossage. Please try again later")
    (error-46 . "Sending huge messages to the server is not a nice thing to do")
    (error-47 . "Anonymous texts are not accepted by all recipients")
    (error-48 . "Invalid auxiliary information")
    (error-49 . "Change of auxiliary information not permitted")
    (error-50 . "Unknown asynchronous message")
    (error-51 . "Internal server error")
    (error-52 . "Feature disabled in the server")
    (error-53 . "Unable to send message")
    (error-54 . "Invalid membership type")
))

(lyskom-language-var global lyskom-unread-mode-line en
  (lyskom-make-lyskom-unread-mode-line))

(lyskom-language-var global lyskom-unread-title-format en
  (lyskom-make-lyskom-unread-title-format))

(lyskom-language-var local lyskom-help-data en lyskom-en-help-data)


(provide 'lyskom-strings)

;;; english-strings ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: swedish-strings.el,v 44.266 2002/09/07 21:35:21 ceder Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: swedish-strings.el
;;;;
;;;; This file contains all strings in the LysKOM elisp client.
;;;; Language: Swedish.
;;;;
;;;; ================================================================
;;;;

(require 'lyskom-vars "vars")
(require 'lyskom-language "language")

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: swedish-strings.el,v 44.266 2002/09/07 21:35:21 ceder Exp $\n"))


;;; ================================================================
;;; The language definition

(lyskom-define-language 'sv
                        'iso-8859-1
                        "Svenska"
                        )


;;; ================================================================
;;; lyskom-edit-mode-map

(defvar lyskom-sv-edit-mode-map nil)
(lyskom-language-keymap lyskom-edit-mode-map sv lyskom-sv-edit-mode-map)

;;; Set the keymap for lyskom-edit-mode

(defvar lyskom-sv-edit-prefix nil)

(if lyskom-sv-edit-mode-map
    nil
  (setq lyskom-sv-edit-mode-map (make-sparse-keymap))
  (define-prefix-command 'lyskom-sv-edit-prefix)
  (define-prefix-command 'lyskom-sv-edit-review-prefix)
  (define-prefix-command 'lyskom-sv-edit-insert-prefix)
  (define-prefix-command 'lyskom-sv-edit-aux-prefix)
  (define-prefix-command 'lyskom-sv-edit-add-prefix)
  (define-key lyskom-sv-edit-mode-map (kbd "*")     'kom-button-press-or-self-insert-command)
  (define-key lyskom-sv-edit-mode-map (kbd "=")     'kom-menu-button-press-or-self-insert-command)
  (define-key lyskom-sv-edit-mode-map (kbd "TAB")   'kom-edit-next-button-or-self-insert)
  (define-key lyskom-sv-edit-mode-map (kbd "M-TAB") 'kom-edit-prev-button)
  (define-key lyskom-sv-edit-mode-map (kbd "<S-tab>") 'kom-edit-prev-button)
  (define-key lyskom-sv-edit-mode-map (kbd "C-c")   'lyskom-sv-edit-prefix)
  (define-key lyskom-sv-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2 'button2up))) 'kom-button-click-or-yank)
  (define-key lyskom-sv-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2up 'button2))) 'kom-mouse-null)
  (define-key lyskom-sv-edit-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-sv-edit-mode-map (kbd (lyskom-keys 'button3up))     'kom-mouse-null)
  (define-key lyskom-sv-edit-prefix (kbd "C-x")     'lyskom-sv-edit-aux-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "?")       'lyskom-help)
  (define-key lyskom-sv-edit-prefix (kbd "}")       'lyskom-sv-edit-review-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "]")       'lyskom-sv-edit-review-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "C-]")     'lyskom-sv-edit-review-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "C-}")     'lyskom-sv-edit-review-prefix)
  (define-key lyskom-sv-edit-prefix (lyskom-keys 'C-) 'lyskom-sv-edit-review-prefix)
  (define-key lyskom-sv-edit-prefix (lyskom-keys 'C-) 'lyskom-sv-edit-review-prefix)
  (define-key lyskom-sv-edit-prefix [(control )] 'lyskom-sv-edit-review-prefix)
  (define-key lyskom-sv-edit-prefix [(control )] 'lyskom-sv-edit-review-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "*")       'kom-button-press)
  (define-key lyskom-sv-edit-prefix (kbd "=")       'kom-menu-button-press)
  (define-key lyskom-sv-edit-prefix (kbd "C-i")     'lyskom-sv-edit-insert-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "TAB")     'lyskom-sv-edit-insert-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "C-c")     'kom-edit-send)
  (define-key lyskom-sv-edit-prefix (kbd "C-s")     'kom-ispell-message)
  (define-key lyskom-sv-edit-prefix (kbd "C-k")     'kom-edit-quit)
  (define-key lyskom-sv-edit-prefix (kbd "} ?")     'lyskom-help)
  (define-key lyskom-sv-edit-prefix (kbd "} C-k")   'kom-edit-show-commented)
  (define-key lyskom-sv-edit-prefix (kbd "} k")     'kom-edit-show-commented)
  (define-key lyskom-sv-edit-prefix (kbd "C-i ?")   'lyskom-help)
  (define-key lyskom-sv-edit-prefix (kbd "C-i C-k") 'kom-edit-insert-commented)
  (define-key lyskom-sv-edit-prefix (kbd "C-y")     'kom-edit-insert-commented)
  (define-key lyskom-sv-edit-prefix (kbd "C-i C-y")     'kom-edit-insert-commented)
  (define-key lyskom-sv-edit-prefix (kbd "C-b")     'kom-edit-insert-buglist)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 1")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 2")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 3")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 4")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 5")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 6")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 7")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 8")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i 9")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i SPC") 'kom-edit-insert-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-i C-l") 'kom-edit-insert-link)
  (define-key lyskom-sv-edit-prefix (kbd "C-a")     'lyskom-sv-edit-add-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "C-a C-m") 'kom-edit-add-recipient)
  (define-key lyskom-sv-edit-prefix (kbd "C-a <RET>") 'kom-edit-add-recipient)
  (define-key lyskom-sv-edit-prefix (kbd "C-a C-e") 'kom-edit-add-copy)
  (define-key lyskom-sv-edit-prefix (kbd "C-a C-b") 'kom-edit-add-bcc)
  (define-key lyskom-sv-edit-prefix (kbd "C-a C-f") 'kom-edit-move-text)
  (define-key lyskom-sv-edit-prefix (kbd "C-a C-j") 'kom-edit-add-recipient)
  (define-key lyskom-sv-edit-prefix (kbd "C-a <LFD>") 'kom-edit-add-recipient)
  (define-key lyskom-sv-edit-prefix (kbd "C-a C-k") 'kom-edit-add-comment)
  (define-key lyskom-sv-edit-prefix (kbd "C-a C-x") 'kom-edit-add-cross-reference)
  (define-key lyskom-sv-edit-prefix (kbd "C-x C-p") 'kom-edit-add-personal-comments)
  (define-key lyskom-sv-edit-prefix (kbd "C-x C-n") 'kom-edit-add-no-comments)
  (define-key lyskom-sv-edit-prefix (kbd "C-x C-l") 'kom-edit-add-world-readable)
  (define-key lyskom-sv-edit-prefix (kbd "C-x C-b") 'kom-edit-add-read-confirm-request)
  (define-key lyskom-sv-edit-prefix (kbd "C-a ?")   'lyskom-help))



(defconst lyskom-strings-missing '())



;;; The alist formely known as lyskom-strings
(lyskom-language-strings local lyskom-message sv
  '(
    ;; From vars.el: 
    ;; From komtypes.el: nil
    ;; From clienttypes.el: nil
    ;; From startup.el:
    (server-q . "LysKOM-server? (%#1s) ")
    (try-connect . "LysKOM elisp-klient version %#1s.\nFrsker koppla upp mot %#2s.\n")
    (too-old-server . "Servern r fr gammal fr den hr versionen av klienten.")
    (connection-done . "Uppkopplingen klar. Serverns versionsnummer r %#1s.\n\n")
    (what-is-your-name . "Vad heter du? ")
    (password . "Lsenord? ")
    (wrong-password . "Fel lsen.\n")
    (wrong-password-help . "
Du kan skicka e-mail till ngon av nedanstende adresser fr att f
ett nytt lsenord eller fr att f din gamla person raderad s att du
kan skapa en ny:\n")
    (wrong-password-email . "* %#1t\n")
    (are-logged-in . "Du r nu inloggad. Vnta ett tag.\n")
    (you-have-motd . "\nDu har en lapp p drren:\n\n")
    (lyskom-motd-was-garbed . "\nLoginmeddelandet finns inte!
Det meddelande som ska visas efter inloggning har frsvunnit.
Kontakta LysKOM-administratren.\n")
    (presentation-encouragement . 
				"Du har ingen presentation. Det skulle vara trevligt om du skrev en.
Anvnd kommandot p. Om du inte vill skriva ngon presentation tryck fs.\n")

    (first-greeting . "%#1s
Det tycks vara frsta gngen du anvnder LysKOM. Vlkommen!
Kontrollera att du stavat ditt namn rtt. Anvnd grna ditt fullstndiga
namn och organisation, t ex \"Eskil Block, FOA\". Om du stavat ditt namn
fel, eller vill ndra ditt namn, svara nej p frgan nedan.

Observera att all information n s lnge sparas s att vem som helst
kan lsa den. Dock r lsenordet krypterat.

Om du r osker p hur man anvnder LysKOM kan du hmta en manual via
anonym ftp frn ftp.lysator.liu.se. Frga din systemadministratr om
du r osker. Du kan ven skriva \"?\" fr kommandot \"Hjlp\".
")

    (is-name-correct . "r namnet %#1s korrekt? ")
    (personal-password . "Ange ett personligt lsen: ")
    (repeat-password . "Repetera fr kontroll: ")
    (repeat-failure . "Du angav inte samma lsenord bgge gngerna.\n")

    (could-not-create-you .  "Det gick inte att skapa personen.\n")
    (presentation-subject . "%#1s")
    (presentation-form . "\
Namn:    
Adress:  
Stad:    
Telefon: 
E-post:  
WWW:     

Annat:   ")
    (presentation-help . "Du skriver just  nu din presentation.\n")
    (not-present-anywhere . "Ej nrvarande i ngot mte.")
    (in-secret-conference . "Hemligt mte (%#1d).")
    (start-new-session-same-server
     . "Du kr redan mot den servern. Vill du starta en ny session? ")
    (new-session-in-buffer . "\n\n---- Ny session startad %s ----\n\n")
    (warning-about-uncompiled-client . "
OBS: LysKOM-klienten r inte kompilerad. Fr att ka prestanda br du kra en
kompilerad version av klienten. Ls i den medfljande README-filen hur man
gr det.
")

    ;; From internal.el:
    (shaky-tcp . "Nu nr jag inte servern. TCP/IP-frbindelsen r skakig%#1s")
    (retrying-tcp . "Jag frsker igen.")

    ;; From parse.el:
    (protocol-error . "protokollfel: %s")

    ;; From services.el:
    (interrupted . "Kommandot avbrutet\n")

    ;; From cache.el:
    ;; No entries.

    ;; From commands1.el:
    (appreciation . "Du r mycket vacker och mycket klok. Mnga lskar dig bde till kropp
och till sjl. Du kommer att versas med rikedom och f stor lycka i ditt
liv. Var glad att just du r du. Det har du all anledning att vara.
Fantomen nskar dig en bra dag.\n\n")
    (abuse . "Du r mycket ful och mycket dum. Mnga hatar dig bde till kropp
och till sjl. Du kommer att versas med sjukdomar och inte f ngon som
helst lycka i ditt liv. Du borde verkligen ta dig samman och gra ngot av
ditt liv ven om det inte r mycket att starta med.
Guran vill helst stta en giftpil i dig.\n\n")

    (what-conf-to-delete . "Vilket mte/person vill du utplna: ")
    (what-conf-to-change . "Vilket mte vill du ndra: ")
    (confirm-delete-pers-or-conf . "Ta bort %#1s %#2s? ")
    (the-pers . "personen")
    (the-conf . "mtet")
    (deletion-not-confirmed . "Utplningen avbruten\n")
    (somebody-else-deleted-that-conf . "Ngon annan tog precis bort mtet.\n")
    (conf-is-deleted . "Ok, nu r %#1s utplnad.\n")
    (you-could-not-delete . "%#1M kunde inte utplnas av dig.\n")
    (you-have-deleted-yourself . "Du har utplnat dig sjlv.\n")

    (what-text-to-delete . "Vilket inlgg skall tas bort? ")
    (delete-marked-text . "Inlgget r %#1s. Ta bort nd? ")
    (delete-marked-by-you . "markerat av dig")
    (delete-marked-by-you-and-others . "markerad av dig och %#1?d%[ngon annan%]%[%#1d andra%]")
    (delete-marked-by-several . "markerat av %#1d person%#1?d%[%]%[er%]")
    (deleting-text . "Radering av text %#1:n...")

    (presentation-for-whom . "Vilket mte/person? ")
    (text-to-see-author-of . "Se presentation fr vilket inlggs frfattare? ")
    (somebody-deleted-that-conf . "Ngon tog precis bort mtet.\n")
    (review-presentation-of . "terse presentation av %#1M.\n")
    (has-no-presentation . "%#1:M har ingen presentation.\n")

    (have-to-read . "Du mste lsa ett inlgg frst.\n")

    (no-comment-to . "Det finns inget kommenterat inlgg att titta p.\n")
    (no-text-at-point . "Det finns inget inlgg vid markren.\n")
    (what-ancestor . "Vilken av de kommenterade texterna nskas? ")

    (who-letter-to . "Vem vill du skicka brev till? ")
    (who-send-text-to . "Vem vill du skicka inlgget till? ")
    (has-motd . "%#1P har en lapp p drren:\n\n")
    (motd-persist-q . "Vill du fortfarande skicka brevet? ")

    (who-to-add . "Vem vill du addera? ")
    (where-to-add . "Vilket mte skall han/hon adderas till? ")
    (where-to-add-self . "Vilket mte vill du bli medlem i? ")
    (priority-q . "Prioritet p ditt medlemskap i mtet? (0 (lg) - 255 (hg)) ")
    (done . "klart.\n")
    (cancelled . "avbrutet.\n")
    (nope . "det gick inte.\n")
    (add-already-member . "%#1P r redan medlem i %#2M.\n")

    (cant-find-supervisor . "Hittar inte organisatren fr %#1M.\n")
    (is-read-protected-contact-supervisor . "%#1M r slutet.
Skicka ett brev till %#2P fr medlemskap.\n")

    (conf-does-not-exist . "\nMtet finns inte.\n")

    (who-to-exclude . "Vem vill du utesluta? ")
    (where-from-exclude . "Vilket mte skall han/hon uteslutas ifrn? ")

    (leave-what-conf . "Vilket mte vill du g ur? ")

    (error-fetching-person . "Fel i personhmtningen.\n")
    (error-fetching-conf . "Fel i mteshmtningen.\n")

    (name-of-conf . "Vad ska mtet heta? ")
    (anyone-member . "Fr vem som helst bli medlem? ")
    (secret-conf . "Hemligt mte? ")
    (comments-allowed . "Fr man skriva kommentarer? ")
    (anonymous-allowed . "Fr man skriva anonyma texter? ")
    (secret-members-allowed . "Fr man g med som hemlig medlem? ")
    (what-comment-no . "Kommentera text nummer: ")
    (what-footnote-no . "Fotnotera text nummer: ")
    (what-private-no . "Personligt svar till text nummer: ")
    (quit-in-spite-of-unsent . "Vill du avsluta sessionen trots oinskickat inlgg? ")
    (really-quit . "Vill du verkligen avsluta sessionen? ")
    (session-ended . "
*****************************
LysKOM-sessionen r avslutad.
*****************************\n")
    (session-auto-ended . "
===========================================================
Kopplar ned frn LysKOM eftersom LysKOM r fullt och
du har lst klart allting. Kom tillbaks senare.
===========================================================\n\n")
    (session-ended-long . "
*******************************************************************************
LysKOM-sessionen r avslutad.
*******************************************************************************
")
    (session-auto-ended-long . "
===============================================================================
Kopplar ned frn LysKOM eftersom LysKOM r fullt och
du har lst klart allting. Kom tillbaks senare.
===============================================================================
\n")
    (what-to-change-pres-you . "Vilket mte/person vill du ndra presentationen fr (dig sjlv): ")
    (what-to-change-faq-you . "Vilket mte vill du ndra FAQ fr: ")
    (who-to-put-motd-for . "Vilket mte/person vill du stta lapp p drr fr (dig sjlv): ")

    (what-to-set-pres-you . "Vilket mte/person vill du stta presentationen fr (dig sjlv): ")
    (what-text-to-set-as-pres-no . "Vilket inlgg vill du ska vara den nya presentationen: ")
    (what-to-set-motd-you . "Vilket mte/person vill du stta lapp p drr fr (dig sjlv): ")
    (what-text-to-set-as-motd-no . "Vilket inlgg vill du ska vara den nya lappen: ")
    (conf-already-has-pres . "Mtet/personen har redan en presentation. Fortstt nd? ")
    (conf-already-has-motd . "Mtet/personen har redan en lapp p drren. Fortstt nd? ")
    (setting-conf-pres . "Stter presentation fr %#1M till text %#2n...")
    (setting-conf-motd . "Stter lapp p drren fr %#1M till text %#2n...")

    (who-to-remove-pres-for . "Vilket mte/person vill du ta bort presentationen frn (dig sjlv): ")
    (removing-pres-for-conf . "Tar bort presentation (text %#2n) frn %#1M...")

    (cant-get-conf-stat . "Kan ej hmta mtesstatus fr mtet.\n")
    (go-to-conf-p . "G till mte: ")
    (want-become-member . "Vill du bli medlem? ")
    (no-ok . "Nehej.\n")

    (who-to-remove-motd-for . "Vilket mte/person vill du ta bort lapp p drr fr (dig sjlv): ")

    (conf-all-read . "inga olsta")
    (no-in-conf . "Du r inte nrvarande i ngot mte.\n")

    (search-for-pers . "Ange skvillkor (RETURN fr alla personer): ")
    (search-for-conf . "Ange skvillkor (RETURN fr alla mten): ")
    (search-re . "Ange skuttryck (reguljrt uttryck): ")
    (include-persons . "Sk bland personer? ")
    (include-conferences . "Sk bland mten? ")

    (no-matching-confs . "Inga mten uppfyller skvillkoret \"%#1s\".\n")
    (no-matching-perss . "Inga personer uppfyller skvillkoret \"%#1s\".\n")
    (no-matching-anys . "Inga personer eller mten uppfyller uttrycket \"%#1s\".\n")
    (no-confs-exist . "Det finns inga mten i databasen.\n")
    (no-pers-confs-exist . "Det finns inga mten eller personer i databasen.\n")
    (list-confs-created-by . "Lista gda mten fr: ")
    (listing-confs-created-by . "gda mten fr %#1P\n\
    S=Skapat, O=Organisatr, M=Brevlda som supermte; S=Slutet, H=Hemligt\n")
    (list-pers-confs-created-by . "Lista gda mten (med brevldor) fr: ")
    (getting-all-confs . "Hmtar en lista av alla mten frn servern...")
    (getting-all-pers-confs . "Hmtar en lista av alla personer och mten frn servern...")
    (getting-all-confs-done . "Hmtar en lista av alla mten frn servern...klart")
    (getting-all-pers-confs-done . "Hmtar en lista av alla personer och mten frn servern...klart")
    (finding-created-confs . "Sker gda mten (%#1d av %#2d klart)")
    (finding-created-pers-confs . "Sker gda mten (med brevldor) (%#1d av %#2d klart)")
    (no-created-confs . "%#1P r inte skapare, organisatr eller supermte fr ngot mte.\n")

    (name-to-be-changed . "Ange det namn som skall ndras: ")
    (no-such-conf-or-pers . "Mtet eller personen finns ej.\n")
    (new-name . "Nytt namn: ")
    (new-paren . "Ny parentes: ")
    (no-paren-in-name . "Namnet innehller ingen parentes.\n")
    (who-to-change-supervisor-for . "Vem vill du ndra organisatr fr? ")
    (new-supervisor . "Ny organisatr: ")
    (text-to-mark . "Vilket inlgg vill du markera? ")
    (text-to-unmark . "Vilket inlgg vill du avmarkera? ")
    (what-mark . "Vilken typ av markering vill du stta (namn eller 0-255)? ")
    (erroneous-mark . "Felaktig markeringstyp.\n")
    (want-to-create-symbolic-mark . "Markeringstypen \"%#1s\" finns inte. Vill du skapa den? ")
    (creating-symbolic-mark-type . "Skapar markeringstypen \"%#1s\" (%#2d).\n")
    (no-mark-types-left . "Ledsen, det finns inga lediga markeringstyper. Rensa bland de gamla frst.")
    (unmarking-textno . "Avmarkering av text %#1n...")
    (marking-textno . "Markering av text %#1n...")
    (list-which-mark . "Lista vilken markeringstyp (namn eller 0-255, RET fr alla)? ")

    (new-passwd-again . "Mata in det nya lsenordet igen fr kontroll: ")
    (what-mark-to-view . "terse vilken markeringstyp (namn eller 0-255, RET fr alla)? ")
    (whos-passwd . "Vem vill du ndra lsenord fr? (dig sjlv) ")
    (old-passwd . "Mata in ditt nuvarande lsenord: ")
    (new-passwd . "Mata in det nya lsenordet: ")
    (changing-passwd . "ndrar lsenordet...")
    (retype-dont-match . "Lsenorden r inte samma. Gr om.\n")
    (palindrome . " (en palindrom!)")
    (lyskom-name . "Anvndare")
    (is-in-conf . "Nrvarande i mte")
    (from-machine . "Kr frn")
    (is-doing . "Gr")
    (connection-time . "Loggade in")
    (active-last . "Aktiv senast")
    (active . "Aktiv")
    (lyskom-client . "Klient")
    (text-to-add-recipient . "Vilket inlgg vill du addera mottagare till:")
    (text-to-add-copy . "Vilket inlgg vill du addera en extra kopia till:")
    (text-to-add-bcc . "Vilket inlgg vill du skicka som dold kopia:")
    (text-to-delete-recipient . "Vilket inlgg vill du subtrahera mottagare frn:")
    (text-to-move . "Vilket inlgg vill du flytta:")
    (text-tree-to-move . "Vilket inlggs r rot till trdet vill du flytta:")
    (text-to-add-comment-to . "Vilket inlgg vill du addera en kommentar till:")
    (text-to-delete-comment-from . "Vilket inlgg vill du subtrahera en kommentar frn:")
    (text-to-add-footnote-to . "Vilket inlgg vill du addera en fotnot till:")
    (text-to-delete-footnote-from . "Vilket inlgg vill du subtrahera en fotnot frn:")
    (text-to-add-cross-reference-to . "Vilket inlgg vill du addera en referens till:")
    (text-has-no-recipients-r . "Inlgg %#1n har inga mottagare\n")

    (where-on-list-q . "Placering p listan? (0-%#1d) ")
    (member-in-conf . "Bli medlem i %#1M...")
    (add-member-in . "Addera %#1P som medlem i %#2M...")
    (change-priority-for-q . "ndra prioritet fr mte: ")
    (change-priority-for . "ndra prioritet p %#2M...")
    (unsubscribe-to . "Uttrda ur %#1M...")

    (exclude-from . "Utesluta %#1P frn %#2M...")

    (unsubscribe-failed . "\nDet gick inte. %#1P var kanske aldrig medlem i %#2M?\n")
    (passivate-done . "Du r nu passiv medlem i %#1M.
Uttrd ur mtet en gng till fr g ur helt.\n")

    (You . "Du")
    (could-not-create-conf . "Mtet \"%#1s\" kunde ej skapas.\n")
    (created-conf-no-name . "Mte nummer %[%#3@%#1:m %#2:M%], skapat.\n")
    (cant-read-textno . "Du fr inte lsa text %#1:n.\n")

    (not-supervisor-for . "Du r inte organisatr fr %#1M.\n")
    (not-supervisor-for-server . "Du r inte administratr fr LysKOM-servern.\n")
    (go-to-conf . "G till %#1M.\n")
    (cant-go-to-his-mailbox . "Du fr inte g till %#1Ms brevlda.\n")
    (not-member-of-conf . "Du r inte medlem i %#1M.\n")
    (about-to-change-name-from . "%#1M\n")
    (change-name-done . "Klart. Nytt namn: %[%#2@%#1:M%].\n")
    (change-name-nope . "Det gick inte bra att ndra till %#1s.\nFelkod %#3d. %#2s.\n")
    (change-supervisor-from-to . "ndra organisatr fr %#1M till %#2P...")
    (change-supervisor-nope . 
			    "\nDet gick inte. Kanske du inte fr ndra organisatr fr %#1M?\n")
    
    (no-marked-texts . "Du har inga markerade inlgg.\n")
    (no-marked-texts-mark . 
			  "Du har inga markerade inlgg med markeringstypen \"%#1s\".\n")

;;; For later
;    (northward . "norrut")
;    (southward . "sderut")
;    (permanent-sundown . "Solen kommer inte att g upp. Flytta %#1s!")
;    (permanent-sunup . "Solen kommer inte att g ned. Flytta %#1s!")
;    (sunup-soon . "Solen gr snart upp")
;    (sundown-recently . "Solen gick nyligen ned")
;    (after-sunset . "Solen har gtt ned")
;    (before-sunup . "Solen har inte gtt upp nnu")
;    (sun-is-up . "Solen r uppe")
;;;
    (weekdays . ["sndag" "mndag" "tisdag" "onsdag" "torsdag"
		 "fredag" "lrdag" "sndag"])
    (weekdays-short . ["sn" "mn" "tis" "ons" "tor" "fre" "lr" "sn"])
    (time-is . "Det r %#1s%#2s (enligt servern).")
    (time-is-week . "Det r %#1s%#2s, vecka %#3d (enligt servern).")

    (xmaseve . "\nJulafton! Har du ppnat dina julklappar n?")
    (xmasday . "Juldagen.\nDu har vl varit i julottan?")
    (newyearday . "Nyrsdagen. Gott nytt %#1d!")
    (newyearevelate . "Mindre n en timme kvar av %#1d...")
    (newyeareve . "Nyrsafton.")
    (cgdag . "Valborgsmssoafton.\nKonungens fdelsedag.")
    (sixjune . "Sveriges nationaldag och svenska flaggans dag.")
    (holdnose . "Hll fr nsan...")
    (lysbday . "
P denna dag, r 1973, grundades Lysator, och det var en stor dag
i svensk datorhistoria. Ls mer p http://www.lysator.liu.se/history/")
    (13dayxmas . "Trettondedag jul (\"Trettondagen\").")
    (20dayxmas . "Tjugondedag jul (\"Tjugondag Knut\").")
    (kyndeldag . "Kyndelsmssodagen.")
    (skottdag . "Skottdagen.")
    (intwomday . "Internationella kvinnodagen.")
    (mariebdag . "Marie bebdelsedag.\nFram med vffeljrnet!")
    (johannesddag . "Johannes Dparens dag.")
    (fnday . "FN-dagen.")
    (allhelgonadag . "Allhelgonadagen.")
    (varnlosdag . "Vrnlsa barns dag.")

    (total-users . "    Sammanlagt %#1d anvndare (%#2s).\n")
    (total-users-sans-date . "    Sammanlagt %#1d anvndare\n")
    (total-visible-users . "    Sammanlagt %#1d synlig%#1?d%[%]%[a%] anvndare (%#2s).\n")
    (total-active-users . "    Sammanlagt %#1d aktiv%#1?d%[%]%[a%] anvndare (%#2s).\n")
    (total-visible-active-users
     . "    Sammanlagt %#1d synlig%#1?d%[%]%[a%] aktiv%#1?d%[%]%[a%] anvndare (%#2s).\n")
    (client-statistics . "    Klienternas frdelning:\n")
    (client-statistics-line . "    %4#2d %#1s")
    (who-to-add-q . "Vilket mte/person vill du addera som mottagare? ")
    (who-to-add-copy-q . "Vilket mte/person vill du addera som kopiemottagare? ")
    (who-to-add-bcc-q . "Vilket mte/person vill du addera som mottagare av en dold kopia? ")
    (really-add-as-recpt-q . "Skall framtida kommentarer till inlgget ocks skickas till %#1M? ") 
    (who-to-sub-q . "Vilket mte/person vill du subtrahera som mottagare? ")
    (who-to-move-from-q . "Frn vilket mte vill du flytta texten? ")
    (who-to-move-to-q . "Vart vill du flytta texten? ")
    (who-to-move-to-or-sub-q . "Vart vill du flytta texten (tomt fr att bara subtrahera)? ")

    (adding-name-as-recipient . "Adderar %#1M som mottagare till text %#2n...")
    (adding-name-as-copy . "Adderar %#1M som kopiemottagare till text %#2n...")
    (remove-name-as-recipient .
			      "Subtraherar %#1M som mottagare frn text %#2n...")
    (adding-cross-reference . "Adderar referens...")

    (error-recipient-limit . "Text %#1n har fr mnga mottagare.\n")
    (error-already-recipient . "%#2M r redan mottagare till inlgg %#1n.\n")
    (error-permission-denied-add-recpt . "Bara frfattaren till %#1n eller organisatren fr %#2M kan ndra mottagartyp.\n")
    (error-permission-denied-sub-recpt . "Bara frfattaren till %#1n eller organisatren fr %#2M kan subtrahera mottagare.\n")
    (error-access-denied-add-recpt . "Du fr inte addera inlgg till %#2M.\n")
    (error-not-recipient . "%#2M r inte mottagare till inlgg %#1n.\n")

    (moving-tree-what-action-q . "Vad vill du gra? (flytta) ")
    (moving-name . "Flyttar text %#3n frn %#1M till %#2M...")
    (moving-already-moved . "Inlgg %#1n har inte %#2M som mottagare.\nFlyttar inte inlgget eller dess kommentarstrd.\n")
    (text-to-add-q . "Vilket inlgg vill du addera som kommentar till %#1n? ")
    (text-to-remove-q . "Vilket inlgg vill du subtrahera som kommentar frn %#1n? ")
    (text-to-add-footn-q . "Vilket inlgg vill du addera som fotnot till %#1n? ")
    (text-to-remove-footn-q . "Vilket inlgg vill du subtrahera som fotnot frn %#1n? ")
    (add-comment-to . "Adderar text %#1n som kommentar till text %#2n...") ;
    (sub-comment-to . "Subtraherar text %#1n som kommentar till text %#2n...")
    (add-footnote-to . "Adderar text %#1n som fotnot till text %#2n...") ;
    (sub-footnote-to . "Subtraherar text %#1n som fotnot till text %#2n...")
    (comment-keep-recpt-p ."Ska %#1s vara mottagare? ")
    (comment-all-relevant-p . "Inlgget har flera mottagare. r alla relevanta? ")
    (please-edit-recipients . "ndra mottagarlistan och skicka in inlgget igen.")
    (checking-rcpt . "Kontrollerar mottagare...")
    (checking-rcpt-done . "Kontrollerar mottagare...klart")
    (checking-comments . "Kontrollerar kommenterade texter...")
    (checking-comments-done . "Kontrollerar kommenterade texter...klart")
    (please-check-commented-texts . "terse de kommenterade texterna och deras kommentarer.")
    (have-unread-comment . "Skicka in trots olsta kommentarer till text %#1n? ")
    (duplicate-recipients . "Kan inte skicka in texten. En mottagare frekommer flera gnger (%#1M)")
    (no-recipients . "Kan inte skicka in texten. Inga mottagare har angivits.")

    (add-recipient-p . "Addera mottagare %#2?b%[ %#2M fr att n%]%[%] %#1P? ")
    (matching-regexp . "Mten/personer som matchar '%#1s'\n")
    (matching-regexp-perss . "Personer som matchar '%#1s'\n")
    (matching-regexp-confs . "Mten som matchar '%#1s'\n")

    (who-is-active-all . "Visar alla sessioner.\n")
    (who-is-active-last-minutes . "Visar alla sessioner som har varit aktiva de senaste %#1d minuterna.\n")
    (showing-invisibles . "Visar osynliga sessioner.\n")
    (null-who-info . "Det finns inga (aktiva) inloggade.\n")

    (no-other-lyskom-r . "Det finns inga fler aktiva LysKOM-sessioner.\n")
    (no-lyskom-session . "Det finns ingen aktiv LysKOM-session.")
    (no-other-unread-lyskom-r . "Hittar ingen annan LysKOM-session med olsta.\n")
    (no-unread-lyskom-r . "Hittar ingen aktiv LysKOM-session med olsta.\n")
    (no-unread-lyskom . "Hittar ingen aktiv LysKOM-session med olsta.")

    (who-is-on-in-what-conference . "Vilka i vilket mte: ")
    (who-is-present-in-what-conference . "Vilka nrvarande i vilket mte: ")
    (who-is-friend . "Visar endast vnner.\n")
    (who-is-active-and-member . "Visar endast medlemmar i %#1M.\n")
    (who-is-active-and-present . "Visar endast medlemmar nrvarande i %#1M.\n")

    (personal-comment-to-anonymous . "Det gr inte att skriva ett personligt svar p ett anonymt inlgg.\n")

    ;; From commands2.el:

    (your-memberships . "Ditt medlemskap i olika KOM-mten:\n")
    (memberships-header . "Senast inne	   Prio	Olsta	Mtesnamn\n")
    (memberships-line . "%16#1s  %#2d\t%#3d\t%#4M\n")
    (conf-for-status . "Vilket mte vill du se statusen fr? ")
    (no-such-conf . "Mtet finns ej.\n")
    (status-record . "Status fr mte %#1M (%#1m) %#2s\n\n")
    (change-type-prompt . "ndra mtestyp fr mte %#1M (%#1m) (%#2s)...")
    (Mailbox . "Brevlda")
    (Protected . "Hemligt")
    (no-comments . "original")
    (closed . "slutet")
    (allow-anon . "anonymt ok")
    (allow-secret . "hemliga medl")

    (created-by . "Skapat av person %25#1p %#3s(%#2P)\n")
    (created-at . "Skapad:%35#1s\n")
    (members .    "Antal medlemmar: %25#1d\n")
    (conf-allows-secret-members . "Hemliga medlemmar:                       %#1s\n")
    (conf-allows-anon-texts .     "Anonyma inlgg:                          %#1s\n")
    (anon-texts-permitted . "Anonyma inlgg r tilltna")
    (anon-texts-not-permitted . "Anonyma inlgg r inte tilltna")
    (secret-members-permitted . "Hemliga medlemmar r tilltna")
    (secret-members-not-permitted . "Hemliga medlemmar r inte tilltna")
    (garb-nice . "Livslngd p inlgg (dagar):%14#1d\n")
    (lowest-local-no . "Lgsta existerande lokala nummer: %8#1d\n")
    (highest-local-no . "Hgsta existerande lokala nummer: %8#1d\n")
    (last-text-time . 
		    "Tid fr senaste inlgg: %18#1s (str det i din cache)\n")
    (no-of-motd . "Lapp p drren i text nummer: %12#1n\n")
    (superconf-is-no-name . "Supermte:       %25#1m %#3s(%#2M)\n")
    (permitted-submitters-no-name . "Tilltna frfattare:%22#1m %#3s(%#2M)\n")
    (supervisor-is-no-name . "Organisatr:     %25#1p %#3s(%#2P)\n")
    (presentation-no . "Presentation:    %25#1n\n")
    (conf-mship-priority . "Prioritet:       %25#1n%#2?b%[ %#2s%]%[%]\n")
    (conf-has-motd . "\n%#1M har en lapp p drren:\n")
    (status-conf-generic . "%-40#1s %#2s\n")
    (status-aux-item .   "Oknd tillggsinformation: %15#1s%#3s (skapad av %#2M)\n")
    (conf-mx-list-name . "Importerad mailinglista:                 %#1s %#2s\n")
    (recommended-conf-aux . "Rekommenderat mte:                      %#1M <%#1m> %#2s\n")
    (status-read-faq-aux-item . "Lst FAQ:                 %15#2n fr %#1?z%[%#1M <%#1m>%]%[servern%] %#3s\n")
    (status-rejected-recommendation-aux-item . "Avvisad mtesrekommendation:            %#1M %#2s\n")
    (status-send-comments-to . "Dirigera om kommentarer till:           %#1M <%#1m> %#2s\n")

    (Everybody . "Alla")
    (show-members-list-also-q . "Vill du se medlemslistan ocks? ")
    (show-membership-info-q . "Visa antalet olsta? ")
    (conf-has-these-members . "\n%#1M har fljande medlemmar:\n")
    (conf-has-no-members . "\n%#1M har inga medlemmar.\n")
    (member-list-header . "Senast inne          Osett  Namn\n\n")
    (secret-membership . "*** Hemlig rad ***\n")
    (conf-membership-line . "%#1s%#2M %#3s\n")
    (conf-membership-line-2 . "                            Adderad %#1s av %#2P\n")
    (pers-for-status . "Vem vill du se statusen fr? ")
    (text-to-see-author-status-of . "Vilken texts frfattare vill du statusen fr? ")
    (no-such-pers . "Det finns ingen sdan person.\n")
    (pers-status-record . "Status fr person %#1P (%#1p)\n")
    (created-time .  "Skapad:%34#1s\n\n")
    (created-confs . "Skapade mten:%27#1d\n")
    (created-persons . "Skapade personer:%24#1d\n")
    (created-texts . "Skapade texter:%26#1d\n")
    (created-lines . "Skapade rader:%27#1d\n")
    (created-chars . "Antal skapade tecken:%20#1d\n")
    (no-of-sessions . "Antal sessioner:%25#1d\n")
    (present-time-d-h-m-s . "Nrvarotid:%19#1d d %02#2d:%02#3d:%02#4d\n")
    (last-log-in . "Senaste in-/utloggning:%18#1s\n")
    (user-name . "Anvndare: %30#1s\n")

    (read-texts . "Lsta texter:%28#1d\n")
    (marked-texts . "Markerade texter:%24#1d\n")
    (time-for-last-letter . "Tid fr senaste brev:%20#1s (str det i din cache)\n")
    (superconf . "Supermte:%31#1m %#3s(%#2M)\n")
    (supervisor . "Organisatr:%29#1p %#3s(%#2P)\n")
    (member-of-confs . "Medlem i (antal mten):%18#1d\n")
    (presentation . "Presentation:    %24#1n\n")
    (show-membership-list-also-q . "Vill du se vilka mten personen r medlem i ocks? ")
    (not-allowed-see-confs . "%#1P r inte medlem i ngra mten.\n")
    (is-member-of . "\n%#1P r medlem i fljande mten:\n")
    (membership-list-header . "Senast inne           Osett  Namn\n\n")
    (pers-membership-line . "%#1s%#2s%#3M %#4s\n")
    (pers-membership-line-2 . "                             Adderad %#1s av %#2P\n")
    (is-supervisor-mark . "O ")
    (who-to-send-message-to . "Vem vill du skicka meddelandet till? (%s) ")
    (send-empty-message-p . "Meddelandet r tomt. Vill du nd skicka det? ")
    (his-total-unread . "\n%#1M har totalt %#2d olsta.\n")
    (message-prompt . "Meddelande: ")
    (message-sent-to-user . "\
%[%#3$\
================================================================
%]%[%#4$\
Ditt meddelande till %#2M:

%#1t
%]%[%#3$\
----------------------------------------------------------------
%]")
    (message-sent-to-all . "\
%[%#3$\
================================================================
%]%[%#4$\
Ditt alarmmeddelande ld:

%#1t
%]%[%#3$\
----------------------------------------------------------------
%]")
    (message-sent-to-user-long . "\
%[%#3$\
===============================================================================
%]%[%#4$\
Ditt meddelande till %#2M:

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-sent-to-all-long . "\
%[%#3$\
===============================================================================
%]%[%#4$\
Ditt alarmmeddelande ld:

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-use-alarm-instead . "Anvnd kommandot %#1s fr att skicka alarmmeddelanden.\n")
    (message-all-info . "Snd alarmmeddelande\n")
    (message-recipient-info . "Snd meddelande till %#1M\n")
    (message-nope
     . "Du kunde inte skicka meddelandet. Mottagaren var kanske inte inloggad.
Meddelandet du frskte snda till %#1M var:
%#2t\n")
    (only-last . "Endast lsa senaste (0 - %#1d) i %#2s: ")
    (only-error . "Ngot gick galet. Ledsen.\n")

    (you-have-unreads . "Du har %#1d olst%#1?d%[%]%[a%] inlgg i %#2M\n")
    (you-have-unreads-special . "Du har %#1d okommentera%#1?d%[t%]%[de%] inlgg i %#2M\n")
    (you-have-no-unreads . "Du har inget olst i %#1M\n")
    (you-have-read-everything . "Du har sett alla nyheter.\n")
    (no-unreads-shown . "Hittade inga mten som matchade det kriteriet.\n")
    (total-unreads . "Du har totalt %#1d olst%#1?d%[%]%[a%] inlgg i %#2d mte%#2?d%[%]%[n%].\n")
    (shown-unreads . "Visade %#1d olst%#1?d%[%]%[a%] inlgg i %#2d mte%#2?d%[%]%[n%].\n")
    (list-unread-with-n-unread . "Visar endast mten med minst %#1d olsta.\n")
    (list-unread-with-at-most-n-unread . "Visar endast mten med som mest %#1d olsta.\n")
    (waiting-for-anything .
			  "Du vntar p ett inlgg i vilket mte som helst.\n")
    (waiting-higher-than . 
			 "Du vntar p ett inlgg i ett mte med hgre prioritet n %#1d.\n")

    (have-to-be-in-conf-with-unread . "Du mste g till ett icketomt mte frst.\n")
    (Texts . "Inlgg")
    (Written . "Skrivet")
    (Lines . "Rader")
    (Author . "Frfattare")
    (Subject . "rende")
    (mark-type . "Typ")
    (could-not-read . "Du fick inte lsa denna text (%#1n).\n")
    (multiple-choice . "Flera alternativ finns.")
    (does-not-exist . "Detta kommando finns inte.")
    (summary-line . "%=-8#1n%#2s%4#3d  %[%#4@%#5:P%]  %[%#6@%#7r%]\n")
    (diff-what-text-old . "Gammal text att jmfra: ")
    (diff-what-text-new . "Ny text att jmfra: ")


    ;; Only people fixing bugs or receiving bug reports should
    ;; change these:
    (buggreport-compilestart . "Skapar buggrapporten...")
    (buggreport-compileend . "Skapar buggrapporten...klart")
    (buggreport-description . "Detta gjorde jag:
\(Fyll i dina kommentarer nedan\)\n================\n\n
================
Bland informationen nedan finns ocks en lista p de 100 sist tryckta
tangenterna i din emacs. Om du nyligen loggat in kan den innehlla ditt
lyskomlsenord. Titta igenom den och ndra det som r ditt lsenord
till * * * eller m i t t l  s e n eller ngot annat lmpligt.

Nr du skrivit klart skall du skicka in din buggrapport till LysKOMs
elispklientutvecklare. Det sker antingen:
* med email till bug-lyskom@lysator.liu.se
* med vanligt brev till:
\tLysator
\tc/o ISY
\tLinkping University
\tS-581 83 Linkoping
\tSWEDEN.

Mrk kuvertet \"LysKOM buggrapport fr elispklienten\".\n\n")
    
    (buggreport-internals . "LysKOMs interna information:\n\n")
    (buggreport-version . "lyskom-version:")
    (buggreport-emacs-version . "emacs-version:")
    (buggreport-system-id . "system-id:")
    (buggreport-ctl-arrow-doc . "ctrl-doc:")
    (buggreport-unparsed . "\nlyskom-unparsed-buffer:")
    (buggreport-command-keys . "Nyss tryckta tangenter:")
    (buggreport-backtrace . "\n*Backtrace*:\n%#1s\n")
    (buggreport-communications . "\nlyskom-debug-communications-to-buffer-buffer:")
    (buggreport-all-kom-variables . "\n\nAndra variabler:\n***** *********")
    (buggreport-instead-of-byte-comp . "byte-code(\"byte-string\"")
    (buggreport-subject . "Bugg-rapport elisp-klienten version %#1s")


    (not-logged-in . "Du r inte inloggad.  ")

    ;; Used for kom-is-person-member-of-conference:
    (pers-to-check-mship-for . "Vems medlemskap vill du underska? ") ;-)
    (conf-to-check-mship-of . "...i vilket mte? ")
    (conf-is-empty . "Mtet %#1M r tomt.\n")
    (pers-is-member-of-conf . "Ja, %#1P r medlem i mtet %#2M.\n")
    (pers-is-passive-member-of-conf . "Nja, %#1P r bara passiv medlem i mtet %#2M.\n")
    (pers-is-not-member-of-conf . "Nej, %#1P r inte medlem i mtet %#2M.\n")

    ;; +++ cant seem to find where these are used:
    (name-is-not-in-conf . "%#1s r inte nrvarande i ngot mte.\n")
    (name-is-in-conf . "%#1s r nrvarande i\n%#2s\n")
    (connected-during . "Uppkopplingstid: %#1d sekunder.\n")
    ;; +++


    (conf-to-set-permitted-submitters-q . "Vilket mte vill du stta tilltna frfattare fr? ")
    (conf-to-set-super-conf-q . "Vilket mte vill du stta supermte fr? ")
    (new-super-conf-q . "Vilket mte vill du ha som supermte? ")
    (new-permitted-submitters-q . "Mte med tilltna frfattare till %#1s? (alla) ")
    (super-conf-for-is . "ndra supermte fr %#1M till %#2M...")
    (permitted-submitters-removed-for-conf . "Tillt alla frfattare i mte %#1M...")
    (submitters-conf-for-is . "ndra tilltna frfattare fr mte %#1M till\nmedlemmarna i %#2M...")

    (conf-to-set-garb-nice-q . "Vilket mte vill du stta livslngd fr? ")
    (new-garb-nice-q . "Vilket vrde vill du stta livslngden till? ")
    (garb-nice-for-is . "ndra livslngden fr %#1M till %#2d...")

    (really-shutdown . "r du sker p att du vill stnga av servern? ")
    (closing-server . "Stnga av servern...")
    (really-sync . "r du sker p att du vill spara databasen? ")
    (syncing-server . "Spara databasen...")
    (administrator . "administratr")
    (no-longer-administrator . "en normal anvndare igen")
    (you-are-now . "Ok, du kr nu som %#1s.\n")
    (setting-motd . "Stter loginmeddelandet till text %#1n.\n")
    (set-motd-success . "Du har satt ett nytt loginmeddelande.\n")
    (set-motd-failed . "Det gick inte. Du var kanske inte administratr.\n")
    (removing-motd . "Tar bort loginmeddelandet.\n")
    (removed-motd . "Du har tagit bort loginmeddelandet.\n")
    (who-to-throw-out . "Vems session vill du kasta ut? ")
    (throwing-out . "Kastar nu ut session %#1d... ")
    (postpone-prompt . "Hur lite vill du lsa nu? ")
    (set-session-priority . "Stt lsniv: ")

    ;; From review.el:
    (no-review-done . "Du mste terse innan du kan terse mer.\n")
    (not-reviewing . "Du hller inte p att terse ngot nu.\n")
    (review-how-many . "terse hur mnga?")
    (review-how-many-more . "terse ytterligare hur mnga?")
    (latest-n . "senaste %#1d")
    (first-n . "frsta %#1d")
    (info-by-whom . "%#1s av vem: ")
    (info-to-conf . "%#1s till mte: ")
    (all-confs . "alla mten")
    ;; +++ not used?
    (info-by-to . "%#1s av %#2P till %#3M framt.")
    (no-get-conf . "Du fr inte hmta mtet.\n")
    (no-get-pers . "Du fr inte hmta personen.\n")
    (no-review-info . "Ej tilltet terse %#1s\n")
    ;; +++
    (review-info . "terse %#1s")
    (review-info-by-to . "terse %#1s av %#2P till %#3M framt.\n")
    (review-more-info-by-to . "terse %#1s av %#2P till %#3M framt.\n")
    (review-rest . "resten")
    (review-more . "nsta %#1d")
    (you-review . "Du terser nu %#1s.\n")
    (read-text-first . "Du mste lsa en text frst.\n")
    (cannot-read-last-text . "Du kan inte lsa den senast lsta texten.\n")
    (review-n-texts . "terse %#1d inlgg.\n")
    (review-marked . "terse %#1d markerade.\n")
    (review-text-no . "terse text nummer %#1n\n")
    (review-many-comments . "terse %#2?d%[en%]%[%#2d%] kommentar%#2?d%[%]%[er%] till inlgg %#1n.\n")
    (view-many-comments . "Ls %#2?d%[en%]%[%#2d%] kommentar%#2?d%[%]%[er%] till %#1n.\n")
    (view-texts-in-conf . "Totalt %#1d inlgg att lsa i %#2M.\n")
    (not-reading-anywhere . "Du lser inte i ngot mte.\n")
    (read-normally-read . "Hur mnga vill du se igen? ")

    (review-conf-gone . "Mtet finns inte.\n")
    (review-pers-gone . "Personen finns inte.\n")
    (review-cant-read-conf . "Du kan inte terse inlgg till ett slutet mte du inte r med i.\n")
    (review-cant-read-letterbox . "Du kan inte terse inlgg till ngon annans brevlda.\n")
    (review-cant-read-empty . "Mtet r tomt.\n")
    (cant-review-everything . "Du kan inte terse alla texter i LysKOM.\n")

    (more-than-one-root . "Inlgg %#1n har mer n ett urinlgg.\n")
    (more-than-one-root-review . 
"Inlgg %#1n har mer n ett urinlgg, men endast ett trd kommer att visas.\n")

    ;; From edit-text.el:
    (press-C-c-C-c . "Tryck C-c C-c fr att skicka in texten.")
    (recipient . "Mottagare")
    (carbon-copy . "Extra kopia")
    (blank-carbon-copy . "Dold kopia")
    (recipient-prefix . "[Mm]")
    (carbon-copy-prefix . "[Ee]")
    (blank-carbon-copy-prefix . "[Dd]")
    (add-recipient . "Addera mottagare")
    (add-recipient-or-xref . "Addera...")

    (secret-aux-flag . "hemlig")
    (anonymous-aux-flag . "anonym")
    (inherit-aux-flag  . "rvd")
    (aux-item-prefix . "[*]")
    (aux-item-prefix-regexp . "\\[\\*\\]\\s-*")
    (comment-item-prefix . "#\\s-*")
    (text-no-comment . "%#1d %#2s /%#3d rad%#3?d%[%]%[er%]/ %#4P %#5?b%[ [anonymt]%]%[%]\n")
    (cant-fcc-text-file-error . "Kan inte spara inlgg %#1n till \"%#2s\" (%#3s: %#4s).\n")
    (cant-fcc-text . "Kan inte spara inlgg %#1n till \"%#2s\" (%#3s).\n")

    (header-subject . "rende: ")
    (header-separator . "\\<lyskom-edit-mode-map>\
--- Skriv nedan. \
Skicka in=\\[kom-edit-send], \
Avbryt=\\[kom-edit-quit], \
Annat se \\[describe-mode] ---")
    (text-mass . "%#4s%#1s\n%#2s\n%#3s")
    (comment-to-by . "%#1s till text %#2n%#3s.\n")
    (already-sent . "Du har redan skickat denna text en gng. Snd nd? ")
    (subject . "rende: ")
    (subject-prefix . "[\\{\\[]")
    (enter-subject-idi . "Skriv ett rende.")
    (which-text-include . "Vilken text skall vi inkludera? ")
    (added-recipient . "Mottagare som skall adderas: ")
    (added-carbon-copy . "Extra kopia till mte: ")
    (added-blank-carbon-copy . "Dold kopia till: ")
    (text-to-comment-q . "Vilket inlgg vill du kommentera? ")
    (conf-has-motd-no . "Mtet har en lapp p drren. (%#1d)\n\n%#2s")
    (still-want-to-add . "Vill du fortfarande addera mtet? ")
    (could-not-create-text . "\nTexten kunde ej skapas. %#2s.\n")
    (no-get-text . "Du fick inte hmta texten.")
    (unknown-header . "Oknd information p raden")
    (transform-error . "Skicka in oformatterat (%#1s)? ")
    (cant-find-info-node . "Hittar inte info-bufferten")

    (link-type . "Vad vill du lnka till (inlgg, mte eller person)? ")
    (which-text-to-link . "Lgg in lnk till text nummer: ")
    (which-text-to-link-err . "Hittar inte texten. Lgg in lnk till text nummer: ")
    (which-pers-to-link . "Lgg in lnk till person: ")
    (which-conf-to-link . "Lgg in lnk till mte: ")

    ;; From view-text.el:
    (view-text-first-line . "%#7$%#2@%#1n %#3s /%#4d rad%#4?d%[%]%[er%]/ %#5P%#6?b%[%#6s%]%[%]\n")

    (marked-by-you . "Markerad av dig (typ: %#1s).\n")
    (marked-by-you-and-others . "Markerad av dig (typ: %#2s) och %#1?d%[ngon annan%]%[%#1d andra%].\n")
    (marked-by-several . "Markerad av %#1d person%#1?d%[%]%[er%].\n")

    (timeformat-day-yyyy-mm-dd-hh-mm-ss . "%#7s %4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm-ss . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d")
    (timeformat-yyyy-mm-dd . "%4#1d-%02#2d-%02#3d")
    (timeformat-hh-mm-ss . "%02#4d:%02#5d:%02#6d")
    (timeformat-hh-mm . "%02#4d:%02#5d")

    (format-time-date-and-time . "%#1s %#2s")
    (format-time-just-date . "%#1s")
    (format-time-just-time . "%#2s")
    (today . "idag")
    (yesterday . "igr")

    (no-such-text-no . "Det finns inget sdant inlgg. (%#1:n)\n")
    (text-created-at . "Skapad: %#1s\n")
    (text-imported-at . "Importerad: %#1s\n")
    (text-imported-at-by . "Importerad: %#1s av %#2P\n")

    (head-Subject . "rende: ")
    (Recipient . "Mottagare")
    (Extra-recipient . "Extra kopia")
    (Hidden-recipient . "Dold kopia")
    (mx-Recipient . "Extern mottagare")
    (mx-Extra-recipient . "Extern kopiemottagare")
    (mx-Extern-reply-to . "Externa svar till")
    (Strange-recipient . "Underlig mottagare")
    (send-at . "    Snt:     %#1s\n")
    (sent-by . "    Snt av %#1P\n")
    (received-at . "    Mottaget: %#1s\n")

    (comment-to-text . "Kommentar till text %#1n")
    (footnote-to-text . "Fotnot till text %#1n")
    (comment-in-text . "Kommentar i text %#1n")
    (footnote-in-text . "Fotnot i text %#1n")

    (comment-to-text-by . "Kommentar till text %#1n av %#2P")
    (footnote-to-text-by . "Fotnot till text %#1n av %#2P")
    (comment-in-text-by . "Kommentar i text %#1n av %#2P")
    (footnote-in-text-by . "Fotnot i text %#1n av %#2P")

    (attachment-to-text . "Bilaga %#3still text %#1n")
    (attachment-in-text . "Bilaga %#3si text %#1n")
    
    (envelope-sender . "Snt av: %#1s\n")
    (attachment-filename . "Bilagans filnamn: \"%#1s\"\n")

    (written-by . " av %#1P\n")

    ;; From async.el:

    (name-has-changed-to-name . "%#1:P har nu bytt namn till %#2:P")
    (name-has-changed-to-name-r . "%[%#3@%#1:P%] har nu bytt namn till %[%#3@%#2:P%]\n")
    (you-changed-name-to . "Nu har du bytt namn till %[%#2@%#1:P%].\n")
    (database-sync . "Databasen synkas.")

    (lyskom-is-full . "\
===========================================================
Meddelande frn LysKOM-systemet: Ngon frskte koppla upp,
men misslyckades eftersom alla tillgngliga frbindelser r
upptagna. Logga ut och kom tillbaks senare om du vntar nu.
===========================================================\n")
    (lyskom-is-full-long . "\
===============================================================================
Meddelande frn LysKOM-systemet: Ngon frskte koppla upp,
men misslyckades eftersom alla tillgngliga frbindelser r
upptagna. Logga ut och kom tillbaks senare om du vntar nu.
===============================================================================
")
    (has-entered . "Nu har %#1:P gtt in i %#2s.")
    (has-entered-r . "%#2@Nu har %#1P gtt in i %#3s.\n")
    (has-left . "Nu har %#1:P gtt ur %#2s.")
    (has-left-r . "%#2@Nu har %#1P gtt ur %#3s.\n")
    (Unknown . "Oknd")
    (unknown . "oknd")
    (Unknown2 . "Oknt")
    (unknown-person . "Oknd person")

    (no-longer-member . "Du r inte lngre medlem i %#1M.\n")
    (no-longer-member-n . "Du r inte lngre medlem i mte %#1m (finns inte).\n")

    (have-become-member . "Du har blivit medlem i %#1M.\n")
    (have-become-invited-member . "Du har bjudits in till %#1M.
G till mtet fr att acceptera eller tacka nej till inbjudan. Du kan ven
anvnda kommandot 'Bli medlem i mte' fr att acceptera inbjudan.\n")
    (have-become-passive-member . "Du har blivit passiv medlem i %#1M.\n")

    (message-broadcast . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Alarmmeddelande frn %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-broadcast-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Alarmmeddelande frn %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Personligt meddelande frn %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-from-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Personligt meddelande frn %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from-to . "\
%[%#5$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$\
Gruppmeddelande till %#3M\nfrn %#2P (%#4s):

%#1t
%]%[%#5$\
----------------------------------------------------------------
%]")
    (message-from-to-long . "\
%[%#5$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$\
Gruppmeddelande till %#3M\nfrn %#2P (%#4s):

%#1t
%]%[%#5$\
-------------------------------------------------------------------------------
%]")
    (text-is-created . "Text %#1n r skapad!")

    ;; Used in mode-line-process
    (mode-line-waiting . ": vntar")
    (mode-line-working . ": arbetar")
    (mode-line-saving . ": sparar")
    (mode-line-down . ": nerkopplad")

    ;; From completing-read.el:
	   
    (person-or-conf-no-regexp . "\\`[ \t]*[mpMP]\\w*[ \t]+\\([0-9]+\\)\\'")
    (session-no-regexp . "\\`[ \t]*[sS]\\w*[ \t]+\\([0-9]+\\)\\'")
    (conf-prompt . "Vilket mte/person? ")

    ;; From prioritize.el:

    (cant-move-nothing-nowhere . "Kan inte flytta ingenting ngonstans.")
    (goto-priority-prompt . "Hoppa till prioritet: ")
    (priority-prompt . "Ny prioritet fr %#1M: ")
    (priority-prompt-marked . "Ny prioritet p markerade mten: ")
    (beginning-of-list . "Brjan av listan")
    (end-of-list . "Slutet av listan")
    (reprioritize-from . "Prioritera om frn: ")
    (reprioritize-to . "Prioritera om till: ")
    (no-selection . "Ingen markerad")
    (selection . "%d markerade")

    (cannot-get-membership . "Kan ej hmta medlemskap fr dig.")
    (cannot-get-pers-stat . "Kan ej hmta personstatus fr dig.")
    (prioritize-help .
		     "u,n Flytta mte, SPC markera, p prioritera markerade, q avsluta, C-h m hjlp")
    (your-priorities . " Prioritet  Mtesnamn
-------------------------------------------------------------------------------
")
    (your-membship . "Ditt medlemskap i olika KOM-mten:
  Prio Mtesnr Mtesnamn\n")
    (prio-row . " %5#1d%5#2m  %#3M\n")
    (too-high-goto-2 . "Du str fr hgt upp. G ner till rad 2.")
    (too-low-go-up . "Du kan inte pusha sista raden. G upp en rad.")
    (all-confs-popped .  "Alla mten r poppade.")
    (prio-died . "Flyttningen misslyckades. Ledsen. Dda bufferten.")
    (new-priority . "Ny prioritet? (0 (lg) - 255 (hg)) ")
    (new-prio . "%6#1d")

    ;; From flags.el:
    (saving-settings . "Sparar instllningarna...")
    (saving-settings-done . "Sparar instllningarna...klart")
    (hang-on . "Vnta ett tag...\n")
    (no-changes . "Ingenting behvde sparas eftersom inga variabler hade ndrats.\n")
    (could-not-save-options . "Kunde ej spara instllningarna.\n")
    (could-not-create-area . "Kunde ej skapa texten.\n")
    (could-not-set-user-area . "Kunde ej stlla om user-arean. Servern sger felmeddelande: %#1d\n")
    (you-dont-exist . "Du finns inte.\n")
    (error-in-options . "Det fanns ett fel i en av dina variabler (%#1s)
Det stod \"%#2s\" i user-arean. Den stts till nil istllet.
Skicka en bugrapport.\n")
    (error-in-options-short . "Det fanns ett fel i dina instllningar. Vissa instllningar har inte lsts in.")

    ;; From elib-string.el:
    ;; No entries.
		
    ;; From lyskom-rest.el:
		
    (mode-line-unread . " Olsta ")
    (mode-line-letters . "brev ")
    (frame-title-unread . "Olsta")
    (frame-title-letters . " brev")
    (sessions-with-unreads . "Sessioner med olsta")
    (unread-letters . "olsta brev")

    (bad-text-no-prefix . "Kan inte verstta prefix `%s' till inlggsnummer")
    (prefix-arg-try-again . "Ange en annan text eller tryck control-g fr att avbryta.\n")
    (error-code . "Felkod %#2d/%#3S: %#1s.\n")
    (error-in-kom-do-when-done . "Variabeln kom-do-when-done har ett felaktigt vrde.
Du br stta den till ett bttre vrde.\n")
    (extended-command . "LysKOM: ")
    (wait-for-server . "LysKOM vntar p svar frn servern. Vnta tills du fr en prompt.\n")
    (review-text-q . "terse text nummer: ")

    (completely-read-conf . "Du har sett alla texter i detta mte.\n")
    (not-in-any-conf . "Du lser inte ngot mte just nu.\n")

    (all-conf-unread-r . "Du har lst ut alla mten.\n")
    (all-conf-unread-s . "Du har lst ut alla mten. ")
    (enter-conf-unread . "%#1d olst%#1?d%[%]%[a%]")
    (enter-conf-unread-faq . "%#1d olst%#1?d%[%]%[a%] FAQ")

    (save-one-on-file-q . "Arkivera inlgg %#1n till fil: ")
    (save-many-on-file-q . "Arkivera %#1d inlgg till fil: ")
    (saving-one-on-file . "Arkiverar inlgg %#1n i %#2s.\n")
    (saving-many-on-file . "Arkivera %#1d inlgg i %#2s.\n")
    (save-text-to-file-q . "Spara inlggstext %#1n p fil: ")
    (save-text-confirm . "Filen %#1s finns redan. Vill du skriva ver den? ")
    (saving-text . "Sparar inlgg %#1n som %#2s...")
    (what-save-no . "Vilket inlgg vill du spara? ")
    (wait-for-prompt . "Vnta p prompten.")

    (conference-no . "<mte %#1d>")
    (person-no . "<person %#1d>")
    (prompt-several-messages . "(%d meddelanden)")
    (prompt-single-message   . "(%d meddelande)")

    (text-buffer-missing . "Inlggsbufferten existerar inte lngre.\n")

    (re-edit-text-prompt . "Redigera texten som inte kunde skapas")
    (go-to-pri-conf-prompt . "G till nsta prioriterade mte")
    (read-pri-text-conf . "Lsa nsta prioriterade text")
    (review-next-text-prompt . "terse nsta text")
    (review-next-comment-prompt . "terse nsta kommentar")
    (review-next-marked-prompt . "terse nsta markerade")
    (review-next-faq-prompt . "terse nsta FAQ")
    (read-next-letter-prompt . "Lsa nsta brev")
    (read-next-footnote-prompt . "Lsa nsta fotnot")
    (read-next-comment-prompt . "Lsa nsta kommentar")
    (read-next-text-prompt . "Lsa nsta text")
    (read-next-attachment-prompt . "Lsa nsta bilaga")
    (go-to-conf-of-marked-prompt . "teruppta terse markerade")
    (go-to-conf-of-review-tree-prompt . "teruppta terse kommentarer")
    (go-to-conf-of-review-prompt . "teruppta terse")
    (go-to-conf-of-review-faq-prompt . "teruppta terse FAQ")
    (go-to-next-conf-prompt . "G till nsta mte")
    (go-to-your-mailbox-prompt . "G till din brevlda")
    (next-pri-session-prompt . "G till prioriterat LysKOM \"%#1s\"")
    (next-unread-session-prompt . "G till LysKOM \"%#1s\"")

    (no-such-kom-session . "Det finns ingen sdan session med olsta.\n")
    (the-command . "Kommandot: %#1C")
    (error-in-login-hook . "Det fanns ett fel i din kom-login-hook: %#1s\n")

    (give-a-number . "Mata in ett tal: ")

    (yes-regexp . "\\`[jJ][aA]\\'")
    (no-regexp . "\\`[nN][eE][jJ]\\'")
    (yes-string . "Ja")
    (no-string . "Nej")
    (yes-or-no-nag . "Svara bara ja eller nej.")
    (yes-or-no . "(ja eller nej) ")

    (y-or-n-instring . "jJnN ")
    (j-or-n-nag . "Svara bara j eller n. ")
    (j-or-n . "(j eller n) ")
    (y-instring . "jJ ")

    (person-does-not-exist . "Person %#1d (finns inte).")
    (conference-does-not-exist . "Mte %#1d (finns inte).")
    (conf-no-does-not-exist-r . "Mte %#1d finns inte.")
    (person-is-anonymous . "Anonym person")

    (process-signal . "Signal frn processen.")
    (closed-connection . "
**************************************************
%#2s
LysKOM-sessionen onormalt stngd.
Felmeddelande: %#1s**************************************************")
    (dead-session . "LysKOM-sessionen r inte aktiv.")
    (not-lyskom-buffer . "Detta r inte en aktiv LysKOM-session.")
    (error-not-found . "Fel nummer %#1d. Ingen klartextfrklaring finns.")

    ;; Useful in more place than one:
    (illegal-command . "Otilltet kommando.\n")
    (no-such-text . "Det finns inget sdant inlgg.\n")
    (no-such-text-m . "Det finns inget sdant inlgg.")
    (nobody . "ingen")
    (everybody . "alla")
    (everything . "allt")
    (anybody . "vem som helst")
    (forward . "framt")
    (backward . "bakt")
    (wait . "Vnta ett tag...\n")
    (comment . "Kommentar")
    (comment-prefix . "[Kk]")
    (footnote . "Fotnot")
    (footnote-prefix . "[Ff]")

    (by . " av %#1P")
    (text-created .  "Text nummer %#1n r skapad.\n")
    (text-created-anonymous .  "\
Text nummer %#1n r skapad (anonymt). Fr att gra det svrare fr 
andra att ta reda p att du skapade inlgget br du vnta ett tag med
att lsa det.\n")

    (resolve-session . "Ange vilken session: ")

    (starting-program . "Startar %#1s...")
    (super-jump . "Filtrerar rende \"%#1r\" i mte \"%#2M\"\n")
    (no-recipient . "Inlgget har ingen mottagare.\n")
    (filtered . "[Filtrerad]")
    (filter-error-specification . "Fel i filterspecifikationen")
    (filter-error-bad-not . "Fel i filterspecifikation efter 'not'")
    (filter-error-unknown-key . "Filternyckeln '%S' r oknd.")
    (filter-error-key-arg . "Fel filterdata (%S %S)")
    (filter-tree . "Hoppar ver text %#1n \"%#2r\" av %#3P och dess kommentarstrd.\n")
    (filter-text . "Hoppar ver text %#1n \"%#2r\" av %#3P.\n")
    (filter-permanent . "Permanent? ")
    (filter-action . "Hur vill du filtrera? ")
    (filter-in-conf . "I vilket mte? (alla) ")
    (filter-subject . "Filtrera vilket rende? ")
    (filter-which-text . "Filtrera inlgg som innehller: ")
    (filter-author . "Filtrera vilken frfattare? ")
    (filter-recipient . "Vilken mottagare vill du filtrera? ")
    (permanent . "(permanent)")
    (temporary . "(tillfllig)")
    (filter-edit-buffer-name . "*LysKOM Filter Edit*")
    (filter-edit-empty-list . "Listan r tom")
    (filter-edit-start-of-list . "Listans brjan")
    (filter-edit-end-of-list . "Listans slut")
    (filter-edit-filter-how . "Hur vill du filtrera? ")
    (filter-edit-filter-what . "Vad vill du filtrera? ")
    (filter-edit-bad-argument . "Felaktig inmatning: %s")
    (filter-edit-outside-entry . "Kan inte utfra kommandot utanfr ett filter")
    (filter-edit-outside-list . "Kan inte utfra operationen utanfr listan")
    (filter-edit-end-of-pattern . "Filtrets slut")
    (filter-edit-save-p . "Spara frndringar? ")
    (filter-edit-remove-empty . "Tomma filter gr att alla texter filtreras. Vill du ta bort dessa? ")
    (filter-edit-restart-p . "Du har gjort ndringar. Vill du verkligen brja om? ")
    (filter-edit-help . 
		      "p,n Upp/ned, i/M-i Ny rad/filter, d/M-d Radera rad/filter, C-h m Mer hjlp")
    (filter-edit-header . "ndra filter fr \"%s\"\n")
    (filter-edit-saving . "Sparar ndringarna...")
    (filter-edit-saving-done . "Sparar ndringarna...klart")
    (filter-edit-saving-error . "Kunde inte spara ndringarna!")
    (filter-edit-insert-pred . "%#1s (=,!=): ")
    (filter-edit-insert-arg . "%#1s %#2s (vad): ")
    (no-filters . "Inga filter har definierats.\n")
    (view-filters-header . "\nAktiva filter:\n\n")
    (view-filters-footer . "")

    (ansaphone-new-message . "Nytt automatsvar: ")
    (ansaphone-message . "Svarsmeddelande:
----------------------------------------------------------------------
%#1t
----------------------------------------------------------------------
")
    (ansaphone-message-long . "Svarsmeddelande:
-------------------------------------------------------------------------------
%#1t
-------------------------------------------------------------------------------
")
    (ansaphone-state . "Automatsvar r nu %#1s.")
    (ansaphone-state-r . "Automatsvar r nu %#1s.\n")
    (ansaphone-messages-gone . "Sparade meddelanden raderade.")
    (ansaphone-no-messages . "Inga meddelanden.\n")
    (ansaphone-message-list-start . "Sparade meddelanden:\n\n")
    (ansaphone-message-list-end . "\n\n")
    (ansaphone-message-header . "Automatiskt svar (satt %#1s):\n")

    (remote-erase-messages . "Fjrrstyrning (%#1P %#2s): Sparade meddelanden raderade\n")
    (remote-set-message . "Fjrrstyrning (%#1P %#2s): Svarsmeddelande:
----------------------------------------------------------------------
%#3t
----------------------------------------------------------------------
")
    (remote-set-message-long . "Fjrrstyrning (%#1P %#2s): Svarsmeddelande:
-------------------------------------------------------------------------------
%#3t
-------------------------------------------------------------------------------
")    (remote-set-ansaphone . "Fjrrstyrning (%#1P %#2s): Automatsvar r nu %#3s\n")
    (remote-list-messages . "Fjrrstyrning (%#1P %#2s): Meddelanden listade\n")
    (remote-quit . "Fjrrstyrning(%#1P %#2s): Avsluta\n")

    (illegal-remote . 
		    "Otillten fjrrstyrning:
Tid: %#1s
Frn: %#2P <%#2p>
Till: %#3P <%#3p>
Text: 
%#4t")
    (illegal-remote-reply . "Fjrrstyrning inte accepterad: %#1s") 
    (remote-not-in-list . "Otillten person")
    (remote-bad-command . "Felaktigt kommando")
    (remote-unknown-error . "Oknt fel")

    (remote-control-who . "Kontrollera vilken session? ")
    (remote-control-autoreply . "Automatsvar p eller av? ")

    (state-on . "pslaget")
    (state-off . "avslaget")

    (text-popup-title . "Inlgg %#1s")
    (conf-popup-title . "Mte %#1s")
    (pers-popup-title . "Person %#1s")
    (url-popup-title  . "URL %#1s")
    (aux-popup-title  . "Tillggsinformation")
    (timestamp-popup-title . "Tidsstmpel %#1s")
    (recpt-type-popup-title . "Mottagartyp: %#1s")
    (add-recpt-button-text . "[Addera...]")
    (add-recpt-button-text-regex . "\\[Addera\\.\\.\\.\\]")
    (generic-popup-title . "%#1s")

    (who-i-am-not-present . "%#1P r inte nrvarande i ngot mte\n")
    (who-i-am-present . "%#1P r nrvarande i %#2M\n")
    (who-i-am-client . "Programmet heter lyskom.el, version %#1s%#2?b%[ (MULE)%]%[%].\n")
    (who-i-am-server . "Detta r %#1s, version %#2s.\n")
    (who-i-am-emacs . "Det krs under %#1s%#2?b%[ (MULE)%]%[%].\n")

    (no-such-session-r . "Det finns ingen sdan session. Personen kanske inte r inloggad.\n")
    (person-not-logged-in-r . "%#1P %#2?b%[har inte varit inloggad sedan %#2s%]%[r inte inloggad%].\n")
    (session-status . "Session %#1d r %#2P <%#2p>
%#5s %#7s %#4M
Kr %#6D frn %#3s\n")
    (session-status-9 . "Session %#1d r %#2P <%#2p>
%#5s %#7s %#4M
Kr %#6D frn %#3s
Uppkopplad sedan %#8s%#9s")
    (session-status-inactive . "\nHar inte varit aktiv p %#1s\n")
    (one-day . "en dag")
    (one-hour . "en timme")
    (one-minute . "en minut")
    (years . "r")
    (year . "r")
    (months . "mnader")
    (month . "mnad")
    (days . "dagar")
    (day . "dag")
    (hours . "timmar")
    (minutes . "minuter")
    (and . "och")
    (session-is-active . " och r aktiv.\n")
    (session-is-invisible . "Denna session r osynlig.\n")
    (status-for-session . "Sessionsstatus fr vilken person? ")
    (unknown-doing-what . "Existerar")
    (doing-where-conn . "i")
    (doing-nowhere-conn . "men r")
    (waiting-for-membership . "Vntar p att medlemskapslistan ska lsas in...%d/%d")

    ;; From slow.el
    (no-such-command . "Det finns inget sdant kommando.\n")
    (command-completions . "Du kan mena ngon av fljande:\n %#1s\n")
    (which-language . "ndra sprk till: ")
    (send-formatted . "Skicka in som formatterad text? ")
    (changing-language-to . "Byter till %#1_s.\n")
    (language-set-to . "Sprket r %#1_s.\n")
    (language-not-loaded . "%#1s finns inte tillgngligt.\n")

    (reformat-html . "HTML")
    (reformat-enriched . "enriched")
    (reformat-filled . "ombruten")

    (reformat-truncated . "nedkortad")

    (reformat-signature . "avsignerad")

    (reformat-deswascii . "var swascii")

    (need-library . "Paketet \"%#1s\" behvs fr att utfra detta kommando.\n")
    (calc-expression . "Uttryck: ")

    (do-send-anonymous . "Skicka in texten anonymt? ")
    (anonymous . "anonym")
    (Anonymous . "Anonym")

    (secret-conf-letter . "H")
    (protected-conf-letter . "S")
    (created-conf-letter . "S")
    (superconf-conf-letter . "M")
    (supervisor-conf-letter . "O")

    ;; Some Help

    (where-is-doesnt-exist . "Kommandot %#1s finns inte")
    (where-is-on-no-key . "%#1s finns inte p ngon tangent")
    (where-is-on-key . "%#1s finns p %#2s")

    ;; From aux-items.el

    (content-type-aux . "Innehllstyp: %#1s")
    (content-type-regexp . "Innehllstyp: \\(\\S-+\\)")
    
    (agreeing . "Hller med om inlgg %#1n...")
    (fast-replying . "Anmrkning till inlgg %#1n...")
    (author-fast-replies . "Anmrkningar av frfattaren:")
    (author-fast-reply-aux . "  \"%#1t\"")
    (other-fast-replies . "Anmrkningar:")
    (other-fast-reply-aux . "  \"%#1t\" /%#2P/")
    (fast-reply-too-long . "Kan inte skapa anmrkningar som bestr av mer n en rad.\n")
    
    (faq-for-conf-aux . "Texten r FAQ fr %#1M <%#1m>") 
    (faq-for-server-aux . "Texten r FAQ fr LysKOM-servern") 
    (faq-in-text-aux . "FAQ i inlgg:                   %10#1n %#2D")
    (conf-to-add-faq . "Vilket mte vill du lgga till en FAQ fr? ")
    (text-to-add-as-faq . "Vilken text vill du lgga till som FAQ? ")
    (text-to-change-as-faq . "Vilken FAQ vill du ndra? ")
    (adding-faq . "Lgger till inlgg %#1n som FAQ fr %#2?b%[%#2M%]%[servern%]...")
    (conf-to-del-faq . "Vilket mte vill du ta bort en FAQ frn? ")
    (text-to-del-as-faq . "Vilken text vill du ta bort som FAQ? ")
    (deleting-faq . "Tar bort inlgg %#1n som FAQ fr %#2?b%[%#2M%]%[servern%]...")
    (conf-has-no-faq . "%#1?b%[%#1M%]%[Servern%] har ingen FAQ\n")
    (view-which-faq . "terse FAQ fr vilket mte? ")
    (review-faq-for-r . "terse FAQ fr %#1?b%[%#1M%]%[servern%].\n")
    (changed-faq-for-conf-done . "FAQ i text %#2n fr %#1?b%[%#1M%]%[servern%] ndrad till text %#3n.\n")
    (changed-faq-for-conf-failed . "Kunde inte ndra FAQ fr %#1?b%[%#1M%]%[servern%] till text %#3n.
%#2?b%[Text %#2n r fortfarande FAQ.
%]%[%]%#4s")
    (faq-in-text . "FAQ i text %#1n %#3s%#4s")
    (faq-in-text-by . "FAQ i text %#1n %#5s %#3sav %#2P %#4s")
    (server-has-new-faq . "\nDet finns %#1d ny%#1?d%[%]%[a%] FAQ till servern.\n")
    (unread-faqs-header . "\nOlst%#1?d%[%]%[a%] FAQ till %#2?b%[%#2M%]%[servern%]:\n")

    (too-many-languages . "Fr mnga teckenuppsttningar fr att koda. Skicka in okodat? ")
    (too-many-content-types . "Kan inte avgra innehllstyp. Frenkla inlgget.")

    (cross-reference-text-status-aux . "Se ven inlgg:                 %10#1n /%#2P/")
    (cross-reference-conf-status-aux . "Se ven mte:                           <%#1m> %#1M /%#2P/")
    (cross-reference-pers-status-aux . "Se ven person:                         <%#1p> %#1P /%#2P/")
    (strange-cross-reference-status .  "Se ven:                                 %#1s (vad nu det betyder)")
    (cross-reference-text-aux . "Se ven inlgg %#1n /%#2P/")
    (cross-reference-conf-aux . "Se ven mte <%#1m> %#1M /%#2P/")
    (cross-reference-pers-aux . "Se ven person <%#1p> %#1P /%#2P/")
    (cross-reference-text-regexp . "Se ven inlgg \\([0-9]+\\)")
    (cross-reference-conf-regexp . "Se ven mte <\\([0-9]+\\)>")
    (cross-reference-pers-regexp . "Se ven person <\\([0-9]+\\)>")
    (strange-cross-reference . "Se ven %#1s, vad nu det betyder")
    
    (no-comments-aux . "Frfattaren har begrt att inte f kommentarer")
    (no-comments-edit-aux . "Begr att inte f kommentarer")
    (no-comments-regexp . "Begr att inte f kommentarer")
    
    (personal-comment-aux . "Frfattaren har begrt endast personliga svar")
    (personal-comment-edit-aux . "Begr endast personliga svar")
    (personal-comment-regexp . "Begr endast personliga svar")
    
    (request-confirmation-aux . "%#1P har begrt lsbekrftelse")
    (request-confirmation-edit-aux . "Begr bekrftelse om lsning")
    (request-confirmation-regexp . "Begr bekrftelse om lsning")
    (confirm-read-q . "Bekrfta lsning av inlgg %#1n? ")
    
    (read-confirm-aux . "Lst: %#1P %#2s")

    (redirect-email-aux . "Skicka sladdpost till %#1s")
    (redirect-lyskom-aux . "Skicka inlgg till mte %#1M")

    (label-what-kind . "Stt personligt namn p vad (inlgg, mte, person)? ")
    (label-what-text . "Stt personligt namn p inlgg nummer: ")
    (label-what-conf . "Stt personligt namn p vilket mte? ")
    (label-what-pers . "Stt personligt namn p vilken person? ")
    (label-what-label . "Personligt namn: ")
    (label-secret    . "Skall andra kunna se namnet? ")

    (creating-software-aux . "Skapad med %#1s")
    (world-readable-text-aux . "Inlgget kan lsas utan inloggning")
    (world-readable-text-edit-aux . "Gr inlgget lsbart utan inloggning")

    (cant-get-aux-item . "Hittar inte tillggsinformationen\n")
    (aux-item-no-info . "Ingen information tillgnglig\n")
    (aux-item-info . "\
Nummer:       %#1d %#6s
Typ:          %#2d (%#3s)
Skapad av:    %#4P <%#4p>
Skapad:       %#5s
Flaggor:      %#7s
Arvsgrns:    %#8s
Innehll:    \"%#9s\"
")
    (secret . "Hemlig")
    (deleted . "Raderad")
    (hide-creator . "Dold skapare")
    (inherit . "rvs")
    (unlimited-inherit . "Obegrnsat arv")
    (no-inheritance . "Arv r avslaget")
    (no-more-inheritance . "Grnsen uppndd; inget mer arv")
    (inherit-steps . "%#1d steg")

    (aux-item-for . "Tillggsinformation fr ")
    (aux-item-for-conference-no . "mte <%#1m> %#1M")
    (aux-item-for-text-no . "inlgg %#1n")
    (aux-item-for-server . "servern")

    (what-fast-reply-no . "Anmrkning till vilket inlgg? ")
    (fast-reply-prompt . "Anmrkning: ")
    (agree-prompt . "Text: ")
    (default-agree-string . "Hller med")
    (what-agree-no . "Hll med vilket inlgg? ")

    (what-kind-to-add-aux-to . "Koppla tillggsinformation till vad? ")
    (which-conf-to-add-aux-to . "Vilket mte vill du koppla till? ")
    (which-text-to-add-aux-to . "Vilket inlgg vill du koppla till? ")
    (which-aux-item-tag . "Aux-item tag: ")
    (which-aux-item-inherit . "Stt inherit-flaggan? ")
    (which-aux-item-secret . "Stt secret-flaggan? ")
    (which-aux-item-anonymous . "Stt anonymous-flaggan? ")
    (which-aux-item-rsv1 . "Stt dont-garb-flaggan? ")
    (which-aux-item-rsv2 . "Stt reserved2-flaggan? ")
    (which-aux-item-rsv3 . "Stt reserved3-flaggan? ")
    (which-aux-item-rsv4 . "Stt reserved4-flaggan? ")
    (which-aux-item-inherit-limit . "Arvsgrns: ")
    (which-aux-item-data . "Data: ")

    ;; Cross-reference stuff

    (person . "Person")
    (conference . "Mte")
    (text . "Inlgg")
    (server . "Server")

    (xref-type . "Vad vill du referera till (inlgg, mte eller person)? ")
    (which-text-to-xref . "Lgg till referens till text nummer: ")
    (which-text-to-xref-err . "Hittar inte texten. Lgg till referens till text nummer: ")
    (which-pers-to-xref . "Lgg till referens till person: ")
    (which-conf-to-xref . "Lgg till referens till mte: ")

    ;; Aux-item stuff from edit-text

    (no-comments-q . "Frfattaren vill inte ha kommentarer. Kommentera nd? ")
    (private-answer-q . "Frfattaren har bett om personliga svar. Skriv personligt svar? ")

    (your-invited . "%#2P har bjudit in dig till %#1M.
Genom att acceptera inbjudan fortstter du vara medlem i %#1M.
Du kan ven tacka nej, och d kommer du automatiskt att g ur mtet.
")

    (accept-invitation . "Vill du acceptera inbjudan och fortstta vara medlem? ")
    (enter-passive . "Du r passiv medlem i %#1M.
Du mste bli aktiv medlem fr att g till mtet.\n")
    (convert-passive . "Vill du bli aktiv medlem i %#1M? ")
    (bug-secret-mship . "Du r hemlig medlem i %#1M\n")

    (invitation-mt-type . "inbjuden")
    (passive-mt-type . "passiv")
    (secret-mt-type . "hemlig")

    (Invitation-mt-type . "Inbjuden")
    (Passive-mt-type . "Passiv")
    (Secret-mt-type . "Hemlig")

    (not-author-try-anyway-p . "Du r inte frfattare till inlgget. Vill du frska nd? ")
    (what-no-comments-no . "Vilken text vill du inte ha kommentarer till: ")
    (adding-no-comments . "Begr att inte f kommentarer till inlgg %#1n...")
    (already-no-comments . "Inlgg %#1n har redan begran om inga kommentarer.\n")

    (what-private-answer-no . "Vilken text vill du ha personligt svar till: ")
    (adding-private-answer . "Begr att endast f personligt svar till inlgg %#1n...")
    (already-private-answer . "Inlgg %#1n har redan begran om enbart personliga svar.\n")

    (what-request-confirm-no . "Vilken text vill du ha lsbekrftelse till: ")
    (adding-request-confirm . "Begr lsbekrftelse till inlgg %#1n...")
    (already-request-confirm . "Inlgg %#1n har redan begran om lsbekrftelse.\n")

    (review-mail-headers-to-what . "Vilken texts brevhuvud vill du se? ")
    (no-mail-headers . "Inlgg %#1n har inget brevhuvud\n")
    (mail-headers-for . "Brevhuvud fr inlgg %#1n:\n")
    (email-name-prefix . "")
    (email-name-suffix . "")

    (you-are-anonymous . "Du r nu ngorlunda anonym.\n")
    (you-are-nonanonymous . "Du r inte lngre anonym.\n")
    (you-are-already-anonymous . "Du r redan ngorlunda anonym.\n")
    (you-are-already-nonanonymous . "Du r redan icke-anonym.\n")

    (start-keep-alive . "Snder data med %#1d sekunders mellanrum fr att hlla frbindelsen aktiv.")
    (stop-keep-alive . "Data snds inte lngre fr att hlla frbindelsen aktiv.")

    (review-noconversion-q . "terse vilket inlgg omodifierat?")
    (review-commented-q . "terse vilket inlgg kommenterade?")
    (review-tree-q . "terse alla kommentarer rekursivt fr vilket inlgg?")
    (find-root-q . "terse urinlgget fr vilken text?")
    (find-root-review-q . "terse trd fr vilket inlgg?")
    (review-comments-q . "terse alla kommentarer till vilket inlgg?")

    (confusion-who-to-reply-to . "Jag frstr inte vems inlgg du vill skriva ett privat svar till.\n")
    (confusion-what-to-answer-to . "Jag frstr inte vilken text du vill besvara.\n")
    (confusion-what-to-view . "Jag frstr inte vilken text du vill terse.\n")

    (confusion-what-to-reply-to . "Jag frstr inte vilken text du vill skriva en anmrkning till.\n")
    (confusion-what-to-agree-to . "Jag frstr inte vilken text du vill hlla med om.\n")
    (confusion-what-to-request-confirmation . "Jag frstr inte vilken text du vill ha lsbekrftelser p.\n")
    (confusion-what-to-comment . "Jag frstr inte vilken text du vill kommentera.\n")
    (confusion-what-to-footnote . "Jag frstr inte vilken text du vill skriva en fotnot till.\n")

    (confusion-what-to-delete . "Jag frstr inte vilken text du vill radera.\n")
    (confusion-what-to-add-sub-recipient . "Jag frstr inte vilken text du vill %#1s.\n")
    (add-rcpt-action-name . "addera mottagare till")
    (add-copy-action-name . "addera extra-kopiemottagare till")
    (add-bcc-action-name . "addera dold kopia till")
    (sub-action-name . "subtrahera mottagare frn")
    (move-action-name . "flytta")

    (confusion-what-to-add-comment-to . "Jag frstr inte vilken text du vill addera en kommentar till.\n")
    (confusion-what-to-sub-comment-from . "Jag frstr inte vilken text du vill subtrahera en kommentar frn.\n")
    (confusion-what-to-add-footnote-to . "Jag frstr inte vilken text du vill addera en fotnot till.\n")
    (confusion-what-to-sub-footnote-from . "Jag frstr inte vilken text du vill subtrahera en fotnot frn.\n")
    
    (confusion-what-to-mark . "Jag frstr inte vilket inlgg du vill markera.\n")
    (confusion-what-to-unmark . "Jag frstr inte vilket inlgg du vill avmarkera.\n")
    (confusion-what-to-save . "Jag frstr inte vilket inlgg du vill spara.\n")

    (confusion-what-to-review-mail-headers . "Jag frstr inte vilket inlggs brevhuvud du vill se.\n")
    (confusion-what-to-find-root . "Jag frstr inte vilket inlggs urinlgg du vill terse.\n")
    (confusion-what-to-find-root-review . "Jag frstr inte vilket inlggstrd du vill terse.\n")


    ;; Help

    (help-with-what . "Vad vill du ha hjlp med? ")
    (help-for . "Hjlp fr \"%#1s\"\n")

    ;; Button actions

    (lyskom-button-view-text-action . "terse texten")
    (lyskom-button-copy-text-no-action . "Kopiera inlggsnumret")
    (lyskom-button-review-noconversion-action . "terse omodifierat")
    (lyskom-button-find-root-review-action . "terse trd")
    (lyskom-button-find-root-action . "terse urinlgget")
    (lyskom-button-comment-text-action . "Kommentera texten")
    (lyskom-button-private-comment-text-action . "Personligt svar")
    (lyskom-button-mark-text-action . "Markera texten")
    (lyskom-button-unmark-text-action . "Avmarkera texten")
    (lyskom-button-save-text-action . "Arkivera inlgg")
    (lyskom-button-save-text-body-action . "Spara inlggstext")
    (lyskom-button-review-comments-action . "terse alla kommentarer")
    (lyskom-button-review-tree-action . "terse alla kommentarer rekursivt")
    (lyskom-button-write-footnote-action . "Fotnotera")
    (lyskom-button-fast-reply-action . "Anmrk")
    (lyskom-button-view-conf-presentation-action . "Visa presentation")
    (lyskom-button-view-conf-status-action . "Visa mtesstatus")
    (lyskom-button-goto-conf-action . "G till mtet")
    (lyskom-button-send-message-action . "Skicka gruppmeddelande")
    (lyskom-button-add-self-action . "Bli medlem i mtet")
    (lyskom-button-sub-self-action . "Uttrd ur mtet")
    (lyskom-button-view-pers-presentation-action . "Visa presentation")
    (lyskom-button-view-pers-status-action . "Visa personstatus")
    (lyskom-button-view-session-status-action . "Visa sessionsstatus")
    (lyskom-button-mail-action . "Skicka brev")
    (lyskom-button-send-message-action . "Snd meddelande")
    (lyskom-button-open-url-action . "ppna")
    (lyskom-button-copy-url-action . "Kopiera")
    (lyskom-button-goto-info-node-action . "ppna")
    (lyskom-button-open-email-action . "Skicka mail")
    (lyskom-button-copy-email-action . "Kopiera")
    (lyskom-button-info-aux-action . "Information")
    (lyskom-button-delete-aux-action . "Radera")
    (lyskom-button-copy-timestamp-action . "Kopiera")
    (lyskom-button-recpt-type-recipient . "Mottagare")
    (lyskom-button-recpt-type-copy . "Extra kopia")
    (lyskom-button-recpt-type-bcc . "Dold kopia")
    (lyskom-button-recpt-type-sub . "Subtrahera")
    (lyskom-button-recpt-add-recipient . "Mottagare")
    (lyskom-button-recpt-add-copy . "Extra-kopiemottagare")
    (lyskom-button-recpt-add-bcc . "Dold-kopiamottagare")
    (lyskom-button-aux-type-xref . "Referens till mte/person/inlgg")
    (lyskom-button-aux-type-no-comments . "Begran om inga kommentarer")
    (lyskom-button-aux-type-personal-comments . "Begran om personligt svar")

    (lyskom-edit-toggle-secret-aux-action . "Vxla \"hemlig\"")
    (lyskom-edit-toggle-anonymous-aux-action . "Vxla \"anonym\"")
    (lyskom-edit-toggle-inherit-aux-action   . "Vxla \"rvd\"")
    (lyskom-edit-delete-aux-action          . "Ta bort")
    (lyskom-prioritize-flag-toggle-action . "Vxla")
    (lyskom-prioritize-flag-set-action . "Stt p")
    (lyskom-prioritize-flag-clear-action . "Stng av")

    (server-status-header   . "Status fr LysKOM-server %#1s%#2?b%[ (%#2s:%#3d)%]%[%]\n\n")
    (server-status-server   . "Kanonisk server:                         %#1s%#2?b%[:%#2s%]%[%]\n")
    (server-status-version  . "Programversion:                          %#1s %#2s\n")
    (server-status-protocol . "Protokollversion:          %15#1d\n")
    (server-status-sessions . "\
Antal sessioner:     %21#1d (totalt)
                     %21#2d aktiva under de senaste %#7d minuterna
                     %21#3d inaktiva sessioner
                     %21#4d oknd aktivitet
                     %21#5d osynliga sessioner
                     %21#6d ej inloggade/hemliga/zombies\n")
    (server-status-first-text . "ldsta befintliga text:    %15#1n\n")
    (server-status-last-text  . "Yngsta befintliga text:    %15#1n\n")
    (server-status-has-motd . "\nServern har en lapp p drren:\n")
    (server-status-time . "Serverns tid:                   %#1s\n")

    (mship-type-invitation-q . "Inbjudan till medlemskap? ")
    (mship-type-passive-q . "Passivt medlemskap? ")
    (mship-type-secret-q . "Hemligt medlemskap? ")
    (recommend-which-conf . "Vilket mte vill du rekommendera? ")
    (recommend-set-priority-q . "Rekommendera prioritet? ")
    (recommend-set-mship-type-q . "Rekommendera mtestyp? ")
    (recommending-conf . "Rekommenderar %#1M%#2?b%[ (prioritet %#2d)%]%[%]%#3?b%[ %#3s%]%[%]...")
    (has-recommended-conf . "%#1P har rekommenderat mte %#2M. Vill du bli medlem?\n")
    (accept-recommendation . "G med i %#1M? ")
    (accepting-recommendataion . "G med i rekommenderat mte %#1M...")

    (redirect-for-whom . "Dirigera om kommentarer fr: ")
    (redirect-to-which-conf . "Dirigera om kommentarer till: ")
    (redirecting-comments-to . "Dirigerar om kommentarer fr %#1P till %#2M%#3?b%[ (frr %#1M)%]%[%]...")

    (kom-redirect-comments-e49 . "Du har inte rtt att ndra denna omdirigering")
    (kom-redirect-comments-e48 . "Omdirigering av kommentarer stds inte av servern")

    (external-program-missing . "Hittar inte det externa programmet \"%#1s\" som krvs fr att genomfra kommandot.")
    (ignored-user-area-var . "\

Ignorerar fljande variabeler i dina instllningar:

    %#1s

Variablerna r inte registrerade LysKOM-variabeler och kan drfr inte
lsas frn servern. Du kan ta bort variablerna frn servern genom att
ge kommandot \"Spara variabler\".\n\n")

    (unknown-aux-item . "Oknd tillggsinformation")
    (text-header-aux-item . "%#1s: <%#2d> \"%#3s\" %#4s")

    (aux-content-type-name . "Innehllstyp")
    (aux-fast-reply-name . "Anmrkning")
    (aux-cross-reference-name . "Referens")
    (aux-no-comments-name . "Begran om inga kommentarer")
    (aux-personal-comment-name . "Begran om personliga svar")
    (aux-request-confirmation-name . "Begran om lsbekrftelse")
    (aux-read-confirm-name . "Lsbekrftelse")
    (aux-redirect-name . "Omdirigering")
    (aux-x-face-name . "Bild")
    (aux-alternate-name-name . "Alternativt namn")
    (aux-pgp-signature-name . "PGP-signatur")
    (aux-pgp-public-key-name . "Publik PGP-nyckel")
    (aux-e-mail-address-name . "E-postadress")
    (aux-faq-text-name . "FAQ i text")
    (aux-creating-software-name . "Skapande klient")
    (aux-mx-author-name . "E-mailfrfattare")
    (aux-mx-from-name . "E-mail frn")
    (aux-mx-reply-to-name . "E-mail svar snds till")
    (aux-mx-to-name . "E-mail till")
    (aux-mx-cc-name . "E-mail CC")
    (aux-mx-date-name . "E-maildatum")
    (aux-mx-message-id-name . "E-mail-meddelande-ID")
    (aux-mx-in-reply-to-name . "E-mail svar till")
    (aux-mx-misc-name . "E-mailheader")
    (aux-mx-allow-filter-name . "E-mail allow-filter")
    (aux-mx-reject-forward-name . "E-mail reject-forward")
    (aux-notify-comments-name . "Meddela kommentarer")
    (aux-faq-for-conf-name . "FAQ fr mte")
    (aux-recommended-conf-name . "Mtesrekommendation")
    (aux-allowed-content-type-name . "Tillten innehllstyp")
    (aux-canonical-name-name . "Kanoniskt namn")
    (aux-mx-list-name-name . "E-maillistnamn")
    (aux-send-comments-to-name . "Snd kommentarer till")
    (aux-world-readable-name . "Lsbart utan inloggning")
    (aux-elisp-client-read-faq-name . "Lst FAQ")
    (aux-elisp-client-rejected-invitation-name . "Avvisad inbjudan")

    (review-marking-as-read . "terse lsmarkerar")
    (review-not-marking-as-read . "terse lsmarkerar inte")

    (using-ssh-connection . "Anvnder ssh-uppkoppling till %#1s...")
    (opening-ssh-connection . "ppnar ssh-uppkoppling till %#1s...")
    (ssh-cant-connect . "Kan inte gra ssh-uppkopplingen: %s")
    (ssh-closnig . "Stnger ssh-uppkopplingen till %#1s")
    (ssh-unknown-host . "oknd vrd")

    (keyboard-cancel . "Avbryt")
    (keyboard-menu-help . "(vlj: C-n, C-p; bekrfta: RET)")
    (customize-help . "Se brjan av bufferten fr mer information")

    (missing-faces . "\
Ditt teckensnittsschema \"%#1s\" saknar fljande instllningar:

    %#2s

Anvnder standardteckensnittet fr dessa instllningar.
")
    ))

(lyskom-language-var local lyskom-month-names sv
  '(("jan" . 1)  ("januari" . 1)
    ("feb" . 2)  ("februari" . 2)
    ("mar" . 3)  ("mars" . 3)
    ("apr" . 4)  ("april" . 4)
    ("maj" . 5)  ("maj" . 5)
    ("jun" . 6)  ("juni" . 6)
    ("jul" . 7)  ("juli" . 7)
    ("aug" . 8)  ("augusti" . 8)
    ("sep" . 9)  ("september" . 9)
    ("okt" . 10) ("oktober" . 10)
    ("nov" . 11) ("november" . 11)
    ("dec" . 12) ("december" . 12)))


;;; ================================================================
;;;              The commands and their associated functions



;;; The Alist formerly known as lyskom-commands
(lyskom-language-strings global lyskom-command sv
  '(
    (kom-help                 . "Hjlp")
    (kom-slow-mode            . "Lngsamma kommandon")
    (kom-quick-mode           . "Snabba kommandon")
    (kom-send-message         . "Snda meddelande")
    (kom-send-alarm           . "Skicka alarmmeddelande")
    (kom-create-conf	      . "Skapa mte")
    (kom-delete-conf          . "Utplna (mte/person)")
    (kom-delete-text          . "Radera inlgg")
    (kom-display-time	      . "Se tiden")
    (kom-go-to-conf	      . "G till mte")
    (kom-go-to-next-conf      . "G till nsta mte")
    (kom-jump		      . "Hoppa ver alla kommentarer")
    (kom-list-created-conferences . "Lista gda mten")
    (kom-list-conferences     . "Lista mten") 
    (kom-list-persons	      . "Lista personer")
    (kom-list-news            . "Lista nyheter")
    (kom-list-re              . "Lista (med) regexpar")
    (kom-membership	      . "Lista medlemskap")
    (kom-postpone	      . "Uppskjuta lsning")
    (kom-set-session-priority . "Stt lsniv")
    (kom-prioritize	      . "Prioritera mten")
    (kom-status-person	      . "Status (fr) person")
    (kom-status-conf	      . "Status (fr) mte")
    (kom-add-self	      . "Bli medlem i mte")
    (kom-change-priority      . "ndra prioritet")
    (kom-list-summary	      . "Lista renden")
    (kom-sub-self             . "Uttrda ur mte")
    (kom-quit		      . "Sluta")
    (kom-recover	      . "Starta om klienten") 
    (kom-start-anew	      . "Brja med nytt namn")
    (kom-view		      . "terse inlgg")
    (kom-find-root-review     . "terse trd")
    (kom-review-comments      . "terse alla kommentarer")
    (kom-review-tree	      . "terse alla kommentarer rekursivt")
    (kom-review-clear         . "terse hoppa")
    (kom-review-last-normally-read
     			      . "terse igen")
    (kom-review-noconversion  . "terse omodifierat")
    (kom-review-next          . "terse nsta")
    (kom-find-root	      . "terse urinlgget")
    (kom-review-by-to         . "terse senaste")
    (kom-review-more          . "terse fler inlgg")
    (kom-review-first         . "terse frsta")
    (kom-review-all           . "terse alla")
    (kom-view-commented-text  . "terse det kommenterade")
    (kom-view-previous-commented-text
     			      . "terse det fregende kommenterade")
    (kom-review-stack         . "terse lista")
    (kom-review-presentation  . "terse presentation")
    (kom-review-backward      . "(terse) Baklnges")
    (kom-view-next-text	      . "Lsa nsta inlgg")
    (kom-who-is-on	      . "Vilka (r) inloggade") 
    (kom-who-is-on-in-conference
     			      . "Vilka (r inloggade i) mte") 
    (kom-who-is-present-in-conference
     			      . "Vilka (r) nrvarande (i mte)")
    (kom-who-is-on-and-friend . "Vilka vnner (r inloggade)")
    (kom-who-am-i             . "Var (r) jag")
    (kom-list-clients	      . "Lista klienter")
    (kom-busy-wait	      . "Vnta p ett inlgg")
    (kom-write-comment	      . "Kommentera inlgget")
    (kom-comment-previous     . "Kommentera fregende inlgg")
    (kom-write-footnote       . "Fotnot till inlgg")
    (kom-private-answer       . "Personligt svar")
    (kom-private-answer-previous
     . "Personligt svar p fregende inlgg")
    (kom-set-unread	      . "Endast lsa senaste")
    (kom-write-text	      . "Skriva ett inlgg")
    (kom-send-letter	      . "Skicka brev")
    (kom-change-name	      . "ndra namn")
    (kom-change-parenthesis   . "ndra parentes")
    (kom-change-password      . "ndra lsenord")
    (kom-change-supervisor    . "ndra organisatr")
    (kom-change-presentation  . "ndra presentation")
    (kom-get-appreciation     . "F uppmuntran")
    (kom-get-abuse            . "F skll")
    (kom-mark-text            . "Markera (inlgg)")
    (kom-unmark-text          . "Avmarkera (inlgg)")
    (kom-review-marked-texts  . "terse markerade")
    (kom-review-all-marked-texts . "terse alla markerade")
    (kom-add-recipient        . "Addera mottagare")
    (kom-add-copy	      . "Addera extra kopiemottagare")
    (kom-add-bcc	      . "Addera dold kopia")
    (kom-sub-recipient        . "Subtrahera mottagare")
    (kom-move-text            . "Flytta inlgg")
    (kom-add-comment	      . "Addera kommentar")
    (kom-sub-comment	      . "Subtrahera kommentar")
    (kom-add-cross-reference  . "Addera referens")
    (kom-add-member	      . "Addera medlem")
    (kom-sub-member           . "Uteslut medlem")
    (kom-change-conf-motd     . "Stt lapp p drren")
    (kom-set-garb-nice        . "ndra livslngd")
    (kom-set-super-conf       . "ndra supermte")
    (kom-set-permitted-submitters . "ndra tilltna frfattare")
    (kom-unset-conf-motd      . "Ta bort lapp p drren")
    (kom-save-text	      . "Arkivera inlgg (till fil)")
    (kom-save-text-body	      . "Spara inlggstext (p fil)")
    (kom-save-options         . "Spara variabler")
    (kom-shutdown-server      . "Stng av servern")
    (kom-sync-database        . "Spara databasen")
    (kom-enable-adm-caps      . "verg till administratrsmod")
    (kom-disable-adm-caps     . "verg till normalmod")
    (kom-set-motd             . "Stt loginmeddelande")
    (kom-remove-motd          . "Ta bort loginmeddelande")
    (kom-force-logout         . "Kasta ut en session")
    (kom-filter-author        . "Filtrera frfattare")
    (kom-filter-subject       . "Filtrera rende")
    (kom-filter-text          . "Filtrera innehll")
    (kom-filter-recipient     . "Filtrera mottagare")
    (kom-super-jump           . "Superhoppa")
    (kom-filter-edit          . "ndra filter")
    (kom-list-filters         . "Lista filter")
    (kom-show-user-area       . "Visa user-arean")
    (kom-change-conf-type     . "ndra mtestyp")

    (kom-change-auto-reply    . "ndra svarsmeddelande")
    (kom-toggle-auto-reply    . "Automatsvar")
    (kom-list-messages        . "Lista meddelanden")
    (kom-erase-messages       . "Radera meddelanden")

    (kom-remote-autoreply     . "Fjrrkontrollera automatsvar")
    (kom-remote-set-message   . "Fjrrkontrollera ndra svarsmeddelande")
    (kom-remote-list-messages . "Fjrrkontrollera lista meddelanden")
    (kom-remote-erase-messages . "Fjrrkontrollera radera meddelanden")
    (kom-remote-quit          . "Fjrrkontrollera avsluta")

    (kom-status-session       . "Status (fr) session")
    (kom-customize            . "Instllningar (fr) LysKOM")
    (kom-next-kom             . "Nsta LysKOM")
    (kom-previous-kom         . "Fregende LysKOM")
    (kom-next-unread-kom      . "Nsta olsta LysKOM")
    (kom-change-language      . "ndra sprk")
    (kom-calculate            . "Berkna")
    (kom-list-marks           . "Lista markeringar")
    (kom-where-is             . "Var finns kommandot")
    (kom-fast-reply           . "Anmrkning (till inlgg)")
    (kom-agree                . "Hlla med")
    (kom-add-faq              . "Addera FAQ")
    (kom-del-faq              . "Ta bort FAQ")
    (kom-review-faq           . "terse FAQ")

    (kom-add-footnote	      . "Addera fotnot")
    (kom-sub-footnote	      . "Subtrahera fotnot")

    (kom-add-no-comments      . "Frhindra kommentarer")
    (kom-add-private-answer   . "Begr personligt svar")
    (kom-add-request-confirm  . "Begr lsbekrftelse")

    (kom-review-mail-headers  . "terse brevhuvud")
    
    (kom-compare-texts        . "Jmfr tv texter")
    (kom-diff-texts           . "Se diff")

    (kom-become-anonymous     . "Bli anonym")
    (kom-become-nonanonymous  . "Bli icke-anonym (trd fram ur skuggorna)")

    (kom-keep-alive           . "Hll frbindelsen aktiv")
    (kom-stop-keep-alive      . "Avbryt hll frbindelsen aktiv")

    (kom-is-person-member-of-conference . "Kontrollera (om person r) medlem (i mte)")
    (kom-change-conf-faq      . "ndra FAQ")

    (kom-make-review-mark-as-read . "terse lsmarkerar")
    (kom-make-review-not-mark-as-read . "terse lsmarkerar inte")

    (kom-set-presentation     . "Addera presentation")
    (kom-remove-presentation  . "Ta bort presentation")
    (kom-set-motd-text        . "Addera lapp p drren")
    (kom-create-aux-item      . "Skapa tillggsinformation")
    (kom-status-server        . "Status (fr) servern")
    (kom-add-server-faq       . "Addera server-FAQ")
    (kom-del-server-faq       . "Ta bort server-FAQ")
    (kom-review-server-faq    . "terse server-FAQ")
    (kom-change-server-faq    . "ndra server-FAQ")
    (kom-recommend-conference . "Rekommendera mte")
    (kom-redirect-comments    . "Dirigera om kommentarer")
    (kom-move-text-tree       . "Flytta trd")
    ))

(lyskom-language-var local lyskom-language-codes sv
  '((aa . "Afar")
    (ab . "Abkhasianska")
    (af . "Afrikaans")
    (am . "Amhariska")
    (ar . "Arabiska")
    (as . "Assamesiska")
    (ay . "Aymara")
    (az . "Azerbajanska")
    (ba . "Bashkiriska")
    (be . "Vitryska")
    (bg . "Bulgariska")
    (bh . "Bihariska")
    (bi . "Bislamska")
    (bn . "Bengaliska")
    (bo . "Tibetanska")
    (br . "Bretangneska")
    (ca . "Katalanska")
    (co . "Korsikanska")
    (cs . "Tjeckiska")
    (cy . "Walesiska")
    (da . "Danska")
    (de . "Tyska")
    (dz . "Bhutanska")
    (el . "Grekiska")
    (en . "Engelska")
    (eo . "Esperanto")
    (es . "Spanska")
    (et . "Estniska")
    (eu . "Baskiska")
    (fa . "Persiska")
    (fi . "Finska")
    (fj . "Fiji")
    (fo . "Fariska")
    (fr . "Franska")
    (fy . "Frisiska")
    (ga . "Irlndska")
    (gd . "Skotsk Gliska")
    (gl . "Galiciska")
    (gn . "Guarani")
    (gu . "Gujaratiska")
    (ha . "Hausa")
    (he . "Hebreiska")
    (hi . "Hindi")
    (hr . "Kroatiska")
    (hu . "Ungerska")
    (hy . "Armeniska")
    (ia . "Interlingua")
    (id . "Indonesiska")
    (ie . "Interlingue")
    (ik . "Inupiak")
    (is . "Islndska")
    (it . "Italienska")
    (iu . "Inuktitut")
    (ja . "Japanska")
    (jw . "Javanesiska")
    (ka . "Georgiska")
    (kk . "Kazakhstanska")
    (kl . "Grnlndska")
    (km . "Kambodianska")
    (kn . "Kannada")
    (ko . "Koreanska")
    (ks . "Kashmiriska")
    (ku . "Kurdiska")
    (ky . "Kirghiz")
    (la . "Latinska")
    (ln . "Lingala")
    (lo . "Laotesiska")
    (lt . "Litauiska")
    (lv . "Lettiska")
    (mg . "Malagasiska")
    (mi . "Maori")
    (mk . "Makedonska")
    (ml . "Malayalam")
    (mn . "Mongolska")
    (mo . "Moldaviska")
    (mr . "Marathi")
    (ms . "Malaysiska")
    (mt . "Maltesiska")
    (my . "Burmesiska")
    (na . "Nauruiska")
    (ne . "Nepalska")
    (nl . "Hollndska")
    (no . "Norska")
    (oc . "Occitanska")
    (om . "Oromo")
    (or . "Oriya")
    (pa . "Pundjabiska")
    (pl . "Polska")
    (ps . "Pashtu")
    (pt . "Protugisiska")
    (qu . "Quechua")
    (rm . "Rhtoromanska")
    (rn . "Kirundiska")
    (ro . "Rumnska")
    (ru . "Ryska")
    (rw . "Kiyarwanda")
    (sa . "Sanskrit")
    (sd . "Sindhi")
    (sg . "Sangho")
    (sh . "Serbokroatiska")
    (si . "Singhalesiska")
    (sk . "Slovakiska")
    (sl . "Slovenska")
    (sm . "Samoanska")
    (sn . "Shoniska")
    (so . "Somaliska")
    (sq . "Albanska")
    (sr . "Serbiska")
    (ss . "Siswatiska")
    (st . "Sesothiska")
    (su . "Sudanesiska")
    (sv . "Svenska")
    (sw . "Swahili")
    (ta . "Tamilska")
    (te . "Telugu")
    (tg . "Tajikiska")
    (th . "Thailndska")
    (ti . "Tigrinya")
    (tk . "Turkmenistanska")
    (tl . "Tagalog")
    (tn . "Sichuanska")
    (to . "Tongiska")
    (tr . "Turkiska")
    (ts . "Tsongiska")
    (tt . "Tatariska")
    (tw . "Twi")
    (ug . "Uiguriska")
    (uk . "Ukrainska")
    (ur . "Urdu")
    (uz . "Uzbekistanska")
    (vi . "Vietnamesiska")
    (vo . "Volapk")
    (wo . "Wolof")
    (xh . "Xhosa")
    (yi . "Yiddish")
    (yo . "Yorouba")
    (za . "Zhuang")
    (zh . "Kinesiska")
    (zu . "Zulu")
    (-- . "Oknt sprk (%#1s)")))


(lyskom-language-strings global lyskom-menu sv
  '((lyskom    . "LysKOM")
    (read      . "Ls")
    (dont-read . "Hoppa")
    (write     . "Skriv")
    (conference . "Mte")
    (person    . "Person")
    (other     . "Annat")
    (marks     . "Markeringar")
    (move      . "G")
    (info      . "Om")
    (send      . "Snd")
    (receivers . "Mottagare")
    (commented . "Kommenterar")
    (kom-edit-send . "Skicka in")
    (kom-edit-send-anonymous . "Skicka anonymt")
    (kom-edit-quit . "Kasta bort") 
    (kom-ispell-message . "Stavningskontroll")
    (kom-edit-add-recipient . "Addera mottagare")
    (kom-edit-add-copy . "Addera extra kopiemottagare")
    (kom-edit-show-commented . "terse det kommenterade")
    (kom-edit-insert-commented . "Citera det kommenterade")
    (kom-edit-insert-buglist . "Klistra in kommenterad buglista")
    (kom-edit-add-bcc . "Addera dold kopia")
    (kom-edit-add-cross-reference . "Addera korsreferens")
    (kom-edit-add-no-comments . "Begr inga kommentarer")
    (kom-edit-add-personal-comments . "Begr personliga svar")
    (kom-edit-add-read-confirm-request . "Begr lsbekrftelse")
    (kom-edit-move-text . "Flytta till en ny mottagare")
))

(lyskom-language-var local lyskom-move-tree-actions sv
                     '(("Flytta eller subtrahera mottagare" . move)
                       ("Lmna kvar och fortstt med kommentarerna" . skip)
                       ("Avsluta helt" . quit)
                       ("Hoppa ver inlgget och dess kommentarstrd" . jump)))

(lyskom-language-var local lyskom-onoff-table sv
  '(("p" . on) ("av" . off)))

(lyskom-language-var local lyskom-filter-predicate-list sv
      '(("=" . nil) ("!=" . t)))

(lyskom-language-var local lyskom-filter-what sv
      '((author . "Frfattare")
        (author-no . "Frfattare (nummer)")
        (author-re . "Frfattare (regexp)")
        (subject . "rende")
        (subject-re . "rende (regexp)")
        (recipient . "Mottagare")
        (recipient-no . "Mottagare (nummer)")
        (recipient-re . "Mottagare (regexp)")
        (text . "Innehll")
        (text . "Innehll (regexp)")))

(lyskom-language-var local lyskom-filter-actions sv
      '((skip-text . "Hoppa ver")
        (dontshow . "Visa inte")
        (read . "Undanta frn filtrering")
        (skip-tree . "Hoppa ver kommentarer")))
                               

(defconst lyskom-keybindings-missing '(lyskom-previous-prefix))

(defvar lyskom-sv-mode-map nil)
(lyskom-language-keymap lyskom-mode-map sv lyskom-sv-mode-map)

(defvar lyskom-sv-S-prefix nil)
(defvar lyskom-sv-list-prefix nil)
(defvar lyskom-sv-fast-reply-prefix nil)
(defvar lyskom-sv-filter-get-prefix nil)

(if lyskom-sv-mode-map
    nil
  (setq lyskom-sv-mode-map (make-keymap))
  (suppress-keymap lyskom-sv-mode-map)
  (define-prefix-command 'lyskom-sv-review-prefix)
  (define-prefix-command 'lyskom-sv-change-prefix)
  (define-prefix-command 'lyskom-sv-next-prefix)
  (define-prefix-command 'lyskom-sv-list-prefix)
  (define-prefix-command 'lyskom-sv-S-prefix)
  (define-prefix-command 'lyskom-sv-fast-reply-prefix)
  (define-prefix-command 'lyskom-sv-filter-get-prefix)
  (define-prefix-command 'lyskom-sv-who-prefix)

  (define-key lyskom-sv-mode-map (kbd "f") 'lyskom-sv-filter-get-prefix)
  (define-key lyskom-sv-mode-map (kbd "n") 'lyskom-sv-next-prefix)
  (define-key lyskom-sv-mode-map (kbd "l") 'lyskom-sv-list-prefix)
  (define-key lyskom-sv-mode-map (kbd "s") 'lyskom-sv-S-prefix)
  (define-key lyskom-sv-mode-map (kbd "r") 'lyskom-sv-fast-reply-prefix)
  (define-key lyskom-sv-mode-map (kbd "v") 'lyskom-sv-who-prefix)
  (define-key lyskom-sv-mode-map (lyskom-keys ') 'lyskom-sv-change-prefix)
  (define-key lyskom-sv-mode-map (lyskom-keys ') 'lyskom-sv-change-prefix)
  (define-key lyskom-sv-mode-map (lyskom-keys ') 'lyskom-sv-review-prefix)
  (define-key lyskom-sv-mode-map (lyskom-keys ') 'lyskom-sv-review-prefix)
  (define-key lyskom-sv-mode-map [] 'lyskom-sv-change-prefix)
  (define-key lyskom-sv-mode-map [] 'lyskom-sv-change-prefix)
  (define-key lyskom-sv-mode-map [] 'lyskom-sv-review-prefix)
  (define-key lyskom-sv-mode-map [] 'lyskom-sv-review-prefix)

  (define-key lyskom-sv-mode-map (kbd "M-m") 'kom-toggle-mark-as-read-prefix)

  (define-key lyskom-sv-mode-map (kbd (lyskom-keys 'button2)) 'kom-button-click)
  (define-key lyskom-sv-mode-map (kbd (lyskom-keys 'button3))   'kom-popup-menu)
  (define-key lyskom-sv-mode-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-sv-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-sv-mode-map (kbd "*")     'kom-button-press)
  (define-key lyskom-sv-mode-map (kbd "=")     'kom-menu-button-press)
  (define-key lyskom-sv-mode-map (kbd "TAB")   'kom-next-link)
  (define-key lyskom-sv-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-sv-mode-map (kbd "<S-tab>") 'kom-previous-link)
  (define-key lyskom-sv-mode-map (kbd "C-i")   'kom-next-link)
  (define-key lyskom-sv-mode-map (kbd "M-C-i") 'kom-previous-link)

  (define-key lyskom-sv-mode-map (kbd "{") 'lyskom-sv-change-prefix) ; krullar
  (define-key lyskom-sv-mode-map (kbd "[") 'lyskom-sv-change-prefix)
  (define-key lyskom-sv-mode-map (kbd "}") 'lyskom-sv-review-prefix)
  (define-key lyskom-sv-mode-map (kbd "]") 'lyskom-sv-review-prefix)


  ;;(define-key lyskom-sv-mode-map "vi" 'vilka)
  
  ;; These should be first in order to be last in the menu of alternatives.
  (define-key lyskom-sv-mode-map (kbd "{ ?") 'lyskom-help)
  (define-key lyskom-sv-mode-map (kbd "} ?") 'lyskom-help)
  (define-key lyskom-sv-mode-map (kbd "f ?") 'lyskom-help)
  (define-key lyskom-sv-mode-map (kbd "n ?") 'lyskom-help)
  (define-key lyskom-sv-mode-map (kbd "l ?") 'lyskom-help)
  (define-key lyskom-sv-mode-map (kbd "s ?") 'lyskom-help)
  (define-key lyskom-sv-mode-map (kbd "v ?") 'lyskom-help)
  

  (define-key lyskom-sv-mode-map (kbd "e")   'kom-set-unread)
  (define-key lyskom-sv-mode-map (kbd "a")   'kom-obsolete-extended-command-binding)
  (define-key lyskom-sv-mode-map (kbd "l v") 'kom-obsolete-who-is-on-in-conference)
  (define-key lyskom-sv-mode-map (kbd "x")   'kom-extended-command)
  (define-key lyskom-sv-mode-map (kbd "<SPC>") 'kom-next-command)
  (define-key lyskom-sv-mode-map (kbd "<RET>") 'kom-line-next-command)
  (define-key lyskom-sv-mode-map (kbd "<LFD>") 'kom-page-next-command)
  (define-key lyskom-sv-mode-map (kbd "C-j") 'kom-page-next-command)
  (define-key lyskom-sv-mode-map (kbd "j")   'kom-page-next-command)
  (define-key lyskom-sv-mode-map (kbd "C-m") 'kom-line-next-command)

  (define-key lyskom-sv-mode-map (kbd "?")   'kom-help)
  (define-key lyskom-sv-mode-map (kbd "b")   'kom-send-letter)
  (define-key lyskom-sv-mode-map (kbd "g")   'kom-go-to-conf)
  (define-key lyskom-sv-mode-map (kbd "i")   'kom-write-text)
  (define-key lyskom-sv-mode-map (kbd "k")   'kom-write-comment)
  (define-key lyskom-sv-mode-map (kbd "K")   'kom-comment-previous)
  (define-key lyskom-sv-mode-map (kbd "F")   'kom-write-footnote)
  (define-key lyskom-sv-mode-map (kbd "p")   'kom-private-answer)
  (define-key lyskom-sv-mode-map (kbd "P")   'kom-private-answer-previous)
  (define-key lyskom-sv-mode-map (kbd "h")   'kom-jump)
  (define-key lyskom-sv-mode-map (kbd "H")   'kom-super-jump)
  (define-key lyskom-sv-mode-map (kbd "l M") 'kom-list-marks)
  (define-key lyskom-sv-mode-map (kbd "l m") 'kom-list-conferences)
  (define-key lyskom-sv-mode-map (kbd "l n") 'kom-list-news)
  (define-key lyskom-sv-mode-map (kbd "l p") 'kom-list-persons)
  (define-key lyskom-sv-mode-map (kbd "l r") 'kom-list-re)
  (define-key lyskom-sv-mode-map (kbd "l s") 'kom-membership)
  (define-key lyskom-sv-list-prefix (lyskom-keys ') 'kom-list-summary)
  (define-key lyskom-sv-list-prefix (lyskom-keys ') 'kom-list-summary)
  (define-key lyskom-sv-list-prefix [] 'kom-list-summary)
  (define-key lyskom-sv-list-prefix [] 'kom-list-summary)
  (define-key lyskom-sv-mode-map (kbd "l {") 'kom-list-summary)
  (define-key lyskom-sv-mode-map (kbd "l [") 'kom-list-summary)
  (define-key lyskom-sv-mode-map (kbd "l f") 'kom-list-filters)
  (define-key lyskom-sv-mode-map (kbd "m")   'kom-add-self)
  (define-key lyskom-sv-mode-map (kbd "M")   'kom-mark-text)
  (define-key lyskom-sv-mode-map (kbd "A")   'kom-unmark-text)
  (define-key lyskom-sv-mode-map (kbd "n i") 'kom-view-next-new-text)
  (define-key lyskom-sv-mode-map (kbd "n m") 'kom-go-to-next-conf)
  (define-key lyskom-sv-mode-map (kbd "n l") 'kom-next-kom)
  (define-key lyskom-sv-mode-map (kbd "n o") 'kom-next-unread-kom)
  (define-key lyskom-sv-mode-map (kbd "f l") 'kom-previous-kom)
  (define-key lyskom-sv-mode-map (kbd "S")   'kom-quit)
  (define-key lyskom-sv-mode-map (kbd "q")   'kom-quit)
  (define-key lyskom-sv-mode-map (kbd "z")   'kom-bury)
  (define-key lyskom-sv-mode-map (kbd "R")   'kom-recover)
  (define-key lyskom-sv-mode-map (kbd "t")   'kom-display-time)
  (define-key lyskom-sv-mode-map (kbd "f u") 'kom-get-appreciation)
  (define-key lyskom-sv-mode-map (kbd "f s") 'kom-get-abuse)
  (define-key lyskom-sv-mode-map (kbd "f t") 'kom-move-text)
  (define-key lyskom-sv-mode-map (kbd "f T") 'kom-move-text-tree)
  (define-key lyskom-sv-filter-get-prefix (lyskom-keys ') 'kom-filter-subject)
  (define-key lyskom-sv-filter-get-prefix (lyskom-keys ') 'kom-filter-subject)
  (define-key lyskom-sv-filter-get-prefix [] 'kom-filter-subject)
  (define-key lyskom-sv-filter-get-prefix [] 'kom-filter-subject)
  (define-key lyskom-sv-mode-map (kbd "f {") 'kom-filter-subject)
  (define-key lyskom-sv-mode-map (kbd "f [") 'kom-filter-subject)
  (define-key lyskom-sv-mode-map (kbd "f f") 'kom-filter-author)
  (define-key lyskom-sv-mode-map (kbd "f i") 'kom-filter-text)
  (define-key lyskom-sv-mode-map (kbd "f m") 'kom-filter-recipient)
  (define-key lyskom-sv-mode-map (kbd "v i") 'kom-who-is-on)
  (define-key lyskom-sv-mode-map (kbd "v m") 'kom-who-is-on-in-conference)
  (define-key lyskom-sv-mode-map (kbd "v n") 'kom-who-is-present-in-conference)
  (define-key lyskom-sv-mode-map (kbd "v v") 'kom-who-is-on-and-friend)
  (define-key lyskom-sv-mode-map (kbd "J")   'kom-who-am-i)
  (define-key lyskom-sv-mode-map (kbd "V")   'kom-busy-wait)
  (define-key lyskom-sv-mode-map (kbd "{ p") 'kom-change-presentation)
  (define-key lyskom-sv-mode-map (kbd "{ q") 'kom-change-conf-faq)
  (define-key lyskom-sv-mode-map (kbd "{ f") 'kom-filter-edit)
  (define-key lyskom-sv-mode-map (kbd "{ m") 'kom-change-auto-reply)
  (define-key lyskom-sv-mode-map (kbd "} SPC") 'kom-view)
  (define-key lyskom-sv-mode-map (kbd "} 0") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 1") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 2") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 3") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 4") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 5") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 6") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 7") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 8") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} 9") 'kom-initial-digit-view)
  (define-key lyskom-sv-mode-map (kbd "} k") 'kom-view-commented-text)
  (define-key lyskom-sv-mode-map (kbd "} K") 'kom-view-previous-commented-text)
  (define-key lyskom-sv-mode-map (kbd "} a ?") 'lyskom-help)
  (define-key lyskom-sv-mode-map (kbd "} a k") 'kom-review-comments)
  (define-key lyskom-sv-mode-map (kbd "} a r") 'kom-review-tree)
  (define-key lyskom-sv-mode-map (kbd "} h") 'kom-review-clear)
  (define-key lyskom-sv-mode-map (kbd "} i") 'kom-review-last-normally-read)
  (define-key lyskom-sv-mode-map (kbd "} n") 'kom-review-next)
  (define-key lyskom-sv-mode-map (kbd "} o") 'kom-review-noconversion)
  (define-key lyskom-sv-mode-map (kbd "} r") 'kom-find-root)
  (define-key lyskom-sv-mode-map (kbd "} u") 'kom-find-root)
  (define-key lyskom-sv-mode-map (kbd "} s") 'kom-review-by-to)
  (define-key lyskom-sv-mode-map (kbd "} y") 'kom-review-more)
  (define-key lyskom-sv-mode-map (kbd "} A") 'kom-review-all)
  (define-key lyskom-sv-mode-map (kbd "} f") 'kom-review-first)
  (define-key lyskom-sv-mode-map (kbd "} l") 'kom-review-stack)
  (define-key lyskom-sv-mode-map (kbd "} p") 'kom-review-presentation)
  (define-key lyskom-sv-mode-map (kbd "} t") 'kom-find-root-review)
  (define-key lyskom-sv-mode-map (kbd "} m") 'kom-review-marked-texts)
  (define-key lyskom-sv-mode-map (kbd "} q") 'kom-review-faq)
  (define-key lyskom-sv-mode-map (kbd "} Q") 'kom-review-server-faq)
  (define-key lyskom-sv-mode-map (kbd "} a m") 'kom-review-all-marked-texts)
  (define-key lyskom-sv-mode-map (kbd "} a SPC") 'kom-review-all)
  (define-key lyskom-sv-mode-map (kbd "} b") 'kom-review-mail-headers)
  (define-key lyskom-sv-mode-map (kbd "B")   'kom-review-backward)
  (define-key lyskom-sv-mode-map (kbd "s m") 'kom-status-conf)
  (define-key lyskom-sv-mode-map (kbd "s p") 'kom-status-person)
  (define-key lyskom-sv-mode-map (kbd "s s") 'kom-status-session)
  (define-key lyskom-sv-mode-map (kbd "s k") 'kom-status-server)
  (define-key lyskom-sv-S-prefix (lyskom-keys ') 'kom-send-message)
  (define-key lyskom-sv-S-prefix (lyskom-keys ') 'kom-send-message)
  (define-key lyskom-sv-S-prefix [] 'kom-send-message)
  (define-key lyskom-sv-S-prefix [] 'kom-send-message)
  (define-key lyskom-sv-mode-map (kbd "s {") 'kom-send-message)
  (define-key lyskom-sv-mode-map (kbd "s [") 'kom-send-message)

  (define-key lyskom-sv-mode-map (kbd "r a") 'kom-fast-reply)
  (define-key lyskom-sv-mode-map (kbd "r r") 'kom-fast-reply)
  (define-key lyskom-sv-mode-map (kbd "r h") 'kom-agree)
  
  ;; Running in buffer

  (define-key lyskom-sv-mode-map (kbd "M-p") 'backward-text)
  (define-key lyskom-sv-mode-map (kbd "M-n") 'forward-text)
  (define-key lyskom-sv-mode-map (kbd "C-M-p") 'kom-prev-prompt)
  (define-key lyskom-sv-mode-map (kbd "C-M-n") 'kom-next-prompt)
  (define-key lyskom-sv-mode-map (kbd "s t") 'kom-save-text)

  (define-key lyskom-sv-mode-map (kbd "C-?") 'scroll-down)
  (define-key lyskom-sv-mode-map (kbd "<DEL>") 'scroll-down)
  (define-key lyskom-sv-mode-map (kbd "<delete>") 'scroll-down)
  (define-key lyskom-sv-mode-map (kbd "<BS>") 'scroll-down)
)





;;;==============================================================
;;; Keymap for filter editing
;;;

(defvar lyskom-sv-filter-edit-map nil)
(lyskom-language-keymap lyskom-filter-edit-map sv lyskom-sv-filter-edit-map)

(if lyskom-sv-filter-edit-map ()
  (setq lyskom-sv-filter-edit-map (make-keymap))
  (suppress-keymap lyskom-sv-filter-edit-map)
  (define-prefix-command 'lyskom-sv-filter-edit-prefix)
  (define-key lyskom-sv-filter-edit-map (kbd "C-c") 'lyskom-sv-filter-edit-prefix)
  (define-key lyskom-sv-filter-edit-map (kbd "p")   'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "P")   'lyskom-filter-edit-prev-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "n")   'lyskom-filter-edit-next-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "N")   'lyskom-filter-edit-next-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "C-p") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "C-n") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "C-b") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "C-f") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "M-p") 'lyskom-filter-edit-prev-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "M-n") 'lyskom-filter-edit-next-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "d")   'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "M-d") 'lyskom-filter-edit-delete-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "D")   'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "C-d") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "i")   'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "I")   'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "M-i") 'lyskom-filter-edit-insert-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "<")   'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-sv-filter-edit-map (kbd ">")   'lyskom-filter-edit-end-of-list)
  (define-key lyskom-sv-filter-edit-map (kbd "M-<") 'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-sv-filter-edit-map (kbd "M->") 'lyskom-filter-edit-end-of-list)
  (define-key lyskom-sv-filter-edit-map (kbd "q")   'lyskom-filter-edit-quit)
  (define-key lyskom-sv-filter-edit-map (kbd "C-c C-c")   'lyskom-filter-edit-quit)
  (define-key lyskom-sv-filter-edit-map (kbd "x")   'lyskom-filter-edit-expunge)
  (define-key lyskom-sv-filter-edit-map (kbd "s")   'lyskom-filter-edit-save)
  (define-key lyskom-sv-filter-edit-map (kbd "g")   'lyskom-filter-edit-revert)
  (define-key lyskom-sv-filter-edit-map (kbd "t")   'lyskom-filter-edit-toggle-permanent)
  (define-key lyskom-sv-filter-edit-map (kbd "a")   'lyskom-filter-edit-toggle-action)
  (define-key lyskom-sv-filter-edit-map (kbd "?")   'lyskom-filter-edit-brief-help)
  (define-key lyskom-sv-filter-edit-map (kbd "h")   'lyskom-filter-edit-brief-help)
  )



(defvar lyskom-sv-prioritize-mode-map nil)
(lyskom-language-keymap lyskom-prioritize-mode-map sv 
  lyskom-sv-prioritize-mode-map)

(if lyskom-sv-prioritize-mode-map 
    nil
  (setq lyskom-sv-prioritize-mode-map (make-keymap))
  (suppress-keymap lyskom-sv-prioritize-mode-map)
  (define-key lyskom-sv-prioritize-mode-map (kbd (lyskom-keys 'button2)) 'kom-button-click)
  (define-key lyskom-sv-prioritize-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-sv-prioritize-mode-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-sv-prioritize-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-sv-prioritize-mode-map (kbd "*") 'kom-button-press)
  (define-key lyskom-sv-prioritize-mode-map (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-sv-prioritize-mode-map (kbd "?") 'kom-prioritize-help)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-k") 'kom-prioritize-select)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-y") 'kom-prioritize-yank)
  (define-key lyskom-sv-prioritize-mode-map (kbd "SPC") 'kom-prioritize-select)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-m") 'kom-prioritize-next-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "RET") 'kom-prioritize-next-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-j") 'kom-prioritize-next-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "<down>") 'kom-prioritize-next-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-n") 'kom-prioritize-next-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "DEL") 'kom-prioritize-previous-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-DEL") 'kom-prioritize-deselect-all)
  (define-key lyskom-sv-prioritize-mode-map (kbd "<up>") 'kom-prioritize-previous-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-p") 'kom-prioritize-previous-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "p") 'kom-prioritize-previous-line)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-<up>") 'kom-prioritize-move-up)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-p") 'kom-prioritize-move-up)
  (define-key lyskom-sv-prioritize-mode-map (kbd "u") 'kom-prioritize-move-up)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-<down>") 'kom-prioritize-move-down)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-n") 'kom-prioritize-move-down)
  (define-key lyskom-sv-prioritize-mode-map (kbd "d") 'kom-prioritize-move-down)
  (define-key lyskom-sv-prioritize-mode-map (kbd "n") 'kom-prioritize-move-down)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-<") 'kom-prioritize-beginning)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M->") 'kom-prioritize-end)
  (define-key lyskom-sv-prioritize-mode-map (kbd "r") 'kom-prioritize-reprioritize)
  (define-key lyskom-sv-prioritize-mode-map (kbd "g") 'kom-prioritize-goto-priority)
  (define-key lyskom-sv-prioritize-mode-map (kbd "p") 'kom-prioritize-set-priority)
  (define-key lyskom-sv-prioritize-mode-map (kbd "s") 'kom-prioritize-save)
  (define-key lyskom-sv-prioritize-mode-map (kbd "q") 'kom-prioritize-quit)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-c C-c") 'kom-prioritize-quit)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-i") 'kom-next-link)
  (define-key lyskom-sv-prioritize-mode-map (kbd "TAB") 'kom-next-link)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-sv-prioritize-mode-map (kbd "<S-tab>") 'kom-previous-link)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-C-i") 'kom-previous-link)
)


(lyskom-language-var local lyskom-prioritize-header-lines sv 2)

(lyskom-language-var local lyskom-prioritize-header sv
" Prio   Mte
-------------------------------------------------------------------------------
")



;;;; ============================================================
;;;; Strings and things for the customize mode
;;;;

(defvar lyskom-sv-customize-map nil)
(lyskom-language-keymap lyskom-customize-map sv lyskom-sv-customize-map)


(if lyskom-sv-customize-map
    nil
  (setq lyskom-sv-customize-map (make-sparse-keymap))
  (define-key lyskom-sv-customize-map (kbd "TAB") 'widget-forward)
  (define-key lyskom-sv-customize-map (kbd "M-TAB") 'widget-backward)
  (define-key lyskom-sv-customize-map (kbd "<S-tab>") 'widget-backward)
  (define-key lyskom-sv-customize-map (kbd "C-i") 'widget-forward)
  (define-key lyskom-sv-customize-map (kbd "M-C-i") 'widget-backward)
  (define-key lyskom-sv-customize-map (kbd "C-m") 'widget-button-press)
  (define-key lyskom-sv-customize-map (kbd "C-j") 'widget-button-press)
  (define-key lyskom-sv-customize-map (kbd "<RET>") 'widget-button-press)
  (define-key lyskom-sv-customize-map (kbd "<LFD>") 'widget-button-press)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button2)) 'widget-button-click)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button3)) 'lyskom-widget-click)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-sv-customize-map (kbd "C-c C-c") 'lyskom-customize-save-and-quit)
  (define-key lyskom-sv-customize-map (kbd "C-c C-k") 'lyskom-customize-quit)
  (define-key lyskom-sv-customize-map (kbd "C-c C-s") 'lyskom-customize-save)
  (define-key lyskom-sv-customize-map (kbd "C-c C-a") 'lyskom-customize-apply)
  (define-key lyskom-sv-customize-map (kbd "?") 'lyskom-customize-help)
)

(lyskom-language-strings local lyskom-custom-strings sv
  '(
    ;;
    ;; Widget strings
    ;;

    (which-person . "Ange en person: ")
    (which-conf . "Ange ett mte: ")
    (which-conf-or-person . "Ange en person eller ett mte: ")
    (which-name . "Ange ett namn: ")
    (some-person . "Person %#1d")
    (invalid-value . "Otilltet vrde (%#1S)")
    (unknown-command . "Oknt kommando (%#1s)")
    (ding . "Ljudsignal")

    ;;
    ;; Help messages
    ;;

    (variable-type-help . "Kryssa i fr att spara instllningen i servern.")
    (default-help-echo . "ndra vrdet p %#1s.")
    (change-this-name . "ndra namnet p denna rad.")
    (show-doc . "Visa hjlptexten.")
    (hide-doc . "Dlj hjlptexten.")
    (select-command . "Vlj kommando.")
    (select-what-to-execute . "Exekvera kommando eller tangentbordsmakro.")
    (select-url-viewer . "Vlj en WWW-lsare.")
    (select-number . "Ange hur mnga gnger.")
    (select-audio-file . "Ange en ljudfil.")
    (select-priority . "Ange prioritet.")
    (select-buffer . "Ange buffert.")
    (select-buffer-size . "Ange buffertstorlek.")

    ;;
    ;; Strings that are used in types and so forth
    ;;

    (buffer-name . "%#1s-instllningar")

    (other-window     . "Ngot annat fnster            ")
    (other-frame      . "I en annan frame               ")
    (new-frame        . "I en ny frame                  ")
    (lyskom-window    . "LysKOM-buffertens fnster      ")
    (window-on-buffer . "Ett fnster som visar bufferten")

    (on . "P")
    (off . "Av")
    (yes . "Ja ")
    (no . "Nej")
    (to-file . "Till fil:")
    (max-text-length . "Fr inlgg kortare n: ")
    
    (friends . "Vnner och bekanta")

    (turned-off      . "Avslaget            ")
    (number-of-times . "Ngra gnger")
    (specific-spec . "Per mottagare/avsndare")
    (sound-file . "Ljudfil")
    (other-persons . "Alla andra")
    (selected-mark . "Markering")
    (conf-or-person . "Person eller mte")
    (ask . "Frga varje gng")
    (before . "Fre texten")
    (after . "Efter texten")
    (first . "Frst")
    (last . "Sist ")
    (depth-first . "I kommentarsordning")
    (time-order . "I tidsordning")
    (limited-number . "Ett begrnsat antal")
    (unlimited-number . "Obegrnsat")

    (ar-message-type . "Meddelandetyp")
    (ar-personal     . "Personligt meddelande")
    (ar-group        . "Gruppmeddelande")
    (ar-alarm        . "Alarmmeddelande")
    (ar-any-type     . "Alla meddelandetyper")
    (ar-sender       . "Avsndare")
    (ar-any-sender   . "Alla avsndare")
    (ar-specified-sender . "Specifika avsndare")
    (ar-pers-or-conf . "Person eller mte")
    (ar-recipient    . "Mottagare")
    (ar-any-recipient . "Alla mottagare")
    (ar-specified-recipient . "Specifika mottagare")
    (ar-person       . "Person")
    (ar-message-text . "Meddelandetext")
    (ar-any-message  . "Alla meddelanden")
    (ar-matching-regexp . "Meddelanden som matchar")
    (ar-reply        . "Automatsvar")
    (ar-no-reply     . "Inget svar")
    (ar-reply-text   . "Svarstext")

    (express-break . "Omedelbart efter de har skapats")
    (break         . "Efter aktuell kommentarskedja")
    (no-break      . "Efter aktuellt mte")

    (express-server-break . "Omedelbart")
    (express-server-letters-break . "Omedelbart om det kommer brev")
    (server-break . "Efter aktuell kommentarskedja")
    (letters-server-break . "Efter aktuell kommentarskedja om det kommer brev")
    (after-conf-server-break . "Efter aktuellt mte")
    (after-conf-letters-server-break . "Efter aktuellt mte nr det kommer brev")
    (when-done-server-break . "Nr allt r utlst")
    (no-server-break . "Aldrig")

    (command . "Kommando")
    (command-list . "Kommandolista")
    (some-persons . "Fr vissa personer")
    (name . "Namn")

    (page-none . "Aldrig                 ")
    (page-all  . "Fre varje kommando    ")
    (page-some . "Fre fljande kommandon")

    (ask-every-time . "Frga varje gng      ")
    (fixed-priority . "Fast prioritet")

    (messages-in-lyskom-buffer . "I LysKOM-bufferten  ")
    (discard-messages .          "Ingenstans          ")
    (in-named-buffer .           "I namngiven buffert:")

    (everybody-rcpt .       "Alla                              ")
    (group-rcpt .           "Senaste gruppmeddelandes mottagare")
    (sender-rcpt .          "Senaste meddelandes avsndare     ")
    (last-recipient-recpt . "Senaste mottagaren                ")

    (viewer-program . "WWW-lsare")
    (no-viewer            . "(ingenting valt)")
    (default-viewer       . "Browse-URL (alla)")
    (netscape-viewer      . "Netscape/Mozilla (alla)")
    (windows-viewer       . "Windows standard eller Netscape/Mozilla (alla)")
    (emacs-w3-viewer      . "Emacs W3-mode (HTTP, Goper, FTP)")
    (emacs-general-viewer . "Emacs (FTP, Telnet, Mail)")
    (emacs-dired-viewer   . "Emacs Dired (FTP)")
    (emacs-mail-viewer    . "Emacs Mail-mode (Mail)")
    (emacs-telnet-viewer  . "Emacs Telnet-mode (telnet)")
    (mosaic-viewer        . "NCSA Mosaic (alla)")
    (lynx-viewer          . "Lynx (alla)")
    (galeon-viewer        . "Galeon (alla)")

    (dont-check . "Ingen bekrftelse")
    (check-before-open . "Bekrfta innan inlgget skrivs")
    (check-before-send . "Bekrfta innan inlgget snds")
    (no-size-limit . "Ingen begrnsning")
    (max-size-in-bytes . "Begrnsning (i bytes)")
    (execute . "Utfr")
    (kbd-macro . "Tangentbordmakro")
    (command . "Kommando")
    (enter-kbd-macro . "Mata in tangentbordsmakro. Avsluta med %#1s")

    (long-format  . "Visa hjlptexter")
    (short-format . "Gm hjlptexter ")

    (truncate-threshold-lines . "Max rader")

    (first . "Frst")
    (last . "Sist")
    (specific-placement . "Specifik plats")
    (priority . "Prioritet")
    (same-as-conf . "Samma som aktuellt mte")
    (custom-format . "Eget format:")
    (default-format . "Standardformat")
    (a-string . "En text:")
    (some-string . "En slumpmssig text")
    (unspecified . "Ospecificerat")

    (symbolic-mark-association . "Associering")
    (symbolic-mark-name . "Symboliskt namn: ")
    (mark-type-to-assoc . "Markeringstyp att associera till: ")

    (prompt-for-text-no . "Frga efter textnummer")

    (all-others . "Alla andra")
    (some-person . "Person")
    (format-html . "Formattera HTML:")

    ;;
    ;; Misc doc strings
    ;;

    (lyskom . "Instllningar fr LysKOM")
    (lyskom-doc . "\
\\[lyskom-customize-save-and-quit] fr att spara och avsluta,
\\[lyskom-customize-save] fr att spara utan att avsluta
\\[lyskom-customize-quit] fr att avsluta utan att spara
\\[widget-forward] flyttar till nsta instllning
\\[widget-button-press] ndrar vrdet

Hjlptexter: [?] Visa hjlptext    [!] Gm hjlptext
Listor mm.:  [INS] Lgg till rad   [DEL] Ta bort rad    [*] ndra vrde

Om rutan fre instllningens namn r ikryssad kommer vrdet att sparas
i servern. Annars sparas det i din .emacs.")

    (section . "------------------------------------------------------------------------------\n")
    (look-and-feel-misc . "Diverse utseende och beteende\n")
    (window-locations   . "Fnster\n")
    (windows-where      . "Hur skall fnster skapas:\n")
    (reading .            "Beteende vid lsning\n")
    (writing .            "Beteende vid skrivning\n")
    (urls .               "Hantering av URLer\n")
    (personal-messages .  "Hantering av personliga meddelanden\n")
    (remote-control .     "Fjrrstyrning av LysKOM\n")
    (hooks .              "Hook-funktioner\n")

    (audio-cues .         "Ljudsignaler\n")
    (audio-cues-when    . "Ge ljudsignal:\n")
    (automatic-replies .  "Automatiskt svar\n")
    
    (audio-cues-doc . "\
  Efterfljande instllningar bestmmer vilken ljudsignal LysKOM skall ge 
  i olika situationer. Fljande alternativ gr att vlja:

    Avslaget
        Ingen ljudsignal alls kommer att ges.

    Ngra gnger
        Emacs kommer att pipa en eller flera gnger nr hndelsen
        intrffar. Antal pip anges ocks. 

    Ljudfil
        Emacs kommer att spela upp den angivna ljudfilen. Programmet som
        angavs ovan som ljudspelarprogram anvnds fr att spela ljudet.")
    

    (sending-doc . "\
  Fljande instllningar slr p eller av vissa kontroller vid inskickning
  av inlgg. Kontrollerna r avsedda att hindra att man gr ngonting dumt.

    Bekrfta multipla mottagare
        Om ett inlgg eller kommentar har flera mottagare s kan LysKOM
        frga vilka av mottagarna som r relevanta fr inlgget. Antingen
        grs detta innan man skriver inlgget (d fr man en frga fr
        varje defaultmottagare), eller nr man skickar in inlgget (d fr
        man bekrfta alla mottagare i klump). Det gr ocks att sl av
        helt.

    Kontroll av kommenterad frfattares medlemskap
        Kontrollera att frfattaren till det kommenterade inlgget r
        medlem i ngon av mottagarna fr kommentaren. Om s inte r fallet,
        erbjuder LysKOM att lgga till frfattaren som mottagare till
        inlgget. 

    Frfattare som inte kontrolleras
        En lista av frfattare som inte skall kontrolleras ven om
        kontroll av kommenterad frfattares medlemskap r pslaget.

    Kontroll av olsta kommentarer
        Nr detta r pslaget s kontrollerar LysKOM att det inlgg man
        kommenterar inte har ngra kommentarer man inte har lst. Detta r
        frmst anvndbart fr att undvika att man skriver ngonting som
        ngon annan redan har skrivit.")


    (windows-doc . "\
  Fljande instllningar bestmmer hur fnster skapas i LysKOM. Alternativen
  som finns r fljande:

    Ngot annat fnster 
        I ett annat fnster i samma frame som LysKOM. Om det bara finns ett
        fnster s kommer ett nytt att skapas (och tas bort nr man r klar).

    I en annan frame
        I en annan frame n LysKOM. Om det bara finns en frame s kommer en
        ny frame att skapas, och (tas bort nr man r klar).

    I en ny frame
        En ny frame skapas fr ndamlet, och tas bort nr man r klar.

    LysKOM-buffertens fnster 
        LysKOM-buffertens fnster kommer att anvndas, och LysKOM kommer
        att terstllas till fnstret nr man r frdig.

    Ett fnster som visar bufferten 
        Om det finns ett fnster ngonstans som visar den angivna bufferten
        s kommer detta fnster att anvndas. Det kan till exempel vara
        anvndbart om man hela tiden har ett fnster ppet, men inte bever
        det just medan man utfr ngot visst kommando.")

    ;;
    ;; Doc strings for variables
    ;;

    (kom-ansaphone-replies-doc . "\
  Den hr instllningen styr automatsvar i detalj. Det gr att stlla in 
  svar fr specifika avsndare, mottagare och till och med meddelanden. Om
  meddelandet som skall besvaras inte stmmer in p ngot i den hr listan
  s anvnds svarsmeddelandet ovan istllet.

  Fr varje mnster gr det att stlla in meddelandetyp, avsndare som 
  meddelandet skall ha, mottagare som meddelandet skall ha, ett mnster
  som meddelandet skall innehlla och vilket svar som skall skickas.

  Det r lmpligt att stlla in att inget svar skall skickas p ngot
  gruppmeddelande eller alarmmeddelande.")

    (kom-bury-buffers-doc . "\
  Bestmmer hur bufferten hanteras nr man gr till ett annat KOM med Nsta
  LysKOM och liknande funktioner. Pslaget innebr att den aktuella bufferten
  lggs sist i buffertlistan nr man byter LysKOM.")

    (kom-personal-messages-in-window-doc . "\
  Bestmmer i vilket fnster som bufferten med personliga meddelanden visas.
  Fr att den hr instllningen skall spela ngon roll s mste personliga
  meddelanden visas i en separat buffert, och bufferten mste visas varje
  gng det kommer meddelanden.")

    (kom-write-texts-in-window-doc . "\
  Bestmmer i vilket fnster nya texter skrivs.")

    (kom-prioritize-in-window-doc . "\
  Bestmmer i vilket fnster man prioriterar om mten.")

    (kom-edit-filters-in-window-doc . "\
  Bestmmer i vilket fnster man ndrar filter.")

    (kom-customize-in-window-doc . "\
  Bestmmer i vilket fnster man gr dessa instllningar.")

    (kom-view-commented-in-window-doc . "\
  Bestmmer i vilket fnster man visar kommenterarer medan man skriver nya.")

    (kom-list-membership-in-window-doc . "\
  Bestmmer i vilket fnster man listar medlemskap.")


    (kom-user-prompt-format-doc . "\
  Format fr LysKOM-prompten. Vissa teckenkombinationer stter in speciella
  texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%] - \"             Standardprompt
    \"%[%s: %c% %m%] - \"         Till exempel \"LysKOM: Se tiden - \"")

    (kom-user-prompt-format-executing-doc . "\
  Format fr LysKOM-prompten efter man trycker p SPC eller RET.  Vissa
  teckenkombinationer stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%].\"             Standardprompt
    \"%[%s: Kr %c% %m%]...\"   Till exempel \"LysKOM: Kr Se tiden...\"")

    
    (kom-anonymous-prompt-format-doc . "\
  Format fr LysKOM-prompten nr man r anonym. Vissa teckenkombinationer 
  stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%] - \"             Standardprompt
    \"%[%s: %c% %m%] - \"         Till exempel \"LysKOM: Se tiden - \"")

    (kom-anonymous-prompt-format-executing-doc . "\
  Format fr LysKOM-prompten efter man trycker p SPC eller RET och r
  anonym.  Vissa teckenkombinationer stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%].\"             Standardprompt
    \"%[%s: Kr %c% %m%]...\"   Till exempel \"LysKOM: Kr Se tiden...\"")

    (kom-enabled-prompt-format-doc . "\
  Format fr LysKOM-prompten nr man r i administratrsmod. Vissa
  teckenkombinationer stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%] - \"             Standardprompt
    \"%[%s: %c% %m%] - \"         Till exempel \"LysKOM: Se tiden - \"")

    (kom-enabled-prompt-format-executing-doc . "\
  Format fr LysKOM-prompten efter man trycker p SPC eller RET och r i
  administratrsmod.  Vissa teckenkombinationer stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%].\"             Standardprompt
    \"%[%s: Kr %c% %m%]...\"   Till exempel \"LysKOM: Kr Se tiden...\"")

    (kom-cite-string-doc . "\
  Text som stts in fre varje rad i ett citerat inlgg. Normalt brukar
  ngonting i stil med \"> \" anvndas. Notera dock att det inte r brukligt
  att citera KOM-inlgg som man gr med sladdpost och News eftersom det
  kommenterade inlgget oftast finns tillgngligt.")


    (kom-created-texts-are-read-doc . "\
  Om detta r pslaget kommer alla inlgg man sjlv skriver att lsmarkeras
  automatiskt. Om instllningen r avslagen s fr man lsa sdant man
  sjlv skriver.")


    (kom-default-mark-doc . "\
  Den markeringstyp som anvnds fr nya markeringar. En markeringstyp r ett
  heltal mellan 0 och 255 (inklusive). Om ingen defaultmarkeringstyp r vald
  frgar LysKOM efter markeringstyp varje gng man markerar en text. Detta
  kan anvndas fr att hlla isr olika sorters markeringar. Till exempel
  kan man markera inlgg som innehller intressant information med ett visst
  tal och inlgg som man ska komma ihg att kommentera vid ett senare
  tillflle med ett annat tal.")

    (kom-symbolic-marks-alist-doc . "\
  Fr att slippa behva memorera vad man tnkte sig att de heltaliga
  markeringstyperna ska innebra kan man definiera en lista med symboliska
  markeringstyper. En symbolisk markeringstyp r en beskrivande strng som
  associeras med en heltalig markeringstyp.")

    (kom-reading-puts-comments-in-pointers-last-doc . "\
  Bestmmer om kommentarslnkar visas fre eller efter en text. Normalt brukar
  man visa kommentarslnkar efter texten.

  Fre:

    398331 1996-09-24  13:22  /2 rader/ George Berkeley
    Mottagare: Filosofimtet <1226>
    Kommentar i text 398374 av John Locke
    rende: 
    ------------------------------------------------------------
    En abstrakt id r en sjlvmotsgelse. 
    (398331) -----------------------------------

  Efter:

    398331 1996-09-24  13:22  /2 rader/ George Berkeley
    Mottagare: Filosofimtet <1226>
    rende: 
    ------------------------------------------------------------
    En abstrakt id r en sjlvmotsgelse. 
    (398331) -----------------------------------
    Kommentar i text 398374 av John Locke
")

    (kom-show-author-at-end-doc . "\
  Om detta r pslaget s visas namnet p frfattaren efter inlggstexten.
  Naturligtvis s visas ven namnet i inlggshuvudet. 

  Pslaget (med streckade linjer ocks pslaget):

    892342 1996-09-24  19:21  /2 rader/ Claude Shannon
    Mottagare: Presentation (av nya) Medlemmar
    rende: Claude Shannon
    ------------------------------------------------------------
    Informationsteoretiker
    (892342) /Claude Shannon/------------------------------

  Avslaget:

    892342 1996-09-24  19:21  /2 rader/ Claude Shannon
    Mottagare: Presentation (av nya) Medlemmar
    rende: Claude Shannon
    ------------------------------------------------------------
    Informationsteoretiker
    (892342) -----------------------------------

  Om man har streckade linjer avslaget s visas frfattaren p samma 
  stt, men de streckade linjerna finns naturligtvis inte med.")

    (kom-truncate-threshold-doc . "\
  Om detta r pslaget kommer inlgg som r lngre n maxantalet att kortas
  ner nr man terser kommentarer, terser markerade inlgg eller terser de
  senaste eller frsta.  Inlgg kortas inte av d man terser inlgg, terser
  trd eller bara lser nsta inlgg.")

    (kom-truncate-show-lines-doc . "\
  Antalet rader som visas nr ett inlgg avkortats.")
     
    (kom-dashed-lines-doc . "\
  Om detta r pslaget visas streckade linjer fre och efter inlggstexten,
  annars visas en tomrad efter renderaden, och ingenting speciellt i slutet.

  Pslaget:

    892343 1996-09-24  19:21  /2 rader/ Tycho Brahe
    Mottagare: Presentation (av nya) Medlemmar
    rende: Tycho Brahe
    ------------------------------------------------------------
    Astronom och upptckare av stjrnor med hemvist p Ven.
    (892343) -----------------------------------

  Avslaget:

    892343 1996-09-24  19:21  /2 rader/ Tycho Brahe
    Mottagare: Presentation (av nya) Medlemmar
    rende: Tycho Brahe

    Astronom och upptckare av stjrnor med hemvist p Ven.
    (892343)

  De flesta brukar ha detta pslaget.")

    (kom-autowrap-doc . "\
  Om detta r pslaget s kommer LysKOM att frska bryta om raderna i
  stycken vars rader egentligen r lngre n skrmen r bred. Stycken
  som verkar vara frformatterade av frfattaren bryts dock aldrig om.")

    (kom-print-number-of-unread-on-entrance-doc . "\
  Om detta r pslaget s visas antalet olsta i ett mte nr man gr till 
  mtet:

  Pslaget:

    G till nsta mte...
    Presentation (av nya) medlemmar - 3 olsta
    Lsa nsta text - 

  Avslaget:

    G till nsta mte...
    Presentation (av nya) medlemmar
    Lsa nsta text - ")


    (kom-presence-messages-in-echo-area-doc . "\

  Om man vill ha meddelanden i ekoarean nr ngon loggar in, ut eller
  byter namn i LysKOM br man sl p den hr instllningen. Meddelanden
  visas i ekoarean. Om man vill ha information om endast vissa personer
  gr det att ange en lista av personer. Vill man inte ha ngra
  meddelanden alls r det bara att ange en tom lista.")

    (kom-presence-messages-in-buffer-doc . "\
  Om man vill ha meddelanden i LysKOM-bufferten nr ngon loggar in, ut eller
  byter namn i LysKOM br man sl p den hr instllningen.  Meddelanden
  visas i LysKOM-bufferten. Om man vill ha information om endast vissa 
  personer gr det att ange en lista av personer. Vill man inte ha ngra 
  meddelanden alls r det bara att ange en tom lista.")

    (kom-show-where-and-what-doc . "\
  Information i vilkalistan om varifrn en person r inloggad och vad personen
  gr visas bara om detta r pslaget.

  Pslaget:

        Anvndare                            Nrvarande i mte              
        Kr frn                             Gr                             
    --------------------------------------------------------------------------
     6810 George Berkeley                      Filosofimtet                  
          berkeley@emp1.tcd.ie                 (Skriver en kommentar.)        
     7571 John Locke                           Filosofimtet                  
          eridy@cc.ox.ac.uk                    (Vntar.)                      

  Avslaget:

        Anvndare                            Nrvarande i mte              
    --------------------------------------------------------------------------
     6810 George Berkeley                      Filosofimtet                  
     7571 John Locke                           Filosofimtet")

    (kom-show-since-and-when-doc . "\
  Information i vilkalistan om nr en person loggade in och hur lnge sedan
  personen var aktiv.")

    (kom-idle-hide-doc . "\
  I vilkalistan visas normalt enbart de sessioner som har varit aktiva
  under den senaste tiden. Denna instllning bestmmer hur mnga minuter
  en session fr ha varit inaktiv och nd visas i vilkalistan.")


    (kom-show-footnotes-immediately-doc . "\
  Fotnoter visas normalt p samma stt som kommentarer, men om detta r
  pslaget s visas fotnoter direkt efter inlgget de hr till.")


    (kom-follow-comments-outside-membership-doc . "\
  Normalt s visar inte LysKOM kommentarer till ett inlgg om man inte r
  medlem i ngot av mtena kommentaren har som mottagare. Om man vill
  flja kommentarskedjor utanfr de mten man r medlem i kan man sl
  p den hr instllningen.")


    (kom-read-depth-first-doc . "\
  LysKOM kan visa inlgg antingen i den ordning de skapades, eller i den
  ordning de ligger i kommentarstrdet. Ta till exempel fljande inlgg:

  Inlgg 1002 r inte en kommentar till ngonting. Inlgg 1003 och 1004
  r kommentarer till inlgg 1002. Inlgg 1005 och 1007 r kommentarer
  till inlgg 1004 och inlgg 1006 r en kommentar till inlgg 1003. D
  ser kommentarstrdet ut ungefr s hr:
        
  1002 +-- 1003 --- 1006
       |
       +-- 1004 +-- 1005
                |
                +-- 1007

  Om man lser inlggen i tidsordning kommer de att visas i ordningen
  1002, 1003, 1004, 1005, 1006 och 1007. I kommentarsordning blir det
  i stllet 1002, 1003, 1006, 1004, 1005 och 1007.")


    (kom-continuous-scrolling-doc . "\
  Pslaget innebr att klienten scrollar bufferten medan ny text stts in, s
  man ser det senaste som har satts in. Detta fungerar bra om man har en
  snabb terminal, men kan vara vrt att sl av om terminalen r lngsam, och
  scrollning i Emacs tar tid.")


    (kom-deferred-printing-doc . "\
  Fr att snabba upp LysKOM s skrivs vissa saker, som person- och mtesnamn
  inte ut omedelbart, utan skrivs frst ut som \"[...]\", vilket sedan byts
  ut mot den rtta utskriften nr texten finns tillgnglig. Detta snabbar
  upp svarstiderna i klienten ganska mycket, men gr att stnga av med den
  hr instllningen om man tycker det ser otrevligt ut.")


    (kom-higher-priority-breaks-doc . "\
  Nr texter kommer in till mten som har hgre prioritet n det man lser
  kan klienten lta en lsa dessa texter omedelbart, efter den aktuella
  kommentarskedjan eller efter man har lst ut mtet.")
    

    (kom-login-hook-doc . "\
  Kommandon som skall kras nr man loggar in, innan ngon inmatning frn
  tangentbordet tas emot. Till exempel kan man gra Lista nyheter hr fr
  att f se en lista av nyheter varje gng man loggar in.")


    (kom-do-when-done-doc . "\
  Kommandon som skall kras nr man har lst ut alla inlgg. Det r ganska
  vanligt att man har terse alla markerade hr. Bde tangentbordsmakron
  och regelrtta funktioner gr bra.")


    (kom-page-before-command-doc . "\
  LysKOM-bufferten kan scrollas fre alla kommandon s att text som stts in
  av kommandot hamnar verst i fnstret. Denna variabel talar om fre vilka
  kommandon detta skall ske.")


    (kom-permissive-completion-doc . "\
  Om detta r pslaget s kommer TAB bara att fylla ut namn p inloggade
  personer nr kommandot bara kan utfras p inloggade personer (till
  exempel Status (fr) session och Snda meddelande). Om det r avslaget
  kommer TAB att fylla ut ven med namn p personer som inte r inloggade.")


    (kom-membership-default-priority-doc . "\
  Detta bestmmer hur prioriteten p mten man gr med i stts. Om det r
  en siffra mellan 1 och 255 s kommer nya medlemskap att f den prioriteten.
  I annat fall kommer klienten att frga fr varje nytt medlemskap vilken
  prioritet det skall ha.")


    (kom-show-personal-messages-in-buffer-doc . "\
  Denna instllning bestmmer var personliga meddelanden, gruppmeddelanden
  och alarmmeddelanden visas. Meddelanden kan antingen visas i 
  LysKOM-bufferten, kastas bort helt eller visas i en namngiven buffert.")


    (kom-pop-personal-messages-doc . "\
  Om personliga meddelanden skall visas i en egen buffert och denna instllning
  ocks r pslagen s kommer den bufferten att visas s fort ett meddelande
  anlnder.")


    (kom-audio-player-doc . "\
  Om man vill att LysKOM skall spela ljudfiler i stllet fr att pipa vid 
  olika tillfllen mste denna instllning peka ut ett program som klarar
  att spela ljudfilerna. Programmet skall ta ett argument: namnet p filen
  som skall spelas.")


    (kom-default-message-recipient-doc . "\
  Denna instllning bestmmer vem som kommer att vara defaultmottagare
  fr personliga meddelanden man skickar. Alternativen som finns r
  att meddelanden normalt r allmnna, att avsndaren fr det senast
  mottagna meddelandet skall vara default eller att mottagaren fr det
  senaste gruppmeddelandet (eller avsndaren av det senaste personliga
  eller allmnna meddelandet) skall vara mottagare.")


    (kom-filter-outgoing-messages-doc . "\
  Om denna instllning r pslagen s kommer meddelanden som skickas 
  automatiskt, till exempel automatiska svar och svar p fjrrkontrollfrsk
  ven att visas som om man hade skickat det manuellt.")

    (kom-friends-doc . "\
  Namnen p personerna i denna lista kommer att visas med ett speciellt 
  utseende i LysKOM-bufferten. Kommandot Vilka vnner r inloggade (och
  andra liknande kommandon) anvnder ocks denna lista.")

    (kom-morons-doc . "\
  Namnen p personerna i denna lista kommer att visas med ett varnande 
  utseende i LysKOM-bufferten.")

    (kom-url-viewer-preferences-doc . "\
  Denna instllning bestmmer vilken WWW-lsare som i frsta hand skall 
  anvndas fr att ppna URLer som frekommer i LysKOM. Om den frsta lsaren 
  i listan inte klarar den typ av URL som man frsker ppna s anvnds nsta
  lsare och s vidare.")

    (kom-windows-browser-command-doc . "\
  Denna instllning talar om vilket kommando som skall anvndas fr att starta
  en WWW-lsare i Windows. Om fltet r tomt testas ett antal kommandon som
  typiskt brukar fungera i Windows.")

    (kom-mosaic-command-doc . "\
  Denna instllning talar om vilket kommando som skall anvndas fr att starta
  Mosaic.")

    (kom-netscape-command-doc . "\
  Denna instllning anger kommandot fr att kra Netscape eller Mozilla.")

    (kom-galeon-command-doc . "\
  Denna instllning anger kommandot fr att kra Galeon.")

    (kom-inhibit-typeahead-doc . "\
  Normalt sparas tangenttryckningar som grs medan klienten r upptagen, och
  utfrs nr det blir mjligt. Om denna instllning r avslagen s kommer
  LysKOM enbart att utfra kommandon som ges nr klienten inte arbetar.")

    (kom-max-buffer-size-doc . "\
  Det r mjligt att begrnsa LysKOM-buffertens storlek genom att ange hur
  stor den fr bli i den hr variabeln. Om bufferten blir fr stor kommer
  information frn buffertens brjan att tas bort.")

    (kom-ansaphone-record-messages-doc . "\
  LysKOM kan \"spela in\" meddelanden som kommer nr funktionen fr automatiskt
  svar r pslagen. Denna instllning bestmmer om s sker eller inte.")

    (kom-ansaphone-show-messages-doc . "\
  Om denna instllning r pslagen kommer LysKOM att visa inkomna personliga
  meddelanden ven om automatiskt svar r pslaget.")

    (kom-ansaphone-default-reply-doc . "\
  Automatsvararen skickar detta meddelande om inget annat meddelande har
  specificerats via ngon annan mekanism (och den r bara till fr frsiktiga
  experter).")

    (kom-remote-control-doc . "\
  Pslagen innebr att det gr att fjrrstyra klienten. Fjrrstyrningen r
  dock begrnsad till vissa personer.")

    (kom-remote-controllers-doc . "\
  Personerna i denna lista fr fjrrstyra klienten.")

    (kom-self-control-doc . "\
  Om detta r pslaget fr anvndaren som r inloggad styra klienten frn
  en annan session. Detta r ett alternativ till att lgga in sig sjlv i
  listan ver tilltna fjrrstyrare.")

    (kom-customize-format-doc . "\
  Dokumentation till instllningarna kan vara p eller avslagen nr 
  instllningsfnstret ppnas. Dokumentationen kan alltid visas eller
  gmmas fr varje enskild instllning genom att anvnda frgetecknet
  eller utropstecknet som str till hger om instllningen.")

    (kom-default-language-doc . "\
  Sprk som skall anvndas i LysKOM. Om du ndrar instllningen hr s kommer
  inte instllningen ndras fr aktuell session, utan du mste ge kommandot
  ndra sprk ocks.")

    (kom-ispell-dictionary-doc . "\
  Ordlista som skall anvndas av stavningskontrollen i LysKOM. Om detta
  r satt till kom-ispell-dictionary s kommer variabeln ispell-dictionary
  att anvndas istllet.")

    (kom-show-namedays-doc . "\
  Pslaget innebr att dagens namn visas nr man ser tiden. Antagligen s
  kommer detta att ersttas av ett nytt kommando i ngon kommande version
  av elispklienten, men det var visst ngon som ville ha det, s ...")

    (kom-show-week-number-doc . "\
  Se tiden visar veckonummer om detta r pslaget. Annars visas inte 
  veckonummer.")

    (kom-membership-default-placement-doc . "\
  Denna instllning styr var nya medlemskap hamnar. Frst betyder att nya
  medlemskap hamnar fre gamla med samma prioritet. Sist betyder att nya 
  medlemskap hamnar efter gamla med samma prioritet. En siffra r en fix
  placering i medlemskapslistan (men medlemskapet kommer att flyttas
  ssmningom).")

    (kom-show-imported-importer-doc . "\
  Pslaget betyder visa vilken person som importerade ett importerat e-mail.")

    (kom-show-imported-envelope-sender-doc . "\
  Visa den verkliga avsndaren till ett importerat e-mail om detta r 
  pslaget.")

    (kom-show-imported-external-recipients-doc . "\
  Visa externa mottagare och extra-kopiemottagare om detta r pslaget.")

    (kom-agree-text-doc . "\
  Text som anvnds av kommandot Hlla med. Det kan antingen vara en text
  eller en lista av texter. Om det r en lista s vljs ett alternativ
  slumpmssigt.")

    (kom-silent-ansaphone-doc . "\
  On detta r avslaget s piper inte klienten nr det kommer meddelanden och
  automatsvar r pslaget.")

    (kom-default-session-priority-doc . "\
  Lsniv fr nya sessioner. Detta r den lsniv som nya sessioner fr
  automatiskt.")

    (kom-unsubscribe-makes-passive-doc . "\
  Om detta r pslaget s gr kommandot Uttrda ur mte att man frst blir
  passiv medlem i mtet. Om man uttrder ur mtet igen s gr man ur p
  riktigt. Om detta r avslaget s gr man ur mtet frsta gngen man frsker
  uttrda.")

    (kom-review-priority-doc . "\
  Prioritet fr tersekommandon. Detta r den prioritet som inlggen man ser
  nr man gr terse fr. Det anvnds fr att avgra om nya inlgg skall
  avbryta tersefunktionen. Stt till 256 eller hgre om du inte vill att nya
  inlgg ngonsin skall avbryta en tersefunktion.")

    (kom-show-creating-software-doc . "\
  Om detta r pslaget s visas vilken klient som skapade inlgget tillsammans
  med varje inlgg, frutsatt att informationen finns verhuvudtaget.")

    (kom-text-footer-format-doc . "\
  Format fr inlggsfoten. I texten erstts %n med inlggsnumret, %P med
  frfattarens namn, %p med frfattarens nummer, %f med information om
  inlgget (ombruten, HTML mm.) och %- med en lagom lng streckad linje.
  En siffra efter procenttecknet r minsta bredd p texten. Ett minustecken
  fre siffran betyder att texten skall vnsterjusteras. Ett likhetstecken
  betyder att fltlngden r exakt och texten kanske kortas av.")

    (kom-long-lines-doc . "\
  Om detta r pslaget s grs de flesta streckade linjer i klienten mycket
  lngre n normalt.")

    (kom-postpone-default-doc . "\
  Antalet inlgg som inte skall uppskjutas med Uppskjuta lsning.")

    (kom-allow-incompleteness-doc . "\
  Pslaget betyder att klienten inte vntar p att information om alla
  olsta har kommit fram innan den tillter kommandon som Lista nyheter.
  Avslaget innebr att klienten vntar p information om olsta inlgg om
  den upptcker att informationen behvs och inte har kommit fram.")

    (kom-smileys-doc . "\
  Gladmn, som :-), visas grafiskt nr denna instllning r p, frutsatt
  att Emacs klarar det och paketet smiley.el (en del av Gnus) r installerat.")

    (kom-ignore-message-senders-doc . "\
  Visa inte personliga, grupp- och alarmmeddelanden frn dessa personer.")

    (kom-ignore-message-recipients-doc . "\
  Visa inte gruppmeddelanden riktade till dessa mten.")

    (kom-text-footer-dash-length-doc . "\
  Den totala lngden p inlggsfoten nr streckade linjer, men inte extra
  lnga linjer, och inte ett eget format anvnds.")

    (kom-text-header-dash-length-doc . "\
  Den totala lngden p den streckade linjen ovanfr inlggstexten nr
  extra lnga linjer inte anvnds.")

    (kom-show-personal-message-date-doc . "\
  Nr detta r pslaget s visas datum och klockslag fr alla personliga,
  grupp- och alarmmeddelanden.")

    (kom-w3-simplify-body-doc . "\
  Nr detta r pslaget s visas HTML utan de frger som anges i HTML-koden.")

    (kom-mercial-doc . "\
  Denna text visas i vilkalistan d du har lst frdigt alla mten.")

    (kom-server-priority-doc . "\
  Prioritet fr sessionen. Sessioner med hg prioritet kan avbryta andra
  sessioner, beroende p instllningen av YYY.")

    (kom-server-priority-breaks-doc . "\
  Denna instllning styr hur prioriterade sessioner avbryter andra
  sessioner. En session r hgre prioriterad n en annan om dess
  sessionsprioritet r hgre n den andra sessionens.

  Omedelbart            S fort der kommer ett inlgg i en prioriterad 
                        session s fr man prompt om att g till den
                        sessionen.

  Omedelbart om det kommer brev     S fort det kommer ett personligt
                        brev i en prioriterad session s fr man prompt 
                        om att g till den sessionen.

  Efter aktuell kommentarskedja     Om det kommer inlgg i en 
                        prioriterad session s fr man prompt om att
                        g till sessionen nr man har lst klart den
                        aktuella kommentarskedjan.

  Efter aktuell kommentarskedja om det kommer brev      Om det kommer
                        personliga brev i en prioriterad session s 
                        fr man prompt om att g till sessionen nr
                        man har lst klart den aktuella kommentarskedjan.

  Efter aktuellt mte   Om det kommer inlgg i en prioriterad session 
                        s fr man prompt om att g till sessionen nr
                        man har lst klart det aktuella mtet.

  Efter aktuellt mte nr det kommer brev       Om det kommer brev i en
                        prioriterad session s fr man prompt om att g
                        till sessionen nr man har lst klart det 
                        aktuella mtet.

  Nr allt r utlst    Ge prompt om att byta till nsta LysKOM med 
                        olsta inlgg nr allt r klart, oberoende av
                        sessionernas prioritet.

  Aldrig                Ge aldrig prompt om att byta session.")

    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-personal-messages-doc . "")
    (kom-ding-on-group-messages-doc . "")
    (kom-ding-on-common-messages-doc . "")
    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-wait-done-doc . "")
    (kom-ding-on-priority-break-doc . "")
    (kom-ding-on-new-letter-doc . "")

    (kom-check-for-new-comments-doc . "")
    (kom-check-commented-author-membership . "")
    (kom-confirm-multiple-recipients-doc . "")
    (kom-check-commented-author-membership-doc . "")
    (kom-complete-numbers-before-names-doc . "\
  Nr detta r pslaget och man matar in en text som kan tolkas bde som
  ett mtesnamn eller ett mtesnummer vid inlsning av mtesnamn, s
  tolkar klienten det i frsta hand som ett nummer. Nr detta r avslaget
  s tolkas det i frsta hand som ett mtesnamn.")
    (kom-keep-alive-interval-doc . "\
  Antalet sekunder som skall g mellan de meddelanden som anvnds fr att
  hlla ntverkskopplingen till LysKOM-servern aktiv. Om din frbindelse
  kopplar ned efter en stunds inaktivitet s kan du stta detta till ungefr 
  hlften och sedan ge kommandot \"Hll frbindelsen aktiv\".")
    (kom-text-no-prompts-doc . "\
  Den r instllningen styr vilka kommandon som alltid frgar efter 
  textnummer (om man inte anger ett explicit som prefixargument). Fr 
  kommandon som inte str med hr anvnds inbyggda standardinstllningar.")
    (kom-saved-file-name-doc . "\
  Anger vilken fil som inlgg skall arkiveras till. Klienten kommer nd
  att frga, men detta blir det frifyllda svaret.")
    (kom-follow-attachments-doc . "\
  Anger om bilagor till importerade brev skall lsas som kommentarer. 
  Om detta r avstngt s lsmarkeras bilagor automatiskt, utan att
  man lser dem.")
    (kom-show-unread-in-frame-title-doc . "\
  Om detta r pslaget s visas \"(Olsta)\" i titelraden fr de
  fnster vars valda buffert hr till en LysKOM-session med olsta. 
  Det r inte skert att titelraden ndras om fnstret inte r ppet.")
    (kom-created-texts-are-saved-doc . "\
  Om detta r ett filnamn s sparas alla inlgg man skriver till den
  filen i ungefr samma format som de har nr man lser dem. Inlgg
  som inte kan skapas sparas inte.")
    (kom-confirm-add-recipients-doc . "\
  Om detta r pslaget och man adderar en mottagare till ett inlgg s
  frgar klienten om man vill att kommentarer till inlgget ocks
  skall skickas till den nya mottagaren. Om detta r avslaget s
  kommer kommentarer alltid att skickas ven till den nya mottagaren. 
  Det r oftast bra att ha pslaget.")
    (kom-trim-buffer-minimum-doc . "\
  Om du begrnsar LysKOM-buffertens storlek s mste den bli s hr mycket
  fr stor innan text i bufferten raderas. Variablen ska vara ett heltal,
  default r 4096.")
    (kom-dont-check-commented-authors-doc . "")
    (kom-print-relative-dates-doc . "\
  Tidsangivelsen fr inlgg (och en del andra saker) kommer att bli
  \"idag\" alternativt \"igr\" om denna instllning r pslagen och
  inlgget skrevs idag alternativt igr. Om den r avslagen kommer ett
  absolut datum alltid att visas.")
    (kom-print-seconds-in-time-strings-doc . "\
  Om denna instllning r pslagen kommer en del tidsangivelser (till
  exempel fr visade inlgg och snda meddelanden) att inkludera
  sekunder.")
    (kom-review-uses-cache-doc . "\
  Om detta r pslaget s kommer kommandon som terser inlgg att 
  anvnda sparade kopior av inlggen om de finns. Det gr att kommandona
  gr lite snabbare, men det finns en viss risk fr att ett inlgg kan
  ha ndrats sedan kopian sparades.")
    (kom-review-marks-texts-as-read-doc . "\
  Om detta r pslaget s kommer kommandon som terser inlgg att 
  lsmarkera de inlgg som visas. I annat fall lmnar tersekommandona
  din lshistorik orrd, precis som vanligt.")
    (kom-auto-review-faqs-doc . "\
  Om detta r pslaget s kommer olsta FAQer inte att terses automatiskt
  nr du loggar in eller gr till ett mte med en olst FAQ.")
    (kom-auto-list-faqs-doc . "\
  Om detta r pslaget s kommer olsta FAQer att listas automatiskt nr
  du loggar in eller gr till ett mte med en olst FAQ.")
    (kom-extended-status-information-doc . "\
  Om detta r pslaget so visas extra statusinformation i kommandona
  Status (fr) person, Status (fr) mte och Status (fr) servern 
  (om sdan information finns tillgnglig).")
    (kom-highlight-first-line-doc . "\
  Om detta r pslaget s visas frsta raden i varje inlgg (den med
  inlggsnummer, datum och frfattare) med ett annorlunda utseende n
  normal text.")
    (kom-highlight-dashed-lines-doc . "\
  Om detta r pslaget s visas raderna fre och efter inlggstexten med
  ett annorlunda utseende n normal text.")
    (kom-highlight-text-body-doc . "\
  Om detta r pslaget s visas inlggstexter med ett annorlunda utseende
  n normal text.")
    (kom-async-highlight-dashed-lines-doc . "\
  Om detta r pslaget s visas raderna fre och efter personliga, grupp-
  och alarmmeddelanden med ett annorlunda utseende n normal text.")
    (kom-async-highlight-text-body-doc . "\
  Om detta r pslaget s visas personliga, grupp- och alarmmeddelanden 
  med ett annorlunda utseende n normal text.")
    (kom-edit-hide-add-button-doc . "\
  Om detta r pslaget s kommer knappen [Addera...] att visas efter
  mottagare och tillggsinformation nr man skriver inlgg.")
    (kom-format-html-authors-doc . "\
  Den hr instllningen styr vilka frfattares HTML-meddelanden som
  elispklienten kommer att frska formattera.")
    (kom-keyboard-menu-immediate-selection-doc . "\
  Den hr instllningen styr huruvida snabbtangenter automatiskt bekrftar
  val i textbaserade menyer eller inte. Om detta r pslaget s mste man
  alltid trycka retur fr att vlja i textbaserade menyer.")
    (kom-max-overlays-doc . "\
  Med denna instllning kan man begrnsa antalet frgmarkeringar (som
  anvnds bland annat fr frgade inlggsbakgrunder). Genom att begrnsa
  antalet markeringar kan scrollning g mycket fortare. Varje inlgg
  behver mellan 1 och 4 markeringar beroende p andra instllningar.")


    ;;
    ;; Tags for variables
    ;;
    
    (kom-ansaphone-replies-tag . "Detaljerade automatsvar")
    (kom-bury-buffers-tag . "Begrav buffertar nr man byter LysKOM:")

    (kom-personal-messages-in-window-tag . "Personliga meddelanden:   ")
    (kom-customize-in-window-tag       . "Instllningar fr LysKOM: ")
    (kom-write-texts-in-window-tag     . "Skriv inlgg:             ")
    (kom-prioritize-in-window-tag      . "Prioritera mten:         ")
    (kom-edit-filters-in-window-tag    . "ndra filter:             ")
    (kom-view-commented-in-window-tag  . "terse kommentarer:       ")
    (kom-list-membership-in-window-tag . "Lista medlemskap:         ")

    (kom-user-prompt-format-tag . "Promptformat:")
    (kom-user-prompt-format-executing-tag . "Promptformat vid krning:")
    (kom-anonymous-prompt-format-tag . "Promptformat (anonym):")
    (kom-anonymous-prompt-format-executing-tag . "Promptformat vid krning (anonym):")
    (kom-enabled-prompt-format-tag . "Promptformat (admin):")
    (kom-enabled-prompt-format-executing-tag . "Promptformat vid krning (admin):")

    (kom-higher-priority-breaks-tag . 
"Ls prioriterade texter:                  ")
    (kom-created-texts-are-read-tag . 
"Lsmarkera skapade texter:                ")
    (kom-default-mark-tag           . 
"Defaultmarkering:                         ")
    (kom-print-number-of-unread-on-entrance-tag . 
"Visa olsta nr man gr till ett mte:    ")
    (kom-follow-comments-outside-membership-tag .
"Flj kommentarskedjor utanfr medlemskap: ")
    (kom-show-footnotes-immediately-tag .
"Visa fotnoter omedelbart:                 ")
    (kom-membership-default-priority-tag . 
"Prioritet fr nya medlemskap:             ")
    (kom-dashed-lines-tag . 
"Streckade linjer kring inlggstexten:     ")
    (kom-autowrap-tag . 
"Automatisk radbrytning vid lsning:       ")
    (kom-show-author-at-end-tag .
"Visa frfattarens namn efter inlgget:    ")

    (kom-truncate-threshold-tag .
"Korta av lnga inlgg:                    ")
    (kom-truncate-show-lines-tag .
"Rader att visa vid avkortade inlgg:      ")
    
    (kom-reading-puts-comments-in-pointers-last-tag . "Kommentarslnkar visas:")
    (kom-read-depth-first-tag . "Lsordning:")
    (kom-deferred-printing-tag . "Frdrjda utskrifter:")
    (kom-continuous-scrolling-tag . "Omedelbar scrollning:")

    (kom-presence-messages-in-echo-area-tag . 
"Nrvaromeddelanden i ekoarean:        ")
    (kom-presence-messages-in-buffer-tag .
"Nrvaromeddelanden i LysKOM-bufferten:")
    (kom-page-before-command-tag . "Rensa skrmen:")

    (kom-idle-hide-tag . 
"Antal minuter en session fr vara inaktiv och nd visas: ")
    (kom-show-where-and-what-tag . 
"Visa varifrn personer r inloggade och vad de gr:         ")
    (kom-show-since-and-when-tag . 
"Visa nr personer loggade in och nr de var aktiva:         ")



    (kom-login-hook-tag . "Kommandon som krs vid login:")
    (kom-do-when-done-tag . "Kommandon som krs efter allt r utlst:")
    (kom-permissive-completion-tag . "Petig utfyllnad av namn:")
    (kom-show-personal-messages-in-buffer-tag . 
"Var visas meddelanden:           ")
    (kom-pop-personal-messages-tag . 
"Ploppa upp meddelandebufferten:  ")
    (kom-default-message-recipient-tag . 
"Defaultmottagare fr meddelanden:")

    (kom-audio-player-tag . "Ljudspelarprogram:")
    (kom-ding-on-new-letter-tag        . "Nr det kommer brev:                ")
    (kom-ding-on-priority-break-tag    . "Nr det kommer prioriterade inlgg: ")
    (kom-ding-on-wait-done-tag         . "Nr man har vntat klart:           ")
    (kom-ding-on-common-messages-tag   . "Vid alarmmeddelanden:               ")
    (kom-ding-on-group-messages-tag    . "Vid gruppmeddelanden:               ")
    (kom-ding-on-personal-messages-tag . "Vid personliga meddelanden:         ")
    (kom-ding-on-no-subject-tag        . "Nr renderad saknas:               ")

    (kom-filter-outgoing-messages-tag . "Visa automatiska meddelanden:")
    (kom-friends-tag . "Vnner och bekanta:")
    (kom-morons-tag . "Idioter och knppskallar:")
    (kom-url-viewer-preferences-tag . "ppna URLer med fljande program:")
    (kom-windows-browser-command-tag . "Kommando fr att starta en WWW-lsare i Windows:")
    (kom-mosaic-command-tag . "Kommando fr att starta NCSA Mosaic:")
    (kom-netscape-command-tag . "Kommando fr att starta Netscape eller Mozilla:")
    (kom-galeon-command-tag . "Kommando fr att starta Galeon:")

    (kom-symbolic-marks-alist-tag . "Symboliska markeringstyper:")

    (kom-cite-string-tag . "Citatmarkering:")
    (kom-confirm-multiple-recipients-tag . 
"Bekrfta multipla mottagare:                   ")
    (kom-check-commented-author-membership-tag . 
"Kontrollera kommenterad frfattares medlemskap:")
    (kom-check-for-new-comments-tag . 
"Kontrollera olsta kommentarer:                ")

    (kom-ansaphone-record-messages-tag . 
"Spara meddelanden d automatiskt svar r pslaget: ")
    (kom-ansaphone-show-messages-tag . 
"Visa meddelanden d automatiskt svar r pslaget:  ")
    (kom-ansaphone-default-reply-tag . "Svarsmeddelande:")


    (kom-inhibit-typeahead-tag . "Buffra tangenttryckningar:")
    (kom-max-buffer-size-tag . "Maximal buffertstorlek:")

    (kom-remote-control-tag .     "Fjrrstyrning:                     ")
    (kom-self-control-tag .       "Tillt fjrrstyrning av mig sjlv: ")
    (kom-remote-controllers-tag . "Tilltna fjrrstyrare:")

    (kom-customize-format-tag . "Visa hjlptexterna fr instllningar:")
    (kom-default-language-tag . "Sprk:           ")
    (kom-ispell-dictionary-tag . "Ordlista:")
    (kom-show-namedays-tag .    "Visa dagens namn:")

    (kom-show-week-number-tag . "Visa veckonummer:")
    (kom-membership-default-placement-tag . "Placering av nya medlemskap:")
    (kom-show-imported-importer-tag . "Visa importr av importerade inlgg:")
    (kom-show-imported-envelope-sender-tag . "Visa avsndare av importerade inlgg:")
    (kom-show-imported-external-recipients-tag . "Visa externa mottagare till importerade inlgg:")
    (kom-agree-text-tag . "Text fr Hlla med:")
    (kom-silent-ansaphone-tag . "Pip nr automatsvar r pslaget:")
    (kom-default-session-priority-tag . "Lsniv fr nya sessioner:")
    (kom-unsubscribe-makes-passive-tag . "Uttrda ur mte gr om medlemskap till passiva:")
    (kom-review-priority-tag . "Prioritet fr tersekommandon:")
    (kom-show-creating-software-tag . "Visa skapande klient:")
    (kom-text-footer-format-tag . "Format fr inlggsfot:")
    (kom-long-lines-tag . "Lnga streckade linjer:")
    (kom-postpone-default-tag . "Sknsvrde fr uppskjuta lsning:")
    (kom-allow-incompleteness-tag . "Tillt ofullstndig information om olsta:")
    (kom-smileys-tag . "Visa gladmn grafiskt:")
    (kom-ignore-message-senders-tag . "Visa inte meddelanden frn:")
    (kom-ignore-message-recipients-tag . "Visa inte meddelanden till:")
    (kom-text-footer-dash-length-tag . "Inlggsfotens lngd:")
    (kom-text-header-dash-length-tag . "Lngden p linjen ovanfr inlggstexten:")
    (kom-show-personal-message-date-tag . "Visa datum fr alla meddelanden:")
    (kom-w3-simplify-body-tag . "Visa HTML utan standardfrger:")
    (kom-mercial-tag . "Text nr allt r utlst:")
    (kom-server-priority-tag . "Sessionsprioritet:")
    (kom-server-priority-breaks-tag . "Byt till LysKOM med olsta:")
    (kom-complete-numbers-before-names-tag . "Ls mtesnummer fre mtesnamn:")
    (kom-keep-alive-interval-tag . "Intervall fr hll frbindelsen igng:")
    (kom-text-no-prompts-tag . "Hur kommandon frgar efter textnummer:")
    (kom-saved-file-name-tag . "Fil att arkivera inlgg i:")
    (kom-follow-attachments-tag . "Ls importerade bilagor som vanligt:")
    (kom-show-unread-in-frame-title-tag . "Visa olstamarkering i titelraden:")
    (kom-created-texts-are-saved-tag . "Spara frfattade inlgg:")
    (kom-confirm-add-recipients-tag . "Frga om kommentarer skall sndas till nya mottagare:")
    (kom-trim-buffer-minimum-tag . "Minsta storlek av LysKOM-bufferten som tas bort:")
    (kom-dont-check-commented-authors-tag . "Frfattare som inte kontrolleras:")
    (kom-print-relative-dates-tag . "Visa relativa datumangivelser:")
    (kom-print-seconds-in-time-strings-tag . "Inkludera sekunder i tidsangivelser:")
    (kom-review-uses-cache-tag . "tersekommandon anvnder sparade inlgg:")
    (kom-review-marks-texts-as-read-tag . "tersekommandon lsmarkerar visade texter:")
    (kom-auto-review-faqs-tag . "Visa nya FAQer automatiskt:")
    (kom-auto-list-faqs-tag . "Lista nya FAQer automatiskt:")
    (kom-extended-status-information-tag . "Utkad statusinformation:")
    (kom-highlight-first-line-tag . "Annorlunda bakgrundsfrg p frsta raden:")
    (kom-highlight-dashed-lines-tag . "Annorlunda bakgrundsfrg fre och efter inlggstexten:")
    (kom-highlight-text-body-tag . "Annorlunda bakgrundsfrg p inlggstexten:")
    (kom-async-highlight-dashed-lines-tag . "Annorlunda bakgrundsfrg fre och efter meddelanden:")
    (kom-async-highlight-text-body-tag . "Annorlunda bakgrundsfrg p meddelanden:")
    (kom-edit-hide-add-button-tag . "Visa Addera-knappen nr man skriver inlgg:")
    (kom-format-html-authors-tag . "Formattera HTML-meddelanden per frfattare:")
    (kom-keyboard-menu-immediate-selection-tag . "Snabbval i textmenyer krver bekrftelse:")
    (kom-max-overlays-tag . "Hgsta antal frgmarkeringeingar:")
    )
)

  
;;;; ============================================================
;;;; The default Ansaphone message goes here. The more complex 
;;;; message specification probably should too, but it's not here
;;;; yet. People who know how to use it are smart enough to do it
;;;; right.

(lyskom-language-var local kom-ansaphone-default-reply sv
  "Jag lser inte LysKOM just nu. Skicka grna ett brev i stllet.")

;;;; ============================================================
;;;; Other language-dependent variables
;;;;

(lyskom-language-var local kom-ispell-dictionary sv
  "svenska")


;;;; ================================================================
;;;; Tell phrases should really be configured with the default
;;;; language used at the server and not for person reading if they
;;;; happen to differ. This is of coarse because they are sent to the
;;;; server for everybody else to see.

;;;; Aronsson was here 4 DEC 1990, thus creating version 0.18
					; Created *-tell-*


;;;; kom-tell-phrases 

;;; To coders of the elisp-client:
;;; if you change kom-tell-phrases here, make sure the list of valid
;;; keywords is updated it in vars.el.
;;; lyskom-tell-phrases-validation-keyword-list, lyskom-tell-phrases-validate

(eval-when-compile (defvar kom-tell-phrases))

(lyskom-language-strings local kom-tell-phrases sv
 '((kom-tell-silence		. "")   ; Why ?
   (kom-tell-send		. "Frsker lgga in en text.")
   (kom-tell-login		. "Loggar in.")
   (kom-tell-read		. "Lser.")
   (kom-tell-1st-pres		. "Skriver den frsta presentationen.")
   (kom-tell-write-comment	. "Skriver en kommentar.")
   (kom-tell-write-footnote	. "Skriver en fotnot.")
   (kom-tell-write-letter	. "Skriver ett brev.")
   (kom-tell-write-reply	. "Skriver ett privat svar.")
   (kom-tell-write-text	. "Skriver inlgg.")
   (kom-tell-conf-pres		. "Skriver presentation fr ett nytt mte.")
   (kom-tell-recover		. "terstartar kom. Suck.")
   (kom-tell-wait		. "Vntar.")
   (kom-tell-regret		. "ngrar sig och slnger inlgget.")
   (kom-tell-review		. "terser.")
   (kom-tell-change-name       . "ndrar sitt namn till ngot annat.")
   (kom-tell-change-supervisor . "ndrar organisatr fr ngot.")
   (kom-tell-next-lyskom       . "Hoppar till ett annat LysKOM.")))

(if (and (boundp 'kom-tell-phrases)
         kom-tell-phrases)
    (lyskom-language-strings local kom-tell-phrases sv
      (mapcar (function 
               (lambda (x)
                 (cond ((and (consp x)
                             (symbolp (car x))
                             (stringp (cdr x))) x)
                       ((and (consp x)
                             (symbolp (car x))
                             (consp (cdr x))
                             (stringp (car (cdr x))))
                        (cons (car x) (car (cdr x))))
                       (t nil))))
              kom-tell-phrases)))


;; Placed here because this must NOT be evaluated before 
;; kom-tell-phrases is defined:

(lyskom-language-var local kom-mercial sv
                     (lyskom-get-string 'kom-tell-wait 'kom-tell-phrases))

;;;


(lyskom-language-strings local lyskom-error-texts sv
  '((error-0 . "Inget fel har intrffat")
    (error-2 . "nnu ej implementerat")
    (error-3 . "Inte lngre implementerat")
    (error-4 . "Felaktigt lsenord")
    (error-5 . "Strngen fr lng")
    (error-6 . "Du r inte inloggad")
    (error-7 . "Ingen fr logga in i LysKOM just nu")
    (error-8 . "Du frskte anvnda mte nummer 0")
    (error-9 . "Odefinierat eller hemligt mte")
    (error-10 . "Odefinierad eller hemlig person")
    (error-11 . "Ingen skriv- eller lsrttighet")
    (error-12 . "Otillten operation")
    (error-13 . "Du r inte medlem i mtet")
    (error-14 . "Inget sdant textnummer")
    (error-15 . "Du kan inte anvnda globalt textnummer 0")
    (error-16 . "Inget sdant lokalt textnummer")
    (error-17 . "Du kan inte anvnda lokalt textnummer 0")
    (error-18 . "Namnet fr kort, fr lngt eller innehller felaktiga tecken")
    (error-19 . "Index utanfr grnserna")
    (error-20 . "Mtet existerar redan")
    (error-21 . "Personen existerar redan")
    (error-22 . "Hemligt, men ej lsskyddat")
    (error-23 . "Du fr inte ndra person/mtesflaggan")
    (error-24 . "Fel i databasen. Attans otur.")
    (error-25 . "Otillten mottagartyp eller kommentarslnk")
    (error-26 . "Otillten infotyp. (Bug i klienten)")
    (error-27 . "Redan mottagare till denna text")
    (error-28 . "Redan kommentar till denna text")
    (error-29 . "Redan fotnot till denna text")
    (error-30 . "Inte mottagare till denna text")
    (error-31 . "Inte kommentar till denna text")
    (error-32 . "Inte fotnot till denna text")
    (error-33 . "Fr mnga mottagare")
    (error-34 . "Fr mnga kommentarer")
    (error-35 . "Fr mnga fotnoter")
    (error-36 . "Fr mnga markeringar")
    (error-37 . "Du r inte frfattare till texten")
    (error-38 . "Du kan inte koppla upp dig till servern")
    (error-39 . "Minnet slut")
    (error-40 . "Servern har ballat ur")
    (error-41 . "Klienten tror att servern sger att den inte frstr klienten")
    (error-42 . "Ingen sdan session finns")
    (error-43 . "Ogiltigt reguljrt uttryck")
    (error-44 . "Texten r inte markerad")
    (error-45 . "Tillflligt fel. Frsk senare")
    (error-46 . "Serven vgrade ta emot en array")
    (error-47 . "Mottagaren tar inte emot anonyma texter")
    (error-48 . "Otillten tillggsinformation")
    (error-49 . "Otillten ndring av tillggsinformation")
    (error-50 . "Oknt asynkront meddelande")
    (error-51 . "Internt fel i servern")
    (error-52 . "Funktionen avstngd i servern")
    (error-53 . "Meddelandet kunde inte sndas")
    (error-54 . "Otillten typ p medlemskap")
))

(lyskom-language-var global lyskom-unread-mode-line sv
  (lyskom-make-lyskom-unread-mode-line))

(lyskom-language-var global lyskom-unread-title-format sv
  (lyskom-make-lyskom-unread-title-format))

(lyskom-language-var local lyskom-help-data sv lyskom-sv-help-data)

(provide 'lyskom-language-sv)

;;; swedish-strings.el ends here

(defvar lyskom-en-help-data (quote ((conferences "Conferences" (section ((id . "conferences") (prompt . "Conferences")) ((h1 nil ((TEXT . "Conferences"))) (p nil ((TEXT . " Every LysKOM system is organized as a set of conferences, each covering a separate topic. Anybody can create a conference, but you should think twice before doing so. In a mature LysKOM system the conference you want to create probably already exists. "))) (p nil ((TEXT . " Conferences can be open, closed and secret. Anyone can join and read texts in all open conferences. To join a closed conference, the conference administractor has to grant membership. Secret conferences are secret: you can't even see them unless you're a member. Most conferences are open. Closed and secret conferences are much less common. "))) (p nil ((TEXT . " The following commands might be useful to get started: "))) (inline ((id . "kom-list-conferences")) nil) (inline ((id . "kom-review-presentation")) nil) (inline ((id . "kom-add-self")) nil) (inline ((id . "kom-go-to-conf")) nil) (h2 nil ((TEXT . "Priorities"))) (p nil ((TEXT . " Your memberships have priorities. When you log on, conferences with higher priority will be presented before conferences with lower priority. Use ") (cref ((id . "kom-prioritize")) nil) (TEXT . " to change your priorities. ")))))) (persons "Persons" (section ((id . "persons") (prompt . "Persons")) ((h1 nil ((TEXT . "Persons"))) (p nil ((TEXT . " Every LysKOM user has a person. A person contains some statistics about what the user has done (texts created, texts read, logon time, and some other stuff). Every person is also associated with a letterbox with the same name of the person. The letterbox is essentially a regular closed conference. ")))))) (texts "Texts" (section ((id . "texts") (prompt . "Texts")) ((h1 nil ((TEXT . "Texts"))) (p nil ((TEXT . " The purpose of LysKOM is to communicate, and communication is done through texts. Texts are simply texts written by a LysKOM member. "))) (h2 nil ((TEXT . "Recipients"))) (p nil ((TEXT . " Every text has one or more recipients: conferences to which the text has been sent. There are three kinds of recipients: regular recipients, cc-recipients and bcc-recipients. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "Regular recipients"))) (TEXT . " are the most common. A regular recipient means that the text belongs in the specified conference (or conferences). Comments to the text will automatically be sent to the same set of recipients. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "CC recipients"))) (TEXT . " are used when you want to send a copy of a text to a conference, but don't want followups sent to that conference. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "BCC recipients"))) (TEXT . " are fairly unusual. To even ") (i nil ((TEXT . "see"))) (TEXT . " a BCC recipient you have to have permission to be a member in the recipient conference. This kind of recipient can be used when you want to send a copy of a text to somebody's letterbox, but don't want other readers to know. "))) (h2 nil ((TEXT . "Comments"))) (p nil ((TEXT . " A text can have comments. A thread of comments to comments to comments is often called comment thread, comment chain or comment tree (strictly speaking a comment thread is a path down the comment tree). Anyone can write comments to any text. There is not requirement that comments be sent to the same conferences as the commented texts. "))) (h2 nil ((TEXT . "Special texts"))) (p nil ((TEXT . " There are three kinds of special texts: presentations, FAQs and notices. A presentation is a text associated with a conference or letterbox, that contains a presentation of that conference or person. These are normally sent to special conferences. A FAQ is a text with frequently asked questions (and answers) in a particular conference. Normally, new FAQs will be displayed when entering the associated conference. Notices are texts that contain urgent information about a person or conference. You can use a notice when you will be away from LysKOM for a while, and similar occasions. ")))))) (settings "Settings" (section ((id . "settings") (prompt . "Settings")) ((h1 nil ((TEXT . "Settings"))) (p nil ((TEXT . " The elisp client has a large number of user-configurable settings. With a few exceptions you can change these by using the command ") (cref ((id . "kom-customize")) nil) (TEXT . ". "))) (p nil ((TEXT . " Settings can be saved in the server or in your .emacs. Settings that are saved in the server will apply only for a particular user on a particular server. Settings saved in .emacs take precedence over settings stored in the server. ")))))) (reading "Reading texts" (section ((id . "reading") (prompt . "Reading texts")) ((h1 nil ((TEXT . "Reading texts"))) (p nil ((TEXT . " To just read texts in the default order, simply press SPC until all texts have been displayed. The elisp client will display one text at a time until you have read all texts in all conferences you are a member of. Use the command ") (cref ((id . "kom-list-summary")) nil) (TEXT . " to see which texts will be shown. There are a large number of more advanced commands, some of which are listed in the sections mentioned below. "))) (list ((header . "See also:")) ((item nil ((refer ((id . "filter")) nil))) (item nil ((refer ((id . "review")) nil))) (item nil ((refer ((id . "mark")) nil)))))))) (filter "Avoiding certain texts" (section ((id . "filter") (prompt . "Avoiding certain texts")) ((h1 nil ((TEXT . "Avoiding certain texts"))) (p nil ((TEXT . " Sometimes you don't want to read certain texts. In those cases the following commands may be useful. Besides these, there are a number of commands for filtering texts, if there is a certain type of text you never want to see. "))) (inline ((id . "kom-set-unread")) nil) (inline ((id . "kom-jump")) nil) (inline ((id . "kom-super-jump")) nil)))) (mark "Remembering texts" (section ((id . "mark") (prompt . "Remembering texts")) ((h1 nil ((TEXT . "Remembering texts"))) (p nil ((TEXT . " Sometimes you might find a text that you want to remember. In these cases, mark the text. A mark is really just a number from 0 to 255, but the elisp client supports assigning easy-to-remember names to marks. "))) (inline ((id . "kom-mark-text")) nil) (inline ((id . "kom-unmark-text")) nil) (inline ((id . "kom-review-all-marked-texts")) nil) (inline ((id . "kom-review-marked-texts")) nil) (inline ((id . "kom-list-marks")) nil)))) (review "Finding old texts" (section ((id . "review") (prompt . "Finding old texts")) ((h1 nil ((TEXT . "Finding old texts"))) (p nil ((TEXT . " There are a large number of commands for finding old texts. All of these start with the word \"Review\". This is just a small sampling: "))) (inline ((id . "kom-review-by-to")) nil) (inline ((id . "kom-review-first")) nil) (inline ((id . "kom-review-more")) nil) (inline ((id . "kom-review-clear")) nil) (inline ((id . "kom-view-commented-text")) nil) (inline ((id . "kom-review-comments")) nil) (inline ((id . "kom-find-root-review")) nil) (inline ((id . "kom-find-root")) nil) (inline ((id . "kom-review-tree")) nil)))) (writing "Writing or changing texts" (section ((id . "writing") (prompt . "Writing or changing texts")) ((h1 nil ((TEXT . "Writing or changing texts"))) (p nil ((TEXT . " There are three basic types of texts: texts, comments and footnotes. All of them are texts, but they are associated to ") (i nil ((TEXT . "other"))) (TEXT . " texts in different ways. "))) (h2 nil ((TEXT . "Texts"))) (p nil ((TEXT . " These are texts that aren't comments to other texts. They start a new thread of discussion. Remember to choose a good subject line when you create new texts. "))) (inline ((id . "kom-write-text")) nil) (inline ((id . "kom-send-letter")) nil) (h2 nil ((TEXT . "Comments"))) (p nil ((TEXT . " Comments are texts that are comments to other texts. When you write a comment, check that the subject line and recipients are still suitable. Personal replies are simply comments sent to somebody's letterbox. "))) (inline ((id . "kom-write-comment")) nil) (inline ((id . "kom-private-answer")) nil) (h2 nil ((TEXT . "Footnotes"))) (p nil ((TEXT . " Footnotes are special comments that only the author of a text can create. Since they are presented before regular comments, they are useful when you want to clarify something you've written before people start writing comments to the text. "))) (inline ((id . "kom-write-footnote")) nil) (h2 nil ((TEXT . "Prefix argument"))) (p nil ((TEXT . " There are several ways to specify which text you want to comment or write a footnote to. When you give any of the comments listed above without an argument, they will apply to the most recenty read text. "))) (p nil ((TEXT . " Sometimes you want a different text. There are a few commands that apply to the next-to-most-recently read (") (cref ((id . "kom-comment-previous")) nil) (TEXT . ", ") (cref ((id . "kom-private-answer-previous")) nil) (TEXT . "), and by using prefix arguments you can specify any text to any command. Supply a prefix argument as usual in Emacs by C-u followed by the argument, or simply type the argument directly. "))) (p nil ((TEXT . " Specify text ") (i nil ((TEXT . "N"))) (TEXT . " by giving the text number as the prefix argument. Specify the text where the cursor is by giving prefix argument 0. Specify the text ") (i nil ((TEXT . "N"))) (TEXT . " texts back in the buffer from the point where the cursor is by giving the prefix argument -") (i nil ((TEXT . "N"))) (TEXT . ". To get a prompt at which you can type the text number, simply hit C-u before giving the command. "))) (h2 nil ((TEXT . "Manage recipients"))) (p nil ((TEXT . " To change the recipients on a text you have to be the author of the text or administrator of the recipient you want to change. Use the commands ") (cref ((id . "kom-add-recipient")) nil) (TEXT . " to add and ") (cref ((id . "kom-sub-recipient")) nil) (TEXT . " to remove recipients. "))) (h2 nil ((TEXT . "Messages and remarks"))) (p nil ((TEXT . " Never use messages (personal, group or alarm messages) or remarks in place of regular texts. It won't work and people will get upset. ")))))) (kom-list-conferences "" (section ((id . "kom-list-conferences") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-conferences")) nil))) (p nil ((TEXT . " List conferences in LysKOM. Use this command with creative arguments to find conferences that you're interested in. ")))))) (kom-list-re "" (section ((id . "kom-list-re") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-re")) nil))) (p nil ((TEXT . " List conferences in LysKOM. Use this command with creative arguments to find conferences that you're interested in. ")))))) (kom-review-presentation "" (section ((id . "kom-review-presentation") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-presentation")) nil))) (p nil ((TEXT . " Show the presentation for a conference or person. Use this command to get more information about a conference. ")))))) (kom-add-self "" (section ((id . "kom-add-self") (prompt . "")) ((h3 nil ((cref ((id . "kom-add-self")) nil))) (p nil ((TEXT . " Join a conference so you can read the texts in the conference and so you'll find out when new texts are created. ")))))) (kom-go-to-conf "" (section ((id . "kom-go-to-conf") (prompt . "")) ((h3 nil ((cref ((id . "kom-go-to-conf")) nil))) (p nil ((TEXT . " Go to a conference you want to read texts in. If you aren't already a member of the conference, you will be asked if you want to join the conference. ")))))) (kom-write-footnote "" (section ((id . "kom-write-footnote") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-footnote")) nil))) (p nil ((TEXT . " Creates a new footnote to an existing text. ")))))) (kom-private-answer "" (section ((id . "kom-private-answer") (prompt . "")) ((h3 nil ((cref ((id . "kom-private-answer")) nil))) (p nil ((TEXT . " Creates a private reply to the author of an existing text. ")))))) (kom-write-comment "" (section ((id . "kom-write-comment") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-comment")) nil))) (p nil ((TEXT . " Creates a new comment to an existing text. ")))))) (kom-send-letter "" (section ((id . "kom-send-letter") (prompt . "")) ((h3 nil ((cref ((id . "kom-send-letter")) nil))) (p nil ((TEXT . " Creates a new letter. ")))))) (kom-write-text "" (section ((id . "kom-write-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-text")) nil))) (p nil ((TEXT . " Creates a new text that is not a comment to any other text. ")))))) (kom-review-tree "" (section ((id . "kom-review-tree") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-tree")) nil))) (p nil ((TEXT . " Reviews the entire tree of comments under the specified text. ")))))) (kom-find-root "" (section ((id . "kom-find-root") (prompt . "")) ((h3 nil ((cref ((id . "kom-find-root")) nil))) (p nil ((TEXT . " Finds the text that started the discussion that the specified text is part of. ")))))) (kom-find-root-review "" (section ((id . "kom-find-root-review") (prompt . "")) ((h3 nil ((cref ((id . "kom-find-root-review")) nil))) (p nil ((TEXT . " Reviews the entire tree of comments that the specified text is part of. Essentially the same as doing ") (cref ((id . "kom-find-root")) nil) (TEXT . " followed by ") (cref ((id . "kom-review-tree")) nil) (TEXT . ". ")))))) (kom-review-comments "" (section ((id . "kom-review-comments") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-comments")) nil))) (p nil ((TEXT . " Reviews all comments to the specified text, but not the comments to the comments. ")))))) (kom-view-commented-text "" (section ((id . "kom-view-commented-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-view-commented-text")) nil))) (p nil ((TEXT . " Reviews the text to which the specified text is a comment. ")))))) (kom-review-clear "" (section ((id . "kom-review-clear") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-clear")) nil))) (p nil ((TEXT . " Aborts all review commands that are active. ")))))) (kom-review-more "" (section ((id . "kom-review-more") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-more")) nil))) (p nil ((TEXT . " Reviews more texts using the same criteria as the most recent ") (cref ((id . "kom-review-by-to")) nil) (TEXT . ", or ") (cref ((id . "kom-review-first")) nil) (TEXT . " command. ")))))) (kom-review-first "" (section ((id . "kom-review-first") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-first")) nil))) (p nil ((TEXT . " Reviews the first text(s) created by a particular person sent to a particular conference. Any parameter can be ignored by simply not supplying a value (use zero for the number of texts) in order to do things like review all texts to a particular conference, the first five texts written by a particular person and so forth. ")))))) (kom-review-by-to "" (section ((id . "kom-review-by-to") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-by-to")) nil))) (p nil ((TEXT . " Reviews the text(s) most recently created by a particular person sent to a particular conference. Any parameter can be ignored by simply not supplying a value (use zero for the number of texts) in order to do things like review all texts to a particular conference, the last five texts written by a particular person and so forth. ")))))) (kom-list-marks "" (section ((id . "kom-list-marks") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-marks")) nil))) (p nil ((TEXT . " Lists all texts marked with a particular mark. ")))))) (kom-review-marked-texts "" (section ((id . "kom-review-marked-texts") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-marked-texts")) nil))) (p nil ((TEXT . " Reviews all texts marked with a particular mark. ")))))) (kom-review-all-marked-texts "" (section ((id . "kom-review-all-marked-texts") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-all-marked-texts")) nil))) (p nil ((TEXT . " Reviews all marked texts. ")))))) (kom-unmark-text "" (section ((id . "kom-unmark-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-unmark-text")) nil))) (p nil ((TEXT . " Removes your marks from a texts. ")))))) (kom-mark-text "" (section ((id . "kom-mark-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-mark-text")) nil))) (p nil ((TEXT . " Marks a texts. Normally this command will ask for the mark to use. ")))))) (kom-super-jump "" (section ((id . "kom-super-jump") (prompt . "")) ((h3 nil ((cref ((id . "kom-super-jump")) nil))) (p nil ((TEXT . " Creates a filter that will skip texts that have the same subject line as the specified text and are sent to the current conference. ")))))) (kom-jump "" (section ((id . "kom-jump") (prompt . "")) ((h3 nil ((cref ((id . "kom-jump")) nil))) (p nil ((TEXT . " Skips all texts in the comment tree below the most recently read text. This is useful when you see a text that starts a discussion that you aren't interested in. ")))))) (kom-set-unread "" (section ((id . "kom-set-unread") (prompt . "")) ((h3 nil ((cref ((id . "kom-set-unread")) nil))) (p nil ((TEXT . " Set the number of unread texts in a particular conference. Can be useful when you have lots of old texts to catch up with. ")))))) (kom-prioritize "" (section ((id . "kom-prioritize") (prompt . "")) ((h3 nil ((cref ((id . "kom-prioritize")) nil))) (p nil ((TEXT . " Interactively change priorities and placements of your memberships. For more information, press C-h m or ? when you have given the command. ")))))))))

(defvar lyskom-sv-help-data (quote ((conferences "Veta mer om mten" (section ((id . "conferences") (prompt . "Veta mer om mten")) ((h1 nil ((TEXT . "Mten"))) (p nil ((TEXT . " Varje LysKOM-system r uppdelat i ett antal olika mten som alla behandlar olika mnen. Vem som helst kan skapa mten, men man ska tnka efter ordenligt innan man skapar ett mte. I ett gammalt LysKOM-system s finns det ofta redan mten som handlar om det man r intresserad av. "))) (p nil ((TEXT . " Mten kan vara ppna, slutna och hemliga. Vem som helst kan g med i och lsa inlgg i alla ppna mten. Fr att g med i slutna mten mste mtesorganisatren lgga till medlemskapet. Hemliga mten gr inte ens att se, och servern gr sitt bsta fr att inte lcka ngon information om dessa. De flesta mten brukar vara ppna. Slutna och hemliga mten r mycket ovanligare. "))) (p nil ((TEXT . " Fljande kommandon kan vara av intresse fr att komma igng: "))) (inline ((id . "kom-list-conferences")) nil) (inline ((id . "kom-list-re")) nil) (inline ((id . "kom-review-presentation")) nil) (inline ((id . "kom-add-self")) nil) (inline ((id . "kom-go-to-conf")) nil) (h2 nil ((TEXT . "Prioriteter"))) (p nil ((TEXT . " Dina medlemskap i mten har prioriteter. Mten med hgre prioritet kommer att presenteras fre mten med lgre prioritet nr du loggar in. Anvnd ") (cref ((id . "kom-prioritize")) nil) (TEXT . " fr att prioritera mten. ")))))) (persons "Veta mer om personer" (section ((id . "persons") (prompt . "Veta mer om personer")) ((h1 nil ((TEXT . "Personer"))) (p nil ((TEXT . " Varje anvndare i LysKOM har en person. En person innehller en del statistik om vad anvndaren har gjort (skapade inlgg, lsta inlgg, nrvarotid och en del annat). Varje person r dessutom kopplad till en brevlda med samma namn som personen. Brevldan r i princip ett vanligt mte, men frn brjan r det slutet. ")))))) (texts "Veta mer om inlgg" (section ((id . "texts") (prompt . "Veta mer om inlgg")) ((h1 nil ((TEXT . "Inlgg"))) (p nil ((TEXT . " Inlgg r LysKOMs syfte. Inlgg r helt enkelt texter skrivna av ngon medlen i LysKOM. "))) (h2 nil ((TEXT . "Mottagare"))) (p nil ((TEXT . " Varje inlgg har en eller flera mottagare; mten som inlgget r skickat till. Mottagare finns i tre olika smaker: vanlig mottagare, extra-kopiemottagare och dold mottagare. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "Vanlig mottagare"))) (TEXT . " r det normala. En vanlig mottagare betyder att inlgget hr hemma i det angivna mtet (eller i alla angivna mten). Kommentarer till inlgget kommer automatiskt att skickas till samma mottagare. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "Extra-kopiemottagare"))) (TEXT . " anvnds nr man vill skicka en kopia av ett inlgg till ett mte utan att kommentarer till inlgget skall hamna i mtet. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "Dold mottagare"))) (TEXT . " r ganska ovanligt. Bara den som har rtt att vara medlem i mtet som r dold mottagare kan verhuvudtaget se den dolda mottagaren. Detta kan allts anvndas fr att skicka inlgg till ngons brevlda eller till ett slutet mte utan att andra kan se det. "))) (h2 nil ((TEXT . "Kommentarer"))) (p nil ((TEXT . " Ett inlgg kan ha kommentarer. Kommentarer till kommentarer till kommentarer bildar trdar, kommentarskedjor, kommentarstrd och inlggstrd. Vem som helst kan skriva kommentarer till vilket inlgg som helst. Det finns inget krav p att kommentarer ska skickas till samma mten som det som kommenteras. Det r till exempel rtt vanligt med kommentarer som bara skickas till frfattaren fr det kommenterade inlgget. "))) (h2 nil ((TEXT . "Speciella inlgg"))) (p nil ((TEXT . " Det finns tre speciella inlggstyper: presentationer, FAQer och Lappar. En presentation r ett inlgg kopplat till ett mte eller en brevlda som innehller en presentation av mtet eller personen. Dessa ligger normalt i speciella mten. En FAQ r ett inlgg som svarar p frgor som ofta stlls i mtet. Varje FAQ r kopplad till ett eller flera mten, och man erbjuds att lsa nya FAQer s fort elispklienten ser att de har skapats. Lappar r inlgg som r kopplade till mten, brevldor eller till hela servern som innehller viktig information. Till exempel r det vanligt att tala om att man reser bort och inte kan lsa LysKOM genom att stta en lapp p sin brevlda. ")))))) (settings "Veta mer om instllningar" (section ((id . "settings") (prompt . "Veta mer om instllningar")) ((h1 nil ((TEXT . "Instllningar"))) (p nil ((TEXT . " Elispklienten har ett stort antal instllningar. Med ngra f undantag kan man ndra alla via kommandot ") (cref ((id . "kom-customize")) nil) (TEXT . ". "))) (p nil ((TEXT . " Instllningar kan sparas antingen i servern eller i din .emacs. Instllningar som sparas i servern gller per anvndare och endast fr en session. Instllningar som sparas i .emacs gller i alla sessioner, oavsett om samma instllningar ven har sparats i servern. ")))))) (reading "Lsa inlgg" (section ((id . "reading") (prompt . "Lsa inlgg")) ((h1 nil ((TEXT . "Att lsa inlgg"))) (p nil ((TEXT . " Fr att bara lsa inlgg i den ordning de presenteras i LysKOM rcker det att trycka p SPC. Ett inlgg i taget kommer att visas tills det inte finns ngra kvar. Det finns ven ett antal mer avancerade kommandon. Anvnd kommandot ") (cref ((id . "kom-list-summary")) nil) (TEXT . " fr att se vilka inlgg som ligger p k fr att lsas. "))) (list ((header . "Se ven:")) ((item nil ((refer ((id . "filter")) nil))) (item nil ((refer ((id . "review")) nil))) (item nil ((refer ((id . "mark")) nil)))))))) (filter "Slippa lsa inlgg" (section ((id . "filter") (prompt . "Slippa lsa inlgg")) ((h1 nil ((TEXT . "Kommandon fr att slippa lsa inlgg"))) (p nil ((TEXT . " Ibland vill man inte lsa en del inlgg. D kan fljande kommandon komma vl till pass. Frutom dessa finns ett antal kommandon fr att filtrera inlgg, om det r ngon typ av inlgg som man aldrig vill se. "))) (inline ((id . "kom-set-unread")) nil) (inline ((id . "kom-jump")) nil) (inline ((id . "kom-super-jump")) nil)))) (mark "Komma ihg inlgg" (section ((id . "mark") (prompt . "Komma ihg inlgg")) ((h1 nil ((TEXT . "Kommandon fr att komma ihg inlgg"))) (p nil ((TEXT . " Ibland hittar man ett inlgg som man vill komma ihg. D kan man markera inlgget. I grund och botten r varje markering ett heltal mellan 0 och 255, men med elispklienten kan man ge ett namn till varje typ av markering. "))) (inline ((id . "kom-mark-text")) nil) (inline ((id . "kom-unmark-text")) nil) (inline ((id . "kom-review-all-marked-texts")) nil) (inline ((id . "kom-review-marked-texts")) nil) (inline ((id . "kom-list-marks")) nil)))) (review "Hitta gamla inlgg" (section ((id . "review") (prompt . "Hitta gamla inlgg")) ((h1 nil ((TEXT . "Kommandon fr att hitta gamla inlgg"))) (p nil ((TEXT . " Ibland vill man hitta gamla inlgg. Det finns ett stort antal kommadon fr att gra detta, och alla har namn som brjar med \"terse\". "))) (inline ((id . "kom-review-by-to")) nil) (inline ((id . "kom-review-first")) nil) (inline ((id . "kom-review-more")) nil) (inline ((id . "kom-review-clear")) nil) (inline ((id . "kom-view-commented-text")) nil) (inline ((id . "kom-review-comments")) nil) (inline ((id . "kom-find-root-review")) nil) (inline ((id . "kom-find-root")) nil) (inline ((id . "kom-review-tree")) nil)))) (writing "Skriva eller ndra inlgg" (section ((id . "writing") (prompt . "Skriva eller ndra inlgg")) ((h1 nil ((TEXT . "Att skriva eller ndra inlgg"))) (p nil ((TEXT . " Det finns i grund och botten tre sorters inlgg: urinlgg, kommentarer och fotnoter. Alla r inlgg, men de hnger ihop med andra inlgg p olika stt. "))) (h2 nil ((TEXT . "Urinlgg"))) (p nil ((TEXT . " Urinlgg r inlgg som inte r kommentarer till ngot annat inlgg. Dessa inleder i allmnhet nya diskussioner. Kom ihg att skriva en vettig renderad nr du skriver nya urinlgg. Brev r vanliga inlgg som skickas till ngons brevlda. "))) (inline ((id . "kom-write-text")) nil) (inline ((id . "kom-send-letter")) nil) (h2 nil ((TEXT . "Kommentarer"))) (p nil ((TEXT . " Kommentarer r, som det lter, kommentarer till andra inlgg. Nr du skriver en kommentar, kolla att renderaden fortfarande r vettig, och kolla att mottagarna till inlgget r vettiga. ndra det som inte r vettigt. Personliga svar r kommentarer som skickas till frfattarens brevlda. Det r egentligen bara vanliga kommentarer dr man har bytt mottagare. "))) (inline ((id . "kom-write-comment")) nil) (inline ((id . "kom-private-answer")) nil) (h2 nil ((TEXT . "Fotnoter"))) (p nil ((TEXT . " Fotnoter r speciella kommentarer som bara frfattaren till ett inlgg kan skriva. De visas fre vanliga kommentarer och r bra nr man vill klargra ngot man har skrivit i ett inlgg s att det visas innan folk brjar kommentera inlgget. "))) (inline ((id . "kom-write-footnote")) nil) (h2 nil ((TEXT . "Prefixargument"))) (p nil ((TEXT . " Det finns flera stt att ange vilket inlgg man vill kommentera eller skriva en fotnot till. Nr man ger ngot av ovanstende kommando utan extra argument s gller kommandot det senaste inlgg som man lste (fr fotnoter det senaste man skrev eller lste som man var frfattare till). "))) (p nil ((TEXT . " Ibland vill man ha en annan text. Dels finns kommandon som kommenterar den nst sista text man lste (") (cref ((id . "kom-comment-previous")) nil) (TEXT . ", ") (cref ((id . "kom-private-answer-previous")) nil) (TEXT . "). Dessutom finns mjligheter att ge prefixargument till alla kommandon som hanterar inlgg. Ange prefixargument som vanligt i Emacs genom C-u fljt av argumentets vrde, eller genom att bara skriva in argumentets vrde direkt. "))) (p nil ((TEXT . " Ange ett textnummer ") (i nil ((TEXT . "N"))) (TEXT . " genom att ge inlggsnumret som prefixargument. Ange inlgget som markren str i genom att ge prefixargument 0. Ange inlgget ") (i nil ((TEXT . "N"))) (TEXT . " inlgg bakt i bufferten frn dr markren str genom att ge argument -") (i nil ((TEXT . "N"))) (TEXT . ". F en prompt att mata in inlggsnumret vid genom att skriva C-u fre kommandot. "))) (h2 nil ((TEXT . "Hantera mottagare"))) (p nil ((TEXT . " Ibland vill man ndra mottagare p ett inlgg. Till det finns kommandona ") (cref ((id . "kom-add-recipient")) nil) (TEXT . " fr att lgga till och ") (cref ((id . "kom-sub-recipient")) nil) (TEXT . " fr att ta bort mottagare. "))) (h2 nil ((TEXT . "Meddelanden och anmrkningar"))) (p nil ((TEXT . " Anvnd aldrig meddelanden eller anmrkningar istllet fr vanliga inlgg. Det fungerar inte och folk blir sura. ")))))) (kom-list-conferences "" (section ((id . "kom-list-conferences") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-conferences")) nil))) (p nil ((TEXT . " Lista mten som finns i systemet. Anvnd detta kommando med fantasifulla skbegrepp fr att hitta mten som du r intresserad av. ")))))) (kom-list-re "" (section ((id . "kom-list-re") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-re")) nil))) (p nil ((TEXT . " Lista mten som finns i systemet. Anvnd detta kommando med fantasifulla skbegrepp fr att hitta mten som du r intresserad av. ")))))) (kom-review-presentation "" (section ((id . "kom-review-presentation") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-presentation")) nil))) (p nil ((TEXT . " Visa presentationen fr ett mte eller en person. Anvnd detta fr att f mer information om ett mte. ")))))) (kom-add-self "" (section ((id . "kom-add-self") (prompt . "")) ((h3 nil ((cref ((id . "kom-add-self")) nil))) (p nil ((TEXT . " G med i ett mte s att du kan lsa inlggen i mtet och s du fr veta nr det kommer nya inlgg. ")))))) (kom-go-to-conf "" (section ((id . "kom-go-to-conf") (prompt . "")) ((h3 nil ((cref ((id . "kom-go-to-conf")) nil))) (p nil ((TEXT . " G till ett mte som du vill lsa inlgg i. Om du inte redan r medlem i mtet s kommer du att erbjudas att bli medlem. ")))))) (kom-write-footnote "" (section ((id . "kom-write-footnote") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-footnote")) nil))) (p nil ((TEXT . " Skapar en ny fotnot till ett befintligt inlgg. ")))))) (kom-private-answer "" (section ((id . "kom-private-answer") (prompt . "")) ((h3 nil ((cref ((id . "kom-private-answer")) nil))) (p nil ((TEXT . " Skapar ett personligt svar till ett befintligt inlgg. ")))))) (kom-write-comment "" (section ((id . "kom-write-comment") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-comment")) nil))) (p nil ((TEXT . " Skapar en ny kommentar till ett befintligt inlgg. ")))))) (kom-send-letter "" (section ((id . "kom-send-letter") (prompt . "")) ((h3 nil ((cref ((id . "kom-send-letter")) nil))) (p nil ((TEXT . " Skapar ett nytt brev. ")))))) (kom-write-text "" (section ((id . "kom-write-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-text")) nil))) (p nil ((TEXT . " Skapar ett nytt urinlgg. ")))))) (kom-review-tree "" (section ((id . "kom-review-tree") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-tree")) nil))) (p nil ((TEXT . " terser hela kommentarstrdet under det angivna inlgget. ")))))) (kom-find-root "" (section ((id . "kom-find-root") (prompt . "")) ((h3 nil ((cref ((id . "kom-find-root")) nil))) (p nil ((TEXT . " terser urinlgget till det angivna inlgget. ")))))) (kom-find-root-review "" (section ((id . "kom-find-root-review") (prompt . "")) ((h3 nil ((cref ((id . "kom-find-root-review")) nil))) (p nil ((TEXT . " terser hela kommentarstrdet som det angivna inlgget r en del av. Ungefr samma sak som att gra ") (cref ((id . "kom-find-root")) nil) (TEXT . " fljt av ") (cref ((id . "kom-review-tree")) nil) (TEXT . ". ")))))) (kom-review-comments "" (section ((id . "kom-review-comments") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-comments")) nil))) (p nil ((TEXT . " terser alla kommentarer till det angivna inlgget, men inte kommentarer till kommentarerna. ")))))) (kom-view-commented-text "" (section ((id . "kom-view-commented-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-view-commented-text")) nil))) (p nil ((TEXT . " terser inlgget som det angivna inlgget r en kommentar till. ")))))) (kom-review-clear "" (section ((id . "kom-review-clear") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-clear")) nil))) (p nil ((TEXT . " Avbryter alla tersekommandon som r aktiva. ")))))) (kom-review-more "" (section ((id . "kom-review-more") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-more")) nil))) (p nil ((TEXT . " terser fler inlgg med samma kriterier som senaste ") (cref ((id . "kom-review-by-to")) nil) (TEXT . ", eller ") (cref ((id . "kom-review-first")) nil) (TEXT . ". ")))))) (kom-review-first "" (section ((id . "kom-review-first") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-first")) nil))) (p nil ((TEXT . " terser de frsta inlggen skrivna av en viss person till ett visst mte. Om du inte anger en viss parameter (eller stter antal till noll) s tas ingen hnsyn till den parametern, s man kan terse allt av en viss person, fsta 5 av en viss person till alla mten och s vidare. ")))))) (kom-review-by-to "" (section ((id . "kom-review-by-to") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-by-to")) nil))) (p nil ((TEXT . " terser de senaste inlggen skrivna av en viss person till ett visst mte. Om du inte anger en viss parameter (eller stter antal till noll) s tas ingen hnsyn till den parametern, s man kan terse allt av en viss person, fsta 5 av en viss person till alla mten och s vidare. ")))))) (kom-list-marks "" (section ((id . "kom-list-marks") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-marks")) nil))) (p nil ((TEXT . " Listar alla inlgg markerade med en viss markeringstyp. ")))))) (kom-review-marked-texts "" (section ((id . "kom-review-marked-texts") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-marked-texts")) nil))) (p nil ((TEXT . " terser inlgg markerade med en viss markeringstyp. ")))))) (kom-review-all-marked-texts "" (section ((id . "kom-review-all-marked-texts") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-all-marked-texts")) nil))) (p nil ((TEXT . " terser alla markerade inlgg. ")))))) (kom-unmark-text "" (section ((id . "kom-unmark-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-unmark-text")) nil))) (p nil ((TEXT . " Avmarkerar ett inlgg. ")))))) (kom-mark-text "" (section ((id . "kom-mark-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-mark-text")) nil))) (p nil ((TEXT . " Markerar ett inlgg. Frgar normalt efter inlggstyp. ")))))) (kom-super-jump "" (section ((id . "kom-super-jump") (prompt . "")) ((h3 nil ((cref ((id . "kom-super-jump")) nil))) (p nil ((TEXT . " Skapar ett filter som hoppar ver inlgg som har samma renderad som det angivna inlgget och som har aktuellt mte som mottagare. ")))))) (kom-jump "" (section ((id . "kom-jump") (prompt . "")) ((h3 nil ((cref ((id . "kom-jump")) nil))) (p nil ((TEXT . " Hoppar ver kommentarstrdet rotat i det senast lsta inlgget. Praktiskt nr man ser att ett inlgg inleder en diskussion som man inte r intresserad av. ")))))) (kom-set-unread "" (section ((id . "kom-set-unread") (prompt . "")) ((h3 nil ((cref ((id . "kom-set-unread")) nil))) (p nil ((TEXT . " Stter antalet olsta i aktuellt mte. Kan vara bra om man har mnga gamla inlgg att lsa ikapp eller helt enkelt inte r intresserad av ngonting i mtet. ")))))) (kom-prioritize "" (section ((id . "kom-prioritize") (prompt . "")) ((h3 nil ((cref ((id . "kom-prioritize")) nil))) (p nil ((TEXT . " ndra interaktivt prioriteter och placeringar p dina medlemskap i olika men. Tryck C-h m eller ? nr du har gett kommandot fr mer information. ")))))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: komtypes.el,v 44.22 2002/05/01 21:42:39 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; This file contains primitives for the different data types
;;;; in the lyskom system. All types here have their origin in
;;;; the server. Compare the file clienttypes.el.
;;;;
;;;; Author: ceder
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: komtypes.el,v 44.22 2002/05/01 21:42:39 byers Exp $\n"))


;;; ============================================================
;;; Black magic...

(defmacro def-komtype (type &rest args)
  (let ((typename (symbol-name type))
	(n 0)
        (tmp nil))
    ;; Constructor
    (append
     (list 'progn
           (list 'defsubst
                 (intern (concat "lyskom-create-" typename))
                 args
                 (concat "Create a `" typename "' from arguments.\n"
                         "Args: " (upcase (mapconcat
                                           'symbol-name args " ")) "\n"
                         "Automatically created with def-komtype.")
                 (list 'cons
                       (list 'quote (intern (upcase typename)))
                       (cons 'vector args)))
           ;; Identifier
           (list 'defsubst
                 (intern (concat "lyskom-" typename "-p"))
                 (list type)
                 (concat "Return `t' if " (upcase typename)
                         " is a " typename ".\n"
                         "Args: " (upcase typename) "\n"
                         "Automatically created with def-komtype.")
                 (list 'and
                       (list 'consp type)
                       (list 'eq (list 'car type)
                             (list 'quote (intern (upcase typename)))))))
    ;; Selectors/Modifiers
     (progn
       (while args
         (let ((argname (symbol-name (car args))))
           ;; Selctor
           (setq tmp (cons
                      (list 'defsubst
                            (intern (concat typename "->" argname))
                            (list type)
                            "Automatically created with def-komtype."
                            (list 'aref (list 'cdr type) n))
                      tmp))
           ;; Modifier
           (setq tmp (cons
                      (list 'defsubst
                            (intern (concat "set-" typename "->" argname))
                            (list type (car args))
                            "Automatically created with def-komtype."
                            (list 'aset (list 'cdr type) n (car args)))
                      tmp))
           (setq n (1+ n)
                 args (cdr args))))
       tmp))))



;;; ================================================================
;;;                            conf-no-list


;;; Constructor:

(defsubst lyskom-create-conf-no-list (conf-nos)
  "Create a conf-no-list from all parameters."
  (cons
   'CONF-NO-LIST
   (vector
    (cond ((vectorp conf-nos) (append conf-nos nil))
          (t conf-nos)))))



;;; Selector:

(defsubst conf-no-list->conf-nos (conf-no-list)
  "Get conf-nos from conf-no-list."
  (elt (cdr conf-no-list) 0))


;;; Modifier:

(defsubst set-conf-no-list->conf-nos (conf-no-list newval)
  "Set conf-nos in conf-no-list to NEWVAL."
  (aset (cdr conf-no-list) 0 newval))


;;; Predicate:

(defsubst lyskom-conf-no-list-p (object)
  "Return t if OBJECT is a conf-no-list."
  (eq (car-safe object) 'CONF-NO-LIST))


;;; Special functions

(defsubst lyskom-conf-no-list-member (conf-no conf-no-list)
  "Returns non-nil if CONF-NO is a member of CONF-NO-LIST.
CONF-NO is a conf-no and CONF-NO-LIST is a conf-no-list."
  (if (= (length (conf-no-list->conf-nos conf-no-list)) 0)
      nil
    (let* ((r 0)
	   (list (conf-no-list->conf-nos conf-no-list))
	   (len (length list))
	   (yes nil))
      (while (and (not yes)
		  (< r len))
	(if (= conf-no (elt list r))
	    (setq yes t)
	  (setq r (1+ r))))
      yes)))

;;; ================================================================
;;;                            uconf-stat

;;; Constructor:

(def-komtype uconf-stat 
  conf-no name conf-type highest-local-no nice)

;;; ================================================================
;;;                            conf-stat

;;; Constructor:

(defsubst lyskom-create-conf-stat (conf-no
				name
				conf-type
				creation-time
				last-written
				creator
				presentation
				supervisor
				permitted-submitters
				super-conf
				msg-of-day
				garb-nice
                                keep-commented
				no-of-members
				first-local-no
				no-of-texts
                                &optional expire
                                aux-items)
  "Create a conf-stat from all parameters."
  (cons
   'CONF-STAT
   (vector conf-no name conf-type creation-time last-written 
	   creator presentation supervisor permitted-submitters 
	   super-conf msg-of-day garb-nice no-of-members first-local-no 
	   no-of-texts (or expire 0) aux-items)))


;;; Selectors:

(defsubst conf-stat->conf-no (conf-stat)
  "Get conf-no from conf-stat."
  (elt (cdr conf-stat) 0))

(defsubst conf-stat->name (conf-stat)
  "Get name from conf-stat."
  (elt (cdr conf-stat) 1))

(defsubst conf-stat->conf-type (conf-stat)
  "Get conf-type from conf-stat."
  (elt (cdr conf-stat) 2))

(defsubst conf-stat->creation-time (conf-stat)
  "Get creation-time from conf-stat."
  (elt (cdr conf-stat) 3))

(defsubst conf-stat->last-written (conf-stat)
  "Get last-written from conf-stat."
  (elt (cdr conf-stat) 4))

(defsubst conf-stat->creator (conf-stat)
  "Get creator from conf-stat."
  (elt (cdr conf-stat) 5))

(defsubst conf-stat->presentation (conf-stat)
  "Get presentation from conf-stat."
  (elt (cdr conf-stat) 6))

(defsubst conf-stat->supervisor (conf-stat)
  "Get supervisor from conf-stat."
  (elt (cdr conf-stat) 7))

(defsubst conf-stat->permitted-submitters (conf-stat)
  "Get permitted-submitters from conf-stat."
  (elt (cdr conf-stat) 8))

(defsubst conf-stat->super-conf (conf-stat)
  "Get super-conf from conf-stat."
  (elt (cdr conf-stat) 9))

(defsubst conf-stat->msg-of-day (conf-stat)
  "Get msg-of-day from conf-stat."
  (elt (cdr conf-stat) 10))

(defsubst conf-stat->garb-nice (conf-stat)
  "Get garb-nice from conf-stat."
  (elt (cdr conf-stat) 11))

(defsubst conf-stat->no-of-members (conf-stat)
  "Get no-of-members from conf-stat."
  (elt (cdr conf-stat) 12))

(defsubst conf-stat->first-local-no (conf-stat)
  "Get first-local-no from conf-stat."
  (elt (cdr conf-stat) 13))

(defsubst conf-stat->no-of-texts (conf-stat)
  "Get no-of-texts from conf-stat."
  (elt (cdr conf-stat) 14))

(defsubst conf-stat->expire (conf-stat)
  "Get expire from conf-stat."
  (elt (cdr conf-stat) 15))

(defsubst conf-stat->aux-items (conf-stat)
  "Get aux-items from conf-stat."
  (elt (cdr conf-stat) 16))


;;; Modifiers:

(defsubst set-conf-stat->conf-no (conf-stat newval)
  "Set conf-no in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 0 newval))

(defsubst set-conf-stat->name (conf-stat newval)
  "Set name in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 1 newval))

(defsubst set-conf-stat->conf-type (conf-stat newval)
  "Set conf-type in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 2 newval))

(defsubst set-conf-stat->creation-time (conf-stat newval)
  "Set creation-time in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 3 newval))

(defsubst set-conf-stat->last-written (conf-stat newval)
  "Set last-written in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 4 newval))

(defsubst set-conf-stat->creator (conf-stat newval)
  "Set creator in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 5 newval))

(defsubst set-conf-stat->presentation (conf-stat newval)
  "Set presentation in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 6 newval))

(defsubst set-conf-stat->supervisor (conf-stat newval)
  "Set supervisor in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 7 newval))

(defsubst set-conf-stat->permitted-submitters (conf-stat newval)
  "Set permitted-submitters in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 8 newval))

(defsubst set-conf-stat->super-conf (conf-stat newval)
  "Set super-conf in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 9 newval))

(defsubst set-conf-stat->msg-of-day (conf-stat newval)
  "Set msg-of-day in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 10 newval))

(defsubst set-conf-stat->garb-nice (conf-stat newval)
  "Set garb-nice in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 11 newval))

(defsubst set-conf-stat->no-of-members (conf-stat newval)
  "Set no-of-members in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 12 newval))

(defsubst set-conf-stat->first-local-no (conf-stat newval)
  "Set first-local-no in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 13 newval))

(defsubst set-conf-stat->no-of-texts (conf-stat newval)
  "Set no-of-texts in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 14 newval))

(defsubst set-conf-stat->expire (conf-stat newval)
  "Set expire in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 15 newval))

(defsubst set-conf-stat->aux-items (conf-stat newval)
  "Set aux-items in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 16 newval))



;;; Predicate:

(defsubst lyskom-conf-stat-p (object)
  "Return t if OBJECT is a conf-stat."
  (eq (car-safe object) 'CONF-STAT))


				
				
;;; ================================================================
;;;                         Conf-list


;;; Constructor:

(defsubst lyskom-create-conf-list (conf-nos conf-types)
  "Create a conf-list from CONF-NOS and CONF-TYPES.
CONF-NOS is a vector of numbers. CONF-TYPES is a vector of conf-type.
Both vectors should be of the same length."
  (cons 'CONF-LIST (cons conf-nos conf-types)))


;;; Selectors:

(defsubst conf-list->conf-nos (conf-list)
  "Get the conf-nos part of CONF-LIST"
  (car (cdr conf-list)))

(defsubst conf-list->conf-types (conf-list)
  "Get the conf-types part of CONF-LIST"
  (cdr (cdr conf-list)))


;;; Predicate:

(defsubst conf-list-p (object)
  "Return true if OBJECT is a conf-list"
  (eq 'CONF-LIST (car-safe object)))


;;; Special functions:

(defsubst lyskom-conf-list-length (conf-list)
  "Return the length of CONF-LIST"
  (length (conf-list->conf-nos conf-list)))


;;; ================================================================
;;;                             pers-stat


;;; Constructor:

(defsubst lyskom-create-pers-stat (pers-no
				username
				privileges
				flags
				last-login
				user-area
				total-time-present
				sessions
				created-lines
				created-bytes
				read-texts
				no-of-text-fetches
				created-persons
				created-confs
				first-created-text
				no-of-created-texts
				no-of-marks
				no-of-confs)
  "Create a pers-stat from all parameters."
  (cons
   'PERS-STAT
   (vector pers-no username privileges flags last-login user-area 
	   total-time-present sessions created-lines created-bytes 
	   read-texts no-of-text-fetches created-persons created-confs 
	   first-created-text no-of-created-texts no-of-marks 
	   no-of-confs )))


;;; Selectors:

(defsubst pers-stat->pers-no (pers-stat)
  "Get pers-no from pers-stat."
  (elt (cdr pers-stat) 0))

(defsubst pers-stat->username (pers-stat)
  "Get username from pers-stat."
  (elt (cdr pers-stat) 1))

(defsubst pers-stat->privileges (pers-stat)
  "Get privileges from pers-stat."
  (elt (cdr pers-stat) 2))

(defsubst pers-stat->flags (pers-stat)
  "Get flags from pers-stat."
  (elt (cdr pers-stat) 3))

(defsubst pers-stat->last-login (pers-stat)
  "Get last-login from pers-stat."
  (elt (cdr pers-stat) 4))

(defsubst pers-stat->user-area (pers-stat)
  "Get user-area from pers-stat."
  (elt (cdr pers-stat) 5))

(defsubst pers-stat->total-time-present (pers-stat)
  "Get total-time-present from pers-stat."
  (elt (cdr pers-stat) 6))

(defsubst pers-stat->sessions (pers-stat)
  "Get sessions from pers-stat."
  (elt (cdr pers-stat) 7))

(defsubst pers-stat->created-lines (pers-stat)
  "Get created-lines from pers-stat."
  (elt (cdr pers-stat) 8))

(defsubst pers-stat->created-bytes (pers-stat)
  "Get created-bytes from pers-stat."
  (elt (cdr pers-stat) 9))

(defsubst pers-stat->read-texts (pers-stat)
  "Get read-texts from pers-stat."
  (elt (cdr pers-stat) 10))

(defsubst pers-stat->no-of-text-fetches (pers-stat)
  "Get no-of-text-fetches from pers-stat."
  (elt (cdr pers-stat) 11))

(defsubst pers-stat->created-persons (pers-stat)
  "Get created-persons from pers-stat."
  (elt (cdr pers-stat) 12))

(defsubst pers-stat->created-confs (pers-stat)
  "Get created-confs from pers-stat."
  (elt (cdr pers-stat) 13))

(defsubst pers-stat->first-created-text (pers-stat)
  "Get first-created-text from pers-stat."
  (elt (cdr pers-stat) 14))

(defsubst pers-stat->no-of-created-texts (pers-stat)
  "Get no-of-created-texts from pers-stat."
  (elt (cdr pers-stat) 15))

(defsubst pers-stat->no-of-marks (pers-stat)
  "Get no-of-marks from pers-stat."
  (elt (cdr pers-stat) 16))

(defsubst pers-stat->no-of-confs (pers-stat)
  "Get no-of-confs from pers-stat."
  (elt (cdr pers-stat) 17))


;;; Modifiers:

(defsubst set-pers-stat->pers-no (pers-stat newval)
  "Set pers-no in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 0 newval))

(defsubst set-pers-stat->username (pers-stat newval)
  "Set username in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 1 newval))

(defsubst set-pers-stat->privileges (pers-stat newval)
  "Set privileges in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 2 newval))

(defsubst set-pers-stat->flags (pers-stat newval)
  "Set flags in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 3 newval))

(defsubst set-pers-stat->last-login (pers-stat newval)
  "Set last-login in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 4 newval))

(defsubst set-pers-stat->user-area (pers-stat newval)
  "Set user-area in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 5 newval))

(defsubst set-pers-stat->total-time-present (pers-stat newval)
  "Set total-time-present in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 6 newval))

(defsubst set-pers-stat->sessions (pers-stat newval)
  "Set sessions in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 7 newval))

(defsubst set-pers-stat->created-lines (pers-stat newval)
  "Set created-lines in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 8 newval))

(defsubst set-pers-stat->created-bytes (pers-stat newval)
  "Set created-bytes in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 9 newval))

(defsubst set-pers-stat->read-texts (pers-stat newval)
  "Set read-texts in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 10 newval))

(defsubst set-pers-stat->no-of-text-fetches (pers-stat newval)
  "Set no-of-text-fetches in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 11 newval))

(defsubst set-pers-stat->created-persons (pers-stat newval)
  "Set created-persons in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 12 newval))

(defsubst set-pers-stat->created-confs (pers-stat newval)
  "Set created-confs in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 13 newval))

(defsubst set-pers-stat->first-created-text (pers-stat newval)
  "Set first-created-text in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 14 newval))

(defsubst set-pers-stat->no-of-created-texts (pers-stat newval)
  "Set no-of-created-texts in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 15 newval))

(defsubst set-pers-stat->no-of-marks (pers-stat newval)
  "Set no-of-marks in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 16 newval))

(defsubst set-pers-stat->no-of-confs (pers-stat newval)
  "Set no-of-confs in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 17 newval))


;;; Predicate:

(defsubst lyskom-pers-stat-p (object)
  "Return t if OBJECT is a pers-stat."
  (eq (car-safe object) 'PERS-STAT))


;;; ================================================================
;;;                           text-stat


;;; Constructor:

(defsubst lyskom-create-text-stat (text-no
				creation-time
				author
				no-of-lines
				no-of-chars
				no-of-marks
				misc-info-list
                                &optional aux-items)
  "Create a text-stat from all parameters."
  (cons
   'TEXT-STAT
   (vector text-no creation-time author no-of-lines no-of-chars 
	   no-of-marks misc-info-list aux-items)))


;;; Selectors:

(defsubst text-stat->text-no (text-stat)
  "Get text-no from text-stat."
  (elt (cdr text-stat) 0))

(defsubst text-stat->creation-time (text-stat)
  "Get creation-time from text-stat."
  (elt (cdr text-stat) 1))

(defsubst text-stat->author (text-stat)
  "Get author from text-stat."
  (elt (cdr text-stat) 2))

(defsubst text-stat->no-of-lines (text-stat)
  "Get no-of-lines from text-stat."
  (elt (cdr text-stat) 3))

(defsubst text-stat->no-of-chars (text-stat)
  "Get no-of-chars from text-stat."
  (elt (cdr text-stat) 4))

(defsubst text-stat->no-of-marks (text-stat)
  "Get no-of-marks from text-stat."
  (elt (cdr text-stat) 5))

(defsubst text-stat->misc-info-list (text-stat)
  "Get misc-info-list from text-stat."
  (elt (cdr text-stat) 6))

(defsubst text-stat->aux-items (text-stat)
  "Get aux-items from text-stat."
  (elt (cdr text-stat) 7))


;;; Modifiers:

(defsubst set-text-stat->text-no (text-stat newval)
  "Set text-no in text-stat to NEWVAL."
  (aset (cdr text-stat) 0 newval))

(defsubst set-text-stat->creation-time (text-stat newval)
  "Set creation-time in text-stat to NEWVAL."
  (aset (cdr text-stat) 1 newval))

(defsubst set-text-stat->author (text-stat newval)
  "Set author in text-stat to NEWVAL."
  (aset (cdr text-stat) 2 newval))

(defsubst set-text-stat->no-of-lines (text-stat newval)
  "Set no-of-lines in text-stat to NEWVAL."
  (aset (cdr text-stat) 3 newval))

(defsubst set-text-stat->no-of-chars (text-stat newval)
  "Set no-of-chars in text-stat to NEWVAL."
  (aset (cdr text-stat) 4 newval))

(defsubst set-text-stat->no-of-marks (text-stat newval)
  "Set no-of-marks in text-stat to NEWVAL."
  (aset (cdr text-stat) 5 newval))

(defsubst set-text-stat->misc-info-list (text-stat newval)
  "Set misc-info-list in text-stat to NEWVAL."
  (aset (cdr text-stat) 6 newval))

(defsubst set-text-stat->aux-items (text-stat newval)
  "Set aux-items in text-stat to NEWVAL."
  (aset (cdr text-stat) 7 newval))


;;; Predicate:

(defsubst lyskom-text-stat-p (object)
  "Return t if OBJECT is a text-stat."
  (eq (car-safe object) 'TEXT-STAT))

;;; ================================================================
;;;                              aux-item

(def-komtype aux-item-flags deleted inherit secret anonymous
  dont-garb reserved2 reserved3 reserved4)

(def-komtype aux-item aux-no 
                       tag
                       creator
                       sent-at
                       flags
                       inherit-limit
                       data)



;;; ================================================================
;;;                            text


;;; Constructor:

(defsubst lyskom-create-text (text-no
			   text-mass)
  "Create a text from all parameters."
  (cons
   'TEXT
   (vector text-no text-mass )))


;;; Selectors:

(defsubst text->text-no (text)
  "Get text-no from text."
  (elt (cdr text) 0))

(defsubst text->text-mass (text)
  "Get text-mass from text."
  (elt (cdr text) 1))


;;; Modifiers:

(defsubst set-text->text-no (text newval)
  "Set text-no in text to NEWVAL."
  (aset (cdr text) 0 newval))

(defsubst set-text->text-mass (text newval)
  "Set text-mass in text to NEWVAL."
  (aset (cdr text) 1 newval))


;;; Predicate:

(defsubst lyskom-text-p (object)
  "Return t if OBJECT is a text."
  (eq (car-safe object) 'TEXT))

;;; Utilities

(defun text->decoded-text-mass (text text-stat)
  "Get the text mass of a text after decoding according to its content type"
  (save-match-data 
    (let* ((str (text->text-mass text))
           (item (lyskom-get-aux-item
                  (text-stat->aux-items text-stat) 1))
           (content-type (and (car item)
                              (lyskom-mime-decode-content-type
                               (aux-item->data (car item))))))
      (if (cdr content-type)
          (lyskom-mime-decode-string str (cdr content-type))
        str))))

				   

;;; ================================================================
;;;                          misc-info


;;; Constructors:

(defsubst lyskom-create-misc-info (type
				recipient-no
				local-no
				rec-time
				comm-to
				comm-in
				footn-to
				footn-in
				sender
				sent-at)
  "Create a misc-info from all parameters.
TYPE is one of RECPT, CC-RECPT, BCC-RECPT, COMM-TO, COMM-IN, 
FOOTN-TO or FOOTN-IN."
  (cons
   'MISC-INFO
   (vector type recipient-no local-no rec-time comm-to comm-in 
	   footn-to footn-in sender sent-at )))

(defsubst lyskom-create-empty-misc-info ()
  "Create an empty misc-info."
  (lyskom-create-misc-info nil nil nil nil nil nil nil nil nil nil))


;;; Selectors:

(defsubst misc-info->type (misc-info)
  "Get type from misc-info."
  (elt (cdr misc-info) 0))

(defsubst misc-info->recipient-no (misc-info)
  "Get recipient-no from misc-info."
  (elt (cdr misc-info) 1))

(defsubst misc-info->local-no (misc-info)
  "Get local-no from misc-info."
  (elt (cdr misc-info) 2))

(defsubst misc-info->rec-time (misc-info)
  "Get rec-time from misc-info."
  (elt (cdr misc-info) 3))

(defsubst misc-info->comm-to (misc-info)
  "Get comm-to from misc-info."
  (elt (cdr misc-info) 4))

(defsubst misc-info->comm-in (misc-info)
  "Get comm-in from misc-info."
  (elt (cdr misc-info) 5))

(defsubst misc-info->footn-to (misc-info)
  "Get footn-to from misc-info."
  (elt (cdr misc-info) 6))

(defsubst misc-info->footn-in (misc-info)
  "Get footn-in from misc-info."
  (elt (cdr misc-info) 7))

(defsubst misc-info->sender (misc-info)
  "Get sender from misc-info."
  (elt (cdr misc-info) 8))

(defsubst misc-info->sent-at (misc-info)
  "Get sent-at from misc-info."
  (elt (cdr misc-info) 9))


;;; Modifiers:

(defsubst set-misc-info->type (misc-info newval)
  "Set type in misc-info to NEWVAL."
  (aset (cdr misc-info) 0 newval))

(defsubst set-misc-info->recipient-no (misc-info newval)
  "Set recipient-no in misc-info to NEWVAL."
  (aset (cdr misc-info) 1 newval))

(defsubst set-misc-info->local-no (misc-info newval)
  "Set local-no in misc-info to NEWVAL."
  (aset (cdr misc-info) 2 newval))

(defsubst set-misc-info->rec-time (misc-info newval)
  "Set rec-time in misc-info to NEWVAL."
  (aset (cdr misc-info) 3 newval))

(defsubst set-misc-info->comm-to (misc-info newval)
  "Set comm-to in misc-info to NEWVAL."
  (aset (cdr misc-info) 4 newval))

(defsubst set-misc-info->comm-in (misc-info newval)
  "Set comm-in in misc-info to NEWVAL."
  (aset (cdr misc-info) 5 newval))

(defsubst set-misc-info->footn-to (misc-info newval)
  "Set footn-to in misc-info to NEWVAL."
  (aset (cdr misc-info) 6 newval))

(defsubst set-misc-info->footn-in (misc-info newval)
  "Set footn-in in misc-info to NEWVAL."
  (aset (cdr misc-info) 7 newval))

(defsubst set-misc-info->sender (misc-info newval)
  "Set sender in misc-info to NEWVAL."
  (aset (cdr misc-info) 8 newval))

(defsubst set-misc-info->sent-at (misc-info newval)
  "Set sent-at in misc-info to NEWVAL."
  (aset (cdr misc-info) 9 newval))


;;; Predicate:

(defsubst lyskom-misc-info-p (object)
  "Return t if OBJECT is a misc-info."
  (eq (car-safe object) 'MISC-INFO))


;;; ================================================================
;;;                                time


;;; Constructor:

(defsubst lyskom-create-time (sec
			   min
			   hour
			   mday
			   mon
			   year
			   wday
			   yday
			   isdst
                           &optional tzhr tzmin)
  "Create a time from all parameters.

Note: YEAR is the actual year, *not* years since 1900.  MON is month
starting with *one* for January."
  (cons
   'TIME
   (vector sec min hour mday mon year wday yday isdst tzhr tzmin)))


;;; Selectors:

(defsubst time->sec (time)
  "Get sec from time."
  (elt (cdr time) 0))

(defsubst time->min (time)
  "Get min from time."
  (elt (cdr time) 1))

(defsubst time->hour (time)
  "Get hour from time."
  (elt (cdr time) 2))

(defsubst time->mday (time)
  "Get mday from time."
  (elt (cdr time) 3))

(defsubst time->mon (time)
  "Get mon from time."
  (elt (cdr time) 4))

(defsubst time->year (time)
  "Get year from time."
  (elt (cdr time) 5))

(defsubst time->wday (time)
  "Get wday from time."
  (elt (cdr time) 6))

(defsubst time->yday (time)
  "Get yday from time."
  (elt (cdr time) 7))

(defsubst time->isdst (time)
  "Get isdst from time."
  (elt (cdr time) 8))

(defsubst time->tzhr (time)
  "Get isdst from time."
  (elt (cdr time) 9))

(defsubst time->tzmin (time)
  "Get isdst from time."
  (elt (cdr time) 10))


;;; Predicate:

(defsubst lyskom-time-p (object)
  "Return t if OBJECT is a time."
  (eq (car-safe object) 'TIME))


;;; ================================================================
;;;                               privs


;;; Constructor:

(defsubst lyskom-create-privs (wheel
			       admin
			       statistic
			       create_pers
			       create_conf
			       change_name
			       flg7
			       flg8
			       flg9
			       flg10
			       flg11
			       flg12
			       flg13
			       flg14
			       flg15
			       flg16)
  "Create a privs from all parameters."
  (cons
   'PRIVS
   (vector wheel admin statistic create_pers create_conf change_name 
	   flg7 flg8 flg9 flg10 flg11 flg12 flg13 flg14 flg15 
	   flg16 )))


;;; Selectors:

(defsubst privs->wheel (privs)
  "Get wheel from privs."
  (elt (cdr privs) 0))

(defsubst privs->admin (privs)
  "Get admin from privs."
  (elt (cdr privs) 1))

(defsubst privs->statistic (privs)
  "Get statistic from privs."
  (elt (cdr privs) 2))

(defsubst privs->create_pers (privs)
  "Get create_pers from privs."
  (elt (cdr privs) 3))

(defsubst privs->create_conf (privs)
  "Get create_conf from privs."
  (elt (cdr privs) 4))

(defsubst privs->change_name (privs)
  "Get change_name from privs."
  (elt (cdr privs) 5))

(defsubst privs->flg7 (privs)
  "Get flg7 from privs."
  (elt (cdr privs) 6))

(defsubst privs->flg8 (privs)
  "Get flg8 from privs."
  (elt (cdr privs) 7))

(defsubst privs->flg9 (privs)
  "Get flg9 from privs."
  (elt (cdr privs) 8))

(defsubst privs->flg10 (privs)
  "Get flg10 from privs."
  (elt (cdr privs) 9))

(defsubst privs->flg11 (privs)
  "Get flg11 from privs."
  (elt (cdr privs) 10))

(defsubst privs->flg12 (privs)
  "Get flg12 from privs."
  (elt (cdr privs) 11))

(defsubst privs->flg13 (privs)
  "Get flg13 from privs."
  (elt (cdr privs) 12))

(defsubst privs->flg14 (privs)
  "Get flg14 from privs."
  (elt (cdr privs) 13))

(defsubst privs->flg15 (privs)
  "Get flg15 from privs."
  (elt (cdr privs) 14))

(defsubst privs->flg16 (privs)
  "Get flg16 from privs."
  (elt (cdr privs) 15))


;;; Modifiers:

(defsubst set-privs->wheel (privs newval)
  "Set wheel in privs to NEWVAL."
  (aset (cdr privs) 0 newval))

(defsubst set-privs->admin (privs newval)
  "Set admin in privs to NEWVAL."
  (aset (cdr privs) 1 newval))

(defsubst set-privs->statistic (privs newval)
  "Set statistic in privs to NEWVAL."
  (aset (cdr privs) 2 newval))

(defsubst set-privs->create_pers (privs newval)
  "Set create_pers in privs to NEWVAL."
  (aset (cdr privs) 3 newval))

(defsubst set-privs->create_conf (privs newval)
  "Set create_conf in privs to NEWVAL."
  (aset (cdr privs) 4 newval))

(defsubst set-privs->change_name (privs newval)
  "Set change_name in privs to NEWVAL."
  (aset (cdr privs) 5 newval))

(defsubst set-privs->flg7 (privs newval)
  "Set flg7 in privs to NEWVAL."
  (aset (cdr privs) 6 newval))

(defsubst set-privs->flg8 (privs newval)
  "Set flg8 in privs to NEWVAL."
  (aset (cdr privs) 7 newval))

(defsubst set-privs->flg9 (privs newval)
  "Set flg9 in privs to NEWVAL."
  (aset (cdr privs) 8 newval))

(defsubst set-privs->flg10 (privs newval)
  "Set flg10 in privs to NEWVAL."
  (aset (cdr privs) 9 newval))

(defsubst set-privs->flg11 (privs newval)
  "Set flg11 in privs to NEWVAL."
  (aset (cdr privs) 10 newval))

(defsubst set-privs->flg12 (privs newval)
  "Set flg12 in privs to NEWVAL."
  (aset (cdr privs) 11 newval))

(defsubst set-privs->flg13 (privs newval)
  "Set flg13 in privs to NEWVAL."
  (aset (cdr privs) 12 newval))

(defsubst set-privs->flg14 (privs newval)
  "Set flg14 in privs to NEWVAL."
  (aset (cdr privs) 13 newval))

(defsubst set-privs->flg15 (privs newval)
  "Set flg15 in privs to NEWVAL."
  (aset (cdr privs) 14 newval))

(defsubst set-privs->flg16 (privs newval)
  "Set flg16 in privs to NEWVAL."
  (aset (cdr privs) 15 newval))


;;; Predicate:

(defsubst lyskom-privs-p (object)
  "Return t if OBJECT is a privs."
  (eq (car-safe object) 'PRIVS))


;;; ================================================================
;;;                            flags



(def-komtype session-flags
  invisible user_active_used user_absent
  reserved3 reserved4 reserved5 reserved6 reserved7)

(def-komtype dynamic-session-info
  session person working-conference idle-time flags what-am-i-doing)

(def-komtype static-session-info
  username hostname ident-user connection-time)

;;; ================================================================
;;;                            flags


;;; Constructor:

(defsubst lyskom-create-flags (unread_is_secret
			       flg2
			       flg3
			       flg4
			       flg5
			       flg6
			       flg7
			       flg8)
  "Create a flags from all parameters."
  (cons
   'FLAGS
   (vector unread_is_secret flg2 flg3 flg4 flg5 flg6 flg7 flg8)))


;;; Selectors:

(defsubst flags->unread_is_secret (flags)
  "Get unread_is_secret from flags."
  (elt (cdr flags) 0))

(defsubst flags->flg2 (flags)
  "Get flg2 from flags."
  (elt (cdr flags) 1))

(defsubst flags->flg3 (flags)
  "Get flg3 from flags."
  (elt (cdr flags) 2))

(defsubst flags->flg4 (flags)
  "Get flg4 from flags."
  (elt (cdr flags) 3))

(defsubst flags->flg5 (flags)
  "Get flg5 from flags."
  (elt (cdr flags) 4))

(defsubst flags->flg6 (flags)
  "Get flg6 from flags."
  (elt (cdr flags) 5))

(defsubst flags->flg7 (flags)
  "Get flg7 from flags."
  (elt (cdr flags) 6))

(defsubst flags->flg8 (flags)
  "Get flg8 from flags."
  (elt (cdr flags) 7))


;;; Modifiers:

(defsubst set-flags->unread_is_secret (flags newval)
  "Set unread_is_secret in flags to NEWVAL."
  (aset (cdr flags) 0 newval))

(defsubst set-flags->flg2 (flags newval)
  "Set flg2 in flags to NEWVAL."
  (aset (cdr flags) 1 newval))

(defsubst set-flags->flg3 (flags newval)
  "Set flg3 in flags to NEWVAL."
  (aset (cdr flags) 2 newval))

(defsubst set-flags->flg4 (flags newval)
  "Set flg4 in flags to NEWVAL."
  (aset (cdr flags) 3 newval))

(defsubst set-flags->flg5 (flags newval)
  "Set flg5 in flags to NEWVAL."
  (aset (cdr flags) 4 newval))

(defsubst set-flags->flg6 (flags newval)
  "Set flg6 in flags to NEWVAL."
  (aset (cdr flags) 5 newval))

(defsubst set-flags->flg7 (flags newval)
  "Set flg7 in flags to NEWVAL."
  (aset (cdr flags) 6 newval))

(defsubst set-flags->flg8 (flags newval)
  "Set flg8 in flags to NEWVAL."
  (aset (cdr flags) 7 newval))



;;; Predicate:

(defsubst lyskom-flags-p (object)
  "Return t if OBJECT is a flags."
  (eq (car-safe object) 'FLAGS))


;;; ================================================================
;;;                             membership


;;; Constructor:

(def-komtype member-list members)

(def-komtype member pers-no created-by created-at membership-type)

(def-komtype membership-type invitation passive secret rsv1 
  rsv2 rsv3 rsv4 rsv5)

(defsubst lyskom-create-membership ( position
                                     last-time-read
                                     conf-no
                                     priority
                                     last-text-read
                                     read-texts
                                     created-by
                                     created-at
                                     type
                                     )
  "Create a membership from all parameters."
  (cons
   'MEMBERSHIP
   (vector last-time-read conf-no priority last-text-read read-texts 
           created-by created-at type position
	   )))


;;; Selectors:

(defsubst membership->last-time-read (membership)
  "Get last-time-read from membership."
  (elt (cdr membership) 0))

(defsubst membership->conf-no (membership)
  "Get conf-no from membership."
  (elt (cdr membership) 1))

(defsubst membership->priority (membership)
  "Get priority from membership."
  (elt (cdr membership) 2))

(defsubst membership->last-text-read (membership)
  "Get last-text-read from membership."
  (elt (cdr membership) 3))

(defsubst membership->read-texts (membership)
  "Get read-texts from membership."
  (elt (cdr membership) 4))

(defsubst membership->created-by (membership)
  "Get created-by from membership"
  (elt (cdr membership) 5))

(defsubst membership->created-at (membership)
  "Get created-by from membership"
  (elt (cdr membership) 6))

(defsubst membership->type (membership)
  "Get type from membership"
  (elt (cdr membership) 7))

(defsubst membership->position (membership)
  "Get position from membership, if known"
  (elt (cdr membership) 8))



;;; Modifiers:

(defsubst set-membership->last-time-read (membership newval)
  "Set last-time-read in membership to NEWVAL."
  (aset (cdr membership) 0 newval))

(defsubst set-membership->conf-no (membership newval)
  "Set conf-no in membership to NEWVAL."
  (aset (cdr membership) 1 newval))

(defsubst set-membership->priority (membership newval)
  "Set priority in membership to NEWVAL."
  (aset (cdr membership) 2 newval))

(defsubst set-membership->last-text-read (membership newval)
  "Set last-text-read in membership to NEWVAL."
  (aset (cdr membership) 3 newval))

(defsubst set-membership->read-texts (membership newval)
  "Set read-texts in membership to NEWVAL."
  (aset (cdr membership) 4 newval))

(defsubst set-membership->created-by (membership newval)
  "Set created-by in membership to NEWVAL."
  (aset (cdr membership) 5 newval))

(defsubst set-membership->created-at (membership newval)
  "Set type in membership to NEWVAL."
  (aset (cdr membership) 6 newval))

(defsubst set-membership->type (membership newval)
  "Set type in membership to NEWVAL."
  (aset (cdr membership) 7 newval))

(defsubst set-membership->position (membership newval)
  "Set position in membership to NEWVAL."
  (aset (cdr membership) 8 newval))


;;; Predicate:

(defsubst lyskom-membership-p (object)
  "Return t if OBJECT is a membership."
  (eq (car-safe object) 'MEMBERSHIP))

;;; Special stuff

(defun lyskom-member-list-find-member (person members)
  (when members
    (lyskom-traverse member (member-list->members members)
      (when (eq person (member->pers-no member))
        (lyskom-traverse-break member)))))



;;; ================================================================
;;;                               map


;;; Constructor:

(defsubst lyskom-create-map (first-local text-nos)
  "Create a map from all parameters."
  (cons
   'MAP
   (vector first-local text-nos )))


;;; Selectors:

(defsubst map->first-local (map)
  "Get first-local from map."
  (elt (cdr map) 0))

(defsubst map->text-nos (map)
  "Get text-nos from map."
  (elt (cdr map) 1))


;;; Modifiers:

(defsubst set-map->first-local (map newval)
  "Set first-local in map to NEWVAL."
  (aset (cdr map) 0 newval))

(defsubst set-map->text-nos (map newval)
  "Set text-nos in map to NEWVAL."
  (aset (cdr map) 1 newval))


;;; Predicate:

(defsubst lyskom-map-p (object)
  "Return t if OBJECT is a map."
  (eq (car-safe object) 'MAP))

			  
;;; Concat:

(defsubst lyskom-map-concat (&rest maps)
  "Take any number of MAPS and return a new map which is the sum of the maps.
Args: &rest MAPS.
The MAPS must be consecutive. No gaps or overlaps are currently allowed."
  (if (null maps)
      (lyskom-create-map 1 [])
    (let* ((first (map->first-local (car maps)))
	   (high (+ first (length (map->text-nos (car maps)))))
	   (maplist (list (map->text-nos (car maps))))
	   (maps (cdr maps)))
      (while maps
	(if (/= (map->first-local (car maps))
		high)
	    (signal 'lyskom-internal-error '("lyskom-map-concat")))
	(setq maplist (nconc maplist (list (map->text-nos (car maps)))))
	(setq high (+ high (length (map->text-nos (car maps)))))
	(setq maps (cdr maps)))
      (lyskom-create-map first (apply 'vconcat maplist)))))


;;; ================================================================
;;; Text-Mapping support

(def-komtype text-mapping
  range-begin
  range-end
  size
  later-texts-exist
  type
  block)

(defsubst lyskom-create-text-pair (local global) (cons local global))
(defsubst text-pair->local-number (pair) (car pair))
(defsubst text-pair->global-number (pair) (cdr pair))

(defun text-mapping->local-to-global (map local)
  (cond ((or (< local (text-mapping->range-begin map))
             (> local (text-mapping->range-end map))) nil)
        ((eq (text-mapping->type map) 'sparse)
         (cdr (assq local (text-mapping->block map))))

        ((eq (text-mapping->type map) 'dense)
         (let ((result (aref (text-mapping->block map)
                             (- local (text-mapping->range-begin map)))))
           (and (not (zerop result)) result)))))

(defun text-mapping->global-numbers (map)
  (cond ((eq (text-mapping->type map) 'sparse)
         (mapcar 'cdr (text-mapping->block map)))
        ((eq (text-mapping->type map) 'dense)
         (let ((result nil))
           (lyskom-traverse el (map->text-nos (text-mapping->block map))
             (unless (zerop el) (setq result (cons el result))))
           (nreverse result)))))

(defun text-mapping->global-to-local (map global)
  (cond ((eq (text-mapping->type map) 'sparse)
         (cdr (rassq global (text-mapping->block map))))
        ((eq (text-mapping->type map) 'dense)
         (let ((i (text-mapping->range-begin map))
               (result nil))
           (while (< i (text-mapping->range-end map))
             (if (eq (aref (map->text-nos (text-mapping->block map)) 
                           (- i (text-mapping->range-begin map)))
                     global)
                 (setq result i i (text-mapping->range-end map))
               (setq i (1+ i))))
           result))))

;;; ================================================================
;;;                            mark


;;; Constructor:

(defsubst lyskom-create-mark (text-no
			   mark-type)
  "Create a mark from all parameters."
  (cons
   'MARK
   (vector text-no mark-type )))


;;; Selectors:

(defsubst mark->text-no (mark)
  "Get text-no from mark."
  (elt (cdr mark) 0))

(defsubst mark->mark-type (mark)
  "Get mark-type from mark."
  (elt (cdr mark) 1))


;;; Modifiers:

(defsubst set-mark->text-no (mark newval)
  "Set text-no in mark to NEWVAL."
  (aset (cdr mark) 0 newval))

(defsubst set-mark->mark-type (mark newval)
  "Set mark-type in mark to NEWVAL."
  (aset (cdr mark) 1 newval))


;;; Predicate:

(defsubst lyskom-mark-p (object)
  "Return t if OBJECT is a mark."
  (eq (car-safe object) 'MARK))

;;; Utilities

(defun mark->symbolic-mark-type (mark)
  (lyskom-symbolic-mark-type-string (mark->mark-type mark)))

;;; ================================================================
;;;                           who-info


;;; Constructor:

(defsubst lyskom-create-who-info (pers-no
			       working-conf
			       connection
			       doing-what
			       username
                               &optional hostname ident-user)
  "Create a who-info from all parameters."
  (cons
   'WHO-INFO
   (vector pers-no working-conf connection doing-what 
           username hostname ident-user
	   )))


;;; Selectors:

(defsubst who-info->pers-no (who-info)
  "Get pers-no from who-info."
  (elt (cdr who-info) 0))

(defsubst who-info->working-conf (who-info)
  "Get working-conf from who-info."
  (elt (cdr who-info) 1))

(defsubst who-info->connection (who-info)
  "Get connection from who-info."
  (elt (cdr who-info) 2))

(defsubst who-info->doing-what (who-info)
  "Get doing-what from who-info."
  (elt (cdr who-info) 3))

(defsubst who-info->username (who-info)
  "Get username from who-info."
  (elt (cdr who-info) 4))

(defsubst who-info->hostname (who-info)
  "Get hostname from who-info."
  (elt (cdr who-info) 5))

(defsubst who-info->ident-user (who-info)
  "Get ident-user from who-info."
  (elt (cdr who-info) 6))


;;; Modifiers:

(defsubst set-who-info->pers-no (who-info newval)
  "Set pers-no in who-info to NEWVAL."
  (aset (cdr who-info) 0 newval))

(defsubst set-who-info->working-conf (who-info newval)
  "Set working-conf in who-info to NEWVAL."
  (aset (cdr who-info) 1 newval))

(defsubst set-who-info->connection (who-info newval)
  "Set connection in who-info to NEWVAL."
  (aset (cdr who-info) 2 newval))

(defsubst set-who-info->doing-what (who-info newval)
  "Set doing-what in who-info to NEWVAL."
  (aset (cdr who-info) 3 newval))

(defsubst set-who-info->username (who-info newval)
  "Set username in who-info to NEWVAL."
  (aset (cdr who-info) 4 newval))

(defsubst set-who-info->hostname (who-info newval)
  "Set hostname in who-info to NEWVAL."
  (aset (cdr who-info) 5 newval))

(defsubst set-who-info->ident-user (who-info newval)
  "Set ident-user in who-info to NEWVAL."
  (aset (cdr who-info) 6 newval))


;;; Predicate:

(defsubst lyskom-who-info-p (object)
  "Return t if OBJECT is a who-info."
  (eq (car-safe object) 'WHO-INFO))

		       
;;; ================================================================
;;;                         session-info


;;; Constructor:

(defsubst lyskom-create-session-info (pers-no
				   working-conf
				   connection
				   doing
				   username
                                   hostname
                                   ident-user
				   idletime
				   connect-time)
  "Create a session-info from all parameters."
  (cons
   'SESSION-INFO
   (vector pers-no working-conf connection doing username idletime 
	   connect-time hostname ident-user)))


;;; Selectors:

(defsubst session-info->pers-no (session-info)
  "Get pers-no from session-info."
  (elt (cdr session-info) 0))

(defsubst session-info->working-conf (session-info)
  "Get working-conf from session-info."
  (elt (cdr session-info) 1))

(defsubst session-info->connection (session-info)
  "Get connection from session-info."
  (elt (cdr session-info) 2))

(defsubst session-info->doing (session-info)
  "Get doing from session-info."
  (elt (cdr session-info) 3))

(defsubst session-info->username (session-info)
  "Get username from session-info."
  (elt (cdr session-info) 4))

(defsubst session-info->idletime (session-info)
  "Get idletime from session-info."
  (elt (cdr session-info) 5))

(defsubst session-info->connect-time (session-info)
  "Get connect-time from session-info."
  (elt (cdr session-info) 6))

(defsubst session-info->hostname (session-info)
  "Get hostname from session-info."
  (elt (cdr session-info) 7))

(defsubst session-info->ident-user (session-info)
  "Get connect-time from session-info."
  (elt (cdr session-info) 8))


;;; Modifiers:

(defsubst set-session-info->pers-no (session-info newval)
  "Set pers-no in session-info to NEWVAL."
  (aset (cdr session-info) 0 newval))

(defsubst set-session-info->working-conf (session-info newval)
  "Set working-conf in session-info to NEWVAL."
  (aset (cdr session-info) 1 newval))

(defsubst set-session-info->connection (session-info newval)
  "Set connection in session-info to NEWVAL."
  (aset (cdr session-info) 2 newval))

(defsubst set-session-info->doing (session-info newval)
  "Set doing in session-info to NEWVAL."
  (aset (cdr session-info) 3 newval))

(defsubst set-session-info->username (session-info newval)
  "Set username in session-info to NEWVAL."
  (aset (cdr session-info) 4 newval))

(defsubst set-session-info->idletime (session-info newval)
  "Set idletime in session-info to NEWVAL."
  (aset (cdr session-info) 5 newval))

(defsubst set-session-info->connect-time (session-info newval)
  "Set connect-time in session-info to NEWVAL."
  (aset (cdr session-info) 6 newval))

(defsubst set-session-info->hostname (session-info newval)
  "Set hostname in session-info to NEWVAL."
  (aset (cdr session-info) 7 newval))

(defsubst set-session-info->ident-user (session-info newval)
  "Set ident-user in session-info to NEWVAL."
  (aset (cdr session-info) 8 newval))



;;; Predicate:

(defsubst lyskom-session-info-p (object)
  "Return t if OBJECT is a session-info."
  (eq (car-safe object) 'SESSION-INFO))


				   
;;; ================================================================
;;;                          conf-type.


;;; Constructor:

(defsubst lyskom-create-conf-type (rd_prot original secret letterbox 
                                           &optional anarchy
                                           forbid-secret rsv2 rsv3)
  "Create a conf-type object. Args: RD_PROT ORIGINAL SECRET LETTERBOX."
  (list 'CONF-TYPE 
	rd_prot 
	original 
	secret 
	letterbox
        anarchy
        forbid-secret
        rsv2
        rsv3
	))


;;;Selectors:

(defsubst conf-type->rd_prot (conf-type)
  "Get rd_prot from conf-type."
  (elt (cdr conf-type) 0))

(defsubst conf-type->original (conf-type)
  "Get original from conf-type."
  (elt (cdr conf-type) 1))

(defsubst conf-type->secret (conf-type)
  "Get secret from conf-type."
  (elt (cdr conf-type) 2))

(defsubst conf-type->letterbox (conf-type)
  "Get letterbox from conf-type."
  (elt (cdr conf-type) 3))

(defsubst conf-type->anarchy (conf-type)
  "Get anarchy from conf-type."
  (elt (cdr conf-type) 4))

(defsubst conf-type->forbid-secret (conf-type)
  "Get reserved bit from conf-type."
  (elt (cdr conf-type) 5))

(defsubst conf-type->rsv2 (conf-type)
  "Get reserved bit from conf-type."
  (elt (cdr conf-type) 5))

(defsubst conf-type->rsv3 (conf-type)
  "Get reserved bit from conf-type."
  (elt (cdr conf-type) 5))


;;; ================================================================
;;;                            text-list


;;; Constructor:

(defsubst lyskom-create-text-list (texts)
  "Create a text-list from all parameters."
  (cons 'TEXT-LIST texts))


;;; Selector:

(defsubst text-list->texts (text-list)
  "Get texts from text-list."
  (cdr text-list))

(defsubst text-list->empty (text-list)
  "Return t if TEXT-LIST is empty."
  (null (cdr text-list)))

(defsubst text-list->length (text-list)
  "Return the length of TEXT-LIST."
  (length (cdr text-list)))


;;; Modifier:

(defsubst set-text-list->texts (text-list newval)
  "Set texts in TEXT-LIST to NEWVAL."
  (setcdr text-list newval))

(defsubst text-list->delq (text-list no)
  "Remove text NO from TEXT-LIST."
  (setcdr text-list (delq no (cdr text-list))))

(defsubst text-list->append (text-list texts)
  "Destructively append TEXTS to the end of TEXT-LIST."
  (setcdr text-list (nconc (cdr text-list) texts)))

;;; Predicate:

(defsubst lyskom-text-list-p (object)
  "Return t if OBJECT is a text-list."
  (eq (car-safe object) 'TEXT-LIST))


;;; ================================================================
;;;                         version-info


;;; Constructor:

(defsubst lyskom-create-version-info (protocol-version
                                      server-software
                                      software-version)
  "Create a version-info from all parameters."
  (cons 'VERSION-INFO
        (vector protocol-version server-software software-version)))

;;; Selectors:

(defsubst version-info->protocol-version (version-info)
  "Get protocol version from version-info."
  (elt (cdr version-info) 0))

(defsubst version-info->server-software (version-info)
  "Get server software name from version-info."
  (elt (cdr version-info) 1))

(defsubst version-info->software-version (version-info)
  "Get server software version from version-info."
  (elt (cdr version-info) 2))

				   
;;; ================================================================
;;;                          server-info


;;; Constructor:

(defsubst lyskom-create-server-info (version
				  conf-pres-conf
				  pers-pres-conf
				  motd-conf
				  kom-news-conf
				  motd-of-lyskom
                                  &optional aux-items)
  "Create a server-info from all parameters."
  (cons
   'SERVER-INFO
   (vector version conf-pres-conf pers-pres-conf motd-conf kom-news-conf 
	   motd-of-lyskom aux-items )))


;;; Selectors:

(defsubst server-info->version (server-info)
  "Get version from server-info."
  (elt (cdr server-info) 0))

(defsubst server-info->conf-pres-conf (server-info)
  "Get conf-pres-conf from server-info."
  (elt (cdr server-info) 1))

(defsubst server-info->pers-pres-conf (server-info)
  "Get pers-pres-conf from server-info."
  (elt (cdr server-info) 2))

(defsubst server-info->motd-conf (server-info)
  "Get motd-conf from server-info."
  (elt (cdr server-info) 3))

(defsubst server-info->kom-news-conf (server-info)
  "Get kom-news-conf from server-info."
  (elt (cdr server-info) 4))

(defsubst server-info->motd-of-lyskom (server-info)
  "Get motd-of-lyskom from server-info."
  (elt (cdr server-info) 5))

(defsubst server-info->aux-item-list (server-info)
  "Get motd-of-lyskom from server-info."
  (elt (cdr server-info) 6))


;;; Modifiers:

(defsubst set-server-info->version (server-info newval)
  "Set version in server-info to NEWVAL."
  (aset (cdr server-info) 0 newval))

(defsubst set-server-info->conf-pres-conf (server-info newval)
  "Set conf-pres-conf in server-info to NEWVAL."
  (aset (cdr server-info) 1 newval))

(defsubst set-server-info->pers-pres-conf (server-info newval)
  "Set pers-pres-conf in server-info to NEWVAL."
  (aset (cdr server-info) 2 newval))

(defsubst set-server-info->motd-conf (server-info newval)
  "Set motd-conf in server-info to NEWVAL."
  (aset (cdr server-info) 3 newval))

(defsubst set-server-info->kom-news-conf (server-info newval)
  "Set kom-news-conf in server-info to NEWVAL."
  (aset (cdr server-info) 4 newval))

(defsubst set-server-info->motd-of-lyskom (server-info newval)
  "Set motd-of-lyskom in server-info to NEWVAL."
  (aset (cdr server-info) 5 newval))

(defsubst set-server-info->aux-item-list (server-info newval)
  "Set motd-of-lyskom in server-info to NEWVAL."
  (aset (cdr server-info) 6 newval))


;;; Predicate:

(defsubst lyskom-server-info-p (object)
  "Return t if OBJECT is a server-info."
  (eq (car-safe object) 'SERVER-INFO))


;;; ================================================================
;;;                            conf-z-info-list


;;; Constructor:

(defun lyskom-create-conf-z-info-list (conf-z-infos)
  "Create a conf-z-info-list from all parameters."
  (cons
   'CONF-Z-INFO-LIST
   (vector conf-z-infos)))


;;; Selector:

(defun conf-z-info-list->conf-z-infos (conf-z-info-list)
  "Get conf-z-infos from conf-z-info-list."
  (elt (cdr conf-z-info-list) 0))


;;; Modifier:

(defun set-conf-z-info-list->conf-z-infos (conf-z-info-list newval)
  "Set conf-z-infos in conf-z-info-list to NEWVAL."
  (aset (cdr conf-z-info-list) 0 newval))


;;; Predicate:

(defun lyskom-conf-z-info-list-p (object)
  "Return t if OBJECT is a conf-z-info-list."
  (eq (car-safe object) 'CONF-Z-INFO-LIST))

;;; ================================================================
;;;                            conf-z-info

;;; Constructor:

(defun lyskom-create-conf-z-info (name
				  conf-type
				  conf-no)
  "Create a conf-z-info from all parameters."
  (cons
   'CONF-Z-INFO
   (vector name conf-type conf-no)))


;;; Selectors:

(defun conf-z-info->name (conf-z-info)
  "Get name from conf-z-info."
  (elt (cdr conf-z-info) 0))

(defun conf-z-info->conf-type (conf-z-info)
  "Get conf-type from conf-z-info."
  (elt (cdr conf-z-info) 1))

(defun conf-z-info->conf-no (conf-z-info)
  "Get conf-no from conf-z-info."
  (elt (cdr conf-z-info) 2))


;;; Modifiers:

(defun set-conf-z-info->name (conf-z-info newval)
  "Set name in conf-z-info to NEWVAL."
  (aset (cdr conf-z-info) 0 newval))

(defun set-conf-z-info->conf-type (conf-z-info newval)
  "Set conf-type in conf-z-info to NEWVAL."
  (aset (cdr conf-z-info) 1 newval))

(defun set-conf-z-info->conf-no (conf-z-info newval)
  "Set conf-no in conf-z-info to NEWVAL."
  (aset (cdr conf-z-info) 2 newval))


;;; Predicate:

(defun lyskom-conf-z-info-p (object)
  "Return t if OBJECT is a conf-z-info."
  (eq (car-safe object) 'CONF-Z-INFO))


;;;; ================================================================
;;;; This field is just simulation of a field in the conf-stat
;;;; that not yet exist.

(defsubst conf-stat->comm-conf (conf-stat)
  (if (and (conf-type->original (conf-stat->conf-type conf-stat))
	   (not (zerop (conf-stat->super-conf conf-stat))))
      (conf-stat->super-conf conf-stat)
    (conf-stat->conf-no conf-stat)))


;;; ================================================================



;;; Utilities

(defun text-stat-find-aux (text-stat tag &optional person)
  "Return a list containing the aux items in TEXT-STAT with tag TAG.
If PERSON is non-nil return only those items created by person.
Args: TEXT-STAT TAG PERSON"
  (let ((result nil)
        (items (text-stat->aux-items text-stat)))
    (while items
      (when (and (eq tag (aux-item->tag (car items)))
                 (not (aux-item-flags->deleted
                       (aux-item->flags (car items))))
                 (or (null person)
                     (eq person (aux-item->creator (car items)))))
        (setq result (cons (car items) result)))
      (setq items (cdr items)))
    (nreverse result)))

(defun conf-stat-find-aux (conf-stat tag &optional person)
  "Return a list containing the aux items in CONF-STAT with tag TAG.
If PERSON is non-nil return only those items created by person.
Args: CONF-STAT TAG PERSON"
  (let ((result nil)
        (items (conf-stat->aux-items conf-stat)))
    (while items
      (when (and (eq tag (aux-item->tag (car items)))
                 (not (aux-item-flags->deleted
                       (aux-item->flags (car items))))
                 (or (null person)
                     (eq person (aux-item->creator (car items)))))
        (setq result (cons (car items) result)))
      (setq items (cdr items)))
    (nreverse result)))

(defun lyskom-is-recipient (text-stat conf-no)
  "Return non-nil if TEXT-STAT has CONF-NO as a recipient."
  (let ((result nil))
    (lyskom-traverse misc
        (text-stat->misc-info-list text-stat)
      (when (and (memq (misc-info->type misc) lyskom-recpt-types-list)
                 (eq (misc-info->recipient-no misc) conf-no))
        (setq result t)))
    result))



(provide 'lyskom-types)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: clienttypes.el,v 44.17 2002/05/25 18:22:39 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: clienttypes.el
;;;;
;;;; This file contains primitives for the different data types
;;;; in the lyskom elisp client. The types in here are only used
;;;; within this lyskom client.
;;;;
;;;; Authors: Linus Tolke and Inge Wallin
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: clienttypes.el,v 44.17 2002/05/25 18:22:39 byers Exp $\n"))


;;; ================================================================
;;;                            read-info

;;; A read-info is used by to tell the client which text to 
;;; show next and in which order to step through the conferences 
;;; with unread texts. New read-infos are created and deleted
;;; all the time within a session.
;;;
;;; The type is one of the following:
;;;   REVIEW      - Default review type, created by the kom-review-by-to
;;;		    and the kom-review-comments
;;;   REVIEW-TREE - List of texts created by one of the tree-reading 
;;;		    commands: kom-find-root-review, kom-review-tree
;;;   REVIEW-MARK - List of texts created by the review-mark command
;;;   REVIEW-FAQ  - List of texts created by kom-review-faq or similar
;;;   COMM-IN     - Type containing the list of comments to a text
;;;   FOOTN-IN    - Type containing the list of footnotes to a text
;;;   CONF        - Basic type of unread in a conf.
;;;   RE-EDIT-TEXT - Re-edit a failed submission. Buffer is in misc.
;;;   PRI-SESSION - Go to prioritized session.
;;;
;;;   The types REVIEW-TREE, COMM-IN and FOOTN-IN are created for new for
;;;   every text read (recursively) when appropriate.
;;;
;;;   The difference between REVIEW, REVIEW-MARK and REVIEW-FAQ is just
;;;   that there generate different prompts and different text from
;;;   kom-review-stack.
;;;


;;; read-info

(defsubst lyskom-create-read-info (type
				conf-stat
				priority
				text-list
				&optional comm-to forward misc)
  "Create a read-info from all parameters."
  ;; The last nil is for the unfetched-texts pair (first . last)
  ;; This field is only applicable in read-infos of type CONF where
  ;; it shows which part of the map for this conference that has not
  ;; yet been fetched.
  (cons
   'READ-INFO
   (vector type conf-stat priority text-list comm-to forward nil misc)))

(defsubst read-info->type (read-info)
  "Get type from read-info."
  (elt (cdr read-info) 0))

(defsubst read-info->conf-stat (read-info)
  "Get conf-stat from read-info."
  (elt (cdr read-info) 1))

(defsubst read-info->priority (read-info)
  "Get priority from read-info."
  (elt (cdr read-info) 2))

(defsubst read-info->text-list (read-info)
  "Get text-list from read-info."
  (elt (cdr read-info) 3))

(defsubst read-info->comm-to (read-info)
  "Get comm-to from read-info."
  (elt (cdr read-info) 4))

(defsubst read-info->forward (read-info)
  "Get forward from read-info."
  (elt (cdr read-info) 5))

(defsubst read-info->unfetched-texts (read-info)
  "Get forward from read-info."
  (elt (cdr read-info) 6))

(defsubst read-info->misc (read-info)
  "Get forward from read-info."
  (elt (cdr read-info) 7))

(defsubst set-read-info->type (read-info newval)
  "Set type in read-info to NEWVAL."
  (aset (cdr read-info) 0 newval))

(defsubst set-read-info->conf-stat (read-info newval)
  "Set conf-stat in read-info to NEWVAL."
  (aset (cdr read-info) 1 newval))

(defsubst set-read-info->priority (read-info newval)
  "Set priority in read-info to NEWVAL."
  (aset (cdr read-info) 2 newval))

(defsubst set-read-info->text-list (read-info newval)
  "Set text-list in read-info to NEWVAL."
  (aset (cdr read-info) 3 newval))

(defsubst set-read-info->comm-to (read-info newval)
  "Set comm-to in read-info to NEWVAL."
  (aset (cdr read-info) 4 newval))

(defsubst set-read-info->forward (read-info newval)
  "Set forward in read-info to NEWVAL."
  (aset (cdr read-info) 5 newval))

(defsubst set-read-info->unfetched-texts (read-info newval)
  "Set forward in read-info to NEWVAL."
  (aset (cdr read-info) 6 newval))

(defsubst set-read-info->misc (read-info newval)
  "Set forward in read-info to NEWVAL."
  (aset (cdr read-info) 7 newval))


(defsubst lyskom-read-info-p (object)
  "Return t if OBJECT is a read-info."
  (eq (car-safe object) 'READ-INFO))


(defsubst read-info-append-text-list (read-info texts)
  (text-list->append (read-info->text-list read-info) texts))

(defsubst read-info-enter-text-last (read-info text-no)
  (read-info-append-text-list read-info (list text-no)))

				   
;;; ================================================================
;;;                          read-list


;;; Constructor:

(defsubst lyskom-create-read-list ()
  "Create an empty read-list."
  (cons 'READ-LIST nil))


;;; Predicates:

(defsubst read-list-isempty (read-list)
  "Return t if READ-LIST is empty, otherwise return nil."
  (null (cdr read-list)))


;;; Selectors:

(defsubst read-list->first (read-list)
  "Return the first entry in READ-LIST, or nil if empty."
  (car-safe (cdr read-list)))


(defsubst read-list->nth (read-list n)
  "Args: READ-LIST N
Return element N in READ-LIST or nil if outside the range.
The range of valid values for N is [0, num-entries - 1]."
  (elt (cdr read-list) n))


(defsubst read-list->all-entries (read-list)
  "Return a list of all entries in READ-LIST."
  (cdr read-list))


;;; Other functions:

(defsubst read-list-length (read-list)
  "Return the number of entries in READ-LIST."
  (1- (length read-list)))


;;; Modifiers:

(defsubst set-read-list-empty (read-list)
  "Empty READ-LIST destructively."
  (setcdr read-list nil))


(defsubst set-read-list-del-first (read-list)
  "Delete the first entry of READ-LIST if there is one."
  (if (cdr read-list)
      (setcdr read-list (cdr (cdr read-list)))))


(defsubst read-list-enter-first (read-info read-list)
  "Enter READ-INFO first into READ-LIST."
  (setcdr read-list (cons read-info (cdr read-list))))


(defun read-list-enter-text (text-no recipient rlist)
  "Args: TEXT-NO RECIPIENT RLIST.
Add the new text TEXT-NO to any RECIPIENT found in RLIST.
RECIPIENT is a conf-stat.
Returns t if there was a conference to insert this text into."
  (let ((inserted nil))
    (lyskom-traverse
     read-info (cdr rlist)
     (cond
      ((and (eq 'CONF (read-info->type read-info))
	    (= (conf-stat->conf-no recipient)
	       (conf-stat->conf-no (read-info->conf-stat read-info))))
       (read-info-enter-text-last read-info text-no)
       (setq inserted t))))
    inserted))


(defun read-list-delete-text (text-no rlist)
  "Destructively delete all occurances of TEXT-NO from RLIST.
RLIST is a list of read-info.
Entries of the type REVIEW, REVIEW-FAQ, REVIEW-TREE or REVIEW-MARK are
not changed except if they were empty in which case they are removed.
Returns the modified RLIST.
TEXT-NO may be nil, in which case only empty read-infos on RLIST are removed."
  (let* ((prev rlist)			;"Previous" cons-celll
	 (curr (cdr rlist)))		;Current cons-cell
    (while curr
      (if text-no
	  (cond
	   ((let ((type (read-info->type (car curr)))) 
					; Don't change REVIEW et c.
	      (memq type lyskom-review-types-list)))
	   (t				; Do change all other entries.
	    (let ((tl  (read-info->text-list (car curr))))
	      (text-list->delq tl text-no)))))
      
      ;; Delete this element from RLIST if the text-list became or was empty.
      
      (if (text-list->empty (read-info->text-list (car curr)))
	  (setcdr prev (cdr curr))
	(setq prev curr))
      (setq curr (cdr curr))))
  rlist)


(defun read-list-enter-read-info (read-info rlist &optional before)
  "Destructively insert READ-INFO in RLIST, sorted by priority.
RLIST is a list of read-info.
Args: READ-INFO RLIST &optional BEFORE.
A new item with the same priority as an item that is alreay on the list
will nomally be inserted after the old one, but if BEFORE is non-nil it
will be inserted before it."
  (let ((pri (+ (if before 0 -1)
		(read-info->priority read-info)))
	(continue t)
	(conf-stat (read-info->conf-stat read-info))
	(type (read-info->type read-info)))
    (while continue
      (cond
       ;; This case was added by davidk 960925. It is not used from
       ;; everywhere, but at least lyskom-enter-map-in-to-do-list
       ;; should become more efficient.
       ((and (eq type 'CONF)
	     (eq (read-info->type (car (cdr rlist))) 'CONF)
	     (eq conf-stat (read-info->conf-stat (car (cdr rlist)))))
	(read-info-append-text-list
	 (car (cdr rlist))
	 (text-list->texts (read-info->text-list read-info)))
	(setq continue nil)) 
       
       ((null (cdr rlist)) 
	(setcdr rlist (list read-info))
	(setq continue nil))
       ((>= pri (read-info->priority (car (cdr rlist))))
	(setcdr rlist (cons read-info (cdr rlist)))
	(setq continue nil))
       (t 
	(setq rlist (cdr rlist)))))))

(defun read-list-delete-read-info (conf-no rlist)
  "Destructively removes all the entries for the conf CONF-NO in RLIST.
RLIST is a list of read-info."
  (while (cdr rlist)
    (if (eq (conf-stat->conf-no (read-info->conf-stat
				      (car (cdr rlist))))
	    conf-no)
	(setcdr rlist (cdr (cdr rlist)))
      (setq rlist (cdr rlist)))))
 
	  
(defun read-list-rotate (read-list)
  "Put the first element of READ-LIST last in the same list. The second
element will be the new first element."
  (if (> (length read-list) 2)
      (let ((first (cdr read-list))
	    (last  (cdr read-list)))
	(while (cdr last)
	  (setq last (cdr last)))
	(setcdr last first)
	(setcdr read-list (cdr first))
	(setcdr first nil)))
  read-list)    
	  

;;; ================================================================
;;;                      A simple queue

;;;
;;; This is a simple implementation of a queue.  The only thing you
;;; can do with it is stuff things at the back of it and remove
;;; things from the front of it.  (...and of course do a few tests)
;;;

;;; Author: Inge Wallin


(defun lyskom-queue-create ()
  "Create an empty queue."
  (cons 'QUEUE (cons nil nil)))


(defsubst lyskom-queue-enter (queue element)
  "Enter last into the queue QUEUE the ELEMENT."
  (let ((elementcell (cons element nil)))
    (if (null (car (cdr queue)))
	; QUEUE is empty
	(setcar (cdr queue)
		(setcdr (cdr queue) 
			elementcell))
      (setcdr (cdr (cdr queue))
	      elementcell)
      (setcdr (cdr queue)
	      elementcell))))


(defsubst lyskom-queue-p (queue)
  "Return t if QUEUE is a queue, otherwise return nil."
  (eq (car-safe queue) 'QUEUE))


(defsubst lyskom-queue-isempty (queue)
  "Return t if QUEUE is empty, otherwise return nil."
  (null (car (cdr queue))))


(defsubst lyskom-queue->first (queue)
  "Return the first element of QUEUE or nil if it is empty."
  (car-safe (car (cdr queue))))


(defsubst lyskom-queue->all-entries (queue)
  "Return all elements of QUEUE (nil if it is empty)."
  (car-safe (cdr queue)))


(defsubst lyskom-queue->last (queue)
  "Return the lastelement of QUEUE or nil if it is empty."
  (car-safe (cdr (cdr queue))))


(defsubst lyskom-queue-make-empty (queue)
  "Make the queue QUEUE empty."
  (setcdr queue (cons nil nil)))

(defsubst lyskom-queue-set-data (queue data)
  (lyskom-queue-make-empty queue)
  (setcdr queue (cons data (last data))))


(defsubst lyskom-queue-delete-first (queue)
  "Delete the first element of QUEUE and return it. If QUEUE is empty
return nil and do nothing."
  (if (lyskom-queue-isempty queue)
      nil
    (prog1
	(lyskom-queue->first queue)
      (setcar (cdr queue)
	      (cdr (car (cdr queue))))
      (if (null (car (cdr queue)))
	  (setcdr (cdr queue) nil)))))


;;; ================================================================
;;;                           A simple stack

;;; 
;;; This is an implementation of a simple stack.
;;;

;;; Author: Inge Wallin


(defun lyskom-stack-create ()
  "Create an empty stack"
  (cons 'STACK nil))


(defun lyskom-stack-p (stack)
  "Return t if STACK is a lyskom-stack, otherwise return nil."
  (eq (car-safe stack) 'STACK))


(defun lyskom-stack-push (stack element)
  "Push the second arg ELEMENT onto the first arg STACK"
  (setcdr stack (cons element (cdr stack))))


(defun lyskom-stack-pop (stack)
  "Remove the topmost element from STACK and return it. If the stack
is empty, return nil"
  (prog1
      (car-safe (cdr stack))
    (setcdr stack (cdr-safe (cdr stack)))))


(defun lyskom-stack->top (stack)
  "Return the topmost element of STACK or nil if it is empty."
  (car-safe (cdr stack)))


(defun lyskom-stack->length (stack)
  "Return the number of elements on STACK."
  (length (cdr stack)))


(defun lyskom-stack->nth (stack n)
  "Return element no (second arg) N of the stack (first arg) STACK.
N counts from zero. If the length of STACK is less than N, nil is returned."
  (nth n (cdr stack)))


(defun lyskom-stack->all-entries (stack)
  "Return a list of all entries in STACK.
The element last pushed is first in the list."
  (cdr stack))


(defsubst lyskom-stack-isempty (stack)
  "Returns non-nil if the STACK is empty."
  (not (cdr stack)))


;;; ================================================================
;;;                          who-buffer-info

;;; Author: Inge Wallin


;;; Constructor:

(defun lyskom-create-who-buffer-info (info
				      start-marker
				      end-marker)
  "Create a who-buffer-info from all parameters."
  (cons
   'WHO-BUFFER-INFO
   (vector info start-marker end-marker )))


;;; Selectors:

(defun who-buffer-info->info (who-buffer-info)
  "Get info from who-buffer-info."
  (elt (cdr who-buffer-info) 0))

(defun who-buffer-info->start-marker (who-buffer-info)
  "Get start-marker from who-buffer-info."
  (elt (cdr who-buffer-info) 1))

(defun who-buffer-info->end-marker (who-buffer-info)
  "Get end-marker from who-buffer-info."
  (elt (cdr who-buffer-info) 2))


;;; Modifiers:

(defun set-who-buffer-info->info (who-buffer-info newval)
  "Set info in who-buffer-info to NEWVAL."
  (aset (cdr who-buffer-info) 0 newval))

(defun set-who-buffer-info->start-marker (who-buffer-info newval)
  "Set start-marker in who-buffer-info to NEWVAL."
  (aset (cdr who-buffer-info) 1 newval))

(defun set-who-buffer-info->end-marker (who-buffer-info newval)
  "Set end-marker in who-buffer-info to NEWVAL."
  (aset (cdr who-buffer-info) 2 newval))



;;; Predicate:

(defun lyskom-who-buffer-info-p (object)
  "Return t if OBJECT is a who-buffer-info."
  (eq (car-safe object) 'WHO-BUFFER-INFO))


;;; ================================================================
;;;			format-props

(defun make-format-props (arg propl)
  (cons 'format-props (vector arg propl)))

(defsubst format-props-p (arg)
  (eq 'format-props (car-safe arg)))

(defsubst format-props->arg (arg)
  (elt (cdr arg) 0))

(defsubst format-props->propl (arg)
  (elt (cdr arg) 1))

;;;
;;;	Help functions
;;;



;;; ================================================================
;;;			format-state

(def-komtype format-state
  format-string
  start
  argl
  length
  result
  delayed-propl
  delayed-overlays
  delayed-content
  depth)
;; 
;; 
;; 
;; (defun make-format-state (format-string
;; 			  start
;; 			  argl
;; 			  result)
;;   (cons 'format-state
;; 	(vector format-string start argl (length argl) result nil nil nil nil)))
;; 
;; (defsubst format-state-p (arg)
;;   (eq 'format-state (car-safe arg)))
;; 
;; (defsubst format-state->format-string (arg)
;;   (elt (cdr arg) 0))
;; 
;; (defsubst set-format-state->format-string (arg str)
;;   (aset (cdr arg) 0 str))
;; 
;; (defsubst format-state->start (arg)
;;   (elt (cdr arg) 1))
;; 
;; (defsubst set-format-state->start (arg pos)
;;   (aset (cdr arg) 1 pos))
;; 
;; (defsubst format-state->args (arg)
;;   (elt (cdr arg) 2))
;; 
;; (defsubst set-format-state->args (arg argl)
;;   (aset (cdr arg) 2 argl)
;;   (aset (cdr arg) 3 (length argl)))
;; 
;; (defsubst format-state->args-length (arg)
;;   (elt (cdr arg) 3))
;; 
;; (defsubst format-state->result (arg)
;;   (elt (cdr arg) 4))
;; 
;; (defsubst set-format-state->result (arg output-list)
;;   (aset (cdr arg) 4 output-list))
;; 
;; (defsubst format-state->delayed-propl (arg)
;;   (elt (cdr arg) 5))
;; 
;; (defsubst set-format-state->delayed-propl (arg propl)
;;   (aset (cdr arg) 5 propl))
;; 
;; (defsubst format-state->delayed-overlays (arg)
;;   (elt (cdr arg) 7))
;; 
;; (defsubst set-format-state->delayed-overlays (arg overlays)
;;   (aset (cdr arg) 7 overlays))
;; 
;; (defsubst format-state->delayed-content (arg)
;;   (elt (cdr arg) 6))
;; 
;; (defsubst set-format-state->delayed-content (arg string)
;;   (aset (cdr arg) 6 string))
;; 
;; (defsubst

;;; ================================================================


;;; ======================================================================
;;;
;;; collector
;;;

;;; A collector is used when a handler needs to pass information
;;; back to a function using asynchronous calls. You could use
;;; dynamically scoped variables, but that causes problems when
;;; the user quits before all handlers have been called since the
;;; result variable will be out of scope for the remaining handlers.
;;; The best-case scenario will be a crash. The worst-case scenario
;;; is when the handler clobbers another variable with the same name
;;; that has come into scope.
;;;
;;; So, so collect a number of results, do the following:
;;;
;;;    (setq <result> (make-collector))
;;;    (<loop-function>
;;;        (initiate-<ngonting> '<queue> <function> <argl> <result>))
;;;    (lyskom-wait-queue '<queue>)
;;;    (<use> (collector->value <result>))
;;;
;;; where function is something like this:
;;;
;;;    (defun <funktion> (data-frn-servern collector)
;;;        (set-collector->value collector
;;;                              (cons (<behandla> data-frn-servern)
;;;                                    (collector->value collector))))
;;;
;;; or shorter,
;;;
;;;    (defun <funktion> (data-frn-servern collector)
;;;        (collector-push (<behandla> data-frn-servern)))
;;;
;;; This sidestepping protects the handler from scope changes.
;;;


(defun make-collector ()
  "Create a data type for collecting asynchronous results safely"
  (cons 'COLLECTOR nil))

(defsubst collector->value (collector)
  "Get the current value of a collector"
  (cdr collector))

(defsubst set-collector->value (collector value)
  "Set the calue of a collector"
  (setcdr collector value))

(defun set-value-of-collector (value collector)
  "For use with lyskom handlers. In other cases, use set-collector->value"
  (set-collector->value collector value))

(defun collector-push (value collector)
  "Push VALUE onto the front of COLLECTOR's value"
  (setcdr collector (cons value (cdr collector))))

(eval-and-compile (provide 'lyskom-clienttypes))

;;; clienttypes.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: deferred-insert.el,v 44.4 2002/02/24 20:23:26 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: deferred-insert.el
;;;;
;;;; This file includes functions for deffering insertion of
;;;; information into the LysKOM buffer.
;;;;

;;;
;;; How to defer a peice of text:
;;; =============================
;;;
;;;  1. Insert some temporary text. Use the variable
;;;     `lyskom-defer-indicator' as a placeholder.
;;; 
;;;  2. Create a defer-info-structure by calling
;;;     `lyskom-create-defer-info' with the following parameters
;;;
;;;        SERVER-CALL - the call to get the data (initate-get-*)
;;;        CALL-ARG    - the argument for the server call. This is
;;;                      limited to a single argument, which is enough
;;;                      for get-conf-stat and friends.
;;;        HANDLER     - the function to be called to insert the
;;;                      "real" data.
;;;        POS         - a marker indicating where the insertion
;;;                      should be placed.
;;;        DEL-CHARS   - an integer indicating how many characters
;;;                      from POS on should be replaced by the "real"
;;;                      text.
;;;        FORMAT      - a format string for inserting the real
;;;                      data. This should normally only contain a
;;;                      single format atom using argument 1
;;;                      (i.e. "%#1P").
;;;        DATA        - any data that you might want to use in
;;;                      HANDLER.
;;;
;;;  3. Call `lyskom-defer-insertion' with the defer-info as argument.
;;;
;;;  4. Write a handler function that takes two arguments, the server
;;;     reply and the defer-info. This function should replace the
;;;     temporary text. A convenient way to do this is to use
;;;     `lyskom-replace-deferred'.
;;;
;;;  5. Sit back and watch it work.
;;;  
;;;  Notes:
;;;  
;;;  POS must be located before the temporary text. DEL-CHARS should
;;;  usually be set to (length lyskom-defer-indicator). Don't count on
;;;  it to be 5.
;;;
;;;  Steps 1 and 2 are often implemented the other way around, or at
;;;  least the POS parameter is determined before any text is
;;;  inserted.
;;;
;;;  You should only defer text if kom-deferred-printing is non-nil.
;;;



;;; Type: defer-info

(defun lyskom-create-defer-info (server-call call-par handler pos
					     del-chars format
					     &optional data)
  (cons 'DEFER-INFO
	(vector server-call call-par handler pos del-chars format data
		lyskom-last-viewed)))

(defun lyskom-defer-info-p (obj)
  (and (consp obj)
       (eq (car obj) 'DEFER-INFO)))

(defun defer-info->server-call (di) (aref (cdr di) 0))
(defun defer-info->call-par (di)    (aref (cdr di) 1))
(defun defer-info->handler (di)     (aref (cdr di) 2))
(defun defer-info->pos (di)         (aref (cdr di) 3))
(defun defer-info->del-chars (di)   (aref (cdr di) 4))
(defun defer-info->format (di)      (aref (cdr di) 5))
(defun defer-info->data (di)        (aref (cdr di) 6))
(defun defer-info->last-viewed (di) (aref (cdr di) 7))

(defun set-defer-info->server-call (di x) (aset (cdr di) 0 x))
(defun set-defer-info->call-par (di x)    (aset (cdr di) 1 x))
(defun set-defer-info->handler (di x)     (aset (cdr di) 2 x))
(defun set-defer-info->pos (di x)         (aset (cdr di) 3 x))
(defun set-defer-info->del-chars (di x)   (aset (cdr di) 4 x))
(defun set-defer-info->format (di x)      (aset (cdr di) 5 x))
(defun set-defer-info->data (di x)        (aset (cdr di) 6 x))
(defun set-defer-info->last-viewed (di x) (aset (cdr di) 7 x))


(defun lyskom-defer-insertion (defer-info)
  "Defer insertion of something.
The insertion will be at (point)."
  (set-defer-info->last-viewed defer-info lyskom-last-viewed)
  ;; (goto-char (defer-info->pos defer-info))
  (funcall (intern-soft (concat "initiate-"
				(symbol-name (defer-info->server-call
					       defer-info)))) 
	   'deferred
	   (defer-info->handler defer-info)
	   (defer-info->call-par defer-info)
	   defer-info))

(defun lyskom-replace-deferred (defer-info &rest replacement-data)
  "Replace some defered text."
  (save-excursion
    (when (marker-buffer (defer-info->pos defer-info))
      (set-buffer (marker-buffer (defer-info->pos defer-info))))
    (goto-char (defer-info->pos defer-info))
    (apply 'lyskom-format-insert-at-point
	   (defer-info->format defer-info)
	   replacement-data)
    (let ((inhibit-read-only t))
      (delete-char (defer-info->del-chars defer-info)))
    (set-marker (defer-info->pos defer-info) nil))
  (if lyskom-executing-command
      nil
    (let ((window (get-buffer-window lyskom-buffer)))
      (if window
	  (if (pos-visible-in-window-p (point-max) window)
	      nil
	    ;; This means that this insertion moved point out of the
	    ;; window. The scrolling becomes tricky. One big problem is
	    ;; that we can't use lyskom-last-viewed, because it has been
	    ;; updated to the new prompt. Until that is solved we make
	    ;; sure that we never scroll.
	    ;;
	    ;; The solution is to save lyskom-last-viewed in the defer-info
	    (save-selected-window
	      (select-window window)
	      (lyskom-scroll))
	    ;; (move-to-window-line -1)
	    ;; (vertical-motion 1)
	    ;; (if (not (pos-visible-in-window-p))
	    ;;     (forward-char -1))
	    )))))


(defun lyskom-deferred-insert-conf (conf-stat defer-info)
  "Insert the name of a conference at a previously reserved place."
  (lyskom-replace-deferred
   defer-info
   (if (null conf-stat)
       (lyskom-format 
	(or (defer-info->data defer-info)
	    (if (= (aref (defer-info->format defer-info)
			 (1- (length (defer-info->format defer-info))))
		   ?P)
		(if (= (defer-info->call-par defer-info) 0)
		    'person-is-anonymous
		  'person-does-not-exist)
	      'conference-does-not-exist))
	(defer-info->call-par defer-info))
     conf-stat)
   (text-properties-at (defer-info->pos defer-info))))


;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: utilities.el,v 44.116 2002/08/09 15:14:50 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: utilities.el
;;;;
;;;; This file contains general lisp utility functions and
;;;; lyskom-specific utility functions (such as date formatting and
;;;; minibuffer reading)
;;;;


(setq lyskom-clientversion-long
      (concat lyskom-clientversion-long
	      "$Id: utilities.el,v 44.116 2002/08/09 15:14:50 byers Exp $\n"))

;;;
;;; Need Per Abrahamsens widget and custom packages There should be a
;;; better way of doing this, but I'll be darned if I know how. The
;;; various files need to be loaded in a very specific order.
;;;

;;; Define widget wrappers for all the functions in macros.el

;;;
;;; Lisp utility functions
;;;

(defsubst listify-vector (vector)
  "Turn VECTOR into a list"
  (append vector nil))

(defun nfirst (n list)
  "Return a list of the N first elements of LIST."
  (let ((result nil))
    (while (and (> n 0) list)
      (setq result (cons (car list) result)
            list (cdr list)
            n (1- n)))
    (nreverse result)))

(defun lyskom-rotate-list (list el)
  "Destructively rotate LIST so EL becomes the first element.
If EL occurs more than one, the first occurrence is used."
  (let ((tail (memq el list)))
    (if (or (null tail) (eq el (car list)))
        list
      (setcdr (nthcdr (- (length list) (length tail) 1) list) nil)
      (setcdr (nthcdr (1- (length tail)) tail) list)
      tail)))

(defun lyskom-preceding-cons (list el)
  "Return the cons cell of LIST preceding the first cons cell whose car is EL.
Return nil if TAIL is the same as LIST or not a member of LIST."
  (unless (or (eq (car list) el)
              (not (memq el list)))
    (nthcdr (- (length list) (length (memq el list)) 1) list)))

(defun lyskom-insert-in-list (el list before)
  "Destructively insert EL in LIST before element BEFORE.
If BEFORE is not in the list, then insert EL at the end of the list."
  (cond ((eq before (car list))
         (cons el list))
        (t (setcdr (nthcdr (- (length list)
                              (length (memq before list)) 1) list)
                   (cons el (memq before list)))
           list)))

(defun lyskom-move-in-list (el list pos)
  "Destructively move EL within LIST so it appears at position POS."
  (when (memq el list)
    (setq list (delq el list))
    (cond ((eq 0 pos) (setq list (cons el list)))
          (t (setcdr (nthcdr (1- pos) list)
                     (cons el (nthcdr pos list))))))
  list)

;;;
;;; +++ FIXME: If cl.el can be guaranteed, this is pointless.
;;;

(defun lyskom-butlast (x &optional n)
  "Returns a copy of LIST with the last N elements removed."
  (if (and n (<= n 0)) x
    (lyskom-nbutlast (copy-sequence x) n)))

(defun lyskom-nbutlast (x &optional n)
  "Modifies LIST to remove the last N elements."
  (let ((m (length x)))
    (or n (setq n 1))
    (and (< n m)
	 (progn
	   (if (> n 0) (setcdr (nthcdr (- (1- m) n) x) nil))
	   x))))

(defun filter-list (test list)
  (let ((result nil))
    (lyskom-traverse el list
      (when (funcall test el)
        (setq result (cons el result))))
    (nreverse result)))

;;;============================================================
;;;
;;; Utility functions.
;;;
;;; These should be shared in LysKOM
;;;

(eval-and-compile
  (if (eval-when-compile (string-match "XEmacs" emacs-version))
      (defmacro lyskom-compiled-function-p (arg) `(compiled-function-p ,arg))
    (defmacro lyskom-compiled-function-p (arg) `(byte-code-function-p ,arg))))

(lyskom-provide-function copy-tree (l)
  "Recursively copy the list L"
  (cond ((atom l) l)
        (t (cons (copy-tree (car l))
                 (copy-tree (cdr l))))))

(lyskom-provide-function functionp (obj)
  "Returns t if OBJ is a function, nil otherwise."
  (cond
   ((symbolp obj) (fboundp obj))
   ((subrp obj))
   ((lyskom-compiled-function-p obj))
   ((consp obj)
    (if (eq (car obj) 'lambda) (listp (car (cdr obj)))))
   (t nil)))


(defun lyskom-ignore (&rest args)
  "Ignore all arguments"
  )

(defun regexpp (re)
  "Return non-nil if RE looks like a valid regexp."
  (let ((result t))
    (save-match-data
      (condition-case nil
          (string-match re "")
        (error (setq result nil))))
    result))


(defun mapcar2 (fn seq1 seq2)
  (let (result)
    (while (and seq1 seq2)
      (setq result (cons (funcall fn (car seq1) (car seq2)) result))
      (setq seq1 (cdr seq1)
            seq2 (cdr seq2)))
    (nreverse result)))


(defun lyskom-maxint ()
  (let ((n 1) 
        (l nil)
        (i 31))
    (while (and (> n 0) (> i 0))
      (setq l (cons n l))
      (setq n (* 2 n))
      (setq i (1- i)))
    (apply '+ l)))

;; Set lyskom-maxint correctly

(setq lyskom-max-int (lyskom-maxint))


(defun lyskom-try-require (feature &optional message &rest args)
  "Load the feature FEATURE using require. 
If optional MESSAGE is non-nil, use it as a LysKOM format string 
taking one string argument to print an error message. Remaining
arguments are used as arguments for the format string.

Returns t if the feature is loaded or can be loaded, and nil otherwise."
  (or (featurep 'feature)
      (condition-case nil
          (progn (require feature)
                 t)
        (error 
         (when message
           (apply 'lyskom-format-insert-before-prompt message (symbol-name feature) args))
         nil))))
                               
      

(defun lyskom-emacs-version ()
  (cond ((string-match "^XEmacs" (emacs-version)) 'xemacs)
	(t 'emacs)))


(defvar lyskom-apo-timeout 0
  "Current millisecond timeout value for accept-process-output")

(defvar lyskom-apo-timeout-index 0
  "Index in lyskom-apo-timeout-vector-max where last timeout is")

(defconst lyskom-apo-timeout-vector
  [0 1000 1000 2000 3000 5000 8000 13000 21000 34000 55000 89000 144000 233000 377000 610000]
  "Vector of timeout values (usecs) for accept-process-output")

(defconst lyskom-apo-timeout-vector-max (1- (length lyskom-apo-timeout-vector))
  "Maximum index in lyskom-apo-timeout-vector")

(defun lyskom-next-apo-timeout ()
  (if (< lyskom-apo-timeout-index lyskom-apo-timeout-vector-max)
      (setq lyskom-apo-timeout
            (aref lyskom-apo-timeout-vector
                  (setq lyskom-apo-timeout-index
                        (1+ lyskom-apo-timeout-index))))))

(defun lyskom-reset-apo-timeout ()
  (setq lyskom-apo-timeout-index -1)
  (setq lyskom-apo-timeout 0))

(defun lyskom-accept-process-output ()
  "Call accept-process-output with the correct timeout values."
  (lyskom-next-apo-timeout)
  (accept-process-output nil 0 lyskom-apo-timeout))

(defun lyskom-set-alist (alist item value)
  "Modifies (non-destructively) an alist ALIST to set item
ITEM to the value VALUE."
  (let ((pair (assq item alist)))
     (if pair
         (progn (setcdr pair value) alist)
       (cons (cons item value) alist))))

;;;
;;; LysKOM utility functions
;;;

(lyskom-provide-function string-to-sequence (string type)
  "Convert STRING to a sequence of TYPE which contains characters in STRING.
TYPE should be `list' or `vector'."
  (let ((len (length string))
	(i 0)
	val)
    (cond ((eq type 'list)
	   (setq val (make-list len 0))
	   (let ((l val))
	     (while (< i len)
	       (setcar l (aref string i))
	       (setq l (cdr l) i (1+ i)))))
	  ((eq type 'vector)
	   (setq val (make-vector len 0))
	   (while (< i len)
	     (aset val i (aref string i))
	     (setq i (1+ i))))
	  (t
	   (error "Invalid type: %s" type)))
    val))

(lyskom-provide-subst string-to-vector (string)
  "Return a vector of characters in STRING."
  (string-to-sequence string 'vector))

;;;
;;; WARNING!
;;;
;;; The following variable is *important* if you fuck it up in any
;;; way, the functions used to read conference names won't work. So if
;;; you change it, try to work one character at a time, and when
;;; you're done, run through the mappings of all 256 characters to
;;; make sure they look OK.
;;;
;;; Make sure your MULE Emacs doesnt fuck it up for you. It did for me.
;;;

(defvar lyskom-default-collate-table
  "\000\001\002\003\004\005\006\007\010 \012\013\014\015\016\017\020\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]~\200\201\202\203\204\205\206\207\210\211\212\213\214\215\216\217\220\221\222\223\224\225\226\227\230\231\232\233\234\235\236\237!AAAA[]ACEEEEIIIINOOOO\\OUUUYYAAAA[]ACEEEEIIIINOOOO\\OUUUYY"
  "String mapping characters to their collate class.

Lowercase, uppercase and other equivalents are mapped to the same class.
The class number defines a proper sorting order.")


(defsubst lyskom-maybe-recode-string (s &optional coding force)
  "Change the encoding of S for when multibyte characters are not supported.
Optional second argument CODING is the coding system to use. If optional
third argument FORCE is non-nil, always encode multibyte strings, otherwise
only encode when multibyte strings are not supported."
  (if (and (multibyte-string-p s) (or force (not enable-multibyte-characters)))
      (encode-coding-string s (or coding
                                  (and lyskom-language
                                       (lyskom-language-coding lyskom-language))
                                  'raw-text))
    s))

(defun lyskom-recode-string-for-title (s coding)
  "Encode S with CODING for use in frame titles.
Attempts to encode the string only in Emacs versions that do not require
MULE coding for frame titles"
  (if (> emacs-major-version 20)
      s
    (lyskom-maybe-recode-string s coding t)))

(defun lyskom-maybe-frob-completion-table (table &optional copy)
  "Recode the cars of alist TABLE to default coding system unless multibyte
characters are enabled. This function is destructive unless optional copy
is non-nil."
  (cond (enable-multibyte-characters table)
	(copy (mapcar (lambda (el)
			(cons (lyskom-maybe-recode-string (car el) nil t)
			      (cdr el)))
                      table))
	(t (lyskom-traverse el table
		(setcar el (lyskom-maybe-recode-string (car el) nil t)))
	   table)))


(defsubst lyskom-unicase-char (c)
  "Smash case and diacritical marks on c." 
  (if (< (char-to-int c) (length lyskom-collate-table))
      (aref lyskom-collate-table (char-to-int c))
    (setq c (lyskom-encode-coding-char c lyskom-server-coding-system))
    (if (and c (< (char-to-int c) (length lyskom-collate-table)))
	(aref lyskom-collate-table (char-to-int c))
      c)))

(defun lyskom-unicase (s)
  "Smash case and diacritical marks of all chars in s." 
  (lyskom-save-excursion
   (and lyskom-buffer (set-buffer lyskom-buffer))
   (let* ((s2 (string-to-vector 
               (encode-coding-string s lyskom-server-coding-system)))
          (l (length s2)))
     (while (> l 0)
       (setq l (1- l))
       (aset s2 l (lyskom-unicase-char (aref s2 l))))
     (concat s2))))

(defun lyskom-looking-at (s)
  "Version of looking-at that will work in Gnu Emacs 20.3"
  (save-excursion
    (let ((start (point)))
      (and (re-search-forward s nil t)
	   (eq (match-beginning 0) start)))))

;; Don't slow things down with our own looking-at unless we have to

(eval-and-compile
 (condition-case nil
     (if (and (eq emacs-major-version 20)
	      (eq emacs-minor-version 3))
	 nil
       (fset 'lyskom-looking-at (symbol-function 'looking-at)))
   (error nil)))


(defun lyskom-compute-char-classes (map)
  "Find out which characters that are equivalent according to MAP.

MAP should be a collate table.

The return value is an assoc list, which characters as keys, and a
list of single-character strings as values.  Only characters that are
equivalent to at least one more character is returned in the assoc
list.

Example: if this function returns

	((97 \"A\" \"a\")
         (65 \"A\" \"a\")
	 (48 \"O\" \"o\" \"0\")
	 (111 \"O\" \"o\" \"0\")
	 (79 \"O\" \"o\" \"0\"))

it means that a and A are equivalent, and o, O and 0 are equivalent.
All other characters are unique."

  (lyskom-save-excursion
    (and lyskom-buffer (set-buffer lyskom-buffer))
    (let ((ix (length map))
	  (cls-to-strings nil)) ;assoc-list from equivalence class to
				;list of chars
      (while (> ix 0)
	(setq ix (1- ix))
	(let* ((cls (aref map ix))
	       (str (decode-coding-string (concat (vector ix))
					  lyskom-server-coding-system))
	       (elem (assoc cls cls-to-strings)))
	  (if elem
	      (rplacd elem (cons str (cdr elem)))
	    (setq cls-to-strings (cons (list cls str) cls-to-strings)))))
      (let ((res nil))
	(while cls-to-strings
	  (let ((lst (cdr (car cls-to-strings))))
	    (if (> (length lst) 1)
		(while lst
		  (setq res (cons (cons (string-to-char (car lst))
					(cdr (car cls-to-strings)))
				  res))
		  (setq lst (cdr lst)))))
	  (setq cls-to-strings (cdr cls-to-strings)))
	res))))
    
;; Stolen from thingatpt.el
;; FIXME: We may not really need this function. Check the callers.

(defun lyskom-thing-at-point-looking-at (regexp)
  "Return non-nil if point is in or just after a match for REGEXP.
Set the match data from the earliest such match ending at or after
point."
  (save-excursion
    (let ((old-point (point)) match)
      (and (looking-at regexp)
	   (>= (match-end 0) old-point)
	   (setq match (point)))
      ;; Search back repeatedly from end of next match.
      ;; This may fail if next match ends before this match does.
      (re-search-forward regexp nil 'limit)
      (while (and (re-search-backward regexp nil t)
		  (or (> (match-beginning 0) old-point)
		      (and (looking-at regexp) ; Extend match-end past search start
			   (>= (match-end 0) old-point)
			   (setq match (point))))))
      (if (not match) nil
	(goto-char match)
	;; Back up a char at a time in case search skipped
	;; intermediate match straddling search start pos.
	(while (and (not (bobp))
		    (progn (backward-char 1) (looking-at regexp))
		    (>= (match-end 0) old-point)
		    (setq match (point))))
	(goto-char match)
	(looking-at regexp)))))


;; Stolen from Gnu Emacs

(defun lyskom-truncate-string-to-width (str end-column &optional start-column padding)
  "Truncate string STR to end at column END-COLUMN.
The optional 2nd arg START-COLUMN, if non-nil, specifies
the starting column; that means to return the characters occupying
columns START-COLUMN ... END-COLUMN of STR.

The optional 3rd arg PADDING, if non-nil, specifies a padding character
to add at the end of the result if STR doesn't reach column END-COLUMN,
or if END-COLUMN comes in the middle of a character in STR.
PADDING is also added at the beginning of the result
if column START-COLUMN appears in the middle of a character in STR.

If PADDING is nil, no padding is added in these cases, so
the resulting string may be narrower than END-COLUMN."
  (or start-column
      (setq start-column 0))
  (let ((len (length str))
	(idx 0)
	(column 0)
	(head-padding "") (tail-padding "")
	ch last-column last-idx from-idx)
    (condition-case nil
	(while (< column start-column)
	  (setq ch (aref str idx)
		column (+ column (char-width ch))
		idx (1+ idx)))
      (args-out-of-range (setq idx len)))
    (if (< column start-column)
	(if padding (make-string end-column padding) "")
      (if (and padding (> column start-column))
	  (setq head-padding (make-string (- column start-column) padding)))
      (setq from-idx idx)
      (if (< end-column column)
	  (setq idx from-idx)
	(condition-case nil
	    (while (< column end-column)
	      (setq last-column column
		    last-idx idx
		    ch (aref str idx)
		    column (+ column (char-width ch))
		    idx (1+ idx)))
	  (args-out-of-range (setq idx len)))
	(if (> column end-column)
	    (setq column last-column idx last-idx))
	(if (and padding (< column end-column))
	    (setq tail-padding (make-string (- end-column column) padding))))
      (setq str (substring str from-idx idx))
      (if padding
	  (concat head-padding str tail-padding)
	str))))


(eval-and-compile
  (lyskom-xemacs-or-gnu
   (fset 'lyskom-string= (symbol-function 'string=))
   (if (< emacs-major-version 20)
       (fset 'lyskom-string= (symbol-function 'string=))
     (defun lyskom-string= (s1 s2)
       (string= (and s1 (if (multibyte-string-p s1)
		    s1
		  (decode-coding-string s1 (lyskom-language-coding
					    lyskom-language))))
		(and s2 (if (multibyte-string-p s2)
		    s2
		  (decode-coding-string s2 (lyskom-language-coding
					    lyskom-language)))))))))

(defun lyskom-string-assoc (key list)
  "Return non-nil if KEY is the same string as the car of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (car (car list))))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-string-member (key list)
  "Return non-nil if KEY is the same string as the car of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (car list)))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-string-rassoc (key list)
  "Return non-nil if KEY is the same string as the cdr of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (cdr (car list))))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-set-default (sym val)
  "Set the value of SYM in the LysKOM buffer to VAL."
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (set sym val)))

(defun lyskom-default-value (sym)
  "Get the value of SYM in the LysKOM buffer"
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (symbol-value sym)))

(defun lyskom-default-value-safe (sym)
  "Get the value of SYM in the LysKOM buffer"
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (and (boundp sym) (symbol-value sym))))


;;; ============================================================
;;; Prefix arguments

(defun lyskom-get-ancestors-of-text (text-no level)
  "Returns a list of all ancestors of TEXT-NO that are LEVEL
comment/foot-note levels up the comment tree. LEVEL is a
non-negative integer and 0 means the given text-no."
  (if (< level 1)
      (list text-no)
    (let* ((text-stat (blocking-do 'get-text-stat text-no))
	   (ancestors (and text-stat
			   (lyskom-text-stat-commented-texts text-stat)))
	   (level (1- level))
	   (result '()))
	(while ancestors
	  (setq result
		(lyskom-union
		 (lyskom-get-ancestors-of-text (car ancestors) level)
		 result
                 ))
	  (setq ancestors (cdr ancestors)))
	result)))

(defun lyskom-get-explicit-text (arg &optional prompt default constraint) arg)
(defun lyskom-get-command-specified-default-text (a p def &optional c) def)

(defun lyskom-get-last-read-text (&optional arg prompt default constraint)
  (lyskom-default-value 'lyskom-current-text))

(defun lyskom-get-previous-text (&optional arg prompt default constraint)
  lyskom-previous-text)

(defun lyskom-get-text-at-point (&optional arg prompt default constraint)
  (or (lyskom-text-at-point)
       (lyskom-get-string 'no-text-at-point)))

(defun lyskom-get-text-at-point-ancestor (arg &optional p d c)
  (let* ((text (lyskom-text-at-point))
	 (cnos (and text (lyskom-get-ancestors-of-text text arg)))
	 (txts (length cnos)))
    (cond
     ((not text)
      (lyskom-get-string 'no-text-at-point))
     ((eq txts 0)
      (lyskom-get-string 'no-comment-to))
     ((eq txts 1)
      (car cnos))
     (t
      (lyskom-read-number (lyskom-get-string 'what-ancestor) (car cnos))))))

(defun lyskom-prompt-for-text-no (arg prompt default &optional constraint)
  (lyskom-read-number prompt default))

(defun lyskom-get-last-text-written-by-me (&optional a p d c)
  (lyskom-default-value 'lyskom-last-written))

(defun lyskom-get-last-written-or-read-by-me (&optional a p d c)
  (lyskom-default-value 'lyskom-last-seen-written))

(defun lyskom-get-text-above-point (arg &optional prompt default constraint)
  (save-excursion
    (let ((former-point (point)))
      (backward-text (+ 1 arg))
      (if (looking-at "\\([0-9]+\\)\\s-")
	  (string-to-int (match-string 1))
	(progn ;; we probably ended up above the first message in the buffer
	  (forward-text)
	  (if (and (< (point) former-point)
		   (looking-at "\\([0-9]+\\)\\s-"))
	      (string-to-int (match-string 1))
	    (lyskom-error (lyskom-get-string 'bad-text-no-prefix) arg)))))))

(defun lyskom-get-text-below-point (arg &optional prompt default constraint)
  (save-excursion
    (let ((former-point (point)))
      (forward-text arg)
      (if (looking-at "\\([0-9]+\\)\\s-")
	  (string-to-int (match-string 1))
	(progn ;; we probably ended up below the final message in the buffer
	  (backward-text)
	  (if (and (> (point) former-point)
		   (looking-at "\\([0-9]+\\)\\s-"))
	      (string-to-int (match-string 1))
	    (lyskom-error (lyskom-get-string 'bad-text-no-prefix) arg)))))))

(defun lyskom-read-text-no-prompt-p (command)
  "Return non-nil if the COMMAND should prompt for a text number."
  (let ((check (assq command kom-text-no-prompts)))
    (if check (cdr check) (memq command lyskom-text-no-prompts-defaults))))

(defun lyskom-read-text-no-prefix-arg (prompt &optional always-prompt
				       default constraint)
  "Call in interactive list to read text-no for lyskom-commands using
configurable prefix argument heuristics. The strategy used for picking a
text-no is defined by the variable `kom-pick-text-no-strategy-alist'.

The PROMPT will be used to prompt for the number, either if invoked by the
strategy directly, or as a fallback when no strategy rule found a text-no,
or when that text-no did not meet the CONSTRAINT.

If the optional argument ALWAYS-PROMPT is non-nil and the user did not give
a prefix argument, she gets prompted for the text number regardless of the
`kom-pick-text-no-strategy-alist' settings. Another method of overriding
the prefix-less strategies for a command is via `kom-text-no-prompts'.

When DEFAULT is given, it will be the default text-no fall-back shown in the
prompt, when `kom-pick-text-no-strategy-alist' did not specify a working
default. The requirements that must be met are given by CONSTRAINT, when
specified. DEFAULT is either a text-no, a function for returning one or one
of the symbols 'last-seen-written and 'last-written, which are compatibility
aliases for lyskom-get-last-written-or-read-by-me and
lyskom-get-last-text-written-by-me respectively.

If the optional CONSTRAINT function or list is provided, it is called for
the text chosen by the strategy alist functions to validate that the text
really applies to the command. Returning nil means that it does, and
otherwise a helpful lyskom format string should be returned, which explains
to the user why that text did not apply to the command. This string may
refer to the text-no as %#1. The message is then presented to the user and
she gets prompted for a better text number. Failing a second time will
invoke the command anyway (probably to fail miserably, reporting a less
helpful error message).

When CONSTRAINT is a list, its first item is called with the text number as
its first argument and remaining list items appended to the argument list."
;  (lyskom-insert (format "Prefix arg: %s\n" current-prefix-arg))
  (let ((default (cond ((eq default 'last-written)
			(lyskom-get-last-text-written-by-me))
		       ((eq default 'last-seen-written)
			(lyskom-get-last-written-or-read-by-me))
		       ((functionp default) (funcall default))
		       (t default)))
	(constraint-func constraint)
	(constraint-args '())
	(text-no nil))
    (when (listp constraint)
      (setq constraint-func (car constraint))
      (setq constraint-args (cdr constraint)))
    (let* ((strategies kom-pick-text-no-strategy-alist)
           (how (append (cdr (assq lyskom-current-command strategies))
                        (cdr (assq t strategies)))))
      (while (and how (null text-no))
        (let* ((strategy-pred nil) ;; when a predicate to test the prefix
               (compare-value nil) ;; when a value to compare the prefix to
               (applies-p (car (car how))) ;; either one of the above
               (what-text (cdr (car how)))
               (constraint-not-met nil))
          (if (or (eq applies-p '-) (not (functionp applies-p)))
              (setq compare-value applies-p)
            (setq strategy-pred applies-p))

          (cond
           ((eq compare-value t) ;; provided a default value for the prompt
            (let ((new-default (lyskom-evaluate-text-no-strategy
                                what-text prompt default constraint)))
              (when (and (lyskom-plusp new-default))
                (setq default (or default new-default)))))

           ((or (eq compare-value current-prefix-arg) ;; a text-no strategy
                (and (functionp strategy-pred)
                     (funcall strategy-pred current-prefix-arg)))
            (setq text-no (lyskom-evaluate-text-no-strategy
                           what-text prompt default constraint))
;	    (lyskom-insert (format "cmp: %s\npred: %s\ntext-no: %s\n\n"
;				   compare-value strategy-pred text-no))
            (when (and (not (stringp text-no)) text-no constraint)
              (setq constraint-not-met
                    (apply constraint-func text-no constraint-args))
              (when constraint-not-met
                (lyskom-format-insert constraint-not-met text-no)
                (lyskom-format-insert
                 (lyskom-get-string 'prefix-arg-try-again))
                (setq text-no (lyskom-read-number prompt default))))))
          (setq how (cdr how)))))
    (cond
     ((stringp text-no) ;; a strategy failure error message
      (lyskom-error text-no))
     ((and (null current-prefix-arg)
           (or always-prompt
               (lyskom-read-text-no-prompt-p lyskom-current-command)))
      (lyskom-read-number prompt 
                          (if (lyskom-plusp text-no) 
                              text-no
                            (lyskom-default-value 'lyskom-current-text))))
     ((and (lyskom-plusp text-no)) ;; a proper text-no
      text-no)
     ((null current-prefix-arg) ;; a fall-back when no strategy had kicked in
      (lyskom-read-number prompt default))
     (t
      (lyskom-error (lyskom-get-string 'bad-text-no-prefix)
                    current-prefix-arg)))))

(defun lyskom-evaluate-text-no-strategy (strategy prompt default constraint)
  (let ((prefix current-prefix-arg)
	(strategy-func nil)
	(strategy-args '()))
    (cond
     ((listp strategy)
      (setq strategy-func (car strategy))
      (setq prefix (funcall (car (cdr strategy)) prefix))
      (setq strategy-args (cdr (cdr strategy)))
      (apply strategy-func prefix prompt default constraint
	     strategy-args))
     ((functionp strategy)
      (funcall strategy prefix prompt default constraint)))))

;;; ============================================================
;;; Set functions

(defun lyskom-subset-p (a b)
  "Return non-nil if A is a subset of B"
  (let ((result t))
    (while a
      (if (memq (car a) b)
          (setq a (cdr a))
        (setq result nil a nil)))
    result))

(defun lyskom-intersection (a b)
  "Returns as a list the intersection of list A and list B.
The order of the list a is kept."
  (if (or a b)
      (let ((list nil))
        (while a
          (if (memq (car a) b)
              (setq list (cons (car a) list)))
          (setq a (cdr a)))
        (nreverse list))))

(defun lyskom-union (a b)
  "Returns a list containing the union of list A and list B.
Specifically, concatenate all elements of B that are not in A
to the end of A. This operation is destructive and modifies the
list pointed to by A."
  (let ((result nil))
    (lyskom-traverse x b
      (unless (memq x a) (setq result (cons x result))))
    (nconc a (nreverse result))))

(defun lyskom-delete-duplicates (list &optional key)
  "Removes all but one instance of each element in LIST.
If optional argument KEY is non-nil, apply KEY to each element before
comparison. Comparison is done with eq."
  (let ((clist (mapcar (lambda (el)
                         (if key
                             (cons (funcall key el) el)
                           (cons el el)))
                       list))
        (result nil))
    (lyskom-traverse el clist
      (unless (assq (car el) result)
        (setq result (cons el result))))
    (nreverse (mapcar 'cdr result))))

(defun lyskom-plusp (int)
  "Returns t for integers greater than 0, nil otherwise."
  (and (integerp int) (> int 0)))

(defun lyskom-minusp (int)
  "Returns t for integers smaller than 0, nil otherwise."
  (and (integerp int) (< int 0)))

;;; ======================================================================
;;; Display device management
;;;


;;; Definition of some useful functions from XEmacs

(lyskom-provide-function console-type (&optional console)
  (or window-system 'tty))

(lyskom-external-function display-color-p)
(lyskom-external-function display-grayscale-p)

(eval-and-compile
  (cond ((fboundp 'device-class)	; XEmacsism
	 (defalias 'lyskom-device-class 'device-class))
	((and (fboundp 'display-color-p) (fboundp 'display-grayscale-p))
	 ;; Emacs 21 can use color even when not running under
	 ;; X-windows.  Note that display-grayscale-p can be false when
	 ;; using a color display!  This happens when running on a
	 ;; classic Linux tty console.
	 (defun lyskom-device-class (&optional device)
	   (cond ((display-color-p device) 'color)
		 ((display-grayscale-p device) 'grayscale)
		 (t 'mono))))
	(t ;; This works in Emacs 20 and earlier.
	 (defun lyskom-device-class (&optional device)
	   (condition-case nil
	       (if (x-display-grayscale-p device)
		   (if (x-display-color-p device)
		       'color
		       'grayscale)
		   'mono)
	     (error 'mono))))))

(lyskom-provide-function frame-property (frame property &optional default)
  (or (cdr (assq property (frame-parameters frame)))
      default))


;;; XEmacs doesn't seem to have a background-mode frame property

(defun lyskom-background-mode ()
  (frame-property (selected-frame) 'background-mode 'light))


;;; ======================================================================
;;; LysKOM Hooks
;;;

(defun lyskom-run-hook-with-args (hook &rest args)
  "Run HOOK with the specified arguments ARGS in the LysKOM buffer.
See run-hook-with-args for detailed information."
  (lyskom-save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                              lyskom-buffer)
                                         (current-buffer)))
                  (apply 'run-hook-with-args hook args)))


;;;(defun lyskom-set-variable-hook-wrapper (hook-function args)
;;;  "Wrapper for running HOOK-FUNCTION with ARGS.
;;;If HOOK returns an alist ((S1 . V1) ...), set value of symbol S1 to V1
;;;and similarly for each element.
;;;
;;;The hook may set hook-function-args to change the arguments to subsequent
;;;hook functions.
;;;
;;;Hook functions that rely on this are totally dependent on the current 
;;;implementation of all callers. If you think you want to use this feature,
;;;think again. You probably don't."
;;;  (lyskom-traverse el (apply hook args)
;;;    (set (car el) (cdr el))))
;;;
;;;
;;;(defun lyskom-run-hook-with-wrapper (hook wrapper &rest args)
;;;  "Run HOOK by calling WRAPPER for each function in the LysKOM buffer.
;;;The wrapper will be called with arguments FUNCTION and ARGS. It
;;;calls the actual hook function by applying FUNCTION to ARGS.
;;;
;;;This function emulates the built-in run-hook-with-args function.
;;;It is modeled on the XEmacs 21.2 implementation, so there may be
;;;slight discrepancies with other Emacs versions.
;;;
;;;The variable hook-function-args holds the arguments to the hook 
;;;function (the ARGS parameter for the wrapper)."
;;;  (save-excursion
;;;    (set-buffer (or (and (boundp 'lyskom-buffer) lyskom-buffer)
;;;                    (current-buffer)))
;;;    (let ((hook-function-args args))
;;;      (when (and hook (boundp hook))
;;;        (let ((val (symbol-value hook)))
;;;          (if (and (consp val) (eq (car val 'lambda)))
;;;              (funcall wrapper val args)
;;;            (while (and val (consp val))
;;;              (if (eq (car val) t)
;;;                  (let ((globals (default-value hook)))
;;;                    (if (and (consp globals) (eq (car globals 'lambda)))
;;;                        (funcall wrapper hook args)
;;;                      (while (and globals (consp globals))
;;;                        (unless (eq (car globals t))
;;;                          (funcall wrapper (car globals) args))
;;;                        (setq globals (cdr globals)))))
;;;                (funcall wrapper (car val) args)
;;;                (setq val (cdr val))))))))))

                                                     

(defun lyskom-add-hook (hook function &optional append)
  "Add to the value of HOOK the function FUNCTION in the LysKOM buffer.
If optional APPEND is non-nil, add at the end of HOOK."
  (save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                       lyskom-buffer)
                                  (current-buffer)))
                  (add-hook hook function append t)))

(defun lyskom-remove-hook (hook function)
  "From the value of HOOK remove the function FUNCTION in the LysKOM buffer."
  (save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                       lyskom-buffer)
                                  (current-buffer)))
                  (remove-hook hook function t)))




;;; ======================================================================
;;; Printing
;;;
;;; XEmacs princ does not insert text properties. This function is based
;;; on the C code for princ. 
;;;

(defun lyskom-princ (object &optional stream)
  "Output the printed representation of OBJECT, any Lisp OBJECT.
No quoting characters are used; no delimiters are printed around
the contents of strings. Text properties are retained.

Output stream is STREAM, or value of standard-output, and must be a
buffer or a marker. Function or minibuffer streams are not supported
for strings."
  (if (not (stringp object))
      (princ object stream)
    (let ((old-point nil)
          (start-point nil)
          (old-buffer (current-buffer)))
      (unwind-protect
          (progn
            (cond ((bufferp stream) (set-buffer stream))
                  ((markerp stream) 
                   (setq old-point (point))
                   (set-buffer (marker-buffer stream))
                   (goto-char stream)
                   (setq start-point (point)))
                  ((null stream)
                   (cond ((bufferp standard-output) (set-buffer standard-output))
                         ((markerp standard-output) 
                          (setq old-point (point))
                          (set-buffer (marker-buffer standard-output))
                          (goto-char standard-output)
                          (setq start-point (point))))))

            (insert object))
        (cond ((markerp stream) 
               (set-marker stream (point))
               (if (>= old-point start-point)
                   (goto-char (+ old-point (- (point) start-point)))
                 (goto-char old-point))))
        (set-buffer old-buffer)))))


;;; ======================================================================
;;; Faces
;;;

(make-face 'lyskom-weak-highlight-face)
(make-face 'lyskom-strong-highlight-face)

(defun lyskom-set-face-foreground (face color)
  (condition-case nil
      (set-face-foreground face color)
    (error nil)))

(defun lyskom-set-face-background (face color)
  (condition-case nil
      (set-face-background face color)
    (error nil)))

(defun lyskom-copy-face (old new)
  (lyskom-xemacs-or-gnu (copy-face old new nil nil nil 'remove-all)
                        (copy-face old new)))



(defun lyskom-set-face-scheme (scheme)
  "Set the LysKOM color and face scheme to SCHEME. Valid schemes are listed
in lyskom-face-schemes."
  (let ((tmp (assoc scheme lyskom-face-schemes))
        (properties nil)
        (set-faces nil)
        (background (or (face-background 'default)
                        (frame-property (selected-frame) 'background-color))))
    (when (and tmp
               (fboundp 'copy-face)
               (fboundp 'lyskom-set-face-foreground)
               (fboundp 'lyskom-set-face-background))


      ;; If we have a background color, then compute the highlight colors

      (when background
        (lyskom-set-face-background 'lyskom-strong-highlight-face
                                    (lyskom-get-color-highlight (lyskom-color-values background) 0.05))
        (lyskom-set-face-background 'lyskom-weak-highlight-face
                                    (lyskom-get-color-highlight (lyskom-color-values background) 0.025)))

      ;; Traverse face specifications in the face scheme

      (lyskom-traverse spec (cdr tmp)
        (if (eq 'property (car spec))
            (setq properties (cons (cons (elt spec 1) (elt spec 2)) properties))
          (if (elt spec 1) (lyskom-copy-face (elt spec 1) (elt spec 0)) (make-face (elt spec 0)))
          (when (elt spec 2) (lyskom-set-face-foreground (elt spec 0) (elt spec 2)))
          (when (elt spec 3) (lyskom-set-face-background (elt spec 0) (elt spec 3)))
          (setq set-faces (cons (elt spec 0) set-faces))))

      ;; Check that the background color of the default face is what
      ;; the face scheme expects. If not, copy the computed highlight
      ;; faces to the real highlight faces.

      (let ((expected-background
             (or (null background)
                 (null (assq 'expected-background properties))
                 (equal (lyskom-color-values 
                         (cdr (assq 'expected-background properties)))
                        (lyskom-color-values background)))))
         (unless (and (memq 'kom-dashed-lines-face set-faces)
                      expected-background)
           (copy-face 'lyskom-strong-highlight-face 'kom-dashed-lines-face))

         (unless (and (memq 'kom-text-body-face set-faces)
                      expected-background)
           (copy-face 'lyskom-weak-highlight-face 'kom-text-body-face))

         (unless (and (memq 'kom-async-dashed-lines-face set-faces)
                      expected-background)
           (copy-face 'lyskom-strong-highlight-face 'kom-async-dashed-lines-face))

         (unless (and (memq 'kom-async-text-body-face set-faces)
                      expected-background)
           (copy-face 'lyskom-weak-highlight-face 'kom-async-text-body-face))

         (setq set-faces (append set-faces
                                 (list 'kom-dashed-lines-face
                                       'kom-text-body-face
                                       'kom-async-dashed-lines-face
                                       'kom-async-text-body-face))))

        ;; Check that we've set all faces. If not, copy the default face and post a message

        (let ((unset-faces nil))
          (lyskom-traverse face-name lyskom-faces
            (unless (memq face-name set-faces)
              (setq unset-faces (cons face-name unset-faces))
              (copy-face 'default face-name)))

          (when unset-faces
            (lyskom-format-insert-before-prompt 
             'missing-faces
             (symbol-name scheme)
             (mapconcat 'symbol-name
                        unset-faces
                        "\n    ")))))))


(defun lyskom-face-resource (face-name attr type)
  (if (eq (lyskom-emacs-version) 'xemacs)
      ;; XEmacs style
      (let ((val (x-get-resource (concat face-name ".attribute" attr)
				 (concat "Face.Attribute" attr)
				 type)))
	(cond ((eq type 'string) val)
	      ((and (eq type 'boolean) val) (if (car val) 'on 'off))
	      (t val)))
    ;; Emacs style
    (let ((val (x-get-resource (concat face-name ".attribute" attr)
			       (concat "Face.Attribute" attr))))
      (cond ((eq type 'string) val)
	    ((and val
		  (eq type 'boolean)
		  (member (downcase val) '("on" "true"))) 'on)
	    ((and val (eq type 'boolean)) 'off)
	    (t val)))))


(defun lyskom-modify-face (what face)
  (condition-case nil
      (funcall (intern (concat "make-face-" (symbol-name what)))
               face)
    (error nil)))

(defun lyskom-setup-faces ()
  "Initalize the faces in the LysKOM client.
This sets the face scheme according to `kom-default-face-scheme', and
also reads the proper X resources."
  (unless kom-default-face-scheme
    (setq kom-default-face-scheme
	  (condition-case nil
	      (cond ((eq (lyskom-device-class) 'mono) 'monochrome)
		    ((eq (lyskom-background-mode) 'dark)
		     'inverse)
		    (t 'default))
	    (error 'default))))  
  (lyskom-set-face-scheme kom-default-face-scheme)
  (if (eq (console-type) 'x)
      (lyskom-traverse face lyskom-faces
        (let* ((face-name (symbol-name face))
               (fg (lyskom-face-resource face-name "Foreground" 'string))
               (bg (lyskom-face-resource face-name "Background" 'string))
               (bl (lyskom-face-resource face-name "Bold" 'boolean))
               (it (lyskom-face-resource face-name "Italic" 'boolean))
               (ul (lyskom-face-resource face-name "Underline" 'boolean)))
          (if fg (set-face-foreground face fg))
          (if bg (set-face-background face bg))
          (if (eq bl 'on) (lyskom-modify-face 'bold face))
          (if (eq bl 'off) (lyskom-modify-face 'unbold face))
          (if (eq it 'on) (lyskom-modify-face 'italic face))
          (if (eq it 'off) (lyskom-modify-face 'unitalic face))
          (if ul (set-face-underline-p face (eq ul 'on)))))))


;;; ============================================================
;;; Date and time utilities

(defun lyskom-current-client-time ()
  "Return time representing current client time."
  (let ((now (decode-time)))
    (lyskom-create-time (elt now 0)     ;sec
                        (elt now 1)     ;min
                        (elt now 2)     ;hour
                        (elt now 3)     ;mday
                        (elt now 4)     ;mon
                        (elt now 5)     ;year
                        (elt now 6)     ;wday
                        0               ;yday
                        (if (elt now 7) ;isdst
                            1
                          0)
                        )))

(defun lyskom-current-server-time ()
  "Return time representing current server time."
  (blocking-do 'get-time))

(defun lyskom-format-time (format &optional time)
  "Return TIME as a string formatted as FORMAT.

FORMAT may be a string or a symbol.  If it is a symbol, it is
interpreted as follows:

    'date-and-time  Include date and time. [1][2]
    'date           Include just date. [1]
    'time           Include just time. [2]

    [1] If kom-print-seconds-in-time-strings is nil, only hours and
    minutes will be included in the time; if it is non-nil, seconds
    will also be included.
    [2] If kom-print-relative-dates is non-nil and the date is today's
    or yesterday's, the string \"today\" or \"yesterday\" (respectively)
    is used instead of the standard date format.

If FORMAT is a symbol but not one of the symbols listed above, the
format string will be looked up with lyskom-get-string.  The
timeformat-* strings are tailored to be used as formats for this
function.

The arguments to the format string are (in order): year, month number
\(starting with one for January), day-of-month number, hour, minute,
second, full name of the day of the week, abbreviated name of the day
of the week.

TIME defaults to the current client time."
  (let* ((time (or time (lyskom-current-client-time)))
         (fmt (cond
               ((stringp format)
                format)
               ((memq format '(date-and-time date time))
                (lyskom-format (cond ((eq format 'date-and-time)
                                      'format-time-date-and-time)
                                     ((eq format 'date)
                                      'format-time-just-date)
                                     ((eq format 'time)
                                      'format-time-just-time))
                               (lyskom-get-string
                                (or (and kom-print-relative-dates
                                         (lyskom-calculate-day-diff time))
                                    'timeformat-yyyy-mm-dd))
                               (lyskom-get-string
                                (if kom-print-seconds-in-time-strings
                                    'timeformat-hh-mm-ss
                                  'timeformat-hh-mm))))
               ((symbolp format)
                (lyskom-get-string format))
               (t (error "Invalid argument")))))
    (lyskom-format fmt
                   (time->year time)
                   (time->mon  time)
                   (time->mday time)
                   (time->hour time)
                   (time->min  time)
                   (time->sec  time)
                   (elt (lyskom-get-string 'weekdays)
                        (time->wday time))
                   (elt (lyskom-get-string 'weekdays-short)
                        (time->wday time)))))


;;; ============================================================
;;; Keymap utilities

(defun lyskom-lookup-key (keymap event &optional accept-default)
  (if (not (arrayp event))
      (setq event (vector event)))
  (if (null keymap)
      (and accept-default 
           (lookup-key global-map event))
    (or (lookup-key keymap event)
        (lyskom-lookup-key (keymap-parent keymap) event accept-default))))

(defun lyskom-keymap-body (keymap)
  (setq keymap (cdr keymap))
  (cond ((arrayp (car keymap)) (car keymap))
        (t keymap)))

(defun lyskom-keymap-realbinding (binding)
  (while (stringp (car-safe binding))
    (setq binding (cdr binding)))
  binding)

(defun lyskom-overlay-keymap (basemap overlay keymap &optional prefix)
  (let ((keys (make-vector (1+ (length prefix)) nil))
        (index (length prefix))
        (body nil)
        (r 0))

    (while (< r (length prefix))
      (aset keys r (aref prefix r))
      (setq r (1+ r)))

    (cond ((not (keymapp keymap)))
          ((not (keymapp overlay)))
          ((not (keymapp basemap)))

          ((setq body (lyskom-keymap-body overlay))
           (mapcar
            (function
             (lambda (element)
               (cond ((arrayp element)
                      (let ((len (length element)))
                        (setq r 0)
                        (while (< r len)
                          (aset keys index r)
                          (lyskom-overlay-keys keys (aref element r)
                                               basemap overlay keymap)
                          (setq r (1+ r)))))

                     ((consp element)
                      (when (not (eq t (car element)))
                        (aset keys index (car element))
                        (lyskom-overlay-keys keys
                                             (lyskom-keymap-realbinding
                                              (cdr element))
                                             basemap overlay keymap)))

                     (t nil))))
            body)))))


(defun lyskom-overlay-keys (keys binding basemap overlay keymap)
  (let ((base-binding (lyskom-lookup-key basemap keys nil)))

   ;; If the binding is a keymap or prefix and
   ;; the binding in the base is a keymap or prefix 
   ;; then recurse

   (cond ((and (keymapp binding)
               (keymapp base-binding))
          (lyskom-overlay-keymap basemap binding keymap keys))

   ;; If the binding is a keymap or prefix and
   ;; we are bound in the base
   ;; then don't recurse

         ((and (keymapp binding)
               base-binding) nil)

   ;; If we are not bound in the base
   ;; copy the binding

         ((and binding
               (null base-binding)) (define-key keymap keys binding)))))


;;;
;;; Stuff
;;;

(defun lyskom-return-membership-type (mt)
  "Return a text description of membership type mt"
  (let ((tmp
         (mapconcat 
          'identity
          (delete nil
                  (list (if (membership-type->invitation mt) (lyskom-get-string 'invitation-mt-type) nil)
                        (if (membership-type->passive mt) (lyskom-get-string 'passive-mt-type) nil)
                        (if (membership-type->secret mt) (lyskom-get-string 'secret-mt-type) nil)))
          ", ")))
    (if (string= tmp "") 
        tmp
      (concat "[" tmp "]"))))

(defun lyskom-find-unread (conf-no)
  "Return the number of unread texts in CONF-NO.
If this function is unable to calculate the number of unread texts it will
return nil."
  (save-excursion
   (set-buffer lyskom-buffer)
   (let ((rlist (read-list->all-entries lyskom-to-do-list))
         (found nil))
     (while (and (not found) rlist)
       (when (eq conf-no (conf-stat->conf-no
                          (read-info->conf-stat (car rlist))))
         (setq found (length (cdr (read-info->text-list (car rlist))))))
       (setq rlist (cdr rlist)))
     found)))

(defun lyskom-prev-area (num prop &optional goto-point-min)
  (while (> num 0)
    (let ((where (previous-single-property-change (point) prop)))
      (cond (where
             (if (not (get-text-property where prop))
                 (setq where (previous-single-property-change 
                              where prop)))
             (if where
                 (goto-char where)
               (goto-char (point-min))
               (setq num 1)))
            (goto-point-min (goto-char (point-min))
                            (setq num 1))))
    (setq num (1- num))))

(defun lyskom-next-area (num prop &optional goto-point-max)
  "Move the cursor to the next prompt in the LysKOM buffer"
  (interactive "p")
  (while (> num 0)
    (let ((where (next-single-property-change (point) prop)))
      (cond (where
             (if (not (get-text-property where prop))
                 (setq where (next-single-property-change where prop)))
             (if where
                 (goto-char where)
               (goto-char (point-max))
               (setq num 1)))
            (goto-point-max (goto-char (point-max))
                            (setq num 1))))
      (setq num (1- num))))

;;; ============================================================
;;; Database stuff

;; Extracted from edit-text.el
;;(defun lyskom-is-supervisor (conf-stat &optional memo)
;;  "Return non-nil if lyskom-pers-no is a supervisor of CONF-STAT."
;;  (cond ((null conf-stat) nil)
;;        ((memq (conf-stat->conf-no conf-stat) memo) nil)
;;        ((eq lyskom-pers-no (conf-stat->conf-no conf-stat)) t)
;;        ((eq lyskom-pers-no (conf-stat->supervisor conf-stat)) t)
;;        ((eq 0 (conf-stat->supervisor conf-stat)) nil)
;;        ((lyskom-get-membership (conf-stat->conf-no conf-stat) t) t)
;;        ((lyskom-is-supervisor
;;          (blocking-do 'get-conf-stat (conf-stat->supervisor conf-stat))
;;          (cons (conf-stat->conf-no conf-stat) memo)))))

(defun lyskom-is-supervisor (conf-no viewer-no)
  "Return non-nil if the supervisor of CONF-NO is VIEWER-NO."
  (or (eq viewer-no conf-no)
      (lyskom-is-strictly-supervisor conf-no viewer-no)))

(defun lyskom-is-strictly-supervisor (conf-no viewer-no)
  "Return non-nil if VIEWER-NO is strictly a supervisor of CONF-NO

Cannot be called from a callback."
  (let ((collector (make-collector))
        (conf-stat nil))
    (initiate-get-conf-stat 'background 'collector-push conf-no collector)
    (lyskom-wait-queue 'background)
    (setq conf-stat (car (collector->value collector)))

    (cond ((null viewer-no) nil)
          ((eq viewer-no 0) nil)
          ((null conf-stat) nil)
          ((eq viewer-no (conf-stat->supervisor conf-stat)) t)
          ((lyskom-is-member (conf-stat->supervisor conf-stat) viewer-no) t)
          (t nil))))

(defun lyskom-is-member (conf-no pers-no &optional queue)
  "Return the membership in CONF-NO of PERS-NO
Optional argument QUEUE is the queue to send the queries on.

Cannot be called from a callback."
  (or (and (eq pers-no lyskom-pers-no)
           (lyskom-try-get-membership conf-no t))
      (let ((collector (make-collector)))
        (initiate-query-read-texts (or queue 'background)
                                   'collector-push
                                   pers-no
                                   conf-no
                                   collector)
        (lyskom-wait-queue (or queue 'background))
        (car (collector->value collector)))))

(defun lyskom-text-recipients (text-stat &optional want-types)
  "Return the list of recipients for TEXT-STAT.
If WANT-TYPES is non-nil then the result is an assoc list where the 
car of each element is the recipient number and the cdr is the type."
  (let ((result nil))
    (lyskom-traverse misc (text-stat->misc-info-list text-stat)
      (when (memq (misc-info->type misc) lyskom-recpt-types-list)
        (if want-types
            (setq result (cons (cons (misc-info->recipient-no misc)
                                     (misc-info->type misc))
                               result))
          (setq result (cons (misc-info->recipient-no misc)
                             result)))))
    (nreverse result)))

(defun lyskom-text-comments (text-stat)
  "Return the list of comments to TEXT-STAT"
  (let ((result nil))
    (lyskom-traverse misc (text-stat->misc-info-list text-stat)
      (cond ((eq (misc-info->type misc) 'FOOTN-IN)
             (setq result (cons (misc-info->footn-in misc) result)))
            ((eq (misc-info->type misc) 'COMM-IN)
             (setq result (cons (misc-info->comm-in misc) result)))))
    (nreverse result)))


(defun lyskom-find-text-by-date (conf-stat target-date)
  "Search texts in CONF-STAT for a text added on or about TARGET-DATE.
Returns a cons of (LOCAL . GLOBAL)"
  (let* ((lowest (conf-stat->first-local-no conf-stat))
         (highest (+ lowest (conf-stat->no-of-texts conf-stat)))
         (result nil)
         (index (+ lowest (/ (- highest lowest) 2)))
         (last-index (1- index)))
    (while (/= last-index index)
      (let* ((map (blocking-do 'local-to-global 
                               (conf-stat->conf-no conf-stat)
                               index
                               1)))
        (cond ((null map) (setq lowest highest))
              ((null (text-mapping->global-numbers map))
               (setq highest index))
              (t 
               (let* ((text-no (car (text-mapping->global-numbers map)))
                      (text-stat (blocking-do 'get-text-stat text-no))
                      (local-no (text-mapping->global-to-local map text-no))
                      (date (and text-stat
                                 (lyskom-traverse misc
                                     (text-stat->misc-info-list text-stat)
                                   (when (and (memq (misc-info->type misc) lyskom-recpt-types-list)
					      (eq (misc-info->recipient-no misc) text-no))
                                     (lyskom-traverse-break 
                                      (if (misc-info->sent-at misc)
                                          (misc-info->sent-at misc)
                                        (text-stat->creation-time text-stat))))))))
                 (when text-stat
                   (setq index local-no)
                   (if (lyskom-time-greater
			date
                        target-date)
                       (setq highest index)
                     (setq lowest index))
                   (setq result text-stat))))))
      (setq last-index index)
      (setq index (+ lowest (/ (- highest lowest) 2))))
    (cons last-index result)))

(defvar lyskom-year-window-start 80
  "Windowing threshold for YY year specifications.
Years below this are considered in the 21st century. Years above this
in the 20th century")

(defun lyskom-parse-date (arg)
  "Parse ARG as a date."
  (let ((month-regexp (concat "\\("
                              (mapconcat (lambda (el)
                                           (regexp-quote (car el)))
                                         lyskom-month-names
                                         "\\|")
                              "\\)"))
        (dmy-regexp (concat "\\("
                            (mapconcat (lambda (el)
                                         (regexp-quote (lyskom-get-string el)))
                                       '(years year months month days day)
                                       "\\|")
                            "\\)"))
        (test-date (format-time-string "%x" '(20 0)))
        year month day di mi yi)

  ;; Look at test-date to see where dates in ambiguous cases should go

    (cond ((string-match "01.*16.*70" test-date) (setq di 2 mi 1 yi 3))
          ((string-match "01.*70.*16" test-date) (setq di 3 mi 1 yi 2))
          ((string-match "16.*01.*70" test-date) (setq di 1 mi 2 yi 3))
          ((string-match "16.*70.*01" test-date) (setq di 1 mi 3 yi 2))
          ((string-match "70.*01.*16" test-date) (setq di 3 mi 2 yi 1))
          ((string-match "70.*16.*01" test-date) (setq di 2 mi 3 yi 1)))

     (cond ((string-match "\\([0-9][0-9][0-9][0-9]\\)[-./]\\([0-9][0-9]?\\)[-./]\\([0-9][0-9]?\\)" arg)
           ;; YYYY-MM-DD
           (setq year (string-to-int (match-string 1 arg))
                 month (string-to-int (match-string (if (> mi di) 3 2) arg))
                 day (string-to-int (match-string (if (> di mi) 2 3) arg)))
           (when (> month 12) (setq month day day month))
           )
          ((string-match "\\([0-9][0-9]?\\)[-./]\\([0-9][0-9]?\\)[-./]\\([0-9][0-9][0-9][0-9]?\\)" arg)
           ;; YYYY-MM-DD
           (setq year (string-to-int (match-string 3 arg))
                 month (string-to-int (match-string (if (> mi di) 2 1) arg))
                 day (string-to-int (match-string (if (> di mi) 1 2) arg)))
           (when (> month 12) (setq month day day month))
           )
          ((string-match "\\([0-9][0-9]\\)[-./]\\([0-9][0-9]?\\)[-./]\\([0-9][0-9]?\\)" arg)
           (setq year (string-to-int (match-string yi arg))
                 month (string-to-int (match-string mi arg))
                 day (string-to-int (match-string di arg)))
           (when (> month 12) (setq month day day month))
           )
          ((string-match "\\([0-9][0-9]\\)/\\([0-9][0-9]\\)" arg)
           ;; Ambiguous:
           ;; MM/DD       Euro
           ;; DD/MM       US
           (let ((a (string-to-int (match-string 1 arg)))
                 (b (string-to-int (match-string 2 arg))))
             (cond ((> a 12) (setq month b day a))
                   ((> b 12) (setq month a day b))
                   ((> di mi) (setq month b day a))
                   (t (setq month a day b))))
           )
          ((string-match (format "%s \\([0-9][0-9]?\\)" month-regexp) arg)
           ;; Ambiguous:
           ;; Month DD
           )
          ((string-match (format "%s,? \\([0-9][0-9][0-9][0-9]\\)" month-regexp) arg)
           ;; Ambiguous:
           ;; Month YYYY
           )
          ((string-match (format "\\([0-9][0-9]?\\) %s" month-regexp) arg)
           ;; DD Month
           )
          ((string-match (format "\\([0-9][0-9]?\\) %s \\([0-9][0-9][0-9][0-9]\\)" month-regexp) arg)
           ;; DD Month YYYY
           )
          ((string-match (format "%s \\([0-9][0-9]?\\), \\([0-9][0-9][0-9]?[0-9]?\\)" month-regexp) arg)
           ;; Month DD, YYYY
           )
          ((string-match (format "\\([0-9][0-9]?\\) %s, \\([0-9][0-9][0-9]?[0-9]?\\)" month-regexp) arg)
           ;; DD Month, YYYY
           )
          ((string-match (format "-\\([0-9]+\\) %s" dmy-regexp) arg)
           ;; -NN days, months, years
           )
          )

    (if (< year lyskom-year-window-start)
        (setq year (+ 2000 year))
      (setq year (+ 1900 year)))

    (list year month day)
    ))


;;; ================================================================
;;; Check noconversion

(defun lyskom-viewing-noconversion ()
  "Return non-nil if we are reviewing in noconversion mode."
  (eq 'kom-review-noconversion lyskom-current-command))


;;; ================================================================
;;; Read membership types

(defun lyskom-read-membership-type ()
  "Interactively read a membership type"
  (let ((invitation (lyskom-j-or-n-p 'mship-type-invitation-q))
        (passive (lyskom-j-or-n-p 'mship-type-passive-q))
        (secret (lyskom-j-or-n-p 'mship-type-secret-q)))
    (lyskom-create-membership-type invitation
                                   passive
                                   secret
                                   nil
                                   nil
                                   nil
                                   nil
                                   nil)))


;;; ================================================================
;;; String truncation
;;;

(defun lyskom-truncate-to-lines (string threshold show-lines &optional width)
  "If STRING is more than THRESHOLD lines on screen, truncate it to  SHOW-LINES.
Optional argument WIDTH is thw window width to use instead of window-width.

This function takes the setting of truncate-lines into account, so
the resulting string may not have SHOW-LINES newline characters.

Result is eq to STRING when no truncation is required.

The result is approximate when truncate-lines is non-nil since different
Emacsen use a different number of characters for the continuation marks
at the end of broken lines. We assume one character continuation marks."
  (let ((line-length (if truncate-lines lyskom-max-int (- (or width (window-width)) 1)))
        (count 0)
        (end nil)
        (pos 0))
    (while (and (< pos (length string)) (< count threshold))
      (setq count (1+ count))
      (let ((next (string-match "\\(\n\\|\\'\\)" string pos)))
        (if (> (- next pos) line-length)
            (setq pos (+ pos line-length))
          (setq pos (match-end 0))))
        (when (= count show-lines)
          (setq end pos)))

    (if (>= count threshold)
        (substring string 0 end)
      string)))


;;; ================================================================
;;; Color model manipulations
;;;
;;; (Of COURSE you need this in a KOM client!)
;;;

(defun lyskom-get-color-highlight (color distance)
  "Create a highlight color for COLOR that is DISTANCE away.
COLOR is a list of R G and B components from 0 to 65535.
DISTANCE is a non-negative integer no larger than 1.0, that in some
way specifies how far away from the original color the new color
should be."
  (when color
    (let* ((hls (lyskom-rgb-to-hls (mapcar (lambda (x) (/ x 65535.0)) color)))
           (l (elt hls 1)))
      (if (> l 0.6)
          (setq l (- l distance))
        (setq l (+ l distance)))
      (cond ((> l 1.0) (setq l 1.0))
            ((< l 0.0) (setq l 0.0)))
      (aset hls 1 l)

      (apply 'format "#%02x%02x%02x"
             (mapcar (lambda (c) (round (* 255 c)))
                     (lyskom-hls-to-rgb hls))))))


(defun lyskom-rgb-to-hls (rgb)
  "Convert a point in RGB color space to a point in HLS color space.

Input value is a vector [R G B], where R, G and B represent red, green
and blue components, respectively. Each value is a non-negative
floating-point value no larger than 1.0.

Output is a vector [H L S], where H, L and S represend hue, lightness
and saturation, respectively. H is in the range 0..360, L and S are
non-negative floating-point numbers no higher than 1.0. If the input
color is a shade of gray (all components are equal), then H in the
output is nil.

Algorithm adapted from Foley, \"Computer Graphics\"."
  (let* ((r (elt rgb 0))
         (g (elt rgb 1))
         (b (elt rgb 2))
         (rgbmin (min r g b))
         (rgbmax (max r g b))
         (h nil)
         (l (/ (+ rgbmax rgbmin) 2.0))
         (s nil)
         (delta (- rgbmax rgbmin)))
    (if (zerop delta)
        (setq s 0.0)
      (if (<= l 0.5)
          (setq s (/ delta (+ rgbmax rgbmin)))
        (setq s (/ delta (- 2.0 rgbmax rgbmin))))
      (cond ((= r rgbmax)
             (setq h (/ (- g b) delta)))
            ((= g rgbmax)
             (setq h (+ 2.0 (/ (- b r) delta))))
            ((= b rgbmax)
             (setq h (+ 4.0 (/ (- r g) delta)))))
      (setq h (* h 60.0))
      (if (< h 0)
          (setq h (+ 360.0 h))))
    (vector h l s)))

(defun lyskom-hls-to-rgb-value (n1 n2 h)
  "Helper function for lyskom-hls-to-rgb"
  (cond ((> h 360) (setq h (- h 360.0)))
        ((< h 0) (setq h (+ h 360.0))))

  (cond ((< h 60)  (+ n1 (* (- n2 n1) (/ h 60.0))))
        ((< h 180) n2)
        ((< h 240) (+ n1 (* (- n2 n1) (/ (- 240.0 h) 60.0))))
        (t n1)))

(defun lyskom-hls-to-rgb (hls)
  "Convert a point in HLS color space to a point in RGB color space.

Input HLS is a vector [H L S], where H, L and S represend hue,
lightness and saturation, respectively. H is in the range 0..360, L
and S are non-negative floating-point numbers no higher than 1.0. If
the input color is a shade of gray (all components are equal), then S
in the input is ignored and may be anything.

Output value is a vector [R G B], where R, G and B represent red,
green and blue components, respectively. Each value is in the range
1..1.0.

This algorithm is adapted from Foley, \"Computer Graphics\" (and
has the bug in that algorithm fixed)."
  (let* ((h (elt hls 0))
         (l (elt hls 1))
         (s (elt hls 2))
         (m2 (if (<= l 0.5)
                 (* l (+ 1.0 s))
               (+ l (* s (- 1 l)))))
         (m1 (- (* 2 l) m2)))
    (if (zerop s)
        (vector l l l)
      (vector (lyskom-hls-to-rgb-value m1 m2 (+ h 120))
              (lyskom-hls-to-rgb-value m1 m2 h)
              (lyskom-hls-to-rgb-value m1 m2 (- h 120))))))


;;; ================================================================
;;; Automatically test that RGB->X and X->RGB color model conversions
;;; really are the inverse of each other.
;;; 
;;; (defun lyskom-test-color-model ()
;;;   (let ((r 0.0)
;;;         (g 0.0)
;;;         (b 0.0)
;;;         (step 0.05))
;;;     (while (<= r 1.0)
;;;       (setq g 0.0)
;;;       (while (<= g 1.0)
;;;         (setq b 0.0)
;;;         (while (<= b 1.0)
;;;           (let ((tmp (lyskom-hls-to-rgb
;;;                       (lyskom-rgb-to-hls (vector r g b)))))
;;;             (unless (and (< (- r (elt tmp 0)) 0.000000001)
;;;                          (< (- g (elt tmp 1)) 0.000000001)
;;;                          (< (- b (elt tmp 2)) 0.000000001))
;;;               (message "Mismatch %1.2f,%1.2f,%1.2f gave %S/%S" r g b (lyskom-rgb-to-hls (vector r g b)) tmp)))
;;;           (setq b (+ b step)))
;;;         (setq g (+ g step)))
;;;       (setq r (+ r step)))))

;;;(defun lyskom-test-auto-colors ()
;;;  (make-face 'test-1)
;;;  (make-face 'test-2)
;;;  (make-face 'test-default)
;;;  (while t
;;;    (let ((foreground (read-from-minibuffer "Foreground: "))
;;;          (background (read-from-minibuffer "Background: ")))
;;;      (pop-to-buffer (get-buffer-create "*kom*-test"))
;;;      (erase-buffer)
;;;      (set-face-foreground 'test-default foreground)
;;;      (set-face-background 'test-default background)
;;;      (set-face-background 'test-1 (lyskom-get-color-highlight (x-color-values background) 0.05))
;;;      (set-face-background 'test-2 (lyskom-get-color-highlight (x-color-values background) 0.025))
;;;      (let ((lyskom-buffer (current-buffer)))
;;;        (lyskom-format-insert "\
;;;%#3@Lsa nsta fotnot...
;;;8408827 idag 00:40 /1 rad/ Lunkwill/CH ( Auf das Universum! )
;;;Fotnot till text 8408825 av Lunkwill/CH ( Auf das Universum! )
;;;Mottagare: Ntverk, Internet, LysNET, Sunet... <30873>
;;;Mottagare: SUBnet (Stngstadens och LiU:s) studentbostadsnt <12152>
;;;Mottagare: Lunkwill/CH ( Auf das Universum! ) <2092>
;;;rende: Vrmtet
;;;%[%#1$------------------------------------------------------------
;;;%]%[%#2$Och tack s mycket fr frklaringarna! =)
;;;%]%[%#1$(8408827) /Lunkwill/CH ( Auf das Universum! )/------
;;;%]G till nsta mte...
;;;SUN erfarenhetsutbyte - 1 olst
;;;Lsa nsta text...
;;;8408823 idag 00:39 /4 rader/ Erik Persson, Lysato(r)
;;;Kommentar till text 8407161 av Dejan (ngot desperat)
;;;Mottagare: SUN erfarenhetsutbyte <23622>
;;;rende: Skapa partitionstabell
;;;%[%#1$------------------------------------------------------------
;;;%]%[%#2$Om du nu vill spela Fibre Channel med IDE-RAID s gr du ver n efter
;;;vatten. Det finns redan IDE-RAID med FC-interface.  Dock har jag inte
;;;sett ngon som stdjer ngot annat n FC-AL vilket r lite
;;;begrnsande.
;;;%]%[%#1$(8408823) ------------------------------------------
;;;%]G till nsta mte...
;;;
;;;
;;;
;;;"
;;;                              '(face test-1)
;;;                              '(face test-2)
;;;                              '(face test-default))))))
;;;
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: completing-read.el,v 44.37 2002/02/24 20:23:26 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: completing-read.el
;;;; Author: David Byers
;;;;
;;;; This file implements functions for reading a conference name
;;;; or a person name with completion and other help.
;;;;

(setq lyskom-clientversion-long 
      (concat
       lyskom-clientversion-long
       "$Id: completing-read.el,v 44.37 2002/02/24 20:23:26 joel Exp $\n"))

(defvar lyskom-name-hist nil)



;;; ============================================================
;;;
;;; Name lookup caches
;;;

(defvar lyskom-completing-who-info-cache nil
  "Temporary cache of who-info data")

(defvar lyskom-completing-lookup-name-cache nil
  "Temporary cache of server queries")

(defvar lyskom-completing-use-dynamic-info nil)

(defun lyskom-completing-clear-cache ()
  (setq lyskom-completing-who-info-cache nil)
  (setq lyskom-completing-lookup-name-cache nil))

(defun lyskom-completing-who-is-on ()
  "Get information about who is on, first checking the cache. Returns what 
\(blocking-do 'who-is-on\) would, but as a list, not a vector"
  (if lyskom-completing-who-info-cache
      lyskom-completing-who-info-cache
    (setq lyskom-completing-who-info-cache
          (listify-vector
	   (if (lyskom-have-feature dynamic-session-info)
	       (blocking-do 'who-is-on-dynamic t t 0)
	     (blocking-do 'who-is-on))))))

(defun lyskom-completing-cache-completion (string data)
  (let* ((downs (lyskom-unicase string))
         (tmp (assoc downs lyskom-completing-lookup-name-cache)))
    (if (null tmp)
        (setq lyskom-completing-lookup-name-cache
              (cons (cons downs data) lyskom-completing-lookup-name-cache)))
    string))

(defun lyskom-completing-lookup-z-name (string want-conf want-pers)
  "Look up STRING as a name. Same as \(blocking-do 'lookup-z-name ...\)
but first checks a cache."
  (if (and (eq 0 want-conf)
           (eq 0 want-pers))
      nil
    (let* ((downs (lyskom-unicase string))
           (tmp (assoc downs lyskom-completing-lookup-name-cache)))
      (if tmp
          (cdr tmp)
        (progn
          (setq tmp (blocking-do 'lookup-z-name string want-pers want-conf))
          (setq lyskom-completing-lookup-name-cache
                (cons (cons downs tmp)
                      lyskom-completing-lookup-name-cache))
          tmp)))))

;;; ============================================================
;;;
;;; Keymaps
;;;


(defvar lyskom-minibuffer-local-completion-map
  (let ((map (copy-keymap minibuffer-local-completion-map)))
    (define-key map " " nil)
    map)
  "Keymap used for reading LysKOM names.")

(defvar lyskom-minibuffer-local-must-match-map
  (let ((map (copy-keymap minibuffer-local-must-match-map)))
    (lyskom-xemacs-or-gnu 
     (set-keymap-parent map lyskom-minibuffer-local-completion-map)
     (define-key map " " nil))
    map)
  "Keymap used for reading LysKOM names.")

(defsubst lyskom-completing-match-string-regexp (string)
  (concat "^"
          (replace-in-string (regexp-quote (lyskom-unicase (lyskom-completing-strip-name string)))
                             "\\s-+" "\\\\S-*\\\\s-+")
          "\\s-*"))

(defsubst lyskom-completing-match-string (string name)
  "Return non-nil if STRING matches NAME using LysKOM completion rules."
  (string-match (lyskom-completing-match-string-regexp string)
                (lyskom-completing-strip-name (lyskom-unicase name))))


(defun lyskom-read-conf-no (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its number or zero if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) 0)
          ((stringp conf-z-info) 0)
	  ((lyskom-conf-stat-p conf-z-info) (conf-stat->conf-no conf-z-info))
	  ((lyskom-uconf-stat-p conf-z-info) (uconf-stat->conf-no conf-z-info))
          (t (conf-z-info->conf-no conf-z-info)))))

(defun lyskom-read-conf-stat (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its conf-stat or nil if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) nil)
          ((stringp conf-z-info) nil)
	  ((lyskom-conf-stat-p conf-z-info) conf-z-info)
          ((lyskom-uconf-stat-p conf-z-info) 
           (blocking-do 'get-conf-stat (uconf-stat->conf-no conf-z-info)))
          (t (blocking-do 'get-conf-stat 
                          (conf-z-info->conf-no conf-z-info))))))

(defun lyskom-read-uconf-stat (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its conf-stat or nil if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) nil)
          ((stringp conf-z-info) nil)
	  ((lyskom-uconf-stat-p conf-z-info) conf-z-info)
	  ((lyskom-conf-stat-p conf-z-info)
           (blocking-do 'get-uconf-stat 
                        (conf-stat->conf-no conf-z-info)))
          (t (blocking-do 'get-uconf-stat 
                          (conf-z-info->conf-no conf-z-info))))))

(defun lyskom-read-conf-name (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its name.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) "")
          ((stringp conf-z-info) conf-z-info)
	  ((lyskom-conf-stat-p conf-z-info) (conf-stat->name conf-z-info))
	  ((lyskom-uconf-stat-p conf-z-info) (uconf-stat->name conf-z-info))
	  (t (conf-z-info->name conf-z-info)))))

(defun lyskom-read-conf (prompt type &optional empty initial mustmatch)
  "Completing read a conference or person from the minibuffer. 

PROMPT is the prompt type type.
TYPE   is the type of conferences to return. It is a list of one or
more of the following:
    all     Return any conference,
    conf    Return conferences (not letterboxes),
    pers    Return persons (letterboxes),
    login   Return persons who are also logged-in, and
    none    Return names that do not match anything in the database.
    (restrict c1 c2 ...) Restrict matching to conference numbers c1, 
            c2 etc. The implementation is inefficient for long lists.

Optional arguments
EMPTY     allow nothing to be entered.
INITIAL   initial contents of the minibuffer
MUSTMATCH if non-nil, the user must enter a valid name.

The return value may be one of
A conf-z-info: The conf-z-info associated with the name entered,
nil:         Nothing was entered, or
A string:    A name that matched nothing in the database."

  (lyskom-completing-clear-cache)
  (let* ((completion-ignore-case t)
         (minibuffer-local-completion-map 
          lyskom-minibuffer-local-completion-map)
         (minibuffer-local-must-match-map 
          lyskom-minibuffer-local-must-match-map)
         (read-string nil)
         (result nil)
         (keep-going t))

    (while keep-going
      (lyskom-with-lyskom-minibuffer
       (setq read-string (completing-read (cond ((stringp prompt) prompt)
                                                ((symbolp prompt) (lyskom-get-string prompt))
                                                (t (lyskom-get-string 'conf-prompt)))
                                          'lyskom-read-conf-internal
                                          type
                                          mustmatch
                                          initial
                                          'lyskom-name-hist)))
      (setq result
            (cond ((null read-string) nil)
                  ((string= "" read-string) nil)
                  (t (lyskom-lookup-conf-by-name read-string type))))
      (setq keep-going (and (not empty)
                            (null result))))
    result))


(defun lyskom-read-conf-get-logins ()
  "Used internally by lyskom-read-conf-internal to get a list of
persons who are logged on."
  (mapcar (if (lyskom-have-feature dynamic-session-info)
              (function (lambda (el) (dynamic-session-info->person el)))
            (function (lambda (el) (who-info->pers-no el))))
          (lyskom-completing-who-is-on)))


(defun lyskom-read-conf-expand-specials (string
                                         predicate
                                         login-list
                                         x-list
                                         &optional return-cs)
  "Used internally by lyskom-read-conf-internal to expand person and
conference number specifications to something useful."
  (cond ((string-match (lyskom-get-string 'person-or-conf-no-regexp) string)
         (let* ((no (string-to-int (match-string 1 string)))
                (cs (blocking-do 'get-uconf-stat no)))
           (if (and cs
                    (lyskom-read-conf-internal-verify-type
                     (uconf-stat->conf-no cs)
                     (uconf-stat->conf-type cs)
                     predicate 
                     login-list
                     x-list))
               (if return-cs
                   cs
                 (list string)))))
        ((string-match (lyskom-get-string 'session-no-regexp) string)
         (let* ((no (string-to-int (match-string 1 string)))
                (si (blocking-do 'get-session-info no))
                (cs (and si
                         (blocking-do 'get-uconf-stat
                                      (session-info->pers-no si)))))
           (if (and cs
                    (lyskom-read-conf-internal-verify-type
                     (uconf-stat->conf-no cs)
                     (uconf-stat->conf-type cs)
                     predicate 
                     login-list
                     x-list))
               (if return-cs
                   cs
                 (list string)))))))

(defun lyskom-read-conf-lookup-specials (string predicate login-list x-list)
  "Used internally by lyskom-read-conf-internal to look up conf-stats
from person and conference number specifications."
  (let ((cs (lyskom-read-conf-expand-specials string
                                              predicate
                                              login-list
                                              x-list
                                              t)))
    (lyskom-create-conf-z-info (uconf-stat->name cs)
                               (uconf-stat->conf-type cs)
                               (uconf-stat->conf-no cs))))

(defun lyskom-lookup-conf-by-name (string predicate)
  "Return the conf-z-info associated with STRING that also satisfies
PREDICATE or nil if no name matches. See lyskom-read-conf-internal for
a documentation of PREDICATE."
  (if (string= string "")
      nil
    (lyskom-read-conf-internal string predicate 'lyskom-lookup)))


(defun lyskom-read-conf-internal (string predicate all)
  "Complete the name STRING according to PREDICATE and ALL.

STRING is a string to complete.
PREDICATE is a list of name types to return. See lyskom-read-conf for
details.
ALL is set by try-completion and all-completions. See the Emacs lisp
manual for a description. Special value 'lyskom-lookup makes the
function work as a name-to-conf-stat translator."

  ;;
  ;;  Catch some degenerate cases that can cause...problems. This
  ;;  won't solve all the...problems, but should speed things up a
  ;;  little bit.
  ;;

  (cond 
   ((and (null all)
         (string-match "^\\s-*$" string)) "")
   ((and (eq all 'lyskom-lookup)
         (string-match "^\\s-*$" string)) nil)
   ((and (eq all 'lambda)
         (string-match "^\\s-*$" string)) nil)
   (t

    (let* ((login-list (and (memq 'login predicate)
                            (lyskom-read-conf-get-logins)))
           (x-list (lyskom-completing-lookup-z-name string 
                                                    (if (or (memq 'all predicate)
                                                            (memq 'conf predicate)
                                                            (memq 'none predicate)) 1 0)
                                                    (if (or (memq 'all predicate)
                                                            (memq 'pers predicate)
                                                            (memq 'none predicate)
                                                            (memq 'login predicate)) 1 0)))
           (r-list (when (assq 'restrict predicate)
                     (let ((result (make-collector)))
                       (lyskom-traverse conf-no (cdr (assq 'restrict predicate))
                         (initiate-get-uconf-stat 'main 'collector-push 
                                                  conf-no result))
                       (lyskom-wait-queue 'main)
                       (delq nil
                             (mapcar (lambda (conf-stat)
                                       (when (lyskom-completing-match-string string (conf-stat->name conf-stat))
                                         (lyskom-create-conf-z-info
                                          (conf-stat->name conf-stat)
                                          (conf-stat->conf-type conf-stat)
                                          (conf-stat->conf-no conf-stat))))
                               (collector->value result))))))
           (candidate-list 
            (append r-list
                   (if x-list
                       (conf-z-info-list->conf-z-infos x-list))))
           (result-list nil))

      ;;
      ;;  login-list now contains a list of logins, IF the predicate
      ;;  includes 'login
      ;;
      ;;  candidate-list contains a list of conf-z-infos
      ;;
      ;;  Now set result-list to the conf-z-infos that fulfill the
      ;;  predicate, fetching the conf-stats asynchronously.
      ;;

      (lyskom-traverse el candidate-list
        (if (lyskom-read-conf-internal-verify-type (conf-z-info->conf-no el)
                                                   (conf-z-info->conf-type el)
                                                   predicate
                                                   login-list
                                                   candidate-list)
            (setq result-list (cons el result-list))))
      

      ;;
      ;;  Now the matching conf-z-infos are in result-list
      ;;

      (cond 
       ((eq all 'lyskom-lookup)
        (let ((names (mapcar 'conf-z-info->name 
                             result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))

          (cond ((and kom-complete-numbers-before-names specials)
                 (lyskom-read-conf-lookup-specials string
                                                   predicate
                                                   login-list
                                                   candidate-list))
                ((= (length result-list) 1)
                 (car result-list))

                ((and (> (length result-list) 1)
                      (lyskom-completing-member string names))
                 (elt result-list
                      (- (length result-list)
                         (length (lyskom-completing-member string names)))))

                (specials (lyskom-read-conf-lookup-specials string
                                                            predicate
                                                            login-list
                                                            candidate-list))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 string))))
     
       ;;
       ;;  Check for exact match. We have an exact match in the server
       ;;  when there was a single match OR when there was no match, and
       ;;  no match is valid according to predicate
       ;;

       ((eq all 'lambda)
        (let ((specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond ((= (length result-list) 1) t)
                ((and (> (length result-list) 1)
                      (let ((names (mapcar 'conf-z-info->name
                                           result-list)))
                        (and (lyskom-completing-member string names)
                             t))))
                (result-list nil)
                ((= (length specials) 1) t)
                (specials nil)
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)

                (t (lyskom-read-conf-internal-verify-type nil
                                                          nil
                                                          predicate
                                                          login-list
                                                          candidate-list)))))


       ;;
       ;;  Called from all-completions. Return a list of all possible
       ;;  completions, in this case all names in the result list plus,
       ;;  if the input string is a person or conf number specification,
       ;;  the input string, PROVIDED, the requested conference matches
       ;;  the predicate. If there were no matches, return the input
       ;;  string if no matches satisfies the predicate.
       ;;
          
       (all
        (let ((names (mapcar 'conf-z-info->name result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond (specials (append specials names))
                (names names)
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 (list string))
                (t nil))))

       ;;
       ;;  Called from try-completion, and there were no matches. Try to
       ;;  expand the input string as a person or conf number
       ;;  specification or return something sensible if the predicate
       ;;  is satisfied by no matches.
       ;;

       ((null result-list)
        (let ((specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond (specials (car specials))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 t)
                (t nil))))

       ;;
       ;;  Called from try-completion, and there were matches in the
       ;;  server. Return t if the string is an exact match to any
       ;;  string returned from the server. Otherwise, expand the string
       ;;  as far as possible and return that
       ;;

       (t
        (let ((name-list (mapcar 'conf-z-info->name result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (if specials (setq name-list (nconc specials name-list)))

          (cond ((lyskom-completing-member string name-list) 
                 (or (and (= (length name-list) 1) t) string)) ; Exact match
                ((= (length name-list) 1) (car name-list))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                (t (or (lyskom-completing-cache-completion
                        (lyskom-complete-string name-list)
                        (if r-list
                            (lyskom-create-conf-z-info-list
                             (apply 'vector candidate-list))
                          x-list))
                       (and (lyskom-read-conf-internal-verify-type 
                             nil
                             nil
                             predicate
                             login-list
                             candidate-list)
                            (list string))))))))))))
        

(defun lyskom-completing-member (string list)
  (let ((string (lyskom-unicase (lyskom-completing-strip-name string)))
        (result nil))
    (while (and list (not result))
      (if (lyskom-string= string (lyskom-unicase 
                           (lyskom-completing-strip-name (car list))))
          (setq result list)
        (setq list (cdr list))))
    result))


(defun lyskom-completing-strip-name (string)
  "Strip parens and crap from a name."
  (while (string-match "([^()]*)" string)
    (setq string (replace-match " " t t string)))
  (while (string-match "\\s-\\s-+" string)
    (setq string (replace-match " " t t string)))
  (while (string-match "([^()]*$" string)
    (setq string (substring string 0 (match-beginning 0))))
  (if (string-match "^\\s-*\\(.*\\S-\\)\\s-*$" string)
      (match-string 1 string)
    string))


(defun lyskom-read-conf-internal-verify-type (conf-no
                                              conf-type
                                              predicate
                                              logins
                                              x-list)
  (or (memq conf-no (cdr (assq 'restrict predicate)))
      (and (memq 'all predicate)
           conf-no)
      (and (memq 'conf predicate)
           conf-type
           (not (conf-type->letterbox conf-type)))
      (and (memq 'pers predicate) 
           conf-type
           (conf-type->letterbox conf-type))
      (and (memq 'login predicate)
           conf-type
           (memq conf-no logins))
      (and (memq 'none predicate) 
           (and (null conf-no)
                (null x-list)))))


; (defun lyskom-complete-show-data-list (state data)
;   (save-excursion
;     (pop-to-buffer (get-buffer-create "*kom*-complete"))
;     (erase-buffer)
;     (set-buffer-multibyte nil)
;    (while data
;       (insert
;        (format "%s\n" (substring (aref (car data) 2)
;                                  (aref (car data) 0)
;                                  (aref (car data) 1))))
;       (setq data (cdr data)))
;     (insert (format "%S %S: %S" (symbol-value current-state)
;                     (elt state 0)
;                     (elt state 1)))
;     (sit-for 5)))
      

(defun lyskom-complete-string (string-list)
  "Find the longest common prefix of all strings in STRING-LIST according to
the LysKOM rules of string matching."
  (let ((main-state 'start-of-string)
        (tmp-state nil)
        (current-state 'main-state)
        (main-accumulator nil)
        (tmp-accumulator nil)
        (current-accumulator 'main-accumulator)
        (done nil)
        (paren-depth 0)
        (have-here nil)
        (last-event-worth-noting nil)
        (data-list (lyskom-complete-string-munge-input string-list))
        (next-char-state (vector nil nil)))

    (while (not done)
      (lyskom-complete-string-next-char next-char-state data-list)
;      (lyskom-complete-show-data-list next-char-state data-list)
      (cond

       ;;
       ;; Case one, a match of two non-special characters.
       ;; Accumulate one character and advance the lists
       ;;

       ((eq (aref next-char-state 0) 'match)
        (if (eq (aref next-char-state 1) ?\ )
            (progn
              (cond ((memq (symbol-value current-state)
			     '(start-of-word start-of-string))
                     nil)
                    ((eq last-event-worth-noting 'mismatch)
                     (lyskom-complete-string-accumulate current-accumulator
                                                        'SPC))
                    (t
                     (lyskom-complete-string-accumulate current-accumulator
                                                        ?\ )))
              (set current-state 'start-of-word)
              (lyskom-complete-string-advance data-list))
          (progn
            (set current-state 'in-a-word)
            (lyskom-complete-string-accumulate current-accumulator
                                               (aref next-char-state 1))
            (lyskom-complete-string-advance data-list)))
        (setq last-event-worth-noting 'match))
       
       ;;
       ;; Case two, a match of two open-paren expressions Increase
       ;; paren depth and accumulate a character. First set
       ;; current-accumulator to the temporary if paren-depth is zero
       ;; to start with.
       ;;

       ((eq (aref next-char-state 0) 'open-paren-match)
        (setq last-event-worth-noting 'match)
        (if (zerop paren-depth)
            (progn
              (setq current-accumulator 'tmp-accumulator)
              (setq current-state 'tmp-state)
              (setq tmp-state main-state)
              (setq tmp-accumulator nil)))
        (setq paren-depth (1+ paren-depth))
        (lyskom-complete-string-accumulate current-accumulator
                                    (aref next-char-state 1))
        (lyskom-complete-string-advance data-list))

       ;;
       ;; Case three, a match of two close-paren expressions
       ;; Accumulate a character. If paren-depth is postitive,
       ;; decrease it. If it ends up zero, add the temporary
       ;; accumulator to the main accumulator and set the current
       ;; accumulator to the main accumulator.
       ;;

       ((eq (aref next-char-state 0) 'close-paren-match)
        (setq last-event-worth-noting 'match)
        (lyskom-complete-string-accumulate current-accumulator
                                    (aref next-char-state 1))
        (if (> paren-depth 0)
            (progn
              (setq paren-depth (1- paren-depth))
              (if (zerop paren-depth)
                  (progn
                    (setq main-accumulator
                          (nconc tmp-accumulator main-accumulator))
                    (setq main-state tmp-state)
                    (setq current-state 'main-state)
                    (setq current-accumulator 'main-accumulator)))))
        (lyskom-complete-string-advance data-list))

       ;;
       ;; Case two, a mismatch of any kind in a paren expression
       ;;

       ((and (> paren-depth 0)
             (memq (aref next-char-state 0)
		     '(mismatch space-mismatch open-paren-mismatch)))
        (setq last-event-worth-noting 'mismatch)
        (setq tmp-accumulator nil)
        (setq tmp-state nil)
        (setq current-state 'main-state)
        (setq current-accumulator 'main-accumulator)
        (lyskom-complete-string-close-parens data-list paren-depth)
        (setq paren-depth 0))

       ;;
       ;; Case two and a half or so, a space mismatch. This is ignored
       ;; if we're still at the start of the string
       ;;
       
       ((and (eq (aref next-char-state 0) 'space-mismatch)
             (memq (symbol-value current-state)
		     '(start-of-string start-of-word)))
        (setq last-event-worth-noting nil)
        (lyskom-complete-string-skip-whitespace data-list))

       ;;
       ;; Case three, a mismatch of regular characters outside a paren
       ;; Advance to the end of the current word
       ;;

       ((and (memq (aref next-char-state 0) '(mismatch space-mismatch))
             (zerop paren-depth))
        (setq last-event-worth-noting 'mismatch)
        (if (memq (symbol-value current-state)
		    '(start-of-word start-of-string))
            (setq done t)
          (progn
            (if (not have-here)
                (progn
                  (lyskom-complete-string-accumulate current-accumulator 
                                                     'HERE)
                  (setq have-here t)))
            (lyskom-complete-string-advance-to-end-of-word data-list)
            (set current-state 'in-a-word))))

       ;;
       ;; Case four, a mistmatch where one character is an open-paren
       ;;

       ((eq (aref next-char-state 0) 'open-paren-mismatch)
        (setq last-event-worth-noting 'mismatch)
        (lyskom-complete-string-skip-parens data-list))


       ;;
       ;; Case five, eof
       ;;

       ((eq (aref next-char-state 0) 'eof)
        (setq done t))

       ;;
       ;; Case six, can't happen
       ;;

       (t (error "This can't happen: %S" next-char-state))))

    ;;
    ;; Build the result by reversing the result list and making a
    ;; string out of it.
    ;;

    (if (eq (car main-accumulator) 'SPC)
        (setq main-accumulator (cdr main-accumulator)))

    (setq main-accumulator (nreverse main-accumulator))

    (if (memq 'HERE main-accumulator)
        (let ((backup (length (memq 'HERE main-accumulator))))
          (if lyskom-experimental-features
              (setq unread-command-events
                    (append (cons ? (make-list (1- backup) 2))
                            unread-command-events)))
          (setq main-accumulator (delq 'HERE main-accumulator))))
    
    (concat (mapcar (lambda (el) (if (eq el 'SPC) ?\  el))
		    main-accumulator))))


(defun lyskom-complete-string-accumulate (accumulator char)
  (set accumulator (cons char (symbol-value accumulator))))

(defun lyskom-complete-string-munge-input (string-list)
  (mapcar (function
           (lambda (x)
             (vector 0 (length x) x)))
          string-list))

;;;
;;; Advance one regular character or multiple whitespaces
;;;

(defun lyskom-complete-string-advance (data-list)
  (lyskom-traverse 
   el data-list
   (string-match "\\([ \t]+\\|[^ \t]\\|$\\)"
                 (aref el 2)
                 (aref el 0))
   (aset el 0 (match-end 0))))

(defun lyskom-complete-string-skip-whitespace (data-list)
  (lyskom-traverse
   el data-list
   (string-match "[ \t]*" (aref el 2) (aref el 0))
   (aset el 0 (match-end 0))))

;;;
;;; Advance to the end of the current word
;;;

(defun lyskom-complete-string-advance-to-end-of-word (data-list)
  (lyskom-traverse
   el data-list
   (aset el 0 (string-match "\\([ \t]\\|$\\)" 
                            (aref el 2)
                            (aref el 0)))))

;;;
;;; Unwind a number of parens
;;;

(defun lyskom-complete-string-skip-parens (data-list)
  (lyskom-traverse
   el data-list
   (if (eq ?\( (aref (aref el 2) (aref el 0)))
       (progn
         (aset el 0 (1+ (aref el 0)))
         (lyskom-complete-string-close-parens-2 el 1)))))

(defun lyskom-complete-string-close-parens (data-list depth)
  (lyskom-traverse
   el data-list
   (lyskom-complete-string-close-parens-2 el depth)))

(defun lyskom-complete-string-close-parens-2 (el depth)
  (let ((string (aref el 2))
        (pos (aref el 0)))
    (while (> depth 0)
      (cond ((>= pos (length string)) 
             (setq depth 0))
            ((eq (aref string pos) ?\))
             (setq depth (1- depth)))
            ((eq (aref string pos) ?\))
             (setq depth (1+ depth))))
      (setq pos (1+ pos)))
    (aset el 0 pos)))


;;;
;;; Check what's happenin' next
;;;

(defun lyskom-complete-string-next-char (state data-list)
  (let ((eofp nil)
        (open-paren-p nil)
        (close-paren-p nil)
        (matchp t)
        (spacep nil)
        (char nil)
        (xchar nil))

    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (mapcar
      (function 
       (lambda (x)
         (cond ((>= (aref x 0) (aref x 1))
                (setq eofp t)
                (setq matchp nil))
               ((eq (aref (aref x 2) (aref x 0)) ?\()
                (setq open-paren-p t))
               ((eq (aref (aref x 2) (aref x 0)) ?\))
                (setq close-paren-p t))
               ((eq (aref (aref x 2) (aref x 0)) ?\ )
                (setq spacep t)))

         (setq matchp (and matchp
                           (if (null char)
                               (progn
                                 (setq xchar (aref (aref x 2)
                                                   (aref x 0)))
                                 (setq char (lyskom-unicase-char xchar)))
                             (eq char (lyskom-unicase-char
                                       (aref (aref x 2)
                                             (aref x 0)))))))))
      data-list))

    (aset state 1 xchar)
    (cond (eofp (aset state 0 'eof))
          ((and matchp open-paren-p)
           (aset state 0 'open-paren-match))
          ((and matchp close-paren-p)
           (aset state 0 'close-paren-match))
          (matchp
           (aset state 0 'match))
          (spacep
           (aset state 0 'space-mismatch))
          (open-paren-p
           (aset state 0 'open-paren-mismatch))
          (t
           (aset state 0 'mismatch))))
  state)








;;; ============================================================
;;;
;;; Session reading
;;;
;;;



(defun lyskom-read-session-no (prompt &optional empty initial only-one)
  (let ((possible-matches
         (lyskom-session-from-conf
          (lyskom-read-conf-no prompt
                               (if kom-permissive-completion
                                   '(pers)
                                 '(login))
                               empty
                               initial
                               t))))
    (if (and (> (length possible-matches) 1)
             only-one)
        (lyskom-read-session-resolve-ambiguity possible-matches)
      possible-matches)))


(defun lyskom-session-from-conf (conf-no)
  (let ((who-list (lyskom-completing-who-is-on))
        (sessions nil))
    (if (lyskom-have-feature dynamic-session-info)
	(while who-list
	  (if (eq (dynamic-session-info->person (car who-list)) conf-no)
	      (setq sessions (cons (dynamic-session-info->session
				    (car who-list))
				   sessions)))
	  (setq who-list (cdr who-list)))
      (while who-list
	(if (eq (who-info->pers-no (car who-list))
		conf-no)
	    (setq sessions (cons (who-info->connection (car who-list))
				 sessions)))
	(setq who-list (cdr who-list))))
    (cond ((and (null sessions) kom-permissive-completion) (list (- conf-no)))
          (t sessions))))


(defun lyskom-read-session-resolve-ambiguity (sessions)
  (lyskom-insert "\n")
  (let* ((s-width (1+ (apply 'max (mapcar (function
					   (lambda (x)
					     (string-width (int-to-string x))))
					  sessions))))
	 (format-string-s (lyskom-info-line-format-string s-width "s" "s"))
	 (format-string-p (lyskom-info-line-format-string s-width "P" "M")))
    (lyskom-format-insert format-string-s
			  ""
			  (lyskom-get-string 'lyskom-name)
			  (lyskom-get-string 'is-in-conf))
    (lyskom-format-insert format-string-s
			  ""
			  (lyskom-get-string 'from-machine)
			  (lyskom-get-string 'is-doing))
    (lyskom-insert
     (concat (make-string (- (lyskom-window-width) 2) ?-)
	     "\n"))
    (let ((result nil)
	  (who-info
	   (mapcar (function
		    (lambda (el)
		      (let* ((info (blocking-do 'get-session-info el))
			     (confconfstat
			      (blocking-do 'get-uconf-stat
					   (session-info->working-conf info))))
			(lyskom-format-insert
			 format-string-p
			 (format "%d%s"
				 (session-info->connection info)
				 (if (eq (session-info->connection info)
					 lyskom-session-no)
				     "*" " "))
			 (session-info->pers-no info)
			 (or confconfstat
                             (lyskom-get-string 'not-present-anywhere)))
			(lyskom-format-insert
			 format-string-p
			 ""
			 (lyskom-return-username info)
			 (concat "("
				 (session-info->doing info)
				 ")"))
			(cons (number-to-string
			       (session-info->connection info))
			      info))))
		   (sort sessions '<))))
      (lyskom-insert (concat (make-string (- (lyskom-window-width) 2) ?-)
			     "\n"))
      (lyskom-insert (lyskom-format 'total-users-sans-date (length who-info)))
      (lyskom-scroll)
      (while (string= ""
                      (lyskom-with-lyskom-minibuffer
                       (setq result (lyskom-completing-read
				    (lyskom-get-string 'resolve-session)
				    (lyskom-maybe-frob-completion-table 
				     who-info)
				    nil
				    t
				    (car (car who-info))
				    nil)))))
      (list (session-info->connection (cdr (assoc result who-info)))))))



;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: keyboard-menu.el,v 44.2 2002/06/29 20:29:20 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: keyboard-menu.el
;;;;
;;;; Implements completing-read almost-compatible lyskom-read-from-menu
;;;; used to implement keyboard navigation of LysKOM menus ('cos tmm
;;;; was *so* ugly).
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: keyboard-menu.el,v 44.2 2002/06/29 20:29:20 byers Exp $\n"))

(defvar lyskom-keyboard-menu-menu)
(defvar lyskom-keyboard-menu-buffer)
(defvar lyskom-keyboard-menu-prompt)
(defvar lyskom-keyboard-menu-selection)
(defvar lyskom-keyboard-menu-overlay)

(defvar lyskom-keyboard-menu-keymap nil)

(defun lyskom-keyboard-menu-read-char (prompt)
  "Read a single keyboard event from the keyboard.
Like read-event in Gnu Emacs or next-command-event in XEmacs."
  (message prompt)
  (sit-for 0)
  (lyskom-xemacs-or-gnu
   (let ((ev (next-command-event nil prompt)))
	    (when (eq 'key-press (event-type ev))
	      (cond ((eq (event-key ev) 'return) 'return)
		    ((event-to-character ev))
		    ((event-key ev))
		    (t nil))))
   (read-event)))

(defun lyskom-keyboard-menu-keys-for-string (string)
  "Return a list of suitable mnemonics for menu item STRING."
  (let ((a-uc nil)
        (a-lc nil)
        (b-uc nil)
        (b-lc nil)
        (c-uc nil)
        (c-lc nil))
    (lyskom-traverse word (string-split " " string)
      (unless (eq (elt word 0) ?\()
        (setq a-lc (cons (downcase (substring word 0 1)) a-lc)
              a-uc (cons (upcase (substring word 0 1)) a-uc))
        (when (> (length word) 1)
          (setq b-lc (cons (downcase (substring word 1 2)) b-lc)
                b-uc (cons (upcase (substring word 1 2)) b-uc)))
        (when (> (length word) 2)
          c-lc (cons (downcase (substring word 2 3)) c-lc)
          c-uc (cons (upcase (substring word 2 3)) c-uc))
        ))
    (mapcar (lambda (s)
              (lyskom-xemacs-or-gnu
               s
               (encode-coding-string s default-keyboard-coding-system)))
            (nconc (nreverse a-lc)
                   (nreverse b-lc)
                   (nreverse c-lc)
                   (nreverse a-uc)
                   (nreverse b-uc)
                   (nreverse c-uc)
                   ))))


(defun lyskom-keyboard-menu-frob-table (table)
  "Convert TABLE to a form suitable for keyboard menus.
TABLE is an alist whose elements' cars are strings. The result will
be an alist whose elements' cars are mnemonics for the string in the
same element's cdr."
  (let ((used-keys nil)
        (default-keys "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
        (default-keys-index 0))
    (nconc
     (mapcar 
      (lambda (element)
        (let* ((string (car element))
               (keys (lyskom-keyboard-menu-keys-for-string string))
               (mnemonic (lyskom-traverse key keys
                           (unless (member key used-keys)
                             (lyskom-traverse-break key)))))

          (while (and (not mnemonic)
                      (< default-keys-index (length default-keys)))
            (let ((key (substring default-keys 
                                  default-keys-index
                                  (1+ default-keys-index))))
              (unless (member key used-keys)
                (setq mnemonic key))))

          (setq used-keys (cons mnemonic used-keys))
          (list mnemonic string element)))
      table)
     (list (list "C-g" (lyskom-get-string 'keyboard-cancel) nil)))))



(defun lyskom-keyboard-menu-highlight-selected ()
  "Highlight the selected menu item"
  (set-buffer lyskom-keyboard-menu-buffer)
  (let ((pos (text-property-any (point-min) 
                                (point-max)
                                'lyskom-keyboard-menu-item
                                lyskom-keyboard-menu-selection)))
    (cond ((or (null pos)
               (null lyskom-keyboard-menu-selection))
           (lyskom-xemacs-or-gnu
            (set-extent-face lyskom-keyboard-menu-overlay nil)
            (overlay-put lyskom-keyboard-menu-overlay 'face nil))
           (goto-char (point-min)))
          (t (let ((start pos)
                   (end (or (next-single-property-change 
                             pos
                             'lyskom-keyboard-menu-item)
                            (point-max))))
               (lyskom-xemacs-or-gnu
                (set-extent-endpoints lyskom-keyboard-menu-overlay
                                      start end)
                (move-overlay lyskom-keyboard-menu-overlay
                              start end)))
             (goto-char pos)
             (lyskom-xemacs-or-gnu
              (set-extent-face lyskom-keyboard-menu-overlay 'kom-mark-face)
              (overlay-put lyskom-keyboard-menu-overlay
                           'face 'kom-mark-face))))
    (save-excursion
      (unless (pos-visible-in-window-p pos)
        (recenter)))))


(defun lyskom-keyboard-menu-format-item (item &optional pad-len)
  "Format a single menu item as a string"
  (let ((string (format "%s (%s)" (elt item 1) (elt item 0))))
    (when (and pad-len (> pad-len (length string)))
      (setq string (concat string (make-string (- pad-len (length string))
                                               ?\ ))))
    (add-text-properties 0 
                         (length string)
                         (list 'lyskom-keyboard-menu-item item)
                         string)
    string))

(defun lyskom-keyboard-menu-insert (prompt menu)
  "Insert the text-based representation of the menu.
PROMPT is the menu title and MENU is the menu data."
  (let* ((line-length (apply 'max
                             (mapcar (lambda (x)
                                       (+ (length (elt x 0))
                                          (length (elt x 1))
                                          3))
                                     menu)))
         (columns (/ (+ (window-width) 1)
                     (+ line-length 2)))
         (dashes (make-string (+ (* line-length columns)
                                 (* 2 (1- columns))) ?-))
         (quit-item nil))

    (insert (format "%s\n%s\n" prompt dashes))
    (lyskom-traverse el menu
      (if (null (elt el 2))
          (setq quit-item el)
        (let ((string (lyskom-keyboard-menu-format-item el line-length)))
          (when (> (+ (current-column) (length string) 2) (window-width))
            (insert "\n"))
          (unless (bolp) (insert "  "))
          (insert string))))
    (unless (bolp)
      (insert "\n"))
    (insert dashes)
    (insert "\n")
    (when quit-item
      (insert (lyskom-keyboard-menu-format-item quit-item)))))




;;; ================================================================
;;; Interactive commands
;;; 


(defun lyskom-read-from-menu (prompt table)
  "Let the user select one of the values in TABLE.
TABLE is an alist whose elements' cars are strings.
Returns the selected string."
  (let* ((menu (lyskom-keyboard-menu-frob-table table))
         (buffer (get-buffer-create "*Keyboard menu*"))
         (menu-window-height 0))
    (save-excursion

      ;; Format the buffer

      (set-buffer buffer)
      (erase-buffer)
      (lyskom-keyboard-menu-insert prompt menu)

      (goto-char (point-min))
      (setq menu-window-height (+ 2 (count-lines (point-min) (point-max))))

      ;; Display the window and do the thing

      (save-window-excursion
        (if (< (- (window-height (selected-window))
                  menu-window-height) 5)
            (select-window
             (display-buffer buffer t))
          (split-window (selected-window) menu-window-height)
          (switch-to-buffer buffer))
        (let* ((lyskom-keyboard-menu-buffer buffer)
               (lyskom-keyboard-menu-menu menu)
               (lyskom-keyboard-menu-selection nil)
               (lyskom-keyboard-menu-overlay 
                (lyskom-xemacs-or-gnu
                 (make-extent 1 1 lyskom-keyboard-menu-buffer)
                 (make-overlay 0 0 lyskom-keyboard-menu-buffer)))
               (result nil))

          (lyskom-xemacs-or-gnu
           (set-extent-face lyskom-keyboard-menu-overlay nil)
           (overlay-put lyskom-keyboard-menu-overlay 'face nil))

          (condition-case nil
              (while (null result)
                (lyskom-keyboard-menu-highlight-selected)
                (let ((c (lyskom-keyboard-menu-read-char 
                          (lyskom-format "%#1s %#2s: %#3s"
                                         prompt
                                         (lyskom-get-string 'keyboard-menu-help)
                                         (or (elt lyskom-keyboard-menu-selection 1)
                                             "")))))
                  (cond ((eq (lookup-key global-map (vector c)) 'keyboard-quit)
                         (keyboard-quit))
                        ((eq c ?\C-a) (lyskom-keyboard-menu-beginning-of-line))
                        ((eq c ?\C-e) (lyskom-keyboard-menu-end-of-line))
                        ((or (eq c 'up)
                             (eq c ?\C-p))
                         (lyskom-keyboard-menu-up))
                        ((or (eq c ?\C-b)
                             (eq c 'left))
                         (lyskom-keyboard-menu-backward))
                        ((or (eq c 'down)
                             (eq c ?\C-n))
                         (lyskom-keyboard-menu-down))
                        ((or (eq c ?\C-f)
                             (eq c 'right))
                         (lyskom-keyboard-menu-forward))
                        ((or (eq c 'return)
                             (eq c ?\r)
                             (eq c ?\n))
                         (setq result lyskom-keyboard-menu-selection))
                        ((and (characterp c)
                              (assoc (make-string 1 c) 
                                     lyskom-keyboard-menu-menu))
                         (if kom-keyboard-menu-immediate-selection
                             (setq result (assoc (make-string 1 c) 
                                                 lyskom-keyboard-menu-menu))
                           (setq lyskom-keyboard-menu-selection
                                 (assoc (make-string 1 c)
                                        lyskom-keyboard-menu-menu))))))
                (when lyskom-keyboard-menu-selection
                  (setq lyskom-keyboard-menu-menu
                        (lyskom-rotate-list lyskom-keyboard-menu-menu
                                            lyskom-keyboard-menu-selection))))
            (quit (setq result nil)))
          (elt result 2)
          )))))

(defun lyskom-keyboard-menu-up ()
  "Move up one menu item"
  (interactive)
  (let ((done nil))
    (while (not done)

      ;; Move up one line
      (condition-case nil
          (previous-line 1)
        (beginning-of-buffer (setq done t)))

      ;; Scan the items on this line until we find the one
      ;; just before point or just after point or around
      ;; point.

      (let ((selection nil)
            (start (save-excursion (beginning-of-line) (point)))
            (end (save-excursion (end-of-line) (point)))
            (pos (point)))
        (while (and (>= pos start) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1- pos)))

        (setq pos (point))
        (while (and (<= pos end) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1+ pos)))
        (when selection (setq done t
                              lyskom-keyboard-menu-selection selection))))))

(defun lyskom-keyboard-menu-down ()
  "Move down one menu item."
  (interactive)
  (let ((done nil))
    (while (not done)

      ;; Move up one line
      (condition-case nil
          (next-line 1)
        (end-of-buffer (setq done t)))

      ;; Scan the items on this line until we find the one
      ;; just before point or just after point or around
      ;; point.

      (let ((selection nil)
            (start (save-excursion (beginning-of-line) (point)))
            (end (save-excursion (end-of-line) (point)))
            (pos (point)))
        (while (and (>= pos start) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1- pos)))

        (setq pos (point))
        (while (and (<= pos end) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1+ pos)))
        (when selection (setq done t
                              lyskom-keyboard-menu-selection selection))))))




(defun lyskom-keyboard-menu-forward ()
  "Move right one menu item."
  (interactive)
  (let ((pos (point))
        (item nil))
    (while (and pos (or (null item) (eq item lyskom-keyboard-menu-selection)))
      (setq pos (next-single-property-change pos 'lyskom-keyboard-menu-item))
      (when pos
        (setq item (get-text-property pos 'lyskom-keyboard-menu-item))))
    (when item (setq lyskom-keyboard-menu-selection item))))


(defun lyskom-keyboard-menu-backward ()
  "Move left one menu item."
  (interactive)
  (let ((pos (point))
        (item nil))
    (while (and pos (or (null item) (eq item lyskom-keyboard-menu-selection)))
      (setq pos (previous-single-property-change pos 'lyskom-keyboard-menu-item))
      (when pos
        (setq item (get-text-property pos 'lyskom-keyboard-menu-item))))
    (when item (setq lyskom-keyboard-menu-selection item))))

(defun lyskom-keyboard-menu-beginning-of-line ()
  "Move to the first menu item of this line."
  (interactive)
  (beginning-of-line)
  (setq lyskom-keyboard-menu-selection
        (or (get-text-property (point) 'lyskom-keyboard-menu-item)
            (get-text-property (or (next-single-property-change 
                                    (point) 'lyskom-keyboard-menu-item
                                    nil (save-excursion (end-of-line) (point)))
                                   (point))
                               'lyskom-keyboard-menu-item))))

(defun lyskom-keyboard-menu-end-of-line ()
  "Move to the last menu item of this line."
  (interactive)
  (end-of-line)
  (setq lyskom-keyboard-menu-selection
        (if (get-text-property (point) 'lyskom-keyboard-menu-item)
            (get-text-property (point) 'lyskom-keyboard-menu-item)
          (let ((pos (previous-single-property-change 
                      (point) 'lyskom-keyboard-menu-item
                      nil (1- (save-excursion (beginning-of-line) (point))))))
            (when (and pos (not (zerop pos)))
              (or (get-text-property pos 'lyskom-keyboard-menu-item)
                  (get-text-property (1- pos)  'lyskom-keyboard-menu-item)))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: command.el,v 44.45 2002/06/24 17:12:19 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: command.el
;;;;
;;;; This file contains stuff regarding commands.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: command.el,v 44.45 2002/06/24 17:12:19 byers Exp $\n"))

;;; (eval-when-compile
;;;   (require 'lyskom-vars "vars")
;;;   (require 'lyskom-services "services")
;;;   (require 'lyskom-language "language")
;;;   (require 'lyskom-clienttypes "clienttypes"))


;;; ======================================================================
;;; LysKOM user commands
;;; The new, blocking commands have a very similar structure
;;;
;;;  (defun kom-cmd (args)
;;;    "Documentation"
;;;    (interactive "...")
;;;    (lyskom-start-of-command 'kom-cmd)
;;;    (unwind-protect
;;;        (progn ...)
;;;      (lyskom-end-of-command)))
;;;
;;; This can now be written as
;;;
;;; (def-kom-command kom-cmd (args)
;;;   "Documentation"
;;;   (interactive "...")
;;;   ...)

(eval-and-compile
  (defun lyskom-fix-interactive-decl (decl command)
    (cond ((stringp (car (cdr decl))) decl)
          (t `(interactive (let ((lyskom-current-command ',command))
                             ,@(cdr decl)))))))




(defmacro def-kom-command (cmd args doc interactive-decl &rest forms)
  (if (not (stringp doc))
      (progn (message "!! No docstring for command %S" cmd)
             (setq forms (cons interactive-decl forms))
             (setq interactive-decl doc)
             (setq doc "")))
  (if (not (eq (car interactive-decl) 'interactive))
      (progn (message "!! Missing interactive declaration for %S; assuming \(interactive\)" cmd)
             (setq forms (cons interactive-decl forms))
             (setq interactive-decl '(interactive))))
  (let ((bufsym (intern (format "%S-start-buffer" cmd))))
    `(defun ,cmd ,args
       ,doc
       ,(lyskom-fix-interactive-decl interactive-decl cmd)
       (lyskom-start-of-command ',cmd)
       (let ((,bufsym (current-buffer)))
         (unwind-protect
             (condition-case nil
                 (progn ,@forms)
               (quit (ding)
                     (lyskom-insert-before-prompt
                      (lyskom-get-string 'interrupted))))
           (lyskom-save-excursion
            (when (buffer-live-p ,bufsym)
              (set-buffer ,bufsym))
             (lyskom-end-of-command)))))))

;;
;; def-kom-emacs-command works like def-kom-command, but the template 
;; is different. Commands defined this way will run as regular Emacs
;; commands when invoked outside of a LysKOM buffer. 
;;
;; The variable <cmd>-running-as-kom-command is non-nil when running
;; as a LysKOM command and nil otherwise.
;;
;; Note: this function catches *all* errors in lyskom-start-of-command
;;       which may not be what you want, so be careful.
;;
;; 
;; (defun kom-cmd (args)
;;   "Documentation"
;;   (interactive "...")
;;   (let ((kom-cmd-running-as-kom-command nil))
;;     (condition-case nil
;;         (progn (lyskom-start-of-command 'kom-cmd)
;;                (setq kom-cmd-running-as-kom-command t))
;;       (error nil))
;;     (unwind-protect
;;         (condition-case nil
;;             (progn ...)
;;           (quit (ding)
;;                 (lyskom-insert-before-prompt
;;                  (lyskom-get-string 'interrupted))))
;;       (and kom-cmd-running-as-kom-command (lyskom-end-of-command)))))
;; 

(defmacro def-kom-emacs-command (cmd args doc interactive-decl &rest forms)
  (if (not (stringp doc))
      (progn (message "!! No docstring for command %S" cmd)
             (setq forms (cons interactive-decl forms))
             (setq interactive-decl doc)
             (setq doc "")))
  (if (not (eq (car interactive-decl) 'interactive))
      (progn (message "!! Missing interactive declaration for %S; assuming \(interactive\)" cmd)
             (setq forms (cons interactive-decl forms))
             (setq interactive-decl '(interactive))))

  (let ((rsym (intern (format "%S-running-as-kom-command" cmd)))
        (bufsym (intern (format "%S-start-buffer" cmd))))
    `(defun ,cmd ,args
       ,doc
       ,(lyskom-fix-interactive-decl interactive-decl cmd)
       (let ((,rsym nil))
         (condition-case nil
             (progn (lyskom-start-of-command ',cmd)
                    (setq ,rsym t))
           (error nil))
         (let ((,bufsym (current-buffer)))
           (unwind-protect
               (condition-case nil
                   (progn ,@forms)
                 (quit (ding)
                       (lyskom-insert-before-prompt
                        (lyskom-get-string 'interrupted))))
             (and ,rsym
                  (lyskom-save-excursion
                   (when (buffer-live-p ,bufsym)
                     (set-buffer ,bufsym))
                   (lyskom-end-of-command)))))))))



(put 'def-kom-command 'edebug-form-spec
     '(&define name lambda-list
	       [&optional stringp]	; Match the doc string, if present.
	       ("interactive" interactive)
	       def-body))

(put 'def-kom-emacs-command 'edebug-form-spec
     '(&define name lambda-list
	       [&optional stringp]	; Match the doc string, if present.
	       ("interactive" interactive)
	       def-body))



;;;; ================================================================
;;;;                User-level commands and functions.


(defsubst lyskom-command-name (command)
  "Get the command name for the command COMMAND"
  (condition-case nil
      (lyskom-get-string command 'lyskom-command)
    (error nil)))

(defun lyskom-ok-command (alternative administrator)
  "Returns non-nil if it is ok to do such a command right now."
  (when (vectorp alternative) 
    (setq alternative (cons (elt alternative 0) (elt alternative 1))))
  (if administrator
      (not (memq (cdr alternative) lyskom-admin-removed-commands))
    (not (memq (cdr alternative) lyskom-noadmin-removed-commands))))

(defun kom-extended-command ()
  "Read a LysKOM function name and call the function."
  (interactive)
  (let ((fnc (lyskom-read-extended-command current-prefix-arg)))
    (cond
     (fnc (call-interactively fnc))
     (t (kom-next-command)))) )

(defvar lyskom-command-minibuffer-local-completion-map
  (let ((map (copy-keymap minibuffer-local-completion-map)))
    (define-key map " " 'lyskom-command-complete-word)
    map)
  "Keymap used for reading LysKOM names.")

(defvar lyskom-command-minibuffer-local-must-match-map
  (let ((map (copy-keymap minibuffer-local-must-match-map)))
    (lyskom-xemacs-or-gnu 
     (progn (set-keymap-parent map lyskom-minibuffer-local-completion-map)
            (define-key map " " 'lyskom-command-complete-word))
     (define-key map " " 'lyskom-command-complete-word))
    map)
  "Keymap used for reading LysKOM names.")

(defun lyskom-read-extended-command (&optional prefix-arg prompt)
  "Reads and returns a command"
  (let* ((completion-ignore-case t)
	 (minibuffer-setup-hook minibuffer-setup-hook)
         (base-prompt (cond ((null prompt) (lyskom-get-string 'extended-command))
                            ((symbolp prompt) (lyskom-get-string prompt))
                            (t prompt)))
	 (alternatives (mapcar 
			(lambda (pair)
			  (cons 
			   (cdr pair)
			   (car pair)))
			(lyskom-get-strings lyskom-commands
					    'lyskom-command)))
	 (name nil)
         (prefix-text
          (cond ((eq prefix-arg '-) "- ")
                ((equal prefix-arg '(4)) "C-u ")
                ((integerp prefix-arg) 
                 (format "%d " prefix-arg))
                ((and (consp prefix-arg) 
                      (integerp (car prefix-arg)))
                 (format "%d " (car prefix-arg)))
                (t nil)))
         (prompt (if prefix-text
                     (concat prefix-text base-prompt)
                   base-prompt)))

    (let ((minibuffer-local-completion-map 
           lyskom-command-minibuffer-local-completion-map)
          (minibuffer-local-must-match-map 
           lyskom-command-minibuffer-local-must-match-map))
      (lyskom-with-lyskom-minibuffer
       (setq name (lyskom-completing-read prompt
                                          'lyskom-complete-command
                                        ;                                        (lyskom-maybe-frob-completion-table
                                        ;                                         alternatives)
                                          ;; lyskom-is-administrator is buffer-local and
                                          ;; must be evalled before the call to 
                                          ;; completing-read
                                          ;; Yes, this is not beautiful
                                          (list 'lambda '(alternative)	     
                                                (list 'lyskom-ok-command 'alternative
                                                      lyskom-is-administrator))
                                          t nil 'lyskom-command-history))))
    (cdr (lyskom-string-assoc name alternatives))))


(defun lyskom-update-command-completion ()
  "Build a list of alternatives for completion of LysKOM commands.
Each list element is a vector [NAME COMMAND CANONICAL]. NAME is the
command name, COMMAND is the command and CANONICAL is the name 
transformed for matching."
  (setq lyskom-command-alternatives
        (mapcar (lambda (el) 
                  (vector (cdr el)
                          (car el)
                          (lyskom-completing-strip-command
                           (lyskom-unicase (cdr el)))
			  (lyskom-unicase (cdr el))))
                (lyskom-get-strings lyskom-commands 'lyskom-command))))

(defun lyskom-lookup-command-by-name (string &optional predicate)
  "Look up the command that corresponds to a certain string."
  (lyskom-complete-command string predicate 'lyskom-lookup))

(defsubst lyskom-command-match-string-regexp (string)
  (concat 
   "^\\s-*"
   (replace-in-string (regexp-quote
                       (lyskom-unicase
                        (lyskom-completing-strip-command string)))
                      "\\s-+" "\\\\S-*\\\\s-+")
          "\\s-*"))

(defun lyskom-completing-strip-command (string)
  "Strip parens and crap from a name.
If optional DONT-STRIP-SPACES is non-nil, don't strip spaces at front
and back of the string."
  (while (string-match "([^()]*)" string) ; Strip nested parens
    (setq string (replace-match "" t t string)))
  (while (string-match "\\s-\\s-+" string) ; Collapse spaces
    (setq string (replace-match " " t t string)))
  (while (string-match "([^()]*$" string) ; Strip incomplete parens at end
    (setq string (substring string 0 (match-beginning 0))))
  string)

;;; FIXME: Below is an idea on how to do command completion more right.
;;;
;;; Precompute lists of words in all commands. Include the optional words 
;;; and mark them as optional. Possibly allow sublists in the list, and
;;; make lists of words into sublists and mark the entire sublist as
;;; optional.
;;;
;;; When matching, divide the input into a list of words. Start matchin
;;; prefixes against the list of words for a command. It goes something 
;;; like this:
;;;
;;; C = 0, I = 0
;;; while there are more words in the input and command
;;;    A = word I of the input
;;;    B = word C of the command
;;;    if B is an optional word then
;;;       N = index of word following optional group that B is part of
;;;       push N,I onto backtracking stack
;;;    if A is a prefix of B then
;;;       I = I + 1
;;;	  C = C + 1
;;;       next iteration of the loop
;;;    if the backtracking stack is empty then
;;;       return mismatch
;;;    pop X,Y from the backtracking stack
;;;    C = X
;;;    I = Y
;;;    next iteration of the loop
;;; end while
;;; if there are left-over words in C then
;;;    return a mismatch
;;; else
;;;    return a match (I,C)
;;;
;;; When doing a word completion we can let the completion function do the
;;; actual work. It computes the longest possible completion we can have
;;; (i.e. one full word more than what we've got) and hands that over to
;;; lyskom-complete-string. Computing the longest possible completion
;;; goes something like this:
;;;
;;; W = nil
;;; Store I,C for all matches
;;; for all matches M = 1 .. N do
;;;    do something useful
;;;
;;; The idea is to get the last word that matches the input by storing
;;; the results of the match computation and then looking at the
;;; following word in all possible completions. If the following word
;;; is a word in an optional group that is the same in all possible
;;; completions, then that plus the first C words of any of the
;;; possible completions is the maximum possible. If the next word is
;;; a word of an optional group that does *not* match in all
;;; possibles, then ignore the optional group and look at the next
;;; word instead.

(defun lyskom-complete-command (string predicate all)
  "Completion function for LysKOM commands."
  (when (string-match "^\\s-+" string)
    (setq string (substring string (match-end 0))))
  (let ((alternatives nil)
        (m-string (lyskom-command-match-string-regexp string))
        (u-string (lyskom-unicase string))
        (exact nil))
    (lyskom-traverse el lyskom-command-alternatives
      (when (and (string-match m-string (elt el 2))
                 (or (null predicate) (funcall predicate el)))
        (setq alternatives (cons (if (eq all 'lyskom-lookup) el (elt el 0)) alternatives))
	(if (string-equal u-string (elt el 3)) (setq exact el))))
    (cond 
     ((eq all 'lyskom-lookup) (and exact (elt exact 1)))
     ((eq all 'lambda) exact)
     (all alternatives)
     ((null alternatives) nil)
     ((and (= (length alternatives) 1) exact) t)
     (t (let ((tmp (lyskom-complete-string alternatives)))
	  (lyskom-maybe-recode-string
	   (if (string-match (concat (regexp-quote (lyskom-unicase tmp)) "\\s-") u-string)
	       (concat tmp " ")
	     tmp)))))))

(defun lyskom-command-complete-word ()
  (interactive)
  (let ((string (buffer-string)))
    (when (next-single-property-change 0 'read-only string)
      (setq string 
            (substring string 
                       (next-single-property-change 0 'read-only string))))

    (let ((completion (try-completion string
                                      minibuffer-completion-table
                                      minibuffer-completion-predicate)))
      (cond ((null completion) (minibuffer-message " [No match]") nil)
            ((eq completion t) nil)
            (t (let* ((tmp string))
                 (when (and (string-equal (lyskom-unicase completion)
                                          (lyskom-unicase tmp))
                            (not (string-match "\\s-$" completion)))
                   (if (stringp (setq tmp (try-completion 
                                           (concat tmp " ")
                                           minibuffer-completion-table
                                           minibuffer-completion-predicate)))
                       (setq completion tmp)))
                 (if (string-equal (lyskom-unicase completion)
                                   (lyskom-unicase string))
                     (progn (minibuffer-completion-help) nil)
                   (delete-region (- (point-max) (length string))
                                  (point-max))

                   ;; Now we have the suggested completion
                   ;; Expand what's in the buffer by one real word.

                   (let* ((count (lyskom-command-complete-count-words string))
                          (result (lyskom-command-complete-word-truncate 
                                   completion count)))
                     (when (string= result string)
                       (setq result (lyskom-command-complete-word-truncate 
                                     completion (1+ count))))
                     (insert result))
                   t)))))))

(defvar lyskom-command-complete-regexp
  "\\(([^\)]*)\\s-+\\)*\\S-+\\(\\s-*([^\)]*)\\)*\\(\\s-+\\|\\'\\)")

(defun lyskom-command-complete-word-truncate (completion count)
  "Truncate completion COMPLETION to COUNT words."
  (let ((start 0))
    (while (and (> count 0)
                (string-match lyskom-command-complete-regexp completion start))
      (setq start (match-end 0)
            count (1- count)))
    (substring completion 0 start)))

(defun lyskom-command-complete-count-words (string)
  "Count number of real words in command name or completion STRING."
  (let ((start 0)
        (count 0))
    (while (string-match lyskom-command-complete-regexp string start)
      (setq start (match-end 0)
            count (1+ count)))
    count))



;;; The code below is an alternative implementation of 
;;; lyskom-command-complete-word that mucks with the
;;; contents of the minibuffer and then calls the regular
;;; minibuffer functions.
;;;
;;;
;;;(defun lyskom-command-complete-word-count-words (string)
;;;  (let ((count 0)
;;;        (start 0))
;;;    (while (string-match lyskom-command-complete-regexp string start)
;;;      (setq start (match-end 0)
;;;            count (1+ count)))
;;;    count))  
;;;
;;;(defun lyskom-command-complete-word ()
;;;  (interactive)
;;;  (let* ((string (buffer-string))
;;;         completions)
;;;    ;; Strip the prompt in Emacs 21
;;;    (when (next-single-property-change 0 'read-only string)
;;;      (setq string 
;;;            (substring string 
;;;                       (next-single-property-change 0 'read-only string))))
;;;
;;;    (setq completions (save-excursion
;;;                        (set-buffer lyskom-buffer)
;;;                        (lyskom-complete-command string 
;;;                                                 nil
;;;                                                 nil)))
;;;    (when (stringp completions)
;;;      (let ((original-count (lyskom-command-complete-word-count-words string))
;;;            (start 0))
;;;        (while (and (> original-count 0)
;;;                    (string-match lyskom-command-complete-regexp completions start))
;;;          (setq start (match-end 0)
;;;                original-count (1- original-count)))
;;;
;;;        (delete-region (- (point-max) (length string)) (point-max))
;;;        (let ((result (substring completions 0 start)))
;;;          (string-match "\\s-*\\'" result)
;;;          (insert (substring result 0 (match-beginning 0)))))))
;;;  (minibuffer-complete-word))


(defun lyskom-start-of-command (function &optional may-interrupt dead-ok)
  "This function is run at the beginning of every LysKOM command.
It moves the cursor one line down, and +++ later it will tell the server
that the previous text has been read.

Argument FUNCTION is a string the string will be written in the buffer
on start of the command. If it is a symbol it searches for the corresponding
command name in lyskom-commands and writes this in the message buffer.

If optional argument MAY-INTERRUPT is present and non-nil,
don't signal an error if this call is interrupting another command.

If optional DEAD-OK is non-nil, don't signal an error if the session 
has been closed.

Special: if lyskom-is-waiting then we are allowed to break if we set 
lyskom-is-waiting nil.

This function checks if lyskom-doing-default-command and
lyskom-first-time-around are bound. The text entered in the buffer is
chosen according to this"

  (cond ((or (not (boundp 'lyskom-proc))
             (not (boundp 'lyskom-buffer))
             (and (null lyskom-proc) (null lyskom-buffer)))
         (lyskom-error "%s" (lyskom-get-string 'not-lyskom-buffer)))

        ((and (not dead-ok)
              (or (not lyskom-proc)
                  (memq (process-status lyskom-proc) '(closed signal exited nil))))
      (lyskom-error "%s" (lyskom-get-string 'dead-session))))

  (if (and lyskom-is-waiting
           (listp lyskom-is-waiting))
      (progn
        (setq lyskom-is-waiting nil)
        (lyskom-end-of-command)))

  (setq lyskom-is-waiting nil)
  (if (and lyskom-executing-command (not may-interrupt))
      (lyskom-error "%s" (lyskom-get-string 'wait-for-prompt)))
  (if (not (and (boundp 'lyskom-doing-default-command)
                lyskom-doing-default-command))
      (cond
       (lyskom-first-time-around)
       ((stringp function) (lyskom-insert function))
       ((and function (symbolp function))
        (let ((name (lyskom-command-name function)))
          (if name (lyskom-insert name)))))
    (save-excursion
      (if lyskom-current-prompt
          (let ((inhibit-read-only t))
            (goto-char (point-max))
            (beginning-of-line)
            (delete-region (point) (point-max)))))
    (lyskom-insert (lyskom-modify-prompt 
                    (cond ((stringp lyskom-current-prompt) 
                           (apply 'lyskom-format 
                                  lyskom-current-prompt
                                  lyskom-current-prompt-args))
                          ((symbolp lyskom-current-prompt)
                           (apply 'lyskom-format 
                                  (lyskom-get-string lyskom-current-prompt)
                                  lyskom-current-prompt-args))
                          (t (format "%S" lyskom-current-prompt)))
                    t)))
  (setq mode-line-process (lyskom-get-string 'mode-line-working))
  (if (pos-visible-in-window-p (point-max))
      (save-excursion
        (goto-char (point-max))
        (lyskom-set-last-viewed)))
  (setq lyskom-executing-command t)
  (setq lyskom-current-command function)
  (setq lyskom-current-prompt nil)
  (lyskom-insert "\n")
  (if (and (eq (window-buffer (selected-window))
               (current-buffer))) 
      (progn
	(if (pos-visible-in-window-p (1- (point-max)))
	    (goto-char (point-max)))
	(sit-for 0)))
  (run-hooks 'lyskom-before-command-hook)
  (if kom-page-before-command           ;Nice with dumb terminals.
      (if (or (not (listp kom-page-before-command))
              (memq function kom-page-before-command))
          (recenter 1))))


(defun lyskom-end-of-command ()
  "Print prompt, maybe scroll, prefetch info."
  (lyskom-save-excursion
   (message "")
   (lyskom-clean-all-buffer-lists)
   (while (and lyskom-to-be-printed-before-prompt
               (lyskom-queue->first lyskom-to-be-printed-before-prompt))
     (if (not (bolp)) (lyskom-insert "\n"))
     (lyskom-insert (car (lyskom-queue->first 
                          lyskom-to-be-printed-before-prompt)))
     (lyskom-queue-delete-first lyskom-to-be-printed-before-prompt))
   (setq lyskom-executing-command nil)
   (setq lyskom-current-command nil)
   (setq lyskom-current-prompt nil)	; Already set in s-o-c really
   (lyskom-scroll)
   (setq mode-line-process (lyskom-get-string 'mode-line-waiting))
   (if (pos-visible-in-window-p (point-max) (selected-window))
       (lyskom-set-last-viewed))
   (lyskom-prefetch-and-print-prompt)
   (run-hooks 'lyskom-after-command-hook)
   (when (and (lyskom-have-feature idle-time)
              (not lyskom-is-anonymous))
     (save-excursion (set-buffer lyskom-buffer)
                     (initiate-user-active 'background nil)))
   (if kom-inhibit-typeahead
       (discard-input))
   ;; lyskom-pending-commands should probably be a queue or a stack.
   (when lyskom-pending-commands
      (let ((command (car lyskom-pending-commands)))
       (setq lyskom-pending-commands (cdr lyskom-pending-commands))
       (if (symbolp command)
           (call-interactively command)
         (eval command))))
   (when lyskom-slow-mode
     (buffer-enable-undo))))

(eval-and-compile (provide 'lyskom-command))

;;; command.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: buffers.el,v 44.23 2002/02/24 20:23:25 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: buffers.el
;;;; Author: David Byers
;;;;
;;;; This file implements special buffer handling used in LysKOM
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: buffers.el,v 44.23 2002/02/24 20:23:25 joel Exp $\n"))


;;;;
;;;; LYSKOM BUFFER MANAGEMENT
;;;;
;;;; Buffers are arranged in a tree rooted in a LysKOM buffer. There
;;;; is one tree for each session.
;;;;
;;;; Use lyskom-get-buffer-create to create new buffers
;;;; Use lyskom-display-buffer to display most buffers
;;;; Use lyskom-undisplay-buffer to undisplay those buffers
;;;;





;;;; ============================================================
;;;; Buffer hierarchy management
;;;;
;;;; This code should not be too dependent on LysKOM
;;;;

(defvar lyskom-buffer-children nil
  "List of buffers that are children to this buffer")

(defvar lyskom-buffer-inherited-variables nil
  "List of variables automatically inherited to sub-buffers when
they are created.")

(defvar lyskom-buffer-parent nil
  "Parent of buffer")

(defvar lyskom-killing-hierarchy nil
  "Non-nil while killing a buffer hierarchy.")

(make-variable-buffer-local 'lyskom-buffer-parent)
(lyskom-protect-variable 'lyskom-buffer-parent)

(make-variable-buffer-local 'lyskom-buffer-children)
(lyskom-protect-variable 'lyskom-buffer-children)

(make-variable-buffer-local 'lyskom-buffer-inherited-variables)
(lyskom-protect-variable 'lyskom-buffer-inherited-variables)




(defun lyskom-set-buffer-parent (buffer parent)
  "Set the parent buffer of BUFFER to PARENT. If buffer is already
a child of some buffer, reparent it."
  (save-excursion (set-buffer buffer)
		  (if (and lyskom-buffer-parent
                           (buffer-live-p lyskom-buffer-parent))
                      (lyskom-remove-buffer-child lyskom-buffer-parent buffer))
		  (setq lyskom-buffer-parent parent)
		  (if parent (lyskom-add-buffer-child parent buffer))))

(defun lyskom-remove-buffer-child (buffer child)
  "Remove CHILD from BUFFER's list of children. Args: BUFFER CHILD"
  (save-excursion (set-buffer buffer)
		  (if (boundp 'lyskom-buffer-children)
		      (setq lyskom-buffer-children 
                            (delq child lyskom-buffer-children)))))

(defun lyskom-add-buffer-child (buffer child)
  "Add CHILD as a child of BUFFER. Args: BUFFER CHILD"
  (save-excursion (set-buffer buffer)
		  (setq lyskom-buffer-children
                        (cons child lyskom-buffer-children))))

(defun lyskom-get-buffer-parent (buffer)
  "Return the parent of BUFFER or nil if it has no parent"
  (save-excursion (set-buffer buffer)
		  (and (boundp 'lyskom-buffer-parent)
		       lyskom-buffer-parent)))

(defun lyskom-get-buffer-children (buffer)
  "Return the list of children of buffer BUFFER or nil if there are none."
  (save-excursion (set-buffer buffer)
		  (and (boundp 'lyskom-buffer-children)
		       lyskom-buffer-children)))

(defun lyskom-buffer-root-ancestor (buffer)
  "Return the ultimate ancestor of buffer BUFFER."
  (let ((buffer-parent buffer))
    (while (setq buffer-parent
		 (lyskom-get-buffer-parent buffer))
      (setq buffer buffer-parent))
    buffer))

(defun lyskom-traverse-buffer-hierarchy (function buffer)
  "Apply FUNCTION to each descendent of BUFFER. Results are discarded."
  (let ((queue (list buffer))
        (done nil)
        (current nil))
    (while queue
      (setq current (car queue))
      (setq queue (cdr queue))
      (unless (or (memq current done)
                  (not (buffer-live-p current)))
        (setq done (cons current done))
        (setq queue (append queue (lyskom-get-buffer-children current)))
        (funcall function current)))))
        

(defun lyskom-map-buffer-children (function buffer)
  "Apply FUNCTION to each child of BUFFER and make a list of the results."
  (cond ((null buffer) nil)
	(t (cons (funcall function buffer)
		 (apply 'nconc 
			(mapcar (function
				 (lambda (x)
                                   (lyskom-map-buffer-children function x)))
				(lyskom-get-buffer-children buffer)))))))


(defun lyskom-buffer-hierarchy-query-kill-function ()
  "When querying if a buffer is to be killed, ensure that none of
the children object"
  (save-excursion
    (not (memq nil
               (mapcar (function
                        (lambda (buffer)
                          (if (buffer-live-p buffer)
                              (progn (set-buffer buffer)
                                     (run-hook-with-args-until-failure
                                      'kill-buffer-query-functions))
                            t)))
                       (lyskom-get-buffer-children (current-buffer)))))))
  

(defun lyskom-buffer-hierarchy-kill-hook ()
  "When killing a buffer, enure that its children also die"
  (let ((kill-buffer-query-functions nil)
        (lyskom-killing-hierarchy (or lyskom-killing-hierarchy
                                      (current-buffer))))
    (lyskom-set-buffer-parent (current-buffer) nil)
    (let ((buflist (lyskom-get-buffer-children (current-buffer))))
      (while buflist
        (kill-buffer (car buflist))
        (setq buflist (cdr buflist))))))


(defun lyskom-buffer-kill-trim-hook ()
  "When killing a buffer, run trimming hooks."
  (when (eq major-mode 'lyskom-mode)
    (let ((lyskom-trim-buffer-delete-to (point-max)))
      (lyskom-ignore lyskom-trim-buffer-delete-to)
      (run-hooks 'lyskom-trim-buffer-hook))))

(add-hook 'kill-buffer-hook 'lyskom-buffer-hierarchy-kill-hook)
(add-hook 'kill-buffer-hook 'lyskom-buffer-kill-trim-hook)
(add-hook 'kill-buffer-query-functions
          'lyskom-buffer-hierarchy-query-kill-function)



;;;; ======================================================================
;;;; ======================================================================

(defun lyskom-clean-all-buffer-lists ()
  "Remove dead buffers from all relevant buffer lists"
  (setq lyskom-sessions-with-unread
        (lyskom-clean-buffer-list lyskom-sessions-with-unread)
        lyskom-sessions-with-unread-letters
        (lyskom-clean-buffer-list lyskom-sessions-with-unread-letters)
        lyskom-buffer-list
        (lyskom-clean-buffer-list lyskom-buffer-list))
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defun lyskom-clean-buffer-list (buffers)
  "Remove all dead buffers from BUFFERS"
  (let ((result nil))
    (while buffers
      (if (lyskom-buffer-p (car buffers))
        (setq result (cons (car buffers) result))
        (save-excursion (set-buffer (car buffers))
                        (setq lyskom-session-has-unread-letters nil)
                        (setq lyskom-session-has-unreads nil)))
      (setq buffers (cdr buffers)))
    (nreverse result)))

(defun lyskom-remove-buffer-from-lists (&optional buffer)
    "Remove BUFFER from all internal lists.
If BUFFER is not specified, assume the current buffer"
  (unless buffer (setq buffer (current-buffer)))
  (lyskom-remove-unread-buffer buffer)  
  (setq lyskom-buffer-list
        (delq buffer lyskom-buffer-list))
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defun lyskom-remove-unread-buffer (buffer &optional letters-only)
  (unless letters-only
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unreads nil)))
     buffer)
    (setq lyskom-sessions-with-unread 
          (delq buffer lyskom-sessions-with-unread)))
  (lyskom-traverse-buffer-hierarchy 
   (lambda (x)
     (save-excursion (set-buffer x)
                     (setq lyskom-session-has-unread-letters nil)))
   buffer)
  (setq lyskom-sessions-with-unread-letters
        (delq buffer lyskom-sessions-with-unread-letters))
  (lyskom-set-default 'lyskom-need-prompt-update t))
  

(defun lyskom-add-unread-buffer (buffer &optional letters)
  (unless (memq buffer lyskom-sessions-with-unread)
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unreads t)))
     buffer)
    (setq lyskom-sessions-with-unread
          (cons buffer lyskom-sessions-with-unread)))
  (unless (or (null letters)
              (memq buffer lyskom-sessions-with-unread-letters))
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unread-letters t)))
     buffer)
    (setq lyskom-sessions-with-unread-letters
          (cons buffer lyskom-sessions-with-unread-letters)))
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defvar lyskom-associated-buffer-list nil
  "List of (CATEGORY . BUFFER-LIST) listing all buffers of various
categories")

(make-variable-buffer-local 'lyskom-associated-buffer-list)
(lyskom-protect-variable 'lyskom-associated-buffer-list)

(defvar lyskom-buffer-category nil
  "Category of this buffer")

(make-variable-buffer-local 'lyskom-buffer-category)
(lyskom-protect-variable 'lyskom-buffer-category)

(def-kom-var lyskom-saved-window-configuration nil
  "The window configuration to return to when closing the window"
  protected
  local)

(def-kom-var lyskom-dedicated-frame nil
  "The frame dedicated to the current buffer"
  protected
  local)

(def-kom-var lyskom-dedicated-window nil
  "The window dedicated to the current buffer"
  protected
  local)

(defvar lyskom-undisplaying-hierarchy nil
  "The top of the buffer hierarchy being undisplayed.")



(defun lyskom-clean-up-buffer-category (cat)
  (let ((buffers (cdr (assq cat (lyskom-default-value 'lyskom-associated-buffer-list))))
        (result nil))
    (while buffers
      (when (buffer-live-p (car buffers))
        (setq result (cons (car buffers) result)))
      (setq buffers (cdr buffers)))
    (lyskom-set-buffers-of-category cat (nreverse result))))


(defun lyskom-set-buffers-of-category (category buflist)
  (let ((tmp (assq category (lyskom-default-value 'lyskom-associated-buffer-list))))
    (cond (tmp (setcdr tmp buflist))
          (t (lyskom-setq-default 
              lyskom-associated-buffer-list
              (cons (cons category buflist)
                    (lyskom-default-value 'lyskom-associated-buffer-list)))))))


(defun lyskom-buffers-of-category (cat)
  "Return all live buffers of catgory CAT"
  (lyskom-clean-up-buffer-category cat)
  (cdr (assq cat (lyskom-default-value 'lyskom-associated-buffer-list))))


(defun lyskom-add-buffer-of-category (buffer category)
  "Add BUFFER as a buffer of category CATEGORY"
  (let ((tmp (assq category (lyskom-default-value 'lyskom-associated-buffer-list))))
    (cond (tmp (setcdr tmp (cons buffer (cdr tmp))))
          (t (lyskom-setq-default 'lyskom-associated-buffer-list
                                  (cons (cons category (list buffer))
                                        (lyskom-default-value
                                         'lyskom-associated-buffer-list)))))))


(defun lyskom-quit-query ()
  (if (and (boundp 'lyskom-buffer)
           (local-variable-p 'lyskom-buffer (current-buffer))
             (eq lyskom-buffer (current-buffer))
             (lyskom-buffers-of-category 'write-texts))
    (unwind-protect
        (progn
          (display-buffer (car (lyskom-buffers-of-category 'write-texts)))
          (lyskom-ja-or-nej-p (lyskom-get-string 'quit-in-spite-of-unsent)))
      nil)
    t))

(add-hook 'kill-buffer-query-functions 'lyskom-quit-query)
(add-hook 'kill-emacs-query-functions 'lyskom-quit-query)

(defun lyskom-recode-buffer-name (name)
  (cond ((and (multibyte-string-p name) (not enable-multibyte-characters))
	 (encode-coding-string name 
			       (or (and lyskom-language
					(lyskom-language-coding
					 lyskom-language))
				   'raw-text)))
	((and (not (multibyte-string-p name)) enable-multibyte-characters)
	 (decode-coding-string name 
			       (or (and lyskom-language
					(lyskom-language-coding
					 lyskom-language))
				   'raw-text)))
	(t name)))

(defun lyskom-generate-new-buffer (name)
  (setq name (lyskom-recode-buffer-name name))
  (let ((buf (generate-new-buffer name)))
    (save-excursion
      (set-buffer buf))
    buf))

(defun lyskom-get-buffer-create (category name &optional unique)
  "Create a new buffer of category CATEGORY with name generated from NAME. 
If UNIQUE is non-nil, re-use the first existing buffer of category
CATEGORY, renaming it and killing its local variables.

The created buffer is made a child of the current buffer."
  (setq name (lyskom-recode-buffer-name name))
  (let ((buffers (lyskom-buffers-of-category category))
        (buffer nil))
    (if (and unique buffers)
        (progn (setq buffer (car buffers))
               (save-excursion (set-buffer buffer)
                               (let ((inhibit-read-only t))
;;; +++ FIXME: This is that erase-buffer works if there are widgets
                                 (setq before-change-functions
                                       (delq 'widget-before-change
                                             before-change-functions))
                                 (erase-buffer))
                               (kill-all-local-variables)
                               (if (equal (buffer-name (current-buffer))
                                          name)
                                   nil
                                 (rename-buffer name t))))
      (progn (setq buffer (generate-new-buffer name))
             (lyskom-add-buffer-of-category buffer category)))
    (lyskom-set-buffer-parent buffer (current-buffer))
    (lyskom-update-inherited-variables buffer)
    (save-excursion (set-buffer buffer)
                    (setq lyskom-buffer-category category))
    buffer))



(defun lyskom-update-inherited-variables (buffer)
  "Update all inherited variables in this buffer and propagate them
to all children"
  (save-excursion 
    (let ((variables nil)
          (tmp lyskom-inherited-variables))
      (set-buffer buffer)
      (when lyskom-buffer-parent
        (set-buffer lyskom-buffer-parent)
        (setq variables (mapcar 'symbol-value lyskom-inherited-variables))
        (set-buffer buffer)
        (while tmp
          (make-local-variable (car tmp))
          (set (car tmp) (car variables))
          (setq tmp (cdr tmp)
                variables (cdr variables))))
      (mapcar 'lyskom-update-inherited-variables
              lyskom-buffer-children))))



(defun lyskom-display-buffer (buffer)
  "Display the buffer BUFFER and select the window displaying it.

If BUFFER is already visible in some window in any frame, iconified or
otherwise, make that window visible. Otherwise display buffer as per 
which category it is in. Selects the window.

Returns the window displaying BUFFER."


  (set-buffer buffer)
  (let ((windows (lyskom-get-buffer-window-list buffer nil 0))
        (iconified-frame nil)
        (visible-frame))

    ;;
    ;; Find out if the buffer is visible somewhere
    ;;

    (while windows
      (cond ((not (frame-live-p (window-frame (car windows)))))
            ((eq (frame-visible-p (window-frame (car windows))) 'icon)
             (setq iconified-frame (car windows)))
            ((frame-visible-p (window-frame (car windows)))
             (setq visible-frame (car windows))
             (setq windows nil)))
      (setq windows (cdr windows)))

    ;;
    ;; Display it
    ;;

    (cond
     (visible-frame (select-window visible-frame)
                    visible-frame)
     (iconified-frame (make-frame-visible (window-frame iconified-frame))
                      (select-window iconified-frame)
                      iconified-frame)

     (t
      (let ((category lyskom-buffer-category)
            (window nil))
        (if (null category) 
            (progn (select-window (display-buffer buffer))
                   (selected-window))

          (let* ((sym (intern-soft (concat "kom-"
                                           (symbol-name category)
                                           "-in-window")))
                 (open (lyskom-default-value-safe sym))
                 (saved-window-configuration
                  (save-excursion
                    (set-buffer (or (and (boundp 'lyskom-buffer)
                                         lyskom-buffer)
                                    (current-buffer)))
                    (current-window-configuration)))
                 (dedicated-frame nil)
                 (dedicated-window nil))
            
            (cond 

             ;;
             ;; NULL -- Just switch to the buffer
             ;;

             ((null open)
              (switch-to-buffer buffer)
              (setq window (selected-window)))

             ;;
             ;; OTHER, OTHER-WINDOW -- Switch to in another window
             ;;

             ((memq open '(other other-window))
              (switch-to-buffer-other-window buffer)
              (setq dedicated-window (selected-window))
              (setq window (selected-window)))
                  
             ;;
             ;; OTHER-FRAME -- Switch to in another frame
             ;; Create frame if none exist
             ;;

             ((eq open 'other-frame)
              (if (eq (selected-frame) (next-frame))
                  (switch-to-buffer-other-frame buffer)
                (other-frame 1)
                (switch-to-buffer buffer))
              (setq window (selected-window)))
                  
             ;;
             ;; NEW-FRAME
             ;; Create a new frame and display buffer in that frame
             ;;

             ((eq open 'new-frame)
              (switch-to-buffer-other-frame buffer)
              (setq dedicated-frame (selected-frame))
              (setq dedicated-window (selected-window))
              (setq window (selected-window))
              (setq saved-window-configuration nil))

             ;;
             ;; String or buffer
             ;; Switch to buffer in window displaying named buffer
             ;; Prefer windows in selected frame
             ;;

             ((and (or (stringp open)
                       (bufferp open))
                   (lyskom-get-buffer-window-list open nil 'visible))
              (let ((tmp (lyskom-get-buffer-window-list open nil 'visible)))
                (setq window (car tmp))
                (while tmp
                  (if (eq (window-frame (car tmp))
                          (selected-frame))
                      (progn
                        (setq window (car tmp))
                        (setq tmp nil))
                    (setq tmp (cdr tmp))))
                (select-window window)
                (switch-to-buffer buffer)))

             ;;
             ;; Otherwise just switch
             ;;
             
             (t (switch-to-buffer buffer)
                (setq window (selected-window))))


            ;;
            ;; Set up kill-buffer-hooks and similar things
            ;;

            (select-window window)
            (set-buffer buffer)
            (make-local-variable 'lyskom-dedicated-frame)
            (setq lyskom-dedicated-frame dedicated-frame)
            (make-local-variable 'lyskom-dedicated-window)
            (setq lyskom-dedicated-window dedicated-window)
            (make-local-variable 'lyskom-saved-window-configuration)
            (setq lyskom-saved-window-configuration
                  saved-window-configuration)
            (make-local-hook 'kill-buffer-hook)
            (add-hook 'kill-buffer-hook
                      'lyskom-undisplay-buffer-hook nil t)
            (put 'kill-buffer-hook 'permanent-local t)
            window)))))))


(defun lyskom-undisplay-buffer-hook ()
  (save-excursion (lyskom-undisplay-buffer (current-buffer))))

(defun lyskom-undisplay-buffer (&optional buffer)
  "Undisplay BUFFER. If buffer is not specified, undisplay the current
buffer"

  (setq buffer (or buffer (current-buffer)))
  (let ((dedicated-frame (and (boundp 'lyskom-dedicated-frame)
                              lyskom-dedicated-frame))
        (dedicated-window (and (boundp 'lyskom-dedicated-window)
                                       lyskom-dedicated-window))
        (lyskom-undisplaying-hierarchy (or buffer
                                           lyskom-undisplaying-hierarchy))
        (saved-window-configuration
         (and (boundp 'lyskom-saved-window-configuration)
              lyskom-saved-window-configuration)))
         
    (cond 

     ;;
     ;; If buffer has a dedicated frame AND
     ;; buffer is visible in that frame THEN
     ;; delete the frame
     ;;

     (dedicated-frame
      (when (memq dedicated-frame
                  (mapcar 'window-frame
                          (lyskom-get-buffer-window-list buffer nil t)))
        (delete-frame dedicated-frame)
        (setq dedicated-frame nil)))

     ((and lyskom-killing-hierarchy
           (not (eq lyskom-killing-hierarchy buffer))) nil)
     ((and lyskom-undisplaying-hierarchy
           (not (eq lyskom-undisplaying-hierarchy buffer))) nil)

     (dedicated-window
      (when (and (window-live-p dedicated-window)
                 (eq (get-buffer buffer)
                     (window-buffer dedicated-window)))
	(if (eq dedicated-window (next-window dedicated-window))
	    (bury-buffer buffer)
	    (delete-window dedicated-window))
	(setq dedicated-window nil))
      (when saved-window-configuration
        (lyskom-set-partial-window-configuration
         saved-window-configuration)))

     (saved-window-configuration
      (lyskom-set-partial-window-configuration
       lyskom-saved-window-configuration)))))

(defun lyskom-set-partial-window-configuration (configuration)
  "Set CONFIGURATION as the current window configuration with the exception
of point mark and window-start in all windows."
  (let* ((info nil)
         (binfo nil))
    (save-excursion
      (setq binfo
            (mapcar (function
                     (lambda (b)
                       (set-buffer b)
                       (list b (point) (mark t))))
                    (buffer-list)))
      (walk-windows (function
                     (lambda (w)
                       (set-buffer (window-buffer w))
                       (setq info
                             (cons
                              (list w
                                    (window-start w)
                                    (window-point w)
                                    (window-buffer w))
                              info))))
                    t t))
    (unwind-protect
        (set-window-configuration configuration)
      (save-selected-window
        (let (buffer window saved-point saved-mark saved-start)

          (while binfo
            (setq buffer (elt (car info) 0)
                  saved-point (elt (car info) 1)
                  saved-mark (elt (car info) 2))
            (when (buffer-live-p buffer)
              (set-buffer buffer)
              (goto-char saved-point)
              (set-mark saved-mark))
            (setq binfo (cdr binfo)))

          (while info
            (setq window (elt (car info) 0)
                  saved-start (elt (car info) 1)
                  saved-point (elt (car info) 2)
                  buffer (elt (car info) 3))

            (when (and (window-live-p window)
                       (eq (window-buffer window)
                           buffer))
              (set-window-start window saved-start)
              (set-window-point window saved-point))
            (setq info (cdr info))))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: aux-items.el,v 44.35 2002/06/12 18:29:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: aux-items.el
;;;;
;;;; Implementation of aux-item specific stuff.
;;;; Hopefulle more of this will be made more general in the future.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: aux-items.el,v 44.35 2002/06/12 18:29:32 byers Exp $\n"))

;;; (eval-when-compile
;;;   (require 'lyskom-defvar "defvar.el")
;;;   (require 'lyskom-vars "vars.el")
;;;   (require 'lyskom-types "komtypes.el"))


(def-kom-var lyskom-aux-item-definitions nil
  "List of aux item definitions.")

(defmacro def-aux-item (name number &rest data)
  (` (setq lyskom-aux-item-definitions 
           (add-to-list 'lyskom-aux-item-definitions
                        (cons (, number)
                              (cons (cons 'name (quote (, name)))
                                    (quote (, data))))))))

(defun lyskom-aux-item-definition->name (def)
  (cdr (assq 'name def)))

(defun lyskom-aux-item-definition->number (def)
  (car def))

(defun lyskom-map-aux-items (fn text-stat)
  "Apply FN to every aux item in TEXT-STAT."
  (let ((items (text-stat->aux-items text-stat)))
    (while items
      (when (and (car items) 
                 (not (aux-item-flags->deleted (aux-item->flags items))))
        (funcall fn (car items)))
      (setq items (cdr items)))))



(defun lyskom-aux-item-try-call (item method default &rest args)
  (when (lyskom-aux-item-p item)
    (setq item (lyskom-find-aux-item-definition item)))
  (cond ((listp method)
         (let ((result nil)
               (found nil))
           (while method
             (when (lyskom-aux-item-definition-field item (car method))
               (setq result
                     (apply (lyskom-aux-item-definition-field item
                                                              (car method))
                            args)
                     found t
                     method nil))
             (setq method (cdr method)))
           (if found result default)))
        (t (if (lyskom-aux-item-definition-field item method)
             (apply (lyskom-aux-item-definition-field item method) args)
             default))))

(defun lyskom-aux-item-has-call (item method)
  "Return non-nil if aux-item ITEM has a defined method METHOD"
  (when (lyskom-aux-item-p item)
    (setq item (lyskom-find-aux-item-definition item)))
  (lyskom-aux-item-definition-field item method))

(defun lyskom-aux-item-call (def method &rest args)
  (apply 'lyskom-aux-item-try-call def method nil args))


(defun lyskom-aux-item-definition-field (def method)
  (when (lyskom-aux-item-p def)
    (setq def (lyskom-find-aux-item-definition def)))
  (cdr (assq method def)))


(defun lyskom-find-aux-item-definition (aux)
  (assq (aux-item->tag aux) lyskom-aux-item-definitions))

(defun lyskom-match-aux-items (item-list predicate)
  "Return a list of all aux-items in ITEM-LIST that match PREDICATE.
PREDICATE should receives a single aux-item as its argument and should
return non-nil if the item is to be included in the list."
  (let ((result nil))
    (while item-list
      (when (funcall predicate (car item-list))
        (setq result (cons (car item-list) result)))
      (setq item-list (cdr item-list)))
    (nreverse result)))

                                        
(defun lyskom-get-aux-item (item-list tag)
  "Return all aux-items in ITEM-LIST with tag TAG."
  (lyskom-match-aux-items item-list
                          (lambda (el) (eq (aux-item->tag el) tag))))


(defun lyskom-aux-item-terminating-button (item obj)
  (if obj
       (lyskom-format 
        " %#1@%[[*]%]" 
        (lyskom-default-button 
         'aux 
         (cond ((lyskom-text-stat-p obj) (list 'text
                                               (text-stat->text-no obj)
                                               (aux-item->aux-no item)))
               ((lyskom-conf-stat-p obj) (list 'conf
                                               (conf-stat->conf-no obj)
                                               (aux-item->aux-no item)))
               ((eq obj 'server) (list 'server nil (aux-item->aux-no item)))
               (t item))))
     ""))

(defun lyskom-aux-item-after-parse (item)
  (lyskom-aux-item-try-call item 'decode-data nil)
  item)

(defun lyskom-aux-item-output-data (item)
  (lyskom-aux-item-try-call item 
                            'encode-data
                            (aux-item->data item)
			    item))


;;; ======================================================================

(def-aux-item content-type 1
  (text-name aux-content-type-name)
  (parse . lyskom-parse-content-type)
  (text-print . lyskom-print-content-type)
  (info  . lyskom-aux-item-info))

(def-aux-item fast-reply 2
  (text-name aux-fast-reply-name)
  (parse . nil)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (info . lyskom-aux-item-info))

(def-aux-item cross-reference 3
  (text-name aux-cross-reference-name)
  (status-print . lyskom-status-print-cross-reference)
  (text-print-when . comment)
  (parse . lyskom-parse-cross-reference)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (text-print . lyskom-print-cross-reference)
  (edit-insert . lyskom-edit-insert-cross-reference)
  (info  . lyskom-aux-item-info))

(def-aux-item no-comments 4
  (text-name aux-no-comments-name)
  (text-print-when . footer)
  (parse . lyskom-parse-no-comments)
  (text-print . lyskom-print-no-comments)
  (edit-insert . lyskom-edit-insert-no-comments)
  (info  . lyskom-aux-item-info))

(def-aux-item personal-comment 5
  (text-name aux-personal-comment-name)
  (text-print-when . footer)
  (parse . lyskom-parse-personal-comments)
  (text-print . lyskom-print-personal-comments)
  (edit-insert . lyskom-edit-insert-personal-comments)
  (info  . lyskom-aux-item-info))

(def-aux-item request-confirmation 6
  (text-name aux-request-confirmation-name)
  (text-print-when . header)
  (parse . lyskom-parse-request-confirmation)
  (text-print . lyskom-print-request-confirmation)
  (edit-insert . lyskom-edit-insert-request-confirmation)
  (info  . lyskom-aux-item-info)
  (read-action . lyskom-request-confirmation-action))

(def-aux-item read-confirm 7
  (text-name aux-read-confirm-name)
  (text-print-when . header)
  (text-print . lyskom-print-read-confirm)
  (info  . lyskom-aux-item-info))

(def-aux-item redirect 8
  (text-name aux-redirect-name)
  (print . lyskom-print-redirect)
  (info  . lyskom-aux-item-info))

(def-aux-item x-face 9
  (text-name aux-x-face-name)
  (print . lyskom-print-xface)
  (info  . lyskom-aux-item-info))

(def-aux-item alternate-name 10
  (text-name aux-alternate-name-name)
  (text-print-when . header)
  (text-print . lyskom-print-alternate-name)
  (encode-data . lyskom-aux-item-encode-data)
  (parse-data . lyskom-aux-item-decode-data)
  (info  . lyskom-aux-item-info))

(def-aux-item pgp-signature 11
  (text-name aux-pgp-signature-name)
  (info  . lyskom-aux-item-info))

(def-aux-item pgp-public-key 12
  (text-name aux-pgp-public-key-name)
  (info  . lyskom-aux-item-info))

(def-aux-item e-mail-address 13
  (text-name aux-e-mail-address-name)
  (info  . lyskom-aux-item-info))

(def-aux-item faq-text 14
  (text-name aux-faq-text-name)
  (info . lyskom-aux-item-info)
  (text-header-line . (faq-in-text faq-in-text-by))
  (status-print . lyskom-status-print-faq-text))

(def-aux-item creating-software 15
  (text-name aux-creating-software-name)
  (info . lyskom-aux-item-info)
  (text-print-when . header)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (text-print . lyskom-print-creating-software))

(def-aux-item mx-author 16
  (text-name aux-mx-author-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-from 17
  (text-name aux-mx-from-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-reply-to 18
  (text-name aux-mx-reply-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-to 19
  (text-name aux-mx-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-cc 20
  (text-name aux-mx-cc-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-date 21
  (text-name aux-mx-date-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-message-id 22
  (text-name aux-mx-message-id-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-in-reply-to 23
  (text-name aux-mx-in-reply-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-misc 24
  (text-name aux-mx-misc-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-allow-filter 25
  (text-name aux-mx-allow-filter-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-reject-forward 26
  (text-name aux-mx-reject-forward-name)
  (info . lyskom-aux-item-info))

(def-aux-item notify-comments 27
  (text-name aux-notify-comments-name)
  (info . lyskom-aux-item-info))

(def-aux-item faq-for-conf 28
  (text-name aux-faq-for-conf-name)
  (text-print . lyskom-print-faq-for-conf)
  (text-print-when . header)
  (info . lyskom-aux-item-info)
  (read-action . lyskom-faq-for-conf-action))


(def-aux-item recommended-conf 29
  (text-name aux-recommended-conf-name)
  (status-print . lyskom-print-recommended-conf)
  (info . lyskom-aux-item-info))

(def-aux-item allowed-content-type 30
  (text-name aux-allowed-content-type-name)
  (info . lyskom-aux-item-info))

(def-aux-item canonical-name 31
  (text-name aux-canonical-name-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-list-name 32
  (text-name aux-mx-list-name-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-mx-list-name))

(def-aux-item send-comments-to 33
  (text-name aux-send-comments-to-name)
  (info . lyskom-print-aux-item-info)
  (status-print . lyskom-print-send-comments-to))

(def-aux-item world-readable 34
  (text-name aux-world-readable-name)
  (info . lyskom-aux-item-info)
  (text-print . lyskom-print-world-readable)
  (parse . lyskom-parse-world-readable)
  (edit-insert . lyskom-edit-insert-world-readable)
  (text-print-when . header))

(def-aux-item elisp-client-read-faq 10000
  (text-name aux-elisp-client-read-faq-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-elisp-client-read-faq))

(def-aux-item elisp-client-rejected-invitation 10001
  (text-name aux-elisp-client-rejected-invitation-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-elisp-client-rejected-invitation))


;;; ================================================================



(defun lyskom-aux-item-decode-data (item)
  (set-aux-item->data 
   item
   (decode-coding-string (aux-item->data item) lyskom-server-coding-system)))

(defun lyskom-aux-item-encode-data (item)
  (encode-coding-string (aux-item->data item) lyskom-server-coding-system)
  )


(defun lyskom-aux-item-info (item header)
  (let ((def (lyskom-find-aux-item-definition item)))
    
    (concat 
     (lyskom-get-string 'aux-item-for)
     header
     "\n"
     (lyskom-format
      'aux-item-info
      (aux-item->aux-no item)
      (aux-item->tag item)
      (if def
          (lyskom-aux-item-definition->name def)
        "unknown")
      (aux-item->creator item)
      (lyskom-format-time 'date-and-time (aux-item->sent-at item))
      (if (aux-item-flags->deleted (aux-item->flags item))
          (format "(%s)" (lyskom-get-string 'deleted))
        "")
      (mapconcat 'identity
                 (delq nil
                       (list
                        (and (aux-item-flags->secret (aux-item->flags item))
                             (lyskom-get-string 'secret))
                        (and (aux-item-flags->anonymous (aux-item->flags item))
                             (lyskom-get-string 'hide-creator))
                        (and (aux-item-flags->inherit (aux-item->flags item))
                             (lyskom-get-string 'inherit))))
                 ", ")
      (cond ((not (aux-item-flags->inherit (aux-item->flags item)))
             (lyskom-get-string 'no-inheritance))
            ((zerop (aux-item->inherit-limit item))
             (lyskom-get-string 'unlimited-inherit))
            ((eq 1  (aux-item->inherit-limit item))
             (lyskom-get-string 'no-more-inherit))
            (t (lyskom-format 'inherit-steps
                              (1- (aux-item->inherit-limit item)))))
      (aux-item->data item)))))

                 

(defun lyskom-print-content-type (item &optional obj)
  (concat (lyskom-format 'content-type-aux (aux-item->data item))
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-parse-content-type ()
  (and (looking-at (lyskom-get-string 'content-type-regexp))
       (match-string 1)))

(defun lyskom-parse-cross-reference ()
  (or (and (looking-at (lyskom-get-string 'cross-reference-text-regexp))
           (concat "T" (match-string 1)))
      (and (looking-at (lyskom-get-string 'cross-reference-conf-regexp))
           (concat "C" (match-string 1)))
      (and (looking-at (lyskom-get-string 'cross-reference-pers-regexp))
           (concat "P" (match-string 1)))))

(defun lyskom-edit-insert-cross-reference (item pers)
  (concat
   (lyskom-print-cross-reference item nil pers)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-print-cross-reference (item &optional obj pers)
  (let ((pers (if (and (zerop (aux-item->creator item))
                       pers)
                  pers
                (aux-item->creator item))))
    (concat
     (cond ((string-match "^P\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-pers-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           ((string-match "^C\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-conf-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           ((string-match "^T\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-text-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           (t (lyskom-format 'strange-cross-reference 
                             (aux-item->data item)
                             pers
                             )))
     (lyskom-aux-item-terminating-button item obj)
     )))

(defun lyskom-status-print-cross-reference (item &optional obj pers)
  (lyskom-insert 
   (concat
    (cond ((string-match "^P\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-pers-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          (aux-item->creator pers)
                          ))
          ((string-match "^C\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-conf-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          pers
                          ))
          ((string-match "^T\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-text-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          (aux-item->creator pers)
                          ))
          (t (lyskom-format 'strange-cross-reference-status 
                            (aux-item->data item)
                            (aux-item->creator pers)
                            )))
    (lyskom-aux-item-terminating-button item obj)
    "\n")))  

(defun lyskom-parse-no-comments ()
  (and (looking-at (lyskom-get-string 'no-comments-regexp))
       ""))

(defun lyskom-print-no-comments (item &optional obj)
  (concat (lyskom-format 'no-comments-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-no-comments (item &optional obj)
  (concat
   (lyskom-format 'no-comments-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-parse-personal-comments ()
  (and (looking-at (lyskom-get-string 'personal-comment-regexp))
       ""))

(defun lyskom-print-personal-comments (item &optional obj)
  (concat (lyskom-format 'personal-comment-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-personal-comments (item &optional obj)
  (concat
   (lyskom-format 'personal-comment-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-parse-request-confirmation ()
  (and (looking-at (lyskom-get-string 'request-confirmation-regexp))
       ""))

(defun lyskom-print-request-confirmation (item &optional obj)
  (concat (lyskom-format 'request-confirmation-aux
                         (aux-item->creator item))
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-request-confirmation (item &optional obj)
  (concat
   (lyskom-format 'request-confirmation-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-faq-for-conf-action (text-stat)
  (let ((faqs (text-stat-find-aux text-stat 28)))
    (lyskom-traverse aux faqs
      (lyskom-register-read-faq (string-to-int (aux-item->data aux))
                                (text-stat->text-no text-stat)))))

(defun lyskom-request-confirmation-action (text-stat)
  (let ((confirmations (text-stat-find-aux text-stat 7))
        (have-confirmation nil))
    (while confirmations
      (when (eq lyskom-pers-no (aux-item->creator (car confirmations)))
        (setq have-confirmation t)
        (setq confirmations nil))
      (setq confirmations (cdr confirmations)))
    (when  (not have-confirmation)
      (lyskom-scroll)
      (when (lyskom-j-or-n-p
             (lyskom-format (lyskom-get-string 'confirm-read-q)
                            text-stat))
        (let ((item (lyskom-create-aux-item 0 7 lyskom-pers-no
                                            nil 
                                            (lyskom-create-aux-item-flags
                                             nil nil nil nil nil nil nil nil)
                                            0 "")))
          (initiate-modify-text-info 'background
                                     nil
                                     (text-stat->text-no text-stat)
                                     nil
                                     (list item))
          (cache-del-text-stat (text-stat->text-no text-stat)))))))

(defun lyskom-print-read-confirm (item &optional obj)
  (concat 
   (lyskom-format 'read-confirm-aux
                  (aux-item->creator item)
                  (lyskom-format-time 'date-and-time (aux-item->sent-at item)))
   (lyskom-aux-item-terminating-button item obj)))



(defun lyskom-print-redirect (item &optional obj)
  (concat
   (cond ((string-match "^E-mail:\\(.*\\)$" (aux-item->data item))
          (lyskom-format 'redirect-email-aux 
                         (match-string 1 (aux-item->data item))))
         ((string-match "^LysKOM:\\(.*\\)$" (aux-item->data item))
          (lyskom-format 'redirect-lyskom-aux 
                         (string-to-int 
                          (match-string 1 (aux-item->data item))))))
   (lyskom-aux-item-terminating-button item obj)))   


(defun lyskom-print-xface (item &optional obj)
  (lyskom-xemacs-or-gnu
   (lyskom-maybe-add-face-to-string item
                                    (make-string 0 ?X))
   nil))

(defun lyskom-maybe-add-face-to-string (item string)
  (lyskom-xemacs-or-gnu
   (if (null item)
       string
     (setq item (car item))
     (unless (find-face 'kom-xface)
       (make-face 'kom-xface))
     (let* ((h (concat "X-Face: " (aux-item->data item)))
            (g (intern h lyskom-xface-cache))
            (e (make-extent 0 (length string) string)))
       (if (boundp g)
           (setq g (symbol-value g))
         (set g (make-glyph
                 (list
                  (list 'global (cons '(tty) [nothing]))
                  (list 'global (cons '(win) 
                                      (vector 'xface ':data h))))))
         (setq g (symbol-value g))
         (set-glyph-face g 'kom-xface))
       (set-extent-begin-glyph e g)
       (set-extent-property e 'end-open nil)
       (set-extent-property e 'start-open nil)
       (set-extent-property e 'duplicable t)
       string))
   string))


(defun lyskom-print-alternate-name (item &optional obj)
  (concat "[" (aux-item->data item) "] "
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-faq-format-subject (text text-stat text-no)
  (if (and text text-stat)
      (concat "\""
	      (cond ((string-match "\n" (text->decoded-text-mass text text-stat))
		     (substring (text->decoded-text-mass text text-stat) 0 (match-beginning 0)))
		    (t ""))
	      "\"")
    (lyskom-format 'no-such-text-no text-no)))

(defun lyskom-deferred-print-faq (text-stat defer-info)
  (if text-stat
      (initiate-get-text 
       'deferred 
       (lambda (text text-stat defer-info)
         (lyskom-replace-deferred defer-info 
                                  (lyskom-format "%#1r" 
                                                 (lyskom-print-faq-format-subject text
                                                                                  text-stat
                                                                                  (defer-info->data defer-info)))))
       (text-stat->text-no text-stat)
       text-stat
       defer-info)
    (lyskom-replace-deferred defer-info
                             (lyskom-print-faq-format-subject nil nil (defer-info->data defer-info)))))

(defun lyskom-status-print-faq-text (item &optional obj)
  (let* ((text-no (string-to-int (aux-item->data item)))
         (subject (if kom-deferred-printing
                      (lyskom-create-defer-info 'get-text-stat
                                                text-no
                                                'lyskom-deferred-print-faq
                                                nil nil nil
                                                text-no)
                    (blocking-do-multiple ((text (get-text text-no))
                                           (text-stat (get-text-stat text-no)))
                      (lyskom-print-faq-format-subject text text-stat text-no)))))
    (lyskom-format-insert 'faq-in-text-aux 
                          text-no
                          subject)
    (lyskom-insert (lyskom-aux-item-terminating-button item obj))
    (lyskom-insert "\n")))

(defun lyskom-print-faq-for-conf (item &optional obj)
  (let ((conf-no (string-to-int (aux-item->data item))))
    (concat 
     (cond ((zerop conf-no) (lyskom-get-string 'faq-for-server-aux))
          (t (lyskom-format 'faq-for-conf-aux conf-no)))
     (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-creating-software (item &optional obj)
  (when (or kom-show-creating-software
            (lyskom-viewing-noconversion))
    (concat
     (lyskom-format 'creating-software-aux (aux-item->data item))
     (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-send-comments-to (item &optional obj)
  (when (string-match "^\\([0-9]+\\)" (aux-item->data item))
    (let ((conf-no (string-to-int (match-string 1 (aux-item->data item)))))
      (lyskom-format-insert 'status-send-comments-to
                            conf-no 
                            (lyskom-aux-item-terminating-button item obj)))))



(defun lyskom-parse-world-readable ()
  (and (looking-at (regexp-quote 
                    (lyskom-get-string 'world-readable-text-edit-aux)))
       ""))

(defun lyskom-edit-insert-world-readable (item &optional obj)
  (concat
   (lyskom-format 'world-readable-text-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-print-world-readable (item &optional obj)
  (concat (lyskom-format 'world-readable-text-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-mx-list-name (item &optional obj)
  (lyskom-format-insert 'conf-mx-list-name 
                        (aux-item->data item)
                        (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-recommended-conf (item &optional obj)
  (let ((conf-no (string-to-int (if (string-match " " (aux-item->data item))
                                    (substring (aux-item->data item) 0 (match-beginning 0))
                                  (aux-item->data item)))))
    (lyskom-format-insert 'recommended-conf-aux
                          conf-no
                          (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-elisp-client-read-faq (item &optional obj)
  (when kom-extended-status-information
    (when (string-match "^\\([0-9]+\\) \\([0-9]+\\)" (aux-item->data item))
      (let ((conf-no (string-to-int (match-string 1 (aux-item->data item))))
            (text-no (string-to-int (match-string 2 (aux-item->data item)))))
        (lyskom-format-insert 'status-read-faq-aux-item 
                              conf-no 
                              text-no
                              (lyskom-aux-item-terminating-button item obj))))))

(defun lyskom-print-elisp-client-rejected-invitation (item &optional obj)
  (when (string-match "^\\([0-9]+\\)" (aux-item->data item))
    (let ((conf-no (string-to-int (match-string 1 (aux-item->data item)))))
      (lyskom-format-insert 'status-rejected-recommendation-aux-item
                            conf-no 
                            (lyskom-aux-item-terminating-button item obj)))))

(provide 'lyskom-aux-items)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: mime.el,v 44.7 2002/07/23 18:28:41 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: mime.el
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: mime.el,v 44.7 2002/07/23 18:28:41 byers Exp $\n"))

(defvar lyskom-charset-alist
  '(((ascii)						. us-ascii)
    ((ascii latin-iso8859-1)				. iso-8859-1)
    ((ascii latin-iso8859-2)				. iso-8859-2)
    ((ascii latin-iso8859-3)				. iso-8859-3)
    ((ascii latin-iso8859-4)				. iso-8859-4)
    ((ascii cyrillic-iso8859-5)				. iso-8859-5)
;;; ((ascii cyrillic-iso8859-5)				. koi8-r)
    ((ascii arabic-iso8859-6)				. iso-8859-6)
    ((ascii greek-iso8859-7)				. iso-8859-7)
    ((ascii hebrew-iso8859-8)				. iso-8859-8)
    ((ascii latin-iso8859-9)				. iso-8859-9)
    ((ascii latin-iso8859-15)				. iso-8859-15)
    ((ascii latin-jisx0201
	    japanese-jisx0208-1978 japanese-jisx0208)	. iso-2022-jp)
    ((ascii latin-jisx0201
	    katakana-jisx0201 japanese-jisx0208)	. shift_jis)
    ((ascii korean-ksc5601)				. euc-kr)
    ((ascii chinese-gb2312)				. gb2312)
    ((ascii chinese-big5-1 chinese-big5-2)		. big5)
    ((ascii latin-iso8859-1 greek-iso8859-7
	    latin-jisx0201 japanese-jisx0208-1978
	    chinese-gb2312 japanese-jisx0208
	    korean-ksc5601 japanese-jisx0212)		. iso-2022-jp-2)
    ;; ((ascii latin-iso8859-1 greek-iso8859-7
    ;;         latin-jisx0201 japanese-jisx0208-1978
    ;;         chinese-gb2312 japanese-jisx0208
    ;;         korean-ksc5601 japanese-jisx0212
    ;;         chinese-cns11643-1 chinese-cns11643-2)      . iso-2022-int-1)
    ))


(defun lyskom-mime-string-charset (data)
  (let* ((cs (find-charset-string data))
         (tmp lyskom-charset-alist)
         (best-guess (let ((system nil))
                       (while (and tmp cs)
                         (if (lyskom-subset-p cs (car (car tmp)))
                             (setq system (cdr (car tmp)) tmp nil)
                           (setq tmp (cdr tmp))))
                       system)))
    (or
     best-guess
     (lyskom-xemacs-or-gnu
      lyskom-server-coding-system
      (let ((coding (find-coding-systems-for-charsets cs)))
        (while (null (coding-system-get (car coding) 'mime-charset))
          (setq coding (cdr coding)))
        (coding-system-get (car coding) 'mime-charset)))
    lyskom-server-coding-system)))

(defun lyskom-mime-charset-coding-system (charset)
  (condition-case nil
      (and (check-coding-system charset)
           charset)
    (error 'raw-text)))

(defun lyskom-mime-encode-string (data)
  (let* ((mime-charset (lyskom-mime-string-charset data))
         (coding-system (lyskom-mime-charset-coding-system mime-charset)))
    (when (and mime-charset coding-system)
      (cons mime-charset (encode-coding-string data coding-system)))))

(defun lyskom-mime-decode-string (data charset)
  (let* ((coding-system (lyskom-mime-charset-coding-system charset)))
    (if coding-system
        (decode-coding-string data coding-system)
      data)))

(defun lyskom-mime-decode-content-type (data)
  (string-match "^\\([^;]*\\)\\(;.*charset=\\([^;]*\\)\\)?" data)
  (cons (match-string 1 data)
        (if (match-string 3 data)
            (intern (match-string 3 data))
          nil)))

(provide 'lyskom-mime)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: prefetch.el,v 44.23 2002/02/24 20:23:27 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;;
;;;; File: prefetch.el
;;;;
;;;; This file contains the functions that make up the prefetch
;;;; system.
;;;;
;;;; Author: Inge Wallin
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: prefetch.el,v 44.23 2002/02/24 20:23:27 joel Exp $\n"))


;;; ================================================================
;;;                          Variables.


(def-kom-var lyskom-prefetch-stack nil
  "A stack where all prefetch requests are entered. New items are entered
first and when an item is to be prefetched, it is taken from the front of 
this list. 

Each entry is either the atom 'DONE, a cons cell as described below or a 
lyskom-queue.

\('CONFSTAT . number\) - The conf stat of Conference NUMBER.
\('PERSSTAT . number\) - The pers stat of person NUMBER.
\('TEXTSTAT . number\) - The text stat of text NUMBER.
\('TEXTMASS . number\) - The text mass of text NUMBER.
\('TEXTAUTH . number\) - The text stat of the text NUMBER 
                       and the conf-stat of the author of it.
\('TEXT-ALL . number\) - The text stat and mass of text NUMBER, but also
                       all information that will be used when writing
                       this text for the user to see, such as conf-stat
                       for the author, text stats for commented texts,
                       comments, a.s.o.
\('TEXTTREE . number\) - The text stat, author, textauth of comments to 
		       and texttree of all comments and footnotes.
\('CONFSTATFORMAP conf-no first-local\) - The conf-stat of the conference
		       number CONF-NO is fetched and then we continue
		       to fetch the map.
\('MAP conf-stat first-local\) -
                       The next part of the map in conference CONF-STAT.
		       The length fetched per revolution is according to
		       the value of lyskom-fetch-map-nos.
\('MARKS\) -             The whole list of marked texts and then every info about
		       these texts.
\('WHOBUFFER\) -         The who-is-on-info to construct the who-buffer.
\('MEMBERSHIP . pers-no\) -
		       The next part of the membership for person PERS-NO
		       is fetched. How long we already have fetched is
		       kept in the variable lyskom-membership-is-read. If 
		       lyskom-membership-is-read is not a number then we
		       are done.
		       For every membership-part we fetch the conf-stats
		       before continuing with the next part.
\('MEMBERSHIPISREAD\) -  Just sets the lyskom-membership-is-read variable to t.
\('CANCELED . rest\)   Whatever it was, it has been canceled.


See further documentation in the source code."
  local)

;;;
;;; The four requests CONFSTAT, PERSSTAT, TEXTSTAT and TEXTMASS are 
;;; called simple requests and are handled immediately and removed.
;;; The others are called complex requests.  These will each generate
;;; further requests when they return.  
;;; 
;;; When one of the simple requests are sent to the server, the atom
;;; DONE is swapped for the request.
;;;
;;; When one of the complex requests are sent to the server, a
;;; lyskom-queue is swapped for the request and a pointer to the queue
;;; is sent to the handler.  When the call returns the new requests this 
;;; call generates will all be put on the queue.  This process can be
;;; repeated and a queue might contain other queues and so on.  
;;; 
;;; When the prefetch code is searching for a new request to process it
;;; always starts searching at the beginning of the variable 
;;; lyskom-prefetch-stack.  If an empty queue is encountered, it is simply
;;; skipped since this significates a complex request that has already 
;;; been sent and is awaiting its result.  A non-empty queue is recursively
;;; searched and treated in the same way as the original stack.
;;; 


(def-kom-var lyskom-prefetch-in-action nil
  "t when the prefetch-process is started and going."
  local)


(defvar lyskom-inhibit-prefetch nil
  "Set this to a non-nil value locally to inhibit the prefetch.
This is used to prevent the prefetch code to reenter itself.")


(def-kom-var lyskom-pending-prefetch 0
  "Variable counting the number of unfinished prefetch requests."
  local)


;;; ================================================================
;;;                 Functions callable from the outside


(defun lyskom-setup-prefetch ()
  "Sets up the prefetch process in lyskom."
  (setq lyskom-prefetch-stack (lyskom-stack-create))
  (setq lyskom-pending-prefetch 0)
  (setq lyskom-membership-is-read 0))


;;; =================================================================
;;; Functions to cancel some prefetches

(defun lyskom-prefetch-cancel-prefetch-map (conf-no &optional queue)
;;;  (let ((prefetch-list (if queue
;;;                           (lyskom-queue->all-entries queue)
;;;                         (lyskom-stack->all-entries lyskom-prefetch-stack))))
;;;    (lyskom-traverse el prefetch-list
;;;      (cond
;;;       ((lyskom-queue-p el)
;;;        (lyskom-prefetch-cancel-prefetch-map conf-no el))
;;;       ((not (consp el)) nil)
;;;       ((or (and (eq (car el) 'MAP) 
;;;                 (eq (conf-stat->conf-no (elt el 1)) conf-no))
;;;            (and (eq (car el) 'CONFSTATFORMAP)
;;;                 (eq (elt el 1) conf-no)))
;;;        (setcar el 'CANCELED))
;;;       )))
)


;;;; ================================================================
;;; +++ lyskom-reset-prefetch  to be called on client reset.
;;;                            must restart everything.
;;; +++ THIS DOES NOT WORK CURRENTLY
(defun lyskom-reset-prefetch ()
  "Reset the prefetch system."
  ;; (lyskom-wait-queue 'prefetch)
  (lyskom-setup-prefetch))


(defsubst lyskom-membership-is-read ()
  "Return t if the while membership list has been fetched, and nil otherwise."
  (eq lyskom-membership-is-read 't))

(defun lyskom-fetch-start-of-map (conf-stat membership)
  "Block fetching map for MEMBERSHIP until we see a text.
Start the prefetch for the remainder of the map."
  (let ((first-local (1+ (membership->last-text-read membership)))
        (last-local (1- (+ (conf-stat->no-of-texts conf-stat)
                           (conf-stat->first-local-no conf-stat))))
        (done nil))
    (while (not done)
      (let ((map (blocking-do 'get-map 
                              (membership->conf-no membership)
                              first-local
                              lyskom-fetch-map-nos)))
        (setq first-local (+ first-local lyskom-fetch-map-nos))
        (lyskom-enter-map-in-to-do-list map conf-stat membership)
        (cond ((and (map->text-nos map)
                    (< first-local last-local)
                    (> (length (map->text-nos map)) 0))
               (setq done t)
               (lyskom-prefetch-map-using-conf-stat conf-stat
                                                    first-local
                                                    membership)
               )

              ((< first-local last-local))
              (t (setq done t)))))))

(defun lyskom-prefetch-conf (conf-no &optional queue)
  "Prefetch the conf-stat for the conference with number CONF-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if conf-no
      (if queue
	  (lyskom-queue-enter queue (cons 'CONFSTAT conf-no))
	(lyskom-stack-push lyskom-prefetch-stack (cons 'CONFSTAT conf-no)))
    (signal 'lyskom-internal-error "No argument to lyskom-prefetch-conf"))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-pers (pers-no &optional queue)
  "Prefetch the pers-stat for person with number PERS-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'PERSSTAT pers-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'PERSSTAT pers-no)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-text (text-no &optional queue)
  "Prefetch the text-stat for the text with number TEXT-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'TEXTSTAT text-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXTSTAT text-no)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-textmass (text-no &optional queue)
  "Prefetch the text mass for the text with number TEXT-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'TEXTMASS text-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXTMASS text-no)))
  (lyskom-continue-prefetch))
  

(defun lyskom-prefetch-textauth (text-no &optional queue)
  "Prefetch the text stat and the author of text number TEXT-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'TEXTAUTH text-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXTAUTH text-no)))
  (lyskom-continue-prefetch))
  

(defun lyskom-prefetch-text-all (text-no &optional queue)
  "Prefetch all info about the text with number TEXT-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'TEXT-ALL text-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXT-ALL text-no)))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-text-stat-all (text-stat &optional queue)
  "Prefetch all info about the text with text stat TEXT-STAT.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (when (null queue)
    (setq queue (lyskom-queue-create))
    (lyskom-stack-push lyskom-prefetch-stack queue))
  (lyskom-prefetch-text-all-handler text-stat queue))


(defun lyskom-prefetch-texttree (text-no &optional queue only-new)
  "Prefetch all info about the text with number TEXT-NO and descends recursively.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack.

If ONLY-NEW is non-nil and the text-stat in question is already
prefetched the prefetch is not done."
  (if (and only-new
	   (cache-get-text-stat text-no))
      nil
    (if queue
	(lyskom-queue-enter queue (cons 'TEXTTREE text-no))
      (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXTTREE text-no))))
  (lyskom-continue-prefetch))
  

(defun lyskom-prefetch-membership (pers-no &optional queue)
  "h{mtar medlemsskapet i sm} delar och d{refter conf-stat f|r m|tena"
  (if queue
      (lyskom-queue-enter queue (cons 'MEMBERSHIP pers-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'MEMBERSHIP pers-no)))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-one-membership (conf-no pers-no &optional queue)
  (if queue
      (lyskom-queue-enter queue (list 'ONE-MEMBERSHIP conf-no pers-no))
    (lyskom-stack-push lyskom-prefetch-stack (list 'ONE-MEMBERSHIP
                                                   conf-no pers-no)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-map (conf-no membership &optional queue)
  "Prefetches a map for conf CONFNO."
  (lyskom-prefetch-map-from conf-no
			    (1+ (membership->last-text-read membership))
			    membership
			    queue))


(defun lyskom-prefetch-map-from (conf-no first-local membership
					 &optional queue)
  "Prefetches a map for conf CONFNO starting att FIRST-LOCAL."
  (if queue
      (lyskom-queue-enter queue (list 'CONFSTATFORMAP
				      conf-no first-local membership))
    (lyskom-stack-push lyskom-prefetch-stack
		       (list 'CONFSTATFORMAP
			     conf-no first-local membership)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-map-using-conf-stat (conf-stat first-local membership
						      &optional queue)
  "Prefetches a map for conf CONFSTAT starting att FIRST-LOCAL."
  (if queue
      (lyskom-queue-enter queue (list 'MAP conf-stat first-local membership))
    (lyskom-stack-push lyskom-prefetch-stack (list 'MAP
						   conf-stat first-local
						   membership)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-all-conf-stats (&optional queue)
  "+++"
  nil)


(defun lyskom-prefetch-marks (&optional queue)
  "Prefetches the list of marked texts. Then all texts are fetched."
  (if queue
      (lyskom-queue-enter queue (list 'MARKS))
    (lyskom-stack-push lyskom-prefetch-stack (list 'MARKS)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-who-is-on (&optional queue)
  "Prefetches the list of persons on the system."
  (if queue
      (lyskom-queue-enter queue (list 'WHOBUFFER))
    (lyskom-stack-push lyskom-prefetch-stack (list 'WHOBUFFER)))
  (lyskom-continue-prefetch))


;;(defun lyskom-prefetch-all-conf-texts (&optional queue)
;;  "Prefetches the texts in all conferences."
;;  (if queue
;;      (lyskom-queue-enter queue (list 'ALL-CONF-TEXTS))
;;    (lyskom-stack-push lyskom-prefetch-stack (list 'ALL-CONF-TEXTS)))
;;  (lyskom-continue-prefetch))


;;(defun lyskom-prefetch-conf-texts (text-list &optional queue)
;;  "Prefetches the texts in all conferences."
;;  (if (null (text-list->texts text-list))
;;      nil
;;    (if queue
;;	(lyskom-queue-enter queue (list 'CONF-TEXTS text-list))
;;      (lyskom-stack-push lyskom-prefetch-stack (list 'CONF-TEXTS text-list))))
;;  (lyskom-continue-prefetch))

(defun lyskom-prefetch-texts (texts &optional queue)
  "Prefetches a list of texts."
  (if (null texts)
      nil
    (if queue
	(lyskom-queue-enter queue
			    (list 'TEXTS texts))
      (lyskom-stack-push lyskom-prefetch-stack
			 (list 'TEXTS texts))))
  (lyskom-continue-prefetch))

;; (defun lyskom-prefetch-text-list-continue (texts &optional queue)
;;   "Prefetches a list of texts."
;;   (if (null texts)
;; 	 nil
;;     (if queue
;; 	   (lyskom-queue-enter queue (list 'TEXT-LIST-CONT texts))
;; 	 (lyskom-stack-push lyskom-prefetch-stack
;; 			    (list 'TEXT-LIST-CONT texts))))
;;   (lyskom-continue-prefetch))


;;; ================================================================
;;;           Functions internal to the prefetch package


(defun lyskom-stop-prefetch ()
  "Stop the prefetch process temporarily."
  (setq lyskom-prefetch-in-action nil))


(defun lyskom-start-prefetch ()
  "Start the whole prefetch process"
  (setq lyskom-prefetch-in-action t)
  (lyskom-continue-prefetch))


(defun lyskom-continue-prefetch ()
  "Called after each prefetch is finished and also when the whole prefetch
process is started. Used to keep prefetch going."
  (if (not lyskom-inhibit-prefetch)
      (let ((lyskom-inhibit-prefetch t)) ; Make sure we don't call this 
					; recursively
	(while (and (< lyskom-pending-prefetch
		       lyskom-prefetch-limit)
		    (lyskom-prefetch-one-item)
		    ;; Only increase lyskom-pending-prefetch if a server
		    ;; call was made.
		    ;;
		    ;; The return value from lyskom-prefetch-one-item
		    ;; is whether it has sent a server call, but it
		    ;; should really be if the prefetch-stack has been
		    ;; altered. See the comment in
		    ;; lyskom-prefetch-one-item.
		    (++ lyskom-pending-prefetch))))))


(defun lyskom-skip-finished-in-queue (queue)
  "Remove all 'DONE entries and queues who's only entry is 'FINISHED."
  (let ((element nil)
	(done nil))
    (while (not done)
      (setq element (lyskom-queue->first queue))
      (if (or (eq element 'DONE)
              (and (consp element) 
                   (eq (car element) 'CANCELED))
	      (and (lyskom-queue-p element)
		   (eq (lyskom-queue->first element) 'FINISHED)))
	  (lyskom-queue-delete-first queue)
	(setq done t)))))


(defun lyskom-prefetch-one-item ()
  "Get the first element of the prefetch data structure and fetch it.
Return t if an element was prefetched, otherwise return nil."
  (let ((result nil)
	element
	(prefetch-list (lyskom-stack->all-entries lyskom-prefetch-stack))
	(list-stack (lyskom-stack-create))
    	(done nil))

    ; Remove all finished entries at the top of lyskom-prefetch-stack
    (while (not done)
      (setq element (lyskom-stack->top lyskom-prefetch-stack))
      (if (or (eq element 'DONE)
              (and (consp element)
                   (eq (car element) 'CANCELED))
	      (and (lyskom-queue-p element)
		   (eq (lyskom-queue->first element) 'FINISHED)))
	  (lyskom-stack-pop lyskom-prefetch-stack)
	(setq done t)))

    (while (and (not result)
		prefetch-list)
      (let ((element (car prefetch-list))
	    (rest-list (cdr prefetch-list)))
	(cond
	 ((eq element 'DONE) nil)
	 ((eq element 'FINISHED) nil)
         ((and (consp element)
               (eq (car element) 'CANCELED)) nil)

	 ;; A queue ==> check it out first.
	 ((lyskom-queue-p element)
	  (lyskom-skip-finished-in-queue element)
	  (if (lyskom-queue-isempty element)
	      nil
	    (lyskom-stack-push list-stack rest-list)
	    (setq rest-list (lyskom-queue->all-entries element))))
       
	 ;; A simple request?
	 ((and (listp element)
	       (memq (car element)
		     '(CONFSTAT PERSSTAT TEXTSTAT TEXTMASS)))
	  (setcar prefetch-list 'DONE)
	  (lyskom-prefetch-one-request element nil)
	  (setq result t))

	 ;; A complex request?
	 ((and (listp element)
	       (memq (car element)
		     '(TEXTAUTH TEXT-ALL TEXTTREE ONE-MEMBERSHIP
				CONFSTATFORMAP MAP MARKS
				MEMBERSHIP WHOBUFFER TEXTS)))
	  (let ((queue (lyskom-queue-create)))
	    (setcar prefetch-list queue)
	    (lyskom-prefetch-one-request element queue)
	    (setq result t)))

	 ;; Special requests
	 ((and (listp element)
	       (memq (car element) '(MEMBERSHIPISREAD ALL-CONF-TEXTS)))
	  (if (eq (car element) 'MEMBERSHIPISREAD)
	      (setq lyskom-membership-is-read t)
	    ;; Temporarily disabled
	    (let ((queue (lyskom-queue-create)))
	      (setcar prefetch-list queue)
	      (mapcar
	       (lambda (read-info)
		 (mapcar
		  (lambda (text-no)
		    (lyskom-prefetch-text-all text-no queue))
		  (text-list->texts (read-info->text-list read-info))))
	       (read-list->all-entries lyskom-to-do-list))
	      (lyskom-queue-enter queue 'FINISHED)))

	  ;; This is an ugly hack. If this function returns a non-nil
	  ;; value, lyskom-prefetch-continue will assume that a server
	  ;; call was made and increase lyskom-pending-prefetch. But
	  ;; no server call has been made, so we decrease
	  ;; lyskom-pending-prefetch "in advance". The reason that
	  ;; this sets result to t is that we want the loop in
	  ;; lyskom-continue-prefetch to keep running, as there is no
	  ;; server response that will wake the prefetch up in the
	  ;; future.
	  ;;(-- lyskom-pending-prefetch)
	  ;;(setq result t)
	  )

	 (t (signal 'lyskom-internal-error 
		    '(lyskom-prefetch-one-item ": unknown key"))))
	
	(setq prefetch-list rest-list)
	(if (not (or prefetch-list
		     (lyskom-stack-isempty list-stack)))
	    (setq prefetch-list (lyskom-stack-pop list-stack)))))

    result))


(defun lyskom-prefetch-one-request (request queue)
  "Prefetch REQUEST. If the request is complex, put the resulting requests on QUEUE."
;  (message "Prefetch: %s" request)
  (cond
   ((eq (car request) 'CONFSTAT)
    (initiate-get-conf-stat 'prefetch
			    'lyskom-prefetch-handler (cdr request)))
   ((eq (car request) 'PERSSTAT)
    (initiate-get-pers-stat 'prefetch
			    'lyskom-prefetch-handler (cdr request)))
   ((eq (car request) 'TEXTSTAT)
    (initiate-get-text-stat 'prefetch
			    'lyskom-prefetch-handler (cdr request)))
   ((eq (car request) 'TEXTMASS)
    (initiate-get-text 'prefetch 'lyskom-prefetch-handler (cdr request)))
   ((eq (car request) 'TEXTAUTH)
    (initiate-get-text-stat 'prefetch 'lyskom-prefetch-textauth-handler 
			    (cdr request) queue))
   ((eq (car request) 'TEXT-ALL)
    (initiate-get-text-stat 'prefetch 'lyskom-prefetch-text-all-handler
			    (cdr request) queue))
   ((eq (car request) 'TEXTTREE)
    (initiate-get-text-stat 'prefetch 'lyskom-prefetch-texttree-handler
			    (cdr request) queue))

   ((eq (car request) 'ONE-MEMBERSHIP)
    (initiate-query-read-texts 'prefetch
                               'lyskom-prefetch-read-texts-handler
                               (elt request 2)
                               (elt request 1)
                               (elt request 1)
                               queue))

   ((eq (car request) 'MEMBERSHIP)
    (if (numberp lyskom-membership-is-read) ; Are we done?
	(initiate-get-part-of-membership 
	 'prefetch 'lyskom-prefetch-membership-handler
	 (cdr request)
	 lyskom-membership-is-read lyskom-fetch-membership-length 
	 (cdr request)
	 queue)
      ; We are done
      (lyskom-prefetch-handler)))
   ((eq (car request) 'CONFSTATFORMAP)
    (initiate-get-conf-stat 'prefetch 'lyskom-prefetch-confstatformap-handler
			    (nth 1 request) (nth 2 request) (nth 3 request)
			    queue))
   ((eq (car request) 'MAP)
    (initiate-get-map 'prefetch 'lyskom-prefetch-map-handler
		      (conf-stat->conf-no
		       (nth 1 request))	; conf-stat
		      (nth 2 request)	; first-local
		      lyskom-fetch-map-nos
		      (nth 1 request)	; conf-stat
		      (nth 2 request)	; first-local
		      (nth 3 request)	; membership
		      queue))
   ((eq (car request) 'MARKS)
    (initiate-get-marks 'prefetch 'lyskom-prefetch-marks-handler queue))
   ((eq (car request) 'WHOBUFFER)
    (initiate-who-is-on 'prefetch 'lyskom-prefetch-whobuffer-handler queue))
   ((eq (car request) 'TEXTS)
    (initiate-get-text-stat 'prefetch 'lyskom-prefetch-texts-handler
			    (car (nth 1 request))
			    (cdr (nth 1 request))
			    queue))
   
   (t (signal 'lyskom-internal-error
	      (list "lyskom-prefetch-one-request - unknown key:"
		    (car request))))))


;;; ================================================================
;;;      Functions which handle the results of complex requests.


(defun lyskom-prefetch-textauth-handler (text-stat queue)
  "Prefetch the conf-stat of the author of the text TEXT-STAT.
Put the request on QUEUE."
  (lyskom-stop-prefetch)
  (if (not text-stat)
      nil
    (lyskom-prefetch-conf (text-stat->author text-stat) queue)
    (lyskom-queue-enter queue 'FINISHED))
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-text-all-handler (text-stat queue)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT.
Put the requests on QUEUE."
  (lyskom-stop-prefetch)
  (lyskom-prefetch-conf (text-stat->author text-stat) queue)
  (lyskom-prefetch-textmass (text-stat->text-no text-stat) queue)
  (lyskom-traverse
   misc
   (text-stat->misc-info-list text-stat)
   (let ((type (misc-info->type misc)))
     (cond
      ((memq type '(RECPT BCC-RECPT CC-RECPT))
       (lyskom-prefetch-conf (misc-info->recipient-no misc) queue))
      ((eq type 'COMM-IN)
       (lyskom-prefetch-textauth (misc-info->comm-in misc) queue))
      ((eq type 'FOOTN-IN)
       (lyskom-prefetch-textauth (misc-info->footn-in misc) queue))
      ((eq type 'COMM-TO)
       (lyskom-prefetch-textauth (misc-info->comm-to misc) queue))
      ((eq type 'FOOTN-TO)
       (lyskom-prefetch-textauth (misc-info->footn-to misc) queue))
      (t nil))))
  (lyskom-queue-enter queue 'FINISHED)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-texttree-handler (text-stat queue)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT.
Then prefetch all info (texttree) of comments.
Put the requests on QUEUE."
  (if (not text-stat)
      nil				; We did not get anything
    (lyskom-stop-prefetch)
    (lyskom-prefetch-conf (text-stat->author text-stat) queue)
    (lyskom-prefetch-textmass (text-stat->text-no text-stat) queue)
    (lyskom-traverse
     misc
     (text-stat->misc-info-list text-stat)
     (let ((type (misc-info->type misc)))
       (cond
	((memq type '(RECPT BCC-RECPT CC-RECPT))
	 (lyskom-prefetch-conf (misc-info->recipient-no misc) queue))
	((eq type 'COMM-IN)
	 (lyskom-prefetch-texttree (misc-info->comm-in misc) queue t))
	((eq type 'FOOTN-IN)
	 (lyskom-prefetch-texttree (misc-info->footn-in misc) queue t))
	((eq type 'COMM-TO)
	 (lyskom-prefetch-textauth (misc-info->comm-to misc) queue))
	((eq type 'FOOTN-TO)
	 (lyskom-prefetch-textauth (misc-info->footn-to misc) queue))
	(t nil))))
    (lyskom-queue-enter queue 'FINISHED))
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-read-texts-handler (membership pers-no queue)
  (lyskom-stop-prefetch)
  (-- lyskom-pending-prefetch)
  (when membership
    (unless (lyskom-try-get-membership (membership->conf-no membership) t)
      (lyskom-add-memberships-to-membership (list membership))
      (when (and (lyskom-visible-membership membership)
                 (lyskom-prefetch-map (membership->conf-no membership)
                                      membership
                                      queue)))))
  (lyskom-queue-enter queue 'FINISHED)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-membership-handler (memberships pers-no queue)
  "Handle the return of the membership prefetch call."
  (lyskom-stop-prefetch)
  (let ((size (length memberships))
	(i 0)
;;; Commented out 1999-06-28 byers
;;; Used by removed code below
;;;        (old-mships (mapcar (lambda (mship)
;;;                              (and (lyskom-try-get-membership
;;;                                    (membership->conf-no mship))
;;;                                   (membership->conf-no mship)))
;;;                            memberships))
        )
    (lyskom-insert-memberships-in-membership memberships)
    (while (< i size)
      (let ((membership (aref memberships i)))
;;; Commented out 1999-06-26 byers
;;; This should not be necessary since we know that all of these
;;; maps were empty when we started the client. Texts created after
;;; the client was started should end up in the reading list anyway
;;; 'cuase they generate asynchronous messages.
;;;	(if (and (lyskom-visible-membership membership)
;;;                 (not (memq (membership->conf-no membership) old-mships)))
;;;	    (lyskom-prefetch-map (membership->conf-no membership)
;;;				 membership
;;;				 queue))
)
      (++ i))
    (if (and (numberp lyskom-membership-is-read)
	     (< (length memberships) lyskom-fetch-membership-length))
	(progn
	  (setq lyskom-membership-is-read 'almost)
	  (lyskom-queue-enter queue (list 'MEMBERSHIPISREAD)))
      (setq lyskom-membership-is-read (+ lyskom-membership-is-read
					 lyskom-fetch-membership-length))
      (lyskom-prefetch-membership pers-no queue)
      ))
  (lyskom-queue-enter queue 'FINISHED)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-confstatformap-handler (conf-stat first-local
							 membership queue)
  "Now that we have the conf-stat we can fetch the map."
  (lyskom-stop-prefetch)
  (lyskom-prefetch-map-using-conf-stat conf-stat first-local membership queue)
  (lyskom-queue-enter queue 'FINISHED)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-map-handler (map conf-stat first-local membership queue)
  "Handle the return of the membership prefetch call.
Maps are `cached' in lyskom-to-do-list."
  (lyskom-stop-prefetch)
  (let ((next-start (+ first-local lyskom-fetch-map-nos))
	(last-local (1- (+ (conf-stat->no-of-texts conf-stat)
		  (conf-stat->first-local-no conf-stat)))))
    (when map
      ;; An old version of this function tester if the map contained no
      ;; texts. That is not a correct termination condition.
      (when (< next-start last-local)
	(lyskom-prefetch-map-using-conf-stat conf-stat
					     next-start
					     membership
					     queue))
      (lyskom-enter-map-in-to-do-list map conf-stat membership)))
  (lyskom-queue-enter queue 'FINISHED)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch)
  (lyskom-update-prompt)
  (lyskom-set-mode-line))

(defun lyskom-prefetch-marks-handler (marks queue)
  "Handle the list of marked texts."
  (cache-set-marked-texts marks)
  (lyskom-stop-prefetch)
  (let ((list (cache-get-marked-texts)))
    (while list
      (lyskom-prefetch-text-all (mark->text-no (car list)) queue)
      (setq list (cdr list))))
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-whobuffer-handler (who-is-on queue)
  "Handle the who-is-on info. The goal here is to get an updated who-buffer."
  ;+++ should be done later
  (cache-initiate-who-info-buffer who-is-on lyskom-buffer)
  (-- lyskom-pending-prefetch)
  )

(defun lyskom-prefetch-texts-handler (text-stat texts queue)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT.
Put the requests on QUEUE."
  (lyskom-stop-prefetch)
  (lyskom-prefetch-conf (text-stat->author text-stat) queue)
  (lyskom-prefetch-textmass (text-stat->text-no text-stat) queue)
  (lyskom-traverse
      misc
      (text-stat->misc-info-list text-stat)
    (let ((type (misc-info->type misc)))
      (cond
       ((memq type '(RECPT BCC-RECPT CC-RECPT))
	(lyskom-prefetch-conf (misc-info->recipient-no misc) queue))
       ((eq type 'COMM-IN)
	(lyskom-prefetch-textauth (misc-info->comm-in misc) queue))
       ((eq type 'FOOTN-IN)
	(lyskom-prefetch-textauth (misc-info->footn-in misc) queue))
       ((eq type 'COMM-TO)
	(lyskom-prefetch-textauth (misc-info->comm-to misc) queue))
       ((eq type 'FOOTN-TO)
	(lyskom-prefetch-textauth (misc-info->footn-to misc) queue))
       (t nil))))
  (lyskom-queue-enter queue 'FINISHED)
  ;; The queue is now used up.
  (lyskom-prefetch-texts texts)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))

(defun lyskom-prefetch-handler (&rest data)
  "Handler called after each simple prefetch request is done."
  (-- lyskom-pending-prefetch)
  (lyskom-continue-prefetch))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: startup.el,v 44.80 2002/08/12 20:41:19 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: startup.el
;;;;
;;;; This file contains functions that are called only when lyskom
;;;; is loaded, started or when a new user is logged in during a 
;;;; session.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: startup.el,v 44.80 2002/08/12 20:41:19 byers Exp $\n"))


;;; ================================================================
;;;                         Start kom.


(defvar lyskom-www-proxy-connect-phase 1
  "Phase when reading connection response from www-proxy:
1: (initial phase) waiting for the
   string \"HTTP/1.0 2000 Connection established\"
2: we have seen the connection string. After this, it may come lines stating
   proxy-agents and other things. They all seem to end with an empty line,
   so in this phase we wait for an empty line.")


(eval-and-compile
  (defun lyskom-compilation-in-progress ()
    "Returns non-nil if the client currently is being compiled, else nil."

    ;; This horrid code is inspired from how cl-compiling-file in the
    ;; cl package works.
    (let ((outbuffersym (lyskom-xemacs-or-gnu 'byte-compile-outbuffer
                                              'outbuffer)))
      (and (boundp outbuffersym)
           (bufferp (symbol-value outbuffersym))
           (equal (buffer-name (symbol-value outbuffersym))
                  " *Compiler Output*")))))


(defconst lyskom-is-running-compiled
  (eval-when-compile (lyskom-compilation-in-progress))
  "Non-nil if the client is running compiled, else nil.")


;;;###autoload
(defun lyskom (&optional host username password session-priority invisiblep)
  "Start a LysKOM session.
Optional arguments: HOST, USERNAME, PASSWORD and INVISIBLEP.

A numeric prefix argument sets the session priority. A prefix argument
of `C-u', on the other hand, logs in the session without notifying other
clients of the event. See lyskom-mode for details on lyskom."
  (interactive (list (lyskom-read-server-name
		      (lyskom-format 'server-q
				     (or (getenv "KOMSERVER")
					 lyskom-default-server)))
		     nil
		     nil
		     (if current-prefix-arg
			 (prefix-numeric-value current-prefix-arg)
		       nil)
		     (and current-prefix-arg (listp current-prefix-arg))))

  (run-hooks 'lyskom-init-hook)
  (setq username
	(or username (getenv "KOMNAME")))
  (setq password
	(or password (getenv "KOMPASSWORD")))
  (if (zerop (length host))
      (let* ((env-kom (getenv "KOMSERVER"))
	     (canon (lyskom-string-rassoc env-kom kom-server-aliases)))
	(setq host (or (car canon)
		       env-kom
		       lyskom-default-server))))
  (let ((port 4894)
	(init-done nil))
    (cond				;Allow "nanny:4892" to use port 4892.
     ((string-match ":" host)
      (setq port (string-to-int (substring host (match-end 0))))
      (cond
       ((zerop (match-beginning 0))
	(setq host lyskom-default-server))
       (t
	(setq host (substring host 0 (match-beginning 0)))))))

    (let* ((duplicate-buffers
            (delq nil
                  (mapcar (lambda (buffer)
                            (and (lyskom-buffer-p buffer t)
                                 (buffer-name buffer)
                                 (string-match (regexp-quote host)
                                               (buffer-name buffer))
                                 (save-excursion (set-buffer buffer)
                                                 (and 
                                                  (boundp 'lyskom-server-port)
                                                  (eq port lyskom-server-port)))
                                 buffer))
                          (buffer-list))))
	   (name nil)
	   (proc nil)
           (buffer (car duplicate-buffers))
	   ;; (alive (lyskom-buffer-p buffer))
           (reused-buffer nil))
      

      ;;<<<<<<< startup.el
      ;;      (if (and buffer
      ;;	       alive
      ;;=======
      (if (and (lyskom-buffer-p buffer nil)
	       (not (prog1
			(j-or-n-p (lyskom-get-string
				   'start-new-session-same-server))
		      (message ""))))
	  (progn 
            (switch-to-buffer buffer)
            (setq reused-buffer t))
	(unwind-protect
	    (progn
	      (cond ((and buffer (not (lyskom-buffer-p buffer)))
		     (set-buffer buffer)
                     (setq reused-buffer t)
		     (goto-char (point-max))
                     (lyskom-insert
                      (format (lyskom-get-string 'new-session-in-buffer)
                              (lyskom-format-time
                               'timeformat-day-yyyy-mm-dd-hh-mm-ss)))
                     (setq name (buffer-name buffer)))
		    (t
		     (setq buffer (lyskom-generate-new-buffer host))
		     (setq name (buffer-name buffer))))
              (let* ((www-proxy-host-string
                      (cond ((stringp kom-www-proxy) kom-www-proxy)
                            ((listp kom-www-proxy)
                             (or (cdr (lyskom-string-assoc host kom-www-proxy))
                                 (cdr (assq t kom-www-proxy))
                                 nil))
                            (t nil)))
                     (www-proxy-host nil)
                     (www-proxy-port nil)
                     (match (string-match "\\(.*\\):\\([0-9]+\\)"
                                          (or www-proxy-host-string "")))
                     (headers nil))
                (setq www-proxy-host (or (and match
                                          (match-string 1 www-proxy-host-string))
                                     www-proxy-host-string)
                      www-proxy-port (or (and match
                                          (string-to-int
                                           (match-string 2
                                                         www-proxy-host-string)))
                                     80))
                (cond (www-proxy-host
                       (setq headers 
                             (cond ((stringp kom-www-proxy-headers)
                                    (list kom-www-proxy-headers))
                                   ((and (listp kom-www-proxy-headers)
                                         (stringp (car kom-www-proxy-headers)))
                                    kom-www-proxy-headers)
                                   ((and (listp kom-www-proxy-headers)
                                         (consp (car kom-www-proxy-headers)))
                                    (cdr (or (lyskom-string-assoc www-proxy-host
                                                                  kom-www-proxy-headers)
                                             (assq t kom-www-proxy-headers))))))
                       (setq proc (lyskom-open-network-stream name buffer
                                                              www-proxy-host
                                                              www-proxy-port))
                       ;; We do explicit coding
                       (set-process-coding-system proc 'no-conversion 'no-conversion)

		       ;; Install our filter.
		       ;; Do this before we send the CONNECT command to
		       ;; the proxy, in case the proxy answers fast.
		       (setq lyskom-www-proxy-connect-phase 1)
		       (set-process-filter proc
					   'lyskom-www-proxy-connect-filter)
		       (process-kill-without-query proc nil)

                       (lyskom-process-send-string 
                        proc
                        (format "CONNECT %s:%d HTTP/1.0\r\n"
                                host port))

                       (mapcar (lambda (header)
                                 (lyskom-process-send-string proc header)
                                 (lyskom-process-send-string proc "\r\n"))
                               headers)
                       (lyskom-process-send-string proc "\r\n")


		       ;; Now wait for the answer from the proxy
		       ;;
		       ;; This is because anything we send before the
		       ;; connection ack will be thrown away by the proxy
		       ;; so it is bad to try to start talking with the
		       ;; server before the connection is up.
		       (while (eq 'lyskom-www-proxy-connect-filter
				  (process-filter proc))
			 (accept-process-output proc))
		       ;; Now the proxy has connected to the kom server
		       )
                      (t (setq proc (lyskom-open-network-stream name buffer
                                                                host port))
                         ;; We do explicit coding
                         (set-process-coding-system proc 'no-conversion 'no-conversion))))
	      (switch-to-buffer buffer)
	      (lyskom-mode)		;Clearing lyskom-default...
	      (setq lyskom-buffer buffer)
	      (setq lyskom-default-user-name username)
	      (setq lyskom-default-password password)
	      (setq lyskom-server-name host)
	      (setq lyskom-server-port port)
	      (setq lyskom-proc proc)
	      (lyskom-setup-faces)
	      (lyskom-insert
	       (lyskom-format 'try-connect lyskom-clientversion host))
	      (set-process-filter proc 'lyskom-connect-filter)
              (process-kill-without-query proc nil)
	      (lyskom-process-send-string
	       proc
	       (concat "A"
		       (lyskom-format-objects
			(concat (user-login-name)
				"%" (system-name)))
                       "\n"))
	      (while (eq 'lyskom-connect-filter (process-filter proc))
		(accept-process-output proc))
	      ;; Now we have got the correct response.
	      (set-process-sentinel proc 'lyskom-sentinel)

	      (save-excursion
		(lyskom-init-parse buffer))

              ;; Async messages
              (lyskom-accept-async)

	      ;; +++PREFETCH+++
	      (lyskom-setup-prefetch)

	      ;; Tell the server who we are
	      (initiate-set-client-version 'background nil
					   "lyskom.el" lyskom-clientversion)

              (setq lyskom-server-version-info (blocking-do 'get-version-info))
              (when (or (null lyskom-server-version-info)
                        (<= (version-info->protocol-version 
                             lyskom-server-version-info) 7))
                (lyskom-error 'too-old-server))
	      (lyskom-setup-client-for-server-version)

	      (setq lyskom-server-info (blocking-do 'get-server-info))
	      (lyskom-format-insert 
	       'connection-done
	       (version-info->software-version lyskom-server-version-info))

              (when (lyskom-have-call 85)
                (setq lyskom-collate-table (blocking-do 'get-collate-table))
                (setq lyskom-char-classes nil)
                (lyskom-update-command-completion))
	      (if (not (zerop (server-info->motd-of-lyskom
			       lyskom-server-info)))
		  (blocking-do-multiple ((text (get-text 
                                                (server-info->motd-of-lyskom
                                                 lyskom-server-info)))
                                         (text-stat (get-text-stat
                                                     (server-info->motd-of-lyskom
                                                      lyskom-server-info))))
		    (lyskom-format-insert "%#1t\n"
		     (if (and text text-stat)
			 (text->decoded-text-mass text text-stat)
		       (lyskom-get-string 'lyskom-motd-was-garbed))
                     (when kom-highlight-text-body
                       '(face kom-text-body-face)))))

	      ;; Can't use lyskom-end-of-command here.
	      (setq lyskom-executing-command nil)
	      ;; Log in
	      (kom-start-anew t session-priority invisiblep)
	      (if (memq lyskom-buffer lyskom-buffer-list)
		  (while (not (eq lyskom-buffer (car lyskom-buffer-list)))
		    (setq lyskom-buffer-list
			  (nconc (cdr lyskom-buffer-list)
				 (list (car lyskom-buffer-list)))))
		(setq lyskom-buffer-list
		      (cons lyskom-buffer lyskom-buffer-list)))
              ;; We're done
	      (setq init-done t)
              )
	  ;; Something went wrong. Lets cleanup everything. :->
	  (if init-done
	      nil
	    (if proc (delete-process proc))
	    (unless reused-buffer (kill-buffer buffer))))))))


(defun lyskom-accept-async ()
  (blocking-do 'accept-async '(5 7 8 9 11 12 13 14 15 16 17 18))
  (let* ((ans (blocking-do 'query-async)))
    (unless (memq 15 (listify-vector ans))
      (blocking-do 'accept-async '(0 5 7 8 9 11 12 13 14 16 17 18)))))


(defun lyskom-www-proxy-connect-filter (proc output)
  "Receive connection acknowledgement from proxy."
  (if lyskom-debug-communications-to-buffer
      (lyskom-debug-insert proc "-----> " output))
  (cond
   ((and (= lyskom-www-proxy-connect-phase 1)
	 (string-match "^HTTP/1\\.. 200.*\r\n" output))
    (setq lyskom-www-proxy-connect-phase 2)
    ;; safety check: see if the empty line is already in this output
    (lyskom-www-proxy-connect-filter proc output))

   ((and (= lyskom-www-proxy-connect-phase 2)
	 (string-match "^\r\n" output))
    (set-process-filter proc 'lyskom-connect-filter))))

(defun lyskom-open-network-stream (name buffer host service)
  (let ((relay (lyskom-setup-ssh-relay host service buffer)))
    (if relay
        (open-network-stream name
                             buffer
                             "127.0.0.1"
                             (get relay 'relay-port))
    (open-network-stream name
                         buffer
                         host
                         service))))


(defun lyskom-setup-ssh-relay (server port kom-buffer)
  (when kom-ssh-relay-host
    (let* ((procname (format "ssh<%s:%s:%d>" kom-ssh-relay-host server port))
           (bufname (concat " *" procname "*"))
           (proc (get-process procname))
           (procsym (intern procname))
           (relay-port (and proc
                            (eq (process-status proc) 'run)
                            (get procsym 'relay-port)))
           (msg nil))
      (unwind-protect
          (save-excursion
            (set-buffer (get-buffer-create bufname))
            (if relay-port
                (lyskom-message 
                 "%s" 
                 (lyskom-format (setq msg 'using-ssh-connection)
                                kom-ssh-relay-host))
              (when proc (delete-process proc))
              (setq relay-port (+ 10000 (random 20000)))
              (put procsym 'relay-host 
                   (if (string-match "@" kom-ssh-relay-host)
                       (substring kom-ssh-relay-host (1+ (match-beginning 0)))
                     kom-ssh-relay-host))
              (put procsym 'relay-port relay-port)
              (put procsym 'num-connected 0)
              (lyskom-message
               "%s"
               (lyskom-format (setq msg 'opening-ssh-connection)
                              kom-ssh-relay-host))
              (goto-char (point-max))
              (insert "\n--- new connection ---\n")
              (let ((old-lc-all (getenv "LC_ALL")))
                (unwind-protect
                    (progn
                      (setenv "LC_ALL" "C")
                      (setq proc (start-process
                                  procname
                                  bufname
                                  "ssh" "-n" "-x"
                                  "-L" (format "%d:%s:%d" relay-port server port)
                                  kom-ssh-relay-host
                                  "sh -c \"while :; do echo ok; sleep 600; done\"")))
                  (setenv "LC_ALL" old-lc-all)))
              (process-kill-without-query proc))
            (while (progn
                     (goto-char (point-max))
                     (re-search-backward "^--- .* ---$" nil t)
                     (not (re-search-forward "^ok$" nil t)))
              (when (re-search-forward "\\<\\(Enter passphrase.*$\\|^.*password.*$\\)\\|refused\\|disconnect\\|denied\\|error\\|key not found\\>" nil t)
                (cond ((match-string 1)
                       (process-send-string 
                        proc
                        (concat (silent-read (match-string 1)) "\n"))
                       (delete-region (match-beginning 0) 
                                      (match-end 0)))
                      (t (error (lyskom-get-string 'ssh-cant-connect)
                                (buffer-substring-no-properties
                                 (progn (beginning-of-line) (point))
                                 (progn (skip-chars-forward "^\n\r")
                                        (point)))))))
              (sleep-for 0.5))
            (setq proc nil)
            (lyskom-message 
             "%s"
             (lyskom-format (concat 
                             (lyskom-format msg kom-ssh-relay-host)
                             (lyskom-get-string 'done)))))
        (if proc (delete-process proc)))

      (save-excursion 
        (set-buffer kom-buffer)
        (put procsym 'num-connected (1+ (or (get procsym 'num-connected) 0)))
        (make-local-variable 'lyskom-ssh-proxy)
        (setq lyskom-ssh-proxy procsym))
      )))


(defun lyskom-setup-client-for-server-version ()
  "Setup flags according to protocol versions."
  (lyskom-clear-features)
  (let ((protocol-version 
         (version-info->protocol-version lyskom-server-version-info)))

  (when (>= protocol-version 10)
    (lyskom-set-feature bcc-misc t)
    (lyskom-set-feature aux-items t)
    (lyskom-set-feature highest-call 105)
    (lyskom-set-feature local-to-global t))

  (when (>= protocol-version 9)
    (lyskom-set-feature dynamic-session-info t)
    (lyskom-set-feature idle-time t))

  (when (>= protocol-version 8)
    (lyskom-set-feature long-conf-types t))))


(defun lyskom-connect-filter (proc output)
  "Receive connection acknowledgement from server."
  (if lyskom-debug-communications-to-buffer
      (lyskom-debug-insert proc "-----> " output))
  (cond
   ((string-match "^LysKOM\n" output)
    (set-process-filter proc 'lyskom-filter))))





;;; ================================================================
;;;                        Start anew


(defun kom-start-anew (&optional lyskom-first-time-around session-priority invisiblep)
  "Start/login as a new person. If INVISIBLEP is not nil, the login will not be
shown to other users."
  (interactive)
  (lyskom-start-of-command 'kom-start-anew)
  (lyskom-completing-clear-cache)
  (let ((new-me nil)
	(login-successful nil)
        (ignored-user-area-vars nil))
    (unwind-protect
        (progn
          (if lyskom-first-time-around
              nil
            (lyskom-tell-internat 'kom-tell-login))
          ;; We can't allow the prefetch to go on after the new user
          ;; is logged in, but to shut down the prefetch would be too
          ;; brutal, since the new login might be cancelled. To
          ;; prevent the blocking-do calls below from allowing
          ;; prefetch we set lyskom-inhibit-prefetch locally.
          (let ((lyskom-inhibit-prefetch t))
            (while (not new-me)

              (if (and lyskom-first-time-around
                       lyskom-default-user-name)
                  ;; This is nil if we can't find a unique match.
                  (setq new-me
                        (conf-z-info->conf-no
                         (lyskom-lookup-conf-by-name lyskom-default-user-name
                                                     '(pers)))))
              (if new-me
                  nil
                (let ((name nil))
                  (while (or (null name)
                             (string= name ""))
                    (setq name (lyskom-read-conf-name
                                (lyskom-get-string 'what-is-your-name) 
                                '(pers none) t "" t)))
                  (setq new-me
                        (or (conf-z-info->conf-no 
                             (lyskom-lookup-conf-by-name name '(pers)))
                            (lyskom-create-new-person name)))))
              ;; Now new-me contains a number of a person.
              ;; Lets log him in.
              (if new-me
                  (let ((conf-stat (blocking-do 'get-conf-stat new-me))
                        (lyskom-inhibit-minibuffer-messages t))

                    ;; Previously this code used lyskom-pers-no
                    ;; directly instead of new-me, but that caused
                    ;; problem with asynchrounous code trying to
                    ;; access it.
                    ;;
                    ;; Setting lyskom-pers-no fscks up other things
                    ;; if we do keyboard-quit in the middle, so don't.
                    ;;
                    ;; (setq lyskom-pers-no new-me)

                    ;; DEBUG
                    (if (null conf-stat)
                        (lyskom-insert "You don't exist. Go away.\n"))

                    (lyskom-insert (concat (conf-stat->name conf-stat) "\n"))
                    (setq lyskom-first-time-around nil)
                    (if (blocking-do 'login new-me
                                     (if lyskom-default-password
                                         (prog1
                                             lyskom-default-password
                                           (setq lyskom-default-password nil)
                                           (set-default 'lyskom-default-password
                                                        nil))
                                       ;; Use password read when creating
                                       ;; the person when loggin in new
                                       ;; users
                                       (or lyskom-is-new-user
                                           (silent-read
                                            (lyskom-get-string 'password))))
                                     (if invisiblep 1 0))
                        (progn
                          (if lyskom-is-new-user
                              (blocking-do 'add-member
                                           (server-info->conf-pres-conf lyskom-server-info)
                                           new-me
                                           100 
                                           1
                                           (lyskom-create-membership-type
                                            nil nil nil nil nil nil nil nil)))
                          (setq login-successful t))
                      (lyskom-insert-string 'wrong-password)
                      (when (lyskom-get-aux-item 
                             (server-info->aux-item-list lyskom-server-info)
                             13)        ; e-mail
                        (lyskom-insert 'wrong-password-help)
                        (mapcar (lambda (el)
                                  (lyskom-format-insert 'wrong-password-email
                                                        (aux-item->data el)))
                                (lyskom-get-aux-item 
                                 (server-info->aux-item-list lyskom-server-info)
                                 13)    ; e-mail
                                ))
                      (setq new-me nil))
                    (setq lyskom-is-new-user nil))))

            ;; Now we are logged in.
            (setq lyskom-pers-no new-me)
            (lyskom-insert-string 'are-logged-in)

            (unless lyskom-is-running-compiled
              (lyskom-insert-string 'warning-about-uncompiled-client))

            (unless lyskom-dont-read-user-area
              (setq ignored-user-area-vars (lyskom-read-options)))
            (when (or session-priority kom-default-session-priority)
              (setq lyskom-session-priority
                    (or session-priority kom-default-session-priority)))
            (lyskom-run-hook-with-args 'lyskom-change-conf-hook
                                       lyskom-current-conf
                                       0)
            (lyskom-run-hook-with-args 'kom-change-conf-hook
                                       lyskom-current-conf
                                       0)
            (setq lyskom-current-conf 0)
            ;; (cache-initiate-who-info-buffer (blocking-do 'who-is-on))
            (cache-set-marked-texts (blocking-do 'get-marks))
            ;; What is this variable? It is never used. It is ust to
            ;; fill the cache?
            (let ((lyskom-who-am-i (blocking-do 'who-am-i)))
              (if lyskom-who-am-i (setq lyskom-session-no lyskom-who-am-i))))

          ;; If login succeeded, clear the caches and set the language

          (when login-successful
            (progn (clear-all-caches)
                   (unless (eq lyskom-language kom-default-language)   
                     (when (lyskom-set-language kom-default-language 'local)
                       (unless lyskom-have-one-login
                         (lyskom-set-language kom-default-language 'global)
                         (lyskom-maybe-setq-default kom-default-language kom-default-language)
                         (setq-default lyskom-language kom-default-language))
                       (lyskom-format-insert-before-prompt
                        'language-set-to
                        (lyskom-language-name kom-default-language))))
                   (setq lyskom-have-one-login t)))

          (when ignored-user-area-vars
            (lyskom-format-insert-before-prompt
             'ignored-user-area-var
             (mapconcat 'symbol-name 
                        ignored-user-area-vars
                        "\n    ")))

          ;; Show motd and encourage writing a presentation

          (let ((conf-stat (blocking-do 'get-conf-stat lyskom-pers-no)))
            (if (and conf-stat
                     (/= (conf-stat->msg-of-day conf-stat) 0))
                (progn
                  (lyskom-insert-string 'you-have-motd)
                  (lyskom-view-text (conf-stat->msg-of-day conf-stat))))
            (if (and conf-stat
                     (zerop (conf-stat->presentation conf-stat))
                     (not (zerop (conf-stat->no-of-texts conf-stat))))
                (lyskom-insert-string 'presentation-encouragement)))

          (setq lyskom-is-new-user nil)

          ;; Start the prefetch and update some basic caches
          (lyskom-refetch))
      (lyskom-end-of-command)))

  ;; Run the hook kom-login-hook. We don't want to hang the
  ;; login, just because something crashed here.

  (condition-case err
      (progn
        (run-hooks 'lyskom-login-hook)
        (run-hooks 'kom-login-hook))
    (error (lyskom-format-insert-before-prompt
            'error-in-login-hook (format "%s" err)))))


(defun lyskom-refetch ()
  "Resets and fetches all reading info.
This is called at login and after prioritize and set-unread."
  ;; +++PREFETCH+++

  ;; The whole membership!
  ;; (lyskom-set-membership (blocking-do 'get-membership lyskom-pers-no))
  ;; (setq lyskom-membership-is-read t)
  ;; (setq lyskom-unread-confs (blocking-do 'get-unread-confs lyskom-pers-no))

  (setq lyskom-membership nil)

  (setq lyskom-to-do-list (lyskom-create-read-list))
  (setq lyskom-reading-list (lyskom-create-read-list))


  (lyskom-reset-prefetch)
  (let ((lyskom-inhibit-prefetch t))
    (lyskom-prefetch-membership lyskom-pers-no)
    (let ((unreads (blocking-do 'get-unread-confs lyskom-pers-no)))
      (lyskom-traverse conf-no (nreverse (conf-no-list->conf-nos unreads))
        (lyskom-prefetch-one-membership conf-no lyskom-pers-no))))
  (lyskom-start-prefetch)

  (condition-case nil
      (progn (lyskom-update-read-faqs)
             (lyskom-clean-read-faqs lyskom-pers-no)
             (lyskom-update-rejected-recommendations)
             (lyskom-startup-check-faqs)
             (lyskom-startup-check-recommended-memberships))
    (error nil)
    (quit nil)))


(defun lyskom-set-membership (membership)
  "Sets lyskom-membership to a new value.
Args: MEMBERSHIP."
  (setq lyskom-membership (listify-vector membership))
  (lyskom-sort-membership)
  (setq lyskom-membership-is-read t))


(defun lyskom-print-name (conf-stat)
  "Print the name of the CONF-STAT, with a trailing \n."
  (lyskom-insert (concat (conf-stat->name conf-stat) "\n")))


(defun lyskom-extract-persons (conf-list)
  "Extract persons from a conf-list.
Return a list of pers-nos of all conferences that are persons.
Args: CONF-LIST."
  (lyskom-do-extract-persons-or-confs conf-list t))


(defun lyskom-extract-confs (conf-list)
  "Extract conferences from a conf-list.
Return a list of conf-nos of all conferences that are persons.
Args: CONF-LIST."
  (lyskom-do-extract-persons-or-confs conf-list nil))


(defun lyskom-do-extract-persons-or-confs (conf-list want-persons)
  "Extract persons or conferences from CONF-LIST.
WANT-PERSONS is t for persons, nil for confs."
  (let* ((result nil)
	 (i 0)
	 (nos (conf-list->conf-nos conf-list))
	 (types (conf-list->conf-types conf-list))
	 (len (length nos)))
    (while (< i len)
      (cond
       ((eq (conf-type->letterbox (elt types i))
	    want-persons)
	(setq result (cons (elt nos i)
			   result))))
      (++ i))
    (nreverse result)))


(defun lyskom-create-new-person (name)
  "A new user named NAME (or an old that mis-spelled his name)."
  (lyskom-insert
   (lyskom-format 'first-greeting name))
  (lyskom-scroll)
  (cond
   ((ja-or-nej-p (lyskom-format 'is-name-correct name))
    (let ((password (silent-read (lyskom-get-string 'personal-password))))
      (cond
       ((not (equal password 
		    (silent-read (lyskom-get-string 'repeat-password))))
	;; Failed to enter the same password twice
	(lyskom-insert-string 'repeat-failure)
	nil)
       (t
	;; Entered the same password twice
	(let ((new-person (blocking-do 'create-person name
                                       password
                                       (lyskom-create-flags nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil)
                                       nil)))
	  (if (null new-person)
	      (lyskom-insert-string 'could-not-create-you)
	    ;; Raise a flag so the user will be added to the
	    ;; presentation conference after login
	    (setq lyskom-is-new-user password))
	  new-person)))))
   (t
    ;; Do not create a new person
    nil)))


;;(defun lyskom-start-anew-create-handler (pers-no name password)
;;  "A new person has been created. Log in as him."
;;  (cond
;;   ((null pers-no)
;;    (lyskom-insert-string 'could-not-create-you)
;;    (setq lyskom-executing-command nil)
;;    (kom-start-anew))
;;   (t
;;    (initiate-login 'main 'lyskom-add-for-new-person
;;		    pers-no password pers-no lyskom-pers-no)
;;    )))

;;(defun lyskom-add-for-new-person (reply pers-no lyskom-pers-no)
;;  "Add a news person as member in the default presentation conference."
;;  (initiate-add-member 'main 'lyskom-start-anew-login-2
;;		       (server-info->conf-pres-conf lyskom-server-info)
;;		       pers-no 100 1
;;		       pers-no lyskom-pers-no))


(defun lyskom-read-server-name (prompt)
  "Read the name of a LysKOM server.
Copmpletion is done on the servers i kom-server-aliases. If an
alias name is entered, the corresponding address is returned."
  ;; Create a completion table like
  ;; (("kom.lysator.liu.se" . "kom.lysator.liu.se")
  ;;  ("LysKOM" . "kom.lysator.liu.se"))
  (let ((known-servers
	 (append (mapcar (function (lambda (pair)
				     (cons (car pair) (car pair))))
			 kom-server-aliases)
		 (mapcar (function (lambda (pair)
				     (cons (cdr pair) (car pair))))
			 kom-server-aliases)))
	(completion-ignore-case t)
	server)
    (setq server (lyskom-completing-read prompt
                                         (lyskom-maybe-frob-completion-table
                                          known-servers)
                                         nil nil))
    (or (cdr (lyskom-string-assoc server known-servers))
	server)))
      

;;; ================================================================
;;;                        The LysKOM mode.

;; The LysKOM mode should not be inherited if we create a new buffer
;; and default-major-mode is nil.
(put 'lyskom-mode 'mode-class 'special)

(defun lyskom-mode ()
  "\\<lyskom-mode-map>Mode for LysKOM client.
Commands:
\\[kom-next-command]	Do the default action. This can be to read the next text,select
	next conference with unread texts or whatever the prompt says.
\\[kom-go-to-conf]	Go to a conference. LysKOM will ask you for a conference
	and make you a member of it if you are not already.
\\[kom-list-conferences]	List conferences matching a given string.
\\[kom-list-persons]	List persons matching a given string.

\\[kom-list-news]	List the conferences you have unread texts in.
\\[kom-go-to-next-conf]	Go to the next conference with unread texts.

\\[kom-membership]	Display a buffer with the list of conferences you are member in.

\\[kom-quit]	Leave this LysKOM session.
\\[kom-who-is-on]	Show a list of all the users of lyskom right now.

\\[kom-extended-command]	Read a command using the minibuffer and execute it.
	This is another way to give commands.

\\[kom-write-text]	Start writing a new text.
\\[kom-write-comment]	Start writing a comment to the last read article.
\\[kom-private-answer]	Start writing a personal answer to the author of the last
	read article.
\\[kom-send-letter]	Start writing a letter to a person or conference.

\\[kom-page-next-command]	Clear the page and do what \\[kom-next-command] does.
\\[kom-line-next-command]	Do what \\[kom-next-command] does, but scroll at most 1 line.

0 .. 9	Give a numeric argument to the next command.
\\[describe-mode]	Display this help text.

\\[kom-busy-wait]	Put the lyskom-session in wait mode. The next created text with 
	a priority higher than that of the next conference you are going
	to will be read directly when it is created.
\\[kom-set-unread]	Mark a number of texts as unread.
\\[kom-jump]	Skip (mark as read) all the comments to this article recursively.
\\[kom-display-time]	Show the current date and time.

\\[kom-change-presentation]	Change your presentation.
\\[kom-view]	View the specified text.
\\[kom-view-commented-text]	View the text that the current text comments or is a footnote to.
\\[kom-review-presentation]	Show the presentation for a person or a conferencce.

\\[kom-review-comments]	View all comments to the current text.
\\[kom-review-tree]	View all comments to the current text and step through the tree
	in depth-first order.

\\[kom-find-root-review]	View the complete comment tree.
\\[kom-find-root]	Show the root text of this comment tree.
\\[kom-review-by-to]	View the last (first or all) article written by named author
	in a named conference.

\\[kom-mark-text]	Create a mark on a text.
\\[kom-unmark-text]	Remove the mark on a text.
\\[kom-review-marked-texts]	View all text marked with a certain mark.
\\[kom-review-all-marked-texts]	View all marked text.

\\[kom-view-next-new-text]	Read the next text from the list of unread.
\\[kom-review-next]	Continue the viewing.
\\[kom-review-stack]	Show the stack of things we are viewing.
\\[kom-review-clear]	Clear the stack of things we are viewing.
\\[kom-review-backward]	Toggles the read order of reviewed texts. This can only be done
	when viewing texts with \\[kom-review-by-to], \\[kom-review-marked-texts] and \\[kom-review-all-marked-texts].

\\[kom-status-conf]	Show the status of a conference.
\\[kom-status-person]	Show the status of a person
\\[kom-save-text]	Save the text you are looking at to a file.

\\[kom-get-abuse]	Get an insulting text.
\\[kom-get-appreciation]	Get an encouraging text.

\\[kom-add-self]	Become a member of a conference.
\\[kom-sub-self]	Removes you as a member of a conference.

All bindings (this is here due to the fact that inconsistensies while 
developping this package are frequent):
\\{lyskom-mode-map}
Entry to this mode runs lyskom-mode-hook.

Functions and variables beginning with kom- are intended for the user to see,
set or call.
Functions and variables beginning with lyskom- are not intended for the user
to see, set of call."
  (interactive)
  (lyskom-clear-vars)
  (setq mode-line-buffer-identification
	(list (concat (lyskom-mode-name-from-host) ": ") 'mode-line-conf-name))

  (setq major-mode 'lyskom-mode)
  (setq mode-name "LysKOM")
  (setq mode-line-process (lyskom-get-string 'mode-line-working))
  (use-local-map lyskom-mode-map)
  (lyskom-set-menus 'lyskom-mode lyskom-mode-map)
  (run-hooks 'lyskom-mode-hook)

  (buffer-disable-undo (current-buffer))
  (setq buffer-read-only t))

(defun lyskom-clear-vars ()
  "Set up buffer-local vars."
  (lyskom-save-variables (lyskom-proc
                          lyskom-pers-no
                          lyskom-membership
                          lyskom-membership-is-read
                          lyskom-last-viewed
                          lyskom-unparsed-buffer
                          lyskom-unparsed-marker
                          lyskom-server-info
                          lyskom-server-name)
      (kill-all-local-variables))
    (lyskom-setup-local-variables)
    (setq lyskom-do-when-done (cons kom-do-when-done kom-do-when-done))
    (setq lyskom-output-queues (make-vector 10 nil))
    (setq lyskom-collate-table lyskom-default-collate-table)
    (setq lyskom-char-classes nil)
    (let ((i 0))
      (while (< i 10)
        (aset lyskom-output-queues i (lyskom-queue-create))
        (setq i (1+ i))))
    (setq lyskom-pending-calls nil)
    (lyskom-set-mode-line
     (lyskom-get-string 'not-present-anywhere)))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: reading.el,v 44.14 2002/02/24 20:23:27 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: reading.el
;;;;
;;;; This file contains functions that manage membership and reading
;;;; lists, namely lyskom-membersip lyskom-reading-list and
;;;; lyskom-to-do-list. These are called both from prefetch and from
;;;; startup procedures.
;;;; 

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: reading.el,v 44.14 2002/02/24 20:23:27 joel Exp $\n"))


(defun lyskom-enter-map-in-to-do-list (map conf-stat membership)
  "Takes a MAP and enters all its listed text-nos in the conference CONF-STAT.
This works by modifying the lyskom-to-do-list which in some cases
also means modifying the lyskom-reading-list. The zero text-nos are skipped."
  (let ((list (lyskom-list-unread map membership))
        (mship (lyskom-try-get-membership (conf-stat->conf-no conf-stat))))
    (when (and list mship)
      (read-list-enter-read-info
       (lyskom-create-read-info 
	'CONF conf-stat
	(membership->priority 
	 (lyskom-try-get-membership (conf-stat->conf-no conf-stat)))
	(lyskom-create-text-list
	 list))
       lyskom-to-do-list))))


(defun lyskom-sort-membership ()
  "Sort the internal membership list."
  (setq lyskom-membership (sort lyskom-membership 'lyskom-membership-<))
  (lyskom-update-membership-positions))

(defun lyskom-update-membership-positions ()
  "Update all the position fields in the memberships in the membership list."
  (let ((mship lyskom-membership)
        (num 0))
    (while mship 
      (set-membership->position (car mship) num)
      (setq num (1+ num) mship (cdr mship)))
  ;; FIXME: If something changed, tell the server.
    (lyskom-sort-to-do-list)))

(defun lyskom-add-memberships-to-membership (memberships)
  "Adds a newly fetched MEMBERSHIP-PART to the list in lyskom-membership.
If an item of the membership is already read and entered in the
lyskom-membership list then this item is not entered."
  (save-excursion
    (set-buffer lyskom-buffer)
    (let ((list (listify-vector memberships)))
      (while list
        ;; If membership is already added or passive, don't add it
        (if (memq (membership->conf-no (car list))
                  (mapcar (function membership->conf-no) lyskom-membership))
            nil
          (setq lyskom-membership (append lyskom-membership (list (car list)))))
        (setq list (cdr list))))))

(defun lyskom-insert-memberships-in-membership (memberships)
  (save-excursion
    (set-buffer lyskom-buffer)
    (let ((list (listify-vector memberships)))
      (while list
        ;; If membership is already added or passive, don't add it
        (if (memq (membership->conf-no (car list))
                  (mapcar (function membership->conf-no) lyskom-membership))
            nil
          (setq lyskom-membership (cons (car list) lyskom-membership)))
        (setq list (cdr list))))
    (lyskom-sort-membership)))


(defun lyskom-do-insert-membership (membership)
  (if (membership->position membership)
      (setq lyskom-membership
            (cond ((elt lyskom-membership (membership->position membership))
                   (lyskom-insert-in-list 
                    membership
                    lyskom-membership
                    (elt lyskom-membership
                         (membership->position membership))))
                  ((>= (membership->position membership) 0)
                   (nconc lyskom-membership (list membership)))
                  (t (cons membership lyskom-membership))))
    (let ((mship-list lyskom-membership)
          (found nil))
      (while mship-list
        (when (<= (membership->priority (car mship-list))
                  (membership->priority membership))
          (setq lyskom-membership
                (lyskom-insert-in-list membership
                                       lyskom-membership
                                       (car mship-list))
                mship-list nil
                found t))
        (setq mship-list (cdr mship-list)))
      (unless found (setq lyskom-membership
                          (nconc lyskom-membership (list membership)))))))

(defun lyskom-insert-membership (membership)
  "Add MEMBERSHIP into lyskom-membership, sorted by priority."
  (save-excursion
    (set-buffer lyskom-buffer)
    (lyskom-do-insert-membership membership)
    (lyskom-update-membership-positions)))

(defun lyskom-replace-membership (membership)
  "Find the membership for the same conference as MEMBERSHIP, and
replace it with MEMBERSHIP into lyskom-membership."
  (save-excursion
    (set-buffer lyskom-buffer)
    (when (lyskom-try-get-membership (membership->conf-no membership) t)
      (lyskom-do-remove-membership (membership->conf-no membership))
      (lyskom-do-insert-membership membership)
      (lyskom-run-hook-with-args 'lyskom-replace-membership-hook
                                 membership
                                 lyskom-membership))))

(defun lyskom-do-remove-membership (conf-no)
  "Remove the membership for CONF-NO from lyskom-membership."
  (let ((list lyskom-membership))
    (while list
      (if (= conf-no (membership->conf-no (car list)))
	  (progn
	    (setcar list nil)
	    (setq list nil))
	(setq list (cdr list)))))
  (setq lyskom-membership (delq nil lyskom-membership)))

(defun lyskom-remove-membership (conf-no)
  "Remove the membership for CONF-NO from lyskom-membership."
  (save-excursion
    (set-buffer lyskom-buffer)
    (lyskom-do-remove-membership conf-no)
    (lyskom-run-hook-with-args 'lyskom-remove-membership-hook
                               conf-no lyskom-membership)))
  
(defun lyskom-membership-position (conf-no)
  "Return the position of the membership for CONF-NO."
  (save-excursion
    (set-buffer lyskom-buffer)
    (let ((mship (lyskom-get-membership conf-no t)))
      (or (membership->position mship)
          (- (length (memq mship lyskom-membership))
             (length lyskom-membership))))))


(defun lyskom-sort-to-do-list ()
  "Sort lyskom-to-do-list in order of membership priorities. 
The priorities for CONF elements are updated to match the membership
priorities. Elements that are not of type CONF appear first on the list
within their priority. This may not be totally accurate, but it's a
reasonable guess."
  (let ((todo (read-list->all-entries lyskom-to-do-list))
        (info nil))

    ;; Update the priorities in the read list

    (while todo
      (setq info (car todo))
      (setq todo (cdr todo))
      (when (eq (read-info->type info) 'CONF)
        (let ((mship 
               (lyskom-get-membership 
                (conf-stat->conf-no (read-info->conf-stat info)) t)))
          (when mship
            (set-read-info->priority info
                                     (membership->priority mship))))))

    ;; Sort the todo list

    (setq lyskom-to-do-list (cons 'READ-LIST
                                  (sort (read-list->all-entries lyskom-to-do-list)
                                        'lyskom-read-info-<)))
    (lyskom-update-prompt)))

(defun lyskom-read-info-< (a b)
  (cond ((< (read-info->priority a) (read-info->priority b)) nil)
        ((> (read-info->priority a) (read-info->priority b)) t)

        ;; Both are confs of equal priority; check position in mship
        ((and (eq (read-info->type a) 'CONF) 
              (eq (read-info->type b) 'CONF))
         (< (lyskom-membership-position 
             (conf-stat->conf-no (read-info->conf-stat a)))
            (lyskom-membership-position 
             (conf-stat->conf-no (read-info->conf-stat b)))))

        ;; A is a CONF and B is not; B is greater.
        ((eq (read-info->type a) 'CONF) nil)

        ;; Both are not CONF, so A is not less than B
        (t t)))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: internal.el,v 44.9 2002/02/24 20:23:27 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: internal.el
;;;;
;;;; Here are internal functions that handles the different kom-queue
;;;; calls. Add a call, apply the handler when a call is done.
;;;;
;;;; Originally written:    ceder
;;;; Completely rewritten:  Inge Wallin
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: internal.el,v 44.9 2002/02/24 20:23:27 joel Exp $\n"))


;;;; ================================================================
;;;;                          Variables.


(defvar lyskom-call-data nil
  "This is an assoc-list of data for the kom-queues.
Each element on the list has the following format:

(NAME . KOM-QUEUE)

NAME    is an atom, the name of the kom-queue.	A kom-queue is a way
        to send questions to the LysKOM server and deal with the replies 
        in a controlled way.

KOM-QUEUE is a kom-queue.")

(make-variable-buffer-local 'lyskom-call-data)


;;; ================================================================
;;;                   Data type kom-queue

;;;
;;; Each kom-queue consists of the following 4 fields:
;;;     PENDING -
;;;         a list where each element represents a call to a service on 
;;;         the server, or a call to lyskom-collect, lyskom-use or 
;;;         lyskom-run. The elements are lists. The first element on each 
;;;         list is a key to what it represents, as described below.
;;;     COLLECT-FLAG - 
;;;          t means this queue is collecting results for a future 
;;;          lyskom-use of lyskom-list-use. The results are collected
;;;          on collect-queue
;;;     COLLECT-QUEUE -
;;;          This is where the results described above are collected.
;;;     HALTED -
;;;          An integer counting the number of times this queue is halted.
;;;          A call to lyskom-halt increments this counter, a call to
;;;          lyskom-resume decrements it.
;;;
;;;
;;; The items on PENDING is one of the following:
;;;
;;; 	('CALL REF-NO PARSER PARSER-DATA HANDLER HANDLER-DATA)
;;; 		A call that has not yet returned.
;;; 
;;; 	('PARSED RESULT HANDLER HANDLER-DATA)
;;; 		A call that has returned, but the result can not be
;;; 		handled until all previous calls has returned.
;;; 
;;; 	('COLLECT)
;;; 		Marks the start of a sequence of results that will be
;;; 		handled by a multi-handler or multi-list-handler.
;;; 
;;; 	('COLLECT-IGNORE)
;;; 		Marks the start of a sequence of results that will be 
;;; 		handled by a multi-handler of multi-list-handler with
;;; 		errors stripped away.
;;; 
;;; 	('USE MULTI-HANDLER MULTI-HANDLER-DATA)
;;; 		Marks the end of a sequence. MULTI-HANDLER is called
;;; 		when all calls before this element have been handled.
;;; 		MULTI-HANDLER is a function whose first arguments are
;;; 		the results from calls between previous COLLECT and
;;; 		this USE.  MULTI-HANDLER-DATA is optional.  If it
;;; 		exists it is a list of more arguments to send to
;;; 		MULTI-HANDLER.
;;; 
;;; 	('LIST-USE MULTI-HANDLER MULTI-HANDLER-DATA)
;;; 		Marks the end of a sequence. MULTI-HANDLER is called
;;; 		when all calls before this element have been handled.
;;; 		MULTI-HANDLER is a function whose first argument is a
;;; 		list of all results from calls between previous
;;; 		COLLECT and this LIST-USE. MULTI-HANDLER-DATA is
;;; 		optional. If it exists it is a list of more arguments
;;; 		to send to MULTI-HANDLER.
;;; 
;;; 	('RUN FUNCTION FUNCTION-ARGS)
;;; 		Run FUNCTION when all calls before this have been handled.
;;; 


(defun kom-queue-create ()
  "Creates a new instance of an empty kom-queue."
  (vector (lyskom-queue-create)
	  nil
	  (lyskom-queue-create)
	  0))


(defun kom-queue->pending (queue)
  "Returns the pending field of the kom-queue QUEUE."
  (elt queue 0))


(defun kom-queue->collect-flag (queue)
  "Returns the collect-flag field of the kom-queue QUEUE."
  (elt queue 1))


(defun kom-queue->collect-queue (queue)
  "Returns the collect-queue field of the kom-queue QUEUE."
  (elt queue 2))


(defun set-kom-queue-collect-flag (queue new-val)
  "Set the collect-flag field of the kom-queue QUEUE to NEW-VAL."
  (aset queue 1 new-val))


(defun kom-queue-halt (queue)
  "Halts the kom-queue QUEUE."
  (aset queue 3 (1+ (elt queue 3))))


(defun kom-queue-resume (queue)
  "Resume execution on the kom-queue QUEUE."
  (if (eq (elt queue 3) 0)
      (signal 'lyskom-internal-error
	      (list "kom-queue-resume called on an unhalted queue: "
		    queue))
    (aset queue 3 (1- (elt queue 3)))))


(defun kom-queue-is-halted (queue)
  "Return t if the kom-queue QUEUE is halted at least once."
  (> (elt queue 3) 0))



;;; ================================================================
;;;               Entry points to this communication packet.


(defun lyskom-collect (kom-queue)
  "Collect the results of future calls via KOM-QUEUE.
The results of the calls will be available to the multi-handler.
See lyskom-use and lyskom-list-use."
  (lyskom-call-add kom-queue 'COLLECT))


(defun lyskom-collect-ignore-err (kom-queue)
  "Collect the result of future calls via KOM-QUEUE.
The result of the calls will be available to the multi-handler with the calls
producing errors stripped."
  (lyskom-call-add kom-queue 'COLLECT-IGNORE))


(defun lyskom-use (kom-queue multi-handler &rest multi-handler-data)
  "Use the previously collected results from calls to the server.
Args: KOM-QUEUE MULTI-HANDLER &rest MULTI-HANDLER-DATA

MULTI-HANDLER is a function that is called when all previous results
have been handled. MULTI-HANDLER-DATA is a list of additional
arguments the multi-handler wants.

See also lyskom-list-use."
  (lyskom-call-add kom-queue 'USE multi-handler multi-handler-data)
  (lyskom-check-call kom-queue))


(defun lyskom-list-use (kom-queue multi-handler &rest multi-handler-data)
  "Use the previously collected results from calls to the server.
Args: KOM-QUEUE MULTI-HANDLER &rest MULTI-HANDLER-DATA

MULTI-HANDLER is a function that is called when all previous
results have been handled. The first argument is a list of
the results. MULTI-HANDLER-DATA is a list of additional
arguments the multi-handler wants.

The difference between lyskom-use and lyskom-list-use is the way
the MULTI-HANDLER receives the data. lyskom-list-use sends them as
a list, lyskom-use as different parameters."
  (lyskom-call-add kom-queue 'LIST-USE multi-handler multi-handler-data)
  (lyskom-check-call kom-queue))


(defun lyskom-run (kom-queue function &rest function-args)
  "Call a function when all calls have been handled.
Args: KOM-QUEUE FUNCTION &rest FUNCTION-ARGS
Register a FUNCTION that shall be called with FUNCTION-ARGS when
all previous calls to the server via KOM-QUEUE have been handled."
  (lyskom-call-add kom-queue 'RUN function function-args)
  (lyskom-check-call kom-queue))


(defun lyskom-halt (queue-name)
  "Prohibit execution of handlers on QUEUE-NAME.
The execution will resume when (lyskom-resume KOM-QUEUE) is called."
  (let ((queue-pair (assq queue-name lyskom-call-data)))
    (if (null queue-pair)
	(setq queue-pair (lyskom-add-new-queue queue-name)))
    (kom-queue-halt (cdr queue-pair))))
    

(defun lyskom-resume (kom-queue)
  "Resume execution of waiting handlers on KOM-QUEUE.
See documentation for lyskom-halt."
  (let ((queue (assq kom-queue lyskom-call-data)))
    (cond
     ((null queue)			;A new kom-queue?
      (signal 'lyskom-internal-error
	      (list "lyskom-resume called on an unused queue:"
		    kom-queue)))
     ((kom-queue-is-halted (cdr queue)) ;A halted queue?
      (kom-queue-resume (cdr queue))    ;Resume execution on the queue.
      (lyskom-check-call kom-queue))	;Run any pending handlers.
     (t					;The queue was not halted. This
      (signal 'lyskom-internal-error	;is an error.
	      (list "lyskom-resume:"
		    kom-queue "(not halted)"))))))


(defun lyskom-call (kom-queue ref-no handler handler-data
			       parser &rest parser-data)
  "Add information about a call that has not yet returned to kom-queue.
Arguments: KOM-QUEUE REF-NO HANDLER HANDLER-DATA
	   PARSER &rest PARSER-DATA."
  (lyskom-call-add kom-queue 'CALL ref-no 
		   parser parser-data handler handler-data))

(defun lyskom-fake-call (kom-queue ref-no handler handler-data)
  "Add information about a call that will not return from the server,
but will be filled in by some other function."
  (lyskom-call-add kom-queue 'CALL ref-no
                   nil nil handler handler-data))

(defun lyskom-complete-call (kom-queue ref-no result)
  "Force a call placed on KOM-QUEUE with reference number REF-NO to return 
RESULT. This should only be used to complete calls placed on the queue using
lyskom-fake-call, or the parser might get confused."
  (let ((call-info (lyskom-locate-ref-no kom-queue ref-no)))
    (if call-info
        (progn
          (lyskom-tr-call-to-parsed call-info result)
          (lyskom-check-call kom-queue)))))


;;; This is used by z-initiate-get-map, which is not used.
;;; This was a temporary solution.

;;(defun lyskom-kom-queue-collect-p (queue-name)
;;  "Return t if the kom-queue QUEUE-NAME has an unmatched 'COLLECT item.
;;It is illegal to call lyskom-collect or lyskom-collect-ignore-err on
;;the kom-queue if and only if this function returns t."
;;  (let* ((queue (cdr-safe (assoc queue-name lyskom-call-data)))
;;	 (pending (lyskom-queue->all-entries (kom-queue->pending queue)))
;;	 (collect-flg nil)
;;	 (type nil))
;;    (while (and queue pending)
;;      (setq type (car (car pending)))
;;      (setq pending (cdr pending))
;;      (cond
;;       ((eq type 'COLLECT)
;;	(setq collect-flg t))
;;       ((eq type 'COLLECT-IGNORE)
;;	(setq collect-flg t))
;;       ((eq type 'USE)
;;	(setq collect-flg nil))
;;       ((eq type 'LIST-USE)
;;	(setq collect-flg nil))))
;;    collect-flg))


;;;; ================================================================
;;;;                     Internal functions.



(defun lyskom-add-new-queue (queue-name)
  "Add QUEUE-NAME to lyskom-call-data as an empty queue.
Return a dotted pair consisting of the QUEUE-NAME and the new queue."
  (let ((new-queue-list (list (cons queue-name (kom-queue-create)))))
    (if (null lyskom-call-data)
	(setq lyskom-call-data new-queue-list)
      (nconc lyskom-call-data new-queue-list))
    (car new-queue-list)))

(defun lyskom-set-queue-priority (queue-name priority)
  (put queue-name 'lyskom-queue-priority priority))

(defun lyskom-queue-priority (queue-name)
  (or (get queue-name 'lyskom-queue-priority)
      0))

(defun lyskom-call-add (queue-name type &rest data)
  "Add an entry to the kom-queue QUEUE-NAME. The entry is of type TYPE
and third argument DATA contains the rest of the necessary data."
  (let ((queue (assoc queue-name lyskom-call-data)))
    (if (null queue)
	(setq queue (lyskom-add-new-queue queue-name)))
    (lyskom-queue-enter (kom-queue->pending (cdr queue))
			(cons type data))))


(defun lyskom-send-packet (kom-queue string)
  "Send a packet to the server.
Add info on lyskom-pending-calls. Update lyskom-ref-no.
Args: KOM-QUEUE STRING."

  ;; Queue it
  (lyskom-queue-enter (aref lyskom-output-queues
			    (lyskom-queue-priority kom-queue))
		      (cons lyskom-ref-no string))
  (setq lyskom-pending-calls
	(cons (cons lyskom-ref-no kom-queue)
	      lyskom-pending-calls))
  (++ lyskom-ref-no)
  
  ;; Send something from the output queues
  (lyskom-check-output-queues))

(defun lyskom-check-output-queues ()
  "Check for pending calls to the server.
Send calls from queues with higher priority first, and make sure that at
most lyskom-max-pending-calls are sent to the server at the same time."
  (catch 'done
    (let ((i 9))
      (while (and lyskom-ok-to-send-new-calls
		  (< lyskom-number-of-pending-calls
		     lyskom-max-pending-calls))
	(while (lyskom-queue-isempty (aref lyskom-output-queues i))
	  (-- i)
	  (if (< i 0) (throw 'done nil)))
	(let ((entry (lyskom-queue-delete-first
		      (aref lyskom-output-queues i))))
	  (++ lyskom-number-of-pending-calls)
	  (lyskom-process-send-string
	   lyskom-proc
	   (concat (number-to-string (car entry)) (cdr entry) "\n")))))))

(defun lyskom-decrease-pending-calls ()
  "A reply has come.
Send a pending call or decrease lyskom-number-of-pending-calls."
  (-- lyskom-number-of-pending-calls)
  (if (< lyskom-number-of-pending-calls 0)
      (setq lyskom-number-of-pending-calls 0))
  (lyskom-check-output-queues))
	

(defun lyskom-process-send-string (process string)
  "Send PROCESS the contents of STRING.
STRING is split in several parts if the operating system can't deal
with big strings."
  (let ((tries 0))
  (while
      (condition-case err
	  (progn (lyskom-process-send-string-2 process string)
		 nil)
	(file-error
	 (if lyskom-debug-communications-to-buffer
	     (lyskom-debug-insert process "Error: " (format "%s" err))
;;;	     (save-excursion
;;;	       (set-buffer (get-buffer-create
;;;			    lyskom-debug-communications-to-buffer-buffer))
;;;	       (save-excursion
;;;		 (goto-char (point-max))
;;;		 (insert "\n" 
;;;			 (format "%s" process)
;;;			 (concat "Error: " (format "%s" err))))
;;;	       (set-buffer (process-buffer process)))
	   )
	 (cond
	  ((and (string= "writing to process" (car (cdr err)))
		(or (string= "message too long" (car (cdr (cdr err))))
		    (string= "no more processes" (car (cdr (cdr err)))))
		(> lyskom-max-packet-size 1))
	   ;; Seems to be impossible to write too long strings to TCP/IP.
	   ;; This happens on a Sequence Balance with packets longer than
	   ;; 2048 bytes. Decrease lyskom-max-packet-size and retry.
	   (setq lyskom-max-packet-size (/ lyskom-max-packet-size 2))
	   t)

	  ((and (string= "writing to process" (car (cdr err)))
		(string= "host is unreachable" (car (cdr (cdr err)))))
	   ;; The net is currently shaky. We try again in a while.
	   (lyskom-message "%s" (lyskom-format 'shaky-tcp
					       (make-string (++ tries) ?.)))
	   (sit-for 4)
	   (lyskom-message "%s" (lyskom-get-string 'retrying-tcp))
	   t)
	  
	  (t
	   ;; It was some unknown file-error. Pass it down.
	   (signal (car err) (cdr err)))))))))


(defun lyskom-process-send-string-2 (process string)
  "Send PROCESS the contents of STRING as input.
PROCESS may be a process name. At most lyskom-max-packet-size bytes
is sent with each packet. If STRING is longer it is splitted."
  (cond
   ((<= (length string) lyskom-max-packet-size)
    (process-send-string
     process
     (progn
       (if lyskom-debug-communications-to-buffer
	   (lyskom-debug-insert process "To " string))
       string)))
   (t
    (let ((i 0))
      (while (< i (length string))
	(process-send-string
	 process
	 (let ((string (substring string
				  i
				  (min (length string)
				       (+ i lyskom-max-packet-size)))))
	   (if lyskom-debug-communications-to-buffer
	       (save-excursion
		 (set-buffer (get-buffer-create 
			      lyskom-debug-communications-to-buffer-buffer))
		 (save-excursion
		   (goto-char (point-max))
		   (insert "\n"
                           "To " process ": "))
		 (set-buffer (process-buffer process))))
	   string))
	(setq i (+ i lyskom-max-packet-size)))))))


(defun lyskom-check-call (queue-name)
  "Check lyskom-call-data and call handlers, multi-handlers and functions.
Args: QUEUE-NAME.
HALTED -> stop
CALL -> stop
PARSED -> handle ->
       -> collect-flag? 'COLLECT -> add on temporary resultlist.
	 	        'COLLECT-IGNORE -> add on temporary resultlist if not 
			 		   error.
		        no  -> delete from lyskom-call-data.
COLLECT -> collect-flag? yes -> error!
			 no  -> set collect-flag.
COLLECT-IGNORE -> collect-flag? yes -> error!
				no -> set collect-flag.
USE ->      call handler. Delete previous parts.
LIST-USE -> call handler. Delete previous parts.
RUN ->      call function. Delete. Not allowed inside COLLECT/USE."
  (let* ((queue (cdr-safe (assoc queue-name lyskom-call-data)))
         (type nil)
         (first-pending (lyskom-queue->first (kom-queue->pending queue))))
    (while (and queue
                (not (or (kom-queue-is-halted queue)
                         (lyskom-queue-isempty (kom-queue->pending queue))
                         (eq (car first-pending) 'CALL))))
      (setq type (car first-pending))

      (cond

       ((eq type 'PARSED)
	(kom-queue-halt queue)
	(unwind-protect
	    (lyskom-apply-handler first-pending)
	  (kom-queue-resume queue))
        (if (or (eq (kom-queue->collect-flag queue) 'COLLECT)
                (and (eq (kom-queue->collect-flag queue) 'COLLECT-IGNORE)
                     (car (cdr first-pending))))
            (lyskom-queue-enter (kom-queue->collect-queue queue)
                                (car (cdr first-pending)))))

       ((eq type 'COLLECT)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call COLLECT."))
          (set-kom-queue-collect-flag queue 'COLLECT)
          (lyskom-queue-make-empty (kom-queue->collect-queue queue))))

       ((eq type 'COLLECT-IGNORE)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call COLLECT-IGNORE."))
          (set-kom-queue-collect-flag queue 'COLLECT-IGNORE)
          (lyskom-queue-make-empty (kom-queue->collect-queue queue))))

       ((eq type 'USE)
        (if (not (kom-queue->collect-flag queue))
            (signal 'lyskom-internal-error
                    '("lyskom-check-call USE.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-multi-handler
             first-pending (lyskom-queue->all-entries
                            (kom-queue->collect-queue queue)))
          (kom-queue-resume queue))
        (set-kom-queue-collect-flag queue nil))

       ((eq type 'LIST-USE)
        (if (not (kom-queue->collect-flag queue))
            (signal 'lyskom-internal-error
                    '("lyskom-check-call LIST-USE.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-multi-list-handler
             first-pending (lyskom-queue->all-entries
                            (kom-queue->collect-queue queue)))
          (kom-queue-resume queue))
        (set-kom-queue-collect-flag queue nil))

       ((eq type 'RUN)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call RUN.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-function first-pending)
          (kom-queue-resume queue)))
       
       (t (signal 'lyskom-internal-error
                  (list 'lyskom-check-call
                        "unknown key:"
                        (car first-pending)))))

      (lyskom-queue-delete-first (kom-queue->pending queue))
      (setq first-pending (lyskom-queue->first (kom-queue->pending queue))))))

;;; Quit is NOT ok to press while the handler is running. inhibit-quit
;;; should be t when these are called.
(defun lyskom-apply-handler (pending)
  "Apply a handler. Args: PENDING.
PENDING is an entry of the list as described in documentation for the variable
lyskom-call-data. The car on the list must be a PARSED:
	('PARSED RESULT HANDLER HANDLER-DATA)"
  (if (car (cdr (cdr pending)))
      (apply (car (cdr (cdr pending)))	;Handler
	     (car (cdr pending))	;Result
	     (car (cdr (cdr (cdr pending))))))) ;Handler-data

(defun lyskom-apply-multi-handler (pending result-list)
  "Apply a handler for a lyskom-collect - lyskom-use construct."
  (apply (car (cdr pending))		;Multi-handler
	 (nconc result-list
		(car (cdr (cdr pending)))))) ;Multi-handler-data


(defun lyskom-apply-multi-list-handler (pending result-list)
  "Apply a handler for a lyskom-collect - lyskom-list-use construct."
  (apply (car (cdr pending))		;Multi-handler
	 (cons result-list
	       (car (cdr (cdr pending)))))) ;Multi-handler-data
    
(defun lyskom-apply-function (pending)
  (setcar pending 'HALTED)
  (apply (car (cdr pending))	    ;Function.
	 (car (cdr (cdr pending)))))  ;Function-args.
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: services.el,v 44.34 2002/08/09 15:14:50 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; This file contains functions for sending requests to the server
;;;; and parsing the result.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: services.el,v 44.34 2002/08/09 15:14:50 byers Exp $\n"))


;;; ================================================================
;;; Macro for defining services

;;; (defmacro def-kom-service (name args &rest body)
;;;   "Create an initiate call. NAME and ARGS are the name and arguments for the call.
;;; If BODY starts with a string, that is the documentation string.
;;; If BODY consists of (call N PARSER), generate a simple call
;;; for RPC number N, and parse the result with PARSER."
;;;   (let ((function-name (intern (concat "initiate-" (symbol-name name))))
;;;         (doc-string nil)
;;;         (auto-call nil)
;;;         (buffer-save (intern (format "initiate-%s-saved-buffer" name))))
;;;     (when (stringp (car body))
;;;       (setq doc-string (car body))
;;;       (setq body (cdr body)))
;;; 
;;;     (when (and (listp (car body))
;;;                (eq 'call (car (car body))))
;;;       (setq auto-call (car body))
;;;       (setq body (cdr body)))
;;; 
;;;     (` (defun (, function-name) (kom-queue handler (,@ args) &rest data)
;;;          (, 
;;;           (or doc-string 
;;;               (format "Initiate %S on server\nArgs: KOM-QUEUE HANDLER %s &rest DATA"  
;;;                       name (mapconcat 
;;;                             (function
;;;                              (lambda (x)
;;;                                (format "%s" (upcase (symbol-name x)))))
;;;                             args
;;;                             " "))))
;;;          (let (((, buffer-save) (current-buffer)))
;;;            (unwind-protect
;;;                (progn
;;;                  (and (not lyskom-output-queues) (set-buffer lyskom-buffer))
;;;                  (,@ (if auto-call
;;;                          (` ((lyskom-call kom-queue lyskom-ref-no handler data (quote (, (elt auto-call 2))))
;;;                              (lyskom-send-packet kom-queue (lyskom-format-objects (, (elt auto-call 1)) (,@ args)))))
;;;                        body)))
;;;              (set-buffer (, buffer-save))))))))

(defmacro lyskom-server-call (&rest body)
  "Macro to protect initiate-somethings 
from being called in the wrong buffer."
  (` (let ((initiate-something-saved-buffer (current-buffer)))
       (unwind-protect
           (prog2 (or lyskom-output-queues (set-buffer lyskom-buffer))
               lyskom-ref-no
             (,@ body))
         (set-buffer initiate-something-saved-buffer)))))

(put 'lyskom-server-call 'lisp-indent-function 0)
(put 'lyskom-server-call 'edebug-form-spec t)
     

;;; ================================================================
;;;                     Requests for services


(defun initiate-login-old (kom-queue handler pers-no password &rest data)
  "Log in on server.
Args: KOM-QUEUE HANDLER PERS-NO PASSWORD &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 0 pers-no password))))


(defun initiate-login (kom-queue handler pers-no password status 
                                 &rest data)
  "Log in on server.
Args: KOM-QUEUE HANDLER PERS-NO PASSWORD STATUS &rest DATA.
Status is 0 for visible login and 1 for invisible login."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 62 pers-no
                                                         password status))))


(defun initiate-logout (kom-queue handler &rest data)
  "Log out from server.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 1))))


(defun initiate-pepsi (kom-queue handler conf-no &rest data)
  "Change working conference.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 2 conf-no))))

(defun initiate-change-name (kom-queue handler
				       conf-no new-name
				       &rest data)
  "Change the name of a conference.
Args: KOM-QUEUE HANDLER CONF-NO NEW-NAME &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 3 conf-no new-name))))


(defun initiate-change-what-i-am-doing (kom-queue handler what &rest data)
  "Tell server what you are doing.
Args: KOM-QUEUE HANDLER WHAT &rest DATA.
WHAT is a string."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 4 what))))
  

(defun initiate-create-person (kom-queue handler name 
                                         password pers-flags
                                         aux-items 
                                             &rest data)
  "Create a new person.
Args: KOM-QUEUE HANDLER NAME PASSWORD &rest DATA."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 89)
       (lyskom-send-packet kom-queue (lyskom-format-objects 89
                                                            name
                                                            password
                                                            pers-flags
                                                            (cons 'LIST 
                                                                  aux-items)))
     (lyskom-send-packet kom-queue (lyskom-format-objects 5 name password)))))


;;; Call 6 is get-person-stat-old, and is obsoleted by call 49.

(defun initiate-set-priv-bits (kom-queue handler pers-no priv-bits &rest data)
  "Set priv-bits of a person.
Args: KOM-QUEUE HANDLER PERS-NO PRIV-BITS &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 7 pers-no priv-bits))))


(defun initiate-set-passwd (kom-queue handler
				      pers-no old-pw new-pw
				      &rest data)
  "Set the password of a person.
Args: KOM-QUEUE HANDLER PERS-NO OLD-PW NEW-PW &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 8 pers-no old-pw new-pw))))


;;; 
;;; This function has a ridiculous name!  It ought to be called
;;; get-membership.  Unfortunately this name is already taken
;;; by another call.
;;;
(defun initiate-query-read-texts (kom-queue handler
					    pers-no conf-no &rest data)
  "Get a membership struct describing the membership of PERS-NO in CONF-NO.
Args: KOM-QUEUE HANDLER PERS-NO CONF-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 (if (lyskom-have-call 98)
                     'lyskom-parse-membership
                   'lyskom-parse-membership-old))
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects
                         (if (lyskom-have-call 98) 98 9)
                         pers-no conf-no))))


(defun initiate-create-conf (kom-queue handler
				       conf-name conf-type
                                       aux-items &rest data)
  "Add a member to a conference.
Args: KOM-QUEUE HANDLER CONF-NAME CONF-TYPE &rest DATA."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 88)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 88 conf-name conf-type
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 10 conf-name conf-type)))))


(defun initiate-delete-conf (kom-queue handler conf-no &rest data)
  "Delete a conference.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 11 conf-no))))



(defun initiate-lookup-name (kom-queue handler name &rest data)
  "See what conferences match NAME.
Args: KOM-QUEUE HANDLER NAME &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-conf-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 12 name))))
					    

;;; Call 13 is get-conf-stat-old, which is obsoleted by 50.


(defun initiate-add-member (kom-queue handler
				      conf-no 
                                      pers-no
                                      priority
                                      where
                                      type
				      &rest data)
  "Add a member to a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERS-NO PRIORITY WHERE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (if (lyskom-have-call 100)
        (lyskom-send-packet kom-queue
                            (lyskom-format-objects 100 conf-no pers-no 
                                                   priority where type))
      (lyskom-send-packet kom-queue
                          (lyskom-format-objects 14 conf-no pers-no 
                                                 priority where)))))


(defun initiate-sub-member (kom-queue handler
				      conf-no pers-no
				      &rest data)
  "Subtract a member from a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERS-NO  &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 15 conf-no pers-no))))


(defun initiate-set-presentation (kom-queue handler
					    conf-no text-no
					    &rest data)
  "Set presentation of a conference.
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 16 conf-no text-no))))


(defun initiate-set-conf-motd (kom-queue handler conf-no text-no &rest data)
  "Set motd of a conference.
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 17 conf-no text-no))))


(defun initiate-set-supervisor (kom-queue handler conf-no admin
					  &rest data)
  "Set supervisor of a conference.
Args: KOM-QUEUE HANDLER CONF-NO ADMIN &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 18 conf-no admin))))


(defun initiate-set-permitted-submitters (kom-queue handler conf-no perm-sub
						    &rest data)
  "Set permitted submitters of a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERM-SUB &rest DATA.
PERM-SUB is a conference number. All members in that conference might
write texts in CONF-NO. If PERM-SUB is zero everyone is allowed to
write texts in CONF-NO."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 19 conf-no perm-sub))))


(defun initiate-set-super-conf (kom-queue handler conf-no super-conf
					  &rest data)
  "Set superconference of a conference.
Args: KOM-QUEUE HANDLER CONF-NO SUPER-CONF &rest DATA.
Unauthorized attempts to write texts to CONF-NO will bounce to SUPER-CONF."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects 20 conf-no super-conf))))


(defun initiate-set-conf-type (kom-queue handler conf-no conf-type &rest data)
  "Set type of a conference.
Args: KOM-QUEUE HANDLER CONF-NO CONF-TYPE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 21 conf-no conf-type))))


(defun initiate-set-garb-nice (kom-queue handler conf-no garb-nice &rest data)
  "Set garb-nice of a conference.
Args: KOM-QUEUE HANDLER CONF-NO GARB-NICE &rest DATA.
Texts in CONF-NO will live approximately GARB-NICE days."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 22 conf-no garb-nice))))


(defun initiate-get-marks (kom-queue handler &rest data)
  "Get all marked texts.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-mark-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 23))))


(defun initiate-mark-text (kom-queue handler
                                     text-no mark-type
                                     &rest data)
  "Mark a text.
Args: KOM-QUEUE HANDLER TEXT-NO MARK-TYPE &rest DATA.
MARK-TYPE is currently a number, but this should maybe be
changed (internally in the elisp-klient) to something similar to
a conf-type (with several bits that are 't' or 'nil' that is)."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 
                         (if (lyskom-have-call 72) 72 24) 
                         text-no mark-type))))

(defun initiate-unmark-text (kom-queue handler
                                     text-no
                                     &rest data)
  "Unmark a text.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (if (lyskom-have-call 73)
        (lyskom-send-packet kom-queue (lyskom-format-objects 73 text-no)))
      (lyskom-send-packet kom-queue (lyskom-format-objects 24 text-no 0))))


(defun initiate-get-text (kom-queue handler text-no &rest data)
  "Get text from LysKOM server.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (let ((text (cache-get-text text-no)))
      (cond
       ((null text)			;Cached info?
        (lyskom-call kom-queue		;No, ask the server.
                     lyskom-ref-no
                     handler data
                     'lyskom-parse-text text-no)
                                        ;(princ text-no (get-buffer-create "text"))+++
                                        ;(terpri (get-buffer-create "text"))
        (lyskom-send-packet kom-queue (lyskom-format-objects 25 text-no
                                                             0 lyskom-max-int)))
       (t
                                        ;Cached info. 
        (lyskom-call-add kom-queue 'PARSED text handler data)
        (lyskom-check-call kom-queue))))))


(defun initiate-get-text-stat (kom-queue handler text-no &rest data)
  "Get text-stat from LysKOM server.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
   (let ((text-stat (cache-get-text-stat text-no)))
     (cond
      ((null text-stat)			;Cached info?
       (lyskom-call kom-queue		;No, ask the server.
                    lyskom-ref-no
                    handler data
                    (if (lyskom-have-call 90)
                        'lyskom-parse-text-stat
                      'lyskom-parse-text-stat-old)
                    text-no)
       ;;(princ text-no (get-buffer-create "text-stat"))+++
       ;;(terpri (get-buffer-create "text-stat"))
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects
                            (if (lyskom-have-call 90) 90 26)
                            text-no)))
      (t
                                        ;Cached info. 
       (lyskom-call-add kom-queue 'PARSED text-stat handler data)
       (lyskom-check-call kom-queue))))))


(defun initiate-mark-as-read (kom-queue handler conf-no text-list &rest data)
  "Mark all texts in TEXT-LIST as read in CONF-NO. Args: CONF-NO TEXT-LIST."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 27 conf-no 
                                               (cons 'LIST text-list)))))


(defun initiate-create-text (kom-queue 
                             handler
                             message
                             misc-list
                             aux-items
                             &rest data)
  "Create a new text.
Args: KOM-QUEUE HANDLER MESSAGE MISC-LIST AUX-ITEMS &rest DATA.
MESSAGE is a string. MISC-LIST should be created by lyskom-create-misc-list."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 86)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 86
                                                  (cons 'STRING message)
                                                  misc-list
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 28 
						(cons 'STRING message) 
						misc-list)))))

				     
(defun initiate-delete-text (kom-queue handler text-no &rest data)
  "Delete a text.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 29 text-no))))


(defun initiate-add-recipient (kom-queue handler
					 text-no conf-no type
					 &rest data)
  "Add a recipient to a text.
Args: KOM-QUEUE HANDLER TEXT-NO CONF-NO TYPE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet 
     kom-queue
     (lyskom-format-objects 30 text-no conf-no
                            (cond ((eq type 'RECPT) 0)
                                  ((eq type 'CC-RECPT) 1)
                                  ((eq type 'BCC-RECPT) 
                                   (if (lyskom-have-feature bcc-misc)
                                       15 1)))))))

(defun initiate-sub-recipient (kom-queue handler
					 text-no conf-no 
					 &rest data)
  "Subtract a recipient from a text.
Args: KOM-QUEUE HANDLER TEXT-NO CONF-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 31 text-no conf-no))))


(defun initiate-add-comment (kom-queue handler
                                       comment-text-no text-no
                                       &rest data)
  "Add a comment to a text.
Args: KOM-QUEUE HANDLER COMMENT-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 32 comment-text-no text-no))))

				       

(defun initiate-sub-comment (kom-queue handler
                                       comment-text-no text-no
                                       &rest data)
  "Subtract a comment from a text.
Args: KOM-QUEUE HANDLER COMMENT-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 33 comment-text-no text-no))))


(defun initiate-get-map (kom-queue handler conf-no first-local
				   no-of-texts &rest data-list)
  "Get mapping from local to global text-nos for CONF-NO from server.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-TEXTS DATA-LIST.
Use z-initiate-get-map instead. This function has severe performance losses
with big maps."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data-list 'lyskom-parse-map)
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects 34 conf-no
                                               first-local no-of-texts))))

(defun z-initiate-get-map  (kom-queue handler conf-no first-local
                                      no-of-texts &rest data)
  "Get mapping from local to global text-nos for CONF-NO from server.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-TEXTS &rest DATA.
This function will automatically split fetching of big maps to small
chunks of lyskom-fetch-map-nos texts/chunk if KOM-QUEUE is not already
used to collect a result. This currently gives a big performance gain.
Unfortunately it is impossible (or at least very hard) to do the same
thing when a collect is in progress. This will of course be fixed in
protocol B."
  (lyskom-server-call
    (cond
     ((kom-queue->collect-flag (cdr-safe (assq kom-queue lyskom-call-data)))
      ;; Use oldstyle single big map. Sorry.
      (apply 'initiate-get-map
             kom-queue handler conf-no first-local no-of-texts data))
     (t
      ;; You win.
      (initiate-get-map kom-queue 'lyskom-receive-partial-map conf-no
                        first-local lyskom-fetch-map-nos
                        (+ lyskom-fetch-map-nos first-local)
                        (- no-of-texts lyskom-fetch-map-nos)
                        conf-no nil kom-queue data handler)))))

(defun lyskom-receive-partial-map (map first-local no-of-texts
				       conf-no map-so-far kom-queue
				       data-list handler)
  "Receive a partial map and start fetching a new chunk."
  (lyskom-server-call
    (let ((map-list (nconc map-so-far (list map))))
      (if (<= no-of-texts 0)
          (apply handler (apply 'lyskom-map-concat map-list) data-list)
        (initiate-get-map kom-queue 'lyskom-receive-partial-map conf-no
                          first-local lyskom-fetch-map-nos
                          (+ lyskom-fetch-map-nos first-local)
                          (- no-of-texts lyskom-fetch-map-nos)
                          conf-no map-list kom-queue data-list handler)))))


(defun initiate-get-time (kom-queue handler &rest data)
  "Get time from server.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-time)
    (lyskom-send-packet kom-queue (lyskom-format-objects 35))))


(defun initiate-get-server-info (kom-queue handler &rest data)
  "Get info about the server"
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no
                handler
                data
                (if (lyskom-have-call 94)
                    'lyskom-parse-server-info
                  'lyskom-parse-server-info-old))
   (lyskom-send-packet kom-queue
                       (lyskom-format-objects
                        (if (lyskom-have-call 94) 94 36)))))


(defun initiate-add-footnote (kom-queue handler
					footnote-text-no text-no
					&rest data)
  "Add a footnote to a text.
Args: KOM-QUEUE HANDLER FOOTNOTE-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 37 footnote-text-no text-no))))


(defun initiate-sub-footnote (kom-queue handler
					footnote-text-no text-no
					&rest data)
  "Subtract a footnote from a text.
Args: KOM-QUEUE HANDLER FOOTNOTE-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 38 footnote-text-no text-no))))


;;; Call 39, who-is-on-old, is obsoleted by call 63.


(defun initiate-set-unread (kom-queue handler conf-no no-of-unread &rest data)
  "Set number of unread texts in a certain conference.
Args: KOM-QUEUE HANDLER CONF-NO NO-OF-UNREAD &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 40 conf-no no-of-unread))))


(defun initiate-set-motd-of-lyskom (kom-queue handler text-no &rest data)
  "Set message of the day of LysKOM.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 41 text-no))))


(defun initiate-enable (kom-queue handler level &rest data)
  "Set security level.
Args: KOM-QUEUE HANDLER LEVEL &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 42 level))))

;;; Call 43 is sync. Starting with version 1.9 of lyskomd it is a
;;; privileged operation, so there is no harm in having the function
;;; easily available any more.

(defun initiate-sync (kom-queue handler &rest data)
  "Sync the LysKOM datbase. This is a prioritized call."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 43))))

;;; Call 44 is shutdown. Use 'kill -HUP' instead.

(defun initiate-shutdown (kom-queue handler parameter &rest data)
  "Shutdown the server.
Args: KOM-QUEUE HANDLER PARAMETER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 44 parameter))))


(defun initiate-broadcast (kom-queue handler message &rest data)
  "Send a broadcast message to all logged in users.
Args: KOM-QUEUE HANDLER MESSAGE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 45 message))))



(defun initiate-get-membership (kom-queue handler pers-no &rest data)
  "Get membership-list for PERS-NO from server.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 (if (lyskom-have-call 99)
                     'lyskom-parse-membership-list
                   'lyskom-parse-membership-list-old))
    (lyskom-send-packet kom-queue (lyskom-format-objects
                                   (if (lyskom-have-call 99) 99 46)
                                   pers-no
                                   0 lyskom-max-int ;all confs.
                                   1)))) ;want read texts.


(defun initiate-get-part-of-membership (kom-queue handler pers-no first length
						  &rest data)
  "Get membership-list for PERS-NO from server.
Args: KOM-QUEUE HANDLER PERS-NO FIRST-IN-LIST LENGHT &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 (if (lyskom-have-call 99)
                     'lyskom-parse-membership-list
                   'lyskom-parse-membership-list-old))
    (lyskom-send-packet kom-queue (lyskom-format-objects 
                                   (if (lyskom-have-call 99) 99 46)
                                   pers-no
                                   first length ;all confs.
                                   1))))


(defun initiate-get-created-texts (kom-queue handler pers-no first-local
					     no-of-texts &rest data)
  "Get a part of the list of created texts for a person.
Args: KOM-QUEUE HANDLER PERS-NO FIRST-LOCAL NO-OF-TEXTS &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-map)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 47 pers-no
                                               first-local no-of-texts))))


(defun initiate-get-members (kom-queue handler conf-no first-local
				       no-of-members &rest data)
  "Get a part of the list of members in a conference.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-MEMBERS &rest DATA.
Returns a conf-no-list."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 (if (lyskom-have-call 101)
                     'lyskom-parse-member-list
                   'lyskom-parse-member-list-old))
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 
                         (if (lyskom-have-call 101) 101 48)
                         conf-no
                         first-local no-of-members))))


(defun initiate-get-pers-stat (kom-queue handler pers-no &rest data)
  "Get status for person PERS-NO.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA."
  (lyskom-server-call
    (let ((pers-stat (cache-get-pers-stat pers-no)))
      (cond
       ((null pers-stat)                ;Cached info?
        (lyskom-call kom-queue		;No, ask the server.
                     lyskom-ref-no
                     handler data
                     'lyskom-parse-pers-stat pers-no)
                                        ;(princ pers-no (get-buffer-create "pers-stat")) +++
                                        ;(terpri (get-buffer-create "pers-stat"))
        (lyskom-send-packet kom-queue (lyskom-format-objects 49 pers-no)))
       (t
                                        ;Cached info. 
        (lyskom-call-add kom-queue 'PARSED pers-stat handler data)
        (lyskom-check-call kom-queue))))))

(defun initiate-get-conf-stat (kom-queue handler conf-no &rest data)
  "Get conf-stat from LysKOM server.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
   (let ((conf-stat (cache-get-conf-stat conf-no)))
     (cond
      ((zerop conf-no)			;No real user.
       (lyskom-call-add kom-queue 'PARSED nil handler data)
       (lyskom-check-call kom-queue))
      ((null conf-stat)			;Cached info?
       (lyskom-call kom-queue		;No, ask the server.
                    lyskom-ref-no
                    handler data
                    (if (lyskom-have-call 91)
                        'lyskom-parse-conf-stat
                      'lyskom-parse-conf-stat-old)
                    conf-no)
       ;;(princ conf-no (get-buffer-create "conf-stat")) +++
       ;;(terpri (get-buffer-create "conf-stat"))
       (lyskom-send-packet kom-queue 
                           (lyskom-format-objects
                            (if (lyskom-have-call 91) 91 50)
                            conf-no)))
      (t
                                        ;Cached info. 
       (lyskom-call-add kom-queue 'PARSED conf-stat handler data)
       (lyskom-check-call kom-queue))))))


;; who-is-on is obsoleted by who-is-on-dynamic (83) i protocol version 9
(defun initiate-who-is-on (kom-queue handler &rest data)
  "Ask server who is on.
Args: KOM-QUEUE HANDLER &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-who-info-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 51))))


(defun initiate-get-unread-confs (kom-queue handler pers-no &rest data)
  "Return a list of confs that may have unread texts.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA.
PERS-NO is the number of the person whos confs we are checking."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-conf-no-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 52 pers-no))))


(defun initiate-send-message (kom-queue handler recipient message &rest data)
  "Send a message to one or all logged in users.
Args: KOM-QUEUE HANDLER RECIPIENT MESSAGE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 53 recipient message))))


(defun initiate-get-session-info (kom-queue handler session-no &rest data)
  "Ask server for info about a session.
Args: KOM-QUEUE HANDLER SESSION-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-session-info)
    (lyskom-send-packet kom-queue (lyskom-format-objects 54 session-no))))


(defun initiate-disconnect (kom-queue handler session-no &rest data)
  "Disconnect a session.
Args: KOM-QUEUE HANDLER SESSION &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 55 session-no))))


(defun initiate-who-am-i (kom-queue handler &rest data)
  "Ask the server which connection we are using.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 56))))

(defun initiate-set-user-area (kom-queue handler pers-no text-no &rest data)
  "Set user-area of a person.
Args: KOM-QUEUE HANDLER PERS-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 57 pers-no text-no))))

(defun initiate-get-last-text (kom-queue handler before &rest data)
  "Get text created before BEFORE.
Args: KOM-QUEUE HANDLER BEFORE &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 58 before))))


(defun initiate-create-anonymous-text (kom-queue 
                                       handler
                                       message 
                                       misc-list
                                       aux-items
                                       &rest data)
  "Create a new anonymous text.
Args: KOM-QUEUE HANDLER MESSAGE MISC-LIST AUX-ITEMS &rest DATA.
MESSAGE is a string. MISC-LIST should be created by lyskom-create-misc-list."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 87)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 87
                                                  (cons 'STRING message)
                                                  misc-list
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 59 
                                                (cons 'STRING message)
                                                misc-list)))))


(defun initiate-find-next-text-no (kom-queue handler text-no &rest data)
  "Find the text following the text TEXT-NO"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (