;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: header.el,v 44.5 2002/04/28 11:50:35 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: header.el
;;;;
;;;; Code that needs to go before everything else
;;;;


;;; Check the version of Emacs when compiling
;;;
;;; If the version of Emacs is too old, signal an error.
;;; We require Gnu Emacs 19.34 or 20.3 or XEmacs 21.1.

(eval-and-compile
  (if (or (not (boundp 'emacs-major-version))
          (not (boundp 'emacs-minor-version))
          (and (string-match "XEmacs" (emacs-version))
               (or (< emacs-major-version 20)
                   (and (= emacs-major-version 20)
                        (< emacs-minor-version 4))
                   (and (= emacs-major-version 21)
                        (< emacs-minor-version 1))))
          (and (not (string-match "XEmacs" (emacs-version)))
               (or (< emacs-major-version 19)
                   (and (= emacs-major-version 19)
                        (< emacs-minor-version 34))
                   (and (= emacs-major-version 20)
                        (< emacs-minor-version 2)))))
      (error "Emacs 19.34, XEmacs 21.1 or later, or Emacs 20.2 or later is required")))

(cond ((or (not (boundp 'emacs-major-version))
           (not (boundp 'emacs-minor-version))
           (< emacs-major-version (eval-when-compile emacs-major-version)))
       (error "LysKOM was compiled for a newer version of Emacs"))
      ((and (eq (eval-when-compile emacs-major-version) 19)
            (> emacs-major-version 19))
       (error "A LysKOM client compiled for Emacs 19 will not run in newer versions of Emacs.")))

;;; Check some basic misfeatures that are still all too common



(eval-and-compile
  (defmacro lyskom-detect-read-kbd-macro-bug ()
    `(and (stringp (read-kbd-macro "<SPC>"))
          (string-equal (read-kbd-macro "<SPC>") "<SPC>")))

  (let ((libraries-to-try '("edmacro")))
    (while libraries-to-try
      (if (lyskom-detect-read-kbd-macro-bug)
          (progn (condition-case nil
                     (load-library (car libraries-to-try))
                   (error nil))
                 (setq libraries-to-try (cdr libraries-to-try)))
        (setq libraries-to-try nil)))

    (if (lyskom-detect-read-kbd-macro-bug)
        (let ((elc-location (locate-library "macedit.elc"))
              (el-location (locate-library "macedit.el"))
              (elz-location (locate-library "macedit.el.gz")))
          (cond ((or el-location elc-location)
                 (message "\

You probably have a file named macedit.elc in Emacs' load path.

This file is included in some versions of the calc package and
is no longer required as the functions that it provides are
also provided by more modern packages.

You will need to remove macedit.el and all references to it
from Emacs. These are the files you need to remove:

%s
To fully remove macedit you will also have to remove any
autoloads that refer to it. These may be found in a file
named auto-autoloads.elc (or auto-autoloads.el), located 
in the same directory as macedit or in a file named
loaddefs.el, located elsewhere.

With Gnu Emacs you may be successful in removing references
by using the command update-autoloads-from-directories.
"
                          (mapconcat (lambda (x) (or x "")) 
                                     (list elc-location el-location elz-location) 
                                     "\n"))
                 (error "Unable to run or compile due to obsolete macedit package."))
                (t
                 (message "\

Your definition of read-kbd-macro appears to be obsolete. This
is usually caused by having a package called macedit in Emacs
load path, but I am unable to find this package. LysKOM cannot
run with your version of read-kbd-macro.
")
                 (error "Unable to run or compile due to obsolete definition of read-kbd-macro.")))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: defvar.el,v 44.15 2002/04/13 15:01:28 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: defvar.el
;;;; Authos: David Byers
;;;;
;;;; This file contains definitions used to define variables
;;;;


(defconst lyskom-clientversion-long 
  "$Id: defvar.el,v 44.15 2002/04/13 15:01:28 byers Exp $\n"
  "Version for every file in the client.")


(provide 'lyskom)

;; Just to get rid of a compiler warning
(defvar kom-dont-read-saved-variables)

(defvar lyskom-local-variables nil
  "List of variables to make local in a LysKOM buffer")

(defvar lyskom-local-hooks nil
  "List of hooks to make local in a LysKOM buffer.")

(defvar lyskom-protected-variables nil
  "List of variables that are protected from kill-buffer")

(defvar lyskom-inherited-variables nil
  "List of variables inherited from the LysKOM buffer")

(defvar lyskom-elisp-variables nil
  "Tells the client what flags and hooks that are to be saved in the server.
These are the flags that are saved in the elisp-client part of the server.")

(defvar lyskom-minibuffer-variables nil
  "These are variables that should be set in the minibuffer by 
lyskom-with-lyskom-minibuffer.")

(defvar lyskom-minibuffer-values nil
  "Dynamic binding of values that minibuffer variables are to take on")


(defmacro lyskom-save-variables (var-list &rest forms)
  "Save the values and property list of symbols in VAR-LIST and execute FORMS
The symbol value, property list and buffer-local property of all variables
is saved before executing FORMS and restored when FORMS have finished."
  (let ((sym1 (make-symbol "lyskom-saved-variables"))
        (sym2 (make-symbol "lyskom-saved-symbols"))
        (sym3 (make-symbol "lyskom-saved-local"))
        (sym4 (make-symbol "lyskom-saved-plist")))
    (` (let* (((, sym2) (quote (, var-list)))
              ((, sym1) (mapcar 'symbol-value (, sym2)))
              ((, sym4) (mapcar 'symbol-plist (, sym2)))
              ((, sym3) (mapcar (function
                                 (lambda (v)
                                   (local-variable-p v (current-buffer))))
                                 (, sym2))))
         (unwind-protect 
             (progn (,@ forms))
           (while (, sym1)
             (if (car (, sym3)) (make-local-variable (car (, sym2))))
             (set (car (, sym2)) (car (, sym1)))
             (setplist (car (, sym2)) (car (, sym4)))
             (setq (, sym1) (cdr (, sym1))
                   (, sym2) (cdr (, sym2))
                   (, sym3) (cdr (, sym3))
                   (, sym4) (cdr (, sym4)))))))))

(put 'lyskom-save-variables 'edebug-form-spec
     '(sexp body))

(defmacro lyskom-with-lyskom-minibuffer (&rest forms)
  "Run FORMS after ensuring that LysKOM minibuffer variables will be set."
  (` (let* ((lyskom-minibuffer-values
             (mapcar 'symbol-value lyskom-minibuffer-variables)))
       (unwind-protect
           (progn
             (add-hook 'minibuffer-setup-hook
                       'lyskom-setup-minibuffer-variables)
             (,@ forms))
         (remove-hook 'minibuffer-setup-hook
                      'lyskom-setup-minibuffer-variables)))))

(put 'lyskom-with-lyskom-minibuffer 'edebug-form-spec
     '(body))


(defun lyskom-setup-minibuffer-variables ()
  (let ((syms lyskom-minibuffer-variables)
        (vals lyskom-minibuffer-values))
    (while syms
      (make-local-variable (car syms))
      (set (car syms) (car vals))
      (setq syms (cdr syms)
            vals (cdr vals)))))

         

(defmacro def-kom-var (name value &rest args)
    "Define a variable with name NAME and initial value VALUE.
Remaining args, ARGS may be
A string        Used as the documentation string for the variable
A symbol        A predefined property of the variable
A list          A widget specification for the variable

Predefined (and tested) properties are the following
server          Save the variable in the elisp block. Implies local.
local           Make the variable buffer-local.
inherited       The variable is inherited from parent buffer. Implies protected
protected       The variable is marked as permanent local. Implies local.
minibuffer      Inherit the variable as a local variable in the minibuffer.
server-hook     A hook stored in the server.
local-hook      A hook variable that is made local in LysKOM buffers.
language-force  A language-variable whose value is to be forced."
          
    (let ((inherited nil)
          (protected nil)
          (elisp-block nil)
          (buffer-local nil)
          (widget-spec nil)
          (doc-string nil)
          (minibuffer nil)
          (local-hook-doc nil)
          (local-var-doc nil)
          (server-doc nil)
          (language-force nil)
          (arglist args))
      (while arglist
        (cond ((stringp (car arglist)) (setq doc-string (car arglist)))
              ((consp (car arglist))
               (setq widget-spec 
                     (` ((setq lyskom-custom-variables
                               (cons  (quote (, (list name
                                                      (car arglist))))
                                      lyskom-custom-variables))))))
              ((symbolp (car arglist))
               (cond ((eq (car arglist) 'server)
                      (setq local-var-doc t server-doc t)
                      (setq elisp-block
                            (` ((if (and (not (memq (quote (, name))
                                                      lyskom-global-boolean-variables))
                                           (not (memq (quote (, name))
                                                      lyskom-global-non-boolean-variables)))
                                           (add-to-list 'lyskom-elisp-variables
                                                        (quote (, name))))
                                      (add-to-list 'lyskom-local-variables
                                                   (quote (, name)))))))

                     ((eq (car arglist) 'server-hook)
                      (setq local-hook-doc t server-doc t)
                      (setq elisp-block
                            (` ((add-to-list 'lyskom-elisp-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-hooks
                                             (quote (, name)))))))

                     ((eq (car arglist) 'protected)
                      (setq local-var-doc t)
                      (setq protected
                            (` ((put (quote (, name)) 'permanent-local t)
                                (add-to-list 'lyskom-protected-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'inherited)
                      (setq local-var-doc t)
                      (setq inherited
                            (` ((add-to-list 'lyskom-inherited-variables
                                             (quote (, name)))
                                (put (quote (, name)) 'permanent-local t)
                                (add-to-list 'lyskom-protected-variables
                                             (quote (, name)))
                                (add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'local)
                      (setq local-var-doc t)
                      (setq buffer-local
                            (` ((add-to-list 'lyskom-local-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'local-hook)
                      (setq local-hook-doc t)
                      (setq buffer-local
                            (` ((add-to-list 'lyskom-local-hooks
                                             (quote (, name)))))))

                     ((eq (car arglist) 'minibuffer)
                      (setq minibuffer
                            (` ((add-to-list 'lyskom-minibuffer-variables
                                             (quote (, name)))))))

                     ((eq (car arglist) 'language-force)
                      (setq language-force
                            `((put ',name 'lyskom-language-force t))))

                     (t (error "LysKOM: Unknown variable property: %S"
                               (car arglist)))))
              (t (error "LysKOM: Strange variable argument type: %S" 
                        (car arglist))))
        (setq arglist (cdr arglist)))

      (if doc-string
        (if
          (if (or local-var-doc local-hook-doc)
            (setq doc-string (concat doc-string "\n")))
          (if local-var-doc
            (setq doc-string (concat doc-string "\nThis variable is buffer-local.")))
          (if local-hook-doc
            (setq doc-string (concat doc-string "\nThis variable is a buffer-local hook.")))
          (setq doc-string (concat doc-string "\n\n\
Setting this variable in .emacs may not yield the results you expect
since that will affect all LysKOM sessions."))))

      (if (and doc-string server-doc)
        (setq doc-string (concat doc-string "

This variable is normally stored on a per-session basis in the
LysKOM server, but can be set in your .emacs simply by setting
it using setq or defvar.")))


      (` (progn (dont-compile (if (and (boundp (quote (, name)))
                                       (or (not (boundp lyskom-is-loaded))
                                           (not lyskom-is-loaded))
                                       (listp kom-dont-read-saved-variables))
                                  (add-to-list 'kom-dont-read-saved-variables
                                               (quote (, name)))))
                (defvar (, name) (, value) (, doc-string))
                (,@ (apply 'append
                           (list inherited
                                 protected
                                 elisp-block
                                 buffer-local
                                 minibuffer
                                 widget-spec
                                 language-force
                                 )))))))


(put 'def-kom-var 'edebug-form-spec
     '(&define name form &rest sexp))



(eval-and-compile (provide 'lyskom-defvar))



;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: feature.el,v 1.5 2002/02/28 18:43:13 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: feature.el
;;;;
;;;; Functions for determining if we have a particular feature or not
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: feature.el,v 1.5 2002/02/28 18:43:13 joel Exp $\n"))

(def-kom-var lyskom-feature-defaults nil
  "Alist with default values of all feature variables")

(eval-and-compile
  (defun lyskom-feature-variable (name)
    (intern (format "lyskom-%s-feature-flag" name))))

(defmacro lyskom-define-feature (name default)
  "Define a feature variable NAME with default value DEFAULT"
  `(progn (setq lyskom-feature-defaults 
                (cons (cons ',name ,default) lyskom-feature-defaults))
          (def-kom-var ,(lyskom-feature-variable name) ,default
            "LysKOM feature flag variable."
            inherited minibuffer local)))

(defmacro lyskom-set-feature (name value)
  "Set the value of feature NAME to VALUE"
  `(setq ,(lyskom-feature-variable name) ,value))

(defmacro lyskom-have-feature (name)
  "Return non-nil if feature NAME is non-nil"
  (lyskom-feature-variable name))

(defmacro lyskom-feature-value (name)
  "Return the value of feature NAME"
  (lyskom-feature-variable name))

(defun lyskom-clear-features ()
  "Set the feature variables to their defaults"
  (mapcar (lambda (feature)
            (set (lyskom-feature-variable (car feature)) (cdr feature)))
          lyskom-feature-defaults))

(defun lyskom-list-features ()
  "List all feature values. mapcar ROCKS!"
  (mapcar 'lyskom-insert-before-prompt
          (mapcar (lambda (x) (apply 'format "%S: %S\n" x))
                  (mapcar2 'list
                           (mapcar 'car lyskom-feature-defaults)
                           (mapcar 'symbol-value 
                                   (mapcar 'lyskom-feature-variable
                                           (mapcar 'car lyskom-feature-defaults)))))))

;;; ======================================================================
;;; ======================================================================

;;; Utility functions

(defmacro lyskom-have-call (call-no)
  "Non-nil if call CALL-NO is supported by the server"
  `(<= ,call-no (lyskom-feature-value highest-call)))


;;; ======================================================================
;;; ======================================================================

;;; The features

(lyskom-define-feature bcc-misc nil)
(lyskom-define-feature aux-items nil)
(lyskom-define-feature highest-call 0)
(lyskom-define-feature local-to-global nil)
(lyskom-define-feature dynamic-session-info nil)
(lyskom-define-feature idle-time nil)
(lyskom-define-feature long-conf-types nil)


(provide 'lyskom-feature)
;;;;; -*-coding: raw-text;mode: emacs-lisp;-*-
;;;;; $Id: vars.el.in,v 44.207 2002/09/08 11:13:14 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: vars.el
;;;;
;;;; This file contains almost all the variables used in lyskom.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: vars.el.in,v 44.207 2002/09/08 11:13:14 byers Exp $\n"))

(defvar lyskom-mule-compiled
  (eval-when-compile (and (fboundp 'multibyte-string-p)
                          (multibyte-string-p "")))
  "Non-nil if the client was compiled with multibyte characters enabled")

(provide 'lyskom)

(require 'lyskom-defvar "defvar")

(defconst lyskom-global-boolean-variables '(
  kom-created-texts-are-read
  kom-dashed-lines
  kom-presence-messages
  kom-print-number-of-unread-on-entrance
  kom-read-depth-first
  kom-reading-puts-comments-in-pointers-last
  kom-confirm-multiple-recipients
)
  "List of flags that are to be saved as booleans in the common block.

Don't change these. They are defined by the protocol.")

(defconst lyskom-global-non-boolean-variables '(
  kom-default-mark
)
  "List of flags that are to be saved in the common block.
These are the non-boolean ones. See: lyskom-global-boolean-variables.

Don't change these. They are defined by the protocol.")



(defun lyskom-protect-variable (sym) 
  "Protect SYM from being killed when deleting local variables."
  (put sym 'permanent-local t)
  (lyskom-local-variable sym)
  (add-to-list 'lyskom-protected-variables sym))

(defun lyskom-local-variable (sym)
  "Define SYM as a buffer-local variable"
  (add-to-list 'lyskom-local-variables sym))

(defun lyskom-inherited-variable (sym)
  "Define SYM as a variable that is inherited when creating new buffers.
Inheritance only works with the LysKOM buffer handling functions."
  (add-to-list 'lyskom-inherited-variable sym)
  (lyskom-protect-variable sym))

(defun lyskom-setup-local-variables ()
  "Set up all globally defined local variables in the current buffer."
  (mapcar 'make-local-variable lyskom-local-variables)
  (mapcar 'make-local-hook lyskom-local-hooks))

(defvar lyskom-is-loaded nil
  "Non-nil when lyskom has been loaded.")

(defvar lyskom-have-one-login nil
  "Non-nil after the first login")


(def-kom-var kom-dont-read-saved-variables '(kom-dont-read-saved-variables
                                             lyskom-login-hook)
  "*Non-nil means don't read some variables from the server.
t means don't read any variables. A list means don't read variables that
are in the list.")

(defmacro lyskom-maybe-setq (var value)
  "This is a wrapper around setq that does nothing
if the variable is in kom-dont-read-saved-variables."
  `(cond ((eq kom-dont-read-saved-variables t) nil)
         ((memq ,var kom-dont-read-saved-variables) nil)
         (t (set ,var ,value))))

(defmacro lyskom-maybe-setq-default (var value)
  "This is a wrapper around setq-default that does nothing
if the variable is in kom-dont-read-saved-variables."
  `(cond ((eq kom-dont-read-saved-variables t) nil)
         ((memq ,var kom-dont-read-saved-variables) nil)
         (t (set-default ,var ,value))))


;;;; ================================================================
;;;;                     Variables and constants.


;;; User flags

(defconst lyskom-old-farts-text-prompt-strategy
  '((kom-comment-previous . ((t   . lyskom-get-previous-text)
			     (nil . lyskom-get-previous-text)))
    (t . ((t   . lyskom-get-last-read-text)
	  (nil . lyskom-get-last-read-text)
	  (0   . lyskom-get-text-at-point)
	  (-     lyskom-get-text-above-point (lambda (&optional args) 1))
	  (listp . lyskom-prompt-for-text-no)
	  (lyskom-plusp . lyskom-get-explicit-text)
	  (lyskom-minusp  lyskom-get-text-above-point abs))))
"Put in your `kom-pick-text-no-strategy-alist' to get the 0.46 behaviour:
 * No prefix argument refers to the most recently read text.
 * The prefix argument zero refers to the text under point.
 * A positive prefix argument is interpreted as a text-no.
 * A negative prefix argument will try to find the text-no
   of the text `arg' messages above point from the current
   kom buffer.")

(def-kom-var kom-pick-text-no-strategy-alist
      '((kom-comment-previous . ((t   . lyskom-get-previous-text)
				 (nil . lyskom-get-previous-text)))
        (kom-private-answer-previous . ((t   . lyskom-get-previous-text)
                                        (nil . lyskom-get-previous-text)))
	(t . ((t   . lyskom-get-text-at-point) ; default for prompts
	      (nil . lyskom-get-text-at-point) ; no prefix arg
	      (0   . lyskom-prompt-for-text-no)
	      (-     lyskom-get-text-above-point (lambda (&optional arg) 1))
	      (listp lyskom-get-text-at-point-ancestor
		     (lambda (arg) (/ (logb (car arg)) 2)))
	      (lyskom-plusp . lyskom-get-text-below-point)
	      (lyskom-minusp  lyskom-get-text-above-point abs))))
      "Defines how prefix arguments are used to find a text-no to operate on.
The cars on the list are either one of the functions which invokes
`lyskom-read-text-no-prefix-arg' (typically the one of the kom-* functions),
or the value t for the strategy common to all such functions. For functions in
the list, the strategy is chosen from the cdr of that entry and, if and when
no matching rule was found that way, from the common strategy.

Each cdr on the list is an alist specifying when to do how when mapping a
prefix argument to a text-no.

The cars on this alist are the predicates for which the cdrs map functions that
retrieve the text-no to operate on. Each predicate is tested in turn on the
prefix argument, and when one returns non-nil, the cdr gets invoked, until the
list is empty or one cdr returned some non-nil value, whichever comes first. If
you like, the cars can also be the actual prefix-arg values (-, 0 or nil, for
example) that you want to invoke some special rule for. The value t means that
the behaviour given by the cdr stipulates the DEFAULT value for the prompt,
when one is shown.

The cdrs on the list may be either of:

* a function, in which case it gets called with four parameters: the prefix
  argument, the PROMPT that would be used to ask the user for a text-no, a
  (possibly nil) DEFAULT choice for that prompt, and a CONSTRAINT value, all
  as provided in the call to `lyskom-read-text-no-prefix-arg' (see its docs)
  Returning a positive integer means return that text-no. Returning a common
  lyskom format string aborts, showing your helpful error description. A nil
  return value means try successive rules instead to get a text-no.

* a list of two functions, optionally followed by additional list items,
  in which case the second function is called to change the prefix argument
  parameter for the first function, which is then called as above. Any extra
  items on the argument list will be appended to its argument list. Hence, a
  '(my-get-text-no abs 17 4711) entry would result in a my-get-text-no call
  (funcall my-get-text-no (abs prefix-arg) prompt default nil 17 4711)."
  )


(def-kom-var kom-keyboard-menu-immediate-selection nil
  "*When non-nil, typing a keyboard shortcut in a keyboard menu selects
the item immediately, without requiring the user to press RET to confirm."
  server)


(def-kom-var kom-edit-hide-add-button nil
  "*If non-nil, hide the add button shown after the headers when editing
a text."
  server
)

(def-kom-var kom-max-overlays 120
  "*Maximum number of overlays to use to highlight texts.
Each text uses one, two, three or four overlays, depending on settings.
Must be a positive integer or nil. If nil, the number of overlays will
be unlimited. Behavior of non-positive and non-nil values is undefined."
  server
)

(def-kom-var kom-highlight-text-body t
  "*If t, overlay kom-text-body-face on printed text bodies in LysKOM.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-highlight-first-line t
  "*If t, overlay kom-first-line-face on the first header line of texts.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-highlight-dashed-lines t
  "*If t, overlay kom-dashed-lines-face on the lines surrounding texts.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-async-highlight-text-body t
  "*If t, overlay kom-text-body-face on asynchronous messages in LysKOM.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-async-highlight-dashed-lines t
  "*If t, overlay kom-dashed-lines-face on the lines surrounding messages.
When this is enabled, an overlay or extent will be created that may
override certain aspects of the underlying text's formatting. Values
other than t or nil are reserved for future use."
  server
)

(def-kom-var kom-extended-status-information nil
  "*If t, list extended status information for all objects in LysKOM.
Extended status information include such information as read FAQs.
Values other than t or nil are reserved for future extensions."
  server
)

(def-kom-var kom-auto-list-faqs t
  "*If non-nil, list unread FAQs when entering a conference or logging
on to the server."
  server
)

(def-kom-var kom-auto-review-faqs t
  "*If non-nil, automatically review unread FAQs when entering a
conference or logging on to the server."
  server
)

(def-kom-var kom-allow-incompleteness nil
  "*If nil, commands like kom-list-news will wait for the prefetch.
If this flag is set to t, some commands may give incomplete answers,
but it might make them faster, especially during the login phase."
  server
)

(def-kom-var kom-bury-buffers t
  "*Controls the behaviour of kom-next-kom and its cousins.
If this variable is non-nil the current buffer is sent to the back
of the buffer list when one of the commands `kom-next-kom',
`kom-previous-kom' or `kom-next-unread-kom' is invoked."
  server)

(def-kom-var kom-write-texts-in-window nil
  "*Where to edit texts. One of nil, 'other, 'new-frame, 'other-frame, a string
or a buffer.

nil means edit texts in the same window as the LysKOM buffer.
'other means edit in another window, creating it if necessary.
'other-frame means edit in another frame, if there is one.
'new-frame means create a new frame for editing. The frame will be removed 
          when editing is finished.
A string or buffer means edit in the indicated buffer."
  server)

(def-kom-var kom-view-commented-in-window 'other
  "*Where to view commented texts. See kom-write-texts-in-window for details."
  server)

(def-kom-var kom-edit-filters-in-window nil
  "*Where to edit filters. See kom-write-texts-in-window for
more information."
  server)

(def-kom-var kom-list-membership-in-window 'other
  "*Where to list membership. See kom-write-texts-in-window for
more information."
  server)

(def-kom-var kom-personal-messages-in-window 'other
  "*Where to display personal messages. See kom-write-texts-in-window 
for more information."
  server)

(def-kom-var kom-customize-format 'long
  "*Format of the customize buffer. Must be long or short."
  server)

(def-kom-var kom-user-prompt-format "%[%c% %m%] - "
  "*Format of LysKOM prompt when waiting for input."
  server)


(def-kom-var kom-user-prompt-format-executing "%[%c% %m%]."
  "*Format of LysKOM prompt when executing a default command"
  server)


(def-kom-var kom-enabled-prompt-format "%[%c% %m%] # "
  "*Format of LysKOM prompt when in enabled mode."
  server)


(def-kom-var kom-enabled-prompt-format-executing "%[%c% %m%]."
  "*Format of LysKOM prompt when executing a default command in 
enabled mode."
  server)

(def-kom-var kom-anonymous-prompt-format "%[%c% %m%] (%a) - "
  "*Format of the LysKOM prompt when running anonymously."
  server)

(def-kom-var kom-anonymous-prompt-format-executing "%[%c% %m%] (%a)."
  "*Format of the LysKOM prompt when executing a command anonymously."
  server)

(def-kom-var kom-show-week-number t
  "*If non-nil show the ISO week number when displaying the time."
  server)


(def-kom-var kom-cite-string ">"
  "*String to insert before each line of a commented text."
  server)

(def-kom-var kom-created-texts-are-saved nil
  "*If non-nil, save all created texts to a file. 
The value of this variable is the file name on which to save new texts."
  server
  inherited)

(def-kom-var kom-created-texts-are-read t
  "*Non-nil means automatically mark texts that you create as read."
  server)

(def-kom-var kom-customize-in-window nil
  "*Where to customize LysKOM. See kom-write-texts-in-window."
  server)

(def-kom-var kom-prioritize-in-window nil
  "*Where to prioritize conferences. See kom-write-texts-in-window."
  server)

(def-kom-var kom-default-mark nil
  "*If non-nil (must be an integer), the user is not asked for type of mark."
  server)

(def-kom-var kom-symbolic-marks-alist '(("Standard" . 100))
  "*Assoc list which maps symbolic mark strings to mark numbers."
  server)

(def-kom-var kom-reading-puts-comments-in-pointers-last t
  "*If non-nil, the texts are shown with comment references at the end."
  server
  inherited)

(def-kom-var kom-review-uses-cache t
  "*If non-nil, review commands don't use the cache."
  server
  inherited)

(def-kom-var kom-review-marks-texts-as-read nil
  "*If non-nil, review commands mark the reviewed texts as read."
  server
  inherited)

(def-kom-var kom-postpone-default 17
  "*The number of articles to postpone by default."
  server)


(def-kom-var kom-dashed-lines t
  "*If non-nil, all texts will be surrounded by lines of dashes."
  server
  inherited)

(def-kom-var kom-long-lines nil
  "*If non-nil, some lines and borders will be made longer."
  server
  inherited)

(def-kom-var kom-text-footer-dash-length 52
  "*If non-nil, the total length of the text footer, when dashes are in use.
Note that the footer may end up longer than this if one or more elements
together are longer than this length.

This length is currently ignored when kom-text-footer-format is used."
  server
  inherited)

(def-kom-var kom-text-header-dash-length 60
  "*If non-nil, the total length of the dashes before a text body.
If kom-dashed-lines is non-nil, this is ignored."
  server
  inherited)



(def-kom-var kom-text-footer-format nil
  "*If non-nil, this specifies the format of a text footer.

The following format directives are legal:

    %n      The text number.
    %p      The number of the author.
    %P      The name of the author
    %-      A bunch of dashes
    %f      Information about the text in parentheses.

Format letters can be prefixed with a number specifying the minimum
field width. The field width can be prefixed with an equals sign which
means that the field is exactly as wide as specified (contents may be
truncated). A negative field width means left justify the contents.

The field width of %- is special. It specifies the maximum number of
dashes printed. The actual number will be the maximum minus the
length of the author's name, if it is included anywhere in the format
string.

When set, this variable overrides kom-dashed-lines and
kom-show-author-at-end.

The default format is equivalent to the following strings, depending on 
the settings of kom-dashed-lines and kom-show-author-at-end.

kom-dashed-lines    kom-show-author-at-end      Format
t                   t                           \"(%n) /%P/%42-%f\"
t                   nil                         \"(%n) %42-%f\"
nil                 t                           \"(%n) /%P/ %f\"
nil                 nil                         \"(%n) %f\"
"
  server
  inherited)



(def-kom-var kom-show-creating-software nil
  "*If non-nil, show the creating software of each text, if specified."
  server
  inherited)

(def-kom-var kom-show-author-at-end t
  "*If non-nil, the author will be shown at the end of each text."
  server
  inherited)

(def-kom-var kom-truncate-threshold nil
  "*If non-nil, truncate long texts when reviewing.
If the text is longer (in lines), the threshold it will be
truncated to `kom-truncate-show-lines' length."
  server)

(def-kom-var kom-truncate-show-lines 10
  "*How many lines to show after truncating.
If the text is truncated by `kom-truncate-threshold', show this many
lines.  If this is greater than the threshold, the threshold will be
used."
  server)


(def-kom-var kom-print-number-of-unread-on-entrance t
  "*If non-nil, print automatically the number of unread articles when
entering a conference."
  server)

(def-kom-var kom-show-unread-in-frame-title t
  "*If non-nil, show an unread indicator in the frame title of each
LysKOM session."
  server)

;; In the common block of the user-area is a simple boolean variable
;; `presence-messages'.  The control of presence messages in the Emacs
;; Lisp client is more advanced, using two non-boolean variables instead
;; (`kom-presence-messages-in-echo' and `kom-presence-messages-in-buffer').
;;
;; Keep track of the common block variable too, although it isn't used here.
;; `lyskom-save-options' sets it before saving it in obvious cases,
;; but generally it's not possible to know what value it should have.
;; (It could also be used for default values for the presence options for
;; users converting from another client, but that isn't done.)

(def-kom-var kom-presence-messages t
  "Equivalent of the variable `presence-messages' in the user-area.
This is a boolean where other clients may store whether the user wants
messages about people logging in and out of LysKOM.  Here this is instead
controlled by `kom-presence-messages-in-echo-area' and
`kom-presence-messages-in-buffer', so only use this variable to
influence what this client stores in the common block of the user-area."
  server)

(def-kom-var kom-presence-messages-in-echo-area t
  "*If non-nil, LysKOM prints continuous info about what other people are doing.
Info is printed on the echo area and never in the buffer. If minibuffer is
used, no message is printed.

A list of integers means show messages for those users.

The value 'friends means show messages for the users in kom-friends.

The value 'morons means show messages for the users in kom-morons.

The value 'friends-and-morons means show messages for the users in 
kom-friends and kom-morons.

If you want the messages in the buffer, you could set the variable 
kom-presence-messages-in-buffer."
  server)



(def-kom-var kom-presence-messages-in-buffer nil
  "*If non-nil, LysKOM prints information about what other people are doing in the buffer.
All printing is done just before the prompt.

If nil no messages are printed.
If 'presence, messages about people logging in, out and people 
changing name are printed."
  server)

(def-kom-var kom-show-where-and-what t
  "*Non-nil means kom-who-is-on shows from which machine the user is running
and what he is doing."
  server)

(def-kom-var kom-show-since-and-when nil
  "*Non-nil means kom-who-is-on shows when the user connected and when
he last was active."
  server)

(def-kom-var kom-idle-hide 30
  "*The number of minutes of idle-time before a user is excluded from the list
of users. This can be overridden by a prefix argument to `kom-who-is-on'."
  server)

(def-kom-var kom-show-footnotes-immediately t
  "*Non-nil means show footnotes immediately following the text."
  server)

(def-kom-var kom-follow-comments-outside-membership nil
  "*Show comments in conferences you are not a member of.

If this variable is nil, texts with no recipient you are a member of
will not be shown."
  server)

(def-kom-var kom-follow-attachments t
  "*Follow attachments as if they are regular comments."
  server)

;;(def-kom-var kom-who-buffer-size-when-displaying 10
;;  "Size of window to display the who-buffer.
;;This is used when executing the kom-display-who-buffer command."
;;  server)

(def-kom-var kom-read-depth-first t
  "*Non-nil means read comments and footnotes to a text before other texts."
  server)

(def-kom-var kom-continuous-scrolling t
  "*Non-nil means scroll LysKOM window as text is inserted. The last viewed
position (generally the most recent prompt) will always be visible."
  server)


;; Should this be set to nil if baud-rate is low?
(def-kom-var kom-deferred-printing t
  "*Non-nil means delay printing of some information not in the cache.
You might want to turn this off to have the old, linear behaviour."
  server)

(def-kom-var lyskom-overlay-pool nil  
  "Pool of overlays"
  local)

(def-kom-var lyskom-defer-indicator "[...]"
  "String to display while LysKOM is waiting for the real string.")

(def-kom-var kom-review-priority nil
  "*If non-nil, the priority to use when reviewing texts. Set this to
255 or higher to avoid texts and conferences with higher priority to
break in while reviewing."
  server)

(def-kom-var kom-higher-priority-breaks nil
  "*Non-nil means allow texts from conferences with higher priority to break in.
If the value is 'express, texts are allowed to break in the middle of a
comment chain. Otherwise we don't let them in until the end of the comment
tree."
  server)

(def-kom-var kom-server-priority-breaks nil
  "*Non-nil means allow servers with a higher priority to break in.
Valid values are 'express, 'express-letters, 'letters, 'after-conf, 
'after-conf-letters, t and 'when-done.

'express means break immediately when a text arrives in a prioritized
session.

'express-letters means break immediately when a letter arrives in a 
prioritized session.

t means break after the current comment chain when a text arrives in 
a prioritized session.

'letters means break after the current comment chain when a letter
arrives in a prioritized session.

'after-conf means break after the current conference when a text
arrives in a prioritized session.

'after-conf-letters means break after the current conference when a
letter arrives in a prioritized session.

'when-done means prompt user to go to the next session with unreads
after everything has been read. This overrides kom-do-when-done as
long as there are sessions with unread texts.
"
  server)

(def-kom-var kom-view-text-hook nil
  "*Hook that is called before a text is shown. When the hooks are
called, kom-view-text-text is bound to the text mass of the 
text and kom-view-text-text-stat to the text-stat of the text
to be shown."
  local-hook)

(def-kom-var lyskom-view-text-hook nil
  "Obsolete synonym for kom-view-text-hook."
  local-hook)


(def-kom-var lyskom-send-message-hook nil
  "*Obsolete synonym for lyskom-send-message-hook."
  local-hook)

(def-kom-var kom-send-message-hook '(lyskom-send-message-trim-newlines)
  "*Hook that is called before a personal, group or common message is sent. 

When called, lyskom-message-string is bound to the message that will be sent
and lyskom-message-recipient to the conf-stat of the recipient or nil if
the recipient does not exist or if the message is a common message.

If lyskom-message-string is set to nil by a hook, the message will not
be sent."
  local-hook)

(def-kom-var kom-send-message-setup-hook nil
  "*Hook that is called when the minibuffer is entered to read a message."
  local-hook)

(def-kom-var lyskom-send-message-setup-hook nil
  "*Obsolete synonym for kom-send-message-setup-hook."
  local-hook)

(def-kom-var kom-send-message-exit-hook nil
  "*Hook that is called when the minibuffer is exited after reading a message."
  local-hook)

(def-kom-var lyskom-send-message-exit-hook nil
  "*Obsolete synonym for kom-send-message-exit-hook."
  local-hook)

(def-kom-var kom-send-text-hook nil
  "*Hook that is called before sending a text. Hook functions return t to
signal success and nil to prevent the text from being sent."
  local-hook)

(def-kom-var lyskom-send-text-hook nil
  "*Obsolete synonym for kom-send-text-hook."
  local-hook)

(def-kom-var kom-after-load-hook nil
  "*Hook to run once after LysKOM is loaded.")

(def-kom-var lyskom-after-load-hook nil
  "*Obsolete synonym for kom-after-load-hook.")

(def-kom-var kom-change-conf-hook nil
  "*Hook to run when changing conferences.
The functions in this list are run with two arguments. The first is the 
current conf-no and the second is the conf-no being changed to.

This hook is run before lyskom-current-conf is changed, and before any
standard messages have been printed."
  local-hook)

(def-kom-var lyskom-change-conf-hook nil
  "*Obsolete synonym for kom-change-conf-hook"
  local-hook)

(def-kom-var kom-after-change-conf-hook nil
  "*Hook to run when changing conferences.
The functions in this list are run with two arguments. The first is the 
current conf-no and the second is the conf-no being changed to.

This hook is run after lyskom-current-conf is changed, and after any
standard messages have been printed."
  local-hook)

(def-kom-var lyskom-after-change-conf-hook nil
  "*Obsolete synonym for kom-after-change-conf-hook."
  local-hook)

(def-kom-var lyskom-login-hook nil
  "*What to do when logged in.
This hook is called after we have logged in but before any command is
accepted from the keyboard. It is called immediately before
kom-login-hook."
  local-hook)

(def-kom-var kom-login-hook nil
  "*What to do when logged in.
This is a list of commands that are executed after we have logged in but before
any command is accepted from the keyboard. See also lyskom-login-hook."
  server)

(def-kom-var kom-confirm-add-recipients t
  "*When non-nil, offer to add cc-recipient instead of full recipient."
  server)


(def-kom-var kom-do-when-done '(kom-review-all-marked-texts kom-display-time)
  "*What to do when all texts are read.
This is a list of commands and lists of commands that are prompted for
and executed when there are no more new texts.  The last element in
the list is the one that will never be removed from the list.
A command can be one of:

type			prompt
------------------------------
lyskom-function		from the lyskom-command-name function
command			\"Command:\" (name of function or definition of
			lambda expression)
keyboard macro		\"Command:\" (keyboard macro definition)"
  server)

(def-kom-var kom-page-before-command nil
  "*This is a list of all commands before which the screen is cleared.
If it isn't a list and isn't nil the screen is cleared before all commands."
  server)

(def-kom-var kom-permissive-completion t
  "*If t, completion on logged-in persons will usually also include
persons who are not logged in. Values other than t or nil are reserved
for future use."
  server)

(def-kom-var kom-unsubscribe-makes-passive t
  "*If non-nil subtracting oneself from a conference makes the membership
passive. A second leave will actually remove the membership."
  server)

(def-kom-var kom-membership-default-priority 'ask
  "*Default priority when joining a new conference.
If a valid priority then new conferences are read with this priority. 
Otherwise ask the user for a priority.

Valid priorities are only the range 0-255."
  server)

(def-kom-var kom-membership-default-placement 'last
  "*Tells the system where to put new conferences.
The value can be one of the following:
'first => before all other conferences.
'last => after all other conferences.
a number => at that position
otherwise => the new conference is entered after all conferences."
  server)

(def-kom-var lyskom-current-prompt nil
  "The current prompt or nil.
This is either nil, indicating that there is currently no prompt, or
a symbol indicating which command is prompted in the LysKOM buffer."
  local)

(def-kom-var lyskom-current-prompt-text nil
  "The current prompt text or nil.
This is either nil, indicating that there is currently no prompt, or
a string indicating the prompt shown in the LysKOM buffer."
  local)

(def-kom-var lyskom-current-prompt-args nil
  "The current prompt arguments.
These are arguments used to format the current prompt."
  local)

(def-kom-var lyskom-current-prompt-timestamp nil
  "The creationtime of the current prompt.
This is used when updating the prompt and on lyskom-start-of-command."
  local)

(def-kom-var lyskom-need-prompt-update nil
  "Non-nil if all prompts need to be updated."
  local)

(def-kom-var kom-show-personal-messages-in-buffer t
  "*Buffer to show personal messages in.
If nil, discard them.
If t, insert them in the *kom* buffert.
If non-nil and non-t this should be a buffer or a name of a (possibly
nonexistent) buffer in which the message is inserted."
  server)

(def-kom-var kom-pop-personal-messages nil
  "*Non-nil means pop up a buffer with personal messages as they arrive.
kom-show-personal-messages-in-buffer decides which buffer to pop."
  server)

(def-kom-var kom-ding-pause-amount 0.1
  "*Amount of time to wait between successive beeps.")

(def-kom-var kom-ding-on-new-letter nil
  "*Non-nil means ding if a message arrives in the letter box. See 
kom-ding-on-priority-break for valid values."
  server)


(def-kom-var kom-ding-on-priority-break 1
  "*Non-nil means ding if a higher priority text or conference breaks in.
A number means the number of times to ding. A string is an argument for the
program named by kom-audio-player."
  server)

(def-kom-var kom-ding-on-wait-done 1
  "*Non-nil means ding when busy-waiting finishes.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as a 
function to call."
  server)

(def-kom-var kom-ding-on-common-messages 0
  "*Non-nil means ding as alarm messages arrive. 
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the sender identity. The corresponding VALUE is used as the
specification on how to beep."
  server)

(def-kom-var kom-ding-on-group-messages 1
  "*Non-nil means ding as group messages arrive.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the recipient identity. The corresponding VALUE is used as the
specification on how to beep."
  server)

(def-kom-var kom-ding-on-personal-messages 2
  "*Non-nil means ding as personal messages arrive.
A number means the number of times to ding. A string is an argument
for the program named by kom-audio-player. A symbol is interpreted as
a function to call. A list consisting of pairs (KEY . VALUE) is used
for fine-grained control. The list is searched for a pair where KEY
matches the sender identity. The corresponding VALUE is used as the
specification on how to beep."
  server)


(def-kom-var kom-ding-on-no-subject 2
  "*How to ding if the user has not entered a subject line.
A number means the number of times to ding. A string is an argument for the
program named by kom-audio-player. A symbol is interpreted as a function 
to call."
  server)


(def-kom-var kom-audio-player "audioplay"
  "*Program to play audio files."
  server)


(def-kom-var kom-ignore-message-senders nil
  "*List of senders whose personal, group and alarm messages are ignored."
  server)

(def-kom-var kom-ignore-message-recipients nil
  "*List of recipients you do not want group messages to."
  server)

(def-kom-var kom-show-personal-message-date t
  "*Show date on personal messages is non-nil."
  server)

(def-kom-var kom-default-message-recipient 'group
  "*Determines default recipient of personal messages.

'everybody means the default recipient is everybody.
'group     means the default recipient is the group to which the last
           message was sent, if it was a group message. If the last message
           was a personal message or a common message, it means the same as 
           'sender. 
'sender    means the sender of the last message received."
  server)


(def-kom-var kom-filter-outgoing-messages t
  "*t if outgoing remote-control messages and automatic replies are not
to be displayed in the buffer."
  server)


(def-kom-var kom-friends nil
  "*List of people whose names should be formatted using kom-friends-face.
Also used in kom-who-is-on-and-friend. This is a list of integers (person
numbers)."
  server)

(def-kom-var kom-morons nil
  "*List of people whose names should be formatted using kom-morons-face."
  server)

(def-kom-var kom-dont-check-commented-authors nil
  "*List of recipients who do not need to be added to comments that they
might not see. Typically this list consists of import agents."
  server
  inherited)

(def-kom-var kom-default-face-scheme nil  
  "*Face scheme to use per default for new logins.")

(def-kom-var kom-smileys t
  "*Non-nil means to reformat smileys in text."
  server)

(def-kom-var kom-text-properties t
  "*Non-nil means to insert text properties in the Emacs buffer for
various LysKOM elements.")

(def-kom-var kom-use-button-hints t
  "*Non-nil means use button hints for overriding default actions.")

(def-kom-var kom-autowrap t
  "*Non-nil means auto wrap articles with discretion.
A number means wrap articles shorter than the number (in bytes)."
  server)

(def-kom-var kom-keep-alive-interval 180
  "*The number of seconds between periodic requests used to keep the session alive"
  server)

(defvar lyskom-transforming-external-text nil
  "Dynamically bound to non-nil when transforming text in which text,
conference and person buttons are not expected.")

(def-kom-var lyskom-url-protocol-regexp
  "\\(file\\|ftp\\|gopher\\|http\\|https\\|news\\|wais\\|mailto\\|telnet\\):"
  "Regexp to match the protocol part of a URL.")

(def-kom-var lyskom-text-buttons
  '(
    ;; Text numbers
    ("\\(\\<[0-9][0-9][0-9][0-9]\\([0-9]\\)?\\([0-9]\\)?\\([0-9]\\)?\\>\\)" 
                                        ; Match
     text                               ; Button type
     0                                  ; Portion that's a button
     1                                  ; Portion that's the arg
     nil                                ; Face or nil (=default)
     )

    ;; Email

    ("\\(\\b\\|^\\)[^()<>@,;:\"\\\\\000- ]+@[^\000- <>;,.'\"!:?) \t\012\014]+\\(\\.[^\000- <>;,.'\"!:?)]+\\)+"
     email 0 0 kom-url-face)

    ;; URLs

    ("\\b\\(www\\|ftp\\|home\\)\\.[^\t \012\014\"<>|\\]*[^][\t \012\014\"<>|.,!(){}?'`:;]" 
     pseudo-url 0 nil kom-url-face)

    ("\\(file://\\|ftp://\\|gopher://\\|http://\\|https://\\|news:\\|wais://\\|mailto:\\|telnet:\\)[^\t \012\014\"<>|\\]*[^][\t \012\014\"<>|.,!(){}?'`:;]" 
     url 0 nil kom-url-face)
    ("<URL:\\s-*\\([^>]*\\)\\s-*>"
     url 1 1 kom-url-face)

    ;; JySKom enhancements

    ("<(?m[|]te[ \t\n]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     conf 0 1 nil)
    ("<(?text[ \t\n]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     text 0 1 nil)
    ("<(?person[ \t\n]*\\([0-9]+\\)\\([^0-9>]?\\|[^0-9>][^>]*\\))?>"
     pers 0 1 nil)

    ;; Info node reference

    ("\\*Note[ \n\t]+\\([^:\n]*\\(\n[^:\n]*\\)?\\):\\s-*\\(\\(([^\)]+)\\)?[^.,\t\n]*\\(\n[^.,\t\n]*\\)?\\)[.,\t]" 
     info-node 1 3 kom-url-face)

    )
  "List of buttons to install in the text mass of LysKOM objects. Each element is
a list consisting of REGEXP TYPE BUTTON-MATCH BUTTON-ARG-MATCH FACE.
REGEXP is the regexp to look for in the text.
TYPE is the button type. Valid button types are defined in lyskom-button-actions.
BUTTON-MATCH is the number of the parenthesized expression that is the actual button.
BUTTON-ARG-MATCH is the number of the expression to be used as the button argument.
FACE is the text face to apply to the button, or nil to use the default face.")

(def-kom-var kom-url-viewer-preferences '("emacs"
                                          "windows"
                                          "w3")

  "*LysKOM will attempt to use URL viewers in the order specified here.
kom-url-managers is a list of all available viewers. Note that the elements
are all strings.

When you select a URL, this list is used to determine which URL
viewer to use in the following manner: Each element is in turn matched
against the manager regexp for each manager in kom-url-managers, and the
first manager found that matches is used to display the URL.

See kom-url-managers for a list of all available URL viewers. See
kom-netscape-command and kom-mosaic-command for information specific 
to some URL viewers."
  server)


(def-kom-var kom-url-managers '(("default"
                            ".*"
                            "Browse-URL"
                            lyskom-view-url-browse-url)
                           ("w3" 
			    "\\(http\\|gopher\\|ftp\\)"
			    "Emacs W3" 
			    lyskom-view-url-w3)
                           ("windows"
                            ".*"
                            "web browser"
                            lyskom-view-url-windows)
			   ("netscape"
			    ".*"
			    "Netscape Navigator/Mozilla"
			    lyskom-view-url-netscape)
			   ("\\(emacs\\|dired\\)"
			    "\\(ftp\\|file\\)"
			    "dired"
			    lyskom-view-url-dired)
			   ("\\(emacs\\|telnet-mode\\)"
			    "telnet"
			    "emacs telnet"
			    lyskom-view-url-telnet)
			   ("\\(emacs\\|mail-mode\\)"
			    "mailto"
			    "mail-mode"
			    lyskom-view-url-mailmode)
			   ("mosaic"
			    "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
			    "NCSA Mosaic"
			    lyskom-view-url-mosaic)
			   ("lynx"
			    "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
			    "Lynx"
			    lyskom-view-url-lynx)
			   ("galeon"
			    "\\(http\\|gopher\\|ftp\\|mailto\\|news\\|wais\\|file\\|telnet\\)"
			    "Galeon"
			    lyskom-view-url-galeon))

  "List of URL managers. Each element is a list consisting of
(MANAGER-REGEXP PROTOCOLS NAME VIEW-FUNCTION). When LysKOM attempts to
view a URL, kom-url-viewer-preferences is scanned, and the URL
-manager whose MANAGER-REGEXP first matches an element in
kom-url-viewer-preferences and whose PROTOCOLS matches the protocol of
the selected URL is used to view the URL by calling its VIEW-FUNCTION
with the URL and the manager entry as arguments.")

(def-kom-var kom-windows-browser-command ""
  "*Program to run to open a URL in Windows. If it is the empty
string, a couple of commands that are likely the work on Windows will
be tried."
  server)

(def-kom-var kom-mosaic-command "/usr/local/bin/mosaic"
  "*Command to run to start Mosaic."
  server)

(def-kom-var kom-netscape-command "netscape"
  "*Command to run to start Netscape or Mozilla.

If a string, it should be a command that starts Netscape or Mozilla 
with no arguments. If a list, the first element must be a command 
that starts Netscape. The remaining elements are used as arguments 
to Netscape.

For instance, a value of \"netscape\" is valid, but \"netscape -d host:0\"
is not. Instead, the latter should be \(\"netscape\" \"-d\" \"host:0\"\)"
  server)

(def-kom-var kom-galeon-command "galeon"
  "*Command to run to start Galeon.

If a string, it should be a command that starts Galeon with no
arguments. If a list, the first element must be a command that starts
Galeon. The remaining elements are used as arguments to Galeon.

For instance, a value of \"galeon\" is valid, but \"galeon --display host:0\"
is not. Instead, the latter should be \(\"galeon\" \"--display\" \"host:0\"\)"
  server)

(def-kom-var kom-lynx-terminal 'xterm
  "*Where to start Lynx.
Valid values are 'xterm (start Lynx in an xterm) and 'terminal (start
Lynx in Emacs terminal mode).")

(def-kom-var kom-lynx-xterm-command
  '("xterm" "-geometry" "90x50+100+100" "-e" "lynx")
  "*Command to run to start Lynx in an xterm.
Must be a list of strings, where the first element is the name of the
xterm program, and the remaining elements are arguments to the
xterm. The last elements should be \"-e\" \"lynx\", or something similar,
to start Lynx.")

(def-kom-var kom-lynx-terminal-command "lynx"
  "*Command to run Lynx in Emacs terminal mode.

This can be either a string, to start Lynx with no arguments, or a
list of strings, where the first element is the command, and the rest
are arguments to Lynx.")

(def-kom-var kom-confirm-multiple-recipients 'after
  "*Non-nil means ask the user for confirmation about recipients.
When the user writes a comment to a text with more than one recipient
he gets a y-or-n-p question for all recipients. 'before means check
before opening the edit buffer. Anything else means check before
sending the article."
  server)

(def-kom-var kom-check-for-new-comments t
  "*Non-nil means check that no new comments have been written to a commented
texts since the last check. A list means check in all conferences except
those listed. A function means call the function and check if non-nil is
returned. The function is called with the commented text's text-stat as
an argument."
  server)

(def-kom-var kom-check-commented-author-membership t
  "*Non-nil means check that the authors of the commented texts are
members of at least one of the recipient conferences. If not, offer to
add them as recipients."
  server)

(def-kom-var kom-inhibit-typeahead nil
  "*If non-nil, discard keyboard input that arrives while a LysKOM command is
executing. "
  server)

(def-kom-var kom-max-buffer-size nil
  "*If non-nil, ensure that buffers won't grow any larger than this."
  server)

(def-kom-var kom-print-relative-dates t
  "*If non-nil, print today's and yesterday's date as \"today\" and
\"yesterday\" (respectively) in some places instead of the default,
numeric format."
  server)

(def-kom-var kom-print-seconds-in-time-strings nil
  "*If non-nil, include seconds, minutes and hours when printing
time in some places. If nil, only include minutes and hours."
  server)

(def-kom-var kom-show-namedays nil
  "*Non-nil means display namedays when running in Swedish.
This variable will eventually be replaced with something else."
  server)

(def-kom-var kom-ssh-relay-host nil
  "*Host to which the session is to be tunneled through ssh through.
For this to work, ssh to the host must succeed without asking for a
password or passphrase.

Note: Storing this variable in the LysKOM server makes no sense.")

(def-kom-var lyskom-ssh-proxy nil
  "When non-nil, the ssh proxy used for this buffer."
  local
  protected)

(def-kom-var kom-www-proxy nil
  "*Non-nil indicates a WWW proxy to use for the connection.
This is useful behind a firewall if the proxy supports the CONNECT
method. 

If this variable is a string, it is assumed to be a proxy
specification for all LysKOM servers. If it is a list, it is assumed
to be a list of pairs, (SERVER . PROXY), where SERVER is the server for
which PROXY specification is to be used. The special value t
can be used for SERVER to indicate a default proxy.

A proxy specification has the form \"HOST:PORT\" where HOST is the
host name of the proxy and PORT is the port to connect to. The :PORT
part is optional. If it is not specified, port 80 is assumed.")

(def-kom-var kom-www-proxy-headers
  "User-Agent: Mozilla/4.7C-CCK-MCD  [en] (X11; I; SunOS 5.6 sun4u)"
  "*Headers to send to the proxy when connecting to LysKOM through a WWW
proxy. The value of this variable should either be a single string, which
is sent verbatim to the proxy, or a list of strings which will be sent to
the proxy separated by CRLF, or a list of elements like (NAME H1 H2 ... Hn)
where NAME is the name of a proxy and the remaining elements are headers
to send when connecting through that proxy.

Do not use this variable for proxy authentication.")



(def-kom-var kom-server-aliases
  '(("kom.lysator.liu.se" . "LysKOM")
    ("com.lysator.liu.se" . "LysCOM (LysKOM in English)")
    ("kom.ludd.luth.se" . "LuddKOM")
    ("kom.hem.liu.se" . "RydKOM")
    ("kom.update.uu.se" . "UppKOM")
    ("kom.mds.mdh.se" . "MdS-KOM")
    ("kom.stacken.kth.se" . "TokKOM")
    ("com.helsinki.fi" . "HesaKOM")
    ("kom.cd.chalmers.se" . "CD-KOM")
    ("community.roxen.com" . "Roxen Community KOM")
    ("kom.ds.hj.se" . "DSKOM")
    ("kom.sno.pp.se" . "SnoppKOM"))
  "*An alist mapping server names to shorter identification strings")

(def-kom-var kom-ansaphone-on nil
  "t if automatic replies to personal messages are in effect."
  local)

(def-kom-var kom-silent-ansaphone nil
  "*Non-nil if messages should not cause beeps when the ansaphone is on."
  server)

(def-kom-var kom-ansaphone-record-messages t
  "*t if messages are recorded while the ansaphone is on."
  server)

(def-kom-var kom-ansaphone-show-messages t
  "*t if messages are to be shown when they are recorded."
  server)


(def-kom-var lyskom-ansaphone-messages nil
  "Messages collected by the automatic reply facility.
The most recent message is the first message in the list."
  local)

(def-kom-var lyskom-ansaphone-when-set (current-time-string)
  "Time when the auto-reply facility was enabled."
  local)

(def-kom-var kom-remote-control t
  "*t if LysKOM may be remotely controlled."
  server)

(def-kom-var kom-remote-controllers nil 
  "*Persons who may control LysKOM using messages. By default you can
always control your own sessions. See kom-self-control for more
information."
  server)

(def-kom-var kom-self-control t
  "*If non-nil, remote control commands are accepted from sessions logged
in as the same user as the current session."
  server)

(def-kom-var kom-ansaphone-replies
  '((group nil nil nil nil)
    (common nil nil nil nil))
  "*List of automatic replies to various messages.

A list of (MESSAGE-TYPE SENDER RECIPIENT TEXT REPLY)
    MESSAGE-TYPE is one of 'personal, 'group or 'common or nil
    SENDER is a list of integers or a single integer or nil
    RECIPIENT is a list of integers or a single integer or nil
    TEXT is a regular expression or nil
    REPLY is a string or nil

When an incoming message arrives and the auto-reply facility is on,
this list is checked for automatic replies. The message type, sender,
recipient and text of the incoming messages is matched against the 
elements of this list. If a match is found, the corresponding reply is
send. A nil in one of the message-type, sender, recipient or text
components in the list is taken to mean a wildcard. A null reply means
don't send a reply.

If none of the elements match, kom-ansaphone-default-reply is sent."
  server)

(def-kom-var kom-agree-text nil
  "*If non-nil, the default text to use when agreeing with a text.
This variable can be a string, function or list. If a string, the
string is used as the message. If a function, the function is called
and the return value is used. If a list, one of the elements is selected
at random and used. This element may be a string, function or list."
  server)

(def-kom-var kom-default-language nil
  "*Which language to use for messages in new sessions.
The value is a symbol whose name is the ISO 630 code for the desired
language (e.g. sv for Swedish and en for English). Not that the languages
available depend on how you have built the client.

All choices are listed in `lyskom-languages'"
  server 
  inherited
  protected)

(def-kom-var lyskom-language kom-default-language
  local
  inherited
  protected
  "The language currently in use for messages.")

(def-kom-var lyskom-global-language kom-default-language
  "The language for language-specific things that affect multiple sessions.")

(def-kom-var lyskom-edit-mode-map nil
  "Mode map for LysKOM edit."
  local)

(def-kom-var lyskom-edit-prefix nil
  "Mode map for LysKOM edit mode.")

(def-kom-var lyskom-customize-map nil
  "Keymap for the customize buffer"
  local)

(def-kom-var lyskom-command-alternatives nil
  "Possible command completions."
  local
  minibuffer)

(def-kom-var kom-trim-buffer-minimum 4096
  "*This number of bytes rounded to a whole line is the amount of text trimmed
each time ." 
  server)


;;; =================================================================
;;;
;;; Language-dependent variables
;;;

(def-kom-var lyskom-month-names nil
  "A list of month names.
Each element is a cons cell consisting of the name of the month
\(a symbol) and the number of the month (1-12). Each month may
appear more than once"
  local
  inherited
  language-force)

(def-kom-var lyskom-help-data nil
  "Help strings."
  local
  language-force)

(def-kom-var lyskom-onoff-table nil
  "A completion table for on and off selections."
  local
  language-force)

(def-kom-var lyskom-move-tree-actions nil
  "A completion table for actions in kom-move-text-tree"
  local
  language-force)

(def-kom-var lyskom-language-codes nil
  "A list of ISO 639 language codes"
  local
  language-force)

(def-kom-var lyskom-filter-predicate-list nil
      "A list of legal filter comparison predicates."
      local
      language-force)

(def-kom-var lyskom-filter-what nil
      "A list of legal filter conditions and their textual representation."
      local
      language-force)

(def-kom-var lyskom-filter-actions nil
      "A list of legal filter actions an their textual representation."
      local
      language-force)

(def-kom-var lyskom-filter-edit-map nil
  "Keymap for LysKOM filter edit."
  local)

(def-kom-var lyskom-prioritize-mode-map nil
  "Keymap used in lyskom-prioritize-mode."
  local)

(def-kom-var lyskom-prioritize-header-lines nil
  "Number of lines in the header of the prioritization buffer."
  local
  language-force)

(def-kom-var lyskom-prioritize-header nil
  "Header for the reprioritization buffer."
  inherited
  language-force)

(def-kom-var kom-ansaphone-default-reply nil
  "*Default message to send when the ansaphone is on."
  server)

(def-kom-var kom-ispell-dictionary nil
  "*Dictionary to use for spell checking."
  server
  inherited)

(def-kom-var lyskom-unread-mode-line nil
  "This variable will become part of mode-line-format"
  language-force)

(def-kom-var lyskom-unread-title-format nil
  "This variable will become part of frame-title-format"
  language-force)

(def-kom-var lyskom-button-actions
  '((text
     text-popup-title
     lyskom-button-view-text
     ((lyskom-button-view-text-action . lyskom-button-view-text)
      (lyskom-button-copy-text-no-action . lyskom-button-copy-text-no)
      (lyskom-button-review-noconversion-action . lyskom-button-review-noconversion)
      (lyskom-button-find-root-review-action . lyskom-button-find-root-review)
      (lyskom-button-find-root-action . lyskom-button-find-root)
      (lyskom-button-review-comments-action . lyskom-button-review-comments)
      (lyskom-button-review-tree-action . lyskom-button-review-tree)
      (lyskom-button-comment-text-action . lyskom-button-comment-text)
      (lyskom-button-private-comment-text-action . lyskom-button-private-comment-text)
      (lyskom-button-write-footnote-action . lyskom-button-write-footnote)
      (lyskom-button-fast-reply-action . lyskom-button-fast-reply)
      (lyskom-button-mark-text-action . lyskom-button-mark-text)
      (lyskom-button-unmark-text-action . lyskom-button-unmark-text)
      (lyskom-button-save-text-action . lyskom-button-save-text)
      (lyskom-button-save-text-body-action . lyskom-button-save-text-body)
      )
     nil
     ;; ((nil lyskom-print-text footer lyskom-button-comment-text))
     )
    (conf 
     conf-popup-title
     lyskom-button-view-conf-presentation
     ((lyskom-button-view-conf-presentation-action . lyskom-button-view-conf-presentation)
      (lyskom-button-view-conf-status-action . lyskom-button-view-conf-status)
      (lyskom-button-goto-conf-action . lyskom-button-goto-conf)
      (lyskom-button-send-message-action . lyskom-button-send-message)
      (lyskom-button-add-self-action . lyskom-button-add-self)
      (lyskom-button-sub-self-action . lyskom-button-sub-self))
     ((kom-list-news . lyskom-button-goto-conf)
      (kom-membership . lyskom-button-goto-conf)))
    (pers 
     pers-popup-title
     lyskom-button-view-pers-presentation
     ((lyskom-button-view-pers-presentation-action . lyskom-button-view-pers-presentation)
      (lyskom-button-view-pers-status-action . lyskom-button-view-pers-status)
      (lyskom-button-view-session-status-action . lyskom-button-view-session-status)
      (lyskom-button-mail-action . lyskom-button-mail)
      (lyskom-button-send-message-action . lyskom-button-send-message))
     ((kom-list-news . lyskom-button-goto-conf)
      (kom-membership . lyskom-button-goto-conf)))
    (url 
     url-popup-title
     lyskom-button-open-url
     ((lyskom-button-open-url-action . lyskom-button-open-url)
      (lyskom-button-copy-url-action . lyskom-button-copy-url))
     nil)
    (info-node 
     generic-popup-title
     lyskom-button-goto-info-node
     ((lyskom-button-goto-info-node-action . lyskom-button-goto-info-node))
     nil)
    (email
     generic-popup-title
     lyskom-button-open-email
     ((lyskom-button-open-email-action . lyskom-button-open-email)
      (lyskom-button-copy-email-action . lyskom-button-copy-email))
     nil)
    (aux
     aux-popup-title
     lyskom-button-info-aux
     ((lyskom-button-info-aux-action . lyskom-button-info-aux)
      (lyskom-button-delete-aux-action . lyskom-button-delete-aux))
     nil)
    (aux-edit-menu
     nil
     aux-edit-menu-text
     ((lyskom-edit-toggle-secret-aux-action . lyskom-edit-toggle-secret-aux)
      (lyskom-edit-toggle-anonymous-aux-action . lyskom-edit-toggle-anonymous-aux)
      (lyskom-edit-toggle-inherit-aux-action . lyskom-edit-toggle-inherit-aux)
      (lyskom-edit-delete-aux-action . lyskom-edit-delete-aux))
     nil)
    (prioritize-flag-menu
     nil
     lyskom-prioritize-flag-toggle
     ((lyskom-prioritize-flag-toggle-action . lyskom-prioritize-flag-toggle)
      (lyskom-prioritize-flag-set-action . lyskom-prioritize-flag-set)
      (lyskom-prioritize-flag-clear-action . lyskom-prioritize-flag-clear))
     nil)
    (func
     nil
     lyskom-button-apply
     nil
     nil)
    (timestamp
     timestamp-popup-title
     (lambda (buffer argument text) nil)
     ((lyskom-button-copy-timestamp-action . lyskom-button-copy-timestamp))
     nil)
    (recpt-type
     recpt-type-popup-title
     (lambda (buffer argument text) nil)
     ((lyskom-button-recpt-type-recipient
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-copy
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'CC-RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-bcc
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-do-add-recipient/copy
	    'BCC-RECPT (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))
      (lyskom-button-recpt-type-sub
       . (lambda (buffer recpt-and-buffer text)
	   (lyskom-edit-sub-recipient/copy
	    (car recpt-and-buffer)
	    (car (cdr recpt-and-buffer)))))))
    (add-recipient-or-xref
     add-recipient-or-xref
     (lambda (buffer argument text) nil)
     ((lyskom-button-recpt-add-recipient
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-recipient)))
      (lyskom-button-recpt-add-copy
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-copy)))
      (lyskom-button-recpt-add-bcc
       . (lambda (buffer buffer text)
           (set-buffer buffer)
	   (kom-edit-add-bcc)))
      (lyskom-button-aux-type-xref
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-cross-reference))))
      (lyskom-button-aux-type-no-comments
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-no-comments))))
      (lyskom-button-aux-type-personal-comments
       . (lambda (buffer recpt-and-buffer text)
           (save-excursion
             (set-buffer recpt-and-buffer)
             (kom-edit-add-personal-comments))))))
    )
  "This variable defines valid button types in LysKOM. Each element is a
list consisting of (TYPE LABEL DEFAULT ACTIONS HINTS).
TYPE is the button type the entry defines
LABEL is a textual representation for the button type, used in menu titles. If
      it is a symbol, that symbol will be looked up using lyskom-get-string.
DEFAULT is the default action to take on a click. It must be a function.
ACTIONS are other possible actions. The format of this entry is described 
        below.
HINTS is a list of hints to override the default action. This is described 
      below.

The ACTIONS entry is used to construct a pop-up menu. It is a list consisting 
of lists with the format (STRING . FUNCTION). STRING is the menu label and
FUNCTION is the function to call when the menu item is selected.

The HINTS entry is used to generate hints that the default action should be 
overridden. It is a list containing elements (COMMAND . HINT) where COMMAND is
as interactive LysKOM command and HINT is a function to call. When a button
is generated while the command COMMAND is being executed, HINT is used as a 
hint for a new default action. The user has the option to ignore or used the 
hint.

Also see the function \"lyskom-add-button-action\"."
  local
  inherited)

(def-kom-var kom-show-imported-envelope-sender t
  "*If non-nil, show the envelope sender of texts imported by komimportmail."
  server)

(def-kom-var kom-show-imported-importer t
  "*If non-nil, show the name of the importer of an imported text."
  server)

(def-kom-var kom-show-imported-external-recipients t
  "*If non-nil, show the external recipients to an imported text."
  server)

(def-kom-var kom-complete-numbers-before-names t
  "*If non-nil, reading conference and user names accepts the special 
forms ``m 4711'' or ``p 42'' as numeric references to conference 4711
and person 42 instead of trying to look for an object with a matching
name. If nil, any name matching the input will be preferred to a
numeric reference."
  server)


(def-kom-var kom-mercial nil
  "*When the user has seen all texts and has reached the view-time prompt,
this string is used as the argument to lyskom-tell-server.
Users are encouraged to use their best sense of humor."
  server)


(defconst lyskom-commands
  '(
    kom-help
    kom-slow-mode
    kom-quick-mode
    kom-send-message
    kom-create-conf
    kom-delete-conf
    kom-delete-text
    kom-display-time
    kom-go-to-conf
    kom-go-to-next-conf
    kom-jump
    kom-list-created-conferences
    kom-list-conferences 
    kom-list-persons
    kom-list-news
    kom-list-re
    kom-membership
    kom-list-marks
    kom-postpone
    kom-set-session-priority
    kom-prioritize
    kom-status-person
    kom-status-conf
    kom-add-self
    kom-change-priority
    kom-list-summary
    kom-sub-self
    kom-quit
    kom-recover 
    kom-start-anew
    kom-view
    kom-find-root-review
    kom-review-comments
    kom-review-tree
    kom-review-clear
    kom-review-last-normally-read
    kom-review-noconversion
    kom-review-next
    kom-find-root
    kom-review-by-to
    kom-review-more
    kom-review-first
    kom-review-all
    kom-view-commented-text
    kom-view-previous-commented-text
    kom-review-stack
    kom-review-presentation
    kom-review-backward
    kom-view-next-text
    kom-who-is-on
    kom-who-is-on-in-conference
    kom-who-is-on-and-friend
    kom-who-am-i
    ;;   kom-display-who-buffer
    kom-list-clients
    kom-busy-wait
    kom-write-comment
    kom-comment-previous
    kom-write-footnote
    kom-private-answer
    kom-private-answer-previous
    kom-set-unread
    kom-write-text
    kom-send-letter
    kom-change-name
    kom-change-parenthesis
    kom-change-password
    kom-change-supervisor
    kom-change-presentation
    kom-get-appreciation
    kom-get-abuse
    kom-mark-text
    kom-unmark-text
    kom-review-marked-texts
    kom-review-all-marked-texts
    kom-add-recipient
    kom-add-copy
    kom-add-bcc
    kom-sub-recipient
    kom-move-text
    kom-move-text-tree
    kom-add-comment
    kom-sub-comment
    kom-add-cross-reference
    kom-add-member
    kom-sub-member
    kom-change-conf-motd
    kom-set-garb-nice
    kom-set-super-conf
    kom-set-permitted-submitters
    kom-unset-conf-motd
    kom-save-text
    kom-save-text-body
    kom-save-options
    kom-shutdown-server
    kom-sync-database
    kom-enable-adm-caps
    kom-disable-adm-caps
    kom-set-motd
    kom-remove-motd
    kom-force-logout
    kom-filter-author
    kom-filter-subject
    kom-filter-text
    kom-filter-recipient
    kom-super-jump
    kom-filter-edit
    kom-list-filters
    kom-show-user-area
    kom-change-conf-type

    kom-change-auto-reply
    kom-toggle-auto-reply
    kom-list-messages
    kom-erase-messages

    kom-remote-autoreply
    kom-remote-set-message
    kom-remote-list-messages
    kom-remote-erase-messages
    kom-remote-quit

    kom-status-session
    kom-customize
    kom-change-language
    kom-calculate

    kom-where-is

    kom-next-kom
    kom-previous-kom
    kom-next-unread-kom

    kom-send-alarm
    kom-agree
    kom-fast-reply
    kom-add-faq
    kom-del-faq
    kom-review-faq

    kom-add-footnote
    kom-sub-footnote

    kom-add-private-answer
    kom-add-no-comments
    kom-add-request-confirm

    kom-review-mail-headers

    kom-compare-texts
    kom-diff-texts

    kom-become-anonymous
    kom-become-nonanonymous

    kom-keep-alive
    kom-stop-keep-alive

    kom-who-is-present-in-conference
    kom-is-person-member-of-conference
    kom-change-conf-faq

    kom-make-review-mark-as-read
    kom-make-review-not-mark-as-read
    kom-set-presentation
    kom-set-motd-text
    kom-remove-presentation
    kom-create-aux-item
    kom-status-server
    kom-add-server-faq
    kom-del-server-faq
    kom-change-server-faq
    kom-review-server-faq
    kom-recommend-conference
    kom-redirect-comments
    ))

;;; ================================================================
;;;                  Internal variables and constants


(defconst lyskom-clientversion "0.47"
  "Version of the LysKOM elisp client.")

(defvar lyskom-max-int 8388607
  "The largest int Emacs, and thus this LysKOM client, can handle.")

(defconst lyskom-server-features
  '((10 lyskom-bcc-flag
        lyskom-extended-types-flag)
    (9  lyskom-accept-async-flag
        lyskom-dynamic-session-info-flag
        lyskom-idle-time-flag)
    (8  lyskom-long-conf-types-flag 
        lyskom-set-last-read-flag 
        lyskom-uconf-stats-flag
        lyskom-set-last-read-flag)
    (7  lyskom-z-lookup-flag))
  "List describing which features a certain server has. Each
element is a list containing the protocol version and what
it supports. The format of each element is:

\(VERSION . SUPPORTS\)

Version is simply a protocol version. Protocol equal to or above the
version support the supports list.

SUPPORTS is a list of pairs and symbols. Cons pairs are treated as
arguments to setq, symbols are interpreted as variable names set
 to 't'.")

;;;(defconst lyskom-server-features
;;;  '(((>= 2 0 0) (lyskom-bcc-flag
;;;                 lyskom-aux-items-flag))
;;;    ((>= 1 9 0) (lyskom-accept-async-flag
;;;                 lyskom-dynamic-session-info-flag
;;;                 lyskom-idle-time-flag))
;;;    ((>= 1 8 0) (lyskom-long-conf-types-flag 
;;;                 lyskom-set-last-read-flag
;;;                 lyskom-uconf-stats-flag))
;;;    ((>= 1 7 0) (lyskom-z-lookup-flag))
;;;    ((= 2 0 0) ((protocol-version 10)))
;;;    ((= 1 9 0) ((protocol-version 9)))
;;;    ((= 1 8 0) ((protocol-version 8)))
;;;    ((= 1 7 0) ((protocol-version 7)))
;;;    ((= 1 7 1) ((protocol-version 7)))
;;;    ((< 1 7 0) ((protocol-version 6))))
;;;  "List describing which features a certain server version has.
;;;Each element is a list containing the server version and what it
;;;supports:
;;;")


(def-kom-var lyskom-server-version '(0 0 0)
  "The version of the server.  A list of three integers: major
version, minor version and revision."
  local)

(def-kom-var lyskom-server-coding-system 'iso-8859-1
  "The default coding system used by the server for all strings."
  inherited)

(def-kom-var lyskom-max-packet-size lyskom-max-int
  "The largest possible packet size that can be transmitted to a
TCP/IP connection. This should be unlimited, but in practise there
are systems that limits this. This variable is automatically adjusted
if any problems are detected.")

(def-kom-var lyskom-pending-commands nil
  "Commands pending to be executed.
When a command finishes, it checks this variable to see if another command
should be run.

It should be a list where each element should be either a symbol or an
expression. If it is a symbol, it is invoked with `call-interactively', and
an expression is evaluated with `eval'."
  local)

(def-kom-var lyskom-do-when-done nil
  "Internal of kom-do-when-done."
  local)

(def-kom-var lyskom-do-when-starting nil
  "Internal of kom-do-when-starting. Obsolete.")

(def-kom-var lyskom-sessions-with-unread nil
  "List of LysKOM sessions with unread texts.
This is not buffer-local.")

(def-kom-var lyskom-sessions-with-unread-letters nil
  "List of LysKOM sessions with unread letters.
This is not buffer-local.")

(def-kom-var lyskom-session-has-unread-letters nil
  "Non-nil if this session has unread letters."
  local
  protected
  inherited)

(def-kom-var lyskom-session-has-unreads nil
  "Non-nil if this session has unread texts."
  local
  protected
  inherited)

(def-kom-var lyskom-buffer nil
  "The LysKOM buffer we are connected to."
  inherited
  minibuffer)

(def-kom-var lyskom-buffer-type nil
  "Type of the current buffer."
  local
  protected)

(def-kom-var output nil
  "Uaark. Just to omit a warning...")

(def-kom-var lyskom-errno nil
  "Errno of last lyskom error."
  local)

(def-kom-var lyskom-err-stat nil
  "Err-stat of last lyskom error."
  local)

(def-kom-var lyskom-parser-recovering nil
  "Non-nil if the parser is recovering from an error."
  local)

(def-kom-var lyskom-parse-pos nil
  "Position of parsing.")

(def-kom-var lyskom-unparsed-buffer nil
  "Buffer containing unparsed information from the server."
  local)

(def-kom-var lyskom-unparsed-marker nil
  "Where we now are inserting."
  local)

(def-kom-var lyskom-to-be-printed-before-prompt nil
  "Contains the strings to be printed before the next prompt."
  local)

(def-kom-var lyskom-other-clients-user-areas nil
  "Contains the parts of the user areas of unknown clients.
The area is a pair: name . info (both strings)."
  local)

(def-kom-var lyskom-pending-calls nil
  "Assoc list of calls to LysKOM server that have not yet completed.
Each element on the list has the format

	(REF-NO . KOM-QUEUE)
REF-NO	   unique number assigned by lyskom-send-packet.
KOM-QUEUE is a kom-queue. (See lyskom-call-data.)"
  local)

(def-kom-var lyskom-output-queues nil
  "Pending output to the server.
This is a vector of ten elements, each of which is a kom-queue. Calls from
queues with a higher index (priority) are always sent first.

At most lyskom-max-pending-calls calls are sent at once."
  local)

(def-kom-var lyskom-max-pending-calls 20
  "*Max number of calls that are transmitted to the server at once.
Extra calls are queued in lyskom-output-queue and sent when the replies
returns.

This variable is not saved in the LysKOM server.")

(def-kom-var lyskom-number-of-pending-calls 0
  "Number of pending calls that are transmitted to the server."
  local)

;; This variable is used to prevent "starvation" of the blocking-do call.
;; When there is heavy prefetch going on in the background and a
;; blocking-do call is made there is a good chance that the
;; accept-process-output call will not return within a reasonable
;; time, because there will always be data to read from the server,
;; which means that Emacs will call lyskom-filter instead of returning
;; from accept-process-output.
(defvar lyskom-ok-to-send-new-calls t
  "This variable controls whether calls are passed to the server.
If it is nil, all outgoing calls are inhibited.")

(def-kom-var lyskom-ref-no 0
  "Next ref-no to use. These ref-nos are used to keep track of the
different packets.")

(def-kom-var lyskom-pers-no 0
  "The pers-no of the current user."
  inherited)

(def-kom-var lyskom-session-no 0
  "Session number in the server for this connection."
  local)

(def-kom-var kom-default-session-priority 1
  "*The default session priority.
Only texts in conferences with a priority equal to or higher than this
will be shown by default.

To set the session priority in a running session, set the variable
lyskom-session-priority instead. The value of this variable is used
to initialize lyskom-session-priority when a new session is started."
  local
  server)

(def-kom-var kom-server-priority -1
  "*The default server priority.
When kom-server-priority-breaks is set, this priority is used to decide
when to go to a prioritized session. For a session to be prioritized its
priority must be higher than the current session's kom-server-priority 
and higher than the priority of whatever is currently being read."
  server)


(def-kom-var lyskom-session-priority 0
  "*This sessions priority.
Only texts in conferences with a priority equal to or higher than this
will be shown."
  local)

(def-kom-var lyskom-proc nil
  "The process (network connection) that is associated with this buffer."
  inherited
  minibuffer)

(def-kom-var lyskom-server-info nil
  "Info about the server."
  local)

(def-kom-var lyskom-server-version-info nil
  "Version information about the client."
  local)

(def-kom-var lyskom-server-name ""
  "The name of the server."
  inherited)

(def-kom-var lyskom-server-port nil
  "The port we are connected to."
  local)

(def-kom-var lyskom-buffer-list nil
  "List of all LysKOM buffers.")

(def-kom-var lyskom-static-session-info-cache nil
  "Cache of session."
  local)

(def-kom-var lyskom-conf-cache nil
  "Cache of conference statuses."
  local)

(def-kom-var lyskom-uconf-cache nil
  "Cache of small conference statuses."
  local)

(def-kom-var lyskom-pers-cache nil
  "Cache of person statuses."
  local)

(def-kom-var lyskom-text-cache nil
  "Cache of text statuses."
  local)

(def-kom-var lyskom-text-mass-cache nil
  "Cache of texts."
  local)

(def-kom-var lyskom-marked-text-cache nil
  "Cache of marks of all texts the current user has marked. "
  local)

(def-kom-var lyskom-who-info-cache nil
  "Cache of people presently logged in in LysKOM."
  local)

(def-kom-var lyskom-who-info-buffer nil
  "Buffer for the who info presentation."
  local)

(def-kom-var lyskom-who-info-buffer-is-on nil
  "Says whether we are collecting who-information or not."
  local)


(def-kom-var lyskom-is-parsing t
  "True when parsing a result.
This is used to prevent parallel parsing since the parser is not reentrant."
  local)

(def-kom-var lyskom-string-bytes-missing 0
  "Number of bytes missing in the unparsed buffer when parsing a string.
Set when parsing a string and there were not enough bytes in the buffer
with the unparsed bytes. This variable is used to prevent reparsing before 
the string is complete.
This variable is buffer-local in the unparsed-buffer."
  local
  inherited)

(def-kom-var lyskom-last-viewed 0       ;
  "Position of the first char of the last line that the user has had
time to view. This is normally the pos of the first char of the prompt."
  local)

(def-kom-var lyskom-mode-map nil
  "Keymap used in LysKOM mode."
  local)


(def-kom-var lyskom-reading-list nil
  "List of articles to read in the current conference.
Each element is a read-info. Only one of the elements is of the type CONF.
This one is located last in the list (except for the elements of the type 
REVIEW, REVIEW-TREE or REVIEW-MARK).
When reading an article with comments a list of the comments is built
recursively if the flag kom-read-depth-first is non-nil.
This is to keep track of the reading order.
Articles can exist in several of the read-info elements. All unread articles
in the conference are always present in the CONF type entry in this list even
if also in other entries. (COMM-IN, FOOTN-IN)

Some powerful reviewing commands requires to construct a list of articles that
should be read. These use the type REVIEW. When reviewing trees and when
every viewed article is supposed to be followed by all its comments then the
type REVIEW-TREE is used.

The first element is a dummy."
  local)

(def-kom-var lyskom-to-do-list nil
  "List of conferences with unread texts.
Each element is a read-info. All have the type 'CONF and there is one for
every conference with unread articles that have already been prefetched.
The list is sorted in falling priority. 
When going to a conference the first element (the one with the highest
priority) is copied from this list to lyskom-reading-list.

The first element is a dummy."
  local)

(def-kom-var lyskom-quit-flag nil
  "A flag indicating if the filter was interrupted by C-g.
 It is set to the same value as quit-flag on filter exit.")

(def-kom-var lyskom-ignoring-async-list nil
  "A list of async messages we are currently ignoring.
Each element is a list. The car of the list is the message and the
remaining elements are whatever is suitable for that type of message.
See the checks in lyskom-parse-async for details."
  local)

(def-kom-var lyskom-inhibit-minibuffer-messages nil
  "A flag indicating whether asynchronous minibuffer messages are allowed.
If this variable is non-nil, no asynchronous messages will appear.")

(def-kom-var lyskom-is-saving nil
  "A flag indicating whether the server is saving at the moment.")

;;; These variables control prefetch of conf-stats, text-stats and texts:

(def-kom-var lyskom-prefetch-conf-tresh 50
  "If fewer than lyskom-prefetch-conf-tresh texts are known, ask for more
conf-stats from server.

This is currently not used."
  local)

(def-kom-var lyskom-prefetch-confs 10
  "Number of confs to ask about at once when checking for unread texts.

This is currently not used."
  local)

(def-kom-var lyskom-fetch-map-nos 50
  "Number of text-nos lyskom will fetch when fetching maps."
  local)

(def-kom-var lyskom-fetch-membership-length 6
  "*Number of entries in the membership-list that is fetched at a time.
This should be optimized depending on how often you read LysKOM and
the activity in the first groups in you membership list.

Best performance is achieved if you, when logging in, always have an unread
article in one of the first lyskom-fetch-membership-length conferences.")

(def-kom-var lyskom-prefetch-limit 10
  "Number of prefetch requests the client will try to keep going
at a time.")


;;;

(def-kom-var lyskom-membership nil
  "Sorted membership list of the logged in person."
  local)

(def-kom-var lyskom-unread-confs nil
  "List containing all unread confs."
  local)

(def-kom-var lyskom-dont-change-prompt nil
  "Non-nil during the entry of a text."
  local)

(def-kom-var lyskom-command-to-do 'unknown
  "Atom describing what command to do. See the function lyskom-what-to-do."
  local)

(def-kom-var lyskom-is-waiting nil
  "If non-nil, this is the condition for the waiting to be stopped.
If t, however, it means that the user is waiting for a text with a prompt.
It is a form that will be evaluated (using eval) every time the asynchronous
message \"new text\" is received.

This is used by the command kom-busy-wait."
  local)

(def-kom-var lyskom-current-conf 0
  "Current conference. 0 means user is not reading any conf."
  local)

(def-kom-var lyskom-current-text nil
  "Text-no of current text. nil means no text is current."
  local)

(def-kom-var lyskom-last-written nil
  "Text-no of last text written. nil means no text written."
  local)

(def-kom-var lyskom-last-seen-written nil
  "Text-no of last text read or written by the current user.
When a new text is written, this is set to the text number of that text.
When a text is read that was written by the current user, this is
set to that text."
  local)

(def-kom-var lyskom-previous-text nil
  "Text-no of previous text. Nil means no text."
  local)

(def-kom-var lyskom-normally-read-texts nil
  "Stack of texts that are read normally. Used for kom-review-last-normally-read."
  local)

(def-kom-var lyskom-current-subject ""
  "Current subject."
  local)

(def-kom-var lyskom-last-added-rcpt 0
  "The default conference when adding a recipient or moving a text."
  local)

(def-kom-var lyskom-last-added-ccrcpt 0
  "The default conference when adding a ccrecipient."
  local)

(def-kom-var lyskom-last-added-bccrcpt 0
  "The default conference when adding a bccrecipient."
  local)

(def-kom-var lyskom-last-sub-rcpt 0
  "The default conference when removing a recipient."
  local)

(def-kom-var kom-saved-file-name (concat default-directory "kom-text")
  "*The default file name when saving a LysKOM text."
  server)

(def-kom-var lyskom-saved-file-name nil
  "After saving once, the default file name when saving a LysKOM text."
  local)

(def-kom-var lyskom-mode-hook nil
  "*Hook to run when lyskom-mode is entered.")

(def-kom-var kom-quit-hook nil
  "*Hook to run when the LysKOM session is correctly ended."
  server-hook)

(def-kom-var kom-quit-when-idle t
  "Non-nil to automatically quit when LysKOM is full and the session is idle")

(def-kom-var kom-permanent-filter-list nil
  "List of patterns to filter permanently."
  server)

(def-kom-var kom-session-filter-list nil
  "List of patterns to filter during this session."
  local)

(def-kom-var lyskom-text-no-prompts-defaults
  '(kom-delete-text
    kom-view
    kom-write-footnote
    kom-mark-text
    kom-unmark-text
    kom-add-recipient
    kom-add-copy
    kom-add-bcc
    kom-sub-recipient
    kom-move-text
    kom-move-text-tree
    kom-add-comment
    kom-sub-comment
    kom-add-cross-reference
    kom-save-text-body
    kom-add-footnote
    kom-sub-footnote
    kom-add-faq
    kom-add-no-comments
    kom-add-private-answer
    kom-add-request-confirm
    kom-add-server-faq
    )
  "Commands that prompt for a text number rather than assume a default."
  inherited)

(def-kom-var kom-text-no-prompts nil
  "*Configure which commands ask for text numbers.
A list containing pairs of (COMMAND . VALUE). If VALUE is non-nil, COMMAND
will prompt for text numbers. If VALUE is nil, COMMAND will use a suitable
default value."
  server
  inherited)


(def-kom-var lyskom-filter-list nil
  "List of patterns that are filtered."
  local)

(def-kom-var kom-create-text-hook nil
  "*Hook to run before creating a new text.
This hook is run just before the server call to create the text is made.

The hook is currently called with the following arguments:
MESSAGE         The message text
MISC-LIST       The misc-info list
AUX-LIST        The aux-item list
BUFFER          The edit buffer
IS-ANONYMOUS    Non-nil if the user is currently anonymous.
&rest RESERVED  Additional arguments may be added in the future.

The hook can change the message by modifying the variable
full-message, the misc-info list by modifying misc-list and the
aux-item list by modifying aux-list. This is not encouraged."
  local-hook)

(def-kom-var lyskom-create-text-hook nil
  "*Obsolete synonym for kom-create-text-hook"
  local-hook)


(def-kom-var kom-new-text-hook nil
  "*Hook to run when a new text is created.
This hook is run after the prompt is removed if it shall be changed but before
the text \"Text 4711 r skapad!\" is printed in the message area. And before the
new prompt is printed."
  local-hook)

(def-kom-var lyskom-new-text-hook nil
  "*Obsolete synonym for kom-new-text-hook"
  local-hook)

(def-kom-var kom-deleted-text-hook nil
  "*Hook to run when a text is deleted.
This hook is run after the prompt is removed if it shall be changed but 
before the new prompt is printed."
  local-hook)

(def-kom-var lyskom-deleted-text-hook nil
  "*Obsolete synonym for kom-deleted-text-hook."
  local-hook)

(def-kom-var kom-new-recipient-hook nil
  "*Hook to run when a text receives a new recipient.
This hook is run after the prompt is removed if it shall be changed but before
the new prompt is printed. It is not run if the text has been marked as read
in any conference other than the person's letterbox."
  local-hook)

(def-kom-var lyskom-new-recipient-hook nil
  "*Obsolete synonym for kom-new-recipient-hook."
  local-hook)

;;(def-kom-var lyskom-who-info-has-changed-hook nil
;;  "Hook to run every time the who-info-buffer has changed.
;;The hook is run with current-buffer the lyskom buffer, not the 
;;who-info-buffer."
;;  server)

(def-kom-var kom-personal-message-hook nil
  "*Hook to run when a personal message is received.
When the hook is run, 'sender' is bound to the conf-stat of the sender
of the message (or possibly nil), 'recipient' is 0 if the message is a
public message and otherwise the conf-stat of the recipient, and
'message' is a string that holds the message."
  local-hook)

(def-kom-var lyskom-personal-message-hook nil
  "*Obsolete synonym for kom-personal-message-hook."
  local-hook)


(def-kom-var lyskom-executing-command t
  "Non-nil means the client is executing a command.
Most commands can't be interrupted by another command."
  local)

(def-kom-var lyskom-current-command nil
  "The command currently being executed."
  local)

(def-kom-var lyskom-current-function nil
  "Sometimes set to the current high-level function being executed."
  local)

(def-kom-var lyskom-current-function-phase nil
  "Sometimes set to the phase of the current high-level function being
executed."
  local)

(def-kom-var kom-low-priority -1
  "*Priority that the current conference is set to when
aborted. nil means don't alter priority. (This means that
kom-go-to-next-conf might go to the same conference again.)")

(def-kom-var lyskom-membership-is-read nil
  "t when the membership has been read."
  local)

(def-kom-var lyskom-is-writing nil
  "t when the user is writing a text."
  local)

(def-kom-var lyskom-debug-communications-to-buffer nil
  "Non-nil means all communications with the server is stored in a buffer.
The name is stored in lyskom-debug-communications-to-buffer-buffer.")

(def-kom-var lyskom-debug-communications-limit 60000
  "When set to an integer limits the communications log to that many
bytes. When set to a non-integer, the communications log is unlimited.
If a protocol error is detected, this limit will be reset to nil.

See lyskom-debug-communications-to-buffer")

(def-kom-var lyskom-backtrace-list nil
  "List containing debugging information.")
  
(def-kom-var lyskom-debug-what-i-am-doing t
  "Non-nil means asynchronous message 5 will be logged to the debug
  buffer. ")

(def-kom-var lyskom-is-anonymous nil
  "Non-nil means be a bit secretive about things. Not totally
  secretive of course, since the server doesn't allow that yet."
  local)

(def-kom-var lyskom-debug-communications-to-buffer-buffer "*kom*-debugs"
  "Name of the buffer to insert the communications with the server into if
lyskom-debug-communications-to-buffer is non-nil.")

(def-kom-var lyskom-doing-default-command nil
  "Non-nil if LysKOM is executing the default command."
  local)

(def-kom-var lyskom-first-time-around nil
  "Non-nil if LysKOM is being entered for the first time."
  local)

(def-kom-var lyskom-experimental-features nil
  "If non-nil, LysKOM is likely to blow up in your face."
  local)

(def-kom-var lyskom-format-experimental nil
  "If non-nil, LysKOM is likely to make a fool out of you."
  local)

(def-kom-var lyskom-count-var 0
  "This variable is used for counting things in the client, such as
unread texts in list-unread."
  local)

(def-kom-var lyskom-default-conf-string nil
  "The default string to use for an unknown conference.
Set this locally when inserting a conference name using
lyskom-format-insert if you want to replace the usual description of
an unknown conference.")

(def-kom-var lyskom-default-pers-string nil
  "The default string to use for an unknown person.
Set this locally when inserting a conference name using
lyskom-format-insert if you want to replace the usual description of
an unknown person.")


(def-kom-var lyskom-is-administrator nil
  "This variable is t if the user is in administrator mode and nil otherwise."
  local
  minibuffer)

(def-kom-var lyskom-last-personal-message-sender ""
  "Name of sender of last personal message received."
  local)

(def-kom-var lyskom-last-group-message-recipient ""
  "Name of target for last group message received."
  local)

(def-kom-var lyskom-last-message-recipient nil
  "Number of last async message recipient sent to."
  local)

(def-kom-var lyskom-is-new-user nil
  "An internal variable used in kom-start-anew.")

(def-kom-var lyskom-apo-timeout-s 1
  "Seconds timeout for accept-process-output.")

(def-kom-var lyskom-apo-timeout-ms nil
  "Microseconds timeout for accept-process-output.")

(def-kom-var lyskom-collate-table nil
  "Table mapping characters to an equivalence class."
  inherited)

(def-kom-var lyskom-char-classes nil
  "An assoc list from character to a list of equivalent strings.
See lyskom-compute-char-classes."
  inherited)

(def-kom-var lyskom-dont-read-user-area nil
  "If non-nil the user area will not be read on login."
  local)

(def-kom-var lyskom-allow-missing-subject nil
  "If non-nil allow texts without subjects.")

(def-kom-var kom-w3-simplify-body t
  "*Strip color information from body tag."
  server)

(def-kom-var kom-format-html-authors '((t . t))
  "*Controls from which authors we accept HTML.
Each element of this list is a cons cell (PERS . VAL), where PERS is
a person number and VAL is t or nil. If VAL is t, then we format HTML
written by PERS. Otherwise not."
  server)

(def-kom-var lyskom-format-special 
  '(("html"               . lyskom-format-html)
    ("enriched"           . lyskom-format-enriched)
    ("text/html"          . lyskom-format-html)
    ("text/enriched"      . lyskom-format-enriched)
    ("text/plain"         . nil)
    ("text/x-kom-basic"   . nil)
    ("x-kom/text"         . nil)  ;Archaic alias for text/x-kom-basic.
    ("x-kom/basic"        . nil)  ;Archaic alias for text/x-kom-basic.
    ("x-kom/\\."         . lyskom-format-))
  "AList of (FORMAT . FUNCTION) specifying functions that format texts
of that type. FORMAT is a symbol and FUNCTION is a function taking one
argument and returning a formatted string.")

(def-kom-var lyskom-send-text-transform-function nil
  "Function to call to transform text before sending it to the server.
The function should accept a single argument and return the transformed
texts that is to be sent to the server.")

(def-kom-var lyskom-slow-mode nil
  "Non-nil when in slow mode."
  local)

(def-kom-var lyskom-saved-read-only nil
  "Saved value of buffer-read-only when in slow mode."
  local)

(defvar lyskom-line-start-chars-string
  "\"$&'()*+-./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]_`abcdefghijklmnopqrstuvwxyz"
  "Characters that may start a line in a paragraph to be broken.")

(def-kom-var lyskom-line-start-chars nil
  "Computer-friendly version of lyskom-line-start-string.")


(def-kom-var lyskom-last-text-format-flags nil
  "List of flags specifying how the last text was reformatted. This variable
should be dynamically bound whenever it needs to be used.")

(def-kom-var lyskom-read-faqs nil
  "List of FAQs that have been read."
  inherited)

(def-kom-var lyskom-rejected-recommendations nil
  "List of invitations that have been rejected."
  inherited)

(defvar lyskom-xface-cache (make-vector 29 0))


;;; ======================================================================
;;; Event hooks
;;;

(def-kom-var lyskom-add-membership-hook nil
  "Functions to call when a membership is added."
  local-hook)

(def-kom-var lyskom-replace-membership-hook nil
  "Functions to call when a membership is replaced."
  local-hook)

(def-kom-var lyskom-remove-membership-hook nil
  "Functions to call when a membership is removed."
  local-hook)

(def-kom-var lyskom-new-membership-list-hook nil
  "Functions to call when the entire membership list is replaced."
  local-hook)


;;; ======================================================================
;;;; lyskom-tell-phrases-validation-keyword-list
;;; This is a list of keywords for kom-tell-phrases.
;;; These are the only keywords that are allowed in kom-tell-phrases.

;;; To coders of the elisp-client:
;;; If you add/delete a reference to any of these keywords make sure
;;; you update these changes.

;;; To everyone:
;;; The kom-tell-phrases list is checked against this list when the
;;; client is loaded, i.e. by lyskom-tell-phrases-validate that causes
;;; an error if any keyword is not present or any non-keyword is
;;; present.

(defvar kom-tell-phrases nil
  "*A list of phrases describing what the client is doing. Each element in
the list is a pair \(KEY . PHRASE\) where KEY is one of the keywords in
lykom-tell-phrases-validation-keyword-list and PHRASE is the phrase to
sent to the server then the client is doing what KEY describes.

If the value of this variable is nil, suitable defaults for the currently
selected language will be selected.")

(defconst lyskom-tell-phrases-validation-keyword-list
  '(
    (kom-tell-silence)
    (kom-tell-send)
    (kom-tell-login)
    (kom-tell-read)
    (kom-tell-1st-pres)
    (kom-tell-write-comment)
    (kom-tell-write-footnote)
    (kom-tell-write-letter)
    (kom-tell-write-reply)
    (kom-tell-write-text)
    (kom-tell-conf-pres)
    (kom-tell-recover)
    (kom-tell-wait)
    (kom-tell-regret)
    (kom-tell-review)
    (kom-tell-change-name)
    (kom-tell-change-supervisor)
    (kom-tell-next-lyskom)
    )
  "Users must not change this constant, but are encouraged to change
the value of  kom-tell-phrases for fun.")

;;; ================================================================
;;; Commands lists that are removed from extended command depending on
;;; administrator status.

(defconst lyskom-admin-removed-commands
  '(kom-enable-adm-caps))
(defconst lyskom-noadmin-removed-commands
  '(kom-disable-adm-caps
    kom-remove-motd
    kom-set-motd
    kom-shutdown-server
    kom-sync-database
    kom-add-server-faq 
    kom-del-server-faq
    kom-change-server-faq
    kom-recommend-conference))


;;; ================================================================
;;; Symbolic error codes

(defvar lyskom-error-codes
  '((no-error . 0)
    (not-implemented . 2)
    (obsolete-call . 3)
    (invalid-password . 4)
    (string-too-long . 5)
    (login-first . 6)
    (login-disallowed . 7)
    (conference-zero . 8)
    (undefined-conference . 9)
    (undefined-person . 10)
    (access-denied . 11)
    (permission-denied . 12)
    (not-member . 13)
    (no-such-text . 14)
    (text-zero . 15)
    (no-such-local-text . 16)
    (local-text-zero . 17)
    (bad-name . 18)
    (index-out-of-range . 19)
    (conference-exists . 20)
    (person-exists . 21)
    (secret-public . 22)
    (letterbox . 23)
    (ldb-error . 24)
    (illegal-misc . 25)
    (illegal-info-type . 26)
    (already-recipient . 27)
    (already-comment . 28)
    (already-footnote . 29)
    (not-recipient . 30)
    (not-comment . 31)
    (not-footnote . 32)
    (recipient-limit . 33)
    (comment-limit . 34)
    (footnote-limit . 35)
    (mark-limit . 36)
    (not-author . 37)
    (no-connect . 38)
    (out-of-memory . 39)
    (server-is-crazy . 40)
    (client-is-crazy . 41)
    (undefined-session . 42)
    (regexp-error . 43)
    (not-marked . 44)
    (temporary-failure . 45)
    (long-array . 46)
    (anonymous-rejected . 47)
    (illegal-aux-item . 48)
    (aux-item-permission . 49)
    (unknown-async . 50)
    (internal-error . 51)
    (feature-disabled . 52)
    (message-not-sent . 53)
    (invalid-membership-type . 54))
  )

;;; ================================================================
;;;          Externally defined variables (environment)


(defvar kom-default-server nil
  "*Setting this variable does nothing. See lyskom-default-server instead.")

(def-kom-var lyskom-default-server "kom.lysator.liu.se"
  "*Default LysKOM server.")

(defvar kom-default-user-name nil
  "*Setting this variable does nothing. See lyskom-default-user-name instead.")

(def-kom-var lyskom-default-user-name nil
  "*Default LysKOM user name."
  local)

(defvar kom-default-password nil
  "*Setting this variable does nothing. See lyskom-default-password instead.")

(def-kom-var lyskom-default-password nil
  "Default LysKOM password."
  local)

(def-kom-var mode-line-conf-name nil
  "Conf name that is present on the mode-line."
  local)

;;
;; Set up default faces in case no face scheme is selected
;;

(def-kom-var lyskom-faces
  '(kom-active-face kom-url-face kom-me-face kom-highlight-face
		    kom-text-face kom-subject-face kom-text-no-face
		    kom-friends-face kom-morons-face kom-presence-face
		    kom-first-line-face kom-warning-face kom-mark-face
                    kom-text-body-face kom-dashed-lines-face 
                    kom-async-text-body-face kom-async-dashed-lines-face
                    kom-dim-face)
  "This is a list of the faces that LysKOM uses.")

(defvar kom-face-schemes nil
  "*Setting this variable does nothing. See lyskom-face-schemes instead.")

(def-kom-var lyskom-face-schemes
  '((default
     (kom-active-face default "blue4" nil)
     (kom-url-face default "BlueViolet" nil)
     (kom-me-face bold "blue3" "lavender")
     (kom-highlight-face highlight nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face default "blue3" "lavender")
     (kom-morons-face default "blue3" "yellow")
     (kom-presence-face italic "dim gray" nil)
     (kom-mark-face bold "blue3" "lavender")
     (kom-warning-face bold "red" nil)
     (kom-first-line-face bold nil nil)
     (kom-dim-face default "gray" nil)
     (kom-dashed-lines-face nil nil "#e8e8ff")
     (kom-text-body-face nil nil "#f8f8ff")
     (kom-async-dashed-lines-face nil nil "#ffe8e8")
     (kom-async-text-body-face nil nil "#fff8f8")
     (property expected-background "white")
     )
    (bark
     (kom-active-face default "Gold" "Black")
     (kom-mark-face default "White" nil)
     (kom-url-face default "Gold" "Black")
     (kom-me-face default "Gold" "Black")
     (kom-highlight-face default "PaleGreen" nil)
     (kom-text-face default nil nil)
     (kom-subject-face default "Gold" nil)
     (kom-text-no-face default nil nil)
     (kom-presence-face default "Gold" nil)
     (kom-first-line-face bold nil nil)
     (kom-dashed-lines-face nil nil "#0a0a0a")
     (kom-async-text-body-face nil nil "#181818")
     (kom-async-dashed-lines-face nil nil "#0a0a0a")
     (kom-text-body-face nil nil "#181818")
     (kom-dim-face nil "DarkSlateGray")
     (kom-friends-face nil "Gold" "Black")
     (kom-morons-face nil "Gold" "Black")
     (kom-warning-face bold "Red" nil)
     (property expected-background "black")
     )
    (black-and-tan
      (kom-active-face default "#602000" nil)
      (kom-url-face default "#800040" nil)
      (kom-me-face bold "#602000" "#f0f0e0")
      (kom-highlight-face highlight nil nil)
      (kom-text-face default nil nil)
      (kom-subject-face default nil nil)
      (kom-text-no-face kom-active-face nil nil)
      (kom-friends-face default "#602000" "#f0f0e0")
      (kom-morons-face default "#602000" "#ffffc0")
      (kom-presence-face italic "grey" nil)
      (kom-mark-face bold "#602000" "#f0f0e0")
      (kom-warning-face bold "red" nil)
      (kom-first-line-face bold nil nil)
      (kom-dim-face default "gray" nil)
      (kom-text-body-face nil nil "#f8f8f0")
      (kom-dashed-lines-face nil nil "#f0f0e0")
      (kom-async-text-body-face nil nil "#f8f8f0")
      (kom-async-dashed-lines-face nil nil "#f0f0e0")
      (property expected-background "white")
      )
    (inverse
     (kom-active-face default "lightblue" nil)
     (kom-url-face default "Moccasin" nil)
     (kom-me-face bold "gold" "black")
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default "Khaki" nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face default "red" nil)
     (kom-morons-face default "yellow" nil)
     (kom-presence-face italic "grey" nil)
     (kom-mark-face default "gold" "black")
     (kom-warning-face bold "red" nil)
     (kom-first-line-face bold nil nil)
     (kom-dim-face default "gray" nil)
     (kom-dashed-lines-face nil nil "#101010")
     (kom-text-body-face nil nil "#080808")
     (kom-async-dashed-lines-face nil nil "#101030")
     (kom-async-text-body-face nil nil "#000020")
     (property expected-background "black")
     )
    (monochrome
     (kom-text-body-face nil nil nil)
     (kom-async-dashed-lines-face nil nil nil)
     (kom-async-text-body-face nil nil nil)
     (kom-dashed-lines-face nil nil nil)
     (kom-active-face default nil nil)
     (kom-url-face default nil nil)
     (kom-me-face bold nil nil)
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face kom-active-face nil nil)
     (kom-friends-face underline nil nil)
     (kom-morons-face strikethrough nil nil)
     (kom-presence-face italic nil nil)
     (kom-mark-face bold nil "black")
     (kom-warning-face bold nil nil)
     (kom-first-line-face bold nil nil)
     (kom-dim-face default nil nil)
     (property expected-background "white")
     )
    (minimal
     (kom-active-face default nil nil)
     (kom-url-face default nil nil)
     (kom-me-face default nil "lavender")
     (kom-highlight-face highlight nil nil)
     (kom-text-face default nil nil)
     (kom-subject-face default nil nil)
     (kom-text-no-face default nil nil)
     (kom-friends-face default nil "alice blue")
     (kom-morons-face default nil "red")
     (kom-presence-face italic "dim gray" nil)
     (kom-mark-face default nil "black")
     (kom-warning-face bold nil nil)
     (kom-first-line-face nil nil nil)
     (kom-dashed-lines-face nil nil nil)
     (kom-text-body-face nil nil nil)
     (kom-async-dashed-lines-face nil nil nil)
     (kom-async-text-body-face nil nil nil)
     (kom-dim-face default nil nil)
     (property expected-background "white")
     )
    (highlight
     (kom-active-face    default   nil          "aliceblue")
     (kom-url-face       default   nil          "yellow")
     (kom-me-face        bold      "darkblue"   "thistle")
     (kom-highlight-face highlight nil          nil)
     (kom-text-face      default   nil          nil)
     (kom-text-no-face   default   nil          nil)
     (kom-friends-face   default   "darkblue"   "thistle")
     (kom-morons-face    strikethrough   "red"        "seagreen")
     (kom-subject-face   default   nil          nil)
     (kom-presence-face  italic    "dim gray"   nil)
     (kom-mark-face      bold      "darkblue"   "thistle")
     (kom-warning-face   bold      "yellow"     "red")
     (kom-first-line-face nil  nil          "lavender")
     (kom-dashed-lines-face nil  nil          "lavender")
     (kom-text-body-face nil nil "#f8f8ff")
     (kom-async-dashed-lines-face nil  nil          "lavender")
     (kom-async-text-body-face nil nil "#f8f8ff")
     (kom-dim-face       default   "gray"       nil)
     (property expected-background "white")
     ))
  "*Face schemes for LysKOM.

This variable is an association list that defines the face and color
schemes in LysKOM. The car of each element is the scheme key, a
symbol, and the cdr is a list of face definitions. Each face
definition in turn is a list of four elements: the face name, the base
face, foreground color and background color. When LysKOM defines a
face from such a specification, the base face is first copied (unless
it is nil) and then the foreground and background colors are set. If
it permissible to substitute nil for any element except the face name.

For instance, (kom-me-face bold \"yellow\" \"red\") will cause kom-me-face
to be bold with yellow text on a red background."
)


;;; ============================================================
;;; History lists
;;;

(defvar lyskom-command-history nil)
(defvar lyskom-expression-history nil)
(defvar lyskom-message-history nil)
(defvar lyskom-language-history nil)
(defvar lyskom-fast-reply-history nil)
(defvar lyskom-help-history nil)


;;; ============================================================

(defconst lyskom-comment-types-list '(COMM-IN FOOTN-IN))
(defconst lyskom-recpt-types-list '(RECPT CC-RECPT BCC-RECPT))
(defconst lyskom-review-types-list '(REVIEW REVIEW-TREE
                                            REVIEW-MARK REVIEW-FAQ))

(eval-and-compile (provide 'lyskom-vars))

;;; vars.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: macros.el,v 44.29 2002/06/12 18:29:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: macros.el
;;;;
;;;; This file contains the macros which must be loaded before lyskom can
;;;; be compiled.
;;;;

(setq lyskom-clientversion-long
      (concat lyskom-clientversion-long
	      "$Id: macros.el,v 44.29 2002/06/12 18:29:32 byers Exp $\n"))

;;;
;;; Require parts of the widget package. We do this to avoid generating
;;; errors later on. This sucks. 
;;;

(require 'custom)
(require 'widget)

;;; ======================================================================
;;; lyskom-traverse - traverse a sequence.
;;;

(defmacro lyskom-traverse (atom sequence &rest body)
  "Bind ATOM to each element in SEQUENCE and execute BODY.
Value returned is always nil."
  `(let* ((__i__ 0)
          (__sequence__ ,sequence)
          (__len__ (or (listp __sequence__ )
                       (length __sequence__)))
          (,atom nil)
          (__result__ nil))
     (setq __result__ __result__)       ; Get rid of compiler warnings
     (if (listp __sequence__)
         (while __sequence__
           (setq ,atom (car __sequence__))
           ,@body
           (setq __sequence__ (cdr __sequence__)))
       (while (< __i__ __len__)
         (setq ,atom (aref __sequence__ __i__))
         ,@body
         (setq __i__ (1+ __i__))))
     __result__))
  

(defmacro lyskom-traverse-break (&optional result)
  "Break a current lyskom-traverse"
  `(progn (setq __len__ 0)
          (setq __sequence__ nil)
          (setq __result__ (or ,result __result__))))

(defmacro lyskom-traverse-aux (atom sequence &rest body)
  "Bind ATOM to each element in SEQUENCE and execute BODY.
Value returned is always nil."
  (let ((seq (make-symbol "aux-items")))
    (` (let (((, seq) (, sequence))
             ((, atom) nil))
         (while (, seq)
           (setq (, atom) (car (, seq)))
           (if (not (aux-item-flags->deleted
                     (aux-item->flags (, atom))))
               (progn (,@ body)))
           (setq (, seq) (cdr (, seq))))))))


(put 'lyskom-traverse-aux 'edebug-form-spec
     '(sexp form body))

(put 'lyskom-traverse-aux 'lisp-indent-hook 2)

(put 'lyskom-traverse 'edebug-form-spec
     '(sexp form body))


;;; ======================================================================
;;; lyskom-save-excursion Does not save point and mark.
;;;

(defmacro lyskom-save-excursion (&rest forms)
  "Save-excursion without saving point and mark."
  (list 'let (list '(__buffer__ (current-buffer)))
	(list 'unwind-protect
	      (cons 'progn
		    forms)
	      '(set-buffer __buffer__))))

(put 'lyskom-save-excursion 'edebug-form-spec t)
(put 'lyskom-save-excursion 'lisp-indent-hook 0)

;;; ======================================================================
;;; Some useful macros to make the code more readable.
;;;

(defmacro char-in-string (char string)
  "Return t if the character CHAR is member of STRING. Otherwise return nil."
  (list 'null
	(list 'not
	      (list 'string-match
		    (list 'regexp-quote
			  (list 'char-to-string char))
		    string))))

(defmacro ++ (var)
  "Increment the variable VAR and return the value."
  (list 'setq var (list '1+ var)))

(defmacro -- (var)
  "Decrement the variable VAR and return the value."
  (list 'setq var (list '1- var)))

(eval-and-compile
  (if (fboundp 'when)
      nil
    (defmacro when (expr &rest body)
      "Execute BODY if EXPR evaluates to non-nil"
      (list 'if expr (cons 'progn body)))
    (put 'when lisp-indent-function 1)
    (put 'when 'edebug-form-spec t)))

(eval-and-compile
  (if (fboundp 'unless)
      nil
    (defmacro unless (expr &rest body)
      "Execute BODY if EXPR evaluates to non-nil"
      (append (list 'if expr nil) body))
    (put 'unless lisp-indent-function 1)
    (put 'unless 'edebug-form-spec t)))


;;; ======================================================================
;;; Multiple blocking read from server
;;;

(defmacro blocking-do-multiple (bind-list &rest body)
  "Bind variables according to BIND-LIST and then eval BODY.
The value of the last form in BODY is returned.
Each element in BIND-LIST is a list (SYMBOL FORM) which binds SYMBOL to
the result of the server call FORM, which is the same as used in blocking-do.
All the forms in BIND-LIST are evaluated before any symbols are bound."
  (let ((bindsym 'multiple-bind-sym)
	(index 0))
    (` (let (((, bindsym)
	      (lyskom-blocking-do-multiple
	       (list (,@ (mapcar (function (lambda (x) 
					     (` (list '(, (car (car (cdr x))))
						      (,@ (cdr (car (cdr x))))))))
			   bind-list))))))
	 (let ((,@ (mapcar (function 
			    (lambda (bpat)
			      (prog1
				  (` ((, (car bpat))
				      (elt (, bindsym) (, index))))
				(setq index (1+ index)))))
			   bind-list)))
	   (,@ body))))))

(put 'blocking-do-multiple 'edebug-form-spec
     '(sexp body))

(put 'blocking-do-multiple 'lisp-indent-function 1)


;;; ======================================================================
;;; Some commands generat async messages we don't really want
;;;

(defmacro lyskom-ignoring-async (async &rest body)
  `(let ((lyskom-ignoring-async-list 
          (cons (list ,@async) lyskom-ignoring-async-list)))
     ,@body))

(put 'lyskom-ignoring-async 'edebug-form-spec
     '(sexp body))

(put 'lyskom-ignoring-async 'lisp-indent-function 1)


;;; ======================================================================
;;; These macros do magic things to the compiler to avoid gratuitous
;;; compiler warnings.
;;;

(eval-and-compile (defvar lyskom-expected-unresolved-functions nil))

(defmacro lyskom-external-function (fn)
  (` (eval-when-compile
       (setq lyskom-expected-unresolved-functions
             (cons (quote (, fn))
                   lyskom-expected-unresolved-functions)))))

(defmacro lyskom-end-of-compilation ()
  (` 
   (eval-when-compile
     (progn
       (if (and (boundp 'byte-compile-unresolved-functions)
                (consp (car-safe byte-compile-unresolved-functions))
                (symbolp (car-safe (car-safe 
                                    byte-compile-unresolved-functions))))
           (progn
             (mapcar (function (lambda (x)
                                 (setq byte-compile-unresolved-functions
                                       (delq
                                        (assq x
                                              byte-compile-unresolved-functions)
                                        byte-compile-unresolved-functions))))
                     lyskom-expected-unresolved-functions)
             (mapcar (function (lambda (x)
                                 (setq byte-compile-unresolved-functions
                                       (delq
                                        (assq x
                                              byte-compile-unresolved-functions)
                                        byte-compile-unresolved-functions))))
                     lyskom-compatibility-definitions)))
       (if lyskom-compatibility-definitions
           (message "Compatibility definitions: %s"
                    (mapconcat '(lambda (sym)
                                  (symbol-name sym))
                               lyskom-compatibility-definitions
                               ", ")))))))

;;; ============================================================
;;; Keymap handling
;;;

(defmacro lyskom-use-local-map (keymap)
  "Use keymap KEYMAP as local map in this buffer. KEYMAP is made local in
the current buffer, and its value is copied from the LysKOM buffer."
  (` (progn (make-local-variable (quote (, keymap)))
            (setq (, keymap)
                  (lyskom-default-value (quote (, keymap))))
            (use-local-map (, keymap)))))


;;; ============================================================
;;; Widget gunk
;;;

(defmacro lyskom-widget-wrapper (fn file)
  `(eval-and-compile
     (if (not (fboundp ',fn))
         (autoload ',fn ,file))))

(lyskom-widget-wrapper define-widget "widget")
(lyskom-widget-wrapper widget-at "wid-edit")
(lyskom-widget-wrapper widget-value "wid-edit")
(lyskom-widget-wrapper widget-button-click "wid-edit")
(lyskom-widget-wrapper widget-setup "wid-edit")
(lyskom-widget-wrapper widget-value-set "wid-edit")
(lyskom-widget-wrapper widget-insert "wid-edit")
(lyskom-widget-wrapper widget-create "wid-edit")
(lyskom-widget-wrapper widget-get "wid-edit")
(lyskom-widget-wrapper widget-put "wid-edit")

;;; ============================================================
;;; Signal gunk
;;;

(defmacro lyskom-ignore-errors (&rest forms)
  (` (condition-case nil
         (progn (,@ forms))
       (error nil))))

(put 'ignore-errors 'edebug-form-spec
     '(sexp form body))


;;; ============================================================
;;; Local variables
;;;

(defmacro lyskom-setq-default (name value)
  (` (lyskom-set-default (quote (, name))
                         (, value))))


(eval-and-compile (provide 'lyskom-macros))

;;; Local Variables: 
;;; eval: (put 'lyskom-traverse 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-save-excursion 'lisp-indent-hook 0)
;;; eval: (put 'lyskom-ignore-errors 'lisp-indent-hook 2)
;;; end: 
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: compatibility.el,v 44.60 2002/08/06 19:43:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;; Copyright (C) 2001 Free Software Foundation, Inc.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: compatibility.el
;;;;
;;;; This file contains functions that may not exist in all supported
;;;; versions of Gnu Emacs. XEmacs-specific and Emacs 18-specific code
;;;; should go in some other file.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: compatibility.el,v 44.60 2002/08/06 19:43:32 byers Exp $\n"))


;;; ======================================================================
;;; Use lyskom-provide to supply a definition that is only to be used
;;; if no definition already exists. The definition will be evaluated at
;;; both compile and run time.
;;;
;;; lyskom-provide-macros behaves like defmacro
;;; lyskom-provide-function behaves like defun
;;; lyskom-provide-subst behaves like defsubst
;;;

(eval-and-compile
  (defvar lyskom-compatibility-definitions nil
    "Functions defined or redefined because they are incompatible with
LysKOM"))

;;; ============================================================
;;; lyskom-compatibility-forms
;;; lyskom-compatibility-definition
;;;


(defmacro lyskom-compatibility-forms (predicate &rest forms)
  "If PREDICATE is nil, evaluate FORMS at compile and run time"
  (` (eval-and-compile
       (if (not (, predicate))
           (progn (,@ forms))))))

(defmacro lyskom-compatibility-definition (predicate definition)
  "If PREDICATE is nil, evaluate DEFINITION at compile and run time.
Definition should be a function definition of some kind, with syntax 
similar to defun or defmacro.

To simply define a function if it is not already defined, used one
of the lyskom-provide-* functions instead."
  (` (progn ;(eval-when-compile
            ;  (if (not (, predicate))
            ;      (message "Compatibility %S for %S"
            ;               (quote (, (car definition)))
            ;               (quote (, (car (cdr definition)))))))
              (eval-and-compile
                (if (not (, predicate))
                    (progn
                      (, definition)
                      (setq lyskom-compatibility-definitions
                            (cons (quote (, (car (cdr definition))))
                                  lyskom-compatibility-definitions))))))))


;;; ============================================================
;;; lyskom-provide
;;; lyskom-provide-macro
;;; lyskom-provide-function
;;; lyskom-provide-subst
;;;
;;; Define functions if they are not already defined
;;;

(defmacro lyskom-provide (definer name rest)
  `(eval-and-compile
     (if (not (fboundp ',name))
         (progn (setq lyskom-compatibility-definitions
                      (cons ',name lyskom-compatibility-definitions))
                (,definer ,name ,@rest)))))


(defmacro lyskom-provide-macro (name &rest rest)
  "If NAME is not already defined, define it as a macro."
  (` (lyskom-provide defmacro (, name) (, rest))))

(defmacro lyskom-provide-function (name &rest rest)
  "If NAME is not already defined, define it as a function."
  (` (lyskom-provide defun (, name) (, rest))))

(defmacro lyskom-provide-subst (name &rest rest)
  "If NAME is not already defined, define it as a defsubst."
  (` (lyskom-provide defsubst (, name) (, rest))))


;;; ============================================================
;;; lyskom-xemacs-or-gnu
;;;

(eval-and-compile
  (defmacro lyskom-xemacs-or-gnu (xemacs-form gnu-form)
    "Eval XEMACS-FORM in XEmacs and GNU-FORM in Gnu Emacs."
    (if (string-match "XEmacs" (emacs-version))
        xemacs-form
      gnu-form)))

(put 'lyskom-xemacs-or-gnu 'edebug-form-spec '(form form))



;;; ======================================================================
;;; Defining keys
;;;
;;; Lots of Emacsen have buggy definitions of kbd (or no definition at all)
;;; Although it's crufty to redefine a function from subr.el, I will do so
;;; if it appears to be misbehaving. Don't like it? Tough!
;;;

(lyskom-compatibility-definition
    (condition-case nil
        (or (equal (kbd (identity "<down-mouse-2>"))
                   [down-mouse-2])
            (error "Bad definition of kbd"))
      (error nil))

    (defmacro kbd (keys)
      "Convert KEYS to the internal Emacs key representation.
KEYS should be a string in the format used for saving keyboard macros
\(see `insert-kbd-macro')."
      (if (or (stringp keys)
              (vectorp keys))
          (read-kbd-macro keys)
        `(read-kbd-macro ,keys))))


;;; ======================================================================
;;; ======================================================================
;;; ======================================================================

;;;


(lyskom-provide-macro char-before (&optional pos buffer)
  `(save-excursion
     (save-restriction 
       (widen)
       ,@(if buffer `((set-buffer ,buffer)))
       ,(if pos 
	    `(if (or (> ,pos (point-max))
		     (<= ,pos (point-min)))
		 nil
	       (goto-char ,pos)
	       (preceding-char))
	   `(if (<= (point) (point-min))
		nil
	      (preceding-char))))))
		       

(lyskom-provide-function characterp (obj)
  (integerp obj))

(lyskom-provide-function int-to-char (obj)
  obj)

(lyskom-compatibility-forms (fboundp 'frame-width)
    (fset 'frame-width 'screen-width))

(lyskom-provide-function signum (num)
  (cond ((< num 0) -1)
        ((> num 0) 1)
        (t 0)))


;;; ======================================================================
;;; Definition of map-keymap that hopefully works like the one in XEmacs
;;; except that the sort-first argument is ignored.
;;;

(lyskom-provide-function map-keymap (fn keymap &optional sort-first)
  (let ((r 0))
    (cond ((vectorp keymap)
           (while (< r (length keymap))
             (if (aref keymap r)
                 (funcall fn r (aref keymap r)))
             (setq r (1+ r))))
          (t (mapcar (function 
                      (lambda (x)
                        (funcall fn (car x) (cdr x))))
                     (cdr keymap))))))


(lyskom-provide-function set-keymap-parent (keymap new-parent)
   (let ((tail keymap))
     (while (and tail (cdr tail) (not (eq (car (cdr tail)) 'keymap)))
       (setq tail (cdr tail)))
     (if tail
         (setcdr tail new-parent))))

(defconst lyskom-gnu-keysym
  '((button1   . "<down-mouse-1>")
    (button2   . "<down-mouse-2>")
    (button3   . "<down-mouse-3>")
    (button1up . "<mouse-1>")
    (button2up . "<mouse-2>")
    (button3up . "<mouse-3>")
    (	       . [229])
    (	       . [197])
    (C-       . [(control 229)])
    (C-       . [(control 197)])
    (	       . [228])
    (	       . [196])
    (	       . [246])
    (	       . [214])
))

(defconst lyskom-xemacs-keysym
  '((button1   . "<button1>")
    (button2   . "<button2>")
    (button3   . "<button3>")
    (button1up . "<button1up>")
    (button2up . "<button2up>")
    (button3up . "<button3up>")
    (C-       . [(control aring)])
    (C-       . [(control Aring)])
    (	       . [aring])
    (	       . [Aring])
    (	       . [adiaeresis])
    (	       . [Adiaeresis])
    (	       . [odiaeresis])
    (	       . [Odiaeresis])
))


(defun lyskom-keys (sym)
  "Look up the key description for key SYM."
  (cdr (assq sym (lyskom-xemacs-or-gnu lyskom-xemacs-keysym
                                       lyskom-gnu-keysym))))


;;; ============================================================
;;; Text property and extents stuff
;;;

(lyskom-provide-function map-extents (&rest args))

(lyskom-provide-function next-text-property-bounds 
    (count pos prop &optional object)
  "Return the COUNTth bounded property region of property PROP after POS.
If COUNT is less than zero, search backwards.  This returns a cons
\(START . END) of the COUNTth maximal region of text that begins after POS
\(starts before POS) and has a non-nil value for PROP.  If there aren't
that many regions, nil is returned.  OBJECT specifies the buffer or
string to search in."
  (or object (setq object (current-buffer)))
  (let ((begin (if (stringp object) 0 (point-min)))
	(end (if (stringp object) (length object) (point-max))))
    (catch 'hit-end
      (if (> count 0)
	  (progn
	    (while (> count 0)
	      (if (>= pos end)
		  (throw 'hit-end nil)
		(and (get-char-property pos prop object)
		     (setq pos (next-single-property-change pos prop
							    object end)))
		(setq pos (next-single-property-change pos prop object end)))
	      (setq count (1- count)))
	    (and (< pos end)
		 (cons pos (next-single-property-change pos prop object end))))
	(while (< count 0)
	  (if (<= pos begin)
	      (throw 'hit-end nil)
	    (and (get-char-property (1- pos) prop object)
		 (setq pos (previous-single-property-change pos prop
							    object begin)))
	    (setq pos (previous-single-property-change pos prop object
						       begin)))
	  (setq count (1+ count)))
	(and (> pos begin)
	     (cons (previous-single-property-change pos prop object begin)
		   pos))))))


;;; ============================================================
;;; Basic stuff

(lyskom-provide-function char-to-int (c) c)

(defvar enable-multibyte-characters nil)
(lyskom-provide-function set-buffer-multibyte (arg)
  (put 'enable-multibyte-characters 'permanent-local t)
  (make-local-variable 'enable-multibyte-characters)
  (setq enable-multibyte-characters arg))

(lyskom-provide-function set-process-coding-system (proc &optional encoding decoding)
  ) 

(lyskom-provide-function encode-coding-string (str coding-system) (copy-sequence str))
(lyskom-provide-function decode-coding-string (str coding-system) (copy-sequence str))
(lyskom-provide-function string-bytes (str) (length str))
(lyskom-provide-function check-coding-system (name) (error "No such coding system"))
(lyskom-provide-function find-coding-systems-for-charsets (cs) nil)
(lyskom-provide-function coding-system-get (cs prop) nil)
(lyskom-provide-function string-width (str) (length str))
(lyskom-provide-function char-width (c) 1)
(lyskom-provide-function find-charset-string (str) '(ascii))
(lyskom-provide-function string-as-unibyte (str) str)
(lyskom-provide-function string-make-unibyte (str) str)
(lyskom-provide-function string-make-multibyte (str) str)
(lyskom-provide-function multibyte-string-p (str) nil)


;;; Detect buggy versions of encode-coding-string and decode-coding-string
;;; such as those provided by APEL (part of TM and often included in XEmacs)

(defun lyskom-buggy-encode-coding-string (str coding-system) str)
(eval-and-compile
  (if (let ((test "TEM")) (eq (encode-coding-string test 'raw-text) test))
      (progn (fset 'lyskom-buggy-encode-coding-string
                   (symbol-function 'encode-coding-string))
             (defun encode-coding-string (str coding-system)
               (copy-sequence (lyskom-buggy-encode-coding-string str coding-system))))))

(defun lyskom-buggy-decode-coding-string (str coding-system) str)
(eval-and-compile
  (if (let ((test "TEM")) (eq (decode-coding-string test 'raw-text) test))
      (progn (fset 'lyskom-buggy-decode-coding-string
                   (symbol-function 'decode-coding-string))
             (defun decode-coding-string (str coding-system)
               (copy-sequence (lyskom-buggy-decode-coding-string str coding-system))))))


;; defmacro lyskom-encode-coding-char in XEmacs so the compiled code
;; is quicker. In Gnu Emacs define it as a function.
;;
;; The definition is made at compile-time to avoid getting warnings 
;; about encode-coding-char.

(eval-and-compile
  (cond ((eval-when-compile (string-match "XEmacs" (emacs-version)))
         (defmacro lyskom-encode-coding-char (c system) c))
        ((eval-when-compile (fboundp 'encode-coding-char))
         (defun lyskom-encode-coding-char (c system)
           (let ((s (encode-coding-char c system)))
             (if (and s (= (length s) 1))
                 (elt s 0)))))
        (t (defmacro lyskom-encode-coding-char (c system) c))))


(eval-and-compile
  (lyskom-xemacs-or-gnu
   (fset 'lyskom-string-width (symbol-function 'string-width))
   (defun lyskom-string-width (str)
     (cond ((and (multibyte-string-p str)
                 (null enable-multibyte-characters))
            (string-width (string-make-unibyte str)))
           ((and (null (multibyte-string-p str))
                 enable-multibyte-characters)
            (string-width (string-make-multibyte str)))
           (t (string-width str))))))


(eval-and-compile
  (cond ((eval-when-compile (string-match "XEmacs" (emacs-version)))
         (defun lyskom-completing-read (prompt
                                        table 
                                        &optional predicate require-match
                                        init hist def inherit-input-method)
           (completing-read prompt table predicate require-match init hist)))
        ((eval-when-compile (> emacs-major-version 19))
         (fset 'lyskom-completing-read (symbol-function 'completing-read)))
        (t 
         (defun lyskom-completing-read (prompt
                                        table 
                                        &optional predicate require-match
                                        init hist def inherit-input-method)
           (completing-read prompt table predicate require-match init hist)))))

(eval-and-compile
  (cond ((eval-when-compile (string-match "XEmacs" (emacs-version)))
	 (defun lyskom-read-from-minibuffer (prompt 
					     &optional initial-contents
					     keymap read hist default-value
					     inherit-input-method)
	   (read-from-minibuffer prompt
				 initial-contents
				 keymap
				 read
				 hist)))
	((eval-when-compile (> emacs-major-version 19))
	 (fset 'lyskom-read-from-minibuffer 
	       (symbol-function 'read-from-minibuffer)))
	(t (defun lyskom-read-from-minibuffer (prompt 
					       &optional initial-contents
					       keymap read hist default-value
					       inherit-input-method)
	     (read-from-minibuffer prompt
				   initial-contents
				   keymap
				   read
				   hist)))))

(lyskom-external-function temp-minibuffer-message)
(lyskom-provide-function minibuffer-message (message)
  (temp-minibuffer-message message))


(lyskom-provide-function last (x &optional n)
  "Returns the last link in the list LIST.
With optional argument N, returns the Nth-to-last link (default 1)."
  "Returns the last link in the list LIST.
With optional argument N, returns Nth-to-last link (default 1)."
  (if n
      (let ((m 0) (p x))
	(while (consp p) (setq m (1+ m)) (setq p (cdr p)))
	(if (<= n 0) p
	  (if (< n m) (nthcdr (- m n) x) x)))
    (while (consp (cdr x)) (setq x (cdr x)))
    x))

(lyskom-provide-function plist-member (plist prop)
  "Return non-nil if PLIST has the property PROP.
PLIST is a property list, which is a list of the form
\(PROP1 VALUE1 PROP2 VALUE2 ...\). PROP is a symbol.
Unlike `plist-get', this allows you to distinguish between a missing
property and a property with the value nil."
      (while (and plist (not (eq (car plist) prop)))
        (setq plist (cdr (cdr plist))))
      (and plist t))

;; The make-temp-file function below is taken verbatim from Emacs 21.2.
(lyskom-provide-function make-temp-file (prefix &optional dir-flag)
  "Create a temporary file.  The returned file name (created by
appending some random characters at the end of PREFIX, and expanding
against `temporary-file-directory' if necessary, is guaranteed to
point to a newly created empty file.  You can then use `write-region'
to write new data into the file.

If DIR-FLAG is non-nil, create a new empty directory instead of a file."
  (let (file)
    (while (condition-case ()
	       (progn
		 (setq file
		       (make-temp-name
			(expand-file-name prefix 
                                          (lyskom-xemacs-or-gnu
                                           (temp-directory)
                                           temporary-file-directory))))
		 (if dir-flag
		     (make-directory file)
		   (write-region "" nil file nil 'silent nil 'excl))
		 nil)
             (file-already-exists t))
      ;; the file was somehow created by someone else between
      ;; `make-temp-name' and `write-region', let's try again.
      nil)
    file))


;;; ================================================================
;;; Faces

(lyskom-provide-function reset-face (face &optional locale tag-set exact-p)
  )

(lyskom-provide-function lyskom-face-background-name (face)
  (face-background face))

(lyskom-provide-function lyskom-face-foreground-name (face)
  (face-foreground face))


(lyskom-provide-function find-face (face)
  (and (facep face) face))

(defun lyskom-make-face (name temporary)
  "Like make-face in XEmacs"
  (lyskom-xemacs-or-gnu (make-face name nil temporary)
                        (make-face name)))

(if (not (find-face 'strikethrough))
    (progn (make-face 'strikethrough)
           (if (eval-when-compile (fboundp 'set-face-strikethrough-p))
               (set-face-strikethru-p 'strikethrough t)
             (set-face-underline-p 'strikethrough t))))


;;; ======================================================================
;;; Event stuff

(lyskom-external-function event-start)
(lyskom-provide-function event-point (e)
  "Return the character position of the given mouse event.
If the event did not occur over a window, or did not occur over text,
then this returns nil.  Otherwise, it returns an index into the buffer
visible in the event's window."
  (car (cdr (event-start e))))

(lyskom-provide-function event-closest-point (e)
  "Return the character position closest to the mouse event EVENT."
  (car (cdr (event-start e))))

(lyskom-provide-function event-glyph (e))


(defun lyskom-get-buffer-window-list (buffer &optional minibuf frame)
  "Return windows currently displaying BUFFER, or nil if none.
See `walk-windows' for the meaning of MINIBUF and FRAME."
  (let ((buffer (if (bufferp buffer) buffer (get-buffer buffer))) windows)
    (walk-windows (function (lambda (window)
			      (if (eq (window-buffer window) buffer)
				  (setq windows (cons window windows)))))
		  minibuf frame)
    windows))

(lyskom-provide-function 
 replace-in-string (str regexp newtext &optional literal)
  "Replaces all matches in STR for REGEXP with NEWTEXT string.
Optional LITERAL non-nil means do a literal replacement.
Otherwise treat \\ in NEWTEXT string as special:
  \\& means substitute original matched text,
  \\N means substitute match for \(...\) number N,
  \\\\ means insert one \\."
  (if (not (stringp str))
      (error "(replace-in-string): First argument must be a string: %s" str))
  (if (stringp newtext)
      nil
    (error "(replace-in-string): 3rd arg must be a string: %s"
	   newtext))
  (let ((rtn-str "")
	(start 0)
	(special)
	match prev-start)
    (while (setq match (string-match regexp str start))
      (setq prev-start start
	    start (match-end 0)
	    rtn-str
	    (concat
	      rtn-str
	      (substring str prev-start match)
	      (cond (literal newtext)
		    (t (mapconcat
			 (function
			   (lambda (c)
			     (if special
				 (progn
				   (setq special nil)
				   (cond ((eq c ?\\) "\\")
					 ((eq c ?&)
					  (substring str
						     (match-beginning 0)
						     (match-end 0)))
					 ((and (>= c ?0) (<= c ?9))
					  (if (> c (+ ?0 (length
							   (match-data))))
					      ;; Invalid match num
					      (error "(replace-in-string) Invalid match num: %c" c)
					    (setq c (- c ?0))
					    (substring str
						       (match-beginning c)
						       (match-end c))))
					 (t (char-to-string c))))
			       (if (eq c ?\\) (progn (setq special t) nil)
				 (char-to-string c)))))
			 newtext ""))))))
    (concat rtn-str (substring str start))))


(lyskom-provide-function buffer-live-p (object)
  "T of OBJECT is an editor buffer that has not been deleted."
  (and (bufferp object)
       (buffer-name object)))

;;; ================================================================
;;; Color stuff

(lyskom-external-function set-specifier)
(lyskom-external-function make-specifier)
(lyskom-external-function color-rgb-components)

(lyskom-compatibility-definition (not (and (fboundp 'color-rgb-components) 
                                           (fboundp 'make-specifier)))
    (defun lyskom-color-values (color)
      (when (stringp color)
        (let ((spec nil))
          (set-specifier (setq spec (make-specifier 'color)) color)
          (setq color spec)))
      (color-rgb-components color)))

(eval-and-compile
  (cond ((fboundp 'lyskom-color-values) nil)
        ((fboundp 'color-values) (fset 'lyskom-color-values 'color-values))
        ((fboundp 'x-color-values) (fset 'lyskom-color-values 'x-color-values))))


;;; ======================================================================
;;; Platform-specific stuff

(lyskom-provide-function w32-shell-execute (&rest args)
  "Dummy function that raises an error."
  (error "w32-shell-execute undefined"))

;; This code looks the way it does in order to avoid warnings in
;; Emacs 21.

(eval-and-compile
  (condition-case nil
      (symbol-value ':default-help-echo)
    (error (set ':default-help-echo ':default-help-echo)))
  (condition-case nil
      (symbol-value ':group)
    (error (set ':group ':group))))




;;; Local Variables:
;;; eval: (put 'lyskom-provide-macro 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-provide-function 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-provide-subst 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-compatibility-forms 'lisp-indent-hook 2)
;;; eval: (put 'lyskom-compatibility-definition 'lisp-indent-hook 2)
;;; end:
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: language.el,v 44.26 2002/05/24 12:42:44 davidk Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: language.el
;;;; Author: Niels Mller
;;;;
;;;;

(require 'lyskom-vars "vars")

;;; Variables

;;(defvar lyskom-language-symbols nil
;;  "Symbols with language data bound to them")

(defvar lyskom-languages nil
  "An alist of defined languages.
Each entry is a pair (SYMBOL . (NAME NAME ...)) where symbol is the symbol
used for identification, and the NAMEs are names of the language.")

(defvar lyskom-language-categories nil
  "Categories of language-specific variables.
Each element is a cons cell (NAME . SCOPE), where NAME is the name of
the category and SCOPE is its scope (global or local).")

(defvar lyskom-language-vars nil
  "A list of all language-dependent variables.
Each element is a cons cell (NAME . SCOPE), where NAME is the name of
the category and SCOPE is its scope (global or local).")


(defun lyskom-language-var-internal (scope var language val)
  "Defines a language-local variable value."
  (or (assq var lyskom-language-vars)
      (setq lyskom-language-vars
	    (cons (cons var scope) lyskom-language-vars)))
  (let* ((alist (get var 'lyskom-language-var))
	 (entry (assq language alist)))
    (if entry
	(setcdr entry val)
      (put var 'lyskom-language-var (cons (cons language val) alist)))))

(defmacro lyskom-language-var (scope var language val)
  `(lyskom-language-var-internal ',scope
                                 ',var
                                 ',language
                                 ',val))

(put 'lyskom-language-var 'lisp-indent-function 2)

(defun lyskom-set-language-vars (language scope)
  "Set language-specific variables to values for LANGUAGE.
SCOPE must be one of global or local, and specifies the scope of the change.
If SCOPE is global, change all variables, even those that affect multiple
sessions."
  (mapcar
   (lambda (spec)
     (let ((var (car spec))
           (var-scope (cdr spec)))
       (when (or (eq scope 'global) (eq var-scope 'local))
         (when (or (not (symbol-value var))
                   (get var 'lyskom-language-force))
           (set var (eval (cdr (assq language
                                     (get var 'lyskom-language-var)))))))))
   lyskom-language-vars))

;;; Keymaps

(defvar lyskom-language-keymaps nil
  "A list of all language-dependent keymaps.")

(defun lyskom-language-keymap-internal (keymap language langmap)
  "Defines a language-local keymap."
  ;; If the "real" keymap has no value, set it to an empty keymap
  (if (eval keymap)
      nil
    (set keymap (make-sparse-keymap)))
  ;; Add it to the list of keymaps
  (or (memq keymap lyskom-language-keymaps)
      (setq lyskom-language-keymaps
	    (cons keymap lyskom-language-keymaps)))
  ;; Modify the property list
  (let* ((alist (get keymap 'lyskom-language-keymap))
	 (entry (assq language alist)))
    (if entry
	(setcdr entry langmap)
      (put keymap 'lyskom-language-keymap
	   (cons (cons language langmap) alist)))))

(defmacro lyskom-language-keymap (keymap language langmap)
  `(lyskom-language-keymap-internal ',keymap
                                    ',language
                                    ',langmap))

(put 'lyskom-language-keymap 'lisp-indent-function 2)

(defun lyskom-set-language-keymaps (language)
  (mapcar
   (lambda (map)
     (set-keymap-parent (symbol-value map)
                        (eval (cdr (assq language
                                         (get map
                                              'lyskom-language-keymap))))))
   lyskom-language-keymaps))

;(defun lyskom-set-language-keymaps (language)
;  (mapcar
;   (function
;    (lambda (map)
;      (setcdr (symbol-value map)
;	      (eval (cdr (assq language
;			       (get map 'lyskom-language-keymap)))))))
;   lyskom-language-keymaps))

;;; String catalogs

(defun lyskom-language-strings-internal (scope category language alist)
  "Associates names to symbols.
See documentation of lyskom-language-strings for information on the 
parameters to this function."
  ;; Record category
  (or (assq category lyskom-language-categories)
      (setq lyskom-language-categories
	    (cons (cons category scope) lyskom-language-categories)))
  (let ((record (get category 'lyskom-language-symbols)))
    (mapcar (lambda (pair)
              (let* ((symbol (car pair))
                     (string (cdr pair))
                     (llist (get symbol category))
                     (entry (assq language llist)))
                ;; Record symbol
                (or (memq symbol record)
                    (setq record (cons symbol record)))
                (if entry
                    (setcdr entry string)
                  (put symbol category (cons (cons language string) llist)))))
	    alist)
    (put category 'lyskom-language-symbols record)))

(defmacro lyskom-language-strings (scope category language alist)
  "Define a category of strings.
SCOPE is the scope of language-specificity. If it is global, then these
strings apply globally and will not be altered by changing the session
language.

CATEGORY is the name of the category.

LANGUAGE is the language, a symbol denoting the ISO639 language code.

ALIST is the list of strings."
  `(lyskom-language-strings-internal ',scope
                                     ',category
                                     ',language
                                     ,alist))

(defun lyskom-language-missing-string-internal (category string languages)
  (let ((old-missing (assq 'lyskom-missing-languages (get string category))))
    (if old-missing
        (setcdr old-missing (append languages (cdr old-missing)))
      (put string category (cons (cons 'lyskom-missing-languages languages)
                                 (get string category))))))

(defun lyskom-language-ending-mismatch-internal (category string l1 l2)
  (let ((old-mismatch (assq 'lyskom-ending-mismatch (get string category))))
    (if old-mismatch
        (setcdr old-mismatch (append (list (cons l1 l2) (cons l2 l1))
                                     (cdr old-mismatch)))
      (put string category (cons (cons 'lyskom-ending-mismatch 
                                       (list (cons l1 l2) (cons l2 l1)))
                                 (get string category))))))

(defmacro lyskom-language-missing-string (category string &rest languages)
  `(lyskom-language-missing-string-internal ',category ',string ',languages))

(defmacro lyskom-language-ending-mismatch (category string l1 l2)
  `(lyskom-language-ending-mismatch-internal ',category ',string ',l1 ',l2))

(put 'lyskom-language-strings 'lisp-indent-function 2)

(defsubst lyskom-tell-string (key)
  "Retrieve the phrase indexed by the key from the kom-tell-phrases
assoc list."
  (condition-case nil
      (lyskom-get-string key 'kom-tell-phrases)
    (lyskom-internal-error (message "Bad kom-tell-phrases: missing %s" key)
                           "")))

(defsubst lyskom-try-get-string (symbol category)
    (cdr (assq (if (eq (cdr (assq category lyskom-language-categories)) 'local)
                   lyskom-language
                 lyskom-global-language)
               (get symbol category))))

(defsubst lyskom-get-string-error (function symbol category)
  (signal 'lyskom-internal-error
	  (list function (list symbol category ": string not found"))))

(defun lyskom-get-string (symbol &optional category)
  "Returns string associated with SYMBOL"
    (or (lyskom-try-get-string symbol (or category 'lyskom-message))
        (lyskom-get-string-error 'lyskom-get-string
                                 symbol
                                 (or category 'lyskom-message))))

(defun lyskom-get-string-sol (symbol &optional category)
  "Returns string associated with SYMBOL
If kom-long-lines is set, return the long form of the string, if it exists."
  (or  (and kom-long-lines
            (lyskom-try-get-string (intern (concat (symbol-name symbol)
                                                        "-long"))
                                        (or category 'lyskom-message)))
       (lyskom-try-get-string symbol
                                   (or category 'lyskom-message))
       (lyskom-get-string-error 'lyskom-get-string
                                symbol
                                (or category 'lyskom-message))))


(defun lyskom-get-strings (symbols &optional category)
  "Returns an alist of (symbol . string) pairs

according to CATEGORY and lyskom-language. Kind of inverse to
lyskom-define-language."
  (mapcar (lambda (symbol)
            (cons symbol (lyskom-get-string symbol category)))
	  symbols))

(defun lyskom-get-menu-string (symbol)
  "Returns the name of a menu(item)

Looks for the 'lyskom-menu category, or 'lyskom-command
if 'lyskom-menu is not found."
  (encode-coding-string 
    (or (lyskom-try-get-string symbol 'lyskom-menu)
        (lyskom-try-get-string symbol 'lyskom-command)
        (lyskom-get-string-error 'lyskom-get-menu-string symbol 'lyskom-menu))
    'iso-8859-1))

(defun lyskom-string-check-category (category)
  "Returns list of names for the category, and their supported languages"
  (mapcar (lambda (symbol)
            (let ((info (get symbol category)))
              (if info (cons symbol (mapcar 'car info)))))
	  (get category 'lyskom-language-symbols)))


(defun lyskom-define-language (language coding &rest names)
  (let ((match (assq language lyskom-languages)))
    (if match
	(setcdr match names)
      (setq lyskom-languages (cons (cons language names) lyskom-languages))))
  (put language 'lyskom-language-coding coding))

(defun lyskom-language-coding (language)
  (or (get language 'lyskom-language-coding)
      'raw-text))

(defun lyskom-language-name (language)
  "Return the name of language code LANGUAGE in the current language."
  (save-excursion
    (when lyskom-buffer (set-buffer lyskom-buffer))
    (or (cdr (assq language lyskom-language-codes))
        (lyskom-format (cdr (assq '-- lyskom-language-codes))
                       (symbol-name language)))))

(defun lyskom-set-language (language scope)
  "Set the current language to LANGUAGE.
Returns non-nil on success and nil on failure."
  (cond ((not (assq language lyskom-languages))
         (lyskom-format-insert-before-prompt 'language-not-loaded
                                             (lyskom-language-name language))
         nil)
        (t 
         (cond ((eq scope 'local) 
                (setq lyskom-language language))
               ((eq scope 'global) 
                (setq lyskom-global-language language)
                (lyskom-set-language-keymaps language)))
         (lyskom-set-language-vars language scope)
         (when (eq scope 'global) (lyskom-update-menus))
         (lyskom-update-prompt t)
         (lyskom-update-command-completion)
         t)))

(eval-and-compile (provide 'lyskom-language))

;;; language.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: help.el,v 44.6 2002/06/12 18:29:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: help.el
;;;;
;;;; Functions for formatting help strings in the client
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: help.el,v 44.6 2002/06/12 18:29:32 byers Exp $\n"))



(defgroup lyskom-faces nil
  "Faces for use in the LysKOM elisp client."
  :group 'lyskom)

(defgroup lyskom nil
  "Faces for use in the LysKOM elisp client."
  :group 'default)

(defface lyskom-help-h1-face '((t (:weight bold :underline t :height 2.0 :family "helvetica")))
  "First level header in LysKOM help."
  :group 'lyskom-faces)

(defface lyskom-help-h2-face '((t (:weight bold :underline t :height 1.5 :family "helvetica")))
  "Second level header in LysKOM help."
  :group 'lyskom-faces)

(defface lyskom-help-h3-face '((t (:weight bold :family "helvetica")))
  "Third level header in LysKOM help."
  :group 'lyskom-faces)

;;; Note that these are duplicated in help-compile.el. Change one and change both!

(defsubst lyskom-help-create-data (tag attr data)
  (list tag attr data))

(defsubst lyskom-help-data-get-tag (data)
  (elt data 0))

(defsubst lyskom-help-data-get-attr (attr data)
  (cdr (assq attr (elt data 1))))

(defsubst lyskom-help-data-get-attrs (data)
  (elt data 1))

(defsubst lyskom-help-data-get-data (data)
  (elt data 2))


(defvar lyskom-help-format-handlers
  '((h1 . lyskom-help-format-h1)
    (h2 . lyskom-help-format-h2)
    (h3 . lyskom-help-format-h3)
    (p  . lyskom-help-format-p)
    (b  . lyskom-help-format-b)
    (i  . lyskom-help-format-i)
    (list . lyskom-help-format-list)
    (item . lyskom-help-format-item)
    (inline . lyskom-help-format-inline)
    (refer . lyskom-help-format-refer)
    (cref . lyskom-help-format-cref)
    (section . lyskom-help-format-section)
    (TEXT . lyskom-help-format-TEXT))
  )

(defun lyskom-help-get-section (section)
  (elt (assq section lyskom-help-data) 2))

(defun lyskom-help-show-section (section)
  "Format and insert section SECTION."
  (lyskom-do-help-format (lyskom-help-get-section section)))

(defun lyskom-do-help-format (data)
  "Format ant insert help data DATA."
  (let ((inhibit-read-only t))
    (cond ((symbolp (car data))
           (funcall (cdr (assq (car data) lyskom-help-format-handlers)) data))
          (t (lyskom-traverse el 
                 data
               (let ((tag (lyskom-help-data-get-tag el)))
                 (funcall (cdr (assq tag lyskom-help-format-handlers))
                          el)))))))

(defun lyskom-help-format-text-properties (data props)
  (let ((start (point-max-marker)))
    (set-marker-insertion-type start nil)
    (lyskom-traverse el (lyskom-help-data-get-data data)
      (lyskom-do-help-format el))
    (add-text-properties start (point-max) props)
    (set-marker start nil)))

(defun lyskom-help-format-section (section)
  "Format and insert section SECTION."
  (lyskom-do-help-format (lyskom-help-data-get-data section)))

(defun lyskom-help-format-h1 (data)
  (lyskom-insert "\n\n")
  (lyskom-help-format-text-properties data '(face lyskom-help-h1-face))
  (lyskom-insert "\n\n"))

(defun lyskom-help-format-h2 (data)
  (lyskom-insert "\n")
  (lyskom-help-format-text-properties data '(face lyskom-help-h2-face))
  (lyskom-insert "\n\n"))

(defun lyskom-help-format-h3 (data)
  (lyskom-help-format-text-properties data '(face lyskom-help-h3-face))
  (lyskom-insert "\n"))

(defun lyskom-help-format-i (data)
  (lyskom-help-format-text-properties data '(face italic)))

(defun lyskom-help-format-b (data)
  (lyskom-help-format-text-properties data '(face bold)))

(defun lyskom-help-format-TEXT (data)
  (lyskom-insert (cdr data)))

(defun lyskom-help-format-list (data)
  (lyskom-insert "\n")
  (when (lyskom-help-data-get-attr 'header data)
    (lyskom-insert (lyskom-help-data-get-attr 'header data))
    (lyskom-insert "\n"))
  (lyskom-do-help-format (lyskom-help-data-get-data data))
  (lyskom-insert "\n"))

(defun lyskom-help-format-item (data)
  (lyskom-insert "  * ")
  (lyskom-do-help-format (lyskom-help-data-get-data data))
  (lyskom-insert "\n"))

(defun lyskom-help-format-refer (data)
  (let* ((id (intern (lyskom-help-data-get-attr 'id data)))
         (section (lyskom-help-get-section id))
         (string (or (lyskom-help-data-get-attr 'prompt section)
                     (format "%s" id))))
    (lyskom-format-insert 
     "%#2@%#1s"
     string
     `(face underline
            mouse-face highlight
            lyskom-button t
            lyskom-button-text ""
            lyskom-button-type func
            lyskom-buffer ,(current-buffer)
            lyskom-button-arg (kom-help (,string . ,id)))))

)


(defun lyskom-help-format-cref (data)
  (let* ((command (intern (lyskom-help-data-get-attr 'id data)))
         (command-name (lyskom-get-string command 'lyskom-command))
         (keys (delq nil
                     (mapcar (lambda (x)
                               (if (and (arrayp x)
                                        (eq (elt x 0) 'menu-bar))
                                   nil
                                 x))
                             (where-is-internal command))))
         (heading (lyskom-format "%#1@%[%#2s%]%#3?b%[ (%#3s)%]%[%]"
                                 '(face italic)
                                 command-name
                                 (and keys 
                                      (mapconcat 'key-description
                                                 keys
                                                 "; ")))))
    (lyskom-insert heading)))

(defun lyskom-help-format-inline (data)
  (let* ((id (intern (lyskom-help-data-get-attr 'id data)))
         (section (lyskom-help-get-section id)))
    (cond (section (lyskom-do-help-format section))
          (t (lyskom-insert (format "[%S]" id))))))

(defun lyskom-help-format-p (data)
  (let ((start (point-max-marker)))
    (set-marker-insertion-type start nil)
    (lyskom-traverse el (lyskom-help-data-get-data data)
      (lyskom-do-help-format el))
      (save-excursion
        (save-restriction
          (narrow-to-region start (point-max))
          (goto-char (point-min))
          (while (re-search-forward "^\\s-+" nil t)
            (replace-match "" nil nil))
          (lyskom-fill-region (point-min) (point-max))))
      (lyskom-insert "\n\n")))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: english-strings.el,v 44.230 2002/09/07 21:35:22 ceder Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: english-strings.el
;;;;
;;;; This file contains all strings in the LysKOM elisp client.
;;;; Language:     English.
;;;; ================================================================
;;;;
;;;; Translation from swedish-strings.el: David Byers
;;;;

(require 'lyskom-vars "vars")
(require 'lyskom-language "language")

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
              "$Id: english-strings.el,v 44.230 2002/09/07 21:35:22 ceder Exp $"))


;;; ================================================================
;;; The language definition

(lyskom-define-language 'en
                        'iso-8859-1
                        "English"
                        "Engelska")


;;; ================================================================
;;; lyskom-edit-mode-map                             English version

(defvar lyskom-en-edit-mode-map nil)
(lyskom-language-keymap lyskom-edit-mode-map en lyskom-en-edit-mode-map)

;;; Set the keymap for lyskom-edit-mode

(defvar lyskom-en-edit-prefix nil)

(if lyskom-en-edit-mode-map
    nil
  (setq lyskom-en-edit-mode-map (make-sparse-keymap))
  (define-prefix-command 'lyskom-en-edit-prefix)
  (define-prefix-command 'lyskom-en-edit-review-prefix)
  (define-prefix-command 'lyskom-en-edit-insert-prefix)
  (define-prefix-command 'lyskom-en-edit-aux-prefix)
  (define-prefix-command 'lyskom-en-edit-add-prefix)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2 'button2up))) 'kom-button-click-or-yank)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2up 'button2))) 'kom-mouse-null)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-edit-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-edit-mode-map (kbd "*")     'kom-button-press-or-self-insert-command)
  (define-key lyskom-en-edit-mode-map (kbd "=")     'kom-menu-button-press-or-self-insert-command)
  (define-key lyskom-en-edit-mode-map (kbd "TAB")   'kom-edit-next-button-or-self-insert)
  (define-key lyskom-en-edit-mode-map (kbd "M-TAB") 'kom-edit-prev-button)
  (define-key lyskom-en-edit-mode-map (kbd "<S-tab>") 'kom-edit-prev-button)
  (define-key lyskom-en-edit-mode-map (kbd "C-c")	'lyskom-en-edit-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-x") 'lyskom-en-edit-aux-prefix)
  (define-key lyskom-en-edit-prefix (kbd "?")	'lyskom-help)
  (define-key lyskom-en-edit-prefix (kbd "C-r") 'lyskom-en-edit-review-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-i") 'lyskom-en-edit-insert-prefix)
  (define-key lyskom-en-edit-prefix (kbd "TAB") 'lyskom-en-edit-insert-prefix)
  (define-key lyskom-en-edit-prefix (kbd "*") 'kom-button-press)
  (define-key lyskom-en-edit-prefix (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-en-edit-prefix (kbd "C-c")	'kom-edit-send)
  (define-key lyskom-en-edit-prefix (kbd "C-s") 'kom-ispell-message)
  (define-key lyskom-en-edit-prefix (kbd "C-k")	'kom-edit-quit)
  (define-key lyskom-en-edit-prefix (kbd "r ?")	'lyskom-help)
  (define-key lyskom-en-edit-prefix (kbd "C-r C-c") 'kom-edit-show-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-i ?") 'lyskom-help)
  (define-key lyskom-en-edit-prefix (kbd "C-i C-c") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-y") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-i C-y") 'kom-edit-insert-commented)
  (define-key lyskom-en-edit-prefix (kbd "C-b")     'kom-edit-insert-buglist)
  (define-key lyskom-en-edit-prefix (kbd "C-i 1") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 2") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 3") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 4") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 5") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 6") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 7") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 8") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i 9") 'kom-edit-insert-digit-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i SPC") 'kom-edit-insert-text)
  (define-key lyskom-en-edit-prefix (kbd "C-i C-l") 'kom-edit-insert-link)
  (define-key lyskom-en-edit-prefix (kbd "C-a") 'lyskom-en-edit-add-prefix)
  (define-key lyskom-en-edit-prefix (kbd "C-a C-r") 'kom-edit-add-recipient)
  (define-key lyskom-en-edit-prefix (kbd "C-a C-c") 'kom-edit-add-copy)
  (define-key lyskom-en-edit-prefix (kbd "C-a <RET>") 'kom-edit-move-text)
  (define-key lyskom-en-edit-prefix (kbd "C-a C-x") 'kom-edit-add-cross-reference)
  (define-key lyskom-en-edit-prefix (kbd "C-x C-p") 'kom-edit-add-personal-comments)
  (define-key lyskom-en-edit-prefix (kbd "C-x C-n") 'kom-edit-add-no-comments)
  (define-key lyskom-en-edit-prefix (kbd "C-x C-r") 'kom-edit-add-read-confirm-request)
  (define-key lyskom-en-edit-prefix (kbd "C-a ?") 'lyskom-help))


;;(defvar lyskom-header-separator
;;  (substitute-command-keys
;;   "\\<lyskom-edit-mode-map>\
;;--- Write below. \
;;Post: \\[kom-edit-send], \
;;Kill: \\[kom-edit-quit], \
;;Help: \\[describe-mode] ---")
;;  "*String to separate headers from text body.")
;;
;;(defvar lyskom-swascii-header-separator nil
;;  "The swascii version of lyskom-header-separator.")
;;
;;(defvar lyskom-header-subject "Subject: "
;;  "*String to prompt for subject in the edit buffer.")
;;
;;
;;(defvar lyskom-swascii-header-subject nil
;;  "The swascii version of lyskom-header-subject.")

(lyskom-language-missing-string lyskom-message cgdag en)
(lyskom-language-missing-string lyskom-message sixjune en)
(lyskom-language-missing-string lyskom-message holdnose en)
(lyskom-language-missing-string lyskom-message 13dayxmas en)
(lyskom-language-missing-string lyskom-message 20dayxmas en)
(lyskom-language-missing-string lyskom-message kyndeldag en)
(lyskom-language-missing-string lyskom-message skottdag en)
(lyskom-language-missing-string lyskom-message intwomday en)
(lyskom-language-missing-string lyskom-message mariebdag en)
(lyskom-language-missing-string lyskom-message johannesddag en)
(lyskom-language-missing-string lyskom-message fnday en)
(lyskom-language-missing-string lyskom-message allhelgonadag en)
(lyskom-language-missing-string lyskom-message varnlosdag en)

(lyskom-language-ending-mismatch lyskom-message carbon-copy-prefix en sv)
(lyskom-language-ending-mismatch lyskom-message blank-carbon-copy-prefix en sv)
(lyskom-language-ending-mismatch lyskom-message newyeareve en sv)

;;; Formely known as lyskom-strings
(lyskom-language-strings local lyskom-message en 
  '(
    ; From vars.el: 
    ; From komtypes.el: nil
    ; From clienttypes.el: nil
    ; From startup.el:
    (server-q . "LysKOM server? (%#1s) ")
    (try-connect . "LysKOM elisp client version %#1s.\nAttempting to connect to %#2s.\n")
    (too-old-server . "The server is too old for this version of the client.")
    (connection-done . "Connection established. Server version is %#1s.\n\n")
    (what-is-your-name . "What is your name? ")
    (password . "Your password? ")
    (wrong-password . "Incorrect password.\n")
    (wrong-password-help . "
If you have forgotten your password you may be able to get a new one
by e-mailing the site administrators at one of the addresses listed
below:\n")
    (wrong-password-email . "* %#1t\n")
    (are-logged-in . "You have entered LysKOM. Please wait...\n")
    (you-have-motd . "\nYou have a notice on your mailbox:\n\n")
    (lyskom-motd-was-garbed . "\nThe login message does not exist!
The message that was supposed to be shown after login has disappeared.
Please contact the LysKOM administrator.\n")
    (presentation-encouragement .
"You have not written a presentation. Please write a presentation by using
the command Ap. If you do not want to write a presentations, please type fk.\n")

    (first-greeting . "%#1s
This appears to be the first time you use LysKOM. Welcome!
Please make sure you have spelled your name correctly. You should use your
full name and organisation, eg. \"Joe Hacker, MIT\". If your name is spelled
incorrectly, or you wish to change it, answer 'no' to the question below.

At present the LysKOM server stores most of the information so that
anybody can read it. Only passwords are encrypted.

If you are uncertain about how to use LysKOM, you can retrieve a manual by
anonymous ftp to ftp.lysator.liu.se. Ask your system administrator for help
on how to do this. You can also type \"?\" for the command \"Help\".
")

    (is-name-correct . "Is the name %#1s correct? ")
    (personal-password . "Enter a personal password: ")
    (repeat-password . "Repeat for confirmation: ")
    (repeat-failure . "The passwords were not the same.\n")

    (could-not-create-you .  "LysKOM couldn't create that user.\n")
    (presentation-subject . "%#1s")
    (presentation-form . "\
Name:      
Address:   
           
Telephone: 
E-mail:    
WWW:       

Other:     ")
    (presentation-help . "You are writing your presentation.\n")
    (not-present-anywhere . "Not in any conference.")
    (unknown-person . "Unknown user")
    (in-secret-conference . "Secret conference (%#1d).")
    (start-new-session-same-server
     . "You are already connected to that server. Do you want a new session? ")
    (new-session-in-buffer . "\n\n---- New session at %s ----\n\n")
    (warning-about-uncompiled-client . "
NOTE: The LysKOM client is not compiled. It is recommended to run a compiled
client for performance reasons. Read the accompanying README to learn how to
do that.
")

    ; From internal.el:
    (shaky-tcp . "At the moment I can't reach the server. The TCP/IP connection is shaky%#1s")
    (retrying-tcp . "Retrying.")

    ; From parse.el:
    (protocol-error . "protocol error: %s")

    ; From services.el:
    (interrupted . "Interrupted\n")

    ; From cache.el:
    ; No entries.

    ; From commands1.el:
    (appreciation . 
"You are a very special person, beautiful and wise, respected by
everybody around you. You are doing a splendid job. Many people love
you, body and soul. You make life easier for others. You are a very
warm and sensitive person.

Be proud of being You! You have a very good reason.\n\n")
    (abuse . 
"You are a nuisance, ugly and stupid, disrespected by everybody around
you. You are doing a worthless job. Many people hate you, body and
soul. You make life harder for others. You are a very cold and
unfeeling person.

Be ashamed of being You! You have a very good reason.\n\n")


    (what-conf-to-delete . "Conference/user to delete: ")
    (what-conf-to-change . "Conference to modify: ")
    (confirm-delete-pers-or-conf . "Really delete %#1s %#2s? ")
    (the-pers . "the user")
    (the-conf . "the conference")
    (deletion-not-confirmed . "Deletion aborted\n")
    (somebody-else-deleted-that-conf . "Somebody else just deleted the conference.\n")
    (conf-is-deleted . "OK, %#1s is now deleted.\n")
    (you-could-not-delete . "%#1M can't be deleted by you.\n")
    (you-have-deleted-yourself . "You have deleted yourself.\n")

    (what-text-to-delete . "Remove which text? ")
    (delete-marked-text . "The text is %#1s. Delete anyway? ")
    (delete-marked-by-you . "marked by you")
    (delete-marked-by-you-and-others . "marked by you and %#1?d%[someone else%]%[%#1d others%]")
    (delete-marked-by-several . "marked by %#1d user%#1?d%[%]%[s%]")
    (deleting-text . "Removing text %#1:n...")

    (presentation-for-whom . "Which conference/user? ")
    (text-to-see-author-of . "Review presentation of author of which text? ")
    (somebody-deleted-that-conf . "Somebody just deleted that conference.\n")
    (review-presentation-of . "Review presentation of %#1M.\n")
    (has-no-presentation . "%#1:M has no presentation.\n")

    (have-to-read . "You must read a text first.\n")

    (no-comment-to . "There is no commented text.\n")
    (no-text-at-point . "There is no text at point.\n")
    (what-ancestor . "Which of the commented texts do you want? ")

    (who-letter-to . "Send a letter to whom? ")
    (who-send-text-to . "Send text to which conference? ")
    (has-motd . "%#1P has a notice on his/her mailbox:\n\n")
    (motd-persist-q . "Send the letter? ")

    (who-to-add . "Whom do you want to add? ")
    (where-to-add . "To which conference? ")
    (where-to-add-self . "Join which conference? ")
    (priority-q . "Priority of your membership? (0 (low) - 255 (high)) ")
    (done . "done.\n")
    (cancelled . "cancelled.\n")
    (nope . "didn't work.\n")
    (add-already-member . "%#1P is already a member of %#2M.\n")

    (cant-find-supervisor . "Can't find supervisor of %#1M.\n")
    (is-read-protected-contact-supervisor . "%#1M is closed.
Send a letter to  %#2P to apply for membership.\n")

    (conf-does-not-exist . "\nThe conference doesn't exist.\n")

    (who-to-exclude . "Who do you want to remove? ")
    (where-from-exclude . "From which conference? ")

    (leave-what-conf . "Leave which conference? ")

    (error-fetching-person . "Error retrieving user.\n")
    (error-fetching-conf . "Error retrieving conference.\n")

    (name-of-conf . "Conference name? ")
    (anyone-member . "May anyone join? ")
    (secret-conf . "Secret conference? ")
    (comments-allowed . "Are comments allowed? ")
    (anonymous-allowed . "Are anonymous texts allowed? ")
    (secret-members-allowed . "Are secret members permitted? ")
    (what-comment-no . "Comment text number: ")
    (what-footnote-no . "Footnote text number: ")
    (what-private-no . "Private reply to text number: ")

    (quit-in-spite-of-unsent . "You have an unsent text. Do you really want to quit? ")
    (really-quit . "Do you really want to quit LysKOM? ")
    (session-ended . "
--------------------------------------------
  LysKOM session finished
  You are now disconnected from the server
--------------------------------------------
")
    (session-ended-long . "
-------------------------------------------------------------------------------
  LysKOM session finished
  You are now disconnected from the server
-------------------------------------------------------------------------------
")
    (session-auto-ended . "
============================================================
Disconnecting from LysKOM since all connections are in use
and you have finished reading. Please come back later.
============================================================\n\n")
    (session-auto-ended-long . "
===============================================================================
Disconnecting from LysKOM since all connections are in use
and you have finished reading. Please come back later.
===============================================================================
\n")
    (what-to-change-pres-you . "Change presentation of whom/what (yourself): ")
    (what-to-change-faq-you . "Change FAQ for which conference: ")
    (who-to-put-motd-for . "Post notice on whom/what (yourself): ")

    (what-to-set-pres-you . "Set presentation for whom/what (yourself): ")
    (what-text-to-set-as-pres-no . "Which text do you want as the new presentation: ")
    (what-to-set-motd-you . "Set notice on whom/what (yourself): ")
    (what-text-to-set-as-motd-no . "Which text do you want as the new notice: ")
    (conf-already-has-pres . "The conference/person already has a presentation. Continue anyway? ")
    (conf-already-has-motd . "The conference/person already has a notice. Continue anyway? ")
    (setting-conf-pres . "Setting presentation of %#1M to text %#2n...")
    (setting-conf-motd . "Setting notice for %#1M to text %#2n...")

    (who-to-remove-pres-for . "Vilket mte/person vill du ta bort presentationen frn (dig sjlv): ")
    (removing-pres-for-conf . "Tar bort presentation (text %#2n) frn %#1M...")

    (cant-get-conf-stat . "Cannot get the status of that conference.\n")
    (go-to-conf-p . "Go to conference: ")
    (want-become-member . "Do you want to join? ")
    (no-ok . "Okiedokie, whatever you say.\n")

    (who-to-remove-motd-for . "Remove notice from whom/what: ")

    (conf-all-read . "no unread texts")
    (no-in-conf . "You are not present in any conference.\n")

    (search-for-pers . "Enter search key (RETURN for all users): ")
    (search-for-conf . "Enter search key (RETURN for all conferences): ")
    (search-re . "Enter search regexp: ")
    (include-persons . "Search among persons? ")
    (include-conferences . "Search among conferences? ")

    (no-matching-confs . "No conferences match \"%#1s\".\n")
    (no-matching-perss . "No persons match \"%#1s\".\n")
    (no-matching-anys . "No persons or conferences match \"%#1s\".\n")
    (no-confs-exist . "There are no conferences in the database.\n")
    (no-pers-confs-exist . "There are no persons or conferences in the database.\n")
    (list-confs-created-by . "List owned conferences for: ")
    (listing-confs-created-by . "Listing owned conferences for %#1P\
    C=Created, O=Supervisor, S=Letterbox is super conf; S=Secret, P=Protected\n")
    (list-pers-confs-created-by . "List owned conferences and persons for: ")
    (getting-all-confs . "Retrieving a list of all conferences from the server...")
    (getting-all-pers-confs . "Retrieving a list of all persons and conferences from the server...")
    (getting-all-confs-done . "Retrieving a list of all conferences from the server...done")
    (getting-all-pers-confs-done . "Retrieving a list of all persons and conferences from the server...done")
    (finding-created-confs . "Finding owned conferences (%#1d of %#2d done)")
    (finding-created-pers-confs . "Finding owned persons and conferences (%#1d of %#2d done)")
    (no-created-confs . "%#1P is not creator, supervisor or super conference for any conference.\n")

    (name-to-be-changed . "Name to change: ")
    (no-such-conf-or-pers . "The conference or user doesn't exist.\n")
    (new-name . "New name: ")
    (new-paren . "New parenthesis: ")
    (no-paren-in-name . "The name doesn't contain a parenthesis.\n")
    (who-to-change-supervisor-for . "Change supervisor of whom/what? ")
    (new-supervisor . "New supervisor: ")
    (text-to-mark . "Mark which text? ")
    (text-to-unmark . "Unmark which text? ")
    (what-mark . "Set which mark type (name or 0-255)? ")
    (erroneous-mark . "Erroneous mark type.\n")
    (want-to-create-symbolic-mark . "The mark type \"%#1s\" does not exist. Do you want to create it? ")
    (creating-symbolic-mark-type . "Creating mark type \"%#1s\" (%#2d).\n")
    (no-mark-types-left . "Sorry, there are no free mark types. Remove an old one first.")
    (unmarking-textno . "Unmarking text %#1n...")
    (marking-textno . "Marking text %#1n...")
    (list-which-mark . "List texts with which mark type (name or 0-255, RET for all)? ")

    (new-passwd-again . "Repeat the new password for confirmation: ")
    (what-mark-to-view . "Review which mark type (name or 0-255, RET for all)? ")
    (whos-passwd . "Change password for whom? (yourself) ")
    (old-passwd . "Your current password: ")
    (new-passwd . "The new password: ")
    (changing-passwd . "Changing password...")
    (retype-dont-match . "You didn't reenter the same passwrod. Try again.\n")
    (palindrome . " (a palindrome!)")
    (lyskom-name . "User")
    (is-in-conf . "In conference")
    (from-machine . "At")
    (is-doing . "Activity")
    (connection-time . "Connected")
    (active-last . "Active last")
    (active . "Active")
    (lyskom-client . "Client")
    (text-to-add-recipient . "Add recipient to which text:")
    (text-to-add-copy . "Add recipient of carbon copy to which text:")
    (text-to-add-bcc . "Add recipient of blind carbon copy to which text:")
    (text-to-delete-recipient . "Remove recipient from which text:")
    (text-to-move . "Which text do you want to move:")
    (text-tree-to-move . "Which text is the root of the tree you want to move:")

    (text-to-add-comment-to . "Add comment to which text:")
    (text-to-delete-comment-from . "Remove comment from which text:")
    (text-to-add-footnote-to . "Add footnote to which text:")
    (text-to-delete-footnote-from . "Remove footnote from which text:")
    (text-to-add-cross-reference-to . "Add cross reference to which text:")
    (text-has-no-recipients-r . "Text %#1n has no recipients\n")

    (where-on-list-q . "Placement in your list? (0-%#1d) ")
    (member-in-conf . "Joining to %#1M...")
    (add-member-in . "Adding %#1P as a member of %#2M...")
    (change-priority-for-q . "Change priority of conference: ")
    (change-priority-for . "Changing priority of %#2M...")
    (unsubscribe-to . "Leaving %#1M...")
    (passivate-done . "You are now a passive member of %#1M.
Leave the conference again to unsubscribe completely.\n")

    (exclude-from . "Removing %#1P from %#2M...")

    (unsubscribe-failed . "\nDidn't work. Perhaps %#1P isn't a member of %#2M?\n")

    (You . "You")
    (could-not-create-conf . "Couldn't create the conference \"%#1s\".\n")
    (created-conf-no-name . "Conference number %[%#3@%#1:m %#2:M%] has been created.\n")
    (cant-read-textno . "You are not allowed to read text %#1:n.\n")

    (not-supervisor-for . "You are not the supervisor of %#1M.\n")
    (not-supervisor-for-server . "You do not have administrative rights on this LysKOM-server.\n")
    (go-to-conf . "Go to conference %#1M.\n")
    (cant-go-to-his-mailbox . "You are not allowed to go to %#1M's mailbox.\n")
    (not-member-of-conf . "You are not a member of %#1M.\n")
    (about-to-change-name-from . "%#1M\n")
    (change-name-done . "Done. New name: %[%#2@%#1:M%].\n")
    (change-name-nope . "Couldn't change name to %#1s. Error code %#3d. %#2s.\n")
    (change-supervisor-from-to . "Change supervisor of %#1M to %#2P...")
    (change-supervisor-nope . 
     "\nDidn't work. Perhaps you are not allowed to change the supervisor of %#1M?\n")
    
    (no-marked-texts . "You have not marked any texts.\n")
    (no-marked-texts-mark . 
     "You have not marked any texts with mark type \"%#1s\".\n")

    (weekdays . ["Sunday" "Monday" "Tuesday" "Wednesday" "Thursday"
		 "Friday" "Saturday" "Sunday"])
    (weekdays-short . ["Sun" "Mon" "Tue" "Wed" "Thu" "Fri" "Sat" "Sun"])
    (time-is . "The time is %#1s%#2s (according to the server).")
    (time-is-week . "The time is %#1s%#2s, week %#3d (according to the server).")

    (xmaseve . "Christmas eve!\nYou didn't open any gifts early, did you?")
    (xmasday . "Christmas day.\nDid you get any nice gifts this year?")
    (newyearday . "\nMay %#1d be a prosperous and good year for you!")
    (newyeareve . "Happy New Year!")
    (newyearevelate . "Less than an hour left of %#1d...")
    (lysbday . "
On this day, in 1973, the Lysator Academic Computer Society was
formed, and it was a great day in the history of computing in Sweden.
Read all about it at http://www.lysator.liu.se/history/")

    (total-users . "    A total of %#1d users (%#2s).\n")
    (total-users-sans-date . "    A total of %#1d users\n")
    (total-visible-users . "    A total of %#1d visible user%#1?d%[%]%[s%] (%#2s).\n")
    (total-active-users . "    A total of %#1d active user%#1?d%[%]%[s%] (%#2s).\n")
    (total-visible-active-users
     . "    A total of %#1d visible%#1?d%[%]%[%] active user%#1?d%[%]%[s%] (%#2s).\n")
    (client-statistics . "    Distribution of clients:\n")
    (client-statistics-line . "    %4#2d %#1s")
    (who-to-add-q . "Add whom/what as a recipient? ")
    (who-to-add-copy-q . "Add which conference/user as carbon copy recipient? ")
    (who-to-add-bcc-q . "Add which conference/user as blind carbon copy recipient? ")
    (really-add-as-recpt-q . "Send future comments to the text to %#1M too? ") 
    (who-to-sub-q . "Remove whom/what as a recipient? ")
    (who-to-move-from-q . "Move from where? ")
    (who-to-move-to-q . "Move to where? ")
    (who-to-move-to-or-sub-q . "Move to where (empty to just remove recipient)? ")

    (adding-name-as-recipient . "Adding %#1M as recipient of text %#2n...")
    (adding-name-as-copy . "%#1M will receive a carbon copy of text %#2n...")
    (remove-name-as-recipient .
     "Removing %#1M as recipient of text %#2n...")
    (adding-cross-reference . "Adding cross reference...")

    (error-recipient-limit . "Text %#1n has too many recipients.\n")
    (error-already-recipient . "%#2M is already a recipient of text %#1n.\n")
    (error-permission-denied-add-recpt . "Only the author of %#1n or supervisor for %#2M can change recipient types.\n")
    (error-permission-denied-sub-recpt . "Only the author of %#1n or supervisor for %#2M can remove the recipient.\n")
    (error-access-denied-add-recpt . "You are not allowed to add texts to %#2M.\n")
    (error-not-recipient . "%#2M is not a recipient of text %#1n.\n")

    (moving-tree-what-action-q . "What do you want to do? (flytta) ")
    (moving-name . "Moving text %#3n from %#1M to %#2M...")
    (moving-already-moved . "Text %#1n does not have %#2M as a mottagare.\nSkipping this text and its comments.\n")
    (text-to-add-q . "Add which text as a comment to %#1n? ")
    (text-to-remove-q . "Remove which text as a comment from %#1n? ")
    (text-to-add-footn-q . "Add which text as a footnote to %#1n? ")
    (text-to-remove-footn-q . "Remove which text as a footnote from %#1n? ")
    (add-comment-to . "Adding text %#1n as a comment to text %#2n...")
    (sub-comment-to . "Removing text %#1n as a comment to text %#2n...")
    (add-footnote-to . "Adding text %#1n as a footnote to text %#2n...")
    (sub-footnote-to . "Removing text %#1n as a footnote to text %#2n...")
    (comment-keep-recpt-p ."Should %#1s remain a recipient? ")
    (comment-all-relevant-p . "There are multiple recipients. Are they all relevant? ")
    (please-edit-recipients . "Modify the recipient list and send the text again.")
    (add-recipient-p . "Add recipient%#2?b%[ %#2M to reach%]%[%] %#1P? ")
    (checking-rcpt . "Checking recipients...")
    (checking-rcpt-done . "Checking recipients...done")
    (checking-comments . "Checking commented texts...")
    (checking-comments-done . "Checking commented texts...done")
    (please-check-commented-texts . "Review the commented text and its comments.")
    (have-unread-comment . "Send despite unread comments to text %#1n? ")
    (duplicate-recipients . "Unable to post. A recipient is duplicated (%#1M)")
    (no-recipients . "Unable to post text. No recipients were specified.")

    (matching-regexp . "Conferences/users matching `%#1s'\n")
    (matching-regexp-perss . "Users matching `%#1s'\n")
    (matching-regexp-confs . "Conferences matching `%#1s'\n")

    (who-is-active-all . "Showing all sessions.\n")
    (who-is-active-last-minutes . "Showing all sessions active the last %#1d minutes.\n")
    (showing-invisibles . "Showing invisible sessions.\n")
    (null-who-info . "No one (active) is logged on.\n")

    (no-other-lyskom-r . "There are no other active LysKOM sessions.\n")
    (no-lyskom-session . "There are no active LysKOM sessions.")
    (no-other-unread-lyskom-r . "There is no another LysKOM session with unread texts.\n")
    (no-unread-lyskom-r . "There is no active LysKOM session with unread texts.\n")
    (no-unread-lyskom . "There is no active LysKOM session with unread texts.")

    (who-is-on-in-what-conference . "Who in which conference: ")
    (who-is-present-in-what-conference . "Who present in which conference: ")
    (who-is-friend . "Only friends are shown.\n")
    (who-is-active-and-member . "Only members in %#1M are shown.\n")
    (who-is-active-and-present . "Only members present in %#1M are shown.\n")

    (personal-comment-to-anonymous . "It is not possible to write a personal comment to an anonymous text.\n")

    ;; Used for kom-is-person-member-of-conference:
    (pers-to-check-mship-for . "Whose membership do you want to check? ") ;-)
    (conf-to-check-mship-of . "...for what conference? ")
    (conf-is-empty . "The conference %#1M is empty.\n")
    (pers-is-member-of-conf . "Yes, %#1P is a member of the conference %#2M.\n")
    (pers-is-passive-member-of-conf . "Well, %#1P is only a passive member of the conference %#2M.\n")
    (pers-is-not-member-of-conf . "No, %#1P is not a member of the conference %#2M.\n")

    ; From commands2.el:

    (your-memberships . "Your LysKOM conference memberships:\n")
    (memberships-header . "Last access	   Prio	Unread	Conference\n")
    (memberships-line . "%16#1s  %#2d\t%#3d\t%#4M\n")
    
    (conf-for-status . "Get status of which conference? ")
    (no-such-conf . "The conference doesn't exist.\n")
    (status-record . "Status of conference %#1M (%#1m) %#2s\n\n")
    (change-type-prompt . "Change conference type for %#1M (%#1m) (%#2s)...")
    (Mailbox . "Mailbox")
    (Protected . "Protected")
    (no-comments . "No comments")
    (closed . "Closed")
    (allow-anon . "anonymomus ok")
    (allow-secret . "secret members")
                   
    (created-by . "Created by person %24#1p %#3s(%#2P)\n")
    (created-at . "Created:%34#1s\n")
    (members .    "Number of members: %19#1d\n")
    (conf-allows-secret-members . "Secret members:                          %#1s\n")
    (conf-allows-anon-texts .     "Anonymous texts:                         %#1s\n")
    (anon-texts-permitted . "Anonymous texts are permitted")
    (anon-texts-not-permitted . "Anonymous texts are not permitted")
    (secret-members-permitted . "Secret members are permitted")
    (secret-members-not-permitted . "Secret members are not permitted")
    (garb-nice . "Expiration time (in days):%16#1d\n")
    (lowest-local-no . "Lowest local number: %21#1d\n")
    (highest-local-no . "Highest local number: %20#1d\n")
    (last-text-time . 
     "Time of last text:    %20#1s (according to your cache)\n")
    (no-of-motd . "Notice in text:    %13#1n\n")
    (superconf-is-no-name . "Superconference: %25#1m %#3s(%#2M)\n")
    (permitted-submitters-no-name . "Allowed authors: %25#1m %#3s(%#2M)\n")
    (supervisor-is-no-name . "Supervisor: %30#1p %#3s(%#2P)\n")
    (presentation-no . "Presentation:    %25#1n\n")
    (conf-has-motd . "\n%#1M has a notice on his/her mailbox:\n")
    (conf-mship-priority . "Prioritet:       %25#1n%#2?b%[ %#2s%]%[%]\n")
    (status-conf-generic . "%-40#1s %#2s\n")
    (status-aux-item . "Unknown auxiliary information: %11#1s%#3s (skapad av %#2M)\n")
    (conf-mx-list-name . "Imported mailing list:                   %#1s %#2s\n")
    (recommended-conf-aux . "Recommended conference:                  %#1M <%#1m> %#2s\n")
    (status-read-faq-aux-item . "Read FAQ:                  %15#2n for %#1?z%[%#1M <%#1m>%]%[the server%] %#3s\n")
    (status-rejected-recommendation-aux-item . "Rejected recommendation for:             %#1M %#2s\n")
    (status-send-comments-to . "Redirect comments to:                    %#1M <%#1m> %#2s\n")

    (Everybody . "Everyone")
    (show-members-list-also-q . "List members? ")
    (show-membership-info-q . "Show number of unreads? ")
    (conf-has-these-members . "\n%#1M has the following members:\n")
    (conf-has-no-members . "\n%#1M has no members.\n")
    (member-list-header . "Last entered        Unread  Name\n\n")
    (secret-membership . "--- Secret line ---\n")
    (conf-membership-line . "%#1s%#2M %#3s\n")
    (conf-membership-line-2 . "                            Added %#1s by %#2P\n")
    (pers-for-status . "Get status of which user? ")
    (text-to-see-author-status-of . "Get status of the author of which text? ")
    (no-such-pers . "The user doesn't exist.\n")
    (pers-status-record . "Status of user %#1P (%#1p)\n")
    (created-time .  "Created:%34#1s\n\n")
    (created-confs . "Conferences created:%22#1d\n")
    (created-persons . "Users created:%28#1d\n")
    (created-texts . "Texts created:%28#1d\n")
    (created-lines . "Lines created:%28#1d\n")
    (created-chars . "Characters created:%23#1d\n")
    (no-of-sessions . "Session count:%28#1d\n")
    (present-time-d-h-m-s . "Total presence:%16#1d d %02#2d:%02#3d:%02#4d\n")
    (last-log-in . "Last login or logout:%21#1s\n")
    (user-name . "User: %36#1s\n")

    (read-texts . "Texts read:%31#1d\n")
    (marked-texts . "Texts marked:%29#1d\n")
    (time-for-last-letter . "Time of last letter:%22#1s (according to your cache)\n")
    (superconf . "Superconference: %25#1m %#3s(%#2M)\n")
    (supervisor . "Supervisor: %30#1p %#3s(%#2P)\n")
    (member-of-confs . "Member of (conferences):%18#1d\n")
    (presentation . "Presentation:    %25#1n\n")
    (show-membership-list-also-q . "List memberships? ")
    (not-allowed-see-confs . "%#1P is not a member of any conferences.\n")
    (is-member-of . "\n%#1P is a member of the following conferences:\n")
    (membership-list-header . "Last access          Unread  Conference\n\n")
    (pers-membership-line . "%#1s%#2s%#3M %#4s\n")
    (pers-membership-line-2 . "                             Added %#1s by %#2P\n")
    (is-supervisor-mark . "O ")
    (who-to-send-message-to . "Send message to whom? (%s) ")
    (send-empty-message-p . "The message is empty. Send it anyway? ")
    (his-total-unread . "\n%#1M has a total of %#2d unread texts.\n")
    (message-prompt . "Message: ")
    (message-sent-to-user . "\
%[%#3$================================================================
%]%[%#4$Your message for %#2M:

%#1t
%]%[%#3$----------------------------------------------------------------
%]")
    (message-sent-to-all . "\
%[%#3$================================================================
%]%[%#4$Your public message

%#1t
%]%[%#3$----------------------------------------------------------------
%]")
    (message-sent-to-user-long . "\
%[%#3$\
===============================================================================
%]%[%#4$Your message for %#2M:

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-sent-to-all-long . "\
%[%#3$\
===============================================================================
%]%[%#4$Your public message

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-use-alarm-instead . "Use %#1s to send alarm messages.\n")
    (message-all-info . "Send alarm\n")
    (message-recipient-info . "Send message to %#1M\n")
    (message-nope .
     "Unable to send the message. Perhaps the recipient isn't logged on.
The message you were sending to %#1M was:
%#2t\n")
    (only-last . "Last (0 - %#1d) texts in %#2s: ")
    (only-error . "Something went wrong. Sorry.\n")
    
    (you-have-unreads . "You have %#1d unread text%#1?d%[%]%[s%] in %#2M\n")
    (you-have-unreads-special . "You have %#1d uncommented text%#1?d%[%]%[s%] in %#2M\n")
    (you-have-no-unreads . "You have read everything in %#1M\n")
    (you-have-read-everything . "No news (is bad news).\n")
    (no-unreads-shown . "Found no conferences meeting that criterion.\n")
    (total-unreads .
     "You have %#1d unread text%#1?d%[%]%[s%] texts in %#2d conference%#2?d%[%]%[s%].\n")
    (shown-unreads . "Showed %#1d unread text%#1?d%[%]%[s%] in %#2d conference%#2?d%[%]%[s%].\n")
    (list-unread-with-n-unread . "Listing conferences with at least %#1d unread.\n")
    (list-unread-with-at-most-n-unread . "Listing conferences with at most %#1d unread.\n")
    (waiting-for-anything .
     "You are waiting for a text in any conference.\n")
    (waiting-higher-than . 
     "You are waiting for a text in any conference with a priority higher than %#1d.\n")
    
    (have-to-be-in-conf-with-unread . "You must go to a non-empty conference first.\n")
    (Texts . "Text")
    (Written . "Written")
    (Lines . "Lines")
    (Author . "Author")
    (Subject . "Subject")
    (mark-type . "Type")

    (could-not-read . "You couldn't read the text (%#1n).\n")
    (multiple-choice . "There are several alternatives.")

    (does-not-exist . "Unknown command.") ; Only people fixing bugs or receiving bug reports should change these:
    (summary-line . "%=-8#1n%#2s%4#3d  %[%#4@%#5:P%]  %[%#6@%#7r%]\n")
    (diff-what-text-old . "Old text to compare: ")
    (diff-what-text-new . "New text to compare: ")

    ; Only people fixing bugs or receiving bug reports should change these:
    (buggreport-compilestart . "Creating bug report...")
    (buggreport-compileend . "Creating bug report...done")
    (buggreport-description . "This is what I was doing:
\(Fill in your comments below\)\n================\n\n
================
In the information below are the 100 most recently pressed keys from
your emacs. If you recently logged on, you password may be contained in
this list. If that is the case, change the characters corresponding to
your password to asterisks.

When you have finished writing this, send your bug report to the LysKOM
developers. You can do this either by email to bug-lyskom@lysator.liu.se or
by mailing a hardcopy of your bug report to:
Lysator, c/0 ISY, Linkoping Univerity, S-581 83 Linkoping, SWEDEN.
Mark the envelope with \"LysKOM bug report\"\n\n")
    (buggreport-internals . "LysKOM's internal information:\n\n")
    (buggreport-version . "lyskom-version:")
    (buggreport-emacs-version . "emacs-version:")
    (buggreport-system-id . "system-id:")
    (buggreport-ctl-arrow-doc . "ctrl-doc:")
    (buggreport-unparsed . "\nlyskom-unparsed-buffer:")
    (buggreport-command-keys . "Recently pressed keys:")
    (buggreport-backtrace . "\n*Backtrace*:\n%#1s\n")
    (buggreport-communications . "\nlyskom-debug-communications-to-buffer-buffer:")
    (buggreport-all-kom-variables . "\n\nOther variables:\n***** *********")
    (buggreport-instead-of-byte-comp . "byte-code(\"byte-string\"")
    (buggreport-subject . "Bugreport elisp-client version %#1s")


    (not-logged-in . "You are not logged on. ")
    (name-is-not-in-conf . "%#1s is not in any conference.\n")
    (name-is-in-conf . "%#1s is in\n%#2s\n")
    (connected-during . "Connect time: %#1d seconds.\n")

    (conf-to-set-permitted-submitters-q . "For which conference do you want to set the allowed authors? ")
    (conf-to-set-super-conf-q . "Set superconference of which conference? ")
    (new-super-conf-q . "Which conference do you want as superconference? ")
    (new-permitted-submitters-q . "Allow members of which conference as authors in %#1s? (all) ")
    (super-conf-for-is . "Changing superconference of %#1M to %#2M...")
    (permitted-submitters-removed-for-conf . "Allowing all authors to conference %#1M...")
    (submitters-conf-for-is . "Changing authors admitted to conference %#1M to the members of %#2M...") 
   
    (conf-to-set-garb-nice-q . "Set expiration time for which conference? ")
    (new-garb-nice-q . "After how many days shall texts be removed? ")
    (garb-nice-for-is . "Changing expiration for %#1M to %#2d...")

    (really-shutdown . "Are you sure you want to shut down the server? ")
    (closing-server . "Shutting down the server...")
    (really-sync . "Are you sure you want to save the database? ")
    (syncing-server . "Saving the database...")
    (administrator . "administrator")
    (no-longer-administrator . "a regular user again")
    (you-are-now . "Ok, you are now running as %#1s.\n")
    (setting-motd . "Changing login message to text %#1n.\n")
    (set-motd-success . "You have set a new login message.\n")
    (set-motd-failed . "Didn't work. Perhaps you were not an administrator.\n")
    (removing-motd . "Removing the login message.\n")
    (removed-motd . "You have removed the login message.\n")
    (who-to-throw-out . "Who's session do you want to kill? ")
    (throwing-out . "Killing session %#1d... ")
    (postpone-prompt . "How much do you want to read now? ")
    (set-session-priority . "Set reading level: ")

    ; From review.el:
    (no-review-done . "You need to review something before you can review more.\n")
    (not-reviewing . "You are currently not reviewing anything.\n")
    (review-how-many . "Review how many?")
    (review-how-many-more . "Review how many more?")
    (latest-n . "last %#1d")
    (first-n . "first %#1d")
    (info-by-whom . "%#1s by whom: ")
    (info-to-conf . "%#1s to conference: ")
    (info-by-to . "%#1s by %#2P to %#3M forward.")
    (all-confs . "all conferences")
    (no-get-conf . "You are not allowed to access that conference.\n")
    (no-get-pers . "You are not allowed to access that user.\n")
    (no-review-info . "You are not allowed to review %#1s\n")
    (review-info . "Review %#1s")
    (review-info-by-to . "Review %#1s by %#2P to %#3M forwards.\n")
    (review-more-info-by-to . "Review %#1s by %#2P to %#3M forwards.\n")
    (review-rest . "the rest")
    (review-more . "%#1d more")
    (you-review . "You are now reviewing %#1s.\n")
    (read-text-first . "You must read a text first.\n")
    (cannot-read-last-text . "You cannot review the last read text.\n")
    (review-n-texts . "Review %#1d texts.\n")
    (review-marked . "Review %#1d marked texts.\n")
    (review-text-no . "Review text %#1n\n")
    (review-many-comments . "Review %#2?d%[one%]%[%#2d%] comment%#2?d%[%]%[s%] to text %#1n.\n")
    (view-many-comments . "Read %#2?d%[one%]%[%#2d%] comment%#2?d%[%]%[s%] to %#1n.\n")
    (view-texts-in-conf . "Grand total of %#1d texts to read in %#2M.\n")

    (not-reading-anywhere . "You are not reading in any conference.\n")
    (read-normally-read . "How many texts to you want to read again? ")

    (review-conf-gone . "The conference does not exist.\n")
    (review-pers-gone . "The user does not exist.\n")
    (review-cant-read-conf . "You can't review texts to a closed conference you are not a member of.\n")
    (review-cant-read-letterbox . "You can't review texts to somebody else's mailbox.\n")
    (review-cant-read-empty . "The conference is empty.\n")
    (cant-review-everything . "You cannot review every text in LysKOM.\n")

    (more-than-one-root . "Text %#1n has more than one root.\n")
    (more-than-one-root-review . "\
Text %#1n has more than one root but only one of the trees will be shown.\n")

    ; From edit-text.el:
    (press-C-c-C-c . "Enter C-c C-c to post the text.")
    (recipient . "Recipient")
    (recipient-prefix . "[Rr]")
    (carbon-copy . "Carbon copy")
    (blank-carbon-copy . "Blind Carbon copy")
    (carbon-copy-prefix . "[Cc]\\([Aa]\\|[Cc]\\)")
    (blank-carbon-copy-prefix . "[Bb]\\([Ll]\\|[Cc][Cc]\\)")
    (add-recipient . "Add a recipient")
    (add-recipient-or-xref . "Add...")

    (secret-aux-flag . "secret")
    (anonymous-aux-flag . "anonymous")
    (inherit-aux-flag  . "inherited")
    (aux-item-prefix . "[*]")
    (aux-item-prefix-regexp . "\\[\\*\\]\\s-*")
    (comment-item-prefix . "#\\s-*")
    (text-no-comment . "%#1d %#2s /%#3d line%#3?d%[%]%[s%]/ %#4P %#5?b%[ [anonymous]%]%[%]\n")
    (cant-fcc-text-file-error . "Unable to save text %#1n to \"%#2s\" (%#3s: %#4s).\n")
    (cant-fcc-text . "Unable to save text %#1n to \"%#2s\" (%#3s).\n")

    (header-subject . "Subject: ")
    (header-separator . "\\<lyskom-edit-mode-map>\
--- Write below. \
Post: \\[kom-edit-send], \
Kill: \\[kom-edit-quit], \
Help: \\[describe-mode] ---")
    (text-mass . "%#4s%#1s\n%#2s\n%#3s")
    (comment-to-by . "%#1s to text %#2n%#3s.\n")
    (already-sent . "You have already posted this text. Post it anyway? ")
    (subject . "Subject: ")
    (subject-prefix . "[Ss]")
    (enter-subject-idi . "Enter a subject.")
    (which-text-include . "Include which text? ")
    (added-recipient . "Recipient: ")
    (added-carbon-copy . "Carbon copy to conference: ")
    (added-blank-carbon-copy . "Blind carbon copy to conference: ")
    (text-to-comment-q . "Which text do you want to comment? ")
    (conf-has-motd-no . "The conference has a notice. (%#1d)\n\n%#2s")
    (still-want-to-add . "Do you still want to add the conference as a recipient? ")
    (could-not-create-text . "\nCouldn't create the text. Error: %#2s.\n")
    (no-get-text . "You were not allowed to retrieve the text.")
    (unknown-header . "Unknown header")
    (transform-error . "Send unformatted (%#1s)? ")
    (cant-find-info-node . "Can't find the info buffer")

    (link-type . "What to you want to link to (text, conference or person)? ")
    (which-text-to-link . "Add link to text: ")
    (which-text-to-link-err . "Text not found. Add link to text: ")
    (which-pers-to-link . "Add link to user: ")
    (which-conf-to-link . "Add link to conference: ")

    ; From view-text.el:
    (view-text-first-line . "%#7$%#2@%#1n %#3s /%#4d line%#4?d%[%]%[s%]/ %#5P%#6?b%[%#6s%]%[%]\n")

    (marked-by-you . "Marked by you (type: %#1s).\n")
    (marked-by-you-and-others . "Marked by you (type: %#2s) and %#1?d%[someone else%]%[%#1d others%].\n")
    (marked-by-several . "Marked by %#1d user%#1?d%[%]%[s%].\n")

    (timeformat-day-yyyy-mm-dd-hh-mm-ss . "%#7s %4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm-ss . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d")
    (timeformat-yyyy-mm-dd . "%4#1d-%02#2d-%02#3d")
    (timeformat-hh-mm-ss . "%02#4d:%02#5d:%02#6d")
    (timeformat-hh-mm . "%02#4d:%02#5d")

    (format-time-date-and-time . "%#1s %#2s")
    (format-time-just-date . "%#1s")
    (format-time-just-time . "%#2s")
    (today . "today")
    (yesterday . "yesterday")

    (no-such-text-no . "The text doesn't exist. (%#1:n)\n")
    (text-created-at . "Created: %#1s\n")
    (text-imported-at . "Imported: %#1s\n")
    (text-imported-at-by . "Imported: %#1s by %#2P\n")

    (head-Subject . "Subject: ")
    (Recipient . "Recipient")
    (Extra-recipient . "CC")
    (Hidden-recipient . "BCC")
    (mx-Recipient . "External recipient")
    (mx-Extra-recipient . "External CC")
    (mx-Extern-reply-to . "External replies to")
    (Strange-recipient . "Also to")
    (send-at . "   Posted:     %#1s\n")
    (sent-by . "   Posted by %#1P\n")
    (received-at . "    Received: %#1s\n")

    (comment-to-text . "Comment to text %#1n")
    (footnote-to-text . "Footnote to text %#1n")
    (comment-in-text . "Comment in text %#1n")
    (footnote-in-text . "Footnote in text %#1n")

    (attachment-to-text . "Attachment %#3sto text %#1n")
    (attachment-in-text . "Attachment %#3sin text %#1n")
    
    (envelope-sender . "Sent by: %#1s\n")
    (attachment-filename . "Attachment file name: \"%#1s\"\n")

    (comment-to-text-by . "Comment to text %#1n by %#2P")
    (footnote-to-text-by . "Footnote to text %#1n by %#2P")
    (comment-in-text-by . "Footnote in text %#1n by %#2P")
    (footnote-in-text-by . "Footnote in text %#1n by %#2P")

    (written-by . " by %#1P\n")

    ; From async.el:

    (name-has-changed-to-name . "%#1:P has changed name to %#2:P")
    (name-has-changed-to-name-r . "%[%#3@%#1:P%] has changed name to %[%#3@%#2:P%]\n")
    (you-changed-name-to . "You have now changed your name to %[%#2@%#1:P%].\n")
    (database-sync . "Synching database.")

    (lyskom-is-full . "\
===========================================================
Message from the LysKOM system: Somebody tried to connect,
but failed since all connections available to LysKOM are in
use. Please leave and return later if you are just waiting
for a text.
===========================================================\n")
    (lyskom-is-full-long . "\
===============================================================================
Message from the LysKOM system: Somebody tried to connect,
but failed since all connections available to LysKOM are in
use. Please leave and return later if you are just waiting
for a text.
===============================================================================
")
    (has-entered . "%#1:P has entered %#2s.")
    (has-entered-r . "%#2@%#1P has entered %#3s.\n")
    (has-left . "%#1:P has left %#2s.")
    (has-left-r . "%#2@%#1P has left %#3s.\n")
    (Unknown . "Unknown")
    (unknown . "unknown")
    (Unknown2 . "Unknown")

    (no-longer-member . "You are no longer a member of %#1M.\n")
    (no-longer-member-n . "You are no longer a member of %#1m (conference is gone).\n")
    (have-become-member . "You have become a member of %#1M.\n")
    (have-become-invited-member . "You have been invited to %#1M.
Go to the conference to accept or decline the invitation. You can also use
the command 'Join conference' to accept the invitation.\n")
    (have-become-passive-member . "You have become a passive member of %#1M.\n")


    (message-broadcast . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Alarm from %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-broadcast-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Alarm from %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Personal message from %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-from-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$Personal message from %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from-to ."\
%[%#5$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$Group message to %#3M\nfrom %#2P (%#4s):

%#1t
%]%[%#5$\
----------------------------------------------------------------
%]")
    (message-from-to-long ."\
%[%#5$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$Group message to %#3M\nfrom %#2P (%#4s):

%#1t
%]%[%#5$\
-------------------------------------------------------------------------------
%]")


    (text-is-created . "Text %#1n has been created!")

    ; Used in mode-line-process
    (mode-line-waiting . ": waiting")
    (mode-line-working . ": working")
    (mode-line-saving . ": saving")
    (mode-line-down . ": down")

    ; From completing-read.el:

    (person-or-conf-no-regexp . "\\`[ \t]*[mpMP]\\w*[ \t]+\\([0-9]+\\)\\'")
    (session-no-regexp . "\\`[ \t]*[sS]\\w*[ \t]+\\([0-9]+\\)\\'")
    (conf-prompt . "Which conference/person? ")

    ; From prioritize.el:

    (cant-move-nothing-nowhere . "Can't move nothing anywhere.")
    (goto-priority-prompt . "Go to priority: ")
    (priority-prompt . "New priority for %#1M: ")
    (priority-prompt-marked . "New priority for selected conferences: ")
    (beginning-of-list . "Beginning of list")
    (end-of-list . "End of list")
    (reprioritize-from . "Reprioritize from: ")
    (reprioritize-to . "Reprioritize to: ")
    (no-selection . "No selection")
    (selection . "%d selected")

    (cannot-get-membership . "Cannot retrieve your membership list.")
    (cannot-get-pers-stat . "Cannot retrieve your personal status.")
    (prioritize-help .
"u,n Move conference, SPC select, p prioritize selection, q quit, C-h m help")
    (your-priorities . " Priority   Conference
-------------------------------------------------------------------------------
")
    (your-membship . "Your memberships:
  Prio Conf# Conference\n")
    (prio-row . " %5#1d%5#2m  %#3M\n")
    (too-high-goto-2 . "You are too high up. Move down to line two.")
    (too-low-go-up . "You can't push the last line. Move up one line.")
    (all-confs-popped .  "All conferences have been popped.")
    (prio-died . "Couldn't complete the move. Sorry. Kill the buffer.")
    (new-priority . "New priority? (0 (low) - 255 (high)) ")
    (new-prio . "%6#1d")

    ; From flags.el:
    (saving-settings . "Saving options...")
    (saving-settings-done . "Saving options...done")
    (hang-on . "Wait a moment...\n")
    (no-changes . "Nothing was saved since no options had been changed.\n")
    (could-not-save-options . "Couldn't save options.\n")
    (could-not-create-area . "Couldn't create the text.\n")
    (could-not-set-user-area . "Couldn't alter the user area. The server says error: %#1d\n")
    (you-dont-exist . "You don't exist. Go away.\n")
    (error-in-options . "There was an error in one of your variables (%#1s)
It was set to \"%#2s\" in the user area. It is set to nil instead.
Send a bug report.\n")
    (error-in-options-short . "There was an error in your saved settings. Some settings have not been read.")

    ; From elib-string.el:
    ; No entries.

    ; From lyskom-rest.el:

    (mode-line-unread . " Unread ")
    (mode-line-letters . "letters ")
    (frame-title-unread . "Unread")
    (frame-title-letters . " letters")
    (sessions-with-unreads . "Sessions with unread texts")
    (unread-letters . "unread letters")

    (bad-text-no-prefix . "Unable to translate prefix `%s' to a text number")
    (prefix-arg-try-again . "Specify another text or press control-g to abort.\n")
    (error-code . "Error code %#2d/%#3S: %#1s.\n")
    (error-in-kom-do-when-done . "The variable kom-do-when-done has an erroneous value.
You should set it to a better value.\n")
    (extended-command . "LysKOM: ")
    (wait-for-server . "LysKOM is waiting for a response from the server. Wait for the prompt.\n")
    (review-text-q . "Review text: ")

    (completely-read-conf . "You have seen all the texts in this conference.\n")
    (not-in-any-conf . "You are not in a conference now.\n")

    (all-conf-unread-r . "You have nothing unread.\n")
    (all-conf-unread-s . "You have nothing unread. ")
    (enter-conf-unread . "%#1d unread text%#1?d%[%]%[s%]")
    (enter-conf-unread-faq . "%#1d unread FAQ%#1?d%[%]%[s%]")

    (save-one-on-file-q . "Save copy of text %#1n in file: ")
    (save-many-on-file-q . "Save copies of %#1d texts in file: ")
    (saving-one-on-file . "Saving copy of text %#1n in %#2s.\n")
    (saving-many-on-file . "Saving %#1d texts in %#2s.\n")
    (save-text-to-file-q . "Save body of text %#1n in which file: ")
    (save-text-confirm . "File %#1s exists. Overwrite? ")
    (saving-text . "Saving text %#1n as %#2s...")
    (what-save-no . "Which text do you want to save? ")
    (wait-for-prompt . "Wait for the prompt.")

    (conference-no . "<conference %#1d>")
    (person-no . "<person %#1d>")
    (prompt-several-messages . "(%d messages)")
    (prompt-single-message . "(%d message)")

    (text-buffer-missing . "The text buffer no longer exists.\n")
    (re-edit-text-prompt . "Edit the text that couldn't be created")
    (go-to-pri-conf-prompt . "Go to next prioritized conference")
    (read-pri-text-conf . "Read next prioritized text")
    (review-next-text-prompt . "Review next text")
    (review-next-comment-prompt . "Review next comment")
    (review-next-marked-prompt . "Review next marked text")
    (review-next-faq-prompt . "Review next FAQ")
    (read-next-letter-prompt . "Read next letter")
    (read-next-footnote-prompt . "Read next footnote")
    (read-next-comment-prompt . "Read next comment")
    (read-next-text-prompt . "Read next text")
    (read-next-attachment-prompt . "Read next attachment")
    (go-to-conf-of-marked-prompt . "Resume reviewing marked")
    (go-to-conf-of-review-tree-prompt . "Resume reviewing comments")
    (go-to-conf-of-review-prompt . "Resume reviewing texts")
    (go-to-conf-of-review-faq-prompt . "Resume reviewing FAQs")
    (go-to-next-conf-prompt . "Go to next conference")
    (go-to-your-mailbox-prompt . "Go to your mailbox")
    (next-pri-session-prompt . "Go to prioritized LysKOM \"%#1s\"")
    (next-unread-session-prompt . "Go to LysKOM \"%#1s\"")
    (no-such-kom-session . "No such session with unread texts.\n")
    (the-command . "Command: %#1C")
    (error-in-login-hook . "There was an error in your kom-login-hook: %#1s\n")

    (give-a-number . "Enter a number: ")

    (yes-regexp . "\\`[yY][eE][sS]\\'")
    (no-regexp . "\\`[nN][oO]\\'")
    (yes-string . "Yes")
    (no-string . "No")
    (yes-or-no-nag . "Answer yes or no.")
    (yes-or-no . "(yes or no) ")

    (y-or-n-instring . "yYnN ")
    (j-or-n-nag . "Answer y or n. ")
    (j-or-n . "(y or n) ")
    (y-instring . "yY ")

    (person-does-not-exist . "User %#1d (does not exist).")
    (conference-does-not-exist . "Conference %#1d (does not exist).")
    (conf-no-does-not-exist-r . "Conference %#1d does not exist.")
    (person-is-anonymous . "Anonymous user")

    (process-signal . "Signal from the process.")
    (dead-session . "No active LysKOM session.")
    (not-lyskom-buffer . "This is not an active LysKOM session.")
    (closed-connection . "
**************************************************
%#2s
LysKOM session killed abnormally
Error message: %#1s**************************************************")
    (error-not-found . "Error code %#1d. No explanation available.")

    ; Useful in more places than one:
    (illegal-command . "Illegal command.\n")
    (no-such-text . "The text doesn't exist.\n")
    (no-such-text-m . "The text doesn't exist.")
    (nobody . "nobody")
    (everybody . "everyone")
    (everything . "everything")
    (anybody . "anyone")
    (forward . "forward")
    (backward . "backward")
    (wait . "Wait a moment...\n")
    (comment . "Comment")
    (comment-prefix . "[Cc][Oo]")
    (footnote . "Footnote")
    (footnote-prefix . "[Ff]")
    (by . " by %#1P")
    (text-created .  "Text %#1n has been created.\n")
    (text-created-anonymous .  "\
Text %#1n has been created (anonymously). To make it more difficult
for others to figure out that you wrote the text, you should wait a while
before reading it.\n")

    (resolve-session . "Which session: ")

    (starting-program . "Starting %#1s...")
    (super-jump . "Filtering subject \"%#1r\" in conference \"%#2M\"\n")
    (no-recipient . "There are no recipients for this text.\n")
    (filtered . "[Filtered]")
    (filter-error-specification . "Error in the filter specification")
    (filter-error-bad-not . "Error in the filter specification after 'not'")
    (filter-error-unknown-key . "The filter key '%S' is unknown.")
    (filter-error-key-arg . "Bad filter data (%S %S)")
    (filter-tree . "Skipping text %#1n \"%#2r\" by %#3P and all its comments.\n")
    (filter-text . "Skipping text %#1n \"%#2r\" by %#3P.\n")
    (filter-permanent . "Permanent? ")
    (filter-action . "Filter how? ")
    (filter-in-conf . "In which conference? (all) ")
    (filter-subject . "Filter which subject? ")
    (filter-recipient . "Filter which recipient? ")
    (filter-which-text . "Filter texts containing: ")
    (filter-author . "Filter which author? ")
    (permanent . "(permanent)")
    (temporary . "(temporary)")
    (filter-edit-buffer-name . "*LysKOM Filter Edit*")
    (filter-edit-empty-list . "Empty list")
    (filter-edit-start-of-list . "Beginning of list")
    (filter-edit-end-of-list . "End of list")
    (filter-edit-filter-how . "Filter how? ")
    (filter-edit-filter-what . "What do you want to filter? ")
    (filter-edit-bad-argument . "Bad input: %s")
    (filter-edit-outside-entry . "Can't do that outside a filter")
    (filter-edit-outside-list . "Can't do that outside the list")
    (filter-edit-end-of-pattern . "End of filter")
    (filter-edit-save-p . "Save changes? ")
    (filter-edit-remove-empty . "Empty filters cause all texts to be filtered. Do you want to remove these? ")
    (filter-edit-restart-p . "You have made changes. Really revert? ")
    (filter-edit-help . "p Up, n Down, i New line, M-i New filter, d Delete line, M-d Delete filter")
    (filter-edit-header . "Edit filters on \"%s\"\n")
    (filter-edit-saving . "Saving changes...")
    (filter-edit-saving-done . "Saving changes...done")
    (filter-edit-saving-error . "Couldn't save changes!")
    (filter-edit-insert-pred . "%#1s (=,!=): ")
    (filter-edit-insert-arg . "%#1s %#2s (what): ")
    (no-filters . "No filters are defined.\n")
    (view-filters-header . "\nActive filters:\n\n")
    (view-filters-footer . "")

    (ansaphone-new-message . "New Ansaphone message: ")
    (ansaphone-message . "Ansaphone message:
----------------------------------------------------------------------
%#1t
----------------------------------------------------------------------
")
    (ansaphone-message-long . "Ansaphone message:
-------------------------------------------------------------------------------
%#1t
-------------------------------------------------------------------------------
")
    (ansaphone-state . "The Ansaphone is %#1s.")
    (ansaphone-state-r . "The Ansaphone is now %#1s.\n")
    (ansaphone-messages-gone . "Recorded messages have been erased.")
    (ansaphone-no-messages . "No recorded messages.\n")
    (ansaphone-message-list-start . "Recorded messages:\n\n")
    (ansaphone-message-list-end . "\n\n")
    (ansaphone-message-header . "Automatic reply (set %#1s):\n")

    (remote-erase-messages . "Remote control (%#1P %#2s): Erased recorded messages\n")
    (remote-set-message . "Remote control (%#1P %#2s): Ansaphone message:
----------------------------------------------------------------------
%#3t
----------------------------------------------------------------------
")
    (remote-set-message-long . "Remote control (%#1P %#2s): Ansaphone message:
-------------------------------------------------------------------------------
%#3t
-------------------------------------------------------------------------------
")    (remote-set-ansaphone . "Remote control (%#1P %#2s): The ansaphone is %#3s\n")
    (remote-list-messages . "Remote control (%#1P %#2s): Listed recorded messages\n")
    (remote-quit . "Remote control (%#1P %#2s): Quit\n")

    (illegal-remote . 
"Illegal remote control attempt:
Time: %#1s
From: %#2P <%#2p>
To  : %#3P <%#3p>
Text: 
%#4t")
    (illegal-remote-reply . "Remote control rejected: %#1s") 
    (remote-not-in-list . "Unauthorised person")
    (remote-bad-command . "Unknown or malformed command")
    (remote-unknown-error . "Unknown error")

    (remote-control-who . "Remotely control which session? ")
    (remote-control-autoreply . "Ansaphone on or off? ")

    (state-on . "on")
    (state-off . "off")
    

    (text-popup-title . "Text %#1s")
    (conf-popup-title . "Conference %#1s")
    (pers-popup-title . "User %#1s")
    (url-popup-title  . "URL %#1s")
    (aux-popup-title  . "Auxiliary information")
    (timestamp-popup-title . "Timestamp %#1s")
    (recpt-type-popup-title . "Recipient type: %#1s")
    (add-recpt-button-text . "[Add...]")
    (add-recpt-button-text-regex . "\\[Add\\.\\.\\.\\]")
    (generic-popup-title . "%#1s")

    (who-i-am-not-present . "%#1P (not in any conference) \n")
    (who-i-am-present . "%#1P is present in %#2M\n")
    (who-i-am-client . "The program is lyskom.el, version %#1s%#2?b%[ (MULE)%]%[%].\n")
    (who-i-am-server . "This is %#1s, version %#2s.\n")
    (who-i-am-emacs . "Running under %#1s%#2?b%[ (MULE)%]%[%].\n")

    (no-such-session-r . "That session does not exist. Perhaps the user is not logged on.\n")
    (person-not-logged-in-r . "%#1P %#2?b%[has not been logged on since %#2s%]%[is not logged on%].\n")

    (session-status . "Session %#1d is %#2P <%#2p>
%#5s %#7s %#4M
Using %#6D from %#3s\n")
    (session-status-9 . "Session %#1d is %#2P <%#2p>
%#5s %#7s %#4M
Using %#6D from %#3s
On since %#8s%#9s")
    (session-status-inactive . "\nHas been inactive for %#1s\n")
    (one-day . "one day")
    (one-hour . "one hour")
    (one-minute . "one minute")
    (years . "years")
    (year . "r")
    (month . "month")
    (months . "months")
    (days . "days")
    (day . "day")
    (hours . "hours")
    (minutes . "minutes")
    (and . "and")
    (session-is-active . " and is currently active.\n")
    (session-is-invisible . "This session is invisible.\n")
    (status-for-session . "Session status for whom? ")
    (unknown-doing-what . "Exists")
    (doing-where-conn . "in")
    (doing-nowhere-conn . "but is")
    (waiting-for-membership . "Waiting for the membership list to be fetched...%d/%d")

    ;; From slow.el
    (no-such-command . "There is no such command.\n")
    (command-completions . "You may mean one of the following:\n %#1s\n")

    (which-language . "Change language to: ")
    (send-formatted . "Send as formatted text? ")
    (changing-language-to . "Changing to %#1s.\n")
    (language-set-to . "Language set to %#1s.\n")
    (language-not-loaded . "%#1s is unavailable.\n")

    (reformat-html . "HTML")
    (reformat-enriched . "enriched")
    (reformat-filled . "filled")

    (reformat-truncated . "truncated")

    (reformat-signature . "designed")

    (reformat-deswascii . "was swascii")

    (need-library . "The \"%#1s\" package is required for this command.\n")
    (calc-expression . "Expression: ")

    (do-send-anonymous . "Send the text anonymously? ")
    (anonymous . "anonymous")
    (Anonymous . "Anonymous")

    (secret-conf-letter . "S")
    (protected-conf-letter . "P")
    (created-conf-letter . "C")
    (superconf-conf-letter . "S")
    (supervisor-conf-letter . "O")

    ;; Some Help

    (where-is-doesnt-exist . "The command %#1s does not exist")
    (where-is-on-no-key . "%#1s is not on any key")
    (where-is-on-key . "%#1s is on %#2s")

    ;; From aux-items.el

    (content-type-aux . "Content type: %#1s")
    (content-type-regexp . "Content type: \\(\\S-+\\)")

    (agreeing . "Agreeing with text %#1n...")
    (fast-replying . "Remark to text %#1n...")
    (author-fast-replies . "Remarks by the author:")
    (author-fast-reply-aux . "  \"%#1t\"")
    (other-fast-replies . "Remarks:")
    (other-fast-reply-aux . "  \"%#1t\" /%#2P/")
    (fast-reply-too-long . "Can't create remarks that consist of more than one line.\n")

    (faq-for-conf-aux . "FAQ for %#1M <%#1m>") 
    (faq-for-server-aux . "FAQ for the LysKOM-server") 
    (faq-in-text-aux . "FAQ in text:                 %10#1n %#2D")
    (conf-to-add-faq . "Which conference do you want to add an FAQ for? ")
    (text-to-add-as-faq . "Which text is the new FAQ? ")
    (text-to-change-as-faq . "Which FAQ do you want to change? ")
    (adding-faq . "Adding text %#1n as an FAQ for %#2?b%[%#2M%]%[the server%]...")
    (conf-to-del-faq . "Which conference do you want to remove an FAQ from? ")
    (text-to-del-as-faq . "Which text do you want to remove as FAQ? ")
    (deleting-faq . "Removing text %#1n as FAQ for %#2?b%[%#2M%]%[the server%]...")
    (conf-has-no-faq . "%#1?b%[%#1M%]%[The server%] has no FAQ\n")
    (view-which-faq . "View FAQ for which conference? ")
    (review-faq-for-r . "View FAQ for %#1?b%[%#1M%]%[the server%].\n")
    (changed-faq-for-conf-done . "FAQ in text %#2n for %#1?b%[%#1M%]%[the server%] changed to text %#3n.\n")
    (changed-faq-for-conf-failed . "Unable to change FAQ for %#1?b%[%#1M%]%[the server%] to text %#3n.
%#2?b%[Text %#2n is still the FAQ.
%]%[%]%#4s")
    (faq-in-text . "FAQ in text %#1n %#3s%#4s")
    (faq-in-text-by . "FAQ in text %#1n %#5s %#3sby %#2P %#4s")
    (server-has-new-faq . "\nThere %#1?d%[is a new FAQ%]%[are %#1d new FAQs%] for the server.\n")
    (unread-faqs-header . "\nUnread FAQ%#1?d%[%]%[s%] for %#2?b%[%#2M%]%[the server%]::\n")

    (too-many-languages . "Cannot code that many character sets. Send uncoded? ")
    (too-many-content-types . "Cannot figure out what content type you want. Simplify the text.")

    (cross-reference-text-status-aux . "See text:              %10#1n /%#2P/")
    (cross-reference-conf-status-aux . "See conference:                         <%#1m> %#1M /%#2P/")
    (cross-reference-pers-status-aux . "See person:                             <%#1p> %#1P /%#2P/")
    (strange-cross-reference-status .  "See also:                                %#1s (whatever that means)")
    (cross-reference-text-aux . "See text %#1n /%#2P/")
    (cross-reference-conf-aux . "See conference <%#1m> %#1M /%#2P/")
    (cross-reference-pers-aux . "See person <%#1p> %#1P /%#2P/")
    (cross-reference-text-regexp . "See text \\([0-9]+\\)")
    (cross-reference-conf-regexp . "See conference <\\([0-9]+\\)>")
    (cross-reference-pers-regexp . "See person <\\([0-9]+\\)>")
    (strange-cross-reference . "See %#1s, whatever that might mean")

    (no-comments-aux . "The author has requested others not to comment this text")
    (no-comments-edit-aux . "Request that others do not comment")
    (no-comments-regexp . "Request that others do not comment")
    
    (personal-comment-aux . "The author has requested private replies only")
    (personal-comment-edit-aux . "Request private replies only")
    (personal-comment-regexp . "Request private replies only")
    
    (request-confirmation-aux . "%#1P has requested confirmation of reading")
    (request-confirmation-edit-aux . "Request confirmation of reading")
    (request-confirmation-regexp . "Request confirmation of reading")
    (confirm-read-q . "Confirm reading text %#1n? ")
    
    (read-confirm-aux . "Confirmed reading: %#1P %#2s")

    (redirect-email-aux . "Send e-mail to %#1s")
    (redirect-lyskom-aux . "Send texts to conference %#1M")

    (label-what-kind . "Set personal label on what (text, conference, user)? ")
    (label-what-text . "Set personal label on text: ")
    (label-what-conf . "Set personal label on which conference? ")
    (label-what-pers . "Set personal label on which person? ")
    (label-what-label . "Personal label: ")
    (label-secret    . "Should others to be able to see the label? ")

    (creating-software-aux . "Created with %#1s")
    (world-readable-text-aux . "The text can be read without logging on")
    (world-readable-text-edit-aux . "Make the text readable without logging on")

    (cant-get-aux-item . "Can't find auxiliary information\n")
    (aux-item-no-info . "No information available\n")
    (aux-item-info . "\
Number:        %#1d %#6s
Type:          %#2d (%#3s)
Created by:    %#4P <%#4p>
Created:       %#5s
Flags:         %#7s
Inherit limit: %#8s
Contents:     \"%#9s\"
")
    (secret . "Secret")
    (deleted . "Deleted")
    (hide-creator . "Secret creator")
    (inherit . "Inherited")
    (unlimited-inherit . "Unlimited inheritance")
    (no-inheritance . "Inheritance is off")
    (no-more-inheritance . "Inherit limit reached; will not be further inherited")
    (inherit-steps . "%#1d steps")

    (aux-item-for . "Auxiliary information for ")
    (aux-item-for-conference-no . "conference <%#1m> %#1M")
    (aux-item-for-text-no . "text %#1n")
    (aux-item-for-server . "the server")

    (what-fast-reply-no . "Remark to which text? ")
    (fast-reply-prompt . "Remark: ")
    (agree-prompt . "Text: ")
    (default-agree-string . "I agree")
    (what-agree-no . "Agree with which text? ")

    (what-kind-to-add-aux-to . "Attach information to what? ")
    (which-conf-to-add-aux-to . "Which conference to you want to attach information to? ")
    (which-text-to-add-aux-to . "Which text to you want to attach information to? ")
    (which-aux-item-tag . "Information tag: ")
    (which-aux-item-inherit . "Set the  inherit-flag? ")
    (which-aux-item-secret . "Set the secret-flag? ")
    (which-aux-item-anonymous . "Set the anonymous-flag? ")
    (which-aux-item-rsv1 . "Set the dont-garb-flag? ")
    (which-aux-item-rsv2 . "Set the reserved2-flag? ")
    (which-aux-item-rsv3 . "Set the reserved3-flag? ")
    (which-aux-item-rsv4 . "Set the reserved4-flag? ")
    (which-aux-item-inherit-limit . "Inherit limit: ")
    (which-aux-item-data . "Data: ")

    ;; Cross-reference stuff

    (person . "User")
    (conference . "Conference")
    (text . "Text")
    (server . "Server")

    (xref-type . "What to you want to refer to (text, conference or person)? ")
    (which-text-to-xref . "Add reference to text: ")
    (which-text-to-xref-err . "Text not found. Add reference to text: ")
    (which-pers-to-xref . "Add reference to user: ")
    (which-conf-to-xref . "Add reference to conference: ")

    ;; Aux-item stuff from edit-text

    (no-comments-q . "The author doesn't want comments. Comment anyway? ")
    (private-answer-q . "The author wants private replies. Write private reply? ")

    (your-invited . "You have been invited to %#1M by %#2P.
By accepting the invitation you will continue to be a member of %#1M.
If you decline the invitation you will not be a member of the conference.
")
    (accept-invitation . "Do you want to accept the invitation now? ")
    (enter-passive . "You are a passive member of %#1M.
You must become an active member of the conference to enter it.\n")
    (convert-passive . "Vill du bli aktiv medlem i %#1M? ")
    (bug-secret-mship . "You are a secret member of %#1M\n")

    (invitation-mt-type . "invited")
    (passive-mt-type . "passive")
    (secret-mt-type . "secret")

    (Invitation-mt-type . "Invited")
    (Passive-mt-type . "Passive")
    (Secret-mt-type . "Secret")

    (not-author-try-anyway-p . "You are not the author of the text. Try anyway? ")
    (what-no-comments-no . "Which text do you want to prevent comments to: ")
    (adding-no-comments . "Preventing comments to text %#1n...")
    (already-no-comments . "Text %#1n already prevents comments.\n")

    (what-private-answer-no . "Which text do you want private replies to: ")
    (adding-private-answer . "Requesting only private replies to text %#1n...")
    (already-private-answer . "Text %#1n already has a request for private replies only.\n")

    (what-request-confirm-no . "Which text do you want read confirmations for: ")
    (adding-request-confirm . "Requesting read confirmations for text %#1n...")
    (already-request-confirm . "Text %#1n already has a request for read confirmations.\n")

    (review-mail-headers-to-what . "Which text's mail headers do you want to see? ")
    (no-mail-headers . "Text %#1n has no mail headers\n")
    (mail-headers-for . "Mail headers for text %#1n:\n")
    (email-name-prefix . "")
    (email-name-suffix . "")

    (you-are-anonymous . "You are now somewhat anonymous.\n")
    (you-are-nonanonymous . "You are no longer anonymous.\n")
    (you-are-already-anonymous . "You are already somewhat anonymous.\n")
    (you-are-already-nonanonymous . "You are already non-anonymous.\n")

    (start-keep-alive . "Sending data at %#1d second intervals to keep the connection active.")
    (stop-keep-alive . "No longer keeping connection active by sending extra data.")

    (review-noconversion-q . "Review which text unconverted?")
    (review-commented-q . "Review the commented for which text?")

    (review-tree-q . "Review all comments recursively for which text?")
    (find-root-q . "Review original text for text?")
    (find-root-review-q . "Review tree of which text?")
    (review-comments-q . "Review all comments to which text?")

    (confusion-who-to-reply-to . "I can't figure out which text you want to write a private reply to.\n")
    (confusion-what-to-answer-to . "I can't figure out which text you want to write a reply to.\n")
    (confusion-what-to-view . "I can't figure out which text you want to view.\n")

    (confusion-what-to-reply-to . "I can't figure out which text you want to write a remark to.\n")
    (confusion-what-to-agree-to . "I can't figure out which text you want to agree with.\n")
    (confusion-what-to-request-confirmation . "I can't figure out which text you want read confirmations for.\n")
    (confusion-what-to-comment . "I can't figure out which text you want to comment.\n")
    (confusion-what-to-footnote . "I can't figure out to which text you want to write a footnote to.\n")

    (confusion-what-to-delete . "I can't figure out which text you want to delete.\n")
    (confusion-what-to-add-sub-recipient . "I can't figure out which text you want to %#1s.\n")
    (add-rcpt-action-name . "add a recipient to")
    (add-copy-action-name . "add a carbon copy recipient to")
    (add-bcc-action-name . "add a blind carbon copy recipient to")
    (sub-action-name . "remove a recipient from")
    (move-action-name . "move")

    (confusion-what-to-add-comment-to . "I can't figure out which text you want to add a comment to.\n")
    (confusion-what-to-sub-comment-from . "I can't figure out which text you want to remove a comment from.\n")
    (confusion-what-to-add-footnote-to . "I can't figure out which text you want to add a footnote to.\n")
    (confusion-what-to-sub-footnote-from . "I can't figure out which text you want to remove a footnote from.\n")
    
    (confusion-what-to-mark . "I can't figure out which text you want to mark.\n")
    (confusion-what-to-unmark . "I can't figure out which text you want to unmark.\n")
    (confusion-what-to-save . "I can't figure out which text you want to save.\n")

    (confusion-what-to-review-mail-headers . "I can't figure out which text's mail headers you want to see.\n")
    (confusion-what-to-find-root . "I can't figure out which text's root you want to see.\n")
    (confusion-what-to-find-root-review . "I can't figure out which tree you want to review.\n")

    ;; Help stuff

    (help-with-what . "What do you want help with? ")
    (help-for . "Help for \"%#1s\"\n")

    ;; Button actions

    (lyskom-button-view-text-action . "View text")
    (lyskom-button-copy-text-no-action . "Copy text number")
    (lyskom-button-review-noconversion-action . "Review unconverted")
    (lyskom-button-find-root-review-action . "Review tree")
    (lyskom-button-find-root-action . "Review root text")
    (lyskom-button-comment-text-action . "Write comment")
    (lyskom-button-private-comment-text-action . "Write personal reply")
    (lyskom-button-mark-text-action . "Mark text")
    (lyskom-button-unmark-text-action . "Unmark text")
    (lyskom-button-save-text-action . "Save archive copy")
    (lyskom-button-save-text-body-action . "Save text body")
    (lyskom-button-review-comments-action . "Review all comments")
    (lyskom-button-review-tree-action . "Review all comments recursively")
    (lyskom-button-write-footnote-action . "Write footnote")
    (lyskom-button-fast-reply-action . "Remark")
    (lyskom-button-view-conf-presentation-action . "View presentation")
    (lyskom-button-view-conf-status-action . "View conference status")
    (lyskom-button-goto-conf-action . "Go to conference")
    (lyskom-button-send-message-action . "Send group message")
    (lyskom-button-add-self-action . "Join conference")
    (lyskom-button-sub-self-action . "Leave conference")
    (lyskom-button-view-pers-presentation-action . "View presentation")
    (lyskom-button-view-pers-status-action . "View user status")
    (lyskom-button-view-session-status-action . "View session status")
    (lyskom-button-mail-action . "Send letter")
    (lyskom-button-send-message-action . "Send personal message")
    (lyskom-button-open-url-action . "Open")
    (lyskom-button-copy-url-action . "Copy")
    (lyskom-button-goto-info-node-action . "Open")
    (lyskom-button-open-email-action . "Send mail")
    (lyskom-button-copy-email-action . "Copy")
    (lyskom-button-info-aux-action . "Information")
    (lyskom-button-delete-aux-action . "Delete")
    (lyskom-button-copy-timestamp-action . "Copy")
    (lyskom-button-recpt-type-recipient . "Recipient")
    (lyskom-button-recpt-type-copy . "Carbon copy")
    (lyskom-button-recpt-type-bcc . "Blind Carbon copy")
    (lyskom-button-recpt-type-sub . "Remove")
    (lyskom-button-recpt-add-recipient . "Recipient")
    (lyskom-button-recpt-add-copy . "Carbon copy recipient")
    (lyskom-button-recpt-add-bcc . "Blind carbon copy recipient")
    (lyskom-button-aux-type-xref . "Referenc till conference/person/text")
    (lyskom-button-aux-type-no-comments . "Request no comments")
    (lyskom-button-aux-type-personal-comments . "Request personal reply")

    (lyskom-edit-toggle-secret-aux-action . "Toggle \"secret\"")
    (lyskom-edit-toggle-anonymous-aux-action . "Toggle \"anonymous\"")
    (lyskom-edit-toggle-inherit-aux-action . "Toggle \"inherited\"")
    (lyskom-edit-delete-aux-action . "Delete")
    (lyskom-prioritize-flag-toggle-action . "Toggle")
    (lyskom-prioritize-flag-set-action . "Set")
    (lyskom-prioritize-flag-clear-action . "Clear")

    (server-status-header   . "Status for LysKOM-server %#1s%#2?b%[ (%#2s:%#3d)%]%[%]\n\n")
    (server-status-server   . "Canonical server name:                   %#1s%#2?b%[:%#2s%]%[%]\n")
    (server-status-version  . "Software version:                        %#1s %#2s\n")
    (server-status-protocol . "Protocol version:          %15#1d\n")
    (server-status-sessions . "\
Number of sessions:  %21#1d (total)
                     %21#2d active in the last %#7d minutes
                     %21#3d inactive sessions
                     %21#4d unknown activity
                     %21#5d invisible sessions
                     %21#6d not logged on/secret/zombies\n")
    (server-status-first-text . "Oldest existing text:      %15#1n\n")
    (server-status-last-text  . "Youngest existing text:    %15#1n\n")
    (server-status-has-motd . "\nThe server has a notice:\n")
    (server-status-time . "Serverns tid:                   %#1s\n")

    (mship-type-invitation-q . "Membership invitation? ")
    (mship-type-passive-q . "Passive membership? ")
    (mship-type-secret-q . "Secret membership? ")
    (recommend-which-conf . "Which conference do you want to recommend? ")
    (recommend-set-priority-q . "Recommend a priority? ")
    (recommend-set-mship-type-q . "Recommend a membership type? ")
    (recommending-conf . "Recommending %#1M%#2?b%[ (priority %#2d)%]%[%]%#3?b%[ %#3s%]%[%]...")
    (has-recommended-conf . "%#1P has recommended conference %#2M. Do you want to become a member?\n")
    (accept-recommendation . "Join conference %#1M? ")
    (accepting-recommendataion . "Joining recommended conference %#1M...")

    (redirect-for-whom . "Redirect comments for whom: ")
    (redirect-to-which-conf . "Redirect comments to: ")
    (redirecting-comments-to . "Redirecting comments for %#1P to %#2M%#3?b%[ (old %#1M)%]%[%]...")

    (kom-redirect-comments-e49 . "You do not have permission to perform this redirection")
    (kom-redirect-comments-e48 . "Comment redirection is not supported by the server")

    (external-program-missing . "Can't find the external program \"%#1s\", that was required for this command.")
    (ignored-user-area-var . "\

Ignoring the following variables in your settings:

    %#1s

These variables are not registered as LysKOM variables and cannot be
read from the server. You can remove the variables from the server by
giving the command \"Save options\".\n\n")


    (unknown-aux-item . "Oknd tillggsinformation")
    (text-header-aux-item . "%#1s: <%#2d> \"%#3s\" %#4s")

    (aux-content-type-name . "Content type")
    (aux-fast-reply-name . "Remark")
    (aux-cross-reference-name . "Reference")
    (aux-no-comments-name . "Request for no comments")
    (aux-personal-comment-name . "Request for personal replies")
    (aux-request-confirmation-name . "Request for read confirmation")
    (aux-read-confirm-name . "Read confirmation")
    (aux-redirect-name . "Redirect")
    (aux-x-face-name . "Picture")
    (aux-alternate-name-name . "Alternate name")
    (aux-pgp-signature-name . "PGP signature")
    (aux-pgp-public-key-name . "PGP public key")
    (aux-e-mail-address-name . "E-mail address")
    (aux-faq-text-name . "FAQ in text")
    (aux-creating-software-name . "Creating software")
    (aux-mx-author-name . "E-mail author")
    (aux-mx-from-name . "E-mail from")
    (aux-mx-reply-to-name . "E-mail reply to")
    (aux-mx-to-name . "E-mail to")
    (aux-mx-cc-name . "E-mail CC")
    (aux-mx-date-name . "E-mail date")
    (aux-mx-message-id-name . "E-mail message ID")
    (aux-mx-in-reply-to-name . "E-mail in reply to")
    (aux-mx-misc-name . "E-mail headers")
    (aux-mx-allow-filter-name . "E-mail allow-filter")
    (aux-mx-reject-forward-name . "E-mail reject-forward")
    (aux-notify-comments-name . "Notify me about comments")
    (aux-faq-for-conf-name . "FAQ for conference")
    (aux-recommended-conf-name . "Conference recommendation")
    (aux-allowed-content-type-name . "Allowed content type")
    (aux-canonical-name-name . "Canonical name")
    (aux-mx-list-name-name . "Mailing list name")
    (aux-send-comments-to-name . "Send comments to")
    (aux-world-readable-name . "World-readable")
    (aux-elisp-client-read-faq-name . "Read FAQ")
    (aux-elisp-client-rejected-invitation-name . "Rejected invitation")

    (review-marking-as-read . "Review marks as read")
    (review-not-marking-as-read . "Review does not mark as read")

    (using-ssh-connection . "Using ssh connection to %#1s...")
    (opening-ssh-connection . "Opening ssh connection to %#1s...")
    (ssh-cant-connect . "Unable to open ssh connection: %s")
    (ssh-closnig . "Closing ssh connection to %#1s")
    (ssh-unknown-host . "unknown host")

    (keyboard-cancel . "Cancel")
    (keyboard-menu-help . "(choose: C-n, C-p; confirm: RET)")
    (customize-help . "See the beginning of the buffer for more information")
    (missing-faces . "\
Your text face scheme \"%#1s\" is missing the following faces:

    %#2s

Using the default face in place of these faces.
")
    ))


(lyskom-language-var local lyskom-month-names en
  '(("jan" . 1)  ("january" . 1)
    ("feb" . 2)  ("february" . 2)
    ("mar" . 3)  ("march" . 3)
    ("apr" . 4)  ("april" . 4)
    ("may" . 5)  ("may" . 5)
    ("jun" . 6)  ("june" . 6)
    ("jul" . 7)  ("july" . 7)
    ("aug" . 8)  ("august" . 8)
    ("sep" . 9)  ("september" . 9)
    ("oct" . 10) ("october" . 10)
    ("nov" . 11) ("november" . 11)
    ("dec" . 12) ("december" . 12)))


;;; ================================================================
;;;              The commands and their associated functions


;;; Formely known as lyskom-commands
(lyskom-language-strings local lyskom-command en
  '(
    (kom-help                 . "Help")
    (kom-slow-mode            . "Long commands")
    (kom-quick-mode           . "Short commands")
    (kom-send-message         . "Send message")
    (kom-send-alarm           . "Send alarm")
    (kom-create-conf          . "Create conference")
    (kom-delete-conf          . "Delete conference/user")
    (kom-delete-text          . "Remove text")
    (kom-display-time         . "Time")
    (kom-go-to-conf           . "Go (to) conference")
    (kom-go-to-next-conf      . "(Go to) next conference")
    (kom-jump                 . "Skip (all) comments")
    (kom-list-created-conferences     . "List owned conferences") 
    (kom-list-conferences     . "List conferences") 
    (kom-list-persons         . "List users")
    (kom-list-news            . "List news")
    (kom-list-re              . "List (using) regexps")
    (kom-membership           . "List memberships")
    ;; (kom-list-marks	      . "List marks")
    (kom-postpone             . "Postpone reading")
    (kom-set-session-priority . "Set reading level")
    (kom-prioritize           . "Prioritize conferences")
    (kom-status-person        . "Status (of) user")
    (kom-status-conf          . "Status (of) conference")
    (kom-add-self             . "Join conference")
    (kom-change-priority      . "Change priority")
    (kom-list-summary         . "List text (subjects)")
    (kom-sub-self             . "Leave (a) conference")
    (kom-quit                 . "Quit")
    (kom-recover              . "Recover") 
    (kom-start-anew           . "New User")
    (kom-view                 . "Review text")
    (kom-find-root-review     . "Review tree")
    (kom-review-comments      . "Review all comments")
    (kom-review-tree          . "Review all comments recursively")
    (kom-review-clear         . "Review and skip")
    (kom-review-last-normally-read
     			      . "Review again")
    (kom-review-noconversion  . "Review unconverted")
    (kom-review-next          . "Review next")
    (kom-find-root            . "Review original (text)")
    (kom-review-by-to         . "Review last")
    (kom-review-first         . "Review first")
    (kom-review-all           . "Review all")
    (kom-review-more          . "Review more")
    (kom-view-commented-text  . "Review (the) commented (text)")
    (kom-view-previous-commented-text
     			      . "Review (the) previously commented (text)")
    (kom-review-stack         . "Review stack")
    (kom-review-presentation  . "Review presentation")
    (kom-review-backward      . "(Review) Backwards")
    (kom-view-next-text       . "(Read) next text")
    (kom-who-is-on            . "Who (is on)")
    (kom-who-is-on-in-conference
                              . "Who (is on in) conference")
    (kom-who-is-present-in-conference
                              . "Who (is) present (in) conference")
    (kom-who-is-on-and-friend . "Which friends (are on)")
    (kom-who-am-i             . "Where (am) i")
    (kom-list-clients	      . "List clients")
    (kom-busy-wait            . "Wait (for news)")
    (kom-write-comment        . "(Write) comment")
    (kom-comment-previous     . "(Write) comment (to) previous text")
    (kom-write-footnote       . "(Write) footnote")
    (kom-private-answer       . "(Write) personal reply (by letter)")
    (kom-private-answer-previous
   . "(Write) personal (reply to) previous text (by letter)")
    (kom-set-unread     	      . "Only (the) last")
    (kom-write-text           . "Write (a) text")
    (kom-send-letter          . "Write (a) letter")
    (kom-change-name          . "Change name")
    (kom-change-parenthesis   . "Change parenthesis")
    (kom-change-password      . "Change password")
    (kom-change-supervisor    . "Change supervisor")
    (kom-change-presentation  . "Change presentation")
    (kom-get-appreciation     . "(Please) pat my head")
    (kom-get-abuse            . "(Please) kick my butt")
    (kom-mark-text            . "Mark (text)")
    (kom-unmark-text          . "Unmark (text)")
    (kom-review-marked-texts  . "Review marked (texts)")
    (kom-review-all-marked-texts . "Review all marked (texts)")
    (kom-add-recipient        . "Add recipient")
    (kom-add-copy             . "Add (recipient of) carbon copy")
    (kom-add-bcc	      . "Add (recipient of) blind carbon copy")
    (kom-sub-recipient        . "Remove recipient")
    (kom-move-text            . "Move text")
    (kom-move-text-tree       . "Move tree")
    (kom-add-comment          . "Add comment")
    (kom-sub-comment          . "Remove comment")
    (kom-add-cross-reference  . "Add cross reference")
    (kom-add-member           . "Add (a) member")
    (kom-sub-member           . "Remove (a) member")
    (kom-change-conf-motd     . "(Post) notice (on the) conference")
    (kom-set-garb-nice        . "Change expiration")
    (kom-set-super-conf       . "Change superconference")
    (kom-set-permitted-submitters . "Change allowed authors")
    (kom-unset-conf-motd      . "Remove notice")
    (kom-save-text            . "Archive (copy of) text (in file)")
    (kom-save-text-body       . "Save text body (in file)")
    (kom-save-options         . "Save options")
    (kom-shutdown-server      . "Shut down (server)")
    (kom-sync-database        . "Save (the) database")
    (kom-enable-adm-caps      . "Become administrator")
    (kom-disable-adm-caps     . "Become (normal) user")
    (kom-set-motd             . "Change login message")
    (kom-remove-motd          . "Remove login message")
    (kom-force-logout         . "Kill session")
    (kom-filter-author        . "Filter author")
    (kom-filter-subject       . "Filter subject")
    (kom-filter-recipient     . "Filter recipient")
    (kom-super-jump           . "Super jump")
    (kom-filter-edit          . "Edit filters")
    (kom-filter-text          . "Filter contents")
    (kom-list-filters         . "List filters")
    (kom-show-user-area       . "Show user area")
    (kom-change-conf-type     . "Change conference type")

    (kom-change-auto-reply    . "Change ansaphone message")
    (kom-toggle-auto-reply    . "Ansaphone")
    (kom-list-messages        . "List messages")
    (kom-erase-messages       . "Erase messages")

    (kom-remote-autoreply     . "Remote control ansaphone")
    (kom-remote-set-message   . "Remote control change ansaphone message")
    (kom-remote-list-messages . "Remote control list messages")
    (kom-remote-erase-messages . "Remote control erase messages")
    (kom-remote-quit          . "Remote control quit")

    (kom-status-session       . "Status (of) session")
    (kom-customize            . "Customize LysKOM")
    (kom-next-kom             . "Next LysKOM")
    (kom-previous-kom         . "Previous LysKOM")
    (kom-next-unread-kom      . "Next unread LysKOM")
    (kom-change-language      . "Change language")
    (kom-calculate            . "Calculate")
    (kom-list-marks           . "List marked texts")
    (kom-where-is             . "Where (is the) command")
    (kom-fast-reply           . "Remark (to text)")
    (kom-agree                . "Agree")
    (kom-add-faq              . "Add FAQ")
    (kom-del-faq              . "Remove FAQ")
    (kom-review-faq           . "View FAQ")

    (kom-sub-footnote         . "Remove footnote")
    (kom-add-footnote         . "Add footnote")

    (kom-add-no-comments      . "Prevent comments")
    (kom-add-private-answer   . "Request private reply")
    (kom-add-request-confirm  . "Request confirmation of reading")

    (kom-review-mail-headers  . "Review mail headers")

    (kom-compare-texts        . "Compare two texts")
    (kom-diff-texts           . "View diff")

    (kom-become-anonymous     . "Become anonymous")
    (kom-become-nonanonymous  . "Become non-anonymous (come forth into the light)")

    (kom-keep-alive           . "Keep connection alive")
    (kom-stop-keep-alive      . "Stop keeping connection alive")

    (kom-is-person-member-of-conference . "Check (if person is a) member (of conference)")
    (kom-change-conf-faq      . "Change FAQ")

    (kom-make-review-mark-as-read . "Review marks as read")
    (kom-make-review-not-mark-as-read . "Review does not mark as read")

    (kom-set-presentation     . "Add presentation")
    (kom-remove-presentation  . "Remove presentation")
    (kom-set-motd-text        . "Add notice")
    (kom-create-aux-item      . "Create auxiliary information")
    (kom-status-server        . "Status (of) server")
    (kom-add-server-faq       . "Add server FAQ")
    (kom-del-server-faq       . "Remove server FAQ")
    (kom-review-server-faq    . "Review server FAQ")
    (kom-change-server-faq    . "Change server FAQ")
    (kom-recommend-conference . "Recommend cnoference")
    (kom-redirect-comments    . "Redirect comments")
    ))

(lyskom-language-var global lyskom-language-codes en
  '((aa . "Afar")
    (ab . "Abkhazian")
    (af . "Afrikaans")
    (am . "Amharic")
    (ar . "Arabic")
    (as . "Assamese")
    (ay . "Aymara")
    (az . "Azerbaijani")
    (ba . "Bashkir")
    (be . "Byelorussian")
    (bg . "Bulgarian")
    (bh . "Bihari")
    (bi . "Bislama")
    (bn . "Bengali")
    (bo . "Tibetan")
    (br . "Breton")
    (ca . "Catalan")
    (co . "Corsican")
    (cs . "Czech")
    (cy . "Welsh")
    (da . "Danish")
    (de . "German")
    (dz . "Bhutani")
    (el . "Greek")
    (en . "English")
    (eo . "Esperanto")
    (es . "Spanish")
    (et . "Estonian")
    (eu . "Basque")
    (fa . "Persian")
    (fi . "Finnish")
    (fj . "Fiji")
    (fo . "Faroese")
    (fr . "French")
    (fy . "Frisian")
    (ga . "Irish")
    (gd . "Scots Gaelic")
    (gl . "Galician")
    (gn . "Guarani")
    (gu . "Gujarati")
    (ha . "Hausa")
    (he . "Hebrew")
    (hi . "Hindi")
    (hr . "Croatian")
    (hu . "Hungarian")
    (hy . "Armenian")
    (ia . "Interlingua")
    (id . "Indonesian")
    (ie . "Interlingue")
    (ik . "Inupiak")
    (is . "Icelandic")
    (it . "Italian")
    (iu . "Inuktitut")
    (ja . "Japanese")
    (jw . "Javanese")
    (ka . "Georgian")
    (kk . "Kazakh")
    (kl . "Greenlandic")
    (km . "Cambodian")
    (kn . "Kannada")
    (ko . "Korean")
    (ks . "Kashmiri")
    (ku . "Kurdish")
    (ky . "Kirghiz")
    (la . "Latin")
    (ln . "Lingala")
    (lo . "Laotian")
    (lt . "Lithuanian")
    (lv . "Latvian Lettish")
    (mg . "Malagasy")
    (mi . "Maori")
    (mk . "Macedonian")
    (ml . "Malayalam")
    (mn . "Mongolian")
    (mo . "Moldavian")
    (mr . "Marathi")
    (ms . "Malay")
    (mt . "Maltese")
    (my . "Burmese")
    (na . "Nauru")
    (ne . "Nepali")
    (nl . "Dutch")
    (no . "Norwegian")
    (oc . "Occitan")
    (om . "Oromo")
    (or . "Oriya")
    (pa . "Pundjabi")
    (pl . "Polish")
    (ps . "Pashto")
    (pt . "Portuguese")
    (qu . "Quechua")
    (rm . "Rhaeto-Romance")
    (rn . "Kirundi")
    (ro . "Romanian")
    (ru . "Russian")
    (rw . "Kiyarwanda")
    (sa . "Sanskrit")
    (sd . "Sindhi")
    (sg . "Sangho")
    (sh . "Serbo-Croatian")
    (si . "Singhalese")
    (sk . "Slovak")
    (sl . "Slovenian")
    (sm . "Samoan")
    (sn . "Shona")
    (so . "Somali")
    (sq . "Albanian")
    (sr . "Serbian")
    (ss . "Siswati")
    (st . "Sesotho")
    (su . "Sudanese")
    (sv . "Swedish")
    (sw . "Swahili")
    (ta . "Tamil")
    (te . "Telugu")
    (tg . "Tajik")
    (th . "Thai")
    (ti . "Tigrinya")
    (tk . "Turkmen")
    (tl . "Tagalog")
    (tn . "Setswana")
    (to . "Tonga")
    (tr . "Turkish")
    (ts . "Tsonga")
    (tt . "Tatar")
    (tw . "Twi")
    (ug . "Uigur")
    (uk . "Ukrainian")
    (ur . "Urdu")
    (uz . "Uzbek")
    (vi . "Vietnamese")
    (vo . "Volapk")
    (wo . "Wolof")
    (xh . "Xhosa")
    (yi . "Yiddish")
    (yo . "Yorouba")
    (za . "Zhuang")
    (zh . "Chinese")
    (zu . "Zulu")
    (-- . "Unknown language (%#1s)")))

(lyskom-language-strings global lyskom-menu en
  '((lyskom    . "LysKOM")
    (read      . "Read")
    (dont-read . "Jump")
    (write     . "Write")
    (conference . "Conference")
    (other     . "Other")
    (person    . "User")
    (marks     . "Marks")
    (move      . "Go")
    (info      . "About")
    (send      . "Send message")
    (receivers . "Receivers")
    (commented . "Commented")
    (kom-edit-send . "Send")
    (kom-edit-send-anonymous . "Send anonymously")
    (kom-edit-quit . "Throw away") 
    (kom-ispell-message . "Check spelling")
    (kom-edit-add-recipient . "Add recipient")
    (kom-edit-add-copy . "Add carbon copy")
    (kom-edit-show-commented . "Review commented")
    (kom-edit-insert-commented . "Cite commented")
    (kom-edit-insert-buglist . "Paste commented bug list")
    (kom-edit-add-bcc . "Add blind carbon copy")
    (kom-edit-add-cross-reference . "Add cross reference")
    (kom-edit-add-no-comments . "Request no comments")
    (kom-edit-add-personal-comments . "Request personal replies")
    (kom-edit-add-read-confirm-request . "Request read confirmation")
    (kom-edit-move-text . "Move to new recipient")
))

(lyskom-language-var local lyskom-move-tree-actions en
                     '(("Move text or subtract recipient" . move)
                       ("Leave text and continue with comments" . skip)
                       ("Abort this command" . quit)
                       ("Skip this command and its comment tree" . jump)))

(lyskom-language-var local lyskom-onoff-table en
  '(("on" . on) ("off" . off)))

(lyskom-language-var local lyskom-filter-predicate-list en
      '(("=" . nil) ("!=" . t)))

(lyskom-language-var local lyskom-filter-what en
      '((author . "Author")
        (author-no . "Author (number)")
        (author-re . "Author (regexp)")
        (subject . "Subject")
        (subject-re . "Subject (regexp)")
        (recipient . "Recipient")
        (recipient-no . "Recipient (number)")
        (recipient-re . "Recipient (regexp)")
        (text . "Contents")
        (text . "Contents (regexp)")))

(lyskom-language-var local lyskom-filter-actions en
      '((skip-text . "Skip")
        (dontshow . "Don't show")
        (read . "Exclude from filter")
        (skip-tree . "Skip comments")))
                               
(defconst lyskom-keybindings-missing nil)

(defvar lyskom-en-mode-map nil)
(lyskom-language-keymap lyskom-mode-map en lyskom-en-mode-map)

(if lyskom-en-mode-map
    nil
  (setq lyskom-en-mode-map (make-keymap))
  (suppress-keymap lyskom-en-mode-map)
  (define-prefix-command 'lyskom-en-review-prefix)
  (define-prefix-command 'lyskom-en-change-prefix)
  (define-prefix-command 'lyskom-en-next-prefix)
  (define-prefix-command 'lyskom-en-list-prefix)
  (define-prefix-command 'lyskom-en-filter-get-prefix)
  (define-prefix-command 'lyskom-en-S-prefix)
  (define-prefix-command 'lyskom-en-previous-prefix)
  (define-prefix-command 'lyskom-en-who-prefix)
  (define-key lyskom-en-mode-map (kbd "A") 'lyskom-en-change-prefix)
  (define-key lyskom-en-mode-map (kbd "r") 'lyskom-en-review-prefix)
  (define-key lyskom-en-mode-map (kbd "f") 'lyskom-en-filter-get-prefix)
  (define-key lyskom-en-mode-map (kbd "n") 'lyskom-en-next-prefix)
  (define-key lyskom-en-mode-map (kbd "l") 'lyskom-en-list-prefix)
  (define-key lyskom-en-mode-map (kbd "s") 'lyskom-en-S-prefix)
  (define-key lyskom-en-mode-map (kbd "b") 'lyskom-en-previous-prefix)
  (define-key lyskom-en-mode-map (kbd "w") 'lyskom-en-who-prefix)

  (define-key lyskom-en-mode-map (kbd "M-m") 'kom-toggle-mark-as-read-prefix)

  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button2)) 'kom-button-click)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-en-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-mode-map (kbd "*") 'kom-button-press)
  (define-key lyskom-en-mode-map (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-en-mode-map (kbd "TAB") 'kom-next-link)
  (define-key lyskom-en-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-en-mode-map (kbd "<S-tab>") 'kom-previous-link)

  ;; These should be first in order to be last in the menu of alternatives.
  (define-key lyskom-en-mode-map (kbd "A ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "r ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "f ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "n ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "l ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "s ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "b ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "w ?") 'lyskom-help)
  

  (define-key lyskom-en-mode-map (kbd "o")     'kom-set-unread)
  (define-key lyskom-en-mode-map (kbd "x")     'kom-extended-command)
  (define-key lyskom-en-mode-map (kbd "<SPC>") 'kom-next-command)
  (define-key lyskom-en-mode-map (kbd "<LFD>")  'kom-page-next-command)
  (define-key lyskom-en-mode-map (kbd "<RET>")  'kom-line-next-command)

  (define-key lyskom-en-mode-map (kbd "?")  'kom-help)
  (define-key lyskom-en-mode-map (kbd "m")  'kom-send-letter)
  (define-key lyskom-en-mode-map (kbd "g")  'kom-go-to-conf)
  (define-key lyskom-en-mode-map (kbd "a")  'kom-write-text)
  (define-key lyskom-en-mode-map (kbd "c")  'kom-write-comment)
  (define-key lyskom-en-mode-map (kbd "C")  'kom-comment-previous)
  (define-key lyskom-en-mode-map (kbd "F")  'kom-write-footnote)
  (define-key lyskom-en-mode-map (kbd "p")  'kom-private-answer)
  (define-key lyskom-en-mode-map (kbd "P")  'kom-private-answer-previous)
  (define-key lyskom-en-mode-map (kbd "j")  'kom-jump)
  (define-key lyskom-en-mode-map (kbd "J")  'kom-super-jump)
  (define-key lyskom-en-mode-map (kbd "l M") 'kom-list-marks)
  (define-key lyskom-en-mode-map (kbd "l c") 'kom-list-conferences)
  (define-key lyskom-en-mode-map (kbd "l n") 'kom-list-news)
  (define-key lyskom-en-mode-map (kbd "l u") 'kom-list-persons)
  (define-key lyskom-en-mode-map (kbd "l r") 'kom-list-re)
  (define-key lyskom-en-mode-map (kbd "l s") 'kom-membership)
  (define-key lyskom-en-mode-map (kbd "l a") 'kom-list-summary)
  (define-key lyskom-en-mode-map (kbd "l f") 'kom-list-filters)
  (define-key lyskom-en-mode-map (kbd "S")  'kom-add-self)
  (define-key lyskom-en-mode-map (kbd "M")  'kom-mark-text)
  (define-key lyskom-en-mode-map (kbd "U")  'kom-unmark-text)
  (define-key lyskom-en-mode-map (kbd "n a") 'kom-view-next-new-text)
  (define-key lyskom-en-mode-map (kbd "n c") 'kom-go-to-next-conf)
  (define-key lyskom-en-mode-map (kbd "n l") 'kom-next-kom)
  (define-key lyskom-en-mode-map (kbd "n u") 'kom-next-unread-kom)
  (define-key lyskom-en-mode-map (kbd "b l") 'kom-previous-kom)
  (define-key lyskom-en-mode-map (kbd "q")  'kom-quit)
  (define-key lyskom-en-mode-map (kbd "z")  'kom-bury)
  (define-key lyskom-en-mode-map (kbd "R")  'kom-recover)
  (define-key lyskom-en-mode-map (kbd "t")  'kom-display-time)
  (define-key lyskom-en-mode-map (kbd "f p") 'kom-get-appreciation)
  (define-key lyskom-en-mode-map (kbd "f k") 'kom-get-abuse)
  (define-key lyskom-en-mode-map (kbd "f s") 'kom-filter-subject)
  (define-key lyskom-en-mode-map (kbd "f a") 'kom-filter-author)
  (define-key lyskom-en-mode-map (kbd "f c") 'kom-filter-text)
  (define-key lyskom-en-mode-map (kbd "f r") 'kom-filter-recipient)
  (define-key lyskom-en-mode-map (kbd "w w") 'kom-who-is-on)
  (define-key lyskom-en-mode-map (kbd "w c") 'kom-who-is-on-in-conference)
  (define-key lyskom-en-mode-map (kbd "w p") 'kom-who-is-present-in-conference)
  (define-key lyskom-en-mode-map (kbd "w f") 'kom-who-is-on-and-friend)
  (define-key lyskom-en-mode-map (kbd "I")  'kom-who-am-i)
  (define-key lyskom-en-mode-map (kbd "W")  'kom-busy-wait)
  (define-key lyskom-en-mode-map (kbd "A p") 'kom-change-presentation)
  (define-key lyskom-en-mode-map (kbd "A q") 'kom-change-conf-faq)
  (define-key lyskom-en-mode-map (kbd "A f") 'kom-filter-edit)
  (define-key lyskom-en-mode-map (kbd "A m") 'kom-change-auto-reply)
  (define-key lyskom-en-mode-map (kbd "A t") 'kom-move-text)
  (define-key lyskom-en-mode-map (kbd "A T") 'kom-move-text-tree)
  (define-key lyskom-en-mode-map (kbd "r SPC") 'kom-view)
  (define-key lyskom-en-mode-map (kbd "r 0") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 1") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 2") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 3") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 4") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 5") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 6") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 7") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 8") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r 9") 'kom-initial-digit-view)
  (define-key lyskom-en-mode-map (kbd "r c") 'kom-view-commented-text)
  (define-key lyskom-en-mode-map (kbd "r C") 'kom-view-previous-commented-text)
  (define-key lyskom-en-mode-map (kbd "r a ?") 'lyskom-help)
  (define-key lyskom-en-mode-map (kbd "r a c") 'kom-review-comments)
  (define-key lyskom-en-mode-map (kbd "r a r") 'kom-review-tree)
  (define-key lyskom-en-mode-map (kbd "r j") 'kom-review-clear)
  (define-key lyskom-en-mode-map (kbd "r n") 'kom-review-next)
  (define-key lyskom-en-mode-map (kbd "r u") 'kom-review-noconversion)
  (define-key lyskom-en-mode-map (kbd "r o") 'kom-find-root)
  (define-key lyskom-en-mode-map (kbd "r l") 'kom-review-by-to)
  (define-key lyskom-en-mode-map (kbd "r f") 'kom-review-first)
  (define-key lyskom-en-mode-map (kbd "r A") 'kom-review-all)
  (define-key lyskom-en-mode-map (kbd "r M") 'kom-review-more)
  (define-key lyskom-en-mode-map (kbd "r g") 'kom-review-last-normally-read)
  (define-key lyskom-en-mode-map (kbd "r q") 'kom-review-faq)
  (define-key lyskom-en-mode-map (kbd "r Q") 'kom-review-server-faq)
  (define-key lyskom-en-mode-map (kbd "B")  'kom-review-backward)
  (define-key lyskom-en-mode-map (kbd "r s") 'kom-review-stack)
  (define-key lyskom-en-mode-map (kbd "r p") 'kom-review-presentation)
  (define-key lyskom-en-mode-map (kbd "r r") 'kom-find-root-review)
  (define-key lyskom-en-mode-map (kbd "r m") 'kom-review-marked-texts)
  (define-key lyskom-en-mode-map (kbd "r a m") 'kom-review-all-marked-texts)
  (define-key lyskom-en-mode-map (kbd "r a SPC") 'kom-review-all)
  (define-key lyskom-en-mode-map (kbd "r x a") 'kom-agree)
  (define-key lyskom-en-mode-map (kbd "r x q") 'kom-fast-reply)
  (define-key lyskom-en-mode-map (kbd "r h") 'kom-review-mail-headers)
  (define-key lyskom-en-mode-map (kbd "s c") 'kom-status-conf)
  (define-key lyskom-en-mode-map (kbd "s u") 'kom-status-person)
  (define-key lyskom-en-mode-map (kbd "s s") 'kom-status-session)
  (define-key lyskom-en-mode-map (kbd "s k") 'kom-status-server)
  (define-key lyskom-en-mode-map (kbd "s m") 'kom-send-message)

  ;; Running in) buffer

  (define-key lyskom-en-mode-map (kbd "M-p") 'backward-text)
  (define-key lyskom-en-mode-map (kbd "M-n") 'forward-text)
  (define-key lyskom-en-mode-map (kbd "C-M-p") 'kom-prev-prompt)
  (define-key lyskom-en-mode-map (kbd "C-M-n") 'kom-next-prompt)
  (define-key lyskom-en-mode-map (kbd "s a") 'kom-save-text)

  (define-key lyskom-en-mode-map (kbd "C-?") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<DEL>") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<delete>") 'scroll-down)
  (define-key lyskom-en-mode-map (kbd "<BS>") 'scroll-down)
  )


;;;==============================================================
;;; Keymap for filter editing
;;;

(defvar lyskom-en-filter-edit-map nil)
(lyskom-language-keymap lyskom-filter-edit-map en lyskom-en-filter-edit-map)

(if lyskom-en-filter-edit-map ()
  (setq lyskom-en-filter-edit-map (make-keymap))
  (suppress-keymap lyskom-en-filter-edit-map)
  (define-prefix-command 'lyskom-en-filter-edit-prefix)
  (define-key lyskom-en-filter-edit-map (kbd "C-c")  'lyskom-en-filter-edit-prefix)
  (define-key lyskom-en-filter-edit-map (kbd "p") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "P") 'lyskom-filter-edit-prev-entry)
  (define-key lyskom-en-filter-edit-map (kbd "n") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "N") 'lyskom-filter-edit-next-entry)
  (define-key lyskom-en-filter-edit-map (kbd "C-p") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-n") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-b") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-f") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-p") 'lyskom-filter-edit-prev-entry)
  (define-key lyskom-en-filter-edit-map (kbd "M-n") 'lyskom-filter-edit-next-entry)
  (define-key lyskom-en-filter-edit-map (kbd "d") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-d") 'lyskom-filter-edit-delete-entry)
  (define-key lyskom-en-filter-edit-map (kbd "D") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "C-d") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "i") 'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "I") 'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-en-filter-edit-map (kbd "M-i") 'lyskom-filter-edit-insert-entry)
  (define-key lyskom-en-filter-edit-map (kbd "<") 'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-en-filter-edit-map (kbd ">") 'lyskom-filter-edit-end-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "M-<") 'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "M->") 'lyskom-filter-edit-end-of-list)
  (define-key lyskom-en-filter-edit-map (kbd "q") 'lyskom-filter-edit-quit)
  (define-key lyskom-en-filter-edit-map (kbd "C-c C-c")   'lyskom-filter-edit-quit)
  (define-key lyskom-en-filter-edit-map (kbd "x") 'lyskom-filter-edit-expunge)
  (define-key lyskom-en-filter-edit-map (kbd "s") 'lyskom-filter-edit-save)
  (define-key lyskom-en-filter-edit-map (kbd "g") 'lyskom-filter-edit-revert)
  (define-key lyskom-en-filter-edit-map (kbd "t") 'lyskom-filter-edit-toggle-permanent)
  (define-key lyskom-en-filter-edit-map (kbd "a") 'lyskom-filter-edit-toggle-action)
  (define-key lyskom-en-filter-edit-map (kbd "?") 'lyskom-filter-edit-brief-help)
  (define-key lyskom-en-filter-edit-map (kbd "h") 'lyskom-filter-edit-brief-help)
  )


;;;(if lyskom-prioritize-mode-map
;;;    nil
;;;  (setq lyskom-prioritize-mode-map (make-keymap))
;;;  (suppress-keymap lyskom-prioritize-mode-map)
;;;  (define-key lyskom-prioritize-mode-map "\C-?" 'previous-line)
;;;  (define-key lyskom-prioritize-mode-map " "    'next-line)
;;;  (define-key lyskom-prioritize-mode-map "\C-k" 'kom-prioritize-kill)
;;;  (define-key lyskom-prioritize-mode-map "\C-y" 'kom-prioritize-yank)
;;;  (define-key lyskom-prioritize-mode-map "p"     'kom-prioritize-set-priority)
;;;  (define-key lyskom-prioritize-mode-map "\C-c\C-c" 'kom-prioritize-quit)
;;;  (define-key lyskom-prioritize-mode-map "q"     'kom-prioritize-quit)
;;;  (define-key lyskom-prioritize-mode-map "Q"     'kom-prioritize-quit)
;;;  (define-key lyskom-prioritize-mode-map "u"     'kom-prioritize-move-up)
;;;  (define-key lyskom-prioritize-mode-map "d"     'kom-prioritize-move-down)
;;;)

(defvar lyskom-en-prioritize-mode-map nil)
(lyskom-language-keymap lyskom-prioritize-mode-map en lyskom-en-prioritize-mode-map)

(if lyskom-en-prioritize-mode-map 
    nil
  (setq lyskom-en-prioritize-mode-map (make-keymap))
  (suppress-keymap lyskom-en-prioritize-mode-map)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button2)) 'kom-button-click)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-en-prioritize-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-prioritize-mode-map (kbd "*") 'kom-button-press)
  (define-key lyskom-en-prioritize-mode-map (kbd "+") 'kom-menu-button-press)
  (define-key lyskom-en-prioritize-mode-map (kbd "?") 'kom-prioritize-help)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-k") 'kom-prioritize-select)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-y") 'kom-prioritize-yank)
  (define-key lyskom-en-prioritize-mode-map (kbd "SPC") 'kom-prioritize-select)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-m") 'kom-prioritize-next-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-j") 'kom-prioritize-next-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "DEL") 'kom-prioritize-previous-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-DEL") 'kom-prioritize-deselect-all)
  (define-key lyskom-en-prioritize-mode-map (kbd "<down>") 'kom-prioritize-next-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-n") 'kom-prioritize-next-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "<up>") 'kom-prioritize-previous-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-p") 'kom-prioritize-previous-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "p") 'kom-prioritize-previous-line)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<up>") 'kom-prioritize-move-up)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-p") 'kom-prioritize-move-up)
  (define-key lyskom-en-prioritize-mode-map (kbd "u") 'kom-prioritize-move-up)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<down>") 'kom-prioritize-move-down)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-n") 'kom-prioritize-move-down)
  (define-key lyskom-en-prioritize-mode-map (kbd "d") 'kom-prioritize-move-down)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-<") 'kom-prioritize-beginning)
  (define-key lyskom-en-prioritize-mode-map (kbd "M->") 'kom-prioritize-end)
  (define-key lyskom-en-prioritize-mode-map (kbd "r") 'kom-prioritize-reprioritize)
  (define-key lyskom-en-prioritize-mode-map (kbd "g") 'kom-prioritize-goto-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "p") 'kom-prioritize-set-priority)
  (define-key lyskom-en-prioritize-mode-map (kbd "s") 'kom-prioritize-save)
  (define-key lyskom-en-prioritize-mode-map (kbd "q") 'kom-prioritize-quit)
  (define-key lyskom-en-prioritize-mode-map (kbd "C-c C-c") 'kom-prioritize-quit)
  (define-key lyskom-en-prioritize-mode-map (kbd "TAB") 'kom-next-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-C-i") 'kom-previous-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-en-prioritize-mode-map (kbd "<S-tab>") 'kom-previous-link)
)

(lyskom-language-var local lyskom-prioritize-header-lines en 2)

(lyskom-language-var local lyskom-prioritize-header en 
" Prio   Conference
-----------------------------------------------------------------------------
")



;;;; ============================================================
;;;; Strings and things for the customize mode
;;;;

(defvar lyskom-en-customize-map nil)
(lyskom-language-keymap lyskom-customize-map en lyskom-en-customize-map)


(if lyskom-en-customize-map
    nil
  (setq lyskom-en-customize-map (make-sparse-keymap))
  (define-key lyskom-en-customize-map (kbd "TAB") 'widget-forward)
  (define-key lyskom-en-customize-map (kbd "M-TAB") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "<S-tab>") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "C-i") 'widget-forward)
  (define-key lyskom-en-customize-map (kbd "M-C-i") 'widget-backward)
  (define-key lyskom-en-customize-map (kbd "C-m") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "C-j") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "<RET>") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd "<LFD>") 'widget-button-press)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button2)) 'widget-button-click)
  (define-key lyskom-en-customize-map (kbd (lyskom-keys 'button3)) 'lyskom-widget-click)
  (define-key lyskom-en-customize-map (kbd "C-c C-c") 'lyskom-customize-save-and-quit)
  (define-key lyskom-en-customize-map (kbd "C-c C-k") 'lyskom-customize-quit)
  (define-key lyskom-en-customize-map (kbd "C-c C-s") 'lyskom-customize-save)
  (define-key lyskom-en-customize-map (kbd "C-c C-a") 'lyskom-customize-apply)
  (define-key lyskom-en-customize-map (kbd "?") 'lyskom-customize-help)
)

(lyskom-language-strings local lyskom-custom-strings en
  '(
    ;;
    ;; Widget strings
    ;;

    (which-person . "Specify person: ")
    (which-conf . "Specify a conference: ")
    (which-conf-or-person . "Specify a person or conference: ")
    (which-name . "Specify a name: ")
    (some-person . "Person %#1d")
    (invalid-value . "Invalid value (%#1S)")
    (unknown-command . "Unknown command (%#1s)")
    (ding . "Audio cue")

    ;;
    ;; Help messages
    ;;

    (variable-type-help . "Select to save the setting in the server.")
    (default-help-echo . "Change the value of  %#1s.")
    (change-this-name . "Change the name in this entry.")
    (show-doc . "Show documentation.")
    (hide-doc . "Hide documentation.")
    (select-command . "Select a command.")
    (select-what-to-execute . "\
Select whether to execute command or keyboard macro.")
    (select-url-viewer . "Select a web browser.")
    (select-number . "Select number of times.")
    (select-audio-file . "Select an audio file.")
    (select-priority . "Select a priority.")
    (select-buffer . "Select a buffer name.")
    (select-buffer-size . "Select maximum buffer size.")

    ;;
    ;; Strings that are used in types and so forth
    ;;

    (buffer-name . "%#1s-configure")

    (other-window .     "Some other window             ")
    (other-frame .      "Some other frame              ")
    (new-frame .        "In a new frame                ")
    (lyskom-window .    "The LysKOM buffer's window    ")
    (window-on-buffer . "A window displaying the buffer")

    (on . "On ")
    (off . "Off")
    (yes . "Yes")
    (no . "No ")
    (to-file . "To file:")
    (max-text-length . "For texts shorter than: ")

    (friends . "Friends and other special people")

    (turned-off .      "Turned off           ")
    (number-of-times . "A few times")
    (specific-spec . "Per recipient/sender")
    (sound-file . "Audio file")
    (other-persons . "All others")

    (selected-mark . "Mark          ")
    (conf-or-person . "Person or conference")
    (ask .           "Ask every time         ")
    (limited-number . "A limited number")
    (unlimited-number . "Unlimited")

    (before . "Before the text")
    (after . "After the text")
    (depth-first . "In comment order")
    (time-order . "In time order")

    (ar-message-type . "Message type")
    (ar-personal     . "Personal")
    (ar-group        . "Group")
    (ar-alarm        . "Alarm")
    (ar-any-type     . "Any message type")
    (ar-sender       . "Sender")
    (ar-any-sender   . "Any sender")
    (ar-specified-sender . "Specified senders")
    (ar-pers-or-conf . "Person or conference")
    (ar-recipient    . "Recipient")
    (ar-any-recipient . "Any recipient")
    (ar-specified-recipient . "Specified recipients")
    (ar-person       . "Person")
    (ar-message-text . "Message text")
    (ar-any-message  . "Any message")
    (ar-matching-regexp . "Matching regexp")
    (ar-reply        . "Reply")
    (ar-no-reply     . "No reply")
    (ar-reply-text   . "Reply text")

    (express-break . "Immediately upon creation  ")
    (break .         "After current comment chain")
    (no-break .      "After current conference   ")

    (express-server-break . "Immediately")
    (express-server-letters-break . "Immediately if letters arrive")
    (server-break . "After current comment chain")
    (letters-server-break . "After current comment chain if letters arrive")
    (after-conf-server-break . "After current conference")
    (after-conf-letters-server-break . "After current conference if letters arrive")
    (when-done-server-break . "After everything has been read")
    (no-server-break . "Never")

    (command . "Command")
    (command-list . "Command list")
    (some-persons . "For some persons")
    (name . "Name")

    (page-none . "Never                        ")
    (page-all .  "Before every command         ")
    (page-some . "Before the following commands")

    (ask-every-time . "Ask every time         ")
    (fixed-priority . "Fixed priority")

    (messages-in-lyskom-buffer . "In the LysKOM buffer")
    (discard-messages .          "Nowhere - discard them")
    (in-named-buffer .           "In a named buffer:")

    (everybody-rcpt . "Everybody                                ")
    (group-rcpt .     "The recipient of the last group message  ")
    (sender-rcpt .    "The sender of the most recent message    ")
    (last-recipient-recpt . "The last person I sent a message to")

    (viewer-program . "Web browser")
    (no-viewer            . "(ingenting valt)")
    (default-viewer       . "Browse-URL (all)")
    (netscape-viewer . "Netscape/Mozilla (all)")
    (windows-viewer       . "Windows default or Netscape/Mozilla (all)")
    (emacs-w3-viewer . "Emacs W3 mode (HTTP, Goper, FTP)")
    (emacs-general-viewer . "Emacs (FTP, Telnet, Mail)")
    (emacs-dired-viewer . "Emacs Dired (FTP)")
    (emacs-mail-viewer . "Emacs Mail mode (Mail)")
    (emacs-telnet-viewer . "Emacs Telnet mode (telnet)")
    (mosaic-viewer . "NCSA Mosaic (all)")
    (lynx-viewer          . "Lynx (all)")
    (galeon-viewer        . "Galeon (all)")

    (dont-check . "Don't ask for confirmation")
    (check-before-open . "Confirm before writing the text")
    (check-before-send . "Confirm before sending the text")
    (no-size-limit . "No limit")
    (max-size-in-bytes . "Fixed limit (in bytes)")
    (execute . "Execute")
    (kbd-macro . "Keyboard macro")
    (command . "Command")
    (enter-kbd-macro . "Enter a keybard macro. Finish with %#1s")
    (long-format .  "Show help texts")
    (short-format . "Hide help texts")

    (truncate-threshold-lines . "Max lines")

    (first . "First")
    (last . "Last")
    (specific-placement . "Specific location")
    (priority . "Priority")
    (same-as-conf . "Same as current conference")
    (custom-format . "Custom format:")
    (default-format . "Standard format")
    (a-string . "A string:")
    (some-string . "A random string")
    (unspecified . "Unspecified")

    (symbolic-mark-association . "Association")
    (symbolic-mark-name . "Symbolic name: ")
    (mark-type-to-assoc . "Mark type to associate with: ")

    (prompt-for-text-no . "Prompt for text number")

    (all-others . "All others")
    (some-person . "Person")
    (format-html . "Format HTML:")

    ;;
    ;; Misc doc strings
    ;;

    (lyskom . "Configuration of LysKOM")
    (lyskom-doc . "\\[lyskom-customize-save-and-quit] to save and quit,
\\[lyskom-customize-save-and-quit] to save and quit,
\\[lyskom-customize-save] to save without quitting,
\\[lyskom-customize-quit] to quit without saving.
\\[widget-forward] moves to the next setting
\\[widget-button-press] changes the value

Documentation:  [?] Show documentation    [!] Hide documentation
Lists etc.   :  [INS] Add a line   [DEL] Remove a line   [*] Modify

If the box before the name of the setting is selected, the setting will
be saved in the server. Otherwise it will be saved in your .emacs.")




    (section . "------------------------------------------------------------------------------\n")
    (look-and-feel-misc . "Look and feel\n")
    (window-locations   . "Windows\n")
    (windows-where      . "How are windows created:\n")
    (reading .            "Reading\n")
    (writing .            "Writing\n")
    (urls .               "URL management\n")
    (personal-messages .  "Personal messages\n")
    (remote-control .     "Remote control of LysKOM\n")
    (hooks .              "Hook functions\n")

    (audio-cues .         "Audio cues\n")
    (audio-cues-when    . "Issue audio cues when:\n")
    (automatic-replies .  "Automatic replies\n")


    (audio-cues-doc . "\
  The following group of settings controls how LysKOM issues audio cues in
  various situations. The following options are available for each setting:

    Off
        No audio cue is issued

    A Few Times
        Emacs will beep one or more times. You have to specify how many
        times Emacs is to beep.

    Audio File
        Emacs will attempt to play the specified audio file. The program
        used to play the file is specified by another setting.")
    

    (sending-doc . "\
  The following settings turn on or off certain checks that can be performed
  before sending a text to the server. The checks are designed to keep
  you from doing something stupid.

    Confirm multiple recipients
        If a text or comment has more than one recipient, LysKOM 
        can ask which of the recipients are relevant. This can either
        be done before you start writing the text, in which case 
        LysKOM will post a question for each recipient, or before sending
        the text to the server, in which case you may confirm all the
        recipients at once. It is also possible to turn this check off
        entirely.

    Check membership of commented author
        When on, LysKOM will check that the author of the comment you are
        writing is a member of at least one of the recipients of your comment.
        If not, LysKOM will offer to add the commented author as a recipient
        to the comment you are writing.

    Authors not to check
        A list of authors not to check even if check membership of
        commented author is on.

    Check for unread comments
        When this is on, LysKOM will check that you have read all the other
        comments to the text you are commenting before sending your
        comment to the server. This is supposed to help you avoid duplicating
        someone else's comment.")

    (windows-doc . "\
  The following settings control how windows are created in LysKOM. The
  available options are:


    Some other window
        In another window, but in the same frame as LysKOM. If there only
        is one window in the frame, a new window will be created (and will
        be removed when you are finished).

    Some other frame
        In a different frame than the one LysKOM is in. If there only is one
        frame, a new one will be created (and will be removed when you are
        finished).

    In a new frame
        A new frame is created (and will be removed when you are finished).

    The LysKOM buffer's window
        The LysKOM buffer's window will be used. LysKOM will be restored to
        the window when you're finished.

    A window displaying the buffer
        If there is a window anywhere displaying the named buffer, that 
        window will be used. This might be useful if you always have a
        particular buffer showing, but don't need it when executing some
        command.")


    ;;
    ;; Doc strings for variables
    ;;

    (kom-ansaphone-replies-doc . "\
  This setting controls automatic replies in detail. You can set replies
  for specific senders, recipients and even message contents. If the message
  being replied to does not match any element in this list, the default
  auto reply message above is sent instead.

  For each pattern in the list you can set the required message type, 
  sender the message must have, recipient the message must have, a regular
  expression the message must match and the reply to send.

  It is advisable to configure the client not to send a message to any
  group or alarm message.")

    (kom-bury-buffers-doc . "\
  Controls how the LysKOM buffer is handled when moving to another KOM buffer
  with the Next and Previous LysKOM commands. When turned on the current
  buffer is buried.")

    (kom-personal-messages-in-window-doc . "\
  Controls which window is used to display the buffer with personal messages.
  For this setting to have any effect, personal messages must be displayed
  in a separate buffer, and that buffer must be displayed automatically
  every time a message is received.")

    (kom-write-texts-in-window-doc . "\
  Controls which window is used to write new texts.")

    (kom-prioritize-in-window-doc . "\
  Controls which window is used to prioritize conferences.")

    (kom-edit-filters-in-window-doc . "\
  Controls which window is used for editing filters.")

    (kom-customize-in-window-doc . "\
  Controls which window is used to configure LysKOM.")

    (kom-view-commented-in-window-doc . "\
  Controls which window is used to show the commented text when commenting.")

    (kom-list-membership-in-window-doc . "\
  Controls in which window your membership list is shown.")


    (kom-user-prompt-format-doc . "\
  The format of the LysKOM prompt. Certain control sequences cause special
  text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-user-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing.
  Certain control sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-anonymous-prompt-format-doc . "\
  The format of the LysKOM prompt used when anonymous. Certain control
  sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-anonymous-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing
  and the session is anonymous. Certain control sequences cause special 
  text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-enabled-prompt-format-doc . "\
  The format of the LysKOM prompt when in administrator mode. Certain
  control sequences cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")

    (kom-enabled-prompt-format-executing-doc . "\
  The format of the LysKOM prompt when the default command is executing
  and the session is in administrator mode. Certain control sequences 
  cause special text to be inserted:

    %c - Inserts the current default command.
    %[ - Inserts `[' if the ansaphone is on.
    %] - Inserts `]' is the ansaphone is on.
    %m - Inserts information about recorded messages.
    %s - Inserts the name of the LysKOM system
    %S - Inserts the server name.
    %p - Inserts the name of the user currently logged on.
    %w - Inserts the name of the current conference.
    %a - Inserts `anonymous'
    %A - Inserts `Anonymous'
    %# - Inserts the current session number.
    %  - Inserts a space if it seems necessary.
    %% - Inserts a percent sign.

  Here are a few examples:

    \"%[%c% %m%] - \"             The default prompt
    \"%[%s: %c% %m%] - \"         Could display \"LysKOM: Time - \"")
    
    (kom-cite-string-doc . "\
  A string that is inserted before each line in a cited text. Normally this
  is set to something like \"> \". Note that it is not customary to cite
  commented texts the way it is done in e-mail or Usenet News since the
  commented text is always available in LysKOM.")


    (kom-created-texts-are-read-doc . "\
  When this is on, self-created texts are automatically marked as read. Turned
  off, those texts are presented as any other texts.")

    (kom-default-mark-doc . "\
  The default mark type used for marking texts. A mark type is an integer
  between 0 and 255 (inclusive). If no default mark type is selected, LysKOM
  asks for a mark type every time a text is to be marked. This can be used
  to separate different types of marks. You can, for example, mark texts
  which contain valuable information with a certain integer and texts which
  you should remember to comment some time with another integer.")

    (kom-symbolic-marks-alist-doc . "\
  To avoid having to memorize what the integer mark types are supposed to
  mean, you can define a list of symbolic mark types. A symbolic mark type
  is a descriptive string that is associated with an integer mark type.")

    (kom-reading-puts-comments-in-pointers-last-doc . "\
  Controls if comment links are listed before or after the body of a text.
  Normally comment links are listed after the text.

  Before:

    398331 1996-09-24  13:22  /2 lines/ George Berkeley
    Recipient: Philosophy <1226>
    Comment in text 398374 by John Locke
    Subject: 
    ------------------------------------------------------------
    An abstract idea is a contradiction in terms.
    (398331) -----------------------------------

  After:

    398331 1996-09-24  13:22  /2 lines/ George Berkeley
    Recipient: Philosophy <1226>
    Subject: 
    ------------------------------------------------------------
    An abstract idea is a contradiction in terms.
    (398331) -----------------------------------
    Comment in text 398374 by John Locke
")

    (kom-dashed-lines-doc . "\
  When this setting is turned on, dashed lines are displayed before and after
  the text body. When turned off, blank lines are used instead.

  On:

    892343 1996-09-24  19:21  /2 lines/ Tycho Brahe
    Recipien: Presentation (of new) Members
    Subject: Tycho Brahe
    ------------------------------------------------------------
    Astronomer and discoverer of stars resident on the island of Ven.
    (892343) -----------------------------------

  Off:

    892343 1996-09-24  19:21  /2 lines/ Tycho Brahe
    Recipien: Presentation (of new) Members
    Subject: Tycho Brahe

    Astronomer and discoverer of stars resident on the island of Ven.
    (892343)

  Most people have this turned on.")

    (kom-autowrap-doc . "\
  With this setting turned on, LysKOM will attempt to fill any paragraphs
  containing lines that are wider than the screen. Paragraphs that appear
  to have been preformatted by the author are exempted from this treatment.")

    (kom-show-author-at-end-doc . "\
  When this is turned on, the name of the author will be shown at the end
  of the text. The name is also shown before the text as usual.

  On (with dashed lines on):

    892342 1996-09-24  19:21  /2 lines/ Claude Shannon
    Mottagare: Presentation (of new) Members
    rende: Claude Shannon
    ------------------------------------------------------------
    Information theoretician
    (892342) /Claude Shannon/------------------------------

  Off:

    892342 1996-09-24  19:21  /2 lines/ Claude Shannon
    Recipient: Presentation (of new) Members
    Subject: Claude Shannon
    ------------------------------------------------------------
    Information theoretician
    (892342) -----------------------------------

  If dashed lines are off, the author's name will be shown as in this
  example, but the dashed lines are naturally not displayed.")

    (kom-truncate-threshold-doc . "\
  If this is activated, texts longer than the maximum number of lines will
  be truncated when you review comments, review marked texts or review the
  first or last texts in a conference.  Texts will not be truncated when
  you review a text, review a tree or read the next text.")

    (kom-truncate-show-lines-doc . "\
  The number of lines to show of truncated texts.")

    (kom-print-number-of-unread-on-entrance-doc . "\
  Determines whether the number of unread texts is shown when entering
  a conference:

  On:

    Go to next conference...
    Presentation (of new) Members - 3 unread
    Read next text - 

  Off:

    Go to next conference...
    Presentation (of new) Members
    Read next text - ")



    (kom-presence-messages-in-echo-area-doc . "\
  If you want messages in the echo area when somebody logs in, logs out or
  changes name, turn this setting on. Messages are shown in the minibuffer.
  If you want messages about a limited number of users, specify which ones.
  To not get any messages at all, just specify an empty list.")

    (kom-presence-messages-in-buffer-doc . "\
  If you want messages in the LysKOM buffer when somebody logs in, logs out
  or changes name, turn this setting on. Messages are shown in the LysKOM
  buffer. If you want messages about a limited number of users, specify which 
  ones. To not get any messages at all, just specify an empty list.")

    (kom-show-where-and-what-doc . "\
  If this is on, the list of active users will include the machine and user
  they are logged in from (if known) and what they are currently doing.

  On:

        User                                   Is in conference             
        At                                     Activity                        
    --------------------------------------------------------------------------
     6810 George Berkeley                      Philosophy                     
          berkeley@emp1.tcd.ie                 (Writing a comment.)           
     7571 John Locke                           Philosophy                     
          eridy@cc.ox.ac.uk                    (Waiting.)                     

  Off:

        User                                   Is in conference             
    --------------------------------------------------------------------------
     6810 George Berkeley                      Philosophy                     
     7571 John Locke                           Philosophy")

    (kom-show-since-and-when-doc . "\
  If this is on, the list of active users will include the connection time
  and the inactivity period for each user.")

    (kom-idle-hide-doc . "\
  The listing of active users normally only shows those users who have been
  active recently. This setting determines how many minutes a user may be
  inactive without being excluded from the list of active users.")


    (kom-show-footnotes-immediately-doc . "\
  Footnotes can be shown either as comments or immediately when the text
  they are footnotes to is displayed. This setting controls which behavior
  is used.")


    (kom-follow-comments-outside-membership-doc . "\
  LysKOM will normally not follow chains of comments into conferences you are
  not a member of. If you do want to follow comment chains into other
  conferences, turn this setting on.")


    (kom-read-depth-first-doc . "\
  LysKOM can display texts either in the order they were written or in
  the order defined by the comment tree. For example, if texts 1003 and
  1004 are comments to text 1002, text 1006 is a comment to 1003 and 
  texts 1005 and 1007 are comments to 1004, the comment tree looks 
  something like this:
        
  1002 +-- 1003 --- 1006
       |
       +-- 1004 +-- 1005
                |
                +-- 1007

  Reading in order of creation will cause the texts to be displayed
  in numerical order: 1002, 1003, 1004, 1005, 1006 and finally 1007.
  Reading in comment order will give the order 1002, 1003, 1006, 1004,
  1005 and finally 1007.")


    (kom-continuous-scrolling-doc . "\
  Turned on means that LysKOM will scroll the buffer while new text is 
  being inserted, not just at the end of a command. This works well with
  faster terminals, but may be worth turning off if the terminal is so slow
  that scrolling Emacs buffers takes a long time.")


    (kom-deferred-printing-doc . "\
  In order to improve speed, LysKOM will not print certain things, such as
  the names of users and conferences immediately, but will delay printing
  to make time for other tasks. This improves response time in the client
  considerably, and should only be turned off if it causes problems.")


    (kom-higher-priority-breaks-doc . "\
  When texts are created in conferences that have a higher priority than
  the one currently being read, LysKOM will attempt to break the normal
  reading order to show these. This setting controls whether the reading
  order is broken immediately, after the current comment chain is read or
  when everything in the current conference has been read.")


    (kom-login-hook-doc . "\
  This hook lists commands to be run when logging in, before any input is
  accepted from the keyboard.")


    (kom-do-when-done-doc . "\
  This hook lists commands and keyboard macros that are to be executed when
  all texts have been read.")


    (kom-page-before-command-doc . "\
  The LysKOM buffer can be cleared before all commands, so text that is 
  inserted always appears at the top of the buffer's window. This variable
  controls before which commands the buffer is to be scrolled.")


    (kom-permissive-completion-doc . "\
  When this is on, TAB will only complete to the names of users that are 
  logged on when the command being invoked is only applicable to people
  that are logged on. When off, TAB will complete to names of everyone.")


    (kom-membership-default-priority-doc . "\
  This specifies the how the initial priority of a conference is set when
  you first become a member. If it is a number between 1 and 255, that is
  the priority assigned. If it is something else, LysKOM will ask for a 
  priority every time you become a member of a conference.")

    (kom-show-personal-messages-in-buffer-doc . "\
  This setting specifies how personal, group and public messages are shown.
  The messages can be displayed in the LysKOM buffer, simply thrown away or
  be shown in a named buffer.")

    (kom-pop-personal-messages-doc . "\
  If messages are shown in a named buffer and this setting is also on, then
  LysKOM will display that buffer whenever a message arrives.")

    (kom-audio-player-doc . "\
  If you want LysKOM to play audio files instead of simply beeping, this
  setting must specify the name of a program that can play the audio files.
  The program must take a single argument, the name of the file to play.")

    (kom-default-message-recipient-doc . "\
  This setting controls who will be the default recipient of messages. The
  default recipient may either be everyone, i.e. a public message; the
  sender of the most recently received message; the recipient of the most
  recently received group message; or the sender of the most recently
  received personal message.")

    (kom-filter-outgoing-messages-doc . "\
  If this is on, messages that are sent automatically, such as automatic
  replies and replies to remote control commands, will be shown as if you
  had sent them manually.")

    (kom-friends-doc . "\
  The users named in this list will be displayed using a special face in
  the LysKOM buffer. These users are also listed with the command Which 
  friends (and may be used in other similar commands).")

    (kom-morons-doc . "\
  The users named in this list will be displayed using a warning face in
  the LysKOM buffer.")

    (kom-url-viewer-preferences-doc . "\
  This setting controls which WWW browser that will be used to open URLs
  found in LysKOM. If the first browser in the list cannot handle the type
  of URL being opened, then the next browser is tried, and so on.")

    (kom-windows-browser-command-doc . "\
  This setting specifies the command to use to start a web browser
  under Windows. If empty, a couple of commands that are likely the
  work on Windows will be tried.")

    (kom-mosaic-command-doc . "\
  This setting specifies the command to use to start NCSA Mosaic.")

    (kom-netscape-command-doc . "\
  This setting specifies the command to use to start Netscape or Mozilla.")

    (kom-galeon-command-doc . "\
  This setting specifies the command to use to start Galeon.")

    (kom-inhibit-typeahead-doc . "\
  Key presses are usually buffered while LysKOM is busy, and are executed
  as soon as possible. With this setting off, LysKOM discards any key presses
  received while the client was busy.")

    (kom-max-buffer-size-doc . "\
  It is possible to limit the size of the LysKOM buffer by specifying a
  maximum number of characters in this setting. When the buffer grows
  beyond this limit, text from the beginning of the buffer is removed.")

    (kom-ansaphone-record-messages-doc . "\
  LysKOM can record messages that arrive when the autoreply feature is on.
  This setting controls whether messages are recorded or not.")

    (kom-ansaphone-show-messages-doc . "\
  When this setting is on, LysKOM will display incoming messages even if
  the autoreply feature is turned on.")

    (kom-ansaphone-default-reply-doc . "\
  This is the message sent by the autoreply feature unless a different
  message has been specified using some other means (and other means are
  only for careful experts).")

    (kom-remote-control-doc . "\
  When turned on, it is possible to control the session using remote control
  commands. Only those users listed below may issue the commands.")

    (kom-remote-controllers-doc . "\
  The users listed here are permitted to issue remove control commands
  to your LysKOM session.")

    (kom-self-control-doc . "\
  When this is on, the user who is logged on may issue remote control
  commands. This is an alternative to adding yourself to the list of 
  permitted controllers.")

    (kom-customize-format-doc . "\
  The documentation for the various settings can be visible or hidden when
  you open the settings buffer. No matter if it starts hidden or visible, the
  documentation for individual settings can be shown and hidden by using the
  question mark/exclamation mark to the right of the setting.")

    (kom-default-language-doc . "\
  Default language to use in LysKOM. If you change this setting the new
  language will not be applied to the current setting. Use the Change
  language command to do that.")

    (kom-ispell-dictionary-doc . "\
  This specifies the dictionary ispell is to use for spell checking. If set
  to ispell-dictionary, then the variable ispell-dictionary will be used
  instead.")

    (kom-show-namedays-doc . "\
  This only works in Swedish. If you're running LysKOM in Swedish, turning
  this on causes today's names to be shown when you ask for the time.")

    (kom-show-week-number-doc . "\
  The Time command shows week numbers if this is on.")

    (kom-membership-default-placement-doc . "\
  This controls where new memberships are placed. First means before
  all existing memberships of the same priority. Last means after all
  existing memberships of the same priority. A number indicates a
  fixed placement (although the client will eventually sort the membership
  list in order of priority).")

    (kom-show-imported-importer-doc . "\
  The importer of an imported e-mail message is shown if this is on.
  This only works with compliant e-mail importers.")

    (kom-show-imported-envelope-sender-doc . "\
  The actual sender (the envelope sender) of imported e-mails is shown 
  if this is on. This only works with compliant e-mail importers.")

    (kom-show-imported-external-recipients-doc . "\
  Show external recipients and CC recipients of imported e-mails if this
  is on. This only works with compilant e-mail importers.")

    (kom-agree-text-doc . "\
  Default text for the Agree command. It can either be a text or a list
  of texts. If it is a list, one of the texts will be chosen at random.")

    (kom-silent-ansaphone-doc . "\
  If this is off, the client will not beep when a personal, group or
  public message is received when the auto reply feature is on.")

    (kom-default-session-priority-doc . "\
  The session priority of new sessions. Conferences with a lower priority
  will not be read.")

    (kom-unsubscribe-makes-passive-doc . "\
  When this is on, the first time you leave a conference you become a
  passive member. Leaving the conference again unsubscribes you completely.
  When this is off, leaving a conference unsubscribes you immediately.")

    (kom-review-priority-doc . "\
  Priority for review commands. This setting can be used to give review
  commands a higher priority than normal. The default priority is the
  same as the conference currently being read. Set this to 256 or higher
  if you want review commands to take precedence over all conferences.")

    (kom-show-creating-software-doc . "\
  Show the name of the client used to create a text if the information
  is present and this setting is on.")

    (kom-text-footer-format-doc . "\
  Format for the text footer. In the format string, %n is replaced by the
  text number, %P with the author's name, %p with the author's number, %f
  with information about the text (HTML, filled, etc), and %- with a
  suitable dashed line. A number after the percent sign is the minimum
  number of characters to use. A minus sign before the number causes text
  to be left justified within the field. An equals sign causes text
  longer than the indicated width to be truncated.")
 
    (kom-long-lines-doc . "\
  When this is on, most of the dashed lines are made longer than normal.")

    (kom-postpone-default-doc . "\
  Number of texts to postpone with the Postpone reading command.")

    (kom-allow-incompleteness-doc . "\
  When this is on, the client will not wait for information about all
  unread texts, even if it is needed. The result is that List news and
  some other commands do not yield accurate results shortly after logging
  in. When this is off, the client will wait for information on all
  unread texts when it is needed.")

    (kom-smileys-doc . "\
  When this is on, Emacs supports it, and the appropriate package 
  (smiley.el, which is part of Gnus) is installed, smileys will be
  shown graphically.")
  
    (kom-ignore-message-senders-doc . "\
  Don't show personal, group or alarm messages from these senders.")

    (kom-ignore-message-recipients-doc . "\
  Don't show group messages to these recipients.")

    (kom-text-footer-dash-length-doc . "\
  The total length of the text footer when long dashed lines are not
  in effect and no custom format is being used.")

    (kom-text-header-dash-length-doc . "\
  The total length of the text header when long dashed lines are not
  in effect.")

    (kom-show-personal-message-date-doc . "\
  When this is on, the date and time is shown on all personal, group and
  alarm messages.")

    (kom-w3-simplify-body-doc . "\
  When this is on, the client will ignore colors set in the HTML body when
  displaying formatted HTML.")

    (kom-mercial-doc . "\
  This text is shown in the list of users when you have finished reading
  everything.")

    (kom-server-priority-doc . "\
  Priority of this LysKOM session. The client can prompt you to go to
  a session with unread texts when a text arrives in a session with a
  higher priority than the one currently being read.")

    (kom-server-priority-breaks-doc . "\
   This setting controls when a prompt to go to the next LysKOM session
   with unread texts is presented.

   Immediately                  Present a prompt if any text arrives in
                                a session with a higher priority.

   Immediately if letters arrive    Present a prompt is a letter arrives
                                in a session with a higher priority.

   After current comment chain  Present a prompt after the current chain
                                of comments has been read if a text
                                arrives in a session with a higher 
                                priority.

   After current comment chain if letters arrive    Present a prompt
                                after the current chain of comments has
                                been read if a letter arrives in a session
                                with a higher priority.

   After current conference     Present a prompt after all texts in the
                                current conference have been read if a
                                text arrives in a session with a higher
                                priority.

   After current conference if letters arrive       Present a prompt 
                                after all texts in the current conference
                                have been read if a letter arrives in a 
                                session with a higher priority.

   After everything has been read   Present a prompt to go to the next
                                session with unreads after everything
                                has been read. The prompt is presented
                                regardless of session priorities.

   Never                        Never prompt to go to another LysKOM
                                session.")

    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-personal-messages-doc . "")
    (kom-ding-on-group-messages-doc . "")
    (kom-ding-on-common-messages-doc . "")
    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-wait-done-doc . "")
    (kom-ding-on-priority-break-doc . "")
    (kom-ding-on-new-letter-doc . "")
    (kom-check-for-new-comments-doc . "")
    (kom-check-commented-author-membership . "")
    (kom-confirm-multiple-recipients-doc . "")
    (kom-check-commented-author-membership-doc . "")
    (kom-complete-numbers-before-names-doc . "\
   When this is on and you enter a text that can be either a conference
   number or a conference name, the client will accept it as a conference 
   number, if possible. When this is off, the text will be accepted as
   a conference name first and number second.")
    (kom-keep-alive-interval-doc . "\
  The number of seconds between calls to the server used to keep the
  network connection to the LysKOM server active. If your network connection
  shuts down after a period of inactivity, set this to approximately half
  that period and use the command `Keep connection alive'.")
    (kom-text-no-prompts-doc . "\
  Specifies which commands will always prompt for text numbers and which
  will not. Commands that are not listed here will use default behavior.")
    (kom-saved-file-name-doc . "\
  Specifies the default file to archive texts in. The client will always
  prompt for the file name, using this as the default.")
    (kom-follow-attachments-doc . "\
  Specifies whether to read imported e-mail attachments as regular
  comments. When off, imported attachments are marked as read when the
  e-mail they are attached to is read.")
    (kom-show-unread-in-frame-title-doc . "\
  When this is on, the indicator \"(Unread)\" is shown in the title
  bar of all windows whose active buffer belongs to a LysKOM session
  with unread texts. The title bar may not be updated unless the
  window is open.")
    (kom-created-texts-are-saved-doc . "\
  If this variable is set to a file name, all texts you write will be 
  saved to that file. Texts that could not be created are not saved.")
    (kom-confirm-add-recipients-doc . "\
  When this is on and you add a recipient to a text, the client will
  ask if comments to the text should also be sent to the new
  recipient. When this is off, comments will always be sent to the new
  recipient. For most people it is a good idea to leave this on.")

    (kom-trim-buffer-minimum-doc . "\
  If you have limited the LysKOM buffer size, this variable determines
  how much larger than the limit the buffer has to be before it is
  trimmed back to the maximum size. The variable must be an integer;
  the default is 4096.")

    (kom-dont-check-commented-authors-doc . "")
    (kom-print-relative-dates-doc . "\
  The time fields of texts (and a couple of other things) will be
  \"today\" or \"yesterday\" if this setting is on and the text was
  written today or yesterday, respectively. If it is off, absolute
  dates will always be shown.")
    (kom-print-seconds-in-time-strings-doc . "\
  If this setting is on, some time strings (for example the creation
  time of texts and sent messages) will include seconds.")
    (kom-review-uses-cache-doc . "\
  If this is turned on, commands that review texts will use saved copies
  of the text rather then get new copies from the server. This makes the
  commands run significantly faster, but in some cases the texts may 
  have changed since they were copied, and you will not see those 
  changes.")
    (kom-review-marks-texts-as-read-doc . "\
  If this is turned on, commands that review texts will also mark them
  as read. Otherwise, the review commands will leave your reading history
  untouched, as usual.")
    (kom-auto-review-faqs-doc . "\
  If this is turned on, FAQs that are not marked as read will be reviewed
  automatically when you log on or go to a conference with a new FAQ.")
    (kom-auto-list-faqs-doc . "\
  If this is turned on, new FAQs will be listed automatically when you
  log on or go to a conference with a new FAQ.")
    (kom-extended-status-information-doc . "\
  When this is on, additional information may be shown by commands that
  display person, conference and server status.")
    (kom-highlight-first-line-doc . "\
  When this is on, the first line (with text number, date and author) is
  shown with a different format than normal text.")
    (kom-highlight-dashed-lines-doc . "\
  When this is on, the lines before and after the text body is shown with
  a different format than normal text.")
    (kom-highlight-text-body-doc . "\
  When this is on, the text body is shown with a different format than
  normal text.")
    (kom-async-highlight-dashed-lines-doc . "\
  When this is on, the lines before and after personal, group- and alarm
  messages are shown with  a different format than normal text.")
    (kom-async-highlight-text-body-doc . "\
  When this is on, the body of personal, group- and alarm messages are
  shown with a different format than normal text.")
    (kom-edit-hide-add-button-doc . "\
  When this is on, an [Add...] button will be shown after the list of
  recipients and auxiliary information when writing a new text.")
    (kom-format-html-authors-doc . "\
  This setting controls which author's HTML messages that the client will
  attempt to format.")
    (kom-keyboard-menu-immediate-selection-doc . "\
  This setting controls whether keyboard shortcuts in text-based context
  menus require confirmation with return or not. With this on you have
  to confirm all selections with return.")
    (kom-max-overlays-doc . "\
  Use this setting to limit the number of overlays in the LysKOM buffer
  \(overlays are used to create the colored backgrounds for texts\). By
  limiting the number of overlays it is possible to speed up operations
  such as scrolling significantly. Each text requires 1-4 overlays for
  highlighting, depending on other settings.")


    ;;
    ;; Tags for variables
    ;;
    
    (kom-ansaphone-replies-tag . "Automatic replies")
    (kom-bury-buffers-tag . "Bury buffers when changing LysKOM:")

  (kom-personal-messages-in-window-tag . "Personal messages:      ")
    (kom-customize-in-window-tag       . "LysKOM customization:   ")
    (kom-write-texts-in-window-tag     . "Author new texts:       ")
    (kom-prioritize-in-window-tag      . "Prioritize conferences: ")
    (kom-edit-filters-in-window-tag    . "Modify filters:         ")
    (kom-view-commented-in-window-tag  . "Review comments:        ")
    (kom-list-membership-in-window-tag . "List membership:        ")

    (kom-user-prompt-format-tag . "Prompt format:")
    (kom-user-prompt-format-executing-tag . "Prompt format when executing:")
    (kom-anonymous-prompt-format-tag . "Prompt format (anonymous):")
    (kom-anonymous-prompt-format-executing-tag . "Prompt format when executing (anonymous):")
    (kom-enabled-prompt-format-tag . "Prompt format (admin):")
    (kom-enabled-prompt-format-executing-tag . "Prompt format when executing (admin):")

    (kom-higher-priority-breaks-tag . 
"Read prioritized texts:                           ")
    (kom-created-texts-are-read-tag . 
"Automatically read created texts:                 ")
    (kom-default-mark-tag           . 
"Default mark:                                     ")
    (kom-print-number-of-unread-on-entrance-tag . 
"Show number of unread when entering a conference: ")
    (kom-follow-comments-outside-membership-tag .
"Follow comment chains outside membership:         ")
    (kom-show-footnotes-immediately-tag .
"Show footnotes immediately:                       ")
    (kom-membership-default-priority-tag . 
"Default priority for new memberships:             ")
    (kom-dashed-lines-tag . 
"Dashed lines around the text body:                ")
    (kom-autowrap-tag . 
"Fill wide paragraphs before displaying:           ")
    (kom-show-author-at-end-tag .
"Show the name of the author after the body:       ")

    (kom-truncate-threshold-tag .
"Truncate long texts:                              ")
    (kom-truncate-show-lines-tag .
"Lines to show of truncated texts:                 ")

    (kom-reading-puts-comments-in-pointers-last-tag . "Comment links are shown:")
    (kom-read-depth-first-tag . "Read order:")
    (kom-deferred-printing-tag . "Delayed display:")
    (kom-continuous-scrolling-tag . "Continuous scrolling:")

    (kom-presence-messages-in-echo-area-tag . 
"Presence messages in echo area:        ")
    (kom-presence-messages-in-buffer-tag .
"Presence messages in the LysKOM buffer:")
    (kom-page-before-command-tag . "Clear the screen:")

    (kom-idle-hide-tag . 
"Number of minutes of inactivity before session is hidden:      ")
    (kom-show-where-and-what-tag . 
"Show where sessions are logged on from and what they are doing:    ")
    (kom-show-since-and-when-tag . 
"Show when sessions connected and how long they have been inactive: ")



    (kom-login-hook-tag . "Commands executed after logging on:")
    (kom-do-when-done-tag . "Commands to execute after reading everything:")
    (kom-permissive-completion-tag . "Fussy name completion:")
    (kom-show-personal-messages-in-buffer-tag . 
"Where are messages shown: ")
    (kom-pop-personal-messages-tag . 
"Pop up message buffer:    ")
    (kom-default-message-recipient-tag . 
"Default message recipient:")

    (kom-audio-player-tag . "Audio player program:")
    (kom-ding-on-new-letter-tag        . "When a letter arrives:            ")
    (kom-ding-on-priority-break-tag    . "When a prioritized text arrives:  ")
    (kom-ding-on-wait-done-tag         . "When done waiting:                ")
    (kom-ding-on-common-messages-tag   . "When a public message arrives:    ")
    (kom-ding-on-group-messages-tag    . "When a group message arrives:     ")
    (kom-ding-on-personal-messages-tag . "When a personal message arrives:  ")
    (kom-ding-on-no-subject-tag     .    "When you forget the subject line: ")

    (kom-filter-outgoing-messages-tag . "Show automatic messages:")
    (kom-friends-tag . "Friends and other special people:")
    (kom-morons-tag . "Morons and other \"special\" people:")
    (kom-url-viewer-preferences-tag . "Open URLs using the following program:")
    (kom-windows-browser-command-tag . "Command to start a web browser on Windows:")
    (kom-mosaic-command-tag . "Command to start NCSA Mosaic:")
    (kom-netscape-command-tag . "Command to start Netscape/Mozilla:")
    (kom-galeon-command-tag . "Command to start Galeon:")

    (kom-symbolic-marks-alist-tag . "Symbolic mark types:")

    (kom-cite-string-tag . "Quotation indicator:")
    (kom-confirm-multiple-recipients-tag . 
"Confirm multiple recipients:         ")
    (kom-check-commented-author-membership-tag . 
"Check membership of commented author:")
    (kom-check-for-new-comments-tag . 
"Check for unread comments:           ")

    (kom-ansaphone-record-messages-tag . 
"Save messages when auto reply is on:    ")
    (kom-ansaphone-show-messages-tag . 
"Display messages when auto reply is on: ")
    (kom-ansaphone-default-reply-tag . "Auto reply message:")


    (kom-inhibit-typeahead-tag . "Buffer keypresses:")
    (kom-max-buffer-size-tag . "Maximum buffer size:")

    (kom-remote-control-tag .     "Remote commands on or off:             ")
    (kom-self-control-tag .       "Allow me to use remote commands:       ")
    (kom-remote-controllers-tag . "People allowed to use remove commands:")

    (kom-customize-format-tag . "Show documentation for all settings:")
    (kom-default-language-tag . "Default language:  ")
    (kom-show-namedays-tag    . "Show today's names:")
    (kom-ispell-dictionary-tag . "Spelling dictionary:")

    (kom-show-week-number-tag . "Show week number:")
    (kom-membership-default-placement-tag . "Placement of new memberships:")
    (kom-show-imported-importer-tag . "Show importer of imported messages:")
    (kom-show-imported-envelope-sender-tag . "Show sender of imported messages:")
    (kom-show-imported-external-recipients-tag . "Show external recipients of imported messages:")
    (kom-agree-text-tag . "Default text for Agree:")
    (kom-silent-ansaphone-tag . "Beep when auto reply is on:")
    (kom-default-session-priority-tag . "Default session priority:")
    (kom-unsubscribe-makes-passive-tag . "Leaving a conference converts membership to passive:")
    (kom-review-priority-tag . "Priority for review commands:")
    (kom-show-creating-software-tag . "Show creating software:")
    (kom-text-footer-format-tag . "Text footer format:")
    (kom-long-lines-tag . "Long dashed lines:")
    (kom-postpone-default-tag . "Default number of texts to postpone:")
    (kom-allow-incompleteness-tag . "Allow incomplete information about unread texts:")
    (kom-smileys-tag . "Show smileys graphically:")
    (kom-ignore-message-senders-tag . "Don't show messages from:")
    (kom-ignore-message-recipients-tag . "Don't show messages to:")
    (kom-text-footer-dash-length-tag . "Text footer length:")
    (kom-text-header-dash-length-tag . "Length of dashed line before text:")
    (kom-show-personal-message-date-tag . "Show date and time of messages:")
    (kom-w3-simplify-body-tag . "Display HTML without document colors:")
    (kom-mercial-tag . "Text to display when all is read:")
    (kom-server-priority-tag . "Session priority:")
    (kom-server-priority-breaks-tag . "Prompt to go to next LysKOM:")
    (kom-complete-numbers-before-names-tag . "Read conference numbers before names:")
    (kom-keep-alive-interval-tag . "Keep connection alive interval:")
    (kom-text-no-prompts-tag . "How commands prompt for text numbers:")
    (kom-saved-file-name-tag . "File to archive texts in:")
    (kom-follow-attachments-tag . "Read imported attachments as texts:")
    (kom-show-unread-in-frame-title-tag . "Show unread indicator in title bar:")
    (kom-created-texts-are-saved-tag . "Save created texts:")
    (kom-confirm-add-recipients-tag . "Ask if comments should be sent to new recipients:")
    (kom-trim-buffer-minimum-tag . "How small parts of the LysKOM buffer are trimmed:")
    (kom-dont-check-commented-authors-tag . "Authors not to check:")
    (kom-print-relative-dates-tag . "Show relative dates:")
    (kom-print-seconds-in-time-strings-tag . "Include seconds in time strings:")
    (kom-review-uses-cache-tag . "Review commands use cached texts:")
    (kom-review-marks-texts-as-read-tag . "Review commands mark texts as read:")
    (kom-auto-review-faqs-tag . "Review new FAQs automatically:")
    (kom-auto-list-faqs-tag . "List new FAQs automatically:")
    (kom-extended-status-information-tag . "Extended status information:")
    (kom-highlight-first-line-tag . "Color fist line:")
    (kom-highlight-dashed-lines-tag . "Color dashed lines:")
    (kom-highlight-text-body-tag . "Color text backgrounds:")
    (kom-async-highlight-dashed-lines-tag . "Color dashed lines around messages:")
    (kom-async-highlight-text-body-tag . "Color message backgrounds:")
    (kom-edit-hide-add-button-tag . "Show add button when writing texts:")
    (kom-format-html-authors-tag . "Format HTML-messages per author:")
    (kom-keyboard-menu-immediate-selection-tag . "Shortcuts in text menus require confirmation:")
    (kom-max-overlays-tag . "Maximum number of overlays:")
    )
)






;;;; ============================================================
;;;; The default Ansaphone message goes here. The more complex 
;;;; message specification probably should too, but it's not here
;;;; yet. People who know how to use it are smart enough to do it
;;;; right.

(lyskom-language-var local kom-ansaphone-default-reply en 
  "I am not reading LysKOM right now. Please write a letter instead.")
        
;;;; ============================================================
;;;; Other language-dependent variables
;;;;

(lyskom-language-var local kom-ispell-dictionary en
  "english")



;;;; ================================================================
;;;; Tell phrases should be configured with the default language used
;;;; at the server and not for person reading if they happens to
;;;; differ. This is of course because they are sent to the server for
;;;; everybody else to see.

;;;; Aronsson was here 4 DEC 1990, thus creating version 0.18
					; Created *-tell-*


;;; To coders of the elisp-client:
;;; You not only have to change the text here, you also have to modify
;;; kom-tell-phrases-validation-list in vars.el if you add or remove
;;; one of these.

(eval-when-compile (defvar kom-tell-phrases))

(lyskom-language-strings local kom-tell-phrases en
  '((kom-tell-silence		. "") ; Why ?
    (kom-tell-send		. "Is trying to post a text.")
    (kom-tell-login		. "Is entering LysKOM.")
    (kom-tell-read		. "Is reading.")
    (kom-tell-1st-pres		. "Is writing the first presentation.")
    (kom-tell-write-comment	. "Is writing a comment.")
    (kom-tell-write-footnote	. "Is writing a footnote.")
    (kom-tell-write-letter	. "Is writing a letter.")
    (kom-tell-write-reply	. "Is writing a personal reply.")
    (kom-tell-write-text	. "Is writing a text.")
    (kom-tell-conf-pres		. "Is writing the presentation for a new conference.")
    (kom-tell-recover		. "Is restarting KOM. Sigh.")
    (kom-tell-wait		. "Is waiting.")
    (kom-tell-regret		. "Decides to throw away the text.")
    (kom-tell-review		. "Is reviewing.")
    (kom-tell-change-name       . "Takes on a new name.")
    (kom-tell-change-supervisor . "Changes the supervisor of something.")
    (kom-tell-next-lyskom	. "Moves to a different LysKOM.")))

(if (and (boundp 'kom-tell-phrases)
         kom-tell-phrases)
    (lyskom-language-strings local kom-tell-phrases en
      (mapcar (function 
               (lambda (x)
                 (cond ((and (consp x)
                             (symbolp (car x))
                             (stringp (cdr x))) x)
                       ((and (consp x)
                             (symbolp (car x))
                             (consp (cdr x))
                             (stringp (car (cdr x))))
                        (cons (car x) (car (cdr x))))
                       (t nil))))
              kom-tell-phrases)))


;; Placed here because this must NOT be evaluated before 
;; kom-tell-phrases is defined:

(lyskom-language-var local kom-mercial en (lyskom-get-string 'kom-tell-wait 
                                                       'kom-tell-phrases))


(lyskom-language-strings local lyskom-error-texts en
  '((error-0 . "No error")
    (error-2 . "Not yet implemented")
    (error-3 . "No longer implemented")
    (error-4 . "Wrong password")
    (error-5 . "String too long")
    (error-6 . "You have not logged on")
    (error-7 . "Nobody may enter LysKOM at this time")
    (error-8 . "You attempted to use conference number 0")
    (error-9 . "Undefined or secret conference")
    (error-10 . "Undefined or secret user")
    (error-11 . "No read or write permission")
    (error-12 . "Illegal operation")
    (error-13 . "You are not a member of that conference")
    (error-14 . "There is no text with that number")
    (error-15 . "You cannot use global text number 0")
    (error-16 . "There is no text with that local number")
    (error-17 . "You cannot use local text number 0")
    (error-18 . "Name too short, too long or containing illegal characters")
    (error-19 . "Index out of bounds")
    (error-20 . "The conference already exists")
    (error-21 . "The user already exists")
    (error-22 . "Secret but not read-protected")
    (error-23 . "You are not allowed to change the person/conference flag")
    (error-24 . "Error in the database. Tough luck.")
    (error-25 . "Invalid recipient or comment type")
    (error-26 . "Illegal info type. (Bug in the client)")
    (error-27 . "Already recipient of this text")
    (error-28 . "Already comment to this text")
    (error-29 . "Already footnote to this text")
    (error-30 . "Not a recipient of this text")
    (error-31 . "Not a comment to this text")
    (error-32 . "Not a footnote to this text")
    (error-33 . "Too many recipients")
    (error-34 . "Too many commentsp")
    (error-35 . "Too many footnotes")
    (error-36 . "Too many marks")
    (error-37 . "You are not the author of that text")
    (error-38 . "You cannot connect to the server")
    (error-39 . "Out of memory")
    (error-40 . "The server is gone crazy")
    (error-41 . "The client thinks that the server says that it does not understand the client")
    (error-42 . "No such session")
    (error-43 . "Invalid regular expression")
    (error-44 . "Can't unmark a text that was not marked")
    (error-45 . "Temorary lossage. Please try again later")
    (error-46 . "Sending huge messages to the server is not a nice thing to do")
    (error-47 . "Anonymous texts are not accepted by all recipients")
    (error-48 . "Invalid auxiliary information")
    (error-49 . "Change of auxiliary information not permitted")
    (error-50 . "Unknown asynchronous message")
    (error-51 . "Internal server error")
    (error-52 . "Feature disabled in the server")
    (error-53 . "Unable to send message")
    (error-54 . "Invalid membership type")
))

(lyskom-language-var global lyskom-unread-mode-line en
  (lyskom-make-lyskom-unread-mode-line))

(lyskom-language-var global lyskom-unread-title-format en
  (lyskom-make-lyskom-unread-title-format))

(lyskom-language-var local lyskom-help-data en lyskom-en-help-data)


(provide 'lyskom-strings)

;;; english-strings ends here

(defvar lyskom-en-help-data (quote ((conferences "Conferences" (section ((id . "conferences") (prompt . "Conferences")) ((h1 nil ((TEXT . "Conferences"))) (p nil ((TEXT . " Every LysKOM system is organized as a set of conferences, each covering a separate topic. Anybody can create a conference, but you should think twice before doing so. In a mature LysKOM system the conference you want to create probably already exists. "))) (p nil ((TEXT . " Conferences can be open, closed and secret. Anyone can join and read texts in all open conferences. To join a closed conference, the conference administractor has to grant membership. Secret conferences are secret: you can't even see them unless you're a member. Most conferences are open. Closed and secret conferences are much less common. "))) (p nil ((TEXT . " The following commands might be useful to get started: "))) (inline ((id . "kom-list-conferences")) nil) (inline ((id . "kom-review-presentation")) nil) (inline ((id . "kom-add-self")) nil) (inline ((id . "kom-go-to-conf")) nil) (h2 nil ((TEXT . "Priorities"))) (p nil ((TEXT . " Your memberships have priorities. When you log on, conferences with higher priority will be presented before conferences with lower priority. Use ") (cref ((id . "kom-prioritize")) nil) (TEXT . " to change your priorities. ")))))) (persons "Persons" (section ((id . "persons") (prompt . "Persons")) ((h1 nil ((TEXT . "Persons"))) (p nil ((TEXT . " Every LysKOM user has a person. A person contains some statistics about what the user has done (texts created, texts read, logon time, and some other stuff). Every person is also associated with a letterbox with the same name of the person. The letterbox is essentially a regular closed conference. ")))))) (texts "Texts" (section ((id . "texts") (prompt . "Texts")) ((h1 nil ((TEXT . "Texts"))) (p nil ((TEXT . " The purpose of LysKOM is to communicate, and communication is done through texts. Texts are simply texts written by a LysKOM member. "))) (h2 nil ((TEXT . "Recipients"))) (p nil ((TEXT . " Every text has one or more recipients: conferences to which the text has been sent. There are three kinds of recipients: regular recipients, cc-recipients and bcc-recipients. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "Regular recipients"))) (TEXT . " are the most common. A regular recipient means that the text belongs in the specified conference (or conferences). Comments to the text will automatically be sent to the same set of recipients. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "CC recipients"))) (TEXT . " are used when you want to send a copy of a text to a conference, but don't want followups sent to that conference. "))) (p nil ((TEXT . " ") (b nil ((TEXT . "BCC recipients"))) (TEXT . " are fairly unusual. To even ") (i nil ((TEXT . "see"))) (TEXT . " a BCC recipient you have to have permission to be a member in the recipient conference. This kind of recipient can be used when you want to send a copy of a text to somebody's letterbox, but don't want other readers to know. "))) (h2 nil ((TEXT . "Comments"))) (p nil ((TEXT . " A text can have comments. A thread of comments to comments to comments is often called comment thread, comment chain or comment tree (strictly speaking a comment thread is a path down the comment tree). Anyone can write comments to any text. There is not requirement that comments be sent to the same conferences as the commented texts. "))) (h2 nil ((TEXT . "Special texts"))) (p nil ((TEXT . " There are three kinds of special texts: presentations, FAQs and notices. A presentation is a text associated with a conference or letterbox, that contains a presentation of that conference or person. These are normally sent to special conferences. A FAQ is a text with frequently asked questions (and answers) in a particular conference. Normally, new FAQs will be displayed when entering the associated conference. Notices are texts that contain urgent information about a person or conference. You can use a notice when you will be away from LysKOM for a while, and similar occasions. ")))))) (settings "Settings" (section ((id . "settings") (prompt . "Settings")) ((h1 nil ((TEXT . "Settings"))) (p nil ((TEXT . " The elisp client has a large number of user-configurable settings. With a few exceptions you can change these by using the command ") (cref ((id . "kom-customize")) nil) (TEXT . ". "))) (p nil ((TEXT . " Settings can be saved in the server or in your .emacs. Settings that are saved in the server will apply only for a particular user on a particular server. Settings saved in .emacs take precedence over settings stored in the server. ")))))) (reading "Reading texts" (section ((id . "reading") (prompt . "Reading texts")) ((h1 nil ((TEXT . "Reading texts"))) (p nil ((TEXT . " To just read texts in the default order, simply press SPC until all texts have been displayed. The elisp client will display one text at a time until you have read all texts in all conferences you are a member of. Use the command ") (cref ((id . "kom-list-summary")) nil) (TEXT . " to see which texts will be shown. There are a large number of more advanced commands, some of which are listed in the sections mentioned below. "))) (list ((header . "See also:")) ((item nil ((refer ((id . "filter")) nil))) (item nil ((refer ((id . "review")) nil))) (item nil ((refer ((id . "mark")) nil)))))))) (filter "Avoiding certain texts" (section ((id . "filter") (prompt . "Avoiding certain texts")) ((h1 nil ((TEXT . "Avoiding certain texts"))) (p nil ((TEXT . " Sometimes you don't want to read certain texts. In those cases the following commands may be useful. Besides these, there are a number of commands for filtering texts, if there is a certain type of text you never want to see. "))) (inline ((id . "kom-set-unread")) nil) (inline ((id . "kom-jump")) nil) (inline ((id . "kom-super-jump")) nil)))) (mark "Remembering texts" (section ((id . "mark") (prompt . "Remembering texts")) ((h1 nil ((TEXT . "Remembering texts"))) (p nil ((TEXT . " Sometimes you might find a text that you want to remember. In these cases, mark the text. A mark is really just a number from 0 to 255, but the elisp client supports assigning easy-to-remember names to marks. "))) (inline ((id . "kom-mark-text")) nil) (inline ((id . "kom-unmark-text")) nil) (inline ((id . "kom-review-all-marked-texts")) nil) (inline ((id . "kom-review-marked-texts")) nil) (inline ((id . "kom-list-marks")) nil)))) (review "Finding old texts" (section ((id . "review") (prompt . "Finding old texts")) ((h1 nil ((TEXT . "Finding old texts"))) (p nil ((TEXT . " There are a large number of commands for finding old texts. All of these start with the word \"Review\". This is just a small sampling: "))) (inline ((id . "kom-review-by-to")) nil) (inline ((id . "kom-review-first")) nil) (inline ((id . "kom-review-more")) nil) (inline ((id . "kom-review-clear")) nil) (inline ((id . "kom-view-commented-text")) nil) (inline ((id . "kom-review-comments")) nil) (inline ((id . "kom-find-root-review")) nil) (inline ((id . "kom-find-root")) nil) (inline ((id . "kom-review-tree")) nil)))) (writing "Writing or changing texts" (section ((id . "writing") (prompt . "Writing or changing texts")) ((h1 nil ((TEXT . "Writing or changing texts"))) (p nil ((TEXT . " There are three basic types of texts: texts, comments and footnotes. All of them are texts, but they are associated to ") (i nil ((TEXT . "other"))) (TEXT . " texts in different ways. "))) (h2 nil ((TEXT . "Texts"))) (p nil ((TEXT . " These are texts that aren't comments to other texts. They start a new thread of discussion. Remember to choose a good subject line when you create new texts. "))) (inline ((id . "kom-write-text")) nil) (inline ((id . "kom-send-letter")) nil) (h2 nil ((TEXT . "Comments"))) (p nil ((TEXT . " Comments are texts that are comments to other texts. When you write a comment, check that the subject line and recipients are still suitable. Personal replies are simply comments sent to somebody's letterbox. "))) (inline ((id . "kom-write-comment")) nil) (inline ((id . "kom-private-answer")) nil) (h2 nil ((TEXT . "Footnotes"))) (p nil ((TEXT . " Footnotes are special comments that only the author of a text can create. Since they are presented before regular comments, they are useful when you want to clarify something you've written before people start writing comments to the text. "))) (inline ((id . "kom-write-footnote")) nil) (h2 nil ((TEXT . "Prefix argument"))) (p nil ((TEXT . " There are several ways to specify which text you want to comment or write a footnote to. When you give any of the comments listed above without an argument, they will apply to the most recenty read text. "))) (p nil ((TEXT . " Sometimes you want a different text. There are a few commands that apply to the next-to-most-recently read (") (cref ((id . "kom-comment-previous")) nil) (TEXT . ", ") (cref ((id . "kom-private-answer-previous")) nil) (TEXT . "), and by using prefix arguments you can specify any text to any command. Supply a prefix argument as usual in Emacs by C-u followed by the argument, or simply type the argument directly. "))) (p nil ((TEXT . " Specify text ") (i nil ((TEXT . "N"))) (TEXT . " by giving the text number as the prefix argument. Specify the text where the cursor is by giving prefix argument 0. Specify the text ") (i nil ((TEXT . "N"))) (TEXT . " texts back in the buffer from the point where the cursor is by giving the prefix argument -") (i nil ((TEXT . "N"))) (TEXT . ". To get a prompt at which you can type the text number, simply hit C-u before giving the command. "))) (h2 nil ((TEXT . "Manage recipients"))) (p nil ((TEXT . " To change the recipients on a text you have to be the author of the text or administrator of the recipient you want to change. Use the commands ") (cref ((id . "kom-add-recipient")) nil) (TEXT . " to add and ") (cref ((id . "kom-sub-recipient")) nil) (TEXT . " to remove recipients. "))) (h2 nil ((TEXT . "Messages and remarks"))) (p nil ((TEXT . " Never use messages (personal, group or alarm messages) or remarks in place of regular texts. It won't work and people will get upset. ")))))) (kom-list-conferences "" (section ((id . "kom-list-conferences") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-conferences")) nil))) (p nil ((TEXT . " List conferences in LysKOM. Use this command with creative arguments to find conferences that you're interested in. ")))))) (kom-list-re "" (section ((id . "kom-list-re") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-re")) nil))) (p nil ((TEXT . " List conferences in LysKOM. Use this command with creative arguments to find conferences that you're interested in. ")))))) (kom-review-presentation "" (section ((id . "kom-review-presentation") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-presentation")) nil))) (p nil ((TEXT . " Show the presentation for a conference or person. Use this command to get more information about a conference. ")))))) (kom-add-self "" (section ((id . "kom-add-self") (prompt . "")) ((h3 nil ((cref ((id . "kom-add-self")) nil))) (p nil ((TEXT . " Join a conference so you can read the texts in the conference and so you'll find out when new texts are created. ")))))) (kom-go-to-conf "" (section ((id . "kom-go-to-conf") (prompt . "")) ((h3 nil ((cref ((id . "kom-go-to-conf")) nil))) (p nil ((TEXT . " Go to a conference you want to read texts in. If you aren't already a member of the conference, you will be asked if you want to join the conference. ")))))) (kom-write-footnote "" (section ((id . "kom-write-footnote") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-footnote")) nil))) (p nil ((TEXT . " Creates a new footnote to an existing text. ")))))) (kom-private-answer "" (section ((id . "kom-private-answer") (prompt . "")) ((h3 nil ((cref ((id . "kom-private-answer")) nil))) (p nil ((TEXT . " Creates a private reply to the author of an existing text. ")))))) (kom-write-comment "" (section ((id . "kom-write-comment") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-comment")) nil))) (p nil ((TEXT . " Creates a new comment to an existing text. ")))))) (kom-send-letter "" (section ((id . "kom-send-letter") (prompt . "")) ((h3 nil ((cref ((id . "kom-send-letter")) nil))) (p nil ((TEXT . " Creates a new letter. ")))))) (kom-write-text "" (section ((id . "kom-write-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-write-text")) nil))) (p nil ((TEXT . " Creates a new text that is not a comment to any other text. ")))))) (kom-review-tree "" (section ((id . "kom-review-tree") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-tree")) nil))) (p nil ((TEXT . " Reviews the entire tree of comments under the specified text. ")))))) (kom-find-root "" (section ((id . "kom-find-root") (prompt . "")) ((h3 nil ((cref ((id . "kom-find-root")) nil))) (p nil ((TEXT . " Finds the text that started the discussion that the specified text is part of. ")))))) (kom-find-root-review "" (section ((id . "kom-find-root-review") (prompt . "")) ((h3 nil ((cref ((id . "kom-find-root-review")) nil))) (p nil ((TEXT . " Reviews the entire tree of comments that the specified text is part of. Essentially the same as doing ") (cref ((id . "kom-find-root")) nil) (TEXT . " followed by ") (cref ((id . "kom-review-tree")) nil) (TEXT . ". ")))))) (kom-review-comments "" (section ((id . "kom-review-comments") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-comments")) nil))) (p nil ((TEXT . " Reviews all comments to the specified text, but not the comments to the comments. ")))))) (kom-view-commented-text "" (section ((id . "kom-view-commented-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-view-commented-text")) nil))) (p nil ((TEXT . " Reviews the text to which the specified text is a comment. ")))))) (kom-review-clear "" (section ((id . "kom-review-clear") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-clear")) nil))) (p nil ((TEXT . " Aborts all review commands that are active. ")))))) (kom-review-more "" (section ((id . "kom-review-more") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-more")) nil))) (p nil ((TEXT . " Reviews more texts using the same criteria as the most recent ") (cref ((id . "kom-review-by-to")) nil) (TEXT . ", or ") (cref ((id . "kom-review-first")) nil) (TEXT . " command. ")))))) (kom-review-first "" (section ((id . "kom-review-first") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-first")) nil))) (p nil ((TEXT . " Reviews the first text(s) created by a particular person sent to a particular conference. Any parameter can be ignored by simply not supplying a value (use zero for the number of texts) in order to do things like review all texts to a particular conference, the first five texts written by a particular person and so forth. ")))))) (kom-review-by-to "" (section ((id . "kom-review-by-to") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-by-to")) nil))) (p nil ((TEXT . " Reviews the text(s) most recently created by a particular person sent to a particular conference. Any parameter can be ignored by simply not supplying a value (use zero for the number of texts) in order to do things like review all texts to a particular conference, the last five texts written by a particular person and so forth. ")))))) (kom-list-marks "" (section ((id . "kom-list-marks") (prompt . "")) ((h3 nil ((cref ((id . "kom-list-marks")) nil))) (p nil ((TEXT . " Lists all texts marked with a particular mark. ")))))) (kom-review-marked-texts "" (section ((id . "kom-review-marked-texts") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-marked-texts")) nil))) (p nil ((TEXT . " Reviews all texts marked with a particular mark. ")))))) (kom-review-all-marked-texts "" (section ((id . "kom-review-all-marked-texts") (prompt . "")) ((h3 nil ((cref ((id . "kom-review-all-marked-texts")) nil))) (p nil ((TEXT . " Reviews all marked texts. ")))))) (kom-unmark-text "" (section ((id . "kom-unmark-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-unmark-text")) nil))) (p nil ((TEXT . " Removes your marks from a texts. ")))))) (kom-mark-text "" (section ((id . "kom-mark-text") (prompt . "")) ((h3 nil ((cref ((id . "kom-mark-text")) nil))) (p nil ((TEXT . " Marks a texts. Normally this command will ask for the mark to use. ")))))) (kom-super-jump "" (section ((id . "kom-super-jump") (prompt . "")) ((h3 nil ((cref ((id . "kom-super-jump")) nil))) (p nil ((TEXT . " Creates a filter that will skip texts that have the same subject line as the specified text and are sent to the current conference. ")))))) (kom-jump "" (section ((id . "kom-jump") (prompt . "")) ((h3 nil ((cref ((id . "kom-jump")) nil))) (p nil ((TEXT . " Skips all texts in the comment tree below the most recently read text. This is useful when you see a text that starts a discussion that you aren't interested in. ")))))) (kom-set-unread "" (section ((id . "kom-set-unread") (prompt . "")) ((h3 nil ((cref ((id . "kom-set-unread")) nil))) (p nil ((TEXT . " Set the number of unread texts in a particular conference. Can be useful when you have lots of old texts to catch up with. ")))))) (kom-prioritize "" (section ((id . "kom-prioritize") (prompt . "")) ((h3 nil ((cref ((id . "kom-prioritize")) nil))) (p nil ((TEXT . " Interactively change priorities and placements of your memberships. For more information, press C-h m or ? when you have given the command. ")))))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: komtypes.el,v 44.22 2002/05/01 21:42:39 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; This file contains primitives for the different data types
;;;; in the lyskom system. All types here have their origin in
;;;; the server. Compare the file clienttypes.el.
;;;;
;;;; Author: ceder
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: komtypes.el,v 44.22 2002/05/01 21:42:39 byers Exp $\n"))


;;; ============================================================
;;; Black magic...

(defmacro def-komtype (type &rest args)
  (let ((typename (symbol-name type))
	(n 0)
        (tmp nil))
    ;; Constructor
    (append
     (list 'progn
           (list 'defsubst
                 (intern (concat "lyskom-create-" typename))
                 args
                 (concat "Create a `" typename "' from arguments.\n"
                         "Args: " (upcase (mapconcat
                                           'symbol-name args " ")) "\n"
                         "Automatically created with def-komtype.")
                 (list 'cons
                       (list 'quote (intern (upcase typename)))
                       (cons 'vector args)))
           ;; Identifier
           (list 'defsubst
                 (intern (concat "lyskom-" typename "-p"))
                 (list type)
                 (concat "Return `t' if " (upcase typename)
                         " is a " typename ".\n"
                         "Args: " (upcase typename) "\n"
                         "Automatically created with def-komtype.")
                 (list 'and
                       (list 'consp type)
                       (list 'eq (list 'car type)
                             (list 'quote (intern (upcase typename)))))))
    ;; Selectors/Modifiers
     (progn
       (while args
         (let ((argname (symbol-name (car args))))
           ;; Selctor
           (setq tmp (cons
                      (list 'defsubst
                            (intern (concat typename "->" argname))
                            (list type)
                            "Automatically created with def-komtype."
                            (list 'aref (list 'cdr type) n))
                      tmp))
           ;; Modifier
           (setq tmp (cons
                      (list 'defsubst
                            (intern (concat "set-" typename "->" argname))
                            (list type (car args))
                            "Automatically created with def-komtype."
                            (list 'aset (list 'cdr type) n (car args)))
                      tmp))
           (setq n (1+ n)
                 args (cdr args))))
       tmp))))



;;; ================================================================
;;;                            conf-no-list


;;; Constructor:

(defsubst lyskom-create-conf-no-list (conf-nos)
  "Create a conf-no-list from all parameters."
  (cons
   'CONF-NO-LIST
   (vector
    (cond ((vectorp conf-nos) (append conf-nos nil))
          (t conf-nos)))))



;;; Selector:

(defsubst conf-no-list->conf-nos (conf-no-list)
  "Get conf-nos from conf-no-list."
  (elt (cdr conf-no-list) 0))


;;; Modifier:

(defsubst set-conf-no-list->conf-nos (conf-no-list newval)
  "Set conf-nos in conf-no-list to NEWVAL."
  (aset (cdr conf-no-list) 0 newval))


;;; Predicate:

(defsubst lyskom-conf-no-list-p (object)
  "Return t if OBJECT is a conf-no-list."
  (eq (car-safe object) 'CONF-NO-LIST))


;;; Special functions

(defsubst lyskom-conf-no-list-member (conf-no conf-no-list)
  "Returns non-nil if CONF-NO is a member of CONF-NO-LIST.
CONF-NO is a conf-no and CONF-NO-LIST is a conf-no-list."
  (if (= (length (conf-no-list->conf-nos conf-no-list)) 0)
      nil
    (let* ((r 0)
	   (list (conf-no-list->conf-nos conf-no-list))
	   (len (length list))
	   (yes nil))
      (while (and (not yes)
		  (< r len))
	(if (= conf-no (elt list r))
	    (setq yes t)
	  (setq r (1+ r))))
      yes)))

;;; ================================================================
;;;                            uconf-stat

;;; Constructor:

(def-komtype uconf-stat 
  conf-no name conf-type highest-local-no nice)

;;; ================================================================
;;;                            conf-stat

;;; Constructor:

(defsubst lyskom-create-conf-stat (conf-no
				name
				conf-type
				creation-time
				last-written
				creator
				presentation
				supervisor
				permitted-submitters
				super-conf
				msg-of-day
				garb-nice
                                keep-commented
				no-of-members
				first-local-no
				no-of-texts
                                &optional expire
                                aux-items)
  "Create a conf-stat from all parameters."
  (cons
   'CONF-STAT
   (vector conf-no name conf-type creation-time last-written 
	   creator presentation supervisor permitted-submitters 
	   super-conf msg-of-day garb-nice no-of-members first-local-no 
	   no-of-texts (or expire 0) aux-items)))


;;; Selectors:

(defsubst conf-stat->conf-no (conf-stat)
  "Get conf-no from conf-stat."
  (elt (cdr conf-stat) 0))

(defsubst conf-stat->name (conf-stat)
  "Get name from conf-stat."
  (elt (cdr conf-stat) 1))

(defsubst conf-stat->conf-type (conf-stat)
  "Get conf-type from conf-stat."
  (elt (cdr conf-stat) 2))

(defsubst conf-stat->creation-time (conf-stat)
  "Get creation-time from conf-stat."
  (elt (cdr conf-stat) 3))

(defsubst conf-stat->last-written (conf-stat)
  "Get last-written from conf-stat."
  (elt (cdr conf-stat) 4))

(defsubst conf-stat->creator (conf-stat)
  "Get creator from conf-stat."
  (elt (cdr conf-stat) 5))

(defsubst conf-stat->presentation (conf-stat)
  "Get presentation from conf-stat."
  (elt (cdr conf-stat) 6))

(defsubst conf-stat->supervisor (conf-stat)
  "Get supervisor from conf-stat."
  (elt (cdr conf-stat) 7))

(defsubst conf-stat->permitted-submitters (conf-stat)
  "Get permitted-submitters from conf-stat."
  (elt (cdr conf-stat) 8))

(defsubst conf-stat->super-conf (conf-stat)
  "Get super-conf from conf-stat."
  (elt (cdr conf-stat) 9))

(defsubst conf-stat->msg-of-day (conf-stat)
  "Get msg-of-day from conf-stat."
  (elt (cdr conf-stat) 10))

(defsubst conf-stat->garb-nice (conf-stat)
  "Get garb-nice from conf-stat."
  (elt (cdr conf-stat) 11))

(defsubst conf-stat->no-of-members (conf-stat)
  "Get no-of-members from conf-stat."
  (elt (cdr conf-stat) 12))

(defsubst conf-stat->first-local-no (conf-stat)
  "Get first-local-no from conf-stat."
  (elt (cdr conf-stat) 13))

(defsubst conf-stat->no-of-texts (conf-stat)
  "Get no-of-texts from conf-stat."
  (elt (cdr conf-stat) 14))

(defsubst conf-stat->expire (conf-stat)
  "Get expire from conf-stat."
  (elt (cdr conf-stat) 15))

(defsubst conf-stat->aux-items (conf-stat)
  "Get aux-items from conf-stat."
  (elt (cdr conf-stat) 16))


;;; Modifiers:

(defsubst set-conf-stat->conf-no (conf-stat newval)
  "Set conf-no in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 0 newval))

(defsubst set-conf-stat->name (conf-stat newval)
  "Set name in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 1 newval))

(defsubst set-conf-stat->conf-type (conf-stat newval)
  "Set conf-type in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 2 newval))

(defsubst set-conf-stat->creation-time (conf-stat newval)
  "Set creation-time in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 3 newval))

(defsubst set-conf-stat->last-written (conf-stat newval)
  "Set last-written in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 4 newval))

(defsubst set-conf-stat->creator (conf-stat newval)
  "Set creator in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 5 newval))

(defsubst set-conf-stat->presentation (conf-stat newval)
  "Set presentation in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 6 newval))

(defsubst set-conf-stat->supervisor (conf-stat newval)
  "Set supervisor in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 7 newval))

(defsubst set-conf-stat->permitted-submitters (conf-stat newval)
  "Set permitted-submitters in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 8 newval))

(defsubst set-conf-stat->super-conf (conf-stat newval)
  "Set super-conf in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 9 newval))

(defsubst set-conf-stat->msg-of-day (conf-stat newval)
  "Set msg-of-day in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 10 newval))

(defsubst set-conf-stat->garb-nice (conf-stat newval)
  "Set garb-nice in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 11 newval))

(defsubst set-conf-stat->no-of-members (conf-stat newval)
  "Set no-of-members in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 12 newval))

(defsubst set-conf-stat->first-local-no (conf-stat newval)
  "Set first-local-no in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 13 newval))

(defsubst set-conf-stat->no-of-texts (conf-stat newval)
  "Set no-of-texts in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 14 newval))

(defsubst set-conf-stat->expire (conf-stat newval)
  "Set expire in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 15 newval))

(defsubst set-conf-stat->aux-items (conf-stat newval)
  "Set aux-items in conf-stat to NEWVAL."
  (aset (cdr conf-stat) 16 newval))



;;; Predicate:

(defsubst lyskom-conf-stat-p (object)
  "Return t if OBJECT is a conf-stat."
  (eq (car-safe object) 'CONF-STAT))


				
				
;;; ================================================================
;;;                         Conf-list


;;; Constructor:

(defsubst lyskom-create-conf-list (conf-nos conf-types)
  "Create a conf-list from CONF-NOS and CONF-TYPES.
CONF-NOS is a vector of numbers. CONF-TYPES is a vector of conf-type.
Both vectors should be of the same length."
  (cons 'CONF-LIST (cons conf-nos conf-types)))


;;; Selectors:

(defsubst conf-list->conf-nos (conf-list)
  "Get the conf-nos part of CONF-LIST"
  (car (cdr conf-list)))

(defsubst conf-list->conf-types (conf-list)
  "Get the conf-types part of CONF-LIST"
  (cdr (cdr conf-list)))


;;; Predicate:

(defsubst conf-list-p (object)
  "Return true if OBJECT is a conf-list"
  (eq 'CONF-LIST (car-safe object)))


;;; Special functions:

(defsubst lyskom-conf-list-length (conf-list)
  "Return the length of CONF-LIST"
  (length (conf-list->conf-nos conf-list)))


;;; ================================================================
;;;                             pers-stat


;;; Constructor:

(defsubst lyskom-create-pers-stat (pers-no
				username
				privileges
				flags
				last-login
				user-area
				total-time-present
				sessions
				created-lines
				created-bytes
				read-texts
				no-of-text-fetches
				created-persons
				created-confs
				first-created-text
				no-of-created-texts
				no-of-marks
				no-of-confs)
  "Create a pers-stat from all parameters."
  (cons
   'PERS-STAT
   (vector pers-no username privileges flags last-login user-area 
	   total-time-present sessions created-lines created-bytes 
	   read-texts no-of-text-fetches created-persons created-confs 
	   first-created-text no-of-created-texts no-of-marks 
	   no-of-confs )))


;;; Selectors:

(defsubst pers-stat->pers-no (pers-stat)
  "Get pers-no from pers-stat."
  (elt (cdr pers-stat) 0))

(defsubst pers-stat->username (pers-stat)
  "Get username from pers-stat."
  (elt (cdr pers-stat) 1))

(defsubst pers-stat->privileges (pers-stat)
  "Get privileges from pers-stat."
  (elt (cdr pers-stat) 2))

(defsubst pers-stat->flags (pers-stat)
  "Get flags from pers-stat."
  (elt (cdr pers-stat) 3))

(defsubst pers-stat->last-login (pers-stat)
  "Get last-login from pers-stat."
  (elt (cdr pers-stat) 4))

(defsubst pers-stat->user-area (pers-stat)
  "Get user-area from pers-stat."
  (elt (cdr pers-stat) 5))

(defsubst pers-stat->total-time-present (pers-stat)
  "Get total-time-present from pers-stat."
  (elt (cdr pers-stat) 6))

(defsubst pers-stat->sessions (pers-stat)
  "Get sessions from pers-stat."
  (elt (cdr pers-stat) 7))

(defsubst pers-stat->created-lines (pers-stat)
  "Get created-lines from pers-stat."
  (elt (cdr pers-stat) 8))

(defsubst pers-stat->created-bytes (pers-stat)
  "Get created-bytes from pers-stat."
  (elt (cdr pers-stat) 9))

(defsubst pers-stat->read-texts (pers-stat)
  "Get read-texts from pers-stat."
  (elt (cdr pers-stat) 10))

(defsubst pers-stat->no-of-text-fetches (pers-stat)
  "Get no-of-text-fetches from pers-stat."
  (elt (cdr pers-stat) 11))

(defsubst pers-stat->created-persons (pers-stat)
  "Get created-persons from pers-stat."
  (elt (cdr pers-stat) 12))

(defsubst pers-stat->created-confs (pers-stat)
  "Get created-confs from pers-stat."
  (elt (cdr pers-stat) 13))

(defsubst pers-stat->first-created-text (pers-stat)
  "Get first-created-text from pers-stat."
  (elt (cdr pers-stat) 14))

(defsubst pers-stat->no-of-created-texts (pers-stat)
  "Get no-of-created-texts from pers-stat."
  (elt (cdr pers-stat) 15))

(defsubst pers-stat->no-of-marks (pers-stat)
  "Get no-of-marks from pers-stat."
  (elt (cdr pers-stat) 16))

(defsubst pers-stat->no-of-confs (pers-stat)
  "Get no-of-confs from pers-stat."
  (elt (cdr pers-stat) 17))


;;; Modifiers:

(defsubst set-pers-stat->pers-no (pers-stat newval)
  "Set pers-no in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 0 newval))

(defsubst set-pers-stat->username (pers-stat newval)
  "Set username in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 1 newval))

(defsubst set-pers-stat->privileges (pers-stat newval)
  "Set privileges in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 2 newval))

(defsubst set-pers-stat->flags (pers-stat newval)
  "Set flags in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 3 newval))

(defsubst set-pers-stat->last-login (pers-stat newval)
  "Set last-login in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 4 newval))

(defsubst set-pers-stat->user-area (pers-stat newval)
  "Set user-area in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 5 newval))

(defsubst set-pers-stat->total-time-present (pers-stat newval)
  "Set total-time-present in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 6 newval))

(defsubst set-pers-stat->sessions (pers-stat newval)
  "Set sessions in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 7 newval))

(defsubst set-pers-stat->created-lines (pers-stat newval)
  "Set created-lines in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 8 newval))

(defsubst set-pers-stat->created-bytes (pers-stat newval)
  "Set created-bytes in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 9 newval))

(defsubst set-pers-stat->read-texts (pers-stat newval)
  "Set read-texts in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 10 newval))

(defsubst set-pers-stat->no-of-text-fetches (pers-stat newval)
  "Set no-of-text-fetches in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 11 newval))

(defsubst set-pers-stat->created-persons (pers-stat newval)
  "Set created-persons in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 12 newval))

(defsubst set-pers-stat->created-confs (pers-stat newval)
  "Set created-confs in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 13 newval))

(defsubst set-pers-stat->first-created-text (pers-stat newval)
  "Set first-created-text in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 14 newval))

(defsubst set-pers-stat->no-of-created-texts (pers-stat newval)
  "Set no-of-created-texts in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 15 newval))

(defsubst set-pers-stat->no-of-marks (pers-stat newval)
  "Set no-of-marks in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 16 newval))

(defsubst set-pers-stat->no-of-confs (pers-stat newval)
  "Set no-of-confs in pers-stat to NEWVAL."
  (aset (cdr pers-stat) 17 newval))


;;; Predicate:

(defsubst lyskom-pers-stat-p (object)
  "Return t if OBJECT is a pers-stat."
  (eq (car-safe object) 'PERS-STAT))


;;; ================================================================
;;;                           text-stat


;;; Constructor:

(defsubst lyskom-create-text-stat (text-no
				creation-time
				author
				no-of-lines
				no-of-chars
				no-of-marks
				misc-info-list
                                &optional aux-items)
  "Create a text-stat from all parameters."
  (cons
   'TEXT-STAT
   (vector text-no creation-time author no-of-lines no-of-chars 
	   no-of-marks misc-info-list aux-items)))


;;; Selectors:

(defsubst text-stat->text-no (text-stat)
  "Get text-no from text-stat."
  (elt (cdr text-stat) 0))

(defsubst text-stat->creation-time (text-stat)
  "Get creation-time from text-stat."
  (elt (cdr text-stat) 1))

(defsubst text-stat->author (text-stat)
  "Get author from text-stat."
  (elt (cdr text-stat) 2))

(defsubst text-stat->no-of-lines (text-stat)
  "Get no-of-lines from text-stat."
  (elt (cdr text-stat) 3))

(defsubst text-stat->no-of-chars (text-stat)
  "Get no-of-chars from text-stat."
  (elt (cdr text-stat) 4))

(defsubst text-stat->no-of-marks (text-stat)
  "Get no-of-marks from text-stat."
  (elt (cdr text-stat) 5))

(defsubst text-stat->misc-info-list (text-stat)
  "Get misc-info-list from text-stat."
  (elt (cdr text-stat) 6))

(defsubst text-stat->aux-items (text-stat)
  "Get aux-items from text-stat."
  (elt (cdr text-stat) 7))


;;; Modifiers:

(defsubst set-text-stat->text-no (text-stat newval)
  "Set text-no in text-stat to NEWVAL."
  (aset (cdr text-stat) 0 newval))

(defsubst set-text-stat->creation-time (text-stat newval)
  "Set creation-time in text-stat to NEWVAL."
  (aset (cdr text-stat) 1 newval))

(defsubst set-text-stat->author (text-stat newval)
  "Set author in text-stat to NEWVAL."
  (aset (cdr text-stat) 2 newval))

(defsubst set-text-stat->no-of-lines (text-stat newval)
  "Set no-of-lines in text-stat to NEWVAL."
  (aset (cdr text-stat) 3 newval))

(defsubst set-text-stat->no-of-chars (text-stat newval)
  "Set no-of-chars in text-stat to NEWVAL."
  (aset (cdr text-stat) 4 newval))

(defsubst set-text-stat->no-of-marks (text-stat newval)
  "Set no-of-marks in text-stat to NEWVAL."
  (aset (cdr text-stat) 5 newval))

(defsubst set-text-stat->misc-info-list (text-stat newval)
  "Set misc-info-list in text-stat to NEWVAL."
  (aset (cdr text-stat) 6 newval))

(defsubst set-text-stat->aux-items (text-stat newval)
  "Set aux-items in text-stat to NEWVAL."
  (aset (cdr text-stat) 7 newval))


;;; Predicate:

(defsubst lyskom-text-stat-p (object)
  "Return t if OBJECT is a text-stat."
  (eq (car-safe object) 'TEXT-STAT))

;;; ================================================================
;;;                              aux-item

(def-komtype aux-item-flags deleted inherit secret anonymous
  dont-garb reserved2 reserved3 reserved4)

(def-komtype aux-item aux-no 
                       tag
                       creator
                       sent-at
                       flags
                       inherit-limit
                       data)



;;; ================================================================
;;;                            text


;;; Constructor:

(defsubst lyskom-create-text (text-no
			   text-mass)
  "Create a text from all parameters."
  (cons
   'TEXT
   (vector text-no text-mass )))


;;; Selectors:

(defsubst text->text-no (text)
  "Get text-no from text."
  (elt (cdr text) 0))

(defsubst text->text-mass (text)
  "Get text-mass from text."
  (elt (cdr text) 1))


;;; Modifiers:

(defsubst set-text->text-no (text newval)
  "Set text-no in text to NEWVAL."
  (aset (cdr text) 0 newval))

(defsubst set-text->text-mass (text newval)
  "Set text-mass in text to NEWVAL."
  (aset (cdr text) 1 newval))


;;; Predicate:

(defsubst lyskom-text-p (object)
  "Return t if OBJECT is a text."
  (eq (car-safe object) 'TEXT))

;;; Utilities

(defun text->decoded-text-mass (text text-stat)
  "Get the text mass of a text after decoding according to its content type"
  (save-match-data 
    (let* ((str (text->text-mass text))
           (item (lyskom-get-aux-item
                  (text-stat->aux-items text-stat) 1))
           (content-type (and (car item)
                              (lyskom-mime-decode-content-type
                               (aux-item->data (car item))))))
      (if (cdr content-type)
          (lyskom-mime-decode-string str (cdr content-type))
        str))))

				   

;;; ================================================================
;;;                          misc-info


;;; Constructors:

(defsubst lyskom-create-misc-info (type
				recipient-no
				local-no
				rec-time
				comm-to
				comm-in
				footn-to
				footn-in
				sender
				sent-at)
  "Create a misc-info from all parameters.
TYPE is one of RECPT, CC-RECPT, BCC-RECPT, COMM-TO, COMM-IN, 
FOOTN-TO or FOOTN-IN."
  (cons
   'MISC-INFO
   (vector type recipient-no local-no rec-time comm-to comm-in 
	   footn-to footn-in sender sent-at )))

(defsubst lyskom-create-empty-misc-info ()
  "Create an empty misc-info."
  (lyskom-create-misc-info nil nil nil nil nil nil nil nil nil nil))


;;; Selectors:

(defsubst misc-info->type (misc-info)
  "Get type from misc-info."
  (elt (cdr misc-info) 0))

(defsubst misc-info->recipient-no (misc-info)
  "Get recipient-no from misc-info."
  (elt (cdr misc-info) 1))

(defsubst misc-info->local-no (misc-info)
  "Get local-no from misc-info."
  (elt (cdr misc-info) 2))

(defsubst misc-info->rec-time (misc-info)
  "Get rec-time from misc-info."
  (elt (cdr misc-info) 3))

(defsubst misc-info->comm-to (misc-info)
  "Get comm-to from misc-info."
  (elt (cdr misc-info) 4))

(defsubst misc-info->comm-in (misc-info)
  "Get comm-in from misc-info."
  (elt (cdr misc-info) 5))

(defsubst misc-info->footn-to (misc-info)
  "Get footn-to from misc-info."
  (elt (cdr misc-info) 6))

(defsubst misc-info->footn-in (misc-info)
  "Get footn-in from misc-info."
  (elt (cdr misc-info) 7))

(defsubst misc-info->sender (misc-info)
  "Get sender from misc-info."
  (elt (cdr misc-info) 8))

(defsubst misc-info->sent-at (misc-info)
  "Get sent-at from misc-info."
  (elt (cdr misc-info) 9))


;;; Modifiers:

(defsubst set-misc-info->type (misc-info newval)
  "Set type in misc-info to NEWVAL."
  (aset (cdr misc-info) 0 newval))

(defsubst set-misc-info->recipient-no (misc-info newval)
  "Set recipient-no in misc-info to NEWVAL."
  (aset (cdr misc-info) 1 newval))

(defsubst set-misc-info->local-no (misc-info newval)
  "Set local-no in misc-info to NEWVAL."
  (aset (cdr misc-info) 2 newval))

(defsubst set-misc-info->rec-time (misc-info newval)
  "Set rec-time in misc-info to NEWVAL."
  (aset (cdr misc-info) 3 newval))

(defsubst set-misc-info->comm-to (misc-info newval)
  "Set comm-to in misc-info to NEWVAL."
  (aset (cdr misc-info) 4 newval))

(defsubst set-misc-info->comm-in (misc-info newval)
  "Set comm-in in misc-info to NEWVAL."
  (aset (cdr misc-info) 5 newval))

(defsubst set-misc-info->footn-to (misc-info newval)
  "Set footn-to in misc-info to NEWVAL."
  (aset (cdr misc-info) 6 newval))

(defsubst set-misc-info->footn-in (misc-info newval)
  "Set footn-in in misc-info to NEWVAL."
  (aset (cdr misc-info) 7 newval))

(defsubst set-misc-info->sender (misc-info newval)
  "Set sender in misc-info to NEWVAL."
  (aset (cdr misc-info) 8 newval))

(defsubst set-misc-info->sent-at (misc-info newval)
  "Set sent-at in misc-info to NEWVAL."
  (aset (cdr misc-info) 9 newval))


;;; Predicate:

(defsubst lyskom-misc-info-p (object)
  "Return t if OBJECT is a misc-info."
  (eq (car-safe object) 'MISC-INFO))


;;; ================================================================
;;;                                time


;;; Constructor:

(defsubst lyskom-create-time (sec
			   min
			   hour
			   mday
			   mon
			   year
			   wday
			   yday
			   isdst
                           &optional tzhr tzmin)
  "Create a time from all parameters.

Note: YEAR is the actual year, *not* years since 1900.  MON is month
starting with *one* for January."
  (cons
   'TIME
   (vector sec min hour mday mon year wday yday isdst tzhr tzmin)))


;;; Selectors:

(defsubst time->sec (time)
  "Get sec from time."
  (elt (cdr time) 0))

(defsubst time->min (time)
  "Get min from time."
  (elt (cdr time) 1))

(defsubst time->hour (time)
  "Get hour from time."
  (elt (cdr time) 2))

(defsubst time->mday (time)
  "Get mday from time."
  (elt (cdr time) 3))

(defsubst time->mon (time)
  "Get mon from time."
  (elt (cdr time) 4))

(defsubst time->year (time)
  "Get year from time."
  (elt (cdr time) 5))

(defsubst time->wday (time)
  "Get wday from time."
  (elt (cdr time) 6))

(defsubst time->yday (time)
  "Get yday from time."
  (elt (cdr time) 7))

(defsubst time->isdst (time)
  "Get isdst from time."
  (elt (cdr time) 8))

(defsubst time->tzhr (time)
  "Get isdst from time."
  (elt (cdr time) 9))

(defsubst time->tzmin (time)
  "Get isdst from time."
  (elt (cdr time) 10))


;;; Predicate:

(defsubst lyskom-time-p (object)
  "Return t if OBJECT is a time."
  (eq (car-safe object) 'TIME))


;;; ================================================================
;;;                               privs


;;; Constructor:

(defsubst lyskom-create-privs (wheel
			       admin
			       statistic
			       create_pers
			       create_conf
			       change_name
			       flg7
			       flg8
			       flg9
			       flg10
			       flg11
			       flg12
			       flg13
			       flg14
			       flg15
			       flg16)
  "Create a privs from all parameters."
  (cons
   'PRIVS
   (vector wheel admin statistic create_pers create_conf change_name 
	   flg7 flg8 flg9 flg10 flg11 flg12 flg13 flg14 flg15 
	   flg16 )))


;;; Selectors:

(defsubst privs->wheel (privs)
  "Get wheel from privs."
  (elt (cdr privs) 0))

(defsubst privs->admin (privs)
  "Get admin from privs."
  (elt (cdr privs) 1))

(defsubst privs->statistic (privs)
  "Get statistic from privs."
  (elt (cdr privs) 2))

(defsubst privs->create_pers (privs)
  "Get create_pers from privs."
  (elt (cdr privs) 3))

(defsubst privs->create_conf (privs)
  "Get create_conf from privs."
  (elt (cdr privs) 4))

(defsubst privs->change_name (privs)
  "Get change_name from privs."
  (elt (cdr privs) 5))

(defsubst privs->flg7 (privs)
  "Get flg7 from privs."
  (elt (cdr privs) 6))

(defsubst privs->flg8 (privs)
  "Get flg8 from privs."
  (elt (cdr privs) 7))

(defsubst privs->flg9 (privs)
  "Get flg9 from privs."
  (elt (cdr privs) 8))

(defsubst privs->flg10 (privs)
  "Get flg10 from privs."
  (elt (cdr privs) 9))

(defsubst privs->flg11 (privs)
  "Get flg11 from privs."
  (elt (cdr privs) 10))

(defsubst privs->flg12 (privs)
  "Get flg12 from privs."
  (elt (cdr privs) 11))

(defsubst privs->flg13 (privs)
  "Get flg13 from privs."
  (elt (cdr privs) 12))

(defsubst privs->flg14 (privs)
  "Get flg14 from privs."
  (elt (cdr privs) 13))

(defsubst privs->flg15 (privs)
  "Get flg15 from privs."
  (elt (cdr privs) 14))

(defsubst privs->flg16 (privs)
  "Get flg16 from privs."
  (elt (cdr privs) 15))


;;; Modifiers:

(defsubst set-privs->wheel (privs newval)
  "Set wheel in privs to NEWVAL."
  (aset (cdr privs) 0 newval))

(defsubst set-privs->admin (privs newval)
  "Set admin in privs to NEWVAL."
  (aset (cdr privs) 1 newval))

(defsubst set-privs->statistic (privs newval)
  "Set statistic in privs to NEWVAL."
  (aset (cdr privs) 2 newval))

(defsubst set-privs->create_pers (privs newval)
  "Set create_pers in privs to NEWVAL."
  (aset (cdr privs) 3 newval))

(defsubst set-privs->create_conf (privs newval)
  "Set create_conf in privs to NEWVAL."
  (aset (cdr privs) 4 newval))

(defsubst set-privs->change_name (privs newval)
  "Set change_name in privs to NEWVAL."
  (aset (cdr privs) 5 newval))

(defsubst set-privs->flg7 (privs newval)
  "Set flg7 in privs to NEWVAL."
  (aset (cdr privs) 6 newval))

(defsubst set-privs->flg8 (privs newval)
  "Set flg8 in privs to NEWVAL."
  (aset (cdr privs) 7 newval))

(defsubst set-privs->flg9 (privs newval)
  "Set flg9 in privs to NEWVAL."
  (aset (cdr privs) 8 newval))

(defsubst set-privs->flg10 (privs newval)
  "Set flg10 in privs to NEWVAL."
  (aset (cdr privs) 9 newval))

(defsubst set-privs->flg11 (privs newval)
  "Set flg11 in privs to NEWVAL."
  (aset (cdr privs) 10 newval))

(defsubst set-privs->flg12 (privs newval)
  "Set flg12 in privs to NEWVAL."
  (aset (cdr privs) 11 newval))

(defsubst set-privs->flg13 (privs newval)
  "Set flg13 in privs to NEWVAL."
  (aset (cdr privs) 12 newval))

(defsubst set-privs->flg14 (privs newval)
  "Set flg14 in privs to NEWVAL."
  (aset (cdr privs) 13 newval))

(defsubst set-privs->flg15 (privs newval)
  "Set flg15 in privs to NEWVAL."
  (aset (cdr privs) 14 newval))

(defsubst set-privs->flg16 (privs newval)
  "Set flg16 in privs to NEWVAL."
  (aset (cdr privs) 15 newval))


;;; Predicate:

(defsubst lyskom-privs-p (object)
  "Return t if OBJECT is a privs."
  (eq (car-safe object) 'PRIVS))


;;; ================================================================
;;;                            flags



(def-komtype session-flags
  invisible user_active_used user_absent
  reserved3 reserved4 reserved5 reserved6 reserved7)

(def-komtype dynamic-session-info
  session person working-conference idle-time flags what-am-i-doing)

(def-komtype static-session-info
  username hostname ident-user connection-time)

;;; ================================================================
;;;                            flags


;;; Constructor:

(defsubst lyskom-create-flags (unread_is_secret
			       flg2
			       flg3
			       flg4
			       flg5
			       flg6
			       flg7
			       flg8)
  "Create a flags from all parameters."
  (cons
   'FLAGS
   (vector unread_is_secret flg2 flg3 flg4 flg5 flg6 flg7 flg8)))


;;; Selectors:

(defsubst flags->unread_is_secret (flags)
  "Get unread_is_secret from flags."
  (elt (cdr flags) 0))

(defsubst flags->flg2 (flags)
  "Get flg2 from flags."
  (elt (cdr flags) 1))

(defsubst flags->flg3 (flags)
  "Get flg3 from flags."
  (elt (cdr flags) 2))

(defsubst flags->flg4 (flags)
  "Get flg4 from flags."
  (elt (cdr flags) 3))

(defsubst flags->flg5 (flags)
  "Get flg5 from flags."
  (elt (cdr flags) 4))

(defsubst flags->flg6 (flags)
  "Get flg6 from flags."
  (elt (cdr flags) 5))

(defsubst flags->flg7 (flags)
  "Get flg7 from flags."
  (elt (cdr flags) 6))

(defsubst flags->flg8 (flags)
  "Get flg8 from flags."
  (elt (cdr flags) 7))


;;; Modifiers:

(defsubst set-flags->unread_is_secret (flags newval)
  "Set unread_is_secret in flags to NEWVAL."
  (aset (cdr flags) 0 newval))

(defsubst set-flags->flg2 (flags newval)
  "Set flg2 in flags to NEWVAL."
  (aset (cdr flags) 1 newval))

(defsubst set-flags->flg3 (flags newval)
  "Set flg3 in flags to NEWVAL."
  (aset (cdr flags) 2 newval))

(defsubst set-flags->flg4 (flags newval)
  "Set flg4 in flags to NEWVAL."
  (aset (cdr flags) 3 newval))

(defsubst set-flags->flg5 (flags newval)
  "Set flg5 in flags to NEWVAL."
  (aset (cdr flags) 4 newval))

(defsubst set-flags->flg6 (flags newval)
  "Set flg6 in flags to NEWVAL."
  (aset (cdr flags) 5 newval))

(defsubst set-flags->flg7 (flags newval)
  "Set flg7 in flags to NEWVAL."
  (aset (cdr flags) 6 newval))

(defsubst set-flags->flg8 (flags newval)
  "Set flg8 in flags to NEWVAL."
  (aset (cdr flags) 7 newval))



;;; Predicate:

(defsubst lyskom-flags-p (object)
  "Return t if OBJECT is a flags."
  (eq (car-safe object) 'FLAGS))


;;; ================================================================
;;;                             membership


;;; Constructor:

(def-komtype member-list members)

(def-komtype member pers-no created-by created-at membership-type)

(def-komtype membership-type invitation passive secret rsv1 
  rsv2 rsv3 rsv4 rsv5)

(defsubst lyskom-create-membership ( position
                                     last-time-read
                                     conf-no
                                     priority
                                     last-text-read
                                     read-texts
                                     created-by
                                     created-at
                                     type
                                     )
  "Create a membership from all parameters."
  (cons
   'MEMBERSHIP
   (vector last-time-read conf-no priority last-text-read read-texts 
           created-by created-at type position
	   )))


;;; Selectors:

(defsubst membership->last-time-read (membership)
  "Get last-time-read from membership."
  (elt (cdr membership) 0))

(defsubst membership->conf-no (membership)
  "Get conf-no from membership."
  (elt (cdr membership) 1))

(defsubst membership->priority (membership)
  "Get priority from membership."
  (elt (cdr membership) 2))

(defsubst membership->last-text-read (membership)
  "Get last-text-read from membership."
  (elt (cdr membership) 3))

(defsubst membership->read-texts (membership)
  "Get read-texts from membership."
  (elt (cdr membership) 4))

(defsubst membership->created-by (membership)
  "Get created-by from membership"
  (elt (cdr membership) 5))

(defsubst membership->created-at (membership)
  "Get created-by from membership"
  (elt (cdr membership) 6))

(defsubst membership->type (membership)
  "Get type from membership"
  (elt (cdr membership) 7))

(defsubst membership->position (membership)
  "Get position from membership, if known"
  (elt (cdr membership) 8))



;;; Modifiers:

(defsubst set-membership->last-time-read (membership newval)
  "Set last-time-read in membership to NEWVAL."
  (aset (cdr membership) 0 newval))

(defsubst set-membership->conf-no (membership newval)
  "Set conf-no in membership to NEWVAL."
  (aset (cdr membership) 1 newval))

(defsubst set-membership->priority (membership newval)
  "Set priority in membership to NEWVAL."
  (aset (cdr membership) 2 newval))

(defsubst set-membership->last-text-read (membership newval)
  "Set last-text-read in membership to NEWVAL."
  (aset (cdr membership) 3 newval))

(defsubst set-membership->read-texts (membership newval)
  "Set read-texts in membership to NEWVAL."
  (aset (cdr membership) 4 newval))

(defsubst set-membership->created-by (membership newval)
  "Set created-by in membership to NEWVAL."
  (aset (cdr membership) 5 newval))

(defsubst set-membership->created-at (membership newval)
  "Set type in membership to NEWVAL."
  (aset (cdr membership) 6 newval))

(defsubst set-membership->type (membership newval)
  "Set type in membership to NEWVAL."
  (aset (cdr membership) 7 newval))

(defsubst set-membership->position (membership newval)
  "Set position in membership to NEWVAL."
  (aset (cdr membership) 8 newval))


;;; Predicate:

(defsubst lyskom-membership-p (object)
  "Return t if OBJECT is a membership."
  (eq (car-safe object) 'MEMBERSHIP))

;;; Special stuff

(defun lyskom-member-list-find-member (person members)
  (when members
    (lyskom-traverse member (member-list->members members)
      (when (eq person (member->pers-no member))
        (lyskom-traverse-break member)))))



;;; ================================================================
;;;                               map


;;; Constructor:

(defsubst lyskom-create-map (first-local text-nos)
  "Create a map from all parameters."
  (cons
   'MAP
   (vector first-local text-nos )))


;;; Selectors:

(defsubst map->first-local (map)
  "Get first-local from map."
  (elt (cdr map) 0))

(defsubst map->text-nos (map)
  "Get text-nos from map."
  (elt (cdr map) 1))


;;; Modifiers:

(defsubst set-map->first-local (map newval)
  "Set first-local in map to NEWVAL."
  (aset (cdr map) 0 newval))

(defsubst set-map->text-nos (map newval)
  "Set text-nos in map to NEWVAL."
  (aset (cdr map) 1 newval))


;;; Predicate:

(defsubst lyskom-map-p (object)
  "Return t if OBJECT is a map."
  (eq (car-safe object) 'MAP))

			  
;;; Concat:

(defsubst lyskom-map-concat (&rest maps)
  "Take any number of MAPS and return a new map which is the sum of the maps.
Args: &rest MAPS.
The MAPS must be consecutive. No gaps or overlaps are currently allowed."
  (if (null maps)
      (lyskom-create-map 1 [])
    (let* ((first (map->first-local (car maps)))
	   (high (+ first (length (map->text-nos (car maps)))))
	   (maplist (list (map->text-nos (car maps))))
	   (maps (cdr maps)))
      (while maps
	(if (/= (map->first-local (car maps))
		high)
	    (signal 'lyskom-internal-error '("lyskom-map-concat")))
	(setq maplist (nconc maplist (list (map->text-nos (car maps)))))
	(setq high (+ high (length (map->text-nos (car maps)))))
	(setq maps (cdr maps)))
      (lyskom-create-map first (apply 'vconcat maplist)))))


;;; ================================================================
;;; Text-Mapping support

(def-komtype text-mapping
  range-begin
  range-end
  size
  later-texts-exist
  type
  block)

(defsubst lyskom-create-text-pair (local global) (cons local global))
(defsubst text-pair->local-number (pair) (car pair))
(defsubst text-pair->global-number (pair) (cdr pair))

(defun text-mapping->local-to-global (map local)
  (cond ((or (< local (text-mapping->range-begin map))
             (> local (text-mapping->range-end map))) nil)
        ((eq (text-mapping->type map) 'sparse)
         (cdr (assq local (text-mapping->block map))))

        ((eq (text-mapping->type map) 'dense)
         (let ((result (aref (text-mapping->block map)
                             (- local (text-mapping->range-begin map)))))
           (and (not (zerop result)) result)))))

(defun text-mapping->global-numbers (map)
  (cond ((eq (text-mapping->type map) 'sparse)
         (mapcar 'cdr (text-mapping->block map)))
        ((eq (text-mapping->type map) 'dense)
         (let ((result nil))
           (lyskom-traverse el (map->text-nos (text-mapping->block map))
             (unless (zerop el) (setq result (cons el result))))
           (nreverse result)))))

(defun text-mapping->global-to-local (map global)
  (cond ((eq (text-mapping->type map) 'sparse)
         (cdr (rassq global (text-mapping->block map))))
        ((eq (text-mapping->type map) 'dense)
         (let ((i (text-mapping->range-begin map))
               (result nil))
           (while (< i (text-mapping->range-end map))
             (if (eq (aref (map->text-nos (text-mapping->block map)) 
                           (- i (text-mapping->range-begin map)))
                     global)
                 (setq result i i (text-mapping->range-end map))
               (setq i (1+ i))))
           result))))

;;; ================================================================
;;;                            mark


;;; Constructor:

(defsubst lyskom-create-mark (text-no
			   mark-type)
  "Create a mark from all parameters."
  (cons
   'MARK
   (vector text-no mark-type )))


;;; Selectors:

(defsubst mark->text-no (mark)
  "Get text-no from mark."
  (elt (cdr mark) 0))

(defsubst mark->mark-type (mark)
  "Get mark-type from mark."
  (elt (cdr mark) 1))


;;; Modifiers:

(defsubst set-mark->text-no (mark newval)
  "Set text-no in mark to NEWVAL."
  (aset (cdr mark) 0 newval))

(defsubst set-mark->mark-type (mark newval)
  "Set mark-type in mark to NEWVAL."
  (aset (cdr mark) 1 newval))


;;; Predicate:

(defsubst lyskom-mark-p (object)
  "Return t if OBJECT is a mark."
  (eq (car-safe object) 'MARK))

;;; Utilities

(defun mark->symbolic-mark-type (mark)
  (lyskom-symbolic-mark-type-string (mark->mark-type mark)))

;;; ================================================================
;;;                           who-info


;;; Constructor:

(defsubst lyskom-create-who-info (pers-no
			       working-conf
			       connection
			       doing-what
			       username
                               &optional hostname ident-user)
  "Create a who-info from all parameters."
  (cons
   'WHO-INFO
   (vector pers-no working-conf connection doing-what 
           username hostname ident-user
	   )))


;;; Selectors:

(defsubst who-info->pers-no (who-info)
  "Get pers-no from who-info."
  (elt (cdr who-info) 0))

(defsubst who-info->working-conf (who-info)
  "Get working-conf from who-info."
  (elt (cdr who-info) 1))

(defsubst who-info->connection (who-info)
  "Get connection from who-info."
  (elt (cdr who-info) 2))

(defsubst who-info->doing-what (who-info)
  "Get doing-what from who-info."
  (elt (cdr who-info) 3))

(defsubst who-info->username (who-info)
  "Get username from who-info."
  (elt (cdr who-info) 4))

(defsubst who-info->hostname (who-info)
  "Get hostname from who-info."
  (elt (cdr who-info) 5))

(defsubst who-info->ident-user (who-info)
  "Get ident-user from who-info."
  (elt (cdr who-info) 6))


;;; Modifiers:

(defsubst set-who-info->pers-no (who-info newval)
  "Set pers-no in who-info to NEWVAL."
  (aset (cdr who-info) 0 newval))

(defsubst set-who-info->working-conf (who-info newval)
  "Set working-conf in who-info to NEWVAL."
  (aset (cdr who-info) 1 newval))

(defsubst set-who-info->connection (who-info newval)
  "Set connection in who-info to NEWVAL."
  (aset (cdr who-info) 2 newval))

(defsubst set-who-info->doing-what (who-info newval)
  "Set doing-what in who-info to NEWVAL."
  (aset (cdr who-info) 3 newval))

(defsubst set-who-info->username (who-info newval)
  "Set username in who-info to NEWVAL."
  (aset (cdr who-info) 4 newval))

(defsubst set-who-info->hostname (who-info newval)
  "Set hostname in who-info to NEWVAL."
  (aset (cdr who-info) 5 newval))

(defsubst set-who-info->ident-user (who-info newval)
  "Set ident-user in who-info to NEWVAL."
  (aset (cdr who-info) 6 newval))


;;; Predicate:

(defsubst lyskom-who-info-p (object)
  "Return t if OBJECT is a who-info."
  (eq (car-safe object) 'WHO-INFO))

		       
;;; ================================================================
;;;                         session-info


;;; Constructor:

(defsubst lyskom-create-session-info (pers-no
				   working-conf
				   connection
				   doing
				   username
                                   hostname
                                   ident-user
				   idletime
				   connect-time)
  "Create a session-info from all parameters."
  (cons
   'SESSION-INFO
   (vector pers-no working-conf connection doing username idletime 
	   connect-time hostname ident-user)))


;;; Selectors:

(defsubst session-info->pers-no (session-info)
  "Get pers-no from session-info."
  (elt (cdr session-info) 0))

(defsubst session-info->working-conf (session-info)
  "Get working-conf from session-info."
  (elt (cdr session-info) 1))

(defsubst session-info->connection (session-info)
  "Get connection from session-info."
  (elt (cdr session-info) 2))

(defsubst session-info->doing (session-info)
  "Get doing from session-info."
  (elt (cdr session-info) 3))

(defsubst session-info->username (session-info)
  "Get username from session-info."
  (elt (cdr session-info) 4))

(defsubst session-info->idletime (session-info)
  "Get idletime from session-info."
  (elt (cdr session-info) 5))

(defsubst session-info->connect-time (session-info)
  "Get connect-time from session-info."
  (elt (cdr session-info) 6))

(defsubst session-info->hostname (session-info)
  "Get hostname from session-info."
  (elt (cdr session-info) 7))

(defsubst session-info->ident-user (session-info)
  "Get connect-time from session-info."
  (elt (cdr session-info) 8))


;;; Modifiers:

(defsubst set-session-info->pers-no (session-info newval)
  "Set pers-no in session-info to NEWVAL."
  (aset (cdr session-info) 0 newval))

(defsubst set-session-info->working-conf (session-info newval)
  "Set working-conf in session-info to NEWVAL."
  (aset (cdr session-info) 1 newval))

(defsubst set-session-info->connection (session-info newval)
  "Set connection in session-info to NEWVAL."
  (aset (cdr session-info) 2 newval))

(defsubst set-session-info->doing (session-info newval)
  "Set doing in session-info to NEWVAL."
  (aset (cdr session-info) 3 newval))

(defsubst set-session-info->username (session-info newval)
  "Set username in session-info to NEWVAL."
  (aset (cdr session-info) 4 newval))

(defsubst set-session-info->idletime (session-info newval)
  "Set idletime in session-info to NEWVAL."
  (aset (cdr session-info) 5 newval))

(defsubst set-session-info->connect-time (session-info newval)
  "Set connect-time in session-info to NEWVAL."
  (aset (cdr session-info) 6 newval))

(defsubst set-session-info->hostname (session-info newval)
  "Set hostname in session-info to NEWVAL."
  (aset (cdr session-info) 7 newval))

(defsubst set-session-info->ident-user (session-info newval)
  "Set ident-user in session-info to NEWVAL."
  (aset (cdr session-info) 8 newval))



;;; Predicate:

(defsubst lyskom-session-info-p (object)
  "Return t if OBJECT is a session-info."
  (eq (car-safe object) 'SESSION-INFO))


				   
;;; ================================================================
;;;                          conf-type.


;;; Constructor:

(defsubst lyskom-create-conf-type (rd_prot original secret letterbox 
                                           &optional anarchy
                                           forbid-secret rsv2 rsv3)
  "Create a conf-type object. Args: RD_PROT ORIGINAL SECRET LETTERBOX."
  (list 'CONF-TYPE 
	rd_prot 
	original 
	secret 
	letterbox
        anarchy
        forbid-secret
        rsv2
        rsv3
	))


;;;Selectors:

(defsubst conf-type->rd_prot (conf-type)
  "Get rd_prot from conf-type."
  (elt (cdr conf-type) 0))

(defsubst conf-type->original (conf-type)
  "Get original from conf-type."
  (elt (cdr conf-type) 1))

(defsubst conf-type->secret (conf-type)
  "Get secret from conf-type."
  (elt (cdr conf-type) 2))

(defsubst conf-type->letterbox (conf-type)
  "Get letterbox from conf-type."
  (elt (cdr conf-type) 3))

(defsubst conf-type->anarchy (conf-type)
  "Get anarchy from conf-type."
  (elt (cdr conf-type) 4))

(defsubst conf-type->forbid-secret (conf-type)
  "Get reserved bit from conf-type."
  (elt (cdr conf-type) 5))

(defsubst conf-type->rsv2 (conf-type)
  "Get reserved bit from conf-type."
  (elt (cdr conf-type) 5))

(defsubst conf-type->rsv3 (conf-type)
  "Get reserved bit from conf-type."
  (elt (cdr conf-type) 5))


;;; ================================================================
;;;                            text-list


;;; Constructor:

(defsubst lyskom-create-text-list (texts)
  "Create a text-list from all parameters."
  (cons 'TEXT-LIST texts))


;;; Selector:

(defsubst text-list->texts (text-list)
  "Get texts from text-list."
  (cdr text-list))

(defsubst text-list->empty (text-list)
  "Return t if TEXT-LIST is empty."
  (null (cdr text-list)))

(defsubst text-list->length (text-list)
  "Return the length of TEXT-LIST."
  (length (cdr text-list)))


;;; Modifier:

(defsubst set-text-list->texts (text-list newval)
  "Set texts in TEXT-LIST to NEWVAL."
  (setcdr text-list newval))

(defsubst text-list->delq (text-list no)
  "Remove text NO from TEXT-LIST."
  (setcdr text-list (delq no (cdr text-list))))

(defsubst text-list->append (text-list texts)
  "Destructively append TEXTS to the end of TEXT-LIST."
  (setcdr text-list (nconc (cdr text-list) texts)))

;;; Predicate:

(defsubst lyskom-text-list-p (object)
  "Return t if OBJECT is a text-list."
  (eq (car-safe object) 'TEXT-LIST))


;;; ================================================================
;;;                         version-info


;;; Constructor:

(defsubst lyskom-create-version-info (protocol-version
                                      server-software
                                      software-version)
  "Create a version-info from all parameters."
  (cons 'VERSION-INFO
        (vector protocol-version server-software software-version)))

;;; Selectors:

(defsubst version-info->protocol-version (version-info)
  "Get protocol version from version-info."
  (elt (cdr version-info) 0))

(defsubst version-info->server-software (version-info)
  "Get server software name from version-info."
  (elt (cdr version-info) 1))

(defsubst version-info->software-version (version-info)
  "Get server software version from version-info."
  (elt (cdr version-info) 2))

				   
;;; ================================================================
;;;                          server-info


;;; Constructor:

(defsubst lyskom-create-server-info (version
				  conf-pres-conf
				  pers-pres-conf
				  motd-conf
				  kom-news-conf
				  motd-of-lyskom
                                  &optional aux-items)
  "Create a server-info from all parameters."
  (cons
   'SERVER-INFO
   (vector version conf-pres-conf pers-pres-conf motd-conf kom-news-conf 
	   motd-of-lyskom aux-items )))


;;; Selectors:

(defsubst server-info->version (server-info)
  "Get version from server-info."
  (elt (cdr server-info) 0))

(defsubst server-info->conf-pres-conf (server-info)
  "Get conf-pres-conf from server-info."
  (elt (cdr server-info) 1))

(defsubst server-info->pers-pres-conf (server-info)
  "Get pers-pres-conf from server-info."
  (elt (cdr server-info) 2))

(defsubst server-info->motd-conf (server-info)
  "Get motd-conf from server-info."
  (elt (cdr server-info) 3))

(defsubst server-info->kom-news-conf (server-info)
  "Get kom-news-conf from server-info."
  (elt (cdr server-info) 4))

(defsubst server-info->motd-of-lyskom (server-info)
  "Get motd-of-lyskom from server-info."
  (elt (cdr server-info) 5))

(defsubst server-info->aux-item-list (server-info)
  "Get motd-of-lyskom from server-info."
  (elt (cdr server-info) 6))


;;; Modifiers:

(defsubst set-server-info->version (server-info newval)
  "Set version in server-info to NEWVAL."
  (aset (cdr server-info) 0 newval))

(defsubst set-server-info->conf-pres-conf (server-info newval)
  "Set conf-pres-conf in server-info to NEWVAL."
  (aset (cdr server-info) 1 newval))

(defsubst set-server-info->pers-pres-conf (server-info newval)
  "Set pers-pres-conf in server-info to NEWVAL."
  (aset (cdr server-info) 2 newval))

(defsubst set-server-info->motd-conf (server-info newval)
  "Set motd-conf in server-info to NEWVAL."
  (aset (cdr server-info) 3 newval))

(defsubst set-server-info->kom-news-conf (server-info newval)
  "Set kom-news-conf in server-info to NEWVAL."
  (aset (cdr server-info) 4 newval))

(defsubst set-server-info->motd-of-lyskom (server-info newval)
  "Set motd-of-lyskom in server-info to NEWVAL."
  (aset (cdr server-info) 5 newval))

(defsubst set-server-info->aux-item-list (server-info newval)
  "Set motd-of-lyskom in server-info to NEWVAL."
  (aset (cdr server-info) 6 newval))


;;; Predicate:

(defsubst lyskom-server-info-p (object)
  "Return t if OBJECT is a server-info."
  (eq (car-safe object) 'SERVER-INFO))


;;; ================================================================
;;;                            conf-z-info-list


;;; Constructor:

(defun lyskom-create-conf-z-info-list (conf-z-infos)
  "Create a conf-z-info-list from all parameters."
  (cons
   'CONF-Z-INFO-LIST
   (vector conf-z-infos)))


;;; Selector:

(defun conf-z-info-list->conf-z-infos (conf-z-info-list)
  "Get conf-z-infos from conf-z-info-list."
  (elt (cdr conf-z-info-list) 0))


;;; Modifier:

(defun set-conf-z-info-list->conf-z-infos (conf-z-info-list newval)
  "Set conf-z-infos in conf-z-info-list to NEWVAL."
  (aset (cdr conf-z-info-list) 0 newval))


;;; Predicate:

(defun lyskom-conf-z-info-list-p (object)
  "Return t if OBJECT is a conf-z-info-list."
  (eq (car-safe object) 'CONF-Z-INFO-LIST))

;;; ================================================================
;;;                            conf-z-info

;;; Constructor:

(defun lyskom-create-conf-z-info (name
				  conf-type
				  conf-no)
  "Create a conf-z-info from all parameters."
  (cons
   'CONF-Z-INFO
   (vector name conf-type conf-no)))


;;; Selectors:

(defun conf-z-info->name (conf-z-info)
  "Get name from conf-z-info."
  (elt (cdr conf-z-info) 0))

(defun conf-z-info->conf-type (conf-z-info)
  "Get conf-type from conf-z-info."
  (elt (cdr conf-z-info) 1))

(defun conf-z-info->conf-no (conf-z-info)
  "Get conf-no from conf-z-info."
  (elt (cdr conf-z-info) 2))


;;; Modifiers:

(defun set-conf-z-info->name (conf-z-info newval)
  "Set name in conf-z-info to NEWVAL."
  (aset (cdr conf-z-info) 0 newval))

(defun set-conf-z-info->conf-type (conf-z-info newval)
  "Set conf-type in conf-z-info to NEWVAL."
  (aset (cdr conf-z-info) 1 newval))

(defun set-conf-z-info->conf-no (conf-z-info newval)
  "Set conf-no in conf-z-info to NEWVAL."
  (aset (cdr conf-z-info) 2 newval))


;;; Predicate:

(defun lyskom-conf-z-info-p (object)
  "Return t if OBJECT is a conf-z-info."
  (eq (car-safe object) 'CONF-Z-INFO))


;;;; ================================================================
;;;; This field is just simulation of a field in the conf-stat
;;;; that not yet exist.

(defsubst conf-stat->comm-conf (conf-stat)
  (if (and (conf-type->original (conf-stat->conf-type conf-stat))
	   (not (zerop (conf-stat->super-conf conf-stat))))
      (conf-stat->super-conf conf-stat)
    (conf-stat->conf-no conf-stat)))


;;; ================================================================



;;; Utilities

(defun text-stat-find-aux (text-stat tag &optional person)
  "Return a list containing the aux items in TEXT-STAT with tag TAG.
If PERSON is non-nil return only those items created by person.
Args: TEXT-STAT TAG PERSON"
  (let ((result nil)
        (items (text-stat->aux-items text-stat)))
    (while items
      (when (and (eq tag (aux-item->tag (car items)))
                 (not (aux-item-flags->deleted
                       (aux-item->flags (car items))))
                 (or (null person)
                     (eq person (aux-item->creator (car items)))))
        (setq result (cons (car items) result)))
      (setq items (cdr items)))
    (nreverse result)))

(defun conf-stat-find-aux (conf-stat tag &optional person)
  "Return a list containing the aux items in CONF-STAT with tag TAG.
If PERSON is non-nil return only those items created by person.
Args: CONF-STAT TAG PERSON"
  (let ((result nil)
        (items (conf-stat->aux-items conf-stat)))
    (while items
      (when (and (eq tag (aux-item->tag (car items)))
                 (not (aux-item-flags->deleted
                       (aux-item->flags (car items))))
                 (or (null person)
                     (eq person (aux-item->creator (car items)))))
        (setq result (cons (car items) result)))
      (setq items (cdr items)))
    (nreverse result)))

(defun lyskom-is-recipient (text-stat conf-no)
  "Return non-nil if TEXT-STAT has CONF-NO as a recipient."
  (let ((result nil))
    (lyskom-traverse misc
        (text-stat->misc-info-list text-stat)
      (when (and (memq (misc-info->type misc) lyskom-recpt-types-list)
                 (eq (misc-info->recipient-no misc) conf-no))
        (setq result t)))
    result))



(provide 'lyskom-types)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: clienttypes.el,v 44.17 2002/05/25 18:22:39 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: clienttypes.el
;;;;
;;;; This file contains primitives for the different data types
;;;; in the lyskom elisp client. The types in here are only used
;;;; within this lyskom client.
;;;;
;;;; Authors: Linus Tolke and Inge Wallin
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: clienttypes.el,v 44.17 2002/05/25 18:22:39 byers Exp $\n"))


;;; ================================================================
;;;                            read-info

;;; A read-info is used by to tell the client which text to 
;;; show next and in which order to step through the conferences 
;;; with unread texts. New read-infos are created and deleted
;;; all the time within a session.
;;;
;;; The type is one of the following:
;;;   REVIEW      - Default review type, created by the kom-review-by-to
;;;		    and the kom-review-comments
;;;   REVIEW-TREE - List of texts created by one of the tree-reading 
;;;		    commands: kom-find-root-review, kom-review-tree
;;;   REVIEW-MARK - List of texts created by the review-mark command
;;;   REVIEW-FAQ  - List of texts created by kom-review-faq or similar
;;;   COMM-IN     - Type containing the list of comments to a text
;;;   FOOTN-IN    - Type containing the list of footnotes to a text
;;;   CONF        - Basic type of unread in a conf.
;;;   RE-EDIT-TEXT - Re-edit a failed submission. Buffer is in misc.
;;;   PRI-SESSION - Go to prioritized session.
;;;
;;;   The types REVIEW-TREE, COMM-IN and FOOTN-IN are created for new for
;;;   every text read (recursively) when appropriate.
;;;
;;;   The difference between REVIEW, REVIEW-MARK and REVIEW-FAQ is just
;;;   that there generate different prompts and different text from
;;;   kom-review-stack.
;;;


;;; read-info

(defsubst lyskom-create-read-info (type
				conf-stat
				priority
				text-list
				&optional comm-to forward misc)
  "Create a read-info from all parameters."
  ;; The last nil is for the unfetched-texts pair (first . last)
  ;; This field is only applicable in read-infos of type CONF where
  ;; it shows which part of the map for this conference that has not
  ;; yet been fetched.
  (cons
   'READ-INFO
   (vector type conf-stat priority text-list comm-to forward nil misc)))

(defsubst read-info->type (read-info)
  "Get type from read-info."
  (elt (cdr read-info) 0))

(defsubst read-info->conf-stat (read-info)
  "Get conf-stat from read-info."
  (elt (cdr read-info) 1))

(defsubst read-info->priority (read-info)
  "Get priority from read-info."
  (elt (cdr read-info) 2))

(defsubst read-info->text-list (read-info)
  "Get text-list from read-info."
  (elt (cdr read-info) 3))

(defsubst read-info->comm-to (read-info)
  "Get comm-to from read-info."
  (elt (cdr read-info) 4))

(defsubst read-info->forward (read-info)
  "Get forward from read-info."
  (elt (cdr read-info) 5))

(defsubst read-info->unfetched-texts (read-info)
  "Get forward from read-info."
  (elt (cdr read-info) 6))

(defsubst read-info->misc (read-info)
  "Get forward from read-info."
  (elt (cdr read-info) 7))

(defsubst set-read-info->type (read-info newval)
  "Set type in read-info to NEWVAL."
  (aset (cdr read-info) 0 newval))

(defsubst set-read-info->conf-stat (read-info newval)
  "Set conf-stat in read-info to NEWVAL."
  (aset (cdr read-info) 1 newval))

(defsubst set-read-info->priority (read-info newval)
  "Set priority in read-info to NEWVAL."
  (aset (cdr read-info) 2 newval))

(defsubst set-read-info->text-list (read-info newval)
  "Set text-list in read-info to NEWVAL."
  (aset (cdr read-info) 3 newval))

(defsubst set-read-info->comm-to (read-info newval)
  "Set comm-to in read-info to NEWVAL."
  (aset (cdr read-info) 4 newval))

(defsubst set-read-info->forward (read-info newval)
  "Set forward in read-info to NEWVAL."
  (aset (cdr read-info) 5 newval))

(defsubst set-read-info->unfetched-texts (read-info newval)
  "Set forward in read-info to NEWVAL."
  (aset (cdr read-info) 6 newval))

(defsubst set-read-info->misc (read-info newval)
  "Set forward in read-info to NEWVAL."
  (aset (cdr read-info) 7 newval))


(defsubst lyskom-read-info-p (object)
  "Return t if OBJECT is a read-info."
  (eq (car-safe object) 'READ-INFO))


(defsubst read-info-append-text-list (read-info texts)
  (text-list->append (read-info->text-list read-info) texts))

(defsubst read-info-enter-text-last (read-info text-no)
  (read-info-append-text-list read-info (list text-no)))

				   
;;; ================================================================
;;;                          read-list


;;; Constructor:

(defsubst lyskom-create-read-list ()
  "Create an empty read-list."
  (cons 'READ-LIST nil))


;;; Predicates:

(defsubst read-list-isempty (read-list)
  "Return t if READ-LIST is empty, otherwise return nil."
  (null (cdr read-list)))


;;; Selectors:

(defsubst read-list->first (read-list)
  "Return the first entry in READ-LIST, or nil if empty."
  (car-safe (cdr read-list)))


(defsubst read-list->nth (read-list n)
  "Args: READ-LIST N
Return element N in READ-LIST or nil if outside the range.
The range of valid values for N is [0, num-entries - 1]."
  (elt (cdr read-list) n))


(defsubst read-list->all-entries (read-list)
  "Return a list of all entries in READ-LIST."
  (cdr read-list))


;;; Other functions:

(defsubst read-list-length (read-list)
  "Return the number of entries in READ-LIST."
  (1- (length read-list)))


;;; Modifiers:

(defsubst set-read-list-empty (read-list)
  "Empty READ-LIST destructively."
  (setcdr read-list nil))


(defsubst set-read-list-del-first (read-list)
  "Delete the first entry of READ-LIST if there is one."
  (if (cdr read-list)
      (setcdr read-list (cdr (cdr read-list)))))


(defsubst read-list-enter-first (read-info read-list)
  "Enter READ-INFO first into READ-LIST."
  (setcdr read-list (cons read-info (cdr read-list))))


(defun read-list-enter-text (text-no recipient rlist)
  "Args: TEXT-NO RECIPIENT RLIST.
Add the new text TEXT-NO to any RECIPIENT found in RLIST.
RECIPIENT is a conf-stat.
Returns t if there was a conference to insert this text into."
  (let ((inserted nil))
    (lyskom-traverse
     read-info (cdr rlist)
     (cond
      ((and (eq 'CONF (read-info->type read-info))
	    (= (conf-stat->conf-no recipient)
	       (conf-stat->conf-no (read-info->conf-stat read-info))))
       (read-info-enter-text-last read-info text-no)
       (setq inserted t))))
    inserted))


(defun read-list-delete-text (text-no rlist)
  "Destructively delete all occurances of TEXT-NO from RLIST.
RLIST is a list of read-info.
Entries of the type REVIEW, REVIEW-FAQ, REVIEW-TREE or REVIEW-MARK are
not changed except if they were empty in which case they are removed.
Returns the modified RLIST.
TEXT-NO may be nil, in which case only empty read-infos on RLIST are removed."
  (let* ((prev rlist)			;"Previous" cons-celll
	 (curr (cdr rlist)))		;Current cons-cell
    (while curr
      (if text-no
	  (cond
	   ((let ((type (read-info->type (car curr)))) 
					; Don't change REVIEW et c.
	      (memq type lyskom-review-types-list)))
	   (t				; Do change all other entries.
	    (let ((tl  (read-info->text-list (car curr))))
	      (text-list->delq tl text-no)))))
      
      ;; Delete this element from RLIST if the text-list became or was empty.
      
      (if (text-list->empty (read-info->text-list (car curr)))
	  (setcdr prev (cdr curr))
	(setq prev curr))
      (setq curr (cdr curr))))
  rlist)


(defun read-list-enter-read-info (read-info rlist &optional before)
  "Destructively insert READ-INFO in RLIST, sorted by priority.
RLIST is a list of read-info.
Args: READ-INFO RLIST &optional BEFORE.
A new item with the same priority as an item that is alreay on the list
will nomally be inserted after the old one, but if BEFORE is non-nil it
will be inserted before it."
  (let ((pri (+ (if before 0 -1)
		(read-info->priority read-info)))
	(continue t)
	(conf-stat (read-info->conf-stat read-info))
	(type (read-info->type read-info)))
    (while continue
      (cond
       ;; This case was added by davidk 960925. It is not used from
       ;; everywhere, but at least lyskom-enter-map-in-to-do-list
       ;; should become more efficient.
       ((and (eq type 'CONF)
	     (eq (read-info->type (car (cdr rlist))) 'CONF)
	     (eq conf-stat (read-info->conf-stat (car (cdr rlist)))))
	(read-info-append-text-list
	 (car (cdr rlist))
	 (text-list->texts (read-info->text-list read-info)))
	(setq continue nil)) 
       
       ((null (cdr rlist)) 
	(setcdr rlist (list read-info))
	(setq continue nil))
       ((>= pri (read-info->priority (car (cdr rlist))))
	(setcdr rlist (cons read-info (cdr rlist)))
	(setq continue nil))
       (t 
	(setq rlist (cdr rlist)))))))

(defun read-list-delete-read-info (conf-no rlist)
  "Destructively removes all the entries for the conf CONF-NO in RLIST.
RLIST is a list of read-info."
  (while (cdr rlist)
    (if (eq (conf-stat->conf-no (read-info->conf-stat
				      (car (cdr rlist))))
	    conf-no)
	(setcdr rlist (cdr (cdr rlist)))
      (setq rlist (cdr rlist)))))
 
	  
(defun read-list-rotate (read-list)
  "Put the first element of READ-LIST last in the same list. The second
element will be the new first element."
  (if (> (length read-list) 2)
      (let ((first (cdr read-list))
	    (last  (cdr read-list)))
	(while (cdr last)
	  (setq last (cdr last)))
	(setcdr last first)
	(setcdr read-list (cdr first))
	(setcdr first nil)))
  read-list)    
	  

;;; ================================================================
;;;                      A simple queue

;;;
;;; This is a simple implementation of a queue.  The only thing you
;;; can do with it is stuff things at the back of it and remove
;;; things from the front of it.  (...and of course do a few tests)
;;;

;;; Author: Inge Wallin


(defun lyskom-queue-create ()
  "Create an empty queue."
  (cons 'QUEUE (cons nil nil)))


(defsubst lyskom-queue-enter (queue element)
  "Enter last into the queue QUEUE the ELEMENT."
  (let ((elementcell (cons element nil)))
    (if (null (car (cdr queue)))
	; QUEUE is empty
	(setcar (cdr queue)
		(setcdr (cdr queue) 
			elementcell))
      (setcdr (cdr (cdr queue))
	      elementcell)
      (setcdr (cdr queue)
	      elementcell))))


(defsubst lyskom-queue-p (queue)
  "Return t if QUEUE is a queue, otherwise return nil."
  (eq (car-safe queue) 'QUEUE))


(defsubst lyskom-queue-isempty (queue)
  "Return t if QUEUE is empty, otherwise return nil."
  (null (car (cdr queue))))


(defsubst lyskom-queue->first (queue)
  "Return the first element of QUEUE or nil if it is empty."
  (car-safe (car (cdr queue))))


(defsubst lyskom-queue->all-entries (queue)
  "Return all elements of QUEUE (nil if it is empty)."
  (car-safe (cdr queue)))


(defsubst lyskom-queue->last (queue)
  "Return the lastelement of QUEUE or nil if it is empty."
  (car-safe (cdr (cdr queue))))


(defsubst lyskom-queue-make-empty (queue)
  "Make the queue QUEUE empty."
  (setcdr queue (cons nil nil)))

(defsubst lyskom-queue-set-data (queue data)
  (lyskom-queue-make-empty queue)
  (setcdr queue (cons data (last data))))


(defsubst lyskom-queue-delete-first (queue)
  "Delete the first element of QUEUE and return it. If QUEUE is empty
return nil and do nothing."
  (if (lyskom-queue-isempty queue)
      nil
    (prog1
	(lyskom-queue->first queue)
      (setcar (cdr queue)
	      (cdr (car (cdr queue))))
      (if (null (car (cdr queue)))
	  (setcdr (cdr queue) nil)))))


;;; ================================================================
;;;                           A simple stack

;;; 
;;; This is an implementation of a simple stack.
;;;

;;; Author: Inge Wallin


(defun lyskom-stack-create ()
  "Create an empty stack"
  (cons 'STACK nil))


(defun lyskom-stack-p (stack)
  "Return t if STACK is a lyskom-stack, otherwise return nil."
  (eq (car-safe stack) 'STACK))


(defun lyskom-stack-push (stack element)
  "Push the second arg ELEMENT onto the first arg STACK"
  (setcdr stack (cons element (cdr stack))))


(defun lyskom-stack-pop (stack)
  "Remove the topmost element from STACK and return it. If the stack
is empty, return nil"
  (prog1
      (car-safe (cdr stack))
    (setcdr stack (cdr-safe (cdr stack)))))


(defun lyskom-stack->top (stack)
  "Return the topmost element of STACK or nil if it is empty."
  (car-safe (cdr stack)))


(defun lyskom-stack->length (stack)
  "Return the number of elements on STACK."
  (length (cdr stack)))


(defun lyskom-stack->nth (stack n)
  "Return element no (second arg) N of the stack (first arg) STACK.
N counts from zero. If the length of STACK is less than N, nil is returned."
  (nth n (cdr stack)))


(defun lyskom-stack->all-entries (stack)
  "Return a list of all entries in STACK.
The element last pushed is first in the list."
  (cdr stack))


(defsubst lyskom-stack-isempty (stack)
  "Returns non-nil if the STACK is empty."
  (not (cdr stack)))


;;; ================================================================
;;;                          who-buffer-info

;;; Author: Inge Wallin


;;; Constructor:

(defun lyskom-create-who-buffer-info (info
				      start-marker
				      end-marker)
  "Create a who-buffer-info from all parameters."
  (cons
   'WHO-BUFFER-INFO
   (vector info start-marker end-marker )))


;;; Selectors:

(defun who-buffer-info->info (who-buffer-info)
  "Get info from who-buffer-info."
  (elt (cdr who-buffer-info) 0))

(defun who-buffer-info->start-marker (who-buffer-info)
  "Get start-marker from who-buffer-info."
  (elt (cdr who-buffer-info) 1))

(defun who-buffer-info->end-marker (who-buffer-info)
  "Get end-marker from who-buffer-info."
  (elt (cdr who-buffer-info) 2))


;;; Modifiers:

(defun set-who-buffer-info->info (who-buffer-info newval)
  "Set info in who-buffer-info to NEWVAL."
  (aset (cdr who-buffer-info) 0 newval))

(defun set-who-buffer-info->start-marker (who-buffer-info newval)
  "Set start-marker in who-buffer-info to NEWVAL."
  (aset (cdr who-buffer-info) 1 newval))

(defun set-who-buffer-info->end-marker (who-buffer-info newval)
  "Set end-marker in who-buffer-info to NEWVAL."
  (aset (cdr who-buffer-info) 2 newval))



;;; Predicate:

(defun lyskom-who-buffer-info-p (object)
  "Return t if OBJECT is a who-buffer-info."
  (eq (car-safe object) 'WHO-BUFFER-INFO))


;;; ================================================================
;;;			format-props

(defun make-format-props (arg propl)
  (cons 'format-props (vector arg propl)))

(defsubst format-props-p (arg)
  (eq 'format-props (car-safe arg)))

(defsubst format-props->arg (arg)
  (elt (cdr arg) 0))

(defsubst format-props->propl (arg)
  (elt (cdr arg) 1))

;;;
;;;	Help functions
;;;



;;; ================================================================
;;;			format-state

(def-komtype format-state
  format-string
  start
  argl
  length
  result
  delayed-propl
  delayed-overlays
  delayed-content
  depth)
;; 
;; 
;; 
;; (defun make-format-state (format-string
;; 			  start
;; 			  argl
;; 			  result)
;;   (cons 'format-state
;; 	(vector format-string start argl (length argl) result nil nil nil nil)))
;; 
;; (defsubst format-state-p (arg)
;;   (eq 'format-state (car-safe arg)))
;; 
;; (defsubst format-state->format-string (arg)
;;   (elt (cdr arg) 0))
;; 
;; (defsubst set-format-state->format-string (arg str)
;;   (aset (cdr arg) 0 str))
;; 
;; (defsubst format-state->start (arg)
;;   (elt (cdr arg) 1))
;; 
;; (defsubst set-format-state->start (arg pos)
;;   (aset (cdr arg) 1 pos))
;; 
;; (defsubst format-state->args (arg)
;;   (elt (cdr arg) 2))
;; 
;; (defsubst set-format-state->args (arg argl)
;;   (aset (cdr arg) 2 argl)
;;   (aset (cdr arg) 3 (length argl)))
;; 
;; (defsubst format-state->args-length (arg)
;;   (elt (cdr arg) 3))
;; 
;; (defsubst format-state->result (arg)
;;   (elt (cdr arg) 4))
;; 
;; (defsubst set-format-state->result (arg output-list)
;;   (aset (cdr arg) 4 output-list))
;; 
;; (defsubst format-state->delayed-propl (arg)
;;   (elt (cdr arg) 5))
;; 
;; (defsubst set-format-state->delayed-propl (arg propl)
;;   (aset (cdr arg) 5 propl))
;; 
;; (defsubst format-state->delayed-overlays (arg)
;;   (elt (cdr arg) 7))
;; 
;; (defsubst set-format-state->delayed-overlays (arg overlays)
;;   (aset (cdr arg) 7 overlays))
;; 
;; (defsubst format-state->delayed-content (arg)
;;   (elt (cdr arg) 6))
;; 
;; (defsubst set-format-state->delayed-content (arg string)
;;   (aset (cdr arg) 6 string))
;; 
;; (defsubst

;;; ================================================================


;;; ======================================================================
;;;
;;; collector
;;;

;;; A collector is used when a handler needs to pass information
;;; back to a function using asynchronous calls. You could use
;;; dynamically scoped variables, but that causes problems when
;;; the user quits before all handlers have been called since the
;;; result variable will be out of scope for the remaining handlers.
;;; The best-case scenario will be a crash. The worst-case scenario
;;; is when the handler clobbers another variable with the same name
;;; that has come into scope.
;;;
;;; So, so collect a number of results, do the following:
;;;
;;;    (setq <result> (make-collector))
;;;    (<loop-function>
;;;        (initiate-<ngonting> '<queue> <function> <argl> <result>))
;;;    (lyskom-wait-queue '<queue>)
;;;    (<use> (collector->value <result>))
;;;
;;; where function is something like this:
;;;
;;;    (defun <funktion> (data-frn-servern collector)
;;;        (set-collector->value collector
;;;                              (cons (<behandla> data-frn-servern)
;;;                                    (collector->value collector))))
;;;
;;; or shorter,
;;;
;;;    (defun <funktion> (data-frn-servern collector)
;;;        (collector-push (<behandla> data-frn-servern)))
;;;
;;; This sidestepping protects the handler from scope changes.
;;;


(defun make-collector ()
  "Create a data type for collecting asynchronous results safely"
  (cons 'COLLECTOR nil))

(defsubst collector->value (collector)
  "Get the current value of a collector"
  (cdr collector))

(defsubst set-collector->value (collector value)
  "Set the calue of a collector"
  (setcdr collector value))

(defun set-value-of-collector (value collector)
  "For use with lyskom handlers. In other cases, use set-collector->value"
  (set-collector->value collector value))

(defun collector-push (value collector)
  "Push VALUE onto the front of COLLECTOR's value"
  (setcdr collector (cons value (cdr collector))))

(eval-and-compile (provide 'lyskom-clienttypes))

;;; clienttypes.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: deferred-insert.el,v 44.4 2002/02/24 20:23:26 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: deferred-insert.el
;;;;
;;;; This file includes functions for deffering insertion of
;;;; information into the LysKOM buffer.
;;;;

;;;
;;; How to defer a peice of text:
;;; =============================
;;;
;;;  1. Insert some temporary text. Use the variable
;;;     `lyskom-defer-indicator' as a placeholder.
;;; 
;;;  2. Create a defer-info-structure by calling
;;;     `lyskom-create-defer-info' with the following parameters
;;;
;;;        SERVER-CALL - the call to get the data (initate-get-*)
;;;        CALL-ARG    - the argument for the server call. This is
;;;                      limited to a single argument, which is enough
;;;                      for get-conf-stat and friends.
;;;        HANDLER     - the function to be called to insert the
;;;                      "real" data.
;;;        POS         - a marker indicating where the insertion
;;;                      should be placed.
;;;        DEL-CHARS   - an integer indicating how many characters
;;;                      from POS on should be replaced by the "real"
;;;                      text.
;;;        FORMAT      - a format string for inserting the real
;;;                      data. This should normally only contain a
;;;                      single format atom using argument 1
;;;                      (i.e. "%#1P").
;;;        DATA        - any data that you might want to use in
;;;                      HANDLER.
;;;
;;;  3. Call `lyskom-defer-insertion' with the defer-info as argument.
;;;
;;;  4. Write a handler function that takes two arguments, the server
;;;     reply and the defer-info. This function should replace the
;;;     temporary text. A convenient way to do this is to use
;;;     `lyskom-replace-deferred'.
;;;
;;;  5. Sit back and watch it work.
;;;  
;;;  Notes:
;;;  
;;;  POS must be located before the temporary text. DEL-CHARS should
;;;  usually be set to (length lyskom-defer-indicator). Don't count on
;;;  it to be 5.
;;;
;;;  Steps 1 and 2 are often implemented the other way around, or at
;;;  least the POS parameter is determined before any text is
;;;  inserted.
;;;
;;;  You should only defer text if kom-deferred-printing is non-nil.
;;;



;;; Type: defer-info

(defun lyskom-create-defer-info (server-call call-par handler pos
					     del-chars format
					     &optional data)
  (cons 'DEFER-INFO
	(vector server-call call-par handler pos del-chars format data
		lyskom-last-viewed)))

(defun lyskom-defer-info-p (obj)
  (and (consp obj)
       (eq (car obj) 'DEFER-INFO)))

(defun defer-info->server-call (di) (aref (cdr di) 0))
(defun defer-info->call-par (di)    (aref (cdr di) 1))
(defun defer-info->handler (di)     (aref (cdr di) 2))
(defun defer-info->pos (di)         (aref (cdr di) 3))
(defun defer-info->del-chars (di)   (aref (cdr di) 4))
(defun defer-info->format (di)      (aref (cdr di) 5))
(defun defer-info->data (di)        (aref (cdr di) 6))
(defun defer-info->last-viewed (di) (aref (cdr di) 7))

(defun set-defer-info->server-call (di x) (aset (cdr di) 0 x))
(defun set-defer-info->call-par (di x)    (aset (cdr di) 1 x))
(defun set-defer-info->handler (di x)     (aset (cdr di) 2 x))
(defun set-defer-info->pos (di x)         (aset (cdr di) 3 x))
(defun set-defer-info->del-chars (di x)   (aset (cdr di) 4 x))
(defun set-defer-info->format (di x)      (aset (cdr di) 5 x))
(defun set-defer-info->data (di x)        (aset (cdr di) 6 x))
(defun set-defer-info->last-viewed (di x) (aset (cdr di) 7 x))


(defun lyskom-defer-insertion (defer-info)
  "Defer insertion of something.
The insertion will be at (point)."
  (set-defer-info->last-viewed defer-info lyskom-last-viewed)
  ;; (goto-char (defer-info->pos defer-info))
  (funcall (intern-soft (concat "initiate-"
				(symbol-name (defer-info->server-call
					       defer-info)))) 
	   'deferred
	   (defer-info->handler defer-info)
	   (defer-info->call-par defer-info)
	   defer-info))

(defun lyskom-replace-deferred (defer-info &rest replacement-data)
  "Replace some defered text."
  (save-excursion
    (when (marker-buffer (defer-info->pos defer-info))
      (set-buffer (marker-buffer (defer-info->pos defer-info))))
    (goto-char (defer-info->pos defer-info))
    (apply 'lyskom-format-insert-at-point
	   (defer-info->format defer-info)
	   replacement-data)
    (let ((inhibit-read-only t))
      (delete-char (defer-info->del-chars defer-info)))
    (set-marker (defer-info->pos defer-info) nil))
  (if lyskom-executing-command
      nil
    (let ((window (get-buffer-window lyskom-buffer)))
      (if window
	  (if (pos-visible-in-window-p (point-max) window)
	      nil
	    ;; This means that this insertion moved point out of the
	    ;; window. The scrolling becomes tricky. One big problem is
	    ;; that we can't use lyskom-last-viewed, because it has been
	    ;; updated to the new prompt. Until that is solved we make
	    ;; sure that we never scroll.
	    ;;
	    ;; The solution is to save lyskom-last-viewed in the defer-info
	    (save-selected-window
	      (select-window window)
	      (lyskom-scroll))
	    ;; (move-to-window-line -1)
	    ;; (vertical-motion 1)
	    ;; (if (not (pos-visible-in-window-p))
	    ;;     (forward-char -1))
	    )))))


(defun lyskom-deferred-insert-conf (conf-stat defer-info)
  "Insert the name of a conference at a previously reserved place."
  (lyskom-replace-deferred
   defer-info
   (if (null conf-stat)
       (lyskom-format 
	(or (defer-info->data defer-info)
	    (if (= (aref (defer-info->format defer-info)
			 (1- (length (defer-info->format defer-info))))
		   ?P)
		(if (= (defer-info->call-par defer-info) 0)
		    'person-is-anonymous
		  'person-does-not-exist)
	      'conference-does-not-exist))
	(defer-info->call-par defer-info))
     conf-stat)
   (text-properties-at (defer-info->pos defer-info))))


;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: utilities.el,v 44.116 2002/08/09 15:14:50 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: utilities.el
;;;;
;;;; This file contains general lisp utility functions and
;;;; lyskom-specific utility functions (such as date formatting and
;;;; minibuffer reading)
;;;;


(setq lyskom-clientversion-long
      (concat lyskom-clientversion-long
	      "$Id: utilities.el,v 44.116 2002/08/09 15:14:50 byers Exp $\n"))

;;;
;;; Need Per Abrahamsens widget and custom packages There should be a
;;; better way of doing this, but I'll be darned if I know how. The
;;; various files need to be loaded in a very specific order.
;;;

;;; Define widget wrappers for all the functions in macros.el

;;;
;;; Lisp utility functions
;;;

(defsubst listify-vector (vector)
  "Turn VECTOR into a list"
  (append vector nil))

(defun nfirst (n list)
  "Return a list of the N first elements of LIST."
  (let ((result nil))
    (while (and (> n 0) list)
      (setq result (cons (car list) result)
            list (cdr list)
            n (1- n)))
    (nreverse result)))

(defun lyskom-rotate-list (list el)
  "Destructively rotate LIST so EL becomes the first element.
If EL occurs more than one, the first occurrence is used."
  (let ((tail (memq el list)))
    (if (or (null tail) (eq el (car list)))
        list
      (setcdr (nthcdr (- (length list) (length tail) 1) list) nil)
      (setcdr (nthcdr (1- (length tail)) tail) list)
      tail)))

(defun lyskom-preceding-cons (list el)
  "Return the cons cell of LIST preceding the first cons cell whose car is EL.
Return nil if TAIL is the same as LIST or not a member of LIST."
  (unless (or (eq (car list) el)
              (not (memq el list)))
    (nthcdr (- (length list) (length (memq el list)) 1) list)))

(defun lyskom-insert-in-list (el list before)
  "Destructively insert EL in LIST before element BEFORE.
If BEFORE is not in the list, then insert EL at the end of the list."
  (cond ((eq before (car list))
         (cons el list))
        (t (setcdr (nthcdr (- (length list)
                              (length (memq before list)) 1) list)
                   (cons el (memq before list)))
           list)))

(defun lyskom-move-in-list (el list pos)
  "Destructively move EL within LIST so it appears at position POS."
  (when (memq el list)
    (setq list (delq el list))
    (cond ((eq 0 pos) (setq list (cons el list)))
          (t (setcdr (nthcdr (1- pos) list)
                     (cons el (nthcdr pos list))))))
  list)

;;;
;;; +++ FIXME: If cl.el can be guaranteed, this is pointless.
;;;

(defun lyskom-butlast (x &optional n)
  "Returns a copy of LIST with the last N elements removed."
  (if (and n (<= n 0)) x
    (lyskom-nbutlast (copy-sequence x) n)))

(defun lyskom-nbutlast (x &optional n)
  "Modifies LIST to remove the last N elements."
  (let ((m (length x)))
    (or n (setq n 1))
    (and (< n m)
	 (progn
	   (if (> n 0) (setcdr (nthcdr (- (1- m) n) x) nil))
	   x))))

(defun filter-list (test list)
  (let ((result nil))
    (lyskom-traverse el list
      (when (funcall test el)
        (setq result (cons el result))))
    (nreverse result)))

;;;============================================================
;;;
;;; Utility functions.
;;;
;;; These should be shared in LysKOM
;;;

(eval-and-compile
  (if (eval-when-compile (string-match "XEmacs" emacs-version))
      (defmacro lyskom-compiled-function-p (arg) `(compiled-function-p ,arg))
    (defmacro lyskom-compiled-function-p (arg) `(byte-code-function-p ,arg))))

(lyskom-provide-function copy-tree (l)
  "Recursively copy the list L"
  (cond ((atom l) l)
        (t (cons (copy-tree (car l))
                 (copy-tree (cdr l))))))

(lyskom-provide-function functionp (obj)
  "Returns t if OBJ is a function, nil otherwise."
  (cond
   ((symbolp obj) (fboundp obj))
   ((subrp obj))
   ((lyskom-compiled-function-p obj))
   ((consp obj)
    (if (eq (car obj) 'lambda) (listp (car (cdr obj)))))
   (t nil)))


(defun lyskom-ignore (&rest args)
  "Ignore all arguments"
  )

(defun regexpp (re)
  "Return non-nil if RE looks like a valid regexp."
  (let ((result t))
    (save-match-data
      (condition-case nil
          (string-match re "")
        (error (setq result nil))))
    result))


(defun mapcar2 (fn seq1 seq2)
  (let (result)
    (while (and seq1 seq2)
      (setq result (cons (funcall fn (car seq1) (car seq2)) result))
      (setq seq1 (cdr seq1)
            seq2 (cdr seq2)))
    (nreverse result)))


(defun lyskom-maxint ()
  (let ((n 1) 
        (l nil)
        (i 31))
    (while (and (> n 0) (> i 0))
      (setq l (cons n l))
      (setq n (* 2 n))
      (setq i (1- i)))
    (apply '+ l)))

;; Set lyskom-maxint correctly

(setq lyskom-max-int (lyskom-maxint))


(defun lyskom-try-require (feature &optional message &rest args)
  "Load the feature FEATURE using require. 
If optional MESSAGE is non-nil, use it as a LysKOM format string 
taking one string argument to print an error message. Remaining
arguments are used as arguments for the format string.

Returns t if the feature is loaded or can be loaded, and nil otherwise."
  (or (featurep 'feature)
      (condition-case nil
          (progn (require feature)
                 t)
        (error 
         (when message
           (apply 'lyskom-format-insert-before-prompt message (symbol-name feature) args))
         nil))))
                               
      

(defun lyskom-emacs-version ()
  (cond ((string-match "^XEmacs" (emacs-version)) 'xemacs)
	(t 'emacs)))


(defvar lyskom-apo-timeout 0
  "Current millisecond timeout value for accept-process-output")

(defvar lyskom-apo-timeout-index 0
  "Index in lyskom-apo-timeout-vector-max where last timeout is")

(defconst lyskom-apo-timeout-vector
  [0 1000 1000 2000 3000 5000 8000 13000 21000 34000 55000 89000 144000 233000 377000 610000]
  "Vector of timeout values (usecs) for accept-process-output")

(defconst lyskom-apo-timeout-vector-max (1- (length lyskom-apo-timeout-vector))
  "Maximum index in lyskom-apo-timeout-vector")

(defun lyskom-next-apo-timeout ()
  (if (< lyskom-apo-timeout-index lyskom-apo-timeout-vector-max)
      (setq lyskom-apo-timeout
            (aref lyskom-apo-timeout-vector
                  (setq lyskom-apo-timeout-index
                        (1+ lyskom-apo-timeout-index))))))

(defun lyskom-reset-apo-timeout ()
  (setq lyskom-apo-timeout-index -1)
  (setq lyskom-apo-timeout 0))

(defun lyskom-accept-process-output ()
  "Call accept-process-output with the correct timeout values."
  (lyskom-next-apo-timeout)
  (accept-process-output nil 0 lyskom-apo-timeout))

(defun lyskom-set-alist (alist item value)
  "Modifies (non-destructively) an alist ALIST to set item
ITEM to the value VALUE."
  (let ((pair (assq item alist)))
     (if pair
         (progn (setcdr pair value) alist)
       (cons (cons item value) alist))))

;;;
;;; LysKOM utility functions
;;;

(lyskom-provide-function string-to-sequence (string type)
  "Convert STRING to a sequence of TYPE which contains characters in STRING.
TYPE should be `list' or `vector'."
  (let ((len (length string))
	(i 0)
	val)
    (cond ((eq type 'list)
	   (setq val (make-list len 0))
	   (let ((l val))
	     (while (< i len)
	       (setcar l (aref string i))
	       (setq l (cdr l) i (1+ i)))))
	  ((eq type 'vector)
	   (setq val (make-vector len 0))
	   (while (< i len)
	     (aset val i (aref string i))
	     (setq i (1+ i))))
	  (t
	   (error "Invalid type: %s" type)))
    val))

(lyskom-provide-subst string-to-vector (string)
  "Return a vector of characters in STRING."
  (string-to-sequence string 'vector))

;;;
;;; WARNING!
;;;
;;; The following variable is *important* if you fuck it up in any
;;; way, the functions used to read conference names won't work. So if
;;; you change it, try to work one character at a time, and when
;;; you're done, run through the mappings of all 256 characters to
;;; make sure they look OK.
;;;
;;; Make sure your MULE Emacs doesnt fuck it up for you. It did for me.
;;;

(defvar lyskom-default-collate-table
  "\000\001\002\003\004\005\006\007\010 \012\013\014\015\016\017\020\021\022\023\024\025\026\027\030\031\032\033\034\035\036\037 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]~\200\201\202\203\204\205\206\207\210\211\212\213\214\215\216\217\220\221\222\223\224\225\226\227\230\231\232\233\234\235\236\237!AAAA[]ACEEEEIIIINOOOO\\OUUUYYAAAA[]ACEEEEIIIINOOOO\\OUUUYY"
  "String mapping characters to their collate class.

Lowercase, uppercase and other equivalents are mapped to the same class.
The class number defines a proper sorting order.")


(defsubst lyskom-maybe-recode-string (s &optional coding force)
  "Change the encoding of S for when multibyte characters are not supported.
Optional second argument CODING is the coding system to use. If optional
third argument FORCE is non-nil, always encode multibyte strings, otherwise
only encode when multibyte strings are not supported."
  (if (and (multibyte-string-p s) (or force (not enable-multibyte-characters)))
      (encode-coding-string s (or coding
                                  (and lyskom-language
                                       (lyskom-language-coding lyskom-language))
                                  'raw-text))
    s))

(defun lyskom-recode-string-for-title (s coding)
  "Encode S with CODING for use in frame titles.
Attempts to encode the string only in Emacs versions that do not require
MULE coding for frame titles"
  (if (> emacs-major-version 20)
      s
    (lyskom-maybe-recode-string s coding t)))

(defun lyskom-maybe-frob-completion-table (table &optional copy)
  "Recode the cars of alist TABLE to default coding system unless multibyte
characters are enabled. This function is destructive unless optional copy
is non-nil."
  (cond (enable-multibyte-characters table)
	(copy (mapcar (lambda (el)
			(cons (lyskom-maybe-recode-string (car el) nil t)
			      (cdr el)))
                      table))
	(t (lyskom-traverse el table
		(setcar el (lyskom-maybe-recode-string (car el) nil t)))
	   table)))


(defsubst lyskom-unicase-char (c)
  "Smash case and diacritical marks on c." 
  (if (< (char-to-int c) (length lyskom-collate-table))
      (aref lyskom-collate-table (char-to-int c))
    (setq c (lyskom-encode-coding-char c lyskom-server-coding-system))
    (if (and c (< (char-to-int c) (length lyskom-collate-table)))
	(aref lyskom-collate-table (char-to-int c))
      c)))

(defun lyskom-unicase (s)
  "Smash case and diacritical marks of all chars in s." 
  (lyskom-save-excursion
   (and lyskom-buffer (set-buffer lyskom-buffer))
   (let* ((s2 (string-to-vector 
               (encode-coding-string s lyskom-server-coding-system)))
          (l (length s2)))
     (while (> l 0)
       (setq l (1- l))
       (aset s2 l (lyskom-unicase-char (aref s2 l))))
     (concat s2))))

(defun lyskom-looking-at (s)
  "Version of looking-at that will work in Gnu Emacs 20.3"
  (save-excursion
    (let ((start (point)))
      (and (re-search-forward s nil t)
	   (eq (match-beginning 0) start)))))

;; Don't slow things down with our own looking-at unless we have to

(eval-and-compile
 (condition-case nil
     (if (and (eq emacs-major-version 20)
	      (eq emacs-minor-version 3))
	 nil
       (fset 'lyskom-looking-at (symbol-function 'looking-at)))
   (error nil)))


(defun lyskom-compute-char-classes (map)
  "Find out which characters that are equivalent according to MAP.

MAP should be a collate table.

The return value is an assoc list, which characters as keys, and a
list of single-character strings as values.  Only characters that are
equivalent to at least one more character is returned in the assoc
list.

Example: if this function returns

	((97 \"A\" \"a\")
         (65 \"A\" \"a\")
	 (48 \"O\" \"o\" \"0\")
	 (111 \"O\" \"o\" \"0\")
	 (79 \"O\" \"o\" \"0\"))

it means that a and A are equivalent, and o, O and 0 are equivalent.
All other characters are unique."

  (lyskom-save-excursion
    (and lyskom-buffer (set-buffer lyskom-buffer))
    (let ((ix (length map))
	  (cls-to-strings nil)) ;assoc-list from equivalence class to
				;list of chars
      (while (> ix 0)
	(setq ix (1- ix))
	(let* ((cls (aref map ix))
	       (str (decode-coding-string (concat (vector ix))
					  lyskom-server-coding-system))
	       (elem (assoc cls cls-to-strings)))
	  (if elem
	      (rplacd elem (cons str (cdr elem)))
	    (setq cls-to-strings (cons (list cls str) cls-to-strings)))))
      (let ((res nil))
	(while cls-to-strings
	  (let ((lst (cdr (car cls-to-strings))))
	    (if (> (length lst) 1)
		(while lst
		  (setq res (cons (cons (string-to-char (car lst))
					(cdr (car cls-to-strings)))
				  res))
		  (setq lst (cdr lst)))))
	  (setq cls-to-strings (cdr cls-to-strings)))
	res))))
    
;; Stolen from thingatpt.el
;; FIXME: We may not really need this function. Check the callers.

(defun lyskom-thing-at-point-looking-at (regexp)
  "Return non-nil if point is in or just after a match for REGEXP.
Set the match data from the earliest such match ending at or after
point."
  (save-excursion
    (let ((old-point (point)) match)
      (and (looking-at regexp)
	   (>= (match-end 0) old-point)
	   (setq match (point)))
      ;; Search back repeatedly from end of next match.
      ;; This may fail if next match ends before this match does.
      (re-search-forward regexp nil 'limit)
      (while (and (re-search-backward regexp nil t)
		  (or (> (match-beginning 0) old-point)
		      (and (looking-at regexp) ; Extend match-end past search start
			   (>= (match-end 0) old-point)
			   (setq match (point))))))
      (if (not match) nil
	(goto-char match)
	;; Back up a char at a time in case search skipped
	;; intermediate match straddling search start pos.
	(while (and (not (bobp))
		    (progn (backward-char 1) (looking-at regexp))
		    (>= (match-end 0) old-point)
		    (setq match (point))))
	(goto-char match)
	(looking-at regexp)))))


;; Stolen from Gnu Emacs

(defun lyskom-truncate-string-to-width (str end-column &optional start-column padding)
  "Truncate string STR to end at column END-COLUMN.
The optional 2nd arg START-COLUMN, if non-nil, specifies
the starting column; that means to return the characters occupying
columns START-COLUMN ... END-COLUMN of STR.

The optional 3rd arg PADDING, if non-nil, specifies a padding character
to add at the end of the result if STR doesn't reach column END-COLUMN,
or if END-COLUMN comes in the middle of a character in STR.
PADDING is also added at the beginning of the result
if column START-COLUMN appears in the middle of a character in STR.

If PADDING is nil, no padding is added in these cases, so
the resulting string may be narrower than END-COLUMN."
  (or start-column
      (setq start-column 0))
  (let ((len (length str))
	(idx 0)
	(column 0)
	(head-padding "") (tail-padding "")
	ch last-column last-idx from-idx)
    (condition-case nil
	(while (< column start-column)
	  (setq ch (aref str idx)
		column (+ column (char-width ch))
		idx (1+ idx)))
      (args-out-of-range (setq idx len)))
    (if (< column start-column)
	(if padding (make-string end-column padding) "")
      (if (and padding (> column start-column))
	  (setq head-padding (make-string (- column start-column) padding)))
      (setq from-idx idx)
      (if (< end-column column)
	  (setq idx from-idx)
	(condition-case nil
	    (while (< column end-column)
	      (setq last-column column
		    last-idx idx
		    ch (aref str idx)
		    column (+ column (char-width ch))
		    idx (1+ idx)))
	  (args-out-of-range (setq idx len)))
	(if (> column end-column)
	    (setq column last-column idx last-idx))
	(if (and padding (< column end-column))
	    (setq tail-padding (make-string (- end-column column) padding))))
      (setq str (substring str from-idx idx))
      (if padding
	  (concat head-padding str tail-padding)
	str))))


(eval-and-compile
  (lyskom-xemacs-or-gnu
   (fset 'lyskom-string= (symbol-function 'string=))
   (if (< emacs-major-version 20)
       (fset 'lyskom-string= (symbol-function 'string=))
     (defun lyskom-string= (s1 s2)
       (string= (and s1 (if (multibyte-string-p s1)
		    s1
		  (decode-coding-string s1 (lyskom-language-coding
					    lyskom-language))))
		(and s2 (if (multibyte-string-p s2)
		    s2
		  (decode-coding-string s2 (lyskom-language-coding
					    lyskom-language)))))))))

(defun lyskom-string-assoc (key list)
  "Return non-nil if KEY is the same string as the car of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (car (car list))))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-string-member (key list)
  "Return non-nil if KEY is the same string as the car of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (car list)))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-string-rassoc (key list)
  "Return non-nil if KEY is the same string as the cdr of an element of LIST.
The value is actually the element of LIST whose car equals KEY."
  (let ((s (and key (downcase key)))
        (result nil))
    (while list
      (when (lyskom-string= s (downcase (cdr (car list))))
        (setq result (car list))
        (setq list nil))
      (setq list (cdr list)))
    result))

(defun lyskom-set-default (sym val)
  "Set the value of SYM in the LysKOM buffer to VAL."
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (set sym val)))

(defun lyskom-default-value (sym)
  "Get the value of SYM in the LysKOM buffer"
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (symbol-value sym)))

(defun lyskom-default-value-safe (sym)
  "Get the value of SYM in the LysKOM buffer"
  (save-excursion
    (set-buffer (or (and (boundp 'lyskom-buffer)
                         (bufferp lyskom-buffer)
                         (buffer-live-p lyskom-buffer)
                         lyskom-buffer)
                    (current-buffer)))
    (and (boundp sym) (symbol-value sym))))


;;; ============================================================
;;; Prefix arguments

(defun lyskom-get-ancestors-of-text (text-no level)
  "Returns a list of all ancestors of TEXT-NO that are LEVEL
comment/foot-note levels up the comment tree. LEVEL is a
non-negative integer and 0 means the given text-no."
  (if (< level 1)
      (list text-no)
    (let* ((text-stat (blocking-do 'get-text-stat text-no))
	   (ancestors (and text-stat
			   (lyskom-text-stat-commented-texts text-stat)))
	   (level (1- level))
	   (result '()))
	(while ancestors
	  (setq result
		(lyskom-union
		 (lyskom-get-ancestors-of-text (car ancestors) level)
		 result
                 ))
	  (setq ancestors (cdr ancestors)))
	result)))

(defun lyskom-get-explicit-text (arg &optional prompt default constraint) arg)
(defun lyskom-get-command-specified-default-text (a p def &optional c) def)

(defun lyskom-get-last-read-text (&optional arg prompt default constraint)
  (lyskom-default-value 'lyskom-current-text))

(defun lyskom-get-previous-text (&optional arg prompt default constraint)
  lyskom-previous-text)

(defun lyskom-get-text-at-point (&optional arg prompt default constraint)
  (or (lyskom-text-at-point)
       (lyskom-get-string 'no-text-at-point)))

(defun lyskom-get-text-at-point-ancestor (arg &optional p d c)
  (let* ((text (lyskom-text-at-point))
	 (cnos (and text (lyskom-get-ancestors-of-text text arg)))
	 (txts (length cnos)))
    (cond
     ((not text)
      (lyskom-get-string 'no-text-at-point))
     ((eq txts 0)
      (lyskom-get-string 'no-comment-to))
     ((eq txts 1)
      (car cnos))
     (t
      (lyskom-read-number (lyskom-get-string 'what-ancestor) (car cnos))))))

(defun lyskom-prompt-for-text-no (arg prompt default &optional constraint)
  (lyskom-read-number prompt default))

(defun lyskom-get-last-text-written-by-me (&optional a p d c)
  (lyskom-default-value 'lyskom-last-written))

(defun lyskom-get-last-written-or-read-by-me (&optional a p d c)
  (lyskom-default-value 'lyskom-last-seen-written))

(defun lyskom-get-text-above-point (arg &optional prompt default constraint)
  (save-excursion
    (let ((former-point (point)))
      (backward-text (+ 1 arg))
      (if (looking-at "\\([0-9]+\\)\\s-")
	  (string-to-int (match-string 1))
	(progn ;; we probably ended up above the first message in the buffer
	  (forward-text)
	  (if (and (< (point) former-point)
		   (looking-at "\\([0-9]+\\)\\s-"))
	      (string-to-int (match-string 1))
	    (lyskom-error (lyskom-get-string 'bad-text-no-prefix) arg)))))))

(defun lyskom-get-text-below-point (arg &optional prompt default constraint)
  (save-excursion
    (let ((former-point (point)))
      (forward-text arg)
      (if (looking-at "\\([0-9]+\\)\\s-")
	  (string-to-int (match-string 1))
	(progn ;; we probably ended up below the final message in the buffer
	  (backward-text)
	  (if (and (> (point) former-point)
		   (looking-at "\\([0-9]+\\)\\s-"))
	      (string-to-int (match-string 1))
	    (lyskom-error (lyskom-get-string 'bad-text-no-prefix) arg)))))))

(defun lyskom-read-text-no-prompt-p (command)
  "Return non-nil if the COMMAND should prompt for a text number."
  (let ((check (assq command kom-text-no-prompts)))
    (if check (cdr check) (memq command lyskom-text-no-prompts-defaults))))

(defun lyskom-read-text-no-prefix-arg (prompt &optional always-prompt
				       default constraint)
  "Call in interactive list to read text-no for lyskom-commands using
configurable prefix argument heuristics. The strategy used for picking a
text-no is defined by the variable `kom-pick-text-no-strategy-alist'.

The PROMPT will be used to prompt for the number, either if invoked by the
strategy directly, or as a fallback when no strategy rule found a text-no,
or when that text-no did not meet the CONSTRAINT.

If the optional argument ALWAYS-PROMPT is non-nil and the user did not give
a prefix argument, she gets prompted for the text number regardless of the
`kom-pick-text-no-strategy-alist' settings. Another method of overriding
the prefix-less strategies for a command is via `kom-text-no-prompts'.

When DEFAULT is given, it will be the default text-no fall-back shown in the
prompt, when `kom-pick-text-no-strategy-alist' did not specify a working
default. The requirements that must be met are given by CONSTRAINT, when
specified. DEFAULT is either a text-no, a function for returning one or one
of the symbols 'last-seen-written and 'last-written, which are compatibility
aliases for lyskom-get-last-written-or-read-by-me and
lyskom-get-last-text-written-by-me respectively.

If the optional CONSTRAINT function or list is provided, it is called for
the text chosen by the strategy alist functions to validate that the text
really applies to the command. Returning nil means that it does, and
otherwise a helpful lyskom format string should be returned, which explains
to the user why that text did not apply to the command. This string may
refer to the text-no as %#1. The message is then presented to the user and
she gets prompted for a better text number. Failing a second time will
invoke the command anyway (probably to fail miserably, reporting a less
helpful error message).

When CONSTRAINT is a list, its first item is called with the text number as
its first argument and remaining list items appended to the argument list."
;  (lyskom-insert (format "Prefix arg: %s\n" current-prefix-arg))
  (let ((default (cond ((eq default 'last-written)
			(lyskom-get-last-text-written-by-me))
		       ((eq default 'last-seen-written)
			(lyskom-get-last-written-or-read-by-me))
		       ((functionp default) (funcall default))
		       (t default)))
	(constraint-func constraint)
	(constraint-args '())
	(text-no nil))
    (when (listp constraint)
      (setq constraint-func (car constraint))
      (setq constraint-args (cdr constraint)))
    (let* ((strategies kom-pick-text-no-strategy-alist)
           (how (append (cdr (assq lyskom-current-command strategies))
                        (cdr (assq t strategies)))))
      (while (and how (null text-no))
        (let* ((strategy-pred nil) ;; when a predicate to test the prefix
               (compare-value nil) ;; when a value to compare the prefix to
               (applies-p (car (car how))) ;; either one of the above
               (what-text (cdr (car how)))
               (constraint-not-met nil))
          (if (or (eq applies-p '-) (not (functionp applies-p)))
              (setq compare-value applies-p)
            (setq strategy-pred applies-p))

          (cond
           ((eq compare-value t) ;; provided a default value for the prompt
            (let ((new-default (lyskom-evaluate-text-no-strategy
                                what-text prompt default constraint)))
              (when (and (lyskom-plusp new-default))
                (setq default (or default new-default)))))

           ((or (eq compare-value current-prefix-arg) ;; a text-no strategy
                (and (functionp strategy-pred)
                     (funcall strategy-pred current-prefix-arg)))
            (setq text-no (lyskom-evaluate-text-no-strategy
                           what-text prompt default constraint))
;	    (lyskom-insert (format "cmp: %s\npred: %s\ntext-no: %s\n\n"
;				   compare-value strategy-pred text-no))
            (when (and (not (stringp text-no)) text-no constraint)
              (setq constraint-not-met
                    (apply constraint-func text-no constraint-args))
              (when constraint-not-met
                (lyskom-format-insert constraint-not-met text-no)
                (lyskom-format-insert
                 (lyskom-get-string 'prefix-arg-try-again))
                (setq text-no (lyskom-read-number prompt default))))))
          (setq how (cdr how)))))
    (cond
     ((stringp text-no) ;; a strategy failure error message
      (lyskom-error text-no))
     ((and (null current-prefix-arg)
           (or always-prompt
               (lyskom-read-text-no-prompt-p lyskom-current-command)))
      (lyskom-read-number prompt 
                          (if (lyskom-plusp text-no) 
                              text-no
                            (lyskom-default-value 'lyskom-current-text))))
     ((and (lyskom-plusp text-no)) ;; a proper text-no
      text-no)
     ((null current-prefix-arg) ;; a fall-back when no strategy had kicked in
      (lyskom-read-number prompt default))
     (t
      (lyskom-error (lyskom-get-string 'bad-text-no-prefix)
                    current-prefix-arg)))))

(defun lyskom-evaluate-text-no-strategy (strategy prompt default constraint)
  (let ((prefix current-prefix-arg)
	(strategy-func nil)
	(strategy-args '()))
    (cond
     ((listp strategy)
      (setq strategy-func (car strategy))
      (setq prefix (funcall (car (cdr strategy)) prefix))
      (setq strategy-args (cdr (cdr strategy)))
      (apply strategy-func prefix prompt default constraint
	     strategy-args))
     ((functionp strategy)
      (funcall strategy prefix prompt default constraint)))))

;;; ============================================================
;;; Set functions

(defun lyskom-subset-p (a b)
  "Return non-nil if A is a subset of B"
  (let ((result t))
    (while a
      (if (memq (car a) b)
          (setq a (cdr a))
        (setq result nil a nil)))
    result))

(defun lyskom-intersection (a b)
  "Returns as a list the intersection of list A and list B.
The order of the list a is kept."
  (if (or a b)
      (let ((list nil))
        (while a
          (if (memq (car a) b)
              (setq list (cons (car a) list)))
          (setq a (cdr a)))
        (nreverse list))))

(defun lyskom-union (a b)
  "Returns a list containing the union of list A and list B.
Specifically, concatenate all elements of B that are not in A
to the end of A. This operation is destructive and modifies the
list pointed to by A."
  (let ((result nil))
    (lyskom-traverse x b
      (unless (memq x a) (setq result (cons x result))))
    (nconc a (nreverse result))))

(defun lyskom-delete-duplicates (list &optional key)
  "Removes all but one instance of each element in LIST.
If optional argument KEY is non-nil, apply KEY to each element before
comparison. Comparison is done with eq."
  (let ((clist (mapcar (lambda (el)
                         (if key
                             (cons (funcall key el) el)
                           (cons el el)))
                       list))
        (result nil))
    (lyskom-traverse el clist
      (unless (assq (car el) result)
        (setq result (cons el result))))
    (nreverse (mapcar 'cdr result))))

(defun lyskom-plusp (int)
  "Returns t for integers greater than 0, nil otherwise."
  (and (integerp int) (> int 0)))

(defun lyskom-minusp (int)
  "Returns t for integers smaller than 0, nil otherwise."
  (and (integerp int) (< int 0)))

;;; ======================================================================
;;; Display device management
;;;


;;; Definition of some useful functions from XEmacs

(lyskom-provide-function console-type (&optional console)
  (or window-system 'tty))

(lyskom-external-function display-color-p)
(lyskom-external-function display-grayscale-p)

(eval-and-compile
  (cond ((fboundp 'device-class)	; XEmacsism
	 (defalias 'lyskom-device-class 'device-class))
	((and (fboundp 'display-color-p) (fboundp 'display-grayscale-p))
	 ;; Emacs 21 can use color even when not running under
	 ;; X-windows.  Note that display-grayscale-p can be false when
	 ;; using a color display!  This happens when running on a
	 ;; classic Linux tty console.
	 (defun lyskom-device-class (&optional device)
	   (cond ((display-color-p device) 'color)
		 ((display-grayscale-p device) 'grayscale)
		 (t 'mono))))
	(t ;; This works in Emacs 20 and earlier.
	 (defun lyskom-device-class (&optional device)
	   (condition-case nil
	       (if (x-display-grayscale-p device)
		   (if (x-display-color-p device)
		       'color
		       'grayscale)
		   'mono)
	     (error 'mono))))))

(lyskom-provide-function frame-property (frame property &optional default)
  (or (cdr (assq property (frame-parameters frame)))
      default))


;;; XEmacs doesn't seem to have a background-mode frame property

(defun lyskom-background-mode ()
  (frame-property (selected-frame) 'background-mode 'light))


;;; ======================================================================
;;; LysKOM Hooks
;;;

(defun lyskom-run-hook-with-args (hook &rest args)
  "Run HOOK with the specified arguments ARGS in the LysKOM buffer.
See run-hook-with-args for detailed information."
  (lyskom-save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                              lyskom-buffer)
                                         (current-buffer)))
                  (apply 'run-hook-with-args hook args)))


;;;(defun lyskom-set-variable-hook-wrapper (hook-function args)
;;;  "Wrapper for running HOOK-FUNCTION with ARGS.
;;;If HOOK returns an alist ((S1 . V1) ...), set value of symbol S1 to V1
;;;and similarly for each element.
;;;
;;;The hook may set hook-function-args to change the arguments to subsequent
;;;hook functions.
;;;
;;;Hook functions that rely on this are totally dependent on the current 
;;;implementation of all callers. If you think you want to use this feature,
;;;think again. You probably don't."
;;;  (lyskom-traverse el (apply hook args)
;;;    (set (car el) (cdr el))))
;;;
;;;
;;;(defun lyskom-run-hook-with-wrapper (hook wrapper &rest args)
;;;  "Run HOOK by calling WRAPPER for each function in the LysKOM buffer.
;;;The wrapper will be called with arguments FUNCTION and ARGS. It
;;;calls the actual hook function by applying FUNCTION to ARGS.
;;;
;;;This function emulates the built-in run-hook-with-args function.
;;;It is modeled on the XEmacs 21.2 implementation, so there may be
;;;slight discrepancies with other Emacs versions.
;;;
;;;The variable hook-function-args holds the arguments to the hook 
;;;function (the ARGS parameter for the wrapper)."
;;;  (save-excursion
;;;    (set-buffer (or (and (boundp 'lyskom-buffer) lyskom-buffer)
;;;                    (current-buffer)))
;;;    (let ((hook-function-args args))
;;;      (when (and hook (boundp hook))
;;;        (let ((val (symbol-value hook)))
;;;          (if (and (consp val) (eq (car val 'lambda)))
;;;              (funcall wrapper val args)
;;;            (while (and val (consp val))
;;;              (if (eq (car val) t)
;;;                  (let ((globals (default-value hook)))
;;;                    (if (and (consp globals) (eq (car globals 'lambda)))
;;;                        (funcall wrapper hook args)
;;;                      (while (and globals (consp globals))
;;;                        (unless (eq (car globals t))
;;;                          (funcall wrapper (car globals) args))
;;;                        (setq globals (cdr globals)))))
;;;                (funcall wrapper (car val) args)
;;;                (setq val (cdr val))))))))))

                                                     

(defun lyskom-add-hook (hook function &optional append)
  "Add to the value of HOOK the function FUNCTION in the LysKOM buffer.
If optional APPEND is non-nil, add at the end of HOOK."
  (save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                       lyskom-buffer)
                                  (current-buffer)))
                  (add-hook hook function append t)))

(defun lyskom-remove-hook (hook function)
  "From the value of HOOK remove the function FUNCTION in the LysKOM buffer."
  (save-excursion (set-buffer (or (and (boundp 'lyskom-buffer)
                                       lyskom-buffer)
                                  (current-buffer)))
                  (remove-hook hook function t)))




;;; ======================================================================
;;; Printing
;;;
;;; XEmacs princ does not insert text properties. This function is based
;;; on the C code for princ. 
;;;

(defun lyskom-princ (object &optional stream)
  "Output the printed representation of OBJECT, any Lisp OBJECT.
No quoting characters are used; no delimiters are printed around
the contents of strings. Text properties are retained.

Output stream is STREAM, or value of standard-output, and must be a
buffer or a marker. Function or minibuffer streams are not supported
for strings."
  (if (not (stringp object))
      (princ object stream)
    (let ((old-point nil)
          (start-point nil)
          (old-buffer (current-buffer)))
      (unwind-protect
          (progn
            (cond ((bufferp stream) (set-buffer stream))
                  ((markerp stream) 
                   (setq old-point (point))
                   (set-buffer (marker-buffer stream))
                   (goto-char stream)
                   (setq start-point (point)))
                  ((null stream)
                   (cond ((bufferp standard-output) (set-buffer standard-output))
                         ((markerp standard-output) 
                          (setq old-point (point))
                          (set-buffer (marker-buffer standard-output))
                          (goto-char standard-output)
                          (setq start-point (point))))))

            (insert object))
        (cond ((markerp stream) 
               (set-marker stream (point))
               (if (>= old-point start-point)
                   (goto-char (+ old-point (- (point) start-point)))
                 (goto-char old-point))))
        (set-buffer old-buffer)))))


;;; ======================================================================
;;; Faces
;;;

(make-face 'lyskom-weak-highlight-face)
(make-face 'lyskom-strong-highlight-face)

(defun lyskom-set-face-foreground (face color)
  (condition-case nil
      (set-face-foreground face color)
    (error nil)))

(defun lyskom-set-face-background (face color)
  (condition-case nil
      (set-face-background face color)
    (error nil)))

(defun lyskom-copy-face (old new)
  (lyskom-xemacs-or-gnu (copy-face old new nil nil nil 'remove-all)
                        (copy-face old new)))



(defun lyskom-set-face-scheme (scheme)
  "Set the LysKOM color and face scheme to SCHEME. Valid schemes are listed
in lyskom-face-schemes."
  (let ((tmp (assoc scheme lyskom-face-schemes))
        (properties nil)
        (set-faces nil)
        (background (or (face-background 'default)
                        (frame-property (selected-frame) 'background-color))))
    (when (and tmp
               (fboundp 'copy-face)
               (fboundp 'lyskom-set-face-foreground)
               (fboundp 'lyskom-set-face-background))


      ;; If we have a background color, then compute the highlight colors

      (when background
        (lyskom-set-face-background 'lyskom-strong-highlight-face
                                    (lyskom-get-color-highlight (lyskom-color-values background) 0.05))
        (lyskom-set-face-background 'lyskom-weak-highlight-face
                                    (lyskom-get-color-highlight (lyskom-color-values background) 0.025)))

      ;; Traverse face specifications in the face scheme

      (lyskom-traverse spec (cdr tmp)
        (if (eq 'property (car spec))
            (setq properties (cons (cons (elt spec 1) (elt spec 2)) properties))
          (if (elt spec 1) (lyskom-copy-face (elt spec 1) (elt spec 0)) (make-face (elt spec 0)))
          (when (elt spec 2) (lyskom-set-face-foreground (elt spec 0) (elt spec 2)))
          (when (elt spec 3) (lyskom-set-face-background (elt spec 0) (elt spec 3)))
          (setq set-faces (cons (elt spec 0) set-faces))))

      ;; Check that the background color of the default face is what
      ;; the face scheme expects. If not, copy the computed highlight
      ;; faces to the real highlight faces.

      (let ((expected-background
             (or (null background)
                 (null (assq 'expected-background properties))
                 (equal (lyskom-color-values 
                         (cdr (assq 'expected-background properties)))
                        (lyskom-color-values background)))))
         (unless (and (memq 'kom-dashed-lines-face set-faces)
                      expected-background)
           (copy-face 'lyskom-strong-highlight-face 'kom-dashed-lines-face))

         (unless (and (memq 'kom-text-body-face set-faces)
                      expected-background)
           (copy-face 'lyskom-weak-highlight-face 'kom-text-body-face))

         (unless (and (memq 'kom-async-dashed-lines-face set-faces)
                      expected-background)
           (copy-face 'lyskom-strong-highlight-face 'kom-async-dashed-lines-face))

         (unless (and (memq 'kom-async-text-body-face set-faces)
                      expected-background)
           (copy-face 'lyskom-weak-highlight-face 'kom-async-text-body-face))

         (setq set-faces (append set-faces
                                 (list 'kom-dashed-lines-face
                                       'kom-text-body-face
                                       'kom-async-dashed-lines-face
                                       'kom-async-text-body-face))))

        ;; Check that we've set all faces. If not, copy the default face and post a message

        (let ((unset-faces nil))
          (lyskom-traverse face-name lyskom-faces
            (unless (memq face-name set-faces)
              (setq unset-faces (cons face-name unset-faces))
              (copy-face 'default face-name)))

          (when unset-faces
            (lyskom-format-insert-before-prompt 
             'missing-faces
             (symbol-name scheme)
             (mapconcat 'symbol-name
                        unset-faces
                        "\n    ")))))))


(defun lyskom-face-resource (face-name attr type)
  (if (eq (lyskom-emacs-version) 'xemacs)
      ;; XEmacs style
      (let ((val (x-get-resource (concat face-name ".attribute" attr)
				 (concat "Face.Attribute" attr)
				 type)))
	(cond ((eq type 'string) val)
	      ((and (eq type 'boolean) val) (if (car val) 'on 'off))
	      (t val)))
    ;; Emacs style
    (let ((val (x-get-resource (concat face-name ".attribute" attr)
			       (concat "Face.Attribute" attr))))
      (cond ((eq type 'string) val)
	    ((and val
		  (eq type 'boolean)
		  (member (downcase val) '("on" "true"))) 'on)
	    ((and val (eq type 'boolean)) 'off)
	    (t val)))))


(defun lyskom-modify-face (what face)
  (condition-case nil
      (funcall (intern (concat "make-face-" (symbol-name what)))
               face)
    (error nil)))

(defun lyskom-setup-faces ()
  "Initalize the faces in the LysKOM client.
This sets the face scheme according to `kom-default-face-scheme', and
also reads the proper X resources."
  (unless kom-default-face-scheme
    (setq kom-default-face-scheme
	  (condition-case nil
	      (cond ((eq (lyskom-device-class) 'mono) 'monochrome)
		    ((eq (lyskom-background-mode) 'dark)
		     'inverse)
		    (t 'default))
	    (error 'default))))  
  (lyskom-set-face-scheme kom-default-face-scheme)
  (if (eq (console-type) 'x)
      (lyskom-traverse face lyskom-faces
        (let* ((face-name (symbol-name face))
               (fg (lyskom-face-resource face-name "Foreground" 'string))
               (bg (lyskom-face-resource face-name "Background" 'string))
               (bl (lyskom-face-resource face-name "Bold" 'boolean))
               (it (lyskom-face-resource face-name "Italic" 'boolean))
               (ul (lyskom-face-resource face-name "Underline" 'boolean)))
          (if fg (set-face-foreground face fg))
          (if bg (set-face-background face bg))
          (if (eq bl 'on) (lyskom-modify-face 'bold face))
          (if (eq bl 'off) (lyskom-modify-face 'unbold face))
          (if (eq it 'on) (lyskom-modify-face 'italic face))
          (if (eq it 'off) (lyskom-modify-face 'unitalic face))
          (if ul (set-face-underline-p face (eq ul 'on)))))))


;;; ============================================================
;;; Date and time utilities

(defun lyskom-current-client-time ()
  "Return time representing current client time."
  (let ((now (decode-time)))
    (lyskom-create-time (elt now 0)     ;sec
                        (elt now 1)     ;min
                        (elt now 2)     ;hour
                        (elt now 3)     ;mday
                        (elt now 4)     ;mon
                        (elt now 5)     ;year
                        (elt now 6)     ;wday
                        0               ;yday
                        (if (elt now 7) ;isdst
                            1
                          0)
                        )))

(defun lyskom-current-server-time ()
  "Return time representing current server time."
  (blocking-do 'get-time))

(defun lyskom-format-time (format &optional time)
  "Return TIME as a string formatted as FORMAT.

FORMAT may be a string or a symbol.  If it is a symbol, it is
interpreted as follows:

    'date-and-time  Include date and time. [1][2]
    'date           Include just date. [1]
    'time           Include just time. [2]

    [1] If kom-print-seconds-in-time-strings is nil, only hours and
    minutes will be included in the time; if it is non-nil, seconds
    will also be included.
    [2] If kom-print-relative-dates is non-nil and the date is today's
    or yesterday's, the string \"today\" or \"yesterday\" (respectively)
    is used instead of the standard date format.

If FORMAT is a symbol but not one of the symbols listed above, the
format string will be looked up with lyskom-get-string.  The
timeformat-* strings are tailored to be used as formats for this
function.

The arguments to the format string are (in order): year, month number
\(starting with one for January), day-of-month number, hour, minute,
second, full name of the day of the week, abbreviated name of the day
of the week.

TIME defaults to the current client time."
  (let* ((time (or time (lyskom-current-client-time)))
         (fmt (cond
               ((stringp format)
                format)
               ((memq format '(date-and-time date time))
                (lyskom-format (cond ((eq format 'date-and-time)
                                      'format-time-date-and-time)
                                     ((eq format 'date)
                                      'format-time-just-date)
                                     ((eq format 'time)
                                      'format-time-just-time))
                               (lyskom-get-string
                                (or (and kom-print-relative-dates
                                         (lyskom-calculate-day-diff time))
                                    'timeformat-yyyy-mm-dd))
                               (lyskom-get-string
                                (if kom-print-seconds-in-time-strings
                                    'timeformat-hh-mm-ss
                                  'timeformat-hh-mm))))
               ((symbolp format)
                (lyskom-get-string format))
               (t (error "Invalid argument")))))
    (lyskom-format fmt
                   (time->year time)
                   (time->mon  time)
                   (time->mday time)
                   (time->hour time)
                   (time->min  time)
                   (time->sec  time)
                   (elt (lyskom-get-string 'weekdays)
                        (time->wday time))
                   (elt (lyskom-get-string 'weekdays-short)
                        (time->wday time)))))


;;; ============================================================
;;; Keymap utilities

(defun lyskom-lookup-key (keymap event &optional accept-default)
  (if (not (arrayp event))
      (setq event (vector event)))
  (if (null keymap)
      (and accept-default 
           (lookup-key global-map event))
    (or (lookup-key keymap event)
        (lyskom-lookup-key (keymap-parent keymap) event accept-default))))

(defun lyskom-keymap-body (keymap)
  (setq keymap (cdr keymap))
  (cond ((arrayp (car keymap)) (car keymap))
        (t keymap)))

(defun lyskom-keymap-realbinding (binding)
  (while (stringp (car-safe binding))
    (setq binding (cdr binding)))
  binding)

(defun lyskom-overlay-keymap (basemap overlay keymap &optional prefix)
  (let ((keys (make-vector (1+ (length prefix)) nil))
        (index (length prefix))
        (body nil)
        (r 0))

    (while (< r (length prefix))
      (aset keys r (aref prefix r))
      (setq r (1+ r)))

    (cond ((not (keymapp keymap)))
          ((not (keymapp overlay)))
          ((not (keymapp basemap)))

          ((setq body (lyskom-keymap-body overlay))
           (mapcar
            (function
             (lambda (element)
               (cond ((arrayp element)
                      (let ((len (length element)))
                        (setq r 0)
                        (while (< r len)
                          (aset keys index r)
                          (lyskom-overlay-keys keys (aref element r)
                                               basemap overlay keymap)
                          (setq r (1+ r)))))

                     ((consp element)
                      (when (not (eq t (car element)))
                        (aset keys index (car element))
                        (lyskom-overlay-keys keys
                                             (lyskom-keymap-realbinding
                                              (cdr element))
                                             basemap overlay keymap)))

                     (t nil))))
            body)))))


(defun lyskom-overlay-keys (keys binding basemap overlay keymap)
  (let ((base-binding (lyskom-lookup-key basemap keys nil)))

   ;; If the binding is a keymap or prefix and
   ;; the binding in the base is a keymap or prefix 
   ;; then recurse

   (cond ((and (keymapp binding)
               (keymapp base-binding))
          (lyskom-overlay-keymap basemap binding keymap keys))

   ;; If the binding is a keymap or prefix and
   ;; we are bound in the base
   ;; then don't recurse

         ((and (keymapp binding)
               base-binding) nil)

   ;; If we are not bound in the base
   ;; copy the binding

         ((and binding
               (null base-binding)) (define-key keymap keys binding)))))


;;;
;;; Stuff
;;;

(defun lyskom-return-membership-type (mt)
  "Return a text description of membership type mt"
  (let ((tmp
         (mapconcat 
          'identity
          (delete nil
                  (list (if (membership-type->invitation mt) (lyskom-get-string 'invitation-mt-type) nil)
                        (if (membership-type->passive mt) (lyskom-get-string 'passive-mt-type) nil)
                        (if (membership-type->secret mt) (lyskom-get-string 'secret-mt-type) nil)))
          ", ")))
    (if (string= tmp "") 
        tmp
      (concat "[" tmp "]"))))

(defun lyskom-find-unread (conf-no)
  "Return the number of unread texts in CONF-NO.
If this function is unable to calculate the number of unread texts it will
return nil."
  (save-excursion
   (set-buffer lyskom-buffer)
   (let ((rlist (read-list->all-entries lyskom-to-do-list))
         (found nil))
     (while (and (not found) rlist)
       (when (eq conf-no (conf-stat->conf-no
                          (read-info->conf-stat (car rlist))))
         (setq found (length (cdr (read-info->text-list (car rlist))))))
       (setq rlist (cdr rlist)))
     found)))

(defun lyskom-prev-area (num prop &optional goto-point-min)
  (while (> num 0)
    (let ((where (previous-single-property-change (point) prop)))
      (cond (where
             (if (not (get-text-property where prop))
                 (setq where (previous-single-property-change 
                              where prop)))
             (if where
                 (goto-char where)
               (goto-char (point-min))
               (setq num 1)))
            (goto-point-min (goto-char (point-min))
                            (setq num 1))))
    (setq num (1- num))))

(defun lyskom-next-area (num prop &optional goto-point-max)
  "Move the cursor to the next prompt in the LysKOM buffer"
  (interactive "p")
  (while (> num 0)
    (let ((where (next-single-property-change (point) prop)))
      (cond (where
             (if (not (get-text-property where prop))
                 (setq where (next-single-property-change where prop)))
             (if where
                 (goto-char where)
               (goto-char (point-max))
               (setq num 1)))
            (goto-point-max (goto-char (point-max))
                            (setq num 1))))
      (setq num (1- num))))

;;; ============================================================
;;; Database stuff

;; Extracted from edit-text.el
;;(defun lyskom-is-supervisor (conf-stat &optional memo)
;;  "Return non-nil if lyskom-pers-no is a supervisor of CONF-STAT."
;;  (cond ((null conf-stat) nil)
;;        ((memq (conf-stat->conf-no conf-stat) memo) nil)
;;        ((eq lyskom-pers-no (conf-stat->conf-no conf-stat)) t)
;;        ((eq lyskom-pers-no (conf-stat->supervisor conf-stat)) t)
;;        ((eq 0 (conf-stat->supervisor conf-stat)) nil)
;;        ((lyskom-get-membership (conf-stat->conf-no conf-stat) t) t)
;;        ((lyskom-is-supervisor
;;          (blocking-do 'get-conf-stat (conf-stat->supervisor conf-stat))
;;          (cons (conf-stat->conf-no conf-stat) memo)))))

(defun lyskom-is-supervisor (conf-no viewer-no)
  "Return non-nil if the supervisor of CONF-NO is VIEWER-NO."
  (or (eq viewer-no conf-no)
      (lyskom-is-strictly-supervisor conf-no viewer-no)))

(defun lyskom-is-strictly-supervisor (conf-no viewer-no)
  "Return non-nil if VIEWER-NO is strictly a supervisor of CONF-NO

Cannot be called from a callback."
  (let ((collector (make-collector))
        (conf-stat nil))
    (initiate-get-conf-stat 'background 'collector-push conf-no collector)
    (lyskom-wait-queue 'background)
    (setq conf-stat (car (collector->value collector)))

    (cond ((null viewer-no) nil)
          ((eq viewer-no 0) nil)
          ((null conf-stat) nil)
          ((eq viewer-no (conf-stat->supervisor conf-stat)) t)
          ((lyskom-is-member (conf-stat->supervisor conf-stat) viewer-no) t)
          (t nil))))

(defun lyskom-is-member (conf-no pers-no &optional queue)
  "Return the membership in CONF-NO of PERS-NO
Optional argument QUEUE is the queue to send the queries on.

Cannot be called from a callback."
  (or (and (eq pers-no lyskom-pers-no)
           (lyskom-try-get-membership conf-no t))
      (let ((collector (make-collector)))
        (initiate-query-read-texts (or queue 'background)
                                   'collector-push
                                   pers-no
                                   conf-no
                                   collector)
        (lyskom-wait-queue (or queue 'background))
        (car (collector->value collector)))))

(defun lyskom-text-recipients (text-stat &optional want-types)
  "Return the list of recipients for TEXT-STAT.
If WANT-TYPES is non-nil then the result is an assoc list where the 
car of each element is the recipient number and the cdr is the type."
  (let ((result nil))
    (lyskom-traverse misc (text-stat->misc-info-list text-stat)
      (when (memq (misc-info->type misc) lyskom-recpt-types-list)
        (if want-types
            (setq result (cons (cons (misc-info->recipient-no misc)
                                     (misc-info->type misc))
                               result))
          (setq result (cons (misc-info->recipient-no misc)
                             result)))))
    (nreverse result)))

(defun lyskom-text-comments (text-stat)
  "Return the list of comments to TEXT-STAT"
  (let ((result nil))
    (lyskom-traverse misc (text-stat->misc-info-list text-stat)
      (cond ((eq (misc-info->type misc) 'FOOTN-IN)
             (setq result (cons (misc-info->footn-in misc) result)))
            ((eq (misc-info->type misc) 'COMM-IN)
             (setq result (cons (misc-info->comm-in misc) result)))))
    (nreverse result)))


(defun lyskom-find-text-by-date (conf-stat target-date)
  "Search texts in CONF-STAT for a text added on or about TARGET-DATE.
Returns a cons of (LOCAL . GLOBAL)"
  (let* ((lowest (conf-stat->first-local-no conf-stat))
         (highest (+ lowest (conf-stat->no-of-texts conf-stat)))
         (result nil)
         (index (+ lowest (/ (- highest lowest) 2)))
         (last-index (1- index)))
    (while (/= last-index index)
      (let* ((map (blocking-do 'local-to-global 
                               (conf-stat->conf-no conf-stat)
                               index
                               1)))
        (cond ((null map) (setq lowest highest))
              ((null (text-mapping->global-numbers map))
               (setq highest index))
              (t 
               (let* ((text-no (car (text-mapping->global-numbers map)))
                      (text-stat (blocking-do 'get-text-stat text-no))
                      (local-no (text-mapping->global-to-local map text-no))
                      (date (and text-stat
                                 (lyskom-traverse misc
                                     (text-stat->misc-info-list text-stat)
                                   (when (and (memq (misc-info->type misc) lyskom-recpt-types-list)
					      (eq (misc-info->recipient-no misc) text-no))
                                     (lyskom-traverse-break 
                                      (if (misc-info->sent-at misc)
                                          (misc-info->sent-at misc)
                                        (text-stat->creation-time text-stat))))))))
                 (when text-stat
                   (setq index local-no)
                   (if (lyskom-time-greater
			date
                        target-date)
                       (setq highest index)
                     (setq lowest index))
                   (setq result text-stat))))))
      (setq last-index index)
      (setq index (+ lowest (/ (- highest lowest) 2))))
    (cons last-index result)))

(defvar lyskom-year-window-start 80
  "Windowing threshold for YY year specifications.
Years below this are considered in the 21st century. Years above this
in the 20th century")

(defun lyskom-parse-date (arg)
  "Parse ARG as a date."
  (let ((month-regexp (concat "\\("
                              (mapconcat (lambda (el)
                                           (regexp-quote (car el)))
                                         lyskom-month-names
                                         "\\|")
                              "\\)"))
        (dmy-regexp (concat "\\("
                            (mapconcat (lambda (el)
                                         (regexp-quote (lyskom-get-string el)))
                                       '(years year months month days day)
                                       "\\|")
                            "\\)"))
        (test-date (format-time-string "%x" '(20 0)))
        year month day di mi yi)

  ;; Look at test-date to see where dates in ambiguous cases should go

    (cond ((string-match "01.*16.*70" test-date) (setq di 2 mi 1 yi 3))
          ((string-match "01.*70.*16" test-date) (setq di 3 mi 1 yi 2))
          ((string-match "16.*01.*70" test-date) (setq di 1 mi 2 yi 3))
          ((string-match "16.*70.*01" test-date) (setq di 1 mi 3 yi 2))
          ((string-match "70.*01.*16" test-date) (setq di 3 mi 2 yi 1))
          ((string-match "70.*16.*01" test-date) (setq di 2 mi 3 yi 1)))

     (cond ((string-match "\\([0-9][0-9][0-9][0-9]\\)[-./]\\([0-9][0-9]?\\)[-./]\\([0-9][0-9]?\\)" arg)
           ;; YYYY-MM-DD
           (setq year (string-to-int (match-string 1 arg))
                 month (string-to-int (match-string (if (> mi di) 3 2) arg))
                 day (string-to-int (match-string (if (> di mi) 2 3) arg)))
           (when (> month 12) (setq month day day month))
           )
          ((string-match "\\([0-9][0-9]?\\)[-./]\\([0-9][0-9]?\\)[-./]\\([0-9][0-9][0-9][0-9]?\\)" arg)
           ;; YYYY-MM-DD
           (setq year (string-to-int (match-string 3 arg))
                 month (string-to-int (match-string (if (> mi di) 2 1) arg))
                 day (string-to-int (match-string (if (> di mi) 1 2) arg)))
           (when (> month 12) (setq month day day month))
           )
          ((string-match "\\([0-9][0-9]\\)[-./]\\([0-9][0-9]?\\)[-./]\\([0-9][0-9]?\\)" arg)
           (setq year (string-to-int (match-string yi arg))
                 month (string-to-int (match-string mi arg))
                 day (string-to-int (match-string di arg)))
           (when (> month 12) (setq month day day month))
           )
          ((string-match "\\([0-9][0-9]\\)/\\([0-9][0-9]\\)" arg)
           ;; Ambiguous:
           ;; MM/DD       Euro
           ;; DD/MM       US
           (let ((a (string-to-int (match-string 1 arg)))
                 (b (string-to-int (match-string 2 arg))))
             (cond ((> a 12) (setq month b day a))
                   ((> b 12) (setq month a day b))
                   ((> di mi) (setq month b day a))
                   (t (setq month a day b))))
           )
          ((string-match (format "%s \\([0-9][0-9]?\\)" month-regexp) arg)
           ;; Ambiguous:
           ;; Month DD
           )
          ((string-match (format "%s,? \\([0-9][0-9][0-9][0-9]\\)" month-regexp) arg)
           ;; Ambiguous:
           ;; Month YYYY
           )
          ((string-match (format "\\([0-9][0-9]?\\) %s" month-regexp) arg)
           ;; DD Month
           )
          ((string-match (format "\\([0-9][0-9]?\\) %s \\([0-9][0-9][0-9][0-9]\\)" month-regexp) arg)
           ;; DD Month YYYY
           )
          ((string-match (format "%s \\([0-9][0-9]?\\), \\([0-9][0-9][0-9]?[0-9]?\\)" month-regexp) arg)
           ;; Month DD, YYYY
           )
          ((string-match (format "\\([0-9][0-9]?\\) %s, \\([0-9][0-9][0-9]?[0-9]?\\)" month-regexp) arg)
           ;; DD Month, YYYY
           )
          ((string-match (format "-\\([0-9]+\\) %s" dmy-regexp) arg)
           ;; -NN days, months, years
           )
          )

    (if (< year lyskom-year-window-start)
        (setq year (+ 2000 year))
      (setq year (+ 1900 year)))

    (list year month day)
    ))


;;; ================================================================
;;; Check noconversion

(defun lyskom-viewing-noconversion ()
  "Return non-nil if we are reviewing in noconversion mode."
  (eq 'kom-review-noconversion lyskom-current-command))


;;; ================================================================
;;; Read membership types

(defun lyskom-read-membership-type ()
  "Interactively read a membership type"
  (let ((invitation (lyskom-j-or-n-p 'mship-type-invitation-q))
        (passive (lyskom-j-or-n-p 'mship-type-passive-q))
        (secret (lyskom-j-or-n-p 'mship-type-secret-q)))
    (lyskom-create-membership-type invitation
                                   passive
                                   secret
                                   nil
                                   nil
                                   nil
                                   nil
                                   nil)))


;;; ================================================================
;;; String truncation
;;;

(defun lyskom-truncate-to-lines (string threshold show-lines &optional width)
  "If STRING is more than THRESHOLD lines on screen, truncate it to  SHOW-LINES.
Optional argument WIDTH is thw window width to use instead of window-width.

This function takes the setting of truncate-lines into account, so
the resulting string may not have SHOW-LINES newline characters.

Result is eq to STRING when no truncation is required.

The result is approximate when truncate-lines is non-nil since different
Emacsen use a different number of characters for the continuation marks
at the end of broken lines. We assume one character continuation marks."
  (let ((line-length (if truncate-lines lyskom-max-int (- (or width (window-width)) 1)))
        (count 0)
        (end nil)
        (pos 0))
    (while (and (< pos (length string)) (< count threshold))
      (setq count (1+ count))
      (let ((next (string-match "\\(\n\\|\\'\\)" string pos)))
        (if (> (- next pos) line-length)
            (setq pos (+ pos line-length))
          (setq pos (match-end 0))))
        (when (= count show-lines)
          (setq end pos)))

    (if (>= count threshold)
        (substring string 0 end)
      string)))


;;; ================================================================
;;; Color model manipulations
;;;
;;; (Of COURSE you need this in a KOM client!)
;;;

(defun lyskom-get-color-highlight (color distance)
  "Create a highlight color for COLOR that is DISTANCE away.
COLOR is a list of R G and B components from 0 to 65535.
DISTANCE is a non-negative integer no larger than 1.0, that in some
way specifies how far away from the original color the new color
should be."
  (when color
    (let* ((hls (lyskom-rgb-to-hls (mapcar (lambda (x) (/ x 65535.0)) color)))
           (l (elt hls 1)))
      (if (> l 0.6)
          (setq l (- l distance))
        (setq l (+ l distance)))
      (cond ((> l 1.0) (setq l 1.0))
            ((< l 0.0) (setq l 0.0)))
      (aset hls 1 l)

      (apply 'format "#%02x%02x%02x"
             (mapcar (lambda (c) (round (* 255 c)))
                     (lyskom-hls-to-rgb hls))))))


(defun lyskom-rgb-to-hls (rgb)
  "Convert a point in RGB color space to a point in HLS color space.

Input value is a vector [R G B], where R, G and B represent red, green
and blue components, respectively. Each value is a non-negative
floating-point value no larger than 1.0.

Output is a vector [H L S], where H, L and S represend hue, lightness
and saturation, respectively. H is in the range 0..360, L and S are
non-negative floating-point numbers no higher than 1.0. If the input
color is a shade of gray (all components are equal), then H in the
output is nil.

Algorithm adapted from Foley, \"Computer Graphics\"."
  (let* ((r (elt rgb 0))
         (g (elt rgb 1))
         (b (elt rgb 2))
         (rgbmin (min r g b))
         (rgbmax (max r g b))
         (h nil)
         (l (/ (+ rgbmax rgbmin) 2.0))
         (s nil)
         (delta (- rgbmax rgbmin)))
    (if (zerop delta)
        (setq s 0.0)
      (if (<= l 0.5)
          (setq s (/ delta (+ rgbmax rgbmin)))
        (setq s (/ delta (- 2.0 rgbmax rgbmin))))
      (cond ((= r rgbmax)
             (setq h (/ (- g b) delta)))
            ((= g rgbmax)
             (setq h (+ 2.0 (/ (- b r) delta))))
            ((= b rgbmax)
             (setq h (+ 4.0 (/ (- r g) delta)))))
      (setq h (* h 60.0))
      (if (< h 0)
          (setq h (+ 360.0 h))))
    (vector h l s)))

(defun lyskom-hls-to-rgb-value (n1 n2 h)
  "Helper function for lyskom-hls-to-rgb"
  (cond ((> h 360) (setq h (- h 360.0)))
        ((< h 0) (setq h (+ h 360.0))))

  (cond ((< h 60)  (+ n1 (* (- n2 n1) (/ h 60.0))))
        ((< h 180) n2)
        ((< h 240) (+ n1 (* (- n2 n1) (/ (- 240.0 h) 60.0))))
        (t n1)))

(defun lyskom-hls-to-rgb (hls)
  "Convert a point in HLS color space to a point in RGB color space.

Input HLS is a vector [H L S], where H, L and S represend hue,
lightness and saturation, respectively. H is in the range 0..360, L
and S are non-negative floating-point numbers no higher than 1.0. If
the input color is a shade of gray (all components are equal), then S
in the input is ignored and may be anything.

Output value is a vector [R G B], where R, G and B represent red,
green and blue components, respectively. Each value is in the range
1..1.0.

This algorithm is adapted from Foley, \"Computer Graphics\" (and
has the bug in that algorithm fixed)."
  (let* ((h (elt hls 0))
         (l (elt hls 1))
         (s (elt hls 2))
         (m2 (if (<= l 0.5)
                 (* l (+ 1.0 s))
               (+ l (* s (- 1 l)))))
         (m1 (- (* 2 l) m2)))
    (if (zerop s)
        (vector l l l)
      (vector (lyskom-hls-to-rgb-value m1 m2 (+ h 120))
              (lyskom-hls-to-rgb-value m1 m2 h)
              (lyskom-hls-to-rgb-value m1 m2 (- h 120))))))


;;; ================================================================
;;; Automatically test that RGB->X and X->RGB color model conversions
;;; really are the inverse of each other.
;;; 
;;; (defun lyskom-test-color-model ()
;;;   (let ((r 0.0)
;;;         (g 0.0)
;;;         (b 0.0)
;;;         (step 0.05))
;;;     (while (<= r 1.0)
;;;       (setq g 0.0)
;;;       (while (<= g 1.0)
;;;         (setq b 0.0)
;;;         (while (<= b 1.0)
;;;           (let ((tmp (lyskom-hls-to-rgb
;;;                       (lyskom-rgb-to-hls (vector r g b)))))
;;;             (unless (and (< (- r (elt tmp 0)) 0.000000001)
;;;                          (< (- g (elt tmp 1)) 0.000000001)
;;;                          (< (- b (elt tmp 2)) 0.000000001))
;;;               (message "Mismatch %1.2f,%1.2f,%1.2f gave %S/%S" r g b (lyskom-rgb-to-hls (vector r g b)) tmp)))
;;;           (setq b (+ b step)))
;;;         (setq g (+ g step)))
;;;       (setq r (+ r step)))))

;;;(defun lyskom-test-auto-colors ()
;;;  (make-face 'test-1)
;;;  (make-face 'test-2)
;;;  (make-face 'test-default)
;;;  (while t
;;;    (let ((foreground (read-from-minibuffer "Foreground: "))
;;;          (background (read-from-minibuffer "Background: ")))
;;;      (pop-to-buffer (get-buffer-create "*kom*-test"))
;;;      (erase-buffer)
;;;      (set-face-foreground 'test-default foreground)
;;;      (set-face-background 'test-default background)
;;;      (set-face-background 'test-1 (lyskom-get-color-highlight (x-color-values background) 0.05))
;;;      (set-face-background 'test-2 (lyskom-get-color-highlight (x-color-values background) 0.025))
;;;      (let ((lyskom-buffer (current-buffer)))
;;;        (lyskom-format-insert "\
;;;%#3@Lsa nsta fotnot...
;;;8408827 idag 00:40 /1 rad/ Lunkwill/CH ( Auf das Universum! )
;;;Fotnot till text 8408825 av Lunkwill/CH ( Auf das Universum! )
;;;Mottagare: Ntverk, Internet, LysNET, Sunet... <30873>
;;;Mottagare: SUBnet (Stngstadens och LiU:s) studentbostadsnt <12152>
;;;Mottagare: Lunkwill/CH ( Auf das Universum! ) <2092>
;;;rende: Vrmtet
;;;%[%#1$------------------------------------------------------------
;;;%]%[%#2$Och tack s mycket fr frklaringarna! =)
;;;%]%[%#1$(8408827) /Lunkwill/CH ( Auf das Universum! )/------
;;;%]G till nsta mte...
;;;SUN erfarenhetsutbyte - 1 olst
;;;Lsa nsta text...
;;;8408823 idag 00:39 /4 rader/ Erik Persson, Lysato(r)
;;;Kommentar till text 8407161 av Dejan (ngot desperat)
;;;Mottagare: SUN erfarenhetsutbyte <23622>
;;;rende: Skapa partitionstabell
;;;%[%#1$------------------------------------------------------------
;;;%]%[%#2$Om du nu vill spela Fibre Channel med IDE-RAID s gr du ver n efter
;;;vatten. Det finns redan IDE-RAID med FC-interface.  Dock har jag inte
;;;sett ngon som stdjer ngot annat n FC-AL vilket r lite
;;;begrnsande.
;;;%]%[%#1$(8408823) ------------------------------------------
;;;%]G till nsta mte...
;;;
;;;
;;;
;;;"
;;;                              '(face test-1)
;;;                              '(face test-2)
;;;                              '(face test-default))))))
;;;
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: completing-read.el,v 44.37 2002/02/24 20:23:26 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: completing-read.el
;;;; Author: David Byers
;;;;
;;;; This file implements functions for reading a conference name
;;;; or a person name with completion and other help.
;;;;

(setq lyskom-clientversion-long 
      (concat
       lyskom-clientversion-long
       "$Id: completing-read.el,v 44.37 2002/02/24 20:23:26 joel Exp $\n"))

(defvar lyskom-name-hist nil)



;;; ============================================================
;;;
;;; Name lookup caches
;;;

(defvar lyskom-completing-who-info-cache nil
  "Temporary cache of who-info data")

(defvar lyskom-completing-lookup-name-cache nil
  "Temporary cache of server queries")

(defvar lyskom-completing-use-dynamic-info nil)

(defun lyskom-completing-clear-cache ()
  (setq lyskom-completing-who-info-cache nil)
  (setq lyskom-completing-lookup-name-cache nil))

(defun lyskom-completing-who-is-on ()
  "Get information about who is on, first checking the cache. Returns what 
\(blocking-do 'who-is-on\) would, but as a list, not a vector"
  (if lyskom-completing-who-info-cache
      lyskom-completing-who-info-cache
    (setq lyskom-completing-who-info-cache
          (listify-vector
	   (if (lyskom-have-feature dynamic-session-info)
	       (blocking-do 'who-is-on-dynamic t t 0)
	     (blocking-do 'who-is-on))))))

(defun lyskom-completing-cache-completion (string data)
  (let* ((downs (lyskom-unicase string))
         (tmp (assoc downs lyskom-completing-lookup-name-cache)))
    (if (null tmp)
        (setq lyskom-completing-lookup-name-cache
              (cons (cons downs data) lyskom-completing-lookup-name-cache)))
    string))

(defun lyskom-completing-lookup-z-name (string want-conf want-pers)
  "Look up STRING as a name. Same as \(blocking-do 'lookup-z-name ...\)
but first checks a cache."
  (if (and (eq 0 want-conf)
           (eq 0 want-pers))
      nil
    (let* ((downs (lyskom-unicase string))
           (tmp (assoc downs lyskom-completing-lookup-name-cache)))
      (if tmp
          (cdr tmp)
        (progn
          (setq tmp (blocking-do 'lookup-z-name string want-pers want-conf))
          (setq lyskom-completing-lookup-name-cache
                (cons (cons downs tmp)
                      lyskom-completing-lookup-name-cache))
          tmp)))))

;;; ============================================================
;;;
;;; Keymaps
;;;


(defvar lyskom-minibuffer-local-completion-map
  (let ((map (copy-keymap minibuffer-local-completion-map)))
    (define-key map " " nil)
    map)
  "Keymap used for reading LysKOM names.")

(defvar lyskom-minibuffer-local-must-match-map
  (let ((map (copy-keymap minibuffer-local-must-match-map)))
    (lyskom-xemacs-or-gnu 
     (set-keymap-parent map lyskom-minibuffer-local-completion-map)
     (define-key map " " nil))
    map)
  "Keymap used for reading LysKOM names.")

(defsubst lyskom-completing-match-string-regexp (string)
  (concat "^"
          (replace-in-string (regexp-quote (lyskom-unicase (lyskom-completing-strip-name string)))
                             "\\s-+" "\\\\S-*\\\\s-+")
          "\\s-*"))

(defsubst lyskom-completing-match-string (string name)
  "Return non-nil if STRING matches NAME using LysKOM completion rules."
  (string-match (lyskom-completing-match-string-regexp string)
                (lyskom-completing-strip-name (lyskom-unicase name))))


(defun lyskom-read-conf-no (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its number or zero if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) 0)
          ((stringp conf-z-info) 0)
	  ((lyskom-conf-stat-p conf-z-info) (conf-stat->conf-no conf-z-info))
	  ((lyskom-uconf-stat-p conf-z-info) (uconf-stat->conf-no conf-z-info))
          (t (conf-z-info->conf-no conf-z-info)))))

(defun lyskom-read-conf-stat (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its conf-stat or nil if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) nil)
          ((stringp conf-z-info) nil)
	  ((lyskom-conf-stat-p conf-z-info) conf-z-info)
          ((lyskom-uconf-stat-p conf-z-info) 
           (blocking-do 'get-conf-stat (uconf-stat->conf-no conf-z-info)))
          (t (blocking-do 'get-conf-stat 
                          (conf-z-info->conf-no conf-z-info))))))

(defun lyskom-read-uconf-stat (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its conf-stat or nil if nothing was matched.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) nil)
          ((stringp conf-z-info) nil)
	  ((lyskom-uconf-stat-p conf-z-info) conf-z-info)
	  ((lyskom-conf-stat-p conf-z-info)
           (blocking-do 'get-uconf-stat 
                        (conf-stat->conf-no conf-z-info)))
          (t (blocking-do 'get-uconf-stat 
                          (conf-z-info->conf-no conf-z-info))))))

(defun lyskom-read-conf-name (prompt type &optional empty initial mustmatch)
  "Read a conference name from the minibuffer with completion and
return its name.

See lyskom-read-conf for a description of the parameters."
  (let ((conf-z-info (lyskom-read-conf prompt type empty initial mustmatch)))
    (cond ((null conf-z-info) "")
          ((stringp conf-z-info) conf-z-info)
	  ((lyskom-conf-stat-p conf-z-info) (conf-stat->name conf-z-info))
	  ((lyskom-uconf-stat-p conf-z-info) (uconf-stat->name conf-z-info))
	  (t (conf-z-info->name conf-z-info)))))

(defun lyskom-read-conf (prompt type &optional empty initial mustmatch)
  "Completing read a conference or person from the minibuffer. 

PROMPT is the prompt type type.
TYPE   is the type of conferences to return. It is a list of one or
more of the following:
    all     Return any conference,
    conf    Return conferences (not letterboxes),
    pers    Return persons (letterboxes),
    login   Return persons who are also logged-in, and
    none    Return names that do not match anything in the database.
    (restrict c1 c2 ...) Restrict matching to conference numbers c1, 
            c2 etc. The implementation is inefficient for long lists.

Optional arguments
EMPTY     allow nothing to be entered.
INITIAL   initial contents of the minibuffer
MUSTMATCH if non-nil, the user must enter a valid name.

The return value may be one of
A conf-z-info: The conf-z-info associated with the name entered,
nil:         Nothing was entered, or
A string:    A name that matched nothing in the database."

  (lyskom-completing-clear-cache)
  (let* ((completion-ignore-case t)
         (minibuffer-local-completion-map 
          lyskom-minibuffer-local-completion-map)
         (minibuffer-local-must-match-map 
          lyskom-minibuffer-local-must-match-map)
         (read-string nil)
         (result nil)
         (keep-going t))

    (while keep-going
      (lyskom-with-lyskom-minibuffer
       (setq read-string (completing-read (cond ((stringp prompt) prompt)
                                                ((symbolp prompt) (lyskom-get-string prompt))
                                                (t (lyskom-get-string 'conf-prompt)))
                                          'lyskom-read-conf-internal
                                          type
                                          mustmatch
                                          initial
                                          'lyskom-name-hist)))
      (setq result
            (cond ((null read-string) nil)
                  ((string= "" read-string) nil)
                  (t (lyskom-lookup-conf-by-name read-string type))))
      (setq keep-going (and (not empty)
                            (null result))))
    result))


(defun lyskom-read-conf-get-logins ()
  "Used internally by lyskom-read-conf-internal to get a list of
persons who are logged on."
  (mapcar (if (lyskom-have-feature dynamic-session-info)
              (function (lambda (el) (dynamic-session-info->person el)))
            (function (lambda (el) (who-info->pers-no el))))
          (lyskom-completing-who-is-on)))


(defun lyskom-read-conf-expand-specials (string
                                         predicate
                                         login-list
                                         x-list
                                         &optional return-cs)
  "Used internally by lyskom-read-conf-internal to expand person and
conference number specifications to something useful."
  (cond ((string-match (lyskom-get-string 'person-or-conf-no-regexp) string)
         (let* ((no (string-to-int (match-string 1 string)))
                (cs (blocking-do 'get-uconf-stat no)))
           (if (and cs
                    (lyskom-read-conf-internal-verify-type
                     (uconf-stat->conf-no cs)
                     (uconf-stat->conf-type cs)
                     predicate 
                     login-list
                     x-list))
               (if return-cs
                   cs
                 (list string)))))
        ((string-match (lyskom-get-string 'session-no-regexp) string)
         (let* ((no (string-to-int (match-string 1 string)))
                (si (blocking-do 'get-session-info no))
                (cs (and si
                         (blocking-do 'get-uconf-stat
                                      (session-info->pers-no si)))))
           (if (and cs
                    (lyskom-read-conf-internal-verify-type
                     (uconf-stat->conf-no cs)
                     (uconf-stat->conf-type cs)
                     predicate 
                     login-list
                     x-list))
               (if return-cs
                   cs
                 (list string)))))))

(defun lyskom-read-conf-lookup-specials (string predicate login-list x-list)
  "Used internally by lyskom-read-conf-internal to look up conf-stats
from person and conference number specifications."
  (let ((cs (lyskom-read-conf-expand-specials string
                                              predicate
                                              login-list
                                              x-list
                                              t)))
    (lyskom-create-conf-z-info (uconf-stat->name cs)
                               (uconf-stat->conf-type cs)
                               (uconf-stat->conf-no cs))))

(defun lyskom-lookup-conf-by-name (string predicate)
  "Return the conf-z-info associated with STRING that also satisfies
PREDICATE or nil if no name matches. See lyskom-read-conf-internal for
a documentation of PREDICATE."
  (if (string= string "")
      nil
    (lyskom-read-conf-internal string predicate 'lyskom-lookup)))


(defun lyskom-read-conf-internal (string predicate all)
  "Complete the name STRING according to PREDICATE and ALL.

STRING is a string to complete.
PREDICATE is a list of name types to return. See lyskom-read-conf for
details.
ALL is set by try-completion and all-completions. See the Emacs lisp
manual for a description. Special value 'lyskom-lookup makes the
function work as a name-to-conf-stat translator."

  ;;
  ;;  Catch some degenerate cases that can cause...problems. This
  ;;  won't solve all the...problems, but should speed things up a
  ;;  little bit.
  ;;

  (cond 
   ((and (null all)
         (string-match "^\\s-*$" string)) "")
   ((and (eq all 'lyskom-lookup)
         (string-match "^\\s-*$" string)) nil)
   ((and (eq all 'lambda)
         (string-match "^\\s-*$" string)) nil)
   (t

    (let* ((login-list (and (memq 'login predicate)
                            (lyskom-read-conf-get-logins)))
           (x-list (lyskom-completing-lookup-z-name string 
                                                    (if (or (memq 'all predicate)
                                                            (memq 'conf predicate)
                                                            (memq 'none predicate)) 1 0)
                                                    (if (or (memq 'all predicate)
                                                            (memq 'pers predicate)
                                                            (memq 'none predicate)
                                                            (memq 'login predicate)) 1 0)))
           (r-list (when (assq 'restrict predicate)
                     (let ((result (make-collector)))
                       (lyskom-traverse conf-no (cdr (assq 'restrict predicate))
                         (initiate-get-uconf-stat 'main 'collector-push 
                                                  conf-no result))
                       (lyskom-wait-queue 'main)
                       (delq nil
                             (mapcar (lambda (conf-stat)
                                       (when (lyskom-completing-match-string string (conf-stat->name conf-stat))
                                         (lyskom-create-conf-z-info
                                          (conf-stat->name conf-stat)
                                          (conf-stat->conf-type conf-stat)
                                          (conf-stat->conf-no conf-stat))))
                               (collector->value result))))))
           (candidate-list 
            (append r-list
                   (if x-list
                       (conf-z-info-list->conf-z-infos x-list))))
           (result-list nil))

      ;;
      ;;  login-list now contains a list of logins, IF the predicate
      ;;  includes 'login
      ;;
      ;;  candidate-list contains a list of conf-z-infos
      ;;
      ;;  Now set result-list to the conf-z-infos that fulfill the
      ;;  predicate, fetching the conf-stats asynchronously.
      ;;

      (lyskom-traverse el candidate-list
        (if (lyskom-read-conf-internal-verify-type (conf-z-info->conf-no el)
                                                   (conf-z-info->conf-type el)
                                                   predicate
                                                   login-list
                                                   candidate-list)
            (setq result-list (cons el result-list))))
      

      ;;
      ;;  Now the matching conf-z-infos are in result-list
      ;;

      (cond 
       ((eq all 'lyskom-lookup)
        (let ((names (mapcar 'conf-z-info->name 
                             result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))

          (cond ((and kom-complete-numbers-before-names specials)
                 (lyskom-read-conf-lookup-specials string
                                                   predicate
                                                   login-list
                                                   candidate-list))
                ((= (length result-list) 1)
                 (car result-list))

                ((and (> (length result-list) 1)
                      (lyskom-completing-member string names))
                 (elt result-list
                      (- (length result-list)
                         (length (lyskom-completing-member string names)))))

                (specials (lyskom-read-conf-lookup-specials string
                                                            predicate
                                                            login-list
                                                            candidate-list))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 string))))
     
       ;;
       ;;  Check for exact match. We have an exact match in the server
       ;;  when there was a single match OR when there was no match, and
       ;;  no match is valid according to predicate
       ;;

       ((eq all 'lambda)
        (let ((specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond ((= (length result-list) 1) t)
                ((and (> (length result-list) 1)
                      (let ((names (mapcar 'conf-z-info->name
                                           result-list)))
                        (and (lyskom-completing-member string names)
                             t))))
                (result-list nil)
                ((= (length specials) 1) t)
                (specials nil)
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)

                (t (lyskom-read-conf-internal-verify-type nil
                                                          nil
                                                          predicate
                                                          login-list
                                                          candidate-list)))))


       ;;
       ;;  Called from all-completions. Return a list of all possible
       ;;  completions, in this case all names in the result list plus,
       ;;  if the input string is a person or conf number specification,
       ;;  the input string, PROVIDED, the requested conference matches
       ;;  the predicate. If there were no matches, return the input
       ;;  string if no matches satisfies the predicate.
       ;;
          
       (all
        (let ((names (mapcar 'conf-z-info->name result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond (specials (append specials names))
                (names names)
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 (list string))
                (t nil))))

       ;;
       ;;  Called from try-completion, and there were no matches. Try to
       ;;  expand the input string as a person or conf number
       ;;  specification or return something sensible if the predicate
       ;;  is satisfied by no matches.
       ;;

       ((null result-list)
        (let ((specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (cond (specials (car specials))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                ((lyskom-read-conf-internal-verify-type nil
                                                        nil
                                                        predicate
                                                        login-list
                                                        candidate-list)
                 t)
                (t nil))))

       ;;
       ;;  Called from try-completion, and there were matches in the
       ;;  server. Return t if the string is an exact match to any
       ;;  string returned from the server. Otherwise, expand the string
       ;;  as far as possible and return that
       ;;

       (t
        (let ((name-list (mapcar 'conf-z-info->name result-list))
              (specials (lyskom-read-conf-expand-specials string
                                                          predicate
                                                          login-list
                                                          candidate-list)))
          (if specials (setq name-list (nconc specials name-list)))

          (cond ((lyskom-completing-member string name-list) 
                 (or (and (= (length name-list) 1) t) string)) ; Exact match
                ((= (length name-list) 1) (car name-list))
                ((string-match (lyskom-get-string 'person-or-conf-no-regexp)
                               string) nil)
                ((string-match (lyskom-get-string 'session-no-regexp)
                               string) nil)
                (t (or (lyskom-completing-cache-completion
                        (lyskom-complete-string name-list)
                        (if r-list
                            (lyskom-create-conf-z-info-list
                             (apply 'vector candidate-list))
                          x-list))
                       (and (lyskom-read-conf-internal-verify-type 
                             nil
                             nil
                             predicate
                             login-list
                             candidate-list)
                            (list string))))))))))))
        

(defun lyskom-completing-member (string list)
  (let ((string (lyskom-unicase (lyskom-completing-strip-name string)))
        (result nil))
    (while (and list (not result))
      (if (lyskom-string= string (lyskom-unicase 
                           (lyskom-completing-strip-name (car list))))
          (setq result list)
        (setq list (cdr list))))
    result))


(defun lyskom-completing-strip-name (string)
  "Strip parens and crap from a name."
  (while (string-match "([^()]*)" string)
    (setq string (replace-match " " t t string)))
  (while (string-match "\\s-\\s-+" string)
    (setq string (replace-match " " t t string)))
  (while (string-match "([^()]*$" string)
    (setq string (substring string 0 (match-beginning 0))))
  (if (string-match "^\\s-*\\(.*\\S-\\)\\s-*$" string)
      (match-string 1 string)
    string))


(defun lyskom-read-conf-internal-verify-type (conf-no
                                              conf-type
                                              predicate
                                              logins
                                              x-list)
  (or (memq conf-no (cdr (assq 'restrict predicate)))
      (and (memq 'all predicate)
           conf-no)
      (and (memq 'conf predicate)
           conf-type
           (not (conf-type->letterbox conf-type)))
      (and (memq 'pers predicate) 
           conf-type
           (conf-type->letterbox conf-type))
      (and (memq 'login predicate)
           conf-type
           (memq conf-no logins))
      (and (memq 'none predicate) 
           (and (null conf-no)
                (null x-list)))))


; (defun lyskom-complete-show-data-list (state data)
;   (save-excursion
;     (pop-to-buffer (get-buffer-create "*kom*-complete"))
;     (erase-buffer)
;     (set-buffer-multibyte nil)
;    (while data
;       (insert
;        (format "%s\n" (substring (aref (car data) 2)
;                                  (aref (car data) 0)
;                                  (aref (car data) 1))))
;       (setq data (cdr data)))
;     (insert (format "%S %S: %S" (symbol-value current-state)
;                     (elt state 0)
;                     (elt state 1)))
;     (sit-for 5)))
      

(defun lyskom-complete-string (string-list)
  "Find the longest common prefix of all strings in STRING-LIST according to
the LysKOM rules of string matching."
  (let ((main-state 'start-of-string)
        (tmp-state nil)
        (current-state 'main-state)
        (main-accumulator nil)
        (tmp-accumulator nil)
        (current-accumulator 'main-accumulator)
        (done nil)
        (paren-depth 0)
        (have-here nil)
        (last-event-worth-noting nil)
        (data-list (lyskom-complete-string-munge-input string-list))
        (next-char-state (vector nil nil)))

    (while (not done)
      (lyskom-complete-string-next-char next-char-state data-list)
;      (lyskom-complete-show-data-list next-char-state data-list)
      (cond

       ;;
       ;; Case one, a match of two non-special characters.
       ;; Accumulate one character and advance the lists
       ;;

       ((eq (aref next-char-state 0) 'match)
        (if (eq (aref next-char-state 1) ?\ )
            (progn
              (cond ((memq (symbol-value current-state)
			     '(start-of-word start-of-string))
                     nil)
                    ((eq last-event-worth-noting 'mismatch)
                     (lyskom-complete-string-accumulate current-accumulator
                                                        'SPC))
                    (t
                     (lyskom-complete-string-accumulate current-accumulator
                                                        ?\ )))
              (set current-state 'start-of-word)
              (lyskom-complete-string-advance data-list))
          (progn
            (set current-state 'in-a-word)
            (lyskom-complete-string-accumulate current-accumulator
                                               (aref next-char-state 1))
            (lyskom-complete-string-advance data-list)))
        (setq last-event-worth-noting 'match))
       
       ;;
       ;; Case two, a match of two open-paren expressions Increase
       ;; paren depth and accumulate a character. First set
       ;; current-accumulator to the temporary if paren-depth is zero
       ;; to start with.
       ;;

       ((eq (aref next-char-state 0) 'open-paren-match)
        (setq last-event-worth-noting 'match)
        (if (zerop paren-depth)
            (progn
              (setq current-accumulator 'tmp-accumulator)
              (setq current-state 'tmp-state)
              (setq tmp-state main-state)
              (setq tmp-accumulator nil)))
        (setq paren-depth (1+ paren-depth))
        (lyskom-complete-string-accumulate current-accumulator
                                    (aref next-char-state 1))
        (lyskom-complete-string-advance data-list))

       ;;
       ;; Case three, a match of two close-paren expressions
       ;; Accumulate a character. If paren-depth is postitive,
       ;; decrease it. If it ends up zero, add the temporary
       ;; accumulator to the main accumulator and set the current
       ;; accumulator to the main accumulator.
       ;;

       ((eq (aref next-char-state 0) 'close-paren-match)
        (setq last-event-worth-noting 'match)
        (lyskom-complete-string-accumulate current-accumulator
                                    (aref next-char-state 1))
        (if (> paren-depth 0)
            (progn
              (setq paren-depth (1- paren-depth))
              (if (zerop paren-depth)
                  (progn
                    (setq main-accumulator
                          (nconc tmp-accumulator main-accumulator))
                    (setq main-state tmp-state)
                    (setq current-state 'main-state)
                    (setq current-accumulator 'main-accumulator)))))
        (lyskom-complete-string-advance data-list))

       ;;
       ;; Case two, a mismatch of any kind in a paren expression
       ;;

       ((and (> paren-depth 0)
             (memq (aref next-char-state 0)
		     '(mismatch space-mismatch open-paren-mismatch)))
        (setq last-event-worth-noting 'mismatch)
        (setq tmp-accumulator nil)
        (setq tmp-state nil)
        (setq current-state 'main-state)
        (setq current-accumulator 'main-accumulator)
        (lyskom-complete-string-close-parens data-list paren-depth)
        (setq paren-depth 0))

       ;;
       ;; Case two and a half or so, a space mismatch. This is ignored
       ;; if we're still at the start of the string
       ;;
       
       ((and (eq (aref next-char-state 0) 'space-mismatch)
             (memq (symbol-value current-state)
		     '(start-of-string start-of-word)))
        (setq last-event-worth-noting nil)
        (lyskom-complete-string-skip-whitespace data-list))

       ;;
       ;; Case three, a mismatch of regular characters outside a paren
       ;; Advance to the end of the current word
       ;;

       ((and (memq (aref next-char-state 0) '(mismatch space-mismatch))
             (zerop paren-depth))
        (setq last-event-worth-noting 'mismatch)
        (if (memq (symbol-value current-state)
		    '(start-of-word start-of-string))
            (setq done t)
          (progn
            (if (not have-here)
                (progn
                  (lyskom-complete-string-accumulate current-accumulator 
                                                     'HERE)
                  (setq have-here t)))
            (lyskom-complete-string-advance-to-end-of-word data-list)
            (set current-state 'in-a-word))))

       ;;
       ;; Case four, a mistmatch where one character is an open-paren
       ;;

       ((eq (aref next-char-state 0) 'open-paren-mismatch)
        (setq last-event-worth-noting 'mismatch)
        (lyskom-complete-string-skip-parens data-list))


       ;;
       ;; Case five, eof
       ;;

       ((eq (aref next-char-state 0) 'eof)
        (setq done t))

       ;;
       ;; Case six, can't happen
       ;;

       (t (error "This can't happen: %S" next-char-state))))

    ;;
    ;; Build the result by reversing the result list and making a
    ;; string out of it.
    ;;

    (if (eq (car main-accumulator) 'SPC)
        (setq main-accumulator (cdr main-accumulator)))

    (setq main-accumulator (nreverse main-accumulator))

    (if (memq 'HERE main-accumulator)
        (let ((backup (length (memq 'HERE main-accumulator))))
          (if lyskom-experimental-features
              (setq unread-command-events
                    (append (cons ? (make-list (1- backup) 2))
                            unread-command-events)))
          (setq main-accumulator (delq 'HERE main-accumulator))))
    
    (concat (mapcar (lambda (el) (if (eq el 'SPC) ?\  el))
		    main-accumulator))))


(defun lyskom-complete-string-accumulate (accumulator char)
  (set accumulator (cons char (symbol-value accumulator))))

(defun lyskom-complete-string-munge-input (string-list)
  (mapcar (function
           (lambda (x)
             (vector 0 (length x) x)))
          string-list))

;;;
;;; Advance one regular character or multiple whitespaces
;;;

(defun lyskom-complete-string-advance (data-list)
  (lyskom-traverse 
   el data-list
   (string-match "\\([ \t]+\\|[^ \t]\\|$\\)"
                 (aref el 2)
                 (aref el 0))
   (aset el 0 (match-end 0))))

(defun lyskom-complete-string-skip-whitespace (data-list)
  (lyskom-traverse
   el data-list
   (string-match "[ \t]*" (aref el 2) (aref el 0))
   (aset el 0 (match-end 0))))

;;;
;;; Advance to the end of the current word
;;;

(defun lyskom-complete-string-advance-to-end-of-word (data-list)
  (lyskom-traverse
   el data-list
   (aset el 0 (string-match "\\([ \t]\\|$\\)" 
                            (aref el 2)
                            (aref el 0)))))

;;;
;;; Unwind a number of parens
;;;

(defun lyskom-complete-string-skip-parens (data-list)
  (lyskom-traverse
   el data-list
   (if (eq ?\( (aref (aref el 2) (aref el 0)))
       (progn
         (aset el 0 (1+ (aref el 0)))
         (lyskom-complete-string-close-parens-2 el 1)))))

(defun lyskom-complete-string-close-parens (data-list depth)
  (lyskom-traverse
   el data-list
   (lyskom-complete-string-close-parens-2 el depth)))

(defun lyskom-complete-string-close-parens-2 (el depth)
  (let ((string (aref el 2))
        (pos (aref el 0)))
    (while (> depth 0)
      (cond ((>= pos (length string)) 
             (setq depth 0))
            ((eq (aref string pos) ?\))
             (setq depth (1- depth)))
            ((eq (aref string pos) ?\))
             (setq depth (1+ depth))))
      (setq pos (1+ pos)))
    (aset el 0 pos)))


;;;
;;; Check what's happenin' next
;;;

(defun lyskom-complete-string-next-char (state data-list)
  (let ((eofp nil)
        (open-paren-p nil)
        (close-paren-p nil)
        (matchp t)
        (spacep nil)
        (char nil)
        (xchar nil))

    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (mapcar
      (function 
       (lambda (x)
         (cond ((>= (aref x 0) (aref x 1))
                (setq eofp t)
                (setq matchp nil))
               ((eq (aref (aref x 2) (aref x 0)) ?\()
                (setq open-paren-p t))
               ((eq (aref (aref x 2) (aref x 0)) ?\))
                (setq close-paren-p t))
               ((eq (aref (aref x 2) (aref x 0)) ?\ )
                (setq spacep t)))

         (setq matchp (and matchp
                           (if (null char)
                               (progn
                                 (setq xchar (aref (aref x 2)
                                                   (aref x 0)))
                                 (setq char (lyskom-unicase-char xchar)))
                             (eq char (lyskom-unicase-char
                                       (aref (aref x 2)
                                             (aref x 0)))))))))
      data-list))

    (aset state 1 xchar)
    (cond (eofp (aset state 0 'eof))
          ((and matchp open-paren-p)
           (aset state 0 'open-paren-match))
          ((and matchp close-paren-p)
           (aset state 0 'close-paren-match))
          (matchp
           (aset state 0 'match))
          (spacep
           (aset state 0 'space-mismatch))
          (open-paren-p
           (aset state 0 'open-paren-mismatch))
          (t
           (aset state 0 'mismatch))))
  state)








;;; ============================================================
;;;
;;; Session reading
;;;
;;;



(defun lyskom-read-session-no (prompt &optional empty initial only-one)
  (let ((possible-matches
         (lyskom-session-from-conf
          (lyskom-read-conf-no prompt
                               (if kom-permissive-completion
                                   '(pers)
                                 '(login))
                               empty
                               initial
                               t))))
    (if (and (> (length possible-matches) 1)
             only-one)
        (lyskom-read-session-resolve-ambiguity possible-matches)
      possible-matches)))


(defun lyskom-session-from-conf (conf-no)
  (let ((who-list (lyskom-completing-who-is-on))
        (sessions nil))
    (if (lyskom-have-feature dynamic-session-info)
	(while who-list
	  (if (eq (dynamic-session-info->person (car who-list)) conf-no)
	      (setq sessions (cons (dynamic-session-info->session
				    (car who-list))
				   sessions)))
	  (setq who-list (cdr who-list)))
      (while who-list
	(if (eq (who-info->pers-no (car who-list))
		conf-no)
	    (setq sessions (cons (who-info->connection (car who-list))
				 sessions)))
	(setq who-list (cdr who-list))))
    (cond ((and (null sessions) kom-permissive-completion) (list (- conf-no)))
          (t sessions))))


(defun lyskom-read-session-resolve-ambiguity (sessions)
  (lyskom-insert "\n")
  (let* ((s-width (1+ (apply 'max (mapcar (function
					   (lambda (x)
					     (string-width (int-to-string x))))
					  sessions))))
	 (format-string-s (lyskom-info-line-format-string s-width "s" "s"))
	 (format-string-p (lyskom-info-line-format-string s-width "P" "M")))
    (lyskom-format-insert format-string-s
			  ""
			  (lyskom-get-string 'lyskom-name)
			  (lyskom-get-string 'is-in-conf))
    (lyskom-format-insert format-string-s
			  ""
			  (lyskom-get-string 'from-machine)
			  (lyskom-get-string 'is-doing))
    (lyskom-insert
     (concat (make-string (- (lyskom-window-width) 2) ?-)
	     "\n"))
    (let ((result nil)
	  (who-info
	   (mapcar (function
		    (lambda (el)
		      (let* ((info (blocking-do 'get-session-info el))
			     (confconfstat
			      (blocking-do 'get-uconf-stat
					   (session-info->working-conf info))))
			(lyskom-format-insert
			 format-string-p
			 (format "%d%s"
				 (session-info->connection info)
				 (if (eq (session-info->connection info)
					 lyskom-session-no)
				     "*" " "))
			 (session-info->pers-no info)
			 (or confconfstat
                             (lyskom-get-string 'not-present-anywhere)))
			(lyskom-format-insert
			 format-string-p
			 ""
			 (lyskom-return-username info)
			 (concat "("
				 (session-info->doing info)
				 ")"))
			(cons (number-to-string
			       (session-info->connection info))
			      info))))
		   (sort sessions '<))))
      (lyskom-insert (concat (make-string (- (lyskom-window-width) 2) ?-)
			     "\n"))
      (lyskom-insert (lyskom-format 'total-users-sans-date (length who-info)))
      (lyskom-scroll)
      (while (string= ""
                      (lyskom-with-lyskom-minibuffer
                       (setq result (lyskom-completing-read
				    (lyskom-get-string 'resolve-session)
				    (lyskom-maybe-frob-completion-table 
				     who-info)
				    nil
				    t
				    (car (car who-info))
				    nil)))))
      (list (session-info->connection (cdr (assoc result who-info)))))))



;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: keyboard-menu.el,v 44.2 2002/06/29 20:29:20 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: keyboard-menu.el
;;;;
;;;; Implements completing-read almost-compatible lyskom-read-from-menu
;;;; used to implement keyboard navigation of LysKOM menus ('cos tmm
;;;; was *so* ugly).
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: keyboard-menu.el,v 44.2 2002/06/29 20:29:20 byers Exp $\n"))

(defvar lyskom-keyboard-menu-menu)
(defvar lyskom-keyboard-menu-buffer)
(defvar lyskom-keyboard-menu-prompt)
(defvar lyskom-keyboard-menu-selection)
(defvar lyskom-keyboard-menu-overlay)

(defvar lyskom-keyboard-menu-keymap nil)

(defun lyskom-keyboard-menu-read-char (prompt)
  "Read a single keyboard event from the keyboard.
Like read-event in Gnu Emacs or next-command-event in XEmacs."
  (message prompt)
  (sit-for 0)
  (lyskom-xemacs-or-gnu
   (let ((ev (next-command-event nil prompt)))
	    (when (eq 'key-press (event-type ev))
	      (cond ((eq (event-key ev) 'return) 'return)
		    ((event-to-character ev))
		    ((event-key ev))
		    (t nil))))
   (read-event)))

(defun lyskom-keyboard-menu-keys-for-string (string)
  "Return a list of suitable mnemonics for menu item STRING."
  (let ((a-uc nil)
        (a-lc nil)
        (b-uc nil)
        (b-lc nil)
        (c-uc nil)
        (c-lc nil))
    (lyskom-traverse word (string-split " " string)
      (unless (eq (elt word 0) ?\()
        (setq a-lc (cons (downcase (substring word 0 1)) a-lc)
              a-uc (cons (upcase (substring word 0 1)) a-uc))
        (when (> (length word) 1)
          (setq b-lc (cons (downcase (substring word 1 2)) b-lc)
                b-uc (cons (upcase (substring word 1 2)) b-uc)))
        (when (> (length word) 2)
          c-lc (cons (downcase (substring word 2 3)) c-lc)
          c-uc (cons (upcase (substring word 2 3)) c-uc))
        ))
    (mapcar (lambda (s)
              (lyskom-xemacs-or-gnu
               s
               (encode-coding-string s default-keyboard-coding-system)))
            (nconc (nreverse a-lc)
                   (nreverse b-lc)
                   (nreverse c-lc)
                   (nreverse a-uc)
                   (nreverse b-uc)
                   (nreverse c-uc)
                   ))))


(defun lyskom-keyboard-menu-frob-table (table)
  "Convert TABLE to a form suitable for keyboard menus.
TABLE is an alist whose elements' cars are strings. The result will
be an alist whose elements' cars are mnemonics for the string in the
same element's cdr."
  (let ((used-keys nil)
        (default-keys "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
        (default-keys-index 0))
    (nconc
     (mapcar 
      (lambda (element)
        (let* ((string (car element))
               (keys (lyskom-keyboard-menu-keys-for-string string))
               (mnemonic (lyskom-traverse key keys
                           (unless (member key used-keys)
                             (lyskom-traverse-break key)))))

          (while (and (not mnemonic)
                      (< default-keys-index (length default-keys)))
            (let ((key (substring default-keys 
                                  default-keys-index
                                  (1+ default-keys-index))))
              (unless (member key used-keys)
                (setq mnemonic key))))

          (setq used-keys (cons mnemonic used-keys))
          (list mnemonic string element)))
      table)
     (list (list "C-g" (lyskom-get-string 'keyboard-cancel) nil)))))



(defun lyskom-keyboard-menu-highlight-selected ()
  "Highlight the selected menu item"
  (set-buffer lyskom-keyboard-menu-buffer)
  (let ((pos (text-property-any (point-min) 
                                (point-max)
                                'lyskom-keyboard-menu-item
                                lyskom-keyboard-menu-selection)))
    (cond ((or (null pos)
               (null lyskom-keyboard-menu-selection))
           (lyskom-xemacs-or-gnu
            (set-extent-face lyskom-keyboard-menu-overlay nil)
            (overlay-put lyskom-keyboard-menu-overlay 'face nil))
           (goto-char (point-min)))
          (t (let ((start pos)
                   (end (or (next-single-property-change 
                             pos
                             'lyskom-keyboard-menu-item)
                            (point-max))))
               (lyskom-xemacs-or-gnu
                (set-extent-endpoints lyskom-keyboard-menu-overlay
                                      start end)
                (move-overlay lyskom-keyboard-menu-overlay
                              start end)))
             (goto-char pos)
             (lyskom-xemacs-or-gnu
              (set-extent-face lyskom-keyboard-menu-overlay 'kom-mark-face)
              (overlay-put lyskom-keyboard-menu-overlay
                           'face 'kom-mark-face))))
    (save-excursion
      (unless (pos-visible-in-window-p pos)
        (recenter)))))


(defun lyskom-keyboard-menu-format-item (item &optional pad-len)
  "Format a single menu item as a string"
  (let ((string (format "%s (%s)" (elt item 1) (elt item 0))))
    (when (and pad-len (> pad-len (length string)))
      (setq string (concat string (make-string (- pad-len (length string))
                                               ?\ ))))
    (add-text-properties 0 
                         (length string)
                         (list 'lyskom-keyboard-menu-item item)
                         string)
    string))

(defun lyskom-keyboard-menu-insert (prompt menu)
  "Insert the text-based representation of the menu.
PROMPT is the menu title and MENU is the menu data."
  (let* ((line-length (apply 'max
                             (mapcar (lambda (x)
                                       (+ (length (elt x 0))
                                          (length (elt x 1))
                                          3))
                                     menu)))
         (columns (/ (+ (window-width) 1)
                     (+ line-length 2)))
         (dashes (make-string (+ (* line-length columns)
                                 (* 2 (1- columns))) ?-))
         (quit-item nil))

    (insert (format "%s\n%s\n" prompt dashes))
    (lyskom-traverse el menu
      (if (null (elt el 2))
          (setq quit-item el)
        (let ((string (lyskom-keyboard-menu-format-item el line-length)))
          (when (> (+ (current-column) (length string) 2) (window-width))
            (insert "\n"))
          (unless (bolp) (insert "  "))
          (insert string))))
    (unless (bolp)
      (insert "\n"))
    (insert dashes)
    (insert "\n")
    (when quit-item
      (insert (lyskom-keyboard-menu-format-item quit-item)))))




;;; ================================================================
;;; Interactive commands
;;; 


(defun lyskom-read-from-menu (prompt table)
  "Let the user select one of the values in TABLE.
TABLE is an alist whose elements' cars are strings.
Returns the selected string."
  (let* ((menu (lyskom-keyboard-menu-frob-table table))
         (buffer (get-buffer-create "*Keyboard menu*"))
         (menu-window-height 0))
    (save-excursion

      ;; Format the buffer

      (set-buffer buffer)
      (erase-buffer)
      (lyskom-keyboard-menu-insert prompt menu)

      (goto-char (point-min))
      (setq menu-window-height (+ 2 (count-lines (point-min) (point-max))))

      ;; Display the window and do the thing

      (save-window-excursion
        (if (< (- (window-height (selected-window))
                  menu-window-height) 5)
            (select-window
             (display-buffer buffer t))
          (split-window (selected-window) menu-window-height)
          (switch-to-buffer buffer))
        (let* ((lyskom-keyboard-menu-buffer buffer)
               (lyskom-keyboard-menu-menu menu)
               (lyskom-keyboard-menu-selection nil)
               (lyskom-keyboard-menu-overlay 
                (lyskom-xemacs-or-gnu
                 (make-extent 1 1 lyskom-keyboard-menu-buffer)
                 (make-overlay 0 0 lyskom-keyboard-menu-buffer)))
               (result nil))

          (lyskom-xemacs-or-gnu
           (set-extent-face lyskom-keyboard-menu-overlay nil)
           (overlay-put lyskom-keyboard-menu-overlay 'face nil))

          (condition-case nil
              (while (null result)
                (lyskom-keyboard-menu-highlight-selected)
                (let ((c (lyskom-keyboard-menu-read-char 
                          (lyskom-format "%#1s %#2s: %#3s"
                                         prompt
                                         (lyskom-get-string 'keyboard-menu-help)
                                         (or (elt lyskom-keyboard-menu-selection 1)
                                             "")))))
                  (cond ((eq (lookup-key global-map (vector c)) 'keyboard-quit)
                         (keyboard-quit))
                        ((eq c ?\C-a) (lyskom-keyboard-menu-beginning-of-line))
                        ((eq c ?\C-e) (lyskom-keyboard-menu-end-of-line))
                        ((or (eq c 'up)
                             (eq c ?\C-p))
                         (lyskom-keyboard-menu-up))
                        ((or (eq c ?\C-b)
                             (eq c 'left))
                         (lyskom-keyboard-menu-backward))
                        ((or (eq c 'down)
                             (eq c ?\C-n))
                         (lyskom-keyboard-menu-down))
                        ((or (eq c ?\C-f)
                             (eq c 'right))
                         (lyskom-keyboard-menu-forward))
                        ((or (eq c 'return)
                             (eq c ?\r)
                             (eq c ?\n))
                         (setq result lyskom-keyboard-menu-selection))
                        ((and (characterp c)
                              (assoc (make-string 1 c) 
                                     lyskom-keyboard-menu-menu))
                         (if kom-keyboard-menu-immediate-selection
                             (setq result (assoc (make-string 1 c) 
                                                 lyskom-keyboard-menu-menu))
                           (setq lyskom-keyboard-menu-selection
                                 (assoc (make-string 1 c)
                                        lyskom-keyboard-menu-menu))))))
                (when lyskom-keyboard-menu-selection
                  (setq lyskom-keyboard-menu-menu
                        (lyskom-rotate-list lyskom-keyboard-menu-menu
                                            lyskom-keyboard-menu-selection))))
            (quit (setq result nil)))
          (elt result 2)
          )))))

(defun lyskom-keyboard-menu-up ()
  "Move up one menu item"
  (interactive)
  (let ((done nil))
    (while (not done)

      ;; Move up one line
      (condition-case nil
          (previous-line 1)
        (beginning-of-buffer (setq done t)))

      ;; Scan the items on this line until we find the one
      ;; just before point or just after point or around
      ;; point.

      (let ((selection nil)
            (start (save-excursion (beginning-of-line) (point)))
            (end (save-excursion (end-of-line) (point)))
            (pos (point)))
        (while (and (>= pos start) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1- pos)))

        (setq pos (point))
        (while (and (<= pos end) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1+ pos)))
        (when selection (setq done t
                              lyskom-keyboard-menu-selection selection))))))

(defun lyskom-keyboard-menu-down ()
  "Move down one menu item."
  (interactive)
  (let ((done nil))
    (while (not done)

      ;; Move up one line
      (condition-case nil
          (next-line 1)
        (end-of-buffer (setq done t)))

      ;; Scan the items on this line until we find the one
      ;; just before point or just after point or around
      ;; point.

      (let ((selection nil)
            (start (save-excursion (beginning-of-line) (point)))
            (end (save-excursion (end-of-line) (point)))
            (pos (point)))
        (while (and (>= pos start) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1- pos)))

        (setq pos (point))
        (while (and (<= pos end) (null selection))
          (setq selection 
                (get-text-property pos 'lyskom-keyboard-menu-item)
                pos (1+ pos)))
        (when selection (setq done t
                              lyskom-keyboard-menu-selection selection))))))




(defun lyskom-keyboard-menu-forward ()
  "Move right one menu item."
  (interactive)
  (let ((pos (point))
        (item nil))
    (while (and pos (or (null item) (eq item lyskom-keyboard-menu-selection)))
      (setq pos (next-single-property-change pos 'lyskom-keyboard-menu-item))
      (when pos
        (setq item (get-text-property pos 'lyskom-keyboard-menu-item))))
    (when item (setq lyskom-keyboard-menu-selection item))))


(defun lyskom-keyboard-menu-backward ()
  "Move left one menu item."
  (interactive)
  (let ((pos (point))
        (item nil))
    (while (and pos (or (null item) (eq item lyskom-keyboard-menu-selection)))
      (setq pos (previous-single-property-change pos 'lyskom-keyboard-menu-item))
      (when pos
        (setq item (get-text-property pos 'lyskom-keyboard-menu-item))))
    (when item (setq lyskom-keyboard-menu-selection item))))

(defun lyskom-keyboard-menu-beginning-of-line ()
  "Move to the first menu item of this line."
  (interactive)
  (beginning-of-line)
  (setq lyskom-keyboard-menu-selection
        (or (get-text-property (point) 'lyskom-keyboard-menu-item)
            (get-text-property (or (next-single-property-change 
                                    (point) 'lyskom-keyboard-menu-item
                                    nil (save-excursion (end-of-line) (point)))
                                   (point))
                               'lyskom-keyboard-menu-item))))

(defun lyskom-keyboard-menu-end-of-line ()
  "Move to the last menu item of this line."
  (interactive)
  (end-of-line)
  (setq lyskom-keyboard-menu-selection
        (if (get-text-property (point) 'lyskom-keyboard-menu-item)
            (get-text-property (point) 'lyskom-keyboard-menu-item)
          (let ((pos (previous-single-property-change 
                      (point) 'lyskom-keyboard-menu-item
                      nil (1- (save-excursion (beginning-of-line) (point))))))
            (when (and pos (not (zerop pos)))
              (or (get-text-property pos 'lyskom-keyboard-menu-item)
                  (get-text-property (1- pos)  'lyskom-keyboard-menu-item)))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: command.el,v 44.45 2002/06/24 17:12:19 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: command.el
;;;;
;;;; This file contains stuff regarding commands.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: command.el,v 44.45 2002/06/24 17:12:19 byers Exp $\n"))

;;; (eval-when-compile
;;;   (require 'lyskom-vars "vars")
;;;   (require 'lyskom-services "services")
;;;   (require 'lyskom-language "language")
;;;   (require 'lyskom-clienttypes "clienttypes"))


;;; ======================================================================
;;; LysKOM user commands
;;; The new, blocking commands have a very similar structure
;;;
;;;  (defun kom-cmd (args)
;;;    "Documentation"
;;;    (interactive "...")
;;;    (lyskom-start-of-command 'kom-cmd)
;;;    (unwind-protect
;;;        (progn ...)
;;;      (lyskom-end-of-command)))
;;;
;;; This can now be written as
;;;
;;; (def-kom-command kom-cmd (args)
;;;   "Documentation"
;;;   (interactive "...")
;;;   ...)

(eval-and-compile
  (defun lyskom-fix-interactive-decl (decl command)
    (cond ((stringp (car (cdr decl))) decl)
          (t `(interactive (let ((lyskom-current-command ',command))
                             ,@(cdr decl)))))))




(defmacro def-kom-command (cmd args doc interactive-decl &rest forms)
  (if (not (stringp doc))
      (progn (message "!! No docstring for command %S" cmd)
             (setq forms (cons interactive-decl forms))
             (setq interactive-decl doc)
             (setq doc "")))
  (if (not (eq (car interactive-decl) 'interactive))
      (progn (message "!! Missing interactive declaration for %S; assuming \(interactive\)" cmd)
             (setq forms (cons interactive-decl forms))
             (setq interactive-decl '(interactive))))
  (let ((bufsym (intern (format "%S-start-buffer" cmd))))
    `(defun ,cmd ,args
       ,doc
       ,(lyskom-fix-interactive-decl interactive-decl cmd)
       (lyskom-start-of-command ',cmd)
       (let ((,bufsym (current-buffer)))
         (unwind-protect
             (condition-case nil
                 (progn ,@forms)
               (quit (ding)
                     (lyskom-insert-before-prompt
                      (lyskom-get-string 'interrupted))))
           (lyskom-save-excursion
            (when (buffer-live-p ,bufsym)
              (set-buffer ,bufsym))
             (lyskom-end-of-command)))))))

;;
;; def-kom-emacs-command works like def-kom-command, but the template 
;; is different. Commands defined this way will run as regular Emacs
;; commands when invoked outside of a LysKOM buffer. 
;;
;; The variable <cmd>-running-as-kom-command is non-nil when running
;; as a LysKOM command and nil otherwise.
;;
;; Note: this function catches *all* errors in lyskom-start-of-command
;;       which may not be what you want, so be careful.
;;
;; 
;; (defun kom-cmd (args)
;;   "Documentation"
;;   (interactive "...")
;;   (let ((kom-cmd-running-as-kom-command nil))
;;     (condition-case nil
;;         (progn (lyskom-start-of-command 'kom-cmd)
;;                (setq kom-cmd-running-as-kom-command t))
;;       (error nil))
;;     (unwind-protect
;;         (condition-case nil
;;             (progn ...)
;;           (quit (ding)
;;                 (lyskom-insert-before-prompt
;;                  (lyskom-get-string 'interrupted))))
;;       (and kom-cmd-running-as-kom-command (lyskom-end-of-command)))))
;; 

(defmacro def-kom-emacs-command (cmd args doc interactive-decl &rest forms)
  (if (not (stringp doc))
      (progn (message "!! No docstring for command %S" cmd)
             (setq forms (cons interactive-decl forms))
             (setq interactive-decl doc)
             (setq doc "")))
  (if (not (eq (car interactive-decl) 'interactive))
      (progn (message "!! Missing interactive declaration for %S; assuming \(interactive\)" cmd)
             (setq forms (cons interactive-decl forms))
             (setq interactive-decl '(interactive))))

  (let ((rsym (intern (format "%S-running-as-kom-command" cmd)))
        (bufsym (intern (format "%S-start-buffer" cmd))))
    `(defun ,cmd ,args
       ,doc
       ,(lyskom-fix-interactive-decl interactive-decl cmd)
       (let ((,rsym nil))
         (condition-case nil
             (progn (lyskom-start-of-command ',cmd)
                    (setq ,rsym t))
           (error nil))
         (let ((,bufsym (current-buffer)))
           (unwind-protect
               (condition-case nil
                   (progn ,@forms)
                 (quit (ding)
                       (lyskom-insert-before-prompt
                        (lyskom-get-string 'interrupted))))
             (and ,rsym
                  (lyskom-save-excursion
                   (when (buffer-live-p ,bufsym)
                     (set-buffer ,bufsym))
                   (lyskom-end-of-command)))))))))



(put 'def-kom-command 'edebug-form-spec
     '(&define name lambda-list
	       [&optional stringp]	; Match the doc string, if present.
	       ("interactive" interactive)
	       def-body))

(put 'def-kom-emacs-command 'edebug-form-spec
     '(&define name lambda-list
	       [&optional stringp]	; Match the doc string, if present.
	       ("interactive" interactive)
	       def-body))



;;;; ================================================================
;;;;                User-level commands and functions.


(defsubst lyskom-command-name (command)
  "Get the command name for the command COMMAND"
  (condition-case nil
      (lyskom-get-string command 'lyskom-command)
    (error nil)))

(defun lyskom-ok-command (alternative administrator)
  "Returns non-nil if it is ok to do such a command right now."
  (when (vectorp alternative) 
    (setq alternative (cons (elt alternative 0) (elt alternative 1))))
  (if administrator
      (not (memq (cdr alternative) lyskom-admin-removed-commands))
    (not (memq (cdr alternative) lyskom-noadmin-removed-commands))))

(defun kom-extended-command ()
  "Read a LysKOM function name and call the function."
  (interactive)
  (let ((fnc (lyskom-read-extended-command current-prefix-arg)))
    (cond
     (fnc (call-interactively fnc))
     (t (kom-next-command)))) )

(defvar lyskom-command-minibuffer-local-completion-map
  (let ((map (copy-keymap minibuffer-local-completion-map)))
    (define-key map " " 'lyskom-command-complete-word)
    map)
  "Keymap used for reading LysKOM names.")

(defvar lyskom-command-minibuffer-local-must-match-map
  (let ((map (copy-keymap minibuffer-local-must-match-map)))
    (lyskom-xemacs-or-gnu 
     (progn (set-keymap-parent map lyskom-minibuffer-local-completion-map)
            (define-key map " " 'lyskom-command-complete-word))
     (define-key map " " 'lyskom-command-complete-word))
    map)
  "Keymap used for reading LysKOM names.")

(defun lyskom-read-extended-command (&optional prefix-arg prompt)
  "Reads and returns a command"
  (let* ((completion-ignore-case t)
	 (minibuffer-setup-hook minibuffer-setup-hook)
         (base-prompt (cond ((null prompt) (lyskom-get-string 'extended-command))
                            ((symbolp prompt) (lyskom-get-string prompt))
                            (t prompt)))
	 (alternatives (mapcar 
			(lambda (pair)
			  (cons 
			   (cdr pair)
			   (car pair)))
			(lyskom-get-strings lyskom-commands
					    'lyskom-command)))
	 (name nil)
         (prefix-text
          (cond ((eq prefix-arg '-) "- ")
                ((equal prefix-arg '(4)) "C-u ")
                ((integerp prefix-arg) 
                 (format "%d " prefix-arg))
                ((and (consp prefix-arg) 
                      (integerp (car prefix-arg)))
                 (format "%d " (car prefix-arg)))
                (t nil)))
         (prompt (if prefix-text
                     (concat prefix-text base-prompt)
                   base-prompt)))

    (let ((minibuffer-local-completion-map 
           lyskom-command-minibuffer-local-completion-map)
          (minibuffer-local-must-match-map 
           lyskom-command-minibuffer-local-must-match-map))
      (lyskom-with-lyskom-minibuffer
       (setq name (lyskom-completing-read prompt
                                          'lyskom-complete-command
                                        ;                                        (lyskom-maybe-frob-completion-table
                                        ;                                         alternatives)
                                          ;; lyskom-is-administrator is buffer-local and
                                          ;; must be evalled before the call to 
                                          ;; completing-read
                                          ;; Yes, this is not beautiful
                                          (list 'lambda '(alternative)	     
                                                (list 'lyskom-ok-command 'alternative
                                                      lyskom-is-administrator))
                                          t nil 'lyskom-command-history))))
    (cdr (lyskom-string-assoc name alternatives))))


(defun lyskom-update-command-completion ()
  "Build a list of alternatives for completion of LysKOM commands.
Each list element is a vector [NAME COMMAND CANONICAL]. NAME is the
command name, COMMAND is the command and CANONICAL is the name 
transformed for matching."
  (setq lyskom-command-alternatives
        (mapcar (lambda (el) 
                  (vector (cdr el)
                          (car el)
                          (lyskom-completing-strip-command
                           (lyskom-unicase (cdr el)))
			  (lyskom-unicase (cdr el))))
                (lyskom-get-strings lyskom-commands 'lyskom-command))))

(defun lyskom-lookup-command-by-name (string &optional predicate)
  "Look up the command that corresponds to a certain string."
  (lyskom-complete-command string predicate 'lyskom-lookup))

(defsubst lyskom-command-match-string-regexp (string)
  (concat 
   "^\\s-*"
   (replace-in-string (regexp-quote
                       (lyskom-unicase
                        (lyskom-completing-strip-command string)))
                      "\\s-+" "\\\\S-*\\\\s-+")
          "\\s-*"))

(defun lyskom-completing-strip-command (string)
  "Strip parens and crap from a name.
If optional DONT-STRIP-SPACES is non-nil, don't strip spaces at front
and back of the string."
  (while (string-match "([^()]*)" string) ; Strip nested parens
    (setq string (replace-match "" t t string)))
  (while (string-match "\\s-\\s-+" string) ; Collapse spaces
    (setq string (replace-match " " t t string)))
  (while (string-match "([^()]*$" string) ; Strip incomplete parens at end
    (setq string (substring string 0 (match-beginning 0))))
  string)

;;; FIXME: Below is an idea on how to do command completion more right.
;;;
;;; Precompute lists of words in all commands. Include the optional words 
;;; and mark them as optional. Possibly allow sublists in the list, and
;;; make lists of words into sublists and mark the entire sublist as
;;; optional.
;;;
;;; When matching, divide the input into a list of words. Start matchin
;;; prefixes against the list of words for a command. It goes something 
;;; like this:
;;;
;;; C = 0, I = 0
;;; while there are more words in the input and command
;;;    A = word I of the input
;;;    B = word C of the command
;;;    if B is an optional word then
;;;       N = index of word following optional group that B is part of
;;;       push N,I onto backtracking stack
;;;    if A is a prefix of B then
;;;       I = I + 1
;;;	  C = C + 1
;;;       next iteration of the loop
;;;    if the backtracking stack is empty then
;;;       return mismatch
;;;    pop X,Y from the backtracking stack
;;;    C = X
;;;    I = Y
;;;    next iteration of the loop
;;; end while
;;; if there are left-over words in C then
;;;    return a mismatch
;;; else
;;;    return a match (I,C)
;;;
;;; When doing a word completion we can let the completion function do the
;;; actual work. It computes the longest possible completion we can have
;;; (i.e. one full word more than what we've got) and hands that over to
;;; lyskom-complete-string. Computing the longest possible completion
;;; goes something like this:
;;;
;;; W = nil
;;; Store I,C for all matches
;;; for all matches M = 1 .. N do
;;;    do something useful
;;;
;;; The idea is to get the last word that matches the input by storing
;;; the results of the match computation and then looking at the
;;; following word in all possible completions. If the following word
;;; is a word in an optional group that is the same in all possible
;;; completions, then that plus the first C words of any of the
;;; possible completions is the maximum possible. If the next word is
;;; a word of an optional group that does *not* match in all
;;; possibles, then ignore the optional group and look at the next
;;; word instead.

(defun lyskom-complete-command (string predicate all)
  "Completion function for LysKOM commands."
  (when (string-match "^\\s-+" string)
    (setq string (substring string (match-end 0))))
  (let ((alternatives nil)
        (m-string (lyskom-command-match-string-regexp string))
        (u-string (lyskom-unicase string))
        (exact nil))
    (lyskom-traverse el lyskom-command-alternatives
      (when (and (string-match m-string (elt el 2))
                 (or (null predicate) (funcall predicate el)))
        (setq alternatives (cons (if (eq all 'lyskom-lookup) el (elt el 0)) alternatives))
	(if (string-equal u-string (elt el 3)) (setq exact el))))
    (cond 
     ((eq all 'lyskom-lookup) (and exact (elt exact 1)))
     ((eq all 'lambda) exact)
     (all alternatives)
     ((null alternatives) nil)
     ((and (= (length alternatives) 1) exact) t)
     (t (let ((tmp (lyskom-complete-string alternatives)))
	  (lyskom-maybe-recode-string
	   (if (string-match (concat (regexp-quote (lyskom-unicase tmp)) "\\s-") u-string)
	       (concat tmp " ")
	     tmp)))))))

(defun lyskom-command-complete-word ()
  (interactive)
  (let ((string (buffer-string)))
    (when (next-single-property-change 0 'read-only string)
      (setq string 
            (substring string 
                       (next-single-property-change 0 'read-only string))))

    (let ((completion (try-completion string
                                      minibuffer-completion-table
                                      minibuffer-completion-predicate)))
      (cond ((null completion) (minibuffer-message " [No match]") nil)
            ((eq completion t) nil)
            (t (let* ((tmp string))
                 (when (and (string-equal (lyskom-unicase completion)
                                          (lyskom-unicase tmp))
                            (not (string-match "\\s-$" completion)))
                   (if (stringp (setq tmp (try-completion 
                                           (concat tmp " ")
                                           minibuffer-completion-table
                                           minibuffer-completion-predicate)))
                       (setq completion tmp)))
                 (if (string-equal (lyskom-unicase completion)
                                   (lyskom-unicase string))
                     (progn (minibuffer-completion-help) nil)
                   (delete-region (- (point-max) (length string))
                                  (point-max))

                   ;; Now we have the suggested completion
                   ;; Expand what's in the buffer by one real word.

                   (let* ((count (lyskom-command-complete-count-words string))
                          (result (lyskom-command-complete-word-truncate 
                                   completion count)))
                     (when (string= result string)
                       (setq result (lyskom-command-complete-word-truncate 
                                     completion (1+ count))))
                     (insert result))
                   t)))))))

(defvar lyskom-command-complete-regexp
  "\\(([^\)]*)\\s-+\\)*\\S-+\\(\\s-*([^\)]*)\\)*\\(\\s-+\\|\\'\\)")

(defun lyskom-command-complete-word-truncate (completion count)
  "Truncate completion COMPLETION to COUNT words."
  (let ((start 0))
    (while (and (> count 0)
                (string-match lyskom-command-complete-regexp completion start))
      (setq start (match-end 0)
            count (1- count)))
    (substring completion 0 start)))

(defun lyskom-command-complete-count-words (string)
  "Count number of real words in command name or completion STRING."
  (let ((start 0)
        (count 0))
    (while (string-match lyskom-command-complete-regexp string start)
      (setq start (match-end 0)
            count (1+ count)))
    count))



;;; The code below is an alternative implementation of 
;;; lyskom-command-complete-word that mucks with the
;;; contents of the minibuffer and then calls the regular
;;; minibuffer functions.
;;;
;;;
;;;(defun lyskom-command-complete-word-count-words (string)
;;;  (let ((count 0)
;;;        (start 0))
;;;    (while (string-match lyskom-command-complete-regexp string start)
;;;      (setq start (match-end 0)
;;;            count (1+ count)))
;;;    count))  
;;;
;;;(defun lyskom-command-complete-word ()
;;;  (interactive)
;;;  (let* ((string (buffer-string))
;;;         completions)
;;;    ;; Strip the prompt in Emacs 21
;;;    (when (next-single-property-change 0 'read-only string)
;;;      (setq string 
;;;            (substring string 
;;;                       (next-single-property-change 0 'read-only string))))
;;;
;;;    (setq completions (save-excursion
;;;                        (set-buffer lyskom-buffer)
;;;                        (lyskom-complete-command string 
;;;                                                 nil
;;;                                                 nil)))
;;;    (when (stringp completions)
;;;      (let ((original-count (lyskom-command-complete-word-count-words string))
;;;            (start 0))
;;;        (while (and (> original-count 0)
;;;                    (string-match lyskom-command-complete-regexp completions start))
;;;          (setq start (match-end 0)
;;;                original-count (1- original-count)))
;;;
;;;        (delete-region (- (point-max) (length string)) (point-max))
;;;        (let ((result (substring completions 0 start)))
;;;          (string-match "\\s-*\\'" result)
;;;          (insert (substring result 0 (match-beginning 0)))))))
;;;  (minibuffer-complete-word))


(defun lyskom-start-of-command (function &optional may-interrupt dead-ok)
  "This function is run at the beginning of every LysKOM command.
It moves the cursor one line down, and +++ later it will tell the server
that the previous text has been read.

Argument FUNCTION is a string the string will be written in the buffer
on start of the command. If it is a symbol it searches for the corresponding
command name in lyskom-commands and writes this in the message buffer.

If optional argument MAY-INTERRUPT is present and non-nil,
don't signal an error if this call is interrupting another command.

If optional DEAD-OK is non-nil, don't signal an error if the session 
has been closed.

Special: if lyskom-is-waiting then we are allowed to break if we set 
lyskom-is-waiting nil.

This function checks if lyskom-doing-default-command and
lyskom-first-time-around are bound. The text entered in the buffer is
chosen according to this"

  (cond ((or (not (boundp 'lyskom-proc))
             (not (boundp 'lyskom-buffer))
             (and (null lyskom-proc) (null lyskom-buffer)))
         (lyskom-error "%s" (lyskom-get-string 'not-lyskom-buffer)))

        ((and (not dead-ok)
              (or (not lyskom-proc)
                  (memq (process-status lyskom-proc) '(closed signal exited nil))))
      (lyskom-error "%s" (lyskom-get-string 'dead-session))))

  (if (and lyskom-is-waiting
           (listp lyskom-is-waiting))
      (progn
        (setq lyskom-is-waiting nil)
        (lyskom-end-of-command)))

  (setq lyskom-is-waiting nil)
  (if (and lyskom-executing-command (not may-interrupt))
      (lyskom-error "%s" (lyskom-get-string 'wait-for-prompt)))
  (if (not (and (boundp 'lyskom-doing-default-command)
                lyskom-doing-default-command))
      (cond
       (lyskom-first-time-around)
       ((stringp function) (lyskom-insert function))
       ((and function (symbolp function))
        (let ((name (lyskom-command-name function)))
          (if name (lyskom-insert name)))))
    (save-excursion
      (if lyskom-current-prompt
          (let ((inhibit-read-only t))
            (goto-char (point-max))
            (beginning-of-line)
            (delete-region (point) (point-max)))))
    (lyskom-insert (lyskom-modify-prompt 
                    (cond ((stringp lyskom-current-prompt) 
                           (apply 'lyskom-format 
                                  lyskom-current-prompt
                                  lyskom-current-prompt-args))
                          ((symbolp lyskom-current-prompt)
                           (apply 'lyskom-format 
                                  (lyskom-get-string lyskom-current-prompt)
                                  lyskom-current-prompt-args))
                          (t (format "%S" lyskom-current-prompt)))
                    t)))
  (setq mode-line-process (lyskom-get-string 'mode-line-working))
  (if (pos-visible-in-window-p (point-max))
      (save-excursion
        (goto-char (point-max))
        (lyskom-set-last-viewed)))
  (setq lyskom-executing-command t)
  (setq lyskom-current-command function)
  (setq lyskom-current-prompt nil)
  (lyskom-insert "\n")
  (if (and (eq (window-buffer (selected-window))
               (current-buffer))) 
      (progn
	(if (pos-visible-in-window-p (1- (point-max)))
	    (goto-char (point-max)))
	(sit-for 0)))
  (run-hooks 'lyskom-before-command-hook)
  (if kom-page-before-command           ;Nice with dumb terminals.
      (if (or (not (listp kom-page-before-command))
              (memq function kom-page-before-command))
          (recenter 1))))


(defun lyskom-end-of-command ()
  "Print prompt, maybe scroll, prefetch info."
  (lyskom-save-excursion
   (message "")
   (lyskom-clean-all-buffer-lists)
   (while (and lyskom-to-be-printed-before-prompt
               (lyskom-queue->first lyskom-to-be-printed-before-prompt))
     (if (not (bolp)) (lyskom-insert "\n"))
     (lyskom-insert (car (lyskom-queue->first 
                          lyskom-to-be-printed-before-prompt)))
     (lyskom-queue-delete-first lyskom-to-be-printed-before-prompt))
   (setq lyskom-executing-command nil)
   (setq lyskom-current-command nil)
   (setq lyskom-current-prompt nil)	; Already set in s-o-c really
   (lyskom-scroll)
   (setq mode-line-process (lyskom-get-string 'mode-line-waiting))
   (if (pos-visible-in-window-p (point-max) (selected-window))
       (lyskom-set-last-viewed))
   (lyskom-prefetch-and-print-prompt)
   (run-hooks 'lyskom-after-command-hook)
   (when (and (lyskom-have-feature idle-time)
              (not lyskom-is-anonymous))
     (save-excursion (set-buffer lyskom-buffer)
                     (initiate-user-active 'background nil)))
   (if kom-inhibit-typeahead
       (discard-input))
   ;; lyskom-pending-commands should probably be a queue or a stack.
   (when lyskom-pending-commands
      (let ((command (car lyskom-pending-commands)))
       (setq lyskom-pending-commands (cdr lyskom-pending-commands))
       (if (symbolp command)
           (call-interactively command)
         (eval command))))
   (when lyskom-slow-mode
     (buffer-enable-undo))))

(eval-and-compile (provide 'lyskom-command))

;;; command.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: buffers.el,v 44.23 2002/02/24 20:23:25 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: buffers.el
;;;; Author: David Byers
;;;;
;;;; This file implements special buffer handling used in LysKOM
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: buffers.el,v 44.23 2002/02/24 20:23:25 joel Exp $\n"))


;;;;
;;;; LYSKOM BUFFER MANAGEMENT
;;;;
;;;; Buffers are arranged in a tree rooted in a LysKOM buffer. There
;;;; is one tree for each session.
;;;;
;;;; Use lyskom-get-buffer-create to create new buffers
;;;; Use lyskom-display-buffer to display most buffers
;;;; Use lyskom-undisplay-buffer to undisplay those buffers
;;;;





;;;; ============================================================
;;;; Buffer hierarchy management
;;;;
;;;; This code should not be too dependent on LysKOM
;;;;

(defvar lyskom-buffer-children nil
  "List of buffers that are children to this buffer")

(defvar lyskom-buffer-inherited-variables nil
  "List of variables automatically inherited to sub-buffers when
they are created.")

(defvar lyskom-buffer-parent nil
  "Parent of buffer")

(defvar lyskom-killing-hierarchy nil
  "Non-nil while killing a buffer hierarchy.")

(make-variable-buffer-local 'lyskom-buffer-parent)
(lyskom-protect-variable 'lyskom-buffer-parent)

(make-variable-buffer-local 'lyskom-buffer-children)
(lyskom-protect-variable 'lyskom-buffer-children)

(make-variable-buffer-local 'lyskom-buffer-inherited-variables)
(lyskom-protect-variable 'lyskom-buffer-inherited-variables)




(defun lyskom-set-buffer-parent (buffer parent)
  "Set the parent buffer of BUFFER to PARENT. If buffer is already
a child of some buffer, reparent it."
  (save-excursion (set-buffer buffer)
		  (if (and lyskom-buffer-parent
                           (buffer-live-p lyskom-buffer-parent))
                      (lyskom-remove-buffer-child lyskom-buffer-parent buffer))
		  (setq lyskom-buffer-parent parent)
		  (if parent (lyskom-add-buffer-child parent buffer))))

(defun lyskom-remove-buffer-child (buffer child)
  "Remove CHILD from BUFFER's list of children. Args: BUFFER CHILD"
  (save-excursion (set-buffer buffer)
		  (if (boundp 'lyskom-buffer-children)
		      (setq lyskom-buffer-children 
                            (delq child lyskom-buffer-children)))))

(defun lyskom-add-buffer-child (buffer child)
  "Add CHILD as a child of BUFFER. Args: BUFFER CHILD"
  (save-excursion (set-buffer buffer)
		  (setq lyskom-buffer-children
                        (cons child lyskom-buffer-children))))

(defun lyskom-get-buffer-parent (buffer)
  "Return the parent of BUFFER or nil if it has no parent"
  (save-excursion (set-buffer buffer)
		  (and (boundp 'lyskom-buffer-parent)
		       lyskom-buffer-parent)))

(defun lyskom-get-buffer-children (buffer)
  "Return the list of children of buffer BUFFER or nil if there are none."
  (save-excursion (set-buffer buffer)
		  (and (boundp 'lyskom-buffer-children)
		       lyskom-buffer-children)))

(defun lyskom-buffer-root-ancestor (buffer)
  "Return the ultimate ancestor of buffer BUFFER."
  (let ((buffer-parent buffer))
    (while (setq buffer-parent
		 (lyskom-get-buffer-parent buffer))
      (setq buffer buffer-parent))
    buffer))

(defun lyskom-traverse-buffer-hierarchy (function buffer)
  "Apply FUNCTION to each descendent of BUFFER. Results are discarded."
  (let ((queue (list buffer))
        (done nil)
        (current nil))
    (while queue
      (setq current (car queue))
      (setq queue (cdr queue))
      (unless (or (memq current done)
                  (not (buffer-live-p current)))
        (setq done (cons current done))
        (setq queue (append queue (lyskom-get-buffer-children current)))
        (funcall function current)))))
        

(defun lyskom-map-buffer-children (function buffer)
  "Apply FUNCTION to each child of BUFFER and make a list of the results."
  (cond ((null buffer) nil)
	(t (cons (funcall function buffer)
		 (apply 'nconc 
			(mapcar (function
				 (lambda (x)
                                   (lyskom-map-buffer-children function x)))
				(lyskom-get-buffer-children buffer)))))))


(defun lyskom-buffer-hierarchy-query-kill-function ()
  "When querying if a buffer is to be killed, ensure that none of
the children object"
  (save-excursion
    (not (memq nil
               (mapcar (function
                        (lambda (buffer)
                          (if (buffer-live-p buffer)
                              (progn (set-buffer buffer)
                                     (run-hook-with-args-until-failure
                                      'kill-buffer-query-functions))
                            t)))
                       (lyskom-get-buffer-children (current-buffer)))))))
  

(defun lyskom-buffer-hierarchy-kill-hook ()
  "When killing a buffer, enure that its children also die"
  (let ((kill-buffer-query-functions nil)
        (lyskom-killing-hierarchy (or lyskom-killing-hierarchy
                                      (current-buffer))))
    (lyskom-set-buffer-parent (current-buffer) nil)
    (let ((buflist (lyskom-get-buffer-children (current-buffer))))
      (while buflist
        (kill-buffer (car buflist))
        (setq buflist (cdr buflist))))))


(defun lyskom-buffer-kill-trim-hook ()
  "When killing a buffer, run trimming hooks."
  (when (eq major-mode 'lyskom-mode)
    (let ((lyskom-trim-buffer-delete-to (point-max)))
      (lyskom-ignore lyskom-trim-buffer-delete-to)
      (run-hooks 'lyskom-trim-buffer-hook))))

(add-hook 'kill-buffer-hook 'lyskom-buffer-hierarchy-kill-hook)
(add-hook 'kill-buffer-hook 'lyskom-buffer-kill-trim-hook)
(add-hook 'kill-buffer-query-functions
          'lyskom-buffer-hierarchy-query-kill-function)



;;;; ======================================================================
;;;; ======================================================================

(defun lyskom-clean-all-buffer-lists ()
  "Remove dead buffers from all relevant buffer lists"
  (setq lyskom-sessions-with-unread
        (lyskom-clean-buffer-list lyskom-sessions-with-unread)
        lyskom-sessions-with-unread-letters
        (lyskom-clean-buffer-list lyskom-sessions-with-unread-letters)
        lyskom-buffer-list
        (lyskom-clean-buffer-list lyskom-buffer-list))
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defun lyskom-clean-buffer-list (buffers)
  "Remove all dead buffers from BUFFERS"
  (let ((result nil))
    (while buffers
      (if (lyskom-buffer-p (car buffers))
        (setq result (cons (car buffers) result))
        (save-excursion (set-buffer (car buffers))
                        (setq lyskom-session-has-unread-letters nil)
                        (setq lyskom-session-has-unreads nil)))
      (setq buffers (cdr buffers)))
    (nreverse result)))

(defun lyskom-remove-buffer-from-lists (&optional buffer)
    "Remove BUFFER from all internal lists.
If BUFFER is not specified, assume the current buffer"
  (unless buffer (setq buffer (current-buffer)))
  (lyskom-remove-unread-buffer buffer)  
  (setq lyskom-buffer-list
        (delq buffer lyskom-buffer-list))
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defun lyskom-remove-unread-buffer (buffer &optional letters-only)
  (unless letters-only
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unreads nil)))
     buffer)
    (setq lyskom-sessions-with-unread 
          (delq buffer lyskom-sessions-with-unread)))
  (lyskom-traverse-buffer-hierarchy 
   (lambda (x)
     (save-excursion (set-buffer x)
                     (setq lyskom-session-has-unread-letters nil)))
   buffer)
  (setq lyskom-sessions-with-unread-letters
        (delq buffer lyskom-sessions-with-unread-letters))
  (lyskom-set-default 'lyskom-need-prompt-update t))
  

(defun lyskom-add-unread-buffer (buffer &optional letters)
  (unless (memq buffer lyskom-sessions-with-unread)
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unreads t)))
     buffer)
    (setq lyskom-sessions-with-unread
          (cons buffer lyskom-sessions-with-unread)))
  (unless (or (null letters)
              (memq buffer lyskom-sessions-with-unread-letters))
    (lyskom-traverse-buffer-hierarchy 
     (lambda (x)
       (save-excursion (set-buffer x)
                       (setq lyskom-session-has-unread-letters t)))
     buffer)
    (setq lyskom-sessions-with-unread-letters
          (cons buffer lyskom-sessions-with-unread-letters)))
  (lyskom-set-default 'lyskom-need-prompt-update t))

(defvar lyskom-associated-buffer-list nil
  "List of (CATEGORY . BUFFER-LIST) listing all buffers of various
categories")

(make-variable-buffer-local 'lyskom-associated-buffer-list)
(lyskom-protect-variable 'lyskom-associated-buffer-list)

(defvar lyskom-buffer-category nil
  "Category of this buffer")

(make-variable-buffer-local 'lyskom-buffer-category)
(lyskom-protect-variable 'lyskom-buffer-category)

(def-kom-var lyskom-saved-window-configuration nil
  "The window configuration to return to when closing the window"
  protected
  local)

(def-kom-var lyskom-dedicated-frame nil
  "The frame dedicated to the current buffer"
  protected
  local)

(def-kom-var lyskom-dedicated-window nil
  "The window dedicated to the current buffer"
  protected
  local)

(defvar lyskom-undisplaying-hierarchy nil
  "The top of the buffer hierarchy being undisplayed.")



(defun lyskom-clean-up-buffer-category (cat)
  (let ((buffers (cdr (assq cat (lyskom-default-value 'lyskom-associated-buffer-list))))
        (result nil))
    (while buffers
      (when (buffer-live-p (car buffers))
        (setq result (cons (car buffers) result)))
      (setq buffers (cdr buffers)))
    (lyskom-set-buffers-of-category cat (nreverse result))))


(defun lyskom-set-buffers-of-category (category buflist)
  (let ((tmp (assq category (lyskom-default-value 'lyskom-associated-buffer-list))))
    (cond (tmp (setcdr tmp buflist))
          (t (lyskom-setq-default 
              lyskom-associated-buffer-list
              (cons (cons category buflist)
                    (lyskom-default-value 'lyskom-associated-buffer-list)))))))


(defun lyskom-buffers-of-category (cat)
  "Return all live buffers of catgory CAT"
  (lyskom-clean-up-buffer-category cat)
  (cdr (assq cat (lyskom-default-value 'lyskom-associated-buffer-list))))


(defun lyskom-add-buffer-of-category (buffer category)
  "Add BUFFER as a buffer of category CATEGORY"
  (let ((tmp (assq category (lyskom-default-value 'lyskom-associated-buffer-list))))
    (cond (tmp (setcdr tmp (cons buffer (cdr tmp))))
          (t (lyskom-setq-default 'lyskom-associated-buffer-list
                                  (cons (cons category (list buffer))
                                        (lyskom-default-value
                                         'lyskom-associated-buffer-list)))))))


(defun lyskom-quit-query ()
  (if (and (boundp 'lyskom-buffer)
           (local-variable-p 'lyskom-buffer (current-buffer))
             (eq lyskom-buffer (current-buffer))
             (lyskom-buffers-of-category 'write-texts))
    (unwind-protect
        (progn
          (display-buffer (car (lyskom-buffers-of-category 'write-texts)))
          (lyskom-ja-or-nej-p (lyskom-get-string 'quit-in-spite-of-unsent)))
      nil)
    t))

(add-hook 'kill-buffer-query-functions 'lyskom-quit-query)
(add-hook 'kill-emacs-query-functions 'lyskom-quit-query)

(defun lyskom-recode-buffer-name (name)
  (cond ((and (multibyte-string-p name) (not enable-multibyte-characters))
	 (encode-coding-string name 
			       (or (and lyskom-language
					(lyskom-language-coding
					 lyskom-language))
				   'raw-text)))
	((and (not (multibyte-string-p name)) enable-multibyte-characters)
	 (decode-coding-string name 
			       (or (and lyskom-language
					(lyskom-language-coding
					 lyskom-language))
				   'raw-text)))
	(t name)))

(defun lyskom-generate-new-buffer (name)
  (setq name (lyskom-recode-buffer-name name))
  (let ((buf (generate-new-buffer name)))
    (save-excursion
      (set-buffer buf))
    buf))

(defun lyskom-get-buffer-create (category name &optional unique)
  "Create a new buffer of category CATEGORY with name generated from NAME. 
If UNIQUE is non-nil, re-use the first existing buffer of category
CATEGORY, renaming it and killing its local variables.

The created buffer is made a child of the current buffer."
  (setq name (lyskom-recode-buffer-name name))
  (let ((buffers (lyskom-buffers-of-category category))
        (buffer nil))
    (if (and unique buffers)
        (progn (setq buffer (car buffers))
               (save-excursion (set-buffer buffer)
                               (let ((inhibit-read-only t))
;;; +++ FIXME: This is that erase-buffer works if there are widgets
                                 (setq before-change-functions
                                       (delq 'widget-before-change
                                             before-change-functions))
                                 (erase-buffer))
                               (kill-all-local-variables)
                               (if (equal (buffer-name (current-buffer))
                                          name)
                                   nil
                                 (rename-buffer name t))))
      (progn (setq buffer (generate-new-buffer name))
             (lyskom-add-buffer-of-category buffer category)))
    (lyskom-set-buffer-parent buffer (current-buffer))
    (lyskom-update-inherited-variables buffer)
    (save-excursion (set-buffer buffer)
                    (setq lyskom-buffer-category category))
    buffer))



(defun lyskom-update-inherited-variables (buffer)
  "Update all inherited variables in this buffer and propagate them
to all children"
  (save-excursion 
    (let ((variables nil)
          (tmp lyskom-inherited-variables))
      (set-buffer buffer)
      (when lyskom-buffer-parent
        (set-buffer lyskom-buffer-parent)
        (setq variables (mapcar 'symbol-value lyskom-inherited-variables))
        (set-buffer buffer)
        (while tmp
          (make-local-variable (car tmp))
          (set (car tmp) (car variables))
          (setq tmp (cdr tmp)
                variables (cdr variables))))
      (mapcar 'lyskom-update-inherited-variables
              lyskom-buffer-children))))



(defun lyskom-display-buffer (buffer)
  "Display the buffer BUFFER and select the window displaying it.

If BUFFER is already visible in some window in any frame, iconified or
otherwise, make that window visible. Otherwise display buffer as per 
which category it is in. Selects the window.

Returns the window displaying BUFFER."


  (set-buffer buffer)
  (let ((windows (lyskom-get-buffer-window-list buffer nil 0))
        (iconified-frame nil)
        (visible-frame))

    ;;
    ;; Find out if the buffer is visible somewhere
    ;;

    (while windows
      (cond ((not (frame-live-p (window-frame (car windows)))))
            ((eq (frame-visible-p (window-frame (car windows))) 'icon)
             (setq iconified-frame (car windows)))
            ((frame-visible-p (window-frame (car windows)))
             (setq visible-frame (car windows))
             (setq windows nil)))
      (setq windows (cdr windows)))

    ;;
    ;; Display it
    ;;

    (cond
     (visible-frame (select-window visible-frame)
                    visible-frame)
     (iconified-frame (make-frame-visible (window-frame iconified-frame))
                      (select-window iconified-frame)
                      iconified-frame)

     (t
      (let ((category lyskom-buffer-category)
            (window nil))
        (if (null category) 
            (progn (select-window (display-buffer buffer))
                   (selected-window))

          (let* ((sym (intern-soft (concat "kom-"
                                           (symbol-name category)
                                           "-in-window")))
                 (open (lyskom-default-value-safe sym))
                 (saved-window-configuration
                  (save-excursion
                    (set-buffer (or (and (boundp 'lyskom-buffer)
                                         lyskom-buffer)
                                    (current-buffer)))
                    (current-window-configuration)))
                 (dedicated-frame nil)
                 (dedicated-window nil))
            
            (cond 

             ;;
             ;; NULL -- Just switch to the buffer
             ;;

             ((null open)
              (switch-to-buffer buffer)
              (setq window (selected-window)))

             ;;
             ;; OTHER, OTHER-WINDOW -- Switch to in another window
             ;;

             ((memq open '(other other-window))
              (switch-to-buffer-other-window buffer)
              (setq dedicated-window (selected-window))
              (setq window (selected-window)))
                  
             ;;
             ;; OTHER-FRAME -- Switch to in another frame
             ;; Create frame if none exist
             ;;

             ((eq open 'other-frame)
              (if (eq (selected-frame) (next-frame))
                  (switch-to-buffer-other-frame buffer)
                (other-frame 1)
                (switch-to-buffer buffer))
              (setq window (selected-window)))
                  
             ;;
             ;; NEW-FRAME
             ;; Create a new frame and display buffer in that frame
             ;;

             ((eq open 'new-frame)
              (switch-to-buffer-other-frame buffer)
              (setq dedicated-frame (selected-frame))
              (setq dedicated-window (selected-window))
              (setq window (selected-window))
              (setq saved-window-configuration nil))

             ;;
             ;; String or buffer
             ;; Switch to buffer in window displaying named buffer
             ;; Prefer windows in selected frame
             ;;

             ((and (or (stringp open)
                       (bufferp open))
                   (lyskom-get-buffer-window-list open nil 'visible))
              (let ((tmp (lyskom-get-buffer-window-list open nil 'visible)))
                (setq window (car tmp))
                (while tmp
                  (if (eq (window-frame (car tmp))
                          (selected-frame))
                      (progn
                        (setq window (car tmp))
                        (setq tmp nil))
                    (setq tmp (cdr tmp))))
                (select-window window)
                (switch-to-buffer buffer)))

             ;;
             ;; Otherwise just switch
             ;;
             
             (t (switch-to-buffer buffer)
                (setq window (selected-window))))


            ;;
            ;; Set up kill-buffer-hooks and similar things
            ;;

            (select-window window)
            (set-buffer buffer)
            (make-local-variable 'lyskom-dedicated-frame)
            (setq lyskom-dedicated-frame dedicated-frame)
            (make-local-variable 'lyskom-dedicated-window)
            (setq lyskom-dedicated-window dedicated-window)
            (make-local-variable 'lyskom-saved-window-configuration)
            (setq lyskom-saved-window-configuration
                  saved-window-configuration)
            (make-local-hook 'kill-buffer-hook)
            (add-hook 'kill-buffer-hook
                      'lyskom-undisplay-buffer-hook nil t)
            (put 'kill-buffer-hook 'permanent-local t)
            window)))))))


(defun lyskom-undisplay-buffer-hook ()
  (save-excursion (lyskom-undisplay-buffer (current-buffer))))

(defun lyskom-undisplay-buffer (&optional buffer)
  "Undisplay BUFFER. If buffer is not specified, undisplay the current
buffer"

  (setq buffer (or buffer (current-buffer)))
  (let ((dedicated-frame (and (boundp 'lyskom-dedicated-frame)
                              lyskom-dedicated-frame))
        (dedicated-window (and (boundp 'lyskom-dedicated-window)
                                       lyskom-dedicated-window))
        (lyskom-undisplaying-hierarchy (or buffer
                                           lyskom-undisplaying-hierarchy))
        (saved-window-configuration
         (and (boundp 'lyskom-saved-window-configuration)
              lyskom-saved-window-configuration)))
         
    (cond 

     ;;
     ;; If buffer has a dedicated frame AND
     ;; buffer is visible in that frame THEN
     ;; delete the frame
     ;;

     (dedicated-frame
      (when (memq dedicated-frame
                  (mapcar 'window-frame
                          (lyskom-get-buffer-window-list buffer nil t)))
        (delete-frame dedicated-frame)
        (setq dedicated-frame nil)))

     ((and lyskom-killing-hierarchy
           (not (eq lyskom-killing-hierarchy buffer))) nil)
     ((and lyskom-undisplaying-hierarchy
           (not (eq lyskom-undisplaying-hierarchy buffer))) nil)

     (dedicated-window
      (when (and (window-live-p dedicated-window)
                 (eq (get-buffer buffer)
                     (window-buffer dedicated-window)))
	(if (eq dedicated-window (next-window dedicated-window))
	    (bury-buffer buffer)
	    (delete-window dedicated-window))
	(setq dedicated-window nil))
      (when saved-window-configuration
        (lyskom-set-partial-window-configuration
         saved-window-configuration)))

     (saved-window-configuration
      (lyskom-set-partial-window-configuration
       lyskom-saved-window-configuration)))))

(defun lyskom-set-partial-window-configuration (configuration)
  "Set CONFIGURATION as the current window configuration with the exception
of point mark and window-start in all windows."
  (let* ((info nil)
         (binfo nil))
    (save-excursion
      (setq binfo
            (mapcar (function
                     (lambda (b)
                       (set-buffer b)
                       (list b (point) (mark t))))
                    (buffer-list)))
      (walk-windows (function
                     (lambda (w)
                       (set-buffer (window-buffer w))
                       (setq info
                             (cons
                              (list w
                                    (window-start w)
                                    (window-point w)
                                    (window-buffer w))
                              info))))
                    t t))
    (unwind-protect
        (set-window-configuration configuration)
      (save-selected-window
        (let (buffer window saved-point saved-mark saved-start)

          (while binfo
            (setq buffer (elt (car info) 0)
                  saved-point (elt (car info) 1)
                  saved-mark (elt (car info) 2))
            (when (buffer-live-p buffer)
              (set-buffer buffer)
              (goto-char saved-point)
              (set-mark saved-mark))
            (setq binfo (cdr binfo)))

          (while info
            (setq window (elt (car info) 0)
                  saved-start (elt (car info) 1)
                  saved-point (elt (car info) 2)
                  buffer (elt (car info) 3))

            (when (and (window-live-p window)
                       (eq (window-buffer window)
                           buffer))
              (set-window-start window saved-start)
              (set-window-point window saved-point))
            (setq info (cdr info))))))))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: aux-items.el,v 44.35 2002/06/12 18:29:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: aux-items.el
;;;;
;;;; Implementation of aux-item specific stuff.
;;;; Hopefulle more of this will be made more general in the future.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: aux-items.el,v 44.35 2002/06/12 18:29:32 byers Exp $\n"))

;;; (eval-when-compile
;;;   (require 'lyskom-defvar "defvar.el")
;;;   (require 'lyskom-vars "vars.el")
;;;   (require 'lyskom-types "komtypes.el"))


(def-kom-var lyskom-aux-item-definitions nil
  "List of aux item definitions.")

(defmacro def-aux-item (name number &rest data)
  (` (setq lyskom-aux-item-definitions 
           (add-to-list 'lyskom-aux-item-definitions
                        (cons (, number)
                              (cons (cons 'name (quote (, name)))
                                    (quote (, data))))))))

(defun lyskom-aux-item-definition->name (def)
  (cdr (assq 'name def)))

(defun lyskom-aux-item-definition->number (def)
  (car def))

(defun lyskom-map-aux-items (fn text-stat)
  "Apply FN to every aux item in TEXT-STAT."
  (let ((items (text-stat->aux-items text-stat)))
    (while items
      (when (and (car items) 
                 (not (aux-item-flags->deleted (aux-item->flags items))))
        (funcall fn (car items)))
      (setq items (cdr items)))))



(defun lyskom-aux-item-try-call (item method default &rest args)
  (when (lyskom-aux-item-p item)
    (setq item (lyskom-find-aux-item-definition item)))
  (cond ((listp method)
         (let ((result nil)
               (found nil))
           (while method
             (when (lyskom-aux-item-definition-field item (car method))
               (setq result
                     (apply (lyskom-aux-item-definition-field item
                                                              (car method))
                            args)
                     found t
                     method nil))
             (setq method (cdr method)))
           (if found result default)))
        (t (if (lyskom-aux-item-definition-field item method)
             (apply (lyskom-aux-item-definition-field item method) args)
             default))))

(defun lyskom-aux-item-has-call (item method)
  "Return non-nil if aux-item ITEM has a defined method METHOD"
  (when (lyskom-aux-item-p item)
    (setq item (lyskom-find-aux-item-definition item)))
  (lyskom-aux-item-definition-field item method))

(defun lyskom-aux-item-call (def method &rest args)
  (apply 'lyskom-aux-item-try-call def method nil args))


(defun lyskom-aux-item-definition-field (def method)
  (when (lyskom-aux-item-p def)
    (setq def (lyskom-find-aux-item-definition def)))
  (cdr (assq method def)))


(defun lyskom-find-aux-item-definition (aux)
  (assq (aux-item->tag aux) lyskom-aux-item-definitions))

(defun lyskom-match-aux-items (item-list predicate)
  "Return a list of all aux-items in ITEM-LIST that match PREDICATE.
PREDICATE should receives a single aux-item as its argument and should
return non-nil if the item is to be included in the list."
  (let ((result nil))
    (while item-list
      (when (funcall predicate (car item-list))
        (setq result (cons (car item-list) result)))
      (setq item-list (cdr item-list)))
    (nreverse result)))

                                        
(defun lyskom-get-aux-item (item-list tag)
  "Return all aux-items in ITEM-LIST with tag TAG."
  (lyskom-match-aux-items item-list
                          (lambda (el) (eq (aux-item->tag el) tag))))


(defun lyskom-aux-item-terminating-button (item obj)
  (if obj
       (lyskom-format 
        " %#1@%[[*]%]" 
        (lyskom-default-button 
         'aux 
         (cond ((lyskom-text-stat-p obj) (list 'text
                                               (text-stat->text-no obj)
                                               (aux-item->aux-no item)))
               ((lyskom-conf-stat-p obj) (list 'conf
                                               (conf-stat->conf-no obj)
                                               (aux-item->aux-no item)))
               ((eq obj 'server) (list 'server nil (aux-item->aux-no item)))
               (t item))))
     ""))

(defun lyskom-aux-item-after-parse (item)
  (lyskom-aux-item-try-call item 'decode-data nil)
  item)

(defun lyskom-aux-item-output-data (item)
  (lyskom-aux-item-try-call item 
                            'encode-data
                            (aux-item->data item)
			    item))


;;; ======================================================================

(def-aux-item content-type 1
  (text-name aux-content-type-name)
  (parse . lyskom-parse-content-type)
  (text-print . lyskom-print-content-type)
  (info  . lyskom-aux-item-info))

(def-aux-item fast-reply 2
  (text-name aux-fast-reply-name)
  (parse . nil)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (info . lyskom-aux-item-info))

(def-aux-item cross-reference 3
  (text-name aux-cross-reference-name)
  (status-print . lyskom-status-print-cross-reference)
  (text-print-when . comment)
  (parse . lyskom-parse-cross-reference)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (text-print . lyskom-print-cross-reference)
  (edit-insert . lyskom-edit-insert-cross-reference)
  (info  . lyskom-aux-item-info))

(def-aux-item no-comments 4
  (text-name aux-no-comments-name)
  (text-print-when . footer)
  (parse . lyskom-parse-no-comments)
  (text-print . lyskom-print-no-comments)
  (edit-insert . lyskom-edit-insert-no-comments)
  (info  . lyskom-aux-item-info))

(def-aux-item personal-comment 5
  (text-name aux-personal-comment-name)
  (text-print-when . footer)
  (parse . lyskom-parse-personal-comments)
  (text-print . lyskom-print-personal-comments)
  (edit-insert . lyskom-edit-insert-personal-comments)
  (info  . lyskom-aux-item-info))

(def-aux-item request-confirmation 6
  (text-name aux-request-confirmation-name)
  (text-print-when . header)
  (parse . lyskom-parse-request-confirmation)
  (text-print . lyskom-print-request-confirmation)
  (edit-insert . lyskom-edit-insert-request-confirmation)
  (info  . lyskom-aux-item-info)
  (read-action . lyskom-request-confirmation-action))

(def-aux-item read-confirm 7
  (text-name aux-read-confirm-name)
  (text-print-when . header)
  (text-print . lyskom-print-read-confirm)
  (info  . lyskom-aux-item-info))

(def-aux-item redirect 8
  (text-name aux-redirect-name)
  (print . lyskom-print-redirect)
  (info  . lyskom-aux-item-info))

(def-aux-item x-face 9
  (text-name aux-x-face-name)
  (print . lyskom-print-xface)
  (info  . lyskom-aux-item-info))

(def-aux-item alternate-name 10
  (text-name aux-alternate-name-name)
  (text-print-when . header)
  (text-print . lyskom-print-alternate-name)
  (encode-data . lyskom-aux-item-encode-data)
  (parse-data . lyskom-aux-item-decode-data)
  (info  . lyskom-aux-item-info))

(def-aux-item pgp-signature 11
  (text-name aux-pgp-signature-name)
  (info  . lyskom-aux-item-info))

(def-aux-item pgp-public-key 12
  (text-name aux-pgp-public-key-name)
  (info  . lyskom-aux-item-info))

(def-aux-item e-mail-address 13
  (text-name aux-e-mail-address-name)
  (info  . lyskom-aux-item-info))

(def-aux-item faq-text 14
  (text-name aux-faq-text-name)
  (info . lyskom-aux-item-info)
  (text-header-line . (faq-in-text faq-in-text-by))
  (status-print . lyskom-status-print-faq-text))

(def-aux-item creating-software 15
  (text-name aux-creating-software-name)
  (info . lyskom-aux-item-info)
  (text-print-when . header)
  (parse-data . lyskom-aux-item-decode-data)
  (encode-data . lyskom-aux-item-encode-data)
  (text-print . lyskom-print-creating-software))

(def-aux-item mx-author 16
  (text-name aux-mx-author-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-from 17
  (text-name aux-mx-from-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-reply-to 18
  (text-name aux-mx-reply-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-to 19
  (text-name aux-mx-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-cc 20
  (text-name aux-mx-cc-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-date 21
  (text-name aux-mx-date-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-message-id 22
  (text-name aux-mx-message-id-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-in-reply-to 23
  (text-name aux-mx-in-reply-to-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-misc 24
  (text-name aux-mx-misc-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-allow-filter 25
  (text-name aux-mx-allow-filter-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-reject-forward 26
  (text-name aux-mx-reject-forward-name)
  (info . lyskom-aux-item-info))

(def-aux-item notify-comments 27
  (text-name aux-notify-comments-name)
  (info . lyskom-aux-item-info))

(def-aux-item faq-for-conf 28
  (text-name aux-faq-for-conf-name)
  (text-print . lyskom-print-faq-for-conf)
  (text-print-when . header)
  (info . lyskom-aux-item-info)
  (read-action . lyskom-faq-for-conf-action))


(def-aux-item recommended-conf 29
  (text-name aux-recommended-conf-name)
  (status-print . lyskom-print-recommended-conf)
  (info . lyskom-aux-item-info))

(def-aux-item allowed-content-type 30
  (text-name aux-allowed-content-type-name)
  (info . lyskom-aux-item-info))

(def-aux-item canonical-name 31
  (text-name aux-canonical-name-name)
  (info . lyskom-aux-item-info))

(def-aux-item mx-list-name 32
  (text-name aux-mx-list-name-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-mx-list-name))

(def-aux-item send-comments-to 33
  (text-name aux-send-comments-to-name)
  (info . lyskom-print-aux-item-info)
  (status-print . lyskom-print-send-comments-to))

(def-aux-item world-readable 34
  (text-name aux-world-readable-name)
  (info . lyskom-aux-item-info)
  (text-print . lyskom-print-world-readable)
  (parse . lyskom-parse-world-readable)
  (edit-insert . lyskom-edit-insert-world-readable)
  (text-print-when . header))

(def-aux-item elisp-client-read-faq 10000
  (text-name aux-elisp-client-read-faq-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-elisp-client-read-faq))

(def-aux-item elisp-client-rejected-invitation 10001
  (text-name aux-elisp-client-rejected-invitation-name)
  (info . lyskom-aux-item-info)
  (status-print . lyskom-print-elisp-client-rejected-invitation))


;;; ================================================================



(defun lyskom-aux-item-decode-data (item)
  (set-aux-item->data 
   item
   (decode-coding-string (aux-item->data item) lyskom-server-coding-system)))

(defun lyskom-aux-item-encode-data (item)
  (encode-coding-string (aux-item->data item) lyskom-server-coding-system)
  )


(defun lyskom-aux-item-info (item header)
  (let ((def (lyskom-find-aux-item-definition item)))
    
    (concat 
     (lyskom-get-string 'aux-item-for)
     header
     "\n"
     (lyskom-format
      'aux-item-info
      (aux-item->aux-no item)
      (aux-item->tag item)
      (if def
          (lyskom-aux-item-definition->name def)
        "unknown")
      (aux-item->creator item)
      (lyskom-format-time 'date-and-time (aux-item->sent-at item))
      (if (aux-item-flags->deleted (aux-item->flags item))
          (format "(%s)" (lyskom-get-string 'deleted))
        "")
      (mapconcat 'identity
                 (delq nil
                       (list
                        (and (aux-item-flags->secret (aux-item->flags item))
                             (lyskom-get-string 'secret))
                        (and (aux-item-flags->anonymous (aux-item->flags item))
                             (lyskom-get-string 'hide-creator))
                        (and (aux-item-flags->inherit (aux-item->flags item))
                             (lyskom-get-string 'inherit))))
                 ", ")
      (cond ((not (aux-item-flags->inherit (aux-item->flags item)))
             (lyskom-get-string 'no-inheritance))
            ((zerop (aux-item->inherit-limit item))
             (lyskom-get-string 'unlimited-inherit))
            ((eq 1  (aux-item->inherit-limit item))
             (lyskom-get-string 'no-more-inherit))
            (t (lyskom-format 'inherit-steps
                              (1- (aux-item->inherit-limit item)))))
      (aux-item->data item)))))

                 

(defun lyskom-print-content-type (item &optional obj)
  (concat (lyskom-format 'content-type-aux (aux-item->data item))
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-parse-content-type ()
  (and (looking-at (lyskom-get-string 'content-type-regexp))
       (match-string 1)))

(defun lyskom-parse-cross-reference ()
  (or (and (looking-at (lyskom-get-string 'cross-reference-text-regexp))
           (concat "T" (match-string 1)))
      (and (looking-at (lyskom-get-string 'cross-reference-conf-regexp))
           (concat "C" (match-string 1)))
      (and (looking-at (lyskom-get-string 'cross-reference-pers-regexp))
           (concat "P" (match-string 1)))))

(defun lyskom-edit-insert-cross-reference (item pers)
  (concat
   (lyskom-print-cross-reference item nil pers)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-print-cross-reference (item &optional obj pers)
  (let ((pers (if (and (zerop (aux-item->creator item))
                       pers)
                  pers
                (aux-item->creator item))))
    (concat
     (cond ((string-match "^P\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-pers-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           ((string-match "^C\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-conf-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           ((string-match "^T\\([0-9]+\\)" (aux-item->data item))
            (lyskom-format 'cross-reference-text-aux 
                           (string-to-int 
                            (match-string 1 (aux-item->data item)))
                           pers
                           ))
           (t (lyskom-format 'strange-cross-reference 
                             (aux-item->data item)
                             pers
                             )))
     (lyskom-aux-item-terminating-button item obj)
     )))

(defun lyskom-status-print-cross-reference (item &optional obj pers)
  (lyskom-insert 
   (concat
    (cond ((string-match "^P\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-pers-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          (aux-item->creator pers)
                          ))
          ((string-match "^C\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-conf-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          pers
                          ))
          ((string-match "^T\\([0-9]+\\)" (aux-item->data item))
           (lyskom-format 'cross-reference-text-status-aux 
                          (string-to-int 
                           (match-string 1 (aux-item->data item)))
                          (aux-item->creator pers)
                          ))
          (t (lyskom-format 'strange-cross-reference-status 
                            (aux-item->data item)
                            (aux-item->creator pers)
                            )))
    (lyskom-aux-item-terminating-button item obj)
    "\n")))  

(defun lyskom-parse-no-comments ()
  (and (looking-at (lyskom-get-string 'no-comments-regexp))
       ""))

(defun lyskom-print-no-comments (item &optional obj)
  (concat (lyskom-format 'no-comments-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-no-comments (item &optional obj)
  (concat
   (lyskom-format 'no-comments-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-parse-personal-comments ()
  (and (looking-at (lyskom-get-string 'personal-comment-regexp))
       ""))

(defun lyskom-print-personal-comments (item &optional obj)
  (concat (lyskom-format 'personal-comment-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-personal-comments (item &optional obj)
  (concat
   (lyskom-format 'personal-comment-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-parse-request-confirmation ()
  (and (looking-at (lyskom-get-string 'request-confirmation-regexp))
       ""))

(defun lyskom-print-request-confirmation (item &optional obj)
  (concat (lyskom-format 'request-confirmation-aux
                         (aux-item->creator item))
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-edit-insert-request-confirmation (item &optional obj)
  (concat
   (lyskom-format 'request-confirmation-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-faq-for-conf-action (text-stat)
  (let ((faqs (text-stat-find-aux text-stat 28)))
    (lyskom-traverse aux faqs
      (lyskom-register-read-faq (string-to-int (aux-item->data aux))
                                (text-stat->text-no text-stat)))))

(defun lyskom-request-confirmation-action (text-stat)
  (let ((confirmations (text-stat-find-aux text-stat 7))
        (have-confirmation nil))
    (while confirmations
      (when (eq lyskom-pers-no (aux-item->creator (car confirmations)))
        (setq have-confirmation t)
        (setq confirmations nil))
      (setq confirmations (cdr confirmations)))
    (when  (not have-confirmation)
      (lyskom-scroll)
      (when (lyskom-j-or-n-p
             (lyskom-format (lyskom-get-string 'confirm-read-q)
                            text-stat))
        (let ((item (lyskom-create-aux-item 0 7 lyskom-pers-no
                                            nil 
                                            (lyskom-create-aux-item-flags
                                             nil nil nil nil nil nil nil nil)
                                            0 "")))
          (initiate-modify-text-info 'background
                                     nil
                                     (text-stat->text-no text-stat)
                                     nil
                                     (list item))
          (cache-del-text-stat (text-stat->text-no text-stat)))))))

(defun lyskom-print-read-confirm (item &optional obj)
  (concat 
   (lyskom-format 'read-confirm-aux
                  (aux-item->creator item)
                  (lyskom-format-time 'date-and-time (aux-item->sent-at item)))
   (lyskom-aux-item-terminating-button item obj)))



(defun lyskom-print-redirect (item &optional obj)
  (concat
   (cond ((string-match "^E-mail:\\(.*\\)$" (aux-item->data item))
          (lyskom-format 'redirect-email-aux 
                         (match-string 1 (aux-item->data item))))
         ((string-match "^LysKOM:\\(.*\\)$" (aux-item->data item))
          (lyskom-format 'redirect-lyskom-aux 
                         (string-to-int 
                          (match-string 1 (aux-item->data item))))))
   (lyskom-aux-item-terminating-button item obj)))   


(defun lyskom-print-xface (item &optional obj)
  (lyskom-xemacs-or-gnu
   (lyskom-maybe-add-face-to-string item
                                    (make-string 0 ?X))
   nil))

(defun lyskom-maybe-add-face-to-string (item string)
  (lyskom-xemacs-or-gnu
   (if (null item)
       string
     (setq item (car item))
     (unless (find-face 'kom-xface)
       (make-face 'kom-xface))
     (let* ((h (concat "X-Face: " (aux-item->data item)))
            (g (intern h lyskom-xface-cache))
            (e (make-extent 0 (length string) string)))
       (if (boundp g)
           (setq g (symbol-value g))
         (set g (make-glyph
                 (list
                  (list 'global (cons '(tty) [nothing]))
                  (list 'global (cons '(win) 
                                      (vector 'xface ':data h))))))
         (setq g (symbol-value g))
         (set-glyph-face g 'kom-xface))
       (set-extent-begin-glyph e g)
       (set-extent-property e 'end-open nil)
       (set-extent-property e 'start-open nil)
       (set-extent-property e 'duplicable t)
       string))
   string))


(defun lyskom-print-alternate-name (item &optional obj)
  (concat "[" (aux-item->data item) "] "
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-faq-format-subject (text text-stat text-no)
  (if (and text text-stat)
      (concat "\""
	      (cond ((string-match "\n" (text->decoded-text-mass text text-stat))
		     (substring (text->decoded-text-mass text text-stat) 0 (match-beginning 0)))
		    (t ""))
	      "\"")
    (lyskom-format 'no-such-text-no text-no)))

(defun lyskom-deferred-print-faq (text-stat defer-info)
  (if text-stat
      (initiate-get-text 
       'deferred 
       (lambda (text text-stat defer-info)
         (lyskom-replace-deferred defer-info 
                                  (lyskom-format "%#1r" 
                                                 (lyskom-print-faq-format-subject text
                                                                                  text-stat
                                                                                  (defer-info->data defer-info)))))
       (text-stat->text-no text-stat)
       text-stat
       defer-info)
    (lyskom-replace-deferred defer-info
                             (lyskom-print-faq-format-subject nil nil (defer-info->data defer-info)))))

(defun lyskom-status-print-faq-text (item &optional obj)
  (let* ((text-no (string-to-int (aux-item->data item)))
         (subject (if kom-deferred-printing
                      (lyskom-create-defer-info 'get-text-stat
                                                text-no
                                                'lyskom-deferred-print-faq
                                                nil nil nil
                                                text-no)
                    (blocking-do-multiple ((text (get-text text-no))
                                           (text-stat (get-text-stat text-no)))
                      (lyskom-print-faq-format-subject text text-stat text-no)))))
    (lyskom-format-insert 'faq-in-text-aux 
                          text-no
                          subject)
    (lyskom-insert (lyskom-aux-item-terminating-button item obj))
    (lyskom-insert "\n")))

(defun lyskom-print-faq-for-conf (item &optional obj)
  (let ((conf-no (string-to-int (aux-item->data item))))
    (concat 
     (cond ((zerop conf-no) (lyskom-get-string 'faq-for-server-aux))
          (t (lyskom-format 'faq-for-conf-aux conf-no)))
     (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-creating-software (item &optional obj)
  (when (or kom-show-creating-software
            (lyskom-viewing-noconversion))
    (concat
     (lyskom-format 'creating-software-aux (aux-item->data item))
     (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-send-comments-to (item &optional obj)
  (when (string-match "^\\([0-9]+\\)" (aux-item->data item))
    (let ((conf-no (string-to-int (match-string 1 (aux-item->data item)))))
      (lyskom-format-insert 'status-send-comments-to
                            conf-no 
                            (lyskom-aux-item-terminating-button item obj)))))



(defun lyskom-parse-world-readable ()
  (and (looking-at (regexp-quote 
                    (lyskom-get-string 'world-readable-text-edit-aux)))
       ""))

(defun lyskom-edit-insert-world-readable (item &optional obj)
  (concat
   (lyskom-format 'world-readable-text-edit-aux)
   (lyskom-edit-generate-aux-item-flags (aux-item->flags item))))

(defun lyskom-print-world-readable (item &optional obj)
  (concat (lyskom-format 'world-readable-text-aux)
          (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-mx-list-name (item &optional obj)
  (lyskom-format-insert 'conf-mx-list-name 
                        (aux-item->data item)
                        (lyskom-aux-item-terminating-button item obj)))

(defun lyskom-print-recommended-conf (item &optional obj)
  (let ((conf-no (string-to-int (if (string-match " " (aux-item->data item))
                                    (substring (aux-item->data item) 0 (match-beginning 0))
                                  (aux-item->data item)))))
    (lyskom-format-insert 'recommended-conf-aux
                          conf-no
                          (lyskom-aux-item-terminating-button item obj))))

(defun lyskom-print-elisp-client-read-faq (item &optional obj)
  (when kom-extended-status-information
    (when (string-match "^\\([0-9]+\\) \\([0-9]+\\)" (aux-item->data item))
      (let ((conf-no (string-to-int (match-string 1 (aux-item->data item))))
            (text-no (string-to-int (match-string 2 (aux-item->data item)))))
        (lyskom-format-insert 'status-read-faq-aux-item 
                              conf-no 
                              text-no
                              (lyskom-aux-item-terminating-button item obj))))))

(defun lyskom-print-elisp-client-rejected-invitation (item &optional obj)
  (when (string-match "^\\([0-9]+\\)" (aux-item->data item))
    (let ((conf-no (string-to-int (match-string 1 (aux-item->data item)))))
      (lyskom-format-insert 'status-rejected-recommendation-aux-item
                            conf-no 
                            (lyskom-aux-item-terminating-button item obj)))))

(provide 'lyskom-aux-items)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: mime.el,v 44.7 2002/07/23 18:28:41 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: mime.el
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: mime.el,v 44.7 2002/07/23 18:28:41 byers Exp $\n"))

(defvar lyskom-charset-alist
  '(((ascii)						. us-ascii)
    ((ascii latin-iso8859-1)				. iso-8859-1)
    ((ascii latin-iso8859-2)				. iso-8859-2)
    ((ascii latin-iso8859-3)				. iso-8859-3)
    ((ascii latin-iso8859-4)				. iso-8859-4)
    ((ascii cyrillic-iso8859-5)				. iso-8859-5)
;;; ((ascii cyrillic-iso8859-5)				. koi8-r)
    ((ascii arabic-iso8859-6)				. iso-8859-6)
    ((ascii greek-iso8859-7)				. iso-8859-7)
    ((ascii hebrew-iso8859-8)				. iso-8859-8)
    ((ascii latin-iso8859-9)				. iso-8859-9)
    ((ascii latin-iso8859-15)				. iso-8859-15)
    ((ascii latin-jisx0201
	    japanese-jisx0208-1978 japanese-jisx0208)	. iso-2022-jp)
    ((ascii latin-jisx0201
	    katakana-jisx0201 japanese-jisx0208)	. shift_jis)
    ((ascii korean-ksc5601)				. euc-kr)
    ((ascii chinese-gb2312)				. gb2312)
    ((ascii chinese-big5-1 chinese-big5-2)		. big5)
    ((ascii latin-iso8859-1 greek-iso8859-7
	    latin-jisx0201 japanese-jisx0208-1978
	    chinese-gb2312 japanese-jisx0208
	    korean-ksc5601 japanese-jisx0212)		. iso-2022-jp-2)
    ;; ((ascii latin-iso8859-1 greek-iso8859-7
    ;;         latin-jisx0201 japanese-jisx0208-1978
    ;;         chinese-gb2312 japanese-jisx0208
    ;;         korean-ksc5601 japanese-jisx0212
    ;;         chinese-cns11643-1 chinese-cns11643-2)      . iso-2022-int-1)
    ))


(defun lyskom-mime-string-charset (data)
  (let* ((cs (find-charset-string data))
         (tmp lyskom-charset-alist)
         (best-guess (let ((system nil))
                       (while (and tmp cs)
                         (if (lyskom-subset-p cs (car (car tmp)))
                             (setq system (cdr (car tmp)) tmp nil)
                           (setq tmp (cdr tmp))))
                       system)))
    (or
     best-guess
     (lyskom-xemacs-or-gnu
      lyskom-server-coding-system
      (let ((coding (find-coding-systems-for-charsets cs)))
        (while (null (coding-system-get (car coding) 'mime-charset))
          (setq coding (cdr coding)))
        (coding-system-get (car coding) 'mime-charset)))
    lyskom-server-coding-system)))

(defun lyskom-mime-charset-coding-system (charset)
  (condition-case nil
      (and (check-coding-system charset)
           charset)
    (error 'raw-text)))

(defun lyskom-mime-encode-string (data)
  (let* ((mime-charset (lyskom-mime-string-charset data))
         (coding-system (lyskom-mime-charset-coding-system mime-charset)))
    (when (and mime-charset coding-system)
      (cons mime-charset (encode-coding-string data coding-system)))))

(defun lyskom-mime-decode-string (data charset)
  (let* ((coding-system (lyskom-mime-charset-coding-system charset)))
    (if coding-system
        (decode-coding-string data coding-system)
      data)))

(defun lyskom-mime-decode-content-type (data)
  (string-match "^\\([^;]*\\)\\(;.*charset=\\([^;]*\\)\\)?" data)
  (cons (match-string 1 data)
        (if (match-string 3 data)
            (intern (match-string 3 data))
          nil)))

(provide 'lyskom-mime)
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: prefetch.el,v 44.23 2002/02/24 20:23:27 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;;
;;;; File: prefetch.el
;;;;
;;;; This file contains the functions that make up the prefetch
;;;; system.
;;;;
;;;; Author: Inge Wallin
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: prefetch.el,v 44.23 2002/02/24 20:23:27 joel Exp $\n"))


;;; ================================================================
;;;                          Variables.


(def-kom-var lyskom-prefetch-stack nil
  "A stack where all prefetch requests are entered. New items are entered
first and when an item is to be prefetched, it is taken from the front of 
this list. 

Each entry is either the atom 'DONE, a cons cell as described below or a 
lyskom-queue.

\('CONFSTAT . number\) - The conf stat of Conference NUMBER.
\('PERSSTAT . number\) - The pers stat of person NUMBER.
\('TEXTSTAT . number\) - The text stat of text NUMBER.
\('TEXTMASS . number\) - The text mass of text NUMBER.
\('TEXTAUTH . number\) - The text stat of the text NUMBER 
                       and the conf-stat of the author of it.
\('TEXT-ALL . number\) - The text stat and mass of text NUMBER, but also
                       all information that will be used when writing
                       this text for the user to see, such as conf-stat
                       for the author, text stats for commented texts,
                       comments, a.s.o.
\('TEXTTREE . number\) - The text stat, author, textauth of comments to 
		       and texttree of all comments and footnotes.
\('CONFSTATFORMAP conf-no first-local\) - The conf-stat of the conference
		       number CONF-NO is fetched and then we continue
		       to fetch the map.
\('MAP conf-stat first-local\) -
                       The next part of the map in conference CONF-STAT.
		       The length fetched per revolution is according to
		       the value of lyskom-fetch-map-nos.
\('MARKS\) -             The whole list of marked texts and then every info about
		       these texts.
\('WHOBUFFER\) -         The who-is-on-info to construct the who-buffer.
\('MEMBERSHIP . pers-no\) -
		       The next part of the membership for person PERS-NO
		       is fetched. How long we already have fetched is
		       kept in the variable lyskom-membership-is-read. If 
		       lyskom-membership-is-read is not a number then we
		       are done.
		       For every membership-part we fetch the conf-stats
		       before continuing with the next part.
\('MEMBERSHIPISREAD\) -  Just sets the lyskom-membership-is-read variable to t.
\('CANCELED . rest\)   Whatever it was, it has been canceled.


See further documentation in the source code."
  local)

;;;
;;; The four requests CONFSTAT, PERSSTAT, TEXTSTAT and TEXTMASS are 
;;; called simple requests and are handled immediately and removed.
;;; The others are called complex requests.  These will each generate
;;; further requests when they return.  
;;; 
;;; When one of the simple requests are sent to the server, the atom
;;; DONE is swapped for the request.
;;;
;;; When one of the complex requests are sent to the server, a
;;; lyskom-queue is swapped for the request and a pointer to the queue
;;; is sent to the handler.  When the call returns the new requests this 
;;; call generates will all be put on the queue.  This process can be
;;; repeated and a queue might contain other queues and so on.  
;;; 
;;; When the prefetch code is searching for a new request to process it
;;; always starts searching at the beginning of the variable 
;;; lyskom-prefetch-stack.  If an empty queue is encountered, it is simply
;;; skipped since this significates a complex request that has already 
;;; been sent and is awaiting its result.  A non-empty queue is recursively
;;; searched and treated in the same way as the original stack.
;;; 


(def-kom-var lyskom-prefetch-in-action nil
  "t when the prefetch-process is started and going."
  local)


(defvar lyskom-inhibit-prefetch nil
  "Set this to a non-nil value locally to inhibit the prefetch.
This is used to prevent the prefetch code to reenter itself.")


(def-kom-var lyskom-pending-prefetch 0
  "Variable counting the number of unfinished prefetch requests."
  local)


;;; ================================================================
;;;                 Functions callable from the outside


(defun lyskom-setup-prefetch ()
  "Sets up the prefetch process in lyskom."
  (setq lyskom-prefetch-stack (lyskom-stack-create))
  (setq lyskom-pending-prefetch 0)
  (setq lyskom-membership-is-read 0))


;;; =================================================================
;;; Functions to cancel some prefetches

(defun lyskom-prefetch-cancel-prefetch-map (conf-no &optional queue)
;;;  (let ((prefetch-list (if queue
;;;                           (lyskom-queue->all-entries queue)
;;;                         (lyskom-stack->all-entries lyskom-prefetch-stack))))
;;;    (lyskom-traverse el prefetch-list
;;;      (cond
;;;       ((lyskom-queue-p el)
;;;        (lyskom-prefetch-cancel-prefetch-map conf-no el))
;;;       ((not (consp el)) nil)
;;;       ((or (and (eq (car el) 'MAP) 
;;;                 (eq (conf-stat->conf-no (elt el 1)) conf-no))
;;;            (and (eq (car el) 'CONFSTATFORMAP)
;;;                 (eq (elt el 1) conf-no)))
;;;        (setcar el 'CANCELED))
;;;       )))
)


;;;; ================================================================
;;; +++ lyskom-reset-prefetch  to be called on client reset.
;;;                            must restart everything.
;;; +++ THIS DOES NOT WORK CURRENTLY
(defun lyskom-reset-prefetch ()
  "Reset the prefetch system."
  ;; (lyskom-wait-queue 'prefetch)
  (lyskom-setup-prefetch))


(defsubst lyskom-membership-is-read ()
  "Return t if the while membership list has been fetched, and nil otherwise."
  (eq lyskom-membership-is-read 't))

(defun lyskom-fetch-start-of-map (conf-stat membership)
  "Block fetching map for MEMBERSHIP until we see a text.
Start the prefetch for the remainder of the map."
  (let ((first-local (1+ (membership->last-text-read membership)))
        (last-local (1- (+ (conf-stat->no-of-texts conf-stat)
                           (conf-stat->first-local-no conf-stat))))
        (done nil))
    (while (not done)
      (let ((map (blocking-do 'get-map 
                              (membership->conf-no membership)
                              first-local
                              lyskom-fetch-map-nos)))
        (setq first-local (+ first-local lyskom-fetch-map-nos))
        (lyskom-enter-map-in-to-do-list map conf-stat membership)
        (cond ((and (map->text-nos map)
                    (< first-local last-local)
                    (> (length (map->text-nos map)) 0))
               (setq done t)
               (lyskom-prefetch-map-using-conf-stat conf-stat
                                                    first-local
                                                    membership)
               )

              ((< first-local last-local))
              (t (setq done t)))))))

(defun lyskom-prefetch-conf (conf-no &optional queue)
  "Prefetch the conf-stat for the conference with number CONF-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if conf-no
      (if queue
	  (lyskom-queue-enter queue (cons 'CONFSTAT conf-no))
	(lyskom-stack-push lyskom-prefetch-stack (cons 'CONFSTAT conf-no)))
    (signal 'lyskom-internal-error "No argument to lyskom-prefetch-conf"))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-pers (pers-no &optional queue)
  "Prefetch the pers-stat for person with number PERS-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'PERSSTAT pers-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'PERSSTAT pers-no)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-text (text-no &optional queue)
  "Prefetch the text-stat for the text with number TEXT-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'TEXTSTAT text-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXTSTAT text-no)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-textmass (text-no &optional queue)
  "Prefetch the text mass for the text with number TEXT-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'TEXTMASS text-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXTMASS text-no)))
  (lyskom-continue-prefetch))
  

(defun lyskom-prefetch-textauth (text-no &optional queue)
  "Prefetch the text stat and the author of text number TEXT-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'TEXTAUTH text-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXTAUTH text-no)))
  (lyskom-continue-prefetch))
  

(defun lyskom-prefetch-text-all (text-no &optional queue)
  "Prefetch all info about the text with number TEXT-NO.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (if queue
      (lyskom-queue-enter queue (cons 'TEXT-ALL text-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXT-ALL text-no)))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-text-stat-all (text-stat &optional queue)
  "Prefetch all info about the text with text stat TEXT-STAT.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack."
  (when (null queue)
    (setq queue (lyskom-queue-create))
    (lyskom-stack-push lyskom-prefetch-stack queue))
  (lyskom-prefetch-text-all-handler text-stat queue))


(defun lyskom-prefetch-texttree (text-no &optional queue only-new)
  "Prefetch all info about the text with number TEXT-NO and descends recursively.
If QUEUE is non-nil, put the request on it, otherwise put it on 
lyskom-prefetch-stack.

If ONLY-NEW is non-nil and the text-stat in question is already
prefetched the prefetch is not done."
  (if (and only-new
	   (cache-get-text-stat text-no))
      nil
    (if queue
	(lyskom-queue-enter queue (cons 'TEXTTREE text-no))
      (lyskom-stack-push lyskom-prefetch-stack (cons 'TEXTTREE text-no))))
  (lyskom-continue-prefetch))
  

(defun lyskom-prefetch-membership (pers-no &optional queue)
  "h{mtar medlemsskapet i sm} delar och d{refter conf-stat f|r m|tena"
  (if queue
      (lyskom-queue-enter queue (cons 'MEMBERSHIP pers-no))
    (lyskom-stack-push lyskom-prefetch-stack (cons 'MEMBERSHIP pers-no)))
  (lyskom-continue-prefetch))

(defun lyskom-prefetch-one-membership (conf-no pers-no &optional queue)
  (if queue
      (lyskom-queue-enter queue (list 'ONE-MEMBERSHIP conf-no pers-no))
    (lyskom-stack-push lyskom-prefetch-stack (list 'ONE-MEMBERSHIP
                                                   conf-no pers-no)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-map (conf-no membership &optional queue)
  "Prefetches a map for conf CONFNO."
  (lyskom-prefetch-map-from conf-no
			    (1+ (membership->last-text-read membership))
			    membership
			    queue))


(defun lyskom-prefetch-map-from (conf-no first-local membership
					 &optional queue)
  "Prefetches a map for conf CONFNO starting att FIRST-LOCAL."
  (if queue
      (lyskom-queue-enter queue (list 'CONFSTATFORMAP
				      conf-no first-local membership))
    (lyskom-stack-push lyskom-prefetch-stack
		       (list 'CONFSTATFORMAP
			     conf-no first-local membership)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-map-using-conf-stat (conf-stat first-local membership
						      &optional queue)
  "Prefetches a map for conf CONFSTAT starting att FIRST-LOCAL."
  (if queue
      (lyskom-queue-enter queue (list 'MAP conf-stat first-local membership))
    (lyskom-stack-push lyskom-prefetch-stack (list 'MAP
						   conf-stat first-local
						   membership)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-all-conf-stats (&optional queue)
  "+++"
  nil)


(defun lyskom-prefetch-marks (&optional queue)
  "Prefetches the list of marked texts. Then all texts are fetched."
  (if queue
      (lyskom-queue-enter queue (list 'MARKS))
    (lyskom-stack-push lyskom-prefetch-stack (list 'MARKS)))
  (lyskom-continue-prefetch))


(defun lyskom-prefetch-who-is-on (&optional queue)
  "Prefetches the list of persons on the system."
  (if queue
      (lyskom-queue-enter queue (list 'WHOBUFFER))
    (lyskom-stack-push lyskom-prefetch-stack (list 'WHOBUFFER)))
  (lyskom-continue-prefetch))


;;(defun lyskom-prefetch-all-conf-texts (&optional queue)
;;  "Prefetches the texts in all conferences."
;;  (if queue
;;      (lyskom-queue-enter queue (list 'ALL-CONF-TEXTS))
;;    (lyskom-stack-push lyskom-prefetch-stack (list 'ALL-CONF-TEXTS)))
;;  (lyskom-continue-prefetch))


;;(defun lyskom-prefetch-conf-texts (text-list &optional queue)
;;  "Prefetches the texts in all conferences."
;;  (if (null (text-list->texts text-list))
;;      nil
;;    (if queue
;;	(lyskom-queue-enter queue (list 'CONF-TEXTS text-list))
;;      (lyskom-stack-push lyskom-prefetch-stack (list 'CONF-TEXTS text-list))))
;;  (lyskom-continue-prefetch))

(defun lyskom-prefetch-texts (texts &optional queue)
  "Prefetches a list of texts."
  (if (null texts)
      nil
    (if queue
	(lyskom-queue-enter queue
			    (list 'TEXTS texts))
      (lyskom-stack-push lyskom-prefetch-stack
			 (list 'TEXTS texts))))
  (lyskom-continue-prefetch))

;; (defun lyskom-prefetch-text-list-continue (texts &optional queue)
;;   "Prefetches a list of texts."
;;   (if (null texts)
;; 	 nil
;;     (if queue
;; 	   (lyskom-queue-enter queue (list 'TEXT-LIST-CONT texts))
;; 	 (lyskom-stack-push lyskom-prefetch-stack
;; 			    (list 'TEXT-LIST-CONT texts))))
;;   (lyskom-continue-prefetch))


;;; ================================================================
;;;           Functions internal to the prefetch package


(defun lyskom-stop-prefetch ()
  "Stop the prefetch process temporarily."
  (setq lyskom-prefetch-in-action nil))


(defun lyskom-start-prefetch ()
  "Start the whole prefetch process"
  (setq lyskom-prefetch-in-action t)
  (lyskom-continue-prefetch))


(defun lyskom-continue-prefetch ()
  "Called after each prefetch is finished and also when the whole prefetch
process is started. Used to keep prefetch going."
  (if (not lyskom-inhibit-prefetch)
      (let ((lyskom-inhibit-prefetch t)) ; Make sure we don't call this 
					; recursively
	(while (and (< lyskom-pending-prefetch
		       lyskom-prefetch-limit)
		    (lyskom-prefetch-one-item)
		    ;; Only increase lyskom-pending-prefetch if a server
		    ;; call was made.
		    ;;
		    ;; The return value from lyskom-prefetch-one-item
		    ;; is whether it has sent a server call, but it
		    ;; should really be if the prefetch-stack has been
		    ;; altered. See the comment in
		    ;; lyskom-prefetch-one-item.
		    (++ lyskom-pending-prefetch))))))


(defun lyskom-skip-finished-in-queue (queue)
  "Remove all 'DONE entries and queues who's only entry is 'FINISHED."
  (let ((element nil)
	(done nil))
    (while (not done)
      (setq element (lyskom-queue->first queue))
      (if (or (eq element 'DONE)
              (and (consp element) 
                   (eq (car element) 'CANCELED))
	      (and (lyskom-queue-p element)
		   (eq (lyskom-queue->first element) 'FINISHED)))
	  (lyskom-queue-delete-first queue)
	(setq done t)))))


(defun lyskom-prefetch-one-item ()
  "Get the first element of the prefetch data structure and fetch it.
Return t if an element was prefetched, otherwise return nil."
  (let ((result nil)
	element
	(prefetch-list (lyskom-stack->all-entries lyskom-prefetch-stack))
	(list-stack (lyskom-stack-create))
    	(done nil))

    ; Remove all finished entries at the top of lyskom-prefetch-stack
    (while (not done)
      (setq element (lyskom-stack->top lyskom-prefetch-stack))
      (if (or (eq element 'DONE)
              (and (consp element)
                   (eq (car element) 'CANCELED))
	      (and (lyskom-queue-p element)
		   (eq (lyskom-queue->first element) 'FINISHED)))
	  (lyskom-stack-pop lyskom-prefetch-stack)
	(setq done t)))

    (while (and (not result)
		prefetch-list)
      (let ((element (car prefetch-list))
	    (rest-list (cdr prefetch-list)))
	(cond
	 ((eq element 'DONE) nil)
	 ((eq element 'FINISHED) nil)
         ((and (consp element)
               (eq (car element) 'CANCELED)) nil)

	 ;; A queue ==> check it out first.
	 ((lyskom-queue-p element)
	  (lyskom-skip-finished-in-queue element)
	  (if (lyskom-queue-isempty element)
	      nil
	    (lyskom-stack-push list-stack rest-list)
	    (setq rest-list (lyskom-queue->all-entries element))))
       
	 ;; A simple request?
	 ((and (listp element)
	       (memq (car element)
		     '(CONFSTAT PERSSTAT TEXTSTAT TEXTMASS)))
	  (setcar prefetch-list 'DONE)
	  (lyskom-prefetch-one-request element nil)
	  (setq result t))

	 ;; A complex request?
	 ((and (listp element)
	       (memq (car element)
		     '(TEXTAUTH TEXT-ALL TEXTTREE ONE-MEMBERSHIP
				CONFSTATFORMAP MAP MARKS
				MEMBERSHIP WHOBUFFER TEXTS)))
	  (let ((queue (lyskom-queue-create)))
	    (setcar prefetch-list queue)
	    (lyskom-prefetch-one-request element queue)
	    (setq result t)))

	 ;; Special requests
	 ((and (listp element)
	       (memq (car element) '(MEMBERSHIPISREAD ALL-CONF-TEXTS)))
	  (if (eq (car element) 'MEMBERSHIPISREAD)
	      (setq lyskom-membership-is-read t)
	    ;; Temporarily disabled
	    (let ((queue (lyskom-queue-create)))
	      (setcar prefetch-list queue)
	      (mapcar
	       (lambda (read-info)
		 (mapcar
		  (lambda (text-no)
		    (lyskom-prefetch-text-all text-no queue))
		  (text-list->texts (read-info->text-list read-info))))
	       (read-list->all-entries lyskom-to-do-list))
	      (lyskom-queue-enter queue 'FINISHED)))

	  ;; This is an ugly hack. If this function returns a non-nil
	  ;; value, lyskom-prefetch-continue will assume that a server
	  ;; call was made and increase lyskom-pending-prefetch. But
	  ;; no server call has been made, so we decrease
	  ;; lyskom-pending-prefetch "in advance". The reason that
	  ;; this sets result to t is that we want the loop in
	  ;; lyskom-continue-prefetch to keep running, as there is no
	  ;; server response that will wake the prefetch up in the
	  ;; future.
	  ;;(-- lyskom-pending-prefetch)
	  ;;(setq result t)
	  )

	 (t (signal 'lyskom-internal-error 
		    '(lyskom-prefetch-one-item ": unknown key"))))
	
	(setq prefetch-list rest-list)
	(if (not (or prefetch-list
		     (lyskom-stack-isempty list-stack)))
	    (setq prefetch-list (lyskom-stack-pop list-stack)))))

    result))


(defun lyskom-prefetch-one-request (request queue)
  "Prefetch REQUEST. If the request is complex, put the resulting requests on QUEUE."
;  (message "Prefetch: %s" request)
  (cond
   ((eq (car request) 'CONFSTAT)
    (initiate-get-conf-stat 'prefetch
			    'lyskom-prefetch-handler (cdr request)))
   ((eq (car request) 'PERSSTAT)
    (initiate-get-pers-stat 'prefetch
			    'lyskom-prefetch-handler (cdr request)))
   ((eq (car request) 'TEXTSTAT)
    (initiate-get-text-stat 'prefetch
			    'lyskom-prefetch-handler (cdr request)))
   ((eq (car request) 'TEXTMASS)
    (initiate-get-text 'prefetch 'lyskom-prefetch-handler (cdr request)))
   ((eq (car request) 'TEXTAUTH)
    (initiate-get-text-stat 'prefetch 'lyskom-prefetch-textauth-handler 
			    (cdr request) queue))
   ((eq (car request) 'TEXT-ALL)
    (initiate-get-text-stat 'prefetch 'lyskom-prefetch-text-all-handler
			    (cdr request) queue))
   ((eq (car request) 'TEXTTREE)
    (initiate-get-text-stat 'prefetch 'lyskom-prefetch-texttree-handler
			    (cdr request) queue))

   ((eq (car request) 'ONE-MEMBERSHIP)
    (initiate-query-read-texts 'prefetch
                               'lyskom-prefetch-read-texts-handler
                               (elt request 2)
                               (elt request 1)
                               (elt request 1)
                               queue))

   ((eq (car request) 'MEMBERSHIP)
    (if (numberp lyskom-membership-is-read) ; Are we done?
	(initiate-get-part-of-membership 
	 'prefetch 'lyskom-prefetch-membership-handler
	 (cdr request)
	 lyskom-membership-is-read lyskom-fetch-membership-length 
	 (cdr request)
	 queue)
      ; We are done
      (lyskom-prefetch-handler)))
   ((eq (car request) 'CONFSTATFORMAP)
    (initiate-get-conf-stat 'prefetch 'lyskom-prefetch-confstatformap-handler
			    (nth 1 request) (nth 2 request) (nth 3 request)
			    queue))
   ((eq (car request) 'MAP)
    (initiate-get-map 'prefetch 'lyskom-prefetch-map-handler
		      (conf-stat->conf-no
		       (nth 1 request))	; conf-stat
		      (nth 2 request)	; first-local
		      lyskom-fetch-map-nos
		      (nth 1 request)	; conf-stat
		      (nth 2 request)	; first-local
		      (nth 3 request)	; membership
		      queue))
   ((eq (car request) 'MARKS)
    (initiate-get-marks 'prefetch 'lyskom-prefetch-marks-handler queue))
   ((eq (car request) 'WHOBUFFER)
    (initiate-who-is-on 'prefetch 'lyskom-prefetch-whobuffer-handler queue))
   ((eq (car request) 'TEXTS)
    (initiate-get-text-stat 'prefetch 'lyskom-prefetch-texts-handler
			    (car (nth 1 request))
			    (cdr (nth 1 request))
			    queue))
   
   (t (signal 'lyskom-internal-error
	      (list "lyskom-prefetch-one-request - unknown key:"
		    (car request))))))


;;; ================================================================
;;;      Functions which handle the results of complex requests.


(defun lyskom-prefetch-textauth-handler (text-stat queue)
  "Prefetch the conf-stat of the author of the text TEXT-STAT.
Put the request on QUEUE."
  (lyskom-stop-prefetch)
  (if (not text-stat)
      nil
    (lyskom-prefetch-conf (text-stat->author text-stat) queue)
    (lyskom-queue-enter queue 'FINISHED))
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-text-all-handler (text-stat queue)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT.
Put the requests on QUEUE."
  (lyskom-stop-prefetch)
  (lyskom-prefetch-conf (text-stat->author text-stat) queue)
  (lyskom-prefetch-textmass (text-stat->text-no text-stat) queue)
  (lyskom-traverse
   misc
   (text-stat->misc-info-list text-stat)
   (let ((type (misc-info->type misc)))
     (cond
      ((memq type '(RECPT BCC-RECPT CC-RECPT))
       (lyskom-prefetch-conf (misc-info->recipient-no misc) queue))
      ((eq type 'COMM-IN)
       (lyskom-prefetch-textauth (misc-info->comm-in misc) queue))
      ((eq type 'FOOTN-IN)
       (lyskom-prefetch-textauth (misc-info->footn-in misc) queue))
      ((eq type 'COMM-TO)
       (lyskom-prefetch-textauth (misc-info->comm-to misc) queue))
      ((eq type 'FOOTN-TO)
       (lyskom-prefetch-textauth (misc-info->footn-to misc) queue))
      (t nil))))
  (lyskom-queue-enter queue 'FINISHED)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-texttree-handler (text-stat queue)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT.
Then prefetch all info (texttree) of comments.
Put the requests on QUEUE."
  (if (not text-stat)
      nil				; We did not get anything
    (lyskom-stop-prefetch)
    (lyskom-prefetch-conf (text-stat->author text-stat) queue)
    (lyskom-prefetch-textmass (text-stat->text-no text-stat) queue)
    (lyskom-traverse
     misc
     (text-stat->misc-info-list text-stat)
     (let ((type (misc-info->type misc)))
       (cond
	((memq type '(RECPT BCC-RECPT CC-RECPT))
	 (lyskom-prefetch-conf (misc-info->recipient-no misc) queue))
	((eq type 'COMM-IN)
	 (lyskom-prefetch-texttree (misc-info->comm-in misc) queue t))
	((eq type 'FOOTN-IN)
	 (lyskom-prefetch-texttree (misc-info->footn-in misc) queue t))
	((eq type 'COMM-TO)
	 (lyskom-prefetch-textauth (misc-info->comm-to misc) queue))
	((eq type 'FOOTN-TO)
	 (lyskom-prefetch-textauth (misc-info->footn-to misc) queue))
	(t nil))))
    (lyskom-queue-enter queue 'FINISHED))
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-read-texts-handler (membership pers-no queue)
  (lyskom-stop-prefetch)
  (-- lyskom-pending-prefetch)
  (when membership
    (unless (lyskom-try-get-membership (membership->conf-no membership) t)
      (lyskom-add-memberships-to-membership (list membership))
      (when (and (lyskom-visible-membership membership)
                 (lyskom-prefetch-map (membership->conf-no membership)
                                      membership
                                      queue)))))
  (lyskom-queue-enter queue 'FINISHED)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-membership-handler (memberships pers-no queue)
  "Handle the return of the membership prefetch call."
  (lyskom-stop-prefetch)
  (let ((size (length memberships))
	(i 0)
;;; Commented out 1999-06-28 byers
;;; Used by removed code below
;;;        (old-mships (mapcar (lambda (mship)
;;;                              (and (lyskom-try-get-membership
;;;                                    (membership->conf-no mship))
;;;                                   (membership->conf-no mship)))
;;;                            memberships))
        )
    (lyskom-insert-memberships-in-membership memberships)
    (while (< i size)
      (let ((membership (aref memberships i)))
;;; Commented out 1999-06-26 byers
;;; This should not be necessary since we know that all of these
;;; maps were empty when we started the client. Texts created after
;;; the client was started should end up in the reading list anyway
;;; 'cuase they generate asynchronous messages.
;;;	(if (and (lyskom-visible-membership membership)
;;;                 (not (memq (membership->conf-no membership) old-mships)))
;;;	    (lyskom-prefetch-map (membership->conf-no membership)
;;;				 membership
;;;				 queue))
)
      (++ i))
    (if (and (numberp lyskom-membership-is-read)
	     (< (length memberships) lyskom-fetch-membership-length))
	(progn
	  (setq lyskom-membership-is-read 'almost)
	  (lyskom-queue-enter queue (list 'MEMBERSHIPISREAD)))
      (setq lyskom-membership-is-read (+ lyskom-membership-is-read
					 lyskom-fetch-membership-length))
      (lyskom-prefetch-membership pers-no queue)
      ))
  (lyskom-queue-enter queue 'FINISHED)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-confstatformap-handler (conf-stat first-local
							 membership queue)
  "Now that we have the conf-stat we can fetch the map."
  (lyskom-stop-prefetch)
  (lyskom-prefetch-map-using-conf-stat conf-stat first-local membership queue)
  (lyskom-queue-enter queue 'FINISHED)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-map-handler (map conf-stat first-local membership queue)
  "Handle the return of the membership prefetch call.
Maps are `cached' in lyskom-to-do-list."
  (lyskom-stop-prefetch)
  (let ((next-start (+ first-local lyskom-fetch-map-nos))
	(last-local (1- (+ (conf-stat->no-of-texts conf-stat)
		  (conf-stat->first-local-no conf-stat)))))
    (when map
      ;; An old version of this function tester if the map contained no
      ;; texts. That is not a correct termination condition.
      (when (< next-start last-local)
	(lyskom-prefetch-map-using-conf-stat conf-stat
					     next-start
					     membership
					     queue))
      (lyskom-enter-map-in-to-do-list map conf-stat membership)))
  (lyskom-queue-enter queue 'FINISHED)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch)
  (lyskom-update-prompt)
  (lyskom-set-mode-line))

(defun lyskom-prefetch-marks-handler (marks queue)
  "Handle the list of marked texts."
  (cache-set-marked-texts marks)
  (lyskom-stop-prefetch)
  (let ((list (cache-get-marked-texts)))
    (while list
      (lyskom-prefetch-text-all (mark->text-no (car list)) queue)
      (setq list (cdr list))))
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))


(defun lyskom-prefetch-whobuffer-handler (who-is-on queue)
  "Handle the who-is-on info. The goal here is to get an updated who-buffer."
  ;+++ should be done later
  (cache-initiate-who-info-buffer who-is-on lyskom-buffer)
  (-- lyskom-pending-prefetch)
  )

(defun lyskom-prefetch-texts-handler (text-stat texts queue)
  "Prefetch all info neccessary to write the text with text-stat TEXT-STAT.
Put the requests on QUEUE."
  (lyskom-stop-prefetch)
  (lyskom-prefetch-conf (text-stat->author text-stat) queue)
  (lyskom-prefetch-textmass (text-stat->text-no text-stat) queue)
  (lyskom-traverse
      misc
      (text-stat->misc-info-list text-stat)
    (let ((type (misc-info->type misc)))
      (cond
       ((memq type '(RECPT BCC-RECPT CC-RECPT))
	(lyskom-prefetch-conf (misc-info->recipient-no misc) queue))
       ((eq type 'COMM-IN)
	(lyskom-prefetch-textauth (misc-info->comm-in misc) queue))
       ((eq type 'FOOTN-IN)
	(lyskom-prefetch-textauth (misc-info->footn-in misc) queue))
       ((eq type 'COMM-TO)
	(lyskom-prefetch-textauth (misc-info->comm-to misc) queue))
       ((eq type 'FOOTN-TO)
	(lyskom-prefetch-textauth (misc-info->footn-to misc) queue))
       (t nil))))
  (lyskom-queue-enter queue 'FINISHED)
  ;; The queue is now used up.
  (lyskom-prefetch-texts texts)
  (-- lyskom-pending-prefetch)
  (lyskom-start-prefetch))

(defun lyskom-prefetch-handler (&rest data)
  "Handler called after each simple prefetch request is done."
  (-- lyskom-pending-prefetch)
  (lyskom-continue-prefetch))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: startup.el,v 44.80 2002/08/12 20:41:19 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: startup.el
;;;;
;;;; This file contains functions that are called only when lyskom
;;;; is loaded, started or when a new user is logged in during a 
;;;; session.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: startup.el,v 44.80 2002/08/12 20:41:19 byers Exp $\n"))


;;; ================================================================
;;;                         Start kom.


(defvar lyskom-www-proxy-connect-phase 1
  "Phase when reading connection response from www-proxy:
1: (initial phase) waiting for the
   string \"HTTP/1.0 2000 Connection established\"
2: we have seen the connection string. After this, it may come lines stating
   proxy-agents and other things. They all seem to end with an empty line,
   so in this phase we wait for an empty line.")


(eval-and-compile
  (defun lyskom-compilation-in-progress ()
    "Returns non-nil if the client currently is being compiled, else nil."

    ;; This horrid code is inspired from how cl-compiling-file in the
    ;; cl package works.
    (let ((outbuffersym (lyskom-xemacs-or-gnu 'byte-compile-outbuffer
                                              'outbuffer)))
      (and (boundp outbuffersym)
           (bufferp (symbol-value outbuffersym))
           (equal (buffer-name (symbol-value outbuffersym))
                  " *Compiler Output*")))))


(defconst lyskom-is-running-compiled
  (eval-when-compile (lyskom-compilation-in-progress))
  "Non-nil if the client is running compiled, else nil.")


;;;###autoload
(defun lyskom (&optional host username password session-priority invisiblep)
  "Start a LysKOM session.
Optional arguments: HOST, USERNAME, PASSWORD and INVISIBLEP.

A numeric prefix argument sets the session priority. A prefix argument
of `C-u', on the other hand, logs in the session without notifying other
clients of the event. See lyskom-mode for details on lyskom."
  (interactive (list (lyskom-read-server-name
		      (lyskom-format 'server-q
				     (or (getenv "KOMSERVER")
					 lyskom-default-server)))
		     nil
		     nil
		     (if current-prefix-arg
			 (prefix-numeric-value current-prefix-arg)
		       nil)
		     (and current-prefix-arg (listp current-prefix-arg))))

  (run-hooks 'lyskom-init-hook)
  (setq username
	(or username (getenv "KOMNAME")))
  (setq password
	(or password (getenv "KOMPASSWORD")))
  (if (zerop (length host))
      (let* ((env-kom (getenv "KOMSERVER"))
	     (canon (lyskom-string-rassoc env-kom kom-server-aliases)))
	(setq host (or (car canon)
		       env-kom
		       lyskom-default-server))))
  (let ((port 4894)
	(init-done nil))
    (cond				;Allow "nanny:4892" to use port 4892.
     ((string-match ":" host)
      (setq port (string-to-int (substring host (match-end 0))))
      (cond
       ((zerop (match-beginning 0))
	(setq host lyskom-default-server))
       (t
	(setq host (substring host 0 (match-beginning 0)))))))

    (let* ((duplicate-buffers
            (delq nil
                  (mapcar (lambda (buffer)
                            (and (lyskom-buffer-p buffer t)
                                 (buffer-name buffer)
                                 (string-match (regexp-quote host)
                                               (buffer-name buffer))
                                 (save-excursion (set-buffer buffer)
                                                 (and 
                                                  (boundp 'lyskom-server-port)
                                                  (eq port lyskom-server-port)))
                                 buffer))
                          (buffer-list))))
	   (name nil)
	   (proc nil)
           (buffer (car duplicate-buffers))
	   ;; (alive (lyskom-buffer-p buffer))
           (reused-buffer nil))
      

      ;;<<<<<<< startup.el
      ;;      (if (and buffer
      ;;	       alive
      ;;=======
      (if (and (lyskom-buffer-p buffer nil)
	       (not (prog1
			(j-or-n-p (lyskom-get-string
				   'start-new-session-same-server))
		      (message ""))))
	  (progn 
            (switch-to-buffer buffer)
            (setq reused-buffer t))
	(unwind-protect
	    (progn
	      (cond ((and buffer (not (lyskom-buffer-p buffer)))
		     (set-buffer buffer)
                     (setq reused-buffer t)
		     (goto-char (point-max))
                     (lyskom-insert
                      (format (lyskom-get-string 'new-session-in-buffer)
                              (lyskom-format-time
                               'timeformat-day-yyyy-mm-dd-hh-mm-ss)))
                     (setq name (buffer-name buffer)))
		    (t
		     (setq buffer (lyskom-generate-new-buffer host))
		     (setq name (buffer-name buffer))))
              (let* ((www-proxy-host-string
                      (cond ((stringp kom-www-proxy) kom-www-proxy)
                            ((listp kom-www-proxy)
                             (or (cdr (lyskom-string-assoc host kom-www-proxy))
                                 (cdr (assq t kom-www-proxy))
                                 nil))
                            (t nil)))
                     (www-proxy-host nil)
                     (www-proxy-port nil)
                     (match (string-match "\\(.*\\):\\([0-9]+\\)"
                                          (or www-proxy-host-string "")))
                     (headers nil))
                (setq www-proxy-host (or (and match
                                          (match-string 1 www-proxy-host-string))
                                     www-proxy-host-string)
                      www-proxy-port (or (and match
                                          (string-to-int
                                           (match-string 2
                                                         www-proxy-host-string)))
                                     80))
                (cond (www-proxy-host
                       (setq headers 
                             (cond ((stringp kom-www-proxy-headers)
                                    (list kom-www-proxy-headers))
                                   ((and (listp kom-www-proxy-headers)
                                         (stringp (car kom-www-proxy-headers)))
                                    kom-www-proxy-headers)
                                   ((and (listp kom-www-proxy-headers)
                                         (consp (car kom-www-proxy-headers)))
                                    (cdr (or (lyskom-string-assoc www-proxy-host
                                                                  kom-www-proxy-headers)
                                             (assq t kom-www-proxy-headers))))))
                       (setq proc (lyskom-open-network-stream name buffer
                                                              www-proxy-host
                                                              www-proxy-port))
                       ;; We do explicit coding
                       (set-process-coding-system proc 'no-conversion 'no-conversion)

		       ;; Install our filter.
		       ;; Do this before we send the CONNECT command to
		       ;; the proxy, in case the proxy answers fast.
		       (setq lyskom-www-proxy-connect-phase 1)
		       (set-process-filter proc
					   'lyskom-www-proxy-connect-filter)
		       (process-kill-without-query proc nil)

                       (lyskom-process-send-string 
                        proc
                        (format "CONNECT %s:%d HTTP/1.0\r\n"
                                host port))

                       (mapcar (lambda (header)
                                 (lyskom-process-send-string proc header)
                                 (lyskom-process-send-string proc "\r\n"))
                               headers)
                       (lyskom-process-send-string proc "\r\n")


		       ;; Now wait for the answer from the proxy
		       ;;
		       ;; This is because anything we send before the
		       ;; connection ack will be thrown away by the proxy
		       ;; so it is bad to try to start talking with the
		       ;; server before the connection is up.
		       (while (eq 'lyskom-www-proxy-connect-filter
				  (process-filter proc))
			 (accept-process-output proc))
		       ;; Now the proxy has connected to the kom server
		       )
                      (t (setq proc (lyskom-open-network-stream name buffer
                                                                host port))
                         ;; We do explicit coding
                         (set-process-coding-system proc 'no-conversion 'no-conversion))))
	      (switch-to-buffer buffer)
	      (lyskom-mode)		;Clearing lyskom-default...
	      (setq lyskom-buffer buffer)
	      (setq lyskom-default-user-name username)
	      (setq lyskom-default-password password)
	      (setq lyskom-server-name host)
	      (setq lyskom-server-port port)
	      (setq lyskom-proc proc)
	      (lyskom-setup-faces)
	      (lyskom-insert
	       (lyskom-format 'try-connect lyskom-clientversion host))
	      (set-process-filter proc 'lyskom-connect-filter)
              (process-kill-without-query proc nil)
	      (lyskom-process-send-string
	       proc
	       (concat "A"
		       (lyskom-format-objects
			(concat (user-login-name)
				"%" (system-name)))
                       "\n"))
	      (while (eq 'lyskom-connect-filter (process-filter proc))
		(accept-process-output proc))
	      ;; Now we have got the correct response.
	      (set-process-sentinel proc 'lyskom-sentinel)

	      (save-excursion
		(lyskom-init-parse buffer))

              ;; Async messages
              (lyskom-accept-async)

	      ;; +++PREFETCH+++
	      (lyskom-setup-prefetch)

	      ;; Tell the server who we are
	      (initiate-set-client-version 'background nil
					   "lyskom.el" lyskom-clientversion)

              (setq lyskom-server-version-info (blocking-do 'get-version-info))
              (when (or (null lyskom-server-version-info)
                        (<= (version-info->protocol-version 
                             lyskom-server-version-info) 7))
                (lyskom-error 'too-old-server))
	      (lyskom-setup-client-for-server-version)

	      (setq lyskom-server-info (blocking-do 'get-server-info))
	      (lyskom-format-insert 
	       'connection-done
	       (version-info->software-version lyskom-server-version-info))

              (when (lyskom-have-call 85)
                (setq lyskom-collate-table (blocking-do 'get-collate-table))
                (setq lyskom-char-classes nil)
                (lyskom-update-command-completion))
	      (if (not (zerop (server-info->motd-of-lyskom
			       lyskom-server-info)))
		  (blocking-do-multiple ((text (get-text 
                                                (server-info->motd-of-lyskom
                                                 lyskom-server-info)))
                                         (text-stat (get-text-stat
                                                     (server-info->motd-of-lyskom
                                                      lyskom-server-info))))
		    (lyskom-format-insert "%#1t\n"
		     (if (and text text-stat)
			 (text->decoded-text-mass text text-stat)
		       (lyskom-get-string 'lyskom-motd-was-garbed))
                     (when kom-highlight-text-body
                       '(face kom-text-body-face)))))

	      ;; Can't use lyskom-end-of-command here.
	      (setq lyskom-executing-command nil)
	      ;; Log in
	      (kom-start-anew t session-priority invisiblep)
	      (if (memq lyskom-buffer lyskom-buffer-list)
		  (while (not (eq lyskom-buffer (car lyskom-buffer-list)))
		    (setq lyskom-buffer-list
			  (nconc (cdr lyskom-buffer-list)
				 (list (car lyskom-buffer-list)))))
		(setq lyskom-buffer-list
		      (cons lyskom-buffer lyskom-buffer-list)))
              ;; We're done
	      (setq init-done t)
              )
	  ;; Something went wrong. Lets cleanup everything. :->
	  (if init-done
	      nil
	    (if proc (delete-process proc))
	    (unless reused-buffer (kill-buffer buffer))))))))


(defun lyskom-accept-async ()
  (blocking-do 'accept-async '(5 7 8 9 11 12 13 14 15 16 17 18))
  (let* ((ans (blocking-do 'query-async)))
    (unless (memq 15 (listify-vector ans))
      (blocking-do 'accept-async '(0 5 7 8 9 11 12 13 14 16 17 18)))))


(defun lyskom-www-proxy-connect-filter (proc output)
  "Receive connection acknowledgement from proxy."
  (if lyskom-debug-communications-to-buffer
      (lyskom-debug-insert proc "-----> " output))
  (cond
   ((and (= lyskom-www-proxy-connect-phase 1)
	 (string-match "^HTTP/1\\.. 200.*\r\n" output))
    (setq lyskom-www-proxy-connect-phase 2)
    ;; safety check: see if the empty line is already in this output
    (lyskom-www-proxy-connect-filter proc output))

   ((and (= lyskom-www-proxy-connect-phase 2)
	 (string-match "^\r\n" output))
    (set-process-filter proc 'lyskom-connect-filter))))

(defun lyskom-open-network-stream (name buffer host service)
  (let ((relay (lyskom-setup-ssh-relay host service buffer)))
    (if relay
        (open-network-stream name
                             buffer
                             "127.0.0.1"
                             (get relay 'relay-port))
    (open-network-stream name
                         buffer
                         host
                         service))))


(defun lyskom-setup-ssh-relay (server port kom-buffer)
  (when kom-ssh-relay-host
    (let* ((procname (format "ssh<%s:%s:%d>" kom-ssh-relay-host server port))
           (bufname (concat " *" procname "*"))
           (proc (get-process procname))
           (procsym (intern procname))
           (relay-port (and proc
                            (eq (process-status proc) 'run)
                            (get procsym 'relay-port)))
           (msg nil))
      (unwind-protect
          (save-excursion
            (set-buffer (get-buffer-create bufname))
            (if relay-port
                (lyskom-message 
                 "%s" 
                 (lyskom-format (setq msg 'using-ssh-connection)
                                kom-ssh-relay-host))
              (when proc (delete-process proc))
              (setq relay-port (+ 10000 (random 20000)))
              (put procsym 'relay-host 
                   (if (string-match "@" kom-ssh-relay-host)
                       (substring kom-ssh-relay-host (1+ (match-beginning 0)))
                     kom-ssh-relay-host))
              (put procsym 'relay-port relay-port)
              (put procsym 'num-connected 0)
              (lyskom-message
               "%s"
               (lyskom-format (setq msg 'opening-ssh-connection)
                              kom-ssh-relay-host))
              (goto-char (point-max))
              (insert "\n--- new connection ---\n")
              (let ((old-lc-all (getenv "LC_ALL")))
                (unwind-protect
                    (progn
                      (setenv "LC_ALL" "C")
                      (setq proc (start-process
                                  procname
                                  bufname
                                  "ssh" "-n" "-x"
                                  "-L" (format "%d:%s:%d" relay-port server port)
                                  kom-ssh-relay-host
                                  "sh -c \"while :; do echo ok; sleep 600; done\"")))
                  (setenv "LC_ALL" old-lc-all)))
              (process-kill-without-query proc))
            (while (progn
                     (goto-char (point-max))
                     (re-search-backward "^--- .* ---$" nil t)
                     (not (re-search-forward "^ok$" nil t)))
              (when (re-search-forward "\\<\\(Enter passphrase.*$\\|^.*password.*$\\)\\|refused\\|disconnect\\|denied\\|error\\|key not found\\>" nil t)
                (cond ((match-string 1)
                       (process-send-string 
                        proc
                        (concat (silent-read (match-string 1)) "\n"))
                       (delete-region (match-beginning 0) 
                                      (match-end 0)))
                      (t (error (lyskom-get-string 'ssh-cant-connect)
                                (buffer-substring-no-properties
                                 (progn (beginning-of-line) (point))
                                 (progn (skip-chars-forward "^\n\r")
                                        (point)))))))
              (sleep-for 0.5))
            (setq proc nil)
            (lyskom-message 
             "%s"
             (lyskom-format (concat 
                             (lyskom-format msg kom-ssh-relay-host)
                             (lyskom-get-string 'done)))))
        (if proc (delete-process proc)))

      (save-excursion 
        (set-buffer kom-buffer)
        (put procsym 'num-connected (1+ (or (get procsym 'num-connected) 0)))
        (make-local-variable 'lyskom-ssh-proxy)
        (setq lyskom-ssh-proxy procsym))
      )))


(defun lyskom-setup-client-for-server-version ()
  "Setup flags according to protocol versions."
  (lyskom-clear-features)
  (let ((protocol-version 
         (version-info->protocol-version lyskom-server-version-info)))

  (when (>= protocol-version 10)
    (lyskom-set-feature bcc-misc t)
    (lyskom-set-feature aux-items t)
    (lyskom-set-feature highest-call 105)
    (lyskom-set-feature local-to-global t))

  (when (>= protocol-version 9)
    (lyskom-set-feature dynamic-session-info t)
    (lyskom-set-feature idle-time t))

  (when (>= protocol-version 8)
    (lyskom-set-feature long-conf-types t))))


(defun lyskom-connect-filter (proc output)
  "Receive connection acknowledgement from server."
  (if lyskom-debug-communications-to-buffer
      (lyskom-debug-insert proc "-----> " output))
  (cond
   ((string-match "^LysKOM\n" output)
    (set-process-filter proc 'lyskom-filter))))





;;; ================================================================
;;;                        Start anew


(defun kom-start-anew (&optional lyskom-first-time-around session-priority invisiblep)
  "Start/login as a new person. If INVISIBLEP is not nil, the login will not be
shown to other users."
  (interactive)
  (lyskom-start-of-command 'kom-start-anew)
  (lyskom-completing-clear-cache)
  (let ((new-me nil)
	(login-successful nil)
        (ignored-user-area-vars nil))
    (unwind-protect
        (progn
          (if lyskom-first-time-around
              nil
            (lyskom-tell-internat 'kom-tell-login))
          ;; We can't allow the prefetch to go on after the new user
          ;; is logged in, but to shut down the prefetch would be too
          ;; brutal, since the new login might be cancelled. To
          ;; prevent the blocking-do calls below from allowing
          ;; prefetch we set lyskom-inhibit-prefetch locally.
          (let ((lyskom-inhibit-prefetch t))
            (while (not new-me)

              (if (and lyskom-first-time-around
                       lyskom-default-user-name)
                  ;; This is nil if we can't find a unique match.
                  (setq new-me
                        (conf-z-info->conf-no
                         (lyskom-lookup-conf-by-name lyskom-default-user-name
                                                     '(pers)))))
              (if new-me
                  nil
                (let ((name nil))
                  (while (or (null name)
                             (string= name ""))
                    (setq name (lyskom-read-conf-name
                                (lyskom-get-string 'what-is-your-name) 
                                '(pers none) t "" t)))
                  (setq new-me
                        (or (conf-z-info->conf-no 
                             (lyskom-lookup-conf-by-name name '(pers)))
                            (lyskom-create-new-person name)))))
              ;; Now new-me contains a number of a person.
              ;; Lets log him in.
              (if new-me
                  (let ((conf-stat (blocking-do 'get-conf-stat new-me))
                        (lyskom-inhibit-minibuffer-messages t))

                    ;; Previously this code used lyskom-pers-no
                    ;; directly instead of new-me, but that caused
                    ;; problem with asynchrounous code trying to
                    ;; access it.
                    ;;
                    ;; Setting lyskom-pers-no fscks up other things
                    ;; if we do keyboard-quit in the middle, so don't.
                    ;;
                    ;; (setq lyskom-pers-no new-me)

                    ;; DEBUG
                    (if (null conf-stat)
                        (lyskom-insert "You don't exist. Go away.\n"))

                    (lyskom-insert (concat (conf-stat->name conf-stat) "\n"))
                    (setq lyskom-first-time-around nil)
                    (if (blocking-do 'login new-me
                                     (if lyskom-default-password
                                         (prog1
                                             lyskom-default-password
                                           (setq lyskom-default-password nil)
                                           (set-default 'lyskom-default-password
                                                        nil))
                                       ;; Use password read when creating
                                       ;; the person when loggin in new
                                       ;; users
                                       (or lyskom-is-new-user
                                           (silent-read
                                            (lyskom-get-string 'password))))
                                     (if invisiblep 1 0))
                        (progn
                          (if lyskom-is-new-user
                              (blocking-do 'add-member
                                           (server-info->conf-pres-conf lyskom-server-info)
                                           new-me
                                           100 
                                           1
                                           (lyskom-create-membership-type
                                            nil nil nil nil nil nil nil nil)))
                          (setq login-successful t))
                      (lyskom-insert-string 'wrong-password)
                      (when (lyskom-get-aux-item 
                             (server-info->aux-item-list lyskom-server-info)
                             13)        ; e-mail
                        (lyskom-insert 'wrong-password-help)
                        (mapcar (lambda (el)
                                  (lyskom-format-insert 'wrong-password-email
                                                        (aux-item->data el)))
                                (lyskom-get-aux-item 
                                 (server-info->aux-item-list lyskom-server-info)
                                 13)    ; e-mail
                                ))
                      (setq new-me nil))
                    (setq lyskom-is-new-user nil))))

            ;; Now we are logged in.
            (setq lyskom-pers-no new-me)
            (lyskom-insert-string 'are-logged-in)

            (unless lyskom-is-running-compiled
              (lyskom-insert-string 'warning-about-uncompiled-client))

            (unless lyskom-dont-read-user-area
              (setq ignored-user-area-vars (lyskom-read-options)))
            (when (or session-priority kom-default-session-priority)
              (setq lyskom-session-priority
                    (or session-priority kom-default-session-priority)))
            (lyskom-run-hook-with-args 'lyskom-change-conf-hook
                                       lyskom-current-conf
                                       0)
            (lyskom-run-hook-with-args 'kom-change-conf-hook
                                       lyskom-current-conf
                                       0)
            (setq lyskom-current-conf 0)
            ;; (cache-initiate-who-info-buffer (blocking-do 'who-is-on))
            (cache-set-marked-texts (blocking-do 'get-marks))
            ;; What is this variable? It is never used. It is ust to
            ;; fill the cache?
            (let ((lyskom-who-am-i (blocking-do 'who-am-i)))
              (if lyskom-who-am-i (setq lyskom-session-no lyskom-who-am-i))))

          ;; If login succeeded, clear the caches and set the language

          (when login-successful
            (progn (clear-all-caches)
                   (unless (eq lyskom-language kom-default-language)   
                     (when (lyskom-set-language kom-default-language 'local)
                       (unless lyskom-have-one-login
                         (lyskom-set-language kom-default-language 'global)
                         (lyskom-maybe-setq-default kom-default-language kom-default-language)
                         (setq-default lyskom-language kom-default-language))
                       (lyskom-format-insert-before-prompt
                        'language-set-to
                        (lyskom-language-name kom-default-language))))
                   (setq lyskom-have-one-login t)))

          (when ignored-user-area-vars
            (lyskom-format-insert-before-prompt
             'ignored-user-area-var
             (mapconcat 'symbol-name 
                        ignored-user-area-vars
                        "\n    ")))

          ;; Show motd and encourage writing a presentation

          (let ((conf-stat (blocking-do 'get-conf-stat lyskom-pers-no)))
            (if (and conf-stat
                     (/= (conf-stat->msg-of-day conf-stat) 0))
                (progn
                  (lyskom-insert-string 'you-have-motd)
                  (lyskom-view-text (conf-stat->msg-of-day conf-stat))))
            (if (and conf-stat
                     (zerop (conf-stat->presentation conf-stat))
                     (not (zerop (conf-stat->no-of-texts conf-stat))))
                (lyskom-insert-string 'presentation-encouragement)))

          (setq lyskom-is-new-user nil)

          ;; Start the prefetch and update some basic caches
          (lyskom-refetch))
      (lyskom-end-of-command)))

  ;; Run the hook kom-login-hook. We don't want to hang the
  ;; login, just because something crashed here.

  (condition-case err
      (progn
        (run-hooks 'lyskom-login-hook)
        (run-hooks 'kom-login-hook))
    (error (lyskom-format-insert-before-prompt
            'error-in-login-hook (format "%s" err)))))


(defun lyskom-refetch ()
  "Resets and fetches all reading info.
This is called at login and after prioritize and set-unread."
  ;; +++PREFETCH+++

  ;; The whole membership!
  ;; (lyskom-set-membership (blocking-do 'get-membership lyskom-pers-no))
  ;; (setq lyskom-membership-is-read t)
  ;; (setq lyskom-unread-confs (blocking-do 'get-unread-confs lyskom-pers-no))

  (setq lyskom-membership nil)

  (setq lyskom-to-do-list (lyskom-create-read-list))
  (setq lyskom-reading-list (lyskom-create-read-list))


  (lyskom-reset-prefetch)
  (let ((lyskom-inhibit-prefetch t))
    (lyskom-prefetch-membership lyskom-pers-no)
    (let ((unreads (blocking-do 'get-unread-confs lyskom-pers-no)))
      (lyskom-traverse conf-no (nreverse (conf-no-list->conf-nos unreads))
        (lyskom-prefetch-one-membership conf-no lyskom-pers-no))))
  (lyskom-start-prefetch)

  (condition-case nil
      (progn (lyskom-update-read-faqs)
             (lyskom-clean-read-faqs lyskom-pers-no)
             (lyskom-update-rejected-recommendations)
             (lyskom-startup-check-faqs)
             (lyskom-startup-check-recommended-memberships))
    (error nil)
    (quit nil)))


(defun lyskom-set-membership (membership)
  "Sets lyskom-membership to a new value.
Args: MEMBERSHIP."
  (setq lyskom-membership (listify-vector membership))
  (lyskom-sort-membership)
  (setq lyskom-membership-is-read t))


(defun lyskom-print-name (conf-stat)
  "Print the name of the CONF-STAT, with a trailing \n."
  (lyskom-insert (concat (conf-stat->name conf-stat) "\n")))


(defun lyskom-extract-persons (conf-list)
  "Extract persons from a conf-list.
Return a list of pers-nos of all conferences that are persons.
Args: CONF-LIST."
  (lyskom-do-extract-persons-or-confs conf-list t))


(defun lyskom-extract-confs (conf-list)
  "Extract conferences from a conf-list.
Return a list of conf-nos of all conferences that are persons.
Args: CONF-LIST."
  (lyskom-do-extract-persons-or-confs conf-list nil))


(defun lyskom-do-extract-persons-or-confs (conf-list want-persons)
  "Extract persons or conferences from CONF-LIST.
WANT-PERSONS is t for persons, nil for confs."
  (let* ((result nil)
	 (i 0)
	 (nos (conf-list->conf-nos conf-list))
	 (types (conf-list->conf-types conf-list))
	 (len (length nos)))
    (while (< i len)
      (cond
       ((eq (conf-type->letterbox (elt types i))
	    want-persons)
	(setq result (cons (elt nos i)
			   result))))
      (++ i))
    (nreverse result)))


(defun lyskom-create-new-person (name)
  "A new user named NAME (or an old that mis-spelled his name)."
  (lyskom-insert
   (lyskom-format 'first-greeting name))
  (lyskom-scroll)
  (cond
   ((ja-or-nej-p (lyskom-format 'is-name-correct name))
    (let ((password (silent-read (lyskom-get-string 'personal-password))))
      (cond
       ((not (equal password 
		    (silent-read (lyskom-get-string 'repeat-password))))
	;; Failed to enter the same password twice
	(lyskom-insert-string 'repeat-failure)
	nil)
       (t
	;; Entered the same password twice
	(let ((new-person (blocking-do 'create-person name
                                       password
                                       (lyskom-create-flags nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil
                                                            nil)
                                       nil)))
	  (if (null new-person)
	      (lyskom-insert-string 'could-not-create-you)
	    ;; Raise a flag so the user will be added to the
	    ;; presentation conference after login
	    (setq lyskom-is-new-user password))
	  new-person)))))
   (t
    ;; Do not create a new person
    nil)))


;;(defun lyskom-start-anew-create-handler (pers-no name password)
;;  "A new person has been created. Log in as him."
;;  (cond
;;   ((null pers-no)
;;    (lyskom-insert-string 'could-not-create-you)
;;    (setq lyskom-executing-command nil)
;;    (kom-start-anew))
;;   (t
;;    (initiate-login 'main 'lyskom-add-for-new-person
;;		    pers-no password pers-no lyskom-pers-no)
;;    )))

;;(defun lyskom-add-for-new-person (reply pers-no lyskom-pers-no)
;;  "Add a news person as member in the default presentation conference."
;;  (initiate-add-member 'main 'lyskom-start-anew-login-2
;;		       (server-info->conf-pres-conf lyskom-server-info)
;;		       pers-no 100 1
;;		       pers-no lyskom-pers-no))


(defun lyskom-read-server-name (prompt)
  "Read the name of a LysKOM server.
Copmpletion is done on the servers i kom-server-aliases. If an
alias name is entered, the corresponding address is returned."
  ;; Create a completion table like
  ;; (("kom.lysator.liu.se" . "kom.lysator.liu.se")
  ;;  ("LysKOM" . "kom.lysator.liu.se"))
  (let ((known-servers
	 (append (mapcar (function (lambda (pair)
				     (cons (car pair) (car pair))))
			 kom-server-aliases)
		 (mapcar (function (lambda (pair)
				     (cons (cdr pair) (car pair))))
			 kom-server-aliases)))
	(completion-ignore-case t)
	server)
    (setq server (lyskom-completing-read prompt
                                         (lyskom-maybe-frob-completion-table
                                          known-servers)
                                         nil nil))
    (or (cdr (lyskom-string-assoc server known-servers))
	server)))
      

;;; ================================================================
;;;                        The LysKOM mode.

;; The LysKOM mode should not be inherited if we create a new buffer
;; and default-major-mode is nil.
(put 'lyskom-mode 'mode-class 'special)

(defun lyskom-mode ()
  "\\<lyskom-mode-map>Mode for LysKOM client.
Commands:
\\[kom-next-command]	Do the default action. This can be to read the next text,select
	next conference with unread texts or whatever the prompt says.
\\[kom-go-to-conf]	Go to a conference. LysKOM will ask you for a conference
	and make you a member of it if you are not already.
\\[kom-list-conferences]	List conferences matching a given string.
\\[kom-list-persons]	List persons matching a given string.

\\[kom-list-news]	List the conferences you have unread texts in.
\\[kom-go-to-next-conf]	Go to the next conference with unread texts.

\\[kom-membership]	Display a buffer with the list of conferences you are member in.

\\[kom-quit]	Leave this LysKOM session.
\\[kom-who-is-on]	Show a list of all the users of lyskom right now.

\\[kom-extended-command]	Read a command using the minibuffer and execute it.
	This is another way to give commands.

\\[kom-write-text]	Start writing a new text.
\\[kom-write-comment]	Start writing a comment to the last read article.
\\[kom-private-answer]	Start writing a personal answer to the author of the last
	read article.
\\[kom-send-letter]	Start writing a letter to a person or conference.

\\[kom-page-next-command]	Clear the page and do what \\[kom-next-command] does.
\\[kom-line-next-command]	Do what \\[kom-next-command] does, but scroll at most 1 line.

0 .. 9	Give a numeric argument to the next command.
\\[describe-mode]	Display this help text.

\\[kom-busy-wait]	Put the lyskom-session in wait mode. The next created text with 
	a priority higher than that of the next conference you are going
	to will be read directly when it is created.
\\[kom-set-unread]	Mark a number of texts as unread.
\\[kom-jump]	Skip (mark as read) all the comments to this article recursively.
\\[kom-display-time]	Show the current date and time.

\\[kom-change-presentation]	Change your presentation.
\\[kom-view]	View the specified text.
\\[kom-view-commented-text]	View the text that the current text comments or is a footnote to.
\\[kom-review-presentation]	Show the presentation for a person or a conferencce.

\\[kom-review-comments]	View all comments to the current text.
\\[kom-review-tree]	View all comments to the current text and step through the tree
	in depth-first order.

\\[kom-find-root-review]	View the complete comment tree.
\\[kom-find-root]	Show the root text of this comment tree.
\\[kom-review-by-to]	View the last (first or all) article written by named author
	in a named conference.

\\[kom-mark-text]	Create a mark on a text.
\\[kom-unmark-text]	Remove the mark on a text.
\\[kom-review-marked-texts]	View all text marked with a certain mark.
\\[kom-review-all-marked-texts]	View all marked text.

\\[kom-view-next-new-text]	Read the next text from the list of unread.
\\[kom-review-next]	Continue the viewing.
\\[kom-review-stack]	Show the stack of things we are viewing.
\\[kom-review-clear]	Clear the stack of things we are viewing.
\\[kom-review-backward]	Toggles the read order of reviewed texts. This can only be done
	when viewing texts with \\[kom-review-by-to], \\[kom-review-marked-texts] and \\[kom-review-all-marked-texts].

\\[kom-status-conf]	Show the status of a conference.
\\[kom-status-person]	Show the status of a person
\\[kom-save-text]	Save the text you are looking at to a file.

\\[kom-get-abuse]	Get an insulting text.
\\[kom-get-appreciation]	Get an encouraging text.

\\[kom-add-self]	Become a member of a conference.
\\[kom-sub-self]	Removes you as a member of a conference.

All bindings (this is here due to the fact that inconsistensies while 
developping this package are frequent):
\\{lyskom-mode-map}
Entry to this mode runs lyskom-mode-hook.

Functions and variables beginning with kom- are intended for the user to see,
set or call.
Functions and variables beginning with lyskom- are not intended for the user
to see, set of call."
  (interactive)
  (lyskom-clear-vars)
  (setq mode-line-buffer-identification
	(list (concat (lyskom-mode-name-from-host) ": ") 'mode-line-conf-name))

  (setq major-mode 'lyskom-mode)
  (setq mode-name "LysKOM")
  (setq mode-line-process (lyskom-get-string 'mode-line-working))
  (use-local-map lyskom-mode-map)
  (lyskom-set-menus 'lyskom-mode lyskom-mode-map)
  (run-hooks 'lyskom-mode-hook)

  (buffer-disable-undo (current-buffer))
  (setq buffer-read-only t))

(defun lyskom-clear-vars ()
  "Set up buffer-local vars."
  (lyskom-save-variables (lyskom-proc
                          lyskom-pers-no
                          lyskom-membership
                          lyskom-membership-is-read
                          lyskom-last-viewed
                          lyskom-unparsed-buffer
                          lyskom-unparsed-marker
                          lyskom-server-info
                          lyskom-server-name)
      (kill-all-local-variables))
    (lyskom-setup-local-variables)
    (setq lyskom-do-when-done (cons kom-do-when-done kom-do-when-done))
    (setq lyskom-output-queues (make-vector 10 nil))
    (setq lyskom-collate-table lyskom-default-collate-table)
    (setq lyskom-char-classes nil)
    (let ((i 0))
      (while (< i 10)
        (aset lyskom-output-queues i (lyskom-queue-create))
        (setq i (1+ i))))
    (setq lyskom-pending-calls nil)
    (lyskom-set-mode-line
     (lyskom-get-string 'not-present-anywhere)))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: reading.el,v 44.14 2002/02/24 20:23:27 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: reading.el
;;;;
;;;; This file contains functions that manage membership and reading
;;;; lists, namely lyskom-membersip lyskom-reading-list and
;;;; lyskom-to-do-list. These are called both from prefetch and from
;;;; startup procedures.
;;;; 

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: reading.el,v 44.14 2002/02/24 20:23:27 joel Exp $\n"))


(defun lyskom-enter-map-in-to-do-list (map conf-stat membership)
  "Takes a MAP and enters all its listed text-nos in the conference CONF-STAT.
This works by modifying the lyskom-to-do-list which in some cases
also means modifying the lyskom-reading-list. The zero text-nos are skipped."
  (let ((list (lyskom-list-unread map membership))
        (mship (lyskom-try-get-membership (conf-stat->conf-no conf-stat))))
    (when (and list mship)
      (read-list-enter-read-info
       (lyskom-create-read-info 
	'CONF conf-stat
	(membership->priority 
	 (lyskom-try-get-membership (conf-stat->conf-no conf-stat)))
	(lyskom-create-text-list
	 list))
       lyskom-to-do-list))))


(defun lyskom-sort-membership ()
  "Sort the internal membership list."
  (setq lyskom-membership (sort lyskom-membership 'lyskom-membership-<))
  (lyskom-update-membership-positions))

(defun lyskom-update-membership-positions ()
  "Update all the position fields in the memberships in the membership list."
  (let ((mship lyskom-membership)
        (num 0))
    (while mship 
      (set-membership->position (car mship) num)
      (setq num (1+ num) mship (cdr mship)))
  ;; FIXME: If something changed, tell the server.
    (lyskom-sort-to-do-list)))

(defun lyskom-add-memberships-to-membership (memberships)
  "Adds a newly fetched MEMBERSHIP-PART to the list in lyskom-membership.
If an item of the membership is already read and entered in the
lyskom-membership list then this item is not entered."
  (save-excursion
    (set-buffer lyskom-buffer)
    (let ((list (listify-vector memberships)))
      (while list
        ;; If membership is already added or passive, don't add it
        (if (memq (membership->conf-no (car list))
                  (mapcar (function membership->conf-no) lyskom-membership))
            nil
          (setq lyskom-membership (append lyskom-membership (list (car list)))))
        (setq list (cdr list))))))

(defun lyskom-insert-memberships-in-membership (memberships)
  (save-excursion
    (set-buffer lyskom-buffer)
    (let ((list (listify-vector memberships)))
      (while list
        ;; If membership is already added or passive, don't add it
        (if (memq (membership->conf-no (car list))
                  (mapcar (function membership->conf-no) lyskom-membership))
            nil
          (setq lyskom-membership (cons (car list) lyskom-membership)))
        (setq list (cdr list))))
    (lyskom-sort-membership)))


(defun lyskom-do-insert-membership (membership)
  (if (membership->position membership)
      (setq lyskom-membership
            (cond ((elt lyskom-membership (membership->position membership))
                   (lyskom-insert-in-list 
                    membership
                    lyskom-membership
                    (elt lyskom-membership
                         (membership->position membership))))
                  ((>= (membership->position membership) 0)
                   (nconc lyskom-membership (list membership)))
                  (t (cons membership lyskom-membership))))
    (let ((mship-list lyskom-membership)
          (found nil))
      (while mship-list
        (when (<= (membership->priority (car mship-list))
                  (membership->priority membership))
          (setq lyskom-membership
                (lyskom-insert-in-list membership
                                       lyskom-membership
                                       (car mship-list))
                mship-list nil
                found t))
        (setq mship-list (cdr mship-list)))
      (unless found (setq lyskom-membership
                          (nconc lyskom-membership (list membership)))))))

(defun lyskom-insert-membership (membership)
  "Add MEMBERSHIP into lyskom-membership, sorted by priority."
  (save-excursion
    (set-buffer lyskom-buffer)
    (lyskom-do-insert-membership membership)
    (lyskom-update-membership-positions)))

(defun lyskom-replace-membership (membership)
  "Find the membership for the same conference as MEMBERSHIP, and
replace it with MEMBERSHIP into lyskom-membership."
  (save-excursion
    (set-buffer lyskom-buffer)
    (when (lyskom-try-get-membership (membership->conf-no membership) t)
      (lyskom-do-remove-membership (membership->conf-no membership))
      (lyskom-do-insert-membership membership)
      (lyskom-run-hook-with-args 'lyskom-replace-membership-hook
                                 membership
                                 lyskom-membership))))

(defun lyskom-do-remove-membership (conf-no)
  "Remove the membership for CONF-NO from lyskom-membership."
  (let ((list lyskom-membership))
    (while list
      (if (= conf-no (membership->conf-no (car list)))
	  (progn
	    (setcar list nil)
	    (setq list nil))
	(setq list (cdr list)))))
  (setq lyskom-membership (delq nil lyskom-membership)))

(defun lyskom-remove-membership (conf-no)
  "Remove the membership for CONF-NO from lyskom-membership."
  (save-excursion
    (set-buffer lyskom-buffer)
    (lyskom-do-remove-membership conf-no)
    (lyskom-run-hook-with-args 'lyskom-remove-membership-hook
                               conf-no lyskom-membership)))
  
(defun lyskom-membership-position (conf-no)
  "Return the position of the membership for CONF-NO."
  (save-excursion
    (set-buffer lyskom-buffer)
    (let ((mship (lyskom-get-membership conf-no t)))
      (or (membership->position mship)
          (- (length (memq mship lyskom-membership))
             (length lyskom-membership))))))


(defun lyskom-sort-to-do-list ()
  "Sort lyskom-to-do-list in order of membership priorities. 
The priorities for CONF elements are updated to match the membership
priorities. Elements that are not of type CONF appear first on the list
within their priority. This may not be totally accurate, but it's a
reasonable guess."
  (let ((todo (read-list->all-entries lyskom-to-do-list))
        (info nil))

    ;; Update the priorities in the read list

    (while todo
      (setq info (car todo))
      (setq todo (cdr todo))
      (when (eq (read-info->type info) 'CONF)
        (let ((mship 
               (lyskom-get-membership 
                (conf-stat->conf-no (read-info->conf-stat info)) t)))
          (when mship
            (set-read-info->priority info
                                     (membership->priority mship))))))

    ;; Sort the todo list

    (setq lyskom-to-do-list (cons 'READ-LIST
                                  (sort (read-list->all-entries lyskom-to-do-list)
                                        'lyskom-read-info-<)))
    (lyskom-update-prompt)))

(defun lyskom-read-info-< (a b)
  (cond ((< (read-info->priority a) (read-info->priority b)) nil)
        ((> (read-info->priority a) (read-info->priority b)) t)

        ;; Both are confs of equal priority; check position in mship
        ((and (eq (read-info->type a) 'CONF) 
              (eq (read-info->type b) 'CONF))
         (< (lyskom-membership-position 
             (conf-stat->conf-no (read-info->conf-stat a)))
            (lyskom-membership-position 
             (conf-stat->conf-no (read-info->conf-stat b)))))

        ;; A is a CONF and B is not; B is greater.
        ((eq (read-info->type a) 'CONF) nil)

        ;; Both are not CONF, so A is not less than B
        (t t)))
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: internal.el,v 44.9 2002/02/24 20:23:27 joel Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: internal.el
;;;;
;;;; Here are internal functions that handles the different kom-queue
;;;; calls. Add a call, apply the handler when a call is done.
;;;;
;;;; Originally written:    ceder
;;;; Completely rewritten:  Inge Wallin
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: internal.el,v 44.9 2002/02/24 20:23:27 joel Exp $\n"))


;;;; ================================================================
;;;;                          Variables.


(defvar lyskom-call-data nil
  "This is an assoc-list of data for the kom-queues.
Each element on the list has the following format:

(NAME . KOM-QUEUE)

NAME    is an atom, the name of the kom-queue.	A kom-queue is a way
        to send questions to the LysKOM server and deal with the replies 
        in a controlled way.

KOM-QUEUE is a kom-queue.")

(make-variable-buffer-local 'lyskom-call-data)


;;; ================================================================
;;;                   Data type kom-queue

;;;
;;; Each kom-queue consists of the following 4 fields:
;;;     PENDING -
;;;         a list where each element represents a call to a service on 
;;;         the server, or a call to lyskom-collect, lyskom-use or 
;;;         lyskom-run. The elements are lists. The first element on each 
;;;         list is a key to what it represents, as described below.
;;;     COLLECT-FLAG - 
;;;          t means this queue is collecting results for a future 
;;;          lyskom-use of lyskom-list-use. The results are collected
;;;          on collect-queue
;;;     COLLECT-QUEUE -
;;;          This is where the results described above are collected.
;;;     HALTED -
;;;          An integer counting the number of times this queue is halted.
;;;          A call to lyskom-halt increments this counter, a call to
;;;          lyskom-resume decrements it.
;;;
;;;
;;; The items on PENDING is one of the following:
;;;
;;; 	('CALL REF-NO PARSER PARSER-DATA HANDLER HANDLER-DATA)
;;; 		A call that has not yet returned.
;;; 
;;; 	('PARSED RESULT HANDLER HANDLER-DATA)
;;; 		A call that has returned, but the result can not be
;;; 		handled until all previous calls has returned.
;;; 
;;; 	('COLLECT)
;;; 		Marks the start of a sequence of results that will be
;;; 		handled by a multi-handler or multi-list-handler.
;;; 
;;; 	('COLLECT-IGNORE)
;;; 		Marks the start of a sequence of results that will be 
;;; 		handled by a multi-handler of multi-list-handler with
;;; 		errors stripped away.
;;; 
;;; 	('USE MULTI-HANDLER MULTI-HANDLER-DATA)
;;; 		Marks the end of a sequence. MULTI-HANDLER is called
;;; 		when all calls before this element have been handled.
;;; 		MULTI-HANDLER is a function whose first arguments are
;;; 		the results from calls between previous COLLECT and
;;; 		this USE.  MULTI-HANDLER-DATA is optional.  If it
;;; 		exists it is a list of more arguments to send to
;;; 		MULTI-HANDLER.
;;; 
;;; 	('LIST-USE MULTI-HANDLER MULTI-HANDLER-DATA)
;;; 		Marks the end of a sequence. MULTI-HANDLER is called
;;; 		when all calls before this element have been handled.
;;; 		MULTI-HANDLER is a function whose first argument is a
;;; 		list of all results from calls between previous
;;; 		COLLECT and this LIST-USE. MULTI-HANDLER-DATA is
;;; 		optional. If it exists it is a list of more arguments
;;; 		to send to MULTI-HANDLER.
;;; 
;;; 	('RUN FUNCTION FUNCTION-ARGS)
;;; 		Run FUNCTION when all calls before this have been handled.
;;; 


(defun kom-queue-create ()
  "Creates a new instance of an empty kom-queue."
  (vector (lyskom-queue-create)
	  nil
	  (lyskom-queue-create)
	  0))


(defun kom-queue->pending (queue)
  "Returns the pending field of the kom-queue QUEUE."
  (elt queue 0))


(defun kom-queue->collect-flag (queue)
  "Returns the collect-flag field of the kom-queue QUEUE."
  (elt queue 1))


(defun kom-queue->collect-queue (queue)
  "Returns the collect-queue field of the kom-queue QUEUE."
  (elt queue 2))


(defun set-kom-queue-collect-flag (queue new-val)
  "Set the collect-flag field of the kom-queue QUEUE to NEW-VAL."
  (aset queue 1 new-val))


(defun kom-queue-halt (queue)
  "Halts the kom-queue QUEUE."
  (aset queue 3 (1+ (elt queue 3))))


(defun kom-queue-resume (queue)
  "Resume execution on the kom-queue QUEUE."
  (if (eq (elt queue 3) 0)
      (signal 'lyskom-internal-error
	      (list "kom-queue-resume called on an unhalted queue: "
		    queue))
    (aset queue 3 (1- (elt queue 3)))))


(defun kom-queue-is-halted (queue)
  "Return t if the kom-queue QUEUE is halted at least once."
  (> (elt queue 3) 0))



;;; ================================================================
;;;               Entry points to this communication packet.


(defun lyskom-collect (kom-queue)
  "Collect the results of future calls via KOM-QUEUE.
The results of the calls will be available to the multi-handler.
See lyskom-use and lyskom-list-use."
  (lyskom-call-add kom-queue 'COLLECT))


(defun lyskom-collect-ignore-err (kom-queue)
  "Collect the result of future calls via KOM-QUEUE.
The result of the calls will be available to the multi-handler with the calls
producing errors stripped."
  (lyskom-call-add kom-queue 'COLLECT-IGNORE))


(defun lyskom-use (kom-queue multi-handler &rest multi-handler-data)
  "Use the previously collected results from calls to the server.
Args: KOM-QUEUE MULTI-HANDLER &rest MULTI-HANDLER-DATA

MULTI-HANDLER is a function that is called when all previous results
have been handled. MULTI-HANDLER-DATA is a list of additional
arguments the multi-handler wants.

See also lyskom-list-use."
  (lyskom-call-add kom-queue 'USE multi-handler multi-handler-data)
  (lyskom-check-call kom-queue))


(defun lyskom-list-use (kom-queue multi-handler &rest multi-handler-data)
  "Use the previously collected results from calls to the server.
Args: KOM-QUEUE MULTI-HANDLER &rest MULTI-HANDLER-DATA

MULTI-HANDLER is a function that is called when all previous
results have been handled. The first argument is a list of
the results. MULTI-HANDLER-DATA is a list of additional
arguments the multi-handler wants.

The difference between lyskom-use and lyskom-list-use is the way
the MULTI-HANDLER receives the data. lyskom-list-use sends them as
a list, lyskom-use as different parameters."
  (lyskom-call-add kom-queue 'LIST-USE multi-handler multi-handler-data)
  (lyskom-check-call kom-queue))


(defun lyskom-run (kom-queue function &rest function-args)
  "Call a function when all calls have been handled.
Args: KOM-QUEUE FUNCTION &rest FUNCTION-ARGS
Register a FUNCTION that shall be called with FUNCTION-ARGS when
all previous calls to the server via KOM-QUEUE have been handled."
  (lyskom-call-add kom-queue 'RUN function function-args)
  (lyskom-check-call kom-queue))


(defun lyskom-halt (queue-name)
  "Prohibit execution of handlers on QUEUE-NAME.
The execution will resume when (lyskom-resume KOM-QUEUE) is called."
  (let ((queue-pair (assq queue-name lyskom-call-data)))
    (if (null queue-pair)
	(setq queue-pair (lyskom-add-new-queue queue-name)))
    (kom-queue-halt (cdr queue-pair))))
    

(defun lyskom-resume (kom-queue)
  "Resume execution of waiting handlers on KOM-QUEUE.
See documentation for lyskom-halt."
  (let ((queue (assq kom-queue lyskom-call-data)))
    (cond
     ((null queue)			;A new kom-queue?
      (signal 'lyskom-internal-error
	      (list "lyskom-resume called on an unused queue:"
		    kom-queue)))
     ((kom-queue-is-halted (cdr queue)) ;A halted queue?
      (kom-queue-resume (cdr queue))    ;Resume execution on the queue.
      (lyskom-check-call kom-queue))	;Run any pending handlers.
     (t					;The queue was not halted. This
      (signal 'lyskom-internal-error	;is an error.
	      (list "lyskom-resume:"
		    kom-queue "(not halted)"))))))


(defun lyskom-call (kom-queue ref-no handler handler-data
			       parser &rest parser-data)
  "Add information about a call that has not yet returned to kom-queue.
Arguments: KOM-QUEUE REF-NO HANDLER HANDLER-DATA
	   PARSER &rest PARSER-DATA."
  (lyskom-call-add kom-queue 'CALL ref-no 
		   parser parser-data handler handler-data))

(defun lyskom-fake-call (kom-queue ref-no handler handler-data)
  "Add information about a call that will not return from the server,
but will be filled in by some other function."
  (lyskom-call-add kom-queue 'CALL ref-no
                   nil nil handler handler-data))

(defun lyskom-complete-call (kom-queue ref-no result)
  "Force a call placed on KOM-QUEUE with reference number REF-NO to return 
RESULT. This should only be used to complete calls placed on the queue using
lyskom-fake-call, or the parser might get confused."
  (let ((call-info (lyskom-locate-ref-no kom-queue ref-no)))
    (if call-info
        (progn
          (lyskom-tr-call-to-parsed call-info result)
          (lyskom-check-call kom-queue)))))


;;; This is used by z-initiate-get-map, which is not used.
;;; This was a temporary solution.

;;(defun lyskom-kom-queue-collect-p (queue-name)
;;  "Return t if the kom-queue QUEUE-NAME has an unmatched 'COLLECT item.
;;It is illegal to call lyskom-collect or lyskom-collect-ignore-err on
;;the kom-queue if and only if this function returns t."
;;  (let* ((queue (cdr-safe (assoc queue-name lyskom-call-data)))
;;	 (pending (lyskom-queue->all-entries (kom-queue->pending queue)))
;;	 (collect-flg nil)
;;	 (type nil))
;;    (while (and queue pending)
;;      (setq type (car (car pending)))
;;      (setq pending (cdr pending))
;;      (cond
;;       ((eq type 'COLLECT)
;;	(setq collect-flg t))
;;       ((eq type 'COLLECT-IGNORE)
;;	(setq collect-flg t))
;;       ((eq type 'USE)
;;	(setq collect-flg nil))
;;       ((eq type 'LIST-USE)
;;	(setq collect-flg nil))))
;;    collect-flg))


;;;; ================================================================
;;;;                     Internal functions.



(defun lyskom-add-new-queue (queue-name)
  "Add QUEUE-NAME to lyskom-call-data as an empty queue.
Return a dotted pair consisting of the QUEUE-NAME and the new queue."
  (let ((new-queue-list (list (cons queue-name (kom-queue-create)))))
    (if (null lyskom-call-data)
	(setq lyskom-call-data new-queue-list)
      (nconc lyskom-call-data new-queue-list))
    (car new-queue-list)))

(defun lyskom-set-queue-priority (queue-name priority)
  (put queue-name 'lyskom-queue-priority priority))

(defun lyskom-queue-priority (queue-name)
  (or (get queue-name 'lyskom-queue-priority)
      0))

(defun lyskom-call-add (queue-name type &rest data)
  "Add an entry to the kom-queue QUEUE-NAME. The entry is of type TYPE
and third argument DATA contains the rest of the necessary data."
  (let ((queue (assoc queue-name lyskom-call-data)))
    (if (null queue)
	(setq queue (lyskom-add-new-queue queue-name)))
    (lyskom-queue-enter (kom-queue->pending (cdr queue))
			(cons type data))))


(defun lyskom-send-packet (kom-queue string)
  "Send a packet to the server.
Add info on lyskom-pending-calls. Update lyskom-ref-no.
Args: KOM-QUEUE STRING."

  ;; Queue it
  (lyskom-queue-enter (aref lyskom-output-queues
			    (lyskom-queue-priority kom-queue))
		      (cons lyskom-ref-no string))
  (setq lyskom-pending-calls
	(cons (cons lyskom-ref-no kom-queue)
	      lyskom-pending-calls))
  (++ lyskom-ref-no)
  
  ;; Send something from the output queues
  (lyskom-check-output-queues))

(defun lyskom-check-output-queues ()
  "Check for pending calls to the server.
Send calls from queues with higher priority first, and make sure that at
most lyskom-max-pending-calls are sent to the server at the same time."
  (catch 'done
    (let ((i 9))
      (while (and lyskom-ok-to-send-new-calls
		  (< lyskom-number-of-pending-calls
		     lyskom-max-pending-calls))
	(while (lyskom-queue-isempty (aref lyskom-output-queues i))
	  (-- i)
	  (if (< i 0) (throw 'done nil)))
	(let ((entry (lyskom-queue-delete-first
		      (aref lyskom-output-queues i))))
	  (++ lyskom-number-of-pending-calls)
	  (lyskom-process-send-string
	   lyskom-proc
	   (concat (number-to-string (car entry)) (cdr entry) "\n")))))))

(defun lyskom-decrease-pending-calls ()
  "A reply has come.
Send a pending call or decrease lyskom-number-of-pending-calls."
  (-- lyskom-number-of-pending-calls)
  (if (< lyskom-number-of-pending-calls 0)
      (setq lyskom-number-of-pending-calls 0))
  (lyskom-check-output-queues))
	

(defun lyskom-process-send-string (process string)
  "Send PROCESS the contents of STRING.
STRING is split in several parts if the operating system can't deal
with big strings."
  (let ((tries 0))
  (while
      (condition-case err
	  (progn (lyskom-process-send-string-2 process string)
		 nil)
	(file-error
	 (if lyskom-debug-communications-to-buffer
	     (lyskom-debug-insert process "Error: " (format "%s" err))
;;;	     (save-excursion
;;;	       (set-buffer (get-buffer-create
;;;			    lyskom-debug-communications-to-buffer-buffer))
;;;	       (save-excursion
;;;		 (goto-char (point-max))
;;;		 (insert "\n" 
;;;			 (format "%s" process)
;;;			 (concat "Error: " (format "%s" err))))
;;;	       (set-buffer (process-buffer process)))
	   )
	 (cond
	  ((and (string= "writing to process" (car (cdr err)))
		(or (string= "message too long" (car (cdr (cdr err))))
		    (string= "no more processes" (car (cdr (cdr err)))))
		(> lyskom-max-packet-size 1))
	   ;; Seems to be impossible to write too long strings to TCP/IP.
	   ;; This happens on a Sequence Balance with packets longer than
	   ;; 2048 bytes. Decrease lyskom-max-packet-size and retry.
	   (setq lyskom-max-packet-size (/ lyskom-max-packet-size 2))
	   t)

	  ((and (string= "writing to process" (car (cdr err)))
		(string= "host is unreachable" (car (cdr (cdr err)))))
	   ;; The net is currently shaky. We try again in a while.
	   (lyskom-message "%s" (lyskom-format 'shaky-tcp
					       (make-string (++ tries) ?.)))
	   (sit-for 4)
	   (lyskom-message "%s" (lyskom-get-string 'retrying-tcp))
	   t)
	  
	  (t
	   ;; It was some unknown file-error. Pass it down.
	   (signal (car err) (cdr err)))))))))


(defun lyskom-process-send-string-2 (process string)
  "Send PROCESS the contents of STRING as input.
PROCESS may be a process name. At most lyskom-max-packet-size bytes
is sent with each packet. If STRING is longer it is splitted."
  (cond
   ((<= (length string) lyskom-max-packet-size)
    (process-send-string
     process
     (progn
       (if lyskom-debug-communications-to-buffer
	   (lyskom-debug-insert process "To " string))
       string)))
   (t
    (let ((i 0))
      (while (< i (length string))
	(process-send-string
	 process
	 (let ((string (substring string
				  i
				  (min (length string)
				       (+ i lyskom-max-packet-size)))))
	   (if lyskom-debug-communications-to-buffer
	       (save-excursion
		 (set-buffer (get-buffer-create 
			      lyskom-debug-communications-to-buffer-buffer))
		 (save-excursion
		   (goto-char (point-max))
		   (insert "\n"
                           "To " process ": "))
		 (set-buffer (process-buffer process))))
	   string))
	(setq i (+ i lyskom-max-packet-size)))))))


(defun lyskom-check-call (queue-name)
  "Check lyskom-call-data and call handlers, multi-handlers and functions.
Args: QUEUE-NAME.
HALTED -> stop
CALL -> stop
PARSED -> handle ->
       -> collect-flag? 'COLLECT -> add on temporary resultlist.
	 	        'COLLECT-IGNORE -> add on temporary resultlist if not 
			 		   error.
		        no  -> delete from lyskom-call-data.
COLLECT -> collect-flag? yes -> error!
			 no  -> set collect-flag.
COLLECT-IGNORE -> collect-flag? yes -> error!
				no -> set collect-flag.
USE ->      call handler. Delete previous parts.
LIST-USE -> call handler. Delete previous parts.
RUN ->      call function. Delete. Not allowed inside COLLECT/USE."
  (let* ((queue (cdr-safe (assoc queue-name lyskom-call-data)))
         (type nil)
         (first-pending (lyskom-queue->first (kom-queue->pending queue))))
    (while (and queue
                (not (or (kom-queue-is-halted queue)
                         (lyskom-queue-isempty (kom-queue->pending queue))
                         (eq (car first-pending) 'CALL))))
      (setq type (car first-pending))

      (cond

       ((eq type 'PARSED)
	(kom-queue-halt queue)
	(unwind-protect
	    (lyskom-apply-handler first-pending)
	  (kom-queue-resume queue))
        (if (or (eq (kom-queue->collect-flag queue) 'COLLECT)
                (and (eq (kom-queue->collect-flag queue) 'COLLECT-IGNORE)
                     (car (cdr first-pending))))
            (lyskom-queue-enter (kom-queue->collect-queue queue)
                                (car (cdr first-pending)))))

       ((eq type 'COLLECT)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call COLLECT."))
          (set-kom-queue-collect-flag queue 'COLLECT)
          (lyskom-queue-make-empty (kom-queue->collect-queue queue))))

       ((eq type 'COLLECT-IGNORE)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call COLLECT-IGNORE."))
          (set-kom-queue-collect-flag queue 'COLLECT-IGNORE)
          (lyskom-queue-make-empty (kom-queue->collect-queue queue))))

       ((eq type 'USE)
        (if (not (kom-queue->collect-flag queue))
            (signal 'lyskom-internal-error
                    '("lyskom-check-call USE.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-multi-handler
             first-pending (lyskom-queue->all-entries
                            (kom-queue->collect-queue queue)))
          (kom-queue-resume queue))
        (set-kom-queue-collect-flag queue nil))

       ((eq type 'LIST-USE)
        (if (not (kom-queue->collect-flag queue))
            (signal 'lyskom-internal-error
                    '("lyskom-check-call LIST-USE.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-multi-list-handler
             first-pending (lyskom-queue->all-entries
                            (kom-queue->collect-queue queue)))
          (kom-queue-resume queue))
        (set-kom-queue-collect-flag queue nil))

       ((eq type 'RUN)
        (if (kom-queue->collect-flag queue)
            (signal 'lyskom-internal-error
                    '("lyskom-check-call RUN.")))
        (kom-queue-halt queue)
        (unwind-protect
            (lyskom-apply-function first-pending)
          (kom-queue-resume queue)))
       
       (t (signal 'lyskom-internal-error
                  (list 'lyskom-check-call
                        "unknown key:"
                        (car first-pending)))))

      (lyskom-queue-delete-first (kom-queue->pending queue))
      (setq first-pending (lyskom-queue->first (kom-queue->pending queue))))))

;;; Quit is NOT ok to press while the handler is running. inhibit-quit
;;; should be t when these are called.
(defun lyskom-apply-handler (pending)
  "Apply a handler. Args: PENDING.
PENDING is an entry of the list as described in documentation for the variable
lyskom-call-data. The car on the list must be a PARSED:
	('PARSED RESULT HANDLER HANDLER-DATA)"
  (if (car (cdr (cdr pending)))
      (apply (car (cdr (cdr pending)))	;Handler
	     (car (cdr pending))	;Result
	     (car (cdr (cdr (cdr pending))))))) ;Handler-data

(defun lyskom-apply-multi-handler (pending result-list)
  "Apply a handler for a lyskom-collect - lyskom-use construct."
  (apply (car (cdr pending))		;Multi-handler
	 (nconc result-list
		(car (cdr (cdr pending)))))) ;Multi-handler-data


(defun lyskom-apply-multi-list-handler (pending result-list)
  "Apply a handler for a lyskom-collect - lyskom-list-use construct."
  (apply (car (cdr pending))		;Multi-handler
	 (cons result-list
	       (car (cdr (cdr pending)))))) ;Multi-handler-data
    
(defun lyskom-apply-function (pending)
  (setcar pending 'HALTED)
  (apply (car (cdr pending))	    ;Function.
	 (car (cdr (cdr pending)))))  ;Function-args.
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: services.el,v 44.34 2002/08/09 15:14:50 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; This file contains functions for sending requests to the server
;;;; and parsing the result.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: services.el,v 44.34 2002/08/09 15:14:50 byers Exp $\n"))


;;; ================================================================
;;; Macro for defining services

;;; (defmacro def-kom-service (name args &rest body)
;;;   "Create an initiate call. NAME and ARGS are the name and arguments for the call.
;;; If BODY starts with a string, that is the documentation string.
;;; If BODY consists of (call N PARSER), generate a simple call
;;; for RPC number N, and parse the result with PARSER."
;;;   (let ((function-name (intern (concat "initiate-" (symbol-name name))))
;;;         (doc-string nil)
;;;         (auto-call nil)
;;;         (buffer-save (intern (format "initiate-%s-saved-buffer" name))))
;;;     (when (stringp (car body))
;;;       (setq doc-string (car body))
;;;       (setq body (cdr body)))
;;; 
;;;     (when (and (listp (car body))
;;;                (eq 'call (car (car body))))
;;;       (setq auto-call (car body))
;;;       (setq body (cdr body)))
;;; 
;;;     (` (defun (, function-name) (kom-queue handler (,@ args) &rest data)
;;;          (, 
;;;           (or doc-string 
;;;               (format "Initiate %S on server\nArgs: KOM-QUEUE HANDLER %s &rest DATA"  
;;;                       name (mapconcat 
;;;                             (function
;;;                              (lambda (x)
;;;                                (format "%s" (upcase (symbol-name x)))))
;;;                             args
;;;                             " "))))
;;;          (let (((, buffer-save) (current-buffer)))
;;;            (unwind-protect
;;;                (progn
;;;                  (and (not lyskom-output-queues) (set-buffer lyskom-buffer))
;;;                  (,@ (if auto-call
;;;                          (` ((lyskom-call kom-queue lyskom-ref-no handler data (quote (, (elt auto-call 2))))
;;;                              (lyskom-send-packet kom-queue (lyskom-format-objects (, (elt auto-call 1)) (,@ args)))))
;;;                        body)))
;;;              (set-buffer (, buffer-save))))))))

(defmacro lyskom-server-call (&rest body)
  "Macro to protect initiate-somethings 
from being called in the wrong buffer."
  (` (let ((initiate-something-saved-buffer (current-buffer)))
       (unwind-protect
           (prog2 (or lyskom-output-queues (set-buffer lyskom-buffer))
               lyskom-ref-no
             (,@ body))
         (set-buffer initiate-something-saved-buffer)))))

(put 'lyskom-server-call 'lisp-indent-function 0)
(put 'lyskom-server-call 'edebug-form-spec t)
     

;;; ================================================================
;;;                     Requests for services


(defun initiate-login-old (kom-queue handler pers-no password &rest data)
  "Log in on server.
Args: KOM-QUEUE HANDLER PERS-NO PASSWORD &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 0 pers-no password))))


(defun initiate-login (kom-queue handler pers-no password status 
                                 &rest data)
  "Log in on server.
Args: KOM-QUEUE HANDLER PERS-NO PASSWORD STATUS &rest DATA.
Status is 0 for visible login and 1 for invisible login."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 62 pers-no
                                                         password status))))


(defun initiate-logout (kom-queue handler &rest data)
  "Log out from server.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 1))))


(defun initiate-pepsi (kom-queue handler conf-no &rest data)
  "Change working conference.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 2 conf-no))))

(defun initiate-change-name (kom-queue handler
				       conf-no new-name
				       &rest data)
  "Change the name of a conference.
Args: KOM-QUEUE HANDLER CONF-NO NEW-NAME &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 3 conf-no new-name))))


(defun initiate-change-what-i-am-doing (kom-queue handler what &rest data)
  "Tell server what you are doing.
Args: KOM-QUEUE HANDLER WHAT &rest DATA.
WHAT is a string."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 4 what))))
  

(defun initiate-create-person (kom-queue handler name 
                                         password pers-flags
                                         aux-items 
                                             &rest data)
  "Create a new person.
Args: KOM-QUEUE HANDLER NAME PASSWORD &rest DATA."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 89)
       (lyskom-send-packet kom-queue (lyskom-format-objects 89
                                                            name
                                                            password
                                                            pers-flags
                                                            (cons 'LIST 
                                                                  aux-items)))
     (lyskom-send-packet kom-queue (lyskom-format-objects 5 name password)))))


;;; Call 6 is get-person-stat-old, and is obsoleted by call 49.

(defun initiate-set-priv-bits (kom-queue handler pers-no priv-bits &rest data)
  "Set priv-bits of a person.
Args: KOM-QUEUE HANDLER PERS-NO PRIV-BITS &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 7 pers-no priv-bits))))


(defun initiate-set-passwd (kom-queue handler
				      pers-no old-pw new-pw
				      &rest data)
  "Set the password of a person.
Args: KOM-QUEUE HANDLER PERS-NO OLD-PW NEW-PW &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 8 pers-no old-pw new-pw))))


;;; 
;;; This function has a ridiculous name!  It ought to be called
;;; get-membership.  Unfortunately this name is already taken
;;; by another call.
;;;
(defun initiate-query-read-texts (kom-queue handler
					    pers-no conf-no &rest data)
  "Get a membership struct describing the membership of PERS-NO in CONF-NO.
Args: KOM-QUEUE HANDLER PERS-NO CONF-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 (if (lyskom-have-call 98)
                     'lyskom-parse-membership
                   'lyskom-parse-membership-old))
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects
                         (if (lyskom-have-call 98) 98 9)
                         pers-no conf-no))))


(defun initiate-create-conf (kom-queue handler
				       conf-name conf-type
                                       aux-items &rest data)
  "Add a member to a conference.
Args: KOM-QUEUE HANDLER CONF-NAME CONF-TYPE &rest DATA."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 88)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 88 conf-name conf-type
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 10 conf-name conf-type)))))


(defun initiate-delete-conf (kom-queue handler conf-no &rest data)
  "Delete a conference.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 11 conf-no))))



(defun initiate-lookup-name (kom-queue handler name &rest data)
  "See what conferences match NAME.
Args: KOM-QUEUE HANDLER NAME &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-conf-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 12 name))))
					    

;;; Call 13 is get-conf-stat-old, which is obsoleted by 50.


(defun initiate-add-member (kom-queue handler
				      conf-no 
                                      pers-no
                                      priority
                                      where
                                      type
				      &rest data)
  "Add a member to a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERS-NO PRIORITY WHERE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (if (lyskom-have-call 100)
        (lyskom-send-packet kom-queue
                            (lyskom-format-objects 100 conf-no pers-no 
                                                   priority where type))
      (lyskom-send-packet kom-queue
                          (lyskom-format-objects 14 conf-no pers-no 
                                                 priority where)))))


(defun initiate-sub-member (kom-queue handler
				      conf-no pers-no
				      &rest data)
  "Subtract a member from a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERS-NO  &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 15 conf-no pers-no))))


(defun initiate-set-presentation (kom-queue handler
					    conf-no text-no
					    &rest data)
  "Set presentation of a conference.
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 16 conf-no text-no))))


(defun initiate-set-conf-motd (kom-queue handler conf-no text-no &rest data)
  "Set motd of a conference.
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 17 conf-no text-no))))


(defun initiate-set-supervisor (kom-queue handler conf-no admin
					  &rest data)
  "Set supervisor of a conference.
Args: KOM-QUEUE HANDLER CONF-NO ADMIN &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 18 conf-no admin))))


(defun initiate-set-permitted-submitters (kom-queue handler conf-no perm-sub
						    &rest data)
  "Set permitted submitters of a conference.
Args: KOM-QUEUE HANDLER CONF-NO PERM-SUB &rest DATA.
PERM-SUB is a conference number. All members in that conference might
write texts in CONF-NO. If PERM-SUB is zero everyone is allowed to
write texts in CONF-NO."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 19 conf-no perm-sub))))


(defun initiate-set-super-conf (kom-queue handler conf-no super-conf
					  &rest data)
  "Set superconference of a conference.
Args: KOM-QUEUE HANDLER CONF-NO SUPER-CONF &rest DATA.
Unauthorized attempts to write texts to CONF-NO will bounce to SUPER-CONF."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects 20 conf-no super-conf))))


(defun initiate-set-conf-type (kom-queue handler conf-no conf-type &rest data)
  "Set type of a conference.
Args: KOM-QUEUE HANDLER CONF-NO CONF-TYPE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 21 conf-no conf-type))))


(defun initiate-set-garb-nice (kom-queue handler conf-no garb-nice &rest data)
  "Set garb-nice of a conference.
Args: KOM-QUEUE HANDLER CONF-NO GARB-NICE &rest DATA.
Texts in CONF-NO will live approximately GARB-NICE days."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 22 conf-no garb-nice))))


(defun initiate-get-marks (kom-queue handler &rest data)
  "Get all marked texts.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-mark-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 23))))


(defun initiate-mark-text (kom-queue handler
                                     text-no mark-type
                                     &rest data)
  "Mark a text.
Args: KOM-QUEUE HANDLER TEXT-NO MARK-TYPE &rest DATA.
MARK-TYPE is currently a number, but this should maybe be
changed (internally in the elisp-klient) to something similar to
a conf-type (with several bits that are 't' or 'nil' that is)."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 
                         (if (lyskom-have-call 72) 72 24) 
                         text-no mark-type))))

(defun initiate-unmark-text (kom-queue handler
                                     text-no
                                     &rest data)
  "Unmark a text.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (if (lyskom-have-call 73)
        (lyskom-send-packet kom-queue (lyskom-format-objects 73 text-no)))
      (lyskom-send-packet kom-queue (lyskom-format-objects 24 text-no 0))))


(defun initiate-get-text (kom-queue handler text-no &rest data)
  "Get text from LysKOM server.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (let ((text (cache-get-text text-no)))
      (cond
       ((null text)			;Cached info?
        (lyskom-call kom-queue		;No, ask the server.
                     lyskom-ref-no
                     handler data
                     'lyskom-parse-text text-no)
                                        ;(princ text-no (get-buffer-create "text"))+++
                                        ;(terpri (get-buffer-create "text"))
        (lyskom-send-packet kom-queue (lyskom-format-objects 25 text-no
                                                             0 lyskom-max-int)))
       (t
                                        ;Cached info. 
        (lyskom-call-add kom-queue 'PARSED text handler data)
        (lyskom-check-call kom-queue))))))


(defun initiate-get-text-stat (kom-queue handler text-no &rest data)
  "Get text-stat from LysKOM server.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
   (let ((text-stat (cache-get-text-stat text-no)))
     (cond
      ((null text-stat)			;Cached info?
       (lyskom-call kom-queue		;No, ask the server.
                    lyskom-ref-no
                    handler data
                    (if (lyskom-have-call 90)
                        'lyskom-parse-text-stat
                      'lyskom-parse-text-stat-old)
                    text-no)
       ;;(princ text-no (get-buffer-create "text-stat"))+++
       ;;(terpri (get-buffer-create "text-stat"))
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects
                            (if (lyskom-have-call 90) 90 26)
                            text-no)))
      (t
                                        ;Cached info. 
       (lyskom-call-add kom-queue 'PARSED text-stat handler data)
       (lyskom-check-call kom-queue))))))


(defun initiate-mark-as-read (kom-queue handler conf-no text-list &rest data)
  "Mark all texts in TEXT-LIST as read in CONF-NO. Args: CONF-NO TEXT-LIST."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 27 conf-no 
                                               (cons 'LIST text-list)))))


(defun initiate-create-text (kom-queue 
                             handler
                             message
                             misc-list
                             aux-items
                             &rest data)
  "Create a new text.
Args: KOM-QUEUE HANDLER MESSAGE MISC-LIST AUX-ITEMS &rest DATA.
MESSAGE is a string. MISC-LIST should be created by lyskom-create-misc-list."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 86)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 86
                                                  (cons 'STRING message)
                                                  misc-list
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 28 
						(cons 'STRING message) 
						misc-list)))))

				     
(defun initiate-delete-text (kom-queue handler text-no &rest data)
  "Delete a text.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 29 text-no))))


(defun initiate-add-recipient (kom-queue handler
					 text-no conf-no type
					 &rest data)
  "Add a recipient to a text.
Args: KOM-QUEUE HANDLER TEXT-NO CONF-NO TYPE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet 
     kom-queue
     (lyskom-format-objects 30 text-no conf-no
                            (cond ((eq type 'RECPT) 0)
                                  ((eq type 'CC-RECPT) 1)
                                  ((eq type 'BCC-RECPT) 
                                   (if (lyskom-have-feature bcc-misc)
                                       15 1)))))))

(defun initiate-sub-recipient (kom-queue handler
					 text-no conf-no 
					 &rest data)
  "Subtract a recipient from a text.
Args: KOM-QUEUE HANDLER TEXT-NO CONF-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 31 text-no conf-no))))


(defun initiate-add-comment (kom-queue handler
                                       comment-text-no text-no
                                       &rest data)
  "Add a comment to a text.
Args: KOM-QUEUE HANDLER COMMENT-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 32 comment-text-no text-no))))

				       

(defun initiate-sub-comment (kom-queue handler
                                       comment-text-no text-no
                                       &rest data)
  "Subtract a comment from a text.
Args: KOM-QUEUE HANDLER COMMENT-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 33 comment-text-no text-no))))


(defun initiate-get-map (kom-queue handler conf-no first-local
				   no-of-texts &rest data-list)
  "Get mapping from local to global text-nos for CONF-NO from server.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-TEXTS DATA-LIST.
Use z-initiate-get-map instead. This function has severe performance losses
with big maps."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data-list 'lyskom-parse-map)
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects 34 conf-no
                                               first-local no-of-texts))))

(defun z-initiate-get-map  (kom-queue handler conf-no first-local
                                      no-of-texts &rest data)
  "Get mapping from local to global text-nos for CONF-NO from server.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-TEXTS &rest DATA.
This function will automatically split fetching of big maps to small
chunks of lyskom-fetch-map-nos texts/chunk if KOM-QUEUE is not already
used to collect a result. This currently gives a big performance gain.
Unfortunately it is impossible (or at least very hard) to do the same
thing when a collect is in progress. This will of course be fixed in
protocol B."
  (lyskom-server-call
    (cond
     ((kom-queue->collect-flag (cdr-safe (assq kom-queue lyskom-call-data)))
      ;; Use oldstyle single big map. Sorry.
      (apply 'initiate-get-map
             kom-queue handler conf-no first-local no-of-texts data))
     (t
      ;; You win.
      (initiate-get-map kom-queue 'lyskom-receive-partial-map conf-no
                        first-local lyskom-fetch-map-nos
                        (+ lyskom-fetch-map-nos first-local)
                        (- no-of-texts lyskom-fetch-map-nos)
                        conf-no nil kom-queue data handler)))))

(defun lyskom-receive-partial-map (map first-local no-of-texts
				       conf-no map-so-far kom-queue
				       data-list handler)
  "Receive a partial map and start fetching a new chunk."
  (lyskom-server-call
    (let ((map-list (nconc map-so-far (list map))))
      (if (<= no-of-texts 0)
          (apply handler (apply 'lyskom-map-concat map-list) data-list)
        (initiate-get-map kom-queue 'lyskom-receive-partial-map conf-no
                          first-local lyskom-fetch-map-nos
                          (+ lyskom-fetch-map-nos first-local)
                          (- no-of-texts lyskom-fetch-map-nos)
                          conf-no map-list kom-queue data-list handler)))))


(defun initiate-get-time (kom-queue handler &rest data)
  "Get time from server.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-time)
    (lyskom-send-packet kom-queue (lyskom-format-objects 35))))


(defun initiate-get-server-info (kom-queue handler &rest data)
  "Get info about the server"
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no
                handler
                data
                (if (lyskom-have-call 94)
                    'lyskom-parse-server-info
                  'lyskom-parse-server-info-old))
   (lyskom-send-packet kom-queue
                       (lyskom-format-objects
                        (if (lyskom-have-call 94) 94 36)))))


(defun initiate-add-footnote (kom-queue handler
					footnote-text-no text-no
					&rest data)
  "Add a footnote to a text.
Args: KOM-QUEUE HANDLER FOOTNOTE-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 37 footnote-text-no text-no))))


(defun initiate-sub-footnote (kom-queue handler
					footnote-text-no text-no
					&rest data)
  "Subtract a footnote from a text.
Args: KOM-QUEUE HANDLER FOOTNOTE-TEXT-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 38 footnote-text-no text-no))))


;;; Call 39, who-is-on-old, is obsoleted by call 63.


(defun initiate-set-unread (kom-queue handler conf-no no-of-unread &rest data)
  "Set number of unread texts in a certain conference.
Args: KOM-QUEUE HANDLER CONF-NO NO-OF-UNREAD &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 40 conf-no no-of-unread))))


(defun initiate-set-motd-of-lyskom (kom-queue handler text-no &rest data)
  "Set message of the day of LysKOM.
Args: KOM-QUEUE HANDLER TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 41 text-no))))


(defun initiate-enable (kom-queue handler level &rest data)
  "Set security level.
Args: KOM-QUEUE HANDLER LEVEL &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 42 level))))

;;; Call 43 is sync. Starting with version 1.9 of lyskomd it is a
;;; privileged operation, so there is no harm in having the function
;;; easily available any more.

(defun initiate-sync (kom-queue handler &rest data)
  "Sync the LysKOM datbase. This is a prioritized call."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 43))))

;;; Call 44 is shutdown. Use 'kill -HUP' instead.

(defun initiate-shutdown (kom-queue handler parameter &rest data)
  "Shutdown the server.
Args: KOM-QUEUE HANDLER PARAMETER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 44 parameter))))


(defun initiate-broadcast (kom-queue handler message &rest data)
  "Send a broadcast message to all logged in users.
Args: KOM-QUEUE HANDLER MESSAGE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 45 message))))



(defun initiate-get-membership (kom-queue handler pers-no &rest data)
  "Get membership-list for PERS-NO from server.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 (if (lyskom-have-call 99)
                     'lyskom-parse-membership-list
                   'lyskom-parse-membership-list-old))
    (lyskom-send-packet kom-queue (lyskom-format-objects
                                   (if (lyskom-have-call 99) 99 46)
                                   pers-no
                                   0 lyskom-max-int ;all confs.
                                   1)))) ;want read texts.


(defun initiate-get-part-of-membership (kom-queue handler pers-no first length
						  &rest data)
  "Get membership-list for PERS-NO from server.
Args: KOM-QUEUE HANDLER PERS-NO FIRST-IN-LIST LENGHT &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 (if (lyskom-have-call 99)
                     'lyskom-parse-membership-list
                   'lyskom-parse-membership-list-old))
    (lyskom-send-packet kom-queue (lyskom-format-objects 
                                   (if (lyskom-have-call 99) 99 46)
                                   pers-no
                                   first length ;all confs.
                                   1))))


(defun initiate-get-created-texts (kom-queue handler pers-no first-local
					     no-of-texts &rest data)
  "Get a part of the list of created texts for a person.
Args: KOM-QUEUE HANDLER PERS-NO FIRST-LOCAL NO-OF-TEXTS &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-map)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 47 pers-no
                                               first-local no-of-texts))))


(defun initiate-get-members (kom-queue handler conf-no first-local
				       no-of-members &rest data)
  "Get a part of the list of members in a conference.
Args: KOM-QUEUE HANDLER CONF-NO FIRST-LOCAL NO-OF-MEMBERS &rest DATA.
Returns a conf-no-list."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 (if (lyskom-have-call 101)
                     'lyskom-parse-member-list
                   'lyskom-parse-member-list-old))
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 
                         (if (lyskom-have-call 101) 101 48)
                         conf-no
                         first-local no-of-members))))


(defun initiate-get-pers-stat (kom-queue handler pers-no &rest data)
  "Get status for person PERS-NO.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA."
  (lyskom-server-call
    (let ((pers-stat (cache-get-pers-stat pers-no)))
      (cond
       ((null pers-stat)                ;Cached info?
        (lyskom-call kom-queue		;No, ask the server.
                     lyskom-ref-no
                     handler data
                     'lyskom-parse-pers-stat pers-no)
                                        ;(princ pers-no (get-buffer-create "pers-stat")) +++
                                        ;(terpri (get-buffer-create "pers-stat"))
        (lyskom-send-packet kom-queue (lyskom-format-objects 49 pers-no)))
       (t
                                        ;Cached info. 
        (lyskom-call-add kom-queue 'PARSED pers-stat handler data)
        (lyskom-check-call kom-queue))))))

(defun initiate-get-conf-stat (kom-queue handler conf-no &rest data)
  "Get conf-stat from LysKOM server.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
   (let ((conf-stat (cache-get-conf-stat conf-no)))
     (cond
      ((zerop conf-no)			;No real user.
       (lyskom-call-add kom-queue 'PARSED nil handler data)
       (lyskom-check-call kom-queue))
      ((null conf-stat)			;Cached info?
       (lyskom-call kom-queue		;No, ask the server.
                    lyskom-ref-no
                    handler data
                    (if (lyskom-have-call 91)
                        'lyskom-parse-conf-stat
                      'lyskom-parse-conf-stat-old)
                    conf-no)
       ;;(princ conf-no (get-buffer-create "conf-stat")) +++
       ;;(terpri (get-buffer-create "conf-stat"))
       (lyskom-send-packet kom-queue 
                           (lyskom-format-objects
                            (if (lyskom-have-call 91) 91 50)
                            conf-no)))
      (t
                                        ;Cached info. 
       (lyskom-call-add kom-queue 'PARSED conf-stat handler data)
       (lyskom-check-call kom-queue))))))


;; who-is-on is obsoleted by who-is-on-dynamic (83) i protocol version 9
(defun initiate-who-is-on (kom-queue handler &rest data)
  "Ask server who is on.
Args: KOM-QUEUE HANDLER &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-who-info-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 51))))


(defun initiate-get-unread-confs (kom-queue handler pers-no &rest data)
  "Return a list of confs that may have unread texts.
Args: KOM-QUEUE HANDLER PERS-NO &rest DATA.
PERS-NO is the number of the person whos confs we are checking."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-conf-no-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 52 pers-no))))


(defun initiate-send-message (kom-queue handler recipient message &rest data)
  "Send a message to one or all logged in users.
Args: KOM-QUEUE HANDLER RECIPIENT MESSAGE &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 53 recipient message))))


(defun initiate-get-session-info (kom-queue handler session-no &rest data)
  "Ask server for info about a session.
Args: KOM-QUEUE HANDLER SESSION-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-session-info)
    (lyskom-send-packet kom-queue (lyskom-format-objects 54 session-no))))


(defun initiate-disconnect (kom-queue handler session-no &rest data)
  "Disconnect a session.
Args: KOM-QUEUE HANDLER SESSION &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 55 session-no))))


(defun initiate-who-am-i (kom-queue handler &rest data)
  "Ask the server which connection we are using.
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 56))))

(defun initiate-set-user-area (kom-queue handler pers-no text-no &rest data)
  "Set user-area of a person.
Args: KOM-QUEUE HANDLER PERS-NO TEXT-NO &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 57 pers-no text-no))))

(defun initiate-get-last-text (kom-queue handler before &rest data)
  "Get text created before BEFORE.
Args: KOM-QUEUE HANDLER BEFORE &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 58 before))))


(defun initiate-create-anonymous-text (kom-queue 
                                       handler
                                       message 
                                       misc-list
                                       aux-items
                                       &rest data)
  "Create a new anonymous text.
Args: KOM-QUEUE HANDLER MESSAGE MISC-LIST AUX-ITEMS &rest DATA.
MESSAGE is a string. MISC-LIST should be created by lyskom-create-misc-list."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
   (if (lyskom-have-call 87)
       (lyskom-send-packet kom-queue
                           (lyskom-format-objects 87
                                                  (cons 'STRING message)
                                                  misc-list
                                                  (cons 'LIST aux-items)))
     (lyskom-send-packet kom-queue
                         (lyskom-format-objects 59 
                                                (cons 'STRING message)
                                                misc-list)))))


(defun initiate-find-next-text-no (kom-queue handler text-no &rest data)
  "Find the text following the text TEXT-NO"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 60 text-no))))

(defun initiate-find-previous-text-no (kom-queue handler text-no &rest data)
  "Find the text preceding the text TEXT-NO"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-num)
    (lyskom-send-packet kom-queue (lyskom-format-objects 61 text-no))))

;; Call 62 is above

(defun initiate-who-is-on-ident (kom-queue handler &rest data)
  "Who is logged on. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-who-info-ident-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 63))))

(defun initiate-get-session-info-ident (kom-queue handler 
                                                  session-no &rest data)
  "Get session info. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-session-info-ident)
    (lyskom-send-packet kom-queue (lyskom-format-objects 64 session-no))))

(defun initiate-re-lookup-person (kom-queue handler regexp &rest data)
  "Look up person based on regexp. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 65 regexp))))

(defun initiate-re-lookup-conf (kom-queue handler regexp &rest data)
  "Look up conference based on regexp. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 66 regexp))))

(defun initiate-lookup-person (kom-queue handler regexp &rest data)
  "Look up person based on abbreviated name. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 67 regexp))))

(defun initiate-lookup-conf (kom-queue handler regexp &rest data)
  "Look up conference based on abbreviated name. Obsolete."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 68 regexp))))

(defun initiate-set-client-version (kom-queue handler name version &rest data)
  "Tell the server to set the client name and version of this session."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 69 name version))))


(defun initiate-get-client-name (kom-queue handler session &rest data)
  "Tell the server to set the highest unread article in conference CONF-NO
to TEXT-NO
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-string)
    (lyskom-send-packet kom-queue (lyskom-format-objects 70 session))))


(defun initiate-get-client-version (kom-queue handler session &rest data)
  "Tell the server to set the highest unread article in conference CONF-NO
to TEXT-NO
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-string)
    (lyskom-send-packet kom-queue (lyskom-format-objects 71 session))))

(defun initiate-re-z-lookup (kom-queue handler regexp want-persons want-confs
				       &rest data)
  "Perform a regexp lookup.
Args: KOM-QUEUE HANDLER REGEXP WANT-PERSONS WANT-CONFS &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-conf-z-info-list)
    (lyskom-send-packet kom-queue (lyskom-format-objects 74 regexp want-persons
                                                         want-confs))))

(defun initiate-get-version-info (kom-queue handler &rest data)
  "Perform a get-version-info vall.
Args: KOM-QUEUE HANDLER &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-version-info)
    (lyskom-send-packet kom-queue (lyskom-format-objects 75))))


(defun initiate-lookup-z-name (kom-queue handler name want-persons want-confs
                                         &rest data)
  "Perform a z-lookup.
Args: KOM-QUEUE HANDLER NAME WANT-PERSONS WANT-CONFS &rest DATA"
  (lyskom-server-call
    (if (lyskom-have-call 76)
        (progn
          (lyskom-call kom-queue lyskom-ref-no handler data 
                       'lyskom-parse-conf-z-info-list)
          (lyskom-send-packet kom-queue (lyskom-format-objects 76 name
                                                               want-persons
                                                               want-confs)))
      (let ((ref-no lyskom-ref-no))
        (lyskom-fake-call kom-queue ref-no handler data)
        (++ lyskom-ref-no)
        (initiate-lookup-name 'compat
                              'initiate-compat-lookup-z-name-2
                              name
                              kom-queue
                              ref-no
                              want-persons
                              want-confs)))))

(defun initiate-compat-lookup-z-name-2 (result kom-queue
                                               ref-no
                                               want-persons
                                               want-confs)
  (lyskom-server-call
    (if (null result)
        (lyskom-complete-call kom-queue ref-no nil))

    (let ((conf-nos (listify-vector (conf-list->conf-nos result)))
          (conf-types (listify-vector (conf-list->conf-types result))))
      (lyskom-collect 'follow)
      (while conf-nos
        (if (or (and want-persons
                     (conf-type->letterbox (car conf-types)))
                (and want-confs
                     (not (conf-type->letterbox (car conf-types)))))
            (initiate-get-conf-stat 'follow nil (car conf-nos)))
        (setq conf-nos (cdr conf-nos))
        (setq conf-types (cdr conf-types)))
      (lyskom-list-use 'follow
                       'initiate-compat-lookup-z-name-3
                       kom-queue
                       ref-no))))



(defun initiate-compat-lookup-z-name-3 (conf-list kom-queue 
                                                  ref-no)
  (lyskom-server-call
    (lyskom-complete-call kom-queue ref-no
                          (lyskom-create-conf-z-info-list
                           (mapcar (function
                                    (lambda (conf-stat)
                                      (lyskom-create-conf-z-info
                                       (conf-stat->name conf-stat)
                                       (conf-stat->conf-type conf-stat)
                                       (conf-stat->conf-no conf-stat))))
                                   conf-list)))))
    

(defun initiate-set-last-read (kom-queue handler conf-no text-no &rest data)
  "Tell the server to set the highest unread article in conference CONF-NO
to TEXT-NO
Args: KOM-QUEUE HANDLER CONF-NO TEXT-NO &rest DATA"
  (lyskom-server-call
    (if (lyskom-have-call 77)
        (progn
          (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
          (lyskom-send-packet kom-queue (lyskom-format-objects 77
                                                               conf-no text-no)))
      (initiate-get-conf-stat kom-queue 
                              'initiate-set-last-read-2 
                              conf-no
                              kom-queue
                              handler 
                              conf-no
                              text-no
                              data))))

(defun initiate-set-last-read-2 (conf-stat 
                                 kom-queue
                                 handler
                                 conf-no
                                 text-no
                                 data)
  (lyskom-server-call
    (let ((no-of-unread (- (1- (+ (conf-stat->first-local-no conf-stat)
                                  (conf-stat->no-of-texts conf-stat)))
                           text-no)))
      (if (< no-of-unread 0)
          (setq no-of-unread 0))

      (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
      (lyskom-send-packet kom-queue
                          (lyskom-format-objects 40 conf-no no-of-unread)))))

(defun initiate-get-uconf-stat (kom-queue handler conf-no &rest data)
  "Get an uconf-stat from LysKOM server.
Args: KOM-QUEUE HANDLER CONF-NO &rest DATA."
  (lyskom-server-call
    (let ((conf-stat (cache-get-uconf-stat conf-no)))
      (cond ((zerop conf-no)
             (lyskom-call-add kom-queue 'PARSED nil handler data)
             (lyskom-check-call kom-queue))
            ((null conf-stat)
             (lyskom-call kom-queue
                          lyskom-ref-no
                          handler data
                          'lyskom-parse-uconf-stat conf-no)
             (lyskom-send-packet kom-queue (lyskom-format-objects 78 conf-no)))
            (t
             (lyskom-call-add kom-queue 'PARSED conf-stat handler data)
             (lyskom-check-call kom-queue))))))

(defun initiate-set-info (kom-queue handler 
                                    conf-pres-conf
                                    pers-pres-conf
                                    motd-conf
                                    kom-news-conf
                                    motd-of-lyskom &rest data)
  "Set server info."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 79
                                                         0
                                                         conf-pres-conf
                                                         pers-pres-conf
                                                         motd-conf
                                                         kom-news-conf
                                                         motd-of-lyskom))))
                                                         

(defun initiate-accept-async (kom-queue handler list &rest data)
  "Request asynchronous messages in LIST
Args: KOM-QUEUE HANDLER LIST &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 80
                                                         (cons 'LIST
                                                               list)))))

(defun initiate-query-async (kom-queue handler &rest data)
  "Request information on which async messages are being sent.
Args: KOM-QUEUE HANDLER &rest DATA"
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-number-array)
    (lyskom-send-packet kom-queue (lyskom-format-objects 81))))
                                 


(defun initiate-user-active (kom-queue handler &rest data)
  "Notify the server that the user is active
Args: KOM-QUEUE HANDLER &rest DATA."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 82))))


(defun initiate-who-is-on-dynamic (kom-queue handler want-visible
					     want-invisible active-last
					     &rest data)
  "Ask server who is on.
Args: KOM-QUEUE HANDLER WANT-VISIBLE WANT-INVISIBLE ACTIVE_LAST &rest DATA"
  (lyskom-server-call
  (lyskom-call kom-queue lyskom-ref-no handler data
	       'lyskom-parse-dynamic-session-info-list)
  (lyskom-send-packet kom-queue (lyskom-format-objects
				 83 want-visible want-invisible active-last))))


(defun initiate-get-static-session-info (kom-queue handler session-no
						   &rest data)
  "Ask server for info about a session.
Args: KOM-QUEUE HANDLER SESSION-NO &rest DATA"
  (lyskom-server-call
   (let ((info (cache-get-static-session-info session-no)))
     (cond
      ((null info)			; Not cached
       (lyskom-call kom-queue lyskom-ref-no handler data
                    'lyskom-parse-static-session-info session-no)
       (lyskom-send-packet kom-queue (lyskom-format-objects
                                      84 session-no)))
      (t                                ; Cached
       (lyskom-call-add kom-queue 'PARSED info handler data)
       (lyskom-check-call kom-queue)))))) ;This might call the handler.


(defun initiate-get-collate-table (kom-queue handler &rest data)
  "Get the collate table from the server."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-string)
    (lyskom-send-packet kom-queue (lyskom-format-objects 85))))

(defun initiate-modify-text-info (kom-queue handler 
                                            text-no
                                            delete-items
                                            add-items
                                            &rest data)
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue
                       (lyskom-format-objects 92
                                              text-no
                                              (cons 'LIST delete-items)
                                              (cons 'LIST add-items)))))

(defun initiate-modify-conf-info (kom-queue handler
                                            conf-no
                                            delete-items
                                            add-items
                                            &rest data)
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue 
                       (lyskom-format-objects 93
                                              conf-no
                                              (cons 'LIST delete-items)
                                              (cons 'LIST add-items)))))

(defun initiate-modify-server-info (kom-queue handler 
                                              delete-items
                                              add-items
                                              &rest data)
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue
                       (lyskom-format-objects 95
                                              (cons 'LIST delete-items)
                                              (cons 'LIST add-items)))))

(defun initiate-query-predefined-aux-items (kom-queue handler &rest data)
  "Send query-predefined-aux-items to the server"
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data
                'lyskom-parse-number-array)
   (lyskom-send-packet kom-queue (lyskom-format-objects 96))))

(defun initiate-set-expire (kom-queue handler conf-no expire &rest data)
  "Send set-expire to server."
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue (lyskom-format-objects 97 conf-no expire))
   (cache-del-conf-stat conf-no)))

(defun initiate-set-membership-type (kom-queue handler pers-no conf-no type &rest data)
  "Send set-membership-type to the server."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue 
                        (lyskom-format-objects 102 pers-no conf-no type))))

(defun initiate-local-to-global (kom-queue handler 
                                           conf-no
                                           first-local-no
                                           no-of-texts &rest data)
  "Send local-to-global to server."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data
                 'lyskom-parse-text-mapping no-of-texts)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 103 
                                               conf-no
                                               first-local-no
                                               no-of-texts))))

(defun initiate-map-created-texts (kom-queue handler
                                             author
                                             first-local-no
                                             no-of-texts
                                             &rest data)
  "Send map-created-texts to the server."
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 
                 'lyskom-parse-text-mappinng no-of-texts)
    (lyskom-send-packet kom-queue
                        (lyskom-format-objects 104
                                               author
                                               first-local-no
                                               no-of-texts))))



(defun initiate-set-keep-commented (kom-queue handler conf-no keep &rest data)
  (lyskom-server-call
   (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
   (lyskom-send-packet kom-queue (lyskom-format-objects 105 conf-no keep))
   (cache-del-conf-stat conf-no)))

(defun initiate-set-pers-flags (kom-queue handler pers-no flags &rest data)
  (lyskom-server-call
    (lyskom-call kom-queue lyskom-ref-no handler data 'lyskom-parse-void)
    (lyskom-send-packet kom-queue (lyskom-format-objects 106 pers-no flags))
    (cache-del-pers-stat pers-no)))



;;; ================================================================


;; Blocking reading from server:

(defvar lyskom-blocking-return nil
  "Return from blocking-do.")

(defun blocking-return (retval)
  "Sets blocking variable."
  (setq lyskom-blocking-return retval
	lyskom-ok-to-send-new-calls nil))

(defun blocking-do (command &rest data)
  "Does the COMMAND agains the lyskom-server and returns the result.
COMMAND is one lyskom-command \(like the initiate-* but the initiate- is
stripped. DATA is the args to command.
The cache is consulted when command is get-conf-stat, get-pers-stat
or get-text-stat."
  ;; Here we could check if lyskom-blocking-return is non-nil, in
  ;; which case there is a bug in the code

  (save-excursion
    (set-buffer (or lyskom-buffer
                    (process-buffer lyskom-proc)))
    ;; If this happens, we're in trouble
    (if lyskom-is-parsing
	(lyskom-really-serious-bug))

    (let ((lyskom-blocking-return 'not-yet-gotten))
      ;; This should not be necessary, but for robustness sake...
      ;; There are occasions when it is needed.
      (setq lyskom-ok-to-send-new-calls t)

      (apply (intern-soft (concat "initiate-"
				  (symbol-name command)))
	     'blocking 'blocking-return
	     data)
      (unwind-protect
	  (while (and (eq lyskom-blocking-return 'not-yet-gotten)
		      (memq (process-status lyskom-proc) '(open run))
		      ;; The following test should probably be removed
		      (not lyskom-quit-flag))
	    (lyskom-accept-process-output))
	
	;; OK to continue with prefetch and stuff again
	(setq lyskom-ok-to-send-new-calls t)
	(lyskom-check-output-queues))
      
      (if (or lyskom-quit-flag quit-flag)
          (signal 'quit nil))
      (setq lyskom-quit-flag nil)
      lyskom-blocking-return)))



(defun lyskom-wait-queue (queue)
  "Waits until all data on QUEUE has been processed"
  (save-excursion
    (set-buffer (or lyskom-buffer
                    (process-buffer lyskom-proc)))
    (let ((collector (make-collector)))
      (lyskom-run queue (lambda (c) (set-collector->value c t)) collector)
      (unwind-protect
	  (while (and (null (collector->value collector))
		      (not lyskom-quit-flag))
	    (lyskom-accept-process-output))
	(setq lyskom-ok-to-send-new-calls t)
	(lyskom-check-output-queues))
      (if (or lyskom-quit-flag quit-flag)
	  (progn
	    (lyskom-insert-before-prompt (lyskom-get-string 'interrupted))
	    (signal 'quit nil)))
      (setq lyskom-quit-flag nil)
      (collector->value collector))))


(defvar lyskom-multiple-blocking-return nil
  "Return from blocking-do-multiple")

(defun lyskom-blocking-do-multiple (call-list)
  (save-excursion
    (set-buffer (or lyskom-buffer
                    (process-buffer lyskom-proc)))
    ;; If this happens, we're in trouble
    (if lyskom-is-parsing
	(lyskom-really-serious-bug))
    
    (let ((lyskom-multiple-blocking-return 'not-yet-gotten))
      (setq lyskom-ok-to-send-new-calls t)
      (lyskom-collect 'blocking)
      (while call-list
	(apply (intern-soft (concat "initiate-"
				    (symbol-name (car (car call-list)))))
	       'blocking nil
	       (cdr (car call-list)))
	(setq call-list (cdr call-list)))
      (lyskom-use 'blocking 'lyskom-blocking-do-multiple-1)
      (unwind-protect
	  (while (and (eq lyskom-multiple-blocking-return 'not-yet-gotten)
		      (memq (process-status lyskom-proc) '(open run))
		      (not lyskom-quit-flag))
	    (lyskom-accept-process-output))
	;; OK to continue with prefetch and stuff again
	(setq lyskom-ok-to-send-new-calls t)
	(lyskom-check-output-queues))
      (if lyskom-quit-flag
	  (progn
	    (setq lyskom-quit-flag nil)
	    (lyskom-insert-before-prompt (lyskom-get-string 'interrupted))
	    (signal 'quit nil)))
      lyskom-multiple-blocking-return)))

(defun lyskom-blocking-do-multiple-1 (&rest data)
  (setq lyskom-multiple-blocking-return data
	lyskom-ok-to-send-new-calls nil))

(defun lyskom-cancel-call (queue-name ref-nos)
  "Attempt to cancel calls in queue QUEUE-NAME with ref-no in REF-NOS. 
There is no guarantee that the call will be canceled. In particular, if
the call is not on QUEUE-NAME or has been sent to the server, it will
probably not be canceled."
  (let ((found nil))

    ;; Delete the call from the pending queue

    (let* ((queue (cdr (assq queue-name lyskom-call-data)))
           (calls (and queue (lyskom-queue->all-entries (kom-queue->pending queue)))))
      (when queue
        (lyskom-queue-make-empty (kom-queue->pending queue))
        (lyskom-traverse el calls
          (if (memq (elt el 1) ref-nos)
              (setq found t)
            (lyskom-queue-enter (kom-queue->pending queue) el)))))
    
    ;; Delete the call from the output queue

    (let* ((queue (aref lyskom-output-queues (lyskom-queue-priority queue-name))))
      (when (and queue found)
        (let ((calls (lyskom-queue->all-entries queue)))
          (lyskom-queue-make-empty queue)
          (lyskom-traverse el calls
            (unless (memq (car el) ref-nos)
              (lyskom-queue-enter queue el))))))))

(put 'blocking-do-multiple 'edebug-form-spec '(sexp body))



(eval-and-compile (provide 'lyskom-services))

;;; services.el ends here
;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: parse.el,v 44.43 2002/08/08 07:44:21 ceder Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: parse.el
;;;;
;;;; This file contains functions which parse replies from the
;;;; server. 
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: parse.el,v 44.43 2002/08/08 07:44:21 ceder Exp $\n"))


;;; ================================================================
;;;        Errors that are handled of use while parsing


(put 'lyskom-parse-incomplete 'error-conditions
     '(error lyskom-error lyskom-parse-incomplete))
(put 'lyskom-parse-incomplete 'error-message
     "LysKOM internal error: Parse incomplete.")


;;; ================================================================
;;;                  Low-level parsing.


(defun lyskom-string-skip-whitespace (string)
  "Return STRING omitting any leading whitespace."
  (let ((start (string-match "[^ \t\n\r]" string)))
    (cond ((null start) "")
	  (t (substring string start)))))

(defun lyskom-parse-skip-rest-of-token ()
  "Skip to the next whitespace"
  (let ((c (lyskom-parse-char)))
    (while (not (or (= c ?\ ) (= c ?\n)))
      (setq c (lyskom-parse-char)))))

(defun lyskom-parse-nonwhite-char ()
  "Get next character, skipping whitespace, from lyskom-unparsed-buffer and
increase lyskom-parse-pos. Signal lyskom-parse-incomplete if
the buffer lyskom-unparsed-buffer is exhausted."
  (let ((char (lyskom-parse-char)))
    (while (or (= char ?\ )
               (= char ?\n))
      (setq char (lyskom-parse-char)))
    char))

  
(defun lyskom-parse-char ()
  "Get next character from lyskom-unparsed-buffer and increase 
lyskom-parse-pos. Signal lyskom-parse-incomplete if the buffer 
lyskom-unparsed-buffer is exhausted."
  (cond
   ((< lyskom-parse-pos (point-max))
    (prog1 (char-after lyskom-parse-pos)
      (++ lyskom-parse-pos)))
   (t (signal 'lyskom-parse-incomplete nil))))


(defun lyskom-expect-char (char)
  "Read past next non-white character, which must be equal to CHAR.
Return nil, or signal lyskom-protocol-error if the
first non-white character was not equal to CHAR."
  (if (/= char (lyskom-parse-nonwhite-char))
      (lyskom-protocol-error 'lyskom-expect-char
                             "Expecting %S but got %S"
                             char (char-after (1- lyskom-parse-pos)))
    nil))


(defun lyskom-char-p (char)
  "Check if next token is CHAR (a character)."
  (let* ((lyskom-parse-pos lyskom-parse-pos)
         (c (lyskom-parse-nonwhite-char)))
    (eq char c)))

(defun lyskom-string-to-parse ()
  "Return unparsed data as a string."
  (lyskom-string-skip-whitespace     
   (buffer-substring lyskom-parse-pos (point-max))))

			  
(defun lyskom-parse-num ()
  "Parse the next token as a number.
Signal lyskom-parse-incomplete if the number is not followed by whitespace.
Signal lyskom-protocol-error if the next token is not a number."
  (goto-char lyskom-parse-pos)

  (cond
   ((looking-at "[ \n]*[0-9]+")
    (if (char-after (match-end 0))
        (progn (setq lyskom-parse-pos (goto-char (match-end 0)))
               (string-to-int (match-string 0)))
      (signal 'lyskom-parse-incomplete nil)))
   ((looking-at "[ \n]*\\'") 
    (goto-char (point-max))
    (signal 'lyskom-parse-incomplete nil))
   (t (lyskom-protocol-error 'lyskom-parse-num
                             "Expected number, got %S"
                             (lyskom-string-to-parse))))
)



(defun lyskom-parse-string ()
  "Parse the next token as a string in the server coding system.
Signal lyskom-parse-incomplete if the string is not complete.
Signal lyskom-protocol-error if the next token is not a string."
  (decode-coding-string 
   (lyskom-parse-raw-string)
   lyskom-server-coding-system))

(defun lyskom-parse-raw-string ()
  "Parse next token as a raw string.
Signal lyskom-parse-incomplete if the string is not complete.
Signal lyskom-protocol-error if the next token is not a string."
  ;; Kludge to deal with leading spaces.
  (lyskom-parse-nonwhite-char)
  (setq lyskom-parse-pos (1- lyskom-parse-pos))
  ;; End kludge.
  (goto-char lyskom-parse-pos)
  (cond
   ((looking-at "[0-9]*\\(\\|H\\)\\'")
    (signal 'lyskom-parse-incomplete nil))
   ((null (looking-at "[0-9]+H"))
    (lyskom-protocol-error 'lyskom-parse-string
                           "Expected hollerith, got %S" 
                           (lyskom-string-to-parse)))   ;Not a legal string.
   (t
    (let* ((num (match-string 0))
           (end (match-end 0))
           (len (string-to-int num)))
      (setq lyskom-parse-pos end)
      (cond
       ((< (point-max) (+ lyskom-parse-pos len))
        (lyskom-setq-default lyskom-string-bytes-missing
                             (- (+ lyskom-parse-pos len)
                                (point-max)))
        (signal 'lyskom-parse-incomplete nil))
       (t
        (prog1 (buffer-substring lyskom-parse-pos 
                                 (+ lyskom-parse-pos len))
          (lyskom-setq-default lyskom-string-bytes-missing 0)
          (setq lyskom-parse-pos (+ lyskom-parse-pos len)))))))))


;;(defun lyskom-parse-raw-string ()
;;  "Parse next token as a raw string.
;;Signal lyskom-parse-incomplete if the string is not complete.
;;Signal lyskom-protocol-error if the next token is not a string."
;;  ;; Kludge to deal with leading spaces.
;;  (lyskom-parse-nonwhite-char)
;;  (setq lyskom-parse-pos (1- lyskom-parse-pos))
;;  ;; End kludge.
;;  (let ((to-parse (lyskom-string-to-parse)))
;;    (cond
;;     ((string-match "\\`[0-9]*\\(\\|H\\)\\'" to-parse)
;;      (signal 'lyskom-parse-incomplete nil))
;;     ((null (string-match "\\`[0-9]+H" to-parse))
;;      (lyskom-protocol-error 'lyskom-parse-string
;;                             "Expected hollerith, got %S" 
;;                             to-parse)) ;Not a legal string.
;;     (t
;;      (let ((end (match-end 0))
;;            (len (string-to-int to-parse)))
;;        (setq lyskom-parse-pos (+ lyskom-parse-pos end))
;;        (cond
;;         ((< (point-max) (+ lyskom-parse-pos len))
;;          (lyskom-setq-default lyskom-string-bytes-missing
;;                (- (+ lyskom-parse-pos len)
;;                   (point-max)))
;;          (signal 'lyskom-parse-incomplete nil))
;;         (t
;;          (prog1 (buffer-substring lyskom-parse-pos 
;;                                   (+ lyskom-parse-pos len))
;;            (lyskom-setq-default lyskom-string-bytes-missing 0)
;;            (setq lyskom-parse-pos (+ lyskom-parse-pos len))))))))))

(defun lyskom-parse-coding ()
  "Parse next token as a raw string.
Signal lyskom-parse-incomplete if the string is not complete.
Signal lyskom-protocol-error if the next token is not a string."
  ;; Kludge to deal with leading spaces.
  (lyskom-parse-nonwhite-char)
  (setq lyskom-parse-pos (1- lyskom-parse-pos))
  ;; End kludge.
  (let ((to-parse (lyskom-string-to-parse)))
    (cond
     ((string-match "\\`[0-9]*\\(\\|C\\)\\'" to-parse)
      (signal 'lyskom-parse-incomplete nil))
     ((null (string-match "\\`[0-9]+C" to-parse))
      (lyskom-protocol-error 'lyskom-parse-string
                             "Expected hollerith, got %S" 
                             to-parse)) ;Not a legal string.
     (t
      (let ((end (match-end 0))
	    (len (string-to-int to-parse)))
	(setq lyskom-parse-pos (+ lyskom-parse-pos end))
	(cond
	 ((< (point-max) (+ lyskom-parse-pos len))
	  (lyskom-setq-default lyskom-string-bytes-missing
		(- (+ lyskom-parse-pos len)
		   (point-max)))
	  (signal 'lyskom-parse-incomplete nil))
	 (t
	  (prog1 (buffer-substring lyskom-parse-pos 
				   (+ lyskom-parse-pos len))
            (lyskom-setq-default lyskom-string-bytes-missing 0)
	    (setq lyskom-parse-pos (+ lyskom-parse-pos len))))))))))

(defun lyskom-parse-coded-string ()
  "Parse a string with explicit coding."
  (let ((coding (intern (lyskom-parse-coding)))
        (data (lyskom-parse-raw-string)))
    (condition-case nil
        (progn (check-coding-system coding)
               (decode-coding-string data coding))
      (nil data))))





(defun lyskom-parse-1-or-0 ()
  "Parse next nonwhite char and return t if it was 1, nil if it was 0.
Signal lyskom-protocol-error if it was neither 1 nor 0.
Signal lyskom-parse-incomplete if there is no nonwhite char to parse."
  (let ((char (lyskom-parse-nonwhite-char)))
    (cond
     ((= char ?0) nil)
     ((= char ?1) t)
     (t (lyskom-protocol-error 'lyskom-parse-1-or-0
                               "Expected boolean, got %S" char)))))


(defun lyskom-parse-bitstring (default)
  "Parse a generic bit string"
  (let ((result nil)
        (char (lyskom-parse-nonwhite-char))
	(continue t))
    (while (and continue default)
      (cond ((eq char ?0) (setq result (cons nil result)
			       default (cdr default)
			       char (lyskom-parse-char)))

            ((eq char ?1) (setq result (cons t result)
			       default (cdr default)
			       char (lyskom-parse-char)))
            ((or (= char ?\ )
                 (= char ?\n))
	     ;; This occurs when the received string is shorter than
	     ;; expected.
             (setq continue nil))

            (t (lyskom-protocol-error 'lyskom-parse-bitstring
                                      "Expected bool or space, got %S"
                                      char))))
    (if (not (memq char '(?\  ?\n)))
	;; This occurs when the received string is longer than
	;; expected.
        (progn
          (lyskom-parse-skip-rest-of-token)
          (nreverse result))
      (nconc (nreverse result) (copy-sequence default)))))


(defun lyskom-parse-time ()
  "Parse a time from server. Args: none."
  (lyskom-create-time
   (lyskom-parse-num)			;sec
   (lyskom-parse-num)			;min
   (lyskom-parse-num)			;hour
   (lyskom-parse-num)			;mday
   (1+ (lyskom-parse-num))		;mon
   (+ 1900 (lyskom-parse-num))		;year
   (lyskom-parse-num)			;wday
   (lyskom-parse-num)			;yday
   (lyskom-parse-num)))			;isdst


;;; ================================================================
;;; Skip tokens. (Used e g to skip unknown asynchronous messages.)


(defun lyskom-skip-tokens (to-skip)
  "Skip next TO-SKIP tokens"
  (while (not (zerop to-skip))
    (lyskom-skip-one-token)
    (-- to-skip)))


(defun lyskom-skip-one-token ()
  (let ((to-parse (lyskom-string-to-parse)))
    (cond
     ((string-match "\\`{" to-parse)	;Array/list?
        (lyskom-parse-nonwhite-char)
        (lyskom-skip-array))
     ((string-match "\\`*" to-parse)	;Empty array/list?
        (lyskom-parse-nonwhite-char))	;Simply skip it.
     ((string-match "\\`[0-9]+H" to-parse) ;Hollerith string?
        (lyskom-parse-string))
     ((string-match "\\`[0-9]+[ \t\n\r]" to-parse) ;Number?
        (lyskom-parse-num))
     ((string-match "\\`[0-9]\\'" to-parse)	;Incomplete number?
        (signal 'lyskom-parse-incomplete nil))
     (t (lyskom-protocol-error 'lyskom-skip-one-token
                               "Unrecognized token")))))


(defun lyskom-skip-array ()
  (let ((to-parse (lyskom-string-to-parse)))
    (cond
     ((string-match "\\`}" to-parse)
      (lyskom-parse-nonwhite-char))
     (t (lyskom-skip-one-token)
	(lyskom-skip-array)))))
  

;;; ================================================================
;;; Medium level parsing. Parse arrays, misc-info-lists
;;; and other complex LysKOM types.


(defun lyskom-parse-vector (len parser)
  "Parse a vector with LEN elements.
Each element is parsed by PARSER, a function that takes no arguments."
  (cond
   ((zerop len) (if (lyskom-char-p ?*)
                    (lyskom-expect-char ?*)
                  (lyskom-expect-char ?\{)
                  (lyskom-expect-char ?\})))
   ((lyskom-char-p ?*) (lyskom-expect-char ?*))
   (t (lyskom-expect-char ?{)
      (prog1
	  (lyskom-fill-vector (make-vector len nil) parser)
	(lyskom-expect-char ?})))))

(defun lyskom-parse-list (len parser)
  "Parse a vector with LEN elements and return it as a list.
Each element is parsed by PARSER, a function that takes no arguments."
  (cond
   ((zerop len) (if (lyskom-char-p ?*)
                    (lyskom-expect-char ?*)
                  (lyskom-expect-char ?\{)
                  (lyskom-expect-char ?\})) nil)
   ((lyskom-char-p ?*) (lyskom-expect-char ?*) nil)
   (t (lyskom-expect-char ?{)
      (let ((result nil))
        (while (> len 0)
          (setq result (cons (funcall parser) result))
          (setq len (1- len)))
        (nreverse result)))))


(defun lyskom-fill-vector (vector parser)
  "Fill a vector. Args: VECTOR PARSER.
Fills in all elements in VECTOR. PARSER is called for each element and the
result is assigned to the element."
  (let ((index 0)
	(len (length vector)))
    (while (< index len)
      (aset vector index (funcall parser))
      (setq index (1+ index))))
  vector)


(defun lyskom-parse-conf-type ()
  "Parse a conf-type. No args."
  (apply 'lyskom-create-conf-type (lyskom-parse-bitstring 
                                   '(nil nil nil nil t nil nil nil))))
          
(defun lyskom-parse-privs ()
  "Parse privileges. No args."
  (apply 'lyskom-create-privs
         (lyskom-parse-bitstring
          '(nil nil nil t t t nil nil nil nil nil nil nil nil nil nil))))


(defun lyskom-parse-flags ()
  "Parse Personal_flags. No args."
  (apply 'lyskom-create-flags
         (lyskom-parse-bitstring
          '(nil nil nil nil nil nil nil nil))))

	
(defun lyskom-parse-misc-info-list ()
  "Parse a misc-info-list."
  (let ((n (lyskom-parse-num))		;Number of misc-items to parse.
	(char (lyskom-parse-nonwhite-char)))
    (cond
     ((= char ?*)			;Empty list.
      nil)
     ((= char ?{)			;Start of list.
      (prog1
	  (lyskom-parse-misc-info-list-sub n)
	(lyskom-expect-char ?})))
     (t (lyskom-protocol-error 'lyskom-parse-misc-info-list
                               "Expected * or {, got %S" char)))))


(defun lyskom-parse-misc-info-list-sub (n)
  "Parse a misc-info list with N items."
  (let* ((result (list 'dummy))
	 (last result)
	 (next-key (lyskom-parse-num))
	 (res))
    (while (> n 0)
      (cond
       ((eq next-key 0)			;recpt
	(setq res (lyskom-parse-misc-recipient 'RECPT last n)))
       ((eq next-key 1)			;cc-recpt
	(setq res (lyskom-parse-misc-recipient 'CC-RECPT last n)))
       ((eq next-key 2)			;comm-to
	(setq res (lyskom-parse-misc-comm-to last n)))
       ((eq next-key 3)			;comm-in
	(setq res (lyskom-parse-misc-comm-in last n)))
       ((eq next-key 4)			;footn-to
	(setq res (lyskom-parse-misc-footn-to last n)))
       ((eq next-key 5)			;footn-in
	(setq res (lyskom-parse-misc-footn-in last n)))
       ((eq next-key 15)                ;bcc-recpt
        (setq res (lyskom-parse-misc-recipient 'BCC-RECPT last n)))
       (t (lyskom-protocol-error 'lyskom-parse-misc-info-list-sub
                                 "Unknown misc-info type %S" next-key)))
      (setq n (car res))
      (setq next-key (cdr res))
      (setq last (cdr last)))
    (cdr result)))			;Don't return the dummy element.
      
	      
(defun lyskom-parse-misc-recipient (type last n)
  "Parse a recipient. Args: TYPE LAST N.
TYPE is either RECPT, CC-RECPT or BCC-RECPT.
LAST is a pointer to the last element on a misc-info-list.
N is number of misc-items left to parse.
Returns (cons n next-key)."
  (setcdr last (cons (lyskom-create-empty-misc-info) nil))
  (let ((info (car (cdr last)))
	(next-key nil))
      (set-misc-info->type info type)
    (set-misc-info->recipient-no info (lyskom-parse-num))
    (setq n (1- n))
    ;; A loc-no should follow.
    (if (/= 6 (lyskom-next-num n nil))
        (lyskom-protocol-error 'lyskom-parse-misc-recipient
                               "Expected 6, got something else"))
    (set-misc-info->local-no info (lyskom-parse-num))
    (setq n (1- n))
    ;; A rec-time might follow.
    (if (= 7 (setq next-key (lyskom-next-num n nil)))
	(progn
	  (set-misc-info->rec-time info (lyskom-parse-time))
	  (setq n (1- n))
	  (setq next-key nil)))
    ;; A sent-by might follow.
    (if (= 8 (setq next-key (lyskom-next-num n next-key)))
	(progn
	  (set-misc-info->sender info (lyskom-parse-num))
	  (setq n (1- n))
	  (setq next-key nil)))
    ;; A sent-at might follow.
    (if (= 9 (setq next-key (lyskom-next-num n next-key)))
	(progn
	  (set-misc-info->sent-at info (lyskom-parse-time))
	  (setq n (1- n))
	  (setq next-key nil)))
    ;; Return n and next-key.
    (cons n (lyskom-next-num n next-key))))


(defun lyskom-parse-misc-comm-to (last n)
  "Parse a comm-to. Args: LAST N.
LAST is a pointer to the last element on a misc-info-list.
N is number of misc-items left to parse.
Returns (cons n next-key)."
  (setcdr last (cons (lyskom-create-empty-misc-info) nil))
  (let ((info (car (cdr last)))
	(next-key nil))
    (set-misc-info->type info 'COMM-TO)
    (set-misc-info->comm-to info (lyskom-parse-num))
    (setq n (1- n))
    ;; A sent-by might follow.
    (if (= 8 (setq next-key (lyskom-next-num n nil)))
	(progn
	  (set-misc-info->sender info (lyskom-parse-num))
	  (setq n (1- n))
	  (setq next-key nil)))
    ;; A sent-at might follow.
    (if (= 9 (setq next-key (lyskom-next-num n next-key)))
	(progn
	  (set-misc-info->sent-at info (lyskom-parse-time))
	  (setq n (1- n))
	  (setq next-key nil)))
    ;; Return n and next-key.
    (cons n (lyskom-next-num n next-key))))


(defun lyskom-parse-misc-footn-to (last n)
  "Parse a footn-to. Args: LAST N.
LAST is a pointer to the last element on a misc-info-list.
N is number of misc-items left to parse.
Returns (cons n next-key)."
  (setcdr last (cons (lyskom-create-empty-misc-info) nil))
  (let ((info (car (cdr last)))
	(next-key nil))
    (set-misc-info->type info 'FOOTN-TO)
    (set-misc-info->footn-to info (lyskom-parse-num))
    (setq n (1- n))
    ;; A sent-at might follow.
    (if (= 9 (setq next-key (lyskom-next-num n nil)))
	(progn
	  (set-misc-info->sent-at info (lyskom-parse-time))
	  (setq n (1- n))
	  (setq next-key nil)))
    ;; Return n and next-key.
    (cons n (lyskom-next-num n next-key))))


(defun lyskom-parse-misc-comm-in (last n)
  "Parse a comm-in. Args: LAST N.
LAST is a pointer to the last element on a misc-info-list.
N is number of misc-items left to parse.
Returns (cons n next-key)."
  (setcdr last (cons (lyskom-create-empty-misc-info) nil))
  (let ((info (car (cdr last))))
    (set-misc-info->type info 'COMM-IN)
    (set-misc-info->comm-in info (lyskom-parse-num))
    (setq n (1- n))
    ;; Return n and next-key.
    (cons n (lyskom-next-num n nil))))


(defun lyskom-parse-misc-footn-in (last n)
  "Parse a footn-in. Args: LAST N.
LAST is a pointer to the last element on a misc-info-list.
N is number of misc-items left to parse.
Returns (cons n next-key)."
  (setcdr last (cons (lyskom-create-empty-misc-info) nil))
  (let ((info (car (cdr last))))
    (set-misc-info->type info 'FOOTN-IN)
    (set-misc-info->footn-in info (lyskom-parse-num))
    (setq n (1- n))
    ;; Return n and next-key.
    (cons n (lyskom-next-num n nil))))

    
(defun lyskom-next-num (items-to-parse pre-fetched)
  "Parse next number if PRE-FETCHED is nil and ITEMS-TO-PARSE is greater
than 0. Args: ITEMS-TO-PARSE PRE-FETCHED. Returns -1 if ITEMS-TO-PARSE is
0."
  (cond
   ((zerop items-to-parse) -1)
   (pre-fetched)
   (t (lyskom-parse-num))))


;;; ================================================================
;;;         High level parsing. Parsing of entire datatypes.


(defun lyskom-parse-number-array ()
  "Parse an array of integers."
  (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-num))


(defun lyskom-parse-membership-type ()
  "Parse a membership type"
  (apply 'lyskom-create-membership-type
         (lyskom-parse-bitstring '(nil nil nil nil nil nil nil nil))))

(defun lyskom-parse-member-old ()
  "Parse an old-style member record."
  (lyskom-create-member (lyskom-parse-num) 
                        0
                        (lyskom-current-client-time)
                        (lyskom-create-membership-type
                         nil nil nil nil nil nil nil nil)))

(defun lyskom-parse-member ()
  "Parse a member record"
  (lyskom-create-member
   (lyskom-parse-num)                   ;conf-no
   (lyskom-parse-num)                   ;added-by
   (lyskom-parse-time)                  ;added-at
   (lyskom-parse-membership-type)       ;type
   ))

(defun lyskom-parse-member-list ()
  "Parse a list of members"
  (lyskom-create-member-list
   (lyskom-parse-vector (lyskom-parse-num)
                        'lyskom-parse-member)))

(defun lyskom-parse-membership ()
  "Parse a membership."
    (lyskom-create-membership
     (lyskom-parse-num)                 ;position
     (lyskom-parse-time)                ;last-time-read
     (lyskom-parse-num)			;conf-no
     (lyskom-parse-num)			;priority
     (lyskom-parse-num)			;last-text-read
     (lyskom-parse-vector               ;read-texts
      (lyskom-parse-num) 'lyskom-parse-num)
     (lyskom-parse-num)                 ;added-by
     (lyskom-parse-time)                ;added-at
     (lyskom-parse-membership-type)))

(defun lyskom-parse-membership-old ()
  "Parse a membership."
  (lyskom-create-membership
   nil
   (lyskom-parse-time)			;last-time-read
   (lyskom-parse-num)			;conf-no
   (lyskom-parse-num)			;priority
   (lyskom-parse-num)			;last-text-read
   (lyskom-parse-vector			;read-texts
    (lyskom-parse-num) 'lyskom-parse-num)
   0
   (lyskom-current-client-time)
   (lyskom-create-membership-type nil nil nil nil nil nil nil nil)))


(defun lyskom-parse-version-info ()
  "Parse info about the server and protocol."
  (lyskom-create-version-info
   (lyskom-parse-num)
   (lyskom-parse-string)
   (lyskom-parse-string)))

(defun lyskom-parse-server-info ()
  "Parse info about the server."
  (lyskom-create-server-info
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-aux-item-list)))

(defun lyskom-parse-server-info-old ()
  "Parse info about the server."
  (lyskom-create-server-info
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-num)
   (lyskom-parse-num)))


(defun lyskom-parse-map ()
  "Parse a text-list (also known as map)."
  (lyskom-create-map
   (lyskom-parse-num)			;first-local
   (lyskom-parse-vector			;text-nos
    (lyskom-parse-num) 'lyskom-parse-num)))

(defun lyskom-parse-who-info ()
  "Parse a who-info."
  (lyskom-create-who-info
   (lyskom-parse-num)			;pers-no
   (lyskom-parse-num)			;working-conf
   (lyskom-parse-num)			;connection
   (lyskom-parse-string)		;doing-what
   (lyskom-parse-string)))		;userid@host

(defun lyskom-parse-who-info-ident ()
  "Parse a who-info-ident"
  (lyskom-create-who-info
   (lyskom-parse-num)			;pers-no
   (lyskom-parse-num)			;working-conf
   (lyskom-parse-num)			;connection
   (lyskom-parse-string)		;doing-what
   (lyskom-parse-string)		;userid@host
   (lyskom-parse-string)                ;hostname
   (lyskom-parse-string)                ;ident-user
   ))


(defun lyskom-parse-session-info ()
  "Parse a session-info."
  (lyskom-create-session-info
   (lyskom-parse-num)			;pers-no
   (lyskom-parse-num)			;working-conf
   (lyskom-parse-num)			;connection
   (lyskom-parse-string)		;doing
   (lyskom-parse-string)		;userid@host
   nil                                  ;username
   nil                                  ;ident-user
   (lyskom-parse-num)			;idletime
   (lyskom-parse-time)))		;connect-time

(defun lyskom-parse-session-info-ident ()
  "Parse a session-info."
  (lyskom-create-session-info
   (lyskom-parse-num)			;pers-no
   (lyskom-parse-num)			;working-conf
   (lyskom-parse-num)			;connection
   (lyskom-parse-string)		;doing
   (lyskom-parse-string)		;userid@host
   (lyskom-parse-string)                ;username
   (lyskom-parse-string)                ;ident-user
   (lyskom-parse-num)			;idletime
   (lyskom-parse-time)))                ;connect-time

;; prot-A.txt says that this should allow more or less flags than
;; specified, but I can't figure out how. /davidk

(defun lyskom-parse-session-flags ()
  "Parse session-flags."
  (apply 'lyskom-create-session-flags
         (lyskom-parse-bitstring
          '(nil nil nil nil nil nil nil nil))))

	
(defun lyskom-parse-dynamic-session-info ()
  "Parse a dynamic-session-info."
  (lyskom-create-dynamic-session-info
   (lyskom-parse-num)			;session-no
   (lyskom-parse-num)			;pers-no
   (lyskom-parse-num)			;working-conf
   (lyskom-parse-num)			;idle-time
   (lyskom-parse-session-flags)		;session-flags
   (lyskom-parse-string)))		;doing


;;; High level parsing. Parsing of complete replies.


(defun lyskom-parse-void ()
  "Parse result from functions that only return an OK/FAILURE."
  t)					;Needn't do anything.
			  

(defun lyskom-parse-conf-no-list ()
  "Parse result from functions that return conf-no-list"
  (lyskom-create-conf-no-list
   (lyskom-parse-vector (lyskom-parse-num)
                        'lyskom-parse-num)))


(defun lyskom-parse-conf-list ()
  "Parse result from functions that return a conf-list."
  (let* ((list-len (lyskom-parse-num)))
    (lyskom-create-conf-list
     (lyskom-parse-vector list-len 'lyskom-parse-num)
     (lyskom-parse-vector list-len 'lyskom-parse-conf-type))))


(defun lyskom-parse-member-list-old ()
  "Parse result from functions that return a conf-no-list."
  (lyskom-create-member-list
   (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-member-old)))


(defun lyskom-parse-mark-list ()
  "Parser result from functions that returns a mark-list."
  (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-mark))


(defun lyskom-parse-mark ()
  "Parse a marked text."
  (lyskom-create-mark
   (lyskom-parse-num)			;Text-no
   (lyskom-parse-num)))			;Mark-type

(defun lyskom-parse-aux-item-list ()
  "Parse an aux-item list"
  (listify-vector
   (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-aux-item)))

(defun lyskom-parse-aux-item ()
  "Parse an aux-item"
  (lyskom-aux-item-after-parse
   (lyskom-create-aux-item (lyskom-parse-num)    ; aux-no
                           (lyskom-parse-num)    ; tag
                           (lyskom-parse-num)    ; creator
                           (lyskom-parse-time)   ; sent-at
                           (lyskom-parse-aux-item-flags)
                           (lyskom-parse-num)    ; inherit-limit
                           (lyskom-parse-raw-string) ; data
                           )))

(defun lyskom-parse-aux-item-flags ()
  "Parse aux-item flags"
  (apply 'lyskom-create-aux-item-flags
         (lyskom-parse-bitstring
          '(nil nil nil nil nil nil nil nil))))
  

;;;================================================================
;;; Parsing of datatypes with cache


(defun lyskom-parse-static-session-info (session)
  "Parse a static-session-info and add it to the cache."
  (let ((info (lyskom-create-static-session-info
	       (lyskom-parse-string)	;username
	       (lyskom-parse-string)	;hostname
	       (lyskom-parse-string)	;ident-user
	       (lyskom-parse-time))))	;connection-time
    (lyskom-save-excursion
    	(set-buffer lyskom-buffer)
    	(cache-add-static-session-info session info))
    info))
    

(defun lyskom-parse-conf-stat-old (conf-no)
  "Parse a conf-stat, add add it in the cache.
Retuns the conf-stat. Args: CONF-NO."
  (let
      ((conf-stat (lyskom-create-conf-stat
		   conf-no		;conf-no (supplied by
					; initiate-get-conf-stat)
		   (lyskom-parse-string) ;name
		   (lyskom-parse-conf-type) ;conf-type
		   (lyskom-parse-time)	;creation-time
		   (lyskom-parse-time)	;last-written
		   (lyskom-parse-num)	;creator
		   (lyskom-parse-num)	;presentation
		   (lyskom-parse-num)	;supervisor
		   (lyskom-parse-num)	;permitted-submitters
		   (lyskom-parse-num)	;super-conf
		   (lyskom-parse-num)	;msg-of-day
		   (lyskom-parse-num)	;garb-nice
                   77                   ;fake keep-commented
		   (lyskom-parse-num)	;no-of-members
		   (lyskom-parse-num)	;first-local-no
		   (lyskom-parse-num)))) ;no-of-texts
    
    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (cache-add-conf-stat conf-stat))
    conf-stat))

(defun lyskom-parse-conf-stat (conf-no)
  "Parse a conf-stat, add add it in the cache.
Retuns the conf-stat. Args: CONF-NO."
  (let
      ((conf-stat (lyskom-create-conf-stat
		   conf-no		;conf-no (supplied by
					; initiate-get-conf-stat)
		   (lyskom-parse-string) ;name
		   (lyskom-parse-conf-type) ;conf-type
		   (lyskom-parse-time)	;creation-time
		   (lyskom-parse-time)	;last-written
		   (lyskom-parse-num)	;creator
		   (lyskom-parse-num)	;presentation
		   (lyskom-parse-num)	;supervisor
		   (lyskom-parse-num)	;permitted-submitters
		   (lyskom-parse-num)	;super-conf
		   (lyskom-parse-num)	;msg-of-day
		   (lyskom-parse-num)	;garb-nice
                   (lyskom-parse-num)   ;keep-commented
		   (lyskom-parse-num)	;no-of-members
		   (lyskom-parse-num)	;first-local-no
		   (lyskom-parse-num)   ;no-of-texts
                   (lyskom-parse-num)   ;expire
                   (lyskom-parse-aux-item-list)
                   )))
    
    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (cache-add-conf-stat conf-stat))
    conf-stat))



(defun lyskom-parse-uconf-stat (conf-no)
  "Parse a uconf-stat, and add it to the cache.
Returns the conf-stat. Args CONF-NO."
  (let ((conf-stat (lyskom-create-uconf-stat conf-no
					     (lyskom-parse-string)
					     (lyskom-parse-conf-type)
					     (lyskom-parse-num)
					     (lyskom-parse-num))))
    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (cache-add-uconf-stat conf-stat))
    conf-stat))


(defun lyskom-parse-pers-stat (pers-no)
  "Parse a pers-stat, add add it in the cache.
Retuns the pers-stat. Args: PERS-NO."
  (let
      ((pers-stat
	(lyskom-create-pers-stat
	 pers-no			;pers-no
	 (lyskom-parse-string)		;username
	 (lyskom-parse-privs)		;privileges
	 (lyskom-parse-flags)		;flags
	 (lyskom-parse-time)		;last-login
	 (lyskom-parse-num)		;user-area
	 (lyskom-parse-num)		;total-time-present
	 (lyskom-parse-num)		;sessions
	 (lyskom-parse-num)		;created-lines
	 (lyskom-parse-num)		;created-bytes
	 (lyskom-parse-num)		;read-texts
	 (lyskom-parse-num)		;no-of-text-fetches
	 (lyskom-parse-num)		;created-persons
	 (lyskom-parse-num)		;created-confs
	 (lyskom-parse-num)		;first-created-text
	 (lyskom-parse-num)		;no-of-created-texts
	 (lyskom-parse-num)		;no-of-marks
	 (lyskom-parse-num))))		;no-of-confs
    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (cache-add-pers-stat pers-stat))
    pers-stat))


(defun lyskom-parse-text-stat-old (text-no)
  "Parse a text-stat and add it in the cache. 
Args: TEXT-NO. Value: text-stat."
  (let
      ((text-stat (lyskom-create-text-stat
		   text-no
		   (lyskom-parse-time)	;creation-time
		   (lyskom-parse-num)	;author
		   (lyskom-parse-num)	;no-of-lines
		   (lyskom-parse-num)	;no-of-chars
		   (lyskom-parse-num)	;no-of-marks
		   (lyskom-parse-misc-info-list)))) ;misc-info-list
    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (cache-add-text-stat text-stat))
    text-stat))

(defun lyskom-parse-text-stat (text-no)
  "Parse a text-stat and add it in the cache. 
Args: TEXT-NO. Value: text-stat."
  (let
      ((text-stat (lyskom-create-text-stat
		   text-no
		   (lyskom-parse-time)	;creation-time
		   (lyskom-parse-num)	;author
		   (lyskom-parse-num)	;no-of-lines
		   (lyskom-parse-num)	;no-of-chars
		   (lyskom-parse-num)	;no-of-marks
		   (lyskom-parse-misc-info-list)  ;misc-info-list
                   (lyskom-parse-aux-item-list)
                   )))
    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (cache-add-text-stat text-stat))
    text-stat))


(defun lyskom-parse-text (text-no)
  "Parse a text and add it to the cache.
  Args: TEXT-NO. Result: text-stat."
  (let ((text (lyskom-create-text
	       text-no
	       (lyskom-parse-raw-string))))		;The text.
    (lyskom-save-excursion
     (set-buffer lyskom-buffer)
     (cache-add-text text))
    text))


(defun lyskom-parse-conf-z-info-list ()
  "Parse result from functions that return a conf-z-info-list."
  (let* ((list-len (lyskom-parse-num)))
    (lyskom-create-conf-z-info-list
     (lyskom-parse-vector list-len 'lyskom-parse-conf-z-info))))

(defun lyskom-parse-conf-z-info ()
  "Parse a conf-z-info."
  (lyskom-create-conf-z-info
   (lyskom-parse-string)		;name
   (lyskom-parse-conf-type)		;conf-type
   (lyskom-parse-num)))			;conf-no


(defun lyskom-parse-text-mapping (existing)
  "Parse a Text-Mapping"
  (let ((block-type nil))
    (lyskom-create-text-mapping
     (lyskom-parse-num)
     (lyskom-parse-num)
     existing
     (lyskom-parse-1-or-0)
     (let ((val (lyskom-parse-num)))
       (cond ((= val 0) (setq block-type 'sparse))
             ((= val 1) (setq block-type 'dense)))
       block-type)
     (lyskom-parse-local-to-global-block block-type))))

(defun lyskom-parse-local-to-global-block (block-type)
  "Parse a Local-To-Global-Block"
  (cond ((eq block-type 'sparse)
         (let ((len (lyskom-parse-string)))
           (lyskom-parse-list len 'lyskom-parse-text-number-pair)))
        ((eq block-type 'dense)
         (lyskom-parse-map))))

(defun lyskom-parse-text-number-pair ()
  "Parse a Text-Number-Pair"
  (lyskom-create-text-pair (lyskom-parse-num) (lyskom-parse-num)))

;;; ================================================================
;;;          Parsing of complex datatypes without cache.


(defun lyskom-parse-membership-list ()
  "Parse a membership-list. Returns a vector."
   (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-membership))

(defun lyskom-parse-membership-list-old ()
  "Parse a membership-list. Returns a vector."
   (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-membership-old))


(defun lyskom-parse-who-info-list ()
  "Parse a who-info-list. Returns a vector."
  (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-who-info))
  
(defun lyskom-parse-who-info-ident-list ()
  "Parse a who-info-ident-list. Returns a vector."
  (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-who-info-ident))
  

(defun lyskom-parse-dynamic-session-info-list ()
  "Parse a who-info-list. Returns a vector."
  (lyskom-parse-vector (lyskom-parse-num) 'lyskom-parse-dynamic-session-info))
  

(defun lyskom-init-parse (buffer)
  "Does all initialization of the parsing routines.
i.e creates the buffer, sets all markers and pointers."
  (setq lyskom-is-parsing nil)
  (setq lyskom-unparsed-buffer 
	(lyskom-generate-new-buffer 
	 (concat (if lyskom-debug-communications-to-buffer "" " ")
		 (buffer-name)
		 "-replies")))
  (save-excursion (set-buffer lyskom-unparsed-buffer)
		  (set-buffer-multibyte nil))
  (setq lyskom-unparsed-marker 
	(lyskom-save-excursion
	 (let ((proc lyskom-proc))
	   (set-buffer lyskom-unparsed-buffer)
 	   (make-local-variable 'lyskom-proc)
	   (make-local-variable 'lyskom-string-bytes-missing)
	   (setq lyskom-proc proc)
	   (make-local-variable 'lyskom-buffer)
	   (setq lyskom-buffer buffer)
           (lyskom-setq-default lyskom-string-bytes-missing 0)
	   (goto-char (point-max))
	   (point-marker)))))


;;; ================================================================
;;;        Functions that call the other parsing functions. 


(defun lyskom-parse-success (ref-no buffer)
  "Parse the results of a successful call and call the handler."
  (lyskom-save-excursion
   (set-buffer buffer)
   (let* ((kom-queue (cdr (assq ref-no lyskom-pending-calls)))
	  (call-info (lyskom-locate-ref-no kom-queue ref-no)))
     (set-buffer lyskom-unparsed-buffer)
     (if call-info
	 (apply-parser call-info))
     (set-buffer buffer)
     (lyskom-decrease-pending-calls)
     (setq lyskom-pending-calls
	   (lyskom-assoc-dremove ref-no lyskom-pending-calls))
     (lyskom-check-call kom-queue))))


(defun lyskom-locate-ref-no (kom-queue ref-no)
  (let ((pending (lyskom-queue->all-entries
		  (kom-queue->pending
		   (cdr (assoc kom-queue lyskom-call-data)))))
	(result nil))
    (while (and (null result)
		(not (null pending)))
      (cond
       ((and (eq (car (car pending)) 'CALL)
	     (eq (car (cdr (car pending))) ref-no))
	(setq result (car pending)))
       (t (setq pending (cdr pending)))))
    result))

     
(defun lyskom-assoc-dremove (elt list)
  "Args: ELT LIST. Return a copy of LIST, but exclude any elements whose
car is equal to ELT."
  (let* ((head (cons nil list))
	 (tail head))
    (while (not (null (cdr tail)))
      (cond
       ((equal elt (car (car (cdr tail))))
	(setcdr tail (cdr (cdr tail))))
       (t
	(setq tail (cdr tail)))))
    (cdr head)))


(defun apply-parser (call-info)
  "Try to parse a reply from the server.
CALL-INFO looks like this: (See lyskom-call-data). 
	('CALL REF-NO PARSER PARSER-DATA HANDLER HANDLER-DATA)
PARSER is called, and if it succeeds
CALL-INFO is destructively changed to
	('PARSED RESULT HANDLER HANDLER-DATA)"
  (let ((result
	 (apply (car (cdr (cdr call-info)))	     ;Parser
		(car (cdr (cdr (cdr call-info))))))) ;Parser-data
    ;; If some part of the reply has not yet arrived
    ;; the parser will signal lyskom-parse-incomplete
    ;; and execution will not continue here.
    ;; The parse is complete. Change the call-info.
    (lyskom-tr-call-to-parsed call-info result)))


(defun lyskom-tr-call-to-parsed (call-info result)
  "Transform a CALL to a PARSED."
  (setcar call-info 'PARSED)
  (setcar (cdr call-info) result)
  (setcdr (cdr call-info) (cdr (cdr (cdr (cdr call-info))))))


(defun lyskom-parse-error (ref-no buffer)
  "Parse the result of an unsuccessful call and call the handler."
  (lyskom-save-excursion
    (set-buffer buffer)
    (let* ((kom-queue (cdr (assq ref-no lyskom-pending-calls)))
	   (call-info (lyskom-locate-ref-no kom-queue ref-no))
	   errno err-stat)
      (set-buffer lyskom-unparsed-buffer)
      (setq errno (lyskom-parse-num))
      (setq err-stat (lyskom-parse-num))		;Skip ref_no.
      (set-buffer buffer)
      (setq lyskom-errno errno)
      (setq lyskom-err-stat err-stat)
      (setq lyskom-pending-calls
	    (lyskom-assoc-dremove ref-no lyskom-pending-calls))
      (lyskom-decrease-pending-calls)
      (when call-info
	  (lyskom-tr-call-to-parsed call-info nil))
      (lyskom-check-call kom-queue))))


(defun lyskom-parse-unparsed ()
  "Parse all complete replies in lyskom-unparsed-buffer.
All parsing is to take place in this buffer but calling the functions:
lyskom-parse-success, lyskom-parse-error and lyskom-parse-async calls 
functions and variables that are connected with the lyskom-buffer."
  (let ((lyskom-buffer (current-buffer))
	(match-data (match-data)))
    ;; Was the server saving?
    (if lyskom-is-saving
	(progn
	  (setq mode-line-process (lyskom-get-string
				   (if lyskom-executing-command
				       'mode-line-working
				     'mode-line-waiting))
		lyskom-is-saving nil)
	  ;; I guess the following two lines could be replaced by
	  ;; force-mode-line-update in a modern emacs.
	  (set-buffer-modified-p (buffer-modified-p))
	  (sit-for 0)

	  ;; Removed check for kom-presence-messages
	  (if (and (not (lyskom-is-in-minibuffer)))
	      (message ""))))
    (if lyskom-parser-recovering
        (lyskom-save-excursion
          (set-buffer lyskom-unparsed-buffer)
          (goto-char (point-min))
          (if (re-search-forward "^[:%=]" nil t)
              (progn (delete-region (point-min) (match-beginning 0))
                     (lyskom-set-default 'lyskom-parser-recovering nil))
            (when (> (point-max) (point-min))
              (delete-region (point-min) (1- (point-max))))))
      (lyskom-save-excursion
        (set-buffer lyskom-unparsed-buffer)
        (while (not (zerop (1- (point-max)))) ;Parse while replies.
          (let* ((lyskom-parse-pos 1)
                 (key (lyskom-parse-nonwhite-char)))
            (condition-case err
                (let ((inhibit-quit t))	; Used to be nil, but that can
					; cause hard-to-repair
					; problems
                  (cond
                   ((= key ?=)		;The call succeeded.
                    (lyskom-parse-success (lyskom-parse-num) lyskom-buffer))
                   ((= key ?%)		;The call was not successful.
                    (lyskom-parse-error (lyskom-parse-num) lyskom-buffer))
                   ((= key ?:)		;An asynchronous message.
                    (lyskom-parse-async (lyskom-parse-num) lyskom-buffer))
                   (t
                    (lyskom-protocol-error 'lyskom-parse-unparsed
                                           "Expected =, %% or :, got %S"
                                           (lyskom-string-to-parse))))
                  (delete-region (point-min) lyskom-parse-pos))
              ;; One reply is now parsed.
              (lyskom-protocol-error
               (delete-region (point-min) (min (point-max) (1+ lyskom-parse-pos)))
               (signal 'lyskom-protocol-error err))
              (lyskom-parse-incomplete (signal (car err) (cdr err)))
              (error (delete-region (point-min) lyskom-parse-pos)
                     (signal (car err) (cdr err)))
)
            (goto-char (point-min))
            (if (looking-at "[ \n]+")
                (delete-region (match-beginning 0) (match-end 0)))
            ))))
    (store-match-data match-data)))

(defun lyskom-protocol-error (function format-string &rest args)
  (when lyskom-debug-communications-to-buffer
    (setq lyskom-debug-communications-limit nil)
    (lyskom-debug-insert lyskom-proc
                         (format " Protocol error in %S: " function)
                         (apply 'format format-string args))
    (lyskom-debug-insert lyskom-proc
                         " Backtrace:"
                         "")
    (let ((standard-output
           (get-buffer-create lyskom-debug-communications-to-buffer-buffer)))
      (backtrace))
    (lyskom-debug-insert lyskom-proc
                         (format " Current string: ")
                         (buffer-substring lyskom-parse-pos (point-max))))

  (lyskom-save-backtrace (lyskom-string-to-parse))
  (lyskom-parse-recover)
  (signal 'lyskom-protocol-error
          (format "Protocol error in %S: %s"
                  function
                  (apply 'format format-string args))))

(defun lyskom-parse-recover ()
  "Initiate parser recovery."
  (lyskom-save-excursion
    (set-buffer lyskom-buffer)
    (setq lyskom-parser-recovering t)
    (initiate-get-time 'main nil)))

;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: cache.el,v 44.12 2002/08/06 19:43:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: cache.el
;;;;
;;;; This file contains all functions which have to do with
;;;; caching various data types in the LysKOM client.
;;;;
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: cache.el,v 44.12 2002/08/06 19:43:32 byers Exp $\n"))


;;; ================================================================
;;;			UConf-stat cache

(defun cache-get-uconf-stat (conf-no)
  "Get uconf-stat for conference CONF-NO, or nil if nothing is cached.
If full conf-stat is cached, construct an uconf-stat from that data and
cache it."
  (or (cache-assoc conf-no lyskom-uconf-cache)
      (and (lyskom-have-feature long-conf-types)
           (cache-construct-uconf-stat (cache-get-conf-stat conf-no)))))

(defun cache-construct-uconf-stat (conf)
  "If conf is non-nil, create an uconf-stat from conf and cache it.
Return the new uconf-stat or nil"
  (let ((tmp nil))
    (and conf
         (cache-add-uconf-stat 
          (setq tmp
                (lyskom-create-uconf-stat (conf-stat->conf-no conf)
                                          (conf-stat->name conf)
                                          (conf-stat->conf-type conf)
                                          (+
                                           (conf-stat->first-local-no conf)
                                           (conf-stat->no-of-texts conf))
                                          (conf-stat->garb-nice conf)))))
    tmp))

(defun cache-add-uconf-stat (uconf-stat)
  "Insert a UCONF-STAT in the cache."
  (cache-add (uconf-stat->conf-no uconf-stat)
	     uconf-stat
	     'lyskom-uconf-cache))

(defun cache-del-uconf-stat (conf-no)
  "Delete a conf-stat from the cache. Args: CONF-NO."
  (cache-del conf-no 'lyskom-uconf-cache)
  (cache-del conf-no 'lyskom-conf-cache))


;;; ================================================================
;;;                     Conf-stat cache.


(defun cache-get-conf-stat (conf-no)
  "Get conf-stat for conference CONF-NO, or nil if nothing is cached."
  (cache-assoc conf-no lyskom-conf-cache))

(defun cache-add-conf-stat (conf-stat)
  "Insert a CONF-STAT in the cache."
  (cache-add (conf-stat->conf-no conf-stat) conf-stat 'lyskom-conf-cache))


(defun cache-del-conf-stat (conf-no)
  "Delete a conf-stat from the cache. Args: CONF-NO."
  (cache-del conf-no 'lyskom-conf-cache)
  (cache-del conf-no 'lyskom-uconf-cache))



;;; ================================================================
;;;                       Pers-stat cache.


(defun cache-get-pers-stat (pers-no)
  "Get pers-stat for person PERS-NO, or nil if nothing is cached."
  (cache-assoc pers-no lyskom-pers-cache))

  
(defun cache-add-pers-stat (pers-stat)
  "Insert a PERS-STAT in the cache."
  (cache-add (pers-stat->pers-no pers-stat) pers-stat 'lyskom-pers-cache))


(defun cache-del-pers-stat (pers-no)
  "Delete a pers-stat from the cache. Args: PERS-NO."
  (cache-del pers-no 'lyskom-pers-cache))
  


;;; ================================================================
;;;                       Text-stat cache.


(defun cache-get-text-stat (text-no)
  "Get text-stat for texton TEXT-NO, or nil if nothing is cached."
  (cache-assoc text-no lyskom-text-cache))

  
(defun cache-add-text-stat (text-stat)
  "Insert a TEXT-STAT in the cache."
  (cache-add (text-stat->text-no text-stat) text-stat 'lyskom-text-cache))


(defun cache-del-text-stat (text-no)
  "Delete a text-stat from the cache. Args: TEXT-NO."
  (cache-del text-no 'lyskom-text-cache))


  
;;; ================================================================
;;;                 Text cache (the text strings).


(defun cache-get-text (text-no)
  "Get text for textno TEXT-NO, or nil if nothing is cached."
  (let ((tx (cache-assoc text-no lyskom-text-mass-cache)))
    (cond
     ((lyskom-text-p tx) tx))))

  
(defun cache-add-text (text)
  "Insert a TEXT in the cache."
  (cache-add (text->text-no text) text 'lyskom-text-mass-cache))


(defun cache-del-text (text-no)
  "Delete a text from the cache. Args: TEXT-NO."
  (cache-del text-no 'lyskom-text-mass-cache))



;;; ================================================================
;;;                      Marked texts cache.


(defun cache-get-marked-texts ()
  "Return the a list of marks for all marked texts."
  lyskom-marked-text-cache)


(defun cache-set-marked-texts (mark-array)
  "Sets the marks for all marked texts. A mark-list is an array, but we
want a list in the cache, so this remakes it into a list."
  (setq lyskom-marked-text-cache (listify-vector mark-array)))


(defun cache-text-is-marked (text-no)
  "Return the mark if the text text-no is marked by the current user,
otherwise return nil"
  (let ((marks lyskom-marked-text-cache)
	(mark nil))
    (while (and (not (null marks))
		(null mark))
      (if (equal text-no (mark->text-no (car marks)))
	  (setq mark (car marks))
	(setq marks (cdr marks))))
    mark))


(defun cache-add-marked-text (text-no mark-type)
  "Insert a mark into the cache. If it is already there, replace it."
  (let ((marks lyskom-marked-text-cache)
	(found nil)
	(mark (lyskom-create-mark text-no mark-type)))
    (while (and (not found)
		(not (null marks)))
      (if (and (car marks)
	       (equal text-no (mark->text-no (car marks))))
	  (progn
	    (setcar marks mark)
	    (setq found t))
	(setq marks (cdr marks))))
    (if (not found)
	(setq lyskom-marked-text-cache
	      (cons mark lyskom-marked-text-cache)))))


(defun cache-del-marked-text (text-no)
  "Remove the mark from the cache of marked texts if it is there.
+++BUG: A mark is replaced with a nil and not removed."
  (let ((marks lyskom-marked-text-cache)
	(found nil))
    (while (and (not found)
		(not (null marks)))
      (if (equal text-no (mark->text-no (car marks)))
	  (progn
	    (setcar marks nil)
	    (setq found t))
	(setq marks (cdr marks))))))


;;; ================================================================
;;;                 Static-session-info cache


(defun cache-get-static-session-info (session)
  "Get static-session-info for session SESSION, or nil if nothing is cached."
  (let ((tx (cache-assoc session lyskom-static-session-info-cache)))
    (cond
     ((lyskom-static-session-info-p tx) tx))))

  
(defun cache-add-static-session-info (session info)
  "Insert INFO in the cache."
  (cache-add session info 'lyskom-static-session-info-cache))


;; NOTUSED: cache-del-static-session-info
(defun cache-del-static-session-info (session)
  "Delete a text from the cache. Args: SESSION."
  (cache-del session 'lyskom-static-session-info-cache))



;;; ================================================================
;;;                         who-info cache


(defun cache-initiate-who-info-buffer (who-info-arr kombuf)
  "Sets the cache of who-info items."
  (setq lyskom-who-info-cache (list 'WHO-INFO-LIST))
  (lyskom-save-excursion
   (setq lyskom-who-info-buffer 
	 (lyskom-get-buffer-create 'WHO-INFO (concat (buffer-name) "-who") t))
   (set-buffer lyskom-who-info-buffer)
   (make-local-variable 'kom-buffer)
   (setq lyskom-buffer kombuf)
   (local-set-key [mouse-2] 'kom-mouse-2)
   (erase-buffer))
  (mapcar 'cache-add-who-info
	  (sort (listify-vector who-info-arr)
		(function (lambda (who1 who2)
			    (< (who-info->connection who1)
			       (who-info->connection who2)))))))


(defun cache-add-who-info (who-info)
  "Adds another entry to the lyskom-who-info-cache. Updating the buffer."
  (if lyskom-who-info-buffer-is-on
      (progn
	(lyskom-collect 'who-buffer)
	(initiate-get-conf-stat
	 'who-buffer nil (who-info->pers-no who-info))
	(initiate-get-conf-stat 
	 'who-buffer nil (who-info->working-conf who-info))
	(lyskom-use 'who-buffer 'lyskom-set-who-info-buffer-2
		    who-info))))


(defun cache-add-session-info (session-info)
  "Adds another entry to the lyskom-who-info-cache. Updating the buffer.
ARG: session-info"
  (if (null session-info)
      nil				;+++ Annan felhantering
    (lyskom-halt 'who-buffer)
    (lyskom-collect 'who-buffer-2)
    (initiate-get-conf-stat
     'who-buffer-2 nil (session-info->pers-no session-info))
    (initiate-get-conf-stat 
     'who-buffer-2 nil (session-info->working-conf session-info))
    (lyskom-use 'who-buffer-2 'lyskom-set-session-info
		session-info)
    (lyskom-run 'who-buffer-2 'lyskom-resume 'who-buffer)))


(defun cache-del-who-info (session-no)
  "Delete the session SESSION-NO from the lyskom-who-info-cache. Updating buffer."
  (if lyskom-who-info-buffer-is-on
      (let ((where (cache-assoc session-no lyskom-who-info-cache)))
	(if where
	    (progn
	      (lyskom-save-excursion
	       (set-buffer lyskom-who-info-buffer)
	       (delete-region (marker-position
			       (who-buffer-info->start-marker where))
			      (marker-position
			       (who-buffer-info->end-marker where))))
	      (set-marker (who-buffer-info->start-marker where) nil)
	      (set-marker (who-buffer-info->end-marker where) nil)
	      (cache-del session-no 'lyskom-who-info-cache))))))


(defun lyskom-set-who-info-buffer-2 (pers-conf-stat conf-conf-stat who-info)
  "Inserts a who-buffer-info into lyskom-who-info-cache"
;;  ;We can use lyskom-insert (not beautiful)
;;  ;we insert everything at the end of the buffer.

;;  ;defensive programming and it will work:
;;  (if (and lyskom-who-info-buffer-is-on
;;	   lyskom-who-info-buffer)
;;      (let ((sesno lyskom-session-no)
;;	    min max
;;	    (where (cache-assoc (who-info->connection who-info) 
;;				lyskom-who-info-cache)))
;;	(lyskom-save-excursion
;;	 (set-buffer lyskom-who-info-buffer)
;;	 (save-restriction
;;	   (if where
;;	       (progn
;;		 (narrow-to-region (marker-position 
;;				    (who-buffer-info->start-marker where))
;;				   (1- (marker-position 
;;					(who-buffer-info->end-marker where))))
;;		 (delete-region (point-min) (point-max)))
;;	     (goto-char (point-max))
;;	     (insert " ")
;;	     (narrow-to-region (point-min) (1- (point-max))))
;;	   (setq min (point-max-marker))
;;	   (lyskom-print-who-info pers-conf-stat conf-conf-stat who-info sesno
;;				  (function
;;				   (lambda (string)
;;				     (insert string))))
;;	   (setq max (point-max-marker))
;;	   (goto-char (point-max)))
;;	 (delete-char 1))
;;	(cache-add (who-info->connection who-info) 
;;		   (lyskom-create-who-buffer-info who-info min max)
;;		   'lyskom-who-info-cache)
;;	(run-hooks 'lyskom-who-info-has-changed-hook)))
  )


(defun lyskom-set-session-info (pers-conf-stat conf-conf-stat session-info)
  "Inserts a session-info into lyskom-who-info-cache"
;;;  (lyskom-set-who-info-buffer-2 pers-conf-stat conf-conf-stat
;;;				(lyskom-create-who-info
;;;				 (session-info->pers-no session-info)
;;;				 (session-info->working-conf session-info)
;;;				 (session-info->connection session-info)
;;;				 (session-info->doing session-info)
;;;				 (session-info->username session-info)))
  )


;;; ================================================================
;;;                     Generic cache routines

(defvar lyskom-caches nil
  "A list of all the caches in use.
This is used to clear all caches with `clear-all-caches'") 

(defun cache-create (cache)
  (set cache nil)
  (setq lyskom-caches (cons cache lyskom-caches)))

(defun cache-assoc (key cache)
  "Get data for item with key KEY from CACHE.
CACHE is an assoc-list in this implementation."
  (cdr-safe (assoc key cache)))


(defun cache-add (key data cache)
  "Add DATA to CACHE under the key KEY.
Args: KEY DATA CACHE.
CACHE is a (the only one) quoted variable pointing to the cache (an alist).
The variable might be changed."
  (if (null (symbol-value cache))
      (cache-create cache))
  (let ((oldval (assoc key (symbol-value cache))))
    (cond
     ((null oldval)
      (set cache
	   (cons (cons key data)

		 (symbol-value cache))))
     (t
      (setcdr oldval data)))))


(defun cache-del (key cache)
  "Delete item with key KEY from CACHE.
CACHE is the name of the variable that points to the cache."
  (let ((oldval (assoc key (symbol-value cache))))
    (if oldval
	(setcdr oldval nil))))		;A pair (key . nil) will remain.
					;Fix this bug someday. +++

(defun cache-clear (cache)
  (set cache nil)
  (setq lyskom-caches (delete cache lyskom-caches)))

;; (defsubst cache-hash (key cache)
;;   "Return a hash value for use in the cache."
;;   (mod key (length (aref cache 2))))
;; 
;; (defun cache-create (cache &optional size)
;;   (set cache (vector 'CACHE-HASH (or size 1000)
;; 			(make-vector (or size 1000) nil)))
;;   (if (not (memq cache lyskom-caches))
;; 	 (setq lyskom-caches (cons cache lyskom-caches)))
;;   (symbol-value cache))
;; 
;; (defun cache-rehash (cache-symbol)
;;   (let* ((cache (symbol-value cache-symbol))
;; 	    (newsize (/ (aref cache 1) 5))
;; 	    (oldsize (length (aref cache 2)))
;; 	    (i 0))
;;     (cache-create cache-symbol newsize)
;;     (while (< i oldsize)
;; 	 (let ((entries (aref cache i)))
;; 	   (while entries
;; 	     (cache-add cache-symbol (car (car entries)) (cdr (car entries)))
;; 	     (setq entries (cdr entries))))
;; 	 (setq i (1+ i)))
;;     (symbol-value cache-symbol)))
;; 
;; (defun cache-assoc (key cache)
;;   "Get data for item with key KEY from CACHE.
;; CACHE is an assoc-list in this implementation."
;;   (if cache
;; 	 (cdr-safe (assq key (aref (aref cache 2)
;; 				   (cache-hash key cache))))))
;; 	     
;; 
;; 
;; (defun cache-add (key data cache-symbol)
;;   "Add DATA to CACHE under the key KEY.
;; Args: KEY DATA CACHE.
;; CACHE is a (the only one) quoted variable pointing to the cache (an alist).
;; The variable might be changed."
;;   (let ((cache (symbol-value cache-symbol)))
;;     (if (null cache)
;; 	   (setq cache (cache-create cache-symbol))
;; 	 (if (> (aset cache 1 (1+ (aref cache 1)))
;; 		(* (length (aref cache 2)) 20))
;; 	     (setq cache (cache-rehash cache-symbol))))
;;     (let ((hash (cache-hash key cache)))
;; 	 (aset (aref cache 2) hash
;; 	       (cons (cons key data) (aref (aref cache 2) hash))))))
;; 
;; (defun cache-del (key cache-symbol)
;;   "Delete item with key KEY from CACHE.
;; CACHE is the name of the variable that points to the cache."
;;   (let ((cache (symbol-value cache-symbol)))
;;     (if cache
;; 	   (let* ((hash (cache-hash key cache))
;; 		  (entries (aref (aref cache 2) hash))
;; 		  (ass (assq key entries)))
;; 	     (if ass
;; 		 (progn (aset cache 1 (1- (aref cache 1)))
;; 			(aset (aref cache 2) hash
;; 			      (delq ass entries))))))))
;; 
;; (defun cache-clear (cache)
;;   (set cache nil)
;;   (setq lyskom-caches (delete cache lyskom-caches)))

(defun clear-all-caches ()
  (mapcar (function (lambda (cache) (set cache nil)))
	  lyskom-caches)
  (setq lyskom-caches nil))

;;; ================================================================
;;;         lyskom-tell-server (this is also a sort of cache)


(def-kom-var lyskom-what-i-am-doing nil
  "What the client thinks the server thinks the user is doing."
  local)


(defun lyskom-tell-server (string)
  "Tell the server what the user is doing. Args: STRING."
  (unless lyskom-is-anonymous
    (save-excursion
      (when lyskom-buffer
        (set-buffer lyskom-buffer))
      (cond
       ((equal string lyskom-what-i-am-doing))
       (t
        (setq lyskom-what-i-am-doing string)
        (initiate-change-what-i-am-doing 'background nil string))))))

(provide 'lyskom-cache)
;;;;; -*-coding: raw-text;-*-
;;;;;
;;;;; $Id: view-mode.el,v 44.8 2002/05/29 20:22:32 byers Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: view-mode.el
;;;;
;;;; LysKOM view mode, a simple move for viewing buffers.
;;;;


(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: view-mode.el,v 44.8 2002/05/29 20:22:32 byers Exp $\n"))

(defvar lyskom-view-mode-map nil
  "Keymap for LysKOM view mode")

(eval-when-compile (defvar view-mode-map nil))

(lyskom-external-function view-major-mode)

(defun lyskom-view-base-mode ()
  (cond ((fboundp 'view-major-mode) (view-major-mode))
        ((assq 'view-mode minor-mode-alist)
         (let* ((keymap (copy-keymap lyskom-view-mode-map)))
           (make-variable-buffer-local 'minor-mode-map-alist)
           (set-keymap-parent keymap view-mode-map)
           (setq minor-mode-map-alist (cons (cons 'view-mode keymap)
                                            minor-mode-map-alist))
           (view-mode)))
        (t (view-mode))))


(if lyskom-view-mode-map
    nil
  (setq lyskom-view-mode-map (make-sparse-keymap))
  (define-key lyskom-view-mode-map "*" 'kom-button-press)
  (define-key lyskom-view-mode-map "=" 'kom-menu-button-press)
  (define-key lyskom-view-mode-map "\t" 'kom-next-link)
  (define-key lyskom-view-mode-map [(meta tab)] 'kom-previous-link)
  (define-key lyskom-view-mode-map (kbd (lyskom-keys 'button2up)) 'kom-button-click)
  (define-key lyskom-view-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-view-mode-map "q" 'lyskom-view-mode-quit))

(defun lyskom-view-mode-quit ()
  (interactive)
  (let ((buf (current-buffer)))
    (lyskom-undisplay-buffer buf)
    (kill-buffer buf)))

(define-derived-mode lyskom-view-mode 
  lyskom-view-base-mode
  "LysKOM View"
  "Major mode for viewing buffers")

;;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; $Id: commands1.el,v 44.152 2002/09/07 21:35:22 ceder Exp $
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: commands1.el
;;;;
;;;; This file contains the code for some of the high level commands.
;;;;

(setq lyskom-clientversion-long 
      (concat lyskom-clientversion-long
	      "$Id: commands1.el,v 44.152 2002/09/07 21:35:22 ceder Exp $\n"))

(eval-when-compile
  (require 'lyskom-command "command"))


;;; ================================================================
;;;                  F} uppmuntran - Get appreciation 

;;; Author: Inge Wallin


(def-kom-command kom-get-appreciation ()
  "Give the user a little light in the dark"
  (interactive)
  (lyskom-insert-string 'appreciation))
  

;;; ================================================================
;;;                      F} Sk{ll - Get abuse

;;; Author: Inge Wallin


(def-kom-command kom-get-abuse ()
  "Give the user a little verbal abuse."
  (interactive)
  (lyskom-insert-string 'abuse))


;;; ================================================================
;;;            Utpl}na - Delete a person or a conference

;;; Author: Inge Wallin


(def-kom-command kom-delete-conf ()
  "Delete a person or a conference."
  (interactive)
  (let ((conf-stat 
	 (lyskom-read-conf-stat (lyskom-get-string 'what-conf-to-delete)
				'(all) nil nil t)))
    (if conf-stat
	(if (lyskom-ja-or-nej-p
	     (lyskom-format 'confirm-delete-pers-or-conf
			    (if (conf-type->letterbox (conf-stat->conf-type 
						       conf-stat))
				(lyskom-get-string 'the-pers)
			      (lyskom-get-string 'the-conf))
			    (conf-stat->name conf-stat)))
	    (if (blocking-do 'delete-conf
			     (conf-stat->conf-no conf-stat))
		(progn
		  (lyskom-format-insert 'conf-is-deleted
					(conf-stat->name conf-stat))
		  (when (= (conf-stat->conf-no conf-stat)
			   lyskom-pers-no)
		    (lyskom-insert (lyskom-get-string
				    'you-have-deleted-yourself))
		    (setq lyskom-pers-no nil
			  lyskom-membership nil
			  lyskom-to-do-list (lyskom-create-read-list)
			  lyskom-reading-list (lyskom-create-read-list)
			  lyskom-pending-commands (cons
						   'kom-start-anew
						   lyskom-pending-commands))))
	      (lyskom-format-insert 'you-could-not-delete
				    conf-stat))
	  (lyskom-insert-string 'deletion-not-confirmed))
      (lyskom-insert-string 'somebody-else-deleted-that-conf))))


;;; ================================================================
;;;                Radera (text) - Delete a text

;;; Author: Inge Wallin


(def-kom-command kom-delete-text (text-no)
  "Delete a text. Argument: TEXT-NO"
  (interactive (list (lyskom-read-text-no-prefix-arg 'what-text-to-delete)))
  (if text-no
      (let* ((do-delete t)
             (text-stat (blocking-do 'get-text-stat text-no))
             (num-marks (text-stat->no-of-marks text-stat))
             (is-marked-by-me (cache-text-is-marked text-no)))
        (cond ((null text-stat) 
               (lyskom-report-command-answer nil)
               (setq do-delete nil))

              ((> (text-stat->no-of-marks text-stat) 0)
               (setq do-delete
                     (lyskom-j-or-n-p 
                      (lyskom-format 'delete-marked-text
                                     (if (> num-marks 0)
                                         (if is-marked-by-me
                                             (if (= num-marks 1)
                                                 (lyskom-get-string 'delete-marked-by-you)
                                               (lyskom-format 'delete-marked-by-you-and-others
                                                              (1- num-marks)))
                                           (lyskom-format 'delete-marked-by-several
                                                          num-marks))))))))
        (when do-delete
          (lyskom-format-insert 'deleting-text text-no)
          (when (lyskom-report-command-answer 
                 (blocking-do 'delete-text text-no))
            (when is-marked-by-me
              (lyskom-unmark-text text-no)))))
    (lyskom-insert 'confusion-what-to-delete)))



;;; ================================================================
;;;        ]terse presentation - Review the presentation
;;;               for a person or a conference

;;; Author: Inge Wallin


(def-kom-command kom-review-presentation (&optional text-or-conf-no)
  "Review the presentation for a person or a conference. If a prefix argument
is given, the presentation of the author of that text will be shown."
  (interactive (and current-prefix-arg ; only peek at textno:s when prefixed!
		    (list (lyskom-read-text-no-prefix-arg
			   'text-to-see-author-of))))
  (let ((conf-stat
         (if text-or-conf-no
             (blocking-do 'get-conf-stat
                          (if (interactive-p)
                              (text-stat->author
                               (blocking-do 'get-text-stat text-or-conf-no))
                            text-or-conf-no))
           (lyskom-read-conf-stat
            (lyskom-get-string 'presentation-for-whom)
            '(all)
            nil "" t))))
    (lyskom-review-presentation conf-stat)))

(defun lyskom-review-presentation (conf-stat)
  "Review the presentation of conference CONF-STAT."
  (if (null conf-stat)
      (lyskom-insert-string 'somebody-deleted-that-conf)
    (lyskom-format-insert 'review-presentation-of
                          conf-stat)
    (if (/= (conf-stat->presentation conf-stat) 0)
        (lyskom-view-text (conf-stat->presentation conf-stat))
      (lyskom-format-insert 'has-no-presentation
                            conf-stat))
    (lyskom-traverse faq (lyskom-get-aux-item 
                          (conf-stat->aux-items conf-stat)
                          14)
      (lyskom-print-comment-like-aux faq conf-stat))))  

(defun lyskom-print-comment-like-aux (item object)
  (let* ((text-no (string-to-int (aux-item->data item)))
         (text-stat nil)
         (text nil))
    (unless kom-deferred-printing
      (blocking-do-multiple ((x-text (get-text text-no))
                             (x-text-stat (get-text-stat text-no)))
        (setq text-stat x-text-stat text x-text)))

    (cond ((or text-stat (not kom-deferred-printing))
           (lyskom-insert-comment-like-aux item text-no text-stat text object))
          (t (let ((defer-info (lyskom-create-defer-info
                                'get-text-stat
                                text-no
                                'lyskom-insert-deferred-comment-like-aux
                                (point-max-marker)
                                (length lyskom-defer-indicator)
                                nil     ; Filled in later
                                (list item object text-no))))
               (lyskom-format-insert "%#1s\n" lyskom-defer-indicator)
               (lyskom-defer-insertion defer-info))))))

(defun lyskom-insert-comment-like-aux (item text-no text-stat text object)
  (let* ((author (if text-stat (text-stat->author text-stat) nil))
         (mx-from (car (lyskom-get-aux-item (text-stat->aux-items text-stat)
                                            17)))
         (mx-author (car (lyskom-get-aux-item (text-stat->aux-items text-stat)
                                              16)))
         (formats (lyskom-aux-item-definition-field item 'text-header-line))
         (subject (lyskom-print-faq-format-subject text text-stat text-no))
         content-type
         )
    (if (and mx-from
             (setq content-type
                   (car (lyskom-get-aux-item (text-stat->aux-items 
                                              text-stat) 1))))
        (progn (string-match "^\\(\\S-+\\)" (aux-item->data content-type))
               (setq content-type (format "(%s) "
                                          (aux-item->data content-type))))
      (setq content-type ""))
    (setq author (or (lyskom-format-mx-author mx-from mx-author) author))

    (lyskom-format-insert (cond ((not (listp formats)) formats)
                                ((<= (length formats) 1) (car formats))
                                (author (elt formats 1))
                                (t (elt formats 0)))
                          text-no
                          author
                          content-type
                          (lyskom-aux-item-terminating-button item
                                                              object)
                          subject)
    (lyskom-insert "\n")))

;;; FIXME: This contains code that duplicates the code in 
;;; lyskom-insert-deferred-header-comm. That's a BAD THING.

(defun lyskom-insert-deferred-comment-like-aux (text-stat defer-info)
  (initiate-get-text 'deferred
                     'lyskom-insert-deferred-comment-like-aux-2
                     (elt (defer-info->data defer-info) 2)
                     text-stat
                     defer-info))

(defun lyskom-insert-deferred-comment-like-aux-2 (text text-stat defer-info)
  (let* ((author (if text-stat (text-stat->author text-stat) nil))
         (item (elt (defer-info->data defer-info) 0))
         (object (elt (defer-info->data defer-info) 1))
         (text-no (elt (defer-info->data defer-info) 2))
         (mx-from (car (lyskom-get-aux-item (text-stat->aux-items text-stat)
                                            17)))
         (mx-author (car (lyskom-get-aux-item (text-stat->aux-items text-stat)
                                              16)))
         (formats (lyskom-aux-item-definition-field item 'text-header-line))
         (subject (lyskom-print-faq-format-subject text text-stat text-no))
         content-type
         )
    (if (and mx-from
             (setq content-type
                   (car (lyskom-get-aux-item (text-stat->aux-items 
                                              text-stat) 1))))
        (progn (string-match "^\\(\\S-+\\)" (aux-item->data content-type))
               (setq content-type (format "(%s) "
                                          (aux-item->data content-type))))
      (setq content-type ""))
    (setq author (or (lyskom-format-mx-author mx-from mx-author) author))

    (set-defer-info->format defer-info 
                            (cond ((not (listp formats)) formats)
                                  ((<= (length formats) 1) (car formats))
                                  (author (elt formats 1))
                                  (t (elt formats 0))))
    (lyskom-replace-deferred defer-info
                             text-no
                             author
                             content-type
                             (lyskom-aux-item-terminating-button item
                                                                 object)
                             subject)))






;;; ================================================================
;;;          terse det kommenterade - View commented text

;;; Author: Inge Wallin
;;; Modified by: David Kgedal, Johan Sundstrm

(def-kom-command kom-view-commented-text (text-no)
  "View the commented text.
If the current text is comment to (footnote to) several text then the first
text is shown and a REVIEW list is built to shown the other ones. If the
optional arg TEXT-NO is present review the text that text commented instead."
  (interactive (list (lyskom-read-text-no-prefix-arg 'review-commented-q)))
  (if text-no
      (progn
	(lyskom-tell-internat 'kom-tell-read)
        (unless kom-review-uses-cache
          (cache-del-text-stat text-no))
	(lyskom-view-commented-text
	 (blocking-do 'get-text-stat text-no)))
    (lyskom-insert-string 'confusion-what-to-view)))


(def-kom-command kom-view-previous-commented-text (text-no)
  "View the text the previous text commented.
If the previously viewed text is a comment to (footnote to) several
texts then the first text is shown and a REVIEW list is built to show
the other ones."
  (interactive (list (lyskom-read-text-no-prefix-arg 'review-commented-q nil
                                                     lyskom-previous-text)))
  (cond (text-no
         (lyskom-tell-internat 'kom-tell-read)
        (unless kom-review-uses-cache
          (cache-del-text-stat text-no))
         (lyskom-view-commented-text
          (blocking-do 'get-text-stat lyskom-previous-text)))
        (t (lyskom-insert-string 'confusion-what-to-view))))


(defun lyskom-text-stat-commented-texts (text-stat)
  "Return a list of the text-nos that TEXT-STAT is a comment or footnote to."
  (let* ((misc-info-list (and text-stat
                              (text-stat->misc-info-list text-stat)))
         (misc-infos (and misc-info-list
                          (append (lyskom-misc-infos-from-list
                                   'COMM-TO misc-info-list)
                                  (lyskom-misc-infos-from-list
                                   'FOOTN-TO misc-info-list)))))
    (and misc-infos
	 (mapcar
	  (function
	   (lambda (misc-info)
	     (if (equal (misc-info->type misc-info)
			'COMM-TO)
		 (misc-info->comm-to misc-info)
	       (misc-info->footn-to misc-info))))
	  misc-infos))))


(defun lyskom-view-commented-text (text-stat)
  "Handles the return from the initiate-get-text-stat, displays and builds list."
  (let ((text-nos (lyskom-text-stat-commented-texts text-stat)))
    (if text-nos
        (progn
          (lyskom-format-insert 'review-text-no 
                                (car text-nos))
          (if (cdr text-nos)
              (read-list-enter-read-info
               (lyskom-create-read-info
                'REVIEW nil (lyskom-review-get-priority)
                (lyskom-create-text-list (cdr text-nos))
                lyskom-current-text)
               lyskom-reading-list t))
          (unless kom-review-uses-cache
            (cache-del-text-stat (car text-nos)))
          (lyskom-view-text (car text-nos)
			    nil nil nil 
			    nil nil nil
			    t))
      (lyskom-insert-string 'no-comment-to))))


(defun lyskom-misc-infos-from-list (type list)
  "Get all the misc-infos from the misc-info-list LIST with the same type
as TYPE. If no such misc-info, return NIL"
  (let ((result nil))
    (while list
      (when (equal type (misc-info->type (car list)))
        (setq result (cons (car list) result)))
      (setq list (cdr list)))
    (nreverse result)))


;;; ================================================================
;;;                         Brev - Send letter

;;; Author: Inge Wallin
;;; Rewritten using read-conf-no by Linus Tolke (4=>1)

(def-kom-command kom-send-letter (&optional pers-no)
  "Send a personal letter to a person or a conference."
  (interactive)
  (condition-case nil
      (progn
        (lyskom-tell-internat 'kom-tell-write-letter)
	;; If there was a motd, which is now removed we have to
	;; refetch the conf-stat to know that.
        (let* ((tono (or pers-no
                         (lyskom-read-conf-no
                          (lyskom-get-string 'who-letter-to)
                          '(all) nil nil t)))
               (conf-stat (blocking-do 'get-conf-stat tono)))
	  (cache-del-conf-stat tono)
          (if (if (zerop (conf-stat->msg-of-day conf-stat))
                  t
                (progn
                  (recenter 1)
                  (lyskom-format-insert 'has-motd 
                                        conf-stat)
                  (lyskom-view-text (conf-stat->msg-of-day conf-stat))
                  (if (lyskom-j-or-n-p (lyskom-get-string 'motd-persist-q))
                      t
                    nil)))
              (if (= tono lyskom-pers-no)
                  (lyskom-edit-text lyskom-proc
                                    (lyskom-create-misc-list 'RECPT tono)
                                    "" "")
                (lyskom-edit-text lyskom-proc
                                  (if (lyskom-get-membership tono)
                                      (lyskom-create-misc-list 'RECPT tono)
                                      (lyskom-create-misc-list 
                                       'RECPT tono
                                       'RECPT lyskom-pers-no))
                                  "" "")))))
    (quit (signal 'quit nil))))


;;; ================================================================
;;;           Bli medlem i m|te - Become a member of a conference
;;;             Addera medlem - Add somebody else as a member

;;; Author: ???
;;; Rewritten by: David K}gedal


;; Add another person

(def-kom-command kom-add-member ()
  "Add a person as a member of a conference.
Ask for the name of the person, the conference to add him/her to."
  (interactive)
  (let* ((who (lyskom-read-conf-stat (lyskom-get-string 'who-to-add)
				     '(pers) nil nil t))
	 (whereto (lyskom-read-conf-stat (lyskom-get-string 'where-to-add)
					 '(all) nil nil t))
	 (pers-stat (blocking-do 'get-pers-stat (conf-stat->conf-no who))))
    (lyskom-add-member-answer (lyskom-try-add-member whereto who 
                                                     pers-stat nil nil t)
			      whereto who)))



;; Add self

(def-kom-command kom-add-self (&optional conf)
  "Add this person as a member of a conference."
  (interactive)
  (let* ((whereto (if conf (blocking-do 'get-conf-stat conf)
                    (lyskom-read-conf-stat 
                     (lyskom-get-string 'where-to-add-self)
                     '(all) nil "" t)))
         (who (blocking-do 'get-conf-stat lyskom-pers-no))
         (pers-stat (blocking-do 'get-pers-stat lyskom-pers-no))
         (mship (lyskom-get-membership (conf-stat->conf-no whereto) t)))
  
    ;; Fake kom-membership-default-priority if this is a passive membership
    ;; This will suppress the normal "which priority" question. Ugly hack.

    (let ((kom-membership-default-priority
           (if (and mship (membership-type->passive (membership->type mship)))
               (membership->priority mship)
             kom-membership-default-priority)))
      (lyskom-add-member-answer (lyskom-try-add-member whereto who pers-stat nil nil t)
                                whereto who))))


(def-kom-command kom-change-priority (&optional conf)
  "Change the priority of a conference."
  (interactive)
  (let* ((conf-stat (if conf (blocking-do 'get-conf-stat conf)
                      (lyskom-read-conf-stat 
                       (lyskom-get-string 'change-priority-for-q)
                       '(all) nil "" t)))
         (mship (lyskom-get-membership (conf-stat->conf-no conf-stat) t))
	 (kom-membership-default-priority nil))
    (blocking-do-multiple ((who (get-conf-stat lyskom-pers-no))
                           (pers-stat (get-pers-stat lyskom-pers-no)))
      (cond ((and (null mship) conf-stat)
             (lyskom-format-insert 'not-member-of-conf conf-stat))
	    ((null conf-stat)
	     (lyskom-format-insert 'no-such-conf))
            (t (lyskom-add-member-answer
                (lyskom-try-add-member conf-stat who pers-stat nil
                                       'change-priority-for t)
                conf-stat who))))))
                                                           
                                     



;;; NOTE: This function is also called from lyskom-go-to-conf-handler
;;;       and from lyskom-create-conf-handler.

(defun lyskom-add-member-by-no (conf-no pers-no &optional thendo &rest data)
  "Fetch info to be able to add a person to a conf.
Get the conf-stat CONF-NO for the conference and the conf-stat and pers-stat 
for person PERS-NO and send them into lyskom-try-add-member."
  (blocking-do-multiple ((whereto (get-conf-stat conf-no))
                         (who (get-conf-stat pers-no))
                         (pers-stat (get-pers-stat pers-no)))
    (let ((result (lyskom-try-add-member whereto who pers-stat nil nil t)))
      (lyskom-add-member-answer result whereto who)
      (if thendo
          (apply thendo data))
      (car result))))


(defun lyskom-try-add-member (conf-conf-stat 
                              pers-conf-stat 
                              pers-stat
                              membership-type
                              &optional message-string
                              need-extra-information
                              default-priority)
  "Add a member to a conference.
Args: CONF-CONF-STAT PERS-CONF-STAT PERS-STAT
CONF-CONF-STAT: the conf-stat of the conference the person is being added to
PERS-CONF-STAT: the conf-stat of the person being added.
PERS-STAT: the pers-stat of the person being added.

Optional MESSAGE-STRING is the message to print before making server call.
Returns t if it was possible, otherwise nil.

If optional NEED-EXTRA-INFORMATION is non-nil, the return value will be
a list where the first element is the result of add-member and the second
is the position where the membership was placed.

If optional USE-PRIORITY is non-nil then use that as the priority.
"
  (if (or (null conf-conf-stat)
	  (null pers-conf-stat))
      nil				; We have some problem here.
    (let ((priority
           (if (/= lyskom-pers-no (conf-stat->conf-no pers-conf-stat))
               (lyskom-read-num-range 0 255
                                      (lyskom-get-string 'priority-q)
                                      nil 100)
             (if (and (numberp kom-membership-default-priority)
                      (< kom-membership-default-priority 256)
                      (>= kom-membership-default-priority 0))
                 kom-membership-default-priority
               (lyskom-read-num-range 0 255 (lyskom-get-string 'priority-q) nil default-priority))))
	  (where
	   (if (/= lyskom-pers-no (conf-stat->conf-no pers-conf-stat))
	       1			; When adding someone else
	     (cond
	      ((and (numberp kom-membership-default-placement)
		    (>= kom-membership-default-placement 0))
	       kom-membership-default-placement)
	      ((eq kom-membership-default-placement 'first)
	       0)
	      ((eq kom-membership-default-placement 'last)
	       (length lyskom-membership))
	      (t
	       (lyskom-read-num-range
		0 (pers-stat->no-of-confs pers-stat)
		(lyskom-format 'where-on-list-q
			       (length lyskom-membership))))))))

      ;;
      ;; Adding ourselves. Adjust where so the membership
      ;; list remains sorted. Find the closest position to
      ;; where at which we can put the membership and keep
      ;; the membership lsit sorted.
      ;;

      (when (eq lyskom-pers-no (conf-stat->conf-no pers-conf-stat))
        (let ((mship-list lyskom-membership)
              (mship nil)
              (index 0)
              (found nil))
          (while mship-list
            (setq mship (car mship-list)
                  mship-list (cdr mship-list))
            (cond ((> (membership->priority mship) priority))
                  ((< (membership->priority mship) priority) 
                   (setq where index mship-list nil found t))
                  ((and (= (membership->priority mship) priority)
                        (= index where))
                   (setq mship-list nil found t))
                  ((and (= (membership->priority mship) priority)
                        (> index where))
                   (setq where index mship-list nil found t)))
            (setq index (1+ index))
            (unless found (setq where (1+ index))))))

      (when (null membership-type)
        (setq membership-type 
              (lyskom-create-membership-type nil nil nil nil
                                             nil nil nil nil)))

      (if message-string
          (lyskom-format-insert message-string
                                pers-conf-stat
                                conf-conf-stat)
        (if (= (conf-stat->conf-no pers-conf-stat)
               lyskom-pers-no)
            (lyskom-format-insert 'member-in-conf
                                  conf-conf-stat)
          (lyskom-format-insert 'add-member-in
                                pers-conf-stat
                                conf-conf-stat)))
      (lyskom-ignoring-async (18 lyskom-pers-no
                                 (conf-stat->conf-no conf-conf-stat))
        (let ((res (blocking-do 'add-member 
                                (conf-stat->conf-no conf-conf-stat)
                                (conf-stat->conf-no pers-conf-stat)
                                priority where
                                membership-type)))
          (if need-extra-information
              (list res where)
            res))))))


(defun lyskom-add-member-answer (answer conf-conf-stat
                                        pers-conf-stat)
  "Handle the result from an attempt to add a member to a conference."
  (let ((pos (if (consp answer) (elt answer 1) nil))
        (answer (if (consp answer) (elt answer 0) answer)))
    (if (null answer)
        (progn
          (lyskom-insert-string 'nope)
          (let* ((errno lyskom-errno)
                 (err-stat lyskom-err-stat)
                 (is-supervisor (lyskom-is-supervisor (conf-stat->conf-no conf-conf-stat)
                                                      lyskom-pers-no))
                 (is-member (lyskom-is-member (conf-stat->conf-no conf-conf-stat)
                                              (conf-stat->conf-no pers-conf-stat)))
                 (rd-prot (conf-type->rd_prot (conf-stat->conf-type conf-conf-stat))))


            (cond (is-member
                   (lyskom-format-insert 'add-already-member 
                                         pers-conf-stat
                                         conf-conf-stat))
                  ((and rd-prot is-supervisor)
                   (lyskom-insert-error errno err-stat))

                  (rd-prot (let ((supervisorconf (blocking-do
                                                  'get-conf-stat
                                                  (conf-stat->supervisor conf-conf-stat))))
                             (if supervisorconf
                                 (lyskom-format-insert 'is-read-protected-contact-supervisor
                                                       conf-conf-stat
                                                       supervisorconf)
                               (lyskom-format-insert 'cant-find-supervisor
                                                     conf-conf-stat))))

                  (t (lyskom-insert-error errno err-stat)))))

      ;;+++Borde {ndra i cachen i st{llet.
      (cache-del-pers-stat (conf-stat->conf-no pers-conf-stat))
      ;;+++Borde {ndra i cachen i st{llet.
      (cache-del-conf-stat (conf-stat->conf-no conf-conf-stat))
      (if (= (conf-stat->conf-no pers-conf-stat)
             lyskom-pers-no)
          (let ((mship (blocking-do 'query-read-texts
                                    lyskom-pers-no 
                                    (conf-stat->conf-no conf-conf-stat))))
            (unless (membership->position mship)
              (set-membership->position mship pos))
            (lyskom-add-membership mship
                                   conf-conf-stat
                                   t)))
      (lyskom-insert-string 'done))))



(defun lyskom-add-membership (membership conf-no-or-stat &optional blocking)
  "Adds MEMBERSHIP to the sorted list of memberships.
If BLOCKING is non-nil, block while reading the conference map until at 
least one text has been seen. CONF-NO-OR-STAT is the conf-no to add 
unless BLOCKING is t, in which cast it is the conf-stat."
  (if membership
      (progn
	(lyskom-insert-membership membership)
        (if blocking
            (lyskom-fetch-start-of-map conf-no-or-stat membership)
          (lyskom-prefetch-map conf-no-or-stat membership))
        (lyskom-run-hook-with-args 'lyskom-add-membership-hook
                                   membership))
    (lyskom-insert-string 'conf-does-not-exist)))



;;; ================================================================
;;;     Uttr{d - Subtract yourself as a member from a conference
;;;     Uteslut medlem - Subtract somebody else as a member

;;; Author: David Byers
;;; Based on code by Inge Wallin


;; Subtract another person

(def-kom-command kom-sub-member ()
  "Subtract a person as a member from a conference. Ask for the name
of the person."
  (interactive)
  (lyskom-sub-member
   (lyskom-read-conf-stat (lyskom-get-string 'who-to-exclude)
                          '(pers) nil "" t)
   (lyskom-read-conf-stat (lyskom-get-string 'where-from-exclude) 
			  '(all) nil "" t)))


(def-kom-command kom-sub-self (&optional conf)
  "Subtract this person as a member from a conference."
  (interactive)
  (lyskom-sub-member 
   (blocking-do 'get-conf-stat lyskom-pers-no)
   (if conf (blocking-do 'get-conf-stat conf)
     (lyskom-read-conf-stat (lyskom-get-string 'leave-what-conf)
                            '(all) nil 
                            (let ((ccn 
                                   (if (or (null lyskom-current-conf)
                                           (zerop lyskom-current-conf))
                                       ""
                                     (conf-stat->name
                                      (blocking-do 'get-conf-stat
                                                   lyskom-current-conf)))))
                              (if ccn
                                  (cons ccn 0)
                                "")) t))))

(defun lyskom-sub-member (pers conf)
  "Remove the person indicated by PERS as a member of CONF."
  (let* ((reply nil)
         (self (= (conf-stat->conf-no pers) lyskom-pers-no))
         (mship (and self 
                     kom-unsubscribe-makes-passive
                     (lyskom-get-membership (conf-stat->conf-no conf))))
         (passivate (and mship
                         (lyskom-have-call 102) ; set-membership-type
                         (not (membership-type->passive
                               (membership->type mship))))))

    (cond ((null pers) (lyskom-insert-string 'error-fetching-person))
	  ((null conf) (lyskom-insert-string 'error-fetching-conf))
          (passivate 
           (lyskom-prefetch-cancel-prefetch-map (conf-stat->conf-no conf))
           (lyskom-format-insert 'unsubscribe-to conf)
           (set-membership-type->passive (membership->type mship) t)
           (setq reply (blocking-do 'set-membership-type
                                    (conf-stat->conf-no pers)
                                    (conf-stat->conf-no conf)
                                    (membership->type mship)))
           (if (not reply)
               (lyskom-format-insert 'unsubscribe-failed
                                     (lyskom-get-string 'You)
                                     conf)
             (lyskom-insert-string 'done)
             (lyskom-format-insert 'passivate-done conf)
             (when (= (conf-stat->conf-no conf) lyskom-current-conf)
               (lyskom-leave-current-conf))
	     (read-list-delete-read-info (conf-stat->conf-no conf)
					 lyskom-to-do-list)))
	  (t
           (when self
             (lyskom-prefetch-cancel-prefetch-map (conf-stat->conf-no conf)))

	   (if self
	       (lyskom-format-insert 'unsubscribe-to conf)
	     (lyskom-format-insert 'exclude-from pers conf))

           (lyskom-ignoring-async (8 (conf-stat->conf-no conf))
             (setq reply (blocking-do 'sub-member
                                      (conf-stat->conf-no conf)
                                      (conf-stat->conf-no pers))))
	   (if self
	       (lyskom-remove-membership (conf-stat->conf-no conf)))
	   (if (not reply)
	       (lyskom-format-insert 'unsubscribe-failed
				     (if self
					 (lyskom-get-string 'You)
				       (conf-stat->name pers))
				     conf)
	     (lyskom-insert-string 'done)
	     (when (and self (= (conf-stat->conf-no conf)
                              lyskom-current-conf))
               (lyskom-leave-current-conf))
	     (read-list-delete-read-info (conf-stat->conf-no conf)
					 lyskom-to-do-list))))))
	   

	 

;;; ================================================================
;;;                 Skapa m|te - Create a conference

;;; Author: ???


(def-kom-command kom-create-conf (&optional name)
  "Create a conference."
  (interactive)
  (let* ((conf-name (or name
			(lyskom-read-string
			 (lyskom-get-string 'name-of-conf))))
	 (open (j-or-n-p (lyskom-get-string 'anyone-member)))
	 (secret (if (not open)
		     (j-or-n-p (lyskom-get-string 'secret-conf))))
	 (orig (j-or-n-p (lyskom-get-string 'comments-allowed)))
         (anarchy (j-or-n-p (lyskom-get-string 'anonymous-allowed)))
         (secmem (and (lyskom-have-feature long-conf-types)
                      (not (lyskom-j-or-n-p (lyskom-get-string 'secret-members-allowed)))))
	 (conf-no (blocking-do 'create-conf 
			       conf-name
			       (lyskom-create-conf-type (not open) 
							(not orig)
							secret
							nil
                                                        anarchy
                                                        secmem
                                                        nil
                                                        nil)
                               nil)))
    (if (null conf-no)
	(progn
	  (lyskom-format-insert 'could-not-create-conf
				conf-name)
	  (lyskom-insert-error))
      (progn
	(let ((conf-stat (blocking-do 'get-conf-stat conf-no)))
	  (lyskom-format-insert 'created-conf-no-name 
				(or conf-stat conf-no)
				(or conf-stat conf-name)
				(if conf-stat
				    (lyskom-default-button 'conf conf-stat)
				  nil)))
	(lyskom-scroll)
	(lyskom-add-member-by-no conf-no lyskom-pers-no
				 (if secret
				     nil ; Don't write a presentation
				   'lyskom-create-conf-handler-2)
				 conf-no conf-name)))))


(defun lyskom-create-conf-handler-2 (conf-no conf-name)
  "Starts editing a presentation for the newly created conference.
This does lyskom-end-of-command"
  (lyskom-tell-internat 'kom-tell-conf-pres)
  (let ((conf (blocking-do 'get-conf-stat conf-no)))
    (if conf
        (lyskom-dispatch-edit-text lyskom-proc
                                   (lyskom-create-misc-list
                                    'RECPT
                                    (server-info->conf-pres-conf 
                                     lyskom-server-info))
                                   conf-name ""
                                   'lyskom-set-presentation conf-no))))


(defun lyskom-set-presentation (text-no conf-no)
  "Set presentation of a conference. Args: text-no conf-no."
  (initiate-set-presentation 'background nil conf-no text-no)
  (cache-del-conf-stat conf-no))	;+++Borde {ndra i cachen i st{llet.
					;+++ Kan tas bort n{r det existerar 
					;asynkrona meddelanden som talar om att
					;n}got {r {ndrat.
    

(defun lyskom-set-conf-motd (text-no conf-no)
  "Set motd of a conference. Args: text-no conf-no."
  (initiate-set-conf-motd 'background nil conf-no text-no)
  (cache-del-conf-stat conf-no))	;+++Borde {ndra i cachen i st{llet.
					;+++ Kan tas bort n{r det existerar 
					;asynkrona meddelanden som talar om att
					;n}got {r {ndrat.
    

;;; ================================================================
;;;                  Kommentera - write comment
;;; Author: ???
;;; FIXME: Does not use def-kom-command


(defun kom-write-comment (text-no)
  "Write a comment to a text.
If optional arg TEXT-NO is present write a comment to that text instead."
  (interactive (list 
                (let ((lyskom-current-command 'kom-write-comment))
                  (lyskom-read-text-no-prefix-arg 'what-comment-no))))
  (lyskom-start-of-command (concat 
			    (lyskom-command-name 'kom-write-comment)
			    (if text-no 
				(lyskom-format " (%#1n)" text-no)
			      "")))
  (unwind-protect
      (if text-no
          (blocking-do-multiple ((text (get-text text-no))
                                 (text-stat (get-text-stat text-no)))
            (when (or (null (text-stat-find-aux text-stat 4))
                      (lyskom-j-or-n-p 
                       (lyskom-get-string 'no-comments-q)))
              (if (and (text-stat-find-aux text-stat 5)
                       (lyskom-j-or-n-p
                        (lyskom-get-string 'private-answer-q)))
                  (lyskom-private-answer-soon
                   text-stat
                   text
                   text-no)
              (lyskom-write-comment-soon text-stat
                                         text
                                         text-no
                                         'comment))))
        (lyskom-insert-string 'confusion-who-to-reply-to))
    (lyskom-end-of-command)))


(def-kom-command kom-write-footnote (text-no)
  "Write a footnote to a text.
If optional arg TEXT-NO is present write a footnote to that text instead."
  (interactive (list (lyskom-read-text-no-prefix-arg 'what-footnote-no nil
                                                     'last-seen-written)))
  (if text-no
      (lyskom-write-comment-soon
       (blocking-do 'get-text-stat text-no)
       (blocking-do 'get-text text-no)
       text-no 'footnote)
    (lyskom-insert-string 'confusion-what-to-footnote)))


(def-kom-command kom-comment-previous (text-no)
  "Write a comment to previously viewed text."
  (interactive (list (lyskom-read-text-no-prefix-arg 'what-comment-no nil
                                                     lyskom-previous-text)))
  (if text-no
      (blocking-do-multiple ((text-stat (get-text-stat text-no))
                             (text (get-text text-no)))
        (when (or (null text-stat)
                  (null text)
                  (null (text-stat-find-aux text-stat 4))
                  (lyskom-j-or-n-p 
                   (lyskom-get-string 'no-comments-q)))
          (if (and (text-stat-find-aux text-stat 5)
                   (lyskom-j-or-n-p
                    (lyskom-get-string 'private-answer-q)))
              (lyskom-private-answer-soon
               text-stat
               text
               text-no)
            (lyskom-write-comment-soon
             text-stat
             text
             text-no
             'comment))))
    (lyskom-insert-string 'confusion-what-to-comment)))


(defun lyskom-write-comment-soon (text-stat text text-no type)
  "Write a comment to the text with TEXT-STAT, TEXT and, TEXT-NO.
TYPE is either 'comment or 'footnote."
  (let ((str (and text-stat text (text->decoded-text-mass text text-stat))))
    (cond
     ;; Text not found?
     ((or (null text-stat)
          (null text))
      (lyskom-format-insert 'cant-read-textno text-no))
     ;; Give header.
     ((string-match "\n" str)
      (lyskom-write-comment text-stat
                            (substring str 0 (match-beginning 0))
                            type))
     ;; The commented text had no header.
     (t (lyskom-write-comment text-stat "" type)))))


(defun lyskom-write-comment (text-stat subject type)
  "Write a comment to the text associated with TEXT-STAT.
The default subject is SUBJECT. TYPE is either 'comment or 'footnote."
  (if (null text-stat)
      (progn
        (lyskom-insert-string 'confusion-what-to-comment))
    (let ((ccrep nil)
          (bccrep nil))
      (lyskom-tell-internat (if (eq type 'comment)
                                'kom-tell-write-comment
                              'kom-tell-write-footnote))
      (let (data)
        (mapcar 
         (function
          (lambda (misc-info)
            (cond
             ((eq 'RECPT (misc-info->type misc-info))
              (setq data 
                    (cons (blocking-do 'get-conf-stat 
                                       (misc-info->recipient-no misc-info))
                          data)))
             ((and (eq type 'footnote)
                   (eq 'CC-RECPT (misc-info->type misc-info)))
              (setq ccrep (cons (misc-info->recipient-no misc-info) 
                                ccrep))
              (setq data (cons (blocking-do 'get-conf-stat
                                            (misc-info->recipient-no misc-info))
                               data)))
             ((and (eq type 'footnote)
                   (eq 'BCC-RECPT (misc-info->type misc-info)))
              (setq bccrep (cons (misc-info->recipient-no misc-info) 
                                 bccrep))
              (setq data (cons (blocking-do 'get-conf-stat
                                            (misc-info->recipient-no misc-info))
                               data))))))
         (text-stat->misc-info-list text-stat))
        (lyskom-comment-recipients (nreverse data)
                                   lyskom-proc 
                                   text-stat
                                   subject 
                                   type 
                                   (nreverse ccrep) 
                                   (nreverse bccrep))))))


(defun lyskom-comment-recipients (data lyskom-proc text-stat
				       subject type ccrep bccrep)
  "Compute recipients to a comment to a text.
Args: DATA, LYSKOM-PROC TEXT-STAT SUBJECT TYPE CCREP BCCREP.
DATA is a list of all the recipients that should receive this text.
If DATA contains more than one conference the user is asked (using y-or-n-p)
if all conferences really should receive the text.
The call is continued to the lyskom-edit-text.
TYPE is info whether this is going to be a comment of footnote.
CCREP is a list of all recipients that are going to be cc-recipients.
BCCREP is a list of all recipient that are going to be bcc-recipients."

  (condition-case nil
      ;; Catch any quits
      (progn
	;; Filter multiple recipients through y-or-n-p.
	(if (and (eq kom-confirm-multiple-recipients 'before)
                 (> (length data) 1)
		 (not (and (= (length data) 2)
			   (or (= lyskom-pers-no (conf-stat->conf-no
						  (car data)))
			       (= lyskom-pers-no (conf-stat->conf-no
						  (car (cdr data))))))))
	    (let ((new-data nil))
	      (while data
		(if (lyskom-j-or-n-p (lyskom-format 'comment-keep-recpt-p
					     (conf-stat->name (car data))))
		    (setq new-data (cons (car data) new-data)))
		(setq data (cdr data)))
	      (setq data (nreverse new-data))))	    

	(let* ((member nil)
	       (recver (lyskom-create-misc-list
			(cond 
			 ((eq type 'comment) 'COMM-TO)
			 ((eq type 'footnote) 'FOOTN-TO)
			 (t (signal 'lyskom-internal-error
				    (list "Unknown comment type" type))))
			(text-stat->text-no text-stat)))
	       (recpts nil))
	  (while data
	    (let* ((conf-stat (car data))
                   (confno (conf-stat->conf-no conf-stat))
                   (commno (if (eq type 'footnote)
                               confno
                             (conf-stat->comm-conf conf-stat))))
	      (if (memq commno recpts)
		  nil
		(setq recver
		      (append recver
			      (list
			       (cons (cond
                                      ((memq confno ccrep) 'CC-RECPT)
                                      ((memq confno bccrep) 'BCC-RECPT)
                                      (t 'RECPT))
                                     commno))))
		(if (lyskom-get-membership commno)
		    (setq member t))
		(setq recpts (cons commno recpts))))
	    (setq data (cdr data)))
	  ;; Add the user to the list of recipients if he isn't a member in
	  ;; any of the recipients.
	  (when (not member)
	      (setq recver (append recver
				   (list (cons 'RECPT lyskom-pers-no)))))
	  (lyskom-edit-text lyskom-proc 
			    recver
			    subject "")))

    (quit (signal 'quit nil))))


;;; ================================================================
;;;                Personligt svar - personal answer

;;; Author: ???
;;; Rewritten using blocking-do by: Linus Tolke


(def-kom-command kom-private-answer (text-no)
  "Write a private answer to the current text.
If optional arg TEXT-NO is present write a private answer to
that text instead."
  (interactive (list (lyskom-read-text-no-prefix-arg 'what-private-no)))
  (if text-no
      (blocking-do-multiple ((text-stat (get-text-stat text-no))
                             (text (get-text text-no)))
        (when (or (null (text-stat-find-aux text-stat 4))
                  (lyskom-j-or-n-p 
                   (lyskom-get-string 'no-comments-q)))
          (lyskom-private-answer-soon text-stat text text-no)))
    (lyskom-insert-string 'confusion-who-to-reply-to)))


(defun lyskom-private-answer-soon (text-stat text text-no)
  "Write a private answer to TEXT-STAT, TEXT."
  (if (and text-stat text)
      (let ((str (text->decoded-text-mass text text-stat)))
        (if (string-match "\n" str)
            (lyskom-private-answer text-stat
                                   (substring str
                                              0 (match-beginning 0)))
          (lyskom-private-answer text-stat "")))
    (lyskom-format-insert 'no-such-text-no text-no)))


(defun lyskom-private-answer (text-stat subject)
  "Write a private answer. Args: TEXT-STAT SUBJECT."
  (cond ((null text-stat)
         (lyskom-insert-string 'confusion-what-to-answer-to))
        ((= (text-stat->author text-stat) 0)
         (lyskom-insert-string 'personal-comment-to-anonymous))
        (t
         (lyskom-tell-internat 'kom-tell-write-reply)
         (cache-del-conf-stat (text-stat->author text-stat))
         (let* ((conf-stat (blocking-do 'get-conf-stat
                                        (text-stat->author text-stat))))
           (if (if (zerop (conf-stat->msg-of-day conf-stat))
                   t
                 (progn
                   (recenter 1)
                   (lyskom-format-insert 'has-motd
                                         conf-stat)
                   (lyskom-view-text (conf-stat->msg-of-day conf-stat))
                   (if (lyskom-j-or-n-p (lyskom-get-string 'motd-persist-q))
                       t
                     nil)))

               (lyskom-edit-text lyskom-proc
                                 (if (= (text-stat->author text-stat) lyskom-pers-no)
                                     (lyskom-create-misc-list
                                      'RECPT
                                      (text-stat->author text-stat))
                                   (lyskom-create-misc-list
                                    'COMM-TO (text-stat->text-no text-stat)
                                    'RECPT (text-stat->author text-stat)
                                    'RECPT lyskom-pers-no))
                                 subject ""))))))


;;; ================================================================
;;;    Personligt svar p} f|reg}ende - kom-private-answer-previous

;;; Author: ceder
;;; Rewritten using blocking-do by: Linus Tolke

(def-kom-command kom-private-answer-previous (text-no)
  "Write a private answer to previously viewed text."
  (interactive (list (lyskom-read-text-no-prefix-arg 'what-private-no nil
                                                     lyskom-previous-text)))
  (if text-no
      (blocking-do-multiple ((text-stat (get-text-stat text-no))
                             (text (get-text text-no)))
        (when (or (null (text-stat-find-aux text-stat 4))
                  (lyskom-j-or-n-p 
                   (lyskom-get-string 'no-comments-q)))
          (lyskom-private-answer-soon text-stat text text-no)))
    (lyskom-insert-string 'confusion-who-to-reply-to)))


;;; ================================================================
;;;                         Sluta - quit

;;; Author: ???


(defun kom-quit (&optional arg)
  "Quit session. Kill process and buffer-local variables.
If optional argument is non-nil then dont ask for confirmation."
  (interactive "P")
  (lyskom-start-of-command 'kom-quit t)
  (let ((do-end-of-command t))
    (unwind-protect
        (setq do-end-of-command
              (cond
               ((and (lyskom-buffers-of-category 'write-texts)
                     (display-buffer 
                      (car (lyskom-buffers-of-category 'write-texts)))
                     (not (lyskom-ja-or-nej-p
                           (lyskom-get-string 'quit-in-spite-of-unsent))))
                t)
               ((or arg (lyskom-ja-or-nej-p (lyskom-get-string 'really-quit)))
                (lyskom-quit) nil)
               (t t)))
      (if do-end-of-command (lyskom-end-of-command)))))


(defun lyskom-quit ()
  "Quit a session. Kill process and buffer-local variables.
Don't ask for confirmation."
    (initiate-logout 'main nil)
    (lyskom-remove-unread-buffer lyskom-buffer)
    (set-process-sentinel lyskom-proc nil)
    (delete-process lyskom-proc)
    (lyskom-insert-string (lyskom-get-string-sol 'session-ended))
    (lyskom-scroll)
    (setq mode-line-process (lyskom-get-string 'mode-line-down))
    (run-hooks 'kom-quit-hook)

    (when (boundp 'lyskom-ssh-proxy)
      (let* ((numleft (1- (get lyskom-ssh-proxy 'num-connected)))
             (procname (symbol-name lyskom-ssh-proxy))
             (bufname (concat " *" procname "*"))
             (proc (get-process procname)))
        (put lyskom-ssh-proxy 'num-connected numleft)
        (when (and (<= numleft 0) proc)
          (string-match "^ssh<\\([^:]*\\)" procname)
          (lyskom-message 
           "%s"
           (lyskom-format 'ssh-closing
                          (or (match-string 1 procname) 
                              (lyskom-get-string 'ssh-unknown-host))))
          (delete-process proc)
          (when (get-buffer bufname)
            (save-excursion
              (set-buffer bufname)
              (goto-char (point-max))
              (insert "\n--- closed connection ---\n")))))))
  

;;; ================================================================
;;;     	[ndra presentation - Change presentation 
;;;	         S{tta lapp p} d|rren - Change conf-motd

;;; Author: Inge Wallin
;;; Changed by Linus Tolke


(def-kom-command kom-change-presentation ()
  "Change presentation for a person or a conference."
  (interactive)
  (lyskom-change-pres-or-motd-2
   (let ((no (lyskom-read-conf-no 
	      (lyskom-get-string 'what-to-change-pres-you)
	      '(all) t nil t)))
     (if (zerop no)
	 (setq no lyskom-pers-no))
     (blocking-do 'get-conf-stat no))
   'pres))



(def-kom-command kom-change-conf-motd ()
  "Change motd for a person or a conference."
  (interactive)
  (lyskom-change-pres-or-motd-2
   (let ((no (lyskom-read-conf-no (lyskom-get-string 'who-to-put-motd-for)
				  '(all) t nil t)))
     (if (zerop no)
	 (setq no lyskom-pers-no))
     (blocking-do 'get-conf-stat no))
   'motd))


(defun lyskom-get-recipients-from-misc-list (misc-list)
  "Return a misc-info-list containing only the recipients."
  (let* ((info (car misc-list))
	 (type (misc-info->type info)))
    (cond ((null misc-list) '())
	  ((memq type lyskom-recpt-types-list)
	   (append (list (intern (symbol-name type))
			 (misc-info->recipient-no info))
		   (lyskom-get-recipients-from-misc-list
		    (cdr misc-list))))
	  (t
	   (lyskom-get-recipients-from-misc-list
	    (cdr misc-list))))))


(defun lyskom-change-pres-or-motd-2 (conf-stat type)
  "Change the presentation or motd of CONF-STAT.
TYPE is either 'pres or 'motd, depending on what should be changed."
  (cond
   ((null conf-stat)			;+++ annan felhantering
    (lyskom-insert-string 'cant-get-conf-stat))
   ((or lyskom-is-administrator
	(lyskom-get-membership (conf-stat->supervisor conf-stat) t)
	(= lyskom-pers-no (conf-stat->conf-no conf-stat)))
    (blocking-do-multiple ((text-stat (get-text-stat
                                       (conf-stat->presentation conf-stat)))
                           (text-mass (get-text 
                                       (cond
                                        ((eq type 'pres)
                                         (conf-stat->presentation conf-stat))
                                        ((eq type 'motd)
                                         (conf-stat->msg-of-day conf-stat))))))
      (let ((str (and text-mass (text->decoded-text-mass
                                 text-mass text-stat))))
        (lyskom-dispatch-edit-text
         lyskom-proc
         (apply
          'lyskom-create-misc-list
          (if (and (eq type 'pres)
                   (not (or (zerop (conf-stat->presentation conf-stat))
                            (null text-stat))))
              (append
               (lyskom-get-recipients-from-misc-list
                (text-stat->misc-info-list text-stat))
               (list 'COMM-TO
                     (conf-stat->presentation conf-stat)))
            (list 'RECPT
                  (cond
                   ((eq type 'motd)
                    (server-info->motd-conf lyskom-server-info))
                   ((eq type 'pres)
                    (if (conf-type->letterbox
                         (conf-stat->conf-type conf-stat))
                        (server-info->pers-pres-conf 
                         lyskom-server-info)
                      (server-info->conf-pres-conf
                       lyskom-server-info)))))))
         (conf-stat->name conf-stat)
         (if (and text-mass (string-match "\n" str))
             (substring str (match-end 0))
           (if (and (eq type 'pres)
                    (conf-type->letterbox (conf-stat->conf-type conf-stat)))
               (lyskom-get-string 'presentation-form)
             ""))
         (cond
          ((eq type 'pres) 'lyskom-set-presentation)
          ((eq type 'motd) 'lyskom-set-conf-motd))
         (conf-stat->conf-no conf-stat)))))
   (t
    (lyskom-format-insert 'not-supervisor-for
			  conf-stat))))


(def-kom-command kom-set-presentation (arg)
  "Add a presentation for a person or conference."
  (interactive "P")
   (let ((conf-no (lyskom-read-conf-no
                   (lyskom-get-string 'what-to-set-pres-you)
                   '(all) t nil t))
         (text-no (lyskom-read-text-no-prefix-arg 'what-text-to-set-as-pres-no t
                                                  lyskom-previous-text)))
     (when (zerop conf-no)
         (setq conf-no lyskom-pers-no))
     (lyskom-set-pres-or-motd-2
      conf-no
      text-no
      'pres)))

(def-kom-command kom-set-motd-text (arg)
  "Add a presentation for a person or conference."
  (interactive "P")
   (let ((conf-no (lyskom-read-conf-no
                   (lyskom-get-string 'what-to-set-pres-you)
                   '(all) t nil t))
         (text-no (lyskom-read-text-no-prefix-arg 'what-text-to-set-as-pres-no t
                                                  lyskom-previous-text)))
     (when (zerop conf-no)
         (setq conf-no lyskom-pers-no))
     (lyskom-set-pres-or-motd-2
      conf-no
      text-no
      'motd)))

(defun lyskom-set-pres-or-motd-2 (conf-no text-no what)
  (let ((set-pres (eq what 'pres)))
    (blocking-do-multiple ((conf-stat (get-conf-stat conf-no))
                           (text-stat (get-text-stat text-no)))
      (cond ((null conf-stat)
             (lyskom-format-insert 'no-such-conf-or-pers)) 
            ((null text-stat)
             (lyskom-format-insert 'no-such-text-no text-no))
            (t
             (let ((existing (if set-pres
                                 (conf-stat->presentation conf-stat)
                               (conf-stat->msg-of-day conf-stat))))
               (when (or (zerop existing)
                         (progn (lyskom-view-text existing)
                                (lyskom-j-or-n-p 
                                 (lyskom-get-string (if set-pres
                                                        'conf-already-has-pres
                                                      'conf-already-has-motd)))))
                 (cache-del-conf-stat conf-no)
                 (cache-del-text-stat text-no)
                 (lyskom-format-insert (if set-pres
                                           'setting-conf-pres
                                         'setting-conf-motd)
                                       conf-stat text-no)
                 (lyskom-report-command-answer 
                  (cond ((eq what 'pres)
                         (blocking-do 'set-presentation conf-no text-no))
                        ((eq what 'motd)
                         (blocking-do 'set-conf-motd conf-no text-no)))))))))))

(def-kom-command kom-remove-presentation ()
  "Removes a presentation for a person or a conference."
  (interactive)
  (let ((conf-stat (or (lyskom-read-conf-stat
                        (lyskom-get-string 'who-to-remove-pres-for)
                        '(all) t nil t)
                       (blocking-do 'get-conf-stat lyskom-pers-no))))
    (cond ((null conf-stat)
           (lyskom-insert-string 'cant-get-conf-stat))
          ((zerop (conf-stat->presentation conf-stat))
           (lyskom-format-insert 'has-no-presentation conf-stat))
          (t
           (lyskom-format-insert 'removing-pres-for-conf conf-stat 
                                 (conf-stat->presentation conf-stat))
           (lyskom-report-command-answer
            (blocking-do 'set-presentation (conf-stat->conf-no conf-stat) 0))))))

;;; ================================================================
;;;           Ta bort lapp p} d|rren - delete conf-motd

;;; Author: Linus Tolke (& Inge Wallin)


(def-kom-command kom-unset-conf-motd ()
  "Removes motd for a person or a conference."
  (interactive)
  (let ((conf-stat (or (lyskom-read-conf-stat
			(lyskom-get-string 'who-to-remove-motd-for)
			'(all) t nil t)
		       (blocking-do 'get-conf-stat lyskom-pers-no))))
    (cond
     ((null conf-stat)
      (lyskom-insert-string 'cant-get-conf-stat))
     ((or lyskom-is-administrator
	  (lyskom-get-membership (conf-stat->supervisor conf-stat) t))
      ;; This works like a dispatch. No error handling.
      (lyskom-set-conf-motd 0 (conf-stat->conf-no conf-stat)))
     (t
      (lyskom-format-insert 'not-supervisor-for
			    conf-stat)))))
  

;;; ================================================================
;;;               G} till M|te - Go to a conference.

;;; Author: ???

(def-kom-command kom-go-to-conf (&optional conf-no)
  "Select a certain conference.
The user is prompted for the name of the conference.
If s/he was already reading a conference that conference will be put
back on lyskom-to-do-list."
  (interactive)
  (let ((conf (if conf-no
                  (blocking-do 'get-conf-stat conf-no)
                (lyskom-read-conf-stat
                 (lyskom-get-string 'go-to-conf-p)
                 '(all) nil "" t))))
  (when (lyskom-check-go-to-conf conf)
    (lyskom-go-to-conf conf))))


(defun lyskom-go-to-conf (conf &optional no-prompt)
  "Go to the conference in CONF. CONF can be conf-no of conf-stat.
Allowed conferences are conferences and the mailboxes you are 
member of.
If NO-PROMPT is non-nil, don't print message that we have gone to conf."
  (if (numberp conf) (setq conf (blocking-do 'get-conf-stat conf)))
  (let ((membership (lyskom-get-membership (conf-stat->conf-no conf) t)))
    (unless no-prompt
      (lyskom-format-insert 'go-to-conf conf))

    ;; FIXME: DEBUG+++
    (let ((lyskom-inhibit-prefetch t))

      (cond
       (membership
	(lyskom-do-go-to-conf conf membership))
       ((conf-type->letterbox (conf-stat->conf-type conf))
	(lyskom-format-insert 'cant-go-to-his-mailbox
			      conf))
       (t
	(progn
	  (lyskom-format-insert 'not-member-of-conf
				conf)
	  (lyskom-scroll)
	  (if (lyskom-j-or-n-p (lyskom-get-string 'want-become-member))
	      (if (lyskom-add-member-by-no (conf-stat->conf-no conf)
					   lyskom-pers-no)
		  (lyskom-do-go-to-conf conf
					(lyskom-get-membership
					 (conf-stat->conf-no conf) t))
		(lyskom-insert-string 'nope))
	    (lyskom-insert-string 'no-ok))))))

    ;; DEBUG+++
    (lyskom-continue-prefetch)
    ))
  

;; Dead function /davidk 960217
;;(defun lyskom-fixup-and-go-to-conf (conf-no)
;;  "Prefetches and after lyskom-member-in-conf and then goes to CONF-NO."
;;  (lyskom-do-go-to-conf (blocking-do 'get-conf-stat conf-no)
;;			(lyskom-member-p conf-no)))

 
(defun lyskom-do-go-to-conf (conf-stat membership)
  "Go to a conference. Args: CONF-STAT MEMBERSHIP.
 Put a read-info of type CONF first on lyskom-reading-list.
Args: CONF-STAT MEMBERSHIP"
  (let ((priority (lyskom-get-current-priority)))
    (lyskom-maybe-move-unread nil)
    (if conf-stat
	(lyskom-set-mode-line conf-stat))
    (let ((r 0)
	  (len (read-list-length lyskom-to-do-list)) 
	  (found nil))
      (while (and (not found)
		  (< r len))
	(if (and (read-info->conf-stat (read-list->nth lyskom-to-do-list r))
		 (= (conf-stat->conf-no conf-stat)
		    (conf-stat->conf-no 
		     (read-info->conf-stat 
		      (read-list->nth lyskom-to-do-list r)))))
	    (setq found t)
	  (++ r)))

      (cond (found
             (let ((read-info (read-list->nth lyskom-to-do-list r)))
               (read-list-enter-first read-info lyskom-reading-list)
               (read-list-delete-read-info (conf-stat->conf-no conf-stat)
                                           lyskom-to-do-list)
               (read-list-enter-first read-info lyskom-to-do-list)
               (set-read-info->priority read-info priority)
               (lyskom-enter-conf conf-stat read-info)))
	    (t
	     (lyskom-go-to-empty-conf conf-stat))))))



(defun lyskom-go-to-empty-conf (conf-stat)
  "Go to a conference with no unseen messages. Args: CONF-STAT."
  (unless lyskom-is-anonymous
    (blocking-do 'pepsi (conf-stat->conf-no conf-stat)))
  (lyskom-run-hook-with-args 'lyskom-change-conf-hook 
                      lyskom-current-conf
                      (conf-stat->conf-no conf-stat))
  (lyskom-run-hook-with-args 'kom-change-conf-hook 
                      lyskom-current-conf
                      (conf-stat->conf-no conf-stat))
  (setq lyskom-current-conf (conf-stat->conf-no conf-stat))
  (lyskom-enter-conf-print-unread conf-stat 0)
  (lyskom-run-hook-with-args 'lyskom-after-change-conf-hook 
                      lyskom-current-conf
                      (conf-stat->conf-no conf-stat))
  (lyskom-run-hook-with-args 'kom-after-change-conf-hook 
                      lyskom-current-conf
                      (conf-stat->conf-no conf-stat)))



;;(def-kom-var kom-im-conf-no 6
;;  "*Conf-no of IM."
;;local)

;;(defun kom-change-to-im-hook (old new)
;;  (cond ((eq new kom-im-conf-no)
;;         (make-local-variable kom-im-saved-variables)
;;         (setq kom-im-saved-variables
;;               (list kom-check-commented-author-membership
;;                     kom-check-for-new-comments
;;                     kom-confirm-multiple-recipients))
;;         (setq kom-check-commented-author-membership nil
;;               kom-check-for-new-comments nil
;;               kom-confirm-multiple-recipients nil))
;;        (t (when kom-im-saved-variables
;;             (setq kom-check-commented-author-membership 
;;                   (elt kom-im-saved-variables 0)
;;                   kom-check-for-new-comments
;;                   (elt kom-im-saved-variables 1)
;;                   kom-confirm-multiple-recipients
;;                   (elt kom-im-saved-variables 2))))))

         

(defun lyskom-get-current-priority ()
  "Return the current priority level."
  (or (read-info->priority (read-list->first 
			    lyskom-reading-list))
      (read-info->priority (read-list->first
			    lyskom-to-do-list))
      -1))


;;; ================================================================
;;;                 Skriva inl{gg - write text

;;; Author: ???


(def-kom-command kom-write-text (&optional arg)
  "write a text."
  (interactive "P")
  (let ((recpt nil))
    (cond ((consp arg) (setq recpt
                         (lyskom-read-conf-no
                          (lyskom-get-string 'who-send-text-to)
                          '(all) nil nil t)))
          ((numberp arg) (setq recpt arg))
          (t (setq recpt lyskom-current-conf)))
    (if (or (null recpt)
            (zerop recpt))
	(lyskom-insert-string 'no-in-conf)
      (lyskom-tell-internat 'kom-tell-write-text)
      (lyskom-edit-text lyskom-proc
                        (lyskom-create-misc-list 'RECPT
                                                 recpt)
                        "" ""))))


;;; ================================================================
;;;                 Lista Personer - List persons

;;; Author: ceder
;;; Rewritten: linus

(def-kom-command kom-list-persons (match)
  "List all conferences whose name matches MATCH (a string).
Those that you are not a member in will be marked with an asterisk."
  (interactive (list (lyskom-read-string
		      (lyskom-get-string 'search-for-pers))))
  (let ((result (blocking-do 'lookup-z-name match 1 0)))
    (if result 
        (if (conf-z-info-list->conf-z-infos result)
            (lyskom-traverse info (conf-z-info-list->conf-z-infos result)
              (lyskom-list-pers-print info))
          (lyskom-format-insert 'no-matching-perss match))
      (lyskom-insert (lyskom-current-error)))))


(defun lyskom-list-pers-print (conf-z)
  "Print name of the person CONF-NO for kom-list-persons."
  (lyskom-format-insert "%[%#1@%5#2:p %#2P%]\n"
			(lyskom-default-button 'pers (conf-z-info->conf-no conf-z))
			conf-z))



;;; ================================================================
;;;              Lista M|ten - List conferences

;;; Author: ceder
;;; Rewritten: linus

(def-kom-command kom-list-conferences (&optional match)
  "List all conferences whose name matches MATCH (a string).
Those that you are not a member in will be marked with an asterisk."
  (interactive)

  (unless kom-allow-incompleteness
    (sit-for 0)
    (lyskom-prefetch-all-confs))

  (setq match (or match
                  (lyskom-read-string
                   (lyskom-get-string 'search-for-conf))))
  (let ((result (blocking-do 'lookup-z-name match 0 1)))
    (if result 
        (if (conf-z-info-list->conf-z-infos result)
            (lyskom-traverse info (conf-z-info-list->conf-z-infos result)
              (lyskom-list-conf-print info))
          (lyskom-format-insert 'no-matching-confs match))
      (lyskom-insert (lyskom-current-error)))))


(def-kom-command kom-list-created-conferences (arg)
  "List all conferences created by some person."
  (interactive "P")

  (unless kom-allow-incompleteness
    (sit-for 0)
    (lyskom-prefetch-all-confs))

  (blocking-do 'get-uconf-stat lyskom-pers-no)
  (let ((pers (lyskom-read-conf-stat
                  (if arg 'list-pers-confs-created-by 'list-confs-created-by)
                  '(all) 
                  nil
                  (if (cache-get-uconf-stat lyskom-pers-no)
                      (cons (conf-stat->name (cache-get-uconf-stat lyskom-pers-no)) 0)1
                      nil)
                  t)))
    (lyskom-format-insert 'listing-confs-created-by (conf-stat->conf-no pers))
    (lyskom-message (lyskom-get-string (if arg 'getting-all-pers-confs 'getting-all-confs)))
    (let ((result (blocking-do 'lookup-z-name "" (if arg 1 0) 1)))
      (lyskom-message (lyskom-get-string (if arg 'getting-all-pers-confs-done 'getting-all-confs-done)))
      (if result
          (if (conf-z-info-list->conf-z-infos result)
              (let ((counter (vector nil
                                     1
                                     (length (conf-z-info-list->conf-z-infos result))
                                     0))
                    (calls nil)
                    (was-at-max (= (save-excursion (end-of-line) (point)) (point-max))))
                (condition-case arg
                    (progn
                      (lyskom-traverse conf-z (conf-z-info-list->conf-z-infos result)
                        (setq calls (cons
                                     (initiate-get-conf-stat 'main
                                                             'lyskom-list-created-conferences-2
                                                             (conf-z-info->conf-no conf-z)
                                                             counter
                                                             (conf-stat->conf-no pers)
                                                             arg
                                                             )
                                     calls)))
                      (lyskom-wait-queue 'main)
                      (if (eq 0 (elt counter 3))
                          (lyskom-format-insert 'no-created-confs pers)
                        (let ((window (get-buffer-window (current-buffer))))
                          (if (and window was-at-max)
                              (if (pos-visible-in-window-p (point-max) window)
                                  (goto-char (point-max))
                                (and kom-continuous-scrolling (lyskom-scroll)))))))
                  (quit (aset counter 0 t)
                        (lyskom-cancel-call 'main calls)
                        (signal 'quit nil))))
            (lyskom-insert (lyskom-get-string (if arg 'no-pers-confs-exist 'no-confs-exist))))
        (lyskom-format-insert (lyskom-current-error))))))

(defun lyskom-list-conf-membership-char (conf-no)
  (if lyskom-membership-is-read
      (cond ((lyskom-get-membership conf-no) ?\ )
            ((lyskom-get-membership conf-no t) ?-)
            (t ?*))
    (cond ((lyskom-try-get-membership conf-no) ?\ )
          ((lyskom-try-get-membership conf-no t) ?-)
          (t ?\?))))

(defun lyskom-list-created-conferences-2 (cs counter pers-no arg)
  (unless (elt counter 0)
    (aset counter 1 (1+ (elt counter 1)))
    (lyskom-message (lyskom-format (if arg 'finding-created-pers-confs 'finding-created-confs)
                                   (elt counter 1)
                                   (elt counter 2)))
    (when (and cs (memq pers-no (list (conf-stat->creator cs)
					(conf-stat->supervisor cs)
					(conf-stat->super-conf cs))))
      (aset counter 3 (1+ (elt counter 3)))
      (lyskom-format-insert "%[%#1@%5#2:m %#3c %4#4s %#5s %#2M%]\n"
                            (lyskom-default-button 'conf (conf-stat->conf-no cs))
                            cs
                            (lyskom-list-conf-membership-char (conf-stat->conf-no cs))
                            (concat (if (eq pers-no (conf-stat->creator cs)) (lyskom-get-string 'created-conf-letter) " ")
                                    (if (eq pers-no (conf-stat->supervisor cs)) (lyskom-get-string 'supervisor-conf-letter) " ")
                                    (if (and (conf-type->original (conf-stat->conf-type cs))
                                             (eq pers-no (conf-stat->super-conf cs)))
                                        (lyskom-get-string 'superconf-conf-letter) " "))
                            (cond ((conf-type->secret (conf-stat->conf-type cs)) (lyskom-get-string 'secret-conf-letter))
                                  ((conf-type->rd_prot (conf-stat->conf-type cs)) (lyskom-get-string 'protected-conf-letter))
                                  (t " ")))
      (sit-for 0))))


(defun lyskom-list-conf-print (conf-z)
  "Print a line of info about CONF-NO.
If you are not member in the conference it will be flagged with an asterisk."
  (lyskom-format-insert "%[%#1@%4#2:m %#3c %#2M%]\n"
			(lyskom-default-button 'conf (conf-z-info->conf-no conf-z))
			conf-z
                        (lyskom-list-conf-membership-char (conf-z-info->conf-no conf-z))))

;;; ================================================================
;;;                Lista med regexpar - List regexp


(defun lyskom-make-re-case-insensitive (re)
  "Convert the regexp RE to a case insensitive regexp."
  (unless lyskom-char-classes
    (setq lyskom-char-classes 
	  (lyskom-compute-char-classes lyskom-collate-table)))
  (let ((res nil)
	(input (listify-vector re))
	val)
    (while input
      (cond

       ;; Copy "[]" character sets literally.
       ((eq (car input) ?\[)
	(setq res (cons "[" res))
	(setq input (cdr input))
	(when input			;Handle "[]asdf]" properly.
	  (setq res (cons (make-string 1 (car input)) res))
	  (setq input (cdr input)))
	(while (and input (not (eq (car input) ?\])))
	  (setq res (cons (make-string 1 (car input)) res))
	  (setq input (cdr input)))
	(when input			;Don't forget the terminating "]".
	  (setq res (cons (make-string 1 (car input)) res))
	  (setq input (cdr input))))

       ;; Copy backslashed sequences literally.
       ((eq (car input) ?\\)
	(setq res (cons "\\" res))
	(setq input (cdr input))
	(when input
	  (setq res (cons (make-string 1 (car input)) res))
	  (setq input (cdr input))))

       ;; Copy special characters literally.
       ((memq (car input) '(?\( ?\) ?\| ?+ ?\* ?\?))
	(setq res (cons (make-string 1 (car input)) res))
	(setq input (cdr input)))

       ;; Create "[]" character sets for equivalent characters.
       ((setq val (cdr-safe (assoc (car input) lyskom-char-classes)))
	(setq res (cons "[" res))
	(if (member "]" val)		;"]" must come first.
	    (setq res (cons "]" res)))
	(while val
	  (cond
	   ((string= "]" (car val)))		;already handled
	   ((string= "-" (car val))
	    (setq res (cons "---" res)))
	   (t
	    (setq res (cons (car val) res))))
	  (setq val (cdr val)))
	(setq res (cons "]" res))
	(setq input (cdr input)))

       ;; Copy other characters literally.
       (t
	(setq res (cons (make-string 1 (car input)) res))
	(setq input (cdr input)))))

    (apply 'concat (nreverse res))))


(def-kom-command kom-list-re (regexp &optional case-sensitive what)
  "List all persons and conferences whose name matches REGEXP.

By default, the regexp will be converted so that the match is
performed in a case insensitive way.  If the optional argument
CASE-SENSITIVE is true, that conversion will not be performed.

If the optional argument WHAT is 'person, only persons will be listed.
If it is 'conf, only conferences will be listed."
  (interactive (list (lyskom-read-string
		      (lyskom-get-string 'search-re))
		     current-prefix-arg
		     (let ((pers (lyskom-j-or-n-p 'include-persons))
			   (conf (lyskom-j-or-n-p 'include-conferences)))
		       (cond
			((and pers conf) nil)
			(pers 'pers)
			(conf 'conf)
			(t (error "This user interface is stupid."))))))
  (unless case-sensitive
    (setq regexp (lyskom-make-re-case-insensitive regexp)))
  (lyskom-format-insert  (cond
			  ((eq what 'pers) 'matching-regexp-perss)
			  ((eq what 'conf) 'matching-regexp-confs)
			  (t 'matching-regexp))
			 regexp)
  (let ((conf-list (blocking-do 're-z-lookup regexp
				(if (eq what 'conf) 0 1)
				(if (eq what 'pers) 0 1))))
    (if conf-list
        (if (conf-z-info-list->conf-z-infos conf-list)
            (lyskom-traverse czi (conf-z-info-list->conf-z-infos conf-list)
              (lyskom-format-insert
               "%[%#1@%5#2:m %#3c %#2:M%]\n"
               (lyskom-default-button
                'conf (conf-z-info->conf-no czi))
               czi
               (if (conf-type->letterbox 
                    (conf-z-info->conf-type czi))
                   ?P ?M)
               ))
          (lyskom-format-insert (cond
				 ((eq what 'pers) 'no-matching-perss)
				 ((eq what 'conf) 'no-matching-confs)
				 (t 'no-matching-anys))
				regexp))
      (lyskom-format-insert (lyskom-current-error)))))


;;; ================================================================
;;;                 [ndra namn - Change name

;;; Author: Inge Wallin
;;; Changed by: Peter Eriksson(?)
;;; Changed again: Inge Wallin
;;; Rewritten: linus


(def-kom-command kom-change-name ()
  "Change the name of a person or conference."
  (interactive)
  (let ((conf-stat (lyskom-read-conf-stat 
		    (lyskom-get-string 'name-to-be-changed)
		    '(all) nil nil t)))
    (if (null conf-stat)
	(lyskom-insert-string 'no-such-conf-or-pers)
      (let (name)
	(lyskom-format-insert 'about-to-change-name-from
			      conf-stat)
	(lyskom-scroll)
	(lyskom-tell-internat 'kom-tell-change-name)
	(setq name (lyskom-read-string (lyskom-get-string 'new-name)
				       (conf-stat->name conf-stat)))
	(if (blocking-do 'change-name (conf-stat->conf-no conf-stat) name)
            (progn
              (lyskom-format-insert 'change-name-done name
                                    (lyskom-default-button 'conf conf-stat))
              (cache-del-conf-stat (conf-stat->conf-no conf-stat)))
	  (lyskom-format-insert 'change-name-nope name 
				(lyskom-get-error-text lyskom-errno)
				lyskom-errno))))))

;;; ================================================================
;;;                 [ndra parentes - Change parenthesis

;;; Author: Per Cederqvist (template stolen from kom-change-name)

(def-kom-command kom-change-parenthesis ()
  "Change the name of a person or conference."
  (interactive)
  (let ((conf-stat (lyskom-read-conf-stat 
		    (lyskom-get-string 'name-to-be-changed)
		    '(all)
                    nil
                    (cons
                     (conf-stat->name (blocking-do 'get-conf-stat lyskom-pers-no))
                     0)
                    t)))
    (if (null conf-stat)
	(lyskom-insert-string 'no-such-conf-or-pers)
      (if (string-match "^\\(.*\\)(\\(.*\\))\\(.*\\)$" (conf-stat->name conf-stat))
	  (let* ((pre-paren (match-string 1 (conf-stat->name conf-stat)))
                 (post-paren (match-string 3 (conf-stat->name conf-stat)))
		 (old-paren (match-string 2 (conf-stat->name conf-stat)))
		 (paren (lyskom-read-string (lyskom-get-string 'new-paren)
					    old-paren))
		 (name (concat pre-paren "(" paren ")" post-paren)))
	    (if (blocking-do 'change-name (conf-stat->conf-no conf-stat) name)
                (progn
                  (lyskom-format-insert 'change-name-done name
                                        (lyskom-default-button 'conf conf-stat))
                  (cache-del-conf-stat (conf-stat->conf-no conf-stat)))
	      (lyskom-format-insert 'change-name-nope name
				    (lyskom-get-error-text lyskom-errno)
				    lyskom-errno)))
	(lyskom-insert-string 'no-paren-in-name)))))
	    


;;; ================================================================
;;;                [ndra organisat|r - Change supervisor

;;; Author: Inge Wallin
;;; Rewritten: linus

(def-kom-command kom-change-supervisor ()
  "Change the supervisor of a person or conference."
  (interactive)
  (let ((supervisee (lyskom-read-conf-stat
		     (lyskom-get-string 'who-to-change-supervisor-for)
		     '(all) nil nil t)))
    (if (null supervisee)
	(lyskom-insert-string 'no-such-conf-or-pers)
      (lyskom-tell-internat 'kom-tell-change-supervisor)
      (let ((supervisor (lyskom-read-conf-stat
			 (lyskom-get-string 'new-supervisor)
			 '(all) nil nil t)))
	(lyskom-format-insert 'change-supervisor-from-to
			      supervisee
			      supervisor)
	(if (blocking-do 'set-supervisor 
			 (conf-stat->conf-no supervisee) 
			 (conf-stat->conf-no supervisor))
	    (progn
	      (lyskom-insert-string 'done)
	      (cache-del-conf-stat (conf-stat->conf-no supervisee)))
	  (lyskom-format-insert
	   'change-supervisor-nope
	   supervisee))))))


;;; ================================================================
;;;         Markera och Avmarkera - Mark and Unmark a text

;;; Author: Inge Wallin
;;; Modified by: Linus Tolke, Johan Sundstrm, Joel Rosdahl

(def-kom-command kom-mark-text (&optional text-no)
  "Mark the text TEXT-NO."
  (interactive (list (lyskom-read-text-no-prefix-arg 'text-to-mark)))
  (if text-no
      (lyskom-mark-text text-no)
    (lyskom-insert 'confusion-what-to-mark)))


(def-kom-command kom-unmark-text (&optional text-no)
  "Unmark the text TEXT-NO."
  (interactive (list (lyskom-read-text-no-prefix-arg 'text-to-unmark)))
  (if text-no
      (lyskom-unmark-text text-no)
    (lyskom-insert 'confusion-what-to-unmark)))


(defun lyskom-unmark-text (text-no)
  "Do the actual unmarking of the text TEXT-NO."
  (lyskom-format-insert 'unmarking-textno text-no)

  (if (blocking-do 'unmark-text text-no)
      (progn
	(lyskom-insert-string 'done)
	(cache-del-marked-text text-no))
    (lyskom-insert-string 'nope))     ;+++ lyskom-errno?
  (cache-del-text-stat text-no))


(defun lyskom-mark-text (text-no &optional mark)
  "Mark TEXT-NO using kom-default-mark (if non-nil) or prompt
the user for what mark to use."
  (let ((mark
	 (or mark
	     kom-default-mark
	     (lyskom-read-mark-type (lyskom-get-string 'what-mark) nil t))))
    (lyskom-format-insert 'marking-textno text-no)

    (if (blocking-do 'mark-text text-no mark)
        (progn
          (lyskom-insert-string 'done)
          (cache-add-marked-text text-no mark))
      (lyskom-insert-string 'nope))     ;+++ lyskom-errno?
    (cache-del-text-stat text-no)))

(defun lyskom-read-mark-type (prompt &optional nildefault create-nonexistent)
  "Ask user about symbolic mark type and return the (integer)
mark-type.  Prompt with PROMPT.  If NILDEFAULT is non-nil, nil is
returned if the user enters the empty string, otherwise the user is
prompted again. If CREATE-NONEXISTENT is t, the user is asked whether
the symbolic mark association should be created if it doesn't already
exist."
  (let ((mark-type nil) ; nil: not yet set, 'default: default chosen
        (completion-ignore-case t)
        (completions kom-symbolic-marks-alist))
    (while (and (not (eq mark-type 'default))
                (or (not (integerp mark-type))
                    (< mark-type 0)
                    (> mark-type 255)))
      (let* ((mark (lyskom-completing-read
                    prompt
                    (lyskom-maybe-frob-completion-table completions)))
             (mark-assoc (lyskom-string-assoc mark completions)))
        (cond
         ;; Default completion.
         ((and nildefault
               (stringp mark)
               (string= mark ""))
          (setq mark-type 'default))

         ;; Correct completion.
         (mark-assoc
          (setq mark-type (cdr mark-assoc)))

         ;; Incorrect completion, integer entered.
         ((string-match "\\`[0-9]+\\'" mark)
          (setq mark-type (string-to-int mark)))

         ;; Incorrect completion; create new symbolic mark type.
         ((and create-nonexistent
               (lyskom-j-or-n-p
                (lyskom-format (lyskom-get-string
                                'want-to-create-symbolic-mark)
                               mark)))
          (let ((new-mark-type (lyskom-allocate-mark-type)))
            (if (not new-mark-type)
                (lyskom-insert 'no-mark-types-left)
              (lyskom-format-insert 'creating-symbolic-mark-type
                                    mark
                                    new-mark-type)
              (setq kom-symbolic-marks-alist
                    (cons (cons mark new-mark-type)
                          kom-symbolic-marks-alist))
              (lyskom-save-options
               (current-buffer)
               (lyskom-get-string 'saving-settings)
               (lyskom-get-string 'saving-settings-done)
               (lyskom-get-string 'could-not-save-options))
              (setq mark-type new-mark-type))))

         ;; Incorrect completion.
         (t
          (lyskom-insert 'erroneous-mark)))))

    (if (eq mark-type 'default)
        nil
      mark-type)))


(defun lyskom-allocate-mark-type ()
  "Returns the first mark type available that is neither named nor used.
If no such type existed, the least used non-named mark type is returned.
If no such existed either, nil is returned."
  (setq kom-symbolic-marks-alist
        (sort kom-symbolic-marks-alist
              (function (lambda (x y) (< (cdr x) (cdr y))))))
  (let ((i 0)
        (list kom-symbolic-marks-alist)
	(used (lyskom-get-least-used-mark-types-alist))
        (found nil))
    (while (and (not found)
                (< i 256))
      (when (not (assq i used)) ; mark type i not presently used?
	(when list
	  (if (= i (cdr (car list))) ; already named?
	      (setq list (cdr list))
	    (setq found t)))) ; neither used nor named!
      (when (not found)
	(++ i)))
    (if (and found (< i 256))
        i
      ; no unused and unnamed mark type available; fall back
      ; to the least used not-yet-named type, if available:
      (when (and used
		 (< (length used) 256)
		 (< (length list) 256))
	(cdr (car used))))))


(defun lyskom-get-least-used-mark-types-alist ()
  "Returns an alist from mark type to number of such marks, ordered by
increasing number of marks per mark type (and, when equal, by mark type)."
  (let ((mark-list (cache-get-marked-texts))
	(cnt-alist nil)) ; the number of texts marked by each mark type
    ;; Count the number of texts marked per mark type:
    (while (not (null mark-list))
      (let* ((mark (car mark-list))
	     (type (mark->mark-type mark))
	     (tcnt (assq type cnt-alist)))
	(when tcnt (setq tcnt (cdr tcnt)))
	(setq cnt-alist
	      (lyskom-set-alist
	       cnt-alist type (if (null tcnt) 1 (1+ tcnt)))))
      (setq mark-list (cdr mark-list)))

    ;; Sort the list, least-used, lowest number of mark type first:
    (sort cnt-alist
	  (function (lambda (x y)
		      (cond
		       ((< (cdr x) (cdr y)) t)
		       ((= (cdr x) (cdr y)) (< (car x) (car y)))
		       (t nil)))))))



;;; ================================================================
;;;          ]terse alla markerade - Review marked texts

;;; Author: Inge Wallin
;;; Modified by: Joel Rosdahl

(def-kom-command kom-review-marked-texts ()
  "Review marked texts with a certain mark."
  (interactive)
  (lyskom-review-marked-texts
   (lyskom-read-mark-type (lyskom-get-string 'what-mark-to-view) t)))


(def-kom-command kom-review-all-marked-texts ()
  "Review all marked texts"
  (interactive)
  (lyskom-review-marked-texts nil))


(defun lyskom-review-marked-texts (mark-no)
  "Review all marked texts with the mark equal to MARK-NO. 
If MARK-NO is nil, review all marked texts."
  (let ((mark-list (cache-get-marked-texts))
	(text-list nil))
    (while (not (null mark-list))
      (let ((mark (car mark-list)))
	(if (and mark
		 (or (null mark-no)
		     (eq mark-no (mark->mark-type mark))))
	    (setq text-list (cons (mark->text-no mark)
				  text-list))))
      (setq mark-list (cdr mark-list)))
    (if (eq (length text-list) 0)
	(lyskom-insert (if (null mark-no)
			   (lyskom-get-string 'no-marked-texts)
			 (lyskom-format 'no-marked-texts-mark
                                        (lyskom-symbolic-mark-type-string
                                         mark-no))))
      (let ((read-info (lyskom-create-read-info
			'REVIEW-MARK nil 
			(lyskom-review-get-priority)
			(lyskom-create-text-list text-list)
			nil t)))
	(read-list-enter-read-info read-info lyskom-reading-list t)
	(read-list-enter-read-info read-info lyskom-to-do-list t)))))


;;; ================================================================
;;;                 [ndra L|senord - Change password

;;; Author: Inge Wallin


(def-kom-command kom-change-password ()
  "Change the password for a person."
  (interactive)
  (let ((pers-no (lyskom-read-conf-no (lyskom-get-string 'whos-passwd)
				      '(pers) t "" t))
	(old-pw (silent-read (lyskom-get-string 'old-passwd)))
	(new-pw1 (silent-read (lyskom-get-string 'new-passwd)))
	(new-pw2 (silent-read (lyskom-get-string 'new-passwd-again))))

    (if (lyskom-string= new-pw1 new-pw2)
	(progn
	  (lyskom-insert-string 'changing-passwd)
	  (lyskom-report-command-answer 
	   (blocking-do 'set-passwd (if (zerop pers-no)
					lyskom-pers-no
				      pers-no)
			old-pw new-pw1)))
      (lyskom-insert-string 'retype-dont-match))))



;;; ================================================================
;;;               (Se) Tiden - display time and date.

(defconst lyskom-times
  '(((nil  1  1 nil nil nil) . newyearday)
    ((nil  1  6 nil nil nil) . 13dayxmas)
    ((nil  1 13 nil nil nil) . 20dayxmas)
    ((nil  2  2 nil nil nil) . kyndeldag)
    ((nil  2 29 nil nil nil) . skottdag)
    ((nil  3  8 nil nil nil) . intwomday)
    ((nil  3 25 nil nil nil) . mariebdag)
    ((nil  3 29 nil nil nil) . lysbday)
    ((nil  4 30 nil nil nil) . cgdag)
    ((nil  6  6 nil nil nil) . sixjune)
    ((nil  6 24 nil nil nil) . johannesdday)
    ((nil  8 15 nil nil nil) . holdnose)
    ((nil 10 24 nil nil nil) . fnday)
    ((nil 11  1 nil nil nil) . allhelgonadag)
    ((nil 12 24 nil nil nil) . xmaseve)
    ((nil 12 25 nil nil nil) . xmasday)
    ((nil 12 28 nil nil nil) . varnlosdag)
    ((nil 12 31 nil nil nil) . newyeareve)
    ((nil 12 31  23 nil nil) . newyearevelate)
))


(lyskom-external-function calendar-iso-from-absolute)
(lyskom-external-function calendar-absolute-from-gregorian)

(def-kom-command kom-display-time ()
  "Ask server about time and date."
  (interactive)
  (let ((time (lyskom-current-server-time))
        (lyskom-last-text-format-flags nil)
        (weekno nil))
    (lyskom-format-insert
     (if kom-show-week-number
         (condition-case nil
             (progn (require 'calendar)
                    (require 'cal-iso)
                    (setq weekno
                          (car (calendar-iso-from-absolute
                                (calendar-absolute-from-gregorian 
                                 (list (time->mon time)
                                       (time->mday time)
                                       (time->year time))))))
                    'time-is-week)
           (error 'time-is))
       'time-is)
     (lyskom-format-time 'timeformat-day-yyyy-mm-dd-hh-mm-ss time)
     ;; Kult:
     (if (and (= (time->hour time)
                 (+ (/ (time->sec time) 10)
                    (* (% (time->sec time) 10) 10)))
              (= (/ (time->min time) 10)
                 (% (time->min time) 10)))
         (lyskom-get-string 'palindrome)
       "")
     weekno)
    ;; Mera kult
    (mapcar (function 
             (lambda (el)
               (let ((when (car el))
                     (event (cdr el)))
                 (if (and (or (null (elt when 0))
                              (= (time->year time) (elt when 0)))
                          (or (null (elt when 1))
                              (= (time->mon time) (elt when 1)))
                          (or (null (elt when 2))
                              (= (time->mday time) (elt when 2)))
                          (or (null (elt when 3))
                              (= (time->hour time) (elt when 3)))
                          (or (null (elt when 4))
                              (= (time->min time) (elt when 4)))
                          (or (null (elt when 5))
                              (= (time->sec time) (elt when 5))))
                     (condition-case nil
			 (progn
			   (lyskom-insert " ")
                           (lyskom-format-insert 
                            "%#1t"
                            (lyskom-format event
                                           (time->year time)
                                           (time->mon  time)
                                           (time->mday time)
                                           (time->hour time)
                                           (time->min  time)
                                           (time->sec  time))))
		       (error nil))))))
            lyskom-times)
;;;
;;; +++ FIXME specialhack fr svenska. Borde det generaliseras?
;;;   
    (when (and (eq lyskom-language 'sv) kom-show-namedays)
      (let ((tmp (lyskom-nameday time)))
        (when tmp
          (lyskom-insert "\n")
          (lyskom-insert tmp)))))
  (lyskom-insert "\n"))


;(def-kom-command kom-display-calendar ()
;  "Nothing yet"
;  (interactive)
;  (let* ((time (lyskom-current-server-time))
;         (nameday (lyskom-nameday time))
;         (special (lyskom-special-date time)))
;    ))
    
(defvar lyskom-nameday-alist
  '((1 . ((1 . ())
          (2 . ("Svea"))
          (3 . ("Alfred" "Alfrida"))
          (4 . ("Rut"))
          (5 . ("Hanna" "Hannele"))
          (6 . ("Kasper" "Melker" "Baltsar"))
          (7 . ("August" "Augusta"))
          (8 . ("Erland"))
          (9 . ("Gunnar" "Gunder"))
          (10 . ("Sigurd" "Sigbritt"))
          (11 . ("Jan" "Jannike"))
          (12 . ("Frideborg" "Fridolf"))
          (13 . ("Knut"))
          (14 . ("Felix" "Felicia"))
          (15 . ("Laura" "Lorentz"))
          (16 . ("Hjalmar" "Helmer"))
          (17 . ("Anton" "Tony"))
          (18 . ("Hilda" "Hildur"))
          (19 . ("Henrik"))
          (20 . ("Fabian" "Sebastian"))
          (21 . ("Agnes" "Agneta"))
          (22 . ("Vincent" "Viktor"))
          (23 . ("Frej" "Freja"))
          (24 . ("Erika"))
          (25 . ("Paul" "Pl"))
          (26 . ("Bodil" "Boel"))
          (27 . ("Gte" "Gta"))
          (28 . ("Karl" "Karla"))
          (29 . ("Diana"))
          (30 . ("Gunilla" "Gunhild"))
          (31 . ("Ivar" "Joar"))))

    (2 . ((1 . ("Max" "Maximilian"))
          (2 . ())
          (3 . ("Disa" "Hjrdis"))
          (4 . ("Ansgar" "Anselm"))
          (5 . ("Agata" "Agda"))
          (6 . ("Dorotea" "Doris"))
          (7 . ("Rikard" "Dick"))
          (8 . ("Berta" "Bert"))
          (9 . ("Fanny" "Franciska"))
          (10 . ("Iris"))
          (11 . ("Yngve" "Inge"))
          (12 . ("Evelina" "Evy"))
          (13 . ("Agne" "Ove"))
          (14 . ("Valentin"))
          (15 . ("Sigfrid"))
          (16 . ("Julia" "Julius"))
          (17 . ("Alexandra" "Sandra"))
          (18 . ("Frida" "Fritiof"))
          (19 . ("Gabriella" "Ella"))
          (20 . ("Vivianne"))
          (21 . ("Hilding"))
          (22 . ("Pia"))
          (23 . ("Torsten" "Torun"))
          (24 . ("Mattias" "Mats"))
          (25 . ("Sigvard" "Sivert"))
          (26 . ("Torgny" "Torkel"))
          (27 . ("Lage"))
          (28 . ("Maria"))))

    (3 . ((1 . ("Albin" "Elvira"))
          (2 . ("Ernst" "Erna"))
          (3 . ("Gunborg" "Gunvor"))
          (4 . ("Adrian" "Adriana"))
          (5 . ("Tora" "Tove"))
          (6 . ("Ebba" "Ebbe"))
          (7 . ("Camilla"))
          (8 . ("Siv"))
          (9 . ("Torbjrn" "Torleif"))
          (10 . ("Edla" "Ada"))
          (11 . ("Edvin" "Egon"))
          (12 . ("Viktoria"))
          (13 . ("Greger"))
          (14 . ("Matilda" "Maud"))
          (15 . ("Kristoffer" "Christel"))
          (16 . ("Herbert" "Gilbert"))
          (17 . ("Gertrud"))
          (18 . ("Edvard" "Edmund"))
          (19 . ("Josef" "Josefina"))
          (20 . ("Joakim" "Kim"))
          (21 . ("Bengt"))
          (22 . ("Kennet" "Kent"))
          (23 . ("Gerda" "Gerd"))
          (24 . ("Gabriel" "Rafael"))
          (25 . ())
          (26 . ("Emanuel"))
          (27 . ("Rudolf" "Ralf"))
          (28 . ("Malkolm" "Morgan"))
          (29 . ("Jonas" "Jens"))
          (30 . ("Holger" "Holmfrid"))
          (31 . ("Ester"))))

    (4 . ((1 . ("Harald" "Hervor"))
          (2 . ("Gudmund" "Ingesund"))
          (3 . ("Ferdinand" "Nanna"))
          (4 . ("Marianne" "Marlene"))
          (5 . ("Irene" "Irja"))
          (6 . ("Vilhelm" "Helmi"))
          (7 . ("Irma" "Irmelin"))
          (8 . ("Nadja" "Tanja"))
          (9 . ("Otto" "Ottilia"))
          (10 . ("Ingvar" "Ingvor"))
          (11 . ("Ulf" "Ylva"))
          (12 . ("Liv"))
          (13 . ("Artur" "Douglas"))
          (14 . ("Tiburtius"))
          (15 . ("Olivia" "Oliver"))
          (16 . ("Patrik" "Patricia"))
          (17 . ("Elias" "Elis"))
          (18 . ("Valdemar" "Volmar"))
          (19 . ("Olaus" "Ola"))
          (20 . ("Amalia" "Amelie"))
          (21 . ("Anneli" "Annika"))
          (22 . ("Allan" "Glenn"))
          (23 . ("Georg" "Gran"))
          (24 . ("Vega"))
          (25 . ("Markus"))
          (26 . ("Teresia" "Terese"))
          (27 . ("Engelbrekt"))
          (28 . ("Ture" "Tyra"))
          (29 . ("Tyko"))
          (30 . ("Mariana"))))

    (5 . ((1 . ("Valborg"))
          (2 . ("Filip" "Filippa"))
          (3 . ("John" "Jane"))
          (4 . ("Monika" "Mona"))
          (5 . ("Gotthard" "Erhard"))
          (6 . ("Marit" "Rita"))
          (7 . ("Carina" "Carita"))
          (8 . ("ke"))
          (9 . ("Reidar" "Reidun"))
          (10 . ("Esbjrn" "Styrbjrn"))
          (11 . ("Mrta" "Mrit"))
          (12 . ("Charlotta" "Lotta"))
          (13 . ("Linnea" "Linn"))
          (14 . ("Halvard" "Halvar"))
          (15 . ("Sofia" "Sonja"))
          (16 . ("Ronald" "Ronny"))
          (17 . ("Rebecka" "Ruben"))
          (18 . ("Erik"))
          (19 . ("Maj" "Majken"))
          (20 . ("Karolina" "Carola"))
          (21 . ("Konstantin" "Conny"))
          (22 . ("Hemming" "Henning"))
          (23 . ("Desideria" "Desiree"))
          (24 . ("Ivan" "Vanja"))
          (25 . ("Urban"))
          (26 . ("Vilhelmina" "Vilma"))
          (27 . ("Beda" "Blenda"))
          (28 . ("Ingeborg" "Borghild"))
          (29 . ("Yvonne" "Jeanette"))
          (30 . ("Vera" "Veronika"))
          (31 . ("Petronella" "Pernilla"))))

    (6 . ((1 . ("Gun" "Gunnel"))
          (2 . ("Rutger" "Roger"))
          (3 . ("Ingemar" "Gudmar"))
          (4 . ("Solbritt" "Solveig"))
          (5 . ("Bo"))
          (6 . ("Gustav" "Gsta"))
          (7 . ("Robert" "Robin"))
          (8 . ("Eivor" "Majvor"))
          (9 . ("Brje" "Birger"))
          (10 . ("Svante" "Boris"))
          (11 . ("Bertil" "Berthold"))
          (12 . ("Eskil"))
          (13 . ("Aina" "Aino"))
          (14 . ("Hkan" "Hakon"))
          (15 . ("Margit" "Margot"))
          (16 . ("Axel" "Axelina"))
          (17 . ("Torborg" "Torvald"))
          (18 . ("Bjrn" "Bjarne"))
          (19 . ("Germund" "Grel"))
          (20 . ("Linda"))
          (21 . ("Alf" "Alvar"))
          (22 . ("Paulina" "Paula"))
          (23 . ("Adolf" "Alice"))
          (24 . ())
          (25 . ("David" "Salomon"))
          (26 . ("Rakel" "Lea"))
          (27 . ("Selma" "Fingal"))
          (28 . ("Leo"))
          (29 . ("Peter" "Petra"))
          (30 . ("Elof" "Leif"))))

    (7 . ((1 . ("Aron" "Mirjam"))
          (2 . ("Rosa" "Rosita"))
          (3 . ("Aurora"))
          (4 . ("Ulrika" "Ulla"))
          (5 . ("Laila" "Ritva"))
          (6 . ("Esaias" "Jessika"))
          (7 . ("Klas"))
          (8 . ("Kjell"))
          (9 . ("Jrgen" "rjan"))
          (10 . ("Andre" "Andrea"))
          (11 . ("Eleonora" "Ellinor"))
          (12 . ("Herman" "Hermine"))
          (13 . ("Joel" "Judit"))
          (14 . ("Folke"))
          (15 . ("Ragnhild" "Ragnvald"))
          (16 . ("Reinhold" "Reine"))
          (17 . ("Bruno"))
          (18 . ("Fredrik" "Fritz"))
          (19 . ("Sara"))
          (20 . ("Margareta" "Greta"))
          (21 . ("Johanna"))
          (22 . ("Magdalena" "Madeleine"))
          (23 . ("Emma"))
          (24 . ("Kristina" "Kerstin"))
          (25 . ("Jakob"))
          (26 . ("Jesper"))
          (27 . ("Marta"))
          (28 . ("Botvid" "Seved"))
          (29 . ("Olof"))
          (30 . ("Algot"))
          (31 . ("Helena" "Elin"))))

    (8 . ((1 . ("Per"))
          (2 . ("Karin" "Kajsa"))
          (3 . ("Tage"))
          (4 . ("Arne" "Arnold"))
          (5 . ("Ulrik" "Alrik"))
          (6 . ("Alfons" "Inez"))
          (7 . ("Dennis" "Denise"))
          (8 . ("Silvia" "Sylvia"))
          (9 . ("Roland"))
          (10 . ("Lars"))
          (11 . ("Susanna"))
          (12 . ("Klara"))
          (13 . ("Kaj"))
          (14 . ("Uno"))
          (15 . ("Stella" "Estelle"))
          (16 . ("Brynolf"))
          (17 . ("Verner" "Valter"))
          (18 . ("Ellen" "Lena"))
          (19 . ("Magnus" "Mns"))
          (20 . ("Bernhard" "Bernt"))
          (21 . ("Jon" "Jonna"))
          (22 . ("Henrietta" "Henrika"))
          (23 . ("Signe" "Signhild"))
          (24 . ("Bartolomeus"))
          (25 . ("Lovisa" "Louise"))
          (26 . ("sten"))
          (27 . ("Rolf" "Raoul"))
          (28 . ("Gurli" "Leila"))
          (29 . ("Hans" "Hampus"))
          (30 . ("Albert" "Albertina"))
          (31 . ("Arvid" "Vidar"))))

    (9 . ((1 . ("Samuel"))
          (2 . ("Justus" "Justina"))
          (3 . ("Alfhild" "Alva"))
          (4 . ("Gisela"))
          (5 . ("Adela" "Heidi"))
          (6 . ("Lilian" "Lilly"))
          (7 . ("Regina" "Roy"))
          (8 . ("Alma" "Hulda"))
          (9 . ("Anita" "Annette"))
          (10 . ("Tord" "Turid"))
          (11 . ("Dagny" "Helny"))
          (12 . ("sa" "slg"))
          (13 . ("Sture"))
          (14 . ("Ida"))
          (15 . ("Sigrid" "Siri"))
          (16 . ("Dag" "Daga"))
          (17 . ("Hildegard" "Magnhild"))
          (18 . ("Orvar"))
          (19 . ("Fredrika"))
          (20 . ("Elise" "Lisa"))
          (21 . ("Matteus"))
          (22 . ("Maurits" "Moritz"))
          (23 . ("Tekla" "Tea"))
          (24 . ("Gerhard" "Gert"))
          (25 . ("Tryggve"))
          (26 . ("Enar" "Einar"))
          (27 . ("Dagmar" "Rigmor"))
          (28 . ("Lennart" "Leonard"))
          (29 . ("Mikael" "Mikaela"))
          (30 . ("Helge"))))

    (10 . ((1 . ("Ragnar" "Ragna"))
           (2 . ("Ludvig" "Love"))
           (3 . ("Evald" "Osvald"))
           (4 . ("Frans" "Frank"))
           (5 . ("Bror"))
           (6 . ("Jenny" "Jennifer"))
           (7 . ("Birgitta" "Britta"))
           (8 . ("Nils"))
           (9 . ("Ingrid" "Inger"))
           (10 . ("Harry" "Harriet"))
           (11 . ("Erling" "Jarl"))
           (12 . ("Valfrid" "Manfred"))
           (13 . ("Berit" "Birgit"))
           (14 . ("Stellan"))
           (15 . ("Hedvig" "Hillevi"))
           (16 . ("Finn"))
           (17 . ("Antonia" "Toini"))
           (18 . ("Lukas"))
           (19 . ("Tore" "Tor"))
           (20 . ("Sibylla"))
           (21 . ("Ursula" "Yrsa"))
           (22 . ("Marika" "Marita"))
           (23 . ("Severin" "Sren"))
           (24 . ("Evert" "Eilert"))
           (25 . ("Inga" "Ingalill"))
           (26 . ("Amanda" "Rasmus"))
           (27 . ("Sabina"))
           (28 . ("Simon" "Simone"))
           (29 . ("Viola"))
           (30 . ("Elsa" "Isabella"))
           (31 . ("Edit" "Edgar"))))

    (11 . ((1 . ())
           (2 . ("Tobias"))
           (3 . ("Hubert" "Hugo"))
           (4 . ("Sverker"))
           (5 . ("Eugen" "Eugenia"))
           (6 . ("Gustav" "Adolf"))
           (7 . ("Ingegerd" "Ingela"))
           (8 . ("Vendela"))
           (9 . ("Teodor" "Teodora"))
           (10 . ("Martin" "Martina"))
           (11 . ("Mrten"))
           (12 . ("Konrad" "Kurt"))
           (13 . ("Kristian" "Krister"))
           (14 . ("Emil" "Emilia"))
           (15 . ("Leopold"))
           (16 . ("Vibeke" "Viveka"))
           (17 . ("Naemi" "Naima"))
           (18 . ("Lillemor" "Moa"))
           (19 . ("Elisabet" "Lisbet"))
           (20 . ("Pontus" "Marina"))
           (21 . ("Helga" "Olga"))
           (22 . ("Cecilia" "Sissela"))
           (23 . ("Klemens"))
           (24 . ("Gudrun" "Rune"))
           (25 . ("Katarina" "Katja"))
           (26 . ("Linus"))
           (27 . ("Astrid" "Asta"))
           (28 . ("Malte"))
           (29 . ("Sune"))
           (30 . ("Andreas" "Anders"))))

    (12 . ((1 . ("Oskar" "Ossian"))
           (2 . ("Beata" "Beatrice"))
           (3 . ("Lydia"))
           (4 . ("Barbara" "Barbro"))
           (5 . ("Sven"))
           (6 . ("Nikolaus" "Niklas"))
           (7 . ("Angela" "Angelika"))
           (8 . ("Virginia"))
           (9 . ("Anna"))
           (10 . ("Malin" "Malena"))
           (11 . ("Daniel" "Daniela"))
           (12 . ("Alexander" "Alexis"))
           (13 . ("Lucia"))
           (14 . ("Sten" "Sixten"))
           (15 . ("Gottfrid"))
           (16 . ("Assar"))
           (17 . ("Stig"))
           (18 . ("Abraham"))
           (19 . ("Isak"))
           (20 . ("Israel" "Moses"))
           (21 . ("Tomas"))
           (22 . ("Natanael" "Jonatan"))
           (23 . ("Adam"))
           (24 . ("Eva"))
           (25 . ())
           (26 . ("Stefan" "Staffan"))
           (27 . ("Johannes" "Johan"))
           (28 . ("Benjamin"))
           (29 . ("Natalia" "Natalie"))
           (30 . ("Abel" "Set"))
           (31 . ("Sylvester"))))))

(defun lyskom-nameday (&optional now)
  (let* ((time (or now (lyskom-current-server-time)))
         (mlist (cdr (assq (time->mon time) lyskom-nameday-alist)))
         (dlist (cdr (assq (time->mday time) mlist))))
    (cond ((null dlist) nil)
          ((eq 1 (length dlist))
           (lyskom-format "%#1s har namnsdag i dag." (car dlist)))
          ((eq 2 (length dlist))
           (lyskom-format "%#1s och %#2s har namnsdag i dag."
                          (elt dlist 0) (elt dlist 1)))
          (t (format "%s och %s har namnsdag i dag."
                     (mapconcat 'identity (lyskom-butlast dlist 1) ", ")
                     (elt dlist (1- (length dlist))))))))


;;; ================================================================
;;;                Vilka ({r inloggade) - Who is on?

;;; Author: ???
;;; Rewritten by: David K}gedal


(put 'lyskom-no-users 'error-conditions
     '(error lyskom-error lyskom-no-users))

(def-kom-command kom-who-is-on (&optional arg)
  "Display a list of active connected users.
With a positive prefix argument ARG, list sessions who have been active 
in the last ARG minutes.

With a positive zero prefix argument ARG, list all visible sessions.

With a negative nonzero prefix argument ARG, list both visible and
invisible sessions who have been active in the last -ARG minutes.

With a negative zero prefix argument (C-u -), list all sessions."
  (interactive "P")
  (condition-case nil
      (if (lyskom-have-feature dynamic-session-info)
	  (lyskom-who-is-on-9 arg)
	(lyskom-who-is-on-8))
    (lyskom-no-users
     (lyskom-insert (lyskom-get-string 'null-who-info)))))

;;; ================================================================
;;;                Vilka ({r inloggade i) mte - Who is on in a conference?

;;; Author: petli

(def-kom-command kom-who-is-on-in-conference (&optional arg)
  "Display a list of all connected users in CONF.
The prefix arg controls the idle limit of the sessions showed. If the
prefix is negative, invisible sessions are also shown.

If the prefix is 0, all visible sessions are shown."
  (interactive "P")
  (let ((conf-stat 
	 (lyskom-read-conf-stat (lyskom-get-string 'who-is-on-in-what-conference)
				'(all) nil 
				(let ((ccn 
				       (if (or (null lyskom-current-conf)
					       (zerop lyskom-current-conf))
					   ""
					 (conf-stat->name
					  (blocking-do 'get-conf-stat
						       lyskom-current-conf)))))
				  (if ccn
				      (cons ccn 0)
				    "")) t)))
    (condition-case nil
	(if (lyskom-have-feature dynamic-session-info)
	    (lyskom-who-is-on-9 arg conf-stat)
	  (lyskom-who-is-on-8 conf-stat))
      (lyskom-no-users
       (lyskom-insert (lyskom-get-string 'null-who-info))))))

;;; ================================================================
;;;                Vilka ({r n{rvarande i) mte - Who is present in a conference?

;;; Author: Christer Ekholm
;;; Copied from kom-who-is-on-in-conference by petli

(def-kom-command kom-who-is-present-in-conference (&optional arg)
  "Display a list of all connected users currently present in CONF.
The prefix arg controls the idle limit of the sessions showed. If the
prefix is negative, invisible sessions are also shown.

If the prefix is 0, all visible sessions are shown."
  (interactive "P")
  (let ((conf-stat 
	 (lyskom-read-conf-stat (lyskom-get-string 'who-is-present-in-what-conference)
				'(all) nil 
				(let ((ccn 
				       (if (or (null lyskom-current-conf)
					       (zerop lyskom-current-conf))
					   ""
					 (conf-stat->name
					  (blocking-do 'get-conf-stat
						       lyskom-current-conf)))))
				  (if ccn
				      (cons ccn 0)
				    "")) t)))
    (condition-case nil
	(if (lyskom-have-feature dynamic-session-info)
	    (lyskom-who-is-on-9 arg conf-stat t)
	  (lyskom-who-is-on-8 conf-stat t))
      (lyskom-no-users
       (lyskom-insert (lyskom-get-string 'null-who-info))))))

;;; ================================================================
;;;                Vilka vnner (r inloggade) - What friends are on

;;; Author: Ulrik Haugen

(def-kom-command kom-who-is-on-and-friend (&optional arg)
  "Display a list of all connected users in kom-friends.
The prefix arg controls the idle limit of the sessions showed. If the
prefix is negative, invisible sessions are also shown.

If the prefix is 0, all visible sessions are shown."
  (interactive "P")
  (condition-case nil
      (if (lyskom-have-feature dynamic-session-info)
	  (lyskom-who-is-on-9 arg nil nil t)
	(lyskom-who-is-on-8 nil nil t))
    (lyskom-no-users
     (lyskom-insert (lyskom-get-string 'null-who-info)))))

(defun lyskom-who-is-on-8 (&optional conf-stat show-present-only
				     show-friends-only)
  "Display a list of all connected users.
Uses Protocol A version 8 calls"
  (let* ((who-info-list (blocking-do 'who-is-on))
	 (who-list (sort
		    (funcall (if show-friends-only
				 #'lyskom-select-friends-from-who-list
			       #'identity)
			     (cond (show-present-only
				    (lyskom-who-is-present-check-membership-8
				     who-info-list conf-stat))
				   (conf-stat
				    (lyskom-who-is-on-check-membership-8
				     who-info-list conf-stat))
				   (t
				    (listify-vector who-info-list))))
			     (function (lambda (who1 who2)
					 (< (who-info->connection who1)
					    (who-info->connection who2))))))
	 (total-users (length who-list))
	 (session-width (1+ (length (int-to-string
				     (who-info->connection
				      (nth (1- total-users) who-list))))))
	 (format-string-1 (lyskom-info-line-format-string
			   session-width "P" "M"))
	 (format-string-2 (lyskom-info-line-format-string
			   session-width "s" "s"))
	 (lyskom-default-conf-string 'not-present-anywhere)
         (lyskom-default-pers-string 'unknown-person))

    (cond (show-friends-only
           (lyskom-format-insert 'who-is-friend))
          (show-present-only
	   (lyskom-format-insert 'who-is-active-and-present conf-stat))
	  (conf-stat
	   (lyskom-format-insert 'who-is-active-and-member conf-stat)))
	  
    (lyskom-format-insert format-string-2
			  ""
			  (lyskom-get-string 'lyskom-name)
			  (lyskom-get-string 'is-in-conf))
    (if kom-show-where-and-what
	(lyskom-format-insert format-string-2
			      ""
			      (lyskom-get-string 'from-machine)
			      (lyskom-get-string 'is-doing)))
    
    (lyskom-insert
     (concat (make-string (- (lyskom-window-width) 1) ?-) "\n"))
    
    (while who-list
      (let* ((who-info (car who-list))
	     (session-no (int-to-string (who-info->connection who-info)))
	     (my-session (if (= lyskom-session-no
				(who-info->connection who-info))
			     "*"
			   " ")))
	(lyskom-format-insert
	 format-string-1
	 (concat session-no my-session)
	 (who-info->pers-no who-info)
	 (or (who-info->working-conf who-info)
	     (lyskom-get-string 'not-present-anywhere)))
	(if kom-show-where-and-what
	    (lyskom-format-insert
	     format-string-2
	     ""
	     (lyskom-return-username who-info)
	     (concat "(" (or (string-replace-match "\n" (who-info->doing-what who-info) " " t t)
                             (who-info->doing-what who-info)")")))))
      (setq who-list (cdr who-list)))
      
      (lyskom-insert (concat (make-string (- (lyskom-window-width) 1) ?-)
			     "\n"))
      (lyskom-insert (lyskom-format 'total-visible-users total-users
                                    (lyskom-format-time
   