{*}
{ * This is a part of the Microsoft Source Code Samples. Copyright (C) 1993-1995 Microsoft Corp.}
{ * All rights reserved.}
{ *}
{ * This source code is only intended as a supplement to Microsoft Development Tools and/or}
{ * WinHelp documentation. See these sources for detailed information regarding the Microsoft}
{ * samples programs.}
{ *}
{ * Modified by Metrowerks Inc., 1997.}
{ *}
{ * Converted to Pascal by Ingemar Ragnemalm 1998.}
{ *}

{This file was processed by Dan's Source Converter}

{Comments on the port:}
{I started with Dan's Source Converter for the most tedious things, but as}
{usual, that is just the start.}
{The C code used pointers a lot, which made the code unnecessaily unreadable}
{and obscure. Where possible, I have changed it to array accesses. This has}
{improved the code a lot!}
{I have aso added constants for the WM_ messages, which also improves}
{readability of the event processing.}
{I moved the dialog template from Otello.dlg and the contents of Otello.h}
{to Otello.rc in order to get one file less, and one "include" less. The}
{#include principle is a primitive low-level informal bug-causing madness}
{that should be put to rest! Sorry, got carried away for a moment...}
{}
{Finally, why port it? Well, if I have to write Win32 code - which I really}
{don't want to but may have to for economical reasons - I want to do it in}
{Pascal or one of its successors - not "hack" language designs like C or C++.}
{Porting this gives me, and perhaps others, one more Pascal demothat works}
{with MW Pascal. My long-term goal, however, is to make glue code that lets}
{me port Mac programs with little effort - and I am getting there, really!}
{}
{I hope it is clear that I do Metrowerks' job here, but unpaid. When I found}
{the Otello demo in the Pascal demos folder, I hoped for a decent demo, but}
{all they had done was to port TWO SMALL ROUTINES and left the rest in C.}
{Not much to work from after paying hundreds of dollars for a compiler!}
{}
{/Ingemar Ragnemalm}

unit OTELLO;
interface
uses
	WINDOWS;

{All programs must export WinMain}
FUNCTION WinMain(ahInstance:HINSTANCE; hPrev:HINSTANCE; lpCmdLine:LPSTR; cmdShow:LONGINT) : LONGINT; STDCALL; DLLIMPORT;

{Many calls and constants are missing in CodeWarrior! Here are a bunch that}
{were needed in this project: /Ingemar}

{Missing declarations:}
function GetKeyState(nVirtKey: Longint): Integer; STDCALL; DLLIMPORT;
function GetDeviceCaps(_hdc: HDC; nIndex: Longint): Longint; STDCALL; DLLIMPORT;
function LoadAcceleratorsA(_hInstance: HINSTANCE; lpTableName: LPCSTR):HACCEL; STDCALL; DLLIMPORT;

function EnableMenuItem(hMenu: HMENU; uIDEnableItem: UINT; uEnable: UINT):BOOL; STDCALL; DLLIMPORT;
function SetCursorPos(X: LONGINT; Y: LONGINT): BOOL; STDCALL; DLLIMPORT;
FUNCTION UpdateWindow(a0:HWND):BOOL; STDCALL; DLLIMPORT;

{Missing constants - which I believe should rather be const than $definec}
{ $DEFINEC WM_CLOSE $0010}
const
	WM_CLOSE = $0010;
	BITSPIXEL = 12;	{For GetDeviceCaps}

implementation

type
	OneBoard = array[0..99] of BYTE;
	BoardType = array[0..7] of OneBoard;
	OneBoardPtr = ^OneBoard;
	
	PieceFlagsType = array[0..3] of BYTE;
	DirecType = array[0..8] of Longint;
	MovesType = array[0..60] of Longint;

var
 prevCheck:WORD;

fCheated:Boolean;
fThinking:Boolean;
bMouseDownInOtello:Boolean;

const
	PieceFlags : PieceFlagsType = ( $00 , $00 , $01 , $02 );
	TYMIN:Longint = 45;
	direc: DirecType = (9, 10, 11, 1, -1, -9, -10, -11, 0);
	moves: MovesType = (
	11,18,81,88, 13,31,16,61,
	38,83,68,86, 14,41,15,51,
	48,84,58,85, 33,36,63,66,
	34,35,43,46, 53,56,64,65,
	24,25,42,47, 52,57,74,75,
	23,26,32,37, 62,67,73,76,
	12,17,21,28, 71,78,82,87,
	22,27,72,77,
	0);

var
ffirstmove:Boolean;
board: BoardType;
strBuf: array[0..79] of CHAR;
szOtello: array[0..19] of CHAR;
szOtelloPractice: array[0..39] of CHAR;
szPass: array[0..29] of CHAR;
szMustPass: array[0..29] of CHAR;
szTie: array[0..29] of CHAR;
szLoss: array[0..29] of CHAR;
szWon: array[0..29] of CHAR;
szWonPost: array[0..29] of CHAR;
szLossPost: array[0..29] of CHAR;
szAbout: array[0..19] of CHAR;
szIllegal: array[0..69] of CHAR;
szNoPass: array[0..69] of CHAR;
szHelpFile: array[0..14] of CHAR;
lpprocAbout:DLGPROC;
hInst:HINSTANCE;
curIllegal:HCURSOR;
curLegal:HCURSOR;
curThink:HCURSOR;
curBlank:HCURSOR;
myhAccel:HACCEL;
hbrBlack:HBRUSH;
hbrPat:HBRUSH;
hbrWhite:HBRUSH;
hbrRed:HBRUSH;
hbrGreen:HBRUSH;
hbrBlue:HBRUSH;
hbrHuman:HBRUSH;
hbrComputer:HBRUSH;
hDisp:HDC;
hWin:HWND;
fPass:Longint;
flashtimes:Longint;
count:Longint;
MessageOn:Boolean;
charheight:Longint;
charwidth:Longint;
xscr:Longint;
xExt:Longint;
yExt:Longint;
Bx:Longint;
By:Longint;
ASPECT:Longint;
COLOR:Boolean;
TXMIN:Longint;
dimension:Longint;
depth:Longint;
BestMove: array[0..7] of Longint;
MousePos:POINT;
pDisplayMessage:LPCSTR;
lpprocInverseMessage:TIMERPROC;

{prototypes}
{I prefer Pascal code not to forward-declare its calls when possible, in order to}
{enforce an order that reflects the structure. /Ingemar}

 function AboutDlgProc(hDlg:HWND; message:UINT; wParam:WPARAM; lParam:LPARAM):BOOL;forward;
 procedure checkdepth(hWindow:HWND; d:WORD);forward;
 procedure clearboard(var b:BoardType);forward;
 procedure ClearMessageTop(hDC:HDC);forward;
 procedure drawboard(var b:BoardType);forward;
 function finalscore(var b:OneBoard; friendly:BYTE; enemy:BYTE):Longint;forward;
 procedure flashsqr( hDC:HDC; x1:Longint; y1:Longint; Ex:Longint; Ey:Longint; color:Longint; fBlankSquare:BOOL; n:Longint);forward;
 procedure FlashMessageTop(hWindow:HWND);forward;
 procedure gameover( hWindow:HWND; hDC:HDC; var b:BoardType; r:Longint);forward;
 function InverseMessage( hWindow:HWND; message:UINT; wParam:WPARAM; lParam:DWORD):PVOID;STDCALL;forward;
 function legalcheck(var b:OneBoard; move:Longint; friendly:BYTE; enemy:BYTE):Boolean;forward;
 procedure makemove(var b:OneBoard; move:Longint; friendly:BYTE; enemy:BYTE);forward;
 function minmax(var b:BoardType; move:Longint; friendly:BYTE; enemy:BYTE; ply:Longint; vmin:Longint; vmax:Longint):Longint;forward;
 procedure Next( Var px:Longint;  Var py:Longint);forward;
 procedure paintmove(var b:OneBoard; move:Longint; friendly:BYTE; enemy:BYTE);forward;
 procedure Previous( Var px:Longint;  Var py:Longint);forward;
 procedure printboard(var b:BoardType);forward;
 procedure OtelloChar(hwnd:HWND;  code:WORD);forward;
 procedure OtelloCreate( hWindow:HWND);forward;
 function OtelloWndProc(ahWnd:HWND;  message:UINT; wParam:WPARAM; lParam:LPARAM): LRESULT; STDCALL;forward;
 function OtelloInit(ahInstance:HINSTANCE):Boolean;forward;
 procedure OtelloMenu( hWindow:HWND; idval:Longint);forward;
 procedure OtelloMessage(hWindow:HWND; hDC:HDC; pS:LPSTR; n:Longint; pchPostStr:LPSTR);forward;
 procedure OtelloMouseClick(hWnd:HWND; point:POINT);forward;
 procedure OtelloMouseMove(point:POINT);forward;
 procedure OtelloPaint(hWindow:HWND; hDC:HDC);forward;
 function score(b:OneBoard; friendly:BYTE; enemy:BYTE):Longint;forward;
 procedure ShowBestMove(hwnd:HWND);forward;
 procedure ShowMessageTop(hDC:HDC; astring:LPCSTR);forward;
 procedure ShowNextMove(hwnd:HWND; fforward:Boolean);forward;
 procedure UpdateCursor(hwnd:HWND);forward;

{functions}

{Well, Win32 is definitely not written for demanding return values...}
{so I got tired of making fake "if's" or ignored variables.}
{$pragma noreturn on}

 procedure clearboard(var b:BoardType);

	 var i,j:Longint;
	k:Longint;

	 begin 
	i:=0;
	While i<=6 Do 
		 begin 
		j:=0;
		While j<=99 Do 
			 begin 
			b[i][j]:=0;
			j:=j+1;
		 End;
		i:=i+1;
	 End;
	
	i:=0;
	While(i<=6) Do 
		 begin 
		j:=11;
		While(j<=81) Do 
			 begin 
			k:=j;
			While(k<j+8) Do 
			 begin 
				b[i][k]:=1;
				k:=k+1;
			 End;
			j:=j+10;
		 End;
		b[i][45]:=3;
		b[i][54]:=3;
		b[i][44]:=2;
		b[i][55]:=2;
		i:=i+1;
	 End;
 End;

 procedure ClearMessageTop(hDC:HDC);
var ignored: BOOL;
	hIgnored: HGDIOBJ;
begin 
	If  MessageOn Then 
		 begin 
		flashtimes := count + 1;
		if COLOR then
			hIgnored := SelectObject(hDC, HGDIOBJ(hbrGreen))
		else
			hIgnored := SelectObject(hDC, HGDIOBJ(hbrWhite));
		ignored := PatBlt(hDC, 0, 0, xscr, charheight, DWORD($00F00021));
		MessageOn := false;
	 End;
 End;

 procedure drawboard(var b:BoardType);

	 var i:Longint;
	lcx,lcy:Longint;
	 xdimension:Longint;
	xLineExt,yLineExt:Longint;

	 begin 
	yLineExt := 8 * yExt;
	xLineExt := 8 * xExt;
	xdimension := dimension * ASPECT;
	SelectObject(hDisp, HGDIOBJ(hbrBlack));
	PatBlt(hDisp, Bx+2*xdimension, By+2*dimension, xLineExt, yLineExt, DWORD($00F00021));
	SelectObject(hDisp, HGDIOBJ(hbrPat));
	PatBlt(hDisp, Bx, By, xLineExt, yLineExt, DWORD($00F00021));
	SelectObject(hDisp, HGDIOBJ(hbrBlack));

	i:=Bx;
	while i <= Bx + xLineExt do
	begin
		PatBlt(hDisp, i, By, ASPECT, yLineExt, DWORD($00F00021));
		i := i + xExt;
	end;

	i:=By;
	while i <= By + yLineExt do
	begin
		PatBlt(hDisp, Bx, i, xLineExt, 1, DWORD($00F00021));
		i := i + yExt;
	end;
	
	lcx := Bx+xLineExt;
	lcy := By+yLineExt;
	SelectObject(hDisp, HGDIOBJ(hbrPat));

	for i:=1 to xdimension-1 do
		PatBlt(hDisp, lcx+i, By+i div ASPECT, 1, yLineExt, DWORD($00F00021));
	for i:=1 to xdimension-1 do
		PatBlt(hDisp, Bx+i * ASPECT, lcy+i, xLineExt, 1, DWORD($00F00021));

	SelectObject(hDisp, HGDIOBJ(hbrBlack));
	MoveToEx(hDisp, lcx, By, nil);
	LineTo(hDisp, lcx+xdimension, By+dimension);
	LineTo(hDisp, lcx+xdimension, lcy+dimension);
	LineTo(hDisp, Bx+xdimension, lcy+dimension);
	LineTo(hDisp, Bx, lcy);
	MoveToEx(hDisp, lcx+xdimension, lcy+dimension, nil);
	LineTo(hDisp, lcx, lcy);
	printboard(b);
 End;

 function finalscore(var b:OneBoard; friendly:BYTE; enemy:BYTE):Longint;

	var i:Longint;
	count:Longint;

	begin 
	count := 0;
	for i:=11 to 88 do
		 begin 
		If  (b[i] = friendly) Then
			count:=count+1
		 else 			If  (b[i] = enemy) Then
				count:=count-1;
	 End;

	If  (count > 0) Then
		finalscore:=32000 + count
	 else 		If  (count < 0) Then
			finalscore:=-32000 + count
		 else 			finalscore:=0;
 End;

 procedure FlashMessageTop(hWindow:HWND);
 begin 
	flashtimes := 0;
	count := 4;
	SetTimer(hWindow, 666, 200, lpprocInverseMessage);
 End;

 procedure flashsqr( hDC:HDC; x1:Longint; y1:Longint; Ex:Longint; Ey:Longint; color:Longint; fBlankSquare:BOOL; n:Longint);

	 var i:Longint;

	 begin 
	If  (fBlankSquare <> 0) Then
		SelectObject(hDC, GetStockObject(8));
	SetCursor(HCURSOR(curBlank));

	for i:=0 to n-1 do
		 begin
	If  (color = 1) Then
		color := 2
	 else 			color := 1;

		If  (color = 1) Then
			SelectObject(hDC,HGDIOBJ(hbrComputer))
		 else 			SelectObject(hDC, HGDIOBJ(hbrHuman));
		SetBkMode(hDC, 2);
		Ellipse(hDC, x1, y1, x1+Ex, y1+Ey);
	 End;

	If  (fBlankSquare<>0) Then 
		 begin 
		SelectObject(hDC, HGDIOBJ(hbrPat));
		Ellipse(hDC, x1, y1, x1+Ex, y1+Ey);
	 End  else 		SetCursor(HCURSOR(curThink));
 End;

 procedure gameover( hWindow:HWND; hDC:HDC; var b:BoardType; r:Longint);

	 var i:Longint;
	cc:Longint;
	hc:Longint;
	sq:Longint;
	reply2:Longint;
	pMoves: Integer;	{Changed from pointer to array index. / Ingemar}
	 begin 
	pMoves := 0;

	fPass := 20;
	reply2 := 20;
	While moves[pMoves] <> 0 Do 
		 begin 
		 sq := moves[pMoves];
		 pMoves := pMoves+1;
		If  (legalcheck(b[0], sq, 2, 3)) Then
			fPass := sq
		 else If  (legalcheck(b[0], sq, 3, 2)) Then
			reply2 := sq;
	 End;

	If  (fPass = 20) Then 
		 begin 
			If  (r = 20) OR (reply2 = 20) Then 
			 begin 
			hc := 0;
			cc := 0;
	
			for i:=11 to 88 do
				 begin 
			If  (b[0][i] = 2) Then
					hc := hc +1
				 else If  (b[0][i] = 3) Then
					cc:=cc+1;
			 End;
	
			If  (hc > cc) Then
				OtelloMessage(hWindow, hDC, @szWon, hc-cc, @szWonPost)
			 else If  (hc < cc) Then
				OtelloMessage(hWindow, hDC, @szLoss, cc-hc, @szLossPost)
			 else 				OtelloMessage(hWindow, hDC, @szTie, 0, nil);
		 End  else 
			 begin 
			OtelloMessage(hWindow, hDC, @szMustPass, 0, nil);
		 End
	 End  else If  (r = 20) Then 
		 begin 
			OtelloMessage(hWindow, hDC, @szPass, 0, nil);
	 End;
 End;

 function InverseMessage( hWindow:HWND; message:UINT; wParam:WPARAM; lParam:DWORD):PVOID;STDCALL;

	var hDC:HDC;
	 begin 
	
	If flashtimes <= count Then 
		 begin 
		hDC := GetDC(hWindow);
		PatBlt(hDC, 0, 0, xscr, charheight, DWORD($00550009));
		flashtimes:=flashtimes+1;
		ReleaseDC(hWindow, hDC);
	 End  else 		KillTimer(hWindow, 666);
	InverseMessage:=nil;
 End;

 function legalcheck(var b:OneBoard; move:Longint; friendly:BYTE; enemy:BYTE):Boolean;

	var sq,d:Longint;
	p: Integer; {index into the direction array "direc"}
	 begin 

	 legalcheck:=true;
	If  (b[move] = 1) Then 
		 begin 
		for p := 0 to 7 do {for all directions}
		 begin 
			d:= direc[p];
			sq:=move;
			sq := sq + d;
			If  b[sq] = enemy Then 
			begin 
				While	b[sq] = enemy do
					sq := sq + d;
				If  (b[sq] = friendly) then
					Exit(legalcheck);
			 End;
		 End;
	 End;
	 legalcheck:=false;
 End;

 procedure makemove(var b:OneBoard; move:Longint; friendly:BYTE; enemy:BYTE);

	var sq,d:Longint;
	p:Integer; {Index into direc}
	 begin 

	If move <> 20 then
	 begin 
		for p := 0 to 7 do {for all directions}
		 begin 
			d:=direc[p];
			sq:=move;
			sq := sq + d;
			If b[sq] = enemy Then  {Enemy in that direction?}
			 begin
				While b[sq] = enemy do {Follow direction until a non-enemy is found}
					sq := sq + d;
				If b[sq] = friendly then {If friend in other end, turn the pieces!}
					while b[sq - d] = enemy do
					begin
						sq := sq - d;
						b[sq]:=friendly;
					end;
			 End;
		 End;
		b[move]:=friendly;
	 End;
 End;

 function minmax(var b:BoardType; move:Longint; friendly:BYTE; enemy:BYTE; ply:Longint; vmin:Longint; vmax:Longint):Longint;
var
	pCurrent, pPrevious: OneBoardPtr;
	i:Longint;
	sq, value, cur_move:Longint;
	count:Longint;
	
	pMoves: Integer; {Index to moves}
	pBestMove: Integer; {Index to BestMove}

	 begin 

	count := 0;
	pPrevious := @b[ply];
	pCurrent := @b[ply+1];

	for i:=11  to 88 do
		b[ply+1][i] := b[ply][i];
	pBestMove := ply; {@BestMove[ply];}

	If  (move = 20) then
		 begin 
			If  (ply = depth) then
			 begin 
			for pMoves := 0 to 7 do {for all directions}
				 begin 
				 sq := moves[pMoves];
				If  (legalcheck(pCurrent^,sq,enemy,friendly)) Then
					begin minmax:=(score(pCurrent^,friendly,enemy));Exit(minmax);end
			 End;
			 minmax:=(finalscore(pCurrent^,friendly,enemy));
			Exit(minmax);
		 End;
	 End  else 
		 begin 
		If  (ply = 0) Then 
			 begin 
			hDisp := GetDC(hWin);
			paintmove(pCurrent^,move,friendly,enemy);
			ReleaseDC(hWin, hDisp);
		 End  else 
			 begin
			makemove(pCurrent^,move,friendly,enemy);
			If  (ply = depth) Then 
				begin minmax:=(score(pCurrent^,friendly,enemy));Exit(minmax);end;
		 End;
	 End;
	
	pMoves := 0;
	cur_move := 20;
	BestMove[pBestMove] := 20;

	while moves[pMoves] <> 0 do
	 begin 
		 sq := moves[pMoves];
		 pMoves:=pMoves+1;
		If  (legalcheck(pCurrent^,sq,enemy,friendly)) Then 
		 begin 
			cur_move := sq;
			value := minmax(b,cur_move,enemy,friendly,ply+1,-vmax,-vmin);
			If  (value > vmin) Then 
				 begin 
				vmin := value;
				BestMove[pBestMove] := cur_move;
				If  (value >= vmax) Then 
					begin
					minmax:=(-vmin);Exit(minmax);
					end;
			 End;
		 End;
	 End;
	
	If  (cur_move = 20) Then 
		 begin 
If  (move = 20) Then
			begin minmax:=(finalscore(pCurrent^,friendly,enemy));Exit(minmax);end
		 else 
			 begin 
			value := minmax(b,20,enemy,friendly,ply+1,-vmax,-vmin);
			If  (value > vmin) Then 
				vmin := value;
		 End;
	 End;

	minmax:=(-vmin);
 End;

 procedure Next( Var px:Longint;  Var py:Longint);
 begin 
	px:=px+1;
	If px > 7 Then 
	begin 
		px := 0;
		py:=py+1;
	If  py > 7 Then
		py := 0;
	 End;
 End;

 procedure OtelloChar(hwnd:HWND;  code:WORD);

	var a:Longint;
	curpoint:POINT;

 begin 
	curpoint.x := 1;
	curpoint.y := 1;
	Case code of
		$27:
			MousePos.x := MousePos.x + xExt;
		$28:
			MousePos.y := MousePos.y + yExt;
		$25:
			begin
			curpoint.x := (MousePos.x - Bx) div xExt;
			MousePos.x := MousePos.x - xExt;
			end;
		$26:
			begin
			curpoint.y := (MousePos.y - By) div yExt;
			MousePos.y := MousePos.y - yExt;
			end;
		$24:
			begin
			curpoint.y := (MousePos.y - By) div yExt;
			curpoint.x := (MousePos.x - Bx) div xExt;
			MousePos.y := MousePos.y - yExt;
			MousePos.x := MousePos.x - xExt;
			end;

		$21:
			begin
			curpoint.y := (MousePos.y - By) div yExt;
			MousePos.y := MousePos.y - yExt;
			MousePos.x := MousePos.x + xExt;
			end;

		$23:
			begin
			curpoint.x := (MousePos.x - Bx) div xExt;
			MousePos.y := MousePos.y + yExt;
			MousePos.x := MousePos.x - xExt;
			end;

		$22:
			begin
			MousePos.y := MousePos.y + yExt;
			MousePos.x := MousePos.x + xExt;
			end;

		$0020,
		$000D:
			If  (Not fThinking) Then
				OtelloMouseClick(hwnd, MousePos);

		$0009:
			If  not fThinking Then
			begin
			If  GetKeyState($10) < 0 Then
				ShowNextMove(hwnd, false)
			 else 				ShowNextMove(hwnd, true);
			Exit(OtelloChar);
			end;
	
		otherwise
			Exit(OtelloChar);
	 End;
	
	a := (MousePos.x - Bx)  div  xExt;
	If  (a >7) OR (a <= 0) Then
		MousePos.x := Bx + xExt  div  2;
	
	If  (a > 8) OR (curpoint.x = 0) AND (a = 0) Then
		MousePos.x := (7*xExt) + Bx + xExt  div  2 ;
	
	a := (MousePos.y - By)  div  yExt;
	If  (a >7) OR (a <= 0) Then
		MousePos.y := By + yExt  div  2;
	
	If  (a > 8) OR (curpoint.y = 0) AND (a = 0) Then
		MousePos.y := (7*yExt) + By + yExt  div  2;
	
	MousePos.x := ((MousePos.x - Bx)  div  xExt) * xExt + Bx + xExt  div  2;
	MousePos.y := ((MousePos.y - By)  div  yExt) * yExt + By + yExt  div  2;
	UpdateCursor(hwnd);
	OtelloMouseMove(MousePos);
 End;

 procedure OtelloCreate( hWindow:HWND);

	 var hDC:HDC;
	charsize:TEXTMETRICA;

	 begin 
MessageOn := false;
	hDC := GetDC(hWindow);
	GetTextMetricsA(hDC, LPTEXTMETRICA(@charsize));
	charheight := charsize.tmHeight;
	charwidth := charsize.tmAveCharWidth;
	ReleaseDC(hWindow, hDC);
	If  COLOR Then 
		 begin 
		hbrComputer := hbrBlue;
		hbrHuman := hbrRed;
	 End  else 
		 begin 
		hbrComputer := hbrBlack;
		hbrHuman := hbrWhite;
	 End;

	TXMIN := 45 * ASPECT;
	clearboard(board);
	fPass := 20;
	depth := 1;
	prevCheck := 41;
	ffirstmove := true;
	checkdepth(hWindow, prevCheck);
 End;

 function OtelloInit(ahInstance:HINSTANCE):Boolean;

	 var pRevClass:WNDCLASSA;
	hdc:HDC;

	 begin 
	 OtelloInit:=false;
	hbrWhite := HBRUSH(GetStockObject(0));
	hbrBlack := HBRUSH(GetStockObject(4));
	hbrPat := HBRUSH(GetStockObject(1));

	If  hbrPat=nil Then
		Exit(OtelloInit);

	ffirstmove := true;
	hdc := GetDC(HWND(nil));
	COLOR := GetDeviceCaps(hdc, BITSPIXEL) > 1; {BITSPIXEL is missing in the interfaces /Ingemar}
	
	If  (GetDeviceCaps(hdc, 10) = 200) Then
		ASPECT := 2
	 else 		ASPECT := 1;

	ReleaseDC(HWND(nil), hdc);
	hbrRed := CreateSolidBrush($0000FF);
	hbrGreen := CreateSolidBrush($00FF00);
	hbrBlue := CreateSolidBrush($FF0000);

	If  (hbrRed=nil) OR (hbrGreen=nil) OR (hbrBlue=nil) Then
		Exit(OtelloInit);

	LoadStringA(ahInstance, 3, @szOtello, 20);
	LoadStringA(ahInstance, 4, @szOtelloPractice, 40);
	LoadStringA(ahInstance, 5, @szPass, 30);
	LoadStringA(ahInstance, 6, @szMustPass, 30);
	LoadStringA(ahInstance, 7, @szTie, 30);
	LoadStringA(ahInstance, 8, @szLoss, 30);
	LoadStringA(ahInstance, 9, @szWon, 30);
	LoadStringA(ahInstance, 10, @szAbout, 20);
	LoadStringA(ahInstance, 11, @szLossPost, 30);
	LoadStringA(ahInstance, 12, @szWonPost, 30);
	LoadStringA(ahInstance, 13, @szIllegal, 70);
	LoadStringA(ahInstance, 14, @szNoPass, 70);
	LoadStringA(ahInstance, 15, @szHelpFile, 15);
	myhAccel := LoadAcceleratorsA(ahInstance, @szOtello);

	curLegal := LoadCursorA(nil, LPCSTR(WORD(32515)));
	curIllegal := LoadCursorA(nil, LPCSTR(WORD(32512)));
	curThink := LoadCursorA(nil, LPCSTR(WORD(32514)));
	curBlank := LoadCursorA(ahInstance, LPCSTR(1));

	If  (curLegal=nil) OR (curIllegal=nil) OR (curThink=nil) OR (curBlank=nil) Then
		Exit(OtelloInit);

	pRevClass.hIcon := LoadIconA(ahInstance, LPCSTR(3));
	pRevClass.lpszClassName := @szOtello;
	if COLOR then
		pRevClass.hbrBackground := hbrGreen
	else
		pRevClass.hbrBackground := hbrWhite;
	pRevClass.lpfnWndProc := @OtelloWndProc;
	pRevClass.lpszMenuName := LPCSTR(1);
	pRevClass.hInstance := ahInstance;
	pRevClass.style := $0001 + $0002 + $1000;
	pRevClass.cbWndExtra := 0;
	pRevClass.cbClsExtra := 0;
	pRevClass.hCursor := nil;

	If RegisterClassA(pRevClass)<>0 Then 
		OtelloInit:=true;
 End; {OtelloInit}

 procedure OtelloMenu( hWindow:HWND; idval:Longint);

	var hDC:HDC;
	 cmd:Longint;

	 begin 
If  (fThinking) Then
		Exit(OtelloMenu);

	hWin := hWindow;
	Case (idval) of
		52:
			PostMessageA(hWindow, $0010, 0, 0);
		36:
			DialogBoxParamA(hInst, LPCSTR(3), hWindow, DLGPROC(@lpprocAbout), 0);
		30,
		35:
			;

		31:
			cmd := $1e;

		32:
			cmd := $20;

		33:
			cmd := $21;

		34:
			cmd := $22;

		50:
			begin
			ShowBestMove(hWindow);
			Exit(OtelloMenu);
			end;

		25:
			begin
			SetWindowTextA(hWindow , @szOtello);
			ffirstmove := true;
			hDisp := GetDC(hWindow);
			hDC := hDisp;
			fCheated := false;
			SetBkMode(hDisp, 2);
			ClearMessageTop(hDC);
			fPass := 20;
			clearboard(board);
			drawboard(board);
			ReleaseDC(hWindow, hDC);
			hDisp := nil;
			end;

		41:
			begin
			depth := 1;
			checkdepth(hWindow, 41);
			end;

		42:
			begin
			depth := 2;
			checkdepth(hWindow, 42);
			end;

		44:
			begin
			depth := 4;
			checkdepth(hWindow, 44);
			end;

		46:
			begin
			depth := 6;
			checkdepth(hWindow, 46);
			end;
		
		20:
			If  (fPass = 20) Then 
				 begin 
				hDC := GetDC(hWindow);
				hDisp := hDC;
				SetBkMode(hDisp, 2);
				fThinking := true;
				ClearMessageTop(hDC);
				SetCursor(curThink);
				ReleaseDC(hWindow, hDC);
				hDisp := nil;
				minmax(board, 20, 2, 3, 0, -32767, 32767);
				hDC := GetDC(hWindow);
				hDisp := hDC;
				paintmove(board[0], BestMove[0], BYTE(3), BYTE(2));
				gameover(hWindow, hDC, board, BestMove[0]);
				SetCursor(curIllegal);
				fThinking := false;
				ReleaseDC(hWindow, hDC);
				hDisp := nil;
			 End
		else
			MessageBoxA(hWindow, @szNoPass, @szOtello, $00000000 + $00000040);
	 End;
 End;

 procedure OtelloMessage(hWindow:HWND; hDC:HDC; pS:LPSTR; n:Longint; pchPostStr:LPSTR);
var
	pch: LPSTR;
  begin 
{Stupid string copying; applications shouldn't mess with these trivialities!}
{And if we must, we should at least use arrays, not blind pointers! /Ingemar}
	pch := @strBuf;
	While pS^ <> Char(0) Do
		begin
			pch^:= pS^;
			pch := LPSTR(Ord(pch)+1);	{Yes, It's clumsy - and it would be so nice with arrays!}
			pS := LPSTR(Ord(pS)+1);
			{^pch++ := ^pS++;}
		end;

	If n<>0 Then 
		 begin 
		If  (n  div  10 <>0) Then
			begin
			pch^ := CHAR(n  div  10 + Ord('0'));
			pch := LPSTR(Ord(pch)+1);
			end;
		pch^ := CHAR(n  mod  10 + Ord('0'));
		pch := LPSTR(Ord(pch)+1);
	 End;

	If pchPostStr<>nil Then 
		 begin 
		While pchPostStr^ <> Char(0) Do
			begin
			pch^ := pchPostStr^;
			pch := LPSTR(Ord(pch)+1);
			pch := LPSTR(Ord(pch)+1);
			end;
	 End;

	pch^ := Char(0);
	ShowMessageTop(hDC, @strBuf);
	FlashMessageTop(hWindow);
 End;

 procedure OtelloMouseClick(hWnd:HWND; thePoint:POINT);

	var move:Longint;
	Si, Sj:Longint;
	hDC:HDC;
	yLineExt:Longint;
	xLineExt:Longint;
	
	 begin 
	yLineExt := 8 * yExt;
	xLineExt := 8 * xExt;
	
	MousePos.x := thePoint.x;
	MousePos.y := thePoint.y;
	
	If  (xExt = 0) OR (yExt = 0) Then
		Exit(OtelloMouseClick);

	If  ((thePoint.x > Bx) AND (thePoint.x < (Bx+xLineExt)) AND (thePoint.y > By) AND (thePoint.y < (By+yLineExt))) Then 
	 begin
		Si := (thePoint.x - Bx)  div  xExt;
		Sj := (thePoint.y - By)  div  yExt;
		move := Si * 10 + Sj + 11;
		If  (legalcheck(board[0], move, 2, 3)) Then
		 begin 
			board[0][move] := 2;
			ffirstmove := false;
			fThinking := true;
			SetCursor(curThink);
			hDC := GetDC(hWnd);
			hDisp := hDC;
			ClearMessageTop(hDC);
			minmax(board, move, 2, 3, 0, -32767, 32767);
			makemove(board[0], move, 2, 3);
			hDisp := hDC;
			paintmove(board[0], BestMove[0], 3, 2);
			gameover(hWnd, hDC, board, BestMove[0]);
			ReleaseDC(hWnd, hDC);
			hDisp := nil;
			SetCursor(curIllegal);
			fThinking := false;
		 End  else 			MessageBoxA(hWnd, @szIllegal, @szOtello, $00000000 + $00000040);
	 End;
 End;

 procedure OtelloMouseMove(thePoint:POINT);

	var move:Longint;
	Si, Sj:Longint;
	yLineExt:Longint;
	xLineExt:Longint;
	cur:HCURSOR;

	 begin 
	yLineExt := 8 * yExt;
	xLineExt := 8 * xExt;
MousePos.x := thePoint.x;
	MousePos.y := thePoint.y;

	If (xExt =0) OR (yExt = 0) Then
		Exit(OtelloMouseMove);
	cur := curIllegal;
	If  ((thePoint.x > Bx) AND (thePoint.x < (Bx+xLineExt)) AND (thePoint.y > By) AND (thePoint.y < (By+yLineExt))) Then 
		 begin 
		Si := (thePoint.x - Bx)  div  xExt;
		Sj := (thePoint.y - By)  div  yExt;
		move := Si * 10 + Sj + 11;
		If  (legalcheck(board[0], move, 2, 3)) Then
			cur := curLegal;
	 End;
	SetCursor(cur);
 End;

 procedure OtelloPaint(hWindow:HWND; hDC:HDC);

	 var Tx, Ty:Longint;
	xLineExt, yLineExt:Longint;
	lpSize:RECT;

	 begin 
hDisp := hDC;
	hWin := hWindow;
	SetBkMode(hDisp, 2);
	GetClientRect(hWindow, @lpSize);
	Tx := lpSize.right - lpSize.left;
	xscr := Tx;
	Ty := lpSize.bottom - lpSize.top;
	If  (Tx < Ty*ASPECT) Then 
		 begin 
		If  (Tx < TXMIN) Then
			Tx := TXMIN;
		xExt := Tx  div  (9 + 1);
		yExt := xExt  div  ASPECT;
	 End  else 
		 begin 
If  (Ty < TYMIN) Then
			Ty := TYMIN;
		yExt := Ty  div  (9 + 1);
		xExt := yExt * ASPECT;
	 End;

	yLineExt := 8 * yExt;
	xLineExt := 8 * xExt;
	dimension := yLineExt div 30;
	if Tx > xLineExt then
	Bx := (Tx - xLineExt)  div  2
	else Bx := 0;
	if Ty > yLineExt then
	By := (Ty - yLineExt)  div  2 else By := 0;
	drawboard(board);
	If  MessageOn Then 
		 begin 
		ShowMessageTop(hDisp, pDisplayMessage);
		PatBlt(hDC, 0, 0, xscr, charheight, DWORD($00550009));
	 End;
 End;

 function OtelloWndProc(ahWnd:HWND;  message:UINT; wParam:WPARAM; lParam:LPARAM): LRESULT; STDCALL;

	var hm:HMENU;
	ps:PAINTSTRUCT;
	curpoint:POINT;
	pt:POINT;
	 begin 
{In the C code, all case constants below were numbers, not constants.}
{Of course serious code should use the constants! /Ingemar}
Case message of
		WM_COMMAND: {$0111:}
			OtelloMenu(ahWnd, wParam);

		WM_INITMENU: {$0116:}
			begin
			hm := GetMenu(ahWnd);
			If  (fThinking) Then 
				 begin 
				EnableMenuItem(hm, 0, $00000002 + $00000400);
				EnableMenuItem(hm, 1, $00000002 + $00000400);
			 End  else 
				 begin 
				EnableMenuItem(hm, 0, $00000000 + $00000400);
				EnableMenuItem(hm, 1, $00000000 + $00000400);
			 End;
			end;
	
		WM_CREATE: {$0001:}
			begin
			OtelloCreate(ahWnd);
			hWin := ahWnd;
			end;
	
		WM_CLOSE: {$0010 - missing in the interfaces! /Ingemar}
			begin
			OtelloWndProc:=(DefWindowProcA(ahWnd, message, wParam, lParam));
			Exit(OtelloWndProc);
			end;
	
		WM_DESTROY: {$0002:}
			begin
			If not COLOR Then
				 begin 
					DeleteObject(HGDIOBJ(hbrGreen));
					DeleteObject(HGDIOBJ(hbrRed));
					DeleteObject(HGDIOBJ(hbrBlue));
			 End;
			PostQuitMessage(0);
			end;
	
		WM_KEYDOWN: {$0100:}
			begin
			If  (IsIconic(ahWnd))<>0 Then
			begin
				OtelloWndProc:=0;
				Exit(OtelloWndProc);
			end;
			OtelloChar(ahWnd, wParam);
			end;
	
		WM_ACTIVATE: {$0006:}
			begin
			If GetSystemMetrics(19)=0 Then 
				 begin 
					If  wParam<>0 Then 
					 begin 
						If  (HWND(lParam) <> ahWnd) Then 
						 begin 
						curpoint.x := MousePos.x;
						curpoint.y := MousePos.y;
						ClientToScreen(ahWnd, @curpoint);
						SetCursorPos(curpoint.x, curpoint.y);
						OtelloMouseMove(MousePos);
						ShowCursor(WORD(wParam));
					 End;
				 End  else 					ShowCursor(wParam);
			 End;
		
			If  (wParam<>0) AND (0 = (BAND(BSR(lParam, 16), $0000FFFF))) Then
				SetFocus(ahWnd);
			end;
		
		WM_PAINT: {$000F:}
			begin
				BeginPaint(ahWnd, @ps);
				OtelloPaint(ahWnd, ps._hdc);
				EndPaint(ahWnd, @ps);
			end;
		
		WM_MOUSEMOVE: {$0200:}
			begin 
				pt.x := LOWORD(lParam);
				pt.y := HIWORD(lParam);
				If  Not fThinking Then
					OtelloMouseMove(pt)
				 else	SetCursor(curThink);
			 End;
			
		WM_LBUTTONDOWN: {$0201:}
			begin
			SetCapture(ahWnd);
			bMouseDownInOtello := true;
			end;
	
		WM_LBUTTONUP: {$0202:}
			begin 
				pt.x := LOWORD(lParam);
				pt.y := HIWORD(lParam);
				ReleaseCapture;
				If  (Not fThinking AND bMouseDownInOtello) Then
					OtelloMouseClick(ahWnd, pt);
				bMouseDownInOtello := false;
			 End;

		WM_TIMER, {$0113,}
		$0114,
		$0115:
			;

		otherwise
			begin
			OtelloWndProc:=(DefWindowProcA(ahWnd, message, wParam, lParam));
			Exit(OtelloWndProc);
			end;
		 End;
	 OtelloWndProc:=0;
 End;

 procedure paintmove(var b:OneBoard; move:Longint; friendly:BYTE; enemy:BYTE);

	var d:Longint;
	sq:Longint;
	 p:Integer;{index in direc}
	 i,j:Longint;
	color:Longint;
	 begin 

	If  move <> 20 Then 
	 begin 
		If  friendly = 3 Then 
		 begin 
			SelectObject(hDisp, HGDIOBJ(hbrComputer));
			color := 1;
		 End
	 else 
		 begin 
			SelectObject(hDisp, HGDIOBJ(hbrHuman));
			color := 2;
		 End;

		i := ((move - 11)  div  10) * xExt + Bx + 2 * ASPECT;
		j := ((move - 11)  mod  10) * yExt + By + 2;
		Ellipse(hDisp, i, j, i + xExt - 4 * ASPECT, j + yExt - 4);
		flashsqr(hDisp, i, j, xExt - 4 * ASPECT, yExt - 4, color, 0, 4);

		for p := 0 to 7 do {For all directions}
			 begin 
			d := direc[p];
			sq:=move;
			sq := sq + d;
			If b[sq] = enemy Then 
			 begin 
				While b[sq] = enemy do
					sq := sq + d;
				If b[sq] = friendly Then
				 begin 
					While b[sq - d] = enemy do
					 begin 
						sq := sq - d;
						b[sq] := friendly;
						board[0][sq] := b[sq];
						i := ((sq - 11) div 10)*xExt+Bx+2*ASPECT;
						j := ((sq - 11) mod 10)*yExt+By+2;
						Ellipse(hDisp, i, j, i + xExt-4*ASPECT, j + yExt-4);
					 End;
				 End;
			 End;
		 End;
		b[move]:=friendly;
	 End;
 End;

 procedure Previous( Var px:Longint;  Var py:Longint);
 begin 
	px:=px-1;
	If  px < 0 Then 
	begin 
		px := 7;
		py:=py-1;
		If py < 0 Then
			py := 7;
	 End;
 End;

 procedure printboard(var b:BoardType);

	 var i,j:Longint;
	sq:Longint;

	begin 
	for i:=0 to 7 do
	begin 
		for j:=0 to 7 do
			 begin 
				sq := b[0][i*10+j+11];
				If  (sq <> 1) Then 
				 begin 
				If  (sq = 3) Then
					SelectObject(hDisp, HGDIOBJ(hbrComputer))
				 else
					SelectObject(hDisp, HGDIOBJ(hbrHuman));
				Ellipse(hDisp,
					Bx+2*ASPECT+i*xExt,
					By+2+j*yExt,
					Bx+2*ASPECT + i*xExt + xExt-4*ASPECT,
					By+2+j*yExt + yExt-4);
			 End;
		 End;
	 End;
 End;

 function score(b:OneBoard; friendly:BYTE; enemy:BYTE):Longint;

type ValueType = array[0..78] of Longint;
	ValuePtr = ^ValueType;
const value:ValueType = ( 
		99, -8, 8, 6, 6, 8, -8, 99,000,
		000, -8,-24, -4, -3, -3, -4,-24, -8,000,
		000, 8, -4, 7, 4, 4, 7, -4, 8,000,
		000, 6, -3, 4, 0, 0, 4, -3, 6,000,
		000, 6, -3, 4, 0, 0, 4, -3, 6,000,
		000, 8, -4, 7, 4, 4, 7, -4, 8,000,
		000, -8,-24, -4, -3, -3, -4,-24, -8,000,
		000, 99, -8, 8, 6, 6, 8, -8, 99,32767
		);
	value2:ValueType = (
		99, -8, 8, 6, 6, 8, -8, 99,000,
		000, -8,-24, 0, 1, 1, 0,-24, -8,000,
		000, 8, 0, 7, 4, 4, 7, 0, 8,000,
		000, 6, 1, 4, 1, 1, 4, 1, 6,000,
		000, 6, 1, 4, 1, 1, 4, 1, 6,000,
		000, 8, 0, 7, 4, 4, 7, 0, 8,000,
		000, -8,-24, 0, 1, 1, 1,-24, -8,000,
		000, 99, -8, 8, 6, 6, 8, -8, 99,32767
		);
var
	bv:BYTE;
	pb: Integer; {index in b}
	pvalue:ValuePtr;
	fpoints:Longint;
	epoints:Longint;
	ecount:Longint;
	v,b11,b18,b81,b88:Longint;
	i:Integer;
	 begin 
	fpoints:=0;
	epoints:=0;
	ecount:=0;

	pb := 11;
	b11 := b[pb];
	b18 := b[18];
	b81 := b[81];
	b88 := b[88];
	
	If  ((b11 <> 1) OR (b18 <> 1) OR (b81 <> 1) OR (b88 <> 1)) Then 
		 begin 
		pvalue := @value2;
		If  (b11 = 1) Then 
			 begin 
			value2[12-11] := -8; 
			value2[21-11] := -8; 
			value2[22-11] := -24;
		 End  else 
			 begin 
			value2[12-11] := 12; 
			value2[21-11] := 12; 
			value2[22-11] := 8;
		 End;
	
		If  (b18 = 1) Then 
			 begin 
			value2[17-11] := -8; 
			value2[28-11] := -8; 
			value2[27-11] := -24;
		 End  else 
			 begin 
			value2[17-11] := 12; 
			value2[28-11] := 12; 
			value2[27-11] := 8;
		 End;

		If  (b81 = 1) Then 
			 begin 
			value2[82-11] := -8; 
			value2[71-11] := -8; 
			value2[72-11] := -24;
		 End  else 
			 begin 
			value2[82-11] := 12; 
			value2[71-11] := 12; 
			value2[72-11] := 8;
		 End;
	
		If  (b88 = 1) Then 
			 begin 
			value2[87-11] := -8; 
			value2[78-11] := -8; 
			value2[77-11] := -24;
		 End  else 
			 begin 
			value2[87-11] := 12; 
			value2[78-11] := 12; 
			value2[77-11] := 8;
		 End;
	 End  else 		pvalue := @value;
	
	{Was before: While(v:=^pvalue++)  <> 32767) Do}
	{but this is nicer and safer: /Ingemar}
	for i := 0 to 77 do
	 begin 
	 	v := pvalue^[i];
		bv := b[pb];
		pb:=pb+1;
		If  (bv = friendly) Then
			fpoints := fpoints + v
		 else If  (bv = enemy) Then 
			 begin 
			epoints := epoints + v;
			ecount:=ecount+1;
		 End;
	 End;
	
	If ecount=0 Then
		score:=32000
	 else 		score:=fpoints-epoints;
 End; {score}

 procedure ShowBestMove(hwnd:HWND);

	var hdc:HDC;
	sq:Longint;
	 x, y:Longint;
	pMoves: Integer; {Index in moves} 
	bDone:Boolean;
	 begin 

	If  (fPass = 20) AND Not ffirstmove Then
		Exit(ShowBestMove);

	If  (Not fCheated) Then
		SetWindowTextA(hwnd, @szOtelloPractice);
	fCheated := true;
	SetCursor(curThink);
	fThinking := true;
	If  (ffirstmove) Then 
		 begin 
		x := 4;
		y := 2;
	 End  else 
		 begin 
		If  (depth = 1) Then 
			 begin 
			bDone := false;
			pMoves := 0; {moves;}
			sq := moves[pMoves];

			While(Not bDone) Do 
				 begin 
			sq := moves[pMoves];
	
			If  (legalcheck(board[0], sq, 2, 3)) Then
				bDone := true
			 else 				pMoves:=pMoves+1;
			 End;
	
			y := (sq - 11)  mod  10;
			x := (sq - 11)  div  10;
		 End  else 
		 begin 
			minmax(board, BestMove[0], 3, 2, 1, -32767, 32767);
			y := (BestMove[1] - 11)  mod  10;
			x := (BestMove[1] - 11)  div  10;
		 End;
	 End;
	
	MousePos.x := (x * xExt) + Bx + xExt div 2;
	MousePos.y := (y * yExt) + By + yExt div 2;
	UpdateCursor(hwnd);
	hdc := GetDC(hwnd);
	x := x * xExt + Bx + 2 * ASPECT;
	y := y * yExt + By + 2;
	flashsqr(hdc, x, y, xExt - 4 * ASPECT, yExt - 4, 3, 1, 3);
	fThinking := false;
	ReleaseDC(hwnd, hdc);
	OtelloMouseMove(MousePos);
 End;

 procedure ShowMessageTop(hDC:HDC; aString:LPCSTR);

	var dx:LONG;
	sizeRet:SIZE;

 begin 
	pDisplayMessage := aString;
	ClearMessageTop(hDC);
	SelectObject(hDC, HGDIOBJ(hbrWhite));
	PatBlt(hDC, 0, 0, xscr, charheight, DWORD($00F00021));
	SetBkMode(hDC, 1);
	GetTextExtentPointA(hDC, aString, lstrlenA(aString), @sizeRet);
	dx := sizeRet.cx;
	TextOutA(hDC, Longint(xscr - dx) div 2, 0, aString, lstrlenA(aString));
	MessageOn := true;
	SetBkMode(hDC, 2);
 End;

 procedure ShowNextMove(hwnd:HWND; fforward:Boolean);

	var x, y:Longint;
	potentialmove:Longint;
	done:Boolean;
	 begin 
	If  (fPass = 20) AND Not ffirstmove Then
		Exit(ShowNextMove);

	x := (MousePos.x - Bx)  div  xExt;
	y := (MousePos.y - By)  div  yExt;

	done := false;
	While(Not done) Do 
		 begin 
		Repeat
			begin 
			If fforward Then
				Next(x, y)
			else
				Previous(x, y);
			End;
		potentialmove := x * 10 + y + 11;
		Until Not board[0][potentialmove] <> 1;
		fThinking := true;
		If legalcheck(board[0], potentialmove, 2, 3) Then
			done := true;
		fThinking := false;
	 End;
	
	MousePos.x := x * xExt + Bx + xExt  div  2;
	MousePos.y := y * yExt + By + yExt  div  2;
	UpdateCursor(hwnd);
	OtelloMouseMove(MousePos);
 End;

	function AboutDlgProc(hDlg:HWND; message:UINT; wParam:WPARAM; lParam:LPARAM):BOOL; STDCALL;
	VAR
		rtn:BOOL;
	BEGIN
		if (message = $0111) then begin
			EndDialog(hDlg,1);
			rtn:=1;
		end else if (message = $0110) then
			rtn:=1
		else
			rtn:=0;

		AboutDlgProc:=rtn;
	END;

	PROCEDURE checkdepth(hWindow:HWND; d:WORD);
	VAR
		ahMenu:HMENU;
	BEGIN
		ahMenu:=GetMenu(hWindow);
		CheckMenuItem(ahMenu, prevCheck, $00000000);
		CheckMenuItem(ahMenu, d, $00000008);
		prevCheck:=d;
	END;

	PROCEDURE UpdateCursor(myHWND: HWND);
	var
		curpoint: POINT;
	begin
		curpoint.x := MousePos.x;
		curpoint.y := MousePos.y;
		ClientToScreen(myHWND, LPPOINT(@curpoint));
		SetCursorPos(curpoint.x, curpoint.y);
	end;

	FUNCTION WinMain(ahInstance:HINSTANCE; hPrev:HINSTANCE; lpCmdLine:LPSTR; cmdShow:LONGINT) : LONGINT; STDCALL; DLLIMPORT;

	var hWnd:HWND;
	msg:MSG;

	 begin
	 WinMain:=0;
	hInst := ahInstance;
	If  hPrev=nil Then 
		 begin
	If  (Not OtelloInit(ahInstance)) Then
			Exit(WinMain)
	 End
	 else 
		 begin 
	If  (fThinking) Then
			Exit(WinMain);
	 End;
	
	lpprocInverseMessage := @InverseMessage;
	TYMIN := 45;
	fThinking := false;
	lpprocAbout := @AboutDlgProc;
	if fCheated then
		hWnd := CreateWindowExA(0, @szOtello, @szOtelloPractice, ($00000000 + $00C00000 + $00080000 + $00040000 + $00020000 + $00010000), $80000000, 0,(GetSystemMetrics(0) div 2), (GetSystemMetrics(1) * 4  div  5), nil, nil, ahInstance, nil)
	else
		hWnd := CreateWindowExA(0, @szOtello, @szOtello, ($00000000 + $00C00000 + $00080000 + $00040000 + $00020000 + $00010000), $80000000, 0,(GetSystemMetrics(0) div 2), (GetSystemMetrics(1) * 4  div  5), nil, nil, ahInstance, nil);
	
	If hWnd=nil Then
			Exit(WinMain);
	
	ShowWindow(hWnd, cmdShow);
	UpdateWindow(hWnd);
	
	While GetMessageA(LPMSG(@msg), nil, 0, 0)<>0 Do 
		 begin 
		If 0=TranslateAcceleratorA(msg._hwnd, myhAccel, LPMSG(@msg)) Then 
		 begin 
			TranslateMessage(LPMSG(@msg));
			DispatchMessageA(LPMSG(@msg));
		 End;
	 End;
	 WinMain:=0;
 End;

end.
