@echo off
if "%1" == "h8/300" goto h8300
if "%1" == "m68k" goto m68k

:go32
echo Configuring gas for go32
update config/ho-go32.h host.h
update config/tc-i386.c targ-cpu.c
update config/tc-i386.h targ-cpu.h
update config/te-go32.h targ-env.h
update config/obj-coff.h obj-format.h
update config/obj-coff.c obj-format.c
update config/atof-ieee.c atof-targ.c
set target=go32
set arch=i386
set tdefines=-DMANY_SEGMENTS -DI386COFF
goto common

:m68k
echo Configuring gas for m68k
update config/ho-go32.h host.h
update config/tc-m68k.c targ-cpu.c
update config/tc-m68k.h targ-cpu.h
update config/te-coff.h targ-env.h
update config/obj-coff.h obj-format.h
update config/obj-coff.c obj-format.c
update config/atof-ieee.c atof-targ.c
set target=m68k
set arch=m68k
set tdefines=-DMANY_SEGMENTS -DM68KCOFF
goto common

:h8300
echo Configuring gas for H8/300
copy config\ho-go32.h host.h
copy config\tc-h8300.c targ-cpu.c
copy config\tc-h8300.h targ-cpu.h
copy config\te-generic.h targ-env.h
copy config\objcoffbfd.h obj-format.h
copy config\objcoffbfd.c obj-format.c
copy config\atof-ieee.c atof-targ.c
set target=go32
set arch=i386
set tdefines=-DMANY_SEGMENTS -DI386COFF

:common

echo # Makefile generated by "configure.bat"> Makefile
echo all.dos : as.new>>Makefile

if exist config.sed del config.sed

echo "s/^	\$(srcdir)\/move-if-change/	update/	">> config.sed
echo "/\.o[ 	]*:/ s/config.status//			">> config.sed
echo "/^target=/ c\					">> config.sed
echo "target=%target%					">> config.sed
echo "s/CC = cc/CC = gcc/				">> config.sed
echo "s/:\$/: \$/g					">> config.sed
echo "s/^	\ *\.\//	go32 /			">> config.sed
echo "s/`echo \$(srcdir)\///g				">> config.sed
echo "s/ | sed 's,\^\\\.\/,,'`//g			">> config.sed
echo "s/^	cd \$(srcdir)[ 	]*;//			">> config.sed

echo "/^####/ i\					">> config.sed
echo "TDEFINES=%tdefines% \				">> config.sed
echo "LOCAL_LOADLIBES=../bfd/libbfd.a			">> config.sed

echo "/^all[ 	]*:/ a\					">> config.sed
echo "dummy:						">> config.sed

echo "s/\/usr[^ ]*errno.h//g				">> config.sed

echo "/^config.h[ 	]*:/ d				">> config.sed

sed -e "s/^\"//" -e "s/\"$//" -e "s/[ 	]*$//" config.sed > config2.sed
sed -f config2.sed Makefile.in >> Makefile.2
update Makefile.2 Makefile
del Makefile.2
del config.sed
del config2.sed

echo > config-stamp
echo #define TARGET_CPU "%arch%">config.h1
echo #define TARGET_ALIAS "%arch%">>config.h1
echo #define TARGET_CANONICAL "%arch%">>config.h1
sed -n "/^VERSION=/p" Makefile.in | sed -e "s/VERSION=/#define GAS_VERSION \"/" -e "s/$/\"/">> config.h1
update config.h1 config.h
