/* Definitions of target machine for GNU compiler.  m68K 68020 COFF version.
   Copyright (C) 1988, 1989, 1993 Free Software Foundation, Inc.

Written for M68K COFF version
By: Jayasooriah <jayas@cse.unsw.edu.au>
Date: Sun Oct 30 10:00:05 LST 1994

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "m68k/m68k.h"

/* See m68k.h: 5 is 68020 without 68881 */
#define TARGET_DEFAULT 5

/* Don't try using XFmode.  */
#undef LONG_DOUBLE_TYPE_SIZE
#define LONG_DOUBLE_TYPE_SIZE 64

/* Define __HAVE_68881__ in preprocessor, according to the -m flags.
   This will control the use of inline 68881 insns in certain macros.
   Also inform the program which CPU this is for.  */

/* -msoft-float is the default */
#define CPP_SPEC \
"%{m68881:-D__HAVE_68881__ }\
%{!ansi:%{m68000:-Dmc68010}%{mc68000:-Dmc68010}%{!mc68000:%{!m68000:-Dmc68020}}}"

/* -m68000 requires special flags to the assembler.  */
#define ASM_SPEC \
 "%{m68000:-mc68010}%{mc68000:-mc68010}%{!mc68000:%{!m68000:-mc68020}}"

/* Names to predefine in the preprocessor for this target machine.  */
#define CPP_PREDEFINES \
 "-Dmc68000 -Dmc68k32 -Dm68k -Dcoff -Asystem(coff) -Acpu(m68k) -Amachine(m68k)"

/* Every structure or union's size must be a multiple of 2 bytes.  */
#define STRUCTURE_SIZE_BOUNDARY 16

/* Generate calls to memcpy, memcmp and memset.  */
#define TARGET_MEM_FUNCTIONS

/* We use gnu assembler, linker and gdb, so we want DBX format.  */
#define DBX_DEBUGGING_INFO

/* Brain damage ?!? */
#define	SCCS_DIRECTIVE

/* Use a register prefix to avoid clashes with external symbols (classic
   example: `extern char PC;' in termcap).  */
#undef REGISTER_PREFIX
#define REGISTER_PREFIX "%"

/* In the machine description we can't use %R, because it will not be seen
   by ASM_FPRINTF.  (Isn't that a design bug?).  */
#undef REGISTER_PREFIX_MD
#define REGISTER_PREFIX_MD "%%"

#undef REGISTER_NAMES
#define REGISTER_NAMES \
{"%d0", "%d1", "%d2", "%d3", "%d4", "%d5", "%d6", "%d7", \
 "%a0", "%a1", "%a2", "%a3", "%a4", "%a5", "%a6", "%sp", \
 "%fp0", "%fp1", "%fp2", "%fp3", "%fp4", "%fp5", "%fp6", "%fp7" }

/* Define how to jump to variable address from dispatch table of
   relative addresses, for m68k.md insn.  Note the use of 2 '%'
   chars to output one. */
#define ASM_RETURN_CASE_JUMP return "jmp %%pc@(2,%0:w)"
