OUTPUT_FORMAT("coff-m68k")
 SEARCH_DIR(/gcc/go32/lib);
MEMORY {
	text   	: ORIGIN = 0x1000000, LENGTH = 0x1000000
	talias 	: ORIGIN = 0x2000000, LENGTH = 0x1000000
	data	: ORIGIN = 0x3000000, LENGTH = 0x1000000
	mstack 	: ORIGIN = 0x4000000, LENGTH = 0x1000000
	rstack 	: ORIGIN = 0x5000000, LENGTH = 0x1000000
}
SECTIONS
{
  .text : {
    *(.text)
     etext  =  .;
     __CTOR_LIST__ = .;
     LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
     *(.ctors)
     LONG(0)
     __CTOR_END__ = .;
     __DTOR_LIST__ = .;
     LONG((__DTOR_END__ - __DTOR_LIST__) / 4 - 2)
     *(.dtors)
     LONG(0)
     __DTOR_END__ = .;
    *(.lit)
    *(.shdata)
  }  > text
  .shbss SIZEOF(.text) + ADDR(.text) :	{
    *(.shbss)
  } 
  .talias :	 { }  > talias
  .data  : {
    *(.data)
     edata  =  .;
  }  > data
  .bss   SIZEOF(.data) + ADDR(.data) :
  { 					
     __bss_start = .;
   *(.bss)
   *(COMMON)
      end = ALIGN(0x8);
      _end = ALIGN(0x8);
  }  > data
  .mstack  : { }  > mstack
  .rstack  : { }  > rstack
  .stab  0 (NOLOAD) : 
  {
    [ .stab ]
  }
  .stabstr  0 (NOLOAD) :
  {
    [ .stabstr ]
  }
}
