/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.videolan.vlma.common.Configuration;
import org.videolan.vlma.common.adapters.IVlAdapter;
import org.videolan.vlma.common.exceptions.InvalidServerNameException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VlServer
implements Serializable {
    protected static final Logger logger = Logger.getLogger(VlServer.class);
    protected String name;
    protected InetAddress ip;
    protected Map<String, IVlAdapter> adapters;
    protected boolean isUp;
    protected double currentCpuLoad;
    protected long currentTrafficIn;
    protected long currentTrafficOut;
    protected double currentVlcCpu;
    protected double currentVlcMem;

    public boolean isUp() {
        return this.isUp;
    }

    public boolean getUp() {
        return this.isUp;
    }

    public void setUp(boolean isUp) {
        this.isUp = isUp;
    }

    private void validateServerName(String name) {
        if (name.contains(File.separator)) {
            throw new InvalidServerNameException("Server name musn't contain '" + File.separator + "'.");
        }
    }

    public VlServer(String name, InetAddress ip) {
        this.name = name;
        this.validateServerName(name);
        this.ip = ip;
        this.adapters = new HashMap<String, IVlAdapter>();
        this.setUp(true);
    }

    public VlServer() {
        this.name = "";
        this.ip = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public void setIp(InetAddress ip) {
        this.ip = ip;
    }

    public Map<String, IVlAdapter> getAdapters() {
        return this.adapters;
    }

    private File getRrdDir() {
        File basePath = new File(Configuration.getInstance().getWorkDir());
        File rrdDir = new File(basePath, "rrd");
        if (!rrdDir.exists()) {
            rrdDir.mkdir();
        }
        return rrdDir;
    }

    protected String createRrdFileIfNecessary() {
        File rrdR = new File(this.getRrdDir(), this.getName() + ".rrd");
        if (!rrdR.exists()) {
            logger.log(Level.WARN, "Cr\u00e9ation du fichier de RRD de " + this.getName());
            try {
                RrdDef rrdDef = new RrdDef(rrdR.getPath());
                rrdDef.setStartTime(Util.getTime());
                rrdDef.addDatasource("cpu_load", "GAUGE", 300L, 0.0, Double.NaN);
                rrdDef.addDatasource("traffic_in", "COUNTER", 300L, 0.0, Double.NaN);
                rrdDef.addDatasource("traffic_out", "COUNTER", 300L, 0.0, Double.NaN);
                rrdDef.addDatasource("vlc_cpu", "GAUGE", 300L, 0.0, Double.NaN);
                rrdDef.addDatasource("vlc_mem", "GAUGE", 300L, 0.0, Double.NaN);
                rrdDef.addArchive("AVERAGE", 0.5, 1, 4000);
                rrdDef.addArchive("AVERAGE", 0.5, 6, 4000);
                rrdDef.addArchive("AVERAGE", 0.5, 24, 4000);
                rrdDef.addArchive("AVERAGE", 0.5, 288, 4000);
                RrdDbPool rrdPool = RrdDbPool.getInstance();
                RrdDb rrdDb = rrdPool.requestRrdDb(rrdDef);
                rrdPool.release(rrdDb);
            }
            catch (RrdException e) {
                logger.error("Error while creating RRD file of " + rrdR.getPath(), e);
            }
            catch (IOException e) {
                logger.error("Error while creating RRD file of " + rrdR.getPath(), e);
            }
        }
        return rrdR.getPath();
    }

    public void updateSnmpData() {
    }

    public void updateRrdGraph() {
        long endTime = Util.getTime();
        long startTime = endTime - 86400L;
        try {
            File rrdDir = this.getRrdDir();
            RrdGraphDef graphDef = new RrdGraphDef();
            graphDef.datasource("cpu_load", this.createRrdFileIfNecessary(), "cpu_load", "AVERAGE");
            graphDef.area("cpu_load", Color.RED, "CPU load@L");
            graphDef.line("cpu_load", Color.BLUE, "CPU load@L", 3);
            graphDef.gprint("cpu_load", "AVERAGE", "Average CPU load: @3@r");
            graphDef.setLowerLimit(0.0);
            graphDef.setTimePeriod(startTime, endTime);
            graphDef.setTitle("Load");
            RrdGraph rrdGraph = new RrdGraph(graphDef);
            File rrdGraphFile = new File(rrdDir, this.getName() + "-cpu_load.png");
            rrdGraph.saveAsPNG(rrdGraphFile.getAbsolutePath());
            graphDef = new RrdGraphDef();
            graphDef.datasource("traffic_out", this.createRrdFileIfNecessary(), "traffic_out", "AVERAGE");
            graphDef.line("traffic_out", Color.BLUE, "Outgoing traffic@L", 3);
            graphDef.setLowerLimit(0.0);
            graphDef.setTimePeriod(startTime, endTime);
            graphDef.setTitle("D\u00e9bit sortant sur eth0 sur un jour");
            rrdGraph = new RrdGraph(graphDef);
            rrdGraphFile = new File(rrdDir, this.getName() + "-traffic_out.png");
            rrdGraph.saveAsPNG(rrdGraphFile.getAbsolutePath());
            graphDef = new RrdGraphDef();
            graphDef.datasource("vlc_cpu", this.createRrdFileIfNecessary(), "vlc_cpu", "AVERAGE");
            graphDef.datasource("vlc_mem", this.createRrdFileIfNecessary(), "vlc_mem", "AVERAGE");
            graphDef.line("vlc_cpu", Color.RED, "CPU usage for VLC");
            graphDef.line("vlc_mem", Color.BLUE, "Memory usage for VLC");
            graphDef.setLowerLimit(0.0);
            graphDef.setTimePeriod(startTime, endTime);
            graphDef.setTitle("Resources used for VLC");
            rrdGraph = new RrdGraph(graphDef);
            rrdGraphFile = new File(rrdDir, this.getName() + "-vlc.png");
            rrdGraph.saveAsPNG(rrdGraphFile.getAbsolutePath());
        }
        catch (RrdException e) {
            logger.error("Error while creating RRD file of " + this.getName(), e);
        }
        catch (IOException e) {
            logger.error("Error while creating RRD file of " + this.getName(), e);
        }
    }

    public boolean checkVLC() {
        return true;
    }

    public boolean equals(Object o) {
        if (o.getClass().equals(VlServer.class)) {
            return ((VlServer)o).name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getId() {
        return this.hashCode();
    }
}

