/*
 * Decompiled with CFR 0.152.
 */
package nxt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nxt.Constants;
import nxt.NxtException;
import nxt.blockchain.Block;
import nxt.blockchain.BlockImpl;
import nxt.blockchain.Blockchain;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.BlockchainProcessorImpl;
import nxt.blockchain.FxtTransaction;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionProcessor;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.configuration.Setup;
import nxt.configuration.SubSystem;
import nxt.env.DirProvider;
import nxt.env.RuntimeEnvironment;
import nxt.env.RuntimeMode;
import nxt.env.ServerStatus;
import nxt.http.API;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.util.ResourceLookup;
import nxt.util.Time;
import nxt.util.security.BlockchainPermission;
import org.json.simple.JSONObject;

public final class Nxt {
    public static final String VERSION = "2.2.6";
    public static final String APPLICATION = "Ardor";
    private static volatile Time time = new Time.EpochTime();
    private static volatile ServerStatus serverStatus = ServerStatus.NOT_INITIALIZED;
    public static final String NXT_DEFAULT_PROPERTIES = "nxt-default.properties";
    public static final String NXT_PROPERTIES = "nxt.properties";
    public static final String NXT_INSTALLER_PROPERTIES = "nxt-installer.properties";
    public static final String CONFIG_DIR = "conf";
    private static final RuntimeMode runtimeMode;
    private static final DirProvider dirProvider;
    private static Setup setup;
    private static final Properties defaultProperties;
    private static final Properties properties;

    private static String getInstallerConfiguredRuntimeMode() {
        Properties properties = new Properties();
        Nxt.loadProperties(properties, NXT_INSTALLER_PROPERTIES, true);
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return bl || properties.getProperty("nxt.runtime.mode") == null ? "" : properties.getProperty("nxt.runtime.mode");
    }

    private static void redirectSystemStreams(String string) {
        Object object;
        String string2 = System.getProperty("nxt.redirect.system." + string);
        Path path = null;
        if (string2 != null) {
            try {
                path = Files.createTempFile("nxt.system." + string + ".", ".log", new FileAttribute[0]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        } else {
            object = System.getProperty("nxt.system." + string);
            if (object != null) {
                path = Paths.get((String)object, new String[0]);
            }
        }
        if (path != null) {
            try {
                object = new PrintStream(Files.newOutputStream(path, new OpenOption[0]));
                if (string.equals("out")) {
                    System.setOut(new PrintStream((OutputStream)object));
                } else {
                    System.setErr(new PrintStream((OutputStream)object));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void loadProperties(Properties properties, String string, boolean bl) {
        block48: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new BlockchainPermission("properties"));
            }
            try {
                String string2 = System.getProperty(string);
                if (string2 != null) {
                    System.out.printf("Loading %s from %s\n", string, string2);
                    try (FileInputStream fileInputStream = new FileInputStream(string2);){
                        properties.load(fileInputStream);
                        break block48;
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException(String.format("Error loading %s from %s", string, string2));
                    }
                }
                try (InputStream inputStream = ResourceLookup.getSystemResourceAsStream(string);){
                    Path path;
                    Path path2;
                    if (inputStream != null) {
                        System.out.printf("Loading %s from classpath\n", string);
                        properties.load(inputStream);
                        if (bl) {
                            return;
                        }
                    }
                    if (dirProvider == null || !dirProvider.isLoadPropertyFileFromUserDir()) {
                        return;
                    }
                    String string3 = dirProvider.getUserHomeDir();
                    if (!Files.isReadable(Paths.get(string3, new String[0]))) {
                        System.out.printf("Creating dir %s\n", string3);
                        try {
                            Files.createDirectory(Paths.get(string3, new String[0]), new FileAttribute[0]);
                        }
                        catch (Exception exception) {
                            if (!(exception instanceof NoSuchFileException)) {
                                throw exception;
                            }
                            Files.createDirectory(Paths.get(string3, new String[0]).getParent(), new FileAttribute[0]);
                            Files.createDirectory(Paths.get(string3, new String[0]), new FileAttribute[0]);
                        }
                    }
                    if (!Files.isReadable(path2 = Paths.get(string3, CONFIG_DIR))) {
                        System.out.printf("Creating dir %s\n", path2);
                        Files.createDirectory(path2, new FileAttribute[0]);
                    }
                    if (Files.isReadable(path = Paths.get(path2.toString(), new String[0]).resolve(Paths.get(string, new String[0])))) {
                        System.out.printf("Loading %s from dir %s\n", string, path2);
                        properties.load(Files.newInputStream(path, new OpenOption[0]));
                    } else {
                        System.out.printf("Creating property file %s\n", path);
                        Files.createFile(path, new FileAttribute[0]);
                        Files.write(path, Convert.toBytes("# use this file for workstation specific " + string), new OpenOption[0]);
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Error loading " + string, iOException);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw illegalArgumentException;
            }
        }
    }

    private static void printCommandLineArguments() {
        try {
            List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
            if (list == null || list.size() <= 0) {
                return;
            }
            System.out.println("Command line arguments");
            list.forEach(System.out::println);
        }
        catch (NoClassDefFoundError | AccessControlException throwable) {
            System.out.println("Cannot read input arguments " + throwable.getMessage());
        }
    }

    public static int getIntProperty(String string) {
        return Nxt.getIntProperty(string, 0);
    }

    public static int getIntProperty(String string, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("properties"));
        }
        try {
            int n2 = Integer.parseInt(properties.getProperty(string));
            Logger.logMessage(string + " = \"" + n2 + "\"");
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            Logger.logMessage(string + " not defined or not numeric, using default value " + n);
            return n;
        }
    }

    public static String getStringProperty(String string) {
        return Nxt.getStringProperty(string, null, false);
    }

    public static String getStringProperty(String string, String string2) {
        return Nxt.getStringProperty(string, string2, false);
    }

    public static String getStringProperty(String string, String string2, boolean bl) {
        return Nxt.getStringProperty(string, string2, bl, null);
    }

    public static String getStringProperty(String string, String string2, boolean bl, String string3) {
        String string4;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("properties"));
        }
        if ((string4 = properties.getProperty(string)) != null && !"".equals(string4)) {
            Logger.logMessage(string + " = \"" + (bl ? "{not logged}" : string4) + "\"");
        } else {
            Logger.logMessage(string + " not defined");
            string4 = string2;
        }
        if (string3 == null || string4 == null) {
            return string4;
        }
        try {
            return new String(string4.getBytes(StandardCharsets.ISO_8859_1), string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static List<String> getStringListProperty(String string) {
        String string2 = Nxt.getStringProperty(string);
        if (string2 == null || string2.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : string2.split(";")) {
            if ((string3 = string3.trim()).length() <= 0) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static boolean getBooleanProperty(String string) {
        return Nxt.getBooleanProperty(string, false);
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("properties"));
        }
        String string2 = properties.getProperty(string);
        if (Boolean.TRUE.toString().equals(string2)) {
            Logger.logMessage(string + " = \"true\"");
            return true;
        }
        if (Boolean.FALSE.toString().equals(string2)) {
            Logger.logMessage(string + " = \"false\"");
            return false;
        }
        Logger.logMessage(string + " not defined, using default " + bl);
        return bl;
    }

    public static Blockchain getBlockchain() {
        return BlockchainImpl.getInstance();
    }

    public static BlockchainProcessor getBlockchainProcessor() {
        return BlockchainProcessorImpl.getInstance();
    }

    public static TransactionProcessor getTransactionProcessor() {
        return TransactionProcessorImpl.getInstance();
    }

    public static Block parseBlock(byte[] byArray, List<? extends FxtTransaction> list) throws NxtException.NotValidException {
        return BlockImpl.parseBlock(byArray, list);
    }

    public static Transaction parseTransaction(byte[] byArray) throws NxtException.NotValidException {
        return TransactionImpl.parseTransaction(byArray);
    }

    public static Transaction.Builder newTransactionBuilder(byte[] byArray) throws NxtException.NotValidException {
        return TransactionImpl.newTransactionBuilder(byArray);
    }

    public static Transaction.Builder newTransactionBuilder(JSONObject jSONObject) throws NxtException.NotValidException {
        return TransactionImpl.newTransactionBuilder(jSONObject);
    }

    public static Transaction.Builder newTransactionBuilder(byte[] byArray, JSONObject jSONObject) throws NxtException.NotValidException {
        return TransactionImpl.newTransactionBuilder(byArray, jSONObject);
    }

    public static int getEpochTime() {
        return time.getTime();
    }

    public static void setTime(Time time) {
        Nxt.time = time;
    }

    public static void main(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("lifecycle"));
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(Nxt::shutdown));
            Nxt.init();
        }
        catch (Throwable throwable) {
            System.out.println("Fatal error: " + throwable.toString());
            throwable.printStackTrace();
        }
    }

    public static void init(Setup setup, Properties properties) {
        Nxt.properties.putAll((Map<?, ?>)properties);
        Nxt.init(setup);
    }

    public static void init() {
        Nxt.init(Setup.FULL_NODE);
    }

    public static void init(Setup setup) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("lifecycle"));
        }
        Nxt.setup = setup;
        Init.init(setup);
    }

    public static void shutdown() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("lifecycle"));
        }
        Logger.logShutdownMessage("Shutting down...");
        setup.shutdownSequence().forEach(SubSystem::shutdown);
    }

    public static String getProcessId() {
        String string;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("sensitiveInfo"));
        }
        try {
            string = ManagementFactory.getRuntimeMXBean().getName();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return "";
        }
        if (string == null) {
            return "";
        }
        String[] stringArray = string.split("@");
        if (stringArray.length == 2) {
            return stringArray[0];
        }
        return "";
    }

    public static String getDbDir(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("dirProvider"));
        }
        return dirProvider.getDbDir(string);
    }

    public static void updateLogFileHandler(Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("dirProvider"));
        }
        dirProvider.updateLogFileHandler(properties);
    }

    public static String getUserHomeDir() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("dirProvider"));
        }
        return dirProvider.getUserHomeDir();
    }

    public static File getConfDir() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("dirProvider"));
        }
        return dirProvider.getConfDir();
    }

    public static void setServerStatus(ServerStatus serverStatus, URI uRI) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("lifecycle"));
        }
        Nxt.serverStatus = serverStatus;
        runtimeMode.setServerStatus(serverStatus, uRI, dirProvider.getLogFileDir());
    }

    public static ServerStatus getServerStatus() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("sensitiveInfo"));
        }
        return serverStatus;
    }

    public static RuntimeMode getRuntimeMode() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("sensitiveInfo"));
        }
        return runtimeMode;
    }

    public static boolean isEnabled(SubSystem subSystem) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("sensitiveInfo"));
        }
        return setup.initSequence().contains(subSystem);
    }

    private Nxt() {
    }

    static {
        setup = Setup.NOT_INITIALIZED;
        defaultProperties = new Properties();
        Nxt.redirectSystemStreams("out");
        Nxt.redirectSystemStreams("err");
        System.out.println("Initializing Nxt server version 2.2.6");
        Nxt.printCommandLineArguments();
        String string = Nxt.getInstallerConfiguredRuntimeMode();
        runtimeMode = RuntimeEnvironment.getRuntimeMode(string);
        System.out.printf("Runtime mode %s\n", runtimeMode.getClass().getName());
        dirProvider = RuntimeEnvironment.getDirProvider(string);
        System.out.println("User home folder " + dirProvider.getUserHomeDir());
        Nxt.loadProperties(defaultProperties, NXT_DEFAULT_PROPERTIES, true);
        if (!VERSION.equals(defaultProperties.getProperty("nxt.version"))) {
            throw new RuntimeException("Using an nxt-default.properties file from a version other than 2.2.6 is not supported!!!");
        }
        properties = new Properties(defaultProperties);
        Nxt.loadProperties(properties, NXT_INSTALLER_PROPERTIES, true);
        Nxt.loadProperties(properties, NXT_PROPERTIES, false);
    }

    private static class Init {
        private static volatile boolean initialized = false;

        private static void init(Setup setup) {
            if (initialized) {
                throw new RuntimeException("Nxt.init has already been called");
            }
            try {
                long l = System.currentTimeMillis();
                setup.initSequence().forEach(SubSystem::init);
                Init.logInitMessages(l);
            }
            catch (Exception exception) {
                Logger.logErrorMessage(exception.getMessage(), exception);
                runtimeMode.alert(exception.getMessage() + "\nSee additional information in " + Paths.get(dirProvider.getLogFileDir().getPath(), "nxt.log").toAbsolutePath());
                System.exit(1);
            }
            initialized = true;
        }

        private static void logInitMessages(long l) {
            long l2 = System.currentTimeMillis();
            Logger.logMessage("Initialization took " + (l2 - l) / 1000L + " seconds");
            Logger.logMessage("Ardor server 2.2.6 started successfully.");
            Logger.logMessage("Copyright \u00a9 2013-2016 The Nxt Core Developers.");
            Logger.logMessage("Copyright \u00a9 2016-2019 Jelurida IP B.V.");
            Logger.logMessage("Distributed under the Jelurida Public License version 1.2 for the Ardor Public Blockchain Platform, with ABSOLUTELY NO WARRANTY.");
            if (API.getWelcomePageUri() != null) {
                Logger.logMessage("Client UI is at " + API.getWelcomePageUri());
            }
            if (Constants.isTestnet) {
                Logger.logMessage("RUNNING ON TESTNET - DO NOT USE REAL ACCOUNTS!");
            }
            Nxt.setServerStatus(ServerStatus.STARTED, API.getWelcomePageUri());
        }

        private Init() {
        }
    }
}

