/*
 * Decompiled with CFR 0.152.
 */
package nxt.account;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountPropertyTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public final class AccountPropertyAttachment
extends Attachment.AbstractAttachment {
    private final String property;
    private final String value;

    AccountPropertyAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.property = Account.PROPERTY_NAME_RW.readFromBuffer(byteBuffer).trim();
        this.value = Account.PROPERTY_VALUE_RW.readFromBuffer(byteBuffer).trim();
    }

    AccountPropertyAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.property = Convert.nullToEmpty((String)jSONObject.get((Object)"property")).trim();
        this.value = Convert.nullToEmpty((String)jSONObject.get((Object)"value")).trim();
    }

    public AccountPropertyAttachment(String string, String string2) {
        this.property = string.trim();
        this.value = Convert.nullToEmpty(string2).trim();
    }

    @Override
    protected int getMySize() {
        return Account.PROPERTY_NAME_RW.getSize(this.property) + Account.PROPERTY_VALUE_RW.getSize(this.value);
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        Account.PROPERTY_NAME_RW.writeToBuffer(this.property, byteBuffer);
        Account.PROPERTY_VALUE_RW.writeToBuffer(this.value, byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"property", (Object)this.property);
        jSONObject.put((Object)"value", (Object)this.value);
    }

    @Override
    public TransactionType getTransactionType() {
        return AccountPropertyTransactionType.ACCOUNT_PROPERTY_SET;
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }
}

