/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nxt.Nxt;
import nxt.account.AccountRestrictions;
import nxt.addons.ChainWrapper;
import nxt.addons.ContractAndSetupParameters;
import nxt.addons.ContractRunnerConfig;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.addons.ParamInvocationHandler;
import nxt.addons.RandomnessSource;
import nxt.addons.ReproducibleRandomness;
import nxt.blockchain.Block;
import nxt.blockchain.Blockchain;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.crypto.Crypto;
import nxt.http.APICall;
import nxt.http.JSONData;
import nxt.http.callers.GetConstantsCall;
import nxt.http.responses.BlockResponse;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONValue;

public abstract class AbstractContractContext {
    public static final int INTERNAL_ERROR_CODE_THRESHOLD = 10000;
    protected static final int VALIDATE_SAME_ACCOUNT_CODE = 1011;
    protected static final int VALIDATE_SAME_TRANSACTION_TYPE = 1012;
    protected static final int VALIDATE_SAME_CHAIN = 1013;
    protected static final int FEE_CANNOT_CALCULATE = 1021;
    protected static final int FEE_EXCEEDS_AMOUNT = 1022;
    protected static final int MESSAGE_TO_ENCRYPT_WITHOUT_SECRET_PHRASE = 1031;
    private final Blockchain blockchain = AccessController.doPrivileged(Nxt::getBlockchain);
    protected static final Map<Integer, ChainWrapper> chainById;
    protected static final Map<String, ChainWrapper> chainByName;
    protected EventSource source;
    protected ContractRunnerConfig config;
    private JO contractSetupParameters;
    protected final String contractName;
    private final String logMessagePrefix;
    private JO response;
    private RandomnessSource randomnessSource;
    private static volatile JO blockchainConstants;

    AbstractContractContext(ContractRunnerConfig contractRunnerConfig, String string) {
        this.config = contractRunnerConfig;
        this.contractName = string;
        this.logMessagePrefix = "{" + string + "} ";
        if (blockchainConstants == null) {
            AbstractContractContext.initBlockchainConstants();
        }
    }

    private static synchronized void initBlockchainConstants() {
        if (blockchainConstants == null) {
            blockchainConstants = GetConstantsCall.create().call();
        }
    }

    public <T extends AbstractContractContext> T getContext() {
        return (T)this;
    }

    public String getContractName() {
        return this.contractName;
    }

    public abstract BlockResponse getBlock();

    public RandomnessSource initRandom(long l) {
        if (this.randomnessSource != null) {
            throw new IllegalStateException("Random number generator is already initialized");
        }
        BlockResponse blockResponse = this.getBlock();
        if (blockResponse == null) {
            throw new UnsupportedOperationException("Cannot generate random value for unknown block");
        }
        MessageDigest messageDigest = Crypto.sha256();
        messageDigest.update(blockResponse.getBlockSignature());
        messageDigest.update(this.getConfig().getRunnerSeed());
        messageDigest.update(Convert.longToBytes(l));
        byte[] byArray = messageDigest.digest();
        long l2 = new BigInteger(1, new byte[]{byArray[7], byArray[6], byArray[5], byArray[4], byArray[3], byArray[2], byArray[1], byArray[0]}).longValue();
        this.randomnessSource = new ReproducibleRandomness();
        Logger.logInfoMessage("Init Randomness with seed %d", l2);
        this.randomnessSource.setSeed(l2);
        return this.randomnessSource;
    }

    public RandomnessSource getRandomnessSource() {
        if (this.randomnessSource == null) {
            throw new IllegalStateException("Random number generator not initialized yet");
        }
        return this.randomnessSource;
    }

    public EventSource getSource() {
        return this.source;
    }

    public JO getContractRunnerConfigParams(String string) {
        if (this.config.getParams().isExist(string)) {
            return this.config.getParams().getJo(string);
        }
        return new JO();
    }

    public ContractRunnerConfig getConfig() {
        return this.config;
    }

    public String getAccount() {
        return this.getConfig().getAccount();
    }

    public String getAccountRs() {
        return this.getConfig().getAccountRs();
    }

    public byte[] getPublicKey() {
        return this.getConfig().getPublicKey();
    }

    public String getPublicKeyHexString() {
        return this.getConfig().getPublicKeyHexString();
    }

    public JO getBlockchainConstants() {
        return blockchainConstants;
    }

    public JO getResponse() {
        return this.response;
    }

    public JO generateResponse(JO jO) {
        if (this.response != null) {
            throw new IllegalStateException("Response already set: " + this.response.toJSONString());
        }
        this.response = jO;
        return jO;
    }

    public JO generateInfoResponse(String string, Object ... objectArray) {
        if (this.response != null) {
            throw new IllegalStateException("Response already set: " + this.response.toJSONString());
        }
        this.response = new JO();
        this.response.put("info", String.format(string, objectArray));
        Logger.logInfoMessage(this.response.toJSONString());
        return this.response;
    }

    public JO generateErrorResponse(int n, String string, Object ... objectArray) {
        if (n < 10000) {
            throw new IllegalArgumentException("Error codes below 10000 are reserved for internal usage");
        }
        return this.generateErrorResponseImpl(n, string, objectArray);
    }

    protected JO generateInternalErrorResponse(int n, String string, Object ... objectArray) {
        if (n >= 10000) {
            throw new IllegalArgumentException("Error codes above 10000 are reserved for contract usage");
        }
        return this.generateErrorResponseImpl(n, string, objectArray);
    }

    private JO generateErrorResponseImpl(int n, String string, Object ... objectArray) {
        if (this.response == null) {
            this.response = new JO();
        }
        this.response.put("errorCode", (Object)n);
        this.response.put("errorDescription", String.format(string, objectArray));
        Logger.logErrorMessage(this.response.toJSONString());
        return this.response;
    }

    protected JO addTriggerData(JO jO) {
        jO.put("source", this.getSource().toString());
        jO.put("submittedBy", this.contractName);
        if (this.randomnessSource != null) {
            jO.put("publicSeed", "" + this.randomnessSource.getSeed());
        }
        return jO;
    }

    protected abstract String getReferencedTransaction();

    public JO createTransaction(APICall.Builder builder) {
        return this.createTransaction(builder, true);
    }

    public JO createTransaction(APICall.Builder builder, boolean bl) {
        long l = this.getTransactionFee(builder);
        if (l < 0L) {
            return this.generateInternalErrorResponse(1021, "%s: cannot calculate fee, try autoFeeRate or defining feeRateNQTPerFXT for chain %s in contract runner configuration", this.contractName, builder.getParam("chain"));
        }
        builder.param("feeNQT", l);
        if (bl && builder.isParamSet("amountNQT")) {
            long l2 = Long.parseLong(builder.getParam("amountNQT"));
            if (l > l2) {
                return this.generateInternalErrorResponse(1022, "%s: calculated fee %d bigger than amount %d", this.getClass().getName(), l, l2);
            }
            builder.param("amountNQT", Math.subtractExact(l2, l));
        }
        JO jO = this.createTransactionImpl(builder);
        if (this.response == null) {
            this.response = new JO();
        } else if (this.response.isExist("errorCode")) {
            return this.response;
        }
        if (!this.response.isExist("transactions")) {
            this.response.put("transactions", new JA());
        }
        JA jA = this.response.getArray("transactions");
        jA.add(jO);
        return this.response;
    }

    private long getTransactionFee(APICall.Builder builder) {
        boolean bl = !"false".equalsIgnoreCase(builder.getParam("broadcast"));
        builder.param("broadcast", false);
        JO jO = this.createTransactionImpl(builder);
        builder.param("broadcast", bl);
        if (!jO.isExist("minimumFeeFQT")) {
            return 0L;
        }
        long l = jO.getLong("minimumFeeFQT");
        int n = Integer.parseInt(builder.getParam("chain"));
        ChainWrapper chainWrapper = chainById.get(n);
        if (!chainWrapper.isChildChain()) {
            return l;
        }
        long l2 = this.config.getCurrentFeeRateNQTPerFXT(n);
        if (l2 == -1L) {
            return -1L;
        }
        return BigDecimal.valueOf(l).multiply(BigDecimal.valueOf(l2)).divide(BigDecimal.valueOf(chainWrapper.getOneCoin()), RoundingMode.HALF_EVEN).longValue();
    }

    private JO createTransactionImpl(APICall.Builder builder) {
        Object object;
        AccountRestrictions.PhasingOnly phasingOnly;
        JO jO = builder.isParamSet("message") && "true".equals(builder.getParam("messageIsPrunable")) ? new JO(JSONValue.parse((String)builder.getParam("message"))) : new JO();
        jO = this.addTriggerData(jO);
        String string = jO.toJSONString();
        builder.param("message", string);
        builder.param("messageIsPrunable", "true");
        if (!builder.isParamSet("secretPhrase")) {
            if (builder.isParamSet("messageToEncrypt")) {
                return this.generateInternalErrorResponse(1031, "%s: do not use the messageToEncrypt parameter, encrypt the data yourself and submit the encryptedMessageData and encryptedMessageNonce instead", this.getClass().getName());
            }
            builder.param("publicKey", this.config.getPublicKeyHexString());
        }
        int n = Integer.parseInt(builder.getParam("chain"));
        if (!builder.isParamSet("feeNQT") && chainById.get(n).isChildChain()) {
            builder.param("feeRateNQTPerFXT", this.config.getCurrentFeeRateNQTPerFXT(n));
        }
        Block block = this.blockchain.getLastBlock();
        builder.param("ecBlockHeight", block.getHeight());
        builder.param("ecBlockId", Long.toUnsignedString(block.getId()));
        builder.param("timestamp", block.getTimestamp());
        String string2 = this.getReferencedTransaction();
        if (string2 != null && chainById.get(n).isChildChain()) {
            builder.param("referencedTransaction", string2);
        }
        if ((phasingOnly = AccessController.doPrivileged(() -> AccountRestrictions.PhasingOnly.get(this.config.getAccountId()))) != null) {
            builder.param("phased", "true");
            builder.param("phasingFinishHeight", this.getBlockchainHeight() + phasingOnly.getMinDuration() + 4);
            object = new JO(JSONData.phasingOnly(phasingOnly));
            builder.param("phasingParams", ((JO)object).getJo("controlParams").toJSONString());
        } else {
            object = this.getPhasingAttachment();
            if (object != null && VoteWeighting.VotingModel.get(((JO)object).getByte("phasingVotingModel")) == VoteWeighting.VotingModel.HASH) {
                builder.param("phased", "true");
                builder.param("phasingFinishHeight", ((JO)object).getInt("phasingFinishHeight"));
                builder.param("phasingParams", ((JO)object).toJSONString());
            }
        }
        object = builder.build();
        return ((APICall)object).getJsonResponse();
    }

    protected JO getPhasingAttachment() {
        return null;
    }

    public ContractAndSetupParameters loadContract(String string) {
        ContractAndSetupParameters contractAndSetupParameters = this.getConfig().getContractProvider().getContract(string);
        if (contractAndSetupParameters == null) {
            throw new IllegalArgumentException("Contract " + string + " not loaded by the contract runner");
        }
        return contractAndSetupParameters;
    }

    public byte[] getHash(byte[] byArray) {
        return this.getHash(byArray, "SHA-256");
    }

    public byte[] getHash(byte[] byArray, String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        return messageDigest.digest(byArray);
    }

    public byte[] sign(byte[] byArray, String string) {
        return Crypto.sign(byArray, string);
    }

    public boolean verify(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return Crypto.verify(byArray, byArray2, byArray3);
    }

    public long fullHashToId(byte[] byArray) {
        return Convert.fullHashToId(byArray);
    }

    public long fullHashToId(String string) {
        return this.fullHashToId(Convert.parseHexString(string));
    }

    public long publicKeyToAccountId(byte[] byArray) {
        byte[] byArray2 = Crypto.sha256().digest(byArray);
        return this.fullHashToId(byArray2);
    }

    public long publicKeyToAccountId(String string) {
        return this.publicKeyToAccountId(Convert.parseHexString(string));
    }

    public ChainWrapper getChain(String string) {
        return chainByName.get(string);
    }

    public ChainWrapper getChain(int n) {
        return chainById.get(n);
    }

    public ChainWrapper getParentChain() {
        return chainById.get(FxtChain.FXT.getId());
    }

    public long parseAccountId(String string) {
        return Convert.parseAccountId(string);
    }

    public String rsAccount(long l) {
        return Convert.rsAccount(l);
    }

    public int getBlockchainHeight() {
        return this.blockchain.getHeight();
    }

    public void logInfoMessage(String string, Object ... objectArray) {
        Logger.logInfoMessage(this.logMessagePrefix + string, objectArray);
    }

    public void logErrorMessage(Throwable throwable) {
        Logger.logErrorMessage(this.logMessagePrefix + throwable.toString(), throwable);
    }

    public byte[] parseHexString(String string) {
        return Convert.parseHexString(string);
    }

    public String toHexString(byte[] byArray) {
        return Convert.toHexString(byArray);
    }

    public byte[] getPublicKey(String string) {
        return Crypto.getPublicKey(string);
    }

    public boolean isPermissionGranted(Permission permission) {
        try {
            System.getSecurityManager().checkPermission(permission);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public JO getRuntimeParams() {
        return new JO();
    }

    public JO getContractSetupParameters() {
        return this.contractSetupParameters;
    }

    public <Params> Params getParams(Class<Params> clazz) {
        JO jO = this.getContractRunnerConfigParams(this.getContractName());
        JO jO2 = this.getRuntimeParams();
        return ParamInvocationHandler.getParams(clazz, jO, this.contractSetupParameters, jO2);
    }

    public void setContractSetupParameters(JO jO) {
        this.contractSetupParameters = jO;
    }

    static {
        HashMap<Integer, ChainWrapper> hashMap = new HashMap<Integer, ChainWrapper>();
        HashMap hashMap2 = new HashMap();
        hashMap.put(FxtChain.FXT.getId(), new ChainWrapper(FxtChain.FXT));
        ChildChain.getAll().forEach(childChain -> hashMap.put(childChain.getId(), new ChainWrapper((Chain)childChain)));
        hashMap2.put(FxtChain.FXT.getName(), hashMap.get(FxtChain.FXT.getId()));
        ChildChain.getAll().forEach(childChain -> {
            ChainWrapper cfr_ignored_0 = (ChainWrapper)hashMap2.put(childChain.getName(), hashMap.get(childChain.getId()));
        });
        chainById = Collections.unmodifiableMap(hashMap);
        chainByName = Collections.unmodifiableMap(hashMap2);
    }

    public static enum EventSource {
        BLOCK,
        TRANSACTION,
        REQUEST,
        VOUCHER,
        NONE;


        public boolean isTransaction() {
            return this == TRANSACTION;
        }

        public boolean isBlock() {
            return this == BLOCK;
        }

        public boolean isRequest() {
            return this == REQUEST;
        }

        public boolean isVoucher() {
            return this == VOUCHER;
        }
    }
}

