/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.util.HashMap;
import java.util.Map;
import nxt.Constants;
import nxt.Nxt;
import nxt.account.Account;
import nxt.addons.ContractProvider;
import nxt.addons.ContractRunnerConfig;
import nxt.addons.ContractRunnerPermission;
import nxt.addons.JO;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.peer.Peers;
import nxt.util.Convert;
import nxt.util.Logger;

class ActiveContractRunnerConfig
implements ContractRunnerConfig {
    private static final String ERROR_PREFIX = "contract runner config error: ";
    private final ContractProvider contractProvider;
    private String secretPhrase;
    private byte[] publicKey;
    private String publicKeyHexString;
    private long accountId;
    private String account;
    private String accountRs;
    private boolean autoFeeRate;
    private long minBundlerBalanceFXT;
    private long minBundlerFeeLimitFQT;
    private Map<Integer, Long> feeRatePerChain;
    private JO params;
    private boolean isValidator;
    private String validatorSecretPhrase;
    private int catchUpInterval;
    private int maxSubmittedTransactionsPerInvocation;
    private byte[] runnerSeed;

    ActiveContractRunnerConfig(ContractProvider contractProvider) {
        this.contractProvider = contractProvider;
    }

    @Override
    public void init(JO jO) {
        this.initAccount(jO);
        this.initFee(jO);
        this.initParams(jO);
        this.initValidation(jO);
        this.initRandomSeed(jO);
        this.initMisc(jO);
        Logger.logInfoMessage("Contract Runner configuration loaded for account %s", this.accountRs);
    }

    private void initAccount(JO jO) {
        this.secretPhrase = this.getProperty(jO, "secretPhrase");
        if (Convert.emptyToNull(this.secretPhrase) == null) {
            String string = this.getProperty(jO, "accountRS");
            if (string == null) {
                throw new IllegalArgumentException("contract runner config error: secretPhrase or accountRS must be defined");
            }
            this.accountId = Convert.parseAccountId(string);
            this.publicKey = Account.getPublicKey(this.accountId);
            if (this.publicKey == null) {
                throw new IllegalArgumentException(String.format("contract runner config error: account %s does not have a public key", string));
            }
        } else {
            this.publicKey = Crypto.getPublicKey(this.secretPhrase);
            this.accountId = Account.getId(this.publicKey);
        }
        this.publicKeyHexString = Convert.toHexString(this.publicKey);
        this.account = Long.toUnsignedString(this.accountId);
        this.accountRs = Convert.rsAccount(this.accountId);
    }

    private void initFee(JO jO) {
        this.autoFeeRate = Boolean.parseBoolean(this.getProperty(jO, "autoFeeRate"));
        this.minBundlerBalanceFXT = this.getLongProperty(jO, "minBundlerBalanceFXT", 0L, 1000000000L, Constants.minBundlerBalanceFXT);
        this.minBundlerFeeLimitFQT = this.getLongProperty(jO, "minBundlerFeeLimitFQT", 0L, 100000000000000000L, (long)Constants.minBundlerFeeLimitFXT * 100000000L);
        this.feeRatePerChain = new HashMap<Integer, Long>();
        for (Chain chain : ChildChain.getAll()) {
            String string = this.getProperty(jO, "feeRateNQTPerFXT." + chain.getName());
            if (string == null) continue;
            long l = Long.parseLong(string);
            this.feeRatePerChain.put(chain.getId(), l);
        }
        if (this.secretPhrase != null && !this.autoFeeRate && this.feeRatePerChain.size() == 0) {
            throw new IllegalArgumentException("contract runner config error: feeRateNQTPerFXT not specified for any chain and autoFeeRate isn't enabled");
        }
    }

    private void initParams(JO jO) {
        this.params = jO.isExist("params") ? jO.getJo("params") : new JO();
    }

    private void initValidation(JO jO) {
        this.isValidator = Boolean.parseBoolean(this.getProperty(jO, "validator"));
        if (this.isValidator) {
            String string = this.getProperty(jO, "validatorSecretPhrase");
            if (string != null && this.validatorSecretPhrase != null) {
                throw new IllegalArgumentException("contract runner config error: cannot switch validator secret phrase during runtime");
            }
            this.validatorSecretPhrase = this.getProperty(jO, "validatorSecretPhrase");
            if (this.validatorSecretPhrase == null) {
                Logger.logWarningMessage("Contract runner validatorSecretPhrase not specified, contract won't be able to approve other contract transactions");
            } else if (Convert.emptyToNull(this.secretPhrase) != null) {
                throw new IllegalArgumentException("contract runner config error: do not specify both secretPhrase and validatorSecretPhrase");
            }
        } else {
            this.validatorSecretPhrase = null;
        }
    }

    private void initRandomSeed(JO jO) {
        String string = this.getProperty(jO, "seed");
        if (string != null) {
            this.runnerSeed = Convert.parseHexString(string);
            if (this.runnerSeed.length < 16) {
                Logger.logWarningMessage("Contract runner random seed is shorter than 16 bytes, it might be possible to brute force it");
            }
        } else {
            Logger.logWarningMessage("Contract runner random seed not specified, random values generated by this contract runner will be predictable");
            this.runnerSeed = this.publicKey;
        }
    }

    private void initMisc(JO jO) {
        this.catchUpInterval = jO.getInt("catchUpInterval", 3600);
        this.maxSubmittedTransactionsPerInvocation = jO.getInt("maxSubmittedTransactionsPerInvocation", 10);
    }

    private String getProperty(JO jO, String string) {
        if (jO.isExist(string)) {
            return jO.getString(string);
        }
        return Nxt.getStringProperty("addon.contractRunner." + string, null, string.toLowerCase().endsWith("secretphrase"));
    }

    private long getLongProperty(JO jO, String string, long l, long l2, long l3) {
        String string2 = Convert.emptyToNull(this.getProperty(jO, string));
        if (string2 == null) {
            return l3;
        }
        long l4 = Long.parseLong(string2);
        if (l4 < l || l4 > l2) {
            throw new IllegalArgumentException(ERROR_PREFIX + String.format("value %d for property %s not in range [%d-%d]", l4, string, l, l2));
        }
        return l4;
    }

    @Override
    public String getSecretPhrase() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ContractRunnerPermission("config"));
        }
        return this.secretPhrase;
    }

    @Override
    public String getValidatorSecretPhrase() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ContractRunnerPermission("config"));
        }
        return this.validatorSecretPhrase;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getPublicKeyHexString() {
        return this.publicKeyHexString;
    }

    @Override
    public long getAccountId() {
        return this.accountId;
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    @Override
    public String getAccountRs() {
        return this.accountRs;
    }

    @Override
    public boolean isAutoFeeRate() {
        return this.autoFeeRate;
    }

    @Override
    public long getMinBundlerBalanceFXT() {
        return this.minBundlerBalanceFXT;
    }

    @Override
    public long getMinBundlerFeeLimitFQT() {
        return this.minBundlerFeeLimitFQT;
    }

    @Override
    public long getFeeRateNQTPerFXT(int n) {
        if (this.feeRatePerChain.get(n) == null) {
            return -1L;
        }
        return this.feeRatePerChain.get(n);
    }

    @Override
    public long getCurrentFeeRateNQTPerFXT(int n) {
        long l = -1L;
        if (this.autoFeeRate) {
            l = Peers.getBestBundlerRate(Chain.getChain(n), this.minBundlerBalanceFXT, this.minBundlerFeeLimitFQT, Peers.getBestBundlerRateWhitelist());
        }
        if (l == -1L) {
            l = this.getFeeRateNQTPerFXT(n);
        }
        return l;
    }

    @Override
    public JO getParams() {
        return this.params;
    }

    @Override
    public boolean isValidator() {
        return this.isValidator;
    }

    @Override
    public int getCatchUpInterval() {
        return this.catchUpInterval;
    }

    @Override
    public int getMaxSubmittedTransactionsPerInvocation() {
        return this.maxSubmittedTransactionsPerInvocation;
    }

    @Override
    public byte[] getRunnerSeed() {
        return this.runnerSeed;
    }

    @Override
    public ContractProvider getContractProvider() {
        return this.contractProvider;
    }

    @Override
    public EncryptedData encryptTo(byte[] byArray, byte[] byArray2, boolean bl) {
        return Account.encryptTo(byArray, byArray2, this.secretPhrase, bl);
    }

    @Override
    public byte[] decryptFrom(byte[] byArray, EncryptedData encryptedData, boolean bl) {
        return Account.decryptFrom(byArray, encryptedData, this.secretPhrase, bl);
    }

    @Override
    public String getStatus() {
        if (this.secretPhrase != null && !this.isValidator) {
            return "Running";
        }
        if (this.validatorSecretPhrase != null && this.isValidator) {
            return "Validating";
        }
        return "Passphrase Not Specified";
    }
}

