/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import nxt.ae.Asset;
import nxt.ae.AssetExchangeTransactionType;
import nxt.blockchain.Bundler;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;

public class AssetBundler
implements Bundler.Filter {
    private static final Collection<TransactionType> OK_TYPES = Collections.unmodifiableList(Arrays.asList(AssetExchangeTransactionType.ASSET_TRANSFER, AssetExchangeTransactionType.ASK_ORDER_PLACEMENT, AssetExchangeTransactionType.BID_ORDER_PLACEMENT, AssetExchangeTransactionType.ASK_ORDER_CANCELLATION, AssetExchangeTransactionType.BID_ORDER_CANCELLATION));
    private long assetId;

    @Override
    public boolean ok(Bundler bundler, ChildTransaction childTransaction) {
        TransactionType transactionType = childTransaction.getType();
        if (!(transactionType instanceof AssetExchangeTransactionType)) {
            return false;
        }
        if (!OK_TYPES.contains(transactionType)) {
            return false;
        }
        return this.assetId == ((AssetExchangeTransactionType)transactionType).getAssetId(childTransaction);
    }

    @Override
    public void setParameter(String string) {
        long l = Convert.parseUnsignedLong(string);
        if (Asset.getAsset(l) == null) {
            throw new IllegalArgumentException("Unknown asset " + string);
        }
        this.assetId = l;
    }

    @Override
    public String getParameter() {
        return Long.toUnsignedString(this.assetId);
    }

    @Override
    public String getName() {
        return "AssetBundler";
    }

    @Override
    public String getDescription() {
        return "Bundles only transactions for asset with ID provided as parameter";
    }
}

