/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.addons.AddOn;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildChain;
import nxt.dbschema.Db;
import nxt.http.APIServlet;
import nxt.http.APITag;
import nxt.http.JSONResponses;
import nxt.http.ParameterParser;
import nxt.util.Convert;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public final class JPLSnapshot
implements AddOn {
    @Override
    public APIServlet.APIRequestHandler getAPIRequestHandler() {
        return new JPLSnapshotAPI("newGenesisAccounts", new APITag[]{APITag.ADDONS}, new String[]{"height"});
    }

    @Override
    public String getAPIRequestType() {
        return "downloadJPLSnapshot";
    }

    private static class JPLSnapshotListener
    implements Listener<Block> {
        private final int height;
        private final JSONObject inputJSON;
        private final SortedMap<String, Object> snapshot = new TreeMap<String, Object>();
        private final CountDownLatch latch = new CountDownLatch(1);

        private JPLSnapshotListener(int n, JSONObject jSONObject) {
            this.height = n;
            this.inputJSON = jSONObject;
        }

        @Override
        public void notify(Block block) {
            if (block.getHeight() == this.height) {
                SortedMap<String, Long> sortedMap = this.snapshotIgnisBalances();
                Logger.logInfoMessage("Snapshot contains " + sortedMap.entrySet().size() + " Ignis balances");
                BigInteger bigInteger = BigInteger.valueOf(sortedMap.values().stream().mapToLong(Long::longValue).sum());
                Logger.logInfoMessage("Snapshot total is " + bigInteger.longValueExact());
                BigInteger bigInteger2 = BigInteger.valueOf(this.inputJSON.values().stream().mapToLong(object -> (Long)object).sum());
                if (!bigInteger2.equals(BigInteger.ZERO)) {
                    sortedMap.entrySet().forEach(entry -> {
                        long l = (Long)entry.getValue();
                        long l2 = BigInteger.valueOf(l).multiply(bigInteger2).divide(bigInteger).divide(BigInteger.valueOf(9L)).longValueExact();
                        entry.setValue(l2);
                    });
                }
                SortedMap<String, String> sortedMap2 = this.snapshotPublicKeys();
                Logger.logInfoMessage("Snapshot contains " + sortedMap2.entrySet().size() + " account public keys");
                Logger.logInfoMessage("Adding " + this.inputJSON.size() + " input accounts");
                this.inputJSON.forEach((object, object2) -> {
                    String string = (String)object;
                    long l3 = (Long)object2;
                    String string2 = Long.toUnsignedString(Account.getId(Convert.parseHexString(string)));
                    String string3 = sortedMap2.putIfAbsent(string2, string);
                    if (string3 != null && !string3.equals(string)) {
                        throw new RuntimeException("Public key collision, input " + string + ", snapshot contains " + string3);
                    }
                    sortedMap.merge(string2, l3, (l, l2) -> l + l2);
                });
                sortedMap.forEach((string, l) -> {
                    String string2 = (String)sortedMap2.get(string);
                    this.snapshot.put(string2 != null ? string2 : string, l);
                });
                this.latch.countDown();
            }
        }

        private SortedMap<String, Object> getSnapshot() {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptedException.getMessage(), interruptedException);
            }
            return this.snapshot;
        }

        private SortedMap<String, String> snapshotPublicKeys() {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            try (Connection connection = Db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT public_key FROM public_key WHERE public_key IS NOT NULL AND height <= ? ORDER by account_id");){
                preparedStatement.setInt(1, this.height);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        byte[] byArray = resultSet.getBytes("public_key");
                        long l = Account.getId(byArray);
                        treeMap.put(Long.toUnsignedString(l), Convert.toHexString(byArray));
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.getMessage(), sQLException);
            }
            return treeMap;
        }

        private SortedMap<String, Long> snapshotIgnisBalances() {
            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
            try (Connection connection = Db.db.getConnection(ChildChain.IGNIS.getDbSchema());
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT account_id, balance FROM balance WHERE balance > 0 AND LATEST=true AND account_id <> " + Constants.BURN_ACCOUNT_ID);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long l = resultSet.getLong("account_id");
                    long l2 = resultSet.getLong("balance");
                    String string = Long.toUnsignedString(l);
                    treeMap.put(string, l2);
                }
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.getMessage(), sQLException);
            }
            return treeMap;
        }
    }

    public static class JPLSnapshotAPI
    extends APIServlet.APIRequestHandler {
        private JPLSnapshotAPI(String string, APITag[] aPITagArray, String ... stringArray) {
            super(string, aPITagArray, stringArray);
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws NxtException {
            Object object;
            int n = ParameterParser.getHeight(httpServletRequest);
            if (n <= 0 || n > Nxt.getBlockchain().getHeight()) {
                return JSONResponses.INCORRECT_HEIGHT;
            }
            JSONObject jSONObject = new JSONObject();
            ParameterParser.FileData fileData = ParameterParser.getFileData(httpServletRequest, "newGenesisAccounts", false);
            if (fileData != null && !((String)(object = Convert.toString(fileData.getData()))).trim().isEmpty()) {
                try {
                    jSONObject = (JSONObject)JSONValue.parseWithException((String)object);
                }
                catch (ParseException parseException) {
                    return JSONResponses.INCORRECT_FILE;
                }
            }
            object = new JPLSnapshotListener(n, jSONObject);
            new Thread(() -> JPLSnapshotAPI.lambda$processRequest$0((JPLSnapshotListener)object, n)).start();
            StringBuilder stringBuilder = new StringBuilder(1024);
            JSON.encodeObject(((JPLSnapshotListener)object).getSnapshot(), stringBuilder);
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=FXT.json");
            httpServletResponse.setContentLength(stringBuilder.length());
            httpServletResponse.setCharacterEncoding("UTF-8");
            try (PrintWriter printWriter = httpServletResponse.getWriter();){
                printWriter.write(stringBuilder.toString());
            }
            catch (IOException iOException) {
                return JSONResponses.RESPONSE_WRITE_ERROR;
            }
            return null;
        }

        @Override
        protected JSONStreamAware processRequest(HttpServletRequest httpServletRequest) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean requirePost() {
            return true;
        }

        @Override
        protected boolean requirePassword() {
            return true;
        }

        @Override
        protected boolean requireFullClient() {
            return true;
        }

        @Override
        protected boolean allowRequiredBlockParameters() {
            return false;
        }

        @Override
        protected boolean isChainSpecific() {
            return false;
        }

        private static /* synthetic */ void lambda$processRequest$0(JPLSnapshotListener jPLSnapshotListener, int n) {
            Nxt.getBlockchainProcessor().addListener(jPLSnapshotListener, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
            Nxt.getBlockchainProcessor().scan(n - 1, false);
            Nxt.getBlockchainProcessor().removeListener(jPLSnapshotListener, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        }
    }
}

