/*
 * Decompiled with CFR 0.152.
 */
package nxt.addons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import nxt.account.Account;
import nxt.account.HoldingType;
import nxt.addons.JO;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.BlockchainProcessorImpl;
import nxt.blockchain.ChildChain;
import nxt.crypto.Crypto;
import nxt.http.callers.StartShufflerCall;
import nxt.shuffling.Shuffler;
import nxt.shuffling.ShufflingHome;
import nxt.shuffling.ShufflingParticipantHome;
import nxt.util.Convert;
import nxt.util.Filter;
import nxt.util.Logger;

public final class StandbyShuffler {
    private static final Map<Long, List<StandbyShuffler>> standbyShufflers = new HashMap<Long, List<StandbyShuffler>>();
    private static final List<ShufflingHome.Shuffling> blockShufflings = new ArrayList<ShufflingHome.Shuffling>();
    private final ChildChain chain;
    private final String secretPhrase;
    private final long accountId;
    private final HoldingType holdingType;
    private final long holdingId;
    private final long minAmount;
    private final long maxAmount;
    private final byte minParticipants;
    private final long feeRateNQTPerFXT;
    private final LinkedList<byte[]> recipientPublicKeys;
    private final Map<String, byte[]> shufflersPublicKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StandbyShuffler start(ChildChain childChain, String string, HoldingType holdingType, long l2, long l3, long l4, byte by, long l5, Collection<byte[]> collection) {
        if (holdingType == HoldingType.COIN) {
            l2 = childChain.getId();
        }
        long l6 = Account.getId(Crypto.getPublicKey(string));
        Map<Long, List<StandbyShuffler>> map = standbyShufflers;
        synchronized (map) {
            if (StandbyShuffler.get(childChain, l6, holdingType, l2) == null) {
                StandbyShuffler standbyShuffler = new StandbyShuffler(childChain, string, l6, holdingType, l2, l3, l4, by, l5, collection);
                standbyShufflers.computeIfAbsent(l2, l -> new ArrayList()).add(standbyShuffler);
                return standbyShuffler;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean stop(ChildChain childChain, long l, HoldingType holdingType, long l2) {
        if (holdingType == HoldingType.COIN && l2 != (long)childChain.getId()) {
            throw new IllegalArgumentException("Holding id should be the chain id when holdingType is COIN");
        }
        Map<Long, List<StandbyShuffler>> map = standbyShufflers;
        synchronized (map) {
            List<StandbyShuffler> list = standbyShufflers.get(l2);
            if (list == null) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).matches(childChain, l, holdingType, l2)) continue;
                list.remove(i);
                if (list.isEmpty()) {
                    standbyShufflers.remove(l2);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(StandbyShuffler standbyShuffler) {
        Map<Long, List<StandbyShuffler>> map = standbyShufflers;
        synchronized (map) {
            List<StandbyShuffler> list = standbyShufflers.get(standbyShuffler.holdingId);
            if (list != null) {
                list.remove(standbyShuffler);
                if (list.isEmpty()) {
                    standbyShufflers.remove(standbyShuffler.holdingId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int stopAll() {
        Map<Long, List<StandbyShuffler>> map = standbyShufflers;
        synchronized (map) {
            int n = standbyShufflers.values().stream().mapToInt(Collection::size).sum();
            standbyShufflers.clear();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StandbyShuffler get(ChildChain childChain, long l, HoldingType holdingType, long l2) {
        if (holdingType == HoldingType.COIN && l2 != (long)childChain.getId()) {
            throw new IllegalArgumentException("Holding id should be the chain id when holdingType is COIN");
        }
        Map<Long, List<StandbyShuffler>> map = standbyShufflers;
        synchronized (map) {
            List<StandbyShuffler> list = standbyShufflers.get(l2);
            if (list == null) {
                return null;
            }
            return list.stream().filter(standbyShuffler -> standbyShuffler.matches(childChain, l, holdingType, l2)).findAny().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<StandbyShuffler> get(Filter<StandbyShuffler> filter) {
        Map<Long, List<StandbyShuffler>> map = standbyShufflers;
        synchronized (map) {
            return standbyShufflers.values().stream().flatMap(Collection::stream).filter(filter::ok).collect(Collectors.toList());
        }
    }

    private StandbyShuffler(ChildChain childChain, String string, long l, HoldingType holdingType, long l2, long l3, long l4, byte by, long l5, Collection<byte[]> collection) {
        this.chain = childChain;
        this.secretPhrase = string;
        this.accountId = l;
        this.holdingType = holdingType;
        this.holdingId = l2;
        this.minAmount = l3;
        this.maxAmount = l4;
        this.minParticipants = by;
        this.feeRateNQTPerFXT = l5;
        this.recipientPublicKeys = new LinkedList<byte[]>(collection);
        this.shufflersPublicKeys = new HashMap<String, byte[]>();
    }

    public boolean matches(ChildChain childChain, long l, HoldingType holdingType, long l2) {
        return this.chain.getId() == childChain.getId() && this.accountId == l && this.holdingType == holdingType && this.holdingId == l2;
    }

    private boolean onShufflingCreated(ShufflingHome.Shuffling shuffling) {
        if (shuffling.getChildChain().getId() != this.chain.getId() || shuffling.getHoldingType() != this.holdingType || shuffling.getHoldingId() != this.holdingId) {
            return false;
        }
        Logger.logDebugMessage("Found potential shuffling for configured StandbyShuffler. Chain %s, Holding %s %d", this.chain.getName(), this.holdingType.name(), this.holdingId);
        if (this.recipientPublicKeys.isEmpty()) {
            Logger.logDebugMessage("No unused public key available.");
            return false;
        }
        if (this.minAmount > 0L && this.minAmount > shuffling.getAmount() || this.maxAmount > 0L && this.maxAmount < shuffling.getAmount() || this.minParticipants > 0 && this.minParticipants > shuffling.getParticipantCount()) {
            Logger.logDebugMessage("Shuffling doesn't match min/max amounts or participants filter");
            return false;
        }
        if (shuffling.getIssuerId() == this.accountId) {
            Logger.logDebugMessage("Skipping our own shuffling");
            return false;
        }
        if (shuffling.getAmount() > this.holdingType.getUnconfirmedBalance(Account.getAccount(this.accountId), this.holdingId)) {
            Logger.logDebugMessage("Insufficient balance to join shuffling, skipping");
            return false;
        }
        if (shuffling.getChildChain().getBalanceHome().getBalance(this.accountId).getUnconfirmedBalance() < shuffling.getChildChain().SHUFFLING_DEPOSIT_NQT + 22L * this.feeRateNQTPerFXT / 100L) {
            Logger.logDebugMessage("Insufficient coin balance to cover shuffling deposit and total fees, skipping");
            return false;
        }
        Logger.logInfoMessage("Shuffling created that matches a StandbyShuffler. Will try to join with unused key.");
        try {
            boolean bl = this.startShuffler(shuffling);
            return bl;
        }
        finally {
            this.stopIfEmpty();
        }
    }

    private void stopIfEmpty() {
        if (this.recipientPublicKeys.isEmpty() && this.shufflersPublicKeys.isEmpty()) {
            Logger.logWarningMessage("StandbyShuffler without any unused key left. Removing it.");
            StandbyShuffler.remove(this);
        }
    }

    private boolean startShuffler(ShufflingHome.Shuffling shuffling) {
        byte[] byArray = this.getNextRecipientPublicKey();
        if (byArray == null) {
            return false;
        }
        JO jO = ((StartShufflerCall)((StartShufflerCall)StartShufflerCall.create(this.chain.getId()).secretPhrase(this.secretPhrase)).shufflingFullHash(shuffling.getFullHash()).recipientPublicKey(byArray).feeRateNQTPerFXT(this.feeRateNQTPerFXT)).call();
        String string = Convert.toHexString(shuffling.getFullHash());
        if (Objects.equals(jO.getString("shufflingFullHash"), string)) {
            Logger.logInfoMessage("Started a shuffler for shuffling %s through StandbyShuffler add-on.", Long.toUnsignedString(shuffling.getId()));
            this.shufflersPublicKeys.put(string, byArray);
            return true;
        }
        if (jO.isExist("errorCode")) {
            String string2 = jO.getString("errorCode");
            Logger.logErrorMessage("Start shuffler from standby shuffler failed: %s %s", string2, jO.getString("errorDescription"));
            if (!"8".equals(string2)) {
                this.recipientPublicKeys.offer(byArray);
            }
        }
        return false;
    }

    private byte[] getNextRecipientPublicKey() {
        byte[] byArray;
        do {
            if ((byArray = this.recipientPublicKeys.poll()) == null || Account.getAccount(byArray) == null) continue;
            byArray = null;
        } while (byArray == null && !this.recipientPublicKeys.isEmpty());
        return byArray;
    }

    private void onParticipantProcessed(ShufflingParticipantHome.ShufflingParticipant shufflingParticipant) {
        if (shufflingParticipant.getAccountId() == this.accountId) {
            this.shufflersPublicKeys.remove(Convert.toHexString(shufflingParticipant.getShufflingFullHash()));
            this.stopIfEmpty();
        }
    }

    private void onShufflerStopped(Shuffler shuffler) {
        byte[] byArray = this.shufflersPublicKeys.remove(Convert.toHexString(shuffler.getShufflingFullHash()));
        if (byArray != null && Arrays.equals(byArray, shuffler.getRecipientPublicKey())) {
            this.recipientPublicKeys.offer(byArray);
        }
        this.stopIfEmpty();
    }

    public long getAccountId() {
        return this.accountId;
    }

    public ChildChain getChain() {
        return this.chain;
    }

    public HoldingType getHoldingType() {
        return this.holdingType;
    }

    public long getHoldingId() {
        return this.holdingId;
    }

    public long getMinAmount() {
        return this.minAmount;
    }

    public long getMaxAmount() {
        return this.maxAmount;
    }

    public byte getMinParticipants() {
        return this.minParticipants;
    }

    public long getFeeRateNQTPerFXT() {
        return this.feeRateNQTPerFXT;
    }

    public LinkedList<byte[]> getRecipientPublicKeys() {
        return this.recipientPublicKeys;
    }

    public int getReservedPublicKeysCount() {
        return this.shufflersPublicKeys.size();
    }

    static {
        ShufflingHome.addListener(blockShufflings::add, ShufflingHome.Event.SHUFFLING_CREATED);
        BlockchainProcessorImpl.getInstance().addListener(block -> {
            if (!blockShufflings.isEmpty()) {
                try {
                    Map<Long, List<StandbyShuffler>> map = standbyShufflers;
                    synchronized (map) {
                        block6: for (ShufflingHome.Shuffling shuffling : blockShufflings) {
                            List<StandbyShuffler> list = standbyShufflers.get(shuffling.getHoldingId());
                            if (list == null) continue;
                            ArrayList<StandbyShuffler> arrayList = new ArrayList<StandbyShuffler>(list);
                            Collections.shuffle(arrayList, Crypto.getSecureRandom());
                            int n = shuffling.getParticipantCount() - 1;
                            for (StandbyShuffler standbyShuffler : arrayList) {
                                if (n <= 0) continue block6;
                                if (!standbyShuffler.onShufflingCreated(shuffling)) continue;
                                --n;
                            }
                        }
                    }
                }
                finally {
                    blockShufflings.clear();
                }
            }
        }, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        ShufflingParticipantHome.addListener(shufflingParticipant -> {
            for (List<StandbyShuffler> list : standbyShufflers.values()) {
                for (StandbyShuffler standbyShuffler : list) {
                    standbyShuffler.onParticipantProcessed((ShufflingParticipantHome.ShufflingParticipant)shufflingParticipant);
                }
            }
        }, ShufflingParticipantHome.Event.PARTICIPANT_PROCESSED);
        Shuffler.addListener(shuffler -> {
            for (List<StandbyShuffler> list : standbyShufflers.values()) {
                for (StandbyShuffler standbyShuffler : list) {
                    standbyShuffler.onShufflerStopped((Shuffler)shuffler);
                }
            }
        }, Shuffler.Event.SHUFFLER_STOPPED);
    }
}

