/*
 * Decompiled with CFR 0.152.
 */
package nxt.ae;

import nxt.Nxt;
import nxt.account.HoldingType;
import nxt.ae.Asset;
import nxt.ae.AssetSnapshot;
import nxt.blockchain.Block;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.ChildChain;
import nxt.migration.HoldingMigrateBlockEventHandler;
import nxt.migration.MigrationMonitor;
import nxt.migration.SaveHoldingSnapshotListener;
import nxt.util.Listener;
import nxt.util.Logger;

public class AssetMigrateMonitor {
    public static void init() {
        MigrationMonitor.init();
        Nxt.getBlockchainProcessor().addListener(new HoldingMigrateBlockEventHandler(new AssetSnapshot()), BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        Asset.addListener(new AssetPropertyEventHandler(), Asset.Event.SET_PROPERTY);
    }

    public static Listener<Block> getSaveAssetSnapshotListener() {
        return new SaveHoldingSnapshotListener(new AssetSnapshot());
    }

    public static void enableMigration(long l, ChildChain childChain, int n, int n2) {
        MigrationMonitor.enableMigration(l, HoldingType.ASSET, childChain, n, n2);
    }

    private static class AssetPropertyEventHandler
    implements Listener<Asset.AssetProperty> {
        private AssetPropertyEventHandler() {
        }

        @Override
        public void notify(Asset.AssetProperty assetProperty) {
            int n;
            if (!"Migrate".equals(assetProperty.getProperty())) {
                return;
            }
            try {
                n = Integer.parseInt(assetProperty.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                Logger.logDebugMessage("Invalid height value", numberFormatException);
                return;
            }
            Asset asset = Asset.getAsset(assetProperty.getAssetId());
            if (asset.getAccountId() != assetProperty.getSetterId()) {
                return;
            }
            MigrationMonitor.scheduleMigration(HoldingType.ASSET, assetProperty.getAssetId(), n);
        }
    }
}

