/*
 * Decompiled with CFR 0.152.
 */
package nxt.aliases;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.aliases.AliasTransactionType;
import nxt.blockchain.Attachment;
import nxt.blockchain.TransactionType;
import nxt.util.Convert;
import nxt.util.bbh.LengthRwPrimitiveType;
import nxt.util.bbh.StringRw;
import org.json.simple.JSONObject;

public final class AliasAssignmentAttachment
extends Attachment.AbstractAttachment {
    public static final StringRw ALIAS_NAME_RW = new StringRw(LengthRwPrimitiveType.BYTE, 100);
    public static final StringRw ALIAS_URI_RW = new StringRw(LengthRwPrimitiveType.SHORT, 1000);
    private final String aliasName;
    private final String aliasURI;

    AliasAssignmentAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        this.aliasName = ALIAS_NAME_RW.readFromBuffer(byteBuffer).trim();
        this.aliasURI = ALIAS_URI_RW.readFromBuffer(byteBuffer).trim();
    }

    AliasAssignmentAttachment(JSONObject jSONObject) {
        super(jSONObject);
        this.aliasName = Convert.nullToEmpty((String)jSONObject.get((Object)"alias")).trim();
        this.aliasURI = Convert.nullToEmpty((String)jSONObject.get((Object)"uri")).trim();
    }

    public AliasAssignmentAttachment(String string, String string2) {
        this.aliasName = string.trim();
        this.aliasURI = string2.trim();
    }

    @Override
    protected int getMySize() {
        return ALIAS_NAME_RW.getSize(this.aliasName) + ALIAS_URI_RW.getSize(this.aliasURI);
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        ALIAS_NAME_RW.writeToBuffer(this.aliasName, byteBuffer);
        ALIAS_URI_RW.writeToBuffer(this.aliasURI, byteBuffer);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"alias", (Object)this.aliasName);
        jSONObject.put((Object)"uri", (Object)this.aliasURI);
    }

    @Override
    public TransactionType getTransactionType() {
        return AliasTransactionType.ALIAS_ASSIGNMENT;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getAliasURI() {
        return this.aliasURI;
    }
}

