/*
 * Decompiled with CFR 0.152.
 */
package nxt.aliases;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import nxt.Nxt;
import nxt.aliases.AliasAssignmentAttachment;
import nxt.aliases.AliasSellAttachment;
import nxt.blockchain.ChildChain;
import nxt.blockchain.Transaction;
import nxt.db.DbClause;
import nxt.db.DbIterator;
import nxt.db.DbKey;
import nxt.db.DbUtils;
import nxt.db.VersionedEntityDbTable;
import nxt.util.Listener;
import nxt.util.Listeners;

public final class AliasHome {
    private final DbKey.LongKeyFactory<Alias> aliasDbKeyFactory;
    private final VersionedEntityDbTable<Alias> aliasTable;
    private final DbKey.LongKeyFactory<Offer> offerDbKeyFactory;
    private final VersionedEntityDbTable<Offer> offerTable;
    private final ChildChain childChain;
    private static final Listeners<Alias, Event> aliasListeners = new Listeners();

    public static AliasHome forChain(ChildChain childChain) {
        if (childChain.getAliasHome() != null) {
            throw new IllegalStateException("already set");
        }
        return new AliasHome(childChain);
    }

    private AliasHome(ChildChain childChain) {
        this.childChain = childChain;
        this.aliasDbKeyFactory = new DbKey.LongKeyFactory<Alias>("id"){

            @Override
            public DbKey newKey(Alias alias) {
                return alias.dbKey;
            }
        };
        this.aliasTable = new VersionedEntityDbTable<Alias>(childChain.getSchemaTable("alias"), this.aliasDbKeyFactory){

            @Override
            protected Alias load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Alias(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Alias alias) throws SQLException {
                alias.save(connection);
            }

            @Override
            protected String defaultSort() {
                return " ORDER BY alias_name_lower ";
            }
        };
        this.offerDbKeyFactory = new DbKey.LongKeyFactory<Offer>("id"){

            @Override
            public DbKey newKey(Offer offer) {
                return offer.dbKey;
            }
        };
        this.offerTable = new VersionedEntityDbTable<Offer>(childChain.getSchemaTable("alias_offer"), this.offerDbKeyFactory){

            @Override
            protected Offer load(Connection connection, ResultSet resultSet, DbKey dbKey) throws SQLException {
                return new Offer(resultSet, dbKey);
            }

            @Override
            protected void save(Connection connection, Offer offer) throws SQLException {
                offer.save(connection);
            }
        };
    }

    public int getCount() {
        return this.aliasTable.getCount();
    }

    public int getAccountAliasCount(long l) {
        return this.aliasTable.getCount(new DbClause.LongClause("account_id", l));
    }

    public DbIterator<Alias> getAliasesByOwner(long l, int n, int n2) {
        return this.aliasTable.getManyBy(new DbClause.LongClause("account_id", l), n, n2);
    }

    public Alias getAlias(String string) {
        return (Alias)this.aliasTable.getBy(new DbClause.StringClause("alias_name_lower", string.toLowerCase(Locale.ROOT)));
    }

    public DbIterator<Alias> getAliasesLike(String string, int n, int n2) {
        return this.aliasTable.getManyBy(new DbClause.LikeClause("alias_name_lower", string.toLowerCase(Locale.ROOT)), n, n2);
    }

    public Alias getAlias(long l) {
        return (Alias)this.aliasTable.get(this.aliasDbKeyFactory.newKey(l));
    }

    public Offer getOffer(Alias alias) {
        return (Offer)this.offerTable.getBy(new DbClause.LongClause("id", alias.getId()).and(new DbClause.LongClause("price", DbClause.Op.NE, Long.MAX_VALUE)));
    }

    void deleteAlias(String string) {
        Alias alias = this.getAlias(string);
        Offer offer = this.getOffer(alias);
        if (offer != null) {
            offer.priceNQT = Long.MAX_VALUE;
            this.offerTable.delete(offer);
        }
        this.aliasTable.delete(alias);
        aliasListeners.notify(alias, Event.DELETE_ALIAS);
    }

    void addOrUpdateAlias(Transaction transaction, AliasAssignmentAttachment aliasAssignmentAttachment) {
        Alias alias = this.getAlias(aliasAssignmentAttachment.getAliasName());
        if (alias == null) {
            alias = new Alias(transaction, aliasAssignmentAttachment);
        } else {
            alias.accountId = transaction.getSenderId();
            alias.aliasURI = aliasAssignmentAttachment.getAliasURI();
            alias.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
        }
        this.aliasTable.insert(alias);
        aliasListeners.notify(alias, Event.SET_ALIAS);
    }

    public void importAlias(long l, long l2, String string, String string2) {
        Alias alias = new Alias(l, l2, string, string2);
        this.aliasTable.insert(alias);
    }

    void sellAlias(Transaction transaction, AliasSellAttachment aliasSellAttachment) {
        String string = aliasSellAttachment.getAliasName();
        long l = aliasSellAttachment.getPriceNQT();
        long l2 = transaction.getRecipientId();
        if (l > 0L) {
            Alias alias = this.getAlias(string);
            Offer offer = this.getOffer(alias);
            if (offer == null) {
                this.offerTable.insert(new Offer(alias.id, l, l2));
            } else {
                offer.priceNQT = l;
                offer.buyerId = l2;
                this.offerTable.insert(offer);
            }
        } else {
            this.changeOwner(l2, string);
        }
    }

    void changeOwner(long l, String string) {
        Alias alias = this.getAlias(string);
        alias.accountId = l;
        alias.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
        this.aliasTable.insert(alias);
        Offer offer = this.getOffer(alias);
        if (offer != null) {
            offer.priceNQT = Long.MAX_VALUE;
            this.offerTable.delete(offer);
        }
    }

    public static boolean addListener(Listener<Alias> listener, Event event) {
        return aliasListeners.addListener(listener, event);
    }

    public static boolean removeListener(Listener<Alias> listener, Event event) {
        return aliasListeners.removeListener(listener, event);
    }

    public static enum Event {
        SET_ALIAS,
        DELETE_ALIAS;

    }

    public final class Alias {
        private long accountId;
        private final long id;
        private final DbKey dbKey;
        private final String aliasName;
        private String aliasURI;
        private int timestamp;

        private Alias(Transaction transaction, AliasAssignmentAttachment aliasAssignmentAttachment) {
            this.id = transaction.getId();
            this.dbKey = AliasHome.this.aliasDbKeyFactory.newKey(this.id);
            this.accountId = transaction.getSenderId();
            this.aliasName = aliasAssignmentAttachment.getAliasName();
            this.aliasURI = aliasAssignmentAttachment.getAliasURI();
            this.timestamp = Nxt.getBlockchain().getLastBlockTimestamp();
        }

        private Alias(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.id = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.accountId = resultSet.getLong("account_id");
            this.aliasName = resultSet.getString("alias_name");
            this.aliasURI = resultSet.getString("alias_uri");
            this.timestamp = resultSet.getInt("timestamp");
        }

        private Alias(long l, long l2, String string, String string2) {
            this.id = l;
            this.accountId = l2;
            this.aliasName = string;
            this.aliasURI = string2;
            this.dbKey = AliasHome.this.aliasDbKeyFactory.newKey(this.id);
            this.timestamp = 0;
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO alias (id, account_id, alias_name, alias_name_lower, alias_uri, timestamp, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.id);
                preparedStatement.setLong(++n, this.accountId);
                preparedStatement.setString(++n, this.aliasName);
                preparedStatement.setString(++n, this.aliasName.toLowerCase(Locale.ROOT));
                preparedStatement.setString(++n, this.aliasURI);
                preparedStatement.setInt(++n, this.timestamp);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.id;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public String getAliasURI() {
            return this.aliasURI;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public long getAccountId() {
            return this.accountId;
        }

        public Offer getOffer() {
            return AliasHome.this.getOffer(this);
        }

        public ChildChain getChildChain() {
            return AliasHome.this.childChain;
        }
    }

    public final class Offer {
        private long priceNQT;
        private long buyerId;
        private final long aliasId;
        private final DbKey dbKey;

        private Offer(long l, long l2, long l3) {
            this.priceNQT = l2;
            this.buyerId = l3;
            this.aliasId = l;
            this.dbKey = AliasHome.this.offerDbKeyFactory.newKey(this.aliasId);
        }

        private Offer(ResultSet resultSet, DbKey dbKey) throws SQLException {
            this.aliasId = resultSet.getLong("id");
            this.dbKey = dbKey;
            this.priceNQT = resultSet.getLong("price");
            this.buyerId = resultSet.getLong("buyer_id");
        }

        private void save(Connection connection) throws SQLException {
            try (PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO alias_offer (id, price, buyer_id, height, latest) KEY (id, height) VALUES (?, ?, ?, ?, TRUE)");){
                int n = 0;
                preparedStatement.setLong(++n, this.aliasId);
                preparedStatement.setLong(++n, this.priceNQT);
                DbUtils.setLongZeroToNull(preparedStatement, ++n, this.buyerId);
                preparedStatement.setInt(++n, Nxt.getBlockchain().getHeight());
                preparedStatement.executeUpdate();
            }
        }

        public long getId() {
            return this.aliasId;
        }

        public long getPriceNQT() {
            return this.priceNQT;
        }

        public long getBuyerId() {
            return this.buyerId;
        }

        public ChildChain getChildChain() {
            return AliasHome.this.childChain;
        }
    }
}

