/*
 * Decompiled with CFR 0.152.
 */
package nxt.aliases;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Map;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.aliases.AliasAssignmentAttachment;
import nxt.aliases.AliasBuyAttachment;
import nxt.aliases.AliasDeleteAttachment;
import nxt.aliases.AliasHome;
import nxt.aliases.AliasSellAttachment;
import nxt.blockchain.Appendix;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.ChildTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import org.json.simple.JSONObject;

public abstract class AliasTransactionType
extends ChildTransactionType {
    private static final byte SUBTYPE_ALIASES_ALIAS_ASSIGNMENT = 0;
    private static final byte SUBTYPE_ALIASES_ALIAS_SELL = 1;
    private static final byte SUBTYPE_ALIASES_ALIAS_BUY = 2;
    private static final byte SUBTYPE_ALIASES_ALIAS_DELETE = 3;
    public static final TransactionType ALIAS_ASSIGNMENT = new AliasTransactionType(){
        private final Fee ALIAS_FEE = new Fee.SizeBasedFee(100000000L, 100000000L, 32){

            @Override
            public int getSize(TransactionImpl transactionImpl, Appendix appendix) {
                AliasAssignmentAttachment aliasAssignmentAttachment = (AliasAssignmentAttachment)transactionImpl.getAttachment();
                return aliasAssignmentAttachment.getAliasName().length() + aliasAssignmentAttachment.getAliasURI().length();
            }
        };

        @Override
        public final byte getSubtype() {
            return 0;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ALIAS_ASSIGNMENT;
        }

        @Override
        public String getName() {
            return "AliasAssignment";
        }

        @Override
        public Fee getBaselineFee(Transaction transaction) {
            return this.ALIAS_FEE;
        }

        @Override
        public AliasAssignmentAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new AliasAssignmentAttachment(byteBuffer);
        }

        @Override
        public AliasAssignmentAttachment parseAttachment(JSONObject jSONObject) {
            return new AliasAssignmentAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AliasAssignmentAttachment aliasAssignmentAttachment = (AliasAssignmentAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getAliasHome().addOrUpdateAlias(childTransactionImpl, aliasAssignmentAttachment);
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            AliasAssignmentAttachment aliasAssignmentAttachment = (AliasAssignmentAttachment)transaction.getAttachment();
            return 1.isDuplicate(ALIAS_ASSIGNMENT, aliasAssignmentAttachment.getAliasName().toLowerCase(Locale.ROOT), map, true);
        }

        @Override
        public boolean isBlockDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            return ((ChildChain)transaction.getChain()).getAliasHome().getAlias(((AliasAssignmentAttachment)transaction.getAttachment()).getAliasName()) == null && 1.isDuplicate(ALIAS_ASSIGNMENT, "", map, true);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            AliasAssignmentAttachment aliasAssignmentAttachment = (AliasAssignmentAttachment)childTransactionImpl.getAttachment();
            if (aliasAssignmentAttachment.getAliasName().length() == 0 || !AliasAssignmentAttachment.ALIAS_NAME_RW.validate(aliasAssignmentAttachment.getAliasName()) || !AliasAssignmentAttachment.ALIAS_URI_RW.validate(aliasAssignmentAttachment.getAliasURI())) {
                throw new NxtException.NotValidException("Invalid alias assignment: " + aliasAssignmentAttachment.getJSONObject());
            }
            String string = aliasAssignmentAttachment.getAliasName().toLowerCase(Locale.ROOT);
            for (int i = 0; i < string.length(); ++i) {
                if ("0123456789abcdefghijklmnopqrstuvwxyz".indexOf(string.charAt(i)) >= 0) continue;
                throw new NxtException.NotValidException("Invalid alias name: " + string);
            }
            AliasHome.Alias alias = childTransactionImpl.getChain().getAliasHome().getAlias(string);
            if (alias != null && alias.getAccountId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotCurrentlyValidException("Alias already owned by another account: " + string);
            }
        }

        @Override
        protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
            if (childTransactionImpl.getChain().getAliasHome().getAlias(childTransactionImpl.getId()) != null) {
                throw new NxtException.NotCurrentlyValidException("Duplicate alias id " + childTransactionImpl.getStringId());
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType ALIAS_DELETE = new AliasTransactionType(){

        @Override
        public final byte getSubtype() {
            return 3;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ALIAS_DELETE;
        }

        @Override
        public String getName() {
            return "AliasDelete";
        }

        @Override
        public AliasDeleteAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new AliasDeleteAttachment(byteBuffer);
        }

        @Override
        public AliasDeleteAttachment parseAttachment(JSONObject jSONObject) {
            return new AliasDeleteAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AliasDeleteAttachment aliasDeleteAttachment = (AliasDeleteAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getAliasHome().deleteAlias(aliasDeleteAttachment.getAliasName());
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            AliasDeleteAttachment aliasDeleteAttachment = (AliasDeleteAttachment)transaction.getAttachment();
            return 2.isDuplicate(ALIAS_ASSIGNMENT, aliasDeleteAttachment.getAliasName().toLowerCase(Locale.ROOT), map, true);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            AliasDeleteAttachment aliasDeleteAttachment = (AliasDeleteAttachment)childTransactionImpl.getAttachment();
            String string = aliasDeleteAttachment.getAliasName();
            if (string == null || string.length() == 0) {
                throw new NxtException.NotValidException("Missing alias name");
            }
            AliasHome.Alias alias = childTransactionImpl.getChain().getAliasHome().getAlias(string);
            if (alias == null) {
                throw new NxtException.NotCurrentlyValidException("No such alias: " + string);
            }
            if (alias.getAccountId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotCurrentlyValidException("Alias doesn't belong to sender: " + string);
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType ALIAS_BUY = new AliasTransactionType(){

        @Override
        public final byte getSubtype() {
            return 2;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ALIAS_BUY;
        }

        @Override
        public String getName() {
            return "AliasBuy";
        }

        @Override
        public AliasBuyAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new AliasBuyAttachment(byteBuffer);
        }

        @Override
        public AliasBuyAttachment parseAttachment(JSONObject jSONObject) {
            return new AliasBuyAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AliasBuyAttachment aliasBuyAttachment = (AliasBuyAttachment)childTransactionImpl.getAttachment();
            String string = aliasBuyAttachment.getAliasName();
            childTransactionImpl.getChain().getAliasHome().changeOwner(childTransactionImpl.getSenderId(), string);
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            AliasBuyAttachment aliasBuyAttachment = (AliasBuyAttachment)transaction.getAttachment();
            return 3.isDuplicate(ALIAS_ASSIGNMENT, aliasBuyAttachment.getAliasName().toLowerCase(Locale.ROOT), map, true);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            AliasBuyAttachment aliasBuyAttachment;
            String string;
            AliasHome aliasHome = childTransactionImpl.getChain().getAliasHome();
            AliasHome.Alias alias = aliasHome.getAlias(string = (aliasBuyAttachment = (AliasBuyAttachment)childTransactionImpl.getAttachment()).getAliasName());
            if (alias == null) {
                throw new NxtException.NotCurrentlyValidException("No such alias: " + string);
            }
            if (alias.getAccountId() != childTransactionImpl.getRecipientId()) {
                throw new NxtException.NotCurrentlyValidException("Alias is owned by account other than recipient: " + Long.toUnsignedString(alias.getAccountId()));
            }
            AliasHome.Offer offer = aliasHome.getOffer(alias);
            if (offer == null) {
                throw new NxtException.NotCurrentlyValidException("Alias is not for sale: " + string);
            }
            if (childTransactionImpl.getAmount() < offer.getPriceNQT()) {
                String string2 = "Price is too low for: " + string + " (" + childTransactionImpl.getAmount() + " < " + offer.getPriceNQT() + ")";
                throw new NxtException.NotCurrentlyValidException(string2);
            }
            if (offer.getBuyerId() != 0L && offer.getBuyerId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotCurrentlyValidException("Wrong buyer for " + string + ": " + Long.toUnsignedString(childTransactionImpl.getSenderId()) + " expected: " + Long.toUnsignedString(offer.getBuyerId()));
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };
    public static final TransactionType ALIAS_SELL = new AliasTransactionType(){

        @Override
        public final byte getSubtype() {
            return 1;
        }

        @Override
        public AccountLedger.LedgerEvent getLedgerEvent() {
            return AccountLedger.LedgerEvent.ALIAS_SELL;
        }

        @Override
        public String getName() {
            return "AliasSell";
        }

        @Override
        public AliasSellAttachment parseAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
            return new AliasSellAttachment(byteBuffer);
        }

        @Override
        public AliasSellAttachment parseAttachment(JSONObject jSONObject) {
            return new AliasSellAttachment(jSONObject);
        }

        @Override
        public void applyAttachment(ChildTransactionImpl childTransactionImpl, Account account, Account account2) {
            AliasSellAttachment aliasSellAttachment = (AliasSellAttachment)childTransactionImpl.getAttachment();
            childTransactionImpl.getChain().getAliasHome().sellAlias(childTransactionImpl, aliasSellAttachment);
        }

        @Override
        public boolean isDuplicate(Transaction transaction, Map<TransactionType, Map<String, Integer>> map) {
            AliasSellAttachment aliasSellAttachment = (AliasSellAttachment)transaction.getAttachment();
            return 4.isDuplicate(ALIAS_ASSIGNMENT, aliasSellAttachment.getAliasName().toLowerCase(Locale.ROOT), map, true);
        }

        @Override
        public void validateAttachment(ChildTransactionImpl childTransactionImpl) throws NxtException.ValidationException {
            if (childTransactionImpl.getAmount() != 0L) {
                throw new NxtException.NotValidException("Invalid sell alias transaction: " + childTransactionImpl.getJSONObject());
            }
            AliasSellAttachment aliasSellAttachment = (AliasSellAttachment)childTransactionImpl.getAttachment();
            String string = aliasSellAttachment.getAliasName();
            if (string == null || string.length() == 0) {
                throw new NxtException.NotValidException("Missing alias name");
            }
            long l = aliasSellAttachment.getPriceNQT();
            if (l < 0L || l > 100000000000000000L) {
                throw new NxtException.NotValidException("Invalid alias sell price: " + l);
            }
            if (l == 0L && childTransactionImpl.getRecipientId() == 0L) {
                throw new NxtException.NotValidException("Missing alias transfer recipient");
            }
            AliasHome.Alias alias = childTransactionImpl.getChain().getAliasHome().getAlias(string);
            if (alias == null) {
                throw new NxtException.NotCurrentlyValidException("No such alias: " + string);
            }
            if (alias.getAccountId() != childTransactionImpl.getSenderId()) {
                throw new NxtException.NotCurrentlyValidException("Alias doesn't belong to sender: " + string);
            }
        }

        @Override
        public boolean canHaveRecipient() {
            return true;
        }

        @Override
        public boolean mustHaveRecipient() {
            return false;
        }

        @Override
        public boolean isPhasingSafe() {
            return false;
        }
    };

    public static TransactionType findTransactionType(byte by) {
        switch (by) {
            case 0: {
                return ALIAS_ASSIGNMENT;
            }
            case 2: {
                return ALIAS_BUY;
            }
            case 1: {
                return ALIAS_SELL;
            }
            case 3: {
                return ALIAS_DELETE;
            }
        }
        return null;
    }

    private AliasTransactionType() {
    }

    @Override
    public final byte getType() {
        return 8;
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
        return true;
    }

    @Override
    public final void undoAttachmentUnconfirmed(ChildTransactionImpl childTransactionImpl, Account account) {
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }
}

