/*
 * Decompiled with CFR 0.152.
 */
package nxt.authentication;

import java.util.EnumSet;
import nxt.Constants;
import nxt.authentication.Role;
import nxt.authentication.RoleMapper;
import nxt.util.security.BlockchainPermission;

public class RoleMapperFactory {
    private static final RoleMapper roleMapper;

    private RoleMapperFactory() {
    }

    public static RoleMapper getRoleMapper() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("authentication"));
        }
        return roleMapper;
    }

    static {
        if (Constants.isPermissioned) {
            try {
                Class<?> clazz = Class.forName("com.jelurida.blockchain.authentication.BlockchainRoleMapper");
                roleMapper = (RoleMapper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new ExceptionInInitializerError(reflectiveOperationException);
            }
        } else {
            roleMapper = new NullRoleMapper();
        }
    }

    public static class NullRoleMapper
    implements RoleMapper {
        @Override
        public EnumSet<Role> getUserRoles(String string) {
            return EnumSet.noneOf(Role.class);
        }

        @Override
        public boolean isValidRoleSetter(long l) {
            return false;
        }

        @Override
        public boolean isUserInRole(long l, Role role) {
            return false;
        }

        @Override
        public EnumSet<Role> parseRoles(String string) {
            return EnumSet.noneOf(Role.class);
        }
    }
}

