/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import nxt.Constants;
import nxt.Nxt;
import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.blockchain.Appendix;
import nxt.blockchain.Block;
import nxt.blockchain.BlockDb;
import nxt.blockchain.BlockImpl;
import nxt.blockchain.BlockchainImpl;
import nxt.blockchain.BlockchainProcessor;
import nxt.blockchain.Chain;
import nxt.blockchain.ChainTransactionId;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransaction;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.Generator;
import nxt.blockchain.Genesis;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionHome;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionProcessor;
import nxt.blockchain.TransactionProcessorImpl;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedFxtTransaction;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.crypto.Crypto;
import nxt.db.DbIterator;
import nxt.db.DerivedDbTable;
import nxt.db.FilteringIterator;
import nxt.db.FullTextTrigger;
import nxt.dbschema.Db;
import nxt.peer.NetworkHandler;
import nxt.peer.NetworkMessage;
import nxt.peer.Peer;
import nxt.peer.Peers;
import nxt.util.JSON;
import nxt.util.Listener;
import nxt.util.Listeners;
import nxt.util.Logger;
import nxt.util.ThreadPool;
import nxt.util.security.BlockchainPermission;
import nxt.voting.PhasingAppendix;
import nxt.voting.PhasingPollHome;
import nxt.voting.VotingTransactionType;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class BlockchainProcessorImpl
implements BlockchainProcessor {
    private static final NavigableMap<Integer, byte[]> checksums;
    private static final BlockchainProcessorImpl instance;
    private static final BlockchainPermission blockchainPermission;
    private final BlockchainImpl blockchain = BlockchainImpl.getInstance();
    private final ExecutorService networkService = Executors.newCachedThreadPool();
    private final List<DerivedDbTable> derivedTables = new CopyOnWriteArrayList<DerivedDbTable>();
    private final boolean trimDerivedTables = Nxt.getBooleanProperty("nxt.trimDerivedTables");
    private final boolean simulateEndlessDownload = Nxt.getBooleanProperty("nxt.simulateEndlessDownload");
    private int initialScanHeight;
    private volatile int lastTrimHeight;
    private volatile int lastRestoreTime = 0;
    private final Set<ChainTransactionId> prunableTransactions = new HashSet<ChainTransactionId>();
    private final Listeners<Block, BlockchainProcessor.Event> blockListeners = new Listeners();
    private volatile Peer lastBlockchainFeeder;
    private volatile int lastBlockchainFeederHeight;
    private volatile boolean getMoreBlocks = true;
    private volatile boolean isDownloadSuspended = false;
    private volatile boolean isTrimming;
    private volatile boolean isScanning;
    private volatile boolean isDownloading;
    private volatile boolean isProcessingBlock;
    private volatile boolean isRestoring;
    private volatile boolean alreadyInitialized = false;
    private volatile long genesisBlockId;
    private final Runnable getMoreBlocksThread = new Runnable(){
        private final NetworkMessage getCumulativeDifficultyRequest = new NetworkMessage.GetCumulativeDifficultyMessage();
        private boolean peerHasMore;
        private List<Peer> connectedPublicPeers;
        private List<Long> chainBlockIds;
        private long totalTime = 1L;
        private int totalBlocks;

        @Override
        public void run() {
            try {
                int n;
                if (BlockchainProcessorImpl.this.isDownloadSuspended) {
                    return;
                }
                do {
                    if (!BlockchainProcessorImpl.this.getMoreBlocks) {
                        return;
                    }
                    n = BlockchainProcessorImpl.this.blockchain.getHeight();
                    this.downloadPeer();
                } while (BlockchainProcessorImpl.this.blockchain.getHeight() != n);
                if (BlockchainProcessorImpl.this.isDownloading && !BlockchainProcessorImpl.this.simulateEndlessDownload) {
                    Logger.logMessage("Finished blockchain download");
                    BlockchainProcessorImpl.this.isDownloading = false;
                }
                n = Nxt.getEpochTime();
                if (!BlockchainProcessorImpl.this.isRestoring && !BlockchainProcessorImpl.this.prunableTransactions.isEmpty() && n - BlockchainProcessorImpl.this.lastRestoreTime > 3600) {
                    BlockchainProcessorImpl.this.isRestoring = true;
                    BlockchainProcessorImpl.this.lastRestoreTime = n;
                    BlockchainProcessorImpl.this.networkService.submit(new RestorePrunableDataTask());
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.logDebugMessage("Blockchain download thread interrupted");
            }
            catch (Throwable throwable) {
                Logger.logErrorMessage("CRITICAL ERROR. PLEASE REPORT TO THE DEVELOPERS.\n" + throwable.toString(), throwable);
                System.exit(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadPeer() throws InterruptedException {
            try {
                long l = System.currentTimeMillis();
                int n = BlockchainProcessorImpl.this.blockchain.getHeight() > Constants.LAST_CHECKSUM_BLOCK - 720 ? Constants.DEFAULT_NUMBER_OF_FORK_CONFIRMATIONS : Math.min(5, Constants.DEFAULT_NUMBER_OF_FORK_CONFIRMATIONS);
                this.connectedPublicPeers = Peers.getConnectedPeers();
                if (this.connectedPublicPeers.size() <= n) {
                    return;
                }
                this.peerHasMore = true;
                Peer peer = Peers.getAnyPeer(this.connectedPublicPeers);
                if (peer == null) {
                    return;
                }
                NetworkMessage.CumulativeDifficultyMessage cumulativeDifficultyMessage = (NetworkMessage.CumulativeDifficultyMessage)peer.sendRequest(this.getCumulativeDifficultyRequest);
                if (cumulativeDifficultyMessage == null) {
                    return;
                }
                BigInteger bigInteger = BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty();
                BigInteger bigInteger2 = cumulativeDifficultyMessage.getCumulativeDifficulty();
                if (bigInteger2.compareTo(bigInteger) < 0) {
                    return;
                }
                BlockchainProcessorImpl.this.lastBlockchainFeeder = peer;
                BlockchainProcessorImpl.this.lastBlockchainFeederHeight = cumulativeDifficultyMessage.getBlockHeight();
                if (bigInteger2.equals(bigInteger)) {
                    return;
                }
                long l2 = BlockchainProcessorImpl.this.genesisBlockId;
                if (BlockchainProcessorImpl.this.blockchain.getHeight() > 0) {
                    l2 = this.getCommonMilestoneBlockId(peer);
                }
                if (l2 == 0L || !this.peerHasMore) {
                    return;
                }
                BlockchainProcessorImpl.this.blockchain.updateLock();
                try {
                    this.chainBlockIds = this.getBlockIdsAfterCommon(peer, l2, false);
                    if (this.chainBlockIds.size() < 2 || !this.peerHasMore) {
                        return;
                    }
                    long l3 = this.chainBlockIds.get(0);
                    BlockImpl blockImpl = BlockchainProcessorImpl.this.blockchain.getBlock(l3);
                    if (blockImpl == null || BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight() >= 720) {
                        if (blockImpl != null) {
                            Logger.logDebugMessage(peer + " advertised chain with better difficulty, but the last common block is at height " + blockImpl.getHeight());
                        }
                        return;
                    }
                    if (BlockchainProcessorImpl.this.simulateEndlessDownload) {
                        BlockchainProcessorImpl.this.isDownloading = true;
                        return;
                    }
                    if (!BlockchainProcessorImpl.this.isDownloading && BlockchainProcessorImpl.this.lastBlockchainFeederHeight - blockImpl.getHeight() > 10) {
                        Logger.logMessage("Blockchain download in progress");
                        BlockchainProcessorImpl.this.isDownloading = true;
                    }
                    if (bigInteger2.compareTo(BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty()) <= 0) {
                        return;
                    }
                    long l4 = BlockchainProcessorImpl.this.blockchain.getLastBlock().getId();
                    this.downloadBlockchain(peer, blockImpl, blockImpl.getHeight());
                    if (BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight() <= 10) {
                        return;
                    }
                    int n2 = 0;
                    for (Peer peer2 : this.connectedPublicPeers) {
                        NetworkMessage.CumulativeDifficultyMessage cumulativeDifficultyMessage2;
                        if (n2 >= n) break;
                        if (peer.getHost().equals(peer2.getHost())) continue;
                        this.chainBlockIds = this.getBlockIdsAfterCommon(peer2, l3, true);
                        if (this.chainBlockIds.isEmpty()) continue;
                        long l5 = this.chainBlockIds.get(0);
                        if (l5 == BlockchainProcessorImpl.this.blockchain.getLastBlock().getId()) {
                            ++n2;
                            continue;
                        }
                        BlockImpl blockImpl2 = BlockchainProcessorImpl.this.blockchain.getBlock(l5);
                        if (BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl2.getHeight() >= 720 || (cumulativeDifficultyMessage2 = (NetworkMessage.CumulativeDifficultyMessage)peer.sendRequest(this.getCumulativeDifficultyRequest)) == null || cumulativeDifficultyMessage2.getCumulativeDifficulty().compareTo(BlockchainProcessorImpl.this.blockchain.getLastBlock().getCumulativeDifficulty()) <= 0) continue;
                        Logger.logDebugMessage("Found a peer with better difficulty");
                        this.downloadBlockchain(peer2, blockImpl2, blockImpl.getHeight());
                    }
                    Logger.logDebugMessage("Got " + n2 + " confirmations");
                    if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() != l4) {
                        long l6 = System.currentTimeMillis() - l;
                        this.totalTime += l6;
                        int n3 = BlockchainProcessorImpl.this.blockchain.getHeight() - blockImpl.getHeight();
                        this.totalBlocks += n3;
                        Logger.logMessage("Downloaded " + n3 + " blocks in " + l6 / 1000L + " s, " + (long)(this.totalBlocks * 1000) / this.totalTime + " per s, " + this.totalTime * (long)(BlockchainProcessorImpl.this.lastBlockchainFeederHeight - BlockchainProcessorImpl.this.blockchain.getHeight()) / ((long)this.totalBlocks * 1000L * 60L) + " min left");
                    } else {
                        Logger.logDebugMessage("Did not accept peer's blocks, back to our own fork");
                    }
                }
                finally {
                    BlockchainProcessorImpl.this.blockchain.updateUnlock();
                }
            }
            catch (NxtException.StopException stopException) {
                Logger.logMessage("Blockchain download stopped: " + stopException.getMessage());
                throw new InterruptedException("Blockchain download stopped");
            }
            catch (Exception exception) {
                Logger.logMessage("Error in blockchain download thread", exception);
            }
        }

        private long getCommonMilestoneBlockId(Peer peer) {
            long l = 0L;
            long l2;
            NetworkMessage.MilestoneBlockIdsMessage milestoneBlockIdsMessage;
            block0: while ((milestoneBlockIdsMessage = (NetworkMessage.MilestoneBlockIdsMessage)peer.sendRequest(new NetworkMessage.GetMilestoneBlockIdsMessage(l2 = l == 0L ? BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() : 0L, l))) != null) {
                List<Long> list = milestoneBlockIdsMessage.getBlockIds();
                if (list.isEmpty()) {
                    return BlockchainProcessorImpl.this.genesisBlockId;
                }
                if (list.size() > 20) {
                    Logger.logDebugMessage("Obsolete or rogue peer " + peer.getHost() + " sends too many milestoneBlockIds, blacklisting");
                    peer.blacklist("Too many milestoneBlockIds");
                    return 0L;
                }
                if (milestoneBlockIdsMessage.isLastBlock()) {
                    this.peerHasMore = false;
                }
                Iterator<Long> iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    long l3 = iterator.next();
                    if (BlockDb.hasBlock(l3)) {
                        if (l == 0L && list.size() > 1) {
                            this.peerHasMore = false;
                        }
                        return l3;
                    }
                    l = l3;
                }
                break;
            }
            return 0L;
        }

        private List<Long> getBlockIdsAfterCommon(Peer peer, long l, boolean bl) {
            boolean bl2;
            int n;
            long l2 = l;
            ArrayList<Long> arrayList = new ArrayList<Long>(720);
            boolean bl3 = false;
            int n2 = n = bl ? 720 : 1440;
            block0: do {
                NetworkMessage.BlockIdsMessage blockIdsMessage;
                if ((blockIdsMessage = (NetworkMessage.BlockIdsMessage)peer.sendRequest(new NetworkMessage.GetNextBlockIdsMessage(l2, n))) == null) {
                    return Collections.emptyList();
                }
                List<Long> list = blockIdsMessage.getBlockIds();
                if (list.isEmpty()) break;
                if (list.size() > n) {
                    Logger.logDebugMessage("Obsolete or rogue peer " + peer.getHost() + " sends too many nextBlockIds, blacklisting");
                    peer.blacklist("Too many nextBlockIds");
                    return Collections.emptyList();
                }
                bl2 = true;
                int n3 = 0;
                for (long l3 : list) {
                    if (bl2) {
                        if (BlockDb.hasBlock(l3)) {
                            l2 = l3;
                            bl3 = true;
                        } else {
                            arrayList.add(l2);
                            arrayList.add(l3);
                            bl2 = false;
                        }
                    } else {
                        arrayList.add(l3);
                        if (arrayList.size() >= 720) continue block0;
                    }
                    if (!bl || ++n3 < 720) continue;
                    continue block0;
                }
            } while (bl2 && !bl);
            if (arrayList.isEmpty() && bl3) {
                arrayList.add(l2);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadBlockchain(Peer peer, Block block, int n) throws InterruptedException {
            Iterator<Object> iterator;
            Object object;
            Object object2;
            int n2;
            HashMap<Long, PeerBlock> hashMap = new HashMap<Long, PeerBlock>();
            ArrayList<GetNextBlocks> arrayList = new ArrayList<GetNextBlocks>();
            int n3 = 36;
            int n4 = this.chainBlockIds.size() - 1;
            for (n2 = 0; n2 < n4; n2 += n3) {
                arrayList.add(new GetNextBlocks(this.chainBlockIds, n2, Math.min(n2 + n3, n4)));
            }
            n2 = ThreadLocalRandom.current().nextInt(this.connectedPublicPeers.size());
            long l = 100L;
            Peer peer2 = null;
            block10: while (!arrayList.isEmpty() && !this.connectedPublicPeers.isEmpty()) {
                for (GetNextBlocks getNextBlocks : arrayList) {
                    if (getNextBlocks.getFailedRequestCount() > 1) {
                        Logger.logDebugMessage("Aborting download, failed request count is " + getNextBlocks.getFailedRequestCount());
                        break block10;
                    }
                    if (getNextBlocks.getStart() == 0 || getNextBlocks.getFailedRequestCount() != 0) {
                        object2 = peer;
                    } else {
                        while (true) {
                            if (this.connectedPublicPeers.isEmpty()) {
                                Logger.logDebugMessage("No connected public peers, aborting");
                                break block10;
                            }
                            if (n2 >= this.connectedPublicPeers.size()) {
                                n2 = 0;
                            }
                            if ((object2 = this.connectedPublicPeers.get(n2++)).getState() == Peer.State.CONNECTED) break;
                            this.connectedPublicPeers.remove(object2);
                        }
                    }
                    if (getNextBlocks.getPeer() == object2) {
                        Logger.logDebugMessage("Feeder " + peer.getHost() + ", connectedPublicPeers " + this.connectedPublicPeers.size());
                        if (getNextBlocks.getFailedRequestCount() != 0) {
                            Logger.logInfoMessage("Failed request count is " + getNextBlocks.getFailedRequestCount() + ", aborting");
                            break block10;
                        }
                    }
                    getNextBlocks.setPeer((Peer)object2);
                    object = BlockchainProcessorImpl.this.networkService.submit(getNextBlocks);
                    getNextBlocks.setFuture((Future<List<Block>>)object);
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    GetNextBlocks getNextBlocks;
                    getNextBlocks = (GetNextBlocks)iterator.next();
                    try {
                        object2 = getNextBlocks.getFuture().get();
                    }
                    catch (ExecutionException executionException) {
                        throw new RuntimeException(executionException.getMessage(), executionException);
                    }
                    if (object2 == null) {
                        object = getNextBlocks.getPeer();
                        Logger.logDebugMessage("No blocks returned, disconnecting peer " + object.getHost());
                        this.connectedPublicPeers.remove(object);
                        object.disconnectPeer();
                        continue;
                    }
                    object = getNextBlocks.getPeer();
                    int n5 = getNextBlocks.getStart() + 1;
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        Block block2 = (Block)iterator2.next();
                        if (block2.getId() != this.chainBlockIds.get(n5).longValue()) {
                            Logger.logDebugMessage("Different block id found");
                            break;
                        }
                        hashMap.put(block2.getId(), new PeerBlock((Peer)object, (BlockImpl)block2));
                        ++n5;
                    }
                    if (n5 > getNextBlocks.getStop()) {
                        iterator.remove();
                    } else {
                        getNextBlocks.setStart(n5 - 1);
                    }
                    if (getNextBlocks.getResponseTime() <= l) continue;
                    l = getNextBlocks.getResponseTime();
                    peer2 = getNextBlocks.getPeer();
                }
            }
            if (peer2 != null && peer2 != peer && NetworkHandler.getConnectionCount() >= n3 && NetworkHandler.getConnectionCount() >= NetworkHandler.getMaxOutboundConnections() && this.chainBlockIds.size() > 360) {
                Logger.logDebugMessage(peer2.getHost() + " took " + l + " ms, disconnecting");
                this.connectedPublicPeers.remove(peer2);
                peer2.disconnectPeer();
            }
            BlockchainProcessorImpl.this.blockchain.writeLock();
            try {
                int n6;
                iterator = new ArrayList();
                for (n6 = 1; n6 < this.chainBlockIds.size() && BlockchainProcessorImpl.this.blockchain.getHeight() - n < 720; ++n6) {
                    object2 = (PeerBlock)hashMap.get(this.chainBlockIds.get(n6));
                    if (object2 == null) {
                        Logger.logDebugMessage("No peer block found for block " + Long.toUnsignedString(this.chainBlockIds.get(n6)));
                        break;
                    }
                    object = ((PeerBlock)object2).getBlock();
                    if (BlockchainProcessorImpl.this.blockchain.getLastBlock().getId() == ((BlockImpl)object).getPreviousBlockId()) {
                        try {
                            BlockchainProcessorImpl.this.pushBlock((BlockImpl)object);
                        }
                        catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                            ((PeerBlock)object2).getPeer().blacklist(blockNotAcceptedException);
                        }
                        continue;
                    }
                    iterator.add(object);
                }
                n6 = BlockchainProcessorImpl.this.blockchain.getHeight() - n;
                if (!iterator.isEmpty() && n6 < 720) {
                    Logger.logDebugMessage("Will process a fork of " + iterator.size() + " blocks, mine is " + n6);
                    try {
                        BlockchainProcessorImpl.this.processFork(iterator, block);
                    }
                    catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                        peer.blacklist(blockNotAcceptedException);
                    }
                }
            }
            finally {
                BlockchainProcessorImpl.this.blockchain.writeUnlock();
            }
        }
    };
    private final Listener<Block> checksumListener = block -> {
        Object object;
        byte[] byArray = (byte[])checksums.get(block.getHeight());
        if (byArray == null) {
            return;
        }
        int n = block.getHeight();
        int n2 = checksums.lowerKey(n);
        MessageDigest messageDigest = Crypto.sha256();
        try {
            object = Db.getConnection();
            Throwable throwable = null;
            try (PreparedStatement preparedStatement = object.prepareStatement("SELECT * FROM transaction_fxt WHERE height > ? AND height <= ? ORDER BY id ASC, timestamp ASC");){
                preparedStatement.setInt(1, n2);
                preparedStatement.setInt(2, n);
                try (DbIterator<FxtTransactionImpl> dbIterator = this.blockchain.getTransactions(FxtChain.FXT, (Connection)object, preparedStatement);){
                    while (dbIterator.hasNext()) {
                        messageDigest.update(dbIterator.next().bytes());
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        object = messageDigest.digest();
        if (byArray.length == 0) {
            Logger.logMessage("Checksum calculated:\n" + Arrays.toString((byte[])object));
        } else if (!Arrays.equals((byte[])object, byArray)) {
            Logger.logErrorMessage("Checksum failed at block " + n + ": " + Arrays.toString((byte[])object));
            if (this.isScanning) {
                throw new RuntimeException("Invalid checksum, interrupting rescan");
            }
            this.popOffTo(n2);
        } else {
            Logger.logMessage("Checksum passed at block " + n);
        }
    };
    private static final Comparator<UnconfirmedTransaction> transactionArrivalComparator;

    public static BlockchainProcessorImpl getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(blockchainPermission);
        }
        return instance;
    }

    public static void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFork(List<Block> list, Block block) throws BlockchainProcessor.BlockNotAcceptedException {
        block22: {
            List<BlockImpl> list2;
            block21: {
                BigInteger bigInteger = this.blockchain.getLastBlock().getCumulativeDifficulty();
                list2 = this.popOffTo(block);
                BlockImpl blockImpl = null;
                int n = 0;
                try {
                    block20: {
                        Iterator iterator;
                        try {
                            if (this.blockchain.getLastBlock().getId() == block.getId()) {
                                for (Block object2 : list) {
                                    if (this.blockchain.getLastBlock().getId() != object2.getPreviousBlockId()) continue;
                                    this.pushBlock((BlockImpl)object2);
                                    ++n;
                                }
                            }
                            if (n <= 0 || this.blockchain.getLastBlock().getCumulativeDifficulty().compareTo(bigInteger) > 0) break block20;
                            blockImpl = this.blockchain.getLastBlock();
                            List<BlockImpl> list3 = this.popOffTo(block);
                            n = 0;
                            iterator = list3.iterator();
                        }
                        catch (Throwable throwable) {
                            if (n > 0 && this.blockchain.getLastBlock().getCumulativeDifficulty().compareTo(bigInteger) <= 0) {
                                blockImpl = this.blockchain.getLastBlock();
                                List<BlockImpl> list3 = this.popOffTo(block);
                                n = 0;
                                for (BlockImpl blockImpl2 : list3) {
                                    TransactionProcessorImpl.getInstance().processLater(blockImpl2.getFxtTransactions());
                                }
                            }
                            throw throwable;
                        }
                        while (iterator.hasNext()) {
                            BlockImpl blockImpl3 = (BlockImpl)iterator.next();
                            TransactionProcessorImpl.getInstance().processLater(blockImpl3.getFxtTransactions());
                        }
                    }
                    if (blockImpl != null) {
                        throw new BlockchainProcessor.BlockOfLowerDifficultyException(blockImpl);
                    }
                    if (n != 0) break block21;
                }
                catch (Throwable throwable) {
                    if (n == 0) {
                        Logger.logDebugMessage("Didn't accept any blocks, pushing back my previous blocks");
                        for (int i = list2.size() - 1; i >= 0; --i) {
                            BlockImpl blockImpl4 = list2.remove(i);
                            try {
                                this.pushBlock(blockImpl4);
                                continue;
                            }
                            catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                                Logger.logErrorMessage("Popped off block no longer acceptable: " + blockImpl4.toString(), blockNotAcceptedException);
                                break;
                            }
                        }
                    } else {
                        Logger.logDebugMessage("Switched to peer's fork");
                        for (BlockImpl blockImpl5 : list2) {
                            TransactionProcessorImpl.getInstance().processLater(blockImpl5.getFxtTransactions());
                        }
                    }
                    throw throwable;
                }
                Logger.logDebugMessage("Didn't accept any blocks, pushing back my previous blocks");
                for (int i = list2.size() - 1; i >= 0; --i) {
                    BlockImpl blockImpl6 = list2.remove(i);
                    try {
                        this.pushBlock(blockImpl6);
                        continue;
                    }
                    catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                        Logger.logErrorMessage("Popped off block no longer acceptable: " + blockImpl6.toString(), blockNotAcceptedException);
                        break block22;
                    }
                }
                break block22;
            }
            Logger.logDebugMessage("Switched to peer's fork");
            for (BlockImpl blockImpl : list2) {
                TransactionProcessorImpl.getInstance().processLater(blockImpl.getFxtTransactions());
            }
        }
    }

    private BlockchainProcessorImpl() {
        int n = Nxt.getIntProperty("nxt.trimFrequency");
        this.blockListeners.addListener((T block) -> {
            if (block.getHeight() % 5000 == 0) {
                Logger.logMessage("processed block " + block.getHeight());
            }
            if (this.trimDerivedTables && block.getHeight() % n == 0) {
                this.doTrimDerivedTables();
            }
        }, BlockchainProcessor.Event.BLOCK_SCANNED);
        this.blockListeners.addListener((T block) -> {
            block4: {
                block5: {
                    if (this.trimDerivedTables && block.getHeight() % n == 0 && !this.isTrimming) {
                        this.isTrimming = true;
                        this.networkService.submit(() -> {
                            this.trimDerivedTables();
                            this.isTrimming = false;
                        });
                    }
                    if (block.getHeight() % 5000 != 0) break block4;
                    Logger.logMessage("received block " + block.getHeight());
                    if (!this.isDownloading) break block5;
                    if (block.getHeight() % 50000 != 0) break block4;
                }
                this.networkService.submit(Db.db::analyzeTables);
            }
        }, BlockchainProcessor.Event.BLOCK_PUSHED);
        this.blockListeners.addListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_PUSHED);
        this.blockListeners.addListener((T block) -> Db.db.analyzeTables(), BlockchainProcessor.Event.RESCAN_END);
        ThreadPool.runBeforeStart(() -> {
            this.alreadyInitialized = true;
            this.addGenesisBlock();
            if (Nxt.getBooleanProperty("nxt.forceScan")) {
                this.scan(0, Nxt.getBooleanProperty("nxt.forceValidate"));
            } else {
                int n;
                boolean bl;
                boolean bl2;
                try (Connection connection = Db.getConnection();
                     Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery("SELECT * FROM scan");){
                    resultSet.next();
                    bl2 = resultSet.getBoolean("rescan");
                    bl = resultSet.getBoolean("validate");
                    n = resultSet.getInt("height");
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
                if (bl2) {
                    this.scan(n, bl);
                }
            }
        }, false);
        if (!Constants.isLightClient && !Constants.isOffline) {
            ThreadPool.scheduleThread("GetMoreBlocks", this.getMoreBlocksThread, 5);
        }
    }

    @Override
    public boolean addListener(Listener<Block> listener, BlockchainProcessor.Event event) {
        return this.blockListeners.addListener(listener, event);
    }

    @Override
    public boolean removeListener(Listener<Block> listener, BlockchainProcessor.Event event) {
        return this.blockListeners.removeListener(listener, event);
    }

    @Override
    public void registerDerivedTable(DerivedDbTable derivedDbTable) {
        if (this.alreadyInitialized) {
            throw new IllegalStateException("Too late to register table " + derivedDbTable + ", must have done it in Nxt.Init");
        }
        this.derivedTables.add(derivedDbTable);
    }

    @Override
    public void trimDerivedTables() {
        try {
            Db.db.beginTransaction();
            this.doTrimDerivedTables();
            Db.db.commitTransaction();
        }
        catch (Exception exception) {
            Logger.logMessage(exception.toString(), exception);
            Db.db.rollbackTransaction();
            throw exception;
        }
        finally {
            Db.db.endTransaction();
        }
    }

    private void doTrimDerivedTables() {
        this.lastTrimHeight = Math.max(this.blockchain.getHeight() - Constants.MAX_ROLLBACK, 0);
        if (this.lastTrimHeight > 0) {
            for (DerivedDbTable derivedDbTable : this.derivedTables) {
                this.blockchain.readLock();
                try {
                    derivedDbTable.trim(this.lastTrimHeight);
                    Db.db.commitTransaction();
                }
                finally {
                    this.blockchain.readUnlock();
                }
            }
        }
    }

    List<DerivedDbTable> getDerivedTables() {
        return this.derivedTables;
    }

    @Override
    public Peer getLastBlockchainFeeder() {
        return this.lastBlockchainFeeder;
    }

    @Override
    public int getLastBlockchainFeederHeight() {
        return this.lastBlockchainFeederHeight;
    }

    @Override
    public boolean isScanning() {
        return this.isScanning;
    }

    @Override
    public int getInitialScanHeight() {
        return this.initialScanHeight;
    }

    @Override
    public void suspendDownload(boolean bl) {
        this.isDownloadSuspended = bl;
    }

    @Override
    public boolean isDownloadSuspended() {
        return this.isDownloadSuspended;
    }

    @Override
    public boolean isDownloading() {
        return this.isDownloading;
    }

    @Override
    public boolean isProcessingBlock() {
        return this.isProcessingBlock;
    }

    @Override
    public int getMinRollbackHeight() {
        return this.trimDerivedTables ? (this.lastTrimHeight > 0 ? this.lastTrimHeight : Math.max(this.blockchain.getHeight() - Constants.MAX_ROLLBACK, 0)) : 0;
    }

    @Override
    public long getGenesisBlockId() {
        return this.genesisBlockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPeerBlock(Block block) throws NxtException {
        BlockImpl blockImpl = (BlockImpl)block;
        BlockImpl blockImpl2 = this.blockchain.getLastBlock();
        if (blockImpl.getPreviousBlockId() == blockImpl2.getId()) {
            this.pushBlock(blockImpl);
        } else if (blockImpl.getPreviousBlockId() == blockImpl2.getPreviousBlockId() && blockImpl.getTimestamp() < blockImpl2.getTimestamp()) {
            this.blockchain.writeLock();
            try {
                if (blockImpl2.getId() != this.blockchain.getLastBlock().getId()) {
                    return;
                }
                BlockImpl blockImpl3 = this.blockchain.getBlock(blockImpl2.getPreviousBlockId());
                blockImpl2 = this.popOffTo(blockImpl3).get(0);
                try {
                    this.pushBlock(blockImpl);
                    TransactionProcessorImpl.getInstance().processLater(blockImpl2.getFxtTransactions());
                    Logger.logDebugMessage("Last block " + blockImpl2.getStringId() + " was replaced by " + blockImpl.getStringId());
                }
                catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
                    Logger.logDebugMessage("Replacement block failed to be accepted, pushing back our last block");
                    this.pushBlock(blockImpl2);
                    TransactionProcessorImpl.getInstance().processLater(blockImpl.getFxtTransactions());
                    throw blockNotAcceptedException;
                }
            }
            finally {
                this.blockchain.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPeerBlocks(List<Block> list) throws NxtException {
        if (list.size() != 2) {
            return;
        }
        this.blockchain.writeLock();
        try {
            BlockImpl blockImpl = this.blockchain.getLastBlock();
            BlockImpl blockImpl2 = this.blockchain.getBlock(blockImpl.getPreviousBlockId());
            BlockImpl blockImpl3 = (BlockImpl)list.get(0);
            if (blockImpl2.getId() != blockImpl3.getPreviousBlockId()) {
                return;
            }
            this.processFork(list, blockImpl2);
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    public List<BlockImpl> popOffTo(int n) {
        if (n < 0) {
            this.fullReset();
        } else if (n < this.blockchain.getHeight()) {
            return this.popOffTo(this.blockchain.getBlockAtHeight(n));
        }
        return Collections.emptyList();
    }

    @Override
    public void fullReset() {
        this.blockchain.writeLock();
        try {
            try {
                this.setGetMoreBlocks(false);
                BlockDb.deleteAll();
                this.addGenesisBlock();
            }
            finally {
                this.setGetMoreBlocks(true);
            }
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    @Override
    public void setGetMoreBlocks(boolean bl) {
        this.getMoreBlocks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int restorePrunedData(Chain chain) {
        Object object;
        Db.db.beginTransaction();
        try {
            object = Db.db.getConnection(chain.getDbSchema());
            Throwable throwable = null;
            try {
                int n = Nxt.getEpochTime();
                int n2 = Math.max(1, n - Constants.MAX_PRUNABLE_LIFETIME);
                int n3 = Math.max(n2, n - Constants.MIN_PRUNABLE_LIFETIME) - 1;
                List<TransactionHome.PrunableTransaction> list = chain.getTransactionHome().findPrunableTransactions((Connection)object, n2, n3);
                list.forEach(prunableTransaction -> {
                    byte[] byArray = prunableTransaction.getFullHash();
                    if (prunableTransaction.hasPrunableAttachment() && prunableTransaction.getTransactionType().isPruned(chain, byArray) || chain.getPrunableMessageHome().isPruned(byArray, prunableTransaction.hasPrunablePlainMessage(), prunableTransaction.hasPrunableEncryptedMessage())) {
                        Set<ChainTransactionId> set = this.prunableTransactions;
                        synchronized (set) {
                            this.prunableTransactions.add(new ChainTransactionId(chain.getId(), byArray));
                        }
                    }
                });
                if (!this.prunableTransactions.isEmpty()) {
                    this.lastRestoreTime = 0;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            Db.db.endTransaction();
        }
        object = this.prunableTransactions;
        synchronized (object) {
            return this.prunableTransactions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transaction restorePrunedTransaction(Chain chain, byte[] byArray) {
        TransactionImpl transactionImpl = chain.getTransactionHome().findTransaction(byArray);
        if (transactionImpl == null) {
            throw new IllegalArgumentException("Transaction not found");
        }
        boolean bl = false;
        for (Appendix.AbstractAppendix object2 : transactionImpl.getAppendages(true)) {
            if (!(object2 instanceof Appendix.Prunable) || ((Appendix.Prunable)((Object)object2)).hasPrunableData()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return transactionImpl;
        }
        List<Peer> list = Peers.getPeers(peer -> peer.providesService(Peer.Service.PRUNABLE) && !peer.isBlacklisted() && (peer.getState() == Peer.State.CONNECTED || peer.getAnnouncedAddress() != null && peer.shareAddress()));
        if (list.isEmpty()) {
            Logger.logDebugMessage("Cannot find any archive peers");
            return null;
        }
        ChainTransactionId chainTransactionId = ChainTransactionId.getChainTransactionId(transactionImpl);
        List<ChainTransactionId> list2 = Collections.singletonList(chainTransactionId);
        for (Peer peer2 : list) {
            if (peer2.getState() != Peer.State.CONNECTED) {
                peer2.connectPeer();
            }
            if (peer2.getState() != Peer.State.CONNECTED) continue;
            Logger.logDebugMessage("Connected to archive peer " + peer2.getHost());
            NetworkMessage.TransactionsMessage transactionsMessage = (NetworkMessage.TransactionsMessage)peer2.sendRequest(new NetworkMessage.GetTransactionsMessage(list2));
            if (transactionsMessage == null || transactionsMessage.getTransactionCount() == 0) continue;
            try {
                List<Transaction> notValidException = transactionsMessage.getTransactions();
                List<Transaction> list3 = Nxt.getTransactionProcessor().restorePrunableData(notValidException);
                if (list3.isEmpty()) continue;
                Set<ChainTransactionId> set = this.prunableTransactions;
                synchronized (set) {
                    this.prunableTransactions.remove(chainTransactionId);
                }
                return list3.get(0);
            }
            catch (NxtException.NotValidException notValidException) {
                Logger.logErrorMessage("Peer " + peer2.getHost() + " returned invalid prunable transaction", notValidException);
                peer2.blacklist(notValidException);
            }
        }
        return null;
    }

    public void shutdown() {
        ThreadPool.shutdownExecutor("networkService", this.networkService, 5);
    }

    private void addBlock(BlockImpl blockImpl) {
        try (Connection connection = BlockDb.getConnection();){
            BlockDb.saveBlock(connection, blockImpl);
            this.blockchain.setLastBlock(blockImpl);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    private void addGenesisBlock() {
        BlockImpl blockImpl = BlockDb.findLastBlock();
        if (blockImpl != null) {
            Logger.logMessage("Genesis block already in database");
            this.blockchain.setLastBlock(blockImpl);
            if (blockImpl.getHeight() > 0) {
                Logger.logDebugMessage("Will pop-off block " + blockImpl.getStringId());
                blockImpl = BlockDb.findBlock(blockImpl.getPreviousBlockId());
            }
            BlockDb.deleteBlocksFromHeight(blockImpl.getHeight() + 1);
            this.popOffTo(blockImpl);
            this.genesisBlockId = BlockDb.findBlockIdAtHeight(0);
            Logger.logMessage("Last block height: " + blockImpl.getHeight());
            return;
        }
        Logger.logMessage("Genesis block not in database, starting from scratch");
        BlockImpl blockImpl2 = new BlockImpl(Genesis.generationSignature);
        this.genesisBlockId = blockImpl2.getId();
        if (Constants.isLightClient) {
            this.blockchain.setLastBlock(blockImpl2);
            return;
        }
        try (Connection connection = Db.db.beginTransaction();){
            this.addBlock(blockImpl2);
            byte[] byArray = Genesis.apply();
            if (!Arrays.equals(byArray, blockImpl2.getGenerationSignature())) {
                this.scheduleScan(0, true);
                Db.db.commitTransaction();
                throw new RuntimeException("Invalid generation signature " + Arrays.toString(byArray));
            }
            Db.db.commitTransaction();
            for (DerivedDbTable derivedDbTable : this.derivedTables) {
                derivedDbTable.createSearchIndex(connection);
            }
            Db.db.commitTransaction();
        }
        catch (SQLException sQLException) {
            Db.db.rollbackTransaction();
            Logger.logMessage(sQLException.getMessage());
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        finally {
            Db.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushBlock(BlockImpl blockImpl) throws BlockchainProcessor.BlockNotAcceptedException {
        int n = Nxt.getEpochTime();
        this.blockchain.writeLock();
        try {
            try {
                Db.db.beginTransaction();
                BlockImpl blockImpl2 = this.blockchain.getLastBlock();
                this.validate(blockImpl, blockImpl2, n);
                long l = Generator.getNextHitTime(blockImpl2.getId(), n);
                if (l > 0L && (long)blockImpl.getTimestamp() > l + 1L) {
                    String string = "Rejecting block " + blockImpl.getStringId() + " at height " + blockImpl2.getHeight() + " block timestamp " + blockImpl.getTimestamp() + " next hit time " + l + " current time " + n;
                    Logger.logDebugMessage(string);
                    Generator.setDelay(-Constants.FORGING_SPEEDUP);
                    throw new BlockchainProcessor.BlockOutOfOrderException(string, blockImpl);
                }
                HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
                ArrayList<ChildTransactionImpl> arrayList = new ArrayList<ChildTransactionImpl>();
                ArrayList<ChildTransactionImpl> arrayList2 = new ArrayList<ChildTransactionImpl>();
                this.validatePhasedTransactions(blockImpl2.getHeight(), arrayList, arrayList2, hashMap);
                this.validateTransactions(blockImpl, blockImpl2, n, hashMap, blockImpl2.getHeight() >= Constants.LAST_CHECKSUM_BLOCK);
                blockImpl.setPrevious(blockImpl2);
                this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BEFORE_BLOCK_ACCEPT);
                TransactionProcessorImpl.getInstance().requeueAllUnconfirmedTransactions();
                try {
                    this.addBlock(blockImpl);
                    this.accept(blockImpl, arrayList, arrayList2, hashMap);
                    Db.db.commitTransaction();
                }
                catch (Exception exception) {
                    Logger.logInfoMessage("Failed to accept an already validated block", exception);
                    Db.db.rollbackTransaction();
                    BlockDb.deleteBlocksFrom(blockImpl.getId());
                    this.blockchain.setLastBlock(blockImpl2);
                    for (DerivedDbTable derivedDbTable : this.derivedTables) {
                        derivedDbTable.popOffTo(blockImpl2.getHeight());
                    }
                    Db.db.clearCache();
                    Db.db.commitTransaction();
                    throw exception;
                }
            }
            finally {
                Db.db.endTransaction();
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
        }
        finally {
            this.blockchain.writeUnlock();
        }
        if (blockImpl.getTimestamp() >= n - 600) {
            NetworkHandler.broadcastMessage(new NetworkMessage.BlockInventoryMessage(blockImpl));
        }
        this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BLOCK_PUSHED);
    }

    private void validatePhasedTransactions(int n, List<ChildTransactionImpl> list, List<ChildTransactionImpl> list2, Map<TransactionType, Map<String, Integer>> map) {
        for (ChildTransaction childTransaction : PhasingPollHome.getFinishingTransactions(n + 1)) {
            ChildTransactionImpl childTransactionImpl = (ChildTransactionImpl)childTransaction;
            if (PhasingPollHome.getResult(childTransactionImpl) != null) continue;
            try {
                childTransactionImpl.validate();
                if (!childTransactionImpl.attachmentIsDuplicate(map, false)) {
                    list.add(childTransactionImpl);
                    continue;
                }
                Logger.logDebugMessage("At height " + n + " phased transaction " + childTransactionImpl.getStringId() + " is duplicate, will not apply");
                list2.add(childTransactionImpl);
            }
            catch (NxtException.ValidationException validationException) {
                Logger.logDebugMessage("At height " + n + " phased transaction " + childTransactionImpl.getStringId() + " no longer passes validation: " + validationException.getMessage() + ", will not apply");
                list2.add(childTransactionImpl);
            }
        }
    }

    private void validate(BlockImpl blockImpl, BlockImpl blockImpl2, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        if (blockImpl2.getId() != blockImpl.getPreviousBlockId()) {
            throw new BlockchainProcessor.BlockOutOfOrderException("Previous block id doesn't match", blockImpl);
        }
        if (blockImpl.getVersion() != this.getBlockVersion(blockImpl2.getHeight())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Invalid version " + blockImpl.getVersion(), blockImpl);
        }
        if (blockImpl.getTimestamp() > n + 15) {
            Logger.logWarningMessage("Received block " + blockImpl.getStringId() + " from the future, timestamp " + blockImpl.getTimestamp() + " generator " + Long.toUnsignedString(blockImpl.getGeneratorId()) + " current time " + n + ", system clock may be off");
            throw new BlockchainProcessor.BlockOutOfOrderException("Invalid timestamp: " + blockImpl.getTimestamp() + " current time is " + n, blockImpl);
        }
        if (blockImpl.getTimestamp() <= blockImpl2.getTimestamp()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Block timestamp " + blockImpl.getTimestamp() + " is before previous block timestamp " + blockImpl2.getTimestamp(), blockImpl);
        }
        if (!Arrays.equals(Crypto.sha256().digest(blockImpl2.bytes()), blockImpl.getPreviousBlockHash())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Previous block hash doesn't match", blockImpl);
        }
        if (blockImpl.getId() == 0L || BlockDb.hasBlock(blockImpl.getId(), blockImpl2.getHeight())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Duplicate block or invalid id", blockImpl);
        }
        if (!blockImpl.verifyGenerationSignature() && !Generator.allowsFakeForging(blockImpl.getGeneratorPublicKey())) {
            Account account = Account.getAccount(blockImpl.getGeneratorId());
            long l = account == null ? 0L : account.getEffectiveBalanceFXT();
            throw new BlockchainProcessor.BlockNotAcceptedException("Generation signature verification failed, effective balance " + l, blockImpl);
        }
        if (!blockImpl.verifyBlockSignature()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Block signature verification failed", blockImpl);
        }
        if (blockImpl.getFxtTransactions().size() > 10) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Invalid block transaction count " + blockImpl.getFxtTransactions().size(), blockImpl);
        }
    }

    private void validateTransactions(BlockImpl blockImpl, BlockImpl blockImpl2, int n, Map<TransactionType, Map<String, Integer>> map, boolean bl) throws BlockchainProcessor.BlockNotAcceptedException {
        long l = 0L;
        MessageDigest messageDigest = Crypto.sha256();
        HashSet<Long> hashSet = bl ? new HashSet<Long>() : null;
        for (FxtTransactionImpl fxtTransactionImpl : blockImpl.getFxtTransactions()) {
            this.validateTransaction(fxtTransactionImpl, blockImpl, blockImpl2, n);
            if (bl) {
                if (!hashSet.add(fxtTransactionImpl.getId())) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Duplicate transaction id", (TransactionImpl)fxtTransactionImpl);
                }
                this.fullyValidateTransaction(fxtTransactionImpl, blockImpl, blockImpl2, n);
            }
            for (ChildTransactionImpl childTransactionImpl : fxtTransactionImpl.getChildTransactions()) {
                this.validateTransaction(childTransactionImpl, blockImpl, blockImpl2, n);
                if (bl) {
                    if (!hashSet.add(childTransactionImpl.getId())) {
                        throw new BlockchainProcessor.TransactionNotAcceptedException("Duplicate transaction id", (TransactionImpl)childTransactionImpl);
                    }
                    this.fullyValidateTransaction(childTransactionImpl, blockImpl, blockImpl2, n);
                }
                if (!childTransactionImpl.attachmentIsDuplicate(map, true)) continue;
                throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction is a duplicate", (TransactionImpl)childTransactionImpl);
            }
            if (fxtTransactionImpl.attachmentIsDuplicate(map, true)) {
                throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction is a duplicate", (TransactionImpl)fxtTransactionImpl);
            }
            l += fxtTransactionImpl.getFee();
            messageDigest.update(fxtTransactionImpl.bytes());
        }
        if (l != blockImpl.getTotalFeeFQT()) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Total fee doesn't match transaction total", blockImpl);
        }
        if (!Arrays.equals(messageDigest.digest(), blockImpl.getPayloadHash())) {
            throw new BlockchainProcessor.BlockNotAcceptedException("Payload hash doesn't match", blockImpl);
        }
    }

    private void validateTransaction(TransactionImpl transactionImpl, BlockImpl blockImpl, BlockImpl blockImpl2, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        if (transactionImpl.getTimestamp() > n + 15) {
            throw new BlockchainProcessor.BlockOutOfOrderException("Invalid transaction timestamp: " + transactionImpl.getTimestamp() + ", current time is " + n, blockImpl);
        }
        if (!transactionImpl.verifySignature()) {
            throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction signature verification failed at height " + blockImpl2.getHeight(), transactionImpl);
        }
    }

    private void fullyValidateTransaction(FxtTransactionImpl fxtTransactionImpl, BlockImpl blockImpl, BlockImpl blockImpl2, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        if (fxtTransactionImpl.getTimestamp() > blockImpl.getTimestamp() + 15 || fxtTransactionImpl.getExpiration() < blockImpl.getTimestamp()) {
            throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction timestamp " + fxtTransactionImpl.getTimestamp() + ", current time is " + n + ", block timestamp is " + blockImpl.getTimestamp(), (TransactionImpl)fxtTransactionImpl);
        }
        if (TransactionHome.hasFxtTransaction(fxtTransactionImpl.getId(), blockImpl2.getHeight())) {
            throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction is already in the blockchain", (TransactionImpl)fxtTransactionImpl);
        }
        if (fxtTransactionImpl.getVersion() != this.getTransactionVersion(blockImpl2.getHeight())) {
            throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction version " + fxtTransactionImpl.getVersion() + " at height " + blockImpl2.getHeight(), (TransactionImpl)fxtTransactionImpl);
        }
        try {
            fxtTransactionImpl.validateId();
            fxtTransactionImpl.validate();
        }
        catch (NxtException.ValidationException validationException) {
            throw new BlockchainProcessor.TransactionNotAcceptedException((Throwable)validationException, (TransactionImpl)fxtTransactionImpl);
        }
    }

    private void fullyValidateTransaction(ChildTransactionImpl childTransactionImpl, BlockImpl blockImpl, BlockImpl blockImpl2, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        if (childTransactionImpl.getChain().getTransactionHome().hasTransaction(childTransactionImpl, blockImpl2.getHeight())) {
            throw new BlockchainProcessor.TransactionNotAcceptedException("Transaction is already in the blockchain", (TransactionImpl)childTransactionImpl);
        }
        if (childTransactionImpl.getReferencedTransactionId() != null && !childTransactionImpl.hasAllReferencedTransactions(childTransactionImpl.getTimestamp(), 0)) {
            throw new BlockchainProcessor.TransactionNotAcceptedException("Missing or invalid referenced transaction " + childTransactionImpl.getReferencedTransactionId(), (TransactionImpl)childTransactionImpl);
        }
        if (childTransactionImpl.getVersion() != this.getTransactionVersion(blockImpl2.getHeight())) {
            throw new BlockchainProcessor.TransactionNotAcceptedException("Invalid transaction version " + childTransactionImpl.getVersion() + " at height " + blockImpl2.getHeight(), (TransactionImpl)childTransactionImpl);
        }
        try {
            childTransactionImpl.validateId();
        }
        catch (NxtException.ValidationException validationException) {
            throw new BlockchainProcessor.TransactionNotAcceptedException((Throwable)validationException, (TransactionImpl)childTransactionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void accept(BlockImpl blockImpl, List<ChildTransactionImpl> list, List<ChildTransactionImpl> list2, Map<TransactionType, Map<String, Integer>> map) throws BlockchainProcessor.TransactionNotAcceptedException {
        try {
            this.isProcessingBlock = true;
            for (FxtTransactionImpl object22 : blockImpl.getFxtTransactions()) {
                if (!object22.applyUnconfirmed()) {
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Double spending", (TransactionImpl)object22);
                }
                for (ChildTransactionImpl childTransactionImpl2 : object22.getSortedChildTransactions()) {
                    if (childTransactionImpl2.applyUnconfirmed()) continue;
                    throw new BlockchainProcessor.TransactionNotAcceptedException("Double spending in child transaction", (TransactionImpl)childTransactionImpl2);
                }
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BEFORE_BLOCK_APPLY);
            blockImpl.apply();
            list.forEach(childTransactionImpl -> childTransactionImpl.getPhasing().countVotes((ChildTransactionImpl)childTransactionImpl));
            list2.forEach(childTransactionImpl -> childTransactionImpl.getPhasing().reject((ChildTransactionImpl)childTransactionImpl));
            int n = Nxt.getEpochTime() - Constants.MAX_PRUNABLE_LIFETIME;
            for (FxtTransactionImpl fxtTransactionImpl2 : blockImpl.getFxtTransactions()) {
                try {
                    fxtTransactionImpl2.apply();
                    this.checkMissingPrunable(fxtTransactionImpl2, n);
                    for (ChildTransactionImpl childTransactionImpl3 : fxtTransactionImpl2.getSortedChildTransactions()) {
                        this.checkMissingPrunable(childTransactionImpl3, n);
                    }
                    if ((fxtTransactionImpl2.getIndex() + 1) % Constants.BATCH_COMMIT_SIZE != 0) continue;
                    Db.db.commitTransaction();
                }
                catch (RuntimeException runtimeException) {
                    Logger.logErrorMessage(runtimeException.toString(), runtimeException);
                    throw new BlockchainProcessor.TransactionNotAcceptedException((Throwable)runtimeException, (TransactionImpl)fxtTransactionImpl2);
                }
            }
            TreeSet<ChildTransaction> treeSet = new TreeSet<ChildTransaction>(PhasingPollHome.finishingTransactionsComparator);
            blockImpl.getFxtTransactions().forEach(fxtTransactionImpl -> {
                for (ChildTransactionImpl childTransactionImpl : fxtTransactionImpl.getSortedChildTransactions()) {
                    PhasingPollHome.getLinkedPhasedTransactions(childTransactionImpl).forEach(childTransaction -> {
                        if (childTransaction.getPhasing().getFinishHeight() > blockImpl.getHeight()) {
                            object22.add((ChildTransactionImpl)childTransaction);
                        }
                    });
                    PhasingAppendix phasingAppendix = childTransactionImpl.getPhasing();
                    if (phasingAppendix != null && phasingAppendix.getParams().allowFinishAtCreation()) {
                        object22.add(childTransactionImpl);
                    }
                    if (childTransactionImpl.getType() != VotingTransactionType.PHASING_VOTE_CASTING || childTransactionImpl.attachmentIsPhased()) continue;
                    this.addVotedTransactions(childTransactionImpl, (Set<ChildTransactionImpl>)object22, blockImpl.getHeight());
                }
            });
            list.forEach(childTransactionImpl -> {
                PhasingPollHome.PhasingPollResult phasingPollResult;
                if (childTransactionImpl.getType() == VotingTransactionType.PHASING_VOTE_CASTING && (phasingPollResult = PhasingPollHome.getResult(childTransactionImpl)) != null && phasingPollResult.isApproved()) {
                    this.addVotedTransactions((ChildTransaction)childTransactionImpl, (Set<ChildTransactionImpl>)object22, blockImpl.getHeight());
                }
            });
            boolean bl = false;
            for (ChildTransactionImpl childTransactionImpl3 : treeSet) {
                if (PhasingPollHome.getResult(childTransactionImpl3) != null) continue;
                try {
                    void var7_14;
                    childTransactionImpl3.validate();
                    childTransactionImpl3.getPhasing().tryCountVotes(childTransactionImpl3, map);
                    if (++var7_14 % Constants.BATCH_COMMIT_SIZE != false) continue;
                    Db.db.commitTransaction();
                }
                catch (NxtException.ValidationException validationException) {
                    Logger.logDebugMessage("At height " + blockImpl.getHeight() + " phased transaction " + childTransactionImpl3.getStringId() + " no longer passes validation: " + validationException.getMessage() + ", cannot finish early");
                }
            }
            this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.AFTER_BLOCK_APPLY);
            if (blockImpl.getFxtTransactions().size() > 0) {
                ArrayList arrayList = new ArrayList();
                blockImpl.getFxtTransactions().forEach(fxtTransactionImpl -> {
                    arrayList.add(fxtTransactionImpl);
                    arrayList.addAll(fxtTransactionImpl.getSortedChildTransactions());
                });
                TransactionProcessorImpl.getInstance().notifyListeners(arrayList, TransactionProcessor.Event.ADDED_CONFIRMED_TRANSACTIONS);
            }
            AccountLedger.commitEntries();
        }
        finally {
            this.isProcessingBlock = false;
            AccountLedger.clearEntries();
        }
    }

    private void addVotedTransactions(ChildTransaction childTransaction, Set<ChildTransactionImpl> set, int n) {
        for (ChainTransactionId chainTransactionId : PhasingPollHome.getVotedTransactionIds(childTransaction)) {
            ChildChain childChain = chainTransactionId.getChildChain();
            PhasingPollHome.PhasingPoll phasingPoll = childChain.getPhasingPollHome().getPoll(chainTransactionId.getFullHash());
            if (!phasingPoll.allowEarlyFinish() || phasingPoll.getFinishHeight() <= n) continue;
            set.add((ChildTransactionImpl)chainTransactionId.getChildTransaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMissingPrunable(TransactionImpl transactionImpl, int n) {
        if (transactionImpl.getTimestamp() > n) {
            for (Appendix.AbstractAppendix abstractAppendix : transactionImpl.getAppendages(true)) {
                if (!(abstractAppendix instanceof Appendix.Prunable) || ((Appendix.Prunable)((Object)abstractAppendix)).hasPrunableData()) continue;
                Set<ChainTransactionId> set = this.prunableTransactions;
                synchronized (set) {
                    this.prunableTransactions.add(ChainTransactionId.getChainTransactionId(transactionImpl));
                }
                this.lastRestoreTime = 0;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<BlockImpl> popOffTo(Block block) {
        this.blockchain.writeLock();
        try {
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    List<BlockImpl> list = this.popOffTo(block);
                    return list;
                }
                finally {
                    Db.db.endTransaction();
                }
            }
            if (!this.blockchain.hasBlock(block.getId())) {
                Logger.logDebugMessage("Block " + block.getStringId() + " not found in blockchain, nothing to pop off");
                List<BlockImpl> list = Collections.emptyList();
                return list;
            }
            if (block.getHeight() < this.getMinRollbackHeight()) {
                Object object;
                Logger.logMessage("Rollback to height " + block.getHeight() + " not supported, will do a full rescan");
                try {
                    this.scheduleScan(0, false);
                    object = BlockDb.deleteBlocksFrom(BlockDb.findBlockIdAtHeight(block.getHeight() + 1));
                    this.blockchain.setLastBlock((BlockImpl)object);
                    for (DerivedDbTable derivedDbTable : this.derivedTables) {
                        derivedDbTable.popOffTo(((BlockImpl)object).getHeight());
                    }
                    Db.db.clearCache();
                    Db.db.commitTransaction();
                    Logger.logDebugMessage("Deleted blocks starting from height %s", block.getHeight() + 1);
                }
                finally {
                    this.scan(0, false);
                }
                object = Collections.emptyList();
                return object;
            }
            ArrayList<BlockImpl> arrayList = new ArrayList<BlockImpl>();
            BlockImpl blockImpl = this.blockchain.getLastBlock();
            blockImpl.loadTransactions();
            Logger.logDebugMessage("Rollback from block " + blockImpl.getStringId() + " at height " + blockImpl.getHeight() + " to " + block.getStringId() + " at " + block.getHeight());
            while (blockImpl.getId() != block.getId() && blockImpl.getHeight() > 0) {
                arrayList.add(blockImpl);
                blockImpl = this.popLastBlock();
            }
            for (DerivedDbTable derivedDbTable : this.derivedTables) {
                derivedDbTable.popOffTo(block.getHeight());
            }
            Db.db.clearCache();
            Db.db.commitTransaction();
            ArrayList<BlockImpl> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    private BlockImpl popLastBlock() {
        BlockImpl blockImpl = this.blockchain.getLastBlock();
        if (blockImpl.getHeight() == 0) {
            throw new RuntimeException("Cannot pop off genesis block");
        }
        BlockImpl blockImpl2 = BlockDb.deleteBlocksFrom(blockImpl.getId());
        blockImpl2.loadTransactions();
        this.blockchain.setLastBlock(blockImpl2);
        this.blockListeners.notify(blockImpl, BlockchainProcessor.Event.BLOCK_POPPED);
        return blockImpl2;
    }

    private int getBlockVersion(int n) {
        return 3;
    }

    private int getTransactionVersion(int n) {
        return 1;
    }

    SortedSet<UnconfirmedFxtTransaction> selectUnconfirmedFxtTransactions(Map<TransactionType, Map<String, Integer>> map, Block block, int n) {
        ArrayList<UnconfirmedFxtTransaction> arrayList = new ArrayList<UnconfirmedFxtTransaction>();
        Iterable<UnconfirmedTransaction> iterable = new FilteringIterator<UnconfirmedTransaction>(TransactionProcessorImpl.getInstance().getUnconfirmedFxtTransactions(), unconfirmedTransaction -> unconfirmedTransaction.getTransaction().hasAllReferencedTransactions(unconfirmedTransaction.getTimestamp(), 0));
        Object object = null;
        try {
            for (UnconfirmedTransaction unconfirmedTransaction2 : iterable) {
                arrayList.add((UnconfirmedFxtTransaction)unconfirmedTransaction2);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (iterable != null) {
                if (object != null) {
                    try {
                        ((FilteringIterator)iterable).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((FilteringIterator)iterable).close();
                }
            }
        }
        iterable = new TreeSet<UnconfirmedTransaction>(transactionArrivalComparator);
        block12: for (UnconfirmedFxtTransaction unconfirmedFxtTransaction : arrayList) {
            if (iterable.contains(unconfirmedFxtTransaction) || unconfirmedFxtTransaction.getVersion() != this.getTransactionVersion(block.getHeight()) || n > 0 && (unconfirmedFxtTransaction.getTimestamp() > n + 15 || unconfirmedFxtTransaction.getExpiration() < n)) continue;
            try {
                unconfirmedFxtTransaction.getTransaction().validate();
            }
            catch (NxtException.ValidationException validationException) {
                continue;
            }
            if (unconfirmedFxtTransaction.getTransaction().attachmentIsDuplicate(map, true)) continue;
            for (ChildTransaction childTransaction : unconfirmedFxtTransaction.getChildTransactions()) {
                if (!((ChildTransactionImpl)childTransaction).attachmentIsDuplicate(map, true)) continue;
                continue block12;
            }
            iterable.add((UnconfirmedFxtTransaction)unconfirmedFxtTransaction);
            if (iterable.size() != 10) continue;
            break;
        }
        return iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBlock(String string, int n) throws BlockchainProcessor.BlockNotAcceptedException {
        Object object;
        Object object22;
        HashMap<TransactionType, Map<String, Integer>> hashMap = new HashMap<TransactionType, Map<String, Integer>>();
        for (ChildTransaction object32 : PhasingPollHome.getFinishingTransactions(this.blockchain.getHeight() + 1)) {
            try {
                object32.validate();
                ((ChildTransactionImpl)object32).attachmentIsDuplicate(hashMap, false);
            }
            catch (NxtException.ValidationException arrayList) {}
        }
        BlockImpl blockImpl = this.blockchain.getLastBlock();
        TransactionProcessorImpl.getInstance().processWaitingTransactions();
        SortedSet<UnconfirmedFxtTransaction> sortedSet = this.selectUnconfirmedFxtTransactions(hashMap, blockImpl, n);
        ArrayList<FxtTransactionImpl> arrayList = new ArrayList<FxtTransactionImpl>();
        MessageDigest messageDigest = Crypto.sha256();
        long l = 0L;
        for (Object object22 : sortedSet) {
            object = ((UnconfirmedFxtTransaction)object22).getTransaction();
            arrayList.add((FxtTransactionImpl)object);
            messageDigest.update(((TransactionImpl)object).bytes());
            l += ((FxtTransactionImpl)object).getFee();
        }
        Object object3 = messageDigest.digest();
        messageDigest.update(blockImpl.getGenerationSignature());
        object22 = Crypto.getPublicKey(string);
        object = messageDigest.digest((byte[])object22);
        byte[] byArray = Crypto.sha256().digest(blockImpl.bytes());
        BlockImpl blockImpl2 = new BlockImpl(this.getBlockVersion(blockImpl.getHeight()), n, blockImpl.getId(), l, (byte[])object3, (byte[])object22, (byte[])object, byArray, arrayList, string);
        try {
            this.pushBlock(blockImpl2);
            this.blockListeners.notify(blockImpl2, BlockchainProcessor.Event.BLOCK_GENERATED);
            Logger.logDebugMessage(String.format("Account %s generated block %s at height %d timestamp %d fee %f %s", Long.toUnsignedString(blockImpl2.getGeneratorId()), blockImpl2.getStringId(), blockImpl2.getHeight(), blockImpl2.getTimestamp(), Float.valueOf((float)blockImpl2.getTotalFeeFQT() / 1.0E8f), "ARDR"));
        }
        catch (BlockchainProcessor.TransactionNotAcceptedException blockNotAcceptedException) {
            Logger.logDebugMessage("Generate block failed: " + blockNotAcceptedException.getMessage());
            TransactionProcessorImpl.getInstance().processWaitingTransactions();
            TransactionImpl transactionImpl = blockNotAcceptedException.getTransaction();
            Logger.logDebugMessage("Removing invalid transaction: " + transactionImpl.getStringId());
            this.blockchain.writeLock();
            try {
                TransactionProcessorImpl.getInstance().removeUnconfirmedTransaction(transactionImpl);
            }
            finally {
                this.blockchain.writeUnlock();
            }
            throw blockNotAcceptedException;
        }
        catch (BlockchainProcessor.BlockNotAcceptedException blockNotAcceptedException) {
            Logger.logDebugMessage("Generate block failed: " + blockNotAcceptedException.getMessage());
            throw blockNotAcceptedException;
        }
    }

    public void scheduleScan(int n, boolean bl) {
        try (Connection connection = Db.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("UPDATE scan SET rescan = TRUE, height = ?, validate = ?");){
            preparedStatement.setInt(1, n);
            preparedStatement.setBoolean(2, bl);
            preparedStatement.executeUpdate();
            Logger.logDebugMessage("Scheduled scan starting from height " + n + (bl ? ", with validation" : ""));
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    @Override
    public void scan(int n, boolean bl) {
        this.scan(n, bl, false);
    }

    @Override
    public void fullScanWithShutdown() {
        this.scan(0, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scan(int n, boolean bl, boolean bl2) {
        this.blockchain.writeLock();
        try {
            if (!Db.db.isInTransaction()) {
                try {
                    Db.db.beginTransaction();
                    if (bl) {
                        this.blockListeners.addListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_SCANNED);
                    }
                    this.scan(n, bl, bl2);
                    Db.db.commitTransaction();
                    return;
                }
                catch (Exception exception) {
                    Db.db.rollbackTransaction();
                    throw exception;
                }
                finally {
                    Db.db.endTransaction();
                    this.blockListeners.removeListener(this.checksumListener, BlockchainProcessor.Event.BLOCK_SCANNED);
                }
            }
            this.scheduleScan(n, bl);
            if (n > 0 && n < this.getMinRollbackHeight()) {
                Logger.logMessage("Rollback to height less than " + this.getMinRollbackHeight() + " not supported, will do a full scan");
                n = 0;
            }
            if (n < 0) {
                n = 0;
            }
            Logger.logMessage("Scanning blockchain starting from height " + n + "...");
            if (bl) {
                Logger.logDebugMessage("Also verifying signatures and validating transactions...");
            }
            try (Connection connection = Db.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM block WHERE " + (n > 0 ? "height >= ? AND " : "") + " db_id >= ? ORDER BY db_id ASC LIMIT 50000");
                 PreparedStatement preparedStatement2 = connection.prepareStatement("UPDATE scan SET rescan = FALSE, height = 0, validate = FALSE");){
                this.isScanning = true;
                this.initialScanHeight = this.blockchain.getHeight();
                if (n > this.blockchain.getHeight() + 1) {
                    Logger.logMessage("Rollback height " + (n - 1) + " exceeds current blockchain height of " + this.blockchain.getHeight() + ", no scan needed");
                    preparedStatement2.executeUpdate();
                    Db.db.commitTransaction();
                    return;
                }
                if (n == 0) {
                    Logger.logDebugMessage("Dropping all full text search indexes");
                    FullTextTrigger.dropAll(connection);
                    this.lastTrimHeight = 0;
                }
                for (DerivedDbTable derivedDbTable : this.derivedTables) {
                    if (n == 0) {
                        derivedDbTable.truncate();
                        continue;
                    }
                    derivedDbTable.rollback(n - 1);
                }
                Db.db.clearCache();
                Db.db.commitTransaction();
                Logger.logDebugMessage("Rolled back derived tables");
                Object object = BlockDb.findBlockAtHeight(n);
                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.RESCAN_BEGIN);
                long l = ((BlockImpl)object).getId();
                if (n == 0) {
                    this.blockchain.setLastBlock((BlockImpl)object);
                    byte[] byArray = Genesis.apply();
                    if (!Arrays.equals(byArray, ((BlockImpl)object).getGenerationSignature())) {
                        throw new RuntimeException("Invalid generation signature ");
                    }
                } else {
                    this.blockchain.setLastBlock(BlockDb.findBlockAtHeight(n - 1));
                }
                if (bl2) {
                    Logger.logMessage("Scan will be performed at next start");
                    new Thread(() -> System.exit(0)).start();
                    return;
                }
                int n2 = 1;
                if (n > 0) {
                    preparedStatement.setInt(n2++, n);
                }
                long l2 = Long.MIN_VALUE;
                boolean bl3 = true;
                block78: while (bl3) {
                    bl3 = false;
                    preparedStatement.setLong(n2, l2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    Throwable throwable = null;
                    try {
                        while (resultSet.next()) {
                            Object object2;
                            try {
                                l2 = resultSet.getLong("db_id");
                                object = BlockDb.loadBlock(connection, resultSet, true);
                                if (((BlockImpl)object).getHeight() > 0) {
                                    ((BlockImpl)object).loadTransactions();
                                    if (((BlockImpl)object).getId() != l) throw new NxtException.NotValidException("Database blocks in the wrong order!");
                                    if (((BlockImpl)object).getHeight() > this.blockchain.getHeight() + 1) {
                                        throw new NxtException.NotValidException("Database blocks in the wrong order!");
                                    }
                                    int n3 = Nxt.getEpochTime();
                                    object2 = new HashMap();
                                    ArrayList<ChildTransactionImpl> arrayList = new ArrayList<ChildTransactionImpl>();
                                    ArrayList<ChildTransactionImpl> arrayList2 = new ArrayList<ChildTransactionImpl>();
                                    this.validatePhasedTransactions(this.blockchain.getHeight(), arrayList, arrayList2, (Map<TransactionType, Map<String, Integer>>)object2);
                                    this.validateTransactions((BlockImpl)object, this.blockchain.getLastBlock(), n3, (Map<TransactionType, Map<String, Integer>>)object2, bl);
                                    if (bl) {
                                        this.validate((BlockImpl)object, this.blockchain.getLastBlock(), n3);
                                        byte[] byArray = ((BlockImpl)object).bytes();
                                        if (!Arrays.equals(byArray, BlockImpl.parseBlock(byArray, ((BlockImpl)object).getFxtTransactions()).bytes())) {
                                            throw new NxtException.NotValidException("Block bytes cannot be parsed back to the same block");
                                        }
                                        ArrayList<TransactionImpl> arrayList3 = new ArrayList<TransactionImpl>();
                                        for (FxtTransactionImpl fxtTransactionImpl : ((BlockImpl)object).getFxtTransactions()) {
                                            arrayList3.add(fxtTransactionImpl);
                                            arrayList3.addAll(fxtTransactionImpl.getSortedChildTransactions());
                                        }
                                        for (TransactionImpl transactionImpl : arrayList3) {
                                            byte[] byArray2 = transactionImpl.bytes();
                                            if (!Arrays.equals(byArray2, TransactionImpl.newTransactionBuilder(byArray2).build().bytes())) {
                                                throw new NxtException.NotValidException("Transaction bytes cannot be parsed back to the same transaction: " + JSON.toJSONString((JSONAware)transactionImpl.getJSONObject()));
                                            }
                                            JSONObject jSONObject = (JSONObject)JSONValue.parse((String)JSON.toJSONString((JSONAware)transactionImpl.getJSONObject()));
                                            if (Arrays.equals(byArray2, TransactionImpl.newTransactionBuilder(jSONObject).build().bytes())) continue;
                                            throw new NxtException.NotValidException("Transaction JSON cannot be parsed back to the same transaction: " + JSON.toJSONString((JSONAware)transactionImpl.getJSONObject()));
                                        }
                                    }
                                    this.blockListeners.notify((Block)object, BlockchainProcessor.Event.BEFORE_BLOCK_ACCEPT);
                                    this.blockchain.setLastBlock((BlockImpl)object);
                                    this.accept((BlockImpl)object, arrayList, arrayList2, (Map<TransactionType, Map<String, Integer>>)object2);
                                    Db.db.clearCache();
                                    Db.db.commitTransaction();
                                    this.blockListeners.notify((Block)object, BlockchainProcessor.Event.AFTER_BLOCK_ACCEPT);
                                }
                                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.BLOCK_SCANNED);
                                bl3 = true;
                                l = ((BlockImpl)object).getNextBlockId();
                            }
                            catch (RuntimeException | NxtException exception) {
                                Db.db.rollbackTransaction();
                                Logger.logDebugMessage(exception.toString(), exception);
                                Logger.logDebugMessage("Applying block " + Long.toUnsignedString(l) + " at height " + ((BlockImpl)object).getHeight() + " failed, deleting from database");
                                object2 = BlockDb.deleteBlocksFrom(l);
                                this.blockchain.setLastBlock((BlockImpl)object2);
                                this.popOffTo((Block)object2);
                                if (resultSet == null) break block78;
                                if (throwable != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block78;
                                }
                                resultSet.close();
                                break block78;
                            }
                        }
                        ++l2;
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                }
                if (n == 0) {
                    for (DerivedDbTable derivedDbTable : this.derivedTables) {
                        derivedDbTable.createSearchIndex(connection);
                    }
                }
                preparedStatement2.executeUpdate();
                Db.db.commitTransaction();
                this.blockListeners.notify((Block)object, BlockchainProcessor.Event.RESCAN_END);
                Logger.logMessage("...done at height " + this.blockchain.getHeight());
                if (n == 0 && bl) {
                    Logger.logMessage("SUCCESSFULLY PERFORMED FULL RESCAN WITH VALIDATION");
                }
                this.lastRestoreTime = 0;
                return;
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
            finally {
                this.isScanning = false;
            }
        }
        finally {
            this.blockchain.writeUnlock();
        }
    }

    static {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        byte[] byArray4;
        byte[] byArray5;
        TreeMap<Integer, byte[]> treeMap = new TreeMap<Integer, byte[]>();
        treeMap.put(0, null);
        Integer n = Constants.CHECKSUM_BLOCK_1;
        if (Constants.isTestnet) {
            byte[] byArray6 = new byte[32];
            byArray6[0] = 91;
            byArray6[1] = 30;
            byArray6[2] = -58;
            byArray6[3] = 23;
            byArray6[4] = 95;
            byArray6[5] = -59;
            byArray6[6] = -78;
            byArray6[7] = 22;
            byArray6[8] = -13;
            byArray6[9] = 31;
            byArray6[10] = -16;
            byArray6[11] = 102;
            byArray6[12] = 79;
            byArray6[13] = -87;
            byArray6[14] = 83;
            byArray6[15] = 64;
            byArray6[16] = 27;
            byArray6[17] = 97;
            byArray6[18] = -67;
            byArray6[19] = -32;
            byArray6[20] = -96;
            byArray6[21] = 109;
            byArray6[22] = 103;
            byArray6[23] = 35;
            byArray6[24] = -87;
            byArray6[25] = 35;
            byArray6[26] = -16;
            byArray6[27] = -119;
            byArray6[28] = -25;
            byArray6[29] = 72;
            byArray6[30] = -128;
            byArray5 = byArray6;
            byArray6[31] = 18;
        } else {
            byte[] byArray7 = new byte[32];
            byArray7[0] = 58;
            byArray7[1] = -59;
            byArray7[2] = 105;
            byArray7[3] = -15;
            byArray7[4] = 37;
            byArray7[5] = -75;
            byArray7[6] = 102;
            byArray7[7] = 83;
            byArray7[8] = -11;
            byArray7[9] = 89;
            byArray7[10] = 67;
            byArray7[11] = 44;
            byArray7[12] = 92;
            byArray7[13] = -70;
            byArray7[14] = -82;
            byArray7[15] = 123;
            byArray7[16] = 83;
            byArray7[17] = 76;
            byArray7[18] = 44;
            byArray7[19] = 39;
            byArray7[20] = -41;
            byArray7[21] = 14;
            byArray7[22] = -17;
            byArray7[23] = 85;
            byArray7[24] = -80;
            byArray7[25] = 2;
            byArray7[26] = -67;
            byArray7[27] = -19;
            byArray7[28] = 28;
            byArray7[29] = -66;
            byArray7[30] = -2;
            byArray5 = byArray7;
            byArray7[31] = -7;
        }
        treeMap.put(n, byArray5);
        Integer n2 = Constants.CHECKSUM_BLOCK_2;
        if (Constants.isTestnet) {
            byte[] byArray8 = new byte[32];
            byArray8[0] = 65;
            byArray8[1] = -59;
            byArray8[2] = 8;
            byArray8[3] = -10;
            byArray8[4] = 76;
            byArray8[5] = 62;
            byArray8[6] = 69;
            byArray8[7] = -65;
            byArray8[8] = -19;
            byArray8[9] = 4;
            byArray8[10] = 107;
            byArray8[11] = 109;
            byArray8[12] = 5;
            byArray8[13] = 79;
            byArray8[14] = 5;
            byArray8[15] = 90;
            byArray8[16] = 45;
            byArray8[17] = -45;
            byArray8[18] = 2;
            byArray8[19] = 23;
            byArray8[20] = -74;
            byArray8[21] = -92;
            byArray8[22] = 90;
            byArray8[23] = 18;
            byArray8[24] = 52;
            byArray8[25] = -31;
            byArray8[26] = -15;
            byArray8[27] = 1;
            byArray8[28] = 40;
            byArray8[29] = -124;
            byArray8[30] = 6;
            byArray4 = byArray8;
            byArray8[31] = -124;
        } else {
            byte[] byArray9 = new byte[32];
            byArray9[0] = -63;
            byArray9[1] = 125;
            byArray9[2] = 46;
            byArray9[3] = -107;
            byArray9[4] = 86;
            byArray9[5] = -81;
            byArray9[6] = -17;
            byArray9[7] = -44;
            byArray9[8] = 50;
            byArray9[9] = -90;
            byArray9[10] = -51;
            byArray9[11] = 78;
            byArray9[12] = -10;
            byArray9[13] = -41;
            byArray9[14] = -104;
            byArray9[15] = -32;
            byArray9[16] = 96;
            byArray9[17] = 0;
            byArray9[18] = 2;
            byArray9[19] = -76;
            byArray9[20] = 3;
            byArray9[21] = 82;
            byArray9[22] = -69;
            byArray9[23] = -62;
            byArray9[24] = 112;
            byArray9[25] = 98;
            byArray9[26] = -107;
            byArray9[27] = 83;
            byArray9[28] = 25;
            byArray9[29] = -123;
            byArray9[30] = -119;
            byArray4 = byArray9;
            byArray9[31] = -78;
        }
        treeMap.put(n2, byArray4);
        Integer n3 = Constants.CHECKSUM_BLOCK_3;
        if (Constants.isTestnet) {
            byte[] byArray10 = new byte[32];
            byArray10[0] = -7;
            byArray10[1] = -58;
            byArray10[2] = 83;
            byArray10[3] = 26;
            byArray10[4] = 80;
            byArray10[5] = 57;
            byArray10[6] = 38;
            byArray10[7] = -8;
            byArray10[8] = -73;
            byArray10[9] = 16;
            byArray10[10] = -35;
            byArray10[11] = 56;
            byArray10[12] = -33;
            byArray10[13] = 0;
            byArray10[14] = -18;
            byArray10[15] = -21;
            byArray10[16] = 11;
            byArray10[17] = -80;
            byArray10[18] = -6;
            byArray10[19] = -58;
            byArray10[20] = -83;
            byArray10[21] = -2;
            byArray10[22] = 22;
            byArray10[23] = -82;
            byArray10[24] = 70;
            byArray10[25] = 61;
            byArray10[26] = 81;
            byArray10[27] = -34;
            byArray10[28] = 22;
            byArray10[29] = -114;
            byArray10[30] = 41;
            byArray3 = byArray10;
            byArray10[31] = 104;
        } else {
            byte[] byArray11 = new byte[32];
            byArray11[0] = 66;
            byArray11[1] = 95;
            byArray11[2] = 48;
            byArray11[3] = 11;
            byArray11[4] = 62;
            byArray11[5] = 26;
            byArray11[6] = -44;
            byArray11[7] = -98;
            byArray11[8] = -114;
            byArray11[9] = 66;
            byArray11[10] = 3;
            byArray11[11] = 13;
            byArray11[12] = -84;
            byArray11[13] = 88;
            byArray11[14] = -67;
            byArray11[15] = 71;
            byArray11[16] = -23;
            byArray11[17] = -46;
            byArray11[18] = -120;
            byArray11[19] = -19;
            byArray11[20] = 98;
            byArray11[21] = 23;
            byArray11[22] = 81;
            byArray11[23] = -22;
            byArray11[24] = 37;
            byArray11[25] = 122;
            byArray11[26] = -113;
            byArray11[27] = 9;
            byArray11[28] = -103;
            byArray11[29] = 55;
            byArray11[30] = -126;
            byArray3 = byArray11;
            byArray11[31] = -77;
        }
        treeMap.put(n3, byArray3);
        Integer n4 = Constants.CHECKSUM_BLOCK_4;
        if (Constants.isTestnet) {
            byte[] byArray12 = new byte[32];
            byArray12[0] = 110;
            byArray12[1] = -17;
            byArray12[2] = -104;
            byArray12[3] = 34;
            byArray12[4] = 42;
            byArray12[5] = 12;
            byArray12[6] = 109;
            byArray12[7] = -97;
            byArray12[8] = 58;
            byArray12[9] = 6;
            byArray12[10] = -122;
            byArray12[11] = 114;
            byArray12[12] = 16;
            byArray12[13] = 14;
            byArray12[14] = -97;
            byArray12[15] = -107;
            byArray12[16] = -46;
            byArray12[17] = 72;
            byArray12[18] = 54;
            byArray12[19] = 44;
            byArray12[20] = 11;
            byArray12[21] = -63;
            byArray12[22] = 8;
            byArray12[23] = 74;
            byArray12[24] = 113;
            byArray12[25] = -60;
            byArray12[26] = -26;
            byArray12[27] = 63;
            byArray12[28] = -32;
            byArray12[29] = -108;
            byArray12[30] = -101;
            byArray2 = byArray12;
            byArray12[31] = -103;
        } else {
            byte[] byArray13 = new byte[32];
            byArray13[0] = 124;
            byArray13[1] = -116;
            byArray13[2] = -24;
            byArray13[3] = 26;
            byArray13[4] = -123;
            byArray13[5] = 86;
            byArray13[6] = 36;
            byArray13[7] = 38;
            byArray13[8] = 119;
            byArray13[9] = -125;
            byArray13[10] = 87;
            byArray13[11] = 52;
            byArray13[12] = -51;
            byArray13[13] = -28;
            byArray13[14] = 63;
            byArray13[15] = -97;
            byArray13[16] = -64;
            byArray13[17] = -86;
            byArray13[18] = 9;
            byArray13[19] = 7;
            byArray13[20] = 125;
            byArray13[21] = -6;
            byArray13[22] = -112;
            byArray13[23] = 118;
            byArray13[24] = 120;
            byArray13[25] = -5;
            byArray13[26] = -50;
            byArray13[27] = 111;
            byArray13[28] = -35;
            byArray13[29] = -88;
            byArray13[30] = -68;
            byArray2 = byArray13;
            byArray13[31] = -46;
        }
        treeMap.put(n4, byArray2);
        Integer n5 = Constants.CHECKSUM_BLOCK_5;
        if (Constants.isTestnet) {
            byte[] byArray14 = new byte[32];
            byArray14[0] = 17;
            byArray14[1] = 100;
            byArray14[2] = -128;
            byArray14[3] = 7;
            byArray14[4] = 55;
            byArray14[5] = -78;
            byArray14[6] = -101;
            byArray14[7] = 54;
            byArray14[8] = 52;
            byArray14[9] = -13;
            byArray14[10] = 82;
            byArray14[11] = -126;
            byArray14[12] = 39;
            byArray14[13] = -110;
            byArray14[14] = 82;
            byArray14[15] = -100;
            byArray14[16] = -43;
            byArray14[17] = -14;
            byArray14[18] = -98;
            byArray14[19] = -108;
            byArray14[20] = -82;
            byArray14[21] = 12;
            byArray14[22] = 94;
            byArray14[23] = 28;
            byArray14[24] = -120;
            byArray14[25] = -74;
            byArray14[26] = -48;
            byArray14[27] = 82;
            byArray14[28] = 115;
            byArray14[29] = -77;
            byArray14[30] = 42;
            byArray = byArray14;
            byArray14[31] = -52;
        } else {
            byte[] byArray15 = new byte[32];
            byArray15[0] = 126;
            byArray15[1] = -110;
            byArray15[2] = 56;
            byArray15[3] = -35;
            byArray15[4] = 87;
            byArray15[5] = 2;
            byArray15[6] = 55;
            byArray15[7] = 29;
            byArray15[8] = -113;
            byArray15[9] = 35;
            byArray15[10] = -11;
            byArray15[11] = 112;
            byArray15[12] = -90;
            byArray15[13] = 36;
            byArray15[14] = 107;
            byArray15[15] = 53;
            byArray15[16] = 3;
            byArray15[17] = 126;
            byArray15[18] = -10;
            byArray15[19] = 94;
            byArray15[20] = 23;
            byArray15[21] = 117;
            byArray15[22] = 69;
            byArray15[23] = 67;
            byArray15[24] = 79;
            byArray15[25] = 52;
            byArray15[26] = -117;
            byArray15[27] = -45;
            byArray15[28] = 56;
            byArray15[29] = 15;
            byArray15[30] = 48;
            byArray = byArray15;
            byArray15[31] = -78;
        }
        treeMap.put(n5, byArray);
        checksums = Collections.unmodifiableNavigableMap(treeMap);
        instance = new BlockchainProcessorImpl();
        blockchainPermission = new BlockchainPermission("getBlockchainProcessor");
        transactionArrivalComparator = Comparator.comparingLong(UnconfirmedTransaction::getArrivalTimestamp).thenComparingInt(UnconfirmedTransaction::getHeight).thenComparingLong(UnconfirmedTransaction::getId);
    }

    private class RestorePrunableDataTask
    implements Runnable {
        private RestorePrunableDataTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = null;
            try {
                HashSet hashSet;
                Object object2;
                List<Peer> list = Peers.getPeers(peer -> peer.providesService(Peer.Service.PRUNABLE) && !peer.isBlacklisted() && (peer.getState() == Peer.State.CONNECTED || peer.getAnnouncedAddress() != null && peer.shareAddress()));
                while (!list.isEmpty()) {
                    if (!Peers.isNetworkingEnabled()) {
                        return;
                    }
                    int n = ThreadLocalRandom.current().nextInt(list.size());
                    object2 = list.get(n);
                    if (object2.getState() != Peer.State.CONNECTED) {
                        object2.connectPeer();
                    }
                    if (object2.getState() == Peer.State.CONNECTED) {
                        object = object2;
                        break;
                    }
                    list.remove(n);
                }
                if (object == null) {
                    Logger.logDebugMessage("Cannot find any archive peers");
                    return;
                }
                Logger.logDebugMessage("Connected to archive peer " + object.getHost());
                object2 = BlockchainProcessorImpl.this.prunableTransactions;
                synchronized (object2) {
                    hashSet = new HashSet(BlockchainProcessorImpl.this.prunableTransactions.size());
                    hashSet.addAll(BlockchainProcessorImpl.this.prunableTransactions);
                }
                Logger.logDebugMessage("Need to restore " + hashSet.size() + " pruned data");
                while (!hashSet.isEmpty()) {
                    List<Transaction> list2;
                    if (!Peers.isNetworkingEnabled()) {
                        Logger.logDebugMessage("Peers networking was disabled while retrieving prunable data");
                        return;
                    }
                    object2 = new ArrayList<ChainTransactionId>(100);
                    Object object3 = BlockchainProcessorImpl.this.prunableTransactions;
                    synchronized (object3) {
                        list2 = hashSet.iterator();
                        while (list2.hasNext()) {
                            object2.add(list2.next());
                            list2.remove();
                            if (object2.size() != 100) continue;
                        }
                    }
                    object3 = (NetworkMessage.TransactionsMessage)object.sendRequest(new NetworkMessage.GetTransactionsMessage((List<ChainTransactionId>)object2));
                    if (object3 == null) {
                        return;
                    }
                    list2 = ((NetworkMessage.TransactionsMessage)object3).getTransactions();
                    if (list2.isEmpty()) {
                        return;
                    }
                    List<Transaction> list3 = Nxt.getTransactionProcessor().restorePrunableData(list2);
                    Set set = BlockchainProcessorImpl.this.prunableTransactions;
                    synchronized (set) {
                        list3.forEach(transaction -> BlockchainProcessorImpl.this.prunableTransactions.remove(ChainTransactionId.getChainTransactionId(transaction)));
                    }
                }
                Logger.logDebugMessage("Done retrieving prunable transactions from " + object.getHost());
            }
            catch (NxtException.NotValidException notValidException) {
                Logger.logErrorMessage("Peer " + object.getHost() + " returned invalid prunable transaction", notValidException);
                object.blacklist(notValidException);
            }
            catch (RuntimeException runtimeException) {
                Logger.logErrorMessage("Unable to restore prunable data", runtimeException);
            }
            finally {
                BlockchainProcessorImpl.this.isRestoring = false;
                Logger.logDebugMessage("Remaining " + BlockchainProcessorImpl.this.prunableTransactions.size() + " pruned transactions");
            }
        }
    }

    private static class PeerBlock {
        private final Peer peer;
        private final BlockImpl block;

        PeerBlock(Peer peer, BlockImpl blockImpl) {
            this.peer = peer;
            this.block = blockImpl;
        }

        public Peer getPeer() {
            return this.peer;
        }

        public BlockImpl getBlock() {
            return this.block;
        }
    }

    private static class GetNextBlocks
    implements Callable<List<Block>> {
        private Future<List<Block>> future;
        private Peer peer;
        private final List<Long> blockIds;
        private int start;
        private final int stop;
        private int failedRequestCount;
        private long responseTime;

        GetNextBlocks(List<Long> list, int n, int n2) {
            this.blockIds = list;
            this.start = n;
            this.stop = n2;
            this.failedRequestCount = 0;
        }

        @Override
        public List<Block> call() {
            ArrayList<Long> arrayList = new ArrayList<Long>(this.stop - this.start);
            for (int i = this.start + 1; i <= this.stop; ++i) {
                arrayList.add(this.blockIds.get(i));
            }
            long l = System.currentTimeMillis();
            NetworkMessage.BlocksMessage blocksMessage = (NetworkMessage.BlocksMessage)this.peer.sendRequest(new NetworkMessage.GetNextBlocksMessage(this.blockIds.get(this.start), arrayList.size(), arrayList));
            this.responseTime = System.currentTimeMillis() - l;
            if (blocksMessage == null || blocksMessage.getBlockCount() == 0) {
                ++this.failedRequestCount;
                return null;
            }
            if (blocksMessage.getBlockCount() > arrayList.size()) {
                Logger.logDebugMessage("Obsolete or rogue peer " + this.peer.getHost() + " sends too many nextBlocks, blacklisting");
                this.peer.blacklist("Too many nextBlocks");
                ++this.failedRequestCount;
                return null;
            }
            try {
                return blocksMessage.getBlocks();
            }
            catch (RuntimeException | NxtException.NotValidException exception) {
                Logger.logDebugMessage("Failed to parse block: " + exception.toString(), exception);
                this.peer.blacklist(exception);
                ++this.failedRequestCount;
                return null;
            }
        }

        public Future<List<Block>> getFuture() {
            return this.future;
        }

        void setFuture(Future<List<Block>> future) {
            this.future = future;
        }

        public Peer getPeer() {
            return this.peer;
        }

        void setPeer(Peer peer) {
            this.peer = peer;
        }

        public int getStart() {
            return this.start;
        }

        void setStart(int n) {
            this.start = n;
        }

        public int getStop() {
            return this.stop;
        }

        public int getFailedRequestCount() {
            return this.failedRequestCount;
        }

        public long getResponseTime() {
            return this.responseTime;
        }
    }
}

