/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountLedger;
import nxt.account.AccountPropertyTransactionType;
import nxt.account.PaymentTransactionType;
import nxt.ae.AssetExchangeTransactionType;
import nxt.aliases.AliasTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildTransactionImpl;
import nxt.blockchain.Fee;
import nxt.blockchain.FxtChain;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.ce.CoinExchangeTransactionType;
import nxt.dgs.DigitalGoodsTransactionType;
import nxt.lightcontracts.LightContractTransactionType;
import nxt.messaging.MessagingTransactionType;
import nxt.ms.MonetarySystemTransactionType;
import nxt.shuffling.ShufflingTransactionType;
import nxt.taggeddata.TaggedDataTransactionType;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.voting.AccountControlTransactionType;
import nxt.voting.VotingTransactionType;

public abstract class ChildTransactionType
extends TransactionType {
    protected static final byte TYPE_PAYMENT = 0;
    protected static final byte TYPE_MESSAGING = 1;
    protected static final byte TYPE_ASSET_EXCHANGE = 2;
    protected static final byte TYPE_DIGITAL_GOODS = 3;
    protected static final byte TYPE_ACCOUNT_CONTROL = 4;
    protected static final byte TYPE_MONETARY_SYSTEM = 5;
    protected static final byte TYPE_DATA = 6;
    protected static final byte TYPE_SHUFFLING = 7;
    protected static final byte TYPE_ALIASES = 8;
    protected static final byte TYPE_VOTING = 9;
    protected static final byte TYPE_ACCOUNT_PROPERTY = 10;
    protected static final byte TYPE_COIN_EXCHANGE = 11;
    protected static final byte TYPE_LIGHT_CONTRACT = 12;

    public static TransactionType findTransactionType(byte by, byte by2) {
        switch (by) {
            case 0: {
                return PaymentTransactionType.findTransactionType(by2);
            }
            case 1: {
                return MessagingTransactionType.findTransactionType(by2);
            }
            case 2: {
                return AssetExchangeTransactionType.findTransactionType(by2);
            }
            case 3: {
                return DigitalGoodsTransactionType.findTransactionType(by2);
            }
            case 4: {
                return AccountControlTransactionType.findTransactionType(by2);
            }
            case 5: {
                return MonetarySystemTransactionType.findTransactionType(by2);
            }
            case 6: {
                return TaggedDataTransactionType.findTransactionType(by2);
            }
            case 7: {
                return ShufflingTransactionType.findTransactionType(by2);
            }
            case 8: {
                return AliasTransactionType.findTransactionType(by2);
            }
            case 9: {
                return VotingTransactionType.findTransactionType(by2);
            }
            case 10: {
                return AccountPropertyTransactionType.findTransactionType(by2);
            }
            case 11: {
                return CoinExchangeTransactionType.findTransactionType(by2);
            }
            case 12: {
                return LightContractTransactionType.findTransactionType(by2);
            }
        }
        return null;
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return Fee.DEFAULT_CHILD_FEE;
    }

    @Override
    public final boolean applyUnconfirmed(TransactionImpl transactionImpl, Account account) {
        ChildChain childChain = (ChildChain)transactionImpl.getChain();
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(transactionImpl);
        long l = transactionImpl.getAmount();
        long l2 = transactionImpl.getFee();
        long l3 = 0L;
        if (((ChildTransactionImpl)transactionImpl).getReferencedTransactionId() != null) {
            if (FxtChain.FXT.getBalanceHome().getBalance(account.getId()).getUnconfirmedBalance() < 1000000000L) {
                Logger.logInfoMessage("account %s must have enough %s to pay the unconfirmed pool deposit", Convert.rsAccount(account.getId()), "ARDR");
                return false;
            }
            l3 = 1000000000L;
            account.addToUnconfirmedBalance(FxtChain.FXT, this.getLedgerEvent(), ledgerEventId, 0L, -l3);
        }
        long l4 = Math.addExact(l, l2);
        if (childChain.getBalanceHome().getBalance(account.getId()).getUnconfirmedBalance() < l4) {
            account.addToUnconfirmedBalance(FxtChain.FXT, this.getLedgerEvent(), ledgerEventId, 0L, l3);
            return false;
        }
        account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, -l, -l2);
        if (!this.applyAttachmentUnconfirmed(transactionImpl, account)) {
            account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, l, l2);
            account.addToUnconfirmedBalance(FxtChain.FXT, this.getLedgerEvent(), ledgerEventId, 0L, l3);
            return false;
        }
        return true;
    }

    @Override
    public final void apply(TransactionImpl transactionImpl, Account account, Account account2) {
        ChildChain childChain = (ChildChain)transactionImpl.getChain();
        long l = transactionImpl.getAmount();
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(transactionImpl);
        if (!transactionImpl.attachmentIsPhased()) {
            account.addToBalance(childChain, this.getLedgerEvent(), ledgerEventId, -l, -transactionImpl.getFee());
        } else {
            account.addToBalance(childChain, this.getLedgerEvent(), ledgerEventId, -l);
        }
        if (account2 != null) {
            account2.addToBalanceAndUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, l);
        }
        this.applyAttachment(transactionImpl, account, account2);
    }

    @Override
    public final void undoUnconfirmed(TransactionImpl transactionImpl, Account account) {
        ChildChain childChain = (ChildChain)transactionImpl.getChain();
        this.undoAttachmentUnconfirmed(transactionImpl, account);
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(transactionImpl);
        account.addToUnconfirmedBalance(childChain, this.getLedgerEvent(), ledgerEventId, transactionImpl.getAmount(), transactionImpl.getFee());
        if (((ChildTransactionImpl)transactionImpl).getReferencedTransactionId() != null) {
            account.addToUnconfirmedBalance(FxtChain.FXT, this.getLedgerEvent(), ledgerEventId, 0L, 1000000000L);
        }
    }

    @Override
    public final void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
        this.validateAttachment((ChildTransactionImpl)transaction);
    }

    protected abstract void validateAttachment(ChildTransactionImpl var1) throws NxtException.ValidationException;

    @Override
    public final boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
        return this.applyAttachmentUnconfirmed((ChildTransactionImpl)transaction, account);
    }

    protected abstract boolean applyAttachmentUnconfirmed(ChildTransactionImpl var1, Account var2);

    @Override
    public final void applyAttachment(Transaction transaction, Account account, Account account2) {
        this.applyAttachment((ChildTransactionImpl)transaction, account, account2);
    }

    protected abstract void applyAttachment(ChildTransactionImpl var1, Account var2, Account var3);

    @Override
    public final void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        this.undoAttachmentUnconfirmed((ChildTransactionImpl)transaction, account);
    }

    protected abstract void undoAttachmentUnconfirmed(ChildTransactionImpl var1, Account var2);

    @Override
    protected final void validateId(Transaction transaction) throws NxtException.ValidationException {
        this.validateId((ChildTransactionImpl)transaction);
    }

    protected void validateId(ChildTransactionImpl childTransactionImpl) throws NxtException.NotCurrentlyValidException {
    }
}

