/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import nxt.Constants;
import nxt.NxtException;
import nxt.blockchain.Appendix;
import nxt.blockchain.Attachment;
import nxt.blockchain.Chain;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.blockchain.UnconfirmedFxtTransaction;
import nxt.blockchain.UnconfirmedTransaction;
import nxt.http.APIEnum;
import nxt.http.APITag;
import org.json.simple.JSONObject;

public final class FxtChain
extends Chain {
    public static final String FXT_NAME = "ARDR";
    public static final FxtChain FXT = new FxtChain();

    public static void init() {
    }

    private FxtChain() {
        super(1, FXT_NAME, 8, Constants.isTestnet ? 99949858899030000L : 99846623125660000L, EnumSet.of(APIEnum.SEND_MESSAGE), EnumSet.of(APITag.ALIASES, new APITag[]{APITag.AE, APITag.DGS, APITag.DATA, APITag.MS, APITag.SHUFFLING, APITag.VS}));
    }

    @Override
    public String getDbSchema() {
        return "PUBLIC";
    }

    @Override
    public boolean isAllowed(TransactionType transactionType) {
        return transactionType.getType() < 0;
    }

    @Override
    public Set<TransactionType> getDisabledTransactionTypes() {
        return Collections.emptySet();
    }

    @Override
    public FxtTransactionImpl.BuilderImpl newTransactionBuilder(byte[] byArray, long l, long l2, short s, Attachment attachment) {
        return FxtTransactionImpl.newTransactionBuilder((byte)1, byArray, l, l2, s, (Attachment.AbstractAttachment)attachment);
    }

    @Override
    FxtTransactionImpl.BuilderImpl newTransactionBuilder(byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list, JSONObject jSONObject) {
        return FxtTransactionImpl.newTransactionBuilder(by, byArray, l, l2, s, list, jSONObject);
    }

    @Override
    FxtTransactionImpl.BuilderImpl newTransactionBuilder(byte by, byte[] byArray, long l, long l2, short s, List<Appendix.AbstractAppendix> list, ByteBuffer byteBuffer) {
        return FxtTransactionImpl.newTransactionBuilder(by, byArray, l, l2, s, list, byteBuffer);
    }

    @Override
    FxtTransactionImpl.BuilderImpl newTransactionBuilder(byte by, long l, long l2, short s, List<Appendix.AbstractAppendix> list, ResultSet resultSet) {
        return FxtTransactionImpl.newTransactionBuilder(by, l, l2, s, list, resultSet);
    }

    @Override
    UnconfirmedTransaction newUnconfirmedTransaction(ResultSet resultSet) throws SQLException, NxtException.NotValidException {
        return new UnconfirmedFxtTransaction(resultSet);
    }
}

