/*
 * Decompiled with CFR 0.152.
 */
package nxt.blockchain;

import nxt.NxtException;
import nxt.account.Account;
import nxt.account.AccountControlFxtTransactionType;
import nxt.account.AccountLedger;
import nxt.account.PaymentFxtTransactionType;
import nxt.blockchain.ChildBlockFxtTransactionType;
import nxt.blockchain.Fee;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransactionImpl;
import nxt.blockchain.Transaction;
import nxt.blockchain.TransactionImpl;
import nxt.blockchain.TransactionType;
import nxt.ce.CoinExchangeFxtTransactionType;

public abstract class FxtTransactionType
extends TransactionType {
    protected static final byte TYPE_CHILDCHAIN_BLOCK = -1;
    protected static final byte TYPE_PAYMENT = -2;
    protected static final byte TYPE_ACCOUNT_CONTROL = -3;
    protected static final byte TYPE_COIN_EXCHANGE = -4;
    protected static final byte SUBTYPE_CHILDCHAIN_BLOCK = 0;
    protected static final byte SUBTYPE_PAYMENT_ORDINARY_PAYMENT = 0;
    protected static final byte SUBTYPE_ACCOUNT_CONTROL_EFFECTIVE_BALANCE_LEASING = 0;

    public static TransactionType findTransactionType(byte by, byte by2) {
        switch (by) {
            case -1: {
                switch (by2) {
                    case 0: {
                        return ChildBlockFxtTransactionType.INSTANCE;
                    }
                }
                return null;
            }
            case -2: {
                switch (by2) {
                    case 0: {
                        return PaymentFxtTransactionType.ORDINARY;
                    }
                }
                return null;
            }
            case -3: {
                switch (by2) {
                    case 0: {
                        return AccountControlFxtTransactionType.EFFECTIVE_BALANCE_LEASING;
                    }
                }
                return null;
            }
            case -4: {
                return CoinExchangeFxtTransactionType.findTransactionType(by2);
            }
        }
        return null;
    }

    @Override
    public Fee getBaselineFee(Transaction transaction) {
        return Fee.DEFAULT_FXT_FEE;
    }

    @Override
    public final boolean applyUnconfirmed(TransactionImpl transactionImpl, Account account) {
        long l = transactionImpl.getAmount();
        long l2 = transactionImpl.getFee();
        long l3 = Math.addExact(l, l2);
        if (FxtChain.FXT.getBalanceHome().getBalance(account.getId()).getUnconfirmedBalance() < l3) {
            return false;
        }
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(transactionImpl);
        account.addToUnconfirmedBalance(FxtChain.FXT, this.getLedgerEvent(), ledgerEventId, -l, -l2);
        if (!this.applyAttachmentUnconfirmed(transactionImpl, account)) {
            account.addToUnconfirmedBalance(FxtChain.FXT, this.getLedgerEvent(), ledgerEventId, l, l2);
            return false;
        }
        return true;
    }

    @Override
    public final void apply(TransactionImpl transactionImpl, Account account, Account account2) {
        long l = transactionImpl.getAmount();
        AccountLedger.LedgerEventId ledgerEventId = AccountLedger.newEventId(transactionImpl);
        account.addToBalance(FxtChain.FXT, this.getLedgerEvent(), ledgerEventId, -l, -transactionImpl.getFee());
        if (account2 != null) {
            account2.addToBalanceAndUnconfirmedBalance(FxtChain.FXT, this.getLedgerEvent(), ledgerEventId, l);
        }
        this.applyAttachment(transactionImpl, account, account2);
    }

    @Override
    public final void undoUnconfirmed(TransactionImpl transactionImpl, Account account) {
        this.undoAttachmentUnconfirmed(transactionImpl, account);
        account.addToUnconfirmedBalance(FxtChain.FXT, this.getLedgerEvent(), AccountLedger.newEventId(transactionImpl), transactionImpl.getAmount(), transactionImpl.getFee());
    }

    @Override
    public final void validateAttachment(Transaction transaction) throws NxtException.ValidationException {
        this.validateAttachment((FxtTransactionImpl)transaction);
    }

    protected abstract void validateAttachment(FxtTransactionImpl var1) throws NxtException.ValidationException;

    @Override
    protected void validateId(Transaction transaction) throws NxtException.ValidationException {
        this.validateId((FxtTransactionImpl)transaction);
    }

    protected void validateId(FxtTransactionImpl fxtTransactionImpl) throws NxtException.ValidationException {
    }

    @Override
    public final boolean applyAttachmentUnconfirmed(Transaction transaction, Account account) {
        return this.applyAttachmentUnconfirmed((FxtTransactionImpl)transaction, account);
    }

    protected abstract boolean applyAttachmentUnconfirmed(FxtTransactionImpl var1, Account var2);

    @Override
    public final void applyAttachment(Transaction transaction, Account account, Account account2) {
        this.applyAttachment((FxtTransactionImpl)transaction, account, account2);
    }

    protected abstract void applyAttachment(FxtTransactionImpl var1, Account var2, Account var3);

    @Override
    public final void undoAttachmentUnconfirmed(Transaction transaction, Account account) {
        this.undoAttachmentUnconfirmed((FxtTransactionImpl)transaction, account);
    }

    protected abstract void undoAttachmentUnconfirmed(FxtTransactionImpl var1, Account var2);

    @Override
    public final boolean isPhasingSafe() {
        return true;
    }

    @Override
    public final boolean isGlobal() {
        return true;
    }
}

