/*
 * Decompiled with CFR 0.152.
 */
package nxt.ce;

import java.nio.ByteBuffer;
import nxt.NxtException;
import nxt.blockchain.Attachment;
import nxt.blockchain.Chain;
import nxt.blockchain.TransactionType;
import nxt.ce.CoinExchangeTransactionType;
import nxt.util.Convert;
import org.json.simple.JSONObject;

public class OrderIssueAttachment
extends Attachment.AbstractAttachment {
    private final Chain chain;
    private final Chain exchangeChain;
    private final long quantityQNT;
    private final long priceNQT;

    public OrderIssueAttachment(Chain chain, Chain chain2, long l, long l2) {
        this.chain = chain;
        this.exchangeChain = chain2;
        this.quantityQNT = l;
        this.priceNQT = l2;
    }

    OrderIssueAttachment(ByteBuffer byteBuffer) throws NxtException.NotValidException {
        super(byteBuffer);
        int n = byteBuffer.getInt();
        this.chain = Chain.getChain(n);
        if (this.chain == null) {
            throw new NxtException.NotValidException("Chain '" + n + "' not defined");
        }
        n = byteBuffer.getInt();
        this.exchangeChain = Chain.getChain(n);
        if (this.exchangeChain == null) {
            throw new NxtException.NotValidException("Exchange chain '" + n + "' not defined");
        }
        this.quantityQNT = byteBuffer.getLong();
        this.priceNQT = byteBuffer.getLong();
    }

    OrderIssueAttachment(JSONObject jSONObject) throws NxtException.NotValidException {
        super(jSONObject);
        int n = (int)Convert.parseLong(jSONObject.get((Object)"chain"));
        this.chain = Chain.getChain(n);
        if (this.chain == null) {
            throw new NxtException.NotValidException("Chain '" + n + "' not defined");
        }
        n = (int)Convert.parseLong(jSONObject.get((Object)"exchangeChain"));
        this.exchangeChain = Chain.getChain(n);
        if (this.exchangeChain == null) {
            throw new NxtException.NotValidException("Exchange chain '" + n + "' not defined");
        }
        this.quantityQNT = Convert.parseLong(jSONObject.get((Object)"quantityQNT"));
        this.priceNQT = Convert.parseLong(jSONObject.get((Object)"priceNQTPerCoin"));
    }

    @Override
    protected int getMySize() {
        return 24;
    }

    @Override
    protected void putMyBytes(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.chain.getId()).putInt(this.exchangeChain.getId()).putLong(this.quantityQNT).putLong(this.priceNQT);
    }

    @Override
    protected void putMyJSON(JSONObject jSONObject) {
        jSONObject.put((Object)"chain", (Object)this.chain.getId());
        jSONObject.put((Object)"exchangeChain", (Object)this.exchangeChain.getId());
        jSONObject.put((Object)"quantityQNT", (Object)this.quantityQNT);
        jSONObject.put((Object)"priceNQTPerCoin", (Object)this.priceNQT);
    }

    public Chain getChain() {
        return this.chain;
    }

    public Chain getExchangeChain() {
        return this.exchangeChain;
    }

    public long getQuantityQNT() {
        return this.quantityQNT;
    }

    public long getPriceNQT() {
        return this.priceNQT;
    }

    @Override
    public TransactionType getTransactionType() {
        return CoinExchangeTransactionType.ORDER_ISSUE;
    }
}

