/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import nxt.Constants;
import nxt.crypto.Crypto;
import nxt.crypto.SecretShare;
import nxt.crypto.SecretSharing;
import nxt.crypto.SimpleShamirSecretSharing;
import nxt.util.Convert;

public class SecretSharingGenerator {
    private static final int CURRENT_VERSION = 1;
    static final BigInteger PRIME_4096_BIT = new BigInteger("16710222102610440107068043371465990121279427984758140486147735732543262527544919309581228990959960933454241707431028205407801175010972697716211777405621844447135311624699359973445785442150139493030849120189695139622021101430363403930757354949513385879948926539292859265140544779841897745831487644537568464106991023630108604575150490083044175049593271254925175508848427143088944400255558397883427448667101368958164663781091806630951947745404989962231943601603024661584134672986801498693341608816527553412312812319737861910590928243420749213395009469338508019541095885541890008803615972806597516557801530791875113872380904094611929773211709366081401737953645348323163171237010704282848106803127761278746182709924566001996544238514546167359724648214393784828708337709298145449348366148476664877596527269176552273043572304982318495803088033967414331004526063175049856118607130798717168809146278034477061142090096734446658190827333485703051687166399550428503452215571581604276048958396735937452791507228393997083495197879290548002853265127569910930648812921091549545147941972750158605112325079312039054825870573986374161254590876872367709717423642369650017374448020838615475035626771463864178105646732507808534977443900875333446450467047221");
    static final BigInteger PRIME_384_BIT = new BigInteger("83085671664126938805092614721037843700776366159998897420433674117190444262260240009907206384693584652377753448639527");
    static final BigInteger PRIME_192_BIT = new BigInteger("14976407493557531125525728362448106789840013430353915016137");
    private static Map<String, Integer> WORDS_MAP = IntStream.range(0, Constants.ALL_SECRET_PHRASE_WORDS.length).boxed().collect(Collectors.toMap(n -> Constants.ALL_SECRET_PHRASE_WORDS[n], n -> n));
    private static final String[] NON_STANDARD_SECRET = new String[0];

    private static SecretSharing getSecretSharingEngine() {
        return new SimpleShamirSecretSharing();
    }

    public static String[] split(String string, int n, int n2, BigInteger bigInteger) {
        if (n2 <= 1 || n2 > n) {
            throw new IllegalArgumentException(String.format("Illegal number of minimum pieces %d, must be between 2 and %d", n2, n));
        }
        BigInteger bigInteger2 = SecretSharingGenerator.secretToNumber(string);
        BigInteger bigInteger3 = SecretSharingGenerator.getModPrime(bigInteger, bigInteger2);
        SecureRandom secureRandom = Crypto.getSecureRandom();
        SecretShare[] secretShareArray = SecretSharingGenerator.getSecretSharingEngine().split(bigInteger2, n2, n, bigInteger3, secureRandom);
        int n3 = SecretSharingGenerator.is12WordsSecret(string.split(" ")) ? 1 : 0;
        String string2 = String.format("%d:%d:%d:%d:%s:", n3, secureRandom.nextInt(), n, n2, bigInteger.toString());
        return (String[])Arrays.stream(secretShareArray).map(secretShare -> string2 + secretShare.getX() + ":" + Convert.toHexString(secretShare.getShare().toByteArray())).toArray(String[]::new);
    }

    public static String combine(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = stringArray[0].split(":", 6);
        if (stringArray3.length < 6) {
            throw new IllegalArgumentException("Wrong piece format, should be v:id:n:k:p:#:data");
        }
        int n = Integer.parseInt(stringArray3[0]);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unsupported piece version " + n);
        }
        int n2 = Integer.parseInt(stringArray3[1]);
        int n3 = Integer.parseInt(stringArray3[2]);
        int n4 = Integer.parseInt(stringArray3[3]);
        BigInteger bigInteger = new BigInteger(stringArray3[4]);
        stringArray2[0] = stringArray3[5];
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray3 = stringArray[i].split(":", 6);
            if (stringArray3.length != 6) {
                throw new IllegalArgumentException("Wrong piece format, should be n:k:p:#:data");
            }
            try {
                if (n != Integer.parseInt(stringArray3[0])) {
                    throw new IllegalArgumentException("Version differs between pieces");
                }
                if (n2 != Integer.parseInt(stringArray3[1])) {
                    throw new IllegalArgumentException("Id differs between pieces");
                }
                if (n3 != Integer.parseInt(stringArray3[2])) {
                    throw new IllegalArgumentException("Total number of shares differs between pieces");
                }
                if (n4 != Integer.parseInt(stringArray3[3])) {
                    throw new IllegalArgumentException("Minimum number of shares differs between pieces");
                }
                if (!bigInteger.equals(new BigInteger(stringArray3[4]))) {
                    throw new IllegalArgumentException("Modulo prime differs between pieces");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Wrong piece numeric values, should be v:id:n:k:p:#:data");
            }
            stringArray2[i] = stringArray3[5];
        }
        if (stringArray2.length < n4) {
            throw new IllegalArgumentException(String.format("Need %d pieces to combine the original secret, only %d unique piece(s) available", n4, stringArray2.length));
        }
        return SecretSharingGenerator.combine(stringArray2, bigInteger, n);
    }

    static String combine(String[] stringArray, BigInteger bigInteger, int n) {
        List<SecretShare> list = Arrays.stream(stringArray).map(string -> {
            String[] stringArray = string.split(":", 2);
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("shared secret not formatted as #:data");
            }
            return new SecretShare(Integer.parseInt(stringArray[0]), new BigInteger(stringArray[1], 16));
        }).collect(Collectors.toList());
        BigInteger bigInteger2 = list.stream().map(SecretShare::getShare).max(Comparator.naturalOrder()).orElse(BigInteger.ZERO);
        bigInteger = SecretSharingGenerator.getModPrime(bigInteger, bigInteger2);
        BigInteger bigInteger3 = SecretSharingGenerator.getSecretSharingEngine().combine(list.toArray(new SecretShare[0]), bigInteger);
        return SecretSharingGenerator.numberToSecret(bigInteger3, n != 0);
    }

    private static String numberToSecret(BigInteger bigInteger, boolean bl) {
        if (bl) {
            CharSequence[] charSequenceArray = SecretSharingGenerator.from128bit(bigInteger);
            return String.join((CharSequence)" ", charSequenceArray);
        }
        return new String(Convert.parseHexString(bigInteger.toString(16)), StandardCharsets.UTF_8);
    }

    private static BigInteger secretToNumber(String string) {
        String[] stringArray = string.split(" ");
        if (SecretSharingGenerator.is12WordsSecret(stringArray)) {
            return SecretSharingGenerator.to128bit(stringArray);
        }
        return new BigInteger(Convert.toHexString(string.getBytes(StandardCharsets.UTF_8)), 16);
    }

    private static boolean is12WordsSecret(String[] stringArray) {
        return stringArray.length == 12 && Arrays.stream(stringArray).allMatch(string -> WORDS_MAP.get(string) != null);
    }

    static BigInteger to128bit(String[] stringArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < stringArray.length / 3; ++i) {
            bigInteger = bigInteger.add(new BigInteger("" + SecretSharingGenerator.getSignedInt(stringArray[3 * i], stringArray[3 * i + 1], stringArray[3 * i + 2])));
            if (i == stringArray.length / 3 - 1) break;
            bigInteger = bigInteger.shiftLeft(32);
        }
        return bigInteger;
    }

    private static long getSignedInt(String string, String string2, String string3) {
        return SecretSharingGenerator.getSignedInt(WORDS_MAP.get(string), WORDS_MAP.get(string2), WORDS_MAP.get(string3));
    }

    private static long getSignedInt(int n, int n2, int n3) {
        int n4 = Constants.ALL_SECRET_PHRASE_WORDS.length;
        return (long)(n + Math.floorMod(n2 - n, n4) * n4 + Math.floorMod(n3 - n2, n4) * n4 * n4) & 0xFFFFFFFFL;
    }

    static String[] from128bit(BigInteger bigInteger) {
        String[] stringArray = new String[12];
        String[] stringArray2 = Constants.ALL_SECRET_PHRASE_WORDS;
        int n = stringArray2.length;
        BigInteger bigInteger2 = new BigInteger(bigInteger.toString());
        for (int i = 0; i < 4; ++i) {
            long l = (long)bigInteger2.intValue() & 0xFFFFFFFFL;
            bigInteger2 = bigInteger2.shiftRight(32);
            long l2 = l % (long)n;
            long l3 = (l / (long)n + l2) % (long)n;
            long l4 = (l / (long)n / (long)n + l3) % (long)n;
            if (l3 < 0L || l3 >= (long)n || l4 < 0L || l4 >= (long)n) {
                return NON_STANDARD_SECRET;
            }
            int n2 = 3 * (4 - i - 1);
            stringArray[n2] = stringArray2[(int)l2];
            stringArray[n2 + 1] = stringArray2[(int)l3];
            stringArray[n2 + 2] = stringArray2[(int)l4];
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) > 0) {
            throw new IllegalStateException(String.format("number %s has more than 128 bit", bigInteger));
        }
        return stringArray;
    }

    public static BigInteger getModPrime(String string) {
        BigInteger bigInteger = SecretSharingGenerator.secretToNumber(string);
        return SecretSharingGenerator.getModPrime(BigInteger.ZERO, bigInteger);
    }

    private static BigInteger getModPrime(BigInteger bigInteger, BigInteger bigInteger2) {
        if (!BigInteger.ZERO.equals(bigInteger)) {
            if (bigInteger2.compareTo(bigInteger) >= 0) {
                throw new IllegalArgumentException("Secret cannot be larger than modulus.  Secret=" + bigInteger2 + " Modulus=" + bigInteger);
            }
            return bigInteger;
        }
        return SecretSharingGenerator.getModPrimeForSecret(bigInteger2);
    }

    private static BigInteger getModPrimeForSecret(BigInteger bigInteger) {
        if (bigInteger.compareTo(PRIME_192_BIT) < 0) {
            return PRIME_192_BIT;
        }
        if (bigInteger.compareTo(PRIME_384_BIT) < 0) {
            return PRIME_384_BIT;
        }
        if (bigInteger.compareTo(PRIME_4096_BIT) < 0) {
            return PRIME_4096_BIT;
        }
        throw new IllegalStateException("Cannot split secrets of more than 4024 bit");
    }
}

