/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nxt.util.Convert;

public interface DbKey {
    default public int setPK(PreparedStatement preparedStatement) throws SQLException {
        return this.setPK(preparedStatement, 1);
    }

    public int setPK(PreparedStatement var1, int var2) throws SQLException;

    public static final class LongStringKey
    implements DbKey {
        private final long idA;
        private final String idB;

        private LongStringKey(long l, String string) {
            this.idA = l;
            this.idB = string;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.idA);
            preparedStatement.setString(n + 1, this.idB);
            return n + 2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof LongStringKey)) {
                return false;
            }
            LongStringKey longStringKey = (LongStringKey)object;
            return this.idA == longStringKey.idA && Objects.equals(this.idB, longStringKey.idB);
        }

        public int hashCode() {
            return Objects.hash(this.idA, this.idB);
        }
    }

    public static final class HashHashLongKey
    implements DbKey {
        private final long idA;
        private final byte[] hashA;
        private final long idB;
        private final byte[] hashB;
        private final long idC;

        private HashHashLongKey(byte[] byArray, byte[] byArray2, long l) {
            this.hashA = byArray;
            this.idA = Convert.fullHashToId(byArray);
            this.hashB = byArray2;
            this.idB = Convert.fullHashToId(byArray2);
            this.idC = l;
        }

        private HashHashLongKey(byte[] byArray, long l, byte[] byArray2, long l2, long l3) {
            this.idA = l;
            this.idB = l2;
            this.hashA = byArray;
            this.hashB = byArray2;
            this.idC = l3;
        }

        public byte[] getHashA() {
            return this.hashA;
        }

        public byte[] getHashB() {
            return this.hashB;
        }

        public long getIdC() {
            return this.idC;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.idA);
            preparedStatement.setBytes(n + 1, this.hashA);
            preparedStatement.setLong(n + 2, this.idB);
            preparedStatement.setBytes(n + 3, this.hashB);
            preparedStatement.setLong(n + 4, this.idC);
            return n + 5;
        }

        public boolean equals(Object object) {
            return object instanceof HashHashLongKey && this.idC == ((HashHashLongKey)object).idC && Arrays.equals(this.hashB, ((HashHashLongKey)object).hashB) && Arrays.equals(this.hashA, ((HashHashLongKey)object).hashA);
        }

        public int hashCode() {
            return (int)(this.idA ^ this.idA >>> 32) ^ (int)(this.idB ^ this.idB >>> 32) ^ Long.hashCode(this.idC);
        }
    }

    public static final class HashHashKey
    implements DbKey {
        private final long idA;
        private final byte[] hashA;
        private final long idB;
        private final byte[] hashB;

        private HashHashKey(byte[] byArray, byte[] byArray2) {
            this.hashA = byArray;
            this.idA = Convert.fullHashToId(byArray);
            this.hashB = byArray2;
            this.idB = Convert.fullHashToId(byArray2);
        }

        private HashHashKey(byte[] byArray, long l, byte[] byArray2, long l2) {
            this.idA = l;
            this.idB = l2;
            this.hashA = byArray;
            this.hashB = byArray2;
        }

        public byte[] getHashA() {
            return this.hashA;
        }

        public byte[] getHashB() {
            return this.hashB;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.idA);
            preparedStatement.setBytes(n + 1, this.hashA);
            preparedStatement.setLong(n + 2, this.idB);
            preparedStatement.setBytes(n + 3, this.hashB);
            return n + 4;
        }

        public boolean equals(Object object) {
            return object instanceof HashHashKey && Arrays.equals(this.hashB, ((HashHashKey)object).hashB) && Arrays.equals(this.hashA, ((HashHashKey)object).hashA);
        }

        public int hashCode() {
            return (int)(this.idA ^ this.idA >>> 32) ^ (int)(this.idB ^ this.idB >>> 32);
        }
    }

    public static final class HashLongKey
    implements DbKey {
        private final long idA;
        private final byte[] hashA;
        private final long idB;

        private HashLongKey(byte[] byArray, long l) {
            this.hashA = byArray;
            this.idA = Convert.fullHashToId(byArray);
            this.idB = l;
        }

        private HashLongKey(byte[] byArray, long l, long l2) {
            this.idA = l;
            this.idB = l2;
            this.hashA = byArray;
        }

        public byte[] getHashA() {
            return this.hashA;
        }

        public long getIdB() {
            return this.idB;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.idA);
            preparedStatement.setBytes(n + 1, this.hashA);
            preparedStatement.setLong(n + 2, this.idB);
            return n + 3;
        }

        public boolean equals(Object object) {
            return object instanceof HashLongKey && ((HashLongKey)object).idB == this.idB && Arrays.equals(this.hashA, ((HashLongKey)object).hashA);
        }

        public int hashCode() {
            return (int)(this.idA ^ this.idA >>> 32) ^ (int)(this.idB ^ this.idB >>> 32);
        }
    }

    public static final class LongLongKey
    implements DbKey {
        private final long idA;
        private final long idB;

        private LongLongKey(long l, long l2) {
            this.idA = l;
            this.idB = l2;
        }

        public long[] getId() {
            return new long[]{this.idA, this.idB};
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.idA);
            preparedStatement.setLong(n + 1, this.idB);
            return n + 2;
        }

        public boolean equals(Object object) {
            return object instanceof LongLongKey && ((LongLongKey)object).idA == this.idA && ((LongLongKey)object).idB == this.idB;
        }

        public int hashCode() {
            return (int)(this.idA ^ this.idA >>> 32) ^ (int)(this.idB ^ this.idB >>> 32);
        }
    }

    public static final class HashKey
    implements DbKey {
        private final long id;
        private final byte[] hash;

        private HashKey(byte[] byArray) {
            this.hash = byArray;
            this.id = Convert.fullHashToId(byArray);
        }

        private HashKey(byte[] byArray, long l) {
            this.hash = byArray;
            this.id = l;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public long getId() {
            return this.id;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.id);
            preparedStatement.setBytes(n + 1, this.hash);
            return n + 2;
        }

        public boolean equals(Object object) {
            return object instanceof HashKey && Arrays.equals(this.hash, ((HashKey)object).hash);
        }

        public int hashCode() {
            return Long.hashCode(this.id);
        }
    }

    public static final class StringKey
    implements DbKey {
        private final String id;

        private StringKey(String string) {
            this.id = string;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setString(n, this.id);
            return n + 1;
        }

        public boolean equals(Object object) {
            return object instanceof StringKey && (this.id != null ? this.id.equals(((StringKey)object).id) : ((StringKey)object).id == null);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }
    }

    public static final class LongKey
    implements DbKey {
        private final long id;

        private LongKey(long l) {
            this.id = l;
        }

        public long getId() {
            return this.id;
        }

        @Override
        public int setPK(PreparedStatement preparedStatement, int n) throws SQLException {
            preparedStatement.setLong(n, this.id);
            return n + 1;
        }

        public boolean equals(Object object) {
            return object instanceof LongKey && ((LongKey)object).id == this.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }
    }

    public static abstract class LongStringKeyFactory<T>
    extends SmartFactory<T> {
        private final String idColumnA;
        private final String idColumnB;

        protected LongStringKeyFactory(String string, String string2) {
            super(string, string2);
            this.idColumnA = string;
            this.idColumnB = string2;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new LongStringKey(resultSet.getLong(this.idColumnA), resultSet.getString(this.idColumnB));
        }

        public DbKey newKey(long l, String string) {
            return new LongStringKey(l, string);
        }
    }

    public static abstract class HashHashLongKeyFactory<T>
    extends Factory<T> {
        private final String idColumnA;
        private final String hashColumnA;
        private final String idColumnB;
        private final String hashColumnB;
        private final String idColumnC;

        public HashHashLongKeyFactory(String string, String string2, String string3, String string4, String string5) {
            super(" WHERE " + string2 + " = ? AND " + string + " = ? AND " + string4 + " = ? AND " + string3 + " = ? AND " + string5 + " = ? ", string2 + ", " + string + ", " + string4 + ", " + string3 + ", " + string5, " a." + string2 + " = b." + string2 + " AND a." + string + " = b." + string + " AND a." + string4 + " = b." + string4 + "  AND a." + string3 + " = b." + string3 + " AND a." + string5 + " = b." + string5);
            this.idColumnA = string2;
            this.hashColumnA = string;
            this.idColumnB = string4;
            this.hashColumnB = string3;
            this.idColumnC = string5;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new HashHashLongKey(resultSet.getBytes(this.hashColumnA), resultSet.getLong(this.idColumnA), resultSet.getBytes(this.hashColumnB), resultSet.getLong(this.idColumnB), resultSet.getLong(this.idColumnC));
        }

        public DbKey newKey(byte[] byArray, byte[] byArray2, long l) {
            return new HashHashLongKey(byArray, byArray2, l);
        }

        public DbKey newKey(byte[] byArray, long l, byte[] byArray2, long l2, long l3) {
            return new HashHashLongKey(byArray, l, byArray2, l2, l3);
        }
    }

    public static abstract class HashHashKeyFactory<T>
    extends Factory<T> {
        private final String idColumnA;
        private final String hashColumnA;
        private final String idColumnB;
        private final String hashColumnB;

        public HashHashKeyFactory(String string, String string2, String string3, String string4) {
            super(" WHERE " + string2 + " = ? AND " + string + " = ? AND " + string4 + " = ? AND " + string3 + " = ? ", string2 + ", " + string + ", " + string4 + ", " + string3, " a." + string2 + " = b." + string2 + " AND a." + string + " = b." + string + " AND a." + string4 + " = b." + string4 + "  AND a." + string3 + " = b." + string3);
            this.idColumnA = string2;
            this.hashColumnA = string;
            this.idColumnB = string4;
            this.hashColumnB = string3;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new HashHashKey(resultSet.getBytes(this.hashColumnA), resultSet.getLong(this.idColumnA), resultSet.getBytes(this.hashColumnB), resultSet.getLong(this.idColumnB));
        }

        public DbKey newKey(byte[] byArray, byte[] byArray2) {
            return new HashHashKey(byArray, byArray2);
        }

        public DbKey newKey(byte[] byArray, long l, byte[] byArray2, long l2) {
            return new HashHashKey(byArray, l, byArray2, l2);
        }
    }

    public static abstract class HashLongKeyFactory<T>
    extends Factory<T> {
        private final String idColumnA;
        private final String hashColumnA;
        private final String idColumnB;

        public HashLongKeyFactory(String string, String string2, String string3) {
            super(" WHERE " + string2 + " = ? AND " + string + " = ? AND " + string3 + " = ? ", string2 + ", " + string + ", " + string3, " a." + string2 + " = b." + string2 + " AND a." + string + " = b." + string + " AND a." + string3 + " = b." + string3 + " ");
            this.idColumnA = string2;
            this.hashColumnA = string;
            this.idColumnB = string3;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new HashLongKey(resultSet.getBytes(this.hashColumnA), resultSet.getLong(this.idColumnA), resultSet.getLong(this.idColumnB));
        }

        public DbKey newKey(byte[] byArray, long l) {
            return new HashLongKey(byArray, l);
        }

        public DbKey newKey(byte[] byArray, long l, long l2) {
            return new HashLongKey(byArray, l, l2);
        }
    }

    public static abstract class LongLongKeyFactory<T>
    extends Factory<T> {
        private final String idColumnA;
        private final String idColumnB;

        public LongLongKeyFactory(String string, String string2) {
            super(" WHERE " + string + " = ? AND " + string2 + " = ? ", string + ", " + string2, " a." + string + " = b." + string + " AND a." + string2 + " = b." + string2 + " ");
            this.idColumnA = string;
            this.idColumnB = string2;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new LongLongKey(resultSet.getLong(this.idColumnA), resultSet.getLong(this.idColumnB));
        }

        public DbKey newKey(long l, long l2) {
            return new LongLongKey(l, l2);
        }
    }

    public static abstract class HashKeyFactory<T>
    extends Factory<T> {
        private final String idColumn;
        private final String hashColumn;

        public HashKeyFactory(String string, String string2) {
            super(" WHERE " + string2 + " = ? AND " + string + " = ?", string2 + ", " + string, " a." + string2 + " = b." + string2 + " AND a." + string + " = b." + string + " ");
            this.idColumn = string2;
            this.hashColumn = string;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new HashKey(resultSet.getBytes(this.hashColumn), resultSet.getLong(this.idColumn));
        }

        @Override
        public DbKey newKey(byte[] byArray) {
            return new HashKey(byArray);
        }

        public DbKey newKey(byte[] byArray, long l) {
            return new HashKey(byArray, l);
        }
    }

    public static abstract class StringKeyFactory<T>
    extends Factory<T> {
        private final String idColumn;

        public StringKeyFactory(String string) {
            super(" WHERE " + string + " = ? ", string, " a." + string + " = b." + string + " ");
            this.idColumn = string;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new StringKey(resultSet.getString(this.idColumn));
        }

        @Override
        public DbKey newKey(String string) {
            return new StringKey(string);
        }
    }

    public static abstract class LongKeyFactory<T>
    extends Factory<T> {
        private final String idColumn;

        public LongKeyFactory(String string) {
            super(" WHERE " + string + " = ? ", string, " a." + string + " = b." + string + " ");
            this.idColumn = string;
        }

        @Override
        public DbKey newKey(ResultSet resultSet) throws SQLException {
            return new LongKey(resultSet.getLong(this.idColumn));
        }

        @Override
        public DbKey newKey(long l) {
            return new LongKey(l);
        }
    }

    public static abstract class SmartFactory<T>
    extends Factory<T> {
        SmartFactory(String ... stringArray) {
            super(SmartFactory.pkClause(stringArray), SmartFactory.pkColumns(stringArray), SmartFactory.selfJoinClause(stringArray));
        }

        static String selfJoinClause(String ... stringArray) {
            return Stream.of(stringArray).map(string -> "a." + string + " = b." + string).collect(Collectors.joining(" AND "));
        }

        static String pkColumns(String ... stringArray) {
            return Stream.of(stringArray).collect(Collectors.joining(", "));
        }

        static String pkClause(String ... stringArray) {
            return " WHERE " + Stream.of(stringArray).map(string -> string + " = ? ").collect(Collectors.joining("AND "));
        }
    }

    public static abstract class Factory<T> {
        private final String pkClause;
        private final String pkColumns;
        private final String selfJoinClause;

        protected Factory(String string, String string2, String string3) {
            this.pkClause = string;
            this.pkColumns = string2;
            this.selfJoinClause = string3;
        }

        public abstract DbKey newKey(T var1);

        public abstract DbKey newKey(ResultSet var1) throws SQLException;

        public T newEntity(DbKey dbKey) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public final String getPKClause() {
            return this.pkClause;
        }

        public final String getPKColumns() {
            return this.pkColumns;
        }

        public final String getSelfJoinClause() {
            return this.selfJoinClause;
        }
    }
}

