/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nxt.db.BasicDb;
import nxt.db.DbUtils;
import nxt.util.Logger;
import nxt.util.security.BlockchainPermission;

public abstract class DbVersion {
    protected final BasicDb db;
    protected final String schema;

    protected DbVersion(BasicDb basicDb, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new BlockchainPermission("db"));
        }
        this.db = basicDb;
        this.schema = string;
    }

    void createSchema() {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.db.getConnection("PUBLIC");
            statement = connection.createStatement();
            statement.executeUpdate("CREATE SCHEMA IF NOT EXISTS " + this.schema);
        }
        catch (SQLException sQLException) {
            try {
                DbUtils.rollback(connection);
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
            catch (Throwable throwable) {
                DbUtils.close(statement, connection);
                throw throwable;
            }
        }
        DbUtils.close(statement, connection);
    }

    void init() {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.db.getConnection(this.schema);
            statement = connection.createStatement();
            int n = 1;
            try {
                ResultSet resultSet = statement.executeQuery("SELECT next_update FROM " + this.schema + ".version");
                if (!resultSet.next()) {
                    throw new RuntimeException("Invalid version table");
                }
                n = resultSet.getInt("next_update");
                if (!resultSet.isLast()) {
                    throw new RuntimeException("Invalid version table");
                }
                resultSet.close();
                Logger.logMessage("Database update may take a while if needed, current db version " + (n - 1) + "...");
            }
            catch (SQLException sQLException) {
                Logger.logMessage("Initializing an empty database");
                statement.executeUpdate("CREATE TABLE version (next_update INT NOT NULL)");
                statement.executeUpdate("INSERT INTO version VALUES (1)");
                connection.commit();
            }
            this.update(n);
        }
        catch (SQLException sQLException) {
            try {
                DbUtils.rollback(connection);
                throw new RuntimeException(sQLException.toString(), sQLException);
            }
            catch (Throwable throwable) {
                DbUtils.close(statement, connection);
                throw throwable;
            }
        }
        DbUtils.close(statement, connection);
    }

    protected void apply(String string) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.db.getConnection(this.schema);
            statement = connection.createStatement();
            try {
                if (string != null) {
                    Logger.logDebugMessage("Will apply sql:\n" + string);
                    statement.executeUpdate(string);
                }
                statement.executeUpdate("UPDATE version SET next_update = next_update + 1");
                connection.commit();
            }
            catch (Exception exception) {
                DbUtils.rollback(connection);
                throw exception;
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new RuntimeException("Database error executing " + string, sQLException);
            }
            catch (Throwable throwable) {
                DbUtils.close(statement, connection);
                throw throwable;
            }
        }
        DbUtils.close(statement, connection);
    }

    protected abstract void update(int var1);
}

