/*
 * Decompiled with CFR 0.152.
 */
package nxt.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nxt.Constants;
import nxt.Nxt;
import nxt.db.Table;

public abstract class DerivedDbTable
extends Table {
    protected DerivedDbTable(String string) {
        super(string);
        Nxt.getBlockchainProcessor().registerDerivedTable(this);
    }

    public void popOffTo(int n) {
        if (!db.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + this.schemaTable + " WHERE height > ? LIMIT " + Constants.BATCH_COMMIT_SIZE);){
            int n2;
            preparedStatement.setInt(1, n);
            do {
                n2 = preparedStatement.executeUpdate();
                db.commitTransaction();
            } while (n2 >= Constants.BATCH_COMMIT_SIZE);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
    }

    public void rollback(int n) {
        this.popOffTo(n);
    }

    @Override
    public void truncate() {
        boolean bl;
        if (!db.isInTransaction()) {
            throw new IllegalStateException("Not in transaction");
        }
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM " + this.schemaTable + " WHERE height < 0 LIMIT 1");){
            bl = resultSet.next();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.toString(), sQLException);
        }
        if (bl) {
            this.popOffTo(-1);
        } else {
            super.truncate();
        }
    }

    public void trim(int n) {
    }

    public void createSearchIndex(Connection connection) throws SQLException {
    }

    public boolean isPersistent() {
        return false;
    }
}

