/*
 * Decompiled with CFR 0.152.
 */
package nxt.dbschema;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import nxt.Constants;
import nxt.Nxt;
import nxt.ae.AssetFreezeMonitor;
import nxt.blockchain.BlockDb;
import nxt.blockchain.BlockchainProcessorImpl;
import nxt.blockchain.ChildChain;
import nxt.blockchain.ChildChainLoader;
import nxt.db.BasicDb;
import nxt.db.DbVersion;
import nxt.db.FullTextTrigger;
import nxt.db.TransactionalDb;
import nxt.util.Convert;

public class FxtDbVersion
extends DbVersion {
    FxtDbVersion(BasicDb basicDb) {
        super(basicDb, "PUBLIC");
    }

    @Override
    protected void update(int n) {
        switch (n) {
            case 1: {
                this.apply("CREATE TABLE IF NOT EXISTS block (db_id IDENTITY, id BIGINT NOT NULL, version INT NOT NULL, timestamp INT NOT NULL, previous_block_id BIGINT, total_fee BIGINT NOT NULL, previous_block_hash BINARY(32), cumulative_difficulty VARBINARY NOT NULL, base_target BIGINT NOT NULL, next_block_id BIGINT, height INT NOT NULL, generation_signature BINARY(64) NOT NULL, block_signature BINARY(64) NOT NULL, payload_hash BINARY(32) NOT NULL, generator_id BIGINT NOT NULL)");
            }
            case 2: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS block_id_idx ON block (id)");
            }
            case 3: {
                this.apply("CREATE TABLE IF NOT EXISTS transaction_fxt (db_id IDENTITY, id BIGINT NOT NULL, deadline SMALLINT NOT NULL, recipient_id BIGINT, transaction_index SMALLINT NOT NULL, amount BIGINT NOT NULL, fee BIGINT NOT NULL, full_hash BINARY(32) NOT NULL, height INT NOT NULL, block_id BIGINT NOT NULL, signature BINARY(64) NOT NULL, timestamp INT NOT NULL, type TINYINT NOT NULL, subtype TINYINT NOT NULL, sender_id BIGINT NOT NULL, block_timestamp INT NOT NULL, has_prunable_attachment BOOLEAN NOT NULL DEFAULT FALSE, has_prunable_message BOOLEAN NOT NULL DEFAULT FALSE, has_prunable_encrypted_message BOOLEAN NOT NULL DEFAULT FALSE, ec_block_height INT DEFAULT NULL, ec_block_id BIGINT DEFAULT NULL, attachment_bytes VARBINARY, version TINYINT NOT NULL)");
            }
            case 4: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS transaction_fxt_id_idx ON transaction_fxt (id)");
            }
            case 5: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS block_height_idx ON block (height)");
            }
            case 6: {
                this.apply("CREATE INDEX IF NOT EXISTS block_generator_id_idx ON block (generator_id)");
            }
            case 7: {
                this.apply("CREATE INDEX IF NOT EXISTS transaction_fxt_sender_id_idx ON transaction_fxt (sender_id)");
            }
            case 8: {
                this.apply("CREATE INDEX IF NOT EXISTS transaction_fxt_recipient_id_idx ON transaction_fxt (recipient_id)");
            }
            case 9: {
                this.apply("CREATE TABLE IF NOT EXISTS peer (address VARCHAR PRIMARY KEY, last_updated INT, services BIGINT)");
            }
            case 10: {
                this.apply("CREATE INDEX IF NOT EXISTS transaction_fxt_block_timestamp_idx ON transaction_fxt (block_timestamp DESC)");
            }
            case 11: {
                this.apply("CREATE TABLE IF NOT EXISTS account (db_id IDENTITY, id BIGINT NOT NULL, has_control_phasing BOOLEAN NOT NULL DEFAULT FALSE, forged_balance BIGINT NOT NULL, active_lessee_id BIGINT, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 12: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS account_id_height_idx ON account (id, height DESC)");
            }
            case 13: {
                this.apply("CREATE TABLE IF NOT EXISTS account_asset (db_id IDENTITY, account_id BIGINT NOT NULL, asset_id BIGINT NOT NULL, quantity BIGINT NOT NULL, unconfirmed_quantity BIGINT NOT NULL, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 14: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS account_asset_id_height_idx ON account_asset (account_id, asset_id, height DESC)");
            }
            case 15: {
                this.apply("CREATE TABLE IF NOT EXISTS account_guaranteed_balance (db_id IDENTITY, account_id BIGINT NOT NULL, additions BIGINT NOT NULL, height INT NOT NULL)");
            }
            case 16: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS account_guaranteed_balance_id_height_idx ON account_guaranteed_balance (account_id, height DESC)");
            }
            case 17: {
                this.apply("CREATE TABLE IF NOT EXISTS unconfirmed_transaction (db_id IDENTITY, id BIGINT NOT NULL, expiration INT NOT NULL, transaction_height INT NOT NULL, fee BIGINT NOT NULL, fee_per_byte BIGINT NOT NULL, arrival_timestamp BIGINT NOT NULL, is_bundled BOOLEAN NOT NULL DEFAULT FALSE, transaction_bytes VARBINARY NOT NULL, chain_id INT NOT NULL, height INT NOT NULL)");
            }
            case 18: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS unconfirmed_transaction_id_idx ON unconfirmed_transaction (id)");
            }
            case 19: {
                this.apply("CREATE INDEX IF NOT EXISTS account_asset_quantity_idx ON account_asset (quantity DESC)");
            }
            case 20: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS block_timestamp_idx ON block (timestamp DESC)");
            }
            case 21: {
                this.apply("CREATE TABLE IF NOT EXISTS account_currency (db_id IDENTITY, account_id BIGINT NOT NULL, currency_id BIGINT NOT NULL, units BIGINT NOT NULL, unconfirmed_units BIGINT NOT NULL, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 22: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS account_currency_id_height_idx ON account_currency (account_id, currency_id, height DESC)");
            }
            case 23: {
                this.apply("CREATE INDEX IF NOT EXISTS account_currency_units_idx ON account_currency (units DESC)");
            }
            case 24: {
                this.apply("CREATE INDEX IF NOT EXISTS unconfirmed_transaction_chain_id_idx ON unconfirmed_transaction (chain_id)");
            }
            case 25: {
                this.apply("CREATE TABLE IF NOT EXISTS scan (rescan BOOLEAN NOT NULL DEFAULT FALSE, height INT NOT NULL DEFAULT 0, validate BOOLEAN NOT NULL DEFAULT FALSE)");
            }
            case 26: {
                this.apply("INSERT INTO scan (rescan, height, validate) VALUES (false, 0, false)");
            }
            case 27: {
                this.apply("CREATE TABLE IF NOT EXISTS public_key (db_id IDENTITY, account_id BIGINT NOT NULL, public_key BINARY(32), height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 28: {
                this.apply("CREATE INDEX IF NOT EXISTS account_guaranteed_balance_height_idx ON account_guaranteed_balance(height)");
            }
            case 29: {
                this.apply("CREATE TABLE IF NOT EXISTS account_info (db_id IDENTITY, account_id BIGINT NOT NULL, name VARCHAR, description VARCHAR, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 30: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS account_info_id_height_idx ON account_info (account_id, height DESC)");
            }
            case 31: {
                this.apply("CREATE INDEX IF NOT EXISTS account_active_lessee_id_idx ON account (active_lessee_id)");
            }
            case 32: {
                this.apply("CREATE TABLE IF NOT EXISTS account_lease (db_id IDENTITY, lessor_id BIGINT NOT NULL, current_leasing_height_from INT, current_leasing_height_to INT, current_lessee_id BIGINT, next_leasing_height_from INT, next_leasing_height_to INT, next_lessee_id BIGINT, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 33: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS account_lease_lessor_id_height_idx ON account_lease (lessor_id, height DESC)");
            }
            case 34: {
                this.apply("CREATE INDEX IF NOT EXISTS account_lease_current_leasing_height_from_idx ON account_lease (current_leasing_height_from)");
            }
            case 35: {
                this.apply("CREATE INDEX IF NOT EXISTS account_lease_current_leasing_height_to_idx ON account_lease (current_leasing_height_to)");
            }
            case 36: {
                this.apply("CREATE INDEX IF NOT EXISTS account_lease_height_id_idx ON account_lease (height, lessor_id)");
            }
            case 37: {
                this.apply("CREATE INDEX IF NOT EXISTS account_asset_asset_id_idx ON account_asset (asset_id)");
            }
            case 38: {
                this.apply("CREATE INDEX IF NOT EXISTS account_currency_currency_id_idx ON account_currency (currency_id)");
            }
            case 39: {
                this.apply("CREATE INDEX IF NOT EXISTS unconfirmed_transaction_expiration_idx ON unconfirmed_transaction (expiration DESC)");
            }
            case 40: {
                this.apply("CREATE INDEX IF NOT EXISTS account_height_id_idx ON account (height, id)");
            }
            case 41: {
                this.apply("CREATE INDEX IF NOT EXISTS account_asset_height_id_idx ON account_asset (height, account_id, asset_id)");
            }
            case 42: {
                this.apply("CREATE INDEX IF NOT EXISTS account_currency_height_id_idx ON account_currency (height, account_id, currency_id)");
            }
            case 43: {
                this.apply("CREATE INDEX IF NOT EXISTS account_info_height_id_idx ON account_info (height, account_id)");
            }
            case 44: {
                this.apply("CREATE TABLE IF NOT EXISTS account_ledger (db_id IDENTITY, account_id BIGINT NOT NULL, event_type TINYINT NOT NULL, event_id BIGINT NOT NULL, event_hash BINARY(32), chain_id INT NOT NULL, holding_type TINYINT NOT NULL, holding_id BIGINT, change BIGINT NOT NULL, balance BIGINT NOT NULL, block_id BIGINT NOT NULL, height INT NOT NULL, timestamp INT NOT NULL)");
            }
            case 45: {
                this.apply("CREATE INDEX IF NOT EXISTS account_ledger_id_idx ON account_ledger(account_id, db_id)");
            }
            case 46: {
                this.apply("CREATE INDEX IF NOT EXISTS account_ledger_height_idx ON account_ledger(height)");
            }
            case 47: {
                FullTextTrigger.init(this.db);
                this.apply(null);
            }
            case 48: {
                this.apply("CREATE TABLE IF NOT EXISTS account_control_phasing (db_id IDENTITY, account_id BIGINT NOT NULL, whitelist ARRAY, voting_model TINYINT NOT NULL, quorum BIGINT, expression VARCHAR, min_balance BIGINT, holding_id BIGINT, min_balance_model TINYINT, max_fees_chains ARRAY, max_fees ARRAY, min_duration SMALLINT, max_duration SMALLINT, sender_property_setter_id BIGINT, sender_property_name VARCHAR, sender_property_value VARCHAR, recipient_property_setter_id BIGINT, recipient_property_name VARCHAR, recipient_property_value VARCHAR, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 49: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS account_control_phasing_id_height_idx ON account_control_phasing (account_id, height DESC)");
            }
            case 50: {
                this.apply("CREATE INDEX IF NOT EXISTS account_control_phasing_height_id_idx ON account_control_phasing (height, account_id)");
            }
            case 51: {
                this.apply("CREATE TABLE IF NOT EXISTS account_property (db_id IDENTITY, id BIGINT NOT NULL, recipient_id BIGINT NOT NULL, setter_id BIGINT, property VARCHAR NOT NULL, value VARCHAR, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 52: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS account_property_id_height_idx ON account_property (id, height DESC)");
            }
            case 53: {
                this.apply("CREATE INDEX IF NOT EXISTS account_property_height_id_idx ON account_property (height, id)");
            }
            case 54: {
                this.apply("CREATE INDEX IF NOT EXISTS account_property_recipient_height_idx ON account_property (recipient_id, height DESC)");
            }
            case 55: {
                this.apply("CREATE INDEX IF NOT EXISTS account_property_setter_recipient_idx ON account_property (setter_id, recipient_id)");
            }
            case 56: {
                this.apply("CREATE TABLE IF NOT EXISTS asset (db_id IDENTITY, id BIGINT NOT NULL, account_id BIGINT NOT NULL, name VARCHAR NOT NULL, description VARCHAR, quantity BIGINT NOT NULL, decimals TINYINT NOT NULL, has_control_phasing BOOLEAN NOT NULL DEFAULT FALSE, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 57: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_account_id_idx ON asset (account_id)");
            }
            case 58: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS asset_id_height_idx ON asset (id, height DESC)");
            }
            case 59: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_height_id_idx ON asset (height, id)");
            }
            case 60: {
                this.apply("CREATE TABLE IF NOT EXISTS asset_history (db_id IDENTITY, id BIGINT NOT NULL, full_hash BINARY(32) NOT NULL, asset_id BIGINT NOT NULL, account_id BIGINT NOT NULL, quantity BIGINT NOT NULL, timestamp INT NOT NULL, chain_id INT NOT NULL, height INT NOT NULL)");
            }
            case 61: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_history_id_idx ON asset_history (id)");
            }
            case 62: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_history_asset_id_idx ON asset_history (asset_id, height DESC)");
            }
            case 63: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_history_account_id_idx ON asset_history (account_id, height DESC)");
            }
            case 64: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_history_height_idx ON asset_history (height)");
            }
            case 65: {
                this.apply("CREATE TABLE IF NOT EXISTS asset_transfer (db_id IDENTITY, id BIGINT NOT NULL, full_hash BINARY(32) NOT NULL, asset_id BIGINT NOT NULL, sender_id BIGINT NOT NULL, recipient_id BIGINT NOT NULL, quantity BIGINT NOT NULL, timestamp INT NOT NULL, chain_id INT NOT NULL, height INT NOT NULL)");
            }
            case 66: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_transfer_id_idx ON asset_transfer (id)");
            }
            case 67: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_transfer_asset_id_idx ON asset_transfer (asset_id, height DESC)");
            }
            case 68: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_transfer_sender_id_idx ON asset_transfer (sender_id, height DESC)");
            }
            case 69: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_transfer_recipient_id_idx ON asset_transfer (recipient_id, height DESC)");
            }
            case 70: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_transfer_height_idx ON asset_transfer (height)");
            }
            case 71: {
                this.apply("CREATE TABLE IF NOT EXISTS currency (db_id IDENTITY, id BIGINT NOT NULL, account_id BIGINT NOT NULL, name VARCHAR NOT NULL, name_lower VARCHAR NOT NULL, code VARCHAR NOT NULL, description VARCHAR, type INT NOT NULL, chain INT NOT NULL, initial_supply BIGINT NOT NULL DEFAULT 0, reserve_supply BIGINT NOT NULL, max_supply BIGINT NOT NULL, creation_height INT NOT NULL, issuance_height INT NOT NULL, min_reserve_per_unit_nqt BIGINT NOT NULL, min_difficulty TINYINT NOT NULL, max_difficulty TINYINT NOT NULL, ruleset TINYINT NOT NULL, algorithm TINYINT NOT NULL, decimals TINYINT NOT NULL DEFAULT 0, is_deleted BOOLEAN NOT NULL DEFAULT FALSE, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 72: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS currency_id_height_idx ON currency (id, height DESC)");
            }
            case 73: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_account_id_idx ON currency (account_id)");
            }
            case 74: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_name_idx ON currency (name_lower, chain, height DESC)");
            }
            case 75: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_code_idx ON currency (code, chain, height DESC)");
            }
            case 76: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_creation_height_idx ON currency (creation_height DESC)");
            }
            case 77: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_issuance_height_idx ON currency (issuance_height)");
            }
            case 78: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_height_id_idx ON currency (height, id)");
            }
            case 79: {
                this.apply("CREATE TABLE IF NOT EXISTS currency_supply (db_id IDENTITY, id BIGINT NOT NULL, current_supply BIGINT NOT NULL, current_reserve_per_unit_nqt BIGINT NOT NULL, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 80: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS currency_supply_id_height_idx ON currency_supply (id, height DESC)");
            }
            case 81: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_supply_height_id_idx ON currency_supply (height, id)");
            }
            case 82: {
                this.apply("CREATE TABLE IF NOT EXISTS phasing_poll_finish (db_id IDENTITY, transaction_id BIGINT NOT NULL, full_hash BINARY(32) NOT NULL, chain_id INT NOT NULL, finish_height INT NOT NULL, height INT NOT NULL)");
            }
            case 83: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_finish_finish_height_idx ON phasing_poll_finish (finish_height)");
            }
            case 84: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_finish_height_idx ON phasing_poll_finish (height)");
            }
            case 85: {
                this.apply("CREATE TABLE IF NOT EXISTS currency_mint (db_id IDENTITY, currency_id BIGINT NOT NULL, account_id BIGINT NOT NULL, counter BIGINT NOT NULL, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 86: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS currency_mint_currency_id_account_id_idx ON currency_mint (currency_id, account_id, height DESC)");
            }
            case 87: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_mint_height_id_idx ON currency_mint (height, currency_id, account_id)");
            }
            case 88: {
                this.apply("CREATE TABLE IF NOT EXISTS currency_transfer (db_id IDENTITY, id BIGINT NOT NULL, full_hash BINARY(32) NOT NULL, currency_id BIGINT NOT NULL, sender_id BIGINT NOT NULL, recipient_id BIGINT NOT NULL, units BIGINT NOT NULL, timestamp INT NOT NULL, chain_id INT NOT NULL, height INT NOT NULL)");
            }
            case 89: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_transfer_id_idx ON currency_transfer (id)");
            }
            case 90: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_transfer_currency_id_idx ON currency_transfer (currency_id, height DESC)");
            }
            case 91: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_transfer_sender_id_idx ON currency_transfer (sender_id, height DESC)");
            }
            case 92: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_transfer_recipient_id_idx ON currency_transfer (recipient_id, height DESC)");
            }
            case 93: {
                this.apply("CREATE INDEX IF NOT EXISTS currency_transfer_height_idx ON currency_transfer(height)");
            }
            case 94: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_finish_id_idx ON phasing_poll_finish (transaction_id)");
            }
            case 95: {
                this.apply("CREATE TABLE IF NOT EXISTS phasing_poll_linked_transaction (db_id IDENTITY, chain_id INT NOT NULL, transaction_id BIGINT NOT NULL, transaction_full_hash BINARY(32) NOT NULL, linked_chain_id INT NOT NULL, linked_full_hash BINARY(32) NOT NULL, linked_transaction_id BIGINT NOT NULL, sub_poll_name VARCHAR, height INT NOT NULL)");
            }
            case 96: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_linked_transaction_id_link_idx ON phasing_poll_linked_transaction (transaction_id, linked_transaction_id)");
            }
            case 97: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_linked_transaction_height_idx ON phasing_poll_linked_transaction (height)");
            }
            case 98: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_linked_transaction_link_id_idx ON phasing_poll_linked_transaction (linked_transaction_id, transaction_id)");
            }
            case 99: {
                this.apply("CREATE TABLE IF NOT EXISTS balance_fxt (db_id IDENTITY, account_id BIGINT NOT NULL, balance BIGINT NOT NULL, unconfirmed_balance BIGINT NOT NULL, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 100: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS balance_fxt_id_height_idx ON balance_fxt (account_id, height DESC)");
            }
            case 101: {
                this.apply("CREATE INDEX IF NOT EXISTS balance_fxt_height_id_idx ON balance_fxt (height, account_id)");
            }
            case 102: {
                this.apply("CREATE TABLE IF NOT EXISTS coin_order_fxt (db_id IDENTITY, id BIGINT NOT NULL,account_id BIGINT NOT NULL, chain_id INT NOT NULL, exchange_id INT NOT NULL, full_hash BINARY(32) NOT NULL, amount BIGINT NOT NULL, quantity BIGINT NOT NULL, bid_price BIGINT NOT NULL, ask_price BIGINT NOT NULL, creation_height INT NOT NULL, height INT NOT NULL, transaction_height INT NOT NULL, transaction_index SMALLINT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 103: {
                this.apply("CREATE INDEX IF NOT EXISTS coin_order_fxt_id_idx ON coin_order_fxt (id, height DESC)");
            }
            case 104: {
                this.apply("CREATE INDEX IF NOT EXISTS coin_order_fxt_chain_idx ON coin_order_fxt (chain_id, exchange_id)");
            }
            case 105: {
                this.apply("CREATE INDEX IF NOT EXISTS coin_order_fxt_exchange_idx ON coin_order_fxt (exchange_id)");
            }
            case 106: {
                this.apply("CREATE INDEX IF NOT EXISTS coin_order_fxt_account_idx ON coin_order_fxt (account_id)");
            }
            case 107: {
                this.apply("CREATE TABLE IF NOT EXISTS coin_trade_fxt (db_id IDENTITY, chain_id INT NOT NULL, exchange_id INT NOT NULL, account_id BIGINT NOT NULL, block_id BIGINT NOT NULL, height INT NOT NULL, timestamp INT NOT NULL, exchange_quantity BIGINT NOT NULL, exchange_price BINARY(16) NOT NULL, order_id BIGINT NOT NULL, order_full_hash BINARY(32) NOT NULL, match_id BIGINT NOT NULL, match_full_hash BINARY(32) NOT NULL)");
            }
            case 108: {
                this.apply("CREATE INDEX IF NOT EXISTS coin_trade_fxt_chain_idx ON coin_trade_fxt (chain_id)");
            }
            case 109: {
                this.apply("CREATE INDEX IF NOT EXISTS coin_trade_fxt_exchange_idx ON coin_trade_fxt (exchange_id)");
            }
            case 110: {
                this.apply("CREATE INDEX IF NOT EXISTS coin_trade_fxt_account_idx ON coin_trade_fxt (account_id)");
            }
            case 111: {
                this.apply("CREATE INDEX IF NOT EXISTS coin_trade_fxt_order_idx ON coin_trade_fxt (order_id)");
            }
            case 112: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS public_key_account_id_height_idx ON public_key (account_id, height DESC)");
            }
            case 113: {
                this.apply("CREATE TABLE IF NOT EXISTS phasing_poll_result (db_id IDENTITY, id BIGINT NOT NULL, full_hash BINARY(32) NOT NULL, chain_id INT NOT NULL, result BIGINT NOT NULL, approved BOOLEAN NOT NULL, height INT NOT NULL)");
            }
            case 114: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_result_id_idx ON phasing_poll_result(id)");
            }
            case 115: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_result_height_idx ON phasing_poll_result(height)");
            }
            case 116: {
                this.apply("CREATE TABLE IF NOT EXISTS prunable_message (db_id IDENTITY, id BIGINT NOT NULL, full_hash BINARY(32) NOT NULL, sender_id BIGINT NOT NULL, recipient_id BIGINT, message VARBINARY, message_is_text BOOLEAN NOT NULL, is_compressed BOOLEAN NOT NULL, encrypted_message VARBINARY, encrypted_is_text BOOLEAN DEFAULT FALSE, block_timestamp INT NOT NULL, transaction_timestamp INT NOT NULL, height INT NOT NULL)");
            }
            case 117: {
                this.apply("CREATE INDEX IF NOT EXISTS prunable_message_id_idx ON prunable_message (id)");
            }
            case 118: {
                this.apply("CREATE INDEX IF NOT EXISTS prunable_message_transaction_timestamp_idx ON prunable_message (transaction_timestamp DESC)");
            }
            case 119: {
                this.apply("CREATE INDEX IF NOT EXISTS prunable_message_sender_idx ON prunable_message (sender_id)");
            }
            case 120: {
                this.apply("CREATE INDEX IF NOT EXISTS prunable_message_recipient_idx ON prunable_message (recipient_id)");
            }
            case 121: {
                this.apply("CREATE INDEX IF NOT EXISTS prunable_message_block_timestamp_dbid_idx ON prunable_message (block_timestamp DESC, db_id DESC)");
            }
            case 122: {
                this.apply("CREATE TABLE IF NOT EXISTS account_control_phasing_sub_poll (db_id IDENTITY, account_id BIGINT NOT NULL, name VARCHAR, whitelist ARRAY, voting_model TINYINT NOT NULL, quorum BIGINT, min_balance BIGINT, sender_property_setter_id BIGINT, sender_property_name VARCHAR, sender_property_value VARCHAR, recipient_property_setter_id BIGINT, recipient_property_name VARCHAR, recipient_property_value VARCHAR, holding_id BIGINT, min_balance_model TINYINT, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 123: {
                this.apply("CREATE INDEX IF NOT EXISTS account_control_phasing_sub_poll_id_height_idx ON account_control_phasing_sub_poll (account_id, height DESC)");
            }
            case 124: {
                this.apply("CREATE INDEX IF NOT EXISTS account_control_phasing_sub_poll_height_id_idx ON account_control_phasing_sub_poll (height, account_id)");
            }
            case 125: {
                this.apply("CREATE TABLE IF NOT EXISTS asset_control_phasing (db_id IDENTITY, asset_id BIGINT NOT NULL, voting_model TINYINT NOT NULL, quorum BIGINT, min_balance BIGINT, holding_id BIGINT, min_balance_model TINYINT, whitelist ARRAY, expression VARCHAR, sender_property_setter_id BIGINT, sender_property_name VARCHAR, sender_property_value VARCHAR, recipient_property_setter_id BIGINT, recipient_property_name VARCHAR, recipient_property_value VARCHAR, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 126: {
                this.apply("CREATE TABLE IF NOT EXISTS asset_control_phasing_sub_poll (db_id IDENTITY, asset_id BIGINT NOT NULL, name VARCHAR, voting_model TINYINT NOT NULL, quorum BIGINT, min_balance BIGINT, holding_id BIGINT, min_balance_model TINYINT, whitelist ARRAY, sender_property_setter_id BIGINT, sender_property_name VARCHAR, sender_property_value VARCHAR, recipient_property_setter_id BIGINT, recipient_property_name VARCHAR, recipient_property_value VARCHAR, height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 127: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_control_phasing_id_height_idx ON asset_control_phasing (asset_id, height DESC)");
            }
            case 128: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_control_phasing_height_id_idx ON asset_control_phasing (height, asset_id)");
            }
            case 129: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_control_phasing_sub_poll_id_height_idx ON asset_control_phasing_sub_poll (asset_id, height DESC)");
            }
            case 130: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_control_phasing_sub_poll_height_id_idx ON asset_control_phasing_sub_poll (height, asset_id)");
            }
            case 131: {
                this.apply(null);
            }
            case 132: {
                FullTextTrigger.migrateToV7(this.db);
                this.apply(null);
            }
            case 133: {
                this.apply("TRUNCATE TABLE coin_trade_fxt");
            }
            case 134: {
                this.apply("ALTER TABLE coin_trade_fxt ALTER COLUMN exchange_price BIGINT NOT NULL");
            }
            case 135: {
                this.apply(null);
            }
            case 136: {
                int n2;
                ArrayList<String> arrayList;
                ArrayList<String> arrayList2;
                Throwable throwable;
                ResultSet resultSet;
                Throwable throwable2;
                Statement statement;
                Throwable throwable3;
                Connection connection;
                try {
                    connection = this.db.getConnection(this.schema);
                    throwable3 = null;
                    try {
                        statement = connection.createStatement();
                        throwable2 = null;
                        try {
                            resultSet = statement.executeQuery("SELECT CONSTRAINT_NAME, TABLE_NAME FROM INFORMATION_SCHEMA.CONSTRAINTS WHERE TABLE_SCHEMA='PUBLIC' AND TABLE_NAME IN ('PUBLIC_KEY', 'PRUNABLE_MESSAGE') AND COLUMN_LIST='HEIGHT'");
                            throwable = null;
                            try {
                                arrayList2 = new ArrayList<String>();
                                arrayList = new ArrayList<String>();
                                while (resultSet.next()) {
                                    arrayList2.add(resultSet.getString("TABLE_NAME"));
                                    arrayList.add(resultSet.getString("CONSTRAINT_NAME"));
                                }
                                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                                    statement.executeUpdate("ALTER TABLE " + (String)arrayList2.get(n2) + " DROP CONSTRAINT " + (String)arrayList.get(n2));
                                }
                                this.apply(null);
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (resultSet != null) {
                                    if (throwable != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        resultSet.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (statement != null) {
                                if (throwable2 != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                } else {
                                    statement.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable3 = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (connection != null) {
                            if (throwable3 != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable3.addSuppressed(throwable9);
                                }
                            } else {
                                connection.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
            }
            case 137: {
                this.apply("CREATE INDEX IF NOT EXISTS public_key_height_idx ON public_key (height)");
            }
            case 138: {
                this.apply("CREATE INDEX IF NOT EXISTS prunable_message_height_idx ON prunable_message (height)");
            }
            case 139: {
                if (BlockDb.getBlockCount() > 0) {
                    BlockchainProcessorImpl.getInstance().scheduleScan(Constants.CHECKSUM_BLOCK_1 - 1, true);
                }
                this.apply(null);
            }
            case 140: {
                this.apply("CREATE TABLE IF NOT EXISTS contract_reference (db_id IDENTITY, id BIGINT NOT NULL, account_id BIGINT NOT NULL, contract_name VARCHAR NOT NULL, contract_params VARCHAR, contract_transaction_chain_id INT NOT NULL, contract_transaction_full_hash BINARY(32), height INT NOT NULL, latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 141: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS contract_reference_id_height_idx ON contract_reference (id, height DESC)");
            }
            case 142: {
                this.apply("CREATE INDEX IF NOT EXISTS contract_reference_height_id_idx ON contract_reference (height, id)");
            }
            case 143: {
                this.apply("CREATE INDEX IF NOT EXISTS contract_reference_account_height_idx ON contract_reference (account_id, height DESC)");
            }
            case 144: {
                this.apply("DELETE FROM unconfirmed_transaction");
            }
            case 145: {
                if (Nxt.getBlockchain().getHeight() > 0) {
                    BlockchainProcessorImpl.getInstance().popOffTo(Nxt.getBlockchain().getHeight() - 1);
                }
                this.apply(null);
            }
            case 146: {
                this.apply("CREATE TABLE IF NOT EXISTS asset_property (   db_id IDENTITY,    id BIGINT NOT NULL,    asset_id BIGINT NOT NULL,    setter_id BIGINT NOT NULL,    property VARCHAR NOT NULL,    value VARCHAR,    height INT NOT NULL,    latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 147: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS asset_property_id_height_idx ON asset_property (id, height DESC)");
            }
            case 148: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_property_height_id_idx ON asset_property (height, id)");
            }
            case 149: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_property_asset_height_idx ON asset_property (asset_id, height DESC)");
            }
            case 150: {
                this.apply("CREATE INDEX IF NOT EXISTS asset_property_setter_property_idx ON asset_property (setter_id, property)");
            }
            case 151: {
                this.apply("CREATE TABLE IF NOT EXISTS holding_freeze (   db_id IDENTITY,    holding_id BIGINT NOT NULL,    holding_type VARCHAR NOT NULL CHECK (holding_type IN ('ASSET', 'CURRENCY')),    min_height INT NOT NULL,    actual_height INT NOT NULL,    height INT NOT NULL,    latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 152: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS holding_freeze_holding_id_holding_type_idx ON holding_freeze (holding_id, holding_type, height DESC)");
            }
            case 153: {
                this.apply("CREATE INDEX IF NOT EXISTS holding_freeze_actual_height_idx ON holding_freeze (actual_height)");
            }
            case 154: {
                this.apply("CREATE INDEX IF NOT EXISTS holding_freeze_height_idx ON holding_freeze (height)");
            }
            case 155: {
                this.apply("CREATE TABLE IF NOT EXISTS holding_migrate (   db_id IDENTITY,    holding_id BIGINT,    holding_type VARCHAR NOT NULL CHECK (holding_type IN ('ASSET', 'CURRENCY', 'COIN')),    child_chain_id INT NOT NULL,    min_height INT NOT NULL,    actual_height INT NOT NULL,    height INT NOT NULL,    latest BOOLEAN NOT NULL DEFAULT TRUE)");
            }
            case 156: {
                this.apply("CREATE UNIQUE INDEX IF NOT EXISTS holding_migrate_child_chain_id_idx ON holding_migrate (child_chain_id, height DESC)");
            }
            case 157: {
                this.apply("CREATE INDEX IF NOT EXISTS holding_migrate_holding_id_holding_type_idx ON holding_migrate (holding_id, holding_type)");
            }
            case 158: {
                this.apply("CREATE INDEX IF NOT EXISTS holding_migrate_actual_height_idx ON holding_migrate (actual_height)");
            }
            case 159: {
                this.apply("CREATE INDEX IF NOT EXISTS holding_migrate_height_idx ON holding_migrate (height)");
            }
            case 160: {
                TransactionalDb.runInDbTransaction(() -> {
                    if (Constants.isTestnet) {
                        ChildChainLoader.enableChildChainLoading(ChildChain.MPG, Constants.MPG_BLOCK, 0);
                    }
                    this.apply(null);
                });
            }
            case 161: {
                this.apply("CREATE TABLE IF NOT EXISTS phasing_poll_hashed_secret (db_id IDENTITY, hashed_secret VARBINARY NOT NULL,hashed_secret_id BIGINT NOT NULL, algorithm TINYINT NOT NULL, transaction_full_hash BINARY(32), transaction_id BIGINT NOT NULL, chain_id INT NOT NULL, finish_height INT NOT NULL, height INT NOT NULL)");
            }
            case 162: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_hashed_secret_id_ix ON phasing_poll_hashed_secret (hashed_secret_id)");
            }
            case 163: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_hashed_secret_transaction_id_idx ON phasing_poll_hashed_secret (transaction_id)");
            }
            case 164: {
                this.apply("CREATE INDEX IF NOT EXISTS phasing_poll_hashed_secret_height_idx ON phasing_poll_hashed_secret (height)");
            }
            case 165: {
                TransactionalDb.runInDbTransaction(() -> {
                    if (!Constants.isTestnet) {
                        ChildChainLoader.enableChildChainLoading(ChildChain.MPG, Constants.MPG_BLOCK, Constants.MPG_BLOCK);
                    }
                    this.apply(null);
                });
            }
            case 166: {
                TransactionalDb.runInDbTransaction(() -> {
                    if (!Constants.isTestnet) {
                        AssetFreezeMonitor.enableFreeze(Convert.parseUnsignedLong("6066975351926729052"), Constants.MPG_BLOCK, Constants.MPG_BLOCK);
                    }
                    this.apply(null);
                });
            }
            case 167: {
                int n2;
                ArrayList<String> arrayList;
                ArrayList<String> arrayList2;
                Throwable throwable;
                ResultSet resultSet;
                Throwable throwable2;
                Statement statement;
                Throwable throwable3;
                Connection connection;
                try {
                    connection = this.db.getConnection(this.schema);
                    throwable3 = null;
                    try {
                        statement = connection.createStatement();
                        throwable2 = null;
                        try {
                            resultSet = statement.executeQuery("SELECT CONSTRAINT_NAME, TABLE_NAME FROM INFORMATION_SCHEMA.CONSTRAINTS WHERE TABLE_SCHEMA='" + this.schema + "' AND TABLE_NAME IN ('TRANSACTION_FXT') AND COLUMN_LIST='BLOCK_ID'");
                            throwable = null;
                            try {
                                arrayList2 = new ArrayList();
                                arrayList = new ArrayList();
                                while (resultSet.next()) {
                                    arrayList2.add(resultSet.getString("TABLE_NAME"));
                                    arrayList.add(resultSet.getString("CONSTRAINT_NAME"));
                                }
                                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                                    statement.executeUpdate("ALTER TABLE " + (String)arrayList2.get(n2) + " DROP CONSTRAINT " + (String)arrayList.get(n2));
                                }
                                this.apply(null);
                            }
                            catch (Throwable throwable10) {
                                throwable = throwable10;
                                throw throwable10;
                            }
                            finally {
                                if (resultSet != null) {
                                    if (throwable != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable11) {
                                            throwable.addSuppressed(throwable11);
                                        }
                                    } else {
                                        resultSet.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable12) {
                            throwable2 = throwable12;
                            throw throwable12;
                        }
                        finally {
                            if (statement != null) {
                                if (throwable2 != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable throwable13) {
                                        throwable2.addSuppressed(throwable13);
                                    }
                                } else {
                                    statement.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable14) {
                        throwable3 = throwable14;
                        throw throwable14;
                    }
                    finally {
                        if (connection != null) {
                            if (throwable3 != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable15) {
                                    throwable3.addSuppressed(throwable15);
                                }
                            } else {
                                connection.close();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException.toString(), sQLException);
                }
            }
            case 168: {
                this.apply("CREATE INDEX IF NOT EXISTS transaction_fxt_block_id_idx ON transaction_fxt (block_id)");
            }
            case 169: {
                this.apply("UPDATE holding_freeze SET height = -1");
            }
            case 170: {
                this.apply("UPDATE holding_migrate SET height = -1");
            }
            case 171: {
                this.apply("UPDATE account_control_phasing SET max_fees=ARRAY[], max_fees_chains=ARRAY[] WHERE max_fees=ARRAY[0]");
            }
            case 172: {
                return;
            }
        }
        throw new RuntimeException("Forging chain database inconsistent with code, at update " + n + ", probably trying to run older code on newer database");
    }
}

